/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.devicepolicy;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.accounts.AccountManager;
import android.app.ActivityManagerNative;
import android.app.AlarmManager;
import android.app.AppGlobals;
import android.app.IActivityManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.admin.DeviceAdminInfo;
import android.app.admin.DevicePolicyManagerInternal;
import android.app.admin.IDevicePolicyManager;
import android.app.admin.SystemUpdatePolicy;
import android.app.backup.IBackupManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.pm.UserInfo;
import android.database.ContentObserver;
import android.graphics.Bitmap;
import android.media.AudioManager;
import android.media.IAudioService;
import android.net.ConnectivityManager;
import android.net.ProxyInfo;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Binder;
import android.os.Bundle;
import android.os.Environment;
import android.os.FileUtils;
import android.os.Handler;
import android.os.IBinder;
import android.os.PersistableBundle;
import android.os.PowerManager;
import android.os.PowerManagerInternal;
import android.os.Process;
import android.os.RecoverySystem;
import android.os.RemoteCallback;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.storage.StorageManager;
import android.provider.ContactsContract;
import android.provider.ContactsInternal;
import android.provider.Settings;
import android.security.Credentials;
import android.security.IKeyChainAliasCallback;
import android.security.IKeyChainService;
import android.security.KeyChain;
import android.service.persistentdata.PersistentDataBlockManager;
import android.text.TextUtils;
import android.util.Log;
import android.util.PrintWriterPrinter;
import android.util.Slog;
import android.util.SparseArray;
import android.util.Xml;
import android.view.IWindowManager;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.IAccessibilityManager;
import android.view.inputmethod.InputMethodInfo;
import android.view.inputmethod.InputMethodManager;
import com.android.internal.statusbar.IStatusBarService;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.JournaledFile;
import com.android.internal.util.Preconditions;
import com.android.internal.util.XmlUtils;
import com.android.internal.widget.LockPatternUtils;
import com.android.server.LocalServices;
import com.android.server.SystemService;
import com.android.server.devicepolicy.DeviceOwner;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class DevicePolicyManagerService
extends IDevicePolicyManager.Stub {
    private static final String LOG_TAG = "DevicePolicyManagerService";
    private static final boolean VERBOSE_LOG = false;
    private static final String DEVICE_POLICIES_XML = "device_policies.xml";
    private static final String TAG_LOCK_TASK_COMPONENTS = "lock-task-component";
    private static final String TAG_STATUS_BAR = "statusbar";
    private static final String ATTR_DISABLED = "disabled";
    private static final String DO_NOT_ASK_CREDENTIALS_ON_BOOT_XML = "do-not-ask-credentials-on-boot";
    private static final int REQUEST_EXPIRE_PASSWORD = 5571;
    private static final long MS_PER_DAY = 86400000L;
    private static final long EXPIRATION_GRACE_PERIOD_MS = 432000000L;
    protected static final String ACTION_EXPIRED_PASSWORD_NOTIFICATION = "com.android.server.ACTION_EXPIRED_PASSWORD_NOTIFICATION";
    private static final int MONITORING_CERT_NOTIFICATION_ID = 17039590;
    private static final int PROFILE_WIPED_NOTIFICATION_ID = 1001;
    private static final boolean DBG = false;
    private static final String ATTR_PERMISSION_PROVIDER = "permission-provider";
    private static final String ATTR_SETUP_COMPLETE = "setup-complete";
    private static final String ATTR_PERMISSION_POLICY = "permission-policy";
    private static final String ATTR_DELEGATED_CERT_INSTALLER = "delegated-cert-installer";
    private static final int STATUS_BAR_DISABLE_MASK = 0x2070000;
    private static final int STATUS_BAR_DISABLE2_MASK = 1;
    private static final Set<String> DEVICE_OWNER_USER_RESTRICTIONS = new HashSet<String>();
    private static final Set<String> IMMUTABLE_USER_RESTRICTIONS;
    private static final Set<String> SECURE_SETTINGS_WHITELIST;
    private static final Set<String> SECURE_SETTINGS_DEVICEOWNER_WHITELIST;
    private static final Set<String> GLOBAL_SETTINGS_WHITELIST;
    private static final Set<String> GLOBAL_SETTINGS_DEPRECATED;
    private static final int PROFILE_KEYGUARD_FEATURES_AFFECT_OWNER = 48;
    private static final int PROFILE_KEYGUARD_FEATURES = 56;
    final Context mContext;
    final UserManager mUserManager;
    final PowerManager.WakeLock mWakeLock;
    final LocalService mLocalService;
    final PowerManager mPowerManager;
    final PowerManagerInternal mPowerManagerInternal;
    IWindowManager mIWindowManager;
    NotificationManager mNotificationManager;
    private DeviceOwner mDeviceOwner;
    private final Binder mToken = new Binder();
    private boolean mHasFeature;
    final SparseArray<DevicePolicyData> mUserData = new SparseArray();
    Handler mHandler = new Handler();
    BroadcastReceiver mReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            final int userHandle = intent.getIntExtra("android.intent.extra.user_handle", this.getSendingUserId());
            if ("android.intent.action.BOOT_COMPLETED".equals(action) || DevicePolicyManagerService.ACTION_EXPIRED_PASSWORD_NOTIFICATION.equals(action)) {
                DevicePolicyManagerService.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        DevicePolicyManagerService.this.handlePasswordExpirationNotification(userHandle);
                    }
                });
            }
            if ("android.intent.action.BOOT_COMPLETED".equals(action) || "android.security.STORAGE_CHANGED".equals(action)) {
                new MonitoringCertNotificationTask().execute(intent);
            }
            if ("android.intent.action.USER_REMOVED".equals(action)) {
                DevicePolicyManagerService.this.removeUserData(userHandle);
            } else if ("android.intent.action.USER_STARTED".equals(action) || "android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE".equals(action)) {
                if ("android.intent.action.USER_STARTED".equals(action)) {
                    DevicePolicyManagerService devicePolicyManagerService = DevicePolicyManagerService.this;
                    synchronized (devicePolicyManagerService) {
                        DevicePolicyManagerService.this.mUserData.remove(userHandle);
                    }
                }
                DevicePolicyManagerService.this.handlePackagesChanged(null, userHandle);
            } else if ("android.intent.action.PACKAGE_CHANGED".equals(action) || "android.intent.action.PACKAGE_ADDED".equals(action) && intent.getBooleanExtra("android.intent.extra.REPLACING", false)) {
                DevicePolicyManagerService.this.handlePackagesChanged(intent.getData().getSchemeSpecificPart(), userHandle);
            } else if ("android.intent.action.PACKAGE_REMOVED".equals(action) && !intent.getBooleanExtra("android.intent.extra.REPLACING", false)) {
                DevicePolicyManagerService.this.handlePackagesChanged(intent.getData().getSchemeSpecificPart(), userHandle);
            } else if ("android.intent.action.MANAGED_PROFILE_ADDED".equals(action)) {
                DevicePolicyManagerService.this.clearWipeProfileNotification();
            }
        }
    };
    public static final String SYSTEM_PROP_DISABLE_CAMERA_PREFIX = "sys.secpolicy.camera.off_";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePackagesChanged(String packageName, int userHandle) {
        boolean removed = false;
        DevicePolicyData policy = this.getUserData(userHandle);
        IPackageManager pm = AppGlobals.getPackageManager();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            for (int i = policy.mAdminList.size() - 1; i >= 0; --i) {
                ActiveAdmin aa = policy.mAdminList.get(i);
                try {
                    String adminPackage = aa.info.getPackageName();
                    if (packageName != null && !packageName.equals(adminPackage) || pm.getPackageInfo(adminPackage, 0, userHandle) != null && pm.getReceiverInfo(aa.info.getComponent(), 0, userHandle) != null) continue;
                    removed = true;
                    policy.mAdminList.remove(i);
                    policy.mAdminMap.remove(aa.info.getComponent());
                    continue;
                }
                catch (RemoteException re) {
                    // empty catch block
                }
            }
            if (removed) {
                this.validatePasswordOwnerLocked(policy);
                this.syncDeviceCapabilitiesLocked(policy);
                this.saveSettingsLocked(policy.mUserHandle);
            }
            if (policy.mDelegatedCertInstallerPackage != null && (packageName == null || packageName.equals(policy.mDelegatedCertInstallerPackage))) {
                try {
                    if (pm.getPackageInfo(policy.mDelegatedCertInstallerPackage, 0, userHandle) == null) {
                        policy.mDelegatedCertInstallerPackage = null;
                        this.saveSettingsLocked(policy.mUserHandle);
                    }
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
        }
    }

    public DevicePolicyManagerService(Context context) {
        this.mContext = context;
        this.mUserManager = UserManager.get(this.mContext);
        this.mHasFeature = context.getPackageManager().hasSystemFeature("android.software.device_admin");
        this.mPowerManager = (PowerManager)context.getSystemService("power");
        this.mPowerManagerInternal = LocalServices.getService(PowerManagerInternal.class);
        this.mWakeLock = this.mPowerManager.newWakeLock(1, "DPM");
        this.mLocalService = new LocalService();
        if (!this.mHasFeature) {
            return;
        }
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.BOOT_COMPLETED");
        filter.addAction(ACTION_EXPIRED_PASSWORD_NOTIFICATION);
        filter.addAction("android.intent.action.USER_REMOVED");
        filter.addAction("android.intent.action.USER_STARTED");
        filter.addAction("android.security.STORAGE_CHANGED");
        filter.setPriority(1000);
        context.registerReceiverAsUser(this.mReceiver, UserHandle.ALL, filter, null, this.mHandler);
        filter = new IntentFilter();
        filter.addAction("android.intent.action.PACKAGE_CHANGED");
        filter.addAction("android.intent.action.PACKAGE_REMOVED");
        filter.addAction("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE");
        filter.addAction("android.intent.action.PACKAGE_ADDED");
        filter.addDataScheme("package");
        context.registerReceiverAsUser(this.mReceiver, UserHandle.ALL, filter, null, this.mHandler);
        filter = new IntentFilter();
        filter.addAction("android.intent.action.MANAGED_PROFILE_ADDED");
        context.registerReceiverAsUser(this.mReceiver, UserHandle.ALL, filter, null, this.mHandler);
        LocalServices.addService(DevicePolicyManagerInternal.class, this.mLocalService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DevicePolicyData getUserData(int userHandle) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            DevicePolicyData policy = this.mUserData.get(userHandle);
            if (policy == null) {
                policy = new DevicePolicyData(userHandle);
                this.mUserData.append(userHandle, policy);
                this.loadSettingsLocked(policy, userHandle);
            }
            return policy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DevicePolicyData getUserDataUnchecked(int userHandle) {
        long ident = Binder.clearCallingIdentity();
        try {
            DevicePolicyData devicePolicyData = this.getUserData(userHandle);
            return devicePolicyData;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeUserData(int userHandle) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            DevicePolicyData policy;
            if (userHandle == 0) {
                Slog.w(LOG_TAG, "Tried to remove device policy file for user 0! Ignoring.");
                return;
            }
            if (this.mDeviceOwner != null) {
                this.mDeviceOwner.removeProfileOwner(userHandle);
                this.mDeviceOwner.writeOwnerFile();
            }
            if ((policy = this.mUserData.get(userHandle)) != null) {
                this.mUserData.remove(userHandle);
            }
            File policyFile = new File(Environment.getUserSystemDirectory(userHandle), DEVICE_POLICIES_XML);
            policyFile.delete();
            Slog.i(LOG_TAG, "Removed device policy file " + policyFile.getAbsolutePath());
        }
        this.updateScreenCaptureDisabledInWindowManager(userHandle, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadDeviceOwner() {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.mDeviceOwner = DeviceOwner.load();
            this.updateDeviceOwnerLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setExpirationAlarmCheckLocked(Context context, DevicePolicyData policy) {
        long alarmTime;
        long expiration = this.getPasswordExpirationLocked(null, policy.mUserHandle);
        long now = System.currentTimeMillis();
        long timeToExpire = expiration - now;
        if (expiration == 0L) {
            alarmTime = 0L;
        } else if (timeToExpire <= 0L) {
            alarmTime = now + 86400000L;
        } else {
            long alarmInterval = timeToExpire % 86400000L;
            if (alarmInterval == 0L) {
                alarmInterval = 86400000L;
            }
            alarmTime = now + alarmInterval;
        }
        long token = Binder.clearCallingIdentity();
        try {
            AlarmManager am = (AlarmManager)context.getSystemService("alarm");
            PendingIntent pi = PendingIntent.getBroadcastAsUser(context, 5571, new Intent(ACTION_EXPIRED_PASSWORD_NOTIFICATION), 0x48000000, new UserHandle(policy.mUserHandle));
            am.cancel(pi);
            if (alarmTime != 0L) {
                am.set(1, alarmTime, pi);
            }
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private IWindowManager getWindowManager() {
        if (this.mIWindowManager == null) {
            IBinder b = ServiceManager.getService("window");
            this.mIWindowManager = IWindowManager.Stub.asInterface(b);
        }
        return this.mIWindowManager;
    }

    private NotificationManager getNotificationManager() {
        if (this.mNotificationManager == null) {
            this.mNotificationManager = (NotificationManager)this.mContext.getSystemService("notification");
        }
        return this.mNotificationManager;
    }

    ActiveAdmin getActiveAdminUncheckedLocked(ComponentName who, int userHandle) {
        ActiveAdmin admin = this.getUserData((int)userHandle).mAdminMap.get(who);
        if (admin != null && who.getPackageName().equals(admin.info.getActivityInfo().packageName) && who.getClassName().equals(admin.info.getActivityInfo().name)) {
            return admin;
        }
        return null;
    }

    ActiveAdmin getActiveAdminForCallerLocked(ComponentName who, int reqPolicy) throws SecurityException {
        int callingUid = Binder.getCallingUid();
        ActiveAdmin result = this.getActiveAdminWithPolicyForUidLocked(who, reqPolicy, callingUid);
        if (result != null) {
            return result;
        }
        if (who != null) {
            int userId = UserHandle.getUserId(callingUid);
            DevicePolicyData policy = this.getUserData(userId);
            ActiveAdmin admin = policy.mAdminMap.get(who);
            if (reqPolicy == -2) {
                throw new SecurityException("Admin " + admin.info.getComponent() + " does not own the device");
            }
            if (reqPolicy == -1) {
                throw new SecurityException("Admin " + admin.info.getComponent() + " does not own the profile");
            }
            throw new SecurityException("Admin " + admin.info.getComponent() + " did not specify uses-policy for: " + admin.info.getTagForPolicy(reqPolicy));
        }
        throw new SecurityException("No active admin owned by uid " + Binder.getCallingUid() + " for policy #" + reqPolicy);
    }

    private ActiveAdmin getActiveAdminWithPolicyForUidLocked(ComponentName who, int reqPolicy, int uid) {
        int userId = UserHandle.getUserId(uid);
        DevicePolicyData policy = this.getUserData(userId);
        if (who != null) {
            ActiveAdmin admin = policy.mAdminMap.get(who);
            if (admin == null) {
                throw new SecurityException("No active admin " + who);
            }
            if (admin.getUid() != uid) {
                throw new SecurityException("Admin " + who + " is not owned by uid " + Binder.getCallingUid());
            }
            if (this.isActiveAdminWithPolicyForUserLocked(admin, reqPolicy, userId)) {
                return admin;
            }
        } else {
            for (ActiveAdmin admin : policy.mAdminList) {
                if (admin.getUid() != uid || !this.isActiveAdminWithPolicyForUserLocked(admin, reqPolicy, userId)) continue;
                return admin;
            }
        }
        return null;
    }

    private boolean isActiveAdminWithPolicyForUserLocked(ActiveAdmin admin, int reqPolicy, int userId) {
        boolean ownsInitialization;
        boolean ownsDevice = this.isDeviceOwner(admin.info.getPackageName());
        boolean ownsProfile = this.getProfileOwner(userId) != null && this.getProfileOwner(userId).getPackageName().equals(admin.info.getPackageName());
        boolean bl = ownsInitialization = this.isDeviceInitializer(admin.info.getPackageName()) && !this.hasUserSetupCompleted(userId);
        return reqPolicy == -2 ? userId == 0 && (ownsDevice || ownsInitialization) || ownsDevice && ownsProfile : (reqPolicy == -1 ? userId == 0 && ownsDevice || ownsProfile || ownsInitialization : admin.info.usesPolicy(reqPolicy));
    }

    void sendAdminCommandLocked(ActiveAdmin admin, String action) {
        this.sendAdminCommandLocked(admin, action, null);
    }

    void sendAdminCommandLocked(ActiveAdmin admin, String action, BroadcastReceiver result) {
        this.sendAdminCommandLocked(admin, action, null, result);
    }

    void sendAdminCommandLocked(ActiveAdmin admin, String action, Bundle adminExtras, BroadcastReceiver result) {
        Intent intent = new Intent(action);
        intent.setComponent(admin.info.getComponent());
        if (action.equals("android.app.action.ACTION_PASSWORD_EXPIRING")) {
            intent.putExtra("expiration", admin.passwordExpirationDate);
        }
        if (adminExtras != null) {
            intent.putExtras(adminExtras);
        }
        if (result != null) {
            this.mContext.sendOrderedBroadcastAsUser(intent, admin.getUserHandle(), null, result, this.mHandler, -1, null, null);
        } else {
            this.mContext.sendBroadcastAsUser(intent, admin.getUserHandle());
        }
    }

    void sendAdminCommandLocked(String action, int reqPolicy, int userHandle) {
        DevicePolicyData policy = this.getUserData(userHandle);
        int count = policy.mAdminList.size();
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                ActiveAdmin admin = policy.mAdminList.get(i);
                if (!admin.info.usesPolicy(reqPolicy)) continue;
                this.sendAdminCommandLocked(admin, action);
            }
        }
    }

    private void sendAdminCommandToSelfAndProfilesLocked(String action, int reqPolicy, int userHandle) {
        List<UserInfo> profiles = this.mUserManager.getProfiles(userHandle);
        for (UserInfo ui : profiles) {
            int id2 = ui.id;
            this.sendAdminCommandLocked(action, reqPolicy, id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeActiveAdminLocked(final ComponentName adminReceiver, int userHandle) {
        final ActiveAdmin admin = this.getActiveAdminUncheckedLocked(adminReceiver, userHandle);
        if (admin != null) {
            DevicePolicyManagerService devicePolicyManagerService = this;
            synchronized (devicePolicyManagerService) {
                this.getUserData((int)userHandle).mRemovingAdmins.add(adminReceiver);
            }
            this.sendAdminCommandLocked(admin, "android.app.action.DEVICE_ADMIN_DISABLED", new BroadcastReceiver(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onReceive(Context context, Intent intent) {
                    DevicePolicyManagerService devicePolicyManagerService = DevicePolicyManagerService.this;
                    synchronized (devicePolicyManagerService) {
                        int userHandle = admin.getUserHandle().getIdentifier();
                        DevicePolicyData policy = DevicePolicyManagerService.this.getUserData(userHandle);
                        boolean doProxyCleanup = admin.info.usesPolicy(5);
                        policy.mAdminList.remove(admin);
                        policy.mAdminMap.remove(adminReceiver);
                        DevicePolicyManagerService.this.validatePasswordOwnerLocked(policy);
                        DevicePolicyManagerService.this.syncDeviceCapabilitiesLocked(policy);
                        if (doProxyCleanup) {
                            DevicePolicyManagerService.this.resetGlobalProxyLocked(DevicePolicyManagerService.this.getUserData(userHandle));
                        }
                        DevicePolicyManagerService.this.saveSettingsLocked(userHandle);
                        DevicePolicyManagerService.this.updateMaximumTimeToLockLocked(policy);
                        policy.mRemovingAdmins.remove(adminReceiver);
                    }
                }
            });
        }
    }

    public DeviceAdminInfo findAdmin(ComponentName adminName, int userHandle) {
        if (!this.mHasFeature) {
            return null;
        }
        this.enforceCrossUserPermission(userHandle);
        Intent resolveIntent = new Intent();
        resolveIntent.setComponent(adminName);
        List<ResolveInfo> infos = this.mContext.getPackageManager().queryBroadcastReceivers(resolveIntent, 32896, userHandle);
        if (infos == null || infos.size() <= 0) {
            throw new IllegalArgumentException("Unknown admin: " + adminName);
        }
        try {
            return new DeviceAdminInfo(this.mContext, infos.get(0));
        }
        catch (XmlPullParserException e) {
            Slog.w(LOG_TAG, "Bad device admin requested for user=" + userHandle + ": " + adminName, e);
            return null;
        }
        catch (IOException e) {
            Slog.w(LOG_TAG, "Bad device admin requested for user=" + userHandle + ": " + adminName, e);
            return null;
        }
    }

    private static JournaledFile makeJournaledFile(int userHandle) {
        String base = userHandle == 0 ? "/data/system/device_policies.xml" : new File(Environment.getUserSystemDirectory(userHandle), DEVICE_POLICIES_XML).getAbsolutePath();
        return new JournaledFile(new File(base), new File(base + ".tmp"));
    }

    private void saveSettingsLocked(int userHandle) {
        DevicePolicyData policy = this.getUserData(userHandle);
        JournaledFile journal = DevicePolicyManagerService.makeJournaledFile(userHandle);
        FileOutputStream stream = null;
        try {
            int i;
            stream = new FileOutputStream(journal.chooseForWrite(), false);
            FastXmlSerializer out = new FastXmlSerializer();
            out.setOutput(stream, StandardCharsets.UTF_8.name());
            out.startDocument(null, true);
            out.startTag(null, "policies");
            if (policy.mRestrictionsProvider != null) {
                out.attribute(null, ATTR_PERMISSION_PROVIDER, policy.mRestrictionsProvider.flattenToString());
            }
            if (policy.mUserSetupComplete) {
                out.attribute(null, ATTR_SETUP_COMPLETE, Boolean.toString(true));
            }
            if (policy.mPermissionPolicy != 0) {
                out.attribute(null, ATTR_PERMISSION_POLICY, Integer.toString(policy.mPermissionPolicy));
            }
            if (policy.mDelegatedCertInstallerPackage != null) {
                out.attribute(null, ATTR_DELEGATED_CERT_INSTALLER, policy.mDelegatedCertInstallerPackage);
            }
            int N = policy.mAdminList.size();
            for (i = 0; i < N; ++i) {
                ActiveAdmin ap = policy.mAdminList.get(i);
                if (ap == null) continue;
                out.startTag(null, "admin");
                out.attribute(null, "name", ap.info.getComponent().flattenToString());
                ap.writeToXml(out);
                out.endTag(null, "admin");
            }
            if (policy.mPasswordOwner >= 0) {
                out.startTag(null, "password-owner");
                out.attribute(null, "value", Integer.toString(policy.mPasswordOwner));
                out.endTag(null, "password-owner");
            }
            if (policy.mFailedPasswordAttempts != 0) {
                out.startTag(null, "failed-password-attempts");
                out.attribute(null, "value", Integer.toString(policy.mFailedPasswordAttempts));
                out.endTag(null, "failed-password-attempts");
            }
            if (policy.mActivePasswordQuality != 0 || policy.mActivePasswordLength != 0 || policy.mActivePasswordUpperCase != 0 || policy.mActivePasswordLowerCase != 0 || policy.mActivePasswordLetters != 0 || policy.mActivePasswordNumeric != 0 || policy.mActivePasswordSymbols != 0 || policy.mActivePasswordNonLetter != 0) {
                out.startTag(null, "active-password");
                out.attribute(null, "quality", Integer.toString(policy.mActivePasswordQuality));
                out.attribute(null, "length", Integer.toString(policy.mActivePasswordLength));
                out.attribute(null, "uppercase", Integer.toString(policy.mActivePasswordUpperCase));
                out.attribute(null, "lowercase", Integer.toString(policy.mActivePasswordLowerCase));
                out.attribute(null, "letters", Integer.toString(policy.mActivePasswordLetters));
                out.attribute(null, "numeric", Integer.toString(policy.mActivePasswordNumeric));
                out.attribute(null, "symbols", Integer.toString(policy.mActivePasswordSymbols));
                out.attribute(null, "nonletter", Integer.toString(policy.mActivePasswordNonLetter));
                out.endTag(null, "active-password");
            }
            for (i = 0; i < policy.mLockTaskPackages.size(); ++i) {
                String component = policy.mLockTaskPackages.get(i);
                out.startTag(null, TAG_LOCK_TASK_COMPONENTS);
                out.attribute(null, "name", component);
                out.endTag(null, TAG_LOCK_TASK_COMPONENTS);
            }
            if (policy.mStatusBarDisabled) {
                out.startTag(null, TAG_STATUS_BAR);
                out.attribute(null, ATTR_DISABLED, Boolean.toString(policy.mStatusBarDisabled));
                out.endTag(null, TAG_STATUS_BAR);
            }
            if (policy.doNotAskCredentialsOnBoot) {
                out.startTag(null, DO_NOT_ASK_CREDENTIALS_ON_BOOT_XML);
                out.endTag(null, DO_NOT_ASK_CREDENTIALS_ON_BOOT_XML);
            }
            out.endTag(null, "policies");
            out.endDocument();
            stream.flush();
            FileUtils.sync(stream);
            stream.close();
            journal.commit();
            this.sendChangedNotification(userHandle);
        }
        catch (IOException e) {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            journal.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendChangedNotification(int userHandle) {
        Intent intent = new Intent("android.app.action.DEVICE_POLICY_MANAGER_STATE_CHANGED");
        intent.setFlags(0x40000000);
        long ident = Binder.clearCallingIdentity();
        try {
            this.mContext.sendBroadcastAsUser(intent, new UserHandle(userHandle));
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSettingsLocked(DevicePolicyData policy, int userHandle) {
        JournaledFile journal = DevicePolicyManagerService.makeJournaledFile(userHandle);
        FileInputStream stream = null;
        File file = journal.chooseForRead();
        try {
            String permissionPolicy;
            String userSetupComplete;
            int type;
            stream = new FileInputStream(file);
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(stream, StandardCharsets.UTF_8.name());
            while ((type = parser.next()) != 1 && type != 2) {
            }
            String tag = parser.getName();
            if (!"policies".equals(tag)) {
                throw new XmlPullParserException("Settings do not start with policies tag: found " + tag);
            }
            String permissionProvider = parser.getAttributeValue(null, ATTR_PERMISSION_PROVIDER);
            if (permissionProvider != null) {
                policy.mRestrictionsProvider = ComponentName.unflattenFromString(permissionProvider);
            }
            if ((userSetupComplete = parser.getAttributeValue(null, ATTR_SETUP_COMPLETE)) != null && Boolean.toString(true).equals(userSetupComplete)) {
                policy.mUserSetupComplete = true;
            }
            if (!TextUtils.isEmpty(permissionPolicy = parser.getAttributeValue(null, ATTR_PERMISSION_POLICY))) {
                policy.mPermissionPolicy = Integer.parseInt(permissionPolicy);
            }
            policy.mDelegatedCertInstallerPackage = parser.getAttributeValue(null, ATTR_DELEGATED_CERT_INSTALLER);
            type = parser.next();
            int outerDepth = parser.getDepth();
            policy.mLockTaskPackages.clear();
            policy.mAdminList.clear();
            policy.mAdminMap.clear();
            while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                if (type == 3 || type == 4) continue;
                tag = parser.getName();
                if ("admin".equals(tag)) {
                    String name = parser.getAttributeValue(null, "name");
                    try {
                        DeviceAdminInfo dai = this.findAdmin(ComponentName.unflattenFromString(name), userHandle);
                        if (dai == null) continue;
                        ActiveAdmin ap = new ActiveAdmin(dai);
                        ap.readFromXml(parser);
                        policy.mAdminMap.put(ap.info.getComponent(), ap);
                    }
                    catch (RuntimeException e) {
                        Slog.w(LOG_TAG, "Failed loading admin " + name, e);
                    }
                    continue;
                }
                if ("failed-password-attempts".equals(tag)) {
                    policy.mFailedPasswordAttempts = Integer.parseInt(parser.getAttributeValue(null, "value"));
                    continue;
                }
                if ("password-owner".equals(tag)) {
                    policy.mPasswordOwner = Integer.parseInt(parser.getAttributeValue(null, "value"));
                    continue;
                }
                if ("active-password".equals(tag)) {
                    policy.mActivePasswordQuality = Integer.parseInt(parser.getAttributeValue(null, "quality"));
                    policy.mActivePasswordLength = Integer.parseInt(parser.getAttributeValue(null, "length"));
                    policy.mActivePasswordUpperCase = Integer.parseInt(parser.getAttributeValue(null, "uppercase"));
                    policy.mActivePasswordLowerCase = Integer.parseInt(parser.getAttributeValue(null, "lowercase"));
                    policy.mActivePasswordLetters = Integer.parseInt(parser.getAttributeValue(null, "letters"));
                    policy.mActivePasswordNumeric = Integer.parseInt(parser.getAttributeValue(null, "numeric"));
                    policy.mActivePasswordSymbols = Integer.parseInt(parser.getAttributeValue(null, "symbols"));
                    policy.mActivePasswordNonLetter = Integer.parseInt(parser.getAttributeValue(null, "nonletter"));
                    continue;
                }
                if (TAG_LOCK_TASK_COMPONENTS.equals(tag)) {
                    policy.mLockTaskPackages.add(parser.getAttributeValue(null, "name"));
                    continue;
                }
                if (TAG_STATUS_BAR.equals(tag)) {
                    policy.mStatusBarDisabled = Boolean.parseBoolean(parser.getAttributeValue(null, ATTR_DISABLED));
                    continue;
                }
                if (DO_NOT_ASK_CREDENTIALS_ON_BOOT_XML.equals(tag)) {
                    policy.doNotAskCredentialsOnBoot = true;
                    continue;
                }
                Slog.w(LOG_TAG, "Unknown tag: " + tag);
                XmlUtils.skipCurrentTag(parser);
            }
        }
        catch (NullPointerException e) {
            Slog.w(LOG_TAG, "failed parsing " + file + " " + e);
        }
        catch (NumberFormatException e) {
            Slog.w(LOG_TAG, "failed parsing " + file + " " + e);
        }
        catch (XmlPullParserException e) {
            Slog.w(LOG_TAG, "failed parsing " + file + " " + e);
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            Slog.w(LOG_TAG, "failed parsing " + file + " " + e);
        }
        catch (IndexOutOfBoundsException e) {
            Slog.w(LOG_TAG, "failed parsing " + file + " " + e);
        }
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        policy.mAdminList.addAll(policy.mAdminMap.values());
        long identity = Binder.clearCallingIdentity();
        try {
            LockPatternUtils utils = new LockPatternUtils(this.mContext);
            if (utils.getActivePasswordQuality(userHandle) < policy.mActivePasswordQuality) {
                Slog.w(LOG_TAG, "Active password quality 0x" + Integer.toHexString(policy.mActivePasswordQuality) + " does not match actual quality 0x" + Integer.toHexString(utils.getActivePasswordQuality(userHandle)));
                policy.mActivePasswordQuality = 0;
                policy.mActivePasswordLength = 0;
                policy.mActivePasswordUpperCase = 0;
                policy.mActivePasswordLowerCase = 0;
                policy.mActivePasswordLetters = 0;
                policy.mActivePasswordNumeric = 0;
                policy.mActivePasswordSymbols = 0;
                policy.mActivePasswordNonLetter = 0;
            }
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
        this.validatePasswordOwnerLocked(policy);
        this.syncDeviceCapabilitiesLocked(policy);
        this.updateMaximumTimeToLockLocked(policy);
        this.addDeviceInitializerToLockTaskPackagesLocked(userHandle);
        this.updateLockTaskPackagesLocked(policy.mLockTaskPackages, userHandle);
        if (policy.mStatusBarDisabled) {
            this.setStatusBarDisabledInternal(policy.mStatusBarDisabled, userHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLockTaskPackagesLocked(List<String> packages, int userId) {
        IActivityManager am = ActivityManagerNative.getDefault();
        long ident = Binder.clearCallingIdentity();
        try {
            am.updateLockTaskPackages(userId, packages.toArray(new String[packages.size()]));
        }
        catch (RemoteException e) {
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDeviceOwnerLocked() {
        IActivityManager am = ActivityManagerNative.getDefault();
        long ident = Binder.clearCallingIdentity();
        try {
            am.updateDeviceOwner(this.getDeviceOwner());
        }
        catch (RemoteException e) {
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    static void validateQualityConstant(int quality) {
        switch (quality) {
            case 0: 
            case 32768: 
            case 65536: 
            case 131072: 
            case 196608: 
            case 262144: 
            case 327680: 
            case 393216: {
                return;
            }
        }
        throw new IllegalArgumentException("Invalid quality constant: 0x" + Integer.toHexString(quality));
    }

    void validatePasswordOwnerLocked(DevicePolicyData policy) {
        if (policy.mPasswordOwner >= 0) {
            boolean haveOwner = false;
            for (int i = policy.mAdminList.size() - 1; i >= 0; --i) {
                if (policy.mAdminList.get(i).getUid() != policy.mPasswordOwner) continue;
                haveOwner = true;
                break;
            }
            if (!haveOwner) {
                Slog.w(LOG_TAG, "Previous password owner " + policy.mPasswordOwner + " no longer active; disabling");
                policy.mPasswordOwner = -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void syncDeviceCapabilitiesLocked(DevicePolicyData policy) {
        String cameraPropertyForUser = SYSTEM_PROP_DISABLE_CAMERA_PREFIX + policy.mUserHandle;
        boolean systemState = SystemProperties.getBoolean(cameraPropertyForUser, false);
        boolean cameraDisabled = this.getCameraDisabled(null, policy.mUserHandle);
        if (cameraDisabled != systemState) {
            long token = Binder.clearCallingIdentity();
            try {
                String value = cameraDisabled ? "1" : "0";
                SystemProperties.set(cameraPropertyForUser, value);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
    }

    public void systemReady() {
        if (!this.mHasFeature) {
            return;
        }
        this.getUserData(0);
        this.loadDeviceOwner();
        this.cleanUpOldUsers();
        new SetupContentObserver(this.mHandler).register(this.mContext.getContentResolver());
        this.updateUserSetupComplete();
        List<UserInfo> users = this.mUserManager.getUsers(true);
        int N = users.size();
        for (int i = 0; i < N; ++i) {
            int userHandle = users.get((int)i).id;
            this.updateScreenCaptureDisabledInWindowManager(userHandle, this.getScreenCaptureDisabled(null, userHandle));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpOldUsers() {
        HashSet<Integer> usersWithData;
        Set<Object> usersWithProfileOwners;
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            usersWithProfileOwners = this.mDeviceOwner != null ? this.mDeviceOwner.getProfileOwnerKeys() : new HashSet();
            usersWithData = new HashSet<Integer>();
            for (int i = 0; i < this.mUserData.size(); ++i) {
                usersWithData.add(this.mUserData.keyAt(i));
            }
        }
        List<UserInfo> allUsers = this.mUserManager.getUsers();
        HashSet deletedUsers = new HashSet();
        deletedUsers.addAll(usersWithProfileOwners);
        deletedUsers.addAll(usersWithData);
        for (UserInfo userInfo : allUsers) {
            deletedUsers.remove(userInfo.id);
        }
        for (Integer userId : deletedUsers) {
            this.removeUserData(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePasswordExpirationNotification(int userHandle) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            long now = System.currentTimeMillis();
            List<UserInfo> profiles = this.mUserManager.getProfiles(userHandle);
            for (UserInfo ui : profiles) {
                int profileUserHandle = ui.id;
                DevicePolicyData policy = this.getUserData(profileUserHandle);
                int count = policy.mAdminList.size();
                if (count <= 0) continue;
                for (int i = 0; i < count; ++i) {
                    ActiveAdmin admin = policy.mAdminList.get(i);
                    if (!admin.info.usesPolicy(6) || admin.passwordExpirationTimeout <= 0L || now < admin.passwordExpirationDate - 432000000L || admin.passwordExpirationDate <= 0L) continue;
                    this.sendAdminCommandLocked(admin, "android.app.action.ACTION_PASSWORD_EXPIRING");
                }
            }
            this.setExpirationAlarmCheckLocked(this.mContext, this.getUserData(userHandle));
        }
    }

    @Override
    public void setActiveAdmin(ComponentName adminReceiver, boolean refreshing, int userHandle) {
        if (!this.mHasFeature) {
            return;
        }
        this.setActiveAdmin(adminReceiver, refreshing, userHandle, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setActiveAdmin(ComponentName adminReceiver, boolean refreshing, int userHandle, Bundle onEnableData) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_DEVICE_ADMINS", null);
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyData policy = this.getUserData(userHandle);
        DeviceAdminInfo info = this.findAdmin(adminReceiver, userHandle);
        if (info == null) {
            throw new IllegalArgumentException("Bad admin: " + adminReceiver);
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            long ident = Binder.clearCallingIdentity();
            try {
                if (!refreshing && this.getActiveAdminUncheckedLocked(adminReceiver, userHandle) != null) {
                    throw new IllegalArgumentException("Admin is already added");
                }
                ActiveAdmin newAdmin = new ActiveAdmin(info);
                policy.mAdminMap.put(adminReceiver, newAdmin);
                int replaceIndex = -1;
                int N = policy.mAdminList.size();
                for (int i = 0; i < N; ++i) {
                    ActiveAdmin oldAdmin = policy.mAdminList.get(i);
                    if (!oldAdmin.info.getComponent().equals(adminReceiver)) continue;
                    replaceIndex = i;
                    break;
                }
                if (replaceIndex == -1) {
                    policy.mAdminList.add(newAdmin);
                    this.enableIfNecessary(info.getPackageName(), userHandle);
                } else {
                    policy.mAdminList.set(replaceIndex, newAdmin);
                }
                this.saveSettingsLocked(userHandle);
                this.sendAdminCommandLocked(newAdmin, "android.app.action.DEVICE_ADMIN_ENABLED", onEnableData, null);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAdminActive(ComponentName adminReceiver, int userHandle) {
        if (!this.mHasFeature) {
            return false;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            return this.getActiveAdminUncheckedLocked(adminReceiver, userHandle) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRemovingAdmin(ComponentName adminReceiver, int userHandle) {
        if (!this.mHasFeature) {
            return false;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            DevicePolicyData policyData = this.getUserData(userHandle);
            return policyData.mRemovingAdmins.contains(adminReceiver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasGrantedPolicy(ComponentName adminReceiver, int policyId, int userHandle) {
        if (!this.mHasFeature) {
            return false;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin administrator = this.getActiveAdminUncheckedLocked(adminReceiver, userHandle);
            if (administrator == null) {
                throw new SecurityException("No active admin " + adminReceiver);
            }
            return administrator.info.usesPolicy(policyId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ComponentName> getActiveAdmins(int userHandle) {
        if (!this.mHasFeature) {
            return Collections.EMPTY_LIST;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            DevicePolicyData policy = this.getUserData(userHandle);
            int N = policy.mAdminList.size();
            if (N <= 0) {
                return null;
            }
            ArrayList<ComponentName> res = new ArrayList<ComponentName>(N);
            for (int i = 0; i < N; ++i) {
                res.add(policy.mAdminList.get((int)i).info.getComponent());
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean packageHasActiveAdmins(String packageName, int userHandle) {
        if (!this.mHasFeature) {
            return false;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            DevicePolicyData policy = this.getUserData(userHandle);
            int N = policy.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                if (!policy.mAdminList.get((int)i).info.getPackageName().equals(packageName)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeActiveAdmin(ComponentName adminReceiver, int userHandle) {
        if (!this.mHasFeature) {
            return;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getActiveAdminUncheckedLocked(adminReceiver, userHandle);
            if (admin == null) {
                return;
            }
            if (admin.getUid() != Binder.getCallingUid()) {
                if (this.isDeviceOwner(adminReceiver.getPackageName())) {
                    return;
                }
                this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_DEVICE_ADMINS", null);
            }
            long ident = Binder.clearCallingIdentity();
            try {
                this.removeActiveAdminLocked(adminReceiver, userHandle);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPasswordQuality(ComponentName who, int quality) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userHandle = UserHandle.getCallingUserId();
        DevicePolicyManagerService.validateQualityConstant(quality);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 0);
            if (ap.passwordQuality != quality) {
                ap.passwordQuality = quality;
                this.saveSettingsLocked(userHandle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPasswordQuality(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return 0;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            int mode = 0;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
                int n = admin != null ? admin.passwordQuality : mode;
                return n;
            }
            List<UserInfo> profiles = this.mUserManager.getProfiles(userHandle);
            for (UserInfo userInfo : profiles) {
                DevicePolicyData policy = this.getUserDataUnchecked(userInfo.id);
                int N = policy.mAdminList.size();
                for (int i = 0; i < N; ++i) {
                    ActiveAdmin admin = policy.mAdminList.get(i);
                    if (mode >= admin.passwordQuality) continue;
                    mode = admin.passwordQuality;
                }
            }
            return mode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPasswordMinimumLength(ComponentName who, int length) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userHandle = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 0);
            if (ap.minimumPasswordLength != length) {
                ap.minimumPasswordLength = length;
                this.saveSettingsLocked(userHandle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPasswordMinimumLength(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return 0;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            int length = 0;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
                int n = admin != null ? admin.minimumPasswordLength : length;
                return n;
            }
            List<UserInfo> profiles = this.mUserManager.getProfiles(userHandle);
            for (UserInfo userInfo : profiles) {
                DevicePolicyData policy = this.getUserDataUnchecked(userInfo.id);
                int N = policy.mAdminList.size();
                for (int i = 0; i < N; ++i) {
                    ActiveAdmin admin = policy.mAdminList.get(i);
                    if (length >= admin.minimumPasswordLength) continue;
                    length = admin.minimumPasswordLength;
                }
            }
            return length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPasswordHistoryLength(ComponentName who, int length) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userHandle = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 0);
            if (ap.passwordHistoryLength != length) {
                ap.passwordHistoryLength = length;
                this.saveSettingsLocked(userHandle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPasswordHistoryLength(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return 0;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            int length = 0;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
                int n = admin != null ? admin.passwordHistoryLength : length;
                return n;
            }
            List<UserInfo> profiles = this.mUserManager.getProfiles(userHandle);
            for (UserInfo userInfo : profiles) {
                DevicePolicyData policy = this.getUserDataUnchecked(userInfo.id);
                int N = policy.mAdminList.size();
                for (int i = 0; i < N; ++i) {
                    ActiveAdmin admin = policy.mAdminList.get(i);
                    if (length >= admin.passwordHistoryLength) continue;
                    length = admin.passwordHistoryLength;
                }
            }
            return length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPasswordExpirationTimeout(ComponentName who, long timeout) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        Preconditions.checkArgumentNonnegative(timeout, "Timeout must be >= 0 ms");
        int userHandle = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            long expiration;
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 6);
            ap.passwordExpirationDate = expiration = timeout > 0L ? timeout + System.currentTimeMillis() : 0L;
            ap.passwordExpirationTimeout = timeout;
            if (timeout > 0L) {
                Slog.w(LOG_TAG, "setPasswordExpiration(): password will expire on " + DateFormat.getDateTimeInstance(2, 2).format(new Date(expiration)));
            }
            this.saveSettingsLocked(userHandle);
            this.setExpirationAlarmCheckLocked(this.mContext, this.getUserData(userHandle));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getPasswordExpirationTimeout(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return 0L;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            long timeout = 0L;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
                long l = admin != null ? admin.passwordExpirationTimeout : timeout;
                return l;
            }
            List<UserInfo> profiles = this.mUserManager.getProfiles(userHandle);
            for (UserInfo userInfo : profiles) {
                DevicePolicyData policy = this.getUserDataUnchecked(userInfo.id);
                int N = policy.mAdminList.size();
                for (int i = 0; i < N; ++i) {
                    ActiveAdmin admin = policy.mAdminList.get(i);
                    if (timeout != 0L && (admin.passwordExpirationTimeout == 0L || timeout <= admin.passwordExpirationTimeout)) continue;
                    timeout = admin.passwordExpirationTimeout;
                }
            }
            return timeout;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addCrossProfileWidgetProvider(ComponentName admin, String packageName) {
        int userId = UserHandle.getCallingUserId();
        ArrayList<String> changedProviders = null;
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            List<String> providers;
            ActiveAdmin activeAdmin = this.getActiveAdminForCallerLocked(admin, -1);
            if (activeAdmin.crossProfileWidgetProviders == null) {
                activeAdmin.crossProfileWidgetProviders = new ArrayList<String>();
            }
            if (!(providers = activeAdmin.crossProfileWidgetProviders).contains(packageName)) {
                providers.add(packageName);
                changedProviders = new ArrayList<String>(providers);
                this.saveSettingsLocked(userId);
            }
        }
        if (changedProviders != null) {
            this.mLocalService.notifyCrossProfileProvidersChanged(userId, changedProviders);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeCrossProfileWidgetProvider(ComponentName admin, String packageName) {
        int userId = UserHandle.getCallingUserId();
        ArrayList<String> changedProviders = null;
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin activeAdmin = this.getActiveAdminForCallerLocked(admin, -1);
            if (activeAdmin.crossProfileWidgetProviders == null) {
                return false;
            }
            List<String> providers = activeAdmin.crossProfileWidgetProviders;
            if (providers.remove(packageName)) {
                changedProviders = new ArrayList<String>(providers);
                this.saveSettingsLocked(userId);
            }
        }
        if (changedProviders != null) {
            this.mLocalService.notifyCrossProfileProvidersChanged(userId, changedProviders);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getCrossProfileWidgetProviders(ComponentName admin) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin activeAdmin = this.getActiveAdminForCallerLocked(admin, -1);
            if (activeAdmin.crossProfileWidgetProviders == null || activeAdmin.crossProfileWidgetProviders.isEmpty()) {
                return null;
            }
            if (Binder.getCallingUid() == Process.myUid()) {
                return new ArrayList<String>(activeAdmin.crossProfileWidgetProviders);
            }
            return activeAdmin.crossProfileWidgetProviders;
        }
    }

    private long getPasswordExpirationLocked(ComponentName who, int userHandle) {
        long timeout = 0L;
        if (who != null) {
            ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
            return admin != null ? admin.passwordExpirationDate : timeout;
        }
        List<UserInfo> profiles = this.mUserManager.getProfiles(userHandle);
        for (UserInfo userInfo : profiles) {
            DevicePolicyData policy = this.getUserDataUnchecked(userInfo.id);
            int N = policy.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = policy.mAdminList.get(i);
                if (timeout != 0L && (admin.passwordExpirationDate == 0L || timeout <= admin.passwordExpirationDate)) continue;
                timeout = admin.passwordExpirationDate;
            }
        }
        return timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getPasswordExpiration(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return 0L;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            return this.getPasswordExpirationLocked(who, userHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPasswordMinimumUpperCase(ComponentName who, int length) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userHandle = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 0);
            if (ap.minimumPasswordUpperCase != length) {
                ap.minimumPasswordUpperCase = length;
                this.saveSettingsLocked(userHandle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPasswordMinimumUpperCase(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return 0;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            int length = 0;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
                int n = admin != null ? admin.minimumPasswordUpperCase : length;
                return n;
            }
            List<UserInfo> profiles = this.mUserManager.getProfiles(userHandle);
            for (UserInfo userInfo : profiles) {
                DevicePolicyData policy = this.getUserDataUnchecked(userInfo.id);
                int N = policy.mAdminList.size();
                for (int i = 0; i < N; ++i) {
                    ActiveAdmin admin = policy.mAdminList.get(i);
                    if (length >= admin.minimumPasswordUpperCase) continue;
                    length = admin.minimumPasswordUpperCase;
                }
            }
            return length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPasswordMinimumLowerCase(ComponentName who, int length) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userHandle = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 0);
            if (ap.minimumPasswordLowerCase != length) {
                ap.minimumPasswordLowerCase = length;
                this.saveSettingsLocked(userHandle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPasswordMinimumLowerCase(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return 0;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            int length = 0;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
                int n = admin != null ? admin.minimumPasswordLowerCase : length;
                return n;
            }
            List<UserInfo> profiles = this.mUserManager.getProfiles(userHandle);
            for (UserInfo userInfo : profiles) {
                DevicePolicyData policy = this.getUserDataUnchecked(userInfo.id);
                int N = policy.mAdminList.size();
                for (int i = 0; i < N; ++i) {
                    ActiveAdmin admin = policy.mAdminList.get(i);
                    if (length >= admin.minimumPasswordLowerCase) continue;
                    length = admin.minimumPasswordLowerCase;
                }
            }
            return length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPasswordMinimumLetters(ComponentName who, int length) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userHandle = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 0);
            if (ap.minimumPasswordLetters != length) {
                ap.minimumPasswordLetters = length;
                this.saveSettingsLocked(userHandle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPasswordMinimumLetters(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return 0;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            int length = 0;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
                int n = admin != null ? admin.minimumPasswordLetters : length;
                return n;
            }
            List<UserInfo> profiles = this.mUserManager.getProfiles(userHandle);
            for (UserInfo userInfo : profiles) {
                DevicePolicyData policy = this.getUserDataUnchecked(userInfo.id);
                int N = policy.mAdminList.size();
                for (int i = 0; i < N; ++i) {
                    ActiveAdmin admin = policy.mAdminList.get(i);
                    if (!DevicePolicyManagerService.isLimitPasswordAllowed(admin, 393216) || length >= admin.minimumPasswordLetters) continue;
                    length = admin.minimumPasswordLetters;
                }
            }
            return length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPasswordMinimumNumeric(ComponentName who, int length) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userHandle = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 0);
            if (ap.minimumPasswordNumeric != length) {
                ap.minimumPasswordNumeric = length;
                this.saveSettingsLocked(userHandle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPasswordMinimumNumeric(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return 0;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            int length = 0;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
                int n = admin != null ? admin.minimumPasswordNumeric : length;
                return n;
            }
            List<UserInfo> profiles = this.mUserManager.getProfiles(userHandle);
            for (UserInfo userInfo : profiles) {
                DevicePolicyData policy = this.getUserDataUnchecked(userInfo.id);
                int N = policy.mAdminList.size();
                for (int i = 0; i < N; ++i) {
                    ActiveAdmin admin = policy.mAdminList.get(i);
                    if (!DevicePolicyManagerService.isLimitPasswordAllowed(admin, 393216) || length >= admin.minimumPasswordNumeric) continue;
                    length = admin.minimumPasswordNumeric;
                }
            }
            return length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPasswordMinimumSymbols(ComponentName who, int length) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userHandle = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 0);
            if (ap.minimumPasswordSymbols != length) {
                ap.minimumPasswordSymbols = length;
                this.saveSettingsLocked(userHandle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPasswordMinimumSymbols(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return 0;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            int length = 0;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
                int n = admin != null ? admin.minimumPasswordSymbols : length;
                return n;
            }
            List<UserInfo> profiles = this.mUserManager.getProfiles(userHandle);
            for (UserInfo userInfo : profiles) {
                DevicePolicyData policy = this.getUserDataUnchecked(userInfo.id);
                int N = policy.mAdminList.size();
                for (int i = 0; i < N; ++i) {
                    ActiveAdmin admin = policy.mAdminList.get(i);
                    if (!DevicePolicyManagerService.isLimitPasswordAllowed(admin, 393216) || length >= admin.minimumPasswordSymbols) continue;
                    length = admin.minimumPasswordSymbols;
                }
            }
            return length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPasswordMinimumNonLetter(ComponentName who, int length) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userHandle = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 0);
            if (ap.minimumPasswordNonLetter != length) {
                ap.minimumPasswordNonLetter = length;
                this.saveSettingsLocked(userHandle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPasswordMinimumNonLetter(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return 0;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            int length = 0;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
                int n = admin != null ? admin.minimumPasswordNonLetter : length;
                return n;
            }
            List<UserInfo> profiles = this.mUserManager.getProfiles(userHandle);
            for (UserInfo userInfo : profiles) {
                DevicePolicyData policy = this.getUserDataUnchecked(userInfo.id);
                int N = policy.mAdminList.size();
                for (int i = 0; i < N; ++i) {
                    ActiveAdmin admin = policy.mAdminList.get(i);
                    if (!DevicePolicyManagerService.isLimitPasswordAllowed(admin, 393216) || length >= admin.minimumPasswordNonLetter) continue;
                    length = admin.minimumPasswordNonLetter;
                }
            }
            return length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActivePasswordSufficient(int userHandle) {
        if (!this.mHasFeature) {
            return true;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            UserInfo parent = this.getProfileParent(userHandle);
            int id2 = parent == null ? userHandle : parent.id;
            DevicePolicyData policy = this.getUserDataUnchecked(id2);
            this.getActiveAdminForCallerLocked(null, 0);
            if (policy.mActivePasswordQuality < this.getPasswordQuality(null, userHandle) || policy.mActivePasswordLength < this.getPasswordMinimumLength(null, userHandle)) {
                return false;
            }
            if (policy.mActivePasswordQuality != 393216) {
                return true;
            }
            return policy.mActivePasswordUpperCase >= this.getPasswordMinimumUpperCase(null, userHandle) && policy.mActivePasswordLowerCase >= this.getPasswordMinimumLowerCase(null, userHandle) && policy.mActivePasswordLetters >= this.getPasswordMinimumLetters(null, userHandle) && policy.mActivePasswordNumeric >= this.getPasswordMinimumNumeric(null, userHandle) && policy.mActivePasswordSymbols >= this.getPasswordMinimumSymbols(null, userHandle) && policy.mActivePasswordNonLetter >= this.getPasswordMinimumNonLetter(null, userHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCurrentFailedPasswordAttempts(int userHandle) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(null, 1);
            UserInfo parent = this.getProfileParent(userHandle);
            int id2 = parent == null ? userHandle : parent.id;
            DevicePolicyData policy = this.getUserDataUnchecked(id2);
            return policy.mFailedPasswordAttempts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaximumFailedPasswordsForWipe(ComponentName who, int num) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userHandle = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(who, 4);
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 1);
            if (ap.maximumFailedPasswordsForWipe != num) {
                ap.maximumFailedPasswordsForWipe = num;
                this.saveSettingsLocked(userHandle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaximumFailedPasswordsForWipe(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return 0;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = who != null ? this.getActiveAdminUncheckedLocked(who, userHandle) : this.getAdminWithMinimumFailedPasswordsForWipeLocked(userHandle);
            return admin != null ? admin.maximumFailedPasswordsForWipe : 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getProfileWithMinimumFailedPasswordsForWipe(int userHandle) {
        if (!this.mHasFeature) {
            return -10000;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getAdminWithMinimumFailedPasswordsForWipeLocked(userHandle);
            return admin != null ? admin.getUserHandle().getIdentifier() : -10000;
        }
    }

    private ActiveAdmin getAdminWithMinimumFailedPasswordsForWipeLocked(int userHandle) {
        int count = 0;
        ActiveAdmin strictestAdmin = null;
        for (UserInfo userInfo : this.mUserManager.getProfiles(userHandle)) {
            DevicePolicyData policy = this.getUserDataUnchecked(userInfo.id);
            for (ActiveAdmin admin : policy.mAdminList) {
                if (admin.maximumFailedPasswordsForWipe == 0 || count != 0 && count <= admin.maximumFailedPasswordsForWipe && (!userInfo.isPrimary() || count < admin.maximumFailedPasswordsForWipe)) continue;
                count = admin.maximumFailedPasswordsForWipe;
                strictestAdmin = admin;
            }
        }
        return strictestAdmin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean resetPassword(String passwordOrNull, int flags) {
        boolean doNotAskCredentialsOnBoot;
        int quality;
        if (!this.mHasFeature) {
            return false;
        }
        int userHandle = UserHandle.getCallingUserId();
        this.enforceNotManagedProfile(userHandle, "reset the password");
        String password = passwordOrNull != null ? passwordOrNull : "";
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(null, 2);
            quality = this.getPasswordQuality(null, userHandle);
            if (quality != 0) {
                int realQuality = LockPatternUtils.computePasswordQuality(password);
                if (realQuality < quality && quality != 393216) {
                    Slog.w(LOG_TAG, "resetPassword: password quality 0x" + Integer.toHexString(realQuality) + " does not meet required quality 0x" + Integer.toHexString(quality));
                    return false;
                }
                quality = Math.max(realQuality, quality);
            }
            int length = this.getPasswordMinimumLength(null, userHandle);
            if (password.length() < length) {
                Slog.w(LOG_TAG, "resetPassword: password length " + password.length() + " does not meet required length " + length);
                return false;
            }
            if (quality == 393216) {
                int letters = 0;
                int uppercase = 0;
                int lowercase = 0;
                int numbers = 0;
                int symbols = 0;
                int nonletter = 0;
                for (int i = 0; i < password.length(); ++i) {
                    char c = password.charAt(i);
                    if (c >= 'A' && c <= 'Z') {
                        ++letters;
                        ++uppercase;
                        continue;
                    }
                    if (c >= 'a' && c <= 'z') {
                        ++letters;
                        ++lowercase;
                        continue;
                    }
                    if (c >= '0' && c <= '9') {
                        ++numbers;
                        ++nonletter;
                        continue;
                    }
                    ++symbols;
                    ++nonletter;
                }
                int neededLetters = this.getPasswordMinimumLetters(null, userHandle);
                if (letters < neededLetters) {
                    Slog.w(LOG_TAG, "resetPassword: number of letters " + letters + " does not meet required number of letters " + neededLetters);
                    return false;
                }
                int neededNumbers = this.getPasswordMinimumNumeric(null, userHandle);
                if (numbers < neededNumbers) {
                    Slog.w(LOG_TAG, "resetPassword: number of numerical digits " + numbers + " does not meet required number of numerical digits " + neededNumbers);
                    return false;
                }
                int neededLowerCase = this.getPasswordMinimumLowerCase(null, userHandle);
                if (lowercase < neededLowerCase) {
                    Slog.w(LOG_TAG, "resetPassword: number of lowercase letters " + lowercase + " does not meet required number of lowercase letters " + neededLowerCase);
                    return false;
                }
                int neededUpperCase = this.getPasswordMinimumUpperCase(null, userHandle);
                if (uppercase < neededUpperCase) {
                    Slog.w(LOG_TAG, "resetPassword: number of uppercase letters " + uppercase + " does not meet required number of uppercase letters " + neededUpperCase);
                    return false;
                }
                int neededSymbols = this.getPasswordMinimumSymbols(null, userHandle);
                if (symbols < neededSymbols) {
                    Slog.w(LOG_TAG, "resetPassword: number of special symbols " + symbols + " does not meet required number of special symbols " + neededSymbols);
                    return false;
                }
                int neededNonLetter = this.getPasswordMinimumNonLetter(null, userHandle);
                if (nonletter < neededNonLetter) {
                    Slog.w(LOG_TAG, "resetPassword: number of non-letter characters " + nonletter + " does not meet required number of non-letter characters " + neededNonLetter);
                    return false;
                }
            }
        }
        int callingUid = Binder.getCallingUid();
        DevicePolicyData policy = this.getUserData(userHandle);
        if (policy.mPasswordOwner >= 0 && policy.mPasswordOwner != callingUid) {
            Slog.w(LOG_TAG, "resetPassword: already set by another uid and not entered by user");
            return false;
        }
        boolean callerIsDeviceOwnerAdmin = this.isCallerDeviceOwnerOrInitializer(callingUid);
        boolean bl = doNotAskCredentialsOnBoot = (flags & 2) != 0;
        if (callerIsDeviceOwnerAdmin && doNotAskCredentialsOnBoot) {
            this.setDoNotAskCredentialsOnBoot();
        }
        long ident = Binder.clearCallingIdentity();
        try {
            boolean requireEntry;
            LockPatternUtils utils = new LockPatternUtils(this.mContext);
            if (!TextUtils.isEmpty(password)) {
                utils.saveLockPassword(password, null, quality, userHandle);
            } else {
                utils.clearLock(userHandle);
            }
            boolean bl2 = requireEntry = (flags & 1) != 0;
            if (requireEntry) {
                utils.requireCredentialEntry(-1);
            }
            DevicePolicyManagerService devicePolicyManagerService2 = this;
            synchronized (devicePolicyManagerService2) {
                int newOwner;
                int n = newOwner = requireEntry ? callingUid : -1;
                if (policy.mPasswordOwner != newOwner) {
                    policy.mPasswordOwner = newOwner;
                    this.saveSettingsLocked(userHandle);
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDoNotAskCredentialsOnBoot() {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            DevicePolicyData policyData = this.getUserData(0);
            if (!policyData.doNotAskCredentialsOnBoot) {
                policyData.doNotAskCredentialsOnBoot = true;
                this.saveSettingsLocked(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getDoNotAskCredentialsOnBoot() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.QUERY_DO_NOT_ASK_CREDENTIALS_ON_BOOT", null);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            DevicePolicyData policyData = this.getUserData(0);
            return policyData.doNotAskCredentialsOnBoot;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaximumTimeToLock(ComponentName who, long timeMs) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userHandle = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 3);
            if (ap.maximumTimeToUnlock != timeMs) {
                ap.maximumTimeToUnlock = timeMs;
                this.saveSettingsLocked(userHandle);
                this.updateMaximumTimeToLockLocked(this.getUserData(userHandle));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateMaximumTimeToLockLocked(DevicePolicyData policy) {
        long timeMs = this.getMaximumTimeToLock(null, policy.mUserHandle);
        if (policy.mLastMaximumTimeToLock == timeMs) {
            return;
        }
        long ident = Binder.clearCallingIdentity();
        try {
            if (timeMs <= 0L) {
                timeMs = Integer.MAX_VALUE;
            } else {
                Settings.Global.putInt(this.mContext.getContentResolver(), "stay_on_while_plugged_in", 0);
            }
            policy.mLastMaximumTimeToLock = timeMs;
            this.mPowerManagerInternal.setMaximumScreenOffTimeoutFromDeviceAdmin((int)timeMs);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMaximumTimeToLock(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return 0L;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            long time = 0L;
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
                long l = admin != null ? admin.maximumTimeToUnlock : time;
                return l;
            }
            List<UserInfo> profiles = this.mUserManager.getProfiles(userHandle);
            for (UserInfo userInfo : profiles) {
                DevicePolicyData policy = this.getUserDataUnchecked(userInfo.id);
                int N = policy.mAdminList.size();
                for (int i = 0; i < N; ++i) {
                    ActiveAdmin admin = policy.mAdminList.get(i);
                    if (time == 0L) {
                        time = admin.maximumTimeToUnlock;
                        continue;
                    }
                    if (admin.maximumTimeToUnlock == 0L || time <= admin.maximumTimeToUnlock) continue;
                    time = admin.maximumTimeToUnlock;
                }
            }
            return time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lockNow() {
        if (!this.mHasFeature) {
            return;
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(null, 3);
            this.lockNowUnchecked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockNowUnchecked() {
        long ident = Binder.clearCallingIdentity();
        try {
            this.mPowerManager.goToSleep(SystemClock.uptimeMillis(), 1, 0);
            new LockPatternUtils(this.mContext).requireCredentialEntry(-1);
            this.getWindowManager().lockNow(null);
        }
        catch (RemoteException remoteException) {
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private boolean isExtStorageEncrypted() {
        String state = SystemProperties.get("vold.decrypt");
        return !"".equals(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enforceCanManageCaCerts(ComponentName who) {
        if (who == null) {
            if (!this.isCallerDelegatedCertInstaller()) {
                this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_CA_CERTIFICATES", null);
            }
        } else {
            DevicePolicyManagerService devicePolicyManagerService = this;
            synchronized (devicePolicyManagerService) {
                this.getActiveAdminForCallerLocked(who, -1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCallerDelegatedCertInstaller() {
        int callingUid = Binder.getCallingUid();
        int userHandle = UserHandle.getUserId(callingUid);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            DevicePolicyData policy = this.getUserData(userHandle);
            if (policy.mDelegatedCertInstallerPackage == null) {
                return false;
            }
            try {
                int uid = this.mContext.getPackageManager().getPackageUid(policy.mDelegatedCertInstallerPackage, userHandle);
                return uid == callingUid;
            }
            catch (PackageManager.NameNotFoundException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean installCaCert(ComponentName admin, byte[] certBuffer) throws RemoteException {
        byte[] pemCert;
        this.enforceCanManageCaCerts(admin);
        try {
            X509Certificate cert = DevicePolicyManagerService.parseCert(certBuffer);
            pemCert = Credentials.convertToPem(cert);
        }
        catch (CertificateException ce) {
            Log.e(LOG_TAG, "Problem converting cert", ce);
            return false;
        }
        catch (IOException ioe) {
            Log.e(LOG_TAG, "Problem reading cert", ioe);
            return false;
        }
        UserHandle userHandle = new UserHandle(UserHandle.getCallingUserId());
        long id2 = Binder.clearCallingIdentity();
        try {
            KeyChain.KeyChainConnection keyChainConnection = KeyChain.bindAsUser(this.mContext, userHandle);
            try {
                keyChainConnection.getService().installCaCertificate(pemCert);
                boolean bl = true;
                keyChainConnection.close();
                return bl;
            }
            catch (RemoteException e) {
                try {
                    try {
                        Log.e(LOG_TAG, "installCaCertsToKeyChain(): ", e);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        keyChainConnection.close();
                    }
                }
                catch (InterruptedException e1) {
                    Log.w(LOG_TAG, "installCaCertsToKeyChain(): ", e1);
                    Thread.currentThread().interrupt();
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(id2);
        }
        return false;
    }

    private static X509Certificate parseCert(byte[] certBuffer) throws CertificateException {
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        return (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(certBuffer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uninstallCaCerts(ComponentName admin, String[] aliases) {
        this.enforceCanManageCaCerts(admin);
        UserHandle userHandle = new UserHandle(UserHandle.getCallingUserId());
        long id2 = Binder.clearCallingIdentity();
        try (KeyChain.KeyChainConnection keyChainConnection = KeyChain.bindAsUser(this.mContext, userHandle);){
            for (int i = 0; i < aliases.length; ++i) {
                keyChainConnection.getService().deleteCaCertificate(aliases[i]);
            }
        }
        catch (InterruptedException ie) {
            Log.w(LOG_TAG, "CaCertUninstaller: ", ie);
            Thread.currentThread().interrupt();
        }
        finally {
            Binder.restoreCallingIdentity(id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean installKeyPair(ComponentName who, byte[] privKey, byte[] cert, String alias) {
        if (who == null) {
            if (!this.isCallerDelegatedCertInstaller()) {
                throw new SecurityException("who == null, but caller is not cert installer");
            }
        } else {
            DevicePolicyManagerService devicePolicyManagerService = this;
            synchronized (devicePolicyManagerService) {
                this.getActiveAdminForCallerLocked(who, -1);
            }
        }
        UserHandle userHandle = new UserHandle(UserHandle.getCallingUserId());
        long id2 = Binder.clearCallingIdentity();
        try {
            KeyChain.KeyChainConnection keyChainConnection = KeyChain.bindAsUser(this.mContext, userHandle);
            try {
                IKeyChainService keyChain = keyChainConnection.getService();
                boolean bl = keyChain.installKeyPair(privKey, cert, alias);
                keyChainConnection.close();
                return bl;
            }
            catch (RemoteException e) {
                try {
                    try {
                        Log.e(LOG_TAG, "Installing certificate", e);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        keyChainConnection.close();
                    }
                }
                catch (InterruptedException e2) {
                    Log.w(LOG_TAG, "Interrupted while installing certificate", e2);
                    Thread.currentThread().interrupt();
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(id2);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void choosePrivateKeyAlias(int uid, Uri uri, String alias, final IBinder response) {
        ActiveAdmin deviceOwnerAdmin;
        if (UserHandle.getAppId(Binder.getCallingUid()) != 1000) {
            return;
        }
        UserHandle caller = Binder.getCallingUserHandle();
        ComponentName aliasChooser = this.getProfileOwner(caller.getIdentifier());
        if (aliasChooser == null && caller.isOwner() && (deviceOwnerAdmin = this.getDeviceOwnerAdmin()) != null) {
            aliasChooser = deviceOwnerAdmin.info.getComponent();
        }
        if (aliasChooser == null) {
            this.sendPrivateKeyAliasResponse(null, response);
            return;
        }
        Intent intent = new Intent("android.app.action.CHOOSE_PRIVATE_KEY_ALIAS");
        intent.setComponent(aliasChooser);
        intent.putExtra("android.app.extra.CHOOSE_PRIVATE_KEY_SENDER_UID", uid);
        intent.putExtra("android.app.extra.CHOOSE_PRIVATE_KEY_URI", uri);
        intent.putExtra("android.app.extra.CHOOSE_PRIVATE_KEY_ALIAS", alias);
        intent.putExtra("android.app.extra.CHOOSE_PRIVATE_KEY_RESPONSE", response);
        long id2 = Binder.clearCallingIdentity();
        try {
            this.mContext.sendOrderedBroadcastAsUser(intent, caller, null, new BroadcastReceiver(){

                @Override
                public void onReceive(Context context, Intent intent) {
                    String chosenAlias = this.getResultData();
                    DevicePolicyManagerService.this.sendPrivateKeyAliasResponse(chosenAlias, response);
                }
            }, null, -1, null, null);
        }
        finally {
            Binder.restoreCallingIdentity(id2);
        }
    }

    private void sendPrivateKeyAliasResponse(final String alias, IBinder responseBinder) {
        final IKeyChainAliasCallback keyChainAliasResponse = IKeyChainAliasCallback.Stub.asInterface(responseBinder);
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... unused) {
                try {
                    keyChainAliasResponse.alias(alias);
                }
                catch (Exception e) {
                    Log.e(DevicePolicyManagerService.LOG_TAG, "error while responding to callback", e);
                }
                return null;
            }
        }.execute(new Void[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCertInstallerPackage(ComponentName who, String installerPackage) throws SecurityException {
        int userHandle = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(who, -1);
            DevicePolicyData policy = this.getUserData(userHandle);
            policy.mDelegatedCertInstallerPackage = installerPackage;
            this.saveSettingsLocked(userHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCertInstallerPackage(ComponentName who) throws SecurityException {
        int userHandle = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(who, -1);
            DevicePolicyData policy = this.getUserData(userHandle);
            return policy.mDelegatedCertInstallerPackage;
        }
    }

    private void wipeDataLocked(boolean wipeExtRequested, String reason) {
        if (wipeExtRequested) {
            StorageManager sm = (StorageManager)this.mContext.getSystemService("storage");
            sm.wipeAdoptableDisks();
        }
        try {
            RecoverySystem.rebootWipeUserData(this.mContext, reason);
        }
        catch (IOException | SecurityException e) {
            Slog.w(LOG_TAG, "Failed requesting data wipe", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wipeData(int flags, int userHandle) {
        if (!this.mHasFeature) {
            return;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(null, 4);
            ComponentName cname = admin.info.getComponent();
            String source = cname != null ? cname.flattenToShortString() : admin.info.getPackageName();
            long ident = Binder.clearCallingIdentity();
            try {
                if ((flags & 2) != 0) {
                    boolean ownsInitialization;
                    boolean bl = ownsInitialization = this.isDeviceInitializer(admin.info.getPackageName()) && !this.hasUserSetupCompleted(userHandle);
                    if (userHandle != 0 || !this.isDeviceOwner(admin.info.getPackageName()) && !ownsInitialization) {
                        throw new SecurityException("Only device owner admins can set WIPE_RESET_PROTECTION_DATA");
                    }
                    PersistentDataBlockManager manager = (PersistentDataBlockManager)this.mContext.getSystemService("persistent_data_block");
                    if (manager != null) {
                        manager.wipe();
                    }
                }
                boolean wipeExtRequested = (flags & 1) != 0;
                this.wipeDeviceOrUserLocked(wipeExtRequested, userHandle, "DevicePolicyManager.wipeData() from " + source);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    private void wipeDeviceOrUserLocked(boolean wipeExtRequested, final int userHandle, String reason) {
        if (userHandle == 0) {
            this.wipeDataLocked(wipeExtRequested, reason);
        } else {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        IActivityManager am = ActivityManagerNative.getDefault();
                        if (am.getCurrentUser().id == userHandle) {
                            am.switchUser(0);
                        }
                        boolean isManagedProfile = DevicePolicyManagerService.this.isManagedProfile(userHandle);
                        if (!DevicePolicyManagerService.this.mUserManager.removeUser(userHandle)) {
                            Slog.w(DevicePolicyManagerService.LOG_TAG, "Couldn't remove user " + userHandle);
                        } else if (isManagedProfile) {
                            DevicePolicyManagerService.this.sendWipeProfileNotification();
                        }
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            });
        }
    }

    private void sendWipeProfileNotification() {
        String contentText = this.mContext.getString(17039597);
        Notification notification = new Notification.Builder(this.mContext).setSmallIcon(17301642).setContentTitle(this.mContext.getString(17039594)).setContentText(contentText).setColor(this.mContext.getColor(17170521)).setStyle(new Notification.BigTextStyle().bigText(contentText)).build();
        this.getNotificationManager().notify(1001, notification);
    }

    private void clearWipeProfileNotification() {
        this.getNotificationManager().cancel(1001);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getRemoveWarning(ComponentName comp, final RemoteCallback result, int userHandle) {
        if (!this.mHasFeature) {
            return;
        }
        this.enforceCrossUserPermission(userHandle);
        this.mContext.enforceCallingOrSelfPermission("android.permission.BIND_DEVICE_ADMIN", null);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getActiveAdminUncheckedLocked(comp, userHandle);
            if (admin == null) {
                try {
                    result.sendResult(null);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
                return;
            }
            Intent intent = new Intent("android.app.action.DEVICE_ADMIN_DISABLE_REQUESTED");
            intent.setFlags(0x10000000);
            intent.setComponent(admin.info.getComponent());
            this.mContext.sendOrderedBroadcastAsUser(intent, new UserHandle(userHandle), null, new BroadcastReceiver(){

                @Override
                public void onReceive(Context context, Intent intent) {
                    try {
                        result.sendResult(this.getResultExtras(false));
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            }, null, -1, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setActivePasswordState(int quality, int length, int letters, int uppercase, int lowercase, int numbers, int symbols, int nonletter, int userHandle) {
        if (!this.mHasFeature) {
            return;
        }
        this.enforceCrossUserPermission(userHandle);
        this.enforceNotManagedProfile(userHandle, "set the active password");
        this.mContext.enforceCallingOrSelfPermission("android.permission.BIND_DEVICE_ADMIN", null);
        DevicePolicyData p = this.getUserData(userHandle);
        DevicePolicyManagerService.validateQualityConstant(quality);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (p.mActivePasswordQuality != quality || p.mActivePasswordLength != length || p.mFailedPasswordAttempts != 0 || p.mActivePasswordLetters != letters || p.mActivePasswordUpperCase != uppercase || p.mActivePasswordLowerCase != lowercase || p.mActivePasswordNumeric != numbers || p.mActivePasswordSymbols != symbols || p.mActivePasswordNonLetter != nonletter) {
                long ident = Binder.clearCallingIdentity();
                try {
                    p.mActivePasswordQuality = quality;
                    p.mActivePasswordLength = length;
                    p.mActivePasswordLetters = letters;
                    p.mActivePasswordLowerCase = lowercase;
                    p.mActivePasswordUpperCase = uppercase;
                    p.mActivePasswordNumeric = numbers;
                    p.mActivePasswordSymbols = symbols;
                    p.mActivePasswordNonLetter = nonletter;
                    p.mFailedPasswordAttempts = 0;
                    this.saveSettingsLocked(userHandle);
                    this.updatePasswordExpirationsLocked(userHandle);
                    this.setExpirationAlarmCheckLocked(this.mContext, p);
                    this.sendAdminCommandToSelfAndProfilesLocked("android.app.action.ACTION_PASSWORD_CHANGED", 0, userHandle);
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
            }
        }
    }

    private void updatePasswordExpirationsLocked(int userHandle) {
        List<UserInfo> profiles = this.mUserManager.getProfiles(userHandle);
        for (UserInfo userInfo : profiles) {
            int profileId = userInfo.id;
            DevicePolicyData policy = this.getUserDataUnchecked(profileId);
            int N = policy.mAdminList.size();
            if (N > 0) {
                for (int i = 0; i < N; ++i) {
                    long expiration;
                    ActiveAdmin admin = policy.mAdminList.get(i);
                    if (!admin.info.usesPolicy(6)) continue;
                    long timeout = admin.passwordExpirationTimeout;
                    admin.passwordExpirationDate = expiration = timeout > 0L ? timeout + System.currentTimeMillis() : 0L;
                }
            }
            this.saveSettingsLocked(profileId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportFailedPasswordAttempt(int userHandle) {
        this.enforceCrossUserPermission(userHandle);
        this.enforceNotManagedProfile(userHandle, "report failed password attempt");
        this.mContext.enforceCallingOrSelfPermission("android.permission.BIND_DEVICE_ADMIN", null);
        long ident = Binder.clearCallingIdentity();
        try {
            boolean wipeData = false;
            int identifier = 0;
            DevicePolicyManagerService devicePolicyManagerService = this;
            synchronized (devicePolicyManagerService) {
                DevicePolicyData policy = this.getUserData(userHandle);
                ++policy.mFailedPasswordAttempts;
                this.saveSettingsLocked(userHandle);
                if (this.mHasFeature) {
                    int max;
                    ActiveAdmin strictestAdmin = this.getAdminWithMinimumFailedPasswordsForWipeLocked(userHandle);
                    int n = max = strictestAdmin != null ? strictestAdmin.maximumFailedPasswordsForWipe : 0;
                    if (max > 0 && policy.mFailedPasswordAttempts >= max) {
                        wipeData = true;
                        identifier = strictestAdmin.getUserHandle().getIdentifier();
                    }
                    this.sendAdminCommandToSelfAndProfilesLocked("android.app.action.ACTION_PASSWORD_FAILED", 1, userHandle);
                }
            }
            if (wipeData) {
                this.wipeDeviceOrUserLocked(false, identifier, "reportFailedPasswordAttempt()");
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportSuccessfulPasswordAttempt(int userHandle) {
        this.enforceCrossUserPermission(userHandle);
        this.mContext.enforceCallingOrSelfPermission("android.permission.BIND_DEVICE_ADMIN", null);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            DevicePolicyData policy = this.getUserData(userHandle);
            if (policy.mFailedPasswordAttempts != 0 || policy.mPasswordOwner >= 0) {
                long ident = Binder.clearCallingIdentity();
                try {
                    policy.mFailedPasswordAttempts = 0;
                    policy.mPasswordOwner = -1;
                    this.saveSettingsLocked(userHandle);
                    if (this.mHasFeature) {
                        this.sendAdminCommandToSelfAndProfilesLocked("android.app.action.ACTION_PASSWORD_SUCCEEDED", 1, userHandle);
                    }
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComponentName setGlobalProxy(ComponentName who, String proxySpec, String exclusionList) {
        if (!this.mHasFeature) {
            return null;
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            Preconditions.checkNotNull(who, "ComponentName is null");
            DevicePolicyData policy = this.getUserData(0);
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, 5);
            Set<ComponentName> compSet = policy.mAdminMap.keySet();
            for (ComponentName component : compSet) {
                ActiveAdmin ap = policy.mAdminMap.get(component);
                if (!ap.specifiesGlobalProxy || component.equals(who)) continue;
                return component;
            }
            if (UserHandle.getCallingUserId() != 0) {
                Slog.w(LOG_TAG, "Only the owner is allowed to set the global proxy. User " + UserHandle.getCallingUserId() + " is not permitted.");
                return null;
            }
            if (proxySpec == null) {
                admin.specifiesGlobalProxy = false;
                admin.globalProxySpec = null;
                admin.globalProxyExclusionList = null;
            } else {
                admin.specifiesGlobalProxy = true;
                admin.globalProxySpec = proxySpec;
                admin.globalProxyExclusionList = exclusionList;
            }
            long origId = Binder.clearCallingIdentity();
            try {
                this.resetGlobalProxyLocked(policy);
            }
            finally {
                Binder.restoreCallingIdentity(origId);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComponentName getGlobalProxyAdmin(int userHandle) {
        if (!this.mHasFeature) {
            return null;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            DevicePolicyData policy = this.getUserData(0);
            int N = policy.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin ap = policy.mAdminList.get(i);
                if (!ap.specifiesGlobalProxy) continue;
                return ap.info.getComponent();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRecommendedGlobalProxy(ComponentName who, ProxyInfo proxyInfo) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(who, -2);
        }
        long token = Binder.clearCallingIdentity();
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
            connectivityManager.setGlobalProxy(proxyInfo);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private void resetGlobalProxyLocked(DevicePolicyData policy) {
        int N = policy.mAdminList.size();
        for (int i = 0; i < N; ++i) {
            ActiveAdmin ap = policy.mAdminList.get(i);
            if (!ap.specifiesGlobalProxy) continue;
            this.saveGlobalProxyLocked(ap.globalProxySpec, ap.globalProxyExclusionList);
            return;
        }
        this.saveGlobalProxyLocked(null, null);
    }

    private void saveGlobalProxyLocked(String proxySpec, String exclusionList) {
        if (exclusionList == null) {
            exclusionList = "";
        }
        if (proxySpec == null) {
            proxySpec = "";
        }
        proxySpec = proxySpec.trim();
        String[] data = proxySpec.split(":");
        int proxyPort = 8080;
        if (data.length > 1) {
            try {
                proxyPort = Integer.parseInt(data[1]);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        exclusionList = exclusionList.trim();
        ContentResolver res = this.mContext.getContentResolver();
        ProxyInfo proxyProperties = new ProxyInfo(data[0], proxyPort, exclusionList);
        if (!proxyProperties.isValid()) {
            Slog.e(LOG_TAG, "Invalid proxy properties, ignoring: " + proxyProperties.toString());
            return;
        }
        Settings.Global.putString(res, "global_http_proxy_host", data[0]);
        Settings.Global.putInt(res, "global_http_proxy_port", proxyPort);
        Settings.Global.putString(res, "global_http_proxy_exclusion_list", exclusionList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setStorageEncryption(ComponentName who, boolean encrypt) {
        if (!this.mHasFeature) {
            return 0;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userHandle = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (userHandle != 0 || UserHandle.getCallingUserId() != 0) {
                Slog.w(LOG_TAG, "Only owner is allowed to set storage encryption. User " + UserHandle.getCallingUserId() + " is not permitted.");
                return 0;
            }
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 7);
            if (!this.isEncryptionSupported()) {
                return 0;
            }
            if (ap.encryptionRequested != encrypt) {
                ap.encryptionRequested = encrypt;
                this.saveSettingsLocked(userHandle);
            }
            DevicePolicyData policy = this.getUserData(0);
            boolean newRequested = false;
            int N = policy.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                newRequested |= policy.mAdminList.get((int)i).encryptionRequested;
            }
            this.setEncryptionRequested(newRequested);
            return newRequested ? 3 : 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getStorageEncryption(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return false;
        }
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who != null) {
                ActiveAdmin ap = this.getActiveAdminUncheckedLocked(who, userHandle);
                boolean bl = ap != null ? ap.encryptionRequested : false;
                return bl;
            }
            DevicePolicyData policy = this.getUserData(userHandle);
            int N = policy.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                if (!policy.mAdminList.get((int)i).encryptionRequested) continue;
                return true;
            }
            return false;
        }
    }

    @Override
    public int getStorageEncryptionStatus(int userHandle) {
        if (!this.mHasFeature) {
            // empty if block
        }
        this.enforceCrossUserPermission(userHandle);
        return this.getEncryptionStatus();
    }

    private boolean isEncryptionSupported() {
        return this.getEncryptionStatus() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getEncryptionStatus() {
        String status = SystemProperties.get("ro.crypto.state", "unsupported");
        if ("encrypted".equalsIgnoreCase(status)) {
            long token = Binder.clearCallingIdentity();
            try {
                int n = LockPatternUtils.isDeviceEncrypted() ? 3 : 4;
                return n;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
        if ("unencrypted".equalsIgnoreCase(status)) {
            return 1;
        }
        return 0;
    }

    private void setEncryptionRequested(boolean encrypt) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setScreenCaptureDisabled(ComponentName who, boolean disabled) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userHandle = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, -1);
            if (ap.disableScreenCapture != disabled) {
                ap.disableScreenCapture = disabled;
                this.saveSettingsLocked(userHandle);
                this.updateScreenCaptureDisabledInWindowManager(userHandle, disabled);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getScreenCaptureDisabled(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return false;
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
                boolean bl = admin != null ? admin.disableScreenCapture : false;
                return bl;
            }
            DevicePolicyData policy = this.getUserData(userHandle);
            int N = policy.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = policy.mAdminList.get(i);
                if (!admin.disableScreenCapture) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateScreenCaptureDisabledInWindowManager(int userHandle, boolean disabled) {
        long ident = Binder.clearCallingIdentity();
        try {
            this.getWindowManager().setScreenCaptureDisabled(userHandle, disabled);
        }
        catch (RemoteException e) {
            Log.w(LOG_TAG, "Unable to notify WindowManager.", e);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAutoTimeRequired(ComponentName who, boolean required) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userHandle = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, -2);
            if (admin.requireAutoTime != required) {
                admin.requireAutoTime = required;
                this.saveSettingsLocked(userHandle);
            }
        }
        if (required) {
            long ident = Binder.clearCallingIdentity();
            try {
                Settings.Global.putInt(this.mContext.getContentResolver(), "auto_time", 1);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getAutoTimeRequired() {
        if (!this.mHasFeature) {
            return false;
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin deviceOwner = this.getDeviceOwnerAdmin();
            return deviceOwner != null ? deviceOwner.requireAutoTime : false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCameraDisabled(ComponentName who, boolean disabled) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userHandle = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 8);
            if (ap.disableCamera != disabled) {
                ap.disableCamera = disabled;
                this.saveSettingsLocked(userHandle);
            }
            this.syncDeviceCapabilitiesLocked(this.getUserData(userHandle));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getCameraDisabled(ComponentName who, int userHandle) {
        if (!this.mHasFeature) {
            return false;
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who != null) {
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
                boolean bl = admin != null ? admin.disableCamera : false;
                return bl;
            }
            DevicePolicyData policy = this.getUserData(userHandle);
            int N = policy.mAdminList.size();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = policy.mAdminList.get(i);
                if (!admin.disableCamera) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setKeyguardDisabledFeatures(ComponentName who, int which) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userHandle = UserHandle.getCallingUserId();
        if (this.isManagedProfile(userHandle)) {
            which &= 0x38;
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, 9);
            if (ap.disabledKeyguardFeatures != which) {
                ap.disabledKeyguardFeatures = which;
                this.saveSettingsLocked(userHandle);
            }
            this.syncDeviceCapabilitiesLocked(this.getUserData(userHandle));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public int getKeyguardDisabledFeatures(ComponentName who, int userHandle) {
        List<Object> profiles;
        long ident;
        block12: {
            int n;
            if (!this.mHasFeature) {
                return 0;
            }
            this.enforceCrossUserPermission(userHandle);
            ident = Binder.clearCallingIdentity();
            try {
                DevicePolicyManagerService devicePolicyManagerService = this;
                // MONITORENTER : devicePolicyManagerService
                if (who == null) break block12;
                ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, userHandle);
                n = admin != null ? admin.disabledKeyguardFeatures : 0;
                // MONITOREXIT : devicePolicyManagerService
            }
            catch (Throwable throwable) {
                Binder.restoreCallingIdentity(ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity(ident);
            return n;
        }
        UserInfo user = this.mUserManager.getUserInfo(userHandle);
        if (user.isManagedProfile()) {
            profiles = new ArrayList(1);
            profiles.add(user);
        } else {
            profiles = this.mUserManager.getProfiles(userHandle);
        }
        int which = 0;
        Iterator<Object> i$ = profiles.iterator();
        block6: while (true) {
            if (!i$.hasNext()) {
                int n = which;
                // MONITOREXIT : devicePolicyManagerService
                Binder.restoreCallingIdentity(ident);
                return n;
            }
            UserInfo userInfo = (UserInfo)i$.next();
            DevicePolicyData policy = this.getUserData(userInfo.id);
            int N = policy.mAdminList.size();
            int i = 0;
            while (true) {
                if (i >= N) continue block6;
                ActiveAdmin admin = policy.mAdminList.get(i);
                which = userInfo.id == userHandle || !userInfo.isManagedProfile() ? (which |= admin.disabledKeyguardFeatures) : (which |= admin.disabledKeyguardFeatures & 0x30);
                ++i;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setDeviceOwner(String packageName, String ownerName) {
        if (!this.mHasFeature) {
            return false;
        }
        if (packageName == null || !DeviceOwner.isInstalled(packageName, this.mContext.getPackageManager())) {
            throw new IllegalArgumentException("Invalid package name " + packageName + " for device owner");
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.enforceCanSetDeviceOwner();
            long ident = Binder.clearCallingIdentity();
            try {
                IBackupManager ibm = IBackupManager.Stub.asInterface(ServiceManager.getService("backup"));
                ibm.setBackupServiceActive(0, false);
            }
            catch (RemoteException e) {
                throw new IllegalStateException("Failed deactivating backup service.", e);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
            if (this.mDeviceOwner == null) {
                this.mDeviceOwner = DeviceOwner.createWithDeviceOwner(packageName, ownerName);
            } else {
                this.mDeviceOwner.setDeviceOwner(packageName, ownerName);
            }
            this.mDeviceOwner.writeOwnerFile();
            this.updateDeviceOwnerLocked();
            Intent intent = new Intent("android.app.action.DEVICE_OWNER_CHANGED");
            ident = Binder.clearCallingIdentity();
            try {
                this.mContext.sendBroadcastAsUser(intent, UserHandle.OWNER);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDeviceOwner(String packageName) {
        if (!this.mHasFeature) {
            return false;
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            return this.mDeviceOwner != null && this.mDeviceOwner.hasDeviceOwner() && this.mDeviceOwner.getDeviceOwnerPackageName().equals(packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDeviceOwner() {
        if (!this.mHasFeature) {
            return null;
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (this.mDeviceOwner != null && this.mDeviceOwner.hasDeviceOwner()) {
                return this.mDeviceOwner.getDeviceOwnerPackageName();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDeviceOwnerName() {
        if (!this.mHasFeature) {
            return null;
        }
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_USERS", null);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (this.mDeviceOwner == null || !this.mDeviceOwner.hasDeviceOwner()) {
                return null;
            }
            String deviceOwnerPackage = this.mDeviceOwner.getDeviceOwnerPackageName();
            return this.getApplicationLabel(deviceOwnerPackage, 0);
        }
    }

    private ActiveAdmin getDeviceOwnerAdmin() {
        String deviceOwnerPackageName = this.getDeviceOwner();
        if (deviceOwnerPackageName == null) {
            return null;
        }
        DevicePolicyData policy = this.getUserData(0);
        int n = policy.mAdminList.size();
        for (int i = 0; i < n; ++i) {
            ActiveAdmin admin = policy.mAdminList.get(i);
            if (!deviceOwnerPackageName.equals(admin.info.getPackageName())) continue;
            return admin;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearDeviceOwner(String packageName) {
        Preconditions.checkNotNull(packageName, "packageName is null");
        try {
            int uid = this.mContext.getPackageManager().getPackageUid(packageName, 0);
            if (uid != Binder.getCallingUid()) {
                throw new SecurityException("Invalid packageName");
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new SecurityException(e);
        }
        if (!this.isDeviceOwner(packageName)) {
            throw new SecurityException("clearDeviceOwner can only be called by the device owner");
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.clearUserPoliciesLocked(new UserHandle(0));
            if (this.mDeviceOwner != null) {
                this.mDeviceOwner.clearDeviceOwner();
                this.mDeviceOwner.writeOwnerFile();
                this.updateDeviceOwnerLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setDeviceInitializer(ComponentName who, ComponentName initializer) {
        boolean isInitializerSystemApp;
        if (!this.mHasFeature) {
            return false;
        }
        if (initializer == null || !DeviceOwner.isInstalled(initializer.getPackageName(), this.mContext.getPackageManager())) {
            throw new IllegalArgumentException("Invalid component name " + initializer + " for device initializer");
        }
        try {
            isInitializerSystemApp = this.isSystemApp(AppGlobals.getPackageManager(), initializer.getPackageName(), Binder.getCallingUserHandle().getIdentifier());
        }
        catch (RemoteException | IllegalArgumentException e) {
            isInitializerSystemApp = false;
            Slog.e(LOG_TAG, "Fail to check if device initialzer is system app.", e);
        }
        if (!isInitializerSystemApp) {
            throw new IllegalArgumentException("Only system app can be set as device initializer.");
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.enforceCanSetDeviceInitializer(who);
            if (this.mDeviceOwner != null && this.mDeviceOwner.hasDeviceInitializer()) {
                throw new IllegalStateException("Trying to set device initializer but device initializer is already set.");
            }
            if (this.mDeviceOwner == null) {
                this.mDeviceOwner = DeviceOwner.createWithDeviceInitializer(initializer);
            } else {
                this.mDeviceOwner.setDeviceInitializer(initializer);
            }
            this.addDeviceInitializerToLockTaskPackagesLocked(0);
            this.mDeviceOwner.writeOwnerFile();
            return true;
        }
    }

    private void enforceCanSetDeviceInitializer(ComponentName who) {
        if (who == null) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_DEVICE_ADMINS", null);
            if (this.hasUserSetupCompleted(0)) {
                throw new IllegalStateException("Trying to set device initializer but device is already provisioned.");
            }
        } else {
            this.getActiveAdminForCallerLocked(who, -2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDeviceInitializer(String packageName) {
        if (!this.mHasFeature) {
            return false;
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            return this.mDeviceOwner != null && this.mDeviceOwner.hasDeviceInitializer() && this.mDeviceOwner.getDeviceInitializerPackageName().equals(packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDeviceInitializer() {
        if (!this.mHasFeature) {
            return null;
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (this.mDeviceOwner != null && this.mDeviceOwner.hasDeviceInitializer()) {
                return this.mDeviceOwner.getDeviceInitializerPackageName();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComponentName getDeviceInitializerComponent() {
        if (!this.mHasFeature) {
            return null;
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (this.mDeviceOwner != null && this.mDeviceOwner.hasDeviceInitializer()) {
                return this.mDeviceOwner.getDeviceInitializerComponent();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearDeviceInitializer(ComponentName who) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        ActiveAdmin admin = this.getActiveAdminUncheckedLocked(who, UserHandle.getCallingUserId());
        if (admin.getUid() != Binder.getCallingUid()) {
            throw new SecurityException("Admin " + who + " is not owned by uid " + Binder.getCallingUid());
        }
        if (!this.isDeviceInitializer(admin.info.getPackageName()) && !this.isDeviceOwner(admin.info.getPackageName())) {
            throw new SecurityException("clearDeviceInitializer can only be called by the device initializer/owner");
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            long ident = Binder.clearCallingIdentity();
            try {
                if (this.mDeviceOwner != null) {
                    this.mDeviceOwner.clearDeviceInitializer();
                    this.mDeviceOwner.writeOwnerFile();
                }
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setProfileOwner(ComponentName who, String ownerName, int userHandle) {
        if (!this.mHasFeature) {
            return false;
        }
        if (who == null || !DeviceOwner.isInstalledForUser(who.getPackageName(), userHandle)) {
            throw new IllegalArgumentException("Component " + who + " not installed for userId:" + userHandle);
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.enforceCanSetProfileOwner(userHandle);
            if (this.mDeviceOwner == null) {
                this.mDeviceOwner = DeviceOwner.createWithProfileOwner(who, ownerName, userHandle);
            } else {
                this.mDeviceOwner.setProfileOwner(who, ownerName, userHandle);
            }
            this.mDeviceOwner.writeOwnerFile();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearProfileOwner(ComponentName who) {
        if (!this.mHasFeature) {
            return;
        }
        UserHandle callingUser = Binder.getCallingUserHandle();
        this.getActiveAdminForCallerLocked(who, -1);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.clearUserPoliciesLocked(callingUser);
            if (this.mDeviceOwner != null) {
                this.mDeviceOwner.removeProfileOwner(callingUser.getIdentifier());
                this.mDeviceOwner.writeOwnerFile();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearUserPoliciesLocked(UserHandle userHandle) {
        int userId = userHandle.getIdentifier();
        DevicePolicyData policy = this.getUserData(userId);
        policy.mPermissionPolicy = 0;
        policy.mDelegatedCertInstallerPackage = null;
        policy.mStatusBarDisabled = false;
        this.saveSettingsLocked(userId);
        long ident = Binder.clearCallingIdentity();
        try {
            this.clearUserRestrictions(userHandle);
            AppGlobals.getPackageManager().updatePermissionFlagsForAllApps(4, 0, userHandle.getIdentifier());
        }
        catch (RemoteException re) {
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private void clearUserRestrictions(UserHandle userHandle) {
        Bundle userRestrictions = this.mUserManager.getUserRestrictions();
        this.mUserManager.setUserRestrictions(new Bundle(), userHandle);
        IAudioService iAudioService = IAudioService.Stub.asInterface(ServiceManager.getService("audio"));
        if (userRestrictions.getBoolean("no_adjust_volume")) {
            try {
                iAudioService.setMasterMute(true, 0, this.mContext.getPackageName(), userHandle.getIdentifier());
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
        if (userRestrictions.getBoolean("no_unmute_microphone")) {
            try {
                iAudioService.setMicrophoneMute(true, this.mContext.getPackageName(), userHandle.getIdentifier());
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean hasUserSetupCompleted() {
        return this.hasUserSetupCompleted(UserHandle.getCallingUserId());
    }

    private boolean hasUserSetupCompleted(int userHandle) {
        if (!this.mHasFeature) {
            return true;
        }
        DevicePolicyData policy = this.getUserData(userHandle);
        return policy == null || policy.mUserSetupComplete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean setUserEnabled(ComponentName who) {
        if (!this.mHasFeature) {
            return false;
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who == null) {
                throw new NullPointerException("ComponentName is null");
            }
            int userId = UserHandle.getCallingUserId();
            ActiveAdmin activeAdmin = this.getActiveAdminForCallerLocked(who, -1);
            if (!this.isDeviceInitializer(activeAdmin.info.getPackageName())) {
                throw new SecurityException("This method can only be called by device initializers");
            }
            long id2 = Binder.clearCallingIdentity();
            try {
                if (!this.isDeviceOwner(activeAdmin.info.getPackageName())) {
                    IPackageManager ipm = AppGlobals.getPackageManager();
                    ipm.setComponentEnabledSetting(who, 2, 1, userId);
                    this.removeActiveAdmin(who, userId);
                }
                if (userId == 0) {
                    Settings.Global.putInt(this.mContext.getContentResolver(), "device_provisioned", 1);
                }
                Settings.Secure.putIntForUser(this.mContext.getContentResolver(), "user_setup_complete", 1, userId);
            }
            catch (RemoteException e) {
                boolean bl;
                try {
                    Log.i(LOG_TAG, "Can't talk to package manager", e);
                    bl = false;
                }
                catch (Throwable throwable) {
                    DevicePolicyManagerService.restoreCallingIdentity(id2);
                    throw throwable;
                }
                DevicePolicyManagerService.restoreCallingIdentity(id2);
                return bl;
            }
            DevicePolicyManagerService.restoreCallingIdentity(id2);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProfileEnabled(ComponentName who) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userHandle = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(who, -1);
            int userId = UserHandle.getCallingUserId();
            long id2 = Binder.clearCallingIdentity();
            try {
                this.mUserManager.setUserEnabled(userId);
                Intent intent = new Intent("android.intent.action.MANAGED_PROFILE_ADDED");
                intent.putExtra("android.intent.extra.USER", new UserHandle(userHandle));
                intent.addFlags(0x50000000);
                this.mContext.sendBroadcastAsUser(intent, UserHandle.OWNER);
            }
            finally {
                DevicePolicyManagerService.restoreCallingIdentity(id2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProfileName(ComponentName who, String profileName) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userId = UserHandle.getCallingUserId();
        this.getActiveAdminForCallerLocked(who, -1);
        long id2 = Binder.clearCallingIdentity();
        try {
            this.mUserManager.setUserName(userId, profileName);
        }
        finally {
            DevicePolicyManagerService.restoreCallingIdentity(id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComponentName getProfileOwner(int userHandle) {
        if (!this.mHasFeature) {
            return null;
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (this.mDeviceOwner != null) {
                return this.mDeviceOwner.getProfileOwnerComponent(userHandle);
            }
        }
        return null;
    }

    private ActiveAdmin getProfileOwnerAdmin(int userHandle) {
        ComponentName profileOwner;
        ComponentName componentName = profileOwner = this.mDeviceOwner != null ? this.mDeviceOwner.getProfileOwnerComponent(userHandle) : null;
        if (profileOwner == null) {
            return null;
        }
        DevicePolicyData policy = this.getUserData(userHandle);
        int n = policy.mAdminList.size();
        for (int i = 0; i < n; ++i) {
            ActiveAdmin admin = policy.mAdminList.get(i);
            if (!profileOwner.equals(admin.info.getComponent())) continue;
            return admin;
        }
        return null;
    }

    @Override
    public String getProfileOwnerName(int userHandle) {
        if (!this.mHasFeature) {
            return null;
        }
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_USERS", null);
        ComponentName profileOwner = this.getProfileOwner(userHandle);
        if (profileOwner == null) {
            return null;
        }
        return this.getApplicationLabel(profileOwner.getPackageName(), userHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getApplicationLabel(String packageName, int userHandle) {
        long token = Binder.clearCallingIdentity();
        try {
            Context userContext;
            try {
                UserHandle handle = new UserHandle(userHandle);
                userContext = this.mContext.createPackageContextAsUser(packageName, 0, handle);
            }
            catch (PackageManager.NameNotFoundException nnfe) {
                Log.w(LOG_TAG, packageName + " is not installed for user " + userHandle, nnfe);
                String string2 = null;
                Binder.restoreCallingIdentity(token);
                return string2;
            }
            ApplicationInfo appInfo = userContext.getApplicationInfo();
            CharSequence result = null;
            if (appInfo != null) {
                PackageManager pm = userContext.getPackageManager();
                result = pm.getApplicationLabel(appInfo);
            }
            String string3 = result != null ? result.toString() : null;
            return string3;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private void enforceCanSetProfileOwner(int userHandle) {
        UserInfo info = this.mUserManager.getUserInfo(userHandle);
        if (info == null) {
            throw new IllegalArgumentException("Attempted to set profile owner for invalid userId: " + userHandle);
        }
        if (info.isGuest()) {
            throw new IllegalStateException("Cannot set a profile owner on a guest");
        }
        if (this.getProfileOwner(userHandle) != null) {
            throw new IllegalStateException("Trying to set the profile owner, but profile owner is already set.");
        }
        int callingUid = Binder.getCallingUid();
        if (callingUid == 2000 || callingUid == 0) {
            if (this.hasUserSetupCompleted(userHandle) && AccountManager.get(this.mContext).getAccountsAsUser(userHandle).length > 0) {
                throw new IllegalStateException("Not allowed to set the profile owner because there are already some accounts on the profile");
            }
            return;
        }
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_PROFILE_AND_DEVICE_OWNERS", null);
        if (this.hasUserSetupCompleted(userHandle) && UserHandle.getAppId(callingUid) != 1000) {
            throw new IllegalStateException("Cannot set the profile owner on a user which is already set-up");
        }
    }

    private void enforceCanSetDeviceOwner() {
        if (this.mDeviceOwner != null && this.mDeviceOwner.hasDeviceOwner()) {
            throw new IllegalStateException("Trying to set the device owner, but device owner is already set.");
        }
        int callingUid = Binder.getCallingUid();
        if (callingUid == 2000 || callingUid == 0) {
            if (!this.hasUserSetupCompleted(0)) {
                return;
            }
            if (this.mUserManager.getUserCount() > 1) {
                throw new IllegalStateException("Not allowed to set the device owner because there are already several users on the device");
            }
            if (AccountManager.get(this.mContext).getAccounts().length > 0) {
                throw new IllegalStateException("Not allowed to set the device owner because there are already some accounts on the device");
            }
            return;
        }
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_PROFILE_AND_DEVICE_OWNERS", null);
        if (this.hasUserSetupCompleted(0)) {
            throw new IllegalStateException("Cannot set the device owner if the device is already set-up");
        }
    }

    private void enforceCrossUserPermission(int userHandle) {
        if (userHandle < 0) {
            throw new IllegalArgumentException("Invalid userId " + userHandle);
        }
        int callingUid = Binder.getCallingUid();
        if (userHandle == UserHandle.getUserId(callingUid)) {
            return;
        }
        if (callingUid != 1000 && callingUid != 0) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL", "Must be system or have INTERACT_ACROSS_USERS_FULL permission");
        }
    }

    private void enforceSystemProcess(String message) {
        if (Binder.getCallingUid() != 1000) {
            throw new SecurityException(message);
        }
    }

    private void enforceNotManagedProfile(int userHandle, String message) {
        if (this.isManagedProfile(userHandle)) {
            throw new SecurityException("You can not " + message + " for a managed profile. ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserInfo getProfileParent(int userHandle) {
        long ident = Binder.clearCallingIdentity();
        try {
            UserInfo userInfo = this.mUserManager.getProfileParent(userHandle);
            return userInfo;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isManagedProfile(int userHandle) {
        long ident = Binder.clearCallingIdentity();
        try {
            boolean bl = this.mUserManager.getUserInfo(userHandle).isManagedProfile();
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private void enableIfNecessary(String packageName, int userId) {
        try {
            IPackageManager ipm = AppGlobals.getPackageManager();
            ApplicationInfo ai = ipm.getApplicationInfo(packageName, 32768, userId);
            if (ai.enabledSetting == 4) {
                ipm.setApplicationEnabledSetting(packageName, 0, 1, userId, "DevicePolicyManager");
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump DevicePolicyManagerService from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        PrintWriterPrinter p = new PrintWriterPrinter(pw);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            p.println("Current Device Policy Manager state:");
            if (this.mDeviceOwner != null) {
                this.mDeviceOwner.dump("  ", pw);
            }
            int userCount = this.mUserData.size();
            for (int u = 0; u < userCount; ++u) {
                DevicePolicyData policy = this.getUserData(this.mUserData.keyAt(u));
                p.println("  Enabled Device Admins (User " + policy.mUserHandle + "):");
                int N = policy.mAdminList.size();
                for (int i = 0; i < N; ++i) {
                    ActiveAdmin ap = policy.mAdminList.get(i);
                    if (ap == null) continue;
                    pw.print("  ");
                    pw.print(ap.info.getComponent().flattenToShortString());
                    pw.println(":");
                    ap.dump("    ", pw);
                }
                if (!policy.mRemovingAdmins.isEmpty()) {
                    p.println("  Removing Device Admins (User " + policy.mUserHandle + "): " + policy.mRemovingAdmins);
                }
                pw.println(" ");
                pw.print("  mPasswordOwner=");
                pw.println(policy.mPasswordOwner);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPersistentPreferredActivity(ComponentName who, IntentFilter filter, ComponentName activity) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userHandle = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(who, -1);
            IPackageManager pm = AppGlobals.getPackageManager();
            long id2 = Binder.clearCallingIdentity();
            try {
                pm.addPersistentPreferredActivity(filter, activity, userHandle);
            }
            catch (RemoteException re) {
            }
            finally {
                DevicePolicyManagerService.restoreCallingIdentity(id2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearPackagePersistentPreferredActivities(ComponentName who, String packageName) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userHandle = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(who, -1);
            IPackageManager pm = AppGlobals.getPackageManager();
            long id2 = Binder.clearCallingIdentity();
            try {
                pm.clearPackagePersistentPreferredActivities(packageName, userHandle);
            }
            catch (RemoteException re) {
            }
            finally {
                DevicePolicyManagerService.restoreCallingIdentity(id2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setApplicationRestrictions(ComponentName who, String packageName, Bundle settings) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        UserHandle userHandle = new UserHandle(UserHandle.getCallingUserId());
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(who, -1);
            long id2 = Binder.clearCallingIdentity();
            try {
                this.mUserManager.setApplicationRestrictions(packageName, settings, userHandle);
            }
            finally {
                DevicePolicyManagerService.restoreCallingIdentity(id2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTrustAgentConfiguration(ComponentName admin, ComponentName agent, PersistableBundle args) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(admin, "admin is null");
        Preconditions.checkNotNull(agent, "agent is null");
        int userHandle = UserHandle.getCallingUserId();
        this.enforceNotManagedProfile(userHandle, "set trust agent configuration");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(admin, 9);
            ap.trustAgentInfos.put(agent.flattenToString(), new ActiveAdmin.TrustAgentInfo(args));
            this.saveSettingsLocked(userHandle);
            this.syncDeviceCapabilitiesLocked(this.getUserData(userHandle));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PersistableBundle> getTrustAgentConfiguration(ComponentName admin, ComponentName agent, int userHandle) {
        if (!this.mHasFeature) {
            return null;
        }
        Preconditions.checkNotNull(agent, "agent null");
        this.enforceCrossUserPermission(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            String componentName = agent.flattenToString();
            if (admin != null) {
                ActiveAdmin ap = this.getActiveAdminUncheckedLocked(admin, userHandle);
                if (ap == null) {
                    return null;
                }
                ActiveAdmin.TrustAgentInfo trustAgentInfo = ap.trustAgentInfos.get(componentName);
                if (trustAgentInfo == null || trustAgentInfo.options == null) {
                    return null;
                }
                ArrayList<PersistableBundle> result = new ArrayList<PersistableBundle>();
                result.add(trustAgentInfo.options);
                return result;
            }
            List<UserInfo> profiles = this.mUserManager.getProfiles(userHandle);
            ArrayList<PersistableBundle> result = null;
            boolean allAdminsHaveOptions = true;
            block3: for (UserInfo userInfo : profiles) {
                DevicePolicyData policy = this.getUserDataUnchecked(userInfo.id);
                int N = policy.mAdminList.size();
                for (int i = 0; i < N; ++i) {
                    ActiveAdmin active = policy.mAdminList.get(i);
                    boolean disablesTrust = (active.disabledKeyguardFeatures & 0x10) != 0;
                    ActiveAdmin.TrustAgentInfo info = active.trustAgentInfos.get(componentName);
                    if (info != null && info.options != null && !info.options.isEmpty()) {
                        if (disablesTrust) {
                            if (result == null) {
                                result = new ArrayList<PersistableBundle>();
                            }
                            result.add(info.options);
                            continue;
                        }
                        Log.w(LOG_TAG, "Ignoring admin " + active.info + " because it has trust options but doesn't declare " + "KEYGUARD_DISABLE_TRUST_AGENTS");
                        continue;
                    }
                    if (!disablesTrust) continue;
                    allAdminsHaveOptions = false;
                    continue block3;
                }
            }
            return allAdminsHaveOptions ? result : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRestrictionsProvider(ComponentName who, ComponentName permissionProvider) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(who, -1);
            int userHandle = UserHandle.getCallingUserId();
            DevicePolicyData userData = this.getUserData(userHandle);
            userData.mRestrictionsProvider = permissionProvider;
            this.saveSettingsLocked(userHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComponentName getRestrictionsProvider(int userHandle) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (Binder.getCallingUid() != 1000) {
                throw new SecurityException("Only the system can query the permission provider");
            }
            DevicePolicyData userData = this.getUserData(userHandle);
            ComponentName componentName = userData != null ? userData.mRestrictionsProvider : null;
            return componentName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCrossProfileIntentFilter(ComponentName who, IntentFilter filter, int flags) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        int callingUserId = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(who, -1);
            IPackageManager pm = AppGlobals.getPackageManager();
            long id2 = Binder.clearCallingIdentity();
            try {
                if ((flags & 1) != 0) {
                    pm.addCrossProfileIntentFilter(filter, who.getPackageName(), callingUserId, 0, 0);
                }
                if ((flags & 2) != 0) {
                    pm.addCrossProfileIntentFilter(filter, who.getPackageName(), 0, callingUserId, 0);
                }
            }
            catch (RemoteException re) {
            }
            finally {
                DevicePolicyManagerService.restoreCallingIdentity(id2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCrossProfileIntentFilters(ComponentName who) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        int callingUserId = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(who, -1);
            IPackageManager pm = AppGlobals.getPackageManager();
            long id2 = Binder.clearCallingIdentity();
            try {
                pm.clearCrossProfileIntentFilters(callingUserId, who.getPackageName());
                pm.clearCrossProfileIntentFilters(0, who.getPackageName());
            }
            catch (RemoteException re) {
            }
            finally {
                DevicePolicyManagerService.restoreCallingIdentity(id2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkPackagesInPermittedListOrSystem(List<String> enabledPackages, List<String> permittedList) {
        int userIdToCheck = UserHandle.getCallingUserId();
        long id2 = Binder.clearCallingIdentity();
        try {
            UserInfo user = this.mUserManager.getUserInfo(userIdToCheck);
            if (user.isManagedProfile()) {
                userIdToCheck = user.profileGroupId;
            }
            IPackageManager pm = AppGlobals.getPackageManager();
            for (String enabledPackage : enabledPackages) {
                boolean systemService = false;
                try {
                    ApplicationInfo applicationInfo = pm.getApplicationInfo(enabledPackage, 8192, userIdToCheck);
                    systemService = (applicationInfo.flags & 1) != 0;
                }
                catch (RemoteException e) {
                    Log.i(LOG_TAG, "Can't talk to package managed", e);
                }
                if (systemService || permittedList.contains(enabledPackage)) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            DevicePolicyManagerService.restoreCallingIdentity(id2);
        }
        return true;
    }

    private AccessibilityManager getAccessibilityManagerForUser(int userId) {
        IBinder iBinder = ServiceManager.getService("accessibility");
        IAccessibilityManager service = iBinder == null ? null : IAccessibilityManager.Stub.asInterface(iBinder);
        return new AccessibilityManager(this.mContext, service, userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setPermittedAccessibilityServices(ComponentName who, List packageList) {
        if (!this.mHasFeature) {
            return false;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        if (packageList != null) {
            int userId = UserHandle.getCallingUserId();
            List<AccessibilityServiceInfo> enabledServices = null;
            long id2 = Binder.clearCallingIdentity();
            try {
                UserInfo user = this.mUserManager.getUserInfo(userId);
                if (user.isManagedProfile()) {
                    userId = user.profileGroupId;
                }
                AccessibilityManager accessibilityManager = this.getAccessibilityManagerForUser(userId);
                enabledServices = accessibilityManager.getEnabledAccessibilityServiceList(-1);
            }
            finally {
                DevicePolicyManagerService.restoreCallingIdentity(id2);
            }
            if (enabledServices != null) {
                ArrayList<String> enabledPackages = new ArrayList<String>();
                for (AccessibilityServiceInfo service : enabledServices) {
                    enabledPackages.add(service.getResolveInfo().serviceInfo.packageName);
                }
                if (!this.checkPackagesInPermittedListOrSystem(enabledPackages, packageList)) {
                    Slog.e(LOG_TAG, "Cannot set permitted accessibility services, because it contains already enabled accesibility services.");
                    return false;
                }
            }
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, -1);
            admin.permittedAccessiblityServices = packageList;
            this.saveSettingsLocked(UserHandle.getCallingUserId());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getPermittedAccessibilityServices(ComponentName who) {
        if (!this.mHasFeature) {
            return null;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, -1);
            return admin.permittedAccessiblityServices;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getPermittedAccessibilityServicesForUser(int userId) {
        if (!this.mHasFeature) {
            return null;
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ArrayList<String> result = null;
            List<UserInfo> profiles = this.mUserManager.getProfiles(userId);
            int PROFILES_SIZE = profiles.size();
            for (int i = 0; i < PROFILES_SIZE; ++i) {
                DevicePolicyData policy = this.getUserDataUnchecked(profiles.get((int)i).id);
                int N = policy.mAdminList.size();
                for (int j = 0; j < N; ++j) {
                    ActiveAdmin admin = policy.mAdminList.get(j);
                    List<String> fromAdmin = admin.permittedAccessiblityServices;
                    if (fromAdmin == null) continue;
                    if (result == null) {
                        result = new ArrayList<String>(fromAdmin);
                        continue;
                    }
                    result.retainAll(fromAdmin);
                }
            }
            if (result != null) {
                long id2 = Binder.clearCallingIdentity();
                try {
                    UserInfo user = this.mUserManager.getUserInfo(userId);
                    if (user.isManagedProfile()) {
                        userId = user.profileGroupId;
                    }
                    AccessibilityManager accessibilityManager = this.getAccessibilityManagerForUser(userId);
                    List<AccessibilityServiceInfo> installedServices = accessibilityManager.getInstalledAccessibilityServiceList();
                    IPackageManager pm = AppGlobals.getPackageManager();
                    if (installedServices != null) {
                        for (AccessibilityServiceInfo service : installedServices) {
                            ServiceInfo serviceInfo = service.getResolveInfo().serviceInfo;
                            ApplicationInfo applicationInfo = serviceInfo.applicationInfo;
                            if ((applicationInfo.flags & 1) == 0) continue;
                            result.add(serviceInfo.packageName);
                        }
                    }
                }
                finally {
                    DevicePolicyManagerService.restoreCallingIdentity(id2);
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkCallerIsCurrentUserOrProfile() {
        int callingUserId = UserHandle.getCallingUserId();
        long token = Binder.clearCallingIdentity();
        try {
            UserInfo currentUser;
            UserInfo callingUser = this.mUserManager.getUserInfo(callingUserId);
            try {
                currentUser = ActivityManagerNative.getDefault().getCurrentUser();
            }
            catch (RemoteException e) {
                Slog.e(LOG_TAG, "Failed to talk to activity managed.", e);
                boolean bl = false;
                Binder.restoreCallingIdentity(token);
                return bl;
            }
            if (callingUser.isManagedProfile() && callingUser.profileGroupId != currentUser.id) {
                Slog.e(LOG_TAG, "Cannot set permitted input methods for managed profile of a user that isn't the foreground user.");
                boolean bl = false;
                return bl;
            }
            if (!callingUser.isManagedProfile() && callingUserId != currentUser.id) {
                Slog.e(LOG_TAG, "Cannot set permitted input methods of a user that isn't the foreground user.");
                boolean bl = false;
                return bl;
            }
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setPermittedInputMethods(ComponentName who, List packageList) {
        InputMethodManager inputMethodManager;
        List<InputMethodInfo> enabledImes;
        if (!this.mHasFeature) {
            return false;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        if (!this.checkCallerIsCurrentUserOrProfile()) {
            return false;
        }
        if (packageList != null && (enabledImes = (inputMethodManager = (InputMethodManager)this.mContext.getSystemService("input_method")).getEnabledInputMethodList()) != null) {
            ArrayList<String> enabledPackages = new ArrayList<String>();
            for (InputMethodInfo ime : enabledImes) {
                enabledPackages.add(ime.getPackageName());
            }
            if (!this.checkPackagesInPermittedListOrSystem(enabledPackages, packageList)) {
                Slog.e(LOG_TAG, "Cannot set permitted input methods, because it contains already enabled input method.");
                return false;
            }
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, -1);
            admin.permittedInputMethods = packageList;
            this.saveSettingsLocked(UserHandle.getCallingUserId());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getPermittedInputMethods(ComponentName who) {
        if (!this.mHasFeature) {
            return null;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, -1);
            return admin.permittedInputMethods;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getPermittedInputMethodsForCurrentUser() {
        UserInfo currentUser;
        try {
            currentUser = ActivityManagerNative.getDefault().getCurrentUser();
        }
        catch (RemoteException e) {
            Slog.e(LOG_TAG, "Failed to make remote calls to get current user", e);
            return null;
        }
        int userId = currentUser.id;
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ArrayList<String> result = null;
            List<UserInfo> profiles = this.mUserManager.getProfiles(userId);
            int PROFILES_SIZE = profiles.size();
            for (int i = 0; i < PROFILES_SIZE; ++i) {
                DevicePolicyData policy = this.getUserDataUnchecked(profiles.get((int)i).id);
                int N = policy.mAdminList.size();
                for (int j = 0; j < N; ++j) {
                    ActiveAdmin admin = policy.mAdminList.get(j);
                    List<String> fromAdmin = admin.permittedInputMethods;
                    if (fromAdmin == null) continue;
                    if (result == null) {
                        result = new ArrayList<String>(fromAdmin);
                        continue;
                    }
                    result.retainAll(fromAdmin);
                }
            }
            if (result != null) {
                InputMethodManager inputMethodManager = (InputMethodManager)this.mContext.getSystemService("input_method");
                List<InputMethodInfo> imes = inputMethodManager.getInputMethodList();
                long id2 = Binder.clearCallingIdentity();
                try {
                    IPackageManager pm = AppGlobals.getPackageManager();
                    if (imes != null) {
                        for (InputMethodInfo ime : imes) {
                            ServiceInfo serviceInfo = ime.getServiceInfo();
                            ApplicationInfo applicationInfo = serviceInfo.applicationInfo;
                            if ((applicationInfo.flags & 1) == 0) continue;
                            result.add(serviceInfo.packageName);
                        }
                    }
                }
                finally {
                    DevicePolicyManagerService.restoreCallingIdentity(id2);
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public UserHandle createUser(ComponentName who, String name) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(who, -2);
            long id2 = Binder.clearCallingIdentity();
            try {
                UserInfo userInfo = this.mUserManager.createUser(name, 0);
                if (userInfo != null) {
                    UserHandle userHandle = userInfo.getUserHandle();
                    return userHandle;
                }
                UserHandle userHandle = null;
                return userHandle;
            }
            finally {
                DevicePolicyManagerService.restoreCallingIdentity(id2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserHandle createAndInitializeUser(ComponentName who, String name, String ownerName, ComponentName profileOwnerComponent, Bundle adminExtras) {
        UserHandle user = this.createUser(who, name);
        if (user == null) {
            return null;
        }
        long id2 = Binder.clearCallingIdentity();
        try {
            String profileOwnerPkg = profileOwnerComponent.getPackageName();
            IPackageManager ipm = AppGlobals.getPackageManager();
            IActivityManager activityManager = ActivityManagerNative.getDefault();
            int userHandle = user.getIdentifier();
            try {
                if (!ipm.isPackageAvailable(profileOwnerPkg, userHandle)) {
                    ipm.installExistingPackageAsUser(profileOwnerPkg, userHandle);
                }
                activityManager.startUserInBackground(userHandle);
            }
            catch (RemoteException e) {
                Slog.e(LOG_TAG, "Failed to make remote calls for configureUser", e);
            }
            this.setActiveAdmin(profileOwnerComponent, true, userHandle, adminExtras);
            this.setProfileOwner(profileOwnerComponent, ownerName, userHandle);
            UserHandle userHandle2 = user;
            return userHandle2;
        }
        finally {
            DevicePolicyManagerService.restoreCallingIdentity(id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeUser(ComponentName who, UserHandle userHandle) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            boolean bl;
            this.getActiveAdminForCallerLocked(who, -2);
            long id2 = Binder.clearCallingIdentity();
            try {
                bl = this.mUserManager.removeUser(userHandle.getIdentifier());
            }
            catch (Throwable throwable) {
                DevicePolicyManagerService.restoreCallingIdentity(id2);
                throw throwable;
            }
            DevicePolicyManagerService.restoreCallingIdentity(id2);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean switchUser(ComponentName who, UserHandle userHandle) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            boolean bl;
            this.getActiveAdminForCallerLocked(who, -2);
            long id2 = Binder.clearCallingIdentity();
            try {
                int userId = 0;
                if (userHandle != null) {
                    userId = userHandle.getIdentifier();
                }
                bl = ActivityManagerNative.getDefault().switchUser(userId);
            }
            catch (RemoteException e) {
                boolean bl2;
                try {
                    Log.e(LOG_TAG, "Couldn't switch user", e);
                    bl2 = false;
                }
                catch (Throwable throwable) {
                    DevicePolicyManagerService.restoreCallingIdentity(id2);
                    throw throwable;
                }
                DevicePolicyManagerService.restoreCallingIdentity(id2);
                return bl2;
            }
            DevicePolicyManagerService.restoreCallingIdentity(id2);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bundle getApplicationRestrictions(ComponentName who, String packageName) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        UserHandle userHandle = new UserHandle(UserHandle.getCallingUserId());
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            Bundle bundle;
            this.getActiveAdminForCallerLocked(who, -1);
            long id2 = Binder.clearCallingIdentity();
            try {
                Bundle bundle2 = this.mUserManager.getApplicationRestrictions(packageName, userHandle);
                bundle = bundle2 != null ? bundle2 : Bundle.EMPTY;
            }
            catch (Throwable throwable) {
                DevicePolicyManagerService.restoreCallingIdentity(id2);
                throw throwable;
            }
            DevicePolicyManagerService.restoreCallingIdentity(id2);
            return bundle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserRestriction(ComponentName who, String key, boolean enabled) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        UserHandle user = new UserHandle(UserHandle.getCallingUserId());
        int userHandle = user.getIdentifier();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin activeAdmin = this.getActiveAdminForCallerLocked(who, -1);
            boolean isDeviceOwner = this.isDeviceOwner(activeAdmin.info.getPackageName());
            if (!isDeviceOwner && userHandle != 0 && DEVICE_OWNER_USER_RESTRICTIONS.contains(key)) {
                throw new SecurityException("Profile owners cannot set user restriction " + key);
            }
            if (IMMUTABLE_USER_RESTRICTIONS.contains(key)) {
                throw new SecurityException("User restriction " + key + " cannot be changed");
            }
            boolean alreadyRestricted = this.mUserManager.hasUserRestriction(key, user);
            IAudioService iAudioService = null;
            if ("no_unmute_microphone".equals(key) || "no_adjust_volume".equals(key)) {
                iAudioService = IAudioService.Stub.asInterface(ServiceManager.getService("audio"));
            }
            long id2 = Binder.clearCallingIdentity();
            try {
                if (enabled && !alreadyRestricted) {
                    if ("no_unmute_microphone".equals(key)) {
                        iAudioService.setMicrophoneMute(true, this.mContext.getPackageName(), userHandle);
                    } else if ("no_adjust_volume".equals(key)) {
                        iAudioService.setMasterMute(true, 0, this.mContext.getPackageName(), userHandle);
                    }
                    if ("no_config_wifi".equals(key)) {
                        Settings.Secure.putIntForUser(this.mContext.getContentResolver(), "wifi_networks_available_notification_on", 0, userHandle);
                    } else if ("no_share_location".equals(key)) {
                        Settings.Secure.putIntForUser(this.mContext.getContentResolver(), "location_mode", 0, userHandle);
                        Settings.Secure.putStringForUser(this.mContext.getContentResolver(), "location_providers_allowed", "", userHandle);
                    } else if ("no_debugging_features".equals(key)) {
                        if (userHandle == 0) {
                            Settings.Global.putStringForUser(this.mContext.getContentResolver(), "adb_enabled", "0", userHandle);
                        }
                    } else if ("ensure_verify_apps".equals(key)) {
                        Settings.Global.putStringForUser(this.mContext.getContentResolver(), "package_verifier_enable", "1", userHandle);
                        Settings.Global.putStringForUser(this.mContext.getContentResolver(), "verifier_verify_adb_installs", "1", userHandle);
                    } else if ("no_install_unknown_sources".equals(key)) {
                        Settings.Secure.putIntForUser(this.mContext.getContentResolver(), "install_non_market_apps", 0, userHandle);
                    }
                }
                this.mUserManager.setUserRestriction(key, enabled, user);
                if (enabled != alreadyRestricted && "no_share_location".equals(key)) {
                    String property = "sys.settings_secure_version";
                    long version = SystemProperties.getLong("sys.settings_secure_version", 0L) + 1L;
                    SystemProperties.set("sys.settings_secure_version", Long.toString(version));
                    String name = "location_providers_allowed";
                    Uri url = Uri.withAppendedPath(Settings.Secure.CONTENT_URI, "location_providers_allowed");
                    this.mContext.getContentResolver().notifyChange(url, null, true, userHandle);
                }
                if (!enabled && alreadyRestricted) {
                    if ("no_unmute_microphone".equals(key)) {
                        iAudioService.setMicrophoneMute(false, this.mContext.getPackageName(), userHandle);
                    } else if ("no_adjust_volume".equals(key)) {
                        iAudioService.setMasterMute(false, 0, this.mContext.getPackageName(), userHandle);
                    }
                }
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Failed to talk to AudioService.", re);
            }
            finally {
                DevicePolicyManagerService.restoreCallingIdentity(id2);
            }
            this.sendChangedNotification(userHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean setApplicationHidden(ComponentName who, String packageName, boolean hidden) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        int callingUserId = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(who, -1);
            long id2 = Binder.clearCallingIdentity();
            try {
                IPackageManager pm = AppGlobals.getPackageManager();
                boolean bl = pm.setApplicationHiddenSettingAsUser(packageName, hidden, callingUserId);
                return bl;
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Failed to setApplicationHiddenSetting", re);
            }
            finally {
                DevicePolicyManagerService.restoreCallingIdentity(id2);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isApplicationHidden(ComponentName who, String packageName) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        int callingUserId = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(who, -1);
            long id2 = Binder.clearCallingIdentity();
            try {
                IPackageManager pm = AppGlobals.getPackageManager();
                boolean bl = pm.getApplicationHiddenSettingAsUser(packageName, callingUserId);
                return bl;
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Failed to getApplicationHiddenSettingAsUser", re);
            }
            finally {
                DevicePolicyManagerService.restoreCallingIdentity(id2);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enableSystemApp(ComponentName who, String packageName) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(who, -1);
            int userId = UserHandle.getCallingUserId();
            long id2 = Binder.clearCallingIdentity();
            try {
                IPackageManager pm;
                UserManager um = UserManager.get(this.mContext);
                UserInfo primaryUser = um.getProfileParent(userId);
                if (primaryUser == null) {
                    primaryUser = um.getUserInfo(userId);
                }
                if (!this.isSystemApp(pm = AppGlobals.getPackageManager(), packageName, primaryUser.id)) {
                    throw new IllegalArgumentException("Only system apps can be enabled this way.");
                }
                pm.installExistingPackageAsUser(packageName, userId);
            }
            catch (RemoteException re) {
                Slog.wtf(LOG_TAG, "Failed to install " + packageName, re);
            }
            finally {
                DevicePolicyManagerService.restoreCallingIdentity(id2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int enableSystemAppWithIntent(ComponentName who, Intent intent) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            int n;
            this.getActiveAdminForCallerLocked(who, -1);
            int userId = UserHandle.getCallingUserId();
            long id2 = Binder.clearCallingIdentity();
            try {
                UserManager um = UserManager.get(this.mContext);
                UserInfo primaryUser = um.getProfileParent(userId);
                if (primaryUser == null) {
                    primaryUser = um.getUserInfo(userId);
                }
                IPackageManager pm = AppGlobals.getPackageManager();
                List<ResolveInfo> activitiesToEnable = pm.queryIntentActivities(intent, intent.resolveTypeIfNeeded(this.mContext.getContentResolver()), 0, primaryUser.id);
                int numberOfAppsInstalled = 0;
                if (activitiesToEnable != null) {
                    for (ResolveInfo info : activitiesToEnable) {
                        if (info.activityInfo == null) continue;
                        String packageName = info.activityInfo.packageName;
                        if (this.isSystemApp(pm, packageName, primaryUser.id)) {
                            ++numberOfAppsInstalled;
                            pm.installExistingPackageAsUser(packageName, userId);
                            continue;
                        }
                        Slog.d(LOG_TAG, "Not enabling " + packageName + " since is not a" + " system app");
                    }
                }
                n = numberOfAppsInstalled;
            }
            catch (RemoteException e) {
                int n2;
                try {
                    Slog.wtf(LOG_TAG, "Failed to resolve intent for: " + intent);
                    n2 = 0;
                }
                catch (Throwable throwable) {
                    DevicePolicyManagerService.restoreCallingIdentity(id2);
                    throw throwable;
                }
                DevicePolicyManagerService.restoreCallingIdentity(id2);
                return n2;
            }
            DevicePolicyManagerService.restoreCallingIdentity(id2);
            return n;
        }
    }

    private boolean isSystemApp(IPackageManager pm, String packageName, int userId) throws RemoteException {
        ApplicationInfo appInfo = pm.getApplicationInfo(packageName, 8192, userId);
        if (appInfo == null) {
            throw new IllegalArgumentException("The application " + packageName + " is not present on this device");
        }
        return (appInfo.flags & 1) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAccountManagementDisabled(ComponentName who, String accountType, boolean disabled) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin ap = this.getActiveAdminForCallerLocked(who, -1);
            if (disabled) {
                ap.accountTypesWithManagementDisabled.add(accountType);
            } else {
                ap.accountTypesWithManagementDisabled.remove(accountType);
            }
            this.saveSettingsLocked(UserHandle.getCallingUserId());
        }
    }

    @Override
    public String[] getAccountTypesWithManagementDisabled() {
        return this.getAccountTypesWithManagementDisabledAsUser(UserHandle.getCallingUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getAccountTypesWithManagementDisabledAsUser(int userId) {
        this.enforceCrossUserPermission(userId);
        if (!this.mHasFeature) {
            return null;
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            DevicePolicyData policy = this.getUserData(userId);
            int N = policy.mAdminList.size();
            HashSet<String> resultSet = new HashSet<String>();
            for (int i = 0; i < N; ++i) {
                ActiveAdmin admin = policy.mAdminList.get(i);
                resultSet.addAll(admin.accountTypesWithManagementDisabled);
            }
            return resultSet.toArray(new String[resultSet.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUninstallBlocked(ComponentName who, String packageName, boolean uninstallBlocked) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        int userId = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(who, -1);
            long id2 = Binder.clearCallingIdentity();
            try {
                IPackageManager pm = AppGlobals.getPackageManager();
                pm.setBlockUninstallForUser(packageName, uninstallBlocked, userId);
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Failed to setBlockUninstallForUser", re);
            }
            finally {
                DevicePolicyManagerService.restoreCallingIdentity(id2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isUninstallBlocked(ComponentName who, String packageName) {
        int userId = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            if (who != null) {
                this.getActiveAdminForCallerLocked(who, -1);
            }
            long id2 = Binder.clearCallingIdentity();
            try {
                IPackageManager pm = AppGlobals.getPackageManager();
                boolean bl = pm.getBlockUninstallForUser(packageName, userId);
                return bl;
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Failed to getBlockUninstallForUser", re);
            }
            finally {
                DevicePolicyManagerService.restoreCallingIdentity(id2);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCrossProfileCallerIdDisabled(ComponentName who, boolean disabled) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, -1);
            if (admin.disableCallerId != disabled) {
                admin.disableCallerId = disabled;
                this.saveSettingsLocked(UserHandle.getCallingUserId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getCrossProfileCallerIdDisabled(ComponentName who) {
        if (!this.mHasFeature) {
            return false;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, -1);
            return admin.disableCallerId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getCrossProfileCallerIdDisabledForUser(int userId) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getProfileOwnerAdmin(userId);
            return admin != null ? admin.disableCallerId : false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void startManagedQuickContact(String actualLookupKey, long actualContactId, Intent originalIntent) {
        int managedUserId;
        long ident;
        Intent intent;
        block9: {
            intent = ContactsContract.QuickContact.rebuildManagedQuickContactsIntent(actualLookupKey, actualContactId, originalIntent);
            int callingUserId = UserHandle.getCallingUserId();
            ident = Binder.clearCallingIdentity();
            DevicePolicyManagerService devicePolicyManagerService = this;
            // MONITORENTER : devicePolicyManagerService
            managedUserId = this.getManagedUserId(callingUserId);
            if (managedUserId >= 0) break block9;
            // MONITOREXIT : devicePolicyManagerService
            Binder.restoreCallingIdentity(ident);
            return;
        }
        if (this.getCrossProfileCallerIdDisabledForUser(managedUserId)) {
            // MONITOREXIT : devicePolicyManagerService
            Binder.restoreCallingIdentity(ident);
            return;
        }
        try {
            ContactsInternal.startQuickContactWithErrorToastForUser(this.mContext, intent, new UserHandle(managedUserId));
            // MONITOREXIT : devicePolicyManagerService
            return;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    public int getManagedUserId(int callingUserId) {
        for (UserInfo ui : this.mUserManager.getProfiles(callingUserId)) {
            if (ui.id == callingUserId || !ui.isManagedProfile()) continue;
            return ui.id;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBluetoothContactSharingDisabled(ComponentName who, boolean disabled) {
        if (!this.mHasFeature) {
            return;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, -1);
            if (admin.disableBluetoothContactSharing != disabled) {
                admin.disableBluetoothContactSharing = disabled;
                this.saveSettingsLocked(UserHandle.getCallingUserId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getBluetoothContactSharingDisabled(ComponentName who) {
        if (!this.mHasFeature) {
            return false;
        }
        Preconditions.checkNotNull(who, "ComponentName is null");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getActiveAdminForCallerLocked(who, -1);
            return admin.disableBluetoothContactSharing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getBluetoothContactSharingDisabledForUser(int userId) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin admin = this.getProfileOwnerAdmin(userId);
            return admin != null ? admin.disableBluetoothContactSharing : false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLockTaskPackages(ComponentName who, String[] packages) throws SecurityException {
        Preconditions.checkNotNull(who, "ComponentName is null");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(who, -2);
            int userHandle = Binder.getCallingUserHandle().getIdentifier();
            this.setLockTaskPackagesLocked(userHandle, new ArrayList<String>(Arrays.asList(packages)));
        }
    }

    private void setLockTaskPackagesLocked(int userHandle, List<String> packages) {
        DevicePolicyData policy = this.getUserData(userHandle);
        policy.mLockTaskPackages = packages;
        this.saveSettingsLocked(userHandle);
        this.updateLockTaskPackagesLocked(packages, userHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getLockTaskPackages(ComponentName who) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(who, -2);
            int userHandle = Binder.getCallingUserHandle().getIdentifier();
            List<String> packages = this.getLockTaskPackagesLocked(userHandle);
            return packages.toArray(new String[packages.size()]);
        }
    }

    private List<String> getLockTaskPackagesLocked(int userHandle) {
        DevicePolicyData policy = this.getUserData(userHandle);
        return policy.mLockTaskPackages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLockTaskPermitted(String pkg) {
        int uid = Binder.getCallingUid();
        int userHandle = UserHandle.getUserId(uid);
        DevicePolicyData policy = this.getUserData(userHandle);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            for (int i = 0; i < policy.mLockTaskPackages.size(); ++i) {
                String lockTaskPackage = policy.mLockTaskPackages.get(i);
                if (!lockTaskPackage.equals(pkg)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyLockTaskModeChanged(boolean isEnabled, String pkg, int userHandle) {
        if (Binder.getCallingUid() != 1000) {
            throw new SecurityException("notifyLockTaskModeChanged can only be called by system");
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            DevicePolicyData policy = this.getUserData(userHandle);
            Bundle adminExtras = new Bundle();
            adminExtras.putString("android.app.extra.LOCK_TASK_PACKAGE", pkg);
            for (ActiveAdmin admin : policy.mAdminList) {
                boolean ownsProfile;
                boolean ownsDevice = this.isDeviceOwner(admin.info.getPackageName());
                boolean bl = ownsProfile = this.getProfileOwner(userHandle) != null && this.getProfileOwner(userHandle).equals(admin.info.getPackageName());
                if (!ownsDevice && !ownsProfile) continue;
                if (isEnabled) {
                    this.sendAdminCommandLocked(admin, "android.app.action.LOCK_TASK_ENTERING", adminExtras, null);
                    continue;
                }
                this.sendAdminCommandLocked(admin, "android.app.action.LOCK_TASK_EXITING");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setGlobalSetting(ComponentName who, String setting, String value) {
        ContentResolver contentResolver = this.mContext.getContentResolver();
        Preconditions.checkNotNull(who, "ComponentName is null");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            long timeMs;
            this.getActiveAdminForCallerLocked(who, -2);
            if (GLOBAL_SETTINGS_DEPRECATED.contains(setting)) {
                Log.i(LOG_TAG, "Global setting no longer supported: " + setting);
                return;
            }
            if (!GLOBAL_SETTINGS_WHITELIST.contains(setting)) {
                throw new SecurityException(String.format("Permission denial: device owners cannot update %1$s", setting));
            }
            if ("stay_on_while_plugged_in".equals(setting) && (timeMs = this.getMaximumTimeToLock(who, UserHandle.getCallingUserId())) > 0L && timeMs < Integer.MAX_VALUE) {
                return;
            }
            long id2 = Binder.clearCallingIdentity();
            try {
                Settings.Global.putString(contentResolver, setting, value);
            }
            finally {
                DevicePolicyManagerService.restoreCallingIdentity(id2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSecureSetting(ComponentName who, String setting, String value) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        int callingUserId = UserHandle.getCallingUserId();
        ContentResolver contentResolver = this.mContext.getContentResolver();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            ActiveAdmin activeAdmin = this.getActiveAdminForCallerLocked(who, -1);
            if (this.isDeviceOwner(activeAdmin.info.getPackageName())) {
                if (!SECURE_SETTINGS_DEVICEOWNER_WHITELIST.contains(setting)) {
                    throw new SecurityException(String.format("Permission denial: Device owners cannot update %1$s", setting));
                }
            } else if (!SECURE_SETTINGS_WHITELIST.contains(setting)) {
                throw new SecurityException(String.format("Permission denial: Profile owners cannot update %1$s", setting));
            }
            long id2 = Binder.clearCallingIdentity();
            try {
                Settings.Secure.putStringForUser(contentResolver, setting, value, callingUserId);
            }
            finally {
                DevicePolicyManagerService.restoreCallingIdentity(id2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMasterVolumeMuted(ComponentName who, boolean on) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(who, -1);
            int userId = UserHandle.getCallingUserId();
            long identity = Binder.clearCallingIdentity();
            try {
                IAudioService iAudioService = IAudioService.Stub.asInterface(ServiceManager.getService("audio"));
                iAudioService.setMasterMute(on, 0, this.mContext.getPackageName(), userId);
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Failed to setMasterMute", re);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isMasterVolumeMuted(ComponentName who) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(who, -1);
            AudioManager audioManager = (AudioManager)this.mContext.getSystemService("audio");
            return audioManager.isMasterMute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserIcon(ComponentName who, Bitmap icon) {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            Preconditions.checkNotNull(who, "ComponentName is null");
            this.getActiveAdminForCallerLocked(who, -1);
            int userId = UserHandle.getCallingUserId();
            long id2 = Binder.clearCallingIdentity();
            try {
                this.mUserManager.setUserIcon(userId, icon);
            }
            finally {
                DevicePolicyManagerService.restoreCallingIdentity(id2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setKeyguardDisabled(ComponentName who, boolean disabled) {
        Preconditions.checkNotNull(who, "ComponentName is null");
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(who, -2);
        }
        int userId = UserHandle.getCallingUserId();
        LockPatternUtils utils = new LockPatternUtils(this.mContext);
        long ident = Binder.clearCallingIdentity();
        try {
            if (disabled && utils.isSecure(userId)) {
                boolean bl = false;
                return bl;
            }
            utils.setLockScreenDisabled(disabled, userId);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setStatusBarDisabled(ComponentName who, boolean disabled) {
        int userId = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(who, -2);
            DevicePolicyData policy = this.getUserData(userId);
            if (policy.mStatusBarDisabled != disabled) {
                if (!this.setStatusBarDisabledInternal(disabled, userId)) {
                    return false;
                }
                policy.mStatusBarDisabled = disabled;
                this.saveSettingsLocked(userId);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setStatusBarDisabledInternal(boolean disabled, int userId) {
        long ident = Binder.clearCallingIdentity();
        try {
            IStatusBarService statusBarService = IStatusBarService.Stub.asInterface(ServiceManager.checkService(TAG_STATUS_BAR));
            if (statusBarService != null) {
                int flags1 = disabled ? 0x2070000 : 0;
                int flags2 = disabled ? 1 : 0;
                statusBarService.disableForUser(flags1, this.mToken, this.mContext.getPackageName(), userId);
                statusBarService.disable2ForUser(flags2, this.mToken, this.mContext.getPackageName(), userId);
                boolean bl = true;
                return bl;
            }
        }
        catch (RemoteException e) {
            Slog.e(LOG_TAG, "Failed to disable the status bar", e);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateUserSetupComplete() {
        List<UserInfo> users = this.mUserManager.getUsers(true);
        ContentResolver resolver = this.mContext.getContentResolver();
        int N = users.size();
        for (int i = 0; i < N; ++i) {
            int userHandle = users.get((int)i).id;
            if (Settings.Secure.getIntForUser(resolver, "user_setup_complete", 0, userHandle) == 0) continue;
            DevicePolicyData policy = this.getUserData(userHandle);
            if (policy.mUserSetupComplete) continue;
            policy.mUserSetupComplete = true;
            DevicePolicyManagerService devicePolicyManagerService = this;
            synchronized (devicePolicyManagerService) {
                this.removeDeviceInitializerFromLockTaskPackages(userHandle);
                this.saveSettingsLocked(userHandle);
                continue;
            }
        }
    }

    private void addDeviceInitializerToLockTaskPackagesLocked(int userHandle) {
        if (this.hasUserSetupCompleted(userHandle)) {
            return;
        }
        String deviceInitializerPackage = this.getDeviceInitializer();
        if (deviceInitializerPackage == null) {
            return;
        }
        List<String> packages = this.getLockTaskPackagesLocked(userHandle);
        if (!packages.contains(deviceInitializerPackage)) {
            packages.add(deviceInitializerPackage);
            this.setLockTaskPackagesLocked(userHandle, packages);
        }
    }

    private void removeDeviceInitializerFromLockTaskPackages(int userHandle) {
        String deviceInitializerPackage = this.getDeviceInitializer();
        if (deviceInitializerPackage == null) {
            return;
        }
        List<String> packages = this.getLockTaskPackagesLocked(userHandle);
        if (packages.remove(deviceInitializerPackage)) {
            this.setLockTaskPackagesLocked(userHandle, packages);
        }
    }

    private static boolean isLimitPasswordAllowed(ActiveAdmin admin, int minPasswordQuality) {
        if (admin.passwordQuality < minPasswordQuality) {
            return false;
        }
        return admin.info.usesPolicy(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSystemUpdatePolicy(ComponentName who, SystemUpdatePolicy policy) {
        if (policy != null && !policy.isValid()) {
            throw new IllegalArgumentException("Invalid system update policy.");
        }
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(who, -2);
            if (policy == null) {
                this.mDeviceOwner.clearSystemUpdatePolicy();
            } else {
                this.mDeviceOwner.setSystemUpdatePolicy(policy);
            }
            this.mDeviceOwner.writeOwnerFile();
        }
        this.mContext.sendBroadcastAsUser(new Intent("android.app.action.SYSTEM_UPDATE_POLICY_CHANGED"), UserHandle.OWNER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SystemUpdatePolicy getSystemUpdatePolicy() {
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            SystemUpdatePolicy policy = this.mDeviceOwner.getSystemUpdatePolicy();
            if (policy != null && !policy.isValid()) {
                Slog.w(LOG_TAG, "Stored system update policy is invalid, return null instead.");
                return null;
            }
            return policy;
        }
    }

    private boolean isCallerDeviceOwnerOrInitializer(int callerUid) {
        String[] pkgs;
        for (String pkg : pkgs = this.mContext.getPackageManager().getPackagesForUid(callerUid)) {
            if (!this.isDeviceOwner(pkg) && !this.isDeviceInitializer(pkg)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyPendingSystemUpdate(long updateReceivedTime) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.NOTIFY_PENDING_SYSTEM_UPDATE", "Only the system update service can broadcast update information");
        if (UserHandle.getCallingUserId() != 0) {
            Slog.w(LOG_TAG, "Only the system update service in the primary usercan broadcast update information.");
            return;
        }
        Intent intent = new Intent("android.app.action.NOTIFY_PENDING_SYSTEM_UPDATE");
        intent.putExtra("android.app.extra.SYSTEM_UPDATE_RECEIVED_TIME", updateReceivedTime);
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            String deviceOwnerPackage = this.getDeviceOwner();
            if (deviceOwnerPackage == null) {
                return;
            }
            ActivityInfo[] receivers = null;
            try {
                receivers = this.mContext.getPackageManager().getPackageInfo((String)deviceOwnerPackage, (int)2).receivers;
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.e(LOG_TAG, "Cannot find device owner package", e);
            }
            if (receivers != null) {
                long ident = Binder.clearCallingIdentity();
                try {
                    for (int i = 0; i < receivers.length; ++i) {
                        if (!"android.permission.BIND_DEVICE_ADMIN".equals(receivers[i].permission)) continue;
                        intent.setComponent(new ComponentName(deviceOwnerPackage, receivers[i].name));
                        this.mContext.sendBroadcastAsUser(intent, UserHandle.OWNER);
                    }
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPermissionPolicy(ComponentName admin, int policy) throws RemoteException {
        int userId = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(admin, -1);
            DevicePolicyData userPolicy = this.getUserData(userId);
            if (userPolicy.mPermissionPolicy != policy) {
                userPolicy.mPermissionPolicy = policy;
                this.saveSettingsLocked(userId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPermissionPolicy(ComponentName admin) throws RemoteException {
        int userId = UserHandle.getCallingUserId();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            DevicePolicyData userPolicy = this.getUserData(userId);
            return userPolicy.mPermissionPolicy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean setPermissionGrantState(ComponentName admin, String packageName, String permission2, int grantState) throws RemoteException {
        UserHandle user = Binder.getCallingUserHandle();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(admin, -1);
            long ident = Binder.clearCallingIdentity();
            try {
                int targetSdkVersion;
                ApplicationInfo ai = AppGlobals.getPackageManager().getApplicationInfo(packageName, 0, user.getIdentifier());
                int n = targetSdkVersion = ai == null ? 0 : ai.targetSdkVersion;
                if (targetSdkVersion < 23) {
                    boolean bl = false;
                    return bl;
                }
                PackageManager packageManager = this.mContext.getPackageManager();
                switch (grantState) {
                    case 1: {
                        packageManager.grantRuntimePermission(packageName, permission2, user);
                        packageManager.updatePermissionFlags(permission2, packageName, 4, 4, user);
                        break;
                    }
                    case 2: {
                        packageManager.revokeRuntimePermission(packageName, permission2, user);
                        packageManager.updatePermissionFlags(permission2, packageName, 4, 4, user);
                        break;
                    }
                    case 0: {
                        packageManager.updatePermissionFlags(permission2, packageName, 4, 0, user);
                        break;
                    }
                }
                boolean bl = true;
                return bl;
            }
            catch (SecurityException se) {
                boolean bl2 = false;
                return bl2;
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getPermissionGrantState(ComponentName admin, String packageName, String permission2) throws RemoteException {
        PackageManager packageManager = this.mContext.getPackageManager();
        UserHandle user = Binder.getCallingUserHandle();
        DevicePolicyManagerService devicePolicyManagerService = this;
        synchronized (devicePolicyManagerService) {
            this.getActiveAdminForCallerLocked(admin, -1);
            long ident = Binder.clearCallingIdentity();
            try {
                int granted = AppGlobals.getPackageManager().checkPermission(permission2, packageName, user.getIdentifier());
                int permFlags = packageManager.getPermissionFlags(permission2, packageName, user);
                if ((permFlags & 4) != 4) {
                    int n = 0;
                    return n;
                }
                int n = granted == 0 ? 1 : 2;
                return n;
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    static {
        DEVICE_OWNER_USER_RESTRICTIONS.add("no_usb_file_transfer");
        DEVICE_OWNER_USER_RESTRICTIONS.add("no_config_tethering");
        DEVICE_OWNER_USER_RESTRICTIONS.add("no_network_reset");
        DEVICE_OWNER_USER_RESTRICTIONS.add("no_factory_reset");
        DEVICE_OWNER_USER_RESTRICTIONS.add("no_add_user");
        DEVICE_OWNER_USER_RESTRICTIONS.add("no_config_cell_broadcasts");
        DEVICE_OWNER_USER_RESTRICTIONS.add("no_config_mobile_networks");
        DEVICE_OWNER_USER_RESTRICTIONS.add("no_physical_media");
        DEVICE_OWNER_USER_RESTRICTIONS.add("no_unmute_microphone");
        DEVICE_OWNER_USER_RESTRICTIONS.add("no_adjust_volume");
        DEVICE_OWNER_USER_RESTRICTIONS.add("no_sms");
        DEVICE_OWNER_USER_RESTRICTIONS.add("no_fun");
        DEVICE_OWNER_USER_RESTRICTIONS.add("no_safe_boot");
        DEVICE_OWNER_USER_RESTRICTIONS.add("no_create_windows");
        IMMUTABLE_USER_RESTRICTIONS = new HashSet<String>();
        IMMUTABLE_USER_RESTRICTIONS.add("no_wallpaper");
        SECURE_SETTINGS_WHITELIST = new HashSet<String>();
        SECURE_SETTINGS_WHITELIST.add("default_input_method");
        SECURE_SETTINGS_WHITELIST.add("skip_first_use_hints");
        SECURE_SETTINGS_WHITELIST.add("install_non_market_apps");
        SECURE_SETTINGS_DEVICEOWNER_WHITELIST = new HashSet<String>();
        SECURE_SETTINGS_DEVICEOWNER_WHITELIST.addAll(SECURE_SETTINGS_WHITELIST);
        SECURE_SETTINGS_DEVICEOWNER_WHITELIST.add("location_mode");
        GLOBAL_SETTINGS_WHITELIST = new HashSet<String>();
        GLOBAL_SETTINGS_WHITELIST.add("adb_enabled");
        GLOBAL_SETTINGS_WHITELIST.add("auto_time");
        GLOBAL_SETTINGS_WHITELIST.add("auto_time_zone");
        GLOBAL_SETTINGS_WHITELIST.add("data_roaming");
        GLOBAL_SETTINGS_WHITELIST.add("usb_mass_storage_enabled");
        GLOBAL_SETTINGS_WHITELIST.add("wifi_sleep_policy");
        GLOBAL_SETTINGS_WHITELIST.add("stay_on_while_plugged_in");
        GLOBAL_SETTINGS_WHITELIST.add("wifi_device_owner_configs_lockdown");
        GLOBAL_SETTINGS_DEPRECATED = new HashSet<String>();
        GLOBAL_SETTINGS_DEPRECATED.add("bluetooth_on");
        GLOBAL_SETTINGS_DEPRECATED.add("development_settings_enabled");
        GLOBAL_SETTINGS_DEPRECATED.add("mode_ringer");
        GLOBAL_SETTINGS_DEPRECATED.add("network_preference");
        GLOBAL_SETTINGS_DEPRECATED.add("wifi_on");
    }

    private final class LocalService
    extends DevicePolicyManagerInternal {
        private List<DevicePolicyManagerInternal.OnCrossProfileWidgetProvidersChangeListener> mWidgetProviderListeners;

        private LocalService() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<String> getCrossProfileWidgetProviders(int profileId) {
            DevicePolicyManagerService devicePolicyManagerService = DevicePolicyManagerService.this;
            synchronized (devicePolicyManagerService) {
                if (DevicePolicyManagerService.this.mDeviceOwner == null) {
                    return Collections.emptyList();
                }
                ComponentName ownerComponent = DevicePolicyManagerService.this.mDeviceOwner.getProfileOwnerComponent(profileId);
                if (ownerComponent == null) {
                    return Collections.emptyList();
                }
                DevicePolicyData policy = DevicePolicyManagerService.this.getUserDataUnchecked(profileId);
                ActiveAdmin admin = policy.mAdminMap.get(ownerComponent);
                if (admin == null || admin.crossProfileWidgetProviders == null || admin.crossProfileWidgetProviders.isEmpty()) {
                    return Collections.emptyList();
                }
                return admin.crossProfileWidgetProviders;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addOnCrossProfileWidgetProvidersChangeListener(DevicePolicyManagerInternal.OnCrossProfileWidgetProvidersChangeListener listener) {
            DevicePolicyManagerService devicePolicyManagerService = DevicePolicyManagerService.this;
            synchronized (devicePolicyManagerService) {
                if (this.mWidgetProviderListeners == null) {
                    this.mWidgetProviderListeners = new ArrayList<DevicePolicyManagerInternal.OnCrossProfileWidgetProvidersChangeListener>();
                }
                if (!this.mWidgetProviderListeners.contains(listener)) {
                    this.mWidgetProviderListeners.add(listener);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isActiveAdminWithPolicy(int uid, int reqPolicy) {
            int userId = UserHandle.getUserId(uid);
            DevicePolicyManagerService devicePolicyManagerService = DevicePolicyManagerService.this;
            synchronized (devicePolicyManagerService) {
                return DevicePolicyManagerService.this.getActiveAdminWithPolicyForUidLocked(null, reqPolicy, uid) != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyCrossProfileProvidersChanged(int userId, List<String> packages) {
            ArrayList<DevicePolicyManagerInternal.OnCrossProfileWidgetProvidersChangeListener> listeners;
            DevicePolicyManagerService devicePolicyManagerService = DevicePolicyManagerService.this;
            synchronized (devicePolicyManagerService) {
                listeners = new ArrayList<DevicePolicyManagerInternal.OnCrossProfileWidgetProvidersChangeListener>(this.mWidgetProviderListeners);
            }
            int listenerCount = listeners.size();
            for (int i = 0; i < listenerCount; ++i) {
                DevicePolicyManagerInternal.OnCrossProfileWidgetProvidersChangeListener listener = (DevicePolicyManagerInternal.OnCrossProfileWidgetProvidersChangeListener)listeners.get(i);
                listener.onCrossProfileWidgetProvidersChanged(userId, packages);
            }
        }
    }

    private class SetupContentObserver
    extends ContentObserver {
        private final Uri mUserSetupComplete;

        public SetupContentObserver(Handler handler) {
            super(handler);
            this.mUserSetupComplete = Settings.Secure.getUriFor("user_setup_complete");
        }

        void register(ContentResolver resolver) {
            resolver.registerContentObserver(this.mUserSetupComplete, false, this, -1);
        }

        @Override
        public void onChange(boolean selfChange, Uri uri) {
            if (this.mUserSetupComplete.equals(uri)) {
                DevicePolicyManagerService.this.updateUserSetupComplete();
            }
        }
    }

    private class MonitoringCertNotificationTask
    extends AsyncTask<Intent, Void, Void> {
        private MonitoringCertNotificationTask() {
        }

        protected Void doInBackground(Intent ... params) {
            int userHandle = params[0].getIntExtra("android.intent.extra.user_handle", -1);
            if (userHandle == -1) {
                for (UserInfo userInfo : DevicePolicyManagerService.this.mUserManager.getUsers()) {
                    this.manageNotification(userInfo.getUserHandle());
                }
            } else {
                this.manageNotification(new UserHandle(userHandle));
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void manageNotification(UserHandle userHandle) {
            Context userContext;
            int smallIconId;
            String contentText;
            if (!DevicePolicyManagerService.this.mUserManager.isUserRunning(userHandle)) {
                return;
            }
            boolean hasCert = false;
            try (KeyChain.KeyChainConnection kcs = KeyChain.bindAsUser(DevicePolicyManagerService.this.mContext, userHandle);){
                if (!kcs.getService().getUserCaAliases().getList().isEmpty()) {
                    hasCert = true;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (RuntimeException e) {
                Log.e(DevicePolicyManagerService.LOG_TAG, "Could not connect to KeyChain service", e);
            }
            if (!hasCert) {
                DevicePolicyManagerService.this.getNotificationManager().cancelAsUser(null, 17039590, userHandle);
                return;
            }
            String ownerName = DevicePolicyManagerService.this.getDeviceOwnerName();
            if (DevicePolicyManagerService.this.isManagedProfile(userHandle.getIdentifier())) {
                contentText = DevicePolicyManagerService.this.mContext.getString(17039592);
                smallIconId = 17303136;
            } else if (ownerName != null) {
                contentText = DevicePolicyManagerService.this.mContext.getString(17039593, ownerName);
                smallIconId = 17303136;
            } else {
                contentText = DevicePolicyManagerService.this.mContext.getString(17039591);
                smallIconId = 17301642;
            }
            Intent dialogIntent = new Intent("com.android.settings.MONITORING_CERT_INFO");
            dialogIntent.setFlags(0x10008000);
            dialogIntent.setPackage("com.android.settings");
            PendingIntent notifyIntent = PendingIntent.getActivityAsUser(DevicePolicyManagerService.this.mContext, 0, dialogIntent, 0x8000000, null, userHandle);
            try {
                userContext = DevicePolicyManagerService.this.mContext.createPackageContextAsUser("android", 0, userHandle);
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.e(DevicePolicyManagerService.LOG_TAG, "Create context as " + userHandle + " failed", e);
                return;
            }
            Notification noti = new Notification.Builder(userContext).setSmallIcon(smallIconId).setContentTitle(DevicePolicyManagerService.this.mContext.getString(17039590)).setContentText(contentText).setContentIntent(notifyIntent).setPriority(1).setShowWhen(false).setColor(DevicePolicyManagerService.this.mContext.getColor(17170521)).build();
            DevicePolicyManagerService.this.getNotificationManager().notifyAsUser(null, 17039590, noti, userHandle);
        }
    }

    static class ActiveAdmin {
        private static final String TAG_DISABLE_KEYGUARD_FEATURES = "disable-keyguard-features";
        private static final String TAG_DISABLE_CAMERA = "disable-camera";
        private static final String TAG_DISABLE_CALLER_ID = "disable-caller-id";
        private static final String TAG_DISABLE_BLUETOOTH_CONTACT_SHARING = "disable-bt-contacts-sharing";
        private static final String TAG_DISABLE_SCREEN_CAPTURE = "disable-screen-capture";
        private static final String TAG_DISABLE_ACCOUNT_MANAGEMENT = "disable-account-management";
        private static final String TAG_REQUIRE_AUTO_TIME = "require_auto_time";
        private static final String TAG_ACCOUNT_TYPE = "account-type";
        private static final String TAG_PERMITTED_ACCESSIBILITY_SERVICES = "permitted-accessiblity-services";
        private static final String TAG_ENCRYPTION_REQUESTED = "encryption-requested";
        private static final String TAG_MANAGE_TRUST_AGENT_FEATURES = "manage-trust-agent-features";
        private static final String TAG_TRUST_AGENT_COMPONENT_OPTIONS = "trust-agent-component-options";
        private static final String TAG_TRUST_AGENT_COMPONENT = "component";
        private static final String TAG_PASSWORD_EXPIRATION_DATE = "password-expiration-date";
        private static final String TAG_PASSWORD_EXPIRATION_TIMEOUT = "password-expiration-timeout";
        private static final String TAG_GLOBAL_PROXY_EXCLUSION_LIST = "global-proxy-exclusion-list";
        private static final String TAG_GLOBAL_PROXY_SPEC = "global-proxy-spec";
        private static final String TAG_SPECIFIES_GLOBAL_PROXY = "specifies-global-proxy";
        private static final String TAG_PERMITTED_IMES = "permitted-imes";
        private static final String TAG_MAX_FAILED_PASSWORD_WIPE = "max-failed-password-wipe";
        private static final String TAG_MAX_TIME_TO_UNLOCK = "max-time-to-unlock";
        private static final String TAG_MIN_PASSWORD_NONLETTER = "min-password-nonletter";
        private static final String TAG_MIN_PASSWORD_SYMBOLS = "min-password-symbols";
        private static final String TAG_MIN_PASSWORD_NUMERIC = "min-password-numeric";
        private static final String TAG_MIN_PASSWORD_LETTERS = "min-password-letters";
        private static final String TAG_MIN_PASSWORD_LOWERCASE = "min-password-lowercase";
        private static final String TAG_MIN_PASSWORD_UPPERCASE = "min-password-uppercase";
        private static final String TAG_PASSWORD_HISTORY_LENGTH = "password-history-length";
        private static final String TAG_MIN_PASSWORD_LENGTH = "min-password-length";
        private static final String ATTR_VALUE = "value";
        private static final String TAG_PASSWORD_QUALITY = "password-quality";
        private static final String TAG_POLICIES = "policies";
        private static final String TAG_CROSS_PROFILE_WIDGET_PROVIDERS = "cross-profile-widget-providers";
        private static final String TAG_PROVIDER = "provider";
        private static final String TAG_PACKAGE_LIST_ITEM = "item";
        final DeviceAdminInfo info;
        int passwordQuality = 0;
        static final int DEF_MINIMUM_PASSWORD_LENGTH = 0;
        int minimumPasswordLength = 0;
        static final int DEF_PASSWORD_HISTORY_LENGTH = 0;
        int passwordHistoryLength = 0;
        static final int DEF_MINIMUM_PASSWORD_UPPER_CASE = 0;
        int minimumPasswordUpperCase = 0;
        static final int DEF_MINIMUM_PASSWORD_LOWER_CASE = 0;
        int minimumPasswordLowerCase = 0;
        static final int DEF_MINIMUM_PASSWORD_LETTERS = 1;
        int minimumPasswordLetters = 1;
        static final int DEF_MINIMUM_PASSWORD_NUMERIC = 1;
        int minimumPasswordNumeric = 1;
        static final int DEF_MINIMUM_PASSWORD_SYMBOLS = 1;
        int minimumPasswordSymbols = 1;
        static final int DEF_MINIMUM_PASSWORD_NON_LETTER = 0;
        int minimumPasswordNonLetter = 0;
        static final long DEF_MAXIMUM_TIME_TO_UNLOCK = 0L;
        long maximumTimeToUnlock = 0L;
        static final int DEF_MAXIMUM_FAILED_PASSWORDS_FOR_WIPE = 0;
        int maximumFailedPasswordsForWipe = 0;
        static final long DEF_PASSWORD_EXPIRATION_TIMEOUT = 0L;
        long passwordExpirationTimeout = 0L;
        static final long DEF_PASSWORD_EXPIRATION_DATE = 0L;
        long passwordExpirationDate = 0L;
        static final int DEF_KEYGUARD_FEATURES_DISABLED = 0;
        int disabledKeyguardFeatures = 0;
        boolean encryptionRequested = false;
        boolean disableCamera = false;
        boolean disableCallerId = false;
        boolean disableBluetoothContactSharing = true;
        boolean disableScreenCapture = false;
        boolean requireAutoTime = false;
        Set<String> accountTypesWithManagementDisabled = new HashSet<String>();
        List<String> permittedAccessiblityServices;
        List<String> permittedInputMethods;
        boolean specifiesGlobalProxy = false;
        String globalProxySpec = null;
        String globalProxyExclusionList = null;
        HashMap<String, TrustAgentInfo> trustAgentInfos = new HashMap();
        List<String> crossProfileWidgetProviders;

        ActiveAdmin(DeviceAdminInfo _info) {
            this.info = _info;
        }

        int getUid() {
            return this.info.getActivityInfo().applicationInfo.uid;
        }

        public UserHandle getUserHandle() {
            return new UserHandle(UserHandle.getUserId(this.info.getActivityInfo().applicationInfo.uid));
        }

        void writeToXml(XmlSerializer out) throws IllegalArgumentException, IllegalStateException, IOException {
            out.startTag(null, TAG_POLICIES);
            this.info.writePoliciesToXml(out);
            out.endTag(null, TAG_POLICIES);
            if (this.passwordQuality != 0) {
                out.startTag(null, TAG_PASSWORD_QUALITY);
                out.attribute(null, ATTR_VALUE, Integer.toString(this.passwordQuality));
                out.endTag(null, TAG_PASSWORD_QUALITY);
                if (this.minimumPasswordLength != 0) {
                    out.startTag(null, TAG_MIN_PASSWORD_LENGTH);
                    out.attribute(null, ATTR_VALUE, Integer.toString(this.minimumPasswordLength));
                    out.endTag(null, TAG_MIN_PASSWORD_LENGTH);
                }
                if (this.passwordHistoryLength != 0) {
                    out.startTag(null, TAG_PASSWORD_HISTORY_LENGTH);
                    out.attribute(null, ATTR_VALUE, Integer.toString(this.passwordHistoryLength));
                    out.endTag(null, TAG_PASSWORD_HISTORY_LENGTH);
                }
                if (this.minimumPasswordUpperCase != 0) {
                    out.startTag(null, TAG_MIN_PASSWORD_UPPERCASE);
                    out.attribute(null, ATTR_VALUE, Integer.toString(this.minimumPasswordUpperCase));
                    out.endTag(null, TAG_MIN_PASSWORD_UPPERCASE);
                }
                if (this.minimumPasswordLowerCase != 0) {
                    out.startTag(null, TAG_MIN_PASSWORD_LOWERCASE);
                    out.attribute(null, ATTR_VALUE, Integer.toString(this.minimumPasswordLowerCase));
                    out.endTag(null, TAG_MIN_PASSWORD_LOWERCASE);
                }
                if (this.minimumPasswordLetters != 1) {
                    out.startTag(null, TAG_MIN_PASSWORD_LETTERS);
                    out.attribute(null, ATTR_VALUE, Integer.toString(this.minimumPasswordLetters));
                    out.endTag(null, TAG_MIN_PASSWORD_LETTERS);
                }
                if (this.minimumPasswordNumeric != 1) {
                    out.startTag(null, TAG_MIN_PASSWORD_NUMERIC);
                    out.attribute(null, ATTR_VALUE, Integer.toString(this.minimumPasswordNumeric));
                    out.endTag(null, TAG_MIN_PASSWORD_NUMERIC);
                }
                if (this.minimumPasswordSymbols != 1) {
                    out.startTag(null, TAG_MIN_PASSWORD_SYMBOLS);
                    out.attribute(null, ATTR_VALUE, Integer.toString(this.minimumPasswordSymbols));
                    out.endTag(null, TAG_MIN_PASSWORD_SYMBOLS);
                }
                if (this.minimumPasswordNonLetter > 0) {
                    out.startTag(null, TAG_MIN_PASSWORD_NONLETTER);
                    out.attribute(null, ATTR_VALUE, Integer.toString(this.minimumPasswordNonLetter));
                    out.endTag(null, TAG_MIN_PASSWORD_NONLETTER);
                }
            }
            if (this.maximumTimeToUnlock != 0L) {
                out.startTag(null, TAG_MAX_TIME_TO_UNLOCK);
                out.attribute(null, ATTR_VALUE, Long.toString(this.maximumTimeToUnlock));
                out.endTag(null, TAG_MAX_TIME_TO_UNLOCK);
            }
            if (this.maximumFailedPasswordsForWipe != 0) {
                out.startTag(null, TAG_MAX_FAILED_PASSWORD_WIPE);
                out.attribute(null, ATTR_VALUE, Integer.toString(this.maximumFailedPasswordsForWipe));
                out.endTag(null, TAG_MAX_FAILED_PASSWORD_WIPE);
            }
            if (this.specifiesGlobalProxy) {
                out.startTag(null, TAG_SPECIFIES_GLOBAL_PROXY);
                out.attribute(null, ATTR_VALUE, Boolean.toString(this.specifiesGlobalProxy));
                out.endTag(null, TAG_SPECIFIES_GLOBAL_PROXY);
                if (this.globalProxySpec != null) {
                    out.startTag(null, TAG_GLOBAL_PROXY_SPEC);
                    out.attribute(null, ATTR_VALUE, this.globalProxySpec);
                    out.endTag(null, TAG_GLOBAL_PROXY_SPEC);
                }
                if (this.globalProxyExclusionList != null) {
                    out.startTag(null, TAG_GLOBAL_PROXY_EXCLUSION_LIST);
                    out.attribute(null, ATTR_VALUE, this.globalProxyExclusionList);
                    out.endTag(null, TAG_GLOBAL_PROXY_EXCLUSION_LIST);
                }
            }
            if (this.passwordExpirationTimeout != 0L) {
                out.startTag(null, TAG_PASSWORD_EXPIRATION_TIMEOUT);
                out.attribute(null, ATTR_VALUE, Long.toString(this.passwordExpirationTimeout));
                out.endTag(null, TAG_PASSWORD_EXPIRATION_TIMEOUT);
            }
            if (this.passwordExpirationDate != 0L) {
                out.startTag(null, TAG_PASSWORD_EXPIRATION_DATE);
                out.attribute(null, ATTR_VALUE, Long.toString(this.passwordExpirationDate));
                out.endTag(null, TAG_PASSWORD_EXPIRATION_DATE);
            }
            if (this.encryptionRequested) {
                out.startTag(null, TAG_ENCRYPTION_REQUESTED);
                out.attribute(null, ATTR_VALUE, Boolean.toString(this.encryptionRequested));
                out.endTag(null, TAG_ENCRYPTION_REQUESTED);
            }
            if (this.disableCamera) {
                out.startTag(null, TAG_DISABLE_CAMERA);
                out.attribute(null, ATTR_VALUE, Boolean.toString(this.disableCamera));
                out.endTag(null, TAG_DISABLE_CAMERA);
            }
            if (this.disableCallerId) {
                out.startTag(null, TAG_DISABLE_CALLER_ID);
                out.attribute(null, ATTR_VALUE, Boolean.toString(this.disableCallerId));
                out.endTag(null, TAG_DISABLE_CALLER_ID);
            }
            if (this.disableBluetoothContactSharing) {
                out.startTag(null, TAG_DISABLE_BLUETOOTH_CONTACT_SHARING);
                out.attribute(null, ATTR_VALUE, Boolean.toString(this.disableBluetoothContactSharing));
                out.endTag(null, TAG_DISABLE_BLUETOOTH_CONTACT_SHARING);
            }
            if (this.disableScreenCapture) {
                out.startTag(null, TAG_DISABLE_SCREEN_CAPTURE);
                out.attribute(null, ATTR_VALUE, Boolean.toString(this.disableScreenCapture));
                out.endTag(null, TAG_DISABLE_SCREEN_CAPTURE);
            }
            if (this.requireAutoTime) {
                out.startTag(null, TAG_REQUIRE_AUTO_TIME);
                out.attribute(null, ATTR_VALUE, Boolean.toString(this.requireAutoTime));
                out.endTag(null, TAG_REQUIRE_AUTO_TIME);
            }
            if (this.disabledKeyguardFeatures != 0) {
                out.startTag(null, TAG_DISABLE_KEYGUARD_FEATURES);
                out.attribute(null, ATTR_VALUE, Integer.toString(this.disabledKeyguardFeatures));
                out.endTag(null, TAG_DISABLE_KEYGUARD_FEATURES);
            }
            if (!this.accountTypesWithManagementDisabled.isEmpty()) {
                out.startTag(null, TAG_DISABLE_ACCOUNT_MANAGEMENT);
                for (String ac : this.accountTypesWithManagementDisabled) {
                    out.startTag(null, TAG_ACCOUNT_TYPE);
                    out.attribute(null, ATTR_VALUE, ac);
                    out.endTag(null, TAG_ACCOUNT_TYPE);
                }
                out.endTag(null, TAG_DISABLE_ACCOUNT_MANAGEMENT);
            }
            if (!this.trustAgentInfos.isEmpty()) {
                Set<Map.Entry<String, TrustAgentInfo>> set = this.trustAgentInfos.entrySet();
                out.startTag(null, TAG_MANAGE_TRUST_AGENT_FEATURES);
                for (Map.Entry<String, TrustAgentInfo> entry : set) {
                    TrustAgentInfo trustAgentInfo = entry.getValue();
                    out.startTag(null, TAG_TRUST_AGENT_COMPONENT);
                    out.attribute(null, ATTR_VALUE, entry.getKey());
                    if (trustAgentInfo.options != null) {
                        out.startTag(null, TAG_TRUST_AGENT_COMPONENT_OPTIONS);
                        try {
                            trustAgentInfo.options.saveToXml(out);
                        }
                        catch (XmlPullParserException e) {
                            Log.e(DevicePolicyManagerService.LOG_TAG, "Failed to save TrustAgent options", e);
                        }
                        out.endTag(null, TAG_TRUST_AGENT_COMPONENT_OPTIONS);
                    }
                    out.endTag(null, TAG_TRUST_AGENT_COMPONENT);
                }
                out.endTag(null, TAG_MANAGE_TRUST_AGENT_FEATURES);
            }
            if (this.crossProfileWidgetProviders != null && !this.crossProfileWidgetProviders.isEmpty()) {
                out.startTag(null, TAG_CROSS_PROFILE_WIDGET_PROVIDERS);
                int providerCount = this.crossProfileWidgetProviders.size();
                for (int i = 0; i < providerCount; ++i) {
                    String provider = this.crossProfileWidgetProviders.get(i);
                    out.startTag(null, TAG_PROVIDER);
                    out.attribute(null, ATTR_VALUE, provider);
                    out.endTag(null, TAG_PROVIDER);
                }
                out.endTag(null, TAG_CROSS_PROFILE_WIDGET_PROVIDERS);
            }
            this.writePackageListToXml(out, TAG_PERMITTED_ACCESSIBILITY_SERVICES, this.permittedAccessiblityServices);
            this.writePackageListToXml(out, TAG_PERMITTED_IMES, this.permittedInputMethods);
        }

        void writePackageListToXml(XmlSerializer out, String outerTag, List<String> packageList) throws IllegalArgumentException, IllegalStateException, IOException {
            if (packageList == null) {
                return;
            }
            out.startTag(null, outerTag);
            for (String packageName : packageList) {
                out.startTag(null, TAG_PACKAGE_LIST_ITEM);
                out.attribute(null, ATTR_VALUE, packageName);
                out.endTag(null, TAG_PACKAGE_LIST_ITEM);
            }
            out.endTag(null, outerTag);
        }

        void readFromXml(XmlPullParser parser) throws XmlPullParserException, IOException {
            int type;
            int outerDepth = parser.getDepth();
            while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                if (type == 3 || type == 4) continue;
                String tag = parser.getName();
                if (TAG_POLICIES.equals(tag)) {
                    this.info.readPoliciesFromXml(parser);
                    continue;
                }
                if (TAG_PASSWORD_QUALITY.equals(tag)) {
                    this.passwordQuality = Integer.parseInt(parser.getAttributeValue(null, ATTR_VALUE));
                    continue;
                }
                if (TAG_MIN_PASSWORD_LENGTH.equals(tag)) {
                    this.minimumPasswordLength = Integer.parseInt(parser.getAttributeValue(null, ATTR_VALUE));
                    continue;
                }
                if (TAG_PASSWORD_HISTORY_LENGTH.equals(tag)) {
                    this.passwordHistoryLength = Integer.parseInt(parser.getAttributeValue(null, ATTR_VALUE));
                    continue;
                }
                if (TAG_MIN_PASSWORD_UPPERCASE.equals(tag)) {
                    this.minimumPasswordUpperCase = Integer.parseInt(parser.getAttributeValue(null, ATTR_VALUE));
                    continue;
                }
                if (TAG_MIN_PASSWORD_LOWERCASE.equals(tag)) {
                    this.minimumPasswordLowerCase = Integer.parseInt(parser.getAttributeValue(null, ATTR_VALUE));
                    continue;
                }
                if (TAG_MIN_PASSWORD_LETTERS.equals(tag)) {
                    this.minimumPasswordLetters = Integer.parseInt(parser.getAttributeValue(null, ATTR_VALUE));
                    continue;
                }
                if (TAG_MIN_PASSWORD_NUMERIC.equals(tag)) {
                    this.minimumPasswordNumeric = Integer.parseInt(parser.getAttributeValue(null, ATTR_VALUE));
                    continue;
                }
                if (TAG_MIN_PASSWORD_SYMBOLS.equals(tag)) {
                    this.minimumPasswordSymbols = Integer.parseInt(parser.getAttributeValue(null, ATTR_VALUE));
                    continue;
                }
                if (TAG_MIN_PASSWORD_NONLETTER.equals(tag)) {
                    this.minimumPasswordNonLetter = Integer.parseInt(parser.getAttributeValue(null, ATTR_VALUE));
                    continue;
                }
                if (TAG_MAX_TIME_TO_UNLOCK.equals(tag)) {
                    this.maximumTimeToUnlock = Long.parseLong(parser.getAttributeValue(null, ATTR_VALUE));
                    continue;
                }
                if (TAG_MAX_FAILED_PASSWORD_WIPE.equals(tag)) {
                    this.maximumFailedPasswordsForWipe = Integer.parseInt(parser.getAttributeValue(null, ATTR_VALUE));
                    continue;
                }
                if (TAG_SPECIFIES_GLOBAL_PROXY.equals(tag)) {
                    this.specifiesGlobalProxy = Boolean.parseBoolean(parser.getAttributeValue(null, ATTR_VALUE));
                    continue;
                }
                if (TAG_GLOBAL_PROXY_SPEC.equals(tag)) {
                    this.globalProxySpec = parser.getAttributeValue(null, ATTR_VALUE);
                    continue;
                }
                if (TAG_GLOBAL_PROXY_EXCLUSION_LIST.equals(tag)) {
                    this.globalProxyExclusionList = parser.getAttributeValue(null, ATTR_VALUE);
                    continue;
                }
                if (TAG_PASSWORD_EXPIRATION_TIMEOUT.equals(tag)) {
                    this.passwordExpirationTimeout = Long.parseLong(parser.getAttributeValue(null, ATTR_VALUE));
                    continue;
                }
                if (TAG_PASSWORD_EXPIRATION_DATE.equals(tag)) {
                    this.passwordExpirationDate = Long.parseLong(parser.getAttributeValue(null, ATTR_VALUE));
                    continue;
                }
                if (TAG_ENCRYPTION_REQUESTED.equals(tag)) {
                    this.encryptionRequested = Boolean.parseBoolean(parser.getAttributeValue(null, ATTR_VALUE));
                    continue;
                }
                if (TAG_DISABLE_CAMERA.equals(tag)) {
                    this.disableCamera = Boolean.parseBoolean(parser.getAttributeValue(null, ATTR_VALUE));
                    continue;
                }
                if (TAG_DISABLE_CALLER_ID.equals(tag)) {
                    this.disableCallerId = Boolean.parseBoolean(parser.getAttributeValue(null, ATTR_VALUE));
                    continue;
                }
                if (TAG_DISABLE_BLUETOOTH_CONTACT_SHARING.equals(tag)) {
                    this.disableBluetoothContactSharing = Boolean.parseBoolean(parser.getAttributeValue(null, ATTR_VALUE));
                    continue;
                }
                if (TAG_DISABLE_SCREEN_CAPTURE.equals(tag)) {
                    this.disableScreenCapture = Boolean.parseBoolean(parser.getAttributeValue(null, ATTR_VALUE));
                    continue;
                }
                if (TAG_REQUIRE_AUTO_TIME.equals(tag)) {
                    this.requireAutoTime = Boolean.parseBoolean(parser.getAttributeValue(null, ATTR_VALUE));
                    continue;
                }
                if (TAG_DISABLE_KEYGUARD_FEATURES.equals(tag)) {
                    this.disabledKeyguardFeatures = Integer.parseInt(parser.getAttributeValue(null, ATTR_VALUE));
                    continue;
                }
                if (TAG_DISABLE_ACCOUNT_MANAGEMENT.equals(tag)) {
                    this.accountTypesWithManagementDisabled = this.readDisableAccountInfo(parser, tag);
                    continue;
                }
                if (TAG_MANAGE_TRUST_AGENT_FEATURES.equals(tag)) {
                    this.trustAgentInfos = this.getAllTrustAgentInfos(parser, tag);
                    continue;
                }
                if (TAG_CROSS_PROFILE_WIDGET_PROVIDERS.equals(tag)) {
                    this.crossProfileWidgetProviders = this.getCrossProfileWidgetProviders(parser, tag);
                    continue;
                }
                if (TAG_PERMITTED_ACCESSIBILITY_SERVICES.equals(tag)) {
                    this.permittedAccessiblityServices = this.readPackageList(parser, tag);
                    continue;
                }
                if (TAG_PERMITTED_IMES.equals(tag)) {
                    this.permittedInputMethods = this.readPackageList(parser, tag);
                    continue;
                }
                Slog.w(DevicePolicyManagerService.LOG_TAG, "Unknown admin tag: " + tag);
                XmlUtils.skipCurrentTag(parser);
            }
        }

        private List<String> readPackageList(XmlPullParser parser, String tag) throws XmlPullParserException, IOException {
            int outerType;
            ArrayList<String> result = new ArrayList<String>();
            int outerDepth = parser.getDepth();
            while ((outerType = parser.next()) != 1 && (outerType != 3 || parser.getDepth() > outerDepth)) {
                if (outerType == 3 || outerType == 4) continue;
                String outerTag = parser.getName();
                if (TAG_PACKAGE_LIST_ITEM.equals(outerTag)) {
                    String packageName = parser.getAttributeValue(null, ATTR_VALUE);
                    if (packageName != null) {
                        result.add(packageName);
                        continue;
                    }
                    Slog.w(DevicePolicyManagerService.LOG_TAG, "Package name missing under " + outerTag);
                    continue;
                }
                Slog.w(DevicePolicyManagerService.LOG_TAG, "Unknown tag under " + tag + ": " + outerTag);
            }
            return result;
        }

        private Set<String> readDisableAccountInfo(XmlPullParser parser, String tag) throws XmlPullParserException, IOException {
            int typeDAM;
            int outerDepthDAM = parser.getDepth();
            HashSet<String> result = new HashSet<String>();
            while ((typeDAM = parser.next()) != 1 && (typeDAM != 3 || parser.getDepth() > outerDepthDAM)) {
                if (typeDAM == 3 || typeDAM == 4) continue;
                String tagDAM = parser.getName();
                if (TAG_ACCOUNT_TYPE.equals(tagDAM)) {
                    result.add(parser.getAttributeValue(null, ATTR_VALUE));
                    continue;
                }
                Slog.w(DevicePolicyManagerService.LOG_TAG, "Unknown tag under " + tag + ": " + tagDAM);
            }
            return result;
        }

        private HashMap<String, TrustAgentInfo> getAllTrustAgentInfos(XmlPullParser parser, String tag) throws XmlPullParserException, IOException {
            int typeDAM;
            int outerDepthDAM = parser.getDepth();
            HashMap<String, TrustAgentInfo> result = new HashMap<String, TrustAgentInfo>();
            while ((typeDAM = parser.next()) != 1 && (typeDAM != 3 || parser.getDepth() > outerDepthDAM)) {
                if (typeDAM == 3 || typeDAM == 4) continue;
                String tagDAM = parser.getName();
                if (TAG_TRUST_AGENT_COMPONENT.equals(tagDAM)) {
                    String component = parser.getAttributeValue(null, ATTR_VALUE);
                    TrustAgentInfo trustAgentInfo = this.getTrustAgentInfo(parser, tag);
                    result.put(component, trustAgentInfo);
                    continue;
                }
                Slog.w(DevicePolicyManagerService.LOG_TAG, "Unknown tag under " + tag + ": " + tagDAM);
            }
            return result;
        }

        private TrustAgentInfo getTrustAgentInfo(XmlPullParser parser, String tag) throws XmlPullParserException, IOException {
            int typeDAM;
            int outerDepthDAM = parser.getDepth();
            TrustAgentInfo result = new TrustAgentInfo(null);
            while ((typeDAM = parser.next()) != 1 && (typeDAM != 3 || parser.getDepth() > outerDepthDAM)) {
                if (typeDAM == 3 || typeDAM == 4) continue;
                String tagDAM = parser.getName();
                if (TAG_TRUST_AGENT_COMPONENT_OPTIONS.equals(tagDAM)) {
                    PersistableBundle bundle = new PersistableBundle();
                    PersistableBundle.restoreFromXml(parser);
                    result.options = bundle;
                    continue;
                }
                Slog.w(DevicePolicyManagerService.LOG_TAG, "Unknown tag under " + tag + ": " + tagDAM);
            }
            return result;
        }

        private List<String> getCrossProfileWidgetProviders(XmlPullParser parser, String tag) throws XmlPullParserException, IOException {
            int typeDAM;
            int outerDepthDAM = parser.getDepth();
            ArrayList<String> result = null;
            while ((typeDAM = parser.next()) != 1 && (typeDAM != 3 || parser.getDepth() > outerDepthDAM)) {
                if (typeDAM == 3 || typeDAM == 4) continue;
                String tagDAM = parser.getName();
                if (TAG_PROVIDER.equals(tagDAM)) {
                    String provider = parser.getAttributeValue(null, ATTR_VALUE);
                    if (result == null) {
                        result = new ArrayList<String>();
                    }
                    result.add(provider);
                    continue;
                }
                Slog.w(DevicePolicyManagerService.LOG_TAG, "Unknown tag under " + tag + ": " + tagDAM);
            }
            return result;
        }

        void dump(String prefix, PrintWriter pw) {
            pw.print(prefix);
            pw.print("uid=");
            pw.println(this.getUid());
            pw.print(prefix);
            pw.println("policies:");
            ArrayList<DeviceAdminInfo.PolicyInfo> pols = this.info.getUsedPolicies();
            if (pols != null) {
                for (int i = 0; i < pols.size(); ++i) {
                    pw.print(prefix);
                    pw.print("  ");
                    pw.println(pols.get((int)i).tag);
                }
            }
            pw.print(prefix);
            pw.print("passwordQuality=0x");
            pw.println(Integer.toHexString(this.passwordQuality));
            pw.print(prefix);
            pw.print("minimumPasswordLength=");
            pw.println(this.minimumPasswordLength);
            pw.print(prefix);
            pw.print("passwordHistoryLength=");
            pw.println(this.passwordHistoryLength);
            pw.print(prefix);
            pw.print("minimumPasswordUpperCase=");
            pw.println(this.minimumPasswordUpperCase);
            pw.print(prefix);
            pw.print("minimumPasswordLowerCase=");
            pw.println(this.minimumPasswordLowerCase);
            pw.print(prefix);
            pw.print("minimumPasswordLetters=");
            pw.println(this.minimumPasswordLetters);
            pw.print(prefix);
            pw.print("minimumPasswordNumeric=");
            pw.println(this.minimumPasswordNumeric);
            pw.print(prefix);
            pw.print("minimumPasswordSymbols=");
            pw.println(this.minimumPasswordSymbols);
            pw.print(prefix);
            pw.print("minimumPasswordNonLetter=");
            pw.println(this.minimumPasswordNonLetter);
            pw.print(prefix);
            pw.print("maximumTimeToUnlock=");
            pw.println(this.maximumTimeToUnlock);
            pw.print(prefix);
            pw.print("maximumFailedPasswordsForWipe=");
            pw.println(this.maximumFailedPasswordsForWipe);
            pw.print(prefix);
            pw.print("specifiesGlobalProxy=");
            pw.println(this.specifiesGlobalProxy);
            pw.print(prefix);
            pw.print("passwordExpirationTimeout=");
            pw.println(this.passwordExpirationTimeout);
            pw.print(prefix);
            pw.print("passwordExpirationDate=");
            pw.println(this.passwordExpirationDate);
            if (this.globalProxySpec != null) {
                pw.print(prefix);
                pw.print("globalProxySpec=");
                pw.println(this.globalProxySpec);
            }
            if (this.globalProxyExclusionList != null) {
                pw.print(prefix);
                pw.print("globalProxyEclusionList=");
                pw.println(this.globalProxyExclusionList);
            }
            pw.print(prefix);
            pw.print("encryptionRequested=");
            pw.println(this.encryptionRequested);
            pw.print(prefix);
            pw.print("disableCamera=");
            pw.println(this.disableCamera);
            pw.print(prefix);
            pw.print("disableCallerId=");
            pw.println(this.disableCallerId);
            pw.print(prefix);
            pw.print("disableBluetoothContactSharing=");
            pw.println(this.disableBluetoothContactSharing);
            pw.print(prefix);
            pw.print("disableScreenCapture=");
            pw.println(this.disableScreenCapture);
            pw.print(prefix);
            pw.print("requireAutoTime=");
            pw.println(this.requireAutoTime);
            pw.print(prefix);
            pw.print("disabledKeyguardFeatures=");
            pw.println(this.disabledKeyguardFeatures);
            pw.print(prefix);
            pw.print("crossProfileWidgetProviders=");
            pw.println(this.crossProfileWidgetProviders);
            if (this.permittedAccessiblityServices != null) {
                pw.print(prefix);
                pw.print("permittedAccessibilityServices=");
                pw.println(this.permittedAccessiblityServices.toString());
            }
            if (this.permittedInputMethods != null) {
                pw.print(prefix);
                pw.print("permittedInputMethods=");
                pw.println(this.permittedInputMethods.toString());
            }
        }

        static class TrustAgentInfo {
            public PersistableBundle options;

            TrustAgentInfo(PersistableBundle bundle) {
                this.options = bundle;
            }
        }
    }

    public static class DevicePolicyData {
        int mActivePasswordQuality = 0;
        int mActivePasswordLength = 0;
        int mActivePasswordUpperCase = 0;
        int mActivePasswordLowerCase = 0;
        int mActivePasswordLetters = 0;
        int mActivePasswordNumeric = 0;
        int mActivePasswordSymbols = 0;
        int mActivePasswordNonLetter = 0;
        int mFailedPasswordAttempts = 0;
        int mUserHandle;
        int mPasswordOwner = -1;
        long mLastMaximumTimeToLock = -1L;
        boolean mUserSetupComplete = false;
        int mPermissionPolicy;
        final HashMap<ComponentName, ActiveAdmin> mAdminMap = new HashMap();
        final ArrayList<ActiveAdmin> mAdminList = new ArrayList();
        final ArrayList<ComponentName> mRemovingAdmins = new ArrayList();
        List<String> mLockTaskPackages = new ArrayList<String>();
        boolean mStatusBarDisabled = false;
        ComponentName mRestrictionsProvider;
        String mDelegatedCertInstallerPackage;
        boolean doNotAskCredentialsOnBoot = false;

        public DevicePolicyData(int userHandle) {
            this.mUserHandle = userHandle;
        }
    }

    public static final class Lifecycle
    extends SystemService {
        private DevicePolicyManagerService mService;

        public Lifecycle(Context context) {
            super(context);
            this.mService = new DevicePolicyManagerService(context);
        }

        @Override
        public void onStart() {
            this.publishBinderService("device_policy", this.mService);
        }

        @Override
        public void onBootPhase(int phase) {
            if (phase == 480) {
                this.mService.systemReady();
            }
        }
    }
}

