/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.fingerprint;

import android.app.ActivityManager;
import android.app.ActivityManagerNative;
import android.app.AppOpsManager;
import android.app.IUserSwitchObserver;
import android.content.Context;
import android.content.pm.UserInfo;
import android.hardware.fingerprint.Fingerprint;
import android.hardware.fingerprint.IFingerprintDaemon;
import android.hardware.fingerprint.IFingerprintDaemonCallback;
import android.hardware.fingerprint.IFingerprintService;
import android.hardware.fingerprint.IFingerprintServiceReceiver;
import android.os.Binder;
import android.os.Environment;
import android.os.Handler;
import android.os.IBinder;
import android.os.IRemoteCallback;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.SELinux;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.UserManager;
import android.util.Slog;
import com.android.server.SystemService;
import com.android.server.fingerprint.FingerprintUtils;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;

public class FingerprintService
extends SystemService
implements IBinder.DeathRecipient {
    private static final String TAG = "FingerprintService";
    private static final boolean DEBUG = true;
    private static final String FP_DATA_DIR = "fpdata";
    private static final String FINGERPRINTD = "android.hardware.fingerprint.IFingerprintDaemon";
    private static final int MSG_USER_SWITCHING = 10;
    private static final int ENROLLMENT_TIMEOUT_MS = 60000;
    private ClientMonitor mAuthClient = null;
    private ClientMonitor mEnrollClient = null;
    private ClientMonitor mRemoveClient = null;
    private final AppOpsManager mAppOps;
    private static final long MS_PER_SEC = 1000L;
    private static final long FAIL_LOCKOUT_TIMEOUT_MS = 30000L;
    private static final int MAX_FAILED_ATTEMPTS = 5;
    private static final int FINGERPRINT_ACQUIRED_GOOD = 0;
    Handler mHandler = new Handler(){

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 10: {
                    FingerprintService.this.handleUserSwitching(msg.arg1);
                    break;
                }
                default: {
                    Slog.w(FingerprintService.TAG, "Unknown message:" + msg.what);
                }
            }
        }
    };
    private final FingerprintUtils mFingerprintUtils = FingerprintUtils.getInstance();
    private Context mContext;
    private long mHalDeviceId;
    private int mFailedAttempts;
    private IFingerprintDaemon mDaemon;
    private PowerManager mPowerManager;
    private final Runnable mLockoutReset = new Runnable(){

        @Override
        public void run() {
            FingerprintService.this.resetFailedAttempts();
        }
    };
    private IFingerprintDaemonCallback mDaemonCallback = new IFingerprintDaemonCallback.Stub(){

        @Override
        public void onEnrollResult(long deviceId, int fingerId, int groupId, int remaining) {
            FingerprintService.this.dispatchEnrollResult(deviceId, fingerId, groupId, remaining);
        }

        @Override
        public void onAcquired(long deviceId, int acquiredInfo) {
            FingerprintService.this.dispatchAcquired(deviceId, acquiredInfo);
        }

        @Override
        public void onAuthenticated(long deviceId, int fingerId, int groupId) {
            FingerprintService.this.dispatchAuthenticated(deviceId, fingerId, groupId);
        }

        @Override
        public void onError(long deviceId, int error) {
            FingerprintService.this.dispatchError(deviceId, error);
        }

        @Override
        public void onRemoved(long deviceId, int fingerId, int groupId) {
            FingerprintService.this.dispatchRemoved(deviceId, fingerId, groupId);
        }

        @Override
        public void onEnumerate(long deviceId, int[] fingerIds, int[] groupIds) {
            FingerprintService.this.dispatchEnumerate(deviceId, fingerIds, groupIds);
        }
    };

    public FingerprintService(Context context) {
        super(context);
        this.mContext = context;
        this.mAppOps = context.getSystemService(AppOpsManager.class);
        this.mPowerManager = (PowerManager)this.mContext.getSystemService("power");
    }

    @Override
    public void binderDied() {
        Slog.v(TAG, "fingerprintd died");
        this.mDaemon = null;
        this.dispatchError(this.mHalDeviceId, 1);
    }

    public IFingerprintDaemon getFingerprintDaemon() {
        block6: {
            if (this.mDaemon == null) {
                this.mDaemon = IFingerprintDaemon.Stub.asInterface(ServiceManager.getService(FINGERPRINTD));
                if (this.mDaemon != null) {
                    try {
                        this.mDaemon.asBinder().linkToDeath(this, 0);
                        this.mDaemon.init(this.mDaemonCallback);
                        this.mHalDeviceId = this.mDaemon.openHal();
                        if (this.mHalDeviceId != 0L) {
                            this.updateActiveGroup(ActivityManager.getCurrentUser());
                            break block6;
                        }
                        Slog.w(TAG, "Failed to open Fingerprint HAL!");
                        this.mDaemon = null;
                    }
                    catch (RemoteException e) {
                        Slog.e(TAG, "Failed to open fingeprintd HAL", e);
                        this.mDaemon = null;
                    }
                } else {
                    Slog.w(TAG, "fingerprint service not available");
                }
            }
        }
        return this.mDaemon;
    }

    protected void dispatchEnumerate(long deviceId, int[] fingerIds, int[] groupIds) {
        if (fingerIds.length != groupIds.length) {
            Slog.w(TAG, "fingerIds and groupIds differ in length: f[]=" + fingerIds + ", g[]=" + groupIds);
            return;
        }
        Slog.w(TAG, "Enumerate: f[]=" + fingerIds + ", g[]=" + groupIds);
    }

    protected void dispatchRemoved(long deviceId, int fingerId, int groupId) {
        ClientMonitor client = this.mRemoveClient;
        if (fingerId != 0) {
            this.removeTemplateForUser(this.mRemoveClient, fingerId);
        }
        if (client != null && client.sendRemoved(fingerId, groupId)) {
            this.removeClient(this.mRemoveClient);
        }
    }

    protected void dispatchError(long deviceId, int error) {
        if (this.mEnrollClient != null) {
            IBinder token = this.mEnrollClient.token;
            if (this.mEnrollClient.sendError(error)) {
                this.stopEnrollment(token, false);
            }
        } else if (this.mAuthClient != null) {
            IBinder token = this.mAuthClient.token;
            if (this.mAuthClient.sendError(error)) {
                this.stopAuthentication(token, false);
            }
        } else if (this.mRemoveClient != null && this.mRemoveClient.sendError(error)) {
            this.removeClient(this.mRemoveClient);
        }
    }

    protected void dispatchAuthenticated(long deviceId, int fingerId, int groupId) {
        if (this.mAuthClient != null) {
            IBinder token = this.mAuthClient.token;
            if (this.mAuthClient.sendAuthenticated(fingerId, groupId)) {
                this.stopAuthentication(token, false);
                this.removeClient(this.mAuthClient);
            }
        }
    }

    protected void dispatchAcquired(long deviceId, int acquiredInfo) {
        if (this.mEnrollClient != null) {
            if (this.mEnrollClient.sendAcquired(acquiredInfo)) {
                this.removeClient(this.mEnrollClient);
            }
        } else if (this.mAuthClient != null && this.mAuthClient.sendAcquired(acquiredInfo)) {
            this.removeClient(this.mAuthClient);
        }
    }

    private void userActivity() {
        long now = SystemClock.uptimeMillis();
        this.mPowerManager.userActivity(now, 2, 0);
    }

    void handleUserSwitching(int userId) {
        this.updateActiveGroup(userId);
    }

    protected void dispatchEnrollResult(long deviceId, int fingerId, int groupId, int remaining) {
        if (this.mEnrollClient != null && this.mEnrollClient.sendEnrollResult(fingerId, groupId, remaining) && remaining == 0) {
            this.addTemplateForUser(this.mEnrollClient, fingerId);
            this.removeClient(this.mEnrollClient);
        }
    }

    private void removeClient(ClientMonitor client) {
        if (client == null) {
            return;
        }
        client.destroy();
        if (client == this.mAuthClient) {
            this.mAuthClient = null;
        } else if (client == this.mEnrollClient) {
            this.mEnrollClient = null;
        } else if (client == this.mRemoveClient) {
            this.mRemoveClient = null;
        }
    }

    private boolean inLockoutMode() {
        return this.mFailedAttempts > 5;
    }

    private void resetFailedAttempts() {
        if (this.inLockoutMode()) {
            Slog.v(TAG, "Reset fingerprint lockout");
        }
        this.mFailedAttempts = 0;
    }

    private boolean handleFailedAttempt(ClientMonitor clientMonitor) {
        ++this.mFailedAttempts;
        if (this.mFailedAttempts > 5) {
            this.mHandler.removeCallbacks(this.mLockoutReset);
            this.mHandler.postDelayed(this.mLockoutReset, 30000L);
            if (clientMonitor != null && !clientMonitor.sendError(7)) {
                Slog.w(TAG, "Cannot send lockout message to client");
            }
            return true;
        }
        return false;
    }

    private void removeTemplateForUser(ClientMonitor clientMonitor, int fingerId) {
        this.mFingerprintUtils.removeFingerprintIdForUser(this.mContext, fingerId, clientMonitor.userId);
    }

    private void addTemplateForUser(ClientMonitor clientMonitor, int fingerId) {
        this.mFingerprintUtils.addFingerprintForUser(this.mContext, fingerId, clientMonitor.userId);
    }

    void startEnrollment(IBinder token, byte[] cryptoToken, int groupId, IFingerprintServiceReceiver receiver, int flags, boolean restricted) {
        IFingerprintDaemon daemon = this.getFingerprintDaemon();
        if (daemon == null) {
            Slog.w(TAG, "enroll: no fingeprintd!");
            return;
        }
        this.stopPendingOperations(true);
        this.mEnrollClient = new ClientMonitor(token, receiver, groupId, restricted);
        int timeout = 60;
        try {
            int result = daemon.enroll(cryptoToken, groupId, 60);
            if (result != 0) {
                Slog.w(TAG, "startEnroll failed, result=" + result);
            }
        }
        catch (RemoteException e) {
            Slog.e(TAG, "startEnroll failed", e);
        }
    }

    public long startPreEnroll(IBinder token) {
        IFingerprintDaemon daemon = this.getFingerprintDaemon();
        if (daemon == null) {
            Slog.w(TAG, "startPreEnroll: no fingeprintd!");
            return 0L;
        }
        try {
            return daemon.preEnroll();
        }
        catch (RemoteException e) {
            Slog.e(TAG, "startPreEnroll failed", e);
            return 0L;
        }
    }

    public int startPostEnroll(IBinder token) {
        IFingerprintDaemon daemon = this.getFingerprintDaemon();
        if (daemon == null) {
            Slog.w(TAG, "startPostEnroll: no fingeprintd!");
            return 0;
        }
        try {
            return daemon.postEnroll();
        }
        catch (RemoteException e) {
            Slog.e(TAG, "startPostEnroll failed", e);
            return 0;
        }
    }

    private void stopPendingOperations(boolean initiatedByClient) {
        if (this.mEnrollClient != null) {
            this.stopEnrollment(this.mEnrollClient.token, initiatedByClient);
        }
        if (this.mAuthClient != null) {
            this.stopAuthentication(this.mAuthClient.token, initiatedByClient);
        }
    }

    void stopEnrollment(IBinder token, boolean initiatedByClient) {
        IFingerprintDaemon daemon = this.getFingerprintDaemon();
        if (daemon == null) {
            Slog.w(TAG, "stopEnrollment: no fingeprintd!");
            return;
        }
        ClientMonitor client = this.mEnrollClient;
        if (client == null || client.token != token) {
            return;
        }
        if (initiatedByClient) {
            try {
                int result = daemon.cancelEnrollment();
                if (result != 0) {
                    Slog.w(TAG, "startEnrollCancel failed, result = " + result);
                }
            }
            catch (RemoteException e) {
                Slog.e(TAG, "stopEnrollment failed", e);
            }
            client.sendError(5);
        }
        this.removeClient(this.mEnrollClient);
    }

    void startAuthentication(IBinder token, long opId, int groupId, IFingerprintServiceReceiver receiver, int flags, boolean restricted) {
        IFingerprintDaemon daemon = this.getFingerprintDaemon();
        if (daemon == null) {
            Slog.w(TAG, "startAuthentication: no fingeprintd!");
            return;
        }
        this.stopPendingOperations(true);
        this.mAuthClient = new ClientMonitor(token, receiver, groupId, restricted);
        if (this.inLockoutMode()) {
            Slog.v(TAG, "In lockout mode; disallowing authentication");
            if (!this.mAuthClient.sendError(7)) {
                Slog.w(TAG, "Cannot send timeout message to client");
            }
            this.mAuthClient = null;
            return;
        }
        try {
            int result = daemon.authenticate(opId, groupId);
            if (result != 0) {
                Slog.w(TAG, "startAuthentication failed, result=" + result);
            }
        }
        catch (RemoteException e) {
            Slog.e(TAG, "startAuthentication failed", e);
        }
    }

    void stopAuthentication(IBinder token, boolean initiatedByClient) {
        IFingerprintDaemon daemon = this.getFingerprintDaemon();
        if (daemon == null) {
            Slog.w(TAG, "stopAuthentication: no fingeprintd!");
            return;
        }
        ClientMonitor client = this.mAuthClient;
        if (client == null || client.token != token) {
            return;
        }
        if (initiatedByClient) {
            try {
                int result = daemon.cancelAuthentication();
                if (result != 0) {
                    Slog.w(TAG, "stopAuthentication failed, result=" + result);
                }
            }
            catch (RemoteException e) {
                Slog.e(TAG, "stopAuthentication failed", e);
            }
            client.sendError(5);
        }
        this.removeClient(this.mAuthClient);
    }

    void startRemove(IBinder token, int fingerId, int userId, IFingerprintServiceReceiver receiver, boolean restricted) {
        IFingerprintDaemon daemon = this.getFingerprintDaemon();
        if (daemon == null) {
            Slog.w(TAG, "startRemove: no fingeprintd!");
            return;
        }
        this.mRemoveClient = new ClientMonitor(token, receiver, userId, restricted);
        try {
            int result = daemon.remove(fingerId, userId);
            if (result != 0) {
                Slog.w(TAG, "startRemove with id = " + fingerId + " failed, result=" + result);
            }
        }
        catch (RemoteException e) {
            Slog.e(TAG, "startRemove failed", e);
        }
    }

    public List<Fingerprint> getEnrolledFingerprints(int userId) {
        return this.mFingerprintUtils.getFingerprintsForUser(this.mContext, userId);
    }

    public boolean hasEnrolledFingerprints(int userId) {
        return this.mFingerprintUtils.getFingerprintsForUser(this.mContext, userId).size() > 0;
    }

    boolean hasPermission(String permission2) {
        return this.getContext().checkCallingOrSelfPermission(permission2) == 0;
    }

    void checkPermission(String permission2) {
        this.getContext().enforceCallingOrSelfPermission(permission2, "Must have " + permission2 + " permission.");
    }

    int getEffectiveUserId(int userId) {
        UserManager um = UserManager.get(this.mContext);
        if (um != null) {
            long callingIdentity = Binder.clearCallingIdentity();
            userId = um.getCredentialOwnerProfile(userId);
            Binder.restoreCallingIdentity(callingIdentity);
        } else {
            Slog.e(TAG, "Unable to acquire UserManager");
        }
        return userId;
    }

    boolean isCurrentUserOrProfile(int userId) {
        UserManager um = UserManager.get(this.mContext);
        List<UserInfo> profiles = um.getEnabledProfiles(userId);
        int n = profiles.size();
        for (int i = 0; i < n; ++i) {
            if (profiles.get((int)i).id != userId) continue;
            return true;
        }
        return false;
    }

    private boolean canUseFingerprint(String opPackageName) {
        this.checkPermission("android.permission.USE_FINGERPRINT");
        return this.mAppOps.noteOp(55, Binder.getCallingUid(), opPackageName) == 0;
    }

    @Override
    public void onStart() {
        this.publishBinderService("fingerprint", new FingerprintServiceWrapper());
        IFingerprintDaemon daemon = this.getFingerprintDaemon();
        Slog.v(TAG, "Fingerprint HAL id: " + this.mHalDeviceId);
        this.listenForUserSwitches();
    }

    private void updateActiveGroup(int userId) {
        IFingerprintDaemon daemon = this.getFingerprintDaemon();
        if (daemon != null) {
            try {
                userId = this.getEffectiveUserId(userId);
                File systemDir = Environment.getUserSystemDirectory(userId);
                File fpDir = new File(systemDir, FP_DATA_DIR);
                if (!fpDir.exists()) {
                    if (!fpDir.mkdir()) {
                        Slog.v(TAG, "Cannot make directory: " + fpDir.getAbsolutePath());
                        return;
                    }
                    if (!SELinux.restorecon(fpDir)) {
                        Slog.w(TAG, "Restorecons failed. Directory will have wrong label.");
                        return;
                    }
                }
                daemon.setActiveGroup(userId, fpDir.getAbsolutePath().getBytes());
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Failed to setActiveGroup():", e);
            }
        }
    }

    private void listenForUserSwitches() {
        try {
            ActivityManagerNative.getDefault().registerUserSwitchObserver(new IUserSwitchObserver.Stub(){

                @Override
                public void onUserSwitching(int newUserId, IRemoteCallback reply) {
                    FingerprintService.this.mHandler.obtainMessage(10, newUserId, 0).sendToTarget();
                }

                @Override
                public void onUserSwitchComplete(int newUserId) throws RemoteException {
                }

                @Override
                public void onForegroundProfileSwitch(int newProfileId) {
                }
            });
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Failed to listen for user switching event", e);
        }
    }

    public long getAuthenticatorId() {
        IFingerprintDaemon daemon = this.getFingerprintDaemon();
        if (daemon != null) {
            try {
                return daemon.getAuthenticatorId();
            }
            catch (RemoteException e) {
                Slog.e(TAG, "getAuthenticatorId failed", e);
            }
        }
        return 0L;
    }

    private final class FingerprintServiceWrapper
    extends IFingerprintService.Stub {
        private static final String KEYGUARD_PACKAGE = "com.android.systemui";

        private FingerprintServiceWrapper() {
        }

        @Override
        public long preEnroll(IBinder token) {
            FingerprintService.this.checkPermission("android.permission.MANAGE_FINGERPRINT");
            return FingerprintService.this.startPreEnroll(token);
        }

        @Override
        public int postEnroll(IBinder token) {
            FingerprintService.this.checkPermission("android.permission.MANAGE_FINGERPRINT");
            return FingerprintService.this.startPostEnroll(token);
        }

        @Override
        public void enroll(final IBinder token, byte[] cryptoToken, int groupId, final IFingerprintServiceReceiver receiver, final int flags) {
            FingerprintService.this.checkPermission("android.permission.MANAGE_FINGERPRINT");
            int limit = FingerprintService.this.mContext.getResources().getInteger(17694871);
            int callingUid = Binder.getCallingUid();
            int userId = UserHandle.getUserId(callingUid);
            int enrolled = FingerprintService.this.getEnrolledFingerprints(userId).size();
            if (enrolled >= limit) {
                Slog.w(FingerprintService.TAG, "Too many fingerprints registered");
                return;
            }
            final byte[] cryptoClone = Arrays.copyOf(cryptoToken, cryptoToken.length);
            final int effectiveGroupId = FingerprintService.this.getEffectiveUserId(groupId);
            final boolean restricted = this.isRestricted();
            FingerprintService.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    FingerprintService.this.startEnrollment(token, cryptoClone, effectiveGroupId, receiver, flags, restricted);
                }
            });
        }

        private boolean isRestricted() {
            boolean restricted = !FingerprintService.this.hasPermission("android.permission.MANAGE_FINGERPRINT");
            return restricted;
        }

        @Override
        public void cancelEnrollment(final IBinder token) {
            FingerprintService.this.checkPermission("android.permission.MANAGE_FINGERPRINT");
            FingerprintService.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    FingerprintService.this.stopEnrollment(token, true);
                }
            });
        }

        @Override
        public void authenticate(final IBinder token, final long opId, int groupId, final IFingerprintServiceReceiver receiver, final int flags, String opPackageName) {
            if (!FingerprintService.this.isCurrentUserOrProfile(UserHandle.getCallingUserId())) {
                Slog.w(FingerprintService.TAG, "Can't authenticate non-current user");
                return;
            }
            if (!FingerprintService.this.canUseFingerprint(opPackageName)) {
                Slog.w(FingerprintService.TAG, "Calling not granted permission to use fingerprint");
                return;
            }
            final int effectiveGroupId = FingerprintService.this.getEffectiveUserId(groupId);
            final boolean restricted = this.isRestricted();
            FingerprintService.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    FingerprintService.this.startAuthentication(token, opId, effectiveGroupId, receiver, flags, restricted);
                }
            });
        }

        @Override
        public void cancelAuthentication(final IBinder token, String opPackageName) {
            if (!FingerprintService.this.canUseFingerprint(opPackageName)) {
                return;
            }
            FingerprintService.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    FingerprintService.this.stopAuthentication(token, true);
                }
            });
        }

        @Override
        public void remove(final IBinder token, final int fingerId, int groupId, final IFingerprintServiceReceiver receiver) {
            FingerprintService.this.checkPermission("android.permission.MANAGE_FINGERPRINT");
            final boolean restricted = this.isRestricted();
            final int effectiveGroupId = FingerprintService.this.getEffectiveUserId(groupId);
            FingerprintService.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    FingerprintService.this.startRemove(token, fingerId, effectiveGroupId, receiver, restricted);
                }
            });
        }

        @Override
        public boolean isHardwareDetected(long deviceId, String opPackageName) {
            if (!FingerprintService.this.canUseFingerprint(opPackageName)) {
                return false;
            }
            return FingerprintService.this.mHalDeviceId != 0L;
        }

        @Override
        public void rename(final int fingerId, int groupId, final String name) {
            FingerprintService.this.checkPermission("android.permission.MANAGE_FINGERPRINT");
            final int effectiveGroupId = FingerprintService.this.getEffectiveUserId(groupId);
            FingerprintService.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    FingerprintService.this.mFingerprintUtils.renameFingerprintForUser(FingerprintService.this.mContext, fingerId, effectiveGroupId, name);
                }
            });
        }

        @Override
        public List<Fingerprint> getEnrolledFingerprints(int userId, String opPackageName) {
            if (!FingerprintService.this.canUseFingerprint(opPackageName)) {
                return Collections.emptyList();
            }
            int effectiveUserId = FingerprintService.this.getEffectiveUserId(userId);
            return FingerprintService.this.getEnrolledFingerprints(effectiveUserId);
        }

        @Override
        public boolean hasEnrolledFingerprints(int userId, String opPackageName) {
            if (!FingerprintService.this.canUseFingerprint(opPackageName)) {
                return false;
            }
            int effectiveUserId = FingerprintService.this.getEffectiveUserId(userId);
            return FingerprintService.this.hasEnrolledFingerprints(effectiveUserId);
        }

        @Override
        public long getAuthenticatorId(String opPackageName) {
            return FingerprintService.this.getAuthenticatorId();
        }
    }

    private class ClientMonitor
    implements IBinder.DeathRecipient {
        IBinder token;
        IFingerprintServiceReceiver receiver;
        int userId;
        boolean restricted;

        public ClientMonitor(IBinder token, IFingerprintServiceReceiver receiver, int userId, boolean restricted) {
            this.token = token;
            this.receiver = receiver;
            this.userId = userId;
            this.restricted = restricted;
            try {
                token.linkToDeath(this, 0);
            }
            catch (RemoteException e) {
                Slog.w(FingerprintService.TAG, "caught remote exception in linkToDeath: ", e);
            }
        }

        public void destroy() {
            if (this.token != null) {
                try {
                    this.token.unlinkToDeath(this, 0);
                }
                catch (NoSuchElementException e) {
                    Slog.e(FingerprintService.TAG, "destroy(): " + this + ":", new Exception("here"));
                }
                this.token = null;
            }
            this.receiver = null;
        }

        @Override
        public void binderDied() {
            this.token = null;
            FingerprintService.this.removeClient(this);
            this.receiver = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                if (this.token != null) {
                    Slog.w(FingerprintService.TAG, "removing leaked reference: " + this.token);
                    FingerprintService.this.removeClient(this);
                }
            }
            finally {
                super.finalize();
            }
        }

        private boolean sendRemoved(int fingerId, int groupId) {
            if (this.receiver == null) {
                return true;
            }
            try {
                this.receiver.onRemoved(FingerprintService.this.mHalDeviceId, fingerId, groupId);
                return fingerId == 0;
            }
            catch (RemoteException e) {
                Slog.w(FingerprintService.TAG, "Failed to notify Removed:", e);
                return false;
            }
        }

        private boolean sendEnrollResult(int fpId, int groupId, int remaining) {
            if (this.receiver == null) {
                return true;
            }
            FingerprintUtils.vibrateFingerprintSuccess(FingerprintService.this.getContext());
            try {
                this.receiver.onEnrollResult(FingerprintService.this.mHalDeviceId, fpId, groupId, remaining);
                return remaining == 0;
            }
            catch (RemoteException e) {
                Slog.w(FingerprintService.TAG, "Failed to notify EnrollResult:", e);
                return true;
            }
        }

        private boolean sendAuthenticated(int fpId, int groupId) {
            boolean result;
            block7: {
                boolean authenticated;
                result = false;
                boolean bl = authenticated = fpId != 0;
                if (this.receiver != null) {
                    try {
                        if (!authenticated) {
                            this.receiver.onAuthenticationFailed(FingerprintService.this.mHalDeviceId);
                            break block7;
                        }
                        Fingerprint fp = !this.restricted ? new Fingerprint("", groupId, fpId, FingerprintService.this.mHalDeviceId) : null;
                        this.receiver.onAuthenticationSucceeded(FingerprintService.this.mHalDeviceId, fp);
                    }
                    catch (RemoteException e) {
                        Slog.w(FingerprintService.TAG, "Failed to notify Authenticated:", e);
                        result = true;
                    }
                } else {
                    result = true;
                }
            }
            if (fpId == 0) {
                FingerprintUtils.vibrateFingerprintError(FingerprintService.this.getContext());
                result |= FingerprintService.this.handleFailedAttempt(this);
            } else {
                FingerprintUtils.vibrateFingerprintSuccess(FingerprintService.this.getContext());
                result |= true;
                FingerprintService.this.mLockoutReset.run();
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean sendAcquired(int acquiredInfo) {
            if (this.receiver == null) {
                return true;
            }
            try {
                this.receiver.onAcquired(FingerprintService.this.mHalDeviceId, acquiredInfo);
                boolean bl = false;
                return bl;
            }
            catch (RemoteException e) {
                Slog.w(FingerprintService.TAG, "Failed to invoke sendAcquired:", e);
                boolean bl = true;
                return bl;
            }
            finally {
                if (acquiredInfo == 0) {
                    FingerprintService.this.userActivity();
                }
            }
        }

        private boolean sendError(int error) {
            if (this.receiver != null) {
                try {
                    this.receiver.onError(FingerprintService.this.mHalDeviceId, error);
                }
                catch (RemoteException e) {
                    Slog.w(FingerprintService.TAG, "Failed to invoke sendError:", e);
                }
            }
            return true;
        }
    }
}

