/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.hdmi;

import android.hardware.hdmi.HdmiDeviceInfo;
import android.hardware.input.InputManager;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.util.Slog;
import android.view.KeyEvent;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.hdmi.HdmiAnnotations;
import com.android.server.hdmi.HdmiCecFeatureAction;
import com.android.server.hdmi.HdmiCecKeycode;
import com.android.server.hdmi.HdmiCecLocalDevicePlayback;
import com.android.server.hdmi.HdmiCecLocalDeviceTv;
import com.android.server.hdmi.HdmiCecMessage;
import com.android.server.hdmi.HdmiCecMessageBuilder;
import com.android.server.hdmi.HdmiCecMessageCache;
import com.android.server.hdmi.HdmiControlService;
import com.android.server.hdmi.HdmiUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

abstract class HdmiCecLocalDevice {
    private static final String TAG = "HdmiCecLocalDevice";
    private static final int MSG_DISABLE_DEVICE_TIMEOUT = 1;
    private static final int MSG_USER_CONTROL_RELEASE_TIMEOUT = 2;
    private static final int DEVICE_CLEANUP_TIMEOUT = 5000;
    private static final int FOLLOWER_SAFETY_TIMEOUT = 550;
    protected final HdmiControlService mService;
    protected final int mDeviceType;
    protected int mAddress;
    protected int mPreferredAddress;
    protected HdmiDeviceInfo mDeviceInfo;
    protected int mLastKeycode = -1;
    protected int mLastKeyRepeatCount = 0;
    @GuardedBy(value="mLock")
    protected final ActiveSource mActiveSource = new ActiveSource();
    @GuardedBy(value="mLock")
    private int mActiveRoutingPath;
    protected final HdmiCecMessageCache mCecMessageCache = new HdmiCecMessageCache();
    protected final Object mLock;
    private final ArrayList<HdmiCecFeatureAction> mActions = new ArrayList();
    private final Handler mHandler = new Handler(){

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    HdmiCecLocalDevice.this.handleDisableDeviceTimeout();
                    break;
                }
                case 2: {
                    HdmiCecLocalDevice.this.handleUserControlReleased();
                }
            }
        }
    };
    protected PendingActionClearedCallback mPendingActionClearedCallback;

    protected HdmiCecLocalDevice(HdmiControlService service, int deviceType) {
        this.mService = service;
        this.mDeviceType = deviceType;
        this.mAddress = 15;
        this.mLock = service.getServiceLock();
    }

    static HdmiCecLocalDevice create(HdmiControlService service, int deviceType) {
        switch (deviceType) {
            case 0: {
                return new HdmiCecLocalDeviceTv(service);
            }
            case 4: {
                return new HdmiCecLocalDevicePlayback(service);
            }
        }
        return null;
    }

    @HdmiAnnotations.ServiceThreadOnly
    void init() {
        this.assertRunOnServiceThread();
        this.mPreferredAddress = this.getPreferredAddress();
        this.mPendingActionClearedCallback = null;
    }

    protected abstract void onAddressAllocated(int var1, int var2);

    protected abstract int getPreferredAddress();

    protected abstract void setPreferredAddress(int var1);

    protected boolean isInputReady(int deviceId) {
        return true;
    }

    protected boolean canGoToStandby() {
        return true;
    }

    @HdmiAnnotations.ServiceThreadOnly
    boolean dispatchMessage(HdmiCecMessage message) {
        this.assertRunOnServiceThread();
        int dest = message.getDestination();
        if (dest != this.mAddress && dest != 15) {
            return false;
        }
        this.mCecMessageCache.cacheMessage(message);
        return this.onMessage(message);
    }

    @HdmiAnnotations.ServiceThreadOnly
    protected final boolean onMessage(HdmiCecMessage message) {
        this.assertRunOnServiceThread();
        if (this.dispatchMessageToAction(message)) {
            return true;
        }
        switch (message.getOpcode()) {
            case 130: {
                return this.handleActiveSource(message);
            }
            case 157: {
                return this.handleInactiveSource(message);
            }
            case 133: {
                return this.handleRequestActiveSource(message);
            }
            case 145: {
                return this.handleGetMenuLanguage(message);
            }
            case 50: {
                return this.handleSetMenuLanguage(message);
            }
            case 131: {
                return this.handleGivePhysicalAddress();
            }
            case 70: {
                return this.handleGiveOsdName(message);
            }
            case 140: {
                return this.handleGiveDeviceVendorId();
            }
            case 159: {
                return this.handleGetCecVersion(message);
            }
            case 132: {
                return this.handleReportPhysicalAddress(message);
            }
            case 128: {
                return this.handleRoutingChange(message);
            }
            case 129: {
                return this.handleRoutingInformation(message);
            }
            case 192: {
                return this.handleInitiateArc(message);
            }
            case 197: {
                return this.handleTerminateArc(message);
            }
            case 114: {
                return this.handleSetSystemAudioMode(message);
            }
            case 126: {
                return this.handleSystemAudioModeStatus(message);
            }
            case 122: {
                return this.handleReportAudioStatus(message);
            }
            case 54: {
                return this.handleStandby(message);
            }
            case 13: {
                return this.handleTextViewOn(message);
            }
            case 4: {
                return this.handleImageViewOn(message);
            }
            case 68: {
                return this.handleUserControlPressed(message);
            }
            case 69: {
                return this.handleUserControlReleased();
            }
            case 134: {
                return this.handleSetStreamPath(message);
            }
            case 143: {
                return this.handleGiveDevicePowerStatus(message);
            }
            case 141: {
                return this.handleMenuRequest(message);
            }
            case 142: {
                return this.handleMenuStatus(message);
            }
            case 137: {
                return this.handleVendorCommand(message);
            }
            case 160: {
                return this.handleVendorCommandWithId(message);
            }
            case 71: {
                return this.handleSetOsdName(message);
            }
            case 15: {
                return this.handleRecordTvScreen(message);
            }
            case 67: {
                return this.handleTimerClearedStatus(message);
            }
            case 144: {
                return this.handleReportPowerStatus(message);
            }
            case 53: {
                return this.handleTimerStatus(message);
            }
            case 10: {
                return this.handleRecordStatus(message);
            }
        }
        return false;
    }

    @HdmiAnnotations.ServiceThreadOnly
    private boolean dispatchMessageToAction(HdmiCecMessage message) {
        this.assertRunOnServiceThread();
        boolean processed = false;
        for (HdmiCecFeatureAction action : new ArrayList<HdmiCecFeatureAction>(this.mActions)) {
            boolean result = action.processCommand(message);
            processed = processed || result;
        }
        return processed;
    }

    @HdmiAnnotations.ServiceThreadOnly
    protected boolean handleGivePhysicalAddress() {
        this.assertRunOnServiceThread();
        int physicalAddress = this.mService.getPhysicalAddress();
        HdmiCecMessage cecMessage = HdmiCecMessageBuilder.buildReportPhysicalAddressCommand(this.mAddress, physicalAddress, this.mDeviceType);
        this.mService.sendCecCommand(cecMessage);
        return true;
    }

    @HdmiAnnotations.ServiceThreadOnly
    protected boolean handleGiveDeviceVendorId() {
        this.assertRunOnServiceThread();
        int vendorId = this.mService.getVendorId();
        HdmiCecMessage cecMessage = HdmiCecMessageBuilder.buildDeviceVendorIdCommand(this.mAddress, vendorId);
        this.mService.sendCecCommand(cecMessage);
        return true;
    }

    @HdmiAnnotations.ServiceThreadOnly
    protected boolean handleGetCecVersion(HdmiCecMessage message) {
        this.assertRunOnServiceThread();
        int version = this.mService.getCecVersion();
        HdmiCecMessage cecMessage = HdmiCecMessageBuilder.buildCecVersion(message.getDestination(), message.getSource(), version);
        this.mService.sendCecCommand(cecMessage);
        return true;
    }

    @HdmiAnnotations.ServiceThreadOnly
    protected boolean handleActiveSource(HdmiCecMessage message) {
        return false;
    }

    @HdmiAnnotations.ServiceThreadOnly
    protected boolean handleInactiveSource(HdmiCecMessage message) {
        return false;
    }

    @HdmiAnnotations.ServiceThreadOnly
    protected boolean handleRequestActiveSource(HdmiCecMessage message) {
        return false;
    }

    @HdmiAnnotations.ServiceThreadOnly
    protected boolean handleGetMenuLanguage(HdmiCecMessage message) {
        this.assertRunOnServiceThread();
        Slog.w(TAG, "Only TV can handle <Get Menu Language>:" + message.toString());
        return false;
    }

    @HdmiAnnotations.ServiceThreadOnly
    protected boolean handleSetMenuLanguage(HdmiCecMessage message) {
        this.assertRunOnServiceThread();
        Slog.w(TAG, "Only Playback device can handle <Set Menu Language>:" + message.toString());
        return false;
    }

    @HdmiAnnotations.ServiceThreadOnly
    protected boolean handleGiveOsdName(HdmiCecMessage message) {
        this.assertRunOnServiceThread();
        HdmiCecMessage cecMessage = HdmiCecMessageBuilder.buildSetOsdNameCommand(this.mAddress, message.getSource(), this.mDeviceInfo.getDisplayName());
        if (cecMessage != null) {
            this.mService.sendCecCommand(cecMessage);
        } else {
            Slog.w(TAG, "Failed to build <Get Osd Name>:" + this.mDeviceInfo.getDisplayName());
        }
        return true;
    }

    protected boolean handleRoutingChange(HdmiCecMessage message) {
        return false;
    }

    protected boolean handleRoutingInformation(HdmiCecMessage message) {
        return false;
    }

    protected boolean handleReportPhysicalAddress(HdmiCecMessage message) {
        return false;
    }

    protected boolean handleSystemAudioModeStatus(HdmiCecMessage message) {
        return false;
    }

    protected boolean handleSetSystemAudioMode(HdmiCecMessage message) {
        return false;
    }

    protected boolean handleTerminateArc(HdmiCecMessage message) {
        return false;
    }

    protected boolean handleInitiateArc(HdmiCecMessage message) {
        return false;
    }

    protected boolean handleReportAudioStatus(HdmiCecMessage message) {
        return false;
    }

    @HdmiAnnotations.ServiceThreadOnly
    protected boolean handleStandby(HdmiCecMessage message) {
        this.assertRunOnServiceThread();
        if (this.mService.isControlEnabled() && !this.mService.isProhibitMode() && this.mService.isPowerOnOrTransient()) {
            this.mService.standby();
            return true;
        }
        return false;
    }

    @HdmiAnnotations.ServiceThreadOnly
    protected boolean handleUserControlPressed(HdmiCecMessage message) {
        this.assertRunOnServiceThread();
        this.mHandler.removeMessages(2);
        if (this.mService.isPowerOnOrTransient() && HdmiCecLocalDevice.isPowerOffOrToggleCommand(message)) {
            this.mService.standby();
            return true;
        }
        if (this.mService.isPowerStandbyOrTransient() && HdmiCecLocalDevice.isPowerOnOrToggleCommand(message)) {
            this.mService.wakeUp();
            return true;
        }
        long downTime = SystemClock.uptimeMillis();
        byte[] params = message.getParams();
        int keycode = HdmiCecKeycode.cecKeycodeAndParamsToAndroidKey(params);
        int keyRepeatCount = 0;
        if (this.mLastKeycode != -1) {
            if (keycode == this.mLastKeycode) {
                keyRepeatCount = this.mLastKeyRepeatCount + 1;
            } else {
                HdmiCecLocalDevice.injectKeyEvent(downTime, 1, this.mLastKeycode, 0);
            }
        }
        this.mLastKeycode = keycode;
        this.mLastKeyRepeatCount = keyRepeatCount;
        if (keycode != -1) {
            HdmiCecLocalDevice.injectKeyEvent(downTime, 0, keycode, keyRepeatCount);
            this.mHandler.sendMessageDelayed(Message.obtain(this.mHandler, 2), 550L);
            return true;
        }
        return false;
    }

    @HdmiAnnotations.ServiceThreadOnly
    protected boolean handleUserControlReleased() {
        this.assertRunOnServiceThread();
        this.mHandler.removeMessages(2);
        this.mLastKeyRepeatCount = 0;
        if (this.mLastKeycode != -1) {
            long upTime = SystemClock.uptimeMillis();
            HdmiCecLocalDevice.injectKeyEvent(upTime, 1, this.mLastKeycode, 0);
            this.mLastKeycode = -1;
            return true;
        }
        return false;
    }

    static void injectKeyEvent(long time, int action, int keycode, int repeat) {
        KeyEvent keyEvent = KeyEvent.obtain(time, time, action, keycode, repeat, 0, -1, 0, 8, 0x2000001, null);
        InputManager.getInstance().injectInputEvent(keyEvent, 0);
        keyEvent.recycle();
    }

    static boolean isPowerOnOrToggleCommand(HdmiCecMessage message) {
        byte[] params = message.getParams();
        return message.getOpcode() == 68 && (params[0] == 64 || params[0] == 109 || params[0] == 107);
    }

    static boolean isPowerOffOrToggleCommand(HdmiCecMessage message) {
        byte[] params = message.getParams();
        return message.getOpcode() == 68 && (params[0] == 64 || params[0] == 108 || params[0] == 107);
    }

    protected boolean handleTextViewOn(HdmiCecMessage message) {
        return false;
    }

    protected boolean handleImageViewOn(HdmiCecMessage message) {
        return false;
    }

    protected boolean handleSetStreamPath(HdmiCecMessage message) {
        return false;
    }

    protected boolean handleGiveDevicePowerStatus(HdmiCecMessage message) {
        this.mService.sendCecCommand(HdmiCecMessageBuilder.buildReportPowerStatus(this.mAddress, message.getSource(), this.mService.getPowerStatus()));
        return true;
    }

    protected boolean handleMenuRequest(HdmiCecMessage message) {
        this.mService.sendCecCommand(HdmiCecMessageBuilder.buildReportMenuStatus(this.mAddress, message.getSource(), 0));
        return true;
    }

    protected boolean handleMenuStatus(HdmiCecMessage message) {
        return false;
    }

    protected boolean handleVendorCommand(HdmiCecMessage message) {
        if (!this.mService.invokeVendorCommandListenersOnReceived(this.mDeviceType, message.getSource(), message.getDestination(), message.getParams(), false)) {
            this.mService.maySendFeatureAbortCommand(message, 1);
        }
        return true;
    }

    protected boolean handleVendorCommandWithId(HdmiCecMessage message) {
        byte[] params = message.getParams();
        int vendorId = HdmiUtils.threeBytesToInt(params);
        if (vendorId == this.mService.getVendorId()) {
            if (!this.mService.invokeVendorCommandListenersOnReceived(this.mDeviceType, message.getSource(), message.getDestination(), params, true)) {
                this.mService.maySendFeatureAbortCommand(message, 1);
            }
        } else if (message.getDestination() != 15 && message.getSource() != 15) {
            Slog.v(TAG, "Wrong direct vendor command. Replying with <Feature Abort>");
            this.mService.maySendFeatureAbortCommand(message, 0);
        } else {
            Slog.v(TAG, "Wrong broadcast vendor command. Ignoring");
        }
        return true;
    }

    protected void sendStandby(int deviceId) {
    }

    protected boolean handleSetOsdName(HdmiCecMessage message) {
        return true;
    }

    protected boolean handleRecordTvScreen(HdmiCecMessage message) {
        this.mService.maySendFeatureAbortCommand(message, 2);
        return true;
    }

    protected boolean handleTimerClearedStatus(HdmiCecMessage message) {
        return false;
    }

    protected boolean handleReportPowerStatus(HdmiCecMessage message) {
        return false;
    }

    protected boolean handleTimerStatus(HdmiCecMessage message) {
        return false;
    }

    protected boolean handleRecordStatus(HdmiCecMessage message) {
        return false;
    }

    @HdmiAnnotations.ServiceThreadOnly
    final void handleAddressAllocated(int logicalAddress, int reason) {
        this.assertRunOnServiceThread();
        this.mAddress = this.mPreferredAddress = logicalAddress;
        this.onAddressAllocated(logicalAddress, reason);
        this.setPreferredAddress(logicalAddress);
    }

    int getType() {
        return this.mDeviceType;
    }

    @HdmiAnnotations.ServiceThreadOnly
    HdmiDeviceInfo getDeviceInfo() {
        this.assertRunOnServiceThread();
        return this.mDeviceInfo;
    }

    @HdmiAnnotations.ServiceThreadOnly
    void setDeviceInfo(HdmiDeviceInfo info) {
        this.assertRunOnServiceThread();
        this.mDeviceInfo = info;
    }

    @HdmiAnnotations.ServiceThreadOnly
    boolean isAddressOf(int addr) {
        this.assertRunOnServiceThread();
        return addr == this.mAddress;
    }

    @HdmiAnnotations.ServiceThreadOnly
    void clearAddress() {
        this.assertRunOnServiceThread();
        this.mAddress = 15;
    }

    @HdmiAnnotations.ServiceThreadOnly
    void addAndStartAction(HdmiCecFeatureAction action) {
        this.assertRunOnServiceThread();
        this.mActions.add(action);
        if (this.mService.isPowerStandby()) {
            Slog.i(TAG, "Not ready to start action. Queued for deferred start:" + action);
            return;
        }
        action.start();
    }

    @HdmiAnnotations.ServiceThreadOnly
    void startQueuedActions() {
        this.assertRunOnServiceThread();
        for (HdmiCecFeatureAction action : this.mActions) {
            if (action.started()) continue;
            Slog.i(TAG, "Starting queued action:" + action);
            action.start();
        }
    }

    @HdmiAnnotations.ServiceThreadOnly
    <T extends HdmiCecFeatureAction> boolean hasAction(Class<T> clazz) {
        this.assertRunOnServiceThread();
        for (HdmiCecFeatureAction action : this.mActions) {
            if (!action.getClass().equals(clazz)) continue;
            return true;
        }
        return false;
    }

    @HdmiAnnotations.ServiceThreadOnly
    <T extends HdmiCecFeatureAction> List<T> getActions(Class<T> clazz) {
        this.assertRunOnServiceThread();
        List actions = Collections.emptyList();
        for (HdmiCecFeatureAction action : this.mActions) {
            if (!action.getClass().equals(clazz)) continue;
            if (actions.isEmpty()) {
                actions = new ArrayList();
            }
            actions.add(action);
        }
        return actions;
    }

    @HdmiAnnotations.ServiceThreadOnly
    void removeAction(HdmiCecFeatureAction action) {
        this.assertRunOnServiceThread();
        action.finish(false);
        this.mActions.remove(action);
        this.checkIfPendingActionsCleared();
    }

    @HdmiAnnotations.ServiceThreadOnly
    <T extends HdmiCecFeatureAction> void removeAction(Class<T> clazz) {
        this.assertRunOnServiceThread();
        this.removeActionExcept(clazz, null);
    }

    @HdmiAnnotations.ServiceThreadOnly
    <T extends HdmiCecFeatureAction> void removeActionExcept(Class<T> clazz, HdmiCecFeatureAction exception) {
        this.assertRunOnServiceThread();
        Iterator<HdmiCecFeatureAction> iter = this.mActions.iterator();
        while (iter.hasNext()) {
            HdmiCecFeatureAction action = iter.next();
            if (action == exception || !action.getClass().equals(clazz)) continue;
            action.finish(false);
            iter.remove();
        }
        this.checkIfPendingActionsCleared();
    }

    protected void checkIfPendingActionsCleared() {
        if (this.mActions.isEmpty() && this.mPendingActionClearedCallback != null) {
            PendingActionClearedCallback callback = this.mPendingActionClearedCallback;
            this.mPendingActionClearedCallback = null;
            callback.onCleared(this);
        }
    }

    protected void assertRunOnServiceThread() {
        if (Looper.myLooper() != this.mService.getServiceLooper()) {
            throw new IllegalStateException("Should run on service thread.");
        }
    }

    void setAutoDeviceOff(boolean enabled) {
    }

    void onHotplug(int portId, boolean connected) {
    }

    final HdmiControlService getService() {
        return this.mService;
    }

    @HdmiAnnotations.ServiceThreadOnly
    final boolean isConnectedToArcPort(int path) {
        this.assertRunOnServiceThread();
        return this.mService.isConnectedToArcPort(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ActiveSource getActiveSource() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mActiveSource;
        }
    }

    void setActiveSource(ActiveSource newActive) {
        this.setActiveSource(newActive.logicalAddress, newActive.physicalAddress);
    }

    void setActiveSource(HdmiDeviceInfo info) {
        this.setActiveSource(info.getLogicalAddress(), info.getPhysicalAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setActiveSource(int logicalAddress, int physicalAddress) {
        Object object = this.mLock;
        synchronized (object) {
            this.mActiveSource.logicalAddress = logicalAddress;
            this.mActiveSource.physicalAddress = physicalAddress;
        }
        this.mService.setLastInputForMhl(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getActivePath() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mActiveRoutingPath;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setActivePath(int path) {
        Object object = this.mLock;
        synchronized (object) {
            this.mActiveRoutingPath = path;
        }
        this.mService.setActivePortId(this.pathToPortId(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getActivePortId() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mService.pathToPortId(this.mActiveRoutingPath);
        }
    }

    void setActivePortId(int portId) {
        this.setActivePath(this.mService.portIdToPath(portId));
    }

    @HdmiAnnotations.ServiceThreadOnly
    HdmiCecMessageCache getCecMessageCache() {
        this.assertRunOnServiceThread();
        return this.mCecMessageCache;
    }

    @HdmiAnnotations.ServiceThreadOnly
    int pathToPortId(int newPath) {
        this.assertRunOnServiceThread();
        return this.mService.pathToPortId(newPath);
    }

    protected void onStandby(boolean initiatedByCec, int standbyAction) {
    }

    protected void disableDevice(boolean initiatedByCec, final PendingActionClearedCallback originalCallback) {
        this.mPendingActionClearedCallback = new PendingActionClearedCallback(){

            @Override
            public void onCleared(HdmiCecLocalDevice device) {
                HdmiCecLocalDevice.this.mHandler.removeMessages(1);
                originalCallback.onCleared(device);
            }
        };
        this.mHandler.sendMessageDelayed(Message.obtain(this.mHandler, 1), 5000L);
    }

    @HdmiAnnotations.ServiceThreadOnly
    private void handleDisableDeviceTimeout() {
        this.assertRunOnServiceThread();
        Iterator<HdmiCecFeatureAction> iter = this.mActions.iterator();
        while (iter.hasNext()) {
            HdmiCecFeatureAction action = iter.next();
            action.finish(false);
            iter.remove();
        }
        if (this.mPendingActionClearedCallback != null) {
            this.mPendingActionClearedCallback.onCleared(this);
        }
    }

    protected void sendKeyEvent(int keyCode, boolean isPressed) {
        Slog.w(TAG, "sendKeyEvent not implemented");
    }

    void sendUserControlPressedAndReleased(int targetAddress, int cecKeycode) {
        this.mService.sendCecCommand(HdmiCecMessageBuilder.buildUserControlPressed(this.mAddress, targetAddress, cecKeycode));
        this.mService.sendCecCommand(HdmiCecMessageBuilder.buildUserControlReleased(this.mAddress, targetAddress));
    }

    protected void dump(IndentingPrintWriter pw) {
        pw.println("mDeviceType: " + this.mDeviceType);
        pw.println("mAddress: " + this.mAddress);
        pw.println("mPreferredAddress: " + this.mPreferredAddress);
        pw.println("mDeviceInfo: " + this.mDeviceInfo);
        pw.println("mActiveSource: " + this.mActiveSource);
        pw.println(String.format("mActiveRoutingPath: 0x%04x", this.mActiveRoutingPath));
    }

    static interface PendingActionClearedCallback {
        public void onCleared(HdmiCecLocalDevice var1);
    }

    static class ActiveSource {
        int logicalAddress;
        int physicalAddress;

        public ActiveSource() {
            this.invalidate();
        }

        public ActiveSource(int logical, int physical) {
            this.logicalAddress = logical;
            this.physicalAddress = physical;
        }

        public static ActiveSource of(ActiveSource source) {
            return new ActiveSource(source.logicalAddress, source.physicalAddress);
        }

        public static ActiveSource of(int logical, int physical) {
            return new ActiveSource(logical, physical);
        }

        public boolean isValid() {
            return HdmiUtils.isValidAddress(this.logicalAddress);
        }

        public void invalidate() {
            this.logicalAddress = -1;
            this.physicalAddress = 65535;
        }

        public boolean equals(int logical, int physical) {
            return this.logicalAddress == logical && this.physicalAddress == physical;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ActiveSource) {
                ActiveSource that = (ActiveSource)obj;
                return that.logicalAddress == this.logicalAddress && that.physicalAddress == this.physicalAddress;
            }
            return false;
        }

        public int hashCode() {
            return this.logicalAddress * 29 + this.physicalAddress;
        }

        public String toString() {
            StringBuffer s = new StringBuffer();
            String logicalAddressString = this.logicalAddress == -1 ? "invalid" : String.format("0x%02x", this.logicalAddress);
            s.append("(").append(logicalAddressString);
            String physicalAddressString = this.physicalAddress == 65535 ? "invalid" : String.format("0x%04x", this.physicalAddress);
            s.append(", ").append(physicalAddressString).append(")");
            return s.toString();
        }
    }
}

