/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.hdmi;

import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.hardware.hdmi.HdmiDeviceInfo;
import android.hardware.hdmi.HdmiHotplugEvent;
import android.hardware.hdmi.HdmiPortInfo;
import android.hardware.hdmi.IHdmiControlCallback;
import android.hardware.hdmi.IHdmiControlService;
import android.hardware.hdmi.IHdmiDeviceEventListener;
import android.hardware.hdmi.IHdmiHotplugEventListener;
import android.hardware.hdmi.IHdmiInputChangeListener;
import android.hardware.hdmi.IHdmiMhlVendorCommandListener;
import android.hardware.hdmi.IHdmiRecordListener;
import android.hardware.hdmi.IHdmiSystemAudioModeChangeListener;
import android.hardware.hdmi.IHdmiVendorCommandListener;
import android.media.AudioManager;
import android.media.tv.TvInputManager;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.ArraySet;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseIntArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.SystemService;
import com.android.server.hdmi.HdmiAnnotations;
import com.android.server.hdmi.HdmiCecController;
import com.android.server.hdmi.HdmiCecLocalDevice;
import com.android.server.hdmi.HdmiCecLocalDevicePlayback;
import com.android.server.hdmi.HdmiCecLocalDeviceTv;
import com.android.server.hdmi.HdmiCecMessage;
import com.android.server.hdmi.HdmiCecMessageBuilder;
import com.android.server.hdmi.HdmiCecMessageValidator;
import com.android.server.hdmi.HdmiLogger;
import com.android.server.hdmi.HdmiMhlControllerStub;
import com.android.server.hdmi.HdmiMhlLocalDeviceStub;
import com.android.server.hdmi.HdmiUtils;
import com.android.server.hdmi.UnmodifiableSparseArray;
import com.android.server.hdmi.UnmodifiableSparseIntArray;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import libcore.util.EmptyArray;

public final class HdmiControlService
extends SystemService {
    private static final String TAG = "HdmiControlService";
    private final Locale HONG_KONG = new Locale("zh", "HK");
    private final Locale MACAU = new Locale("zh", "MO");
    static final String PERMISSION = "android.permission.HDMI_CEC";
    static final int INITIATED_BY_ENABLE_CEC = 0;
    static final int INITIATED_BY_BOOT_UP = 1;
    static final int INITIATED_BY_SCREEN_ON = 2;
    static final int INITIATED_BY_WAKE_UP_MESSAGE = 3;
    static final int INITIATED_BY_HOTPLUG = 4;
    static final int STANDBY_SCREEN_OFF = 0;
    static final int STANDBY_SHUTDOWN = 1;
    private final HandlerThread mIoThread = new HandlerThread("Hdmi Control Io Thread");
    private final Object mLock = new Object();
    private final List<Integer> mLocalDevices;
    @GuardedBy(value="mLock")
    private final ArrayList<HotplugEventListenerRecord> mHotplugEventListenerRecords = new ArrayList();
    @GuardedBy(value="mLock")
    private final ArrayList<DeviceEventListenerRecord> mDeviceEventListenerRecords = new ArrayList();
    @GuardedBy(value="mLock")
    private final ArrayList<VendorCommandListenerRecord> mVendorCommandListenerRecords = new ArrayList();
    @GuardedBy(value="mLock")
    private InputChangeListenerRecord mInputChangeListenerRecord;
    @GuardedBy(value="mLock")
    private HdmiRecordListenerRecord mRecordListenerRecord;
    @GuardedBy(value="mLock")
    private boolean mHdmiControlEnabled;
    @GuardedBy(value="mLock")
    private boolean mProhibitMode;
    private final ArrayList<SystemAudioModeChangeListenerRecord> mSystemAudioModeChangeListenerRecords = new ArrayList();
    private final Handler mHandler = new Handler();
    private final SettingsObserver mSettingsObserver;
    private final HdmiControlBroadcastReceiver mHdmiControlBroadcastReceiver = new HdmiControlBroadcastReceiver();
    private HdmiCecController mCecController;
    private List<HdmiPortInfo> mPortInfo;
    private UnmodifiableSparseIntArray mPortIdMap;
    private UnmodifiableSparseArray<HdmiPortInfo> mPortInfoMap;
    private UnmodifiableSparseArray<HdmiDeviceInfo> mPortDeviceMap;
    private HdmiCecMessageValidator mMessageValidator;
    @HdmiAnnotations.ServiceThreadOnly
    private int mPowerStatus = 1;
    @HdmiAnnotations.ServiceThreadOnly
    private String mLanguage = Locale.getDefault().getISO3Language();
    @HdmiAnnotations.ServiceThreadOnly
    private boolean mStandbyMessageReceived = false;
    @HdmiAnnotations.ServiceThreadOnly
    private boolean mWakeUpMessageReceived = false;
    @HdmiAnnotations.ServiceThreadOnly
    private int mActivePortId = -1;
    @GuardedBy(value="mLock")
    private boolean mMhlInputChangeEnabled;
    @GuardedBy(value="mLock")
    private final ArrayList<HdmiMhlVendorCommandListenerRecord> mMhlVendorCommandListenerRecords = new ArrayList();
    @GuardedBy(value="mLock")
    private List<HdmiDeviceInfo> mMhlDevices;
    private HdmiMhlControllerStub mMhlController;
    private TvInputManager mTvInputManager;
    private PowerManager mPowerManager;
    @HdmiAnnotations.ServiceThreadOnly
    private int mLastInputMhl = -1;
    private boolean mAddressAllocated = false;
    private CecMessageBuffer mCecMessageBuffer = new CecMessageBuffer();

    public HdmiControlService(Context context) {
        super(context);
        this.mLocalDevices = HdmiControlService.getIntList(SystemProperties.get("ro.hdmi.device_type"));
        this.mSettingsObserver = new SettingsObserver(this.mHandler);
    }

    private static List<Integer> getIntList(String string2) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        TextUtils.SimpleStringSplitter splitter = new TextUtils.SimpleStringSplitter(',');
        splitter.setString(string2);
        for (String item : splitter) {
            try {
                list.add(Integer.parseInt(item));
            }
            catch (NumberFormatException e) {
                Slog.w(TAG, "Can't parseInt: " + item);
            }
        }
        return Collections.unmodifiableList(list);
    }

    @Override
    public void onStart() {
        this.mIoThread.start();
        this.mPowerStatus = 2;
        this.mProhibitMode = false;
        this.mHdmiControlEnabled = this.readBooleanSetting("hdmi_control_enabled", true);
        this.mMhlInputChangeEnabled = this.readBooleanSetting("mhl_input_switching_enabled", true);
        this.mCecController = HdmiCecController.create(this);
        if (this.mCecController != null) {
            if (this.mHdmiControlEnabled) {
                this.initializeCec(1);
            }
        } else {
            Slog.i(TAG, "Device does not support HDMI-CEC.");
            return;
        }
        this.mMhlController = HdmiMhlControllerStub.create(this);
        if (!this.mMhlController.isReady()) {
            Slog.i(TAG, "Device does not support MHL-control.");
        }
        this.mMhlDevices = Collections.emptyList();
        this.initPortInfo();
        this.mMessageValidator = new HdmiCecMessageValidator(this);
        this.publishBinderService("hdmi_control", new BinderService());
        if (this.mCecController != null) {
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.intent.action.SCREEN_OFF");
            filter.addAction("android.intent.action.SCREEN_ON");
            filter.addAction("android.intent.action.CONFIGURATION_CHANGED");
            this.getContext().registerReceiver(this.mHdmiControlBroadcastReceiver, filter);
            this.registerContentObserver();
        }
        this.mMhlController.setOption(104, 1);
    }

    @Override
    public void onBootPhase(int phase) {
        if (phase == 500) {
            this.mTvInputManager = (TvInputManager)this.getContext().getSystemService("tv_input");
            this.mPowerManager = (PowerManager)this.getContext().getSystemService("power");
        }
    }

    TvInputManager getTvInputManager() {
        return this.mTvInputManager;
    }

    void registerTvInputCallback(TvInputManager.TvInputCallback callback) {
        if (this.mTvInputManager == null) {
            return;
        }
        this.mTvInputManager.registerCallback(callback, this.mHandler);
    }

    void unregisterTvInputCallback(TvInputManager.TvInputCallback callback) {
        if (this.mTvInputManager == null) {
            return;
        }
        this.mTvInputManager.unregisterCallback(callback);
    }

    PowerManager getPowerManager() {
        return this.mPowerManager;
    }

    private void onInitializeCecComplete(int initiatedBy) {
        if (this.mPowerStatus == 2) {
            this.mPowerStatus = 0;
        }
        this.mWakeUpMessageReceived = false;
        if (this.isTvDeviceEnabled()) {
            this.mCecController.setOption(1, HdmiControlService.toInt(this.tv().getAutoWakeup()));
        }
        int reason = -1;
        switch (initiatedBy) {
            case 1: {
                reason = 0;
                break;
            }
            case 0: {
                reason = 1;
                break;
            }
            case 2: 
            case 3: {
                reason = 2;
            }
        }
        if (reason != -1) {
            this.invokeVendorCommandListenersOnControlStateChanged(true, reason);
        }
    }

    private void registerContentObserver() {
        String[] settings;
        ContentResolver resolver = this.getContext().getContentResolver();
        for (String s : settings = new String[]{"hdmi_control_enabled", "hdmi_control_auto_wakeup_enabled", "hdmi_control_auto_device_off_enabled", "mhl_input_switching_enabled", "mhl_power_charge_enabled"}) {
            resolver.registerContentObserver(Settings.Global.getUriFor(s), false, this.mSettingsObserver, -1);
        }
    }

    private static int toInt(boolean enabled) {
        return enabled ? 1 : 0;
    }

    boolean readBooleanSetting(String key, boolean defVal) {
        ContentResolver cr = this.getContext().getContentResolver();
        return Settings.Global.getInt(cr, key, HdmiControlService.toInt(defVal)) == 1;
    }

    void writeBooleanSetting(String key, boolean value) {
        ContentResolver cr = this.getContext().getContentResolver();
        Settings.Global.putInt(cr, key, HdmiControlService.toInt(value));
    }

    private void initializeCec(int initiatedBy) {
        this.mAddressAllocated = false;
        this.mCecController.setOption(3, 1);
        this.mCecController.setOption(5, HdmiUtils.languageToInt(this.mLanguage));
        this.initializeLocalDevices(initiatedBy);
    }

    @HdmiAnnotations.ServiceThreadOnly
    private void initializeLocalDevices(int initiatedBy) {
        this.assertRunOnServiceThread();
        ArrayList<HdmiCecLocalDevice> localDevices = new ArrayList<HdmiCecLocalDevice>();
        for (int type : this.mLocalDevices) {
            HdmiCecLocalDevice localDevice = this.mCecController.getLocalDevice(type);
            if (localDevice == null) {
                localDevice = HdmiCecLocalDevice.create(this, type);
            }
            localDevice.init();
            localDevices.add(localDevice);
        }
        this.clearLocalDevices();
        this.allocateLogicalAddress(localDevices, initiatedBy);
    }

    @HdmiAnnotations.ServiceThreadOnly
    private void allocateLogicalAddress(final ArrayList<HdmiCecLocalDevice> allocatingDevices, final int initiatedBy) {
        this.assertRunOnServiceThread();
        this.mCecController.clearLogicalAddress();
        final ArrayList allocatedDevices = new ArrayList();
        final int[] finished = new int[1];
        this.mAddressAllocated = allocatingDevices.isEmpty();
        for (final HdmiCecLocalDevice localDevice : allocatingDevices) {
            this.mCecController.allocateLogicalAddress(localDevice.getType(), localDevice.getPreferredAddress(), new HdmiCecController.AllocateAddressCallback(){

                @Override
                public void onAllocated(int deviceType, int logicalAddress) {
                    if (logicalAddress == 15) {
                        Slog.e(HdmiControlService.TAG, "Failed to allocate address:[device_type:" + deviceType + "]");
                    } else {
                        HdmiDeviceInfo deviceInfo = HdmiControlService.this.createDeviceInfo(logicalAddress, deviceType, 0);
                        localDevice.setDeviceInfo(deviceInfo);
                        HdmiControlService.this.mCecController.addLocalDevice(deviceType, localDevice);
                        HdmiControlService.this.mCecController.addLogicalAddress(logicalAddress);
                        allocatedDevices.add(localDevice);
                    }
                    finished[0] = finished[0] + 1;
                    if (allocatingDevices.size() == finished[0]) {
                        HdmiControlService.this.mAddressAllocated = true;
                        if (initiatedBy != 4) {
                            HdmiControlService.this.onInitializeCecComplete(initiatedBy);
                        }
                        HdmiControlService.this.notifyAddressAllocated(allocatedDevices, initiatedBy);
                        HdmiControlService.this.mCecMessageBuffer.processMessages();
                    }
                }
            });
        }
    }

    @HdmiAnnotations.ServiceThreadOnly
    private void notifyAddressAllocated(ArrayList<HdmiCecLocalDevice> devices, int initiatedBy) {
        this.assertRunOnServiceThread();
        for (HdmiCecLocalDevice device : devices) {
            int address = device.getDeviceInfo().getLogicalAddress();
            device.handleAddressAllocated(address, initiatedBy);
        }
    }

    @HdmiAnnotations.ServiceThreadOnly
    private void initPortInfo() {
        this.assertRunOnServiceThread();
        HdmiPortInfo[] cecPortInfo = null;
        if (this.mCecController != null) {
            cecPortInfo = this.mCecController.getPortInfos();
        }
        if (cecPortInfo == null) {
            return;
        }
        SparseArray<HdmiPortInfo> portInfoMap = new SparseArray<HdmiPortInfo>();
        SparseIntArray portIdMap = new SparseIntArray();
        SparseArray<HdmiDeviceInfo> portDeviceMap = new SparseArray<HdmiDeviceInfo>();
        for (HdmiPortInfo info : cecPortInfo) {
            portIdMap.put(info.getAddress(), info.getId());
            portInfoMap.put(info.getId(), info);
            portDeviceMap.put(info.getId(), new HdmiDeviceInfo(info.getAddress(), info.getId()));
        }
        this.mPortIdMap = new UnmodifiableSparseIntArray(portIdMap);
        this.mPortInfoMap = new UnmodifiableSparseArray(portInfoMap);
        this.mPortDeviceMap = new UnmodifiableSparseArray(portDeviceMap);
        HdmiPortInfo[] mhlPortInfo = this.mMhlController.getPortInfos();
        ArraySet<Integer> mhlSupportedPorts = new ArraySet<Integer>(mhlPortInfo.length);
        for (HdmiPortInfo info : mhlPortInfo) {
            if (!info.isMhlSupported()) continue;
            mhlSupportedPorts.add(info.getId());
        }
        if (mhlSupportedPorts.isEmpty()) {
            this.mPortInfo = Collections.unmodifiableList(Arrays.asList(cecPortInfo));
            return;
        }
        ArrayList<HdmiPortInfo> result = new ArrayList<HdmiPortInfo>(cecPortInfo.length);
        for (HdmiPortInfo info : cecPortInfo) {
            if (mhlSupportedPorts.contains(info.getId())) {
                result.add(new HdmiPortInfo(info.getId(), info.getType(), info.getAddress(), info.isCecSupported(), true, info.isArcSupported()));
                continue;
            }
            result.add(info);
        }
        this.mPortInfo = Collections.unmodifiableList(result);
    }

    List<HdmiPortInfo> getPortInfo() {
        return this.mPortInfo;
    }

    HdmiPortInfo getPortInfo(int portId) {
        return this.mPortInfoMap.get(portId, null);
    }

    int portIdToPath(int portId) {
        HdmiPortInfo portInfo = this.getPortInfo(portId);
        if (portInfo == null) {
            Slog.e(TAG, "Cannot find the port info: " + portId);
            return 65535;
        }
        return portInfo.getAddress();
    }

    int pathToPortId(int path) {
        int portAddress = path & 0xF000;
        return this.mPortIdMap.get(portAddress, -1);
    }

    boolean isValidPortId(int portId) {
        return this.getPortInfo(portId) != null;
    }

    Looper getIoLooper() {
        return this.mIoThread.getLooper();
    }

    Looper getServiceLooper() {
        return this.mHandler.getLooper();
    }

    int getPhysicalAddress() {
        return this.mCecController.getPhysicalAddress();
    }

    int getVendorId() {
        return this.mCecController.getVendorId();
    }

    @HdmiAnnotations.ServiceThreadOnly
    HdmiDeviceInfo getDeviceInfo(int logicalAddress) {
        this.assertRunOnServiceThread();
        return this.tv() == null ? null : this.tv().getCecDeviceInfo(logicalAddress);
    }

    @HdmiAnnotations.ServiceThreadOnly
    HdmiDeviceInfo getDeviceInfoByPort(int port) {
        this.assertRunOnServiceThread();
        HdmiMhlLocalDeviceStub info = this.mMhlController.getLocalDevice(port);
        if (info != null) {
            return info.getInfo();
        }
        return null;
    }

    int getCecVersion() {
        return this.mCecController.getVersion();
    }

    boolean isConnectedToArcPort(int physicalAddress) {
        int portId = this.pathToPortId(physicalAddress);
        if (portId != -1) {
            return this.mPortInfoMap.get(portId).isArcSupported();
        }
        return false;
    }

    @HdmiAnnotations.ServiceThreadOnly
    boolean isConnected(int portId) {
        this.assertRunOnServiceThread();
        return this.mCecController.isConnected(portId);
    }

    void runOnServiceThread(Runnable runnable) {
        this.mHandler.post(runnable);
    }

    void runOnServiceThreadAtFrontOfQueue(Runnable runnable) {
        this.mHandler.postAtFrontOfQueue(runnable);
    }

    private void assertRunOnServiceThread() {
        if (Looper.myLooper() != this.mHandler.getLooper()) {
            throw new IllegalStateException("Should run on service thread.");
        }
    }

    @HdmiAnnotations.ServiceThreadOnly
    void sendCecCommand(HdmiCecMessage command, SendMessageCallback callback) {
        this.assertRunOnServiceThread();
        if (this.mMessageValidator.isValid(command) == 0) {
            this.mCecController.sendCommand(command, callback);
        } else {
            HdmiLogger.error("Invalid message type:" + command, new Object[0]);
            if (callback != null) {
                callback.onSendCompleted(3);
            }
        }
    }

    @HdmiAnnotations.ServiceThreadOnly
    void sendCecCommand(HdmiCecMessage command) {
        this.assertRunOnServiceThread();
        this.sendCecCommand(command, null);
    }

    @HdmiAnnotations.ServiceThreadOnly
    void maySendFeatureAbortCommand(HdmiCecMessage command, int reason) {
        this.assertRunOnServiceThread();
        this.mCecController.maySendFeatureAbortCommand(command, reason);
    }

    @HdmiAnnotations.ServiceThreadOnly
    boolean handleCecCommand(HdmiCecMessage message) {
        this.assertRunOnServiceThread();
        if (!this.mAddressAllocated) {
            this.mCecMessageBuffer.bufferMessage(message);
            return true;
        }
        int errorCode = this.mMessageValidator.isValid(message);
        if (errorCode != 0) {
            if (errorCode == 3) {
                this.maySendFeatureAbortCommand(message, 3);
            }
            return true;
        }
        return this.dispatchMessageToLocalDevice(message);
    }

    void setAudioReturnChannel(int portId, boolean enabled) {
        this.mCecController.setAudioReturnChannel(portId, enabled);
    }

    @HdmiAnnotations.ServiceThreadOnly
    private boolean dispatchMessageToLocalDevice(HdmiCecMessage message) {
        this.assertRunOnServiceThread();
        for (HdmiCecLocalDevice device : this.mCecController.getLocalDeviceList()) {
            if (!device.dispatchMessage(message) || message.getDestination() == 15) continue;
            return true;
        }
        if (message.getDestination() != 15) {
            HdmiLogger.warning("Unhandled cec command:" + message, new Object[0]);
        }
        return false;
    }

    @HdmiAnnotations.ServiceThreadOnly
    void onHotplug(int portId, boolean connected) {
        this.assertRunOnServiceThread();
        if (connected && !this.isTvDevice()) {
            ArrayList<HdmiCecLocalDevice> localDevices = new ArrayList<HdmiCecLocalDevice>();
            for (int type : this.mLocalDevices) {
                HdmiCecLocalDevice localDevice = this.mCecController.getLocalDevice(type);
                if (localDevice == null) {
                    localDevice = HdmiCecLocalDevice.create(this, type);
                    localDevice.init();
                }
                localDevices.add(localDevice);
            }
            this.allocateLogicalAddress(localDevices, 4);
        }
        for (HdmiCecLocalDevice device : this.mCecController.getLocalDeviceList()) {
            device.onHotplug(portId, connected);
        }
        this.announceHotplugEvent(portId, connected);
    }

    @HdmiAnnotations.ServiceThreadOnly
    void pollDevices(DevicePollingCallback callback, int sourceAddress, int pickStrategy, int retryCount) {
        this.assertRunOnServiceThread();
        this.mCecController.pollDevices(callback, sourceAddress, this.checkPollStrategy(pickStrategy), retryCount);
    }

    private int checkPollStrategy(int pickStrategy) {
        int strategy = pickStrategy & 3;
        if (strategy == 0) {
            throw new IllegalArgumentException("Invalid poll strategy:" + pickStrategy);
        }
        int iterationStrategy = pickStrategy & 0x30000;
        if (iterationStrategy == 0) {
            throw new IllegalArgumentException("Invalid iteration strategy:" + pickStrategy);
        }
        return strategy | iterationStrategy;
    }

    List<HdmiCecLocalDevice> getAllLocalDevices() {
        this.assertRunOnServiceThread();
        return this.mCecController.getLocalDeviceList();
    }

    Object getServiceLock() {
        return this.mLock;
    }

    void setAudioStatus(boolean mute, int volume) {
        AudioManager audioManager = this.getAudioManager();
        boolean muted = audioManager.isStreamMute(3);
        if (mute) {
            if (!muted) {
                audioManager.setStreamMute(3, true);
            }
        } else {
            if (muted) {
                audioManager.setStreamMute(3, false);
            }
            audioManager.setStreamVolume(3, volume, 257);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void announceSystemAudioModeChange(boolean enabled) {
        Object object = this.mLock;
        synchronized (object) {
            for (SystemAudioModeChangeListenerRecord record : this.mSystemAudioModeChangeListenerRecords) {
                this.invokeSystemAudioModeChangeLocked(record.mListener, enabled);
            }
        }
    }

    private HdmiDeviceInfo createDeviceInfo(int logicalAddress, int deviceType, int powerStatus) {
        String displayName = Build.MODEL;
        return new HdmiDeviceInfo(logicalAddress, this.getPhysicalAddress(), this.pathToPortId(this.getPhysicalAddress()), deviceType, this.getVendorId(), displayName);
    }

    @HdmiAnnotations.ServiceThreadOnly
    void handleMhlHotplugEvent(int portId, boolean connected) {
        this.assertRunOnServiceThread();
        if (connected) {
            HdmiMhlLocalDeviceStub newDevice = new HdmiMhlLocalDeviceStub(this, portId);
            HdmiMhlLocalDeviceStub oldDevice = this.mMhlController.addLocalDevice(newDevice);
            if (oldDevice != null) {
                oldDevice.onDeviceRemoved();
                Slog.i(TAG, "Old device of port " + portId + " is removed");
            }
            this.invokeDeviceEventListeners(newDevice.getInfo(), 1);
            this.updateSafeMhlInput();
        } else {
            HdmiMhlLocalDeviceStub device = this.mMhlController.removeLocalDevice(portId);
            if (device != null) {
                device.onDeviceRemoved();
                this.invokeDeviceEventListeners(device.getInfo(), 2);
                this.updateSafeMhlInput();
            } else {
                Slog.w(TAG, "No device to remove:[portId=" + portId);
            }
        }
        this.announceHotplugEvent(portId, connected);
    }

    @HdmiAnnotations.ServiceThreadOnly
    void handleMhlBusModeChanged(int portId, int busmode) {
        this.assertRunOnServiceThread();
        HdmiMhlLocalDeviceStub device = this.mMhlController.getLocalDevice(portId);
        if (device != null) {
            device.setBusMode(busmode);
        } else {
            Slog.w(TAG, "No mhl device exists for bus mode change[portId:" + portId + ", busmode:" + busmode + "]");
        }
    }

    @HdmiAnnotations.ServiceThreadOnly
    void handleMhlBusOvercurrent(int portId, boolean on) {
        this.assertRunOnServiceThread();
        HdmiMhlLocalDeviceStub device = this.mMhlController.getLocalDevice(portId);
        if (device != null) {
            device.onBusOvercurrentDetected(on);
        } else {
            Slog.w(TAG, "No mhl device exists for bus overcurrent event[portId:" + portId + "]");
        }
    }

    @HdmiAnnotations.ServiceThreadOnly
    void handleMhlDeviceStatusChanged(int portId, int adopterId, int deviceId) {
        this.assertRunOnServiceThread();
        HdmiMhlLocalDeviceStub device = this.mMhlController.getLocalDevice(portId);
        if (device != null) {
            device.setDeviceStatusChange(adopterId, deviceId);
        } else {
            Slog.w(TAG, "No mhl device exists for device status event[portId:" + portId + ", adopterId:" + adopterId + ", deviceId:" + deviceId + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HdmiAnnotations.ServiceThreadOnly
    private void updateSafeMhlInput() {
        this.assertRunOnServiceThread();
        List inputs = Collections.emptyList();
        SparseArray<HdmiMhlLocalDeviceStub> devices = this.mMhlController.getAllLocalDevices();
        for (int i = 0; i < devices.size(); ++i) {
            HdmiMhlLocalDeviceStub device = devices.valueAt(i);
            HdmiDeviceInfo info = device.getInfo();
            if (info == null) continue;
            if (inputs.isEmpty()) {
                inputs = new ArrayList();
            }
            inputs.add(device.getInfo());
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mMhlDevices = inputs;
        }
    }

    private List<HdmiDeviceInfo> getMhlDevicesLocked() {
        return this.mMhlDevices;
    }

    private void enforceAccessPermission() {
        this.getContext().enforceCallingOrSelfPermission(PERMISSION, TAG);
    }

    @HdmiAnnotations.ServiceThreadOnly
    private void oneTouchPlay(IHdmiControlCallback callback) {
        this.assertRunOnServiceThread();
        HdmiCecLocalDevicePlayback source = this.playback();
        if (source == null) {
            Slog.w(TAG, "Local playback device not available");
            this.invokeCallback(callback, 2);
            return;
        }
        source.oneTouchPlay(callback);
    }

    @HdmiAnnotations.ServiceThreadOnly
    private void queryDisplayStatus(IHdmiControlCallback callback) {
        this.assertRunOnServiceThread();
        HdmiCecLocalDevicePlayback source = this.playback();
        if (source == null) {
            Slog.w(TAG, "Local playback device not available");
            this.invokeCallback(callback, 2);
            return;
        }
        source.queryDisplayStatus(callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHotplugEventListener(final IHdmiHotplugEventListener listener) {
        final HotplugEventListenerRecord record = new HotplugEventListenerRecord(listener);
        try {
            listener.asBinder().linkToDeath(record, 0);
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Listener already died");
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mHotplugEventListenerRecords.add(record);
        }
        this.runOnServiceThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = HdmiControlService.this.mLock;
                synchronized (object) {
                    if (!HdmiControlService.this.mHotplugEventListenerRecords.contains(record)) {
                        return;
                    }
                }
                for (HdmiPortInfo port : HdmiControlService.this.mPortInfo) {
                    HdmiHotplugEvent event = new HdmiHotplugEvent(port.getId(), HdmiControlService.this.mCecController.isConnected(port.getId()));
                    Object object2 = HdmiControlService.this.mLock;
                    synchronized (object2) {
                        HdmiControlService.this.invokeHotplugEventListenerLocked(listener, event);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeHotplugEventListener(IHdmiHotplugEventListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            for (HotplugEventListenerRecord record : this.mHotplugEventListenerRecords) {
                if (record.mListener.asBinder() != listener.asBinder()) continue;
                listener.asBinder().unlinkToDeath(record, 0);
                this.mHotplugEventListenerRecords.remove(record);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDeviceEventListener(IHdmiDeviceEventListener listener) {
        DeviceEventListenerRecord record = new DeviceEventListenerRecord(listener);
        try {
            listener.asBinder().linkToDeath(record, 0);
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Listener already died");
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mDeviceEventListenerRecords.add(record);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invokeDeviceEventListeners(HdmiDeviceInfo device, int status) {
        Object object = this.mLock;
        synchronized (object) {
            for (DeviceEventListenerRecord record : this.mDeviceEventListenerRecords) {
                try {
                    record.mListener.onStatusChanged(device, status);
                }
                catch (RemoteException e) {
                    Slog.e(TAG, "Failed to report device event:" + e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSystemAudioModeChangeListner(IHdmiSystemAudioModeChangeListener listener) {
        SystemAudioModeChangeListenerRecord record = new SystemAudioModeChangeListenerRecord(listener);
        try {
            listener.asBinder().linkToDeath(record, 0);
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Listener already died");
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mSystemAudioModeChangeListenerRecords.add(record);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSystemAudioModeChangeListener(IHdmiSystemAudioModeChangeListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            for (SystemAudioModeChangeListenerRecord record : this.mSystemAudioModeChangeListenerRecords) {
                if (record.mListener.asBinder() != listener) continue;
                listener.asBinder().unlinkToDeath(record, 0);
                this.mSystemAudioModeChangeListenerRecords.remove(record);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInputChangeListener(IHdmiInputChangeListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mInputChangeListenerRecord = new InputChangeListenerRecord(listener);
            try {
                listener.asBinder().linkToDeath(this.mInputChangeListenerRecord, 0);
            }
            catch (RemoteException e) {
                Slog.w(TAG, "Listener already died");
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invokeInputChangeListener(HdmiDeviceInfo info) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mInputChangeListenerRecord != null) {
                try {
                    this.mInputChangeListenerRecord.mListener.onChanged(info);
                }
                catch (RemoteException e) {
                    Slog.w(TAG, "Exception thrown by IHdmiInputChangeListener: " + e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setHdmiRecordListener(IHdmiRecordListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mRecordListenerRecord = new HdmiRecordListenerRecord(listener);
            try {
                listener.asBinder().linkToDeath(this.mRecordListenerRecord, 0);
            }
            catch (RemoteException e) {
                Slog.w(TAG, "Listener already died.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] invokeRecordRequestListener(int recorderAddress) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mRecordListenerRecord != null) {
                try {
                    return this.mRecordListenerRecord.mListener.getOneTouchRecordSource(recorderAddress);
                }
                catch (RemoteException e) {
                    Slog.w(TAG, "Failed to start record.", e);
                }
            }
            return EmptyArray.BYTE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invokeOneTouchRecordResult(int recorderAddress, int result) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mRecordListenerRecord != null) {
                try {
                    this.mRecordListenerRecord.mListener.onOneTouchRecordResult(recorderAddress, result);
                }
                catch (RemoteException e) {
                    Slog.w(TAG, "Failed to call onOneTouchRecordResult.", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invokeTimerRecordingResult(int recorderAddress, int result) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mRecordListenerRecord != null) {
                try {
                    this.mRecordListenerRecord.mListener.onTimerRecordingResult(recorderAddress, result);
                }
                catch (RemoteException e) {
                    Slog.w(TAG, "Failed to call onTimerRecordingResult.", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invokeClearTimerRecordingResult(int recorderAddress, int result) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mRecordListenerRecord != null) {
                try {
                    this.mRecordListenerRecord.mListener.onClearTimerRecordingResult(recorderAddress, result);
                }
                catch (RemoteException e) {
                    Slog.w(TAG, "Failed to call onClearTimerRecordingResult.", e);
                }
            }
        }
    }

    private void invokeCallback(IHdmiControlCallback callback, int result) {
        try {
            callback.onComplete(result);
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Invoking callback failed:" + e);
        }
    }

    private void invokeSystemAudioModeChangeLocked(IHdmiSystemAudioModeChangeListener listener, boolean enabled) {
        try {
            listener.onStatusChanged(enabled);
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Invoking callback failed:" + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void announceHotplugEvent(int portId, boolean connected) {
        HdmiHotplugEvent event = new HdmiHotplugEvent(portId, connected);
        Object object = this.mLock;
        synchronized (object) {
            for (HotplugEventListenerRecord record : this.mHotplugEventListenerRecords) {
                this.invokeHotplugEventListenerLocked(record.mListener, event);
            }
        }
    }

    private void invokeHotplugEventListenerLocked(IHdmiHotplugEventListener listener, HdmiHotplugEvent event) {
        try {
            listener.onReceived(event);
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Failed to report hotplug event:" + event.toString(), e);
        }
    }

    private HdmiCecLocalDeviceTv tv() {
        return (HdmiCecLocalDeviceTv)this.mCecController.getLocalDevice(0);
    }

    boolean isTvDevice() {
        return this.mLocalDevices.contains(0);
    }

    boolean isTvDeviceEnabled() {
        return this.isTvDevice() && this.tv() != null;
    }

    private HdmiCecLocalDevicePlayback playback() {
        return (HdmiCecLocalDevicePlayback)this.mCecController.getLocalDevice(4);
    }

    AudioManager getAudioManager() {
        return (AudioManager)this.getContext().getSystemService("audio");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isControlEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mHdmiControlEnabled;
        }
    }

    @HdmiAnnotations.ServiceThreadOnly
    int getPowerStatus() {
        this.assertRunOnServiceThread();
        return this.mPowerStatus;
    }

    @HdmiAnnotations.ServiceThreadOnly
    boolean isPowerOnOrTransient() {
        this.assertRunOnServiceThread();
        return this.mPowerStatus == 0 || this.mPowerStatus == 2;
    }

    @HdmiAnnotations.ServiceThreadOnly
    boolean isPowerStandbyOrTransient() {
        this.assertRunOnServiceThread();
        return this.mPowerStatus == 1 || this.mPowerStatus == 3;
    }

    @HdmiAnnotations.ServiceThreadOnly
    boolean isPowerStandby() {
        this.assertRunOnServiceThread();
        return this.mPowerStatus == 1;
    }

    @HdmiAnnotations.ServiceThreadOnly
    void wakeUp() {
        this.assertRunOnServiceThread();
        this.mWakeUpMessageReceived = true;
        this.mPowerManager.wakeUp(SystemClock.uptimeMillis(), "android.server.hdmi:WAKE");
    }

    @HdmiAnnotations.ServiceThreadOnly
    void standby() {
        this.assertRunOnServiceThread();
        this.mStandbyMessageReceived = true;
        this.mPowerManager.goToSleep(SystemClock.uptimeMillis(), 5, 0);
    }

    @HdmiAnnotations.ServiceThreadOnly
    private void onWakeUp() {
        this.assertRunOnServiceThread();
        this.mPowerStatus = 2;
        if (this.mCecController != null) {
            if (this.mHdmiControlEnabled) {
                int startReason = 2;
                if (this.mWakeUpMessageReceived) {
                    startReason = 3;
                }
                this.initializeCec(startReason);
            }
        } else {
            Slog.i(TAG, "Device does not support HDMI-CEC.");
        }
    }

    @HdmiAnnotations.ServiceThreadOnly
    private void onStandby(final int standbyAction) {
        this.assertRunOnServiceThread();
        if (!this.canGoToStandby()) {
            return;
        }
        this.mPowerStatus = 3;
        this.invokeVendorCommandListenersOnControlStateChanged(false, 3);
        final List<HdmiCecLocalDevice> devices = this.getAllLocalDevices();
        this.disableDevices(new HdmiCecLocalDevice.PendingActionClearedCallback(){

            @Override
            public void onCleared(HdmiCecLocalDevice device) {
                Slog.v(HdmiControlService.TAG, "On standby-action cleared:" + device.mDeviceType);
                devices.remove(device);
                if (devices.isEmpty()) {
                    HdmiControlService.this.onStandbyCompleted(standbyAction);
                }
            }
        });
    }

    private boolean canGoToStandby() {
        for (HdmiCecLocalDevice device : this.mCecController.getLocalDeviceList()) {
            if (device.canGoToStandby()) continue;
            return false;
        }
        return true;
    }

    @HdmiAnnotations.ServiceThreadOnly
    private void onLanguageChanged(String language) {
        this.assertRunOnServiceThread();
        this.mLanguage = language;
        if (this.isTvDeviceEnabled()) {
            this.tv().broadcastMenuLanguage(language);
            this.mCecController.setOption(5, HdmiUtils.languageToInt(language));
        }
    }

    @HdmiAnnotations.ServiceThreadOnly
    String getLanguage() {
        this.assertRunOnServiceThread();
        return this.mLanguage;
    }

    private void disableDevices(HdmiCecLocalDevice.PendingActionClearedCallback callback) {
        if (this.mCecController != null) {
            for (HdmiCecLocalDevice device : this.mCecController.getLocalDeviceList()) {
                device.disableDevice(this.mStandbyMessageReceived, callback);
            }
        }
        this.mMhlController.clearAllLocalDevices();
    }

    @HdmiAnnotations.ServiceThreadOnly
    private void clearLocalDevices() {
        this.assertRunOnServiceThread();
        if (this.mCecController == null) {
            return;
        }
        this.mCecController.clearLogicalAddress();
        this.mCecController.clearLocalDevices();
    }

    @HdmiAnnotations.ServiceThreadOnly
    private void onStandbyCompleted(int standbyAction) {
        this.assertRunOnServiceThread();
        Slog.v(TAG, "onStandbyCompleted");
        if (this.mPowerStatus != 3) {
            return;
        }
        this.mPowerStatus = 1;
        for (HdmiCecLocalDevice device : this.mCecController.getLocalDeviceList()) {
            device.onStandby(this.mStandbyMessageReceived, standbyAction);
        }
        this.mStandbyMessageReceived = false;
        this.mAddressAllocated = false;
        this.mCecController.setOption(3, 0);
        this.mMhlController.setOption(104, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addVendorCommandListener(IHdmiVendorCommandListener listener, int deviceType) {
        VendorCommandListenerRecord record = new VendorCommandListenerRecord(listener, deviceType);
        try {
            listener.asBinder().linkToDeath(record, 0);
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Listener already died");
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mVendorCommandListenerRecords.add(record);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean invokeVendorCommandListenersOnReceived(int deviceType, int srcAddress, int destAddress, byte[] params, boolean hasVendorId) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mVendorCommandListenerRecords.isEmpty()) {
                return false;
            }
            for (VendorCommandListenerRecord record : this.mVendorCommandListenerRecords) {
                if (record.mDeviceType != deviceType) continue;
                try {
                    record.mListener.onReceived(srcAddress, destAddress, params, hasVendorId);
                }
                catch (RemoteException e) {
                    Slog.e(TAG, "Failed to notify vendor command reception", e);
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean invokeVendorCommandListenersOnControlStateChanged(boolean enabled, int reason) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mVendorCommandListenerRecords.isEmpty()) {
                return false;
            }
            for (VendorCommandListenerRecord record : this.mVendorCommandListenerRecords) {
                try {
                    record.mListener.onControlStateChanged(enabled, reason);
                }
                catch (RemoteException e) {
                    Slog.e(TAG, "Failed to notify control-state-changed to vendor handler", e);
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHdmiMhlVendorCommandListener(IHdmiMhlVendorCommandListener listener) {
        HdmiMhlVendorCommandListenerRecord record = new HdmiMhlVendorCommandListenerRecord(listener);
        try {
            listener.asBinder().linkToDeath(record, 0);
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Listener already died.");
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mMhlVendorCommandListenerRecords.add(record);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invokeMhlVendorCommandListeners(int portId, int offest, int length, byte[] data) {
        Object object = this.mLock;
        synchronized (object) {
            for (HdmiMhlVendorCommandListenerRecord record : this.mMhlVendorCommandListenerRecords) {
                try {
                    record.mListener.onReceived(portId, offest, length, data);
                }
                catch (RemoteException e) {
                    Slog.e(TAG, "Failed to notify MHL vendor command", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isProhibitMode() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mProhibitMode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setProhibitMode(boolean enabled) {
        Object object = this.mLock;
        synchronized (object) {
            this.mProhibitMode = enabled;
        }
    }

    @HdmiAnnotations.ServiceThreadOnly
    void setCecOption(int key, int value) {
        this.assertRunOnServiceThread();
        this.mCecController.setOption(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HdmiAnnotations.ServiceThreadOnly
    void setControlEnabled(boolean enabled) {
        this.assertRunOnServiceThread();
        Object object = this.mLock;
        synchronized (object) {
            this.mHdmiControlEnabled = enabled;
        }
        if (enabled) {
            this.enableHdmiControlService();
            return;
        }
        this.invokeVendorCommandListenersOnControlStateChanged(false, 1);
        this.runOnServiceThread(new Runnable(){

            @Override
            public void run() {
                HdmiControlService.this.disableHdmiControlService();
            }
        });
    }

    @HdmiAnnotations.ServiceThreadOnly
    private void enableHdmiControlService() {
        this.mCecController.setOption(2, 1);
        this.mMhlController.setOption(103, 1);
        this.initializeCec(0);
    }

    @HdmiAnnotations.ServiceThreadOnly
    private void disableHdmiControlService() {
        this.disableDevices(new HdmiCecLocalDevice.PendingActionClearedCallback(){

            @Override
            public void onCleared(HdmiCecLocalDevice device) {
                HdmiControlService.this.assertRunOnServiceThread();
                HdmiControlService.this.mCecController.flush(new Runnable(){

                    @Override
                    public void run() {
                        HdmiControlService.this.mCecController.setOption(2, 0);
                        HdmiControlService.this.mMhlController.setOption(103, 0);
                        HdmiControlService.this.clearLocalDevices();
                    }
                });
            }
        });
    }

    @HdmiAnnotations.ServiceThreadOnly
    void setActivePortId(int portId) {
        this.assertRunOnServiceThread();
        this.mActivePortId = portId;
        this.setLastInputForMhl(-1);
    }

    @HdmiAnnotations.ServiceThreadOnly
    void setLastInputForMhl(int portId) {
        this.assertRunOnServiceThread();
        this.mLastInputMhl = portId;
    }

    @HdmiAnnotations.ServiceThreadOnly
    int getLastInputForMhl() {
        this.assertRunOnServiceThread();
        return this.mLastInputMhl;
    }

    @HdmiAnnotations.ServiceThreadOnly
    void changeInputForMhl(int portId, boolean contentOn) {
        int lastInput;
        this.assertRunOnServiceThread();
        if (this.tv() == null) {
            return;
        }
        int n = lastInput = contentOn ? this.tv().getActivePortId() : -1;
        if (portId != -1) {
            this.tv().doManualPortSwitching(portId, new IHdmiControlCallback.Stub(){

                @Override
                public void onComplete(int result) throws RemoteException {
                    HdmiControlService.this.setLastInputForMhl(lastInput);
                }
            });
        }
        this.tv().setActivePortId(portId);
        HdmiMhlLocalDeviceStub device = this.mMhlController.getLocalDevice(portId);
        HdmiDeviceInfo info = device != null ? device.getInfo() : this.mPortDeviceMap.get(portId, HdmiDeviceInfo.INACTIVE_DEVICE);
        this.invokeInputChangeListener(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMhlInputChangeEnabled(boolean enabled) {
        this.mMhlController.setOption(101, HdmiControlService.toInt(enabled));
        Object object = this.mLock;
        synchronized (object) {
            this.mMhlInputChangeEnabled = enabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isMhlInputChangeEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mMhlInputChangeEnabled;
        }
    }

    @HdmiAnnotations.ServiceThreadOnly
    void displayOsd(int messageId) {
        this.assertRunOnServiceThread();
        Intent intent = new Intent("android.hardware.hdmi.action.OSD_MESSAGE");
        intent.putExtra("android.hardware.hdmi.extra.MESSAGE_ID", messageId);
        this.getContext().sendBroadcastAsUser(intent, UserHandle.ALL, PERMISSION);
    }

    @HdmiAnnotations.ServiceThreadOnly
    void displayOsd(int messageId, int extra) {
        this.assertRunOnServiceThread();
        Intent intent = new Intent("android.hardware.hdmi.action.OSD_MESSAGE");
        intent.putExtra("android.hardware.hdmi.extra.MESSAGE_ID", messageId);
        intent.putExtra("android.hardware.hdmi.extra.MESSAGE_EXTRA_PARAM1", extra);
        this.getContext().sendBroadcastAsUser(intent, UserHandle.ALL, PERMISSION);
    }

    private final class InputChangeListenerRecord
    implements IBinder.DeathRecipient {
        private final IHdmiInputChangeListener mListener;

        public InputChangeListenerRecord(IHdmiInputChangeListener listener) {
            this.mListener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            Object object = HdmiControlService.this.mLock;
            synchronized (object) {
                HdmiControlService.this.mInputChangeListenerRecord = null;
            }
        }
    }

    private final class BinderService
    extends IHdmiControlService.Stub {
        private BinderService() {
        }

        @Override
        public int[] getSupportedTypes() {
            HdmiControlService.this.enforceAccessPermission();
            int[] localDevices = new int[HdmiControlService.this.mLocalDevices.size()];
            for (int i = 0; i < localDevices.length; ++i) {
                localDevices[i] = (Integer)HdmiControlService.this.mLocalDevices.get(i);
            }
            return localDevices;
        }

        @Override
        public HdmiDeviceInfo getActiveSource() {
            HdmiControlService.this.enforceAccessPermission();
            HdmiCecLocalDeviceTv tv = HdmiControlService.this.tv();
            if (tv == null) {
                Slog.w(HdmiControlService.TAG, "Local tv device not available");
                return null;
            }
            HdmiCecLocalDevice.ActiveSource activeSource = tv.getActiveSource();
            if (activeSource.isValid()) {
                return new HdmiDeviceInfo(activeSource.logicalAddress, activeSource.physicalAddress, -1, -1, 0, "");
            }
            int activePath = tv.getActivePath();
            if (activePath != 65535) {
                HdmiDeviceInfo info = tv.getSafeDeviceInfoByPath(activePath);
                return info != null ? info : new HdmiDeviceInfo(activePath, tv.getActivePortId());
            }
            return null;
        }

        @Override
        public void deviceSelect(final int deviceId, final IHdmiControlCallback callback) {
            HdmiControlService.this.enforceAccessPermission();
            HdmiControlService.this.runOnServiceThread(new Runnable(){

                @Override
                public void run() {
                    if (callback == null) {
                        Slog.e(HdmiControlService.TAG, "Callback cannot be null");
                        return;
                    }
                    HdmiCecLocalDeviceTv tv = HdmiControlService.this.tv();
                    if (tv == null) {
                        Slog.w(HdmiControlService.TAG, "Local tv device not available");
                        HdmiControlService.this.invokeCallback(callback, 2);
                        return;
                    }
                    HdmiMhlLocalDeviceStub device = HdmiControlService.this.mMhlController.getLocalDeviceById(deviceId);
                    if (device != null) {
                        if (device.getPortId() == tv.getActivePortId()) {
                            HdmiControlService.this.invokeCallback(callback, 0);
                            return;
                        }
                        device.turnOn(callback);
                        tv.doManualPortSwitching(device.getPortId(), null);
                        return;
                    }
                    tv.deviceSelect(deviceId, callback);
                }
            });
        }

        @Override
        public void portSelect(final int portId, final IHdmiControlCallback callback) {
            HdmiControlService.this.enforceAccessPermission();
            HdmiControlService.this.runOnServiceThread(new Runnable(){

                @Override
                public void run() {
                    if (callback == null) {
                        Slog.e(HdmiControlService.TAG, "Callback cannot be null");
                        return;
                    }
                    HdmiCecLocalDeviceTv tv = HdmiControlService.this.tv();
                    if (tv == null) {
                        Slog.w(HdmiControlService.TAG, "Local tv device not available");
                        HdmiControlService.this.invokeCallback(callback, 2);
                        return;
                    }
                    tv.doManualPortSwitching(portId, callback);
                }
            });
        }

        @Override
        public void sendKeyEvent(final int deviceType, final int keyCode, final boolean isPressed) {
            HdmiControlService.this.enforceAccessPermission();
            HdmiControlService.this.runOnServiceThread(new Runnable(){

                @Override
                public void run() {
                    HdmiMhlLocalDeviceStub device = HdmiControlService.this.mMhlController.getLocalDevice(HdmiControlService.this.mActivePortId);
                    if (device != null) {
                        device.sendKeyEvent(keyCode, isPressed);
                        return;
                    }
                    if (HdmiControlService.this.mCecController != null) {
                        HdmiCecLocalDevice localDevice = HdmiControlService.this.mCecController.getLocalDevice(deviceType);
                        if (localDevice == null) {
                            Slog.w(HdmiControlService.TAG, "Local device not available");
                            return;
                        }
                        localDevice.sendKeyEvent(keyCode, isPressed);
                    }
                }
            });
        }

        @Override
        public void oneTouchPlay(final IHdmiControlCallback callback) {
            HdmiControlService.this.enforceAccessPermission();
            HdmiControlService.this.runOnServiceThread(new Runnable(){

                @Override
                public void run() {
                    HdmiControlService.this.oneTouchPlay(callback);
                }
            });
        }

        @Override
        public void queryDisplayStatus(final IHdmiControlCallback callback) {
            HdmiControlService.this.enforceAccessPermission();
            HdmiControlService.this.runOnServiceThread(new Runnable(){

                @Override
                public void run() {
                    HdmiControlService.this.queryDisplayStatus(callback);
                }
            });
        }

        @Override
        public void addHotplugEventListener(IHdmiHotplugEventListener listener) {
            HdmiControlService.this.enforceAccessPermission();
            HdmiControlService.this.addHotplugEventListener(listener);
        }

        @Override
        public void removeHotplugEventListener(IHdmiHotplugEventListener listener) {
            HdmiControlService.this.enforceAccessPermission();
            HdmiControlService.this.removeHotplugEventListener(listener);
        }

        @Override
        public void addDeviceEventListener(IHdmiDeviceEventListener listener) {
            HdmiControlService.this.enforceAccessPermission();
            HdmiControlService.this.addDeviceEventListener(listener);
        }

        @Override
        public List<HdmiPortInfo> getPortInfo() {
            HdmiControlService.this.enforceAccessPermission();
            return HdmiControlService.this.getPortInfo();
        }

        @Override
        public boolean canChangeSystemAudioMode() {
            HdmiControlService.this.enforceAccessPermission();
            HdmiCecLocalDeviceTv tv = HdmiControlService.this.tv();
            if (tv == null) {
                return false;
            }
            return tv.hasSystemAudioDevice();
        }

        @Override
        public boolean getSystemAudioMode() {
            HdmiControlService.this.enforceAccessPermission();
            HdmiCecLocalDeviceTv tv = HdmiControlService.this.tv();
            if (tv == null) {
                return false;
            }
            return tv.isSystemAudioActivated();
        }

        @Override
        public void setSystemAudioMode(final boolean enabled, final IHdmiControlCallback callback) {
            HdmiControlService.this.enforceAccessPermission();
            HdmiControlService.this.runOnServiceThread(new Runnable(){

                @Override
                public void run() {
                    HdmiCecLocalDeviceTv tv = HdmiControlService.this.tv();
                    if (tv == null) {
                        Slog.w(HdmiControlService.TAG, "Local tv device not available");
                        HdmiControlService.this.invokeCallback(callback, 2);
                        return;
                    }
                    tv.changeSystemAudioMode(enabled, callback);
                }
            });
        }

        @Override
        public void addSystemAudioModeChangeListener(IHdmiSystemAudioModeChangeListener listener) {
            HdmiControlService.this.enforceAccessPermission();
            HdmiControlService.this.addSystemAudioModeChangeListner(listener);
        }

        @Override
        public void removeSystemAudioModeChangeListener(IHdmiSystemAudioModeChangeListener listener) {
            HdmiControlService.this.enforceAccessPermission();
            HdmiControlService.this.removeSystemAudioModeChangeListener(listener);
        }

        @Override
        public void setInputChangeListener(IHdmiInputChangeListener listener) {
            HdmiControlService.this.enforceAccessPermission();
            HdmiControlService.this.setInputChangeListener(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<HdmiDeviceInfo> getInputDevices() {
            HdmiControlService.this.enforceAccessPermission();
            HdmiCecLocalDeviceTv tv = HdmiControlService.this.tv();
            Object object = HdmiControlService.this.mLock;
            synchronized (object) {
                List<Object> cecDevices = tv == null ? Collections.emptyList() : tv.getSafeExternalInputsLocked();
                return HdmiUtils.mergeToUnmodifiableList(cecDevices, HdmiControlService.this.getMhlDevicesLocked());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<HdmiDeviceInfo> getDeviceList() {
            HdmiControlService.this.enforceAccessPermission();
            HdmiCecLocalDeviceTv tv = HdmiControlService.this.tv();
            Object object = HdmiControlService.this.mLock;
            synchronized (object) {
                return tv == null ? Collections.emptyList() : tv.getSafeCecDevicesLocked();
            }
        }

        @Override
        public void setSystemAudioVolume(final int oldIndex, final int newIndex, final int maxIndex) {
            HdmiControlService.this.enforceAccessPermission();
            HdmiControlService.this.runOnServiceThread(new Runnable(){

                @Override
                public void run() {
                    HdmiCecLocalDeviceTv tv = HdmiControlService.this.tv();
                    if (tv == null) {
                        Slog.w(HdmiControlService.TAG, "Local tv device not available");
                        return;
                    }
                    tv.changeVolume(oldIndex, newIndex - oldIndex, maxIndex);
                }
            });
        }

        @Override
        public void setSystemAudioMute(final boolean mute) {
            HdmiControlService.this.enforceAccessPermission();
            HdmiControlService.this.runOnServiceThread(new Runnable(){

                @Override
                public void run() {
                    HdmiCecLocalDeviceTv tv = HdmiControlService.this.tv();
                    if (tv == null) {
                        Slog.w(HdmiControlService.TAG, "Local tv device not available");
                        return;
                    }
                    tv.changeMute(mute);
                }
            });
        }

        @Override
        public void setArcMode(boolean enabled) {
            HdmiControlService.this.enforceAccessPermission();
            HdmiControlService.this.runOnServiceThread(new Runnable(){

                @Override
                public void run() {
                    HdmiCecLocalDeviceTv tv = HdmiControlService.this.tv();
                    if (tv == null) {
                        Slog.w(HdmiControlService.TAG, "Local tv device not available to change arc mode.");
                        return;
                    }
                }
            });
        }

        @Override
        public void setProhibitMode(boolean enabled) {
            HdmiControlService.this.enforceAccessPermission();
            if (!HdmiControlService.this.isTvDevice()) {
                return;
            }
            HdmiControlService.this.setProhibitMode(enabled);
        }

        @Override
        public void addVendorCommandListener(IHdmiVendorCommandListener listener, int deviceType) {
            HdmiControlService.this.enforceAccessPermission();
            HdmiControlService.this.addVendorCommandListener(listener, deviceType);
        }

        @Override
        public void sendVendorCommand(final int deviceType, final int targetAddress, final byte[] params, final boolean hasVendorId) {
            HdmiControlService.this.enforceAccessPermission();
            HdmiControlService.this.runOnServiceThread(new Runnable(){

                @Override
                public void run() {
                    HdmiCecLocalDevice device = HdmiControlService.this.mCecController.getLocalDevice(deviceType);
                    if (device == null) {
                        Slog.w(HdmiControlService.TAG, "Local device not available");
                        return;
                    }
                    if (hasVendorId) {
                        HdmiControlService.this.sendCecCommand(HdmiCecMessageBuilder.buildVendorCommandWithId(device.getDeviceInfo().getLogicalAddress(), targetAddress, HdmiControlService.this.getVendorId(), params));
                    } else {
                        HdmiControlService.this.sendCecCommand(HdmiCecMessageBuilder.buildVendorCommand(device.getDeviceInfo().getLogicalAddress(), targetAddress, params));
                    }
                }
            });
        }

        @Override
        public void sendStandby(final int deviceType, final int deviceId) {
            HdmiControlService.this.enforceAccessPermission();
            HdmiControlService.this.runOnServiceThread(new Runnable(){

                @Override
                public void run() {
                    HdmiMhlLocalDeviceStub mhlDevice = HdmiControlService.this.mMhlController.getLocalDeviceById(deviceId);
                    if (mhlDevice != null) {
                        mhlDevice.sendStandby();
                        return;
                    }
                    HdmiCecLocalDevice device = HdmiControlService.this.mCecController.getLocalDevice(deviceType);
                    if (device == null) {
                        Slog.w(HdmiControlService.TAG, "Local device not available");
                        return;
                    }
                    device.sendStandby(deviceId);
                }
            });
        }

        @Override
        public void setHdmiRecordListener(IHdmiRecordListener listener) {
            HdmiControlService.this.enforceAccessPermission();
            HdmiControlService.this.setHdmiRecordListener(listener);
        }

        @Override
        public void startOneTouchRecord(final int recorderAddress, final byte[] recordSource) {
            HdmiControlService.this.enforceAccessPermission();
            HdmiControlService.this.runOnServiceThread(new Runnable(){

                @Override
                public void run() {
                    if (!HdmiControlService.this.isTvDeviceEnabled()) {
                        Slog.w(HdmiControlService.TAG, "TV device is not enabled.");
                        return;
                    }
                    HdmiControlService.this.tv().startOneTouchRecord(recorderAddress, recordSource);
                }
            });
        }

        @Override
        public void stopOneTouchRecord(final int recorderAddress) {
            HdmiControlService.this.enforceAccessPermission();
            HdmiControlService.this.runOnServiceThread(new Runnable(){

                @Override
                public void run() {
                    if (!HdmiControlService.this.isTvDeviceEnabled()) {
                        Slog.w(HdmiControlService.TAG, "TV device is not enabled.");
                        return;
                    }
                    HdmiControlService.this.tv().stopOneTouchRecord(recorderAddress);
                }
            });
        }

        @Override
        public void startTimerRecording(final int recorderAddress, final int sourceType, final byte[] recordSource) {
            HdmiControlService.this.enforceAccessPermission();
            HdmiControlService.this.runOnServiceThread(new Runnable(){

                @Override
                public void run() {
                    if (!HdmiControlService.this.isTvDeviceEnabled()) {
                        Slog.w(HdmiControlService.TAG, "TV device is not enabled.");
                        return;
                    }
                    HdmiControlService.this.tv().startTimerRecording(recorderAddress, sourceType, recordSource);
                }
            });
        }

        @Override
        public void clearTimerRecording(final int recorderAddress, final int sourceType, final byte[] recordSource) {
            HdmiControlService.this.enforceAccessPermission();
            HdmiControlService.this.runOnServiceThread(new Runnable(){

                @Override
                public void run() {
                    if (!HdmiControlService.this.isTvDeviceEnabled()) {
                        Slog.w(HdmiControlService.TAG, "TV device is not enabled.");
                        return;
                    }
                    HdmiControlService.this.tv().clearTimerRecording(recorderAddress, sourceType, recordSource);
                }
            });
        }

        @Override
        public void sendMhlVendorCommand(final int portId, final int offset, final int length, final byte[] data) {
            HdmiControlService.this.enforceAccessPermission();
            HdmiControlService.this.runOnServiceThread(new Runnable(){

                @Override
                public void run() {
                    if (!HdmiControlService.this.isControlEnabled()) {
                        Slog.w(HdmiControlService.TAG, "Hdmi control is disabled.");
                        return;
                    }
                    HdmiMhlLocalDeviceStub device = HdmiControlService.this.mMhlController.getLocalDevice(portId);
                    if (device == null) {
                        Slog.w(HdmiControlService.TAG, "Invalid port id:" + portId);
                        return;
                    }
                    HdmiControlService.this.mMhlController.sendVendorCommand(portId, offset, length, data);
                }
            });
        }

        @Override
        public void addHdmiMhlVendorCommandListener(IHdmiMhlVendorCommandListener listener) {
            HdmiControlService.this.enforceAccessPermission();
            HdmiControlService.this.addHdmiMhlVendorCommandListener(listener);
        }

        @Override
        protected void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
            HdmiControlService.this.getContext().enforceCallingOrSelfPermission("android.permission.DUMP", HdmiControlService.TAG);
            IndentingPrintWriter pw = new IndentingPrintWriter((Writer)writer, "  ");
            pw.println("mHdmiControlEnabled: " + HdmiControlService.this.mHdmiControlEnabled);
            pw.println("mProhibitMode: " + HdmiControlService.this.mProhibitMode);
            if (HdmiControlService.this.mCecController != null) {
                pw.println("mCecController: ");
                pw.increaseIndent();
                HdmiControlService.this.mCecController.dump(pw);
                pw.decreaseIndent();
            }
            pw.println("mMhlController: ");
            pw.increaseIndent();
            HdmiControlService.this.mMhlController.dump(pw);
            pw.decreaseIndent();
            pw.println("mPortInfo: ");
            pw.increaseIndent();
            for (HdmiPortInfo hdmiPortInfo : HdmiControlService.this.mPortInfo) {
                pw.println("- " + hdmiPortInfo);
            }
            pw.decreaseIndent();
            pw.println("mPowerStatus: " + HdmiControlService.this.mPowerStatus);
        }
    }

    private class HdmiRecordListenerRecord
    implements IBinder.DeathRecipient {
        private final IHdmiRecordListener mListener;

        public HdmiRecordListenerRecord(IHdmiRecordListener listener) {
            this.mListener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            Object object = HdmiControlService.this.mLock;
            synchronized (object) {
                HdmiControlService.this.mRecordListenerRecord = null;
            }
        }
    }

    class VendorCommandListenerRecord
    implements IBinder.DeathRecipient {
        private final IHdmiVendorCommandListener mListener;
        private final int mDeviceType;

        public VendorCommandListenerRecord(IHdmiVendorCommandListener listener, int deviceType) {
            this.mListener = listener;
            this.mDeviceType = deviceType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            Object object = HdmiControlService.this.mLock;
            synchronized (object) {
                HdmiControlService.this.mVendorCommandListenerRecords.remove(this);
            }
        }
    }

    private final class SystemAudioModeChangeListenerRecord
    implements IBinder.DeathRecipient {
        private final IHdmiSystemAudioModeChangeListener mListener;

        public SystemAudioModeChangeListenerRecord(IHdmiSystemAudioModeChangeListener listener) {
            this.mListener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            Object object = HdmiControlService.this.mLock;
            synchronized (object) {
                HdmiControlService.this.mSystemAudioModeChangeListenerRecords.remove(this);
            }
        }
    }

    private final class DeviceEventListenerRecord
    implements IBinder.DeathRecipient {
        private final IHdmiDeviceEventListener mListener;

        public DeviceEventListenerRecord(IHdmiDeviceEventListener listener) {
            this.mListener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            Object object = HdmiControlService.this.mLock;
            synchronized (object) {
                HdmiControlService.this.mDeviceEventListenerRecords.remove(this);
            }
        }
    }

    private final class HotplugEventListenerRecord
    implements IBinder.DeathRecipient {
        private final IHdmiHotplugEventListener mListener;

        public HotplugEventListenerRecord(IHdmiHotplugEventListener listener) {
            this.mListener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            Object object = HdmiControlService.this.mLock;
            synchronized (object) {
                HdmiControlService.this.mHotplugEventListenerRecords.remove(this);
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof HotplugEventListenerRecord)) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            HotplugEventListenerRecord other = (HotplugEventListenerRecord)obj;
            return other.mListener == this.mListener;
        }

        public int hashCode() {
            return this.mListener.hashCode();
        }
    }

    private class HdmiMhlVendorCommandListenerRecord
    implements IBinder.DeathRecipient {
        private final IHdmiMhlVendorCommandListener mListener;

        public HdmiMhlVendorCommandListenerRecord(IHdmiMhlVendorCommandListener listener) {
            this.mListener = listener;
        }

        @Override
        public void binderDied() {
            HdmiControlService.this.mMhlVendorCommandListenerRecords.remove(this);
        }
    }

    private class SettingsObserver
    extends ContentObserver {
        public SettingsObserver(Handler handler) {
            super(handler);
        }

        @Override
        public void onChange(boolean selfChange, Uri uri) {
            String option = uri.getLastPathSegment();
            boolean enabled = HdmiControlService.this.readBooleanSetting(option, true);
            switch (option) {
                case "hdmi_control_enabled": {
                    HdmiControlService.this.setControlEnabled(enabled);
                    break;
                }
                case "hdmi_control_auto_wakeup_enabled": {
                    if (HdmiControlService.this.isTvDeviceEnabled()) {
                        HdmiControlService.this.tv().setAutoWakeup(enabled);
                    }
                    HdmiControlService.this.setCecOption(1, HdmiControlService.toInt(enabled));
                    break;
                }
                case "hdmi_control_auto_device_off_enabled": {
                    Iterator i$ = HdmiControlService.this.mLocalDevices.iterator();
                    while (i$.hasNext()) {
                        int type = (Integer)i$.next();
                        HdmiCecLocalDevice localDevice = HdmiControlService.this.mCecController.getLocalDevice(type);
                        localDevice.setAutoDeviceOff(enabled);
                    }
                    break;
                }
                case "mhl_input_switching_enabled": {
                    HdmiControlService.this.setMhlInputChangeEnabled(enabled);
                    break;
                }
                case "mhl_power_charge_enabled": {
                    HdmiControlService.this.mMhlController.setOption(102, HdmiControlService.toInt(enabled));
                }
            }
        }
    }

    private final class CecMessageBuffer {
        private List<HdmiCecMessage> mBuffer = new ArrayList<HdmiCecMessage>();

        private CecMessageBuffer() {
        }

        public void bufferMessage(HdmiCecMessage message) {
            switch (message.getOpcode()) {
                case 130: {
                    this.bufferActiveSource(message);
                    break;
                }
                case 4: 
                case 13: {
                    this.bufferImageOrTextViewOn(message);
                    break;
                }
            }
        }

        public void processMessages() {
            for (final HdmiCecMessage message : this.mBuffer) {
                HdmiControlService.this.runOnServiceThread(new Runnable(){

                    @Override
                    public void run() {
                        HdmiControlService.this.handleCecCommand(message);
                    }
                });
            }
            this.mBuffer.clear();
        }

        private void bufferActiveSource(HdmiCecMessage message) {
            if (!this.replaceMessageIfBuffered(message, 130)) {
                this.mBuffer.add(message);
            }
        }

        private void bufferImageOrTextViewOn(HdmiCecMessage message) {
            if (!this.replaceMessageIfBuffered(message, 4) && !this.replaceMessageIfBuffered(message, 13)) {
                this.mBuffer.add(message);
            }
        }

        private boolean replaceMessageIfBuffered(HdmiCecMessage message, int opcode) {
            for (int i = 0; i < this.mBuffer.size(); ++i) {
                HdmiCecMessage bufferedMessage = this.mBuffer.get(i);
                if (bufferedMessage.getOpcode() != opcode) continue;
                this.mBuffer.set(i, message);
                return true;
            }
            return false;
        }
    }

    private class HdmiControlBroadcastReceiver
    extends BroadcastReceiver {
        private HdmiControlBroadcastReceiver() {
        }

        @Override
        @HdmiAnnotations.ServiceThreadOnly
        public void onReceive(Context context, Intent intent) {
            HdmiControlService.this.assertRunOnServiceThread();
            switch (intent.getAction()) {
                case "android.intent.action.SCREEN_OFF": {
                    if (!HdmiControlService.this.isPowerOnOrTransient()) break;
                    HdmiControlService.this.onStandby(0);
                    break;
                }
                case "android.intent.action.SCREEN_ON": {
                    if (!HdmiControlService.this.isPowerStandbyOrTransient()) break;
                    HdmiControlService.this.onWakeUp();
                    break;
                }
                case "android.intent.action.CONFIGURATION_CHANGED": {
                    String language = this.getMenuLanguage();
                    if (HdmiControlService.this.mLanguage.equals(language)) break;
                    HdmiControlService.this.onLanguageChanged(language);
                    break;
                }
                case "android.intent.action.ACTION_SHUTDOWN": {
                    if (!HdmiControlService.this.isPowerOnOrTransient()) break;
                    HdmiControlService.this.onStandby(1);
                }
            }
        }

        private String getMenuLanguage() {
            Locale locale = Locale.getDefault();
            if (locale.equals(Locale.TAIWAN) || locale.equals(HdmiControlService.this.HONG_KONG) || locale.equals(HdmiControlService.this.MACAU)) {
                return "chi";
            }
            return locale.getISO3Language();
        }
    }

    static interface DevicePollingCallback {
        public void onPollingFinished(List<Integer> var1);
    }

    static interface SendMessageCallback {
        public void onSendCompleted(int var1);
    }
}

