/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.hdmi;

import android.hardware.hdmi.IHdmiControlCallback;
import android.os.RemoteException;
import android.util.Slog;
import com.android.server.hdmi.HdmiCecFeatureAction;
import com.android.server.hdmi.HdmiCecLocalDevice;
import com.android.server.hdmi.HdmiCecLocalDevicePlayback;
import com.android.server.hdmi.HdmiCecMessage;
import com.android.server.hdmi.HdmiCecMessageBuilder;

final class OneTouchPlayAction
extends HdmiCecFeatureAction {
    private static final String TAG = "OneTouchPlayAction";
    private static final int STATE_WAITING_FOR_REPORT_POWER_STATUS = 1;
    private static final int LOOP_COUNTER_MAX = 10;
    private final int mTargetAddress;
    private final IHdmiControlCallback mCallback;
    private int mPowerStatusCounter = 0;

    static OneTouchPlayAction create(HdmiCecLocalDevicePlayback source, int targetAddress, IHdmiControlCallback callback) {
        if (source == null || callback == null) {
            Slog.e(TAG, "Wrong arguments");
            return null;
        }
        return new OneTouchPlayAction(source, targetAddress, callback);
    }

    private OneTouchPlayAction(HdmiCecLocalDevice localDevice, int targetAddress, IHdmiControlCallback callback) {
        super(localDevice);
        this.mTargetAddress = targetAddress;
        this.mCallback = callback;
    }

    @Override
    boolean start() {
        this.sendCommand(HdmiCecMessageBuilder.buildTextViewOn(this.getSourceAddress(), this.mTargetAddress));
        this.broadcastActiveSource();
        this.queryDevicePowerStatus();
        this.mState = 1;
        this.addTimer(this.mState, 2000);
        return true;
    }

    private void broadcastActiveSource() {
        this.sendCommand(HdmiCecMessageBuilder.buildActiveSource(this.getSourceAddress(), this.getSourcePath()));
        this.playback().setActiveSource(true);
    }

    private void queryDevicePowerStatus() {
        this.sendCommand(HdmiCecMessageBuilder.buildGiveDevicePowerStatus(this.getSourceAddress(), this.mTargetAddress));
    }

    @Override
    boolean processCommand(HdmiCecMessage cmd) {
        if (this.mState != 1 || this.mTargetAddress != cmd.getSource()) {
            return false;
        }
        if (cmd.getOpcode() == 144) {
            byte status = cmd.getParams()[0];
            if (status == 0) {
                this.broadcastActiveSource();
                this.invokeCallback(0);
                this.finish();
            }
            return true;
        }
        return false;
    }

    @Override
    void handleTimerEvent(int state) {
        if (this.mState != state) {
            return;
        }
        if (state == 1) {
            if (this.mPowerStatusCounter++ < 10) {
                this.queryDevicePowerStatus();
                this.addTimer(this.mState, 2000);
            } else {
                this.invokeCallback(1);
                this.finish();
            }
        }
    }

    private void invokeCallback(int result) {
        try {
            this.mCallback.onComplete(result);
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Callback failed:" + e);
        }
    }
}

