/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.job;

import android.app.ActivityManager;
import android.app.job.IJobCallback;
import android.app.job.IJobService;
import android.app.job.JobParameters;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.WorkSource;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.app.IBatteryStats;
import com.android.server.job.JobCompletedListener;
import com.android.server.job.JobSchedulerService;
import com.android.server.job.controllers.JobStatus;
import java.util.concurrent.atomic.AtomicBoolean;

public class JobServiceContext
extends IJobCallback.Stub
implements ServiceConnection {
    private static final boolean DEBUG = false;
    private static final String TAG = "JobServiceContext";
    private static final int defaultMaxActiveJobsPerService = ActivityManager.isLowRamDeviceStatic() ? 1 : 3;
    private static final long EXECUTING_TIMESLICE_MILLIS = 600000L;
    private static final long OP_TIMEOUT_MILLIS = 8000L;
    private static final String[] VERB_STRINGS = new String[]{"VERB_BINDING", "VERB_STARTING", "VERB_EXECUTING", "VERB_STOPPING"};
    static final int VERB_BINDING = 0;
    static final int VERB_STARTING = 1;
    static final int VERB_EXECUTING = 2;
    static final int VERB_STOPPING = 3;
    private static final int MSG_TIMEOUT = 0;
    private static final int MSG_CALLBACK = 1;
    private static final int MSG_SERVICE_BOUND = 2;
    private static final int MSG_CANCEL = 3;
    private static final int MSG_SHUTDOWN_EXECUTION = 4;
    private final Handler mCallbackHandler;
    private final JobCompletedListener mCompletedListener;
    private final Context mContext;
    private final IBatteryStats mBatteryStats;
    private PowerManager.WakeLock mWakeLock;
    private JobParameters mParams;
    int mVerb;
    private AtomicBoolean mCancelled = new AtomicBoolean();
    private JobStatus mRunningJob;
    IJobService service;
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private boolean mAvailable;
    private long mExecutionStartTimeElapsed;
    private long mTimeoutElapsed;

    JobServiceContext(JobSchedulerService service, IBatteryStats batteryStats, Looper looper) {
        this(service.getContext(), batteryStats, service, looper);
    }

    JobServiceContext(Context context, IBatteryStats batteryStats, JobCompletedListener completedListener, Looper looper) {
        this.mContext = context;
        this.mBatteryStats = batteryStats;
        this.mCallbackHandler = new JobServiceHandler(looper);
        this.mCompletedListener = completedListener;
        this.mAvailable = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean executeRunnableJob(JobStatus job) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mAvailable) {
                Slog.e(TAG, "Starting new runnable but context is unavailable > Error.");
                return false;
            }
            this.mRunningJob = job;
            boolean isDeadlineExpired = job.hasDeadlineConstraint() && job.getLatestRunTimeElapsed() < SystemClock.elapsedRealtime();
            this.mParams = new JobParameters(this, job.getJobId(), job.getExtras(), isDeadlineExpired);
            this.mExecutionStartTimeElapsed = SystemClock.elapsedRealtime();
            this.mVerb = 0;
            this.scheduleOpTimeOut();
            Intent intent = new Intent().setComponent(job.getServiceComponent());
            boolean binding = this.mContext.bindServiceAsUser(intent, this, 5, new UserHandle(job.getUserId()));
            if (!binding) {
                this.mRunningJob = null;
                this.mParams = null;
                this.mExecutionStartTimeElapsed = 0L;
                this.removeOpTimeOut();
                return false;
            }
            try {
                this.mBatteryStats.noteJobStart(job.getName(), job.getUid());
            }
            catch (RemoteException e) {
                // empty catch block
            }
            this.mAvailable = false;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JobStatus getRunningJob() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mRunningJob;
        }
    }

    void cancelExecutingJob() {
        this.mCallbackHandler.obtainMessage(3).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isAvailable() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mAvailable;
        }
    }

    long getExecutionStartTimeElapsed() {
        return this.mExecutionStartTimeElapsed;
    }

    long getTimeoutElapsed() {
        return this.mTimeoutElapsed;
    }

    @Override
    public void jobFinished(int jobId, boolean reschedule) {
        if (!this.verifyCallingUid()) {
            return;
        }
        this.mCallbackHandler.obtainMessage(1, jobId, reschedule ? 1 : 0).sendToTarget();
    }

    @Override
    public void acknowledgeStopMessage(int jobId, boolean reschedule) {
        if (!this.verifyCallingUid()) {
            return;
        }
        this.mCallbackHandler.obtainMessage(1, jobId, reschedule ? 1 : 0).sendToTarget();
    }

    @Override
    public void acknowledgeStartMessage(int jobId, boolean ongoing) {
        if (!this.verifyCallingUid()) {
            return;
        }
        this.mCallbackHandler.obtainMessage(1, jobId, ongoing ? 1 : 0).sendToTarget();
    }

    @Override
    public void onServiceConnected(ComponentName name, IBinder service) {
        if (!name.equals(this.mRunningJob.getServiceComponent())) {
            this.mCallbackHandler.obtainMessage(4).sendToTarget();
            return;
        }
        this.service = IJobService.Stub.asInterface(service);
        PowerManager pm = (PowerManager)this.mContext.getSystemService("power");
        this.mWakeLock = pm.newWakeLock(1, this.mRunningJob.getTag());
        this.mWakeLock.setWorkSource(new WorkSource(this.mRunningJob.getUid()));
        this.mWakeLock.setReferenceCounted(false);
        this.mWakeLock.acquire();
        this.mCallbackHandler.obtainMessage(2).sendToTarget();
    }

    @Override
    public void onServiceDisconnected(ComponentName name) {
        this.mCallbackHandler.obtainMessage(4).sendToTarget();
    }

    private boolean verifyCallingUid() {
        return this.mRunningJob != null && Binder.getCallingUid() == this.mRunningJob.getUid();
    }

    private void scheduleOpTimeOut() {
        this.removeOpTimeOut();
        long timeoutMillis = this.mVerb == 2 ? 600000L : 8000L;
        Message m = this.mCallbackHandler.obtainMessage(0);
        this.mCallbackHandler.sendMessageDelayed(m, timeoutMillis);
        this.mTimeoutElapsed = SystemClock.elapsedRealtime() + timeoutMillis;
    }

    private void removeOpTimeOut() {
        this.mCallbackHandler.removeMessages(0);
    }

    private class JobServiceHandler
    extends Handler {
        JobServiceHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message message) {
            switch (message.what) {
                case 2: {
                    JobServiceContext.this.removeOpTimeOut();
                    this.handleServiceBoundH();
                    break;
                }
                case 1: {
                    JobServiceContext.this.removeOpTimeOut();
                    if (JobServiceContext.this.mVerb == 1) {
                        boolean workOngoing = message.arg2 == 1;
                        this.handleStartedH(workOngoing);
                        break;
                    }
                    if (JobServiceContext.this.mVerb != 2 && JobServiceContext.this.mVerb != 3) break;
                    boolean reschedule = message.arg2 == 1;
                    this.handleFinishedH(reschedule);
                    break;
                }
                case 3: {
                    this.handleCancelH();
                    break;
                }
                case 0: {
                    this.handleOpTimeoutH();
                    break;
                }
                case 4: {
                    this.closeAndCleanupJobH(true);
                    break;
                }
                default: {
                    Slog.e(JobServiceContext.TAG, "Unrecognised message: " + message);
                }
            }
        }

        private void handleServiceBoundH() {
            if (JobServiceContext.this.mVerb != 0) {
                Slog.e(JobServiceContext.TAG, "Sending onStartJob for a job that isn't pending. " + VERB_STRINGS[JobServiceContext.this.mVerb]);
                this.closeAndCleanupJobH(false);
                return;
            }
            if (JobServiceContext.this.mCancelled.get()) {
                this.closeAndCleanupJobH(true);
                return;
            }
            try {
                JobServiceContext.this.mVerb = 1;
                JobServiceContext.this.scheduleOpTimeOut();
                JobServiceContext.this.service.startJob(JobServiceContext.this.mParams);
            }
            catch (RemoteException e) {
                Slog.e(JobServiceContext.TAG, "Error sending onStart message to '" + JobServiceContext.this.mRunningJob.getServiceComponent().getShortClassName() + "' ", e);
            }
        }

        private void handleStartedH(boolean workOngoing) {
            switch (JobServiceContext.this.mVerb) {
                case 1: {
                    JobServiceContext.this.mVerb = 2;
                    if (!workOngoing) {
                        this.handleFinishedH(false);
                        return;
                    }
                    if (JobServiceContext.this.mCancelled.get()) {
                        this.handleCancelH();
                        return;
                    }
                    JobServiceContext.this.scheduleOpTimeOut();
                    break;
                }
                default: {
                    Slog.e(JobServiceContext.TAG, "Handling started job but job wasn't starting! Was " + VERB_STRINGS[JobServiceContext.this.mVerb] + ".");
                    return;
                }
            }
        }

        private void handleFinishedH(boolean reschedule) {
            switch (JobServiceContext.this.mVerb) {
                case 2: 
                case 3: {
                    this.closeAndCleanupJobH(reschedule);
                    break;
                }
                default: {
                    Slog.e(JobServiceContext.TAG, "Got an execution complete message for a job that wasn't beingexecuted. Was " + VERB_STRINGS[JobServiceContext.this.mVerb] + ".");
                }
            }
        }

        private void handleCancelH() {
            if (JobServiceContext.this.mRunningJob == null) {
                return;
            }
            switch (JobServiceContext.this.mVerb) {
                case 0: 
                case 1: {
                    JobServiceContext.this.mCancelled.set(true);
                    break;
                }
                case 2: {
                    if (this.hasMessages(1)) {
                        return;
                    }
                    this.sendStopMessageH();
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    Slog.e(JobServiceContext.TAG, "Cancelling a job without a valid verb: " + JobServiceContext.this.mVerb);
                }
            }
        }

        private void handleOpTimeoutH() {
            switch (JobServiceContext.this.mVerb) {
                case 0: {
                    Slog.e(JobServiceContext.TAG, "Time-out while trying to bind " + JobServiceContext.this.mRunningJob.toShortString() + ", dropping.");
                    this.closeAndCleanupJobH(false);
                    break;
                }
                case 1: {
                    Slog.e(JobServiceContext.TAG, "No response from client for onStartJob '" + JobServiceContext.this.mRunningJob.toShortString());
                    this.closeAndCleanupJobH(false);
                    break;
                }
                case 3: {
                    Slog.e(JobServiceContext.TAG, "No response from client for onStopJob, '" + JobServiceContext.this.mRunningJob.toShortString());
                    this.closeAndCleanupJobH(true);
                    break;
                }
                case 2: {
                    Slog.i(JobServiceContext.TAG, "Client timed out while executing (no jobFinished received). sending onStop. " + JobServiceContext.this.mRunningJob.toShortString());
                    this.sendStopMessageH();
                    break;
                }
                default: {
                    Slog.e(JobServiceContext.TAG, "Handling timeout for an invalid job state: " + JobServiceContext.this.mRunningJob.toShortString() + ", dropping.");
                    this.closeAndCleanupJobH(false);
                }
            }
        }

        private void sendStopMessageH() {
            JobServiceContext.this.removeOpTimeOut();
            if (JobServiceContext.this.mVerb != 2) {
                Slog.e(JobServiceContext.TAG, "Sending onStopJob for a job that isn't started. " + JobServiceContext.this.mRunningJob);
                this.closeAndCleanupJobH(false);
                return;
            }
            try {
                JobServiceContext.this.mVerb = 3;
                JobServiceContext.this.scheduleOpTimeOut();
                JobServiceContext.this.service.stopJob(JobServiceContext.this.mParams);
            }
            catch (RemoteException e) {
                Slog.e(JobServiceContext.TAG, "Error sending onStopJob to client.", e);
                this.closeAndCleanupJobH(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeAndCleanupJobH(boolean reschedule) {
            JobStatus completedJob = JobServiceContext.this.mRunningJob;
            Object object = JobServiceContext.this.mLock;
            synchronized (object) {
                try {
                    JobServiceContext.this.mBatteryStats.noteJobFinish(JobServiceContext.this.mRunningJob.getName(), JobServiceContext.this.mRunningJob.getUid());
                }
                catch (RemoteException e) {
                    // empty catch block
                }
                if (JobServiceContext.this.mWakeLock != null) {
                    JobServiceContext.this.mWakeLock.release();
                }
                JobServiceContext.this.mContext.unbindService(JobServiceContext.this);
                JobServiceContext.this.mWakeLock = null;
                JobServiceContext.this.mRunningJob = null;
                JobServiceContext.this.mParams = null;
                JobServiceContext.this.mVerb = -1;
                JobServiceContext.this.mCancelled.set(false);
                JobServiceContext.this.service = null;
                JobServiceContext.this.mAvailable = true;
            }
            JobServiceContext.this.removeOpTimeOut();
            this.removeMessages(1);
            this.removeMessages(2);
            this.removeMessages(3);
            this.removeMessages(4);
            JobServiceContext.this.mCompletedListener.onJobCompleted(completedJob, reschedule);
        }
    }
}

