/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.job.controllers;

import android.app.usage.UsageStatsManagerInternal;
import android.content.Context;
import com.android.server.LocalServices;
import com.android.server.job.JobSchedulerService;
import com.android.server.job.StateChangedListener;
import com.android.server.job.controllers.JobStatus;
import com.android.server.job.controllers.StateController;
import java.io.PrintWriter;
import java.util.ArrayList;

public class AppIdleController
extends StateController {
    private static final String LOG_TAG = "AppIdleController";
    private static final boolean DEBUG = false;
    private static Object sCreationLock = new Object();
    private static volatile AppIdleController sController;
    final ArrayList<JobStatus> mTrackedTasks = new ArrayList();
    private final UsageStatsManagerInternal mUsageStatsInternal = LocalServices.getService(UsageStatsManagerInternal.class);
    boolean mAppIdleParoleOn = this.mUsageStatsInternal.isAppIdleParoleOn();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AppIdleController get(JobSchedulerService service) {
        Object object = sCreationLock;
        synchronized (object) {
            if (sController == null) {
                sController = new AppIdleController(service, service.getContext());
            }
            return sController;
        }
    }

    private AppIdleController(StateChangedListener stateChangedListener, Context context) {
        super(stateChangedListener, context);
        this.mUsageStatsInternal.addAppIdleStateChangeListener(new AppIdleStateChangeListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void maybeStartTrackingJob(JobStatus jobStatus) {
        ArrayList<JobStatus> arrayList = this.mTrackedTasks;
        synchronized (arrayList) {
            this.mTrackedTasks.add(jobStatus);
            String packageName = jobStatus.job.getService().getPackageName();
            boolean appIdle = !this.mAppIdleParoleOn && this.mUsageStatsInternal.isAppIdle(packageName, jobStatus.getUserId());
            jobStatus.appNotIdleConstraintSatisfied.set(!appIdle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void maybeStopTrackingJob(JobStatus jobStatus) {
        ArrayList<JobStatus> arrayList = this.mTrackedTasks;
        synchronized (arrayList) {
            this.mTrackedTasks.remove(jobStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dumpControllerState(PrintWriter pw) {
        pw.println("AppIdle");
        pw.println("Parole On: " + this.mAppIdleParoleOn);
        ArrayList<JobStatus> arrayList = this.mTrackedTasks;
        synchronized (arrayList) {
            for (JobStatus task : this.mTrackedTasks) {
                pw.print(task.job.getService().getPackageName());
                pw.print(":idle=" + !task.appNotIdleConstraintSatisfied.get());
                pw.print(", ");
            }
            pw.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAppIdleParoleOn(boolean isAppIdleParoleOn) {
        boolean changed = false;
        ArrayList<JobStatus> arrayList = this.mTrackedTasks;
        synchronized (arrayList) {
            if (this.mAppIdleParoleOn == isAppIdleParoleOn) {
                return;
            }
            this.mAppIdleParoleOn = isAppIdleParoleOn;
            for (JobStatus task : this.mTrackedTasks) {
                boolean appIdle;
                String packageName = task.job.getService().getPackageName();
                boolean bl = appIdle = !this.mAppIdleParoleOn && this.mUsageStatsInternal.isAppIdle(packageName, task.getUserId());
                if (task.appNotIdleConstraintSatisfied.get() != appIdle) continue;
                task.appNotIdleConstraintSatisfied.set(!appIdle);
                changed = true;
            }
        }
        if (changed) {
            this.mStateChangedListener.onControllerStateChanged();
        }
    }

    private class AppIdleStateChangeListener
    extends UsageStatsManagerInternal.AppIdleStateChangeListener {
        private AppIdleStateChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAppIdleStateChanged(String packageName, int userId, boolean idle) {
            boolean changed = false;
            ArrayList<JobStatus> arrayList = AppIdleController.this.mTrackedTasks;
            synchronized (arrayList) {
                if (AppIdleController.this.mAppIdleParoleOn) {
                    return;
                }
                for (JobStatus task : AppIdleController.this.mTrackedTasks) {
                    if (!task.job.getService().getPackageName().equals(packageName) || task.getUserId() != userId || task.appNotIdleConstraintSatisfied.get() == !idle) continue;
                    task.appNotIdleConstraintSatisfied.set(!idle);
                    changed = true;
                }
            }
            if (changed) {
                AppIdleController.this.mStateChangedListener.onControllerStateChanged();
            }
        }

        @Override
        public void onParoleStateChanged(boolean isParoleOn) {
            AppIdleController.this.setAppIdleParoleOn(isParoleOn);
        }
    }
}

