/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.job.controllers;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.BatteryManagerInternal;
import com.android.server.LocalServices;
import com.android.server.job.JobSchedulerService;
import com.android.server.job.StateChangedListener;
import com.android.server.job.controllers.JobStatus;
import com.android.server.job.controllers.StateController;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BatteryController
extends StateController {
    private static final String TAG = "JobScheduler.Batt";
    private static final Object sCreationLock = new Object();
    private static volatile BatteryController sController;
    private List<JobStatus> mTrackedTasks = new ArrayList<JobStatus>();
    private ChargingTracker mChargeTracker = new ChargingTracker();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BatteryController get(JobSchedulerService taskManagerService) {
        Object object = sCreationLock;
        synchronized (object) {
            if (sController == null) {
                sController = new BatteryController(taskManagerService, taskManagerService.getContext());
            }
        }
        return sController;
    }

    public ChargingTracker getTracker() {
        return this.mChargeTracker;
    }

    public static BatteryController getForTesting(StateChangedListener stateChangedListener, Context context) {
        return new BatteryController(stateChangedListener, context);
    }

    private BatteryController(StateChangedListener stateChangedListener, Context context) {
        super(stateChangedListener, context);
        this.mChargeTracker.startTracking();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void maybeStartTrackingJob(JobStatus taskStatus) {
        boolean isOnStablePower = this.mChargeTracker.isOnStablePower();
        if (taskStatus.hasChargingConstraint()) {
            List<JobStatus> list = this.mTrackedTasks;
            synchronized (list) {
                this.mTrackedTasks.add(taskStatus);
                taskStatus.chargingConstraintSatisfied.set(isOnStablePower);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void maybeStopTrackingJob(JobStatus taskStatus) {
        if (taskStatus.hasChargingConstraint()) {
            List<JobStatus> list = this.mTrackedTasks;
            synchronized (list) {
                this.mTrackedTasks.remove(taskStatus);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeReportNewChargingState() {
        boolean stablePower = this.mChargeTracker.isOnStablePower();
        boolean reportChange = false;
        List<JobStatus> list = this.mTrackedTasks;
        synchronized (list) {
            for (JobStatus ts : this.mTrackedTasks) {
                boolean previous = ts.chargingConstraintSatisfied.getAndSet(stablePower);
                if (previous == stablePower) continue;
                reportChange = true;
            }
        }
        if (reportChange) {
            this.mStateChangedListener.onControllerStateChanged();
        }
        if (stablePower) {
            this.mStateChangedListener.onRunJobNow(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dumpControllerState(PrintWriter pw) {
        pw.println("Batt.");
        pw.println("Stable power: " + this.mChargeTracker.isOnStablePower());
        List<JobStatus> list = this.mTrackedTasks;
        synchronized (list) {
            Iterator<JobStatus> it = this.mTrackedTasks.iterator();
            if (it.hasNext()) {
                pw.print(String.valueOf(it.next().hashCode()));
            }
            while (it.hasNext()) {
                pw.print("," + String.valueOf(it.next().hashCode()));
            }
            pw.println();
        }
    }

    public class ChargingTracker
    extends BroadcastReceiver {
        private boolean mCharging;
        private boolean mBatteryHealthy;

        public void startTracking() {
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.intent.action.BATTERY_LOW");
            filter.addAction("android.intent.action.BATTERY_OKAY");
            filter.addAction("android.os.action.CHARGING");
            filter.addAction("android.os.action.DISCHARGING");
            BatteryController.this.mContext.registerReceiver(this, filter);
            BatteryManagerInternal batteryManagerInternal = LocalServices.getService(BatteryManagerInternal.class);
            this.mBatteryHealthy = !batteryManagerInternal.getBatteryLevelLow();
            this.mCharging = batteryManagerInternal.isPowered(7);
        }

        boolean isOnStablePower() {
            return this.mCharging && this.mBatteryHealthy;
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            this.onReceiveInternal(intent);
        }

        public void onReceiveInternal(Intent intent) {
            String action = intent.getAction();
            if ("android.intent.action.BATTERY_LOW".equals(action)) {
                this.mBatteryHealthy = false;
            } else if ("android.intent.action.BATTERY_OKAY".equals(action)) {
                this.mBatteryHealthy = true;
                BatteryController.this.maybeReportNewChargingState();
            } else if ("android.os.action.CHARGING".equals(action)) {
                this.mCharging = true;
                BatteryController.this.maybeReportNewChargingState();
            } else if ("android.os.action.DISCHARGING".equals(action)) {
                this.mCharging = false;
                BatteryController.this.maybeReportNewChargingState();
            }
        }
    }
}

