/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.job.controllers;

import android.app.job.JobInfo;
import android.content.ComponentName;
import android.os.PersistableBundle;
import android.os.SystemClock;
import android.os.UserHandle;
import android.text.format.DateUtils;
import java.io.PrintWriter;
import java.util.concurrent.atomic.AtomicBoolean;

public class JobStatus {
    public static final long NO_LATEST_RUNTIME = Long.MAX_VALUE;
    public static final long NO_EARLIEST_RUNTIME = 0L;
    final JobInfo job;
    final int uId;
    final String name;
    final String tag;
    final AtomicBoolean chargingConstraintSatisfied = new AtomicBoolean();
    final AtomicBoolean timeDelayConstraintSatisfied = new AtomicBoolean();
    final AtomicBoolean deadlineConstraintSatisfied = new AtomicBoolean();
    final AtomicBoolean idleConstraintSatisfied = new AtomicBoolean();
    final AtomicBoolean unmeteredConstraintSatisfied = new AtomicBoolean();
    final AtomicBoolean connectivityConstraintSatisfied = new AtomicBoolean();
    final AtomicBoolean appNotIdleConstraintSatisfied = new AtomicBoolean();
    private long earliestRunTimeElapsedMillis;
    private long latestRunTimeElapsedMillis;
    private final int numFailures;

    public int getServiceToken() {
        return this.uId;
    }

    private JobStatus(JobInfo job, int uId, int numFailures) {
        this.job = job;
        this.uId = uId;
        this.name = job.getService().flattenToShortString();
        this.tag = "*job*/" + this.name;
        this.numFailures = numFailures;
    }

    public JobStatus(JobInfo job, int uId) {
        this(job, uId, 0);
        long elapsedNow = SystemClock.elapsedRealtime();
        if (job.isPeriodic()) {
            this.earliestRunTimeElapsedMillis = elapsedNow;
            this.latestRunTimeElapsedMillis = elapsedNow + job.getIntervalMillis();
        } else {
            this.earliestRunTimeElapsedMillis = job.hasEarlyConstraint() ? elapsedNow + job.getMinLatencyMillis() : 0L;
            this.latestRunTimeElapsedMillis = job.hasLateConstraint() ? elapsedNow + job.getMaxExecutionDelayMillis() : Long.MAX_VALUE;
        }
    }

    public JobStatus(JobInfo job, int uId, long earliestRunTimeElapsedMillis, long latestRunTimeElapsedMillis) {
        this(job, uId, 0);
        this.earliestRunTimeElapsedMillis = earliestRunTimeElapsedMillis;
        this.latestRunTimeElapsedMillis = latestRunTimeElapsedMillis;
    }

    public JobStatus(JobStatus rescheduling, long newEarliestRuntimeElapsedMillis, long newLatestRuntimeElapsedMillis, int backoffAttempt) {
        this(rescheduling.job, rescheduling.getUid(), backoffAttempt);
        this.earliestRunTimeElapsedMillis = newEarliestRuntimeElapsedMillis;
        this.latestRunTimeElapsedMillis = newLatestRuntimeElapsedMillis;
    }

    public JobInfo getJob() {
        return this.job;
    }

    public int getJobId() {
        return this.job.getId();
    }

    public int getNumFailures() {
        return this.numFailures;
    }

    public ComponentName getServiceComponent() {
        return this.job.getService();
    }

    public int getUserId() {
        return UserHandle.getUserId(this.uId);
    }

    public int getUid() {
        return this.uId;
    }

    public String getName() {
        return this.name;
    }

    public String getTag() {
        return this.tag;
    }

    public PersistableBundle getExtras() {
        return this.job.getExtras();
    }

    public boolean hasConnectivityConstraint() {
        return this.job.getNetworkType() == 1;
    }

    public boolean hasUnmeteredConstraint() {
        return this.job.getNetworkType() == 2;
    }

    public boolean hasChargingConstraint() {
        return this.job.isRequireCharging();
    }

    public boolean hasTimingDelayConstraint() {
        return this.earliestRunTimeElapsedMillis != 0L;
    }

    public boolean hasDeadlineConstraint() {
        return this.latestRunTimeElapsedMillis != Long.MAX_VALUE;
    }

    public boolean hasIdleConstraint() {
        return this.job.isRequireDeviceIdle();
    }

    public boolean isPersisted() {
        return this.job.isPersisted();
    }

    public long getEarliestRunTime() {
        return this.earliestRunTimeElapsedMillis;
    }

    public long getLatestRunTimeElapsed() {
        return this.latestRunTimeElapsedMillis;
    }

    public synchronized boolean isReady() {
        return (this.isConstraintsSatisfied() || this.hasDeadlineConstraint() && this.deadlineConstraintSatisfied.get()) && this.appNotIdleConstraintSatisfied.get();
    }

    public synchronized boolean isConstraintsSatisfied() {
        return !(this.hasChargingConstraint() && !this.chargingConstraintSatisfied.get() || this.hasTimingDelayConstraint() && !this.timeDelayConstraintSatisfied.get() || this.hasConnectivityConstraint() && !this.connectivityConstraintSatisfied.get() || this.hasUnmeteredConstraint() && !this.unmeteredConstraintSatisfied.get() || this.hasIdleConstraint() && !this.idleConstraintSatisfied.get());
    }

    public boolean matches(int uid, int jobId) {
        return this.job.getId() == jobId && this.uId == uid;
    }

    public String toString() {
        return String.valueOf(this.hashCode()).substring(0, 3) + ".." + ":[" + this.job.getService() + ",jId=" + this.job.getId() + ",u" + this.getUserId() + ",R=(" + this.formatRunTime(this.earliestRunTimeElapsedMillis, 0L) + "," + this.formatRunTime(this.latestRunTimeElapsedMillis, Long.MAX_VALUE) + ")" + ",N=" + this.job.getNetworkType() + ",C=" + this.job.isRequireCharging() + ",I=" + this.job.isRequireDeviceIdle() + ",F=" + this.numFailures + ",P=" + this.job.isPersisted() + ",ANI=" + this.appNotIdleConstraintSatisfied.get() + (this.isReady() ? "(READY)" : "") + "]";
    }

    private String formatRunTime(long runtime, long defaultValue) {
        if (runtime == defaultValue) {
            return "none";
        }
        long elapsedNow = SystemClock.elapsedRealtime();
        long nextRuntime = runtime - elapsedNow;
        if (nextRuntime > 0L) {
            return DateUtils.formatElapsedTime(nextRuntime / 1000L);
        }
        return "-" + DateUtils.formatElapsedTime(nextRuntime / -1000L);
    }

    public String toShortString() {
        return this.job.getService().flattenToShortString() + " jId=" + this.job.getId() + ", u" + this.getUserId();
    }

    public void dump(PrintWriter pw, String prefix) {
        pw.print(prefix);
        pw.println(this.toString());
    }
}

