/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.job.controllers;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.SystemClock;
import com.android.server.job.JobSchedulerService;
import com.android.server.job.StateChangedListener;
import com.android.server.job.controllers.JobStatus;
import com.android.server.job.controllers.StateController;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class TimeController
extends StateController {
    private static final String TAG = "JobScheduler.Time";
    private static final String ACTION_JOB_EXPIRED = "android.content.jobscheduler.JOB_DEADLINE_EXPIRED";
    private static final String ACTION_JOB_DELAY_EXPIRED = "android.content.jobscheduler.JOB_DELAY_EXPIRED";
    private final PendingIntent mDeadlineExpiredAlarmIntent;
    private final PendingIntent mNextDelayExpiredAlarmIntent;
    private long mNextJobExpiredElapsedMillis;
    private long mNextDelayExpiredElapsedMillis;
    private AlarmManager mAlarmService = null;
    private final List<JobStatus> mTrackedJobs = new LinkedList<JobStatus>();
    private static TimeController mSingleton;
    private final BroadcastReceiver mAlarmExpiredReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if (TimeController.ACTION_JOB_EXPIRED.equals(intent.getAction())) {
                TimeController.this.checkExpiredDeadlinesAndResetAlarm();
            } else if (TimeController.ACTION_JOB_DELAY_EXPIRED.equals(intent.getAction())) {
                TimeController.this.checkExpiredDelaysAndResetAlarm();
            }
        }
    };

    public static synchronized TimeController get(JobSchedulerService jms) {
        if (mSingleton == null) {
            mSingleton = new TimeController(jms, jms.getContext());
        }
        return mSingleton;
    }

    private TimeController(StateChangedListener stateChangedListener, Context context) {
        super(stateChangedListener, context);
        this.mDeadlineExpiredAlarmIntent = PendingIntent.getBroadcast(this.mContext, 0, new Intent(ACTION_JOB_EXPIRED), 0);
        this.mNextDelayExpiredAlarmIntent = PendingIntent.getBroadcast(this.mContext, 0, new Intent(ACTION_JOB_DELAY_EXPIRED), 0);
        this.mNextJobExpiredElapsedMillis = Long.MAX_VALUE;
        this.mNextDelayExpiredElapsedMillis = Long.MAX_VALUE;
        IntentFilter intentFilter = new IntentFilter(ACTION_JOB_EXPIRED);
        intentFilter.addAction(ACTION_JOB_DELAY_EXPIRED);
        this.mContext.registerReceiver(this.mAlarmExpiredReceiver, intentFilter);
    }

    @Override
    public synchronized void maybeStartTrackingJob(JobStatus job) {
        if (job.hasTimingDelayConstraint() || job.hasDeadlineConstraint()) {
            this.maybeStopTrackingJob(job);
            boolean isInsert = false;
            ListIterator<JobStatus> it = this.mTrackedJobs.listIterator(this.mTrackedJobs.size());
            while (it.hasPrevious()) {
                JobStatus ts = it.previous();
                if (ts.getLatestRunTimeElapsed() >= job.getLatestRunTimeElapsed()) continue;
                isInsert = true;
                break;
            }
            if (isInsert) {
                it.next();
            }
            it.add(job);
            this.maybeUpdateAlarms(job.hasTimingDelayConstraint() ? job.getEarliestRunTime() : Long.MAX_VALUE, job.hasDeadlineConstraint() ? job.getLatestRunTimeElapsed() : Long.MAX_VALUE);
        }
    }

    @Override
    public synchronized void maybeStopTrackingJob(JobStatus job) {
        if (this.mTrackedJobs.remove(job)) {
            this.checkExpiredDelaysAndResetAlarm();
            this.checkExpiredDeadlinesAndResetAlarm();
        }
    }

    private boolean canStopTrackingJob(JobStatus job) {
        return !(job.hasTimingDelayConstraint() && !job.timeDelayConstraintSatisfied.get() || job.hasDeadlineConstraint() && !job.deadlineConstraintSatisfied.get());
    }

    private void ensureAlarmService() {
        if (this.mAlarmService == null) {
            this.mAlarmService = (AlarmManager)this.mContext.getSystemService("alarm");
        }
    }

    private synchronized void checkExpiredDeadlinesAndResetAlarm() {
        long nextExpiryTime = Long.MAX_VALUE;
        long nowElapsedMillis = SystemClock.elapsedRealtime();
        Iterator<JobStatus> it = this.mTrackedJobs.iterator();
        while (it.hasNext()) {
            JobStatus job = it.next();
            if (!job.hasDeadlineConstraint()) continue;
            long jobDeadline = job.getLatestRunTimeElapsed();
            if (jobDeadline <= nowElapsedMillis) {
                job.deadlineConstraintSatisfied.set(true);
                this.mStateChangedListener.onRunJobNow(job);
                it.remove();
                continue;
            }
            nextExpiryTime = jobDeadline;
            break;
        }
        this.setDeadlineExpiredAlarm(nextExpiryTime);
    }

    private synchronized void checkExpiredDelaysAndResetAlarm() {
        long nowElapsedMillis = SystemClock.elapsedRealtime();
        long nextDelayTime = Long.MAX_VALUE;
        boolean ready = false;
        Iterator<JobStatus> it = this.mTrackedJobs.iterator();
        while (it.hasNext()) {
            JobStatus job = it.next();
            if (!job.hasTimingDelayConstraint()) continue;
            long jobDelayTime = job.getEarliestRunTime();
            if (jobDelayTime <= nowElapsedMillis) {
                job.timeDelayConstraintSatisfied.set(true);
                if (this.canStopTrackingJob(job)) {
                    it.remove();
                }
                if (!job.isReady()) continue;
                ready = true;
                continue;
            }
            if (nextDelayTime <= jobDelayTime) continue;
            nextDelayTime = jobDelayTime;
        }
        if (ready) {
            this.mStateChangedListener.onControllerStateChanged();
        }
        this.setDelayExpiredAlarm(nextDelayTime);
    }

    private void maybeUpdateAlarms(long delayExpiredElapsed, long deadlineExpiredElapsed) {
        if (delayExpiredElapsed < this.mNextDelayExpiredElapsedMillis) {
            this.setDelayExpiredAlarm(delayExpiredElapsed);
        }
        if (deadlineExpiredElapsed < this.mNextJobExpiredElapsedMillis) {
            this.setDeadlineExpiredAlarm(deadlineExpiredElapsed);
        }
    }

    private void setDelayExpiredAlarm(long alarmTimeElapsedMillis) {
        this.mNextDelayExpiredElapsedMillis = alarmTimeElapsedMillis = this.maybeAdjustAlarmTime(alarmTimeElapsedMillis);
        this.updateAlarmWithPendingIntent(this.mNextDelayExpiredAlarmIntent, this.mNextDelayExpiredElapsedMillis);
    }

    private void setDeadlineExpiredAlarm(long alarmTimeElapsedMillis) {
        this.mNextJobExpiredElapsedMillis = alarmTimeElapsedMillis = this.maybeAdjustAlarmTime(alarmTimeElapsedMillis);
        this.updateAlarmWithPendingIntent(this.mDeadlineExpiredAlarmIntent, this.mNextJobExpiredElapsedMillis);
    }

    private long maybeAdjustAlarmTime(long proposedAlarmTimeElapsedMillis) {
        long earliestWakeupTimeElapsed = SystemClock.elapsedRealtime();
        if (proposedAlarmTimeElapsedMillis < earliestWakeupTimeElapsed) {
            return earliestWakeupTimeElapsed;
        }
        return proposedAlarmTimeElapsedMillis;
    }

    private void updateAlarmWithPendingIntent(PendingIntent pi, long alarmTimeElapsed) {
        this.ensureAlarmService();
        if (alarmTimeElapsed == Long.MAX_VALUE) {
            this.mAlarmService.cancel(pi);
        } else {
            this.mAlarmService.set(3, alarmTimeElapsed, pi);
        }
    }

    @Override
    public void dumpControllerState(PrintWriter pw) {
        long nowElapsed = SystemClock.elapsedRealtime();
        pw.println("Alarms (" + SystemClock.elapsedRealtime() + ")");
        pw.println("Next delay alarm in " + (this.mNextDelayExpiredElapsedMillis - nowElapsed) / 1000L + "s");
        pw.println("Next deadline alarm in " + (this.mNextJobExpiredElapsedMillis - nowElapsed) / 1000L + "s");
        pw.println("Tracking:");
        for (JobStatus ts : this.mTrackedJobs) {
            pw.println(String.valueOf(ts.hashCode()).substring(0, 3) + ".." + ": (" + (ts.hasTimingDelayConstraint() ? Long.valueOf(ts.getEarliestRunTime()) : "N/A") + ", " + (ts.hasDeadlineConstraint() ? Long.valueOf(ts.getLatestRunTimeElapsed()) : "N/A") + ")");
        }
    }
}

