/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.location;

import android.location.GpsNavigationMessageEvent;
import android.location.IGpsNavigationMessageListener;
import android.os.Handler;
import android.os.RemoteException;
import android.util.Log;
import com.android.server.location.RemoteListenerHelper;

public abstract class GpsNavigationMessageProvider
extends RemoteListenerHelper<IGpsNavigationMessageListener> {
    private static final String TAG = "GpsNavigationMessageProvider";

    protected GpsNavigationMessageProvider(Handler handler) {
        super(handler, TAG);
    }

    public void onNavigationMessageAvailable(final GpsNavigationMessageEvent event) {
        RemoteListenerHelper.ListenerOperation<IGpsNavigationMessageListener> operation = new RemoteListenerHelper.ListenerOperation<IGpsNavigationMessageListener>(){

            @Override
            public void execute(IGpsNavigationMessageListener listener) throws RemoteException {
                listener.onGpsNavigationMessageReceived(event);
            }
        };
        this.foreach(operation);
    }

    public void onCapabilitiesUpdated(boolean isGpsNavigationMessageSupported) {
        this.setSupported(isGpsNavigationMessageSupported);
        this.updateResult();
    }

    public void onGpsEnabledChanged() {
        if (this.tryUpdateRegistrationWithService()) {
            this.updateResult();
        }
    }

    @Override
    protected RemoteListenerHelper.ListenerOperation<IGpsNavigationMessageListener> getHandlerOperation(int result) {
        int status;
        switch (result) {
            case 0: {
                status = GpsNavigationMessageEvent.STATUS_READY;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                status = GpsNavigationMessageEvent.STATUS_NOT_SUPPORTED;
                break;
            }
            case 3: {
                status = GpsNavigationMessageEvent.STATUS_GPS_LOCATION_DISABLED;
                break;
            }
            case 5: {
                return null;
            }
            default: {
                Log.v(TAG, "Unhandled addListener result: " + result);
                return null;
            }
        }
        return new StatusChangedOperation(status);
    }

    private static class StatusChangedOperation
    implements RemoteListenerHelper.ListenerOperation<IGpsNavigationMessageListener> {
        private final int mStatus;

        public StatusChangedOperation(int status) {
            this.mStatus = status;
        }

        @Override
        public void execute(IGpsNavigationMessageListener listener) throws RemoteException {
            listener.onStatusChanged(this.mStatus);
        }
    }
}

