/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.location;

import android.location.IGpsStatusListener;
import android.os.Handler;
import android.os.RemoteException;
import com.android.server.location.GpsLocationProvider;
import com.android.server.location.RemoteListenerHelper;

abstract class GpsStatusListenerHelper
extends RemoteListenerHelper<IGpsStatusListener> {
    protected GpsStatusListenerHelper(Handler handler) {
        super(handler, "GpsStatusListenerHelper");
        this.setSupported(GpsLocationProvider.isSupported());
    }

    @Override
    protected boolean registerWithService() {
        return true;
    }

    @Override
    protected void unregisterFromService() {
    }

    @Override
    protected RemoteListenerHelper.ListenerOperation<IGpsStatusListener> getHandlerOperation(int result) {
        return null;
    }

    public void onStatusChanged(boolean isNavigating) {
        Operation operation = isNavigating ? new Operation(){

            @Override
            public void execute(IGpsStatusListener listener) throws RemoteException {
                listener.onGpsStarted();
            }
        } : new Operation(){

            @Override
            public void execute(IGpsStatusListener listener) throws RemoteException {
                listener.onGpsStopped();
            }
        };
        this.foreach(operation);
    }

    public void onFirstFix(final int timeToFirstFix) {
        Operation operation = new Operation(){

            @Override
            public void execute(IGpsStatusListener listener) throws RemoteException {
                listener.onFirstFix(timeToFirstFix);
            }
        };
        this.foreach(operation);
    }

    public void onSvStatusChanged(final int svCount, final int[] prns, final float[] snrs, final float[] elevations, final float[] azimuths, final int ephemerisMask, final int almanacMask, final int usedInFixMask) {
        Operation operation = new Operation(){

            @Override
            public void execute(IGpsStatusListener listener) throws RemoteException {
                listener.onSvStatusChanged(svCount, prns, snrs, elevations, azimuths, ephemerisMask, almanacMask, usedInFixMask);
            }
        };
        this.foreach(operation);
    }

    public void onNmeaReceived(final long timestamp, final String nmea) {
        Operation operation = new Operation(){

            @Override
            public void execute(IGpsStatusListener listener) throws RemoteException {
                listener.onNmeaReceived(timestamp, nmea);
            }
        };
        this.foreach(operation);
    }

    private static interface Operation
    extends RemoteListenerHelper.ListenerOperation<IGpsStatusListener> {
    }
}

