/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.location;

import android.text.TextUtils;
import android.util.Log;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Properties;
import java.util.Random;
import libcore.io.Streams;

public class GpsXtraDownloader {
    private static final String TAG = "GpsXtraDownloader";
    private static final boolean DEBUG = Log.isLoggable("GpsXtraDownloader", 3);
    private static final String DEFAULT_USER_AGENT = "Android";
    private final String[] mXtraServers;
    private int mNextServerIndex;
    private final String mUserAgent;

    GpsXtraDownloader(Properties properties) {
        String agent;
        int count = 0;
        String server1 = properties.getProperty("XTRA_SERVER_1");
        String server2 = properties.getProperty("XTRA_SERVER_2");
        String server3 = properties.getProperty("XTRA_SERVER_3");
        if (server1 != null) {
            ++count;
        }
        if (server2 != null) {
            ++count;
        }
        if (server3 != null) {
            ++count;
        }
        this.mUserAgent = TextUtils.isEmpty(agent = properties.getProperty("XTRA_USER_AGENT")) ? DEFAULT_USER_AGENT : agent;
        if (count == 0) {
            Log.e(TAG, "No XTRA servers were specified in the GPS configuration");
            this.mXtraServers = null;
        } else {
            this.mXtraServers = new String[count];
            count = 0;
            if (server1 != null) {
                this.mXtraServers[count++] = server1;
            }
            if (server2 != null) {
                this.mXtraServers[count++] = server2;
            }
            if (server3 != null) {
                this.mXtraServers[count++] = server3;
            }
            Random random = new Random();
            this.mNextServerIndex = random.nextInt(count);
        }
    }

    byte[] downloadXtraData() {
        byte[] result = null;
        int startIndex = this.mNextServerIndex;
        if (this.mXtraServers == null) {
            return null;
        }
        while (result == null) {
            result = this.doDownload(this.mXtraServers[this.mNextServerIndex]);
            ++this.mNextServerIndex;
            if (this.mNextServerIndex == this.mXtraServers.length) {
                this.mNextServerIndex = 0;
            }
            if (this.mNextServerIndex != startIndex) continue;
            break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] doDownload(String url) {
        if (DEBUG) {
            Log.d(TAG, "Downloading XTRA data from " + url);
        }
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setRequestProperty("Accept", "*/*, application/vnd.wap.mms-message, application/vnd.wap.sic");
            connection.setRequestProperty("x-wap-profile", "http://www.openmobilealliance.org/tech/profiles/UAPROF/ccppschema-20021212#");
            connection.connect();
            int statusCode = connection.getResponseCode();
            if (statusCode != 200) {
                if (DEBUG) {
                    Log.d(TAG, "HTTP error downloading gps XTRA: " + statusCode);
                }
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = Streams.readFully(connection.getInputStream());
            return byArray;
        }
        catch (IOException ioe) {
            if (DEBUG) {
                Log.d(TAG, "Error downloading gps XTRA: ", ioe);
            }
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return null;
    }
}

