/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.net;

import android.app.AppGlobals;
import android.app.AppOpsManager;
import android.app.IActivityManager;
import android.app.INotificationManager;
import android.app.IUidObserver;
import android.app.Notification;
import android.app.PendingIntent;
import android.app.usage.UsageStatsManagerInternal;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.content.pm.PackageManager;
import android.content.pm.UserInfo;
import android.content.res.Resources;
import android.net.ConnectivityManager;
import android.net.IConnectivityManager;
import android.net.INetworkManagementEventObserver;
import android.net.INetworkPolicyListener;
import android.net.INetworkPolicyManager;
import android.net.INetworkStatsService;
import android.net.LinkProperties;
import android.net.NetworkIdentity;
import android.net.NetworkInfo;
import android.net.NetworkPolicy;
import android.net.NetworkPolicyManager;
import android.net.NetworkQuotaInfo;
import android.net.NetworkState;
import android.net.NetworkTemplate;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.os.Binder;
import android.os.Environment;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IDeviceIdleController;
import android.os.INetworkManagementService;
import android.os.IPowerManager;
import android.os.Message;
import android.os.MessageQueue;
import android.os.PowerManagerInternal;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.Settings;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.text.format.Formatter;
import android.text.format.Time;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.AtomicFile;
import android.util.Log;
import android.util.NtpTrustedTime;
import android.util.Pair;
import android.util.Slog;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import android.util.TrustedTime;
import android.util.Xml;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.IndentingPrintWriter;
import com.android.internal.util.Preconditions;
import com.android.internal.util.XmlUtils;
import com.android.server.DeviceIdleController;
import com.android.server.EventLogTags;
import com.android.server.LocalServices;
import com.android.server.net.BaseNetworkObserver;
import com.google.android.collect.Lists;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import libcore.io.IoUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class NetworkPolicyManagerService
extends INetworkPolicyManager.Stub {
    private static final String TAG = "NetworkPolicy";
    private static final boolean LOGD = false;
    private static final boolean LOGV = false;
    private static final int VERSION_INIT = 1;
    private static final int VERSION_ADDED_SNOOZE = 2;
    private static final int VERSION_ADDED_RESTRICT_BACKGROUND = 3;
    private static final int VERSION_ADDED_METERED = 4;
    private static final int VERSION_SPLIT_SNOOZE = 5;
    private static final int VERSION_ADDED_TIMEZONE = 6;
    private static final int VERSION_ADDED_INFERRED = 7;
    private static final int VERSION_SWITCH_APP_ID = 8;
    private static final int VERSION_ADDED_NETWORK_ID = 9;
    private static final int VERSION_SWITCH_UID = 10;
    private static final int VERSION_LATEST = 10;
    public static final int TYPE_WARNING = 1;
    public static final int TYPE_LIMIT = 2;
    public static final int TYPE_LIMIT_SNOOZED = 3;
    private static final String TAG_POLICY_LIST = "policy-list";
    private static final String TAG_NETWORK_POLICY = "network-policy";
    private static final String TAG_UID_POLICY = "uid-policy";
    private static final String TAG_APP_POLICY = "app-policy";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_RESTRICT_BACKGROUND = "restrictBackground";
    private static final String ATTR_NETWORK_TEMPLATE = "networkTemplate";
    private static final String ATTR_SUBSCRIBER_ID = "subscriberId";
    private static final String ATTR_NETWORK_ID = "networkId";
    private static final String ATTR_CYCLE_DAY = "cycleDay";
    private static final String ATTR_CYCLE_TIMEZONE = "cycleTimezone";
    private static final String ATTR_WARNING_BYTES = "warningBytes";
    private static final String ATTR_LIMIT_BYTES = "limitBytes";
    private static final String ATTR_LAST_SNOOZE = "lastSnooze";
    private static final String ATTR_LAST_WARNING_SNOOZE = "lastWarningSnooze";
    private static final String ATTR_LAST_LIMIT_SNOOZE = "lastLimitSnooze";
    private static final String ATTR_METERED = "metered";
    private static final String ATTR_INFERRED = "inferred";
    private static final String ATTR_UID = "uid";
    private static final String ATTR_APP_ID = "appId";
    private static final String ATTR_POLICY = "policy";
    private static final String TAG_ALLOW_BACKGROUND = "NetworkPolicy:allowBackground";
    private static final String ACTION_ALLOW_BACKGROUND = "com.android.server.net.action.ALLOW_BACKGROUND";
    private static final String ACTION_SNOOZE_WARNING = "com.android.server.net.action.SNOOZE_WARNING";
    private static final long TIME_CACHE_MAX_AGE = 86400000L;
    private static final int MSG_RULES_CHANGED = 1;
    private static final int MSG_METERED_IFACES_CHANGED = 2;
    private static final int MSG_LIMIT_REACHED = 5;
    private static final int MSG_RESTRICT_BACKGROUND_CHANGED = 6;
    private static final int MSG_ADVISE_PERSIST_THRESHOLD = 7;
    private static final int MSG_SCREEN_ON_CHANGED = 8;
    private final Context mContext;
    private final IActivityManager mActivityManager;
    private final IPowerManager mPowerManager;
    private final INetworkStatsService mNetworkStats;
    private final INetworkManagementService mNetworkManager;
    private UsageStatsManagerInternal mUsageStats;
    private final TrustedTime mTime;
    private final UserManager mUserManager;
    private IConnectivityManager mConnManager;
    private INotificationManager mNotifManager;
    private PowerManagerInternal mPowerManagerInternal;
    private IDeviceIdleController mDeviceIdleController;
    final Object mRulesLock = new Object();
    volatile boolean mSystemReady;
    volatile boolean mScreenOn;
    volatile boolean mRestrictBackground;
    volatile boolean mRestrictPower;
    volatile boolean mDeviceIdleMode;
    private final boolean mSuppressDefaultPolicy;
    final ArrayMap<NetworkTemplate, NetworkPolicy> mNetworkPolicy = new ArrayMap();
    final ArrayMap<NetworkPolicy, String[]> mNetworkRules = new ArrayMap();
    final SparseIntArray mUidPolicy = new SparseIntArray();
    final SparseIntArray mUidRules = new SparseIntArray();
    final SparseBooleanArray mFirewallChainStates = new SparseBooleanArray();
    private final SparseBooleanArray mPowerSaveWhitelistExceptIdleAppIds = new SparseBooleanArray();
    private final SparseBooleanArray mPowerSaveWhitelistAppIds = new SparseBooleanArray();
    private final SparseBooleanArray mPowerSaveTempWhitelistAppIds = new SparseBooleanArray();
    private ArraySet<String> mMeteredIfaces = new ArraySet();
    private final ArraySet<NetworkTemplate> mOverLimitNotified = new ArraySet();
    private final ArraySet<String> mActiveNotifs = new ArraySet();
    final SparseIntArray mUidState = new SparseIntArray();
    private final RemoteCallbackList<INetworkPolicyListener> mListeners = new RemoteCallbackList();
    final Handler mHandler;
    private final AtomicFile mPolicyFile;
    private final AppOpsManager mAppOps;
    private final IUidObserver mUidObserver = new IUidObserver.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onUidStateChanged(int uid, int procState) throws RemoteException {
            Object object = NetworkPolicyManagerService.this.mRulesLock;
            synchronized (object) {
                NetworkPolicyManagerService.this.updateUidStateLocked(uid, procState);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onUidGone(int uid) throws RemoteException {
            Object object = NetworkPolicyManagerService.this.mRulesLock;
            synchronized (object) {
                NetworkPolicyManagerService.this.removeUidStateLocked(uid);
            }
        }
    };
    private final BroadcastReceiver mPowerSaveWhitelistReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            Object object = NetworkPolicyManagerService.this.mRulesLock;
            synchronized (object) {
                NetworkPolicyManagerService.this.updatePowerSaveWhitelistLocked();
                NetworkPolicyManagerService.this.updateRulesForGlobalChangeLocked(false);
            }
        }
    };
    private final Runnable mTempPowerSaveChangedCallback = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = NetworkPolicyManagerService.this.mRulesLock;
            synchronized (object) {
                NetworkPolicyManagerService.this.updatePowerSaveTempWhitelistLocked();
                NetworkPolicyManagerService.this.updateRulesForTempWhitelistChangeLocked();
                NetworkPolicyManagerService.this.purgePowerSaveTempWhitelistLocked();
            }
        }
    };
    private final BroadcastReceiver mScreenReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            NetworkPolicyManagerService.this.mHandler.obtainMessage(8).sendToTarget();
        }
    };
    private final BroadcastReceiver mPackageReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            int uid = intent.getIntExtra("android.intent.extra.UID", -1);
            if (uid == -1) {
                return;
            }
            if ("android.intent.action.PACKAGE_ADDED".equals(action)) {
                Object object = NetworkPolicyManagerService.this.mRulesLock;
                synchronized (object) {
                    NetworkPolicyManagerService.this.updateRulesForUidLocked(uid);
                }
            }
        }
    };
    private final BroadcastReceiver mUidRemovedReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            int uid = intent.getIntExtra("android.intent.extra.UID", -1);
            if (uid == -1) {
                return;
            }
            Object object = NetworkPolicyManagerService.this.mRulesLock;
            synchronized (object) {
                NetworkPolicyManagerService.this.mUidPolicy.delete(uid);
                NetworkPolicyManagerService.this.updateRulesForUidLocked(uid);
                NetworkPolicyManagerService.this.writePolicyLocked();
            }
        }
    };
    private final BroadcastReceiver mUserReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            int userId = intent.getIntExtra("android.intent.extra.user_handle", -1);
            if (userId == -1) {
                return;
            }
            switch (action) {
                case "android.intent.action.USER_REMOVED": 
                case "android.intent.action.USER_ADDED": {
                    Object object = NetworkPolicyManagerService.this.mRulesLock;
                    synchronized (object) {
                        NetworkPolicyManagerService.this.removePoliciesForUserLocked(userId);
                        NetworkPolicyManagerService.this.updateRulesForGlobalChangeLocked(true);
                        break;
                    }
                }
            }
        }
    };
    private final BroadcastReceiver mStatsReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            NetworkPolicyManagerService.this.maybeRefreshTrustedTime();
            Object object = NetworkPolicyManagerService.this.mRulesLock;
            synchronized (object) {
                NetworkPolicyManagerService.this.updateNetworkEnabledLocked();
                NetworkPolicyManagerService.this.updateNotificationsLocked();
            }
        }
    };
    private final BroadcastReceiver mAllowReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            NetworkPolicyManagerService.this.setRestrictBackground(false);
        }
    };
    private final BroadcastReceiver mSnoozeWarningReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            NetworkTemplate template = (NetworkTemplate)intent.getParcelableExtra("android.net.NETWORK_TEMPLATE");
            NetworkPolicyManagerService.this.performSnooze(template, 1);
        }
    };
    private final BroadcastReceiver mWifiConfigReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            int reason = intent.getIntExtra("changeReason", 0);
            if (reason == 1) {
                WifiConfiguration config = (WifiConfiguration)intent.getParcelableExtra("wifiConfiguration");
                if (config.SSID != null) {
                    NetworkTemplate template = NetworkTemplate.buildTemplateWifi(config.SSID);
                    Object object = NetworkPolicyManagerService.this.mRulesLock;
                    synchronized (object) {
                        if (NetworkPolicyManagerService.this.mNetworkPolicy.containsKey(template)) {
                            NetworkPolicyManagerService.this.mNetworkPolicy.remove(template);
                            NetworkPolicyManagerService.this.writePolicyLocked();
                        }
                    }
                }
            }
        }
    };
    private final BroadcastReceiver mWifiStateReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            NetworkInfo netInfo = (NetworkInfo)intent.getParcelableExtra("networkInfo");
            if (!netInfo.isConnected()) {
                return;
            }
            WifiInfo info = (WifiInfo)intent.getParcelableExtra("wifiInfo");
            boolean meteredHint = info.getMeteredHint();
            NetworkTemplate template = NetworkTemplate.buildTemplateWifi(info.getSSID());
            Object object = NetworkPolicyManagerService.this.mRulesLock;
            synchronized (object) {
                NetworkPolicy policy = NetworkPolicyManagerService.this.mNetworkPolicy.get(template);
                if (policy == null && meteredHint) {
                    policy = new NetworkPolicy(template, -1, "UTC", -1L, -1L, -1L, -1L, meteredHint, true);
                    NetworkPolicyManagerService.this.addNetworkPolicyLocked(policy);
                } else if (policy != null && policy.inferred) {
                    policy.metered = meteredHint;
                    NetworkPolicyManagerService.this.updateNetworkRulesLocked();
                }
            }
        }
    };
    private final INetworkManagementEventObserver mAlertObserver = new BaseNetworkObserver(){

        @Override
        public void limitReached(String limitName, String iface) {
            NetworkPolicyManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", NetworkPolicyManagerService.TAG);
            if (!"globalAlert".equals(limitName)) {
                NetworkPolicyManagerService.this.mHandler.obtainMessage(5, iface).sendToTarget();
            }
        }
    };
    private BroadcastReceiver mConnReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            NetworkPolicyManagerService.this.maybeRefreshTrustedTime();
            Object object = NetworkPolicyManagerService.this.mRulesLock;
            synchronized (object) {
                NetworkPolicyManagerService.this.ensureActiveMobilePolicyLocked();
                NetworkPolicyManagerService.this.normalizePoliciesLocked();
                NetworkPolicyManagerService.this.updateNetworkEnabledLocked();
                NetworkPolicyManagerService.this.updateNetworkRulesLocked();
                NetworkPolicyManagerService.this.updateNotificationsLocked();
            }
        }
    };
    private Handler.Callback mHandlerCallback = new Handler.Callback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    int uid = msg.arg1;
                    int uidRules = msg.arg2;
                    int length = NetworkPolicyManagerService.this.mListeners.beginBroadcast();
                    for (int i = 0; i < length; ++i) {
                        INetworkPolicyListener listener = (INetworkPolicyListener)NetworkPolicyManagerService.this.mListeners.getBroadcastItem(i);
                        if (listener == null) continue;
                        try {
                            listener.onUidRulesChanged(uid, uidRules);
                            continue;
                        }
                        catch (RemoteException e) {
                            // empty catch block
                        }
                    }
                    NetworkPolicyManagerService.this.mListeners.finishBroadcast();
                    return true;
                }
                case 2: {
                    String[] meteredIfaces = (String[])msg.obj;
                    int length = NetworkPolicyManagerService.this.mListeners.beginBroadcast();
                    for (int i = 0; i < length; ++i) {
                        INetworkPolicyListener listener = (INetworkPolicyListener)NetworkPolicyManagerService.this.mListeners.getBroadcastItem(i);
                        if (listener == null) continue;
                        try {
                            listener.onMeteredIfacesChanged(meteredIfaces);
                            continue;
                        }
                        catch (RemoteException e) {
                            // empty catch block
                        }
                    }
                    NetworkPolicyManagerService.this.mListeners.finishBroadcast();
                    return true;
                }
                case 5: {
                    String iface = (String)msg.obj;
                    NetworkPolicyManagerService.this.maybeRefreshTrustedTime();
                    Object length = NetworkPolicyManagerService.this.mRulesLock;
                    synchronized (length) {
                        if (NetworkPolicyManagerService.this.mMeteredIfaces.contains(iface)) {
                            try {
                                NetworkPolicyManagerService.this.mNetworkStats.forceUpdate();
                            }
                            catch (RemoteException e) {
                                // empty catch block
                            }
                            NetworkPolicyManagerService.this.updateNetworkEnabledLocked();
                            NetworkPolicyManagerService.this.updateNotificationsLocked();
                        }
                    }
                    return true;
                }
                case 6: {
                    boolean restrictBackground = msg.arg1 != 0;
                    int length = NetworkPolicyManagerService.this.mListeners.beginBroadcast();
                    for (int i = 0; i < length; ++i) {
                        INetworkPolicyListener listener = (INetworkPolicyListener)NetworkPolicyManagerService.this.mListeners.getBroadcastItem(i);
                        if (listener == null) continue;
                        try {
                            listener.onRestrictBackgroundChanged(restrictBackground);
                            continue;
                        }
                        catch (RemoteException e) {
                            // empty catch block
                        }
                    }
                    NetworkPolicyManagerService.this.mListeners.finishBroadcast();
                    return true;
                }
                case 7: {
                    long lowestRule = (Long)msg.obj;
                    try {
                        long persistThreshold = lowestRule / 1000L;
                        NetworkPolicyManagerService.this.mNetworkStats.advisePersistThreshold(persistThreshold);
                    }
                    catch (RemoteException e) {
                        // empty catch block
                    }
                    return true;
                }
                case 8: {
                    NetworkPolicyManagerService.this.updateScreenOn();
                    return true;
                }
            }
            return false;
        }
    };

    public NetworkPolicyManagerService(Context context, IActivityManager activityManager, IPowerManager powerManager, INetworkStatsService networkStats, INetworkManagementService networkManagement) {
        this(context, activityManager, powerManager, networkStats, networkManagement, NtpTrustedTime.getInstance(context), NetworkPolicyManagerService.getSystemDir(), false);
    }

    private static File getSystemDir() {
        return new File(Environment.getDataDirectory(), "system");
    }

    public NetworkPolicyManagerService(Context context, IActivityManager activityManager, IPowerManager powerManager, INetworkStatsService networkStats, INetworkManagementService networkManagement, TrustedTime time, File systemDir, boolean suppressDefaultPolicy) {
        this.mContext = Preconditions.checkNotNull(context, "missing context");
        this.mActivityManager = Preconditions.checkNotNull(activityManager, "missing activityManager");
        this.mPowerManager = Preconditions.checkNotNull(powerManager, "missing powerManager");
        this.mNetworkStats = Preconditions.checkNotNull(networkStats, "missing networkStats");
        this.mNetworkManager = Preconditions.checkNotNull(networkManagement, "missing networkManagement");
        this.mDeviceIdleController = IDeviceIdleController.Stub.asInterface(ServiceManager.getService("deviceidle"));
        this.mTime = Preconditions.checkNotNull(time, "missing TrustedTime");
        this.mUserManager = (UserManager)this.mContext.getSystemService("user");
        HandlerThread thread = new HandlerThread(TAG);
        thread.start();
        this.mHandler = new Handler(thread.getLooper(), this.mHandlerCallback);
        this.mSuppressDefaultPolicy = suppressDefaultPolicy;
        this.mPolicyFile = new AtomicFile(new File(systemDir, "netpolicy.xml"));
        this.mAppOps = context.getSystemService(AppOpsManager.class);
    }

    public void bindConnectivityManager(IConnectivityManager connManager) {
        this.mConnManager = Preconditions.checkNotNull(connManager, "missing IConnectivityManager");
    }

    public void bindNotificationManager(INotificationManager notifManager) {
        this.mNotifManager = Preconditions.checkNotNull(notifManager, "missing INotificationManager");
    }

    void updatePowerSaveWhitelistLocked() {
        try {
            int[] whitelist = this.mDeviceIdleController.getAppIdWhitelistExceptIdle();
            this.mPowerSaveWhitelistExceptIdleAppIds.clear();
            if (whitelist != null) {
                for (int uid : whitelist) {
                    this.mPowerSaveWhitelistExceptIdleAppIds.put(uid, true);
                }
            }
            whitelist = this.mDeviceIdleController.getAppIdWhitelist();
            this.mPowerSaveWhitelistAppIds.clear();
            if (whitelist != null) {
                for (int uid : whitelist) {
                    this.mPowerSaveWhitelistAppIds.put(uid, true);
                }
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    void updatePowerSaveTempWhitelistLocked() {
        try {
            int N = this.mPowerSaveTempWhitelistAppIds.size();
            for (int i = 0; i < N; ++i) {
                this.mPowerSaveTempWhitelistAppIds.setValueAt(i, false);
            }
            int[] whitelist = this.mDeviceIdleController.getAppIdTempWhitelist();
            if (whitelist != null) {
                for (int uid : whitelist) {
                    this.mPowerSaveTempWhitelistAppIds.put(uid, true);
                }
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    void purgePowerSaveTempWhitelistLocked() {
        int N = this.mPowerSaveTempWhitelistAppIds.size();
        for (int i = N - 1; i >= 0; --i) {
            if (this.mPowerSaveTempWhitelistAppIds.valueAt(i)) continue;
            this.mPowerSaveTempWhitelistAppIds.removeAt(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void systemReady() {
        if (!this.isBandwidthControlEnabled()) {
            Slog.w(TAG, "bandwidth controls disabled, unable to enforce policy");
            return;
        }
        this.mUsageStats = LocalServices.getService(UsageStatsManagerInternal.class);
        Object object = this.mRulesLock;
        synchronized (object) {
            this.updatePowerSaveWhitelistLocked();
            this.mPowerManagerInternal = LocalServices.getService(PowerManagerInternal.class);
            this.mPowerManagerInternal.registerLowPowerModeObserver(new PowerManagerInternal.LowPowerModeListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onLowPowerModeChanged(boolean enabled) {
                    Object object = NetworkPolicyManagerService.this.mRulesLock;
                    synchronized (object) {
                        if (NetworkPolicyManagerService.this.mRestrictPower != enabled) {
                            NetworkPolicyManagerService.this.mRestrictPower = enabled;
                            NetworkPolicyManagerService.this.updateRulesForGlobalChangeLocked(true);
                        }
                    }
                }
            });
            this.mRestrictPower = this.mPowerManagerInternal.getLowPowerModeEnabled();
            this.mSystemReady = true;
            this.readPolicyLocked();
            if (this.mRestrictBackground || this.mRestrictPower || this.mDeviceIdleMode) {
                this.updateRulesForGlobalChangeLocked(false);
                this.updateNotificationsLocked();
            } else {
                this.updateRulesForAppIdleLocked();
            }
        }
        this.updateScreenOn();
        try {
            this.mActivityManager.registerUidObserver(this.mUidObserver);
            this.mNetworkManager.registerObserver(this.mAlertObserver);
        }
        catch (RemoteException e) {
            // empty catch block
        }
        IntentFilter screenFilter = new IntentFilter();
        screenFilter.addAction("android.intent.action.SCREEN_ON");
        screenFilter.addAction("android.intent.action.SCREEN_OFF");
        this.mContext.registerReceiver(this.mScreenReceiver, screenFilter);
        IntentFilter whitelistFilter = new IntentFilter("android.os.action.POWER_SAVE_WHITELIST_CHANGED");
        this.mContext.registerReceiver(this.mPowerSaveWhitelistReceiver, whitelistFilter, null, this.mHandler);
        DeviceIdleController.LocalService deviceIdleService = LocalServices.getService(DeviceIdleController.LocalService.class);
        deviceIdleService.setNetworkPolicyTempWhitelistCallback(this.mTempPowerSaveChangedCallback);
        IntentFilter connFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        this.mContext.registerReceiver(this.mConnReceiver, connFilter, "android.permission.CONNECTIVITY_INTERNAL", this.mHandler);
        IntentFilter packageFilter = new IntentFilter();
        packageFilter.addAction("android.intent.action.PACKAGE_ADDED");
        packageFilter.addDataScheme("package");
        this.mContext.registerReceiver(this.mPackageReceiver, packageFilter, null, this.mHandler);
        this.mContext.registerReceiver(this.mUidRemovedReceiver, new IntentFilter("android.intent.action.UID_REMOVED"), null, this.mHandler);
        IntentFilter userFilter = new IntentFilter();
        userFilter.addAction("android.intent.action.USER_ADDED");
        userFilter.addAction("android.intent.action.USER_REMOVED");
        this.mContext.registerReceiver(this.mUserReceiver, userFilter, null, this.mHandler);
        IntentFilter statsFilter = new IntentFilter("com.android.server.action.NETWORK_STATS_UPDATED");
        this.mContext.registerReceiver(this.mStatsReceiver, statsFilter, "android.permission.READ_NETWORK_USAGE_HISTORY", this.mHandler);
        IntentFilter allowFilter = new IntentFilter(ACTION_ALLOW_BACKGROUND);
        this.mContext.registerReceiver(this.mAllowReceiver, allowFilter, "android.permission.MANAGE_NETWORK_POLICY", this.mHandler);
        IntentFilter snoozeWarningFilter = new IntentFilter(ACTION_SNOOZE_WARNING);
        this.mContext.registerReceiver(this.mSnoozeWarningReceiver, snoozeWarningFilter, "android.permission.MANAGE_NETWORK_POLICY", this.mHandler);
        IntentFilter wifiConfigFilter = new IntentFilter("android.net.wifi.CONFIGURED_NETWORKS_CHANGE");
        this.mContext.registerReceiver(this.mWifiConfigReceiver, wifiConfigFilter, null, this.mHandler);
        IntentFilter wifiStateFilter = new IntentFilter("android.net.wifi.STATE_CHANGE");
        this.mContext.registerReceiver(this.mWifiStateReceiver, wifiStateFilter, null, this.mHandler);
        this.mUsageStats.addAppIdleStateChangeListener(new AppIdleStateChangeListener());
    }

    void updateNotificationsLocked() {
        int i;
        ArraySet<String> beforeNotifs = new ArraySet<String>(this.mActiveNotifs);
        this.mActiveNotifs.clear();
        long currentTime = this.currentTimeMillis();
        for (i = this.mNetworkPolicy.size() - 1; i >= 0; --i) {
            long end;
            NetworkPolicy policy = this.mNetworkPolicy.valueAt(i);
            if (!this.isTemplateRelevant(policy.template) || !policy.hasCycle()) continue;
            long start = NetworkPolicyManager.computeLastCycleBoundary(currentTime, policy);
            long totalBytes = this.getTotalBytes(policy.template, start, end = currentTime);
            if (policy.isOverLimit(totalBytes)) {
                if (policy.lastLimitSnooze >= start) {
                    this.enqueueNotification(policy, 3, totalBytes);
                    continue;
                }
                this.enqueueNotification(policy, 2, totalBytes);
                this.notifyOverLimitLocked(policy.template);
                continue;
            }
            this.notifyUnderLimitLocked(policy.template);
            if (!policy.isOverWarning(totalBytes) || policy.lastWarningSnooze >= start) continue;
            this.enqueueNotification(policy, 1, totalBytes);
        }
        if (this.mRestrictBackground) {
            this.enqueueRestrictedNotification(TAG_ALLOW_BACKGROUND);
        }
        for (i = beforeNotifs.size() - 1; i >= 0; --i) {
            String tag = beforeNotifs.valueAt(i);
            if (this.mActiveNotifs.contains(tag)) continue;
            this.cancelNotification(tag);
        }
    }

    private boolean isTemplateRelevant(NetworkTemplate template) {
        if (template.isMatchRuleMobile()) {
            int[] subIds;
            TelephonyManager tele = TelephonyManager.from(this.mContext);
            SubscriptionManager sub = SubscriptionManager.from(this.mContext);
            for (int subId : subIds = sub.getActiveSubscriptionIdList()) {
                String subscriberId = tele.getSubscriberId(subId);
                NetworkIdentity probeIdent = new NetworkIdentity(0, 0, subscriberId, null, false);
                if (!template.matches(probeIdent)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private void notifyOverLimitLocked(NetworkTemplate template) {
        if (!this.mOverLimitNotified.contains(template)) {
            this.mContext.startActivity(NetworkPolicyManagerService.buildNetworkOverLimitIntent(template));
            this.mOverLimitNotified.add(template);
        }
    }

    private void notifyUnderLimitLocked(NetworkTemplate template) {
        this.mOverLimitNotified.remove(template);
    }

    private String buildNotificationTag(NetworkPolicy policy, int type) {
        return "NetworkPolicy:" + policy.template.hashCode() + ":" + type;
    }

    private void enqueueNotification(NetworkPolicy policy, int type, long totalBytes) {
        String tag = this.buildNotificationTag(policy, type);
        Notification.Builder builder = new Notification.Builder(this.mContext);
        builder.setOnlyAlertOnce(true);
        builder.setWhen(0L);
        builder.setColor(this.mContext.getColor(17170521));
        Resources res = this.mContext.getResources();
        switch (type) {
            case 1: {
                CharSequence title = res.getText(17040518);
                String body = res.getString(17040519);
                builder.setSmallIcon(17301624);
                builder.setTicker(title);
                builder.setContentTitle(title);
                builder.setContentText(body);
                Intent snoozeIntent = NetworkPolicyManagerService.buildSnoozeWarningIntent(policy.template);
                builder.setDeleteIntent(PendingIntent.getBroadcast(this.mContext, 0, snoozeIntent, 0x8000000));
                Intent viewIntent = NetworkPolicyManagerService.buildViewDataUsageIntent(policy.template);
                builder.setContentIntent(PendingIntent.getActivity(this.mContext, 0, viewIntent, 0x8000000));
                break;
            }
            case 2: {
                CharSequence title;
                CharSequence body = res.getText(17040524);
                int icon = 17303097;
                switch (policy.template.getMatchRule()) {
                    case 2: {
                        title = res.getText(17040520);
                        break;
                    }
                    case 3: {
                        title = res.getText(17040521);
                        break;
                    }
                    case 1: {
                        title = res.getText(17040522);
                        break;
                    }
                    case 4: {
                        title = res.getText(17040523);
                        icon = 17301624;
                        break;
                    }
                    default: {
                        title = null;
                    }
                }
                builder.setOngoing(true);
                builder.setSmallIcon(icon);
                builder.setTicker(title);
                builder.setContentTitle(title);
                builder.setContentText(body);
                Intent intent = NetworkPolicyManagerService.buildNetworkOverLimitIntent(policy.template);
                builder.setContentIntent(PendingIntent.getActivity(this.mContext, 0, intent, 0x8000000));
                break;
            }
            case 3: {
                CharSequence title;
                long overBytes = totalBytes - policy.limitBytes;
                String body = res.getString(17040529, Formatter.formatFileSize(this.mContext, overBytes));
                switch (policy.template.getMatchRule()) {
                    case 2: {
                        title = res.getText(17040525);
                        break;
                    }
                    case 3: {
                        title = res.getText(17040526);
                        break;
                    }
                    case 1: {
                        title = res.getText(17040527);
                        break;
                    }
                    case 4: {
                        title = res.getText(17040528);
                        break;
                    }
                    default: {
                        title = null;
                    }
                }
                builder.setOngoing(true);
                builder.setSmallIcon(17301624);
                builder.setTicker(title);
                builder.setContentTitle(title);
                builder.setContentText(body);
                Intent intent = NetworkPolicyManagerService.buildViewDataUsageIntent(policy.template);
                builder.setContentIntent(PendingIntent.getActivity(this.mContext, 0, intent, 0x8000000));
                break;
            }
        }
        try {
            String packageName = this.mContext.getPackageName();
            int[] idReceived = new int[1];
            this.mNotifManager.enqueueNotificationWithTag(packageName, packageName, tag, 0, builder.getNotification(), idReceived, 0);
            this.mActiveNotifs.add(tag);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    private void enqueueRestrictedNotification(String tag) {
        Resources res = this.mContext.getResources();
        Notification.Builder builder = new Notification.Builder(this.mContext);
        CharSequence title = res.getText(17040530);
        String body = res.getString(17040531);
        builder.setOnlyAlertOnce(true);
        builder.setOngoing(true);
        builder.setSmallIcon(17301624);
        builder.setTicker(title);
        builder.setContentTitle(title);
        builder.setContentText(body);
        builder.setColor(this.mContext.getColor(17170521));
        Intent intent = NetworkPolicyManagerService.buildAllowBackgroundDataIntent();
        builder.setContentIntent(PendingIntent.getBroadcast(this.mContext, 0, intent, 0x8000000));
        try {
            String packageName = this.mContext.getPackageName();
            int[] idReceived = new int[1];
            this.mNotifManager.enqueueNotificationWithTag(packageName, packageName, tag, 0, builder.getNotification(), idReceived, 0);
            this.mActiveNotifs.add(tag);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    private void cancelNotification(String tag) {
        try {
            String packageName = this.mContext.getPackageName();
            this.mNotifManager.cancelNotificationWithTag(packageName, tag, 0, 0);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    void updateNetworkEnabledLocked() {
        long currentTime = this.currentTimeMillis();
        for (int i = this.mNetworkPolicy.size() - 1; i >= 0; --i) {
            long end;
            NetworkPolicy policy = this.mNetworkPolicy.valueAt(i);
            if (policy.limitBytes == -1L || !policy.hasCycle()) {
                this.setNetworkTemplateEnabled(policy.template, true);
                continue;
            }
            long start = NetworkPolicyManager.computeLastCycleBoundary(currentTime, policy);
            long totalBytes = this.getTotalBytes(policy.template, start, end = currentTime);
            boolean overLimitWithoutSnooze = policy.isOverLimit(totalBytes) && policy.lastLimitSnooze < start;
            boolean networkEnabled = !overLimitWithoutSnooze;
            this.setNetworkTemplateEnabled(policy.template, networkEnabled);
        }
    }

    private void setNetworkTemplateEnabled(NetworkTemplate template, boolean enabled) {
    }

    void updateNetworkRulesLocked() {
        String iface;
        int i;
        Object ident;
        NetworkState[] states;
        try {
            states = this.mConnManager.getAllNetworkState();
        }
        catch (RemoteException e) {
            return;
        }
        boolean powerSave = this.mRestrictPower && !this.mRestrictBackground;
        ArrayList<Pair<String, Object>> connIdents = new ArrayList<Pair<String, Object>>(states.length);
        ArraySet<String> connIfaces = new ArraySet<String>(states.length);
        for (NetworkState state : states) {
            if (!state.networkInfo.isConnected()) continue;
            ident = NetworkIdentity.buildNetworkIdentity(this.mContext, state);
            String baseIface = state.linkProperties.getInterfaceName();
            if (baseIface != null) {
                connIdents.add(Pair.create(baseIface, ident));
                if (powerSave) {
                    connIfaces.add(baseIface);
                }
            }
            List<LinkProperties> stackedLinks = state.linkProperties.getStackedLinks();
            for (LinkProperties stackedLink : stackedLinks) {
                String stackedIface = stackedLink.getInterfaceName();
                if (stackedIface == null) continue;
                connIdents.add(Pair.create(stackedIface, ident));
                if (!powerSave) continue;
                connIfaces.add(stackedIface);
            }
        }
        this.mNetworkRules.clear();
        ArrayList ifaceList = Lists.newArrayList();
        for (int i2 = this.mNetworkPolicy.size() - 1; i2 >= 0; --i2) {
            NetworkPolicy policy = this.mNetworkPolicy.valueAt(i2);
            ifaceList.clear();
            for (int j = connIdents.size() - 1; j >= 0; --j) {
                ident = (Pair)connIdents.get(j);
                if (!policy.template.matches((NetworkIdentity)((Pair)ident).second)) continue;
                ifaceList.add(((Pair)ident).first);
            }
            if (ifaceList.size() <= 0) continue;
            String[] ifaces = ifaceList.toArray(new String[ifaceList.size()]);
            this.mNetworkRules.put(policy, ifaces);
        }
        long lowestRule = Long.MAX_VALUE;
        ArraySet<String> newMeteredIfaces = new ArraySet<String>(states.length);
        long currentTime = this.currentTimeMillis();
        for (i = this.mNetworkRules.size() - 1; i >= 0; --i) {
            boolean hasLimit;
            long totalBytes;
            long start;
            NetworkPolicy policy = this.mNetworkRules.keyAt(i);
            String[] ifaces = this.mNetworkRules.valueAt(i);
            if (policy.hasCycle()) {
                start = NetworkPolicyManager.computeLastCycleBoundary(currentTime, policy);
                totalBytes = this.getTotalBytes(policy.template, start, currentTime);
            } else {
                start = Long.MAX_VALUE;
                totalBytes = 0L;
            }
            boolean hasWarning = policy.warningBytes != -1L;
            boolean bl = hasLimit = policy.limitBytes != -1L;
            if (hasLimit || policy.metered) {
                long quotaBytes = !hasLimit ? Long.MAX_VALUE : (policy.lastLimitSnooze >= start ? Long.MAX_VALUE : Math.max(1L, policy.limitBytes - totalBytes));
                if (ifaces.length > 1) {
                    Slog.w(TAG, "shared quota unsupported; generating rule for each iface");
                }
                for (String iface2 : ifaces) {
                    this.removeInterfaceQuota(iface2);
                    this.setInterfaceQuota(iface2, quotaBytes);
                    newMeteredIfaces.add(iface2);
                    if (!powerSave) continue;
                    connIfaces.remove(iface2);
                }
            }
            if (hasWarning && policy.warningBytes < lowestRule) {
                lowestRule = policy.warningBytes;
            }
            if (!hasLimit || policy.limitBytes >= lowestRule) continue;
            lowestRule = policy.limitBytes;
        }
        for (i = connIfaces.size() - 1; i >= 0; --i) {
            iface = (String)connIfaces.valueAt(i);
            this.removeInterfaceQuota(iface);
            this.setInterfaceQuota(iface, Long.MAX_VALUE);
            newMeteredIfaces.add(iface);
        }
        this.mHandler.obtainMessage(7, lowestRule).sendToTarget();
        for (i = this.mMeteredIfaces.size() - 1; i >= 0; --i) {
            iface = this.mMeteredIfaces.valueAt(i);
            if (newMeteredIfaces.contains(iface)) continue;
            this.removeInterfaceQuota(iface);
        }
        this.mMeteredIfaces = newMeteredIfaces;
        String[] meteredIfaces = this.mMeteredIfaces.toArray(new String[this.mMeteredIfaces.size()]);
        this.mHandler.obtainMessage(2, meteredIfaces).sendToTarget();
    }

    private void ensureActiveMobilePolicyLocked() {
        int[] subIds;
        if (this.mSuppressDefaultPolicy) {
            return;
        }
        TelephonyManager tele = TelephonyManager.from(this.mContext);
        SubscriptionManager sub = SubscriptionManager.from(this.mContext);
        for (int subId : subIds = sub.getActiveSubscriptionIdList()) {
            String subscriberId = tele.getSubscriberId(subId);
            this.ensureActiveMobilePolicyLocked(subscriberId);
        }
    }

    private void ensureActiveMobilePolicyLocked(String subscriberId) {
        NetworkIdentity probeIdent = new NetworkIdentity(0, 0, subscriberId, null, false);
        for (int i = this.mNetworkPolicy.size() - 1; i >= 0; --i) {
            NetworkTemplate template = this.mNetworkPolicy.keyAt(i);
            if (!template.matches(probeIdent)) continue;
            return;
        }
        Slog.i(TAG, "No policy for subscriber " + NetworkIdentity.scrubSubscriberId(subscriberId) + "; generating default policy");
        long warningBytes = (long)this.mContext.getResources().getInteger(17694845) * 0x100000L;
        Time time = new Time();
        time.setToNow();
        int cycleDay = time.monthDay;
        String cycleTimezone = time.timezone;
        NetworkTemplate template = NetworkTemplate.buildTemplateMobileAll(subscriberId);
        NetworkPolicy policy = new NetworkPolicy(template, cycleDay, cycleTimezone, warningBytes, -1L, -1L, -1L, true, true);
        this.addNetworkPolicyLocked(policy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPolicyLocked() {
        this.mNetworkPolicy.clear();
        this.mUidPolicy.clear();
        FileInputStream fis = null;
        try {
            int type;
            fis = this.mPolicyFile.openRead();
            XmlPullParser in = Xml.newPullParser();
            in.setInput(fis, StandardCharsets.UTF_8.name());
            int version = 1;
            while ((type = in.next()) != 1) {
                String tag = in.getName();
                if (type != 2) continue;
                if (TAG_POLICY_LIST.equals(tag)) {
                    version = XmlUtils.readIntAttribute(in, ATTR_VERSION);
                    if (version >= 3) {
                        this.mRestrictBackground = XmlUtils.readBooleanAttribute(in, ATTR_RESTRICT_BACKGROUND);
                        continue;
                    }
                    this.mRestrictBackground = false;
                    continue;
                }
                if (TAG_NETWORK_POLICY.equals(tag)) {
                    boolean metered;
                    int networkTemplate = XmlUtils.readIntAttribute(in, ATTR_NETWORK_TEMPLATE);
                    String subscriberId = in.getAttributeValue(null, ATTR_SUBSCRIBER_ID);
                    String networkId = version >= 9 ? in.getAttributeValue(null, ATTR_NETWORK_ID) : null;
                    int cycleDay = XmlUtils.readIntAttribute(in, ATTR_CYCLE_DAY);
                    String cycleTimezone = version >= 6 ? in.getAttributeValue(null, ATTR_CYCLE_TIMEZONE) : "UTC";
                    long warningBytes = XmlUtils.readLongAttribute(in, ATTR_WARNING_BYTES);
                    long limitBytes = XmlUtils.readLongAttribute(in, ATTR_LIMIT_BYTES);
                    long lastLimitSnooze = version >= 5 ? XmlUtils.readLongAttribute(in, ATTR_LAST_LIMIT_SNOOZE) : (version >= 2 ? XmlUtils.readLongAttribute(in, ATTR_LAST_SNOOZE) : -1L);
                    if (version >= 4) {
                        metered = XmlUtils.readBooleanAttribute(in, ATTR_METERED);
                    } else {
                        switch (networkTemplate) {
                            case 1: 
                            case 2: 
                            case 3: {
                                metered = true;
                                break;
                            }
                            default: {
                                metered = false;
                            }
                        }
                    }
                    long lastWarningSnooze = version >= 5 ? XmlUtils.readLongAttribute(in, ATTR_LAST_WARNING_SNOOZE) : -1L;
                    boolean inferred = version >= 7 ? XmlUtils.readBooleanAttribute(in, ATTR_INFERRED) : false;
                    NetworkTemplate template = new NetworkTemplate(networkTemplate, subscriberId, networkId);
                    this.mNetworkPolicy.put(template, new NetworkPolicy(template, cycleDay, cycleTimezone, warningBytes, limitBytes, lastWarningSnooze, lastLimitSnooze, metered, inferred));
                    continue;
                }
                if (TAG_UID_POLICY.equals(tag)) {
                    int uid = XmlUtils.readIntAttribute(in, ATTR_UID);
                    int policy = XmlUtils.readIntAttribute(in, ATTR_POLICY);
                    if (UserHandle.isApp(uid)) {
                        this.setUidPolicyUncheckedLocked(uid, policy, false);
                        continue;
                    }
                    Slog.w(TAG, "unable to apply policy to UID " + uid + "; ignoring");
                    continue;
                }
                if (!TAG_APP_POLICY.equals(tag)) continue;
                int appId = XmlUtils.readIntAttribute(in, ATTR_APP_ID);
                int policy = XmlUtils.readIntAttribute(in, ATTR_POLICY);
                int uid = UserHandle.getUid(0, appId);
                if (UserHandle.isApp(uid)) {
                    this.setUidPolicyUncheckedLocked(uid, policy, false);
                    continue;
                }
                Slog.w(TAG, "unable to apply policy to UID " + uid + "; ignoring");
            }
        }
        catch (FileNotFoundException e) {
            this.upgradeLegacyBackgroundData();
        }
        catch (IOException e) {
            Log.wtf(TAG, "problem reading network policy", e);
        }
        catch (XmlPullParserException e) {
            Log.wtf(TAG, "problem reading network policy", e);
        }
        finally {
            IoUtils.closeQuietly(fis);
        }
    }

    private void upgradeLegacyBackgroundData() {
        boolean bl = this.mRestrictBackground = Settings.Secure.getInt(this.mContext.getContentResolver(), "background_data", 1) != 1;
        if (this.mRestrictBackground) {
            Intent broadcast = new Intent("android.net.conn.BACKGROUND_DATA_SETTING_CHANGED");
            this.mContext.sendBroadcastAsUser(broadcast, UserHandle.ALL);
        }
    }

    void writePolicyLocked() {
        block6: {
            FileOutputStream fos = null;
            try {
                int i;
                fos = this.mPolicyFile.startWrite();
                FastXmlSerializer out = new FastXmlSerializer();
                out.setOutput(fos, StandardCharsets.UTF_8.name());
                out.startDocument(null, true);
                out.startTag(null, TAG_POLICY_LIST);
                XmlUtils.writeIntAttribute(out, ATTR_VERSION, 10);
                XmlUtils.writeBooleanAttribute(out, ATTR_RESTRICT_BACKGROUND, this.mRestrictBackground);
                for (i = 0; i < this.mNetworkPolicy.size(); ++i) {
                    String networkId;
                    NetworkPolicy policy = this.mNetworkPolicy.valueAt(i);
                    NetworkTemplate template = policy.template;
                    out.startTag(null, TAG_NETWORK_POLICY);
                    XmlUtils.writeIntAttribute(out, ATTR_NETWORK_TEMPLATE, template.getMatchRule());
                    String subscriberId = template.getSubscriberId();
                    if (subscriberId != null) {
                        out.attribute(null, ATTR_SUBSCRIBER_ID, subscriberId);
                    }
                    if ((networkId = template.getNetworkId()) != null) {
                        out.attribute(null, ATTR_NETWORK_ID, networkId);
                    }
                    XmlUtils.writeIntAttribute(out, ATTR_CYCLE_DAY, policy.cycleDay);
                    out.attribute(null, ATTR_CYCLE_TIMEZONE, policy.cycleTimezone);
                    XmlUtils.writeLongAttribute(out, ATTR_WARNING_BYTES, policy.warningBytes);
                    XmlUtils.writeLongAttribute(out, ATTR_LIMIT_BYTES, policy.limitBytes);
                    XmlUtils.writeLongAttribute(out, ATTR_LAST_WARNING_SNOOZE, policy.lastWarningSnooze);
                    XmlUtils.writeLongAttribute(out, ATTR_LAST_LIMIT_SNOOZE, policy.lastLimitSnooze);
                    XmlUtils.writeBooleanAttribute(out, ATTR_METERED, policy.metered);
                    XmlUtils.writeBooleanAttribute(out, ATTR_INFERRED, policy.inferred);
                    out.endTag(null, TAG_NETWORK_POLICY);
                }
                for (i = 0; i < this.mUidPolicy.size(); ++i) {
                    int uid = this.mUidPolicy.keyAt(i);
                    int policy = this.mUidPolicy.valueAt(i);
                    if (policy == 0) continue;
                    out.startTag(null, TAG_UID_POLICY);
                    XmlUtils.writeIntAttribute(out, ATTR_UID, uid);
                    XmlUtils.writeIntAttribute(out, ATTR_POLICY, policy);
                    out.endTag(null, TAG_UID_POLICY);
                }
                out.endTag(null, TAG_POLICY_LIST);
                out.endDocument();
                this.mPolicyFile.finishWrite(fos);
            }
            catch (IOException e) {
                if (fos == null) break block6;
                this.mPolicyFile.failWrite(fos);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUidPolicy(int uid, int policy) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        if (!UserHandle.isApp(uid)) {
            throw new IllegalArgumentException("cannot apply policy to UID " + uid);
        }
        Object object = this.mRulesLock;
        synchronized (object) {
            long token = Binder.clearCallingIdentity();
            try {
                int oldPolicy = this.mUidPolicy.get(uid, 0);
                if (oldPolicy != policy) {
                    this.setUidPolicyUncheckedLocked(uid, policy, true);
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addUidPolicy(int uid, int policy) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        if (!UserHandle.isApp(uid)) {
            throw new IllegalArgumentException("cannot apply policy to UID " + uid);
        }
        Object object = this.mRulesLock;
        synchronized (object) {
            int oldPolicy = this.mUidPolicy.get(uid, 0);
            if (oldPolicy != (policy |= oldPolicy)) {
                this.setUidPolicyUncheckedLocked(uid, policy, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUidPolicy(int uid, int policy) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        if (!UserHandle.isApp(uid)) {
            throw new IllegalArgumentException("cannot apply policy to UID " + uid);
        }
        Object object = this.mRulesLock;
        synchronized (object) {
            int oldPolicy = this.mUidPolicy.get(uid, 0);
            policy = oldPolicy & ~policy;
            if (oldPolicy != policy) {
                this.setUidPolicyUncheckedLocked(uid, policy, true);
            }
        }
    }

    private void setUidPolicyUncheckedLocked(int uid, int policy, boolean persist) {
        this.mUidPolicy.put(uid, policy);
        this.updateRulesForUidLocked(uid);
        if (persist) {
            this.writePolicyLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUidPolicy(int uid) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        Object object = this.mRulesLock;
        synchronized (object) {
            return this.mUidPolicy.get(uid, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getUidsWithPolicy(int policy) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        int[] uids = new int[]{};
        Object object = this.mRulesLock;
        synchronized (object) {
            for (int i = 0; i < this.mUidPolicy.size(); ++i) {
                int uid = this.mUidPolicy.keyAt(i);
                int uidPolicy = this.mUidPolicy.valueAt(i);
                if (uidPolicy != policy) continue;
                uids = ArrayUtils.appendInt(uids, uid);
            }
        }
        return uids;
    }

    void removePoliciesForUserLocked(int userId) {
        int[] uids = new int[]{};
        for (int i = 0; i < this.mUidPolicy.size(); ++i) {
            int uid = this.mUidPolicy.keyAt(i);
            if (UserHandle.getUserId(uid) != userId) continue;
            uids = ArrayUtils.appendInt(uids, uid);
        }
        if (uids.length > 0) {
            for (int uid : uids) {
                this.mUidPolicy.delete(uid);
                this.updateRulesForUidLocked(uid);
            }
            this.writePolicyLocked();
        }
    }

    @Override
    public void registerListener(INetworkPolicyListener listener) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        this.mListeners.register(listener);
    }

    @Override
    public void unregisterListener(INetworkPolicyListener listener) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        this.mListeners.unregister(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNetworkPolicies(NetworkPolicy[] policies) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        this.maybeRefreshTrustedTime();
        Object object = this.mRulesLock;
        synchronized (object) {
            this.normalizePoliciesLocked(policies);
            this.updateNetworkEnabledLocked();
            this.updateNetworkRulesLocked();
            this.updateNotificationsLocked();
            this.writePolicyLocked();
        }
    }

    void addNetworkPolicyLocked(NetworkPolicy policy) {
        NetworkPolicy[] policies = this.getNetworkPolicies(this.mContext.getOpPackageName());
        policies = ArrayUtils.appendElement(NetworkPolicy.class, policies, policy);
        this.setNetworkPolicies(policies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetworkPolicy[] getNetworkPolicies(String callingPackage) {
        block6: {
            this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
            try {
                this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PRIVILEGED_PHONE_STATE", TAG);
            }
            catch (SecurityException e) {
                this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PHONE_STATE", TAG);
                if (this.mAppOps.noteOp(51, Binder.getCallingUid(), callingPackage) == 0) break block6;
                return new NetworkPolicy[0];
            }
        }
        Object object = this.mRulesLock;
        synchronized (object) {
            int size = this.mNetworkPolicy.size();
            NetworkPolicy[] policies = new NetworkPolicy[size];
            for (int i = 0; i < size; ++i) {
                policies[i] = this.mNetworkPolicy.valueAt(i);
            }
            return policies;
        }
    }

    private void normalizePoliciesLocked() {
        this.normalizePoliciesLocked(this.getNetworkPolicies(this.mContext.getOpPackageName()));
    }

    private void normalizePoliciesLocked(NetworkPolicy[] policies) {
        TelephonyManager tele = TelephonyManager.from(this.mContext);
        String[] merged = tele.getMergedSubscriberIds();
        this.mNetworkPolicy.clear();
        for (NetworkPolicy policy : policies) {
            policy.template = NetworkTemplate.normalize(policy.template, merged);
            NetworkPolicy existing = this.mNetworkPolicy.get(policy.template);
            if (existing != null && existing.compareTo(policy) <= 0) continue;
            if (existing != null) {
                Slog.d(TAG, "Normalization replaced " + existing + " with " + policy);
            }
            this.mNetworkPolicy.put(policy.template, policy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void snoozeLimit(NetworkTemplate template) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        long token = Binder.clearCallingIdentity();
        try {
            this.performSnooze(template, 2);
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void performSnooze(NetworkTemplate template, int type) {
        this.maybeRefreshTrustedTime();
        long currentTime = this.currentTimeMillis();
        Object object = this.mRulesLock;
        synchronized (object) {
            NetworkPolicy policy = this.mNetworkPolicy.get(template);
            if (policy == null) {
                throw new IllegalArgumentException("unable to find policy for " + template);
            }
            switch (type) {
                case 1: {
                    policy.lastWarningSnooze = currentTime;
                    break;
                }
                case 2: {
                    policy.lastLimitSnooze = currentTime;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unexpected type");
                }
            }
            this.normalizePoliciesLocked();
            this.updateNetworkEnabledLocked();
            this.updateNetworkRulesLocked();
            this.updateNotificationsLocked();
            this.writePolicyLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRestrictBackground(boolean restrictBackground) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        this.maybeRefreshTrustedTime();
        Object object = this.mRulesLock;
        synchronized (object) {
            this.mRestrictBackground = restrictBackground;
            this.updateRulesForGlobalChangeLocked(true);
            this.updateNotificationsLocked();
            this.writePolicyLocked();
        }
        this.mHandler.obtainMessage(6, restrictBackground ? 1 : 0, 0).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getRestrictBackground() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        Object object = this.mRulesLock;
        synchronized (object) {
            return this.mRestrictBackground;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDeviceIdleMode(boolean enabled) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        Object object = this.mRulesLock;
        synchronized (object) {
            if (this.mDeviceIdleMode != enabled) {
                this.mDeviceIdleMode = enabled;
                if (this.mSystemReady) {
                    this.updateRulesForDeviceIdleLocked();
                }
                if (enabled) {
                    EventLogTags.writeDeviceIdleOnPhase("net");
                } else {
                    EventLogTags.writeDeviceIdleOffPhase("net");
                }
            }
        }
    }

    private NetworkPolicy findPolicyForNetworkLocked(NetworkIdentity ident) {
        for (int i = this.mNetworkPolicy.size() - 1; i >= 0; --i) {
            NetworkPolicy policy = this.mNetworkPolicy.valueAt(i);
            if (!policy.template.matches(ident)) continue;
            return policy;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetworkQuotaInfo getNetworkQuotaInfo(NetworkState state) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE", TAG);
        long token = Binder.clearCallingIdentity();
        try {
            NetworkQuotaInfo networkQuotaInfo = this.getNetworkQuotaInfoUnchecked(state);
            return networkQuotaInfo;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NetworkQuotaInfo getNetworkQuotaInfoUnchecked(NetworkState state) {
        NetworkPolicy policy;
        NetworkIdentity ident = NetworkIdentity.buildNetworkIdentity(this.mContext, state);
        Object object = this.mRulesLock;
        synchronized (object) {
            policy = this.findPolicyForNetworkLocked(ident);
        }
        if (policy == null || !policy.hasCycle()) {
            return null;
        }
        long currentTime = this.currentTimeMillis();
        long start = NetworkPolicyManager.computeLastCycleBoundary(currentTime, policy);
        long end = currentTime;
        long totalBytes = this.getTotalBytes(policy.template, start, end);
        long softLimitBytes = policy.warningBytes != -1L ? policy.warningBytes : -1L;
        long hardLimitBytes = policy.limitBytes != -1L ? policy.limitBytes : -1L;
        return new NetworkQuotaInfo(totalBytes, softLimitBytes, hardLimitBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNetworkMetered(NetworkState state) {
        NetworkPolicy policy;
        NetworkIdentity ident = NetworkIdentity.buildNetworkIdentity(this.mContext, state);
        if (ident.getRoaming()) {
            return true;
        }
        Object object = this.mRulesLock;
        synchronized (object) {
            policy = this.findPolicyForNetworkLocked(ident);
        }
        if (policy != null) {
            return policy.metered;
        }
        int type = state.networkInfo.getType();
        return ConnectivityManager.isNetworkTypeMobile(type) || type == 6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DUMP", TAG);
        IndentingPrintWriter fout = new IndentingPrintWriter((Writer)writer, "  ");
        ArraySet<String> argSet = new ArraySet<String>(args.length);
        for (String arg : args) {
            argSet.add(arg);
        }
        Object object = this.mRulesLock;
        synchronized (object) {
            int i;
            int i2;
            if (argSet.contains("--unsnooze")) {
                for (i2 = this.mNetworkPolicy.size() - 1; i2 >= 0; --i2) {
                    this.mNetworkPolicy.valueAt(i2).clearSnooze();
                }
                this.normalizePoliciesLocked();
                this.updateNetworkEnabledLocked();
                this.updateNetworkRulesLocked();
                this.updateNotificationsLocked();
                this.writePolicyLocked();
                fout.println("Cleared snooze timestamps");
                return;
            }
            fout.print("System ready: ");
            fout.println(this.mSystemReady);
            fout.print("Restrict background: ");
            fout.println(this.mRestrictBackground);
            fout.print("Restrict power: ");
            fout.println(this.mRestrictPower);
            fout.print("Device idle: ");
            fout.println(this.mDeviceIdleMode);
            fout.println("Network policies:");
            fout.increaseIndent();
            for (i2 = 0; i2 < this.mNetworkPolicy.size(); ++i2) {
                fout.println(this.mNetworkPolicy.valueAt(i2).toString());
            }
            fout.decreaseIndent();
            fout.print("Metered ifaces: ");
            fout.println(String.valueOf(this.mMeteredIfaces));
            fout.println("Policy for UIDs:");
            fout.increaseIndent();
            int size = this.mUidPolicy.size();
            for (i = 0; i < size; ++i) {
                int uid = this.mUidPolicy.keyAt(i);
                int policy = this.mUidPolicy.valueAt(i);
                fout.print("UID=");
                fout.print(uid);
                fout.print(" policy=");
                NetworkPolicyManager.dumpPolicy(fout, policy);
                fout.println();
            }
            fout.decreaseIndent();
            size = this.mPowerSaveWhitelistExceptIdleAppIds.size();
            if (size > 0) {
                fout.println("Power save whitelist (except idle) app ids:");
                fout.increaseIndent();
                for (i = 0; i < size; ++i) {
                    fout.print("UID=");
                    fout.print(this.mPowerSaveWhitelistExceptIdleAppIds.keyAt(i));
                    fout.print(": ");
                    fout.print(this.mPowerSaveWhitelistExceptIdleAppIds.valueAt(i));
                    fout.println();
                }
                fout.decreaseIndent();
            }
            if ((size = this.mPowerSaveWhitelistAppIds.size()) > 0) {
                fout.println("Power save whitelist app ids:");
                fout.increaseIndent();
                for (i = 0; i < size; ++i) {
                    fout.print("UID=");
                    fout.print(this.mPowerSaveWhitelistAppIds.keyAt(i));
                    fout.print(": ");
                    fout.print(this.mPowerSaveWhitelistAppIds.valueAt(i));
                    fout.println();
                }
                fout.decreaseIndent();
            }
            SparseBooleanArray knownUids = new SparseBooleanArray();
            NetworkPolicyManagerService.collectKeys(this.mUidState, knownUids);
            NetworkPolicyManagerService.collectKeys(this.mUidRules, knownUids);
            fout.println("Status for known UIDs:");
            fout.increaseIndent();
            size = knownUids.size();
            for (int i3 = 0; i3 < size; ++i3) {
                int uid = knownUids.keyAt(i3);
                fout.print("UID=");
                fout.print(uid);
                int state = this.mUidState.get(uid, 16);
                fout.print(" state=");
                fout.print(state);
                fout.print(state <= 2 ? " (fg)" : " (bg)");
                fout.print(" rules=");
                int rulesIndex = this.mUidRules.indexOfKey(uid);
                if (rulesIndex < 0) {
                    fout.print("UNKNOWN");
                } else {
                    NetworkPolicyManager.dumpRules(fout, this.mUidRules.valueAt(rulesIndex));
                }
                fout.println();
            }
            fout.decreaseIndent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUidForeground(int uid) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_NETWORK_POLICY", TAG);
        Object object = this.mRulesLock;
        synchronized (object) {
            return this.isUidForegroundLocked(uid);
        }
    }

    boolean isUidForegroundLocked(int uid) {
        return this.mScreenOn && this.mUidState.get(uid, 16) <= 2;
    }

    void updateUidStateLocked(int uid, int uidState) {
        int oldUidState = this.mUidState.get(uid, 16);
        if (oldUidState != uidState) {
            this.mUidState.put(uid, uidState);
            this.updateRulesForUidStateChangeLocked(uid, oldUidState, uidState);
            if (this.mDeviceIdleMode && NetworkPolicyManagerService.isProcStateAllowedWhileIdle(oldUidState) != NetworkPolicyManagerService.isProcStateAllowedWhileIdle(uidState)) {
                this.updateRulesForDeviceIdleLocked();
            }
        }
    }

    void removeUidStateLocked(int uid) {
        int index = this.mUidState.indexOfKey(uid);
        if (index >= 0) {
            int oldUidState = this.mUidState.valueAt(index);
            this.mUidState.removeAt(index);
            if (oldUidState != 16) {
                this.updateRulesForUidStateChangeLocked(uid, oldUidState, 16);
                if (this.mDeviceIdleMode) {
                    this.updateRulesForDeviceIdleLocked();
                }
            }
        }
    }

    void updateRulesForUidStateChangeLocked(int uid, int oldUidState, int newUidState) {
        boolean newForeground;
        boolean oldForeground = oldUidState <= 2;
        boolean bl = newForeground = newUidState <= 2;
        if (oldForeground != newForeground) {
            this.updateRulesForUidLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateScreenOn() {
        Object object = this.mRulesLock;
        synchronized (object) {
            try {
                this.mScreenOn = this.mPowerManager.isInteractive();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this.updateRulesForScreenLocked();
        }
    }

    private void updateRulesForScreenLocked() {
        int size = this.mUidState.size();
        for (int i = 0; i < size; ++i) {
            if (this.mUidState.valueAt(i) > 2) continue;
            int uid = this.mUidState.keyAt(i);
            this.updateRulesForUidLocked(uid);
        }
    }

    static boolean isProcStateAllowedWhileIdle(int procState) {
        return procState <= 4;
    }

    void updateRulesForDeviceIdleLocked() {
        if (this.mDeviceIdleMode) {
            SparseIntArray uidRules = new SparseIntArray();
            List<UserInfo> users = this.mUserManager.getUsers();
            for (int ui = users.size() - 1; ui >= 0; --ui) {
                int uid;
                int appId;
                int i;
                UserInfo user = users.get(ui);
                for (i = this.mPowerSaveTempWhitelistAppIds.size() - 1; i >= 0; --i) {
                    if (!this.mPowerSaveTempWhitelistAppIds.valueAt(i)) continue;
                    appId = this.mPowerSaveTempWhitelistAppIds.keyAt(i);
                    uid = UserHandle.getUid(user.id, appId);
                    uidRules.put(uid, 1);
                }
                for (i = this.mPowerSaveWhitelistAppIds.size() - 1; i >= 0; --i) {
                    appId = this.mPowerSaveWhitelistAppIds.keyAt(i);
                    uid = UserHandle.getUid(user.id, appId);
                    uidRules.put(uid, 1);
                }
            }
            for (int i = this.mUidState.size() - 1; i >= 0; --i) {
                if (!NetworkPolicyManagerService.isProcStateAllowedWhileIdle(this.mUidState.valueAt(i))) continue;
                uidRules.put(this.mUidState.keyAt(i), 1);
            }
            this.setUidFirewallRules(1, uidRules);
        }
        this.enableFirewallChainLocked(1, this.mDeviceIdleMode);
    }

    void updateRuleForDeviceIdleLocked(int uid) {
        if (this.mDeviceIdleMode) {
            int appId = UserHandle.getAppId(uid);
            if (this.mPowerSaveTempWhitelistAppIds.get(appId) || this.mPowerSaveWhitelistAppIds.get(appId) || NetworkPolicyManagerService.isProcStateAllowedWhileIdle(this.mUidState.get(uid))) {
                this.setUidFirewallRule(1, uid, 1);
            } else {
                this.setUidFirewallRule(1, uid, 0);
            }
        }
    }

    void updateRulesForAppIdleLocked() {
        SparseIntArray uidRules = new SparseIntArray();
        List<UserInfo> users = this.mUserManager.getUsers();
        for (int ui = users.size() - 1; ui >= 0; --ui) {
            int[] idleUids;
            UserInfo user = users.get(ui);
            for (int uid : idleUids = this.mUsageStats.getIdleUidsForUser(user.id)) {
                if (this.mPowerSaveTempWhitelistAppIds.get(UserHandle.getAppId(uid), false)) continue;
                uidRules.put(uid, 2);
            }
        }
        this.setUidFirewallRules(2, uidRules);
    }

    void updateRuleForAppIdleLocked(int uid) {
        if (!NetworkPolicyManagerService.isUidValidForRules(uid)) {
            return;
        }
        int appId = UserHandle.getAppId(uid);
        if (!this.mPowerSaveTempWhitelistAppIds.get(appId) && this.isUidIdle(uid)) {
            this.setUidFirewallRule(2, uid, 2);
        } else {
            this.setUidFirewallRule(2, uid, 0);
        }
    }

    void updateRulesForAppIdleParoleLocked() {
        boolean enableChain = !this.mUsageStats.isAppIdleParoleOn();
        this.enableFirewallChainLocked(2, enableChain);
    }

    void updateRulesForGlobalChangeLocked(boolean restrictedNetworksChanged) {
        PackageManager pm = this.mContext.getPackageManager();
        this.updateRulesForDeviceIdleLocked();
        this.updateRulesForAppIdleLocked();
        List<UserInfo> users = this.mUserManager.getUsers();
        List<ApplicationInfo> apps = pm.getInstalledApplications(8704);
        for (UserInfo user : users) {
            for (ApplicationInfo app : apps) {
                int uid = UserHandle.getUid(user.id, app.uid);
                this.updateRulesForUidLocked(uid);
            }
        }
        this.updateRulesForUidLocked(1013);
        this.updateRulesForUidLocked(1019);
        if (restrictedNetworksChanged) {
            this.normalizePoliciesLocked();
            this.updateNetworkRulesLocked();
        }
    }

    void updateRulesForTempWhitelistChangeLocked() {
        List<UserInfo> users = this.mUserManager.getUsers();
        for (UserInfo user : users) {
            for (int i = this.mPowerSaveTempWhitelistAppIds.size() - 1; i >= 0; --i) {
                int appId = this.mPowerSaveTempWhitelistAppIds.keyAt(i);
                int uid = UserHandle.getUid(user.id, appId);
                this.updateRuleForAppIdleLocked(uid);
                this.updateRuleForDeviceIdleLocked(uid);
            }
        }
    }

    private static boolean isUidValidForRules(int uid) {
        return uid == 1013 || uid == 1019 || UserHandle.isApp(uid);
    }

    private boolean isUidIdle(int uid) {
        String[] packages = this.mContext.getPackageManager().getPackagesForUid(uid);
        int userId = UserHandle.getUserId(uid);
        for (String packageName : packages) {
            if (this.mUsageStats.isAppIdle(packageName, userId)) continue;
            return false;
        }
        return true;
    }

    void updateRulesForUidLocked(int uid) {
        boolean rejectMetered;
        if (!NetworkPolicyManagerService.isUidValidForRules(uid)) {
            return;
        }
        IPackageManager ipm = AppGlobals.getPackageManager();
        try {
            if (ipm.checkUidPermission("android.permission.INTERNET", uid) != 0) {
                return;
            }
        }
        catch (RemoteException e) {
            // empty catch block
        }
        int uidPolicy = this.mUidPolicy.get(uid, 0);
        boolean uidForeground = this.isUidForegroundLocked(uid);
        int appId = UserHandle.getAppId(uid);
        int uidRules = 0;
        if (!uidForeground && (uidPolicy & 1) != 0) {
            uidRules = 1;
        } else if (this.mRestrictBackground) {
            if (!uidForeground) {
                uidRules = 1;
            }
        } else if (this.mRestrictPower) {
            boolean whitelisted;
            boolean bl = whitelisted = this.mPowerSaveWhitelistExceptIdleAppIds.get(appId) || this.mPowerSaveTempWhitelistAppIds.get(appId);
            if (!whitelisted && !uidForeground && (uidPolicy & 2) == 0) {
                uidRules = 1;
            }
        }
        int oldRules = this.mUidRules.get(uid);
        if (uidRules == 0) {
            this.mUidRules.delete(uid);
        } else {
            this.mUidRules.put(uid, uidRules);
        }
        boolean oldRejectMetered = (oldRules & 1) != 0;
        boolean bl = rejectMetered = (uidRules & 1) != 0;
        if (oldRejectMetered != rejectMetered) {
            this.setUidNetworkRules(uid, rejectMetered);
        }
        if (oldRules != uidRules) {
            this.mHandler.obtainMessage(1, uid, uidRules).sendToTarget();
        }
        try {
            this.mNetworkStats.setUidForeground(uid, uidForeground);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    private void setInterfaceQuota(String iface, long quotaBytes) {
        try {
            this.mNetworkManager.setInterfaceQuota(iface, quotaBytes);
        }
        catch (IllegalStateException e) {
            Log.wtf(TAG, "problem setting interface quota", e);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    private void removeInterfaceQuota(String iface) {
        try {
            this.mNetworkManager.removeInterfaceQuota(iface);
        }
        catch (IllegalStateException e) {
            Log.wtf(TAG, "problem removing interface quota", e);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void setUidNetworkRules(int uid, boolean rejectOnQuotaInterfaces) {
        try {
            this.mNetworkManager.setUidNetworkRules(uid, rejectOnQuotaInterfaces);
        }
        catch (IllegalStateException e) {
            Log.wtf(TAG, "problem setting uid rules", e);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void setUidFirewallRules(int chain, SparseIntArray uidRules) {
        try {
            int size = uidRules.size();
            int[] uids = new int[size];
            int[] rules = new int[size];
            for (int index = size - 1; index >= 0; --index) {
                uids[index] = uidRules.keyAt(index);
                rules[index] = uidRules.valueAt(index);
            }
            this.mNetworkManager.setFirewallUidRules(chain, uids, rules);
        }
        catch (IllegalStateException e) {
            Log.wtf(TAG, "problem setting firewall uid rules", e);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void setUidFirewallRule(int chain, int uid, int rule) {
        try {
            this.mNetworkManager.setFirewallUidRule(chain, uid, rule);
        }
        catch (IllegalStateException e) {
            Log.wtf(TAG, "problem setting firewall uid rules", e);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    private void enableFirewallChainLocked(int chain, boolean enable) {
        if (this.mFirewallChainStates.indexOfKey(chain) >= 0 && this.mFirewallChainStates.get(chain) == enable) {
            return;
        }
        this.mFirewallChainStates.put(chain, enable);
        try {
            this.mNetworkManager.setFirewallChainEnabled(chain, enable);
        }
        catch (IllegalStateException e) {
            Log.wtf(TAG, "problem enable firewall chain", e);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private long getTotalBytes(NetworkTemplate template, long start, long end) {
        try {
            return this.mNetworkStats.getNetworkTotalBytes(template, start, end);
        }
        catch (RuntimeException e) {
            Slog.w(TAG, "problem reading network stats: " + e);
            return 0L;
        }
        catch (RemoteException e) {
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isBandwidthControlEnabled() {
        long token = Binder.clearCallingIdentity();
        try {
            boolean bl = this.mNetworkManager.isBandwidthControlEnabled();
            return bl;
        }
        catch (RemoteException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    void maybeRefreshTrustedTime() {
        if (this.mTime.getCacheAge() > 86400000L) {
            this.mTime.forceRefresh();
        }
    }

    private long currentTimeMillis() {
        return this.mTime.hasCache() ? this.mTime.currentTimeMillis() : System.currentTimeMillis();
    }

    private static Intent buildAllowBackgroundDataIntent() {
        return new Intent(ACTION_ALLOW_BACKGROUND);
    }

    private static Intent buildSnoozeWarningIntent(NetworkTemplate template) {
        Intent intent = new Intent(ACTION_SNOOZE_WARNING);
        intent.putExtra("android.net.NETWORK_TEMPLATE", template);
        return intent;
    }

    private static Intent buildNetworkOverLimitIntent(NetworkTemplate template) {
        Intent intent = new Intent();
        intent.setComponent(new ComponentName("com.android.systemui", "com.android.systemui.net.NetworkOverLimitActivity"));
        intent.addFlags(0x10000000);
        intent.putExtra("android.net.NETWORK_TEMPLATE", template);
        return intent;
    }

    private static Intent buildViewDataUsageIntent(NetworkTemplate template) {
        Intent intent = new Intent();
        intent.setComponent(new ComponentName("com.android.settings", "com.android.settings.Settings$DataUsageSummaryActivity"));
        intent.addFlags(0x10000000);
        intent.putExtra("android.net.NETWORK_TEMPLATE", template);
        return intent;
    }

    public void addIdleHandler(MessageQueue.IdleHandler handler) {
        this.mHandler.getLooper().getQueue().addIdleHandler(handler);
    }

    private static void collectKeys(SparseIntArray source, SparseBooleanArray target) {
        int size = source.size();
        for (int i = 0; i < size; ++i) {
            target.put(source.keyAt(i), true);
        }
    }

    @Override
    public void factoryReset(String subscriber) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
        if (this.mUserManager.hasUserRestriction("no_network_reset")) {
            return;
        }
        NetworkPolicy[] policies = this.getNetworkPolicies(this.mContext.getOpPackageName());
        NetworkTemplate template = NetworkTemplate.buildTemplateMobileAll(subscriber);
        for (NetworkPolicy policy : policies) {
            if (!policy.template.equals(template)) continue;
            policy.limitBytes = -1L;
            policy.inferred = false;
            policy.clearSnooze();
        }
        this.setNetworkPolicies(policies);
        this.setRestrictBackground(false);
        if (!this.mUserManager.hasUserRestriction("no_control_apps")) {
            for (int uid : this.getUidsWithPolicy(1)) {
                this.setUidPolicy(uid, 0);
            }
        }
    }

    private class AppIdleStateChangeListener
    extends UsageStatsManagerInternal.AppIdleStateChangeListener {
        private AppIdleStateChangeListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAppIdleStateChanged(String packageName, int userId, boolean idle) {
            try {
                int uid = NetworkPolicyManagerService.this.mContext.getPackageManager().getPackageUid(packageName, userId);
                Object object = NetworkPolicyManagerService.this.mRulesLock;
                synchronized (object) {
                    NetworkPolicyManagerService.this.updateRuleForAppIdleLocked(uid);
                }
            }
            catch (PackageManager.NameNotFoundException nnfe) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onParoleStateChanged(boolean isParoleOn) {
            Object object = NetworkPolicyManagerService.this.mRulesLock;
            synchronized (object) {
                NetworkPolicyManagerService.this.updateRulesForAppIdleParoleLocked();
            }
        }
    }
}

