/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.net;

import android.net.NetworkStats;
import android.net.NetworkTemplate;
import android.os.DropBoxManager;
import android.util.Log;
import android.util.MathUtils;
import com.android.internal.net.VpnInfo;
import com.android.internal.util.FileRotator;
import com.android.internal.util.IndentingPrintWriter;
import com.android.internal.util.Preconditions;
import com.android.server.net.NetworkIdentitySet;
import com.android.server.net.NetworkStatsCollection;
import com.google.android.collect.Sets;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import libcore.io.IoUtils;

public class NetworkStatsRecorder {
    private static final String TAG = "NetworkStatsRecorder";
    private static final boolean LOGD = false;
    private static final boolean LOGV = false;
    private static final String TAG_NETSTATS_DUMP = "netstats_dump";
    private static final boolean DUMP_BEFORE_DELETE = true;
    private final FileRotator mRotator;
    private final NetworkStats.NonMonotonicObserver<String> mObserver;
    private final DropBoxManager mDropBox;
    private final String mCookie;
    private final long mBucketDuration;
    private final boolean mOnlyTags;
    private long mPersistThresholdBytes = 0x200000L;
    private NetworkStats mLastSnapshot;
    private final NetworkStatsCollection mPending;
    private final NetworkStatsCollection mSinceBoot;
    private final CombiningRewriter mPendingRewriter;
    private WeakReference<NetworkStatsCollection> mComplete;

    public NetworkStatsRecorder(FileRotator rotator, NetworkStats.NonMonotonicObserver<String> observer, DropBoxManager dropBox, String cookie, long bucketDuration, boolean onlyTags) {
        this.mRotator = Preconditions.checkNotNull(rotator, "missing FileRotator");
        this.mObserver = Preconditions.checkNotNull(observer, "missing NonMonotonicObserver");
        this.mDropBox = Preconditions.checkNotNull(dropBox, "missing DropBoxManager");
        this.mCookie = cookie;
        this.mBucketDuration = bucketDuration;
        this.mOnlyTags = onlyTags;
        this.mPending = new NetworkStatsCollection(bucketDuration);
        this.mSinceBoot = new NetworkStatsCollection(bucketDuration);
        this.mPendingRewriter = new CombiningRewriter(this.mPending);
    }

    public void setPersistThreshold(long thresholdBytes) {
        this.mPersistThresholdBytes = MathUtils.constrain(thresholdBytes, 1024L, 0x6400000L);
    }

    public void resetLocked() {
        this.mLastSnapshot = null;
        this.mPending.reset();
        this.mSinceBoot.reset();
        this.mComplete.clear();
    }

    public NetworkStats.Entry getTotalSinceBootLocked(NetworkTemplate template) {
        return this.mSinceBoot.getSummary(template, Long.MIN_VALUE, Long.MAX_VALUE).getTotal(null);
    }

    public NetworkStatsCollection getOrLoadCompleteLocked() {
        NetworkStatsCollection res;
        NetworkStatsCollection networkStatsCollection = res = this.mComplete != null ? (NetworkStatsCollection)this.mComplete.get() : null;
        if (res == null) {
            res = this.loadLocked(Long.MIN_VALUE, Long.MAX_VALUE);
            this.mComplete = new WeakReference<NetworkStatsCollection>(res);
        }
        return res;
    }

    public NetworkStatsCollection getOrLoadPartialLocked(long start, long end) {
        NetworkStatsCollection res;
        NetworkStatsCollection networkStatsCollection = res = this.mComplete != null ? (NetworkStatsCollection)this.mComplete.get() : null;
        if (res == null) {
            res = this.loadLocked(start, end);
        }
        return res;
    }

    private NetworkStatsCollection loadLocked(long start, long end) {
        NetworkStatsCollection res = new NetworkStatsCollection(this.mBucketDuration);
        try {
            this.mRotator.readMatching(res, start, end);
            res.recordCollection(this.mPending);
        }
        catch (IOException e) {
            Log.wtf(TAG, "problem completely reading network stats", e);
            this.recoverFromWtf();
        }
        catch (OutOfMemoryError e) {
            Log.wtf(TAG, "problem completely reading network stats", e);
            this.recoverFromWtf();
        }
        return res;
    }

    public void recordSnapshotLocked(NetworkStats snapshot, Map<String, NetworkIdentitySet> ifaceIdent, VpnInfo[] vpnArray, long currentTimeMillis) {
        HashSet unknownIfaces = Sets.newHashSet();
        if (snapshot == null) {
            return;
        }
        if (this.mLastSnapshot == null) {
            this.mLastSnapshot = snapshot;
            return;
        }
        NetworkStatsCollection complete = this.mComplete != null ? (NetworkStatsCollection)this.mComplete.get() : null;
        NetworkStats delta = NetworkStats.subtract(snapshot, this.mLastSnapshot, this.mObserver, this.mCookie);
        long end = currentTimeMillis;
        long start = end - delta.getElapsedRealtime();
        if (vpnArray != null) {
            for (VpnInfo info : vpnArray) {
                delta.migrateTun(info.ownerUid, info.vpnIface, info.primaryUnderlyingIface);
            }
        }
        NetworkStats.Entry entry = null;
        for (int i = 0; i < delta.size(); ++i) {
            entry = delta.getValues(i, entry);
            NetworkIdentitySet ident = ifaceIdent.get(entry.iface);
            if (ident == null) {
                unknownIfaces.add(entry.iface);
                continue;
            }
            if (entry.isEmpty() || entry.tag == 0 == this.mOnlyTags) continue;
            this.mPending.recordData(ident, entry.uid, entry.set, entry.tag, start, end, entry);
            if (this.mSinceBoot != null) {
                this.mSinceBoot.recordData(ident, entry.uid, entry.set, entry.tag, start, end, entry);
            }
            if (complete == null) continue;
            complete.recordData(ident, entry.uid, entry.set, entry.tag, start, end, entry);
        }
        this.mLastSnapshot = snapshot;
    }

    public void maybePersistLocked(long currentTimeMillis) {
        long pendingBytes = this.mPending.getTotalBytes();
        if (pendingBytes >= this.mPersistThresholdBytes) {
            this.forcePersistLocked(currentTimeMillis);
        } else {
            this.mRotator.maybeRotate(currentTimeMillis);
        }
    }

    public void forcePersistLocked(long currentTimeMillis) {
        if (this.mPending.isDirty()) {
            try {
                this.mRotator.rewriteActive(this.mPendingRewriter, currentTimeMillis);
                this.mRotator.maybeRotate(currentTimeMillis);
                this.mPending.reset();
            }
            catch (IOException e) {
                Log.wtf(TAG, "problem persisting pending stats", e);
                this.recoverFromWtf();
            }
            catch (OutOfMemoryError e) {
                Log.wtf(TAG, "problem persisting pending stats", e);
                this.recoverFromWtf();
            }
        }
    }

    public void removeUidsLocked(int[] uids) {
        NetworkStatsCollection complete;
        try {
            this.mRotator.rewriteAll(new RemoveUidRewriter(this.mBucketDuration, uids));
        }
        catch (IOException e) {
            Log.wtf(TAG, "problem removing UIDs " + Arrays.toString(uids), e);
            this.recoverFromWtf();
        }
        catch (OutOfMemoryError e) {
            Log.wtf(TAG, "problem removing UIDs " + Arrays.toString(uids), e);
            this.recoverFromWtf();
        }
        this.mPending.removeUids(uids);
        this.mSinceBoot.removeUids(uids);
        if (this.mLastSnapshot != null) {
            this.mLastSnapshot = this.mLastSnapshot.withoutUids(uids);
        }
        NetworkStatsCollection networkStatsCollection = complete = this.mComplete != null ? (NetworkStatsCollection)this.mComplete.get() : null;
        if (complete != null) {
            complete.removeUids(uids);
        }
    }

    public void importLegacyNetworkLocked(File file) throws IOException {
        this.mRotator.deleteAll();
        NetworkStatsCollection collection = new NetworkStatsCollection(this.mBucketDuration);
        collection.readLegacyNetwork(file);
        long startMillis = collection.getStartMillis();
        long endMillis = collection.getEndMillis();
        if (!collection.isEmpty()) {
            this.mRotator.rewriteActive(new CombiningRewriter(collection), startMillis);
            this.mRotator.maybeRotate(endMillis);
        }
    }

    public void importLegacyUidLocked(File file) throws IOException {
        this.mRotator.deleteAll();
        NetworkStatsCollection collection = new NetworkStatsCollection(this.mBucketDuration);
        collection.readLegacyUid(file, this.mOnlyTags);
        long startMillis = collection.getStartMillis();
        long endMillis = collection.getEndMillis();
        if (!collection.isEmpty()) {
            this.mRotator.rewriteActive(new CombiningRewriter(collection), startMillis);
            this.mRotator.maybeRotate(endMillis);
        }
    }

    public void dumpLocked(IndentingPrintWriter pw, boolean fullHistory) {
        pw.print("Pending bytes: ");
        pw.println(this.mPending.getTotalBytes());
        if (fullHistory) {
            pw.println("Complete history:");
            this.getOrLoadCompleteLocked().dump(pw);
        } else {
            pw.println("History since boot:");
            this.mSinceBoot.dump(pw);
        }
    }

    public void dumpCheckin(PrintWriter pw, long start, long end) {
        this.getOrLoadPartialLocked(start, end).dumpCheckin(pw, start, end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recoverFromWtf() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            this.mRotator.dumpAll(os);
        }
        catch (IOException e) {
            os.reset();
        }
        finally {
            IoUtils.closeQuietly(os);
        }
        this.mDropBox.addData(TAG_NETSTATS_DUMP, os.toByteArray(), 0);
        this.mRotator.deleteAll();
    }

    public static class RemoveUidRewriter
    implements FileRotator.Rewriter {
        private final NetworkStatsCollection mTemp;
        private final int[] mUids;

        public RemoveUidRewriter(long bucketDuration, int[] uids) {
            this.mTemp = new NetworkStatsCollection(bucketDuration);
            this.mUids = uids;
        }

        @Override
        public void reset() {
            this.mTemp.reset();
        }

        @Override
        public void read(InputStream in) throws IOException {
            this.mTemp.read(in);
            this.mTemp.clearDirty();
            this.mTemp.removeUids(this.mUids);
        }

        @Override
        public boolean shouldWrite() {
            return this.mTemp.isDirty();
        }

        @Override
        public void write(OutputStream out) throws IOException {
            this.mTemp.write(new DataOutputStream(out));
        }
    }

    private static class CombiningRewriter
    implements FileRotator.Rewriter {
        private final NetworkStatsCollection mCollection;

        public CombiningRewriter(NetworkStatsCollection collection) {
            this.mCollection = Preconditions.checkNotNull(collection, "missing NetworkStatsCollection");
        }

        @Override
        public void reset() {
        }

        @Override
        public void read(InputStream in) throws IOException {
            this.mCollection.read(in);
        }

        @Override
        public boolean shouldWrite() {
            return true;
        }

        @Override
        public void write(OutputStream out) throws IOException {
            this.mCollection.write(new DataOutputStream(out));
            this.mCollection.reset();
        }
    }
}

