/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.notification;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.service.notification.Condition;
import android.service.notification.ConditionProviderService;
import android.service.notification.IConditionProvider;
import android.service.notification.ZenModeConfig;
import android.text.format.DateFormat;
import android.util.ArraySet;
import android.util.Log;
import android.util.Slog;
import com.android.server.notification.NotificationManagerService;
import com.android.server.notification.ZenLog;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;

public class DowntimeConditionProvider
extends ConditionProviderService {
    private static final String TAG = "DowntimeConditions";
    private static final boolean DEBUG = Log.isLoggable("DowntimeConditions", 3);
    public static final ComponentName COMPONENT = new ComponentName("android", DowntimeConditionProvider.class.getName());
    private static final String ENTER_ACTION = "DowntimeConditions.enter";
    private static final int ENTER_CODE = 100;
    private static final String EXIT_ACTION = "DowntimeConditions.exit";
    private static final int EXIT_CODE = 101;
    private static final String EXTRA_TIME = "time";
    private final Calendar mCalendar = Calendar.getInstance();
    private final Context mContext = this;
    private final ArraySet<Integer> mDays = new ArraySet();
    private boolean mConnected;
    private boolean mInDowntime;
    private ZenModeConfig mConfig;
    private Callback mCallback;
    private BroadcastReceiver mReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            long now = System.currentTimeMillis();
            if (DowntimeConditionProvider.ENTER_ACTION.equals(action) || DowntimeConditionProvider.EXIT_ACTION.equals(action)) {
                long schTime = intent.getLongExtra(DowntimeConditionProvider.EXTRA_TIME, 0L);
                if (DEBUG) {
                    Slog.d(DowntimeConditionProvider.TAG, String.format("%s scheduled for %s, fired at %s, delta=%s", action, DowntimeConditionProvider.ts(schTime), DowntimeConditionProvider.ts(now), now - schTime));
                }
            } else if ("android.intent.action.TIMEZONE_CHANGED".equals(action)) {
                if (DEBUG) {
                    Slog.d(DowntimeConditionProvider.TAG, "timezone changed to " + TimeZone.getDefault());
                }
                DowntimeConditionProvider.this.mCalendar.setTimeZone(TimeZone.getDefault());
            } else if (DEBUG) {
                Slog.d(DowntimeConditionProvider.TAG, action + " fired at " + now);
            }
            DowntimeConditionProvider.this.reevaluateDowntime();
            DowntimeConditionProvider.this.updateAlarms();
        }
    };

    public DowntimeConditionProvider() {
        if (DEBUG) {
            Slog.d(TAG, "new DowntimeConditionProvider()");
        }
    }

    public void dump(PrintWriter pw, NotificationManagerService.DumpFilter filter) {
        pw.println("    DowntimeConditionProvider:");
        pw.print("      mConnected=");
        pw.println(this.mConnected);
        pw.print("      mInDowntime=");
        pw.println(this.mInDowntime);
    }

    public void attachBase(Context base) {
        this.attachBaseContext(base);
    }

    public IConditionProvider asInterface() {
        return (IConditionProvider)((Object)this.onBind(null));
    }

    public void setCallback(Callback callback) {
        this.mCallback = callback;
    }

    @Override
    public void onConnected() {
        if (DEBUG) {
            Slog.d(TAG, "onConnected");
        }
        this.mConnected = true;
        IntentFilter filter = new IntentFilter();
        filter.addAction(ENTER_ACTION);
        filter.addAction(EXIT_ACTION);
        filter.addAction("android.intent.action.TIME_SET");
        filter.addAction("android.intent.action.TIMEZONE_CHANGED");
        this.mContext.registerReceiver(this.mReceiver, filter);
        this.init();
    }

    @Override
    public void onDestroy() {
        if (DEBUG) {
            Slog.d(TAG, "onDestroy");
        }
        this.mConnected = false;
    }

    @Override
    public void onRequestConditions(int relevance) {
        if (DEBUG) {
            Slog.d(TAG, "onRequestConditions relevance=" + relevance);
        }
        if ((relevance & 1) != 0 && this.mInDowntime && this.mConfig != null) {
            this.notifyCondition(this.createCondition(this.mConfig.toDowntimeInfo(), 1));
        }
    }

    @Override
    public void onSubscribe(Uri conditionId) {
        ZenModeConfig.DowntimeInfo downtime;
        if (DEBUG) {
            Slog.d(TAG, "onSubscribe conditionId=" + conditionId);
        }
        if ((downtime = ZenModeConfig.tryParseDowntimeConditionId((Uri)conditionId)) != null && this.mConfig != null) {
            int state;
            int n = state = this.mConfig.toDowntimeInfo().equals((Object)downtime) && this.mInDowntime ? 1 : 0;
            if (DEBUG) {
                Slog.d(TAG, "notify condition state: " + Condition.stateToString(state));
            }
            this.notifyCondition(this.createCondition(downtime, state));
        }
    }

    @Override
    public void onUnsubscribe(Uri conditionId) {
        if (DEBUG) {
            Slog.d(TAG, "onUnsubscribe conditionId=" + conditionId);
        }
    }

    public void setConfig(ZenModeConfig config) {
        if (Objects.equals(this.mConfig, config)) {
            return;
        }
        if (DEBUG) {
            Slog.d(TAG, "setConfig");
        }
        this.mConfig = config;
        if (this.mConnected) {
            this.init();
        }
    }

    public boolean isInDowntime() {
        return this.mInDowntime;
    }

    public Condition createCondition(ZenModeConfig.DowntimeInfo downtime, int state) {
        if (downtime == null) {
            return null;
        }
        Uri id2 = ZenModeConfig.toDowntimeConditionId((ZenModeConfig.DowntimeInfo)downtime);
        String skeleton = DateFormat.is24HourFormat(this.mContext) ? "Hm" : "hma";
        Locale locale = Locale.getDefault();
        String pattern = DateFormat.getBestDateTimePattern(locale, skeleton);
        long time = this.getTime(System.currentTimeMillis(), downtime.endHour, downtime.endMinute);
        String formatted = new SimpleDateFormat(pattern, locale).format(new Date(time));
        String summary = this.mContext.getString(17041023, formatted);
        return new Condition(id2, summary, "", "", 0, state, 1);
    }

    public boolean isDowntimeCondition(Condition condition) {
        return condition != null && ZenModeConfig.isValidDowntimeConditionId((Uri)condition.id);
    }

    private void init() {
        this.updateDays();
        this.reevaluateDowntime();
        this.updateAlarms();
    }

    private void updateDays() {
        this.mDays.clear();
        if (this.mConfig != null) {
            int[] days = ZenModeConfig.tryParseDays((String)this.mConfig.sleepMode);
            for (int i = 0; days != null && i < days.length; ++i) {
                this.mDays.add(days[i]);
            }
        }
    }

    private boolean isInDowntime(long time) {
        long end;
        if (this.mConfig == null || this.mDays.size() == 0) {
            return false;
        }
        long start = this.getTime(time, this.mConfig.sleepStartHour, this.mConfig.sleepStartMinute);
        if (start == (end = this.getTime(time, this.mConfig.sleepEndHour, this.mConfig.sleepEndMinute))) {
            return false;
        }
        if (end < start) {
            end = this.addDays(end, 1);
        }
        return this.isInDowntime(-1, time, start, end) || this.isInDowntime(0, time, start, end);
    }

    private boolean isInDowntime(int daysOffset, long time, long start, long end) {
        int n = 7;
        int day = (this.getDayOfWeek(time) - 1 + daysOffset % 7 + 7) % 7 + 1;
        start = this.addDays(start, daysOffset);
        end = this.addDays(end, daysOffset);
        return this.mDays.contains(day) && time >= start && time < end;
    }

    private void reevaluateDowntime() {
        boolean inDowntime = this.isInDowntime(System.currentTimeMillis());
        if (DEBUG) {
            Slog.d(TAG, "inDowntime=" + inDowntime);
        }
        if (inDowntime == this.mInDowntime) {
            return;
        }
        Slog.i(TAG, (inDowntime ? "Entering" : "Exiting") + " downtime");
        this.mInDowntime = inDowntime;
        ZenLog.traceDowntime((boolean)this.mInDowntime, (int)this.getDayOfWeek(System.currentTimeMillis()), this.mDays);
        this.fireDowntimeChanged();
    }

    private void fireDowntimeChanged() {
        if (this.mCallback != null) {
            this.mCallback.onDowntimeChanged(this.mInDowntime);
        }
    }

    private void updateAlarms() {
        if (this.mConfig == null) {
            return;
        }
        this.updateAlarm(ENTER_ACTION, 100, this.mConfig.sleepStartHour, this.mConfig.sleepStartMinute);
        this.updateAlarm(EXIT_ACTION, 101, this.mConfig.sleepEndHour, this.mConfig.sleepEndMinute);
    }

    private int getDayOfWeek(long time) {
        this.mCalendar.setTimeInMillis(time);
        return this.mCalendar.get(7);
    }

    private long getTime(long millis, int hour, int min) {
        this.mCalendar.setTimeInMillis(millis);
        this.mCalendar.set(11, hour);
        this.mCalendar.set(12, min);
        this.mCalendar.set(13, 0);
        this.mCalendar.set(14, 0);
        return this.mCalendar.getTimeInMillis();
    }

    private long addDays(long time, int days) {
        this.mCalendar.setTimeInMillis(time);
        this.mCalendar.add(5, days);
        return this.mCalendar.getTimeInMillis();
    }

    private void updateAlarm(String action, int requestCode, int hr, int min) {
        AlarmManager alarms = (AlarmManager)this.mContext.getSystemService("alarm");
        long now = System.currentTimeMillis();
        this.mCalendar.setTimeInMillis(now);
        this.mCalendar.set(11, hr);
        this.mCalendar.set(12, min);
        this.mCalendar.set(13, 0);
        this.mCalendar.set(14, 0);
        long time = this.mCalendar.getTimeInMillis();
        if (time <= now) {
            time = this.addDays(time, 1);
        }
        PendingIntent pendingIntent = PendingIntent.getBroadcast(this.mContext, requestCode, new Intent(action).putExtra(EXTRA_TIME, time), 0x8000000);
        alarms.cancel(pendingIntent);
        if (this.mConfig.sleepMode != null) {
            if (DEBUG) {
                Slog.d(TAG, String.format("Scheduling %s for %s, %s in the future, now=%s", action, DowntimeConditionProvider.ts(time), time - now, DowntimeConditionProvider.ts(now)));
            }
            alarms.setExact(0, time, pendingIntent);
        }
    }

    private static String ts(long time) {
        return new Date(time) + " (" + time + ")";
    }

    public static interface Callback {
        public void onDowntimeChanged(boolean var1);
    }
}

