/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.notification;

import android.app.Notification;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.os.SystemClock;
import android.util.Log;
import com.android.internal.logging.MetricsLogger;
import com.android.server.notification.NotificationManagerService;
import com.android.server.notification.NotificationRecord;
import java.io.PrintWriter;
import java.util.ArrayDeque;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class NotificationUsageStats {
    private static final String TAG = "NotificationUsageStats";
    private static final boolean ENABLE_AGGREGATED_IN_MEMORY_STATS = true;
    private static final boolean ENABLE_SQLITE_LOG = true;
    private static final AggregatedStats[] EMPTY_AGGREGATED_STATS = new AggregatedStats[0];
    private static final String DEVICE_GLOBAL_STATS = "__global";
    private static final int MSG_EMIT = 1;
    private static final boolean DEBUG = false;
    public static final int TEN_SECONDS = 10000;
    public static final int FOUR_HOURS = 14400000;
    private static final long EMIT_PERIOD = 14400000L;
    private final Map<String, AggregatedStats> mStats = new HashMap<String, AggregatedStats>();
    private final ArrayDeque<AggregatedStats[]> mStatsArrays = new ArrayDeque();
    private final SQLiteLog mSQLiteLog;
    private final Context mContext;
    private final Handler mHandler;
    private long mLastEmitTime;

    public NotificationUsageStats(Context context) {
        this.mContext = context;
        this.mLastEmitTime = SystemClock.elapsedRealtime();
        this.mSQLiteLog = new SQLiteLog(context);
        this.mHandler = new Handler(this.mContext.getMainLooper()){

            @Override
            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 1: {
                        NotificationUsageStats.this.emit();
                        break;
                    }
                    default: {
                        Log.wtf(NotificationUsageStats.TAG, "Unknown message type: " + msg.what);
                    }
                }
            }
        };
        this.mHandler.sendEmptyMessageDelayed(1, 14400000L);
    }

    public synchronized void registerPostedByApp(NotificationRecord notification) {
        AggregatedStats[] aggregatedStatsArray;
        notification.stats = new SingleNotificationStats();
        notification.stats.posttimeElapsedMs = SystemClock.elapsedRealtime();
        for (AggregatedStats stats : aggregatedStatsArray = this.getAggregatedStatsLocked(notification)) {
            ++stats.numPostedByApp;
            stats.countApiUse(notification);
        }
        this.releaseAggregatedStatsLocked(aggregatedStatsArray);
        this.mSQLiteLog.logPosted(notification);
    }

    public void registerUpdatedByApp(NotificationRecord notification, NotificationRecord old) {
        AggregatedStats[] aggregatedStatsArray;
        notification.stats = old.stats;
        for (AggregatedStats stats : aggregatedStatsArray = this.getAggregatedStatsLocked(notification)) {
            ++stats.numUpdatedByApp;
            stats.countApiUse(notification);
        }
        this.releaseAggregatedStatsLocked(aggregatedStatsArray);
    }

    public synchronized void registerRemovedByApp(NotificationRecord notification) {
        AggregatedStats[] aggregatedStatsArray;
        notification.stats.onRemoved();
        for (AggregatedStats stats : aggregatedStatsArray = this.getAggregatedStatsLocked(notification)) {
            ++stats.numRemovedByApp;
        }
        this.releaseAggregatedStatsLocked(aggregatedStatsArray);
        this.mSQLiteLog.logRemoved(notification);
    }

    public synchronized void registerDismissedByUser(NotificationRecord notification) {
        MetricsLogger.histogram(this.mContext, "note_dismiss_longevity", (int)(System.currentTimeMillis() - notification.getRankingTimeMs()) / 60000);
        notification.stats.onDismiss();
        this.mSQLiteLog.logDismissed(notification);
    }

    public synchronized void registerClickedByUser(NotificationRecord notification) {
        MetricsLogger.histogram(this.mContext, "note_click_longevity", (int)(System.currentTimeMillis() - notification.getRankingTimeMs()) / 60000);
        notification.stats.onClick();
        this.mSQLiteLog.logClicked(notification);
    }

    public synchronized void registerPeopleAffinity(NotificationRecord notification, boolean valid, boolean starred, boolean cached) {
        AggregatedStats[] aggregatedStatsArray;
        for (AggregatedStats stats : aggregatedStatsArray = this.getAggregatedStatsLocked(notification)) {
            if (valid) {
                ++stats.numWithValidPeople;
            }
            if (starred) {
                ++stats.numWithStaredPeople;
            }
            if (cached) {
                ++stats.numPeopleCacheHit;
                continue;
            }
            ++stats.numPeopleCacheMiss;
        }
        this.releaseAggregatedStatsLocked(aggregatedStatsArray);
    }

    public synchronized void registerBlocked(NotificationRecord notification) {
        AggregatedStats[] aggregatedStatsArray;
        for (AggregatedStats stats : aggregatedStatsArray = this.getAggregatedStatsLocked(notification)) {
            ++stats.numBlocked;
        }
        this.releaseAggregatedStatsLocked(aggregatedStatsArray);
    }

    private AggregatedStats[] getAggregatedStatsLocked(NotificationRecord record) {
        AggregatedStats[] array2 = this.mStatsArrays.poll();
        if (array2 == null) {
            array2 = new AggregatedStats[]{this.getOrCreateAggregatedStatsLocked(DEVICE_GLOBAL_STATS)};
        }
        return array2;
    }

    private void releaseAggregatedStatsLocked(AggregatedStats[] array2) {
        for (int i = 0; i < array2.length; ++i) {
            array2[i] = null;
        }
        this.mStatsArrays.offer(array2);
    }

    private AggregatedStats getOrCreateAggregatedStatsLocked(String key) {
        AggregatedStats result = this.mStats.get(key);
        if (result == null) {
            result = new AggregatedStats(this.mContext, key);
            this.mStats.put(key, result);
        }
        return result;
    }

    public synchronized JSONObject dumpJson(NotificationManagerService.DumpFilter filter) {
        JSONObject dump = new JSONObject();
        try {
            JSONArray aggregatedStats = new JSONArray();
            for (AggregatedStats as : this.mStats.values()) {
                if (filter != null && !filter.matches(as.key)) continue;
                aggregatedStats.put(as.dumpJson());
            }
            dump.put("current", aggregatedStats);
        }
        catch (JSONException e) {
            // empty catch block
        }
        try {
            dump.put("historical", this.mSQLiteLog.dumpJson(filter));
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return dump;
    }

    public synchronized void dump(PrintWriter pw, String indent, NotificationManagerService.DumpFilter filter) {
        for (AggregatedStats as : this.mStats.values()) {
            if (filter != null && !filter.matches(as.key)) continue;
            as.dump(pw, indent);
        }
        pw.println(indent + "mStatsArrays.size(): " + this.mStatsArrays.size());
        this.mSQLiteLog.dump(pw, indent, filter);
    }

    public synchronized void emit() {
        AggregatedStats stats = this.getOrCreateAggregatedStatsLocked(DEVICE_GLOBAL_STATS);
        stats.emit();
        this.mLastEmitTime = SystemClock.elapsedRealtime();
        this.mHandler.removeMessages(1);
        this.mHandler.sendEmptyMessageDelayed(1, 14400000L);
    }

    private static class SQLiteLog {
        private static final String TAG = "NotificationSQLiteLog";
        private static final int MSG_POST = 1;
        private static final int MSG_CLICK = 2;
        private static final int MSG_REMOVE = 3;
        private static final int MSG_DISMISS = 4;
        private static final String DB_NAME = "notification_log.db";
        private static final int DB_VERSION = 4;
        private static final long HORIZON_MS = 604800000L;
        private static final long PRUNE_MIN_DELAY_MS = 21600000L;
        private static final long PRUNE_MIN_WRITES = 1024L;
        private static final String TAB_LOG = "log";
        private static final String COL_EVENT_USER_ID = "event_user_id";
        private static final String COL_EVENT_TYPE = "event_type";
        private static final String COL_EVENT_TIME = "event_time_ms";
        private static final String COL_KEY = "key";
        private static final String COL_PKG = "pkg";
        private static final String COL_NOTIFICATION_ID = "nid";
        private static final String COL_TAG = "tag";
        private static final String COL_WHEN_MS = "when_ms";
        private static final String COL_DEFAULTS = "defaults";
        private static final String COL_FLAGS = "flags";
        private static final String COL_PRIORITY = "priority";
        private static final String COL_CATEGORY = "category";
        private static final String COL_ACTION_COUNT = "action_count";
        private static final String COL_POSTTIME_MS = "posttime_ms";
        private static final String COL_AIRTIME_MS = "airtime_ms";
        private static final String COL_FIRST_EXPANSIONTIME_MS = "first_expansion_time_ms";
        private static final String COL_AIRTIME_EXPANDED_MS = "expansion_airtime_ms";
        private static final String COL_EXPAND_COUNT = "expansion_count";
        private static final int EVENT_TYPE_POST = 1;
        private static final int EVENT_TYPE_CLICK = 2;
        private static final int EVENT_TYPE_REMOVE = 3;
        private static final int EVENT_TYPE_DISMISS = 4;
        private static long sLastPruneMs;
        private static long sNumWrites;
        private final SQLiteOpenHelper mHelper;
        private final Handler mWriteHandler;
        private static final long DAY_MS = 86400000L;

        public SQLiteLog(Context context) {
            HandlerThread backgroundThread = new HandlerThread("notification-sqlite-log", 10);
            backgroundThread.start();
            this.mWriteHandler = new Handler(backgroundThread.getLooper()){

                @Override
                public void handleMessage(Message msg) {
                    NotificationRecord r = (NotificationRecord)msg.obj;
                    long nowMs = System.currentTimeMillis();
                    switch (msg.what) {
                        case 1: {
                            SQLiteLog.this.writeEvent(r.sbn.getPostTime(), 1, r);
                            break;
                        }
                        case 2: {
                            SQLiteLog.this.writeEvent(nowMs, 2, r);
                            break;
                        }
                        case 3: {
                            SQLiteLog.this.writeEvent(nowMs, 3, r);
                            break;
                        }
                        case 4: {
                            SQLiteLog.this.writeEvent(nowMs, 4, r);
                            break;
                        }
                        default: {
                            Log.wtf(SQLiteLog.TAG, "Unknown message type: " + msg.what);
                        }
                    }
                }
            };
            this.mHelper = new SQLiteOpenHelper(context, DB_NAME, null, 4){

                @Override
                public void onCreate(SQLiteDatabase db) {
                    db.execSQL("CREATE TABLE log (_id INTEGER PRIMARY KEY AUTOINCREMENT,event_user_id INT,event_type INT,event_time_ms INT,key TEXT,pkg TEXT,nid INT,tag TEXT,when_ms INT,defaults INT,flags INT,priority INT,category TEXT,action_count INT,posttime_ms INT,airtime_ms INT,first_expansion_time_ms INT,expansion_airtime_ms INT,expansion_count INT)");
                }

                @Override
                public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
                    if (oldVersion <= 3) {
                        db.execSQL("DROP TABLE IF EXISTS log");
                        this.onCreate(db);
                    }
                }
            };
        }

        public void logPosted(NotificationRecord notification) {
            this.mWriteHandler.sendMessage(this.mWriteHandler.obtainMessage(1, notification));
        }

        public void logClicked(NotificationRecord notification) {
            this.mWriteHandler.sendMessage(this.mWriteHandler.obtainMessage(2, notification));
        }

        public void logRemoved(NotificationRecord notification) {
            this.mWriteHandler.sendMessage(this.mWriteHandler.obtainMessage(3, notification));
        }

        public void logDismissed(NotificationRecord notification) {
            this.mWriteHandler.sendMessage(this.mWriteHandler.obtainMessage(4, notification));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private JSONArray JsonPostFrequencies(NotificationManagerService.DumpFilter filter) throws JSONException {
            JSONArray frequencies = new JSONArray();
            SQLiteDatabase db = this.mHelper.getReadableDatabase();
            long midnight = this.getMidnightMs();
            String q = "SELECT event_user_id, pkg, CAST(((" + midnight + " - " + COL_EVENT_TIME + ") / " + 86400000L + ") AS int) " + "AS day, " + "COUNT(*) AS cnt " + "FROM " + TAB_LOG + " " + "WHERE " + COL_EVENT_TYPE + "=" + 1 + " AND " + COL_EVENT_TIME + " > " + filter.since + " GROUP BY " + COL_EVENT_USER_ID + ", day, " + COL_PKG;
            try (Cursor cursor = db.rawQuery(q, null);){
                cursor.moveToFirst();
                while (!cursor.isAfterLast()) {
                    int userId = cursor.getInt(0);
                    String pkg = cursor.getString(1);
                    if (filter == null || filter.matches(pkg)) {
                        int day = cursor.getInt(2);
                        int count = cursor.getInt(3);
                        JSONObject row = new JSONObject();
                        row.put("user_id", userId);
                        row.put("package", pkg);
                        row.put("day", day);
                        row.put("count", count);
                        frequencies.put(row);
                    }
                    cursor.moveToNext();
                }
            }
            return frequencies;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void printPostFrequencies(PrintWriter pw, String indent, NotificationManagerService.DumpFilter filter) {
            SQLiteDatabase db = this.mHelper.getReadableDatabase();
            long midnight = this.getMidnightMs();
            String q = "SELECT event_user_id, pkg, CAST(((" + midnight + " - " + COL_EVENT_TIME + ") / " + 86400000L + ") AS int) " + "AS day, " + "COUNT(*) AS cnt " + "FROM " + TAB_LOG + " " + "WHERE " + COL_EVENT_TYPE + "=" + 1 + " " + "GROUP BY " + COL_EVENT_USER_ID + ", day, " + COL_PKG;
            try (Cursor cursor = db.rawQuery(q, null);){
                cursor.moveToFirst();
                while (!cursor.isAfterLast()) {
                    int userId = cursor.getInt(0);
                    String pkg = cursor.getString(1);
                    if (filter == null || filter.matches(pkg)) {
                        int day = cursor.getInt(2);
                        int count = cursor.getInt(3);
                        pw.println(indent + "post_frequency{user_id=" + userId + ",pkg=" + pkg + ",day=" + day + ",count=" + count + "}");
                    }
                    cursor.moveToNext();
                }
            }
        }

        private long getMidnightMs() {
            GregorianCalendar midnight = new GregorianCalendar();
            midnight.set(midnight.get(1), midnight.get(2), midnight.get(5), 23, 59, 59);
            return midnight.getTimeInMillis();
        }

        private void writeEvent(long eventTimeMs, int eventType, NotificationRecord r) {
            ContentValues cv = new ContentValues();
            cv.put(COL_EVENT_USER_ID, r.sbn.getUser().getIdentifier());
            cv.put(COL_EVENT_TIME, eventTimeMs);
            cv.put(COL_EVENT_TYPE, eventType);
            SQLiteLog.putNotificationIdentifiers(r, cv);
            if (eventType == 1) {
                SQLiteLog.putNotificationDetails(r, cv);
            } else {
                SQLiteLog.putPosttimeVisibility(r, cv);
            }
            SQLiteDatabase db = this.mHelper.getWritableDatabase();
            if (db.insert(TAB_LOG, null, cv) < 0L) {
                Log.wtf(TAG, "Error while trying to insert values: " + cv);
            }
            ++sNumWrites;
            this.pruneIfNecessary(db);
        }

        private void pruneIfNecessary(SQLiteDatabase db) {
            long nowMs = System.currentTimeMillis();
            if (sNumWrites > 1024L || nowMs - sLastPruneMs > 21600000L) {
                sNumWrites = 0L;
                sLastPruneMs = nowMs;
                long horizonStartMs = nowMs - 604800000L;
                int deletedRows = db.delete(TAB_LOG, "event_time_ms < ?", new String[]{String.valueOf(horizonStartMs)});
                Log.d(TAG, "Pruned event entries: " + deletedRows);
            }
        }

        private static void putNotificationIdentifiers(NotificationRecord r, ContentValues outCv) {
            outCv.put(COL_KEY, r.sbn.getKey());
            outCv.put(COL_PKG, r.sbn.getPackageName());
        }

        private static void putNotificationDetails(NotificationRecord r, ContentValues outCv) {
            outCv.put(COL_NOTIFICATION_ID, r.sbn.getId());
            if (r.sbn.getTag() != null) {
                outCv.put(COL_TAG, r.sbn.getTag());
            }
            outCv.put(COL_WHEN_MS, r.sbn.getPostTime());
            outCv.put(COL_FLAGS, r.getNotification().flags);
            outCv.put(COL_PRIORITY, r.getNotification().priority);
            if (r.getNotification().category != null) {
                outCv.put(COL_CATEGORY, r.getNotification().category);
            }
            outCv.put(COL_ACTION_COUNT, r.getNotification().actions != null ? r.getNotification().actions.length : 0);
        }

        private static void putPosttimeVisibility(NotificationRecord r, ContentValues outCv) {
            outCv.put(COL_POSTTIME_MS, r.stats.getCurrentPosttimeMs());
            outCv.put(COL_AIRTIME_MS, r.stats.getCurrentAirtimeMs());
            outCv.put(COL_EXPAND_COUNT, r.stats.userExpansionCount);
            outCv.put(COL_AIRTIME_EXPANDED_MS, r.stats.getCurrentAirtimeExpandedMs());
            outCv.put(COL_FIRST_EXPANSIONTIME_MS, r.stats.posttimeToFirstVisibleExpansionMs);
        }

        public void dump(PrintWriter pw, String indent, NotificationManagerService.DumpFilter filter) {
            this.printPostFrequencies(pw, indent, filter);
        }

        public JSONObject dumpJson(NotificationManagerService.DumpFilter filter) {
            JSONObject dump = new JSONObject();
            try {
                dump.put("post_frequency", this.JsonPostFrequencies(filter));
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return dump;
        }
    }

    public static class Aggregate {
        long numSamples;
        double avg;
        double sum2;
        double var;

        public void addSample(long sample) {
            ++this.numSamples;
            double n = this.numSamples;
            double delta = (double)sample - this.avg;
            this.avg += 1.0 / n * delta;
            this.sum2 += (n - 1.0) / n * delta * delta;
            double divisor = this.numSamples == 1L ? 1.0 : n - 1.0;
            this.var = this.sum2 / divisor;
        }

        public String toString() {
            return "Aggregate{numSamples=" + this.numSamples + ", avg=" + this.avg + ", var=" + this.var + '}';
        }
    }

    public static class SingleNotificationStats {
        private boolean isVisible = false;
        private boolean isExpanded = false;
        public long posttimeElapsedMs = -1L;
        public long posttimeToFirstClickMs = -1L;
        public long posttimeToDismissMs = -1L;
        public long airtimeCount = 0L;
        public long posttimeToFirstAirtimeMs = -1L;
        public long currentAirtimeStartElapsedMs = -1L;
        public long airtimeMs = 0L;
        public long posttimeToFirstVisibleExpansionMs = -1L;
        public long currentAirtimeExpandedStartElapsedMs = -1L;
        public long airtimeExpandedMs = 0L;
        public long userExpansionCount = 0L;

        public long getCurrentPosttimeMs() {
            if (this.posttimeElapsedMs < 0L) {
                return 0L;
            }
            return SystemClock.elapsedRealtime() - this.posttimeElapsedMs;
        }

        public long getCurrentAirtimeMs() {
            long result = this.airtimeMs;
            if (this.currentAirtimeStartElapsedMs >= 0L) {
                result += SystemClock.elapsedRealtime() - this.currentAirtimeStartElapsedMs;
            }
            return result;
        }

        public long getCurrentAirtimeExpandedMs() {
            long result = this.airtimeExpandedMs;
            if (this.currentAirtimeExpandedStartElapsedMs >= 0L) {
                result += SystemClock.elapsedRealtime() - this.currentAirtimeExpandedStartElapsedMs;
            }
            return result;
        }

        public void onClick() {
            if (this.posttimeToFirstClickMs < 0L) {
                this.posttimeToFirstClickMs = SystemClock.elapsedRealtime() - this.posttimeElapsedMs;
            }
        }

        public void onDismiss() {
            if (this.posttimeToDismissMs < 0L) {
                this.posttimeToDismissMs = SystemClock.elapsedRealtime() - this.posttimeElapsedMs;
            }
            this.finish();
        }

        public void onCancel() {
            this.finish();
        }

        public void onRemoved() {
            this.finish();
        }

        public void onVisibilityChanged(boolean visible) {
            long elapsedNowMs = SystemClock.elapsedRealtime();
            boolean wasVisible = this.isVisible;
            this.isVisible = visible;
            if (visible) {
                if (this.currentAirtimeStartElapsedMs < 0L) {
                    ++this.airtimeCount;
                    this.currentAirtimeStartElapsedMs = elapsedNowMs;
                }
                if (this.posttimeToFirstAirtimeMs < 0L) {
                    this.posttimeToFirstAirtimeMs = elapsedNowMs - this.posttimeElapsedMs;
                }
            } else if (this.currentAirtimeStartElapsedMs >= 0L) {
                this.airtimeMs += elapsedNowMs - this.currentAirtimeStartElapsedMs;
                this.currentAirtimeStartElapsedMs = -1L;
            }
            if (wasVisible != this.isVisible) {
                this.updateVisiblyExpandedStats();
            }
        }

        public void onExpansionChanged(boolean userAction, boolean expanded) {
            this.isExpanded = expanded;
            if (this.isExpanded && userAction) {
                ++this.userExpansionCount;
            }
            this.updateVisiblyExpandedStats();
        }

        private void updateVisiblyExpandedStats() {
            long elapsedNowMs = SystemClock.elapsedRealtime();
            if (this.isExpanded && this.isVisible) {
                if (this.currentAirtimeExpandedStartElapsedMs < 0L) {
                    this.currentAirtimeExpandedStartElapsedMs = elapsedNowMs;
                }
                if (this.posttimeToFirstVisibleExpansionMs < 0L) {
                    this.posttimeToFirstVisibleExpansionMs = elapsedNowMs - this.posttimeElapsedMs;
                }
            } else if (this.currentAirtimeExpandedStartElapsedMs >= 0L) {
                this.airtimeExpandedMs += elapsedNowMs - this.currentAirtimeExpandedStartElapsedMs;
                this.currentAirtimeExpandedStartElapsedMs = -1L;
            }
        }

        public void finish() {
            this.onVisibilityChanged(false);
        }

        public String toString() {
            return "SingleNotificationStats{posttimeElapsedMs=" + this.posttimeElapsedMs + ", posttimeToFirstClickMs=" + this.posttimeToFirstClickMs + ", posttimeToDismissMs=" + this.posttimeToDismissMs + ", airtimeCount=" + this.airtimeCount + ", airtimeMs=" + this.airtimeMs + ", currentAirtimeStartElapsedMs=" + this.currentAirtimeStartElapsedMs + ", airtimeExpandedMs=" + this.airtimeExpandedMs + ", posttimeToFirstVisibleExpansionMs=" + this.posttimeToFirstVisibleExpansionMs + ", currentAirtimeExpandedSEMs=" + this.currentAirtimeExpandedStartElapsedMs + '}';
        }
    }

    private static class AggregatedStats {
        private final Context mContext;
        public final String key;
        private final long mCreated;
        private AggregatedStats mPrevious;
        public int numPostedByApp;
        public int numUpdatedByApp;
        public int numRemovedByApp;
        public int numPeopleCacheHit;
        public int numPeopleCacheMiss;
        public int numWithStaredPeople;
        public int numWithValidPeople;
        public int numBlocked;
        public int numWithActions;
        public int numPrivate;
        public int numSecret;
        public int numPriorityMax;
        public int numPriorityHigh;
        public int numPriorityLow;
        public int numPriorityMin;
        public int numWithBigText;
        public int numWithBigPicture;
        public int numForegroundService;
        public int numOngoing;
        public int numAutoCancel;
        public int numWithLargeIcon;
        public int numWithInbox;
        public int numWithMediaSession;
        public int numWithTitle;
        public int numWithText;
        public int numWithSubText;
        public int numWithInfoText;
        public int numInterrupt;

        public AggregatedStats(Context context, String key) {
            this.key = key;
            this.mContext = context;
            this.mCreated = SystemClock.elapsedRealtime();
        }

        public void countApiUse(NotificationRecord record) {
            Notification n = record.getNotification();
            if (n.actions != null) {
                ++this.numWithActions;
            }
            if ((n.flags & 0x40) != 0) {
                ++this.numForegroundService;
            }
            if ((n.flags & 2) != 0) {
                ++this.numOngoing;
            }
            if ((n.flags & 0x10) != 0) {
                ++this.numAutoCancel;
            }
            if ((n.defaults & 1) != 0 || (n.defaults & 2) != 0 || n.sound != null || n.vibrate != null) {
                ++this.numInterrupt;
            }
            switch (n.visibility) {
                case 0: {
                    ++this.numPrivate;
                    break;
                }
                case -1: {
                    ++this.numSecret;
                }
            }
            switch (n.priority) {
                case 2: {
                    ++this.numPriorityMax;
                    break;
                }
                case 1: {
                    ++this.numPriorityHigh;
                    break;
                }
                case -1: {
                    ++this.numPriorityLow;
                    break;
                }
                case -2: {
                    ++this.numPriorityMin;
                }
            }
            for (String Key2 : n.extras.keySet()) {
                if ("android.bigText".equals(this.key)) {
                    ++this.numWithBigText;
                    continue;
                }
                if ("android.picture".equals(this.key)) {
                    ++this.numWithBigPicture;
                    continue;
                }
                if ("android.largeIcon".equals(this.key)) {
                    ++this.numWithLargeIcon;
                    continue;
                }
                if ("android.textLines".equals(this.key)) {
                    ++this.numWithInbox;
                    continue;
                }
                if ("android.mediaSession".equals(this.key)) {
                    ++this.numWithMediaSession;
                    continue;
                }
                if ("android.title".equals(this.key)) {
                    ++this.numWithTitle;
                    continue;
                }
                if ("android.text".equals(this.key)) {
                    ++this.numWithText;
                    continue;
                }
                if ("android.subText".equals(this.key)) {
                    ++this.numWithSubText;
                    continue;
                }
                if (!"android.infoText".equals(this.key)) continue;
                ++this.numWithInfoText;
            }
        }

        public void emit() {
            if (this.mPrevious == null) {
                this.mPrevious = new AggregatedStats(null, this.key);
            }
            this.maybeCount("note_post", this.numPostedByApp - this.mPrevious.numPostedByApp);
            this.maybeCount("note_update", this.numUpdatedByApp - this.mPrevious.numUpdatedByApp);
            this.maybeCount("note_remove", this.numRemovedByApp - this.mPrevious.numRemovedByApp);
            this.maybeCount("note_with_people", this.numWithValidPeople - this.mPrevious.numWithValidPeople);
            this.maybeCount("note_with_stars", this.numWithStaredPeople - this.mPrevious.numWithStaredPeople);
            this.maybeCount("people_cache_hit", this.numPeopleCacheHit - this.mPrevious.numPeopleCacheHit);
            this.maybeCount("people_cache_miss", this.numPeopleCacheMiss - this.mPrevious.numPeopleCacheMiss);
            this.maybeCount("note_blocked", this.numBlocked - this.mPrevious.numBlocked);
            this.maybeCount("note_with_actions", this.numWithActions - this.mPrevious.numWithActions);
            this.maybeCount("note_private", this.numPrivate - this.mPrevious.numPrivate);
            this.maybeCount("note_secret", this.numSecret - this.mPrevious.numSecret);
            this.maybeCount("note_prio_max", this.numPriorityMax - this.mPrevious.numPriorityMax);
            this.maybeCount("note_prio_high", this.numPriorityHigh - this.mPrevious.numPriorityHigh);
            this.maybeCount("note_prio_low", this.numPriorityLow - this.mPrevious.numPriorityLow);
            this.maybeCount("note_prio_min", this.numPriorityMin - this.mPrevious.numPriorityMin);
            this.maybeCount("note_interupt", this.numInterrupt - this.mPrevious.numInterrupt);
            this.maybeCount("note_big_text", this.numWithBigText - this.mPrevious.numWithBigText);
            this.maybeCount("note_big_pic", this.numWithBigPicture - this.mPrevious.numWithBigPicture);
            this.maybeCount("note_fg", this.numForegroundService - this.mPrevious.numForegroundService);
            this.maybeCount("note_ongoing", this.numOngoing - this.mPrevious.numOngoing);
            this.maybeCount("note_auto", this.numAutoCancel - this.mPrevious.numAutoCancel);
            this.maybeCount("note_large_icon", this.numWithLargeIcon - this.mPrevious.numWithLargeIcon);
            this.maybeCount("note_inbox", this.numWithInbox - this.mPrevious.numWithInbox);
            this.maybeCount("note_media", this.numWithMediaSession - this.mPrevious.numWithMediaSession);
            this.maybeCount("note_title", this.numWithTitle - this.mPrevious.numWithTitle);
            this.maybeCount("note_text", this.numWithText - this.mPrevious.numWithText);
            this.maybeCount("note_sub_text", this.numWithSubText - this.mPrevious.numWithSubText);
            this.maybeCount("note_info_text", this.numWithInfoText - this.mPrevious.numWithInfoText);
            this.mPrevious.numPostedByApp = this.numPostedByApp;
            this.mPrevious.numUpdatedByApp = this.numUpdatedByApp;
            this.mPrevious.numRemovedByApp = this.numRemovedByApp;
            this.mPrevious.numPeopleCacheHit = this.numPeopleCacheHit;
            this.mPrevious.numPeopleCacheMiss = this.numPeopleCacheMiss;
            this.mPrevious.numWithStaredPeople = this.numWithStaredPeople;
            this.mPrevious.numWithValidPeople = this.numWithValidPeople;
            this.mPrevious.numBlocked = this.numBlocked;
            this.mPrevious.numWithActions = this.numWithActions;
            this.mPrevious.numPrivate = this.numPrivate;
            this.mPrevious.numSecret = this.numSecret;
            this.mPrevious.numPriorityMax = this.numPriorityMax;
            this.mPrevious.numPriorityHigh = this.numPriorityHigh;
            this.mPrevious.numPriorityLow = this.numPriorityLow;
            this.mPrevious.numPriorityMin = this.numPriorityMin;
            this.mPrevious.numInterrupt = this.numInterrupt;
            this.mPrevious.numWithBigText = this.numWithBigText;
            this.mPrevious.numWithBigPicture = this.numWithBigPicture;
            this.mPrevious.numForegroundService = this.numForegroundService;
            this.mPrevious.numOngoing = this.numOngoing;
            this.mPrevious.numAutoCancel = this.numAutoCancel;
            this.mPrevious.numWithLargeIcon = this.numWithLargeIcon;
            this.mPrevious.numWithInbox = this.numWithInbox;
            this.mPrevious.numWithMediaSession = this.numWithMediaSession;
            this.mPrevious.numWithTitle = this.numWithTitle;
            this.mPrevious.numWithText = this.numWithText;
            this.mPrevious.numWithSubText = this.numWithSubText;
            this.mPrevious.numWithInfoText = this.numWithInfoText;
        }

        void maybeCount(String name, int value) {
            if (value > 0) {
                MetricsLogger.count(this.mContext, name, value);
            }
        }

        public void dump(PrintWriter pw, String indent) {
            pw.println(this.toStringWithIndent(indent));
        }

        public String toString() {
            return this.toStringWithIndent("");
        }

        private String toStringWithIndent(String indent) {
            return indent + "AggregatedStats{\n" + indent + "  key='" + this.key + "',\n" + indent + "  numPostedByApp=" + this.numPostedByApp + ",\n" + indent + "  numUpdatedByApp=" + this.numUpdatedByApp + ",\n" + indent + "  numRemovedByApp=" + this.numRemovedByApp + ",\n" + indent + "  numPeopleCacheHit=" + this.numPeopleCacheHit + ",\n" + indent + "  numWithStaredPeople=" + this.numWithStaredPeople + ",\n" + indent + "  numWithValidPeople=" + this.numWithValidPeople + ",\n" + indent + "  numPeopleCacheMiss=" + this.numPeopleCacheMiss + ",\n" + indent + "  numBlocked=" + this.numBlocked + ",\n" + indent + "}";
        }

        public JSONObject dumpJson() throws JSONException {
            JSONObject dump = new JSONObject();
            dump.put("key", this.key);
            dump.put("duration", SystemClock.elapsedRealtime() - this.mCreated);
            this.maybePut(dump, "numPostedByApp", this.numPostedByApp);
            this.maybePut(dump, "numUpdatedByApp", this.numUpdatedByApp);
            this.maybePut(dump, "numRemovedByApp", this.numRemovedByApp);
            this.maybePut(dump, "numPeopleCacheHit", this.numPeopleCacheHit);
            this.maybePut(dump, "numPeopleCacheMiss", this.numPeopleCacheMiss);
            this.maybePut(dump, "numWithStaredPeople", this.numWithStaredPeople);
            this.maybePut(dump, "numWithValidPeople", this.numWithValidPeople);
            this.maybePut(dump, "numBlocked", this.numBlocked);
            this.maybePut(dump, "numWithActions", this.numWithActions);
            this.maybePut(dump, "numPrivate", this.numPrivate);
            this.maybePut(dump, "numSecret", this.numSecret);
            this.maybePut(dump, "numPriorityMax", this.numPriorityMax);
            this.maybePut(dump, "numPriorityHigh", this.numPriorityHigh);
            this.maybePut(dump, "numPriorityLow", this.numPriorityLow);
            this.maybePut(dump, "numPriorityMin", this.numPriorityMin);
            this.maybePut(dump, "numInterrupt", this.numInterrupt);
            this.maybePut(dump, "numWithBigText", this.numWithBigText);
            this.maybePut(dump, "numWithBigPicture", this.numWithBigPicture);
            this.maybePut(dump, "numForegroundService", this.numForegroundService);
            this.maybePut(dump, "numOngoing", this.numOngoing);
            this.maybePut(dump, "numAutoCancel", this.numAutoCancel);
            this.maybePut(dump, "numWithLargeIcon", this.numWithLargeIcon);
            this.maybePut(dump, "numWithInbox", this.numWithInbox);
            this.maybePut(dump, "numWithMediaSession", this.numWithMediaSession);
            this.maybePut(dump, "numWithTitle", this.numWithTitle);
            this.maybePut(dump, "numWithText", this.numWithText);
            this.maybePut(dump, "numWithSubText", this.numWithSubText);
            this.maybePut(dump, "numWithInfoText", this.numWithInfoText);
            return dump;
        }

        private void maybePut(JSONObject dump, String name, int value) throws JSONException {
            if (value > 0) {
                dump.put(name, value);
            }
        }
    }
}

