/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.notification;

import android.app.Notification;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Handler;
import android.os.Message;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Slog;
import com.android.server.notification.GlobalSortKeyComparator;
import com.android.server.notification.NotificationComparator;
import com.android.server.notification.NotificationManagerService;
import com.android.server.notification.NotificationRecord;
import com.android.server.notification.NotificationSignalExtractor;
import com.android.server.notification.NotificationUsageStats;
import com.android.server.notification.RankingConfig;
import com.android.server.notification.RankingReconsideration;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class RankingHelper
implements RankingConfig {
    private static final String TAG = "RankingHelper";
    private static final int XML_VERSION = 1;
    private static final String TAG_RANKING = "ranking";
    private static final String TAG_PACKAGE = "package";
    private static final String ATT_VERSION = "version";
    private static final String ATT_NAME = "name";
    private static final String ATT_UID = "uid";
    private static final String ATT_PRIORITY = "priority";
    private static final String ATT_PEEKABLE = "peekable";
    private static final String ATT_VISIBILITY = "visibility";
    private static final int DEFAULT_PRIORITY = 0;
    private static final boolean DEFAULT_PEEKABLE = true;
    private static final int DEFAULT_VISIBILITY = -1000;
    private final NotificationSignalExtractor[] mSignalExtractors;
    private final NotificationComparator mPreliminaryComparator = new NotificationComparator();
    private final GlobalSortKeyComparator mFinalComparator = new GlobalSortKeyComparator();
    private final ArrayMap<String, Record> mRecords = new ArrayMap();
    private final ArrayMap<String, NotificationRecord> mProxyByGroupTmp = new ArrayMap();
    private final ArrayMap<String, Record> mRestoredWithoutUids = new ArrayMap();
    private final Context mContext;
    private final Handler mRankingHandler;

    public RankingHelper(Context context, Handler rankingHandler, NotificationUsageStats usageStats, String[] extractorNames) {
        this.mContext = context;
        this.mRankingHandler = rankingHandler;
        int N = extractorNames.length;
        this.mSignalExtractors = new NotificationSignalExtractor[N];
        for (int i = 0; i < N; ++i) {
            try {
                Class<?> extractorClass = this.mContext.getClassLoader().loadClass(extractorNames[i]);
                NotificationSignalExtractor extractor = (NotificationSignalExtractor)extractorClass.newInstance();
                extractor.initialize(this.mContext, usageStats);
                extractor.setConfig(this);
                this.mSignalExtractors[i] = extractor;
                continue;
            }
            catch (ClassNotFoundException e) {
                Slog.w(TAG, "Couldn't find extractor " + extractorNames[i] + ".", e);
                continue;
            }
            catch (InstantiationException e) {
                Slog.w(TAG, "Couldn't instantiate extractor " + extractorNames[i] + ".", e);
                continue;
            }
            catch (IllegalAccessException e) {
                Slog.w(TAG, "Problem accessing extractor " + extractorNames[i] + ".", e);
            }
        }
    }

    public <T extends NotificationSignalExtractor> T findExtractor(Class<T> extractorClass) {
        for (NotificationSignalExtractor extractor : this.mSignalExtractors) {
            if (!extractorClass.equals(extractor.getClass())) continue;
            return (T)extractor;
        }
        return null;
    }

    public void extractSignals(NotificationRecord r) {
        for (NotificationSignalExtractor extractor : this.mSignalExtractors) {
            try {
                RankingReconsideration recon = extractor.process(r);
                if (recon == null) continue;
                Message m = Message.obtain(this.mRankingHandler, 4, recon);
                long delay = recon.getDelay(TimeUnit.MILLISECONDS);
                this.mRankingHandler.sendMessageDelayed(m, delay);
            }
            catch (Throwable t) {
                Slog.w(TAG, "NotificationSignalExtractor failed.", t);
            }
        }
    }

    public void readXml(XmlPullParser parser, boolean forRestore) throws XmlPullParserException, IOException {
        PackageManager pm = this.mContext.getPackageManager();
        int type = parser.getEventType();
        if (type != 2) {
            return;
        }
        String tag = parser.getName();
        if (!TAG_RANKING.equals(tag)) {
            return;
        }
        this.mRecords.clear();
        this.mRestoredWithoutUids.clear();
        while ((type = parser.next()) != 1) {
            tag = parser.getName();
            if (type == 3 && TAG_RANKING.equals(tag)) {
                return;
            }
            if (type != 2 || !TAG_PACKAGE.equals(tag)) continue;
            int uid = RankingHelper.safeInt(parser, ATT_UID, Record.UNKNOWN_UID);
            int priority = RankingHelper.safeInt(parser, ATT_PRIORITY, 0);
            boolean peekable = RankingHelper.safeBool(parser, ATT_PEEKABLE, true);
            int vis = RankingHelper.safeInt(parser, ATT_VISIBILITY, -1000);
            String name = parser.getAttributeValue(null, ATT_NAME);
            if (TextUtils.isEmpty(name)) continue;
            if (forRestore) {
                try {
                    uid = pm.getPackageUid(name, 0);
                }
                catch (PackageManager.NameNotFoundException e) {
                    // empty catch block
                }
            }
            Record r = null;
            if (uid == Record.UNKNOWN_UID) {
                r = this.mRestoredWithoutUids.get(name);
                if (r == null) {
                    r = new Record();
                    this.mRestoredWithoutUids.put(name, r);
                }
            } else {
                r = this.getOrCreateRecord(name, uid);
            }
            if (priority != 0) {
                r.priority = priority;
            }
            if (!peekable) {
                r.peekable = peekable;
            }
            if (vis == -1000) continue;
            r.visibility = vis;
        }
        throw new IllegalStateException("Failed to reach END_DOCUMENT");
    }

    private static String recordKey(String pkg, int uid) {
        return pkg + "|" + uid;
    }

    private Record getOrCreateRecord(String pkg, int uid) {
        String key = RankingHelper.recordKey(pkg, uid);
        Record r = this.mRecords.get(key);
        if (r == null) {
            r = new Record();
            r.pkg = pkg;
            r.uid = uid;
            this.mRecords.put(key, r);
        }
        return r;
    }

    private void removeDefaultRecords() {
        int N = this.mRecords.size();
        for (int i = N - 1; i >= 0; --i) {
            Record r = this.mRecords.valueAt(i);
            if (r.priority != 0 || !r.peekable || r.visibility != -1000) continue;
            this.mRecords.remove(i);
        }
    }

    public void writeXml(XmlSerializer out, boolean forBackup) throws IOException {
        out.startTag(null, TAG_RANKING);
        out.attribute(null, ATT_VERSION, Integer.toString(1));
        int N = this.mRecords.size();
        for (int i = 0; i < N; ++i) {
            Record r = this.mRecords.valueAt(i);
            if (forBackup && UserHandle.getUserId(r.uid) != 0) continue;
            out.startTag(null, TAG_PACKAGE);
            out.attribute(null, ATT_NAME, r.pkg);
            if (r.priority != 0) {
                out.attribute(null, ATT_PRIORITY, Integer.toString(r.priority));
            }
            if (!r.peekable) {
                out.attribute(null, ATT_PEEKABLE, Boolean.toString(r.peekable));
            }
            if (r.visibility != -1000) {
                out.attribute(null, ATT_VISIBILITY, Integer.toString(r.visibility));
            }
            if (!forBackup) {
                out.attribute(null, ATT_UID, Integer.toString(r.uid));
            }
            out.endTag(null, TAG_PACKAGE);
        }
        out.endTag(null, TAG_RANKING);
    }

    private void updateConfig() {
        int N = this.mSignalExtractors.length;
        for (int i = 0; i < N; ++i) {
            this.mSignalExtractors[i].setConfig(this);
        }
        this.mRankingHandler.sendEmptyMessage(5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort(ArrayList<NotificationRecord> notificationList) {
        int N = notificationList.size();
        for (int i = N - 1; i >= 0; --i) {
            notificationList.get(i).setGlobalSortKey(null);
        }
        Collections.sort(notificationList, this.mPreliminaryComparator);
        ArrayMap<String, NotificationRecord> arrayMap = this.mProxyByGroupTmp;
        synchronized (arrayMap) {
            NotificationRecord record;
            int i;
            for (i = N - 1; i >= 0; --i) {
                record = notificationList.get(i);
                record.setAuthoritativeRank(i);
                String groupKey = record.getGroupKey();
                boolean isGroupSummary = record.getNotification().isGroupSummary();
                if (!isGroupSummary && this.mProxyByGroupTmp.containsKey(groupKey)) continue;
                this.mProxyByGroupTmp.put(groupKey, record);
            }
            for (i = 0; i < N; ++i) {
                record = notificationList.get(i);
                NotificationRecord groupProxy = this.mProxyByGroupTmp.get(record.getGroupKey());
                String groupSortKey = record.getNotification().getSortKey();
                String groupSortKeyPortion = groupSortKey == null ? "nsk" : (groupSortKey.equals("") ? "esk" : "gsk=" + groupSortKey);
                boolean isGroupSummary = record.getNotification().isGroupSummary();
                record.setGlobalSortKey(String.format("intrsv=%c:grnk=0x%04x:gsmry=%c:%s:rnk=0x%04x", Character.valueOf(record.isRecentlyIntrusive() ? (char)'0' : '1'), groupProxy.getAuthoritativeRank(), Character.valueOf(isGroupSummary ? (char)'0' : '1'), groupSortKeyPortion, record.getAuthoritativeRank()));
            }
            this.mProxyByGroupTmp.clear();
        }
        Collections.sort(notificationList, this.mFinalComparator);
    }

    public int indexOf(ArrayList<NotificationRecord> notificationList, NotificationRecord target) {
        return Collections.binarySearch(notificationList, target, this.mFinalComparator);
    }

    private static int safeInt(XmlPullParser parser, String att, int defValue) {
        String val = parser.getAttributeValue(null, att);
        return RankingHelper.tryParseInt(val, defValue);
    }

    private static int tryParseInt(String value, int defValue) {
        if (TextUtils.isEmpty(value)) {
            return defValue;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            return defValue;
        }
    }

    private static boolean safeBool(XmlPullParser parser, String att, boolean defValue) {
        String val = parser.getAttributeValue(null, att);
        return RankingHelper.tryParseBool(val, defValue);
    }

    private static boolean tryParseBool(String value, boolean defValue) {
        if (TextUtils.isEmpty(value)) {
            return defValue;
        }
        return Boolean.valueOf(value);
    }

    @Override
    public int getPackagePriority(String packageName, int uid) {
        Record r = this.mRecords.get(RankingHelper.recordKey(packageName, uid));
        return r != null ? r.priority : 0;
    }

    @Override
    public void setPackagePriority(String packageName, int uid, int priority) {
        if (priority == this.getPackagePriority(packageName, uid)) {
            return;
        }
        this.getOrCreateRecord((String)packageName, (int)uid).priority = priority;
        this.removeDefaultRecords();
        this.updateConfig();
    }

    @Override
    public boolean getPackagePeekable(String packageName, int uid) {
        Record r = this.mRecords.get(RankingHelper.recordKey(packageName, uid));
        return r != null ? r.peekable : true;
    }

    @Override
    public void setPackagePeekable(String packageName, int uid, boolean peekable) {
        if (peekable == this.getPackagePeekable(packageName, uid)) {
            return;
        }
        this.getOrCreateRecord((String)packageName, (int)uid).peekable = peekable;
        this.removeDefaultRecords();
        this.updateConfig();
    }

    @Override
    public int getPackageVisibilityOverride(String packageName, int uid) {
        Record r = this.mRecords.get(RankingHelper.recordKey(packageName, uid));
        return r != null ? r.visibility : -1000;
    }

    @Override
    public void setPackageVisibilityOverride(String packageName, int uid, int visibility) {
        if (visibility == this.getPackageVisibilityOverride(packageName, uid)) {
            return;
        }
        this.getOrCreateRecord((String)packageName, (int)uid).visibility = visibility;
        this.removeDefaultRecords();
        this.updateConfig();
    }

    public void dump(PrintWriter pw, String prefix, NotificationManagerService.DumpFilter filter) {
        if (filter == null) {
            int N = this.mSignalExtractors.length;
            pw.print(prefix);
            pw.print("mSignalExtractors.length = ");
            pw.println(N);
            for (int i = 0; i < N; ++i) {
                pw.print(prefix);
                pw.print("  ");
                pw.println(this.mSignalExtractors[i]);
            }
        }
        if (filter == null) {
            pw.print(prefix);
            pw.println("per-package config:");
        }
        RankingHelper.dumpRecords(pw, prefix, filter, this.mRecords);
        RankingHelper.dumpRecords(pw, prefix, filter, this.mRestoredWithoutUids);
    }

    private static void dumpRecords(PrintWriter pw, String prefix, NotificationManagerService.DumpFilter filter, ArrayMap<String, Record> records) {
        int N = records.size();
        for (int i = 0; i < N; ++i) {
            Record r = records.valueAt(i);
            if (filter != null && !filter.matches(r.pkg)) continue;
            pw.print(prefix);
            pw.print("  ");
            pw.print(r.pkg);
            pw.print(" (");
            pw.print(r.uid == Record.UNKNOWN_UID ? "UNKNOWN_UID" : Integer.toString(r.uid));
            pw.print(')');
            if (r.priority != 0) {
                pw.print(" priority=");
                pw.print(Notification.priorityToString(r.priority));
            }
            if (!r.peekable) {
                pw.print(" peekable=");
                pw.print(r.peekable);
            }
            if (r.visibility != -1000) {
                pw.print(" visibility=");
                pw.print(Notification.visibilityToString(r.visibility));
            }
            pw.println();
        }
    }

    public void onPackagesChanged(boolean queryReplace, String[] pkgList) {
        if (queryReplace || pkgList == null || pkgList.length == 0 || this.mRestoredWithoutUids.isEmpty()) {
            return;
        }
        PackageManager pm = this.mContext.getPackageManager();
        boolean updated = false;
        for (String pkg : pkgList) {
            Record r = this.mRestoredWithoutUids.get(pkg);
            if (r == null) continue;
            try {
                r.uid = pm.getPackageUid(r.pkg, 0);
                this.mRestoredWithoutUids.remove(pkg);
                this.mRecords.put(RankingHelper.recordKey(r.pkg, r.uid), r);
                updated = true;
            }
            catch (PackageManager.NameNotFoundException e) {
                // empty catch block
            }
        }
        if (updated) {
            this.updateConfig();
        }
    }

    private static class Record {
        static int UNKNOWN_UID = -10000;
        String pkg;
        int uid = UNKNOWN_UID;
        int priority = 0;
        boolean peekable = true;
        int visibility = -1000;

        private Record() {
        }
    }
}

