/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.notification;

import android.app.AppOpsManager;
import android.app.NotificationManager;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.database.ContentObserver;
import android.media.AudioManagerInternal;
import android.media.VolumePolicy;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.os.UserHandle;
import android.provider.Settings;
import android.service.notification.IConditionListener;
import android.service.notification.ZenModeConfig;
import android.util.ArraySet;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.logging.MetricsLogger;
import com.android.server.LocalServices;
import com.android.server.notification.ConditionProviders;
import com.android.server.notification.NotificationRecord;
import com.android.server.notification.ValidateNotificationPeople;
import com.android.server.notification.ZenLog;
import com.android.server.notification.ZenModeConditions;
import com.android.server.notification.ZenModeFiltering;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Objects;
import libcore.io.IoUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class ZenModeHelper {
    static final String TAG = "ZenModeHelper";
    static final boolean DEBUG = Log.isLoggable("ZenModeHelper", 3);
    private final Context mContext;
    private final H mHandler;
    private final SettingsObserver mSettingsObserver;
    private final AppOpsManager mAppOps;
    private final ZenModeConfig mDefaultConfig;
    private final ArrayList<Callback> mCallbacks = new ArrayList();
    private final ZenModeFiltering mFiltering;
    private final RingerModeDelegate mRingerModeDelegate = new RingerModeDelegate();
    private final ZenModeConditions mConditions;
    private final SparseArray<ZenModeConfig> mConfigs = new SparseArray();
    private final Metrics mMetrics = new Metrics();
    private int mZenMode;
    private int mUser = 0;
    private ZenModeConfig mConfig;
    private AudioManagerInternal mAudioManager;
    private boolean mEffectsSuppressed;
    private final ZenModeConfig.Migration mConfigMigration = new ZenModeConfig.Migration(){

        @Override
        public ZenModeConfig migrate(ZenModeConfig.XmlV1 v1) {
            if (v1 == null) {
                return null;
            }
            ZenModeConfig rt = new ZenModeConfig();
            rt.allowCalls = v1.allowCalls;
            rt.allowEvents = v1.allowEvents;
            rt.allowCallsFrom = v1.allowFrom;
            rt.allowMessages = v1.allowMessages;
            rt.allowMessagesFrom = v1.allowFrom;
            rt.allowReminders = v1.allowReminders;
            int[] days = ZenModeConfig.XmlV1.tryParseDays(v1.sleepMode);
            if (days != null && days.length > 0) {
                Log.i(ZenModeHelper.TAG, "Migrating existing V1 downtime to single schedule");
                ZenModeConfig.ScheduleInfo schedule = new ZenModeConfig.ScheduleInfo();
                schedule.days = days;
                schedule.startHour = v1.sleepStartHour;
                schedule.startMinute = v1.sleepStartMinute;
                schedule.endHour = v1.sleepEndHour;
                schedule.endMinute = v1.sleepEndMinute;
                ZenModeConfig.ZenRule rule = new ZenModeConfig.ZenRule();
                rule.enabled = true;
                rule.name = ZenModeHelper.this.mContext.getResources().getString(17040759);
                rule.conditionId = ZenModeConfig.toScheduleConditionId(schedule);
                rule.zenMode = v1.sleepNone ? 2 : 1;
                rt.automaticRules.put(rt.newRuleId(), rule);
            } else {
                Log.i(ZenModeHelper.TAG, "No existing V1 downtime found, generating default schedules");
                ZenModeHelper.this.appendDefaultScheduleRules(rt);
            }
            ZenModeHelper.this.appendDefaultEventRules(rt);
            return rt;
        }
    };

    public ZenModeHelper(Context context, Looper looper, ConditionProviders conditionProviders) {
        this.mContext = context;
        this.mHandler = new H(looper);
        this.addCallback(this.mMetrics);
        this.mAppOps = (AppOpsManager)context.getSystemService("appops");
        this.mDefaultConfig = this.readDefaultConfig(context.getResources());
        this.appendDefaultScheduleRules(this.mDefaultConfig);
        this.appendDefaultEventRules(this.mDefaultConfig);
        this.mConfig = this.mDefaultConfig;
        this.mConfigs.put(0, this.mConfig);
        this.mSettingsObserver = new SettingsObserver(this.mHandler);
        this.mSettingsObserver.observe();
        this.mFiltering = new ZenModeFiltering(this.mContext);
        this.mConditions = new ZenModeConditions(this, conditionProviders);
    }

    public Looper getLooper() {
        return this.mHandler.getLooper();
    }

    public String toString() {
        return TAG;
    }

    public boolean matchesCallFilter(UserHandle userHandle, Bundle extras, ValidateNotificationPeople validator, int contactsTimeoutMs, float timeoutAffinity) {
        return ZenModeFiltering.matchesCallFilter(this.mContext, this.mZenMode, this.mConfig, userHandle, extras, validator, contactsTimeoutMs, timeoutAffinity);
    }

    public boolean isCall(NotificationRecord record) {
        return this.mFiltering.isCall(record);
    }

    public boolean shouldIntercept(NotificationRecord record) {
        return this.mFiltering.shouldIntercept(this.mZenMode, this.mConfig, record);
    }

    public void addCallback(Callback callback) {
        this.mCallbacks.add(callback);
    }

    public void removeCallback(Callback callback) {
        this.mCallbacks.remove(callback);
    }

    public void initZenMode() {
        if (DEBUG) {
            Log.d(TAG, "initZenMode");
        }
        this.evaluateZenMode("init", true);
    }

    public void onSystemReady() {
        if (DEBUG) {
            Log.d(TAG, "onSystemReady");
        }
        this.mAudioManager = LocalServices.getService(AudioManagerInternal.class);
        if (this.mAudioManager != null) {
            this.mAudioManager.setRingerModeDelegate(this.mRingerModeDelegate);
        }
        this.mHandler.postMetricsTimer();
    }

    public void onUserSwitched(int user) {
        ZenModeConfig config;
        if (this.mUser == user || user < 0) {
            return;
        }
        this.mUser = user;
        if (DEBUG) {
            Log.d(TAG, "onUserSwitched u=" + user);
        }
        if ((config = this.mConfigs.get(user)) == null) {
            if (DEBUG) {
                Log.d(TAG, "onUserSwitched: generating default config for user " + user);
            }
            config = this.mDefaultConfig.copy();
            config.user = user;
        }
        this.setConfig(config, "onUserSwitched");
    }

    public void onUserRemoved(int user) {
        if (user < 0) {
            return;
        }
        if (DEBUG) {
            Log.d(TAG, "onUserRemoved u=" + user);
        }
        this.mConfigs.remove(user);
    }

    public void requestZenModeConditions(IConditionListener callback, int relevance) {
        this.mConditions.requestConditions(callback, relevance);
    }

    public int getZenModeListenerInterruptionFilter() {
        return NotificationManager.zenModeToInterruptionFilter(this.mZenMode);
    }

    public void requestFromListener(ComponentName name, int filter) {
        int newZen = NotificationManager.zenModeFromInterruptionFilter(filter, -1);
        if (newZen != -1) {
            this.setManualZenMode(newZen, null, "listener:" + (name != null ? name.flattenToShortString() : null));
        }
    }

    public void setEffectsSuppressed(boolean effectsSuppressed) {
        if (this.mEffectsSuppressed == effectsSuppressed) {
            return;
        }
        this.mEffectsSuppressed = effectsSuppressed;
        this.applyRestrictions();
    }

    public int getZenMode() {
        return this.mZenMode;
    }

    public void setManualZenMode(int zenMode, Uri conditionId, String reason) {
        this.setManualZenMode(zenMode, conditionId, reason, true);
    }

    private void setManualZenMode(int zenMode, Uri conditionId, String reason, boolean setRingerMode) {
        if (this.mConfig == null) {
            return;
        }
        if (!Settings.Global.isValidZenMode(zenMode)) {
            return;
        }
        if (DEBUG) {
            Log.d(TAG, "setManualZenMode " + Settings.Global.zenModeToString(zenMode) + " conditionId=" + conditionId + " reason=" + reason + " setRingerMode=" + setRingerMode);
        }
        ZenModeConfig newConfig = this.mConfig.copy();
        if (zenMode == 0) {
            newConfig.manualRule = null;
            for (ZenModeConfig.ZenRule automaticRule : newConfig.automaticRules.values()) {
                if (!automaticRule.isAutomaticActive()) continue;
                automaticRule.snoozing = true;
            }
        } else {
            ZenModeConfig.ZenRule newRule = new ZenModeConfig.ZenRule();
            newRule.enabled = true;
            newRule.zenMode = zenMode;
            newRule.conditionId = conditionId;
            newConfig.manualRule = newRule;
        }
        this.setConfig(newConfig, reason, setRingerMode);
    }

    public void dump(PrintWriter pw, String prefix) {
        pw.print(prefix);
        pw.print("mZenMode=");
        pw.println(Settings.Global.zenModeToString(this.mZenMode));
        ZenModeHelper.dump(pw, prefix, "mDefaultConfig", this.mDefaultConfig);
        int N = this.mConfigs.size();
        for (int i = 0; i < N; ++i) {
            ZenModeHelper.dump(pw, prefix, "mConfigs[u=" + this.mConfigs.keyAt(i) + "]", this.mConfigs.valueAt(i));
        }
        pw.print(prefix);
        pw.print("mUser=");
        pw.println(this.mUser);
        ZenModeHelper.dump(pw, prefix, "mConfig", this.mConfig);
        pw.print(prefix);
        pw.print("mEffectsSuppressed=");
        pw.println(this.mEffectsSuppressed);
        this.mFiltering.dump(pw, prefix);
        this.mConditions.dump(pw, prefix);
    }

    private static void dump(PrintWriter pw, String prefix, String var, ZenModeConfig config) {
        pw.print(prefix);
        pw.print(var);
        pw.print('=');
        if (config == null) {
            pw.println(config);
            return;
        }
        pw.printf("allow(calls=%s,callsFrom=%s,repeatCallers=%s,messages=%s,messagesFrom=%s,events=%s,reminders=%s)\n", config.allowCalls, config.allowCallsFrom, config.allowRepeatCallers, config.allowMessages, config.allowMessagesFrom, config.allowEvents, config.allowReminders);
        pw.print(prefix);
        pw.print("  manualRule=");
        pw.println(config.manualRule);
        if (config.automaticRules.isEmpty()) {
            return;
        }
        int N = config.automaticRules.size();
        for (int i = 0; i < N; ++i) {
            pw.print(prefix);
            pw.print(i == 0 ? "  automaticRules=" : "                 ");
            pw.println(config.automaticRules.valueAt(i));
        }
    }

    public void readXml(XmlPullParser parser, boolean forRestore) throws XmlPullParserException, IOException {
        ZenModeConfig config = ZenModeConfig.readXml(parser, this.mConfigMigration);
        if (config != null) {
            if (forRestore) {
                if (config.user != 0) {
                    return;
                }
                config.manualRule = null;
                if (config.automaticRules != null) {
                    for (ZenModeConfig.ZenRule automaticRule : config.automaticRules.values()) {
                        automaticRule.snoozing = false;
                        automaticRule.condition = null;
                    }
                }
            }
            if (DEBUG) {
                Log.d(TAG, "readXml");
            }
            this.setConfig(config, "readXml");
        }
    }

    public void writeXml(XmlSerializer out, boolean forBackup) throws IOException {
        int N = this.mConfigs.size();
        for (int i = 0; i < N; ++i) {
            if (forBackup && this.mConfigs.keyAt(i) != 0) continue;
            this.mConfigs.valueAt(i).writeXml(out);
        }
    }

    public NotificationManager.Policy getNotificationPolicy() {
        return ZenModeHelper.getNotificationPolicy(this.mConfig);
    }

    private static NotificationManager.Policy getNotificationPolicy(ZenModeConfig config) {
        return config == null ? null : config.toNotificationPolicy();
    }

    public void setNotificationPolicy(NotificationManager.Policy policy) {
        if (policy == null || this.mConfig == null) {
            return;
        }
        ZenModeConfig newConfig = this.mConfig.copy();
        newConfig.applyNotificationPolicy(policy);
        this.setConfig(newConfig, "setNotificationPolicy");
    }

    public ZenModeConfig getConfig() {
        return this.mConfig;
    }

    public boolean setConfig(ZenModeConfig config, String reason) {
        return this.setConfig(config, reason, true);
    }

    private boolean setConfig(ZenModeConfig config, String reason, boolean setRingerMode) {
        if (config == null || !config.isValid()) {
            Log.w(TAG, "Invalid config in setConfig; " + config);
            return false;
        }
        if (config.user != this.mUser) {
            this.mConfigs.put(config.user, config);
            if (DEBUG) {
                Log.d(TAG, "setConfig: store config for user " + config.user);
            }
            return true;
        }
        this.mConditions.evaluateConfig(config, false);
        this.mConfigs.put(config.user, config);
        if (config.equals(this.mConfig)) {
            return true;
        }
        if (DEBUG) {
            Log.d(TAG, "setConfig reason=" + reason, new Throwable());
        }
        ZenLog.traceConfig(reason, this.mConfig, config);
        boolean policyChanged = !Objects.equals(ZenModeHelper.getNotificationPolicy(this.mConfig), ZenModeHelper.getNotificationPolicy(config));
        this.mConfig = config;
        this.dispatchOnConfigChanged();
        if (policyChanged) {
            this.dispatchOnPolicyChanged();
        }
        String val = Integer.toString(this.mConfig.hashCode());
        Settings.Global.putString(this.mContext.getContentResolver(), "zen_mode_config_etag", val);
        if (!this.evaluateZenMode(reason, setRingerMode)) {
            this.applyRestrictions();
        }
        this.mConditions.evaluateConfig(config, true);
        return true;
    }

    private int getZenModeSetting() {
        return Settings.Global.getInt(this.mContext.getContentResolver(), "zen_mode", 0);
    }

    private void setZenModeSetting(int zen) {
        Settings.Global.putInt(this.mContext.getContentResolver(), "zen_mode", zen);
    }

    private int getPreviousRingerModeSetting() {
        return Settings.Global.getInt(this.mContext.getContentResolver(), "zen_mode_ringer_level", 2);
    }

    private void setPreviousRingerModeSetting(Integer previousRingerLevel) {
        Settings.Global.putString(this.mContext.getContentResolver(), "zen_mode_ringer_level", previousRingerLevel == null ? null : Integer.toString(previousRingerLevel));
    }

    private boolean evaluateZenMode(String reason, boolean setRingerMode) {
        ArraySet<ZenModeConfig.ZenRule> automaticRules;
        int zen;
        if (DEBUG) {
            Log.d(TAG, "evaluateZenMode");
        }
        if ((zen = this.computeZenMode(automaticRules = new ArraySet<ZenModeConfig.ZenRule>())) == this.mZenMode) {
            return false;
        }
        ZenLog.traceSetZenMode(zen, reason);
        this.mZenMode = zen;
        this.updateRingerModeAffectedStreams();
        this.setZenModeSetting(this.mZenMode);
        if (setRingerMode) {
            this.applyZenToRingerMode();
        }
        this.applyRestrictions();
        this.mHandler.postDispatchOnZenModeChanged();
        return true;
    }

    private void updateRingerModeAffectedStreams() {
        if (this.mAudioManager != null) {
            this.mAudioManager.updateRingerModeAffectedStreamsInternal();
        }
    }

    private int computeZenMode(ArraySet<ZenModeConfig.ZenRule> automaticRulesOut) {
        if (this.mConfig == null) {
            return 0;
        }
        if (this.mConfig.manualRule != null) {
            return this.mConfig.manualRule.zenMode;
        }
        int zen = 0;
        for (ZenModeConfig.ZenRule automaticRule : this.mConfig.automaticRules.values()) {
            if (!automaticRule.isAutomaticActive() || ZenModeHelper.zenSeverity(automaticRule.zenMode) <= ZenModeHelper.zenSeverity(zen)) continue;
            zen = automaticRule.zenMode;
        }
        return zen;
    }

    private void applyRestrictions() {
        boolean zen = this.mZenMode != 0;
        boolean muteNotifications = this.mEffectsSuppressed;
        this.applyRestrictions(muteNotifications, 5);
        boolean muteCalls = zen && !this.mConfig.allowCalls && !this.mConfig.allowRepeatCallers || this.mEffectsSuppressed;
        this.applyRestrictions(muteCalls, 6);
        boolean muteAlarms = this.mZenMode == 2;
        this.applyRestrictions(muteAlarms, 4);
    }

    private void applyRestrictions(boolean mute, int usage) {
        String[] exceptionPackages = null;
        this.mAppOps.setRestriction(3, usage, mute ? 1 : 0, exceptionPackages);
        this.mAppOps.setRestriction(28, usage, mute ? 1 : 0, exceptionPackages);
    }

    private void applyZenToRingerMode() {
        int ringerModeInternal;
        if (this.mAudioManager == null) {
            return;
        }
        int newRingerModeInternal = ringerModeInternal = this.mAudioManager.getRingerModeInternal();
        switch (this.mZenMode) {
            case 2: 
            case 3: {
                if (ringerModeInternal == 0) break;
                this.setPreviousRingerModeSetting(ringerModeInternal);
                newRingerModeInternal = 0;
                break;
            }
            case 0: 
            case 1: {
                if (ringerModeInternal != 0) break;
                newRingerModeInternal = this.getPreviousRingerModeSetting();
                this.setPreviousRingerModeSetting(null);
            }
        }
        if (newRingerModeInternal != -1) {
            this.mAudioManager.setRingerModeInternal(newRingerModeInternal, TAG);
        }
    }

    private void dispatchOnConfigChanged() {
        for (Callback callback : this.mCallbacks) {
            callback.onConfigChanged();
        }
    }

    private void dispatchOnPolicyChanged() {
        for (Callback callback : this.mCallbacks) {
            callback.onPolicyChanged();
        }
    }

    private void dispatchOnZenModeChanged() {
        for (Callback callback : this.mCallbacks) {
            callback.onZenModeChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ZenModeConfig readDefaultConfig(Resources resources) {
        XmlResourceParser parser = null;
        try {
            parser = resources.getXml(0x1110004);
            while (parser.next() != 1) {
                ZenModeConfig config = ZenModeConfig.readXml(parser, this.mConfigMigration);
                if (config == null) continue;
                ZenModeConfig zenModeConfig = config;
                return zenModeConfig;
            }
        }
        catch (Exception e) {
            Log.w(TAG, "Error reading default zen mode config from resource", e);
        }
        finally {
            IoUtils.closeQuietly(parser);
        }
        return new ZenModeConfig();
    }

    private void appendDefaultScheduleRules(ZenModeConfig config) {
        if (config == null) {
            return;
        }
        ZenModeConfig.ScheduleInfo weeknights = new ZenModeConfig.ScheduleInfo();
        weeknights.days = ZenModeConfig.WEEKNIGHT_DAYS;
        weeknights.startHour = 22;
        weeknights.endHour = 7;
        ZenModeConfig.ZenRule rule1 = new ZenModeConfig.ZenRule();
        rule1.enabled = false;
        rule1.name = this.mContext.getResources().getString(17040760);
        rule1.conditionId = ZenModeConfig.toScheduleConditionId(weeknights);
        rule1.zenMode = 3;
        config.automaticRules.put(config.newRuleId(), rule1);
        ZenModeConfig.ScheduleInfo weekends = new ZenModeConfig.ScheduleInfo();
        weekends.days = ZenModeConfig.WEEKEND_DAYS;
        weekends.startHour = 23;
        weekends.startMinute = 30;
        weekends.endHour = 10;
        ZenModeConfig.ZenRule rule2 = new ZenModeConfig.ZenRule();
        rule2.enabled = false;
        rule2.name = this.mContext.getResources().getString(17040761);
        rule2.conditionId = ZenModeConfig.toScheduleConditionId(weekends);
        rule2.zenMode = 3;
        config.automaticRules.put(config.newRuleId(), rule2);
    }

    private void appendDefaultEventRules(ZenModeConfig config) {
        if (config == null) {
            return;
        }
        ZenModeConfig.EventInfo events = new ZenModeConfig.EventInfo();
        events.calendar = null;
        events.reply = 1;
        ZenModeConfig.ZenRule rule = new ZenModeConfig.ZenRule();
        rule.enabled = false;
        rule.name = this.mContext.getResources().getString(17040762);
        rule.conditionId = ZenModeConfig.toEventConditionId(events);
        rule.zenMode = 3;
        config.automaticRules.put(config.newRuleId(), rule);
    }

    private static int zenSeverity(int zen) {
        switch (zen) {
            case 1: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 2: {
                return 3;
            }
        }
        return 0;
    }

    public static class Callback {
        void onConfigChanged() {
        }

        void onZenModeChanged() {
        }

        void onPolicyChanged() {
        }
    }

    private final class H
    extends Handler {
        private static final int MSG_DISPATCH = 1;
        private static final int MSG_METRICS = 2;
        private static final long METRICS_PERIOD_MS = 21600000L;

        private H(Looper looper) {
            super(looper);
        }

        private void postDispatchOnZenModeChanged() {
            this.removeMessages(1);
            this.sendEmptyMessage(1);
        }

        private void postMetricsTimer() {
            this.removeMessages(2);
            this.sendEmptyMessageDelayed(2, 21600000L);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    ZenModeHelper.this.dispatchOnZenModeChanged();
                    break;
                }
                case 2: {
                    ZenModeHelper.this.mMetrics.emit();
                }
            }
        }
    }

    private final class Metrics
    extends Callback {
        private static final String COUNTER_PREFIX = "dnd_mode_";
        private static final long MINIMUM_LOG_PERIOD_MS = 60000L;
        private int mPreviousZenMode = -1;
        private long mBeginningMs = 0L;

        private Metrics() {
        }

        @Override
        void onZenModeChanged() {
            this.emit();
        }

        private void emit() {
            ZenModeHelper.this.mHandler.postMetricsTimer();
            long now = SystemClock.elapsedRealtime();
            long since = now - this.mBeginningMs;
            if (this.mPreviousZenMode != ZenModeHelper.this.mZenMode || since > 60000L) {
                if (this.mPreviousZenMode != -1) {
                    MetricsLogger.count(ZenModeHelper.this.mContext, COUNTER_PREFIX + this.mPreviousZenMode, (int)since);
                }
                this.mPreviousZenMode = ZenModeHelper.this.mZenMode;
                this.mBeginningMs = now;
            }
        }
    }

    private final class SettingsObserver
    extends ContentObserver {
        private final Uri ZEN_MODE;

        public SettingsObserver(Handler handler) {
            super(handler);
            this.ZEN_MODE = Settings.Global.getUriFor("zen_mode");
        }

        public void observe() {
            ContentResolver resolver = ZenModeHelper.this.mContext.getContentResolver();
            resolver.registerContentObserver(this.ZEN_MODE, false, this);
            this.update(null);
        }

        @Override
        public void onChange(boolean selfChange, Uri uri) {
            this.update(uri);
        }

        public void update(Uri uri) {
            if (this.ZEN_MODE.equals(uri) && ZenModeHelper.this.mZenMode != ZenModeHelper.this.getZenModeSetting()) {
                if (DEBUG) {
                    Log.d(ZenModeHelper.TAG, "Fixing zen mode setting");
                }
                ZenModeHelper.this.setZenModeSetting(ZenModeHelper.this.mZenMode);
            }
        }
    }

    private final class RingerModeDelegate
    implements AudioManagerInternal.RingerModeDelegate {
        private RingerModeDelegate() {
        }

        public String toString() {
            return ZenModeHelper.TAG;
        }

        @Override
        public int onSetRingerModeInternal(int ringerModeOld, int ringerModeNew, String caller, int ringerModeExternal, VolumePolicy policy) {
            boolean isChange = ringerModeOld != ringerModeNew;
            int ringerModeExternalOut = ringerModeNew;
            int newZen = -1;
            switch (ringerModeNew) {
                case 0: {
                    if (!isChange || !policy.doNotDisturbWhenSilent) break;
                    if (ZenModeHelper.this.mZenMode != 2 && ZenModeHelper.this.mZenMode != 3) {
                        newZen = 3;
                    }
                    ZenModeHelper.this.setPreviousRingerModeSetting(ringerModeOld);
                    break;
                }
                case 1: 
                case 2: {
                    if (isChange && ringerModeOld == 0 && (ZenModeHelper.this.mZenMode == 2 || ZenModeHelper.this.mZenMode == 3)) {
                        newZen = 0;
                        break;
                    }
                    if (ZenModeHelper.this.mZenMode == 0) break;
                    ringerModeExternalOut = 0;
                }
            }
            if (newZen != -1) {
                ZenModeHelper.this.setManualZenMode(newZen, null, "ringerModeInternal", false);
            }
            if (isChange || newZen != -1 || ringerModeExternal != ringerModeExternalOut) {
                ZenLog.traceSetRingerModeInternal(ringerModeOld, ringerModeNew, caller, ringerModeExternal, ringerModeExternalOut);
            }
            return ringerModeExternalOut;
        }

        @Override
        public int onSetRingerModeExternal(int ringerModeOld, int ringerModeNew, String caller, int ringerModeInternal, VolumePolicy policy) {
            int ringerModeInternalOut = ringerModeNew;
            boolean isChange = ringerModeOld != ringerModeNew;
            boolean isVibrate = ringerModeInternal == 1;
            int newZen = -1;
            switch (ringerModeNew) {
                case 0: {
                    if (isChange) {
                        if (ZenModeHelper.this.mZenMode == 0) {
                            newZen = 3;
                        }
                        ringerModeInternalOut = isVibrate ? 1 : 0;
                        break;
                    }
                    ringerModeInternalOut = ringerModeInternal;
                    break;
                }
                case 1: 
                case 2: {
                    if (ZenModeHelper.this.mZenMode == 0) break;
                    newZen = 0;
                }
            }
            if (newZen != -1) {
                ZenModeHelper.this.setManualZenMode(newZen, null, "ringerModeExternal", false);
            }
            ZenLog.traceSetRingerModeExternal(ringerModeOld, ringerModeNew, caller, ringerModeInternal, ringerModeInternalOut);
            return ringerModeInternalOut;
        }

        @Override
        public boolean canVolumeDownEnterSilent() {
            return ZenModeHelper.this.mZenMode == 0;
        }

        @Override
        public int getRingerModeAffectedStreams(int streams) {
            streams |= 0x26;
            streams = ZenModeHelper.this.mZenMode == 2 ? (streams |= 0x18) : (streams &= 0xFFFFFFE7);
            return streams;
        }
    }
}

