/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.app.job.JobInfo;
import android.app.job.JobParameters;
import android.app.job.JobScheduler;
import android.app.job.JobService;
import android.content.ComponentName;
import android.content.Context;
import android.os.ServiceManager;
import android.util.ArraySet;
import android.util.Log;
import com.android.server.pm.PackageManagerService;
import java.util.concurrent.atomic.AtomicBoolean;

public class BackgroundDexOptService
extends JobService {
    static final String TAG = "BackgroundDexOptService";
    static final long RETRY_LATENCY = 14400000L;
    static final int BACKGROUND_DEXOPT_JOB = 800;
    private static ComponentName sDexoptServiceName = new ComponentName("android", BackgroundDexOptService.class.getName());
    static final ArraySet<String> sFailedPackageNames = new ArraySet();
    final AtomicBoolean mIdleTime = new AtomicBoolean(false);

    public static void schedule(Context context, long minLatency) {
        JobScheduler js = (JobScheduler)context.getSystemService("jobscheduler");
        JobInfo job = new JobInfo.Builder(800, sDexoptServiceName).setRequiresDeviceIdle(true).setRequiresCharging(true).setMinimumLatency(minLatency).build();
        js.schedule(job);
    }

    @Override
    public boolean onStartJob(JobParameters params) {
        Log.i(TAG, "onIdleStart");
        final PackageManagerService pm = (PackageManagerService)ServiceManager.getService("package");
        if (pm.isStorageLow()) {
            BackgroundDexOptService.schedule(this, 14400000L);
            return false;
        }
        final ArraySet<String> pkgs = pm.getPackagesThatNeedDexOpt();
        if (pkgs == null) {
            return false;
        }
        final JobParameters jobParams = params;
        this.mIdleTime.set(true);
        new Thread("BackgroundDexOptService_DexOpter"){

            @Override
            public void run() {
                for (String pkg : pkgs) {
                    if (!BackgroundDexOptService.this.mIdleTime.get()) {
                        BackgroundDexOptService.schedule(BackgroundDexOptService.this, 0L);
                        return;
                    }
                    if (sFailedPackageNames.contains(pkg) || pm.performDexOpt(pkg, null, true)) continue;
                    sFailedPackageNames.add(pkg);
                }
                BackgroundDexOptService.this.jobFinished(jobParams, false);
            }
        }.start();
        return true;
    }

    @Override
    public boolean onStopJob(JobParameters params) {
        Log.i(TAG, "onIdleStop");
        this.mIdleTime.set(false);
        return false;
    }
}

