/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.content.pm.PackageParser;
import android.content.pm.PermissionInfo;
import android.os.UserHandle;
import com.android.server.pm.PackageSettingBase;

final class BasePermission {
    static final int TYPE_NORMAL = 0;
    static final int TYPE_BUILTIN = 1;
    static final int TYPE_DYNAMIC = 2;
    final String name;
    String sourcePackage;
    PackageSettingBase packageSetting;
    final int type;
    int protectionLevel;
    PackageParser.Permission perm;
    PermissionInfo pendingInfo;
    int uid;
    private int[] gids;
    private boolean perUser;

    BasePermission(String _name, String _sourcePackage, int _type) {
        this.name = _name;
        this.sourcePackage = _sourcePackage;
        this.type = _type;
        this.protectionLevel = 2;
    }

    public String toString() {
        return "BasePermission{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.name + "}";
    }

    public void setGids(int[] gids, boolean perUser) {
        this.gids = gids;
        this.perUser = perUser;
    }

    public int[] computeGids(int userId) {
        if (this.perUser) {
            int[] userGids = new int[this.gids.length];
            for (int i = 0; i < this.gids.length; ++i) {
                userGids[i] = UserHandle.getUid(userId, this.gids[i]);
            }
            return userGids;
        }
        return this.gids;
    }

    public boolean isRuntime() {
        return (this.protectionLevel & 0xF) == 1;
    }

    public boolean isDevelopment() {
        return (this.protectionLevel & 0xF) == 2 && (this.protectionLevel & 0x20) != 0;
    }
}

