/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.content.pm.PackageParser;
import android.os.PowerManager;
import android.os.UserHandle;
import android.os.WorkSource;
import android.util.ArraySet;
import android.util.Log;
import android.util.Slog;
import com.android.server.pm.InstructionSets;
import com.android.server.pm.PackageManagerService;
import dalvik.system.DexFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

final class PackageDexOptimizer {
    private static final String TAG = "PackageManager.DexOptimizer";
    static final String OAT_DIR_NAME = "oat";
    static final int DEX_OPT_SKIPPED = 0;
    static final int DEX_OPT_PERFORMED = 1;
    static final int DEX_OPT_DEFERRED = 2;
    static final int DEX_OPT_FAILED = -1;
    private final PackageManagerService mPackageManagerService;
    private ArraySet<PackageParser.Package> mDeferredDexOpt;
    private final PowerManager.WakeLock mDexoptWakeLock;
    private volatile boolean mSystemReady;

    PackageDexOptimizer(PackageManagerService packageManagerService) {
        this.mPackageManagerService = packageManagerService;
        PowerManager powerManager = (PowerManager)packageManagerService.mContext.getSystemService("power");
        this.mDexoptWakeLock = powerManager.newWakeLock(1, "*dexopt*");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int performDexOpt(PackageParser.Package pkg, String[] instructionSets, boolean forceDex, boolean defer, boolean inclDependencies) {
        ArraySet<String> done;
        if (inclDependencies && (pkg.usesLibraries != null || pkg.usesOptionalLibraries != null)) {
            done = new ArraySet<String>();
            done.add(pkg.packageName);
        } else {
            done = null;
        }
        Object object = this.mPackageManagerService.mInstallLock;
        synchronized (object) {
            int n;
            block10: {
                boolean useLock = this.mSystemReady;
                if (useLock) {
                    this.mDexoptWakeLock.setWorkSource(new WorkSource(pkg.applicationInfo.uid));
                    this.mDexoptWakeLock.acquire();
                }
                try {
                    n = this.performDexOptLI(pkg, instructionSets, forceDex, defer, done);
                    if (!useLock) break block10;
                    this.mDexoptWakeLock.release();
                }
                catch (Throwable throwable) {
                    if (useLock) {
                        this.mDexoptWakeLock.release();
                    }
                    throw throwable;
                }
            }
            return n;
        }
    }

    private int performDexOptLI(PackageParser.Package pkg, String[] targetInstructionSets, boolean forceDex, boolean defer, ArraySet<String> done) {
        String[] dexCodeInstructionSets;
        String[] instructionSets;
        String[] stringArray = instructionSets = targetInstructionSets != null ? targetInstructionSets : InstructionSets.getAppDexInstructionSets(pkg.applicationInfo);
        if (done != null) {
            done.add(pkg.packageName);
            if (pkg.usesLibraries != null) {
                this.performDexOptLibsLI(pkg.usesLibraries, instructionSets, forceDex, defer, done);
            }
            if (pkg.usesOptionalLibraries != null) {
                this.performDexOptLibsLI(pkg.usesOptionalLibraries, instructionSets, forceDex, defer, done);
            }
        }
        if ((pkg.applicationInfo.flags & 4) == 0) {
            return 0;
        }
        boolean vmSafeMode = (pkg.applicationInfo.flags & 0x4000) != 0;
        boolean debuggable = (pkg.applicationInfo.flags & 2) != 0;
        List<String> paths = pkg.getAllCodePathsExcludingResourceOnly();
        boolean performedDexOpt = false;
        for (String dexCodeInstructionSet : dexCodeInstructionSets = InstructionSets.getDexCodeInstructionSets(instructionSets)) {
            if (!forceDex && pkg.mDexOptPerformed.contains(dexCodeInstructionSet)) continue;
            for (String path : paths) {
                String dexoptType;
                int dexoptNeeded;
                if (forceDex) {
                    dexoptNeeded = 1;
                } else {
                    try {
                        dexoptNeeded = DexFile.getDexOptNeeded(path, pkg.packageName, dexCodeInstructionSet, defer);
                    }
                    catch (IOException ioe) {
                        Slog.w(TAG, "IOException reading apk: " + path, ioe);
                        return -1;
                    }
                }
                if (!forceDex && defer && dexoptNeeded != 0) {
                    this.addPackageForDeferredDexopt(pkg);
                    return 2;
                }
                if (dexoptNeeded == 0) continue;
                String oatDir = null;
                if (dexoptNeeded == 1) {
                    dexoptType = "dex2oat";
                    try {
                        oatDir = this.createOatDirIfSupported(pkg, dexCodeInstructionSet);
                    }
                    catch (IOException ioe) {
                        Slog.w(TAG, "Unable to create oatDir for package: " + pkg.packageName);
                        return -1;
                    }
                } else if (dexoptNeeded == 2) {
                    dexoptType = "patchoat";
                } else if (dexoptNeeded == 3) {
                    dexoptType = "self patchoat";
                } else {
                    throw new IllegalStateException("Invalid dexopt needed: " + dexoptNeeded);
                }
                Log.i(TAG, "Running dexopt (" + dexoptType + ") on: " + path + " pkg=" + pkg.applicationInfo.packageName + " isa=" + dexCodeInstructionSet + " vmSafeMode=" + vmSafeMode + " debuggable=" + debuggable + " oatDir = " + oatDir);
                int sharedGid = UserHandle.getSharedAppGid(pkg.applicationInfo.uid);
                int ret = this.mPackageManagerService.mInstaller.dexopt(path, sharedGid, !pkg.isForwardLocked(), pkg.packageName, dexCodeInstructionSet, dexoptNeeded, vmSafeMode, debuggable, oatDir);
                if (ret != 0) continue;
                performedDexOpt = true;
            }
            pkg.mDexOptPerformed.add(dexCodeInstructionSet);
        }
        return performedDexOpt ? 1 : 0;
    }

    private String createOatDirIfSupported(PackageParser.Package pkg, String dexInstructionSet) throws IOException {
        if (pkg.isSystemApp() && !pkg.isUpdatedSystemApp() || pkg.isForwardLocked() || pkg.applicationInfo.isExternalAsec()) {
            return null;
        }
        File codePath = new File(pkg.codePath);
        if (codePath.isDirectory()) {
            File oatDir = PackageDexOptimizer.getOatDir(codePath);
            this.mPackageManagerService.mInstaller.createOatDir(oatDir.getAbsolutePath(), dexInstructionSet);
            return oatDir.getAbsolutePath();
        }
        return null;
    }

    static File getOatDir(File codePath) {
        return new File(codePath, OAT_DIR_NAME);
    }

    private void performDexOptLibsLI(ArrayList<String> libs, String[] instructionSets, boolean forceDex, boolean defer, ArraySet<String> done) {
        for (String libName : libs) {
            PackageParser.Package libPkg = this.mPackageManagerService.findSharedNonSystemLibrary(libName);
            if (libPkg == null || done.contains(libName)) continue;
            this.performDexOptLI(libPkg, instructionSets, forceDex, defer, done);
        }
    }

    public ArraySet<PackageParser.Package> clearDeferredDexOptPackages() {
        ArraySet<PackageParser.Package> result = this.mDeferredDexOpt;
        this.mDeferredDexOpt = null;
        return result;
    }

    public void addPackageForDeferredDexopt(PackageParser.Package pkg) {
        if (this.mDeferredDexOpt == null) {
            this.mDeferredDexOpt = new ArraySet();
        }
        this.mDeferredDexOpt.add(pkg);
    }

    void systemReady() {
        this.mSystemReady = true;
    }
}

