/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.app.ActivityManager;
import android.app.ActivityManagerNative;
import android.app.AppGlobals;
import android.app.IActivityManager;
import android.app.admin.IDevicePolicyManager;
import android.app.backup.IBackupManager;
import android.app.usage.UsageStats;
import android.app.usage.UsageStatsManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.IIntentReceiver;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.ServiceConnection;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.FeatureInfo;
import android.content.pm.IOnPermissionsChangeListener;
import android.content.pm.IPackageDataObserver;
import android.content.pm.IPackageDeleteObserver;
import android.content.pm.IPackageDeleteObserver2;
import android.content.pm.IPackageInstallObserver2;
import android.content.pm.IPackageInstaller;
import android.content.pm.IPackageManager;
import android.content.pm.IPackageMoveObserver;
import android.content.pm.IPackageStatsObserver;
import android.content.pm.InstrumentationInfo;
import android.content.pm.IntentFilterVerificationInfo;
import android.content.pm.KeySet;
import android.content.pm.ManifestDigest;
import android.content.pm.PackageCleanItem;
import android.content.pm.PackageInfo;
import android.content.pm.PackageInfoLite;
import android.content.pm.PackageInstaller;
import android.content.pm.PackageManager;
import android.content.pm.PackageManagerInternal;
import android.content.pm.PackageParser;
import android.content.pm.PackageStats;
import android.content.pm.PackageUserState;
import android.content.pm.ParceledListSlice;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.content.pm.ProviderInfo;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.pm.Signature;
import android.content.pm.UserInfo;
import android.content.pm.VerificationParams;
import android.content.pm.VerifierDeviceIdentity;
import android.content.pm.VerifierInfo;
import android.content.res.Resources;
import android.hardware.display.DisplayManager;
import android.net.Uri;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.Debug;
import android.os.Environment;
import android.os.FileUtils;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.SELinux;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.storage.IMountService;
import android.os.storage.MountServiceInternal;
import android.os.storage.StorageEventListener;
import android.os.storage.StorageManager;
import android.os.storage.VolumeInfo;
import android.provider.Settings;
import android.security.KeyStore;
import android.security.SystemKeyStore;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.system.StructStat;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.AtomicFile;
import android.util.DisplayMetrics;
import android.util.EventLog;
import android.util.ExceptionUtils;
import android.util.Log;
import android.util.LogPrinter;
import android.util.MathUtils;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import android.util.Xml;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.app.IMediaContainerService;
import com.android.internal.app.IntentForwarderActivity;
import com.android.internal.app.ResolverActivity;
import com.android.internal.content.NativeLibraryHelper;
import com.android.internal.content.PackageHelper;
import com.android.internal.os.IParcelFileDescriptorFactory;
import com.android.internal.os.SomeArgs;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.FastPrintWriter;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.IndentingPrintWriter;
import com.android.internal.util.Preconditions;
import com.android.server.EventLogTags;
import com.android.server.FgThread;
import com.android.server.IntentResolver;
import com.android.server.LocalServices;
import com.android.server.ServiceThread;
import com.android.server.SystemConfig;
import com.android.server.Watchdog;
import com.android.server.pm.BasePermission;
import com.android.server.pm.CrossProfileIntentFilter;
import com.android.server.pm.CrossProfileIntentResolver;
import com.android.server.pm.DefaultPermissionGrantPolicy;
import com.android.server.pm.Installer;
import com.android.server.pm.InstructionSets;
import com.android.server.pm.IntentFilterVerificationResponse;
import com.android.server.pm.IntentFilterVerificationState;
import com.android.server.pm.KeySetHandle;
import com.android.server.pm.KeySetManagerService;
import com.android.server.pm.PackageDexOptimizer;
import com.android.server.pm.PackageInstallerService;
import com.android.server.pm.PackageManagerException;
import com.android.server.pm.PackageSetting;
import com.android.server.pm.PackageSignatures;
import com.android.server.pm.PackageVerificationResponse;
import com.android.server.pm.PackageVerificationState;
import com.android.server.pm.PermissionsState;
import com.android.server.pm.PersistentPreferredActivity;
import com.android.server.pm.PersistentPreferredIntentResolver;
import com.android.server.pm.PreferredActivity;
import com.android.server.pm.PreferredIntentResolver;
import com.android.server.pm.SELinuxMMAC;
import com.android.server.pm.SettingBase;
import com.android.server.pm.Settings;
import com.android.server.pm.SharedUserSetting;
import com.android.server.pm.UserManagerService;
import com.android.server.storage.DeviceStorageMonitorInternal;
import dalvik.system.DexFile;
import dalvik.system.VMRuntime;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import libcore.io.IoUtils;
import libcore.util.EmptyArray;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class PackageManagerService
extends IPackageManager.Stub {
    static final String TAG = "PackageManager";
    static final boolean DEBUG_SETTINGS = false;
    static final boolean DEBUG_PREFERRED = false;
    static final boolean DEBUG_UPGRADE = false;
    static final boolean DEBUG_DOMAIN_VERIFICATION = false;
    private static final boolean DEBUG_BACKUP = false;
    private static final boolean DEBUG_INSTALL = false;
    private static final boolean DEBUG_REMOVE = false;
    private static final boolean DEBUG_BROADCASTS = false;
    private static final boolean DEBUG_SHOW_INFO = false;
    private static final boolean DEBUG_PACKAGE_INFO = false;
    private static final boolean DEBUG_INTENT_MATCHING = false;
    private static final boolean DEBUG_PACKAGE_SCANNING = false;
    private static final boolean DEBUG_VERIFY = false;
    private static final boolean DEBUG_DEXOPT = false;
    private static final boolean DEBUG_ABI_SELECTION = false;
    static final boolean CLEAR_RUNTIME_PERMISSIONS_ON_UPGRADE = false;
    private static final int RADIO_UID = 1001;
    private static final int LOG_UID = 1007;
    private static final int NFC_UID = 1027;
    private static final int BLUETOOTH_UID = 1002;
    private static final int SHELL_UID = 2000;
    private static final int MAX_PERMISSION_TREE_FOOTPRINT = 32768;
    private static final String INSTALL_PACKAGE_SUFFIX = "-";
    static final int SCAN_NO_DEX = 2;
    static final int SCAN_FORCE_DEX = 4;
    static final int SCAN_UPDATE_SIGNATURE = 8;
    static final int SCAN_NEW_INSTALL = 16;
    static final int SCAN_NO_PATHS = 32;
    static final int SCAN_UPDATE_TIME = 64;
    static final int SCAN_DEFER_DEX = 128;
    static final int SCAN_BOOTING = 256;
    static final int SCAN_TRUSTED_OVERLAY = 512;
    static final int SCAN_DELETE_DATA_ON_FAILURES = 1024;
    static final int SCAN_REPLACING = 2048;
    static final int SCAN_REQUIRE_KNOWN = 4096;
    static final int SCAN_MOVE = 8192;
    static final int SCAN_INITIAL = 16384;
    static final int REMOVE_CHATTY = 65536;
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final long WATCHDOG_TIMEOUT = 600000L;
    private static final long DEFAULT_MANDATORY_FSTRIM_INTERVAL = 259200000L;
    private static final boolean DEFAULT_VERIFY_ENABLE = true;
    private static final long DEFAULT_VERIFICATION_TIMEOUT = 10000L;
    private static final int DEFAULT_VERIFICATION_RESPONSE = 1;
    static final String DEFAULT_CONTAINER_PACKAGE = "com.android.defcontainer";
    static final ComponentName DEFAULT_CONTAINER_COMPONENT = new ComponentName("com.android.defcontainer", "com.android.defcontainer.DefaultContainerService");
    private static final String KILL_APP_REASON_GIDS_CHANGED = "permission grant or revoke changed gids";
    private static final String KILL_APP_REASON_PERMISSIONS_REVOKED = "permissions revoked";
    private static final String PACKAGE_MIME_TYPE = "application/vnd.android.package-archive";
    private static final String VENDOR_OVERLAY_DIR = "/vendor/overlay";
    private static final int GRANT_DENIED = 1;
    private static final int GRANT_INSTALL = 2;
    private static final int GRANT_INSTALL_LEGACY = 3;
    private static final int GRANT_RUNTIME = 4;
    private static final int GRANT_UPGRADE = 5;
    private static final Intent sBrowserIntent = new Intent();
    final ServiceThread mHandlerThread;
    final PackageHandler mHandler;
    private ArrayList<Message> mPostSystemReadyMessages;
    final int mSdkVersion = Build.VERSION.SDK_INT;
    final Context mContext;
    final boolean mFactoryTest;
    final boolean mOnlyCore;
    final boolean mLazyDexOpt;
    final long mDexOptLRUThresholdInMills;
    final DisplayMetrics mMetrics;
    final int mDefParseFlags;
    final String[] mSeparateProcesses;
    final boolean mIsUpgrade;
    final File mAppDataDir;
    final File mUserAppDataDir;
    final String mAsecInternalPath;
    @GuardedBy(value="mInstallLock")
    final Installer mInstaller;
    final File mAppInstallDir;
    private File mAppLib32InstallDir;
    final File mDrmAppPrivateInstallDir;
    final Object mInstallLock = new Object();
    @GuardedBy(value="mPackages")
    final ArrayMap<String, PackageParser.Package> mPackages = new ArrayMap();
    final ArrayMap<String, ArrayMap<String, PackageParser.Package>> mOverlays = new ArrayMap();
    private final ArrayMap<String, File> mExpectingBetter = new ArrayMap();
    private final ArraySet<String> mExistingSystemPackages = new ArraySet();
    boolean mPromoteSystemApps;
    final Settings mSettings;
    boolean mRestoredSettings;
    final int[] mGlobalGids;
    final SparseArray<ArraySet<String>> mSystemPermissions;
    final ArrayMap<String, FeatureInfo> mAvailableFeatures;
    boolean mFoundPolicyFile;
    private boolean mShouldRestoreconData = SELinuxMMAC.shouldRestorecon();
    final ArrayMap<String, SharedLibraryEntry> mSharedLibraries = new ArrayMap();
    final ActivityIntentResolver mActivities = new ActivityIntentResolver();
    final ActivityIntentResolver mReceivers = new ActivityIntentResolver();
    final ServiceIntentResolver mServices = new ServiceIntentResolver();
    final ProviderIntentResolver mProviders = new ProviderIntentResolver();
    final ArrayMap<String, PackageParser.Provider> mProvidersByAuthority = new ArrayMap();
    final ArrayMap<ComponentName, PackageParser.Instrumentation> mInstrumentation = new ArrayMap();
    final ArrayMap<String, PackageParser.PermissionGroup> mPermissionGroups = new ArrayMap();
    final ArraySet<String> mTransferedPackages = new ArraySet();
    final ArraySet<String> mProtectedBroadcasts = new ArraySet();
    final SparseArray<PackageVerificationState> mPendingVerification = new SparseArray();
    final ArrayMap<String, ArraySet<String>> mAppOpPermissionPackages = new ArrayMap();
    final PackageInstallerService mInstallerService;
    private final PackageDexOptimizer mPackageDexOptimizer;
    private AtomicInteger mNextMoveId = new AtomicInteger();
    private final MoveCallbacks mMoveCallbacks;
    private final OnPermissionChangeListeners mOnPermissionChangeListeners;
    SparseBooleanArray mUserNeedsBadging = new SparseBooleanArray();
    private int mPendingVerificationToken = 0;
    volatile boolean mSystemReady;
    volatile boolean mSafeMode;
    volatile boolean mHasSystemUidErrors;
    ApplicationInfo mAndroidApplication;
    final ActivityInfo mResolveActivity = new ActivityInfo();
    final ResolveInfo mResolveInfo = new ResolveInfo();
    ComponentName mResolveComponentName;
    PackageParser.Package mPlatformPackage;
    ComponentName mCustomResolverComponentName;
    boolean mResolverReplaced = false;
    private final ComponentName mIntentFilterVerifierComponent;
    private int mIntentFilterVerificationToken = 0;
    final SparseArray<IntentFilterVerificationState> mIntentFilterVerificationStates = new SparseArray();
    final DefaultPermissionGrantPolicy mDefaultPermissionPolicy = new DefaultPermissionGrantPolicy(this);
    private IntentFilterVerifier mIntentFilterVerifier;
    final PendingPackageBroadcasts mPendingBroadcasts = new PendingPackageBroadcasts();
    private IMediaContainerService mContainerService = null;
    static final int SEND_PENDING_BROADCAST = 1;
    static final int MCS_BOUND = 3;
    static final int END_COPY = 4;
    static final int INIT_COPY = 5;
    static final int MCS_UNBIND = 6;
    static final int START_CLEANING_PACKAGE = 7;
    static final int FIND_INSTALL_LOC = 8;
    static final int POST_INSTALL = 9;
    static final int MCS_RECONNECT = 10;
    static final int MCS_GIVE_UP = 11;
    static final int UPDATED_MEDIA_STATUS = 12;
    static final int WRITE_SETTINGS = 13;
    static final int WRITE_PACKAGE_RESTRICTIONS = 14;
    static final int PACKAGE_VERIFIED = 15;
    static final int CHECK_PENDING_VERIFICATION = 16;
    static final int START_INTENT_FILTER_VERIFICATIONS = 17;
    static final int INTENT_FILTER_VERIFIED = 18;
    static final int WRITE_SETTINGS_DELAY = 10000;
    static final int BROADCAST_DELAY = 10000;
    static UserManagerService sUserManager;
    private ArraySet<Integer> mDirtyUsers = new ArraySet();
    private final DefaultContainerConnection mDefContainerConn = new DefaultContainerConnection();
    final SparseArray<PostInstallData> mRunningInstalls = new SparseArray();
    int mNextInstallToken = 1;
    private static final String TAG_PREFERRED_BACKUP = "pa";
    private static final String TAG_DEFAULT_APPS = "da";
    private static final String TAG_INTENT_FILTER_VERIFICATION = "iv";
    final String mRequiredVerifierPackage;
    final String mRequiredInstallerPackage;
    private final PackageUsage mPackageUsage = new PackageUsage();
    private StorageEventListener mStorageListener = new StorageEventListener(){

        @Override
        public void onVolumeStateChanged(VolumeInfo vol, int oldState, int newState) {
            if (vol.type == 1) {
                if (vol.state == 2) {
                    String volumeUuid = vol.getFsUuid();
                    PackageManagerService.this.reconcileUsers(volumeUuid);
                    PackageManagerService.this.reconcileApps(volumeUuid);
                    PackageManagerService.this.mInstallerService.onPrivateVolumeMounted(volumeUuid);
                    PackageManagerService.this.loadPrivatePackages(vol);
                } else if (vol.state == 5) {
                    PackageManagerService.this.unloadPrivatePackages(vol);
                }
            }
            if (vol.type == 0 && vol.isPrimary()) {
                if (vol.state == 2) {
                    PackageManagerService.this.updateExternalMediaStatus(true, false);
                } else if (vol.state == 5) {
                    PackageManagerService.this.updateExternalMediaStatus(false, false);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onVolumeForgotten(String fsUuid) {
            if (TextUtils.isEmpty(fsUuid)) {
                Slog.w(PackageManagerService.TAG, "Forgetting internal storage is probably a mistake; ignoring");
                return;
            }
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                List<PackageSetting> packages = PackageManagerService.this.mSettings.getVolumePackagesLPr(fsUuid);
                for (PackageSetting ps : packages) {
                    Slog.d(PackageManagerService.TAG, "Destroying " + ps.name + " because volume was forgotten");
                    PackageManagerService.this.deletePackage(ps.name, new PackageManager.LegacyPackageDeleteObserver(null).getBinder(), 0, 2);
                }
                PackageManagerService.this.mSettings.onVolumeForgotten(fsUuid);
                PackageManagerService.this.mSettings.writeLPr();
            }
        }
    };
    static final int UPDATE_PERMISSIONS_ALL = 1;
    static final int UPDATE_PERMISSIONS_REPLACE_PKG = 2;
    static final int UPDATE_PERMISSIONS_REPLACE_ALL = 4;
    private static final Comparator<ResolveInfo> mResolvePrioritySorter;
    private static final Comparator<ProviderInfo> mProviderInitOrderSorter;
    static final boolean DEBUG_SD_INSTALL = false;
    private static final String SD_ENCRYPTION_KEYSTORE_NAME = "AppsOnSD";
    private static final String SD_ENCRYPTION_ALGORITHM = "AES";
    private boolean mMediaMounted = false;

    private static boolean hasValidDomains(PackageParser.ActivityIntentInfo filter) {
        return filter.hasCategory("android.intent.category.BROWSABLE") && (filter.hasDataScheme("http") || filter.hasDataScheme("https"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void grantRequestedRuntimePermissions(PackageParser.Package pkg, int userId, String[] grantedPermissions) {
        if (userId >= 0) {
            this.grantRequestedRuntimePermissionsForUser(pkg, userId, grantedPermissions);
        } else if (userId == -1) {
            int[] userIds;
            ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
            synchronized (arrayMap) {
                userIds = UserManagerService.getInstance().getUserIds();
            }
            for (int someUserId : userIds) {
                this.grantRequestedRuntimePermissionsForUser(pkg, someUserId, grantedPermissions);
            }
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            this.mSettings.writePackageListLPr();
        }
    }

    private void grantRequestedRuntimePermissionsForUser(PackageParser.Package pkg, int userId, String[] grantedPermissions) {
        SettingBase sb = (SettingBase)pkg.mExtras;
        if (sb == null) {
            return;
        }
        PermissionsState permissionsState = sb.getPermissionsState();
        for (String permission2 : pkg.requestedPermissions) {
            BasePermission bp = this.mSettings.mPermissions.get(permission2);
            if (bp == null || !bp.isRuntime() || grantedPermissions != null && !ArrayUtils.contains(grantedPermissions, permission2)) continue;
            permissionsState.grantRuntimePermission(bp, userId);
        }
    }

    Bundle extrasForInstallResult(PackageInstalledInfo res) {
        Bundle extras = null;
        switch (res.returnCode) {
            case -112: {
                extras = new Bundle();
                extras.putString("android.content.pm.extra.FAILURE_EXISTING_PERMISSION", res.origPermission);
                extras.putString("android.content.pm.extra.FAILURE_EXISTING_PACKAGE", res.origPackage);
                break;
            }
            case 1: {
                extras = new Bundle();
                extras.putBoolean("android.intent.extra.REPLACING", res.removedInfo != null && res.removedInfo.removedPackage != null);
            }
        }
        return extras;
    }

    void scheduleWriteSettingsLocked() {
        if (!this.mHandler.hasMessages(13)) {
            this.mHandler.sendEmptyMessageDelayed(13, 10000L);
        }
    }

    void scheduleWritePackageRestrictionsLocked(int userId) {
        if (!sUserManager.exists(userId)) {
            return;
        }
        this.mDirtyUsers.add(userId);
        if (!this.mHandler.hasMessages(14)) {
            this.mHandler.sendEmptyMessageDelayed(14, 10000L);
        }
    }

    public static PackageManagerService main(Context context, Installer installer, boolean factoryTest, boolean onlyCore) {
        PackageManagerService m = new PackageManagerService(context, installer, factoryTest, onlyCore);
        ServiceManager.addService("package", m);
        return m;
    }

    static String[] splitString(String str, char sep) {
        int count = 1;
        int i = 0;
        while ((i = str.indexOf(sep, i)) >= 0) {
            ++count;
            ++i;
        }
        String[] res = new String[count];
        i = 0;
        count = 0;
        int lastI = 0;
        while ((i = str.indexOf(sep, i)) >= 0) {
            res[count] = str.substring(lastI, i);
            ++count;
            lastI = ++i;
        }
        res[count] = str.substring(lastI, str.length());
        return res;
    }

    private static void getDefaultDisplayMetrics(Context context, DisplayMetrics metrics) {
        DisplayManager displayManager = (DisplayManager)context.getSystemService("display");
        displayManager.getDisplay(0).getMetrics(metrics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PackageManagerService(Context context, Installer installer, boolean factoryTest, boolean onlyCore) {
        EventLog.writeEvent(3060, SystemClock.uptimeMillis());
        if (this.mSdkVersion <= 0) {
            Slog.w(TAG, "**** ro.build.version.sdk not set!");
        }
        this.mContext = context;
        this.mFactoryTest = factoryTest;
        this.mOnlyCore = onlyCore;
        this.mLazyDexOpt = "eng".equals(SystemProperties.get("ro.build.type"));
        this.mMetrics = new DisplayMetrics();
        this.mSettings = new Settings(this.mPackages);
        this.mSettings.addSharedUserLPw("android.uid.system", 1000, 1, 8);
        this.mSettings.addSharedUserLPw("android.uid.phone", 1001, 1, 8);
        this.mSettings.addSharedUserLPw("android.uid.log", 1007, 1, 8);
        this.mSettings.addSharedUserLPw("android.uid.nfc", 1027, 1, 8);
        this.mSettings.addSharedUserLPw("android.uid.bluetooth", 1002, 1, 8);
        this.mSettings.addSharedUserLPw("android.uid.shell", 2000, 1, 8);
        long dexOptLRUThresholdInMinutes = this.mLazyDexOpt ? 30L : 10080L;
        this.mDexOptLRUThresholdInMills = dexOptLRUThresholdInMinutes * 60L * 1000L;
        String separateProcesses = SystemProperties.get("debug.separate_processes");
        if (separateProcesses != null && separateProcesses.length() > 0) {
            if ("*".equals(separateProcesses)) {
                this.mDefParseFlags = 8;
                this.mSeparateProcesses = null;
                Slog.w(TAG, "Running with debug.separate_processes: * (ALL)");
            } else {
                this.mDefParseFlags = 0;
                this.mSeparateProcesses = separateProcesses.split(",");
                Slog.w(TAG, "Running with debug.separate_processes: " + separateProcesses);
            }
        } else {
            this.mDefParseFlags = 0;
            this.mSeparateProcesses = null;
        }
        this.mInstaller = installer;
        this.mPackageDexOptimizer = new PackageDexOptimizer(this);
        this.mMoveCallbacks = new MoveCallbacks(FgThread.get().getLooper());
        this.mOnPermissionChangeListeners = new OnPermissionChangeListeners(FgThread.get().getLooper());
        PackageManagerService.getDefaultDisplayMetrics(context, this.mMetrics);
        SystemConfig systemConfig = SystemConfig.getInstance();
        this.mGlobalGids = systemConfig.getGlobalGids();
        this.mSystemPermissions = systemConfig.getSystemPermissions();
        this.mAvailableFeatures = systemConfig.getAvailableFeatures();
        Object object = this.mInstallLock;
        synchronized (object) {
            ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
            synchronized (arrayMap) {
                int i;
                this.mHandlerThread = new ServiceThread(TAG, 10, true);
                this.mHandlerThread.start();
                this.mHandler = new PackageHandler(this.mHandlerThread.getLooper());
                Watchdog.getInstance().addThread(this.mHandler, 600000L);
                File dataDir = Environment.getDataDirectory();
                this.mAppDataDir = new File(dataDir, "data");
                this.mAppInstallDir = new File(dataDir, "app");
                this.mAppLib32InstallDir = new File(dataDir, "app-lib");
                this.mAsecInternalPath = new File(dataDir, "app-asec").getPath();
                this.mUserAppDataDir = new File(dataDir, "user");
                this.mDrmAppPrivateInstallDir = new File(dataDir, "app-private");
                sUserManager = new UserManagerService(context, this, this.mInstallLock, this.mPackages);
                ArrayMap<String, SystemConfig.PermissionEntry> permConfig = systemConfig.getPermissions();
                for (int i2 = 0; i2 < permConfig.size(); ++i2) {
                    SystemConfig.PermissionEntry perm = permConfig.valueAt(i2);
                    BasePermission bp = this.mSettings.mPermissions.get(perm.name);
                    if (bp == null) {
                        bp = new BasePermission(perm.name, "android", 1);
                        this.mSettings.mPermissions.put(perm.name, bp);
                    }
                    if (perm.gids == null) continue;
                    bp.setGids(perm.gids, perm.perUser);
                }
                ArrayMap<String, String> libConfig = systemConfig.getSharedLibraries();
                for (int i3 = 0; i3 < libConfig.size(); ++i3) {
                    this.mSharedLibraries.put(libConfig.keyAt(i3), new SharedLibraryEntry(libConfig.valueAt(i3), null));
                }
                this.mFoundPolicyFile = SELinuxMMAC.readInstallPolicy();
                this.mRestoredSettings = this.mSettings.readLPw(this, sUserManager.getUsers(false), this.mSdkVersion, this.mOnlyCore);
                String customResolverActivity = Resources.getSystem().getString(0x1040044);
                if (TextUtils.isEmpty(customResolverActivity)) {
                    customResolverActivity = null;
                } else {
                    this.mCustomResolverComponentName = ComponentName.unflattenFromString(customResolverActivity);
                }
                long startTime = SystemClock.uptimeMillis();
                EventLog.writeEvent(3070, startTime);
                int scanFlags = 16800;
                ArraySet<String> alreadyDexOpted = new ArraySet<String>();
                String bootClassPath = System.getenv("BOOTCLASSPATH");
                String systemServerClassPath = System.getenv("SYSTEMSERVERCLASSPATH");
                if (bootClassPath != null) {
                    String[] bootClassPathElements;
                    for (String element : bootClassPathElements = PackageManagerService.splitString(bootClassPath, ':')) {
                        alreadyDexOpted.add(element);
                    }
                } else {
                    Slog.w(TAG, "No BOOTCLASSPATH found!");
                }
                if (systemServerClassPath != null) {
                    String[] systemServerClassPathElements;
                    for (String element : systemServerClassPathElements = PackageManagerService.splitString(systemServerClassPath, ':')) {
                        alreadyDexOpted.add(element);
                    }
                } else {
                    Slog.w(TAG, "No SYSTEMSERVERCLASSPATH found!");
                }
                List<String> allInstructionSets = InstructionSets.getAllInstructionSets();
                String[] dexCodeInstructionSets = InstructionSets.getDexCodeInstructionSets(allInstructionSets.toArray(new String[allInstructionSets.size()]));
                if (this.mSharedLibraries.size() > 0) {
                    for (String dexCodeInstructionSet : dexCodeInstructionSets) {
                        for (SharedLibraryEntry libEntry : this.mSharedLibraries.values()) {
                            String lib = libEntry.path;
                            if (lib == null) continue;
                            try {
                                int dexoptNeeded = DexFile.getDexOptNeeded(lib, null, dexCodeInstructionSet, false);
                                if (dexoptNeeded == 0) continue;
                                alreadyDexOpted.add(lib);
                                this.mInstaller.dexopt(lib, 1000, true, dexCodeInstructionSet, dexoptNeeded);
                            }
                            catch (FileNotFoundException e) {
                                Slog.w(TAG, "Library not found: " + lib);
                            }
                            catch (IOException e) {
                                Slog.w(TAG, "Cannot dexopt " + lib + "; is it an APK or JAR? " + e.getMessage());
                            }
                        }
                    }
                }
                File frameworkDir = new File(Environment.getRootDirectory(), "framework");
                alreadyDexOpted.add(frameworkDir.getPath() + "/framework-res.apk");
                alreadyDexOpted.add(frameworkDir.getPath() + "/core-libart.jar");
                String[] frameworkFiles = frameworkDir.list();
                if (frameworkFiles != null) {
                    for (String dexCodeInstructionSet : dexCodeInstructionSets) {
                        for (int i4 = 0; i4 < frameworkFiles.length; ++i4) {
                            File libPath = new File(frameworkDir, frameworkFiles[i4]);
                            String path = libPath.getPath();
                            if (alreadyDexOpted.contains(path) || !path.endsWith(".apk") && !path.endsWith(".jar")) continue;
                            try {
                                int dexoptNeeded = DexFile.getDexOptNeeded(path, null, dexCodeInstructionSet, false);
                                if (dexoptNeeded == 0) continue;
                                this.mInstaller.dexopt(path, 1000, true, dexCodeInstructionSet, dexoptNeeded);
                                continue;
                            }
                            catch (FileNotFoundException e) {
                                Slog.w(TAG, "Jar not found: " + path);
                                continue;
                            }
                            catch (IOException e) {
                                Slog.w(TAG, "Exception reading jar: " + path, e);
                            }
                        }
                    }
                }
                Settings.VersionInfo ver = this.mSettings.getInternalVersion();
                this.mIsUpgrade = !Build.FINGERPRINT.equals(ver.fingerprint);
                boolean bl = this.mPromoteSystemApps = this.mIsUpgrade && ver.sdkVersion <= 22;
                if (this.mPromoteSystemApps) {
                    for (PackageSetting ps : this.mSettings.mPackages.values()) {
                        if (!PackageManagerService.isSystemApp(ps)) continue;
                        this.mExistingSystemPackages.add(ps.name);
                    }
                }
                File vendorOverlayDir = new File(VENDOR_OVERLAY_DIR);
                this.scanDirLI(vendorOverlayDir, 65, 17312, 0L);
                this.scanDirLI(frameworkDir, 193, 16802, 0L);
                File privilegedAppDir = new File(Environment.getRootDirectory(), "priv-app");
                this.scanDirLI(privilegedAppDir, 193, 16800, 0L);
                File systemAppDir = new File(Environment.getRootDirectory(), "app");
                this.scanDirLI(systemAppDir, 65, 16800, 0L);
                File vendorAppDir = new File("/vendor/app");
                try {
                    vendorAppDir = vendorAppDir.getCanonicalFile();
                }
                catch (IOException e) {
                    // empty catch block
                }
                this.scanDirLI(vendorAppDir, 65, 16800, 0L);
                File oemAppDir = new File(Environment.getOemDirectory(), "app");
                this.scanDirLI(oemAppDir, 65, 16800, 0L);
                this.mInstaller.moveFiles();
                ArrayList<String> possiblyDeletedUpdatedSystemApps = new ArrayList<String>();
                if (!this.mOnlyCore) {
                    Iterator<PackageSetting> psit = this.mSettings.mPackages.values().iterator();
                    while (psit.hasNext()) {
                        PackageSetting ps = psit.next();
                        if ((ps.pkgFlags & 1) == 0) continue;
                        PackageParser.Package scannedPkg = this.mPackages.get(ps.name);
                        if (scannedPkg != null) {
                            if (!this.mSettings.isDisabledSystemPackageLPr(ps.name)) continue;
                            PackageManagerService.logCriticalInfo(5, "Expecting better updated system app for " + ps.name + "; removing system app.  Last known codePath=" + ps.codePathString + ", installStatus=" + ps.installStatus + ", versionCode=" + ps.versionCode + "; scanned versionCode=" + scannedPkg.mVersionCode);
                            this.removePackageLI(ps, true);
                            this.mExpectingBetter.put(ps.name, ps.codePath);
                            continue;
                        }
                        if (!this.mSettings.isDisabledSystemPackageLPr(ps.name)) {
                            psit.remove();
                            PackageManagerService.logCriticalInfo(5, "System package " + ps.name + " no longer exists; wiping its data");
                            this.removeDataDirsLI(null, ps.name);
                            continue;
                        }
                        PackageSetting disabledPs = this.mSettings.getDisabledSystemPkgLPr(ps.name);
                        if (disabledPs.codePath != null && disabledPs.codePath.exists()) continue;
                        possiblyDeletedUpdatedSystemApps.add(ps.name);
                    }
                }
                ArrayList<PackageSetting> deletePkgsList = this.mSettings.getListOfIncompleteInstallPackagesLPr();
                for (i = 0; i < deletePkgsList.size(); ++i) {
                    this.cleanupInstallFailedPackage(deletePkgsList.get(i));
                }
                this.deleteTempPackageFiles();
                this.mSettings.pruneSharedUsersLPw();
                if (!this.mOnlyCore) {
                    EventLog.writeEvent(3080, SystemClock.uptimeMillis());
                    this.scanDirLI(this.mAppInstallDir, 0, 20896, 0L);
                    this.scanDirLI(this.mDrmAppPrivateInstallDir, 16, 20896, 0L);
                    for (String deletedAppName : possiblyDeletedUpdatedSystemApps) {
                        String msg;
                        PackageParser.Package deletedPkg = this.mPackages.get(deletedAppName);
                        this.mSettings.removeDisabledSystemPackageLPw(deletedAppName);
                        if (deletedPkg == null) {
                            msg = "Updated system package " + deletedAppName + " no longer exists; wiping its data";
                            this.removeDataDirsLI(null, deletedAppName);
                        } else {
                            msg = "Updated system app + " + deletedAppName + " no longer present; removing system privileges for " + deletedAppName;
                            deletedPkg.applicationInfo.flags &= 0xFFFFFFFE;
                            PackageSetting deletedPs = this.mSettings.mPackages.get(deletedAppName);
                            deletedPs.pkgFlags &= 0xFFFFFFFE;
                        }
                        PackageManagerService.logCriticalInfo(5, msg);
                    }
                    for (i = 0; i < this.mExpectingBetter.size(); ++i) {
                        int reparseFlags;
                        String packageName = this.mExpectingBetter.keyAt(i);
                        if (this.mPackages.containsKey(packageName)) continue;
                        File scanFile = this.mExpectingBetter.valueAt(i);
                        PackageManagerService.logCriticalInfo(5, "Expected better " + packageName + " but never showed up; reverting to system");
                        if (FileUtils.contains(privilegedAppDir, scanFile)) {
                            reparseFlags = 193;
                        } else if (FileUtils.contains(systemAppDir, scanFile)) {
                            reparseFlags = 65;
                        } else if (FileUtils.contains(vendorAppDir, scanFile)) {
                            reparseFlags = 65;
                        } else if (FileUtils.contains(oemAppDir, scanFile)) {
                            reparseFlags = 65;
                        } else {
                            Slog.e(TAG, "Ignoring unexpected fallback path " + scanFile);
                            continue;
                        }
                        this.mSettings.enableSystemPackageLPw(packageName);
                        try {
                            this.scanPackageLI(scanFile, reparseFlags, 16800, 0L, null);
                            continue;
                        }
                        catch (PackageManagerException e) {
                            Slog.e(TAG, "Failed to parse original system package: " + e.getMessage());
                        }
                    }
                }
                this.mExpectingBetter.clear();
                this.updateAllSharedLibrariesLPw();
                for (SharedUserSetting setting : this.mSettings.getAllSharedUsersLPw()) {
                    this.adjustCpuAbisForSharedUserLPw(setting.packages, null, false, false);
                }
                this.mPackageUsage.readLP();
                EventLog.writeEvent(3090, SystemClock.uptimeMillis());
                Slog.i(TAG, "Time to scan packages: " + (float)(SystemClock.uptimeMillis() - startTime) / 1000.0f + " seconds");
                int updateFlags = 1;
                if (ver.sdkVersion != this.mSdkVersion) {
                    Slog.i(TAG, "Platform changed from " + ver.sdkVersion + " to " + this.mSdkVersion + "; regranting permissions for internal storage");
                    updateFlags |= 6;
                }
                this.updatePermissionsLPw(null, null, updateFlags);
                ver.sdkVersion = this.mSdkVersion;
                if (!(onlyCore || !this.mPromoteSystemApps && this.mRestoredSettings)) {
                    for (UserInfo user : sUserManager.getUsers(true)) {
                        this.mSettings.applyDefaultPreferredAppsLPw(this, user.id);
                        this.applyFactoryDefaultBrowserLPw(user.id);
                        this.primeDomainVerificationsLPw(user.id);
                    }
                }
                if (this.mIsUpgrade && !onlyCore) {
                    Slog.i(TAG, "Build fingerprint changed; clearing code caches");
                    for (int i5 = 0; i5 < this.mSettings.mPackages.size(); ++i5) {
                        PackageSetting ps = this.mSettings.mPackages.valueAt(i5);
                        if (!Objects.equals(StorageManager.UUID_PRIVATE_INTERNAL, ps.volumeUuid)) continue;
                        this.deleteCodeCacheDirsLI(ps.volumeUuid, ps.name);
                    }
                    ver.fingerprint = Build.FINGERPRINT;
                }
                this.checkDefaultBrowser();
                this.mExistingSystemPackages.clear();
                this.mPromoteSystemApps = false;
                ver.databaseVersion = 3;
                this.mSettings.writeLPr();
                EventLog.writeEvent(3100, SystemClock.uptimeMillis());
                this.mRequiredVerifierPackage = this.getRequiredVerifierLPr();
                this.mRequiredInstallerPackage = this.getRequiredInstallerLPr();
                this.mInstallerService = new PackageInstallerService(context, this);
                this.mIntentFilterVerifierComponent = this.getIntentFilterVerifierComponentNameLPr();
                this.mIntentFilterVerifier = new IntentVerifierProxy(this.mContext, this.mIntentFilterVerifierComponent);
            }
        }
        Runtime.getRuntime().gc();
        LocalServices.addService(PackageManagerInternal.class, new PackageManagerInternalImpl());
    }

    @Override
    public boolean isFirstBoot() {
        return !this.mRestoredSettings;
    }

    @Override
    public boolean isOnlyCoreApps() {
        return this.mOnlyCore;
    }

    @Override
    public boolean isUpgrade() {
        return this.mIsUpgrade;
    }

    private String getRequiredVerifierLPr() {
        Intent verification = new Intent("android.intent.action.PACKAGE_NEEDS_VERIFICATION");
        List<ResolveInfo> receivers = this.queryIntentReceivers(verification, PACKAGE_MIME_TYPE, 512, 0);
        String requiredVerifier = null;
        int N = receivers.size();
        for (int i = 0; i < N; ++i) {
            String packageName;
            ResolveInfo info = receivers.get(i);
            if (info.activityInfo == null || this.checkPermission("android.permission.PACKAGE_VERIFICATION_AGENT", packageName = info.activityInfo.packageName, 0) != 0) continue;
            if (requiredVerifier != null) {
                throw new RuntimeException("There can be only one required verifier");
            }
            requiredVerifier = packageName;
        }
        return requiredVerifier;
    }

    private String getRequiredInstallerLPr() {
        Intent installerIntent = new Intent("android.intent.action.INSTALL_PACKAGE");
        installerIntent.addCategory("android.intent.category.DEFAULT");
        installerIntent.setDataAndType(Uri.fromFile(new File("foo.apk")), PACKAGE_MIME_TYPE);
        List<ResolveInfo> installers = this.queryIntentActivities(installerIntent, PACKAGE_MIME_TYPE, 0, 0);
        String requiredInstaller = null;
        int N = installers.size();
        for (int i = 0; i < N; ++i) {
            ResolveInfo info = installers.get(i);
            String packageName = info.activityInfo.packageName;
            if (!info.activityInfo.applicationInfo.isSystemApp()) continue;
            if (requiredInstaller != null) {
                throw new RuntimeException("There must be one required installer");
            }
            requiredInstaller = packageName;
        }
        if (requiredInstaller == null) {
            throw new RuntimeException("There must be one required installer");
        }
        return requiredInstaller;
    }

    private ComponentName getIntentFilterVerifierComponentNameLPr() {
        Intent verification = new Intent("android.intent.action.INTENT_FILTER_NEEDS_VERIFICATION");
        List<ResolveInfo> receivers = this.queryIntentReceivers(verification, PACKAGE_MIME_TYPE, 512, 0);
        ComponentName verifierComponentName = null;
        int priority = -1000;
        int N = receivers.size();
        for (int i = 0; i < N; ++i) {
            String packageName;
            PackageSetting ps;
            ResolveInfo info = receivers.get(i);
            if (info.activityInfo == null || (ps = this.mSettings.mPackages.get(packageName = info.activityInfo.packageName)) == null || this.checkPermission("android.permission.INTENT_FILTER_VERIFICATION_AGENT", packageName, 0) != 0 || priority >= info.priority) continue;
            priority = info.priority;
            verifierComponentName = new ComponentName(packageName, info.activityInfo.name);
        }
        return verifierComponentName;
    }

    private void primeDomainVerificationsLPw(int userId) {
        SystemConfig systemConfig = SystemConfig.getInstance();
        ArraySet<String> packages = systemConfig.getLinkedApps();
        ArraySet<String> domains = new ArraySet<String>();
        for (String packageName : packages) {
            PackageParser.Package pkg = this.mPackages.get(packageName);
            if (pkg != null) {
                if (!pkg.isSystemApp()) {
                    Slog.w(TAG, "Non-system app '" + packageName + "' in sysconfig <app-link>");
                    continue;
                }
                domains.clear();
                for (PackageParser.Activity a : pkg.activities) {
                    for (PackageParser.ActivityIntentInfo filter : a.intents) {
                        if (!PackageManagerService.hasValidDomains(filter)) continue;
                        domains.addAll(filter.getHostsList());
                    }
                }
                if (domains.size() > 0) {
                    IntentFilterVerificationInfo ivi = this.mSettings.createIntentFilterVerificationIfNeededLPw(packageName, new ArrayList<String>(domains));
                    ivi.setStatus(0);
                    this.mSettings.updateIntentFilterVerificationStatusLPw(packageName, 2, userId);
                    continue;
                }
                Slog.w(TAG, "Sysconfig <app-link> package '" + packageName + "' does not handle web links");
                continue;
            }
            Slog.w(TAG, "Unknown package '" + packageName + "' in sysconfig <app-link>");
        }
        this.scheduleWritePackageRestrictionsLocked(userId);
        this.scheduleWriteSettingsLocked();
    }

    private void applyFactoryDefaultBrowserLPw(int userId) {
        String browserPkg = this.mContext.getResources().getString(17039404);
        if (!TextUtils.isEmpty(browserPkg)) {
            PackageSetting ps = this.mSettings.mPackages.get(browserPkg);
            if (ps == null) {
                Slog.e(TAG, "Product default browser app does not exist: " + browserPkg);
                browserPkg = null;
            } else {
                this.mSettings.setDefaultBrowserPackageNameLPw(browserPkg, userId);
            }
        }
        if (browserPkg == null) {
            this.calculateDefaultBrowserLPw(userId);
        }
    }

    private void calculateDefaultBrowserLPw(int userId) {
        List<String> allBrowsers = this.resolveAllBrowserApps(userId);
        String browserPkg = allBrowsers.size() == 1 ? allBrowsers.get(0) : null;
        this.mSettings.setDefaultBrowserPackageNameLPw(browserPkg, userId);
    }

    private List<String> resolveAllBrowserApps(int userId) {
        List<ResolveInfo> list = this.queryIntentActivities(sBrowserIntent, null, 131072, userId);
        int count = list.size();
        ArrayList<String> result = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            ResolveInfo info = list.get(i);
            if (info.activityInfo == null || !info.handleAllWebDataURI || (info.activityInfo.applicationInfo.flags & 1) == 0 || result.contains(info.activityInfo.packageName)) continue;
            result.add(info.activityInfo.packageName);
        }
        return result;
    }

    private boolean packageIsBrowser(String packageName, int userId) {
        List<ResolveInfo> list = this.queryIntentActivities(sBrowserIntent, null, 131072, userId);
        int N = list.size();
        for (int i = 0; i < N; ++i) {
            ResolveInfo info = list.get(i);
            if (!packageName.equals(info.activityInfo.packageName)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDefaultBrowser() {
        PackageInfo info;
        int myUserId = UserHandle.myUserId();
        String packageName = this.getDefaultBrowserPackageName(myUserId);
        if (packageName != null && (info = this.getPackageInfo(packageName, 0, myUserId)) == null) {
            Slog.w(TAG, "Default browser no longer installed: " + packageName);
            ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
            synchronized (arrayMap) {
                this.applyFactoryDefaultBrowserLPw(myUserId);
            }
        }
    }

    @Override
    public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        try {
            return super.onTransact(code, data, reply, flags);
        }
        catch (RuntimeException e) {
            if (!(e instanceof SecurityException) && !(e instanceof IllegalArgumentException)) {
                Slog.wtf(TAG, "Package Manager Crash", e);
            }
            throw e;
        }
    }

    void cleanupInstallFailedPackage(PackageSetting ps) {
        PackageManagerService.logCriticalInfo(5, "Cleaning up incompletely installed app: " + ps.name);
        this.removeDataDirsLI(ps.volumeUuid, ps.name);
        if (ps.codePath != null) {
            if (ps.codePath.isDirectory()) {
                this.mInstaller.rmPackageDir(ps.codePath.getAbsolutePath());
            } else {
                ps.codePath.delete();
            }
        }
        if (ps.resourcePath != null && !ps.resourcePath.equals(ps.codePath)) {
            if (ps.resourcePath.isDirectory()) {
                FileUtils.deleteContents(ps.resourcePath);
            }
            ps.resourcePath.delete();
        }
        this.mSettings.removePackageLPw(ps.name);
    }

    static int[] appendInts(int[] cur, int[] add) {
        if (add == null) {
            return cur;
        }
        if (cur == null) {
            return add;
        }
        int N = add.length;
        for (int i = 0; i < N; ++i) {
            cur = ArrayUtils.appendInt(cur, add[i]);
        }
        return cur;
    }

    PackageInfo generatePackageInfo(PackageParser.Package p, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        PackageSetting ps = (PackageSetting)p.mExtras;
        if (ps == null) {
            return null;
        }
        PermissionsState permissionsState = ps.getPermissionsState();
        int[] gids = permissionsState.computeGids(userId);
        Set<String> permissions = permissionsState.getPermissions(userId);
        PackageUserState state = ps.readUserState(userId);
        return PackageParser.generatePackageInfo(p, gids, flags, ps.firstInstallTime, ps.lastUpdateTime, permissions, state, userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPackageFrozen(String packageName) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageSetting ps = this.mSettings.mPackages.get(packageName);
            if (ps != null) {
                return ps.frozen;
            }
        }
        Slog.w(TAG, "Package " + packageName + " is missing; assuming frozen");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPackageAvailable(String packageName, int userId) {
        if (!sUserManager.exists(userId)) {
            return false;
        }
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, false, false, "is package available");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageUserState state;
            PackageSetting ps;
            PackageParser.Package p = this.mPackages.get(packageName);
            if (p != null && (ps = (PackageSetting)p.mExtras) != null && (state = ps.readUserState(userId)) != null) {
                return PackageParser.isAvailable(state);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PackageInfo getPackageInfo(String packageName, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, false, false, "get package info");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageParser.Package p = this.mPackages.get(packageName);
            if (p != null) {
                return this.generatePackageInfo(p, flags, userId);
            }
            if ((flags & 0x2000) != 0) {
                return this.generatePackageInfoFromSettingsLPw(packageName, flags, userId);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] currentToCanonicalPackageNames(String[] names) {
        String[] out = new String[names.length];
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            for (int i = names.length - 1; i >= 0; --i) {
                PackageSetting ps = this.mSettings.mPackages.get(names[i]);
                out[i] = ps != null && ps.realName != null ? ps.realName : names[i];
            }
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] canonicalToCurrentPackageNames(String[] names) {
        String[] out = new String[names.length];
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            for (int i = names.length - 1; i >= 0; --i) {
                String cur = this.mSettings.mRenamedPackages.get(names[i]);
                out[i] = cur != null ? cur : names[i];
            }
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPackageUid(String packageName, int userId) {
        if (!sUserManager.exists(userId)) {
            return -1;
        }
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, false, false, "get package uid");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageParser.Package p = this.mPackages.get(packageName);
            if (p != null) {
                return UserHandle.getUid(userId, p.applicationInfo.uid);
            }
            PackageSetting ps = this.mSettings.mPackages.get(packageName);
            if (ps == null || ps.pkg == null || ps.pkg.applicationInfo == null) {
                return -1;
            }
            p = ps.pkg;
            int n = p != null ? UserHandle.getUid(userId, p.applicationInfo.uid) : -1;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getPackageGids(String packageName, int userId) throws RemoteException {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, false, false, "getPackageGids");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageParser.Package p = this.mPackages.get(packageName);
            if (p != null) {
                PackageSetting ps = (PackageSetting)p.mExtras;
                return ps.getPermissionsState().computeGids(userId);
            }
        }
        return null;
    }

    static PermissionInfo generatePermissionInfo(BasePermission bp, int flags) {
        if (bp.perm != null) {
            return PackageParser.generatePermissionInfo(bp.perm, flags);
        }
        PermissionInfo pi = new PermissionInfo();
        pi.name = bp.name;
        pi.packageName = bp.sourcePackage;
        pi.nonLocalizedLabel = bp.name;
        pi.protectionLevel = bp.protectionLevel;
        return pi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PermissionInfo getPermissionInfo(String name, int flags) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            BasePermission p = this.mSettings.mPermissions.get(name);
            if (p != null) {
                return PackageManagerService.generatePermissionInfo(p, flags);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PermissionInfo> queryPermissionsByGroup(String group, int flags) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            ArrayList<PermissionInfo> out = new ArrayList<PermissionInfo>(10);
            for (BasePermission p : this.mSettings.mPermissions.values()) {
                if (group == null) {
                    if (p.perm != null && p.perm.info.group != null) continue;
                    out.add(PackageManagerService.generatePermissionInfo(p, flags));
                    continue;
                }
                if (p.perm == null || !group.equals(p.perm.info.group)) continue;
                out.add(PackageParser.generatePermissionInfo(p.perm, flags));
            }
            if (out.size() > 0) {
                return out;
            }
            return this.mPermissionGroups.containsKey(group) ? out : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PermissionGroupInfo getPermissionGroupInfo(String name, int flags) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            return PackageParser.generatePermissionGroupInfo(this.mPermissionGroups.get(name), flags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PermissionGroupInfo> getAllPermissionGroups(int flags) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            int N = this.mPermissionGroups.size();
            ArrayList<PermissionGroupInfo> out = new ArrayList<PermissionGroupInfo>(N);
            for (PackageParser.PermissionGroup pg : this.mPermissionGroups.values()) {
                out.add(PackageParser.generatePermissionGroupInfo(pg, flags));
            }
            return out;
        }
    }

    private ApplicationInfo generateApplicationInfoFromSettingsLPw(String packageName, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        PackageSetting ps = this.mSettings.mPackages.get(packageName);
        if (ps != null) {
            if (ps.pkg == null) {
                PackageInfo pInfo = this.generatePackageInfoFromSettingsLPw(packageName, flags, userId);
                if (pInfo != null) {
                    return pInfo.applicationInfo;
                }
                return null;
            }
            return PackageParser.generateApplicationInfo(ps.pkg, flags, ps.readUserState(userId), userId);
        }
        return null;
    }

    private PackageInfo generatePackageInfoFromSettingsLPw(String packageName, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        PackageSetting ps = this.mSettings.mPackages.get(packageName);
        if (ps != null) {
            PackageParser.Package pkg = ps.pkg;
            if (pkg == null) {
                if ((flags & 0x2000) == 0) {
                    return null;
                }
                pkg = new PackageParser.Package(packageName);
                pkg.applicationInfo.packageName = packageName;
                pkg.applicationInfo.flags = ps.pkgFlags | 0x1000000;
                pkg.applicationInfo.privateFlags = ps.pkgPrivateFlags;
                pkg.applicationInfo.dataDir = Environment.getDataUserPackageDirectory(ps.volumeUuid, userId, packageName).getAbsolutePath();
                pkg.applicationInfo.primaryCpuAbi = ps.primaryCpuAbiString;
                pkg.applicationInfo.secondaryCpuAbi = ps.secondaryCpuAbiString;
            }
            return this.generatePackageInfo(pkg, flags, userId);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApplicationInfo getApplicationInfo(String packageName, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, false, false, "get application info");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageParser.Package p = this.mPackages.get(packageName);
            if (p != null) {
                PackageSetting ps = this.mSettings.mPackages.get(packageName);
                if (ps == null) {
                    return null;
                }
                return PackageParser.generateApplicationInfo(p, flags, ps.readUserState(userId), userId);
            }
            if ("android".equals(packageName) || "system".equals(packageName)) {
                return this.mAndroidApplication;
            }
            if ((flags & 0x2000) != 0) {
                return this.generateApplicationInfoFromSettingsLPw(packageName, flags, userId);
            }
        }
        return null;
    }

    @Override
    public void freeStorageAndNotify(final String volumeUuid, final long freeStorageSize, final IPackageDataObserver observer) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CLEAR_APP_CACHE", null);
        this.mHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                PackageManagerService.this.mHandler.removeCallbacks(this);
                int retCode = -1;
                Object object = PackageManagerService.this.mInstallLock;
                synchronized (object) {
                    retCode = PackageManagerService.this.mInstaller.freeCache(volumeUuid, freeStorageSize);
                    if (retCode < 0) {
                        Slog.w(PackageManagerService.TAG, "Couldn't clear application caches");
                    }
                }
                if (observer != null) {
                    try {
                        observer.onRemoveCompleted(null, retCode >= 0);
                    }
                    catch (RemoteException e) {
                        Slog.w(PackageManagerService.TAG, "RemoveException when invoking call back");
                    }
                }
            }
        });
    }

    @Override
    public void freeStorage(final String volumeUuid, final long freeStorageSize, final IntentSender pi) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CLEAR_APP_CACHE", null);
        this.mHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                PackageManagerService.this.mHandler.removeCallbacks(this);
                int retCode = -1;
                Object object = PackageManagerService.this.mInstallLock;
                synchronized (object) {
                    retCode = PackageManagerService.this.mInstaller.freeCache(volumeUuid, freeStorageSize);
                    if (retCode < 0) {
                        Slog.w(PackageManagerService.TAG, "Couldn't clear application caches");
                    }
                }
                if (pi != null) {
                    try {
                        int code = retCode >= 0 ? 1 : 0;
                        pi.sendIntent(null, code, null, null, null);
                    }
                    catch (IntentSender.SendIntentException e1) {
                        Slog.i(PackageManagerService.TAG, "Failed to send pending intent");
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void freeStorage(String volumeUuid, long freeStorageSize) throws IOException {
        Object object = this.mInstallLock;
        synchronized (object) {
            if (this.mInstaller.freeCache(volumeUuid, freeStorageSize) < 0) {
                throw new IOException("Failed to free enough space");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActivityInfo getActivityInfo(ComponentName component, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, false, false, "get activity info");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageParser.Activity a = (PackageParser.Activity)this.mActivities.mActivities.get(component);
            if (a != null && this.mSettings.isEnabledLPr(a.info, flags, userId)) {
                PackageSetting ps = this.mSettings.mPackages.get(component.getPackageName());
                if (ps == null) {
                    return null;
                }
                return PackageParser.generateActivityInfo(a, flags, ps.readUserState(userId), userId);
            }
            if (this.mResolveComponentName.equals(component)) {
                return PackageParser.generateActivityInfo(this.mResolveActivity, flags, new PackageUserState(), userId);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean activitySupportsIntent(ComponentName component, Intent intent, String resolvedType) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            if (component.equals(this.mResolveComponentName)) {
                return true;
            }
            PackageParser.Activity a = (PackageParser.Activity)this.mActivities.mActivities.get(component);
            if (a == null) {
                return false;
            }
            for (int i = 0; i < a.intents.size(); ++i) {
                if (((PackageParser.ActivityIntentInfo)a.intents.get(i)).match(intent.getAction(), resolvedType, intent.getScheme(), intent.getData(), intent.getCategories(), TAG) < 0) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActivityInfo getReceiverInfo(ComponentName component, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, false, false, "get receiver info");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageParser.Activity a = (PackageParser.Activity)this.mReceivers.mActivities.get(component);
            if (a != null && this.mSettings.isEnabledLPr(a.info, flags, userId)) {
                PackageSetting ps = this.mSettings.mPackages.get(component.getPackageName());
                if (ps == null) {
                    return null;
                }
                return PackageParser.generateActivityInfo(a, flags, ps.readUserState(userId), userId);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceInfo getServiceInfo(ComponentName component, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, false, false, "get service info");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageParser.Service s = (PackageParser.Service)this.mServices.mServices.get(component);
            if (s != null && this.mSettings.isEnabledLPr(s.info, flags, userId)) {
                PackageSetting ps = this.mSettings.mPackages.get(component.getPackageName());
                if (ps == null) {
                    return null;
                }
                return PackageParser.generateServiceInfo(s, flags, ps.readUserState(userId), userId);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProviderInfo getProviderInfo(ComponentName component, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, false, false, "get provider info");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageParser.Provider p = (PackageParser.Provider)this.mProviders.mProviders.get(component);
            if (p != null && this.mSettings.isEnabledLPr(p.info, flags, userId)) {
                PackageSetting ps = this.mSettings.mPackages.get(component.getPackageName());
                if (ps == null) {
                    return null;
                }
                return PackageParser.generateProviderInfo(p, flags, ps.readUserState(userId), userId);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getSystemSharedLibraryNames() {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            Set<String> libSet = this.mSharedLibraries.keySet();
            int size = libSet.size();
            if (size > 0) {
                String[] libs = new String[size];
                libSet.toArray(libs);
                return libs;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PackageParser.Package findSharedNonSystemLibrary(String libName) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            SharedLibraryEntry lib = this.mSharedLibraries.get(libName);
            if (lib != null && lib.apk != null) {
                return this.mPackages.get(lib.apk);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FeatureInfo[] getSystemAvailableFeatures() {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            Collection<FeatureInfo> featSet = this.mAvailableFeatures.values();
            int size = featSet.size();
            if (size > 0) {
                FeatureInfo[] features = new FeatureInfo[size + 1];
                featSet.toArray(features);
                FeatureInfo fi = new FeatureInfo();
                fi.reqGlEsVersion = SystemProperties.getInt("ro.opengles.version", 0);
                features[size] = fi;
                return features;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasSystemFeature(String name) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            return this.mAvailableFeatures.containsKey(name);
        }
    }

    private void checkValidCaller(int uid, int userId) {
        if (UserHandle.getUserId(uid) == userId || uid == 1000 || uid == 0) {
            return;
        }
        throw new SecurityException("Caller uid=" + uid + " is not privileged to communicate with user=" + userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int checkPermission(String permName, String pkgName, int userId) {
        if (!sUserManager.exists(userId)) {
            return -1;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageParser.Package p = this.mPackages.get(pkgName);
            if (p != null && p.mExtras != null) {
                PackageSetting ps = (PackageSetting)p.mExtras;
                PermissionsState permissionsState = ps.getPermissionsState();
                if (permissionsState.hasPermission(permName, userId)) {
                    return 0;
                }
                if ("android.permission.ACCESS_COARSE_LOCATION".equals(permName) && permissionsState.hasPermission("android.permission.ACCESS_FINE_LOCATION", userId)) {
                    return 0;
                }
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int checkUidPermission(String permName, int uid) {
        int userId = UserHandle.getUserId(uid);
        if (!sUserManager.exists(userId)) {
            return -1;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            Object obj = this.mSettings.getUserIdLPr(UserHandle.getAppId(uid));
            if (obj != null) {
                SettingBase ps = (SettingBase)obj;
                PermissionsState permissionsState = ps.getPermissionsState();
                if (permissionsState.hasPermission(permName, userId)) {
                    return 0;
                }
                if ("android.permission.ACCESS_COARSE_LOCATION".equals(permName) && permissionsState.hasPermission("android.permission.ACCESS_FINE_LOCATION", userId)) {
                    return 0;
                }
            } else {
                ArraySet<String> perms = this.mSystemPermissions.get(uid);
                if (perms != null) {
                    if (perms.contains(permName)) {
                        return 0;
                    }
                    if ("android.permission.ACCESS_COARSE_LOCATION".equals(permName) && perms.contains("android.permission.ACCESS_FINE_LOCATION")) {
                        return 0;
                    }
                }
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPermissionRevokedByPolicy(String permission2, String packageName, int userId) {
        if (UserHandle.getCallingUserId() != userId) {
            this.mContext.enforceCallingPermission("android.permission.INTERACT_ACROSS_USERS_FULL", "isPermissionRevokedByPolicy for user " + userId);
        }
        if (this.checkPermission(permission2, packageName, userId) == 0) {
            return false;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            int flags = this.getPermissionFlags(permission2, packageName, userId);
            boolean bl = (flags & 4) != 0;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPermissionControllerPackageName() {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            return this.mRequiredInstallerPackage;
        }
    }

    void enforceCrossUserPermission(int callingUid, int userId, boolean requireFullPermission, boolean checkShell, String message) {
        if (userId < 0) {
            throw new IllegalArgumentException("Invalid userId " + userId);
        }
        if (checkShell) {
            this.enforceShellRestriction("no_debugging_features", callingUid, userId);
        }
        if (userId == UserHandle.getUserId(callingUid)) {
            return;
        }
        if (callingUid != 1000 && callingUid != 0) {
            if (requireFullPermission) {
                this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL", message);
            } else {
                try {
                    this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL", message);
                }
                catch (SecurityException se) {
                    this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS", message);
                }
            }
        }
    }

    void enforceShellRestriction(String restriction, int callingUid, int userHandle) {
        if (callingUid == 2000) {
            if (userHandle >= 0 && sUserManager.hasUserRestriction(restriction, userHandle)) {
                throw new SecurityException("Shell does not have permission to access user " + userHandle);
            }
            if (userHandle < 0) {
                Slog.e(TAG, "Unable to check shell permission for user " + userHandle + "\n\t" + Debug.getCallers(3));
            }
        }
    }

    private BasePermission findPermissionTreeLP(String permName) {
        for (BasePermission bp : this.mSettings.mPermissionTrees.values()) {
            if (!permName.startsWith(bp.name) || permName.length() <= bp.name.length() || permName.charAt(bp.name.length()) != '.') continue;
            return bp;
        }
        return null;
    }

    private BasePermission checkPermissionTreeLP(String permName) {
        BasePermission bp;
        if (permName != null && (bp = this.findPermissionTreeLP(permName)) != null) {
            if (bp.uid == UserHandle.getAppId(Binder.getCallingUid())) {
                return bp;
            }
            throw new SecurityException("Calling uid " + Binder.getCallingUid() + " is not allowed to add to permission tree " + bp.name + " owned by uid " + bp.uid);
        }
        throw new SecurityException("No permission tree found for " + permName);
    }

    static boolean compareStrings(CharSequence s1, CharSequence s2) {
        if (s1 == null) {
            return s2 == null;
        }
        if (s2 == null) {
            return false;
        }
        if (s1.getClass() != s2.getClass()) {
            return false;
        }
        return s1.equals(s2);
    }

    static boolean comparePermissionInfos(PermissionInfo pi1, PermissionInfo pi2) {
        if (pi1.icon != pi2.icon) {
            return false;
        }
        if (pi1.logo != pi2.logo) {
            return false;
        }
        if (pi1.protectionLevel != pi2.protectionLevel) {
            return false;
        }
        if (!PackageManagerService.compareStrings(pi1.name, pi2.name)) {
            return false;
        }
        if (!PackageManagerService.compareStrings(pi1.nonLocalizedLabel, pi2.nonLocalizedLabel)) {
            return false;
        }
        return PackageManagerService.compareStrings(pi1.packageName, pi2.packageName);
    }

    int permissionInfoFootprint(PermissionInfo info) {
        int size = info.name.length();
        if (info.nonLocalizedLabel != null) {
            size += info.nonLocalizedLabel.length();
        }
        if (info.nonLocalizedDescription != null) {
            size += info.nonLocalizedDescription.length();
        }
        return size;
    }

    int calculateCurrentPermissionFootprintLocked(BasePermission tree) {
        int size = 0;
        for (BasePermission perm : this.mSettings.mPermissions.values()) {
            if (perm.uid != tree.uid) continue;
            size += perm.name.length() + this.permissionInfoFootprint(perm.perm.info);
        }
        return size;
    }

    void enforcePermissionCapLocked(PermissionInfo info, BasePermission tree) {
        int curTreeSize;
        if (tree.uid != 1000 && (curTreeSize = this.calculateCurrentPermissionFootprintLocked(tree)) + this.permissionInfoFootprint(info) > 32768) {
            throw new SecurityException("Permission tree size cap exceeded");
        }
    }

    boolean addPermissionLocked(PermissionInfo info, boolean async) {
        if (info.labelRes == 0 && info.nonLocalizedLabel == null) {
            throw new SecurityException("Label must be specified in permission");
        }
        BasePermission tree = this.checkPermissionTreeLP(info.name);
        BasePermission bp = this.mSettings.mPermissions.get(info.name);
        boolean added = bp == null;
        boolean changed = true;
        int fixedLevel = PermissionInfo.fixProtectionLevel(info.protectionLevel);
        if (added) {
            this.enforcePermissionCapLocked(info, tree);
            bp = new BasePermission(info.name, tree.sourcePackage, 2);
        } else {
            if (bp.type != 2) {
                throw new SecurityException("Not allowed to modify non-dynamic permission " + info.name);
            }
            if (bp.protectionLevel == fixedLevel && bp.perm.owner.equals(tree.perm.owner) && bp.uid == tree.uid && PackageManagerService.comparePermissionInfos(bp.perm.info, info)) {
                changed = false;
            }
        }
        bp.protectionLevel = fixedLevel;
        info = new PermissionInfo(info);
        info.protectionLevel = fixedLevel;
        bp.perm = new PackageParser.Permission(tree.perm.owner, info);
        bp.perm.info.packageName = tree.perm.info.packageName;
        bp.uid = tree.uid;
        if (added) {
            this.mSettings.mPermissions.put(info.name, bp);
        }
        if (changed) {
            if (!async) {
                this.mSettings.writeLPr();
            } else {
                this.scheduleWriteSettingsLocked();
            }
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addPermission(PermissionInfo info) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            return this.addPermissionLocked(info, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addPermissionAsync(PermissionInfo info) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            return this.addPermissionLocked(info, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePermission(String name) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            this.checkPermissionTreeLP(name);
            BasePermission bp = this.mSettings.mPermissions.get(name);
            if (bp != null) {
                if (bp.type != 2) {
                    throw new SecurityException("Not allowed to modify non-dynamic permission " + name);
                }
                this.mSettings.mPermissions.remove(name);
                this.mSettings.writeLPr();
            }
        }
    }

    private static void enforceDeclaredAsUsedAndRuntimeOrDevelopmentPermission(PackageParser.Package pkg, BasePermission bp) {
        int index = pkg.requestedPermissions.indexOf(bp.name);
        if (index == -1) {
            throw new SecurityException("Package " + pkg.packageName + " has not requested permission " + bp.name);
        }
        if (!bp.isRuntime() && !bp.isDevelopment()) {
            throw new SecurityException("Permission " + bp.name + " is not a changeable permission type");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantRuntimePermission(String packageName, String name, final int userId) {
        int uid;
        if (!sUserManager.exists(userId)) {
            Log.e(TAG, "No such user:" + userId);
            return;
        }
        this.mContext.enforceCallingOrSelfPermission("android.permission.GRANT_RUNTIME_PERMISSIONS", "grantRuntimePermission");
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, true, false, "grantRuntimePermission");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageParser.Package pkg = this.mPackages.get(packageName);
            if (pkg == null) {
                throw new IllegalArgumentException("Unknown package: " + packageName);
            }
            BasePermission bp = this.mSettings.mPermissions.get(name);
            if (bp == null) {
                throw new IllegalArgumentException("Unknown permission: " + name);
            }
            PackageManagerService.enforceDeclaredAsUsedAndRuntimeOrDevelopmentPermission(pkg, bp);
            uid = UserHandle.getUid(userId, pkg.applicationInfo.uid);
            SettingBase sb = (SettingBase)pkg.mExtras;
            if (sb == null) {
                throw new IllegalArgumentException("Unknown package: " + packageName);
            }
            PermissionsState permissionsState = sb.getPermissionsState();
            int flags = permissionsState.getPermissionFlags(name, userId);
            if ((flags & 0x10) != 0) {
                throw new SecurityException("Cannot grant system fixed permission: " + name + " for package: " + packageName);
            }
            if (bp.isDevelopment()) {
                if (permissionsState.grantInstallPermission(bp) != -1) {
                    this.scheduleWriteSettingsLocked();
                }
                return;
            }
            int result = permissionsState.grantRuntimePermission(bp, userId);
            switch (result) {
                case -1: {
                    return;
                }
                case 1: {
                    final int appId = UserHandle.getAppId(pkg.applicationInfo.uid);
                    this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            PackageManagerService.this.killUid(appId, userId, PackageManagerService.KILL_APP_REASON_GIDS_CHANGED);
                        }
                    });
                }
            }
            this.mOnPermissionChangeListeners.onPermissionsChanged(uid);
            this.mSettings.writeRuntimePermissionsForUserLPr(userId, false);
        }
        if ("android.permission.READ_EXTERNAL_STORAGE".equals(name) || "android.permission.WRITE_EXTERNAL_STORAGE".equals(name)) {
            long token = Binder.clearCallingIdentity();
            try {
                if (sUserManager.isInitialized(userId)) {
                    MountServiceInternal mountServiceInternal = LocalServices.getService(MountServiceInternal.class);
                    mountServiceInternal.onExternalStoragePolicyChanged(uid, packageName);
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revokeRuntimePermission(String packageName, String name, int userId) {
        int appId;
        if (!sUserManager.exists(userId)) {
            Log.e(TAG, "No such user:" + userId);
            return;
        }
        this.mContext.enforceCallingOrSelfPermission("android.permission.REVOKE_RUNTIME_PERMISSIONS", "revokeRuntimePermission");
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, true, false, "revokeRuntimePermission");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageParser.Package pkg = this.mPackages.get(packageName);
            if (pkg == null) {
                throw new IllegalArgumentException("Unknown package: " + packageName);
            }
            BasePermission bp = this.mSettings.mPermissions.get(name);
            if (bp == null) {
                throw new IllegalArgumentException("Unknown permission: " + name);
            }
            PackageManagerService.enforceDeclaredAsUsedAndRuntimeOrDevelopmentPermission(pkg, bp);
            SettingBase sb = (SettingBase)pkg.mExtras;
            if (sb == null) {
                throw new IllegalArgumentException("Unknown package: " + packageName);
            }
            PermissionsState permissionsState = sb.getPermissionsState();
            int flags = permissionsState.getPermissionFlags(name, userId);
            if ((flags & 0x10) != 0) {
                throw new SecurityException("Cannot revoke system fixed permission: " + name + " for package: " + packageName);
            }
            if (bp.isDevelopment()) {
                if (permissionsState.revokeInstallPermission(bp) != -1) {
                    this.scheduleWriteSettingsLocked();
                }
                return;
            }
            if (permissionsState.revokeRuntimePermission(bp, userId) == -1) {
                return;
            }
            this.mOnPermissionChangeListeners.onPermissionsChanged(pkg.applicationInfo.uid);
            this.mSettings.writeRuntimePermissionsForUserLPr(userId, true);
            appId = UserHandle.getAppId(pkg.applicationInfo.uid);
        }
        this.killUid(appId, userId, KILL_APP_REASON_PERMISSIONS_REVOKED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetRuntimePermissions() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.REVOKE_RUNTIME_PERMISSIONS", "revokeRuntimePermission");
        int callingUid = Binder.getCallingUid();
        if (callingUid != 1000 && callingUid != 0) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL", "resetRuntimePermissions");
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            this.updatePermissionsLPw(null, null, 1);
            for (int userId : UserManagerService.getInstance().getUserIds()) {
                int packageCount = this.mPackages.size();
                for (int i = 0; i < packageCount; ++i) {
                    PackageParser.Package pkg = this.mPackages.valueAt(i);
                    if (!(pkg.mExtras instanceof PackageSetting)) continue;
                    PackageSetting ps = (PackageSetting)pkg.mExtras;
                    this.resetUserChangesToRuntimePermissionsAndFlagsLPw(ps, userId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPermissionFlags(String name, String packageName, int userId) {
        if (!sUserManager.exists(userId)) {
            return 0;
        }
        this.enforceGrantRevokeRuntimePermissionPermissions("getPermissionFlags");
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, true, false, "getPermissionFlags");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageParser.Package pkg = this.mPackages.get(packageName);
            if (pkg == null) {
                throw new IllegalArgumentException("Unknown package: " + packageName);
            }
            BasePermission bp = this.mSettings.mPermissions.get(name);
            if (bp == null) {
                throw new IllegalArgumentException("Unknown permission: " + name);
            }
            SettingBase sb = (SettingBase)pkg.mExtras;
            if (sb == null) {
                throw new IllegalArgumentException("Unknown package: " + packageName);
            }
            PermissionsState permissionsState = sb.getPermissionsState();
            return permissionsState.getPermissionFlags(name, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePermissionFlags(String name, String packageName, int flagMask, int flagValues, int userId) {
        if (!sUserManager.exists(userId)) {
            return;
        }
        this.enforceGrantRevokeRuntimePermissionPermissions("updatePermissionFlags");
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, true, false, "updatePermissionFlags");
        if (PackageManagerService.getCallingUid() != 1000) {
            flagMask &= 0xFFFFFFEF;
            flagValues &= 0xFFFFFFEF;
            flagMask &= 0xFFFFFFDF;
            flagValues &= 0xFFFFFFDF;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            boolean hadState;
            PackageParser.Package pkg = this.mPackages.get(packageName);
            if (pkg == null) {
                throw new IllegalArgumentException("Unknown package: " + packageName);
            }
            BasePermission bp = this.mSettings.mPermissions.get(name);
            if (bp == null) {
                throw new IllegalArgumentException("Unknown permission: " + name);
            }
            SettingBase sb = (SettingBase)pkg.mExtras;
            if (sb == null) {
                throw new IllegalArgumentException("Unknown package: " + packageName);
            }
            PermissionsState permissionsState = sb.getPermissionsState();
            int flags = permissionsState.getPermissionFlags(bp.name, userId);
            if ((flags & 0x10) != 0) {
                return;
            }
            boolean bl = hadState = permissionsState.getRuntimePermissionState(name, userId) != null;
            if (permissionsState.updatePermissionFlags(bp, userId, flagMask, flagValues)) {
                if (permissionsState.getInstallPermissionState(name) != null) {
                    this.scheduleWriteSettingsLocked();
                } else if (permissionsState.getRuntimePermissionState(name, userId) != null || hadState) {
                    this.mSettings.writeRuntimePermissionsForUserLPr(userId, false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePermissionFlagsForAllApps(int flagMask, int flagValues, int userId) {
        if (!sUserManager.exists(userId)) {
            return;
        }
        this.enforceGrantRevokeRuntimePermissionPermissions("updatePermissionFlagsForAllApps");
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, true, false, "updatePermissionFlagsForAllApps");
        if (PackageManagerService.getCallingUid() != 1000) {
            flagMask &= 0xFFFFFFEF;
            flagValues &= 0xFFFFFFEF;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            boolean changed = false;
            int packageCount = this.mPackages.size();
            for (int pkgIndex = 0; pkgIndex < packageCount; ++pkgIndex) {
                PackageParser.Package pkg = this.mPackages.valueAt(pkgIndex);
                SettingBase sb = (SettingBase)pkg.mExtras;
                if (sb == null) continue;
                PermissionsState permissionsState = sb.getPermissionsState();
                changed |= permissionsState.updatePermissionFlagsForAllPermissions(userId, flagMask, flagValues);
            }
            if (changed) {
                this.mSettings.writeRuntimePermissionsForUserLPr(userId, false);
            }
        }
    }

    private void enforceGrantRevokeRuntimePermissionPermissions(String message) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.GRANT_RUNTIME_PERMISSIONS") != 0 && this.mContext.checkCallingOrSelfPermission("android.permission.REVOKE_RUNTIME_PERMISSIONS") != 0) {
            throw new SecurityException(message + " requires " + "android.permission.GRANT_RUNTIME_PERMISSIONS" + " or " + "android.permission.REVOKE_RUNTIME_PERMISSIONS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shouldShowRequestPermissionRationale(String permissionName, String packageName, int userId) {
        int flags;
        if (UserHandle.getCallingUserId() != userId) {
            this.mContext.enforceCallingPermission("android.permission.INTERACT_ACROSS_USERS_FULL", "canShowRequestPermissionRationale for user " + userId);
        }
        int uid = this.getPackageUid(packageName, userId);
        if (UserHandle.getAppId(PackageManagerService.getCallingUid()) != UserHandle.getAppId(uid)) {
            return false;
        }
        if (this.checkPermission(permissionName, packageName, userId) == 0) {
            return false;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            flags = this.getPermissionFlags(permissionName, packageName, userId);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
        int fixedFlags = 22;
        if ((flags & 0x16) != 0) {
            return false;
        }
        return (flags & 1) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOnPermissionsChangeListener(IOnPermissionsChangeListener listener) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.OBSERVE_GRANT_REVOKE_PERMISSIONS", "addOnPermissionsChangeListener");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            this.mOnPermissionChangeListeners.addListenerLocked(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeOnPermissionsChangeListener(IOnPermissionsChangeListener listener) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            this.mOnPermissionChangeListeners.removeListenerLocked(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isProtectedBroadcast(String actionName) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            return this.mProtectedBroadcasts.contains(actionName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int checkSignatures(String pkg1, String pkg2) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageParser.Package p1 = this.mPackages.get(pkg1);
            PackageParser.Package p2 = this.mPackages.get(pkg2);
            if (p1 == null || p1.mExtras == null || p2 == null || p2.mExtras == null) {
                return -4;
            }
            return PackageManagerService.compareSignatures(p1.mSignatures, p2.mSignatures);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int checkUidSignatures(int uid1, int uid2) {
        uid1 = UserHandle.getAppId(uid1);
        uid2 = UserHandle.getAppId(uid2);
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            Signature[] s2;
            Signature[] s1;
            Object obj = this.mSettings.getUserIdLPr(uid1);
            if (obj == null) {
                return -4;
            }
            if (obj instanceof SharedUserSetting) {
                s1 = ((SharedUserSetting)obj).signatures.mSignatures;
            } else {
                if (!(obj instanceof PackageSetting)) {
                    return -4;
                }
                s1 = ((PackageSetting)obj).signatures.mSignatures;
            }
            obj = this.mSettings.getUserIdLPr(uid2);
            if (obj == null) {
                return -4;
            }
            if (obj instanceof SharedUserSetting) {
                s2 = ((SharedUserSetting)obj).signatures.mSignatures;
            } else {
                if (!(obj instanceof PackageSetting)) {
                    return -4;
                }
                s2 = ((PackageSetting)obj).signatures.mSignatures;
            }
            return PackageManagerService.compareSignatures(s1, s2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killUid(int appId, int userId, String reason) {
        long identity = Binder.clearCallingIdentity();
        try {
            IActivityManager am = ActivityManagerNative.getDefault();
            if (am != null) {
                try {
                    am.killUid(appId, userId, reason);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    static int compareSignatures(Signature[] s1, Signature[] s2) {
        if (s1 == null) {
            return s2 == null ? 1 : -1;
        }
        if (s2 == null) {
            return -2;
        }
        if (s1.length != s2.length) {
            return -3;
        }
        if (s1.length == 1) {
            return s1[0].equals(s2[0]) ? 0 : -3;
        }
        ArraySet<Signature> set1 = new ArraySet<Signature>();
        for (Signature sig : s1) {
            set1.add(sig);
        }
        ArraySet<Signature> set2 = new ArraySet<Signature>();
        for (Signature sig : s2) {
            set2.add(sig);
        }
        if (set1.equals(set2)) {
            return 0;
        }
        return -3;
    }

    private boolean isCompatSignatureUpdateNeeded(PackageParser.Package scannedPkg) {
        Settings.VersionInfo ver = this.getSettingsVersionForPackage(scannedPkg);
        return ver.databaseVersion < 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int compareSignaturesCompat(PackageSignatures existingSigs, PackageParser.Package scannedPkg) {
        if (!this.isCompatSignatureUpdateNeeded(scannedPkg)) {
            return -3;
        }
        ArraySet<Signature> existingSet = new ArraySet<Signature>();
        for (Signature sig : existingSigs.mSignatures) {
            existingSet.add(sig);
        }
        ArraySet<Signature> scannedCompatSet = new ArraySet<Signature>();
        for (Signature sig : scannedPkg.mSignatures) {
            try {
                Signature[] chainSignatures;
                for (Signature chainSig : chainSignatures = sig.getChainSignatures()) {
                    scannedCompatSet.add(chainSig);
                }
            }
            catch (CertificateEncodingException e) {
                scannedCompatSet.add(sig);
            }
        }
        if (scannedCompatSet.equals(existingSet)) {
            existingSigs.assignSignatures(scannedPkg.mSignatures);
            ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
            synchronized (arrayMap) {
                this.mSettings.mKeySetManagerService.removeAppKeySetDataLPw(scannedPkg.packageName);
            }
            return 0;
        }
        return -3;
    }

    private boolean isRecoverSignatureUpdateNeeded(PackageParser.Package scannedPkg) {
        Settings.VersionInfo ver = this.getSettingsVersionForPackage(scannedPkg);
        return ver.databaseVersion < 3;
    }

    private int compareSignaturesRecover(PackageSignatures existingSigs, PackageParser.Package scannedPkg) {
        if (!this.isRecoverSignatureUpdateNeeded(scannedPkg)) {
            return -3;
        }
        String msg = null;
        try {
            if (Signature.areEffectiveMatch(existingSigs.mSignatures, scannedPkg.mSignatures)) {
                PackageManagerService.logCriticalInfo(4, "Recovered effectively matching certificates for " + scannedPkg.packageName);
                return 0;
            }
        }
        catch (CertificateException e) {
            msg = e.getMessage();
        }
        PackageManagerService.logCriticalInfo(4, "Failed to recover certificates for " + scannedPkg.packageName + ": " + msg);
        return -3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getPackagesForUid(int uid) {
        uid = UserHandle.getAppId(uid);
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            Object obj = this.mSettings.getUserIdLPr(uid);
            if (obj instanceof SharedUserSetting) {
                SharedUserSetting sus = (SharedUserSetting)obj;
                int N = sus.packages.size();
                String[] res = new String[N];
                Iterator<PackageSetting> it = sus.packages.iterator();
                int i = 0;
                while (it.hasNext()) {
                    res[i++] = it.next().name;
                }
                return res;
            }
            if (obj instanceof PackageSetting) {
                PackageSetting ps = (PackageSetting)obj;
                return new String[]{ps.name};
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNameForUid(int uid) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            Object obj = this.mSettings.getUserIdLPr(UserHandle.getAppId(uid));
            if (obj instanceof SharedUserSetting) {
                SharedUserSetting sus = (SharedUserSetting)obj;
                return sus.name + ":" + sus.userId;
            }
            if (obj instanceof PackageSetting) {
                PackageSetting ps = (PackageSetting)obj;
                return ps.name;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUidForSharedUser(String sharedUserName) {
        if (sharedUserName == null) {
            return -1;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            SharedUserSetting suid = this.mSettings.getSharedUserLPw(sharedUserName, 0, 0, false);
            if (suid == null) {
                return -1;
            }
            return suid.userId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFlagsForUid(int uid) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            Object obj = this.mSettings.getUserIdLPr(UserHandle.getAppId(uid));
            if (obj instanceof SharedUserSetting) {
                SharedUserSetting sus = (SharedUserSetting)obj;
                return sus.pkgFlags;
            }
            if (obj instanceof PackageSetting) {
                PackageSetting ps = (PackageSetting)obj;
                return ps.pkgFlags;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPrivateFlagsForUid(int uid) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            Object obj = this.mSettings.getUserIdLPr(UserHandle.getAppId(uid));
            if (obj instanceof SharedUserSetting) {
                SharedUserSetting sus = (SharedUserSetting)obj;
                return sus.pkgPrivateFlags;
            }
            if (obj instanceof PackageSetting) {
                PackageSetting ps = (PackageSetting)obj;
                return ps.pkgPrivateFlags;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUidPrivileged(int uid) {
        uid = UserHandle.getAppId(uid);
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            Object obj = this.mSettings.getUserIdLPr(uid);
            if (obj instanceof SharedUserSetting) {
                SharedUserSetting sus = (SharedUserSetting)obj;
                Iterator<PackageSetting> it = sus.packages.iterator();
                while (it.hasNext()) {
                    if (!it.next().isPrivileged()) continue;
                    return true;
                }
            } else if (obj instanceof PackageSetting) {
                PackageSetting ps = (PackageSetting)obj;
                return ps.isPrivileged();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getAppOpPermissionPackages(String permissionName) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            ArraySet<String> pkgs = this.mAppOpPermissionPackages.get(permissionName);
            if (pkgs == null) {
                return null;
            }
            return pkgs.toArray(new String[pkgs.size()]);
        }
    }

    @Override
    public ResolveInfo resolveIntent(Intent intent, String resolvedType, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, false, false, "resolve intent");
        List<ResolveInfo> query = this.queryIntentActivities(intent, resolvedType, flags, userId);
        return this.chooseBestActivity(intent, resolvedType, flags, query, userId);
    }

    @Override
    public void setLastChosenActivity(Intent intent, String resolvedType, int flags, IntentFilter filter, int match, ComponentName activity) {
        int userId = UserHandle.getCallingUserId();
        intent.setComponent(null);
        List<ResolveInfo> query = this.queryIntentActivities(intent, resolvedType, flags, userId);
        this.findPreferredActivity(intent, resolvedType, flags, query, 0, false, true, false, userId);
        this.addPreferredActivityInternal(filter, match, null, activity, false, userId, "Setting last chosen");
    }

    @Override
    public ResolveInfo getLastChosenActivity(Intent intent, String resolvedType, int flags) {
        int userId = UserHandle.getCallingUserId();
        List<ResolveInfo> query = this.queryIntentActivities(intent, resolvedType, flags, userId);
        return this.findPreferredActivity(intent, resolvedType, flags, query, 0, false, false, false, userId);
    }

    private ResolveInfo chooseBestActivity(Intent intent, String resolvedType, int flags, List<ResolveInfo> query, int userId) {
        if (query != null) {
            int N = query.size();
            if (N == 1) {
                return query.get(0);
            }
            if (N > 1) {
                boolean debug = (intent.getFlags() & 8) != 0;
                ResolveInfo r0 = query.get(0);
                ResolveInfo r1 = query.get(1);
                if (debug) {
                    Slog.v(TAG, r0.activityInfo.name + "=" + r0.priority + " vs " + r1.activityInfo.name + "=" + r1.priority);
                }
                if (r0.priority != r1.priority || r0.preferredOrder != r1.preferredOrder || r0.isDefault != r1.isDefault) {
                    return query.get(0);
                }
                ResolveInfo ri = this.findPreferredActivity(intent, resolvedType, flags, query, r0.priority, true, false, debug, userId);
                if (ri != null) {
                    return ri;
                }
                ri = new ResolveInfo(this.mResolveInfo);
                ri.activityInfo = new ActivityInfo(ri.activityInfo);
                ri.activityInfo.applicationInfo = new ApplicationInfo(ri.activityInfo.applicationInfo);
                if (userId != 0) {
                    ri.activityInfo.applicationInfo.uid = UserHandle.getUid(userId, UserHandle.getAppId(ri.activityInfo.applicationInfo.uid));
                }
                if (ri.activityInfo.metaData == null) {
                    ri.activityInfo.metaData = new Bundle();
                }
                ri.activityInfo.metaData.putBoolean("android.dock_home", true);
                return ri;
            }
        }
        return null;
    }

    private ResolveInfo findPersistentPreferredActivityLP(Intent intent, String resolvedType, int flags, List<ResolveInfo> query, boolean debug, int userId) {
        List pprefs;
        int N = query.size();
        PersistentPreferredIntentResolver ppir = this.mSettings.mPersistentPreferredActivities.get(userId);
        if (debug) {
            Slog.v(TAG, "Looking for presistent preferred activities...");
        }
        List list = ppir != null ? ppir.queryIntent(intent, resolvedType, (flags & 0x10000) != 0, userId) : (pprefs = null);
        if (pprefs != null && pprefs.size() > 0) {
            int M = pprefs.size();
            for (int i = 0; i < M; ++i) {
                PersistentPreferredActivity ppa = (PersistentPreferredActivity)pprefs.get(i);
                if (debug) {
                    Slog.v(TAG, "Checking PersistentPreferredActivity ds=" + (ppa.countDataSchemes() > 0 ? ppa.getDataScheme(0) : "<none>") + "\n  component=" + ppa.mComponent);
                    ppa.dump(new LogPrinter(2, TAG, 3), "  ");
                }
                ActivityInfo ai = this.getActivityInfo(ppa.mComponent, flags | 0x200, userId);
                if (debug) {
                    Slog.v(TAG, "Found persistent preferred activity:");
                    if (ai != null) {
                        ai.dump(new LogPrinter(2, TAG, 3), "  ");
                    } else {
                        Slog.v(TAG, "  null");
                    }
                }
                if (ai == null) continue;
                for (int j = 0; j < N; ++j) {
                    ResolveInfo ri = query.get(j);
                    if (!ri.activityInfo.applicationInfo.packageName.equals(ai.applicationInfo.packageName) || !ri.activityInfo.name.equals(ai.name)) continue;
                    if (debug) {
                        Slog.v(TAG, "Returning persistent preferred activity: " + ri.activityInfo.packageName + "/" + ri.activityInfo.name);
                    }
                    return ri;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ResolveInfo findPreferredActivity(Intent intent, String resolvedType, int flags, List<ResolveInfo> query, int priority, boolean always, boolean removeMatches, boolean debug, int userId) {
        if (!PackageManagerService.sUserManager.exists(userId)) {
            return null;
        }
        var10_10 = this.mPackages;
        synchronized (var10_10) {
            if (intent.getSelector() != null) {
                intent = intent.getSelector();
            }
            if ((pri = this.findPersistentPreferredActivityLP(intent, resolvedType, flags, query, debug, userId)) != null) {
                return pri;
            }
            pir = this.mSettings.mPreferredActivities.get(userId);
            if (debug) {
                Slog.v("PackageManager", "Looking for preferred activities...");
            }
            v0 = pir != null ? pir.queryIntent(intent, resolvedType, (flags & 65536) != 0, userId) : (prefs = null);
            if (prefs != null && prefs.size() > 0) {
                changed = false;
                try {
                    match = 0;
                    if (debug) {
                        Slog.v("PackageManager", "Figuring out best match...");
                    }
                    N = query.size();
                    for (j = 0; j < N; ++j) {
                        ri = query.get(j);
                        if (debug) {
                            Slog.v("PackageManager", "Match for " + ri.activityInfo + ": 0x" + Integer.toHexString(match));
                        }
                        if (ri.match <= match) continue;
                        match = ri.match;
                    }
                    if (debug) {
                        Slog.v("PackageManager", "Best match: 0x" + Integer.toHexString(match));
                    }
                    match &= 0xFFF0000;
                    M = prefs.size();
                    block8: for (i = 0; i < M; ++i) {
                        pa = (PreferredActivity)prefs.get(i);
                        if (debug) {
                            Slog.v("PackageManager", "Checking PreferredActivity ds=" + (pa.countDataSchemes() > 0 ? pa.getDataScheme(0) : "<none>") + "\n  component=" + pa.mPref.mComponent);
                            pa.dump(new LogPrinter(2, "PackageManager", 3), "  ");
                        }
                        if (pa.mPref.mMatch != match) {
                            if (!debug) continue;
                            Slog.v("PackageManager", "Skipping bad match " + Integer.toHexString(pa.mPref.mMatch));
                            continue;
                        }
                        if (always && !pa.mPref.mAlways) {
                            if (!debug) continue;
                            Slog.v("PackageManager", "Skipping mAlways=false entry");
                            continue;
                        }
                        ai = this.getActivityInfo(pa.mPref.mComponent, flags | 512, userId);
                        if (debug) {
                            Slog.v("PackageManager", "Found preferred activity:");
                            if (ai != null) {
                                ai.dump(new LogPrinter(2, "PackageManager", 3), "  ");
                            } else {
                                Slog.v("PackageManager", "  null");
                            }
                        }
                        if (ai == null) {
                            Slog.w("PackageManager", "Removing dangling preferred activity: " + pa.mPref.mComponent);
                            pir.removeFilter(pa);
                            changed = true;
                            continue;
                        }
                        for (j = 0; j < N; ++j) {
                            ri = query.get(j);
                            if (!ri.activityInfo.applicationInfo.packageName.equals(ai.applicationInfo.packageName) || !ri.activityInfo.name.equals(ai.name)) continue;
                            if (removeMatches) {
                                pir.removeFilter(pa);
                                changed = true;
                                continue block8;
                            }
                            if (always && !pa.mPref.sameSet(query)) {
                                Slog.i("PackageManager", "Result set changed, dropping preferred activity for " + intent + " type " + resolvedType);
                                pir.removeFilter(pa);
                                lastChosen = new PreferredActivity(pa, pa.mPref.mMatch, null, pa.mPref.mComponent, false);
                                pir.addFilter(lastChosen);
                                changed = true;
                                var24_26 = null;
                                return var24_26;
                            }
                            if (debug) {
                                Slog.v("PackageManager", "Returning preferred activity: " + ri.activityInfo.packageName + "/" + ri.activityInfo.name);
                            }
                            var23_25 = ri;
                            return var23_25;
                        }
                    }
                }
                finally {
                    if (changed) {
                        this.scheduleWritePackageRestrictionsLocked(userId);
                    }
                }
            }
            ** if (!debug) goto lbl97
        }
lbl-1000:
        // 1 sources

        {
            Slog.v("PackageManager", "No preferred activity to return");
        }
lbl97:
        // 2 sources

        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canForwardTo(Intent intent, String resolvedType, int sourceUserId, int targetUserId) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL", null);
        List<CrossProfileIntentFilter> matches = this.getMatchingCrossProfileIntentFilters(intent, resolvedType, sourceUserId);
        if (matches != null) {
            int size = matches.size();
            for (int i = 0; i < size; ++i) {
                if (matches.get(i).getTargetUserId() != targetUserId) continue;
                return true;
            }
        }
        if (PackageManagerService.hasWebURI(intent)) {
            UserInfo parent = this.getProfileParent(sourceUserId);
            ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
            synchronized (arrayMap) {
                CrossProfileDomainInfo xpDomainInfo = this.getCrossProfileDomainPreferredLpr(intent, resolvedType, 0, sourceUserId, parent.id);
                return xpDomainInfo != null;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserInfo getProfileParent(int userId) {
        long identity = Binder.clearCallingIdentity();
        try {
            UserInfo userInfo = sUserManager.getProfileParent(userId);
            return userInfo;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    private List<CrossProfileIntentFilter> getMatchingCrossProfileIntentFilters(Intent intent, String resolvedType, int userId) {
        CrossProfileIntentResolver resolver = this.mSettings.mCrossProfileIntentResolvers.get(userId);
        if (resolver != null) {
            return resolver.queryIntent(intent, resolvedType, false, userId);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ResolveInfo> queryIntentActivities(Intent intent, String resolvedType, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return Collections.emptyList();
        }
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, false, false, "query intent activities");
        ComponentName comp = intent.getComponent();
        if (comp == null && intent.getSelector() != null) {
            intent = intent.getSelector();
            comp = intent.getComponent();
        }
        if (comp != null) {
            ArrayList<ResolveInfo> list = new ArrayList<ResolveInfo>(1);
            ActivityInfo ai = this.getActivityInfo(comp, flags, userId);
            if (ai != null) {
                ResolveInfo ri = new ResolveInfo();
                ri.activityInfo = ai;
                list.add(ri);
            }
            return list;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            String pkgName = intent.getPackage();
            if (pkgName == null) {
                List<CrossProfileIntentFilter> matchingFilters = this.getMatchingCrossProfileIntentFilters(intent, resolvedType, userId);
                ResolveInfo xpResolveInfo = this.querySkipCurrentProfileIntents(matchingFilters, intent, resolvedType, flags, userId);
                if (xpResolveInfo != null && this.isUserEnabled(xpResolveInfo.targetUserId)) {
                    ArrayList<ResolveInfo> result = new ArrayList<ResolveInfo>(1);
                    result.add(xpResolveInfo);
                    return this.filterIfNotPrimaryUser(result, userId);
                }
                List<ResolveInfo> result = this.mActivities.queryIntent(intent, resolvedType, flags, userId);
                xpResolveInfo = this.queryCrossProfileIntents(matchingFilters, intent, resolvedType, flags, userId);
                if (xpResolveInfo != null && this.isUserEnabled(xpResolveInfo.targetUserId)) {
                    result.add(xpResolveInfo);
                    Collections.sort(result, mResolvePrioritySorter);
                }
                result = this.filterIfNotPrimaryUser(result, userId);
                if (PackageManagerService.hasWebURI(intent)) {
                    CrossProfileDomainInfo xpDomainInfo = null;
                    UserInfo parent = this.getProfileParent(userId);
                    if (parent != null) {
                        xpDomainInfo = this.getCrossProfileDomainPreferredLpr(intent, resolvedType, flags, userId, parent.id);
                    }
                    if (xpDomainInfo != null) {
                        if (xpResolveInfo != null) {
                            result.remove(xpResolveInfo);
                        }
                        if (result.size() == 0) {
                            result.add(xpDomainInfo.resolveInfo);
                            return result;
                        }
                    } else if (result.size() <= 1) {
                        return result;
                    }
                    result = this.filterCandidatesWithDomainPreferredActivitiesLPr(intent, flags, result, xpDomainInfo, userId);
                    Collections.sort(result, mResolvePrioritySorter);
                }
                return result;
            }
            PackageParser.Package pkg = this.mPackages.get(pkgName);
            if (pkg != null) {
                return this.filterIfNotPrimaryUser(this.mActivities.queryIntentForPackage(intent, resolvedType, flags, pkg.activities, userId), userId);
            }
            return new ArrayList<ResolveInfo>();
        }
    }

    private CrossProfileDomainInfo getCrossProfileDomainPreferredLpr(Intent intent, String resolvedType, int flags, int sourceUserId, int parentUserId) {
        if (!sUserManager.hasUserRestriction("allow_parent_profile_app_linking", sourceUserId)) {
            return null;
        }
        List<ResolveInfo> resultTargetUser = this.mActivities.queryIntent(intent, resolvedType, flags, parentUserId);
        if (resultTargetUser == null || resultTargetUser.isEmpty()) {
            return null;
        }
        CrossProfileDomainInfo result = null;
        int size = resultTargetUser.size();
        for (int i = 0; i < size; ++i) {
            String packageName;
            PackageSetting ps;
            ResolveInfo riTargetUser = resultTargetUser.get(i);
            if (riTargetUser.handleAllWebDataURI || (ps = this.mSettings.mPackages.get(packageName = riTargetUser.activityInfo.packageName)) == null) continue;
            long verificationState = this.getDomainVerificationStatusLPr(ps, parentUserId);
            int status = (int)(verificationState >> 32);
            if (result == null) {
                result = new CrossProfileDomainInfo();
                result.resolveInfo = this.createForwardingResolveInfo(new IntentFilter(), sourceUserId, parentUserId);
                result.bestDomainVerificationStatus = status;
                continue;
            }
            result.bestDomainVerificationStatus = this.bestDomainVerificationStatus(status, result.bestDomainVerificationStatus);
        }
        if (result != null && result.bestDomainVerificationStatus == 3) {
            return null;
        }
        return result;
    }

    private int bestDomainVerificationStatus(int status1, int status2) {
        if (status1 == 3) {
            return status2;
        }
        if (status2 == 3) {
            return status1;
        }
        return (int)MathUtils.max(status1, status2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isUserEnabled(int userId) {
        long callingId = Binder.clearCallingIdentity();
        try {
            UserInfo userInfo = sUserManager.getUserInfo(userId);
            boolean bl = userInfo != null && userInfo.isEnabled();
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(callingId);
        }
    }

    private List<ResolveInfo> filterIfNotPrimaryUser(List<ResolveInfo> resolveInfos, int userId) {
        if (userId == 0) {
            return resolveInfos;
        }
        for (int i = resolveInfos.size() - 1; i >= 0; --i) {
            ResolveInfo info = resolveInfos.get(i);
            if ((info.activityInfo.flags & 0x20000000) == 0) continue;
            resolveInfos.remove(i);
        }
        return resolveInfos;
    }

    private static boolean hasWebURI(Intent intent) {
        if (intent.getData() == null) {
            return false;
        }
        String scheme = intent.getScheme();
        if (TextUtils.isEmpty(scheme)) {
            return false;
        }
        return scheme.equals("http") || scheme.equals("https");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ResolveInfo> filterCandidatesWithDomainPreferredActivitiesLPr(Intent intent, int matchFlags, List<ResolveInfo> candidates, CrossProfileDomainInfo xpDomainInfo, int userId) {
        boolean debug = (intent.getFlags() & 8) != 0;
        ArrayList<ResolveInfo> result = new ArrayList<ResolveInfo>();
        ArrayList<ResolveInfo> alwaysList = new ArrayList<ResolveInfo>();
        ArrayList<ResolveInfo> undefinedList = new ArrayList<ResolveInfo>();
        ArrayList<ResolveInfo> alwaysAskList = new ArrayList<ResolveInfo>();
        ArrayList<ResolveInfo> neverList = new ArrayList<ResolveInfo>();
        ArrayList<ResolveInfo> matchAllList = new ArrayList<ResolveInfo>();
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            int count = candidates.size();
            for (int n = 0; n < count; ++n) {
                ResolveInfo info = candidates.get(n);
                String packageName = info.activityInfo.packageName;
                PackageSetting ps = this.mSettings.mPackages.get(packageName);
                if (ps == null) continue;
                if (info.handleAllWebDataURI) {
                    matchAllList.add(info);
                    continue;
                }
                long packedStatus = this.getDomainVerificationStatusLPr(ps, userId);
                int status = (int)(packedStatus >> 32);
                int linkGeneration = (int)(packedStatus & 0xFFFFFFFFFFFFFFFFL);
                if (status == 2) {
                    info.preferredOrder = linkGeneration;
                    alwaysList.add(info);
                    continue;
                }
                if (status == 3) {
                    neverList.add(info);
                    continue;
                }
                if (status == 4) {
                    alwaysAskList.add(info);
                    continue;
                }
                if (status != 0 && status != 1) continue;
                undefinedList.add(info);
            }
            boolean includeBrowser = false;
            if (alwaysList.size() > 0) {
                result.addAll(alwaysList);
            } else if (xpDomainInfo != null && xpDomainInfo.bestDomainVerificationStatus == 2) {
                result.add(xpDomainInfo.resolveInfo);
            } else {
                result.addAll(undefinedList);
                if (xpDomainInfo != null && (xpDomainInfo.bestDomainVerificationStatus == 0 || xpDomainInfo.bestDomainVerificationStatus == 1)) {
                    result.add(xpDomainInfo.resolveInfo);
                }
                includeBrowser = true;
            }
            if (alwaysAskList.size() > 0) {
                for (ResolveInfo i : result) {
                    i.preferredOrder = 0;
                }
                result.addAll(alwaysAskList);
                includeBrowser = true;
            }
            if (includeBrowser) {
                if ((matchFlags & 0x20000) != 0) {
                    result.addAll(matchAllList);
                } else {
                    String defaultBrowserPackageName = this.getDefaultBrowserPackageName(userId);
                    int maxMatchPrio = 0;
                    ResolveInfo defaultBrowserMatch = null;
                    int numCandidates = matchAllList.size();
                    for (int n = 0; n < numCandidates; ++n) {
                        ResolveInfo info = (ResolveInfo)matchAllList.get(n);
                        if (info.priority > maxMatchPrio) {
                            maxMatchPrio = info.priority;
                        }
                        if (!info.activityInfo.packageName.equals(defaultBrowserPackageName) || defaultBrowserMatch != null && defaultBrowserMatch.priority >= info.priority) continue;
                        if (debug) {
                            Slog.v(TAG, "Considering default browser match " + info);
                        }
                        defaultBrowserMatch = info;
                    }
                    if (defaultBrowserMatch != null && defaultBrowserMatch.priority >= maxMatchPrio && !TextUtils.isEmpty(defaultBrowserPackageName)) {
                        if (debug) {
                            Slog.v(TAG, "Default browser match " + defaultBrowserMatch);
                        }
                        result.add(defaultBrowserMatch);
                    } else {
                        result.addAll(matchAllList);
                    }
                }
                if (result.size() == 0) {
                    result.addAll(candidates);
                    result.removeAll(neverList);
                }
            }
        }
        return result;
    }

    private long getDomainVerificationStatusLPr(PackageSetting ps, int userId) {
        long result = ps.getDomainVerificationStatusForUser(userId);
        if (result >> 32 == 0L && ps.getIntentFilterVerificationInfo() != null) {
            result = (long)ps.getIntentFilterVerificationInfo().getStatus() << 32;
        }
        return result;
    }

    private ResolveInfo querySkipCurrentProfileIntents(List<CrossProfileIntentFilter> matchingFilters, Intent intent, String resolvedType, int flags, int sourceUserId) {
        if (matchingFilters != null) {
            int size = matchingFilters.size();
            for (int i = 0; i < size; ++i) {
                ResolveInfo resolveInfo;
                CrossProfileIntentFilter filter = matchingFilters.get(i);
                if ((filter.getFlags() & 2) == 0 || (resolveInfo = this.checkTargetCanHandle(filter, intent, resolvedType, flags, sourceUserId)) == null) continue;
                return resolveInfo;
            }
        }
        return null;
    }

    private ResolveInfo queryCrossProfileIntents(List<CrossProfileIntentFilter> matchingFilters, Intent intent, String resolvedType, int flags, int sourceUserId) {
        if (matchingFilters != null) {
            SparseBooleanArray alreadyTriedUserIds = new SparseBooleanArray();
            int size = matchingFilters.size();
            for (int i = 0; i < size; ++i) {
                CrossProfileIntentFilter filter = matchingFilters.get(i);
                int targetUserId = filter.getTargetUserId();
                if ((filter.getFlags() & 2) != 0 || alreadyTriedUserIds.get(targetUserId)) continue;
                ResolveInfo resolveInfo = this.checkTargetCanHandle(filter, intent, resolvedType, flags, sourceUserId);
                if (resolveInfo != null) {
                    return resolveInfo;
                }
                alreadyTriedUserIds.put(targetUserId, true);
            }
        }
        return null;
    }

    private ResolveInfo checkTargetCanHandle(CrossProfileIntentFilter filter, Intent intent, String resolvedType, int flags, int sourceUserId) {
        List<ResolveInfo> resultTargetUser = this.mActivities.queryIntent(intent, resolvedType, flags, filter.getTargetUserId());
        if (resultTargetUser != null && !resultTargetUser.isEmpty()) {
            return this.createForwardingResolveInfo(filter, sourceUserId, filter.getTargetUserId());
        }
        return null;
    }

    private ResolveInfo createForwardingResolveInfo(IntentFilter filter, int sourceUserId, int targetUserId) {
        ResolveInfo forwardingResolveInfo = new ResolveInfo();
        String className = targetUserId == 0 ? IntentForwarderActivity.FORWARD_INTENT_TO_USER_OWNER : IntentForwarderActivity.FORWARD_INTENT_TO_MANAGED_PROFILE;
        ComponentName forwardingActivityComponentName = new ComponentName(this.mAndroidApplication.packageName, className);
        ActivityInfo forwardingActivityInfo = this.getActivityInfo(forwardingActivityComponentName, 0, sourceUserId);
        if (targetUserId == 0) {
            forwardingActivityInfo.showUserIcon = 0;
            forwardingResolveInfo.noResourceId = true;
        }
        forwardingResolveInfo.activityInfo = forwardingActivityInfo;
        forwardingResolveInfo.priority = 0;
        forwardingResolveInfo.preferredOrder = 0;
        forwardingResolveInfo.match = 0;
        forwardingResolveInfo.isDefault = true;
        forwardingResolveInfo.filter = filter;
        forwardingResolveInfo.targetUserId = targetUserId;
        return forwardingResolveInfo;
    }

    @Override
    public List<ResolveInfo> queryIntentActivityOptions(ComponentName caller, Intent[] specifics, String[] specificTypes, Intent intent, String resolvedType, int flags, int userId) {
        int N;
        int i;
        if (!sUserManager.exists(userId)) {
            return Collections.emptyList();
        }
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, false, false, "query intent activity options");
        String resultsAction = intent.getAction();
        List<ResolveInfo> results = this.queryIntentActivities(intent, resolvedType, flags | 0x40, userId);
        int specificsPos = 0;
        if (specifics != null) {
            for (i = 0; i < specifics.length; ++i) {
                Intent sintent = specifics[i];
                if (sintent == null) continue;
                String action = sintent.getAction();
                if (resultsAction != null && resultsAction.equals(action)) {
                    action = null;
                }
                ResolveInfo ri = null;
                ActivityInfo ai = null;
                ComponentName comp = sintent.getComponent();
                if (comp == null) {
                    ri = this.resolveIntent(sintent, specificTypes != null ? specificTypes[i] : null, flags, userId);
                    if (ri == null) continue;
                    if (ri == this.mResolveInfo) {
                        // empty if block
                    }
                    ai = ri.activityInfo;
                    comp = new ComponentName(ai.applicationInfo.packageName, ai.name);
                } else {
                    ai = this.getActivityInfo(comp, flags, userId);
                    if (ai == null) continue;
                }
                N = results.size();
                for (int j = specificsPos; j < N; ++j) {
                    ResolveInfo sri = results.get(j);
                    if ((!sri.activityInfo.name.equals(comp.getClassName()) || !sri.activityInfo.applicationInfo.packageName.equals(comp.getPackageName())) && (action == null || !sri.filter.matchAction(action))) continue;
                    results.remove(j);
                    if (ri == null) {
                        ri = sri;
                    }
                    --j;
                    --N;
                }
                if (ri == null) {
                    ri = new ResolveInfo();
                    ri.activityInfo = ai;
                }
                results.add(specificsPos, ri);
                ri.specificIndex = i;
                ++specificsPos;
            }
        }
        N = results.size();
        for (i = specificsPos; i < N - 1; ++i) {
            Iterator<String> it;
            ResolveInfo rii = results.get(i);
            if (rii.filter == null || (it = rii.filter.actionsIterator()) == null) continue;
            while (it.hasNext()) {
                String action = it.next();
                if (resultsAction != null && resultsAction.equals(action)) continue;
                for (int j = i + 1; j < N; ++j) {
                    ResolveInfo rij = results.get(j);
                    if (rij.filter == null || !rij.filter.hasAction(action)) continue;
                    results.remove(j);
                    --j;
                    --N;
                }
            }
            if ((flags & 0x40) != 0) continue;
            rii.filter = null;
        }
        if (caller != null) {
            N = results.size();
            for (i = 0; i < N; ++i) {
                ActivityInfo ainfo = results.get((int)i).activityInfo;
                if (!caller.getPackageName().equals(ainfo.applicationInfo.packageName) || !caller.getClassName().equals(ainfo.name)) continue;
                results.remove(i);
                break;
            }
        }
        if ((flags & 0x40) == 0) {
            N = results.size();
            for (i = 0; i < N; ++i) {
                results.get((int)i).filter = null;
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ResolveInfo> queryIntentReceivers(Intent intent, String resolvedType, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return Collections.emptyList();
        }
        ComponentName comp = intent.getComponent();
        if (comp == null && intent.getSelector() != null) {
            intent = intent.getSelector();
            comp = intent.getComponent();
        }
        if (comp != null) {
            ArrayList<ResolveInfo> list = new ArrayList<ResolveInfo>(1);
            ActivityInfo ai = this.getReceiverInfo(comp, flags, userId);
            if (ai != null) {
                ResolveInfo ri = new ResolveInfo();
                ri.activityInfo = ai;
                list.add(ri);
            }
            return list;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            String pkgName = intent.getPackage();
            if (pkgName == null) {
                return this.mReceivers.queryIntent(intent, resolvedType, flags, userId);
            }
            PackageParser.Package pkg = this.mPackages.get(pkgName);
            if (pkg != null) {
                return this.mReceivers.queryIntentForPackage(intent, resolvedType, flags, pkg.receivers, userId);
            }
            return null;
        }
    }

    @Override
    public ResolveInfo resolveService(Intent intent, String resolvedType, int flags, int userId) {
        List<ResolveInfo> query = this.queryIntentServices(intent, resolvedType, flags, userId);
        if (!sUserManager.exists(userId)) {
            return null;
        }
        if (query != null && query.size() >= 1) {
            return query.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ResolveInfo> queryIntentServices(Intent intent, String resolvedType, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return Collections.emptyList();
        }
        ComponentName comp = intent.getComponent();
        if (comp == null && intent.getSelector() != null) {
            intent = intent.getSelector();
            comp = intent.getComponent();
        }
        if (comp != null) {
            ArrayList<ResolveInfo> list = new ArrayList<ResolveInfo>(1);
            ServiceInfo si = this.getServiceInfo(comp, flags, userId);
            if (si != null) {
                ResolveInfo ri = new ResolveInfo();
                ri.serviceInfo = si;
                list.add(ri);
            }
            return list;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            String pkgName = intent.getPackage();
            if (pkgName == null) {
                return this.mServices.queryIntent(intent, resolvedType, flags, userId);
            }
            PackageParser.Package pkg = this.mPackages.get(pkgName);
            if (pkg != null) {
                return this.mServices.queryIntentForPackage(intent, resolvedType, flags, pkg.services, userId);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ResolveInfo> queryIntentContentProviders(Intent intent, String resolvedType, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return Collections.emptyList();
        }
        ComponentName comp = intent.getComponent();
        if (comp == null && intent.getSelector() != null) {
            intent = intent.getSelector();
            comp = intent.getComponent();
        }
        if (comp != null) {
            ArrayList<ResolveInfo> list = new ArrayList<ResolveInfo>(1);
            ProviderInfo pi = this.getProviderInfo(comp, flags, userId);
            if (pi != null) {
                ResolveInfo ri = new ResolveInfo();
                ri.providerInfo = pi;
                list.add(ri);
            }
            return list;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            String pkgName = intent.getPackage();
            if (pkgName == null) {
                return this.mProviders.queryIntent(intent, resolvedType, flags, userId);
            }
            PackageParser.Package pkg = this.mPackages.get(pkgName);
            if (pkg != null) {
                return this.mProviders.queryIntentForPackage(intent, resolvedType, flags, pkg.providers, userId);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParceledListSlice<PackageInfo> getInstalledPackages(int flags, int userId) {
        boolean listUninstalled = (flags & 0x2000) != 0;
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, true, false, "get installed packages");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            ArrayList<PackageInfo> list;
            if (listUninstalled) {
                list = new ArrayList(this.mSettings.mPackages.size());
                for (PackageSetting ps : this.mSettings.mPackages.values()) {
                    PackageInfo pi = ps.pkg != null ? this.generatePackageInfo(ps.pkg, flags, userId) : this.generatePackageInfoFromSettingsLPw(ps.name, flags, userId);
                    if (pi == null) continue;
                    list.add(pi);
                }
            } else {
                list = new ArrayList<PackageInfo>(this.mPackages.size());
                for (PackageParser.Package p : this.mPackages.values()) {
                    PackageInfo pi = this.generatePackageInfo(p, flags, userId);
                    if (pi == null) continue;
                    list.add(pi);
                }
            }
            return new ParceledListSlice<PackageInfo>(list);
        }
    }

    private void addPackageHoldingPermissions(ArrayList<PackageInfo> list, PackageSetting ps, String[] permissions, boolean[] tmp, int flags, int userId) {
        int numMatch = 0;
        PermissionsState permissionsState = ps.getPermissionsState();
        for (int i = 0; i < permissions.length; ++i) {
            String permission2 = permissions[i];
            if (permissionsState.hasPermission(permission2, userId)) {
                tmp[i] = true;
                ++numMatch;
                continue;
            }
            tmp[i] = false;
        }
        if (numMatch == 0) {
            return;
        }
        PackageInfo pi = ps.pkg != null ? this.generatePackageInfo(ps.pkg, flags, userId) : this.generatePackageInfoFromSettingsLPw(ps.name, flags, userId);
        if (pi != null) {
            if ((flags & 0x1000) == 0) {
                if (numMatch == permissions.length) {
                    pi.requestedPermissions = permissions;
                } else {
                    pi.requestedPermissions = new String[numMatch];
                    numMatch = 0;
                    for (int i = 0; i < permissions.length; ++i) {
                        if (!tmp[i]) continue;
                        pi.requestedPermissions[numMatch] = permissions[i];
                        ++numMatch;
                    }
                }
            }
            list.add(pi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParceledListSlice<PackageInfo> getPackagesHoldingPermissions(String[] permissions, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        boolean listUninstalled = (flags & 0x2000) != 0;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            ArrayList<PackageInfo> list = new ArrayList<PackageInfo>();
            boolean[] tmpBools = new boolean[permissions.length];
            if (listUninstalled) {
                for (PackageSetting ps : this.mSettings.mPackages.values()) {
                    this.addPackageHoldingPermissions(list, ps, permissions, tmpBools, flags, userId);
                }
            } else {
                for (PackageParser.Package pkg : this.mPackages.values()) {
                    PackageSetting ps = (PackageSetting)pkg.mExtras;
                    if (ps == null) continue;
                    this.addPackageHoldingPermissions(list, ps, permissions, tmpBools, flags, userId);
                }
            }
            return new ParceledListSlice<PackageInfo>(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParceledListSlice<ApplicationInfo> getInstalledApplications(int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        boolean listUninstalled = (flags & 0x2000) != 0;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            ArrayList<ApplicationInfo> list;
            if (listUninstalled) {
                list = new ArrayList(this.mSettings.mPackages.size());
                for (PackageSetting ps : this.mSettings.mPackages.values()) {
                    ApplicationInfo ai = ps.pkg != null ? PackageParser.generateApplicationInfo(ps.pkg, flags, ps.readUserState(userId), userId) : this.generateApplicationInfoFromSettingsLPw(ps.name, flags, userId);
                    if (ai == null) continue;
                    list.add(ai);
                }
            } else {
                list = new ArrayList<ApplicationInfo>(this.mPackages.size());
                for (PackageParser.Package p : this.mPackages.values()) {
                    ApplicationInfo ai;
                    if (p.mExtras == null || (ai = PackageParser.generateApplicationInfo(p, flags, ((PackageSetting)p.mExtras).readUserState(userId), userId)) == null) continue;
                    list.add(ai);
                }
            }
            return new ParceledListSlice<ApplicationInfo>(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ApplicationInfo> getPersistentApplications(int flags) {
        ArrayList<ApplicationInfo> finalList = new ArrayList<ApplicationInfo>();
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            Iterator<PackageParser.Package> i = this.mPackages.values().iterator();
            int userId = UserHandle.getCallingUserId();
            while (i.hasNext()) {
                ApplicationInfo ai;
                PackageSetting ps;
                PackageParser.Package p = i.next();
                if (p.applicationInfo == null || (p.applicationInfo.flags & 8) == 0 || this.mSafeMode && !PackageManagerService.isSystemApp(p) || (ps = this.mSettings.mPackages.get(p.packageName)) == null || (ai = PackageParser.generateApplicationInfo(p, flags, ps.readUserState(userId), userId)) == null) continue;
                finalList.add(ai);
            }
        }
        return finalList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProviderInfo resolveContentProvider(String name, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return null;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageParser.Provider provider = this.mProvidersByAuthority.get(name);
            PackageSetting ps = provider != null ? this.mSettings.mPackages.get(provider.owner.packageName) : null;
            return ps != null && this.mSettings.isEnabledLPr(provider.info, flags, userId) && (!this.mSafeMode || (provider.info.applicationInfo.flags & 1) != 0) ? PackageParser.generateProviderInfo(provider, flags, ps.readUserState(userId), userId) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void querySyncProviders(List<String> outNames, List<ProviderInfo> outInfo) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            Iterator<Map.Entry<String, PackageParser.Provider>> i = this.mProvidersByAuthority.entrySet().iterator();
            int userId = UserHandle.getCallingUserId();
            while (i.hasNext()) {
                ProviderInfo info;
                Map.Entry<String, PackageParser.Provider> entry = i.next();
                PackageParser.Provider p = entry.getValue();
                PackageSetting ps = this.mSettings.mPackages.get(p.owner.packageName);
                if (ps == null || !p.syncable || this.mSafeMode && (p.info.applicationInfo.flags & 1) == 0 || (info = PackageParser.generateProviderInfo(p, 0, ps.readUserState(userId), userId)) == null) continue;
                outNames.add(entry.getKey());
                outInfo.add(info);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParceledListSlice<ProviderInfo> queryContentProviders(String processName, int uid, int flags) {
        ArrayList<ProviderInfo> finalList = null;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            int userId;
            Iterator i = this.mProviders.mProviders.values().iterator();
            int n = userId = processName != null ? UserHandle.getUserId(uid) : UserHandle.getCallingUserId();
            while (i.hasNext()) {
                ProviderInfo info;
                PackageParser.Provider p = (PackageParser.Provider)i.next();
                PackageSetting ps = this.mSettings.mPackages.get(p.owner.packageName);
                if (ps == null || p.info.authority == null || processName != null && (!p.info.processName.equals(processName) || !UserHandle.isSameApp(p.info.applicationInfo.uid, uid)) || !this.mSettings.isEnabledLPr(p.info, flags, userId) || this.mSafeMode && (p.info.applicationInfo.flags & 1) == 0) continue;
                if (finalList == null) {
                    finalList = new ArrayList<ProviderInfo>(3);
                }
                if ((info = PackageParser.generateProviderInfo(p, flags, ps.readUserState(userId), userId)) == null) continue;
                finalList.add(info);
            }
        }
        if (finalList != null) {
            Collections.sort(finalList, mProviderInitOrderSorter);
            return new ParceledListSlice<ProviderInfo>(finalList);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InstrumentationInfo getInstrumentationInfo(ComponentName name, int flags) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageParser.Instrumentation i = this.mInstrumentation.get(name);
            return PackageParser.generateInstrumentationInfo(i, flags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<InstrumentationInfo> queryInstrumentation(String targetPackage, int flags) {
        ArrayList<InstrumentationInfo> finalList = new ArrayList<InstrumentationInfo>();
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            for (PackageParser.Instrumentation p : this.mInstrumentation.values()) {
                InstrumentationInfo ii;
                if (targetPackage != null && !targetPackage.equals(p.info.targetPackage) || (ii = PackageParser.generateInstrumentationInfo(p, flags)) == null) continue;
                finalList.add(ii);
            }
        }
        return finalList;
    }

    private void createIdmapsForPackageLI(PackageParser.Package pkg) {
        ArrayMap<String, PackageParser.Package> overlays = this.mOverlays.get(pkg.packageName);
        if (overlays == null) {
            Slog.w(TAG, "Unable to create idmap for " + pkg.packageName + ": no overlay packages");
            return;
        }
        for (PackageParser.Package opkg : overlays.values()) {
            this.createIdmapForPackagePairLI(pkg, opkg);
        }
    }

    private boolean createIdmapForPackagePairLI(PackageParser.Package pkg, PackageParser.Package opkg) {
        if (!opkg.mTrustedOverlay) {
            Slog.w(TAG, "Skipping target and overlay pair " + pkg.baseCodePath + " and " + opkg.baseCodePath + ": overlay not trusted");
            return false;
        }
        ArrayMap<String, PackageParser.Package> overlaySet = this.mOverlays.get(pkg.packageName);
        if (overlaySet == null) {
            Slog.e(TAG, "was about to create idmap for " + pkg.baseCodePath + " and " + opkg.baseCodePath + " but target package has no known overlays");
            return false;
        }
        int sharedGid = UserHandle.getSharedAppGid(pkg.applicationInfo.uid);
        if (this.mInstaller.idmap(pkg.baseCodePath, opkg.baseCodePath, sharedGid) != 0) {
            Slog.e(TAG, "Failed to generate idmap for " + pkg.baseCodePath + " and " + opkg.baseCodePath);
            return false;
        }
        PackageParser.Package[] overlayArray = overlaySet.values().toArray(new PackageParser.Package[0]);
        Comparator<PackageParser.Package> cmp = new Comparator<PackageParser.Package>(){

            @Override
            public int compare(PackageParser.Package p1, PackageParser.Package p2) {
                return p1.mOverlayPriority - p2.mOverlayPriority;
            }
        };
        Arrays.sort(overlayArray, cmp);
        pkg.applicationInfo.resourceDirs = new String[overlayArray.length];
        int i = 0;
        for (PackageParser.Package p : overlayArray) {
            pkg.applicationInfo.resourceDirs[i++] = p.baseCodePath;
        }
        return true;
    }

    private void scanDirLI(File dir, int parseFlags, int scanFlags, long currentTime) {
        File[] files = dir.listFiles();
        if (ArrayUtils.isEmpty(files)) {
            Log.d(TAG, "No files in app dir " + dir);
            return;
        }
        for (File file : files) {
            boolean isPackage;
            boolean bl = isPackage = (PackageParser.isApkFile(file) || file.isDirectory()) && !PackageInstallerService.isStageName(file.getName());
            if (!isPackage) continue;
            try {
                this.scanPackageLI(file, parseFlags | 4, scanFlags, currentTime, null);
            }
            catch (PackageManagerException e) {
                Slog.w(TAG, "Failed to parse " + file + ": " + e.getMessage());
                if ((parseFlags & 1) != 0 || e.error != -2) continue;
                PackageManagerService.logCriticalInfo(5, "Deleting invalid package at " + file);
                if (file.isDirectory()) {
                    this.mInstaller.rmPackageDir(file.getAbsolutePath());
                    continue;
                }
                file.delete();
            }
        }
    }

    private static File getSettingsProblemFile() {
        File dataDir = Environment.getDataDirectory();
        File systemDir = new File(dataDir, "system");
        File fname = new File(systemDir, "uiderrors.txt");
        return fname;
    }

    static void reportSettingsProblem(int priority, String msg) {
        PackageManagerService.logCriticalInfo(priority, msg);
    }

    static void logCriticalInfo(int priority, String msg) {
        Slog.println(priority, TAG, msg);
        EventLogTags.writePmCriticalInfo(msg);
        try {
            File fname = PackageManagerService.getSettingsProblemFile();
            FileOutputStream out = new FileOutputStream(fname, true);
            FastPrintWriter pw = new FastPrintWriter(out);
            SimpleDateFormat formatter = new SimpleDateFormat();
            String dateString = formatter.format(new Date(System.currentTimeMillis()));
            pw.println(dateString + ": " + msg);
            ((PrintWriter)pw).close();
            FileUtils.setPermissions(fname.toString(), 508, -1, -1);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectCertificatesLI(PackageParser pp, PackageSetting ps, PackageParser.Package pkg, File srcFile, int parseFlags) throws PackageManagerException {
        if (ps != null && ps.codePath.equals(srcFile) && ps.timeStamp == srcFile.lastModified() && !this.isCompatSignatureUpdateNeeded(pkg) && !this.isRecoverSignatureUpdateNeeded(pkg)) {
            ArraySet<PublicKey> signingKs;
            long mSigningKeySetId = ps.keySetData.getProperSigningKeySet();
            KeySetManagerService ksms = this.mSettings.mKeySetManagerService;
            ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
            synchronized (arrayMap) {
                signingKs = ksms.getPublicKeysFromKeySetLPr(mSigningKeySetId);
            }
            if (ps.signatures.mSignatures != null && ps.signatures.mSignatures.length != 0 && signingKs != null) {
                pkg.mSignatures = ps.signatures.mSignatures;
                pkg.mSigningKeys = signingKs;
                return;
            }
            Slog.w(TAG, "PackageSetting for " + ps.name + " is missing signatures.  Collecting certs again to recover them.");
        } else {
            Log.i(TAG, srcFile.toString() + " changed; collecting certs");
        }
        try {
            pp.collectCertificates(pkg, parseFlags);
            pp.collectManifestDigest(pkg);
        }
        catch (PackageParser.PackageParserException e) {
            throw PackageManagerException.from(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackageParser.Package scanPackageLI(File scanFile, int parseFlags, int scanFlags, long currentTime, UserHandle user) throws PackageManagerException {
        PackageSetting updatedPkg;
        Object oldName;
        PackageParser.Package pkg;
        parseFlags |= this.mDefParseFlags;
        PackageParser pp = new PackageParser();
        pp.setSeparateProcesses(this.mSeparateProcesses);
        pp.setOnlyCoreApps(this.mOnlyCore);
        pp.setDisplayMetrics(this.mMetrics);
        if ((scanFlags & 0x200) != 0) {
            parseFlags |= 0x200;
        }
        try {
            pkg = pp.parsePackage(scanFile, parseFlags);
        }
        catch (PackageParser.PackageParserException e) {
            throw PackageManagerException.from(e);
        }
        PackageSetting ps = null;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            oldName = this.mSettings.mRenamedPackages.get(pkg.packageName);
            if (pkg.mOriginalPackages != null && pkg.mOriginalPackages.contains(oldName)) {
                ps = this.mSettings.peekPackageLPr((String)oldName);
            }
            if (ps == null) {
                ps = this.mSettings.peekPackageLPr(pkg.packageName);
            }
            updatedPkg = this.mSettings.getDisabledSystemPkgLPr(ps != null ? ps.name : pkg.packageName);
        }
        boolean updatedPkgBetter = false;
        if (updatedPkg != null && (parseFlags & 1) != 0) {
            updatedPkg.pkgPrivateFlags = PackageManagerService.locationIsPrivileged(scanFile) ? (updatedPkg.pkgPrivateFlags |= 8) : (updatedPkg.pkgPrivateFlags &= 0xFFFFFFF7);
            if (ps != null && !ps.codePath.equals(scanFile)) {
                if (pkg.mVersionCode <= ps.versionCode) {
                    if (!updatedPkg.codePath.equals(scanFile)) {
                        Slog.w(TAG, "Code path for hidden system pkg : " + ps.name + " changing from " + updatedPkg.codePathString + " to " + scanFile);
                        updatedPkg.codePath = scanFile;
                        updatedPkg.codePathString = scanFile.toString();
                        updatedPkg.resourcePath = scanFile;
                        updatedPkg.resourcePathString = scanFile.toString();
                    }
                    updatedPkg.pkg = pkg;
                    throw new PackageManagerException(-5, "Package " + ps.name + " at " + scanFile + " ignored: updated version " + ps.versionCode + " better than this " + pkg.mVersionCode);
                }
                oldName = this.mPackages;
                synchronized (oldName) {
                    this.mPackages.remove(ps.name);
                }
                PackageManagerService.logCriticalInfo(5, "Package " + ps.name + " at " + scanFile + " reverting from " + ps.codePathString + ": new version " + pkg.mVersionCode + " better than installed " + ps.versionCode);
                InstallArgs args = this.createInstallArgsForExisting(this.packageFlagsToInstallFlags(ps), ps.codePathString, ps.resourcePathString, InstructionSets.getAppDexInstructionSets(ps));
                ArrayMap<String, PackageParser.Package> arrayMap2 = this.mInstallLock;
                synchronized (arrayMap2) {
                    args.cleanUpResourcesLI();
                }
                arrayMap2 = this.mPackages;
                synchronized (arrayMap2) {
                    this.mSettings.enableSystemPackageLPw(ps.name);
                }
                updatedPkgBetter = true;
            }
        }
        if (updatedPkg != null) {
            parseFlags |= 1;
            if ((updatedPkg.pkgPrivateFlags & 8) != 0) {
                parseFlags |= 0x80;
            }
        }
        this.collectCertificatesLI(pp, ps, pkg, scanFile, parseFlags);
        boolean shouldHideSystemApp = false;
        if (updatedPkg == null && ps != null && (parseFlags & 0x40) != 0 && !PackageManagerService.isSystemApp(ps)) {
            if (PackageManagerService.compareSignatures(ps.signatures.mSignatures, pkg.mSignatures) != 0) {
                PackageManagerService.logCriticalInfo(5, "Package " + ps.name + " appeared on system, but" + " signatures don't match existing userdata copy; removing");
                this.deletePackageLI(pkg.packageName, null, true, null, null, 0, null, false);
                ps = null;
            } else if (pkg.mVersionCode <= ps.versionCode) {
                shouldHideSystemApp = true;
                PackageManagerService.logCriticalInfo(4, "Package " + ps.name + " appeared at " + scanFile + " but new version " + pkg.mVersionCode + " better than installed " + ps.versionCode + "; hiding system");
            } else {
                PackageManagerService.logCriticalInfo(5, "Package " + ps.name + " at " + scanFile + " reverting from " + ps.codePathString + ": new version " + pkg.mVersionCode + " better than installed " + ps.versionCode);
                InstallArgs args = this.createInstallArgsForExisting(this.packageFlagsToInstallFlags(ps), ps.codePathString, ps.resourcePathString, InstructionSets.getAppDexInstructionSets(ps));
                Object object = this.mInstallLock;
                synchronized (object) {
                    args.cleanUpResourcesLI();
                }
            }
        }
        if ((parseFlags & 0x40) == 0 && ps != null && !ps.codePath.equals(ps.resourcePath)) {
            parseFlags |= 0x10;
        }
        String resourcePath = null;
        String baseResourcePath = null;
        if ((parseFlags & 0x10) != 0 && !updatedPkgBetter) {
            if (ps != null && ps.resourcePathString != null) {
                resourcePath = ps.resourcePathString;
                baseResourcePath = ps.resourcePathString;
            } else {
                Slog.e(TAG, "Resource path not set for pkg : " + pkg.packageName);
            }
        } else {
            resourcePath = pkg.codePath;
            baseResourcePath = pkg.baseCodePath;
        }
        pkg.applicationInfo.volumeUuid = pkg.volumeUuid;
        pkg.applicationInfo.setCodePath(pkg.codePath);
        pkg.applicationInfo.setBaseCodePath(pkg.baseCodePath);
        pkg.applicationInfo.setSplitCodePaths(pkg.splitCodePaths);
        pkg.applicationInfo.setResourcePath(resourcePath);
        pkg.applicationInfo.setBaseResourcePath(baseResourcePath);
        pkg.applicationInfo.setSplitResourcePaths(pkg.splitCodePaths);
        PackageParser.Package scannedPkg = this.scanPackageLI(pkg, parseFlags, scanFlags | 8, currentTime, user);
        if (shouldHideSystemApp) {
            ArrayMap<String, PackageParser.Package> arrayMap3 = this.mPackages;
            synchronized (arrayMap3) {
                this.mSettings.disableSystemPackageLPw(pkg.packageName);
            }
        }
        return scannedPkg;
    }

    private static String fixProcessName(String defProcessName, String processName, int uid) {
        if (processName == null) {
            return defProcessName;
        }
        return processName;
    }

    private void verifySignaturesLP(PackageSetting pkgSetting, PackageParser.Package pkg) throws PackageManagerException {
        boolean match;
        if (pkgSetting.signatures.mSignatures != null) {
            boolean bl = match = PackageManagerService.compareSignatures(pkgSetting.signatures.mSignatures, pkg.mSignatures) == 0;
            if (!match) {
                boolean bl2 = match = this.compareSignaturesCompat(pkgSetting.signatures, pkg) == 0;
            }
            if (!match) {
                boolean bl3 = match = this.compareSignaturesRecover(pkgSetting.signatures, pkg) == 0;
            }
            if (!match) {
                throw new PackageManagerException(-7, "Package " + pkg.packageName + " signatures do not match the " + "previously installed version; ignoring!");
            }
        }
        if (pkgSetting.sharedUser != null && pkgSetting.sharedUser.signatures.mSignatures != null) {
            boolean bl = match = PackageManagerService.compareSignatures(pkgSetting.sharedUser.signatures.mSignatures, pkg.mSignatures) == 0;
            if (!match) {
                boolean bl4 = match = this.compareSignaturesCompat(pkgSetting.sharedUser.signatures, pkg) == 0;
            }
            if (!match) {
                boolean bl5 = match = this.compareSignaturesRecover(pkgSetting.sharedUser.signatures, pkg) == 0;
            }
            if (!match) {
                throw new PackageManagerException(-8, "Package " + pkg.packageName + " has no signatures that match those in shared user " + pkgSetting.sharedUser.name + "; ignoring!");
            }
        }
    }

    private static final void enforceSystemOrRoot(String message) {
        int uid = Binder.getCallingUid();
        if (uid != 1000 && uid != 0) {
            throw new SecurityException(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performBootDexOpt() {
        ArraySet<PackageParser.Package> pkgs;
        block23: {
            PackageManagerService.enforceSystemOrRoot("Only the system can request dexopt be performed");
            try {
                IMountService ms = PackageHelper.getMountService();
                if (ms != null) {
                    boolean isUpgrade = this.isUpgrade();
                    boolean doTrim = isUpgrade;
                    if (doTrim) {
                        Slog.w(TAG, "Running disk maintenance immediately due to system update");
                    } else {
                        long timeSinceLast;
                        long interval = Settings.Global.getLong(this.mContext.getContentResolver(), "fstrim_mandatory_interval", 259200000L);
                        if (interval > 0L && (timeSinceLast = System.currentTimeMillis() - ms.lastMaintenance()) > interval) {
                            doTrim = true;
                            Slog.w(TAG, "No disk maintenance in " + timeSinceLast + "; running immediately");
                        }
                    }
                    if (!doTrim) break block23;
                    if (!this.isFirstBoot()) {
                        try {
                            ActivityManagerNative.getDefault().showBootMessage(this.mContext.getResources().getString(17040237), true);
                        }
                        catch (RemoteException e) {
                            // empty catch block
                        }
                    }
                    ms.runMaintenance();
                    break block23;
                }
                Slog.e(TAG, "Mount service unavailable!");
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
        ArrayMap<String, PackageParser.Package> isUpgrade = this.mPackages;
        synchronized (isUpgrade) {
            pkgs = this.mPackageDexOptimizer.clearDeferredDexOptPackages();
        }
        if (pkgs != null) {
            ArrayList<PackageParser.Package> sortedPkgs = new ArrayList<PackageParser.Package>();
            Iterator<PackageParser.Package> it = pkgs.iterator();
            while (it.hasNext()) {
                PackageParser.Package pkg = it.next();
                if (!pkg.coreApp) continue;
                sortedPkgs.add(pkg);
                it.remove();
            }
            Intent intent = new Intent("android.intent.action.PRE_BOOT_COMPLETED");
            ArraySet<String> pkgNames = this.getPackageNamesForIntent(intent);
            Iterator<PackageParser.Package> it2 = pkgs.iterator();
            while (it2.hasNext()) {
                PackageParser.Package pkg = it2.next();
                if (!pkgNames.contains(pkg.packageName)) continue;
                sortedPkgs.add(pkg);
                it2.remove();
            }
            it2 = pkgs.iterator();
            while (it2.hasNext()) {
                PackageParser.Package pkg = it2.next();
                if (!PackageManagerService.isSystemApp(pkg) || pkg.isUpdatedSystemApp()) continue;
                sortedPkgs.add(pkg);
                it2.remove();
            }
            it2 = pkgs.iterator();
            while (it2.hasNext()) {
                PackageParser.Package pkg = it2.next();
                if (!pkg.isUpdatedSystemApp()) continue;
                sortedPkgs.add(pkg);
                it2.remove();
            }
            intent = new Intent("android.intent.action.BOOT_COMPLETED");
            pkgNames = this.getPackageNamesForIntent(intent);
            it2 = pkgs.iterator();
            while (it2.hasNext()) {
                PackageParser.Package pkg = it2.next();
                if (!pkgNames.contains(pkg.packageName)) continue;
                sortedPkgs.add(pkg);
                it2.remove();
            }
            this.filterRecentlyUsedApps(pkgs);
            for (PackageParser.Package pkg : pkgs) {
                sortedPkgs.add(pkg);
            }
            if (this.mLazyDexOpt) {
                this.filterRecentlyUsedApps(sortedPkgs);
            }
            int i = 0;
            int total = sortedPkgs.size();
            File dataDir = Environment.getDataDirectory();
            long lowThreshold = StorageManager.from(this.mContext).getStorageLowBytes(dataDir);
            if (lowThreshold == 0L) {
                throw new IllegalStateException("Invalid low memory threshold");
            }
            for (PackageParser.Package pkg : sortedPkgs) {
                long usableSpace = dataDir.getUsableSpace();
                if (usableSpace < lowThreshold) {
                    Log.w(TAG, "Not running dexopt on remaining apps due to low memory: " + usableSpace);
                    break;
                }
                this.performBootDexOpt(pkg, ++i, total);
            }
        }
    }

    private void filterRecentlyUsedApps(Collection<PackageParser.Package> pkgs) {
        if (this.mLazyDexOpt || !this.isFirstBoot() && this.mPackageUsage.isHistoricalPackageUsageAvailable()) {
            int total = pkgs.size();
            int skipped = 0;
            long now = System.currentTimeMillis();
            Iterator<PackageParser.Package> i = pkgs.iterator();
            while (i.hasNext()) {
                PackageParser.Package pkg = i.next();
                long then = pkg.mLastPackageUsageTimeInMills;
                if (then + this.mDexOptLRUThresholdInMills >= now) continue;
                i.remove();
                ++skipped;
            }
        }
    }

    private ArraySet<String> getPackageNamesForIntent(Intent intent) {
        List<ResolveInfo> ris = null;
        try {
            ris = AppGlobals.getPackageManager().queryIntentReceivers(intent, null, 0, 0);
        }
        catch (RemoteException e) {
            // empty catch block
        }
        ArraySet<String> pkgNames = new ArraySet<String>();
        if (ris != null) {
            for (ResolveInfo ri : ris) {
                pkgNames.add(ri.activityInfo.packageName);
            }
        }
        return pkgNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performBootDexOpt(PackageParser.Package pkg, int curr, int total) {
        if (!this.isFirstBoot()) {
            try {
                ActivityManagerNative.getDefault().showBootMessage(this.mContext.getResources().getString(17040238, curr, total), true);
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
        PackageParser.Package p = pkg;
        Object object = this.mInstallLock;
        synchronized (object) {
            this.mPackageDexOptimizer.performDexOpt(p, null, false, false, true);
        }
    }

    @Override
    public boolean performDexOptIfNeeded(String packageName, String instructionSet) {
        return this.performDexOpt(packageName, instructionSet, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performDexOpt(String packageName, String instructionSet, boolean backgroundDexopt) {
        String targetInstructionSet;
        PackageParser.Package p;
        boolean updateUsage;
        boolean dexopt = this.mLazyDexOpt || backgroundDexopt;
        boolean bl = updateUsage = !backgroundDexopt;
        if (!dexopt && !updateUsage) {
            return false;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            p = this.mPackages.get(packageName);
            if (p == null) {
                return false;
            }
            if (updateUsage) {
                p.mLastPackageUsageTimeInMills = System.currentTimeMillis();
            }
            this.mPackageUsage.write(false);
            if (!dexopt) {
                return false;
            }
            String string2 = targetInstructionSet = instructionSet != null ? instructionSet : InstructionSets.getPrimaryInstructionSet(p.applicationInfo);
            if (p.mDexOptPerformed.contains(targetInstructionSet)) {
                return false;
            }
        }
        long callingId = Binder.clearCallingIdentity();
        try {
            Object object = this.mInstallLock;
            synchronized (object) {
                String[] instructionSets = new String[]{targetInstructionSet};
                int result = this.mPackageDexOptimizer.performDexOpt(p, instructionSets, false, false, true);
                boolean bl2 = result == 1;
                return bl2;
            }
        }
        finally {
            Binder.restoreCallingIdentity(callingId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArraySet<String> getPackagesThatNeedDexOpt() {
        ArraySet<String> pkgs = null;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            for (PackageParser.Package p : this.mPackages.values()) {
                if (!p.mDexOptPerformed.isEmpty()) continue;
                if (pkgs == null) {
                    pkgs = new ArraySet<String>();
                }
                pkgs.add(p.packageName);
            }
        }
        return pkgs;
    }

    public void shutdown() {
        this.mPackageUsage.write(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceDexOpt(String packageName) {
        PackageParser.Package pkg;
        PackageManagerService.enforceSystemOrRoot("forceDexOpt");
        Object object = this.mPackages;
        synchronized (object) {
            pkg = this.mPackages.get(packageName);
            if (pkg == null) {
                throw new IllegalArgumentException("Missing package: " + packageName);
            }
        }
        object = this.mInstallLock;
        synchronized (object) {
            String[] instructionSets = new String[]{InstructionSets.getPrimaryInstructionSet(pkg.applicationInfo)};
            int res = this.mPackageDexOptimizer.performDexOpt(pkg, instructionSets, true, false, true);
            if (res != 1) {
                throw new IllegalStateException("Failed to dexopt: " + res);
            }
        }
    }

    private boolean verifyPackageUpdateLPr(PackageSetting oldPkg, PackageParser.Package newPkg) {
        if ((oldPkg.pkgFlags & 1) == 0) {
            Slog.w(TAG, "Unable to update from " + oldPkg.name + " to " + newPkg.packageName + ": old package not in system partition");
            return false;
        }
        if (this.mPackages.get(oldPkg.name) != null) {
            Slog.w(TAG, "Unable to update from " + oldPkg.name + " to " + newPkg.packageName + ": old package still exists");
            return false;
        }
        return true;
    }

    private int createDataDirsLI(String volumeUuid, String packageName, int uid, String seinfo) {
        int[] users = sUserManager.getUserIds();
        int res = this.mInstaller.install(volumeUuid, packageName, uid, uid, seinfo);
        if (res < 0) {
            return res;
        }
        for (int user : users) {
            if (user == 0 || (res = this.mInstaller.createUserData(volumeUuid, packageName, UserHandle.getUid(user, uid), user, seinfo)) >= 0) continue;
            return res;
        }
        return res;
    }

    private int removeDataDirsLI(String volumeUuid, String packageName) {
        int[] users = sUserManager.getUserIds();
        int res = 0;
        for (int user : users) {
            int resInner = this.mInstaller.remove(volumeUuid, packageName, user);
            if (resInner >= 0) continue;
            res = resInner;
        }
        return res;
    }

    private int deleteCodeCacheDirsLI(String volumeUuid, String packageName) {
        int[] users = sUserManager.getUserIds();
        int res = 0;
        for (int user : users) {
            int resInner = this.mInstaller.deleteCodeCacheFiles(volumeUuid, packageName, user);
            if (resInner >= 0) continue;
            res = resInner;
        }
        return res;
    }

    private void addSharedLibraryLPw(ArraySet<String> usesLibraryFiles, SharedLibraryEntry file, PackageParser.Package changingLib) {
        if (file.path != null) {
            usesLibraryFiles.add(file.path);
            return;
        }
        PackageParser.Package p = this.mPackages.get(file.apk);
        if (changingLib != null && changingLib.packageName.equals(file.apk) && (p == null || p.packageName.equals(changingLib.packageName))) {
            p = changingLib;
        }
        if (p != null) {
            usesLibraryFiles.addAll(p.getAllCodePaths());
        }
    }

    private void updateSharedLibrariesLPw(PackageParser.Package pkg, PackageParser.Package changingLib) throws PackageManagerException {
        if (pkg.usesLibraries != null || pkg.usesOptionalLibraries != null) {
            SharedLibraryEntry file;
            int i;
            ArraySet<String> usesLibraryFiles = new ArraySet<String>();
            int N = pkg.usesLibraries != null ? pkg.usesLibraries.size() : 0;
            for (i = 0; i < N; ++i) {
                file = this.mSharedLibraries.get(pkg.usesLibraries.get(i));
                if (file == null) {
                    throw new PackageManagerException(-9, "Package " + pkg.packageName + " requires unavailable shared library " + pkg.usesLibraries.get(i) + "; failing!");
                }
                this.addSharedLibraryLPw(usesLibraryFiles, file, changingLib);
            }
            N = pkg.usesOptionalLibraries != null ? pkg.usesOptionalLibraries.size() : 0;
            for (i = 0; i < N; ++i) {
                file = this.mSharedLibraries.get(pkg.usesOptionalLibraries.get(i));
                if (file == null) {
                    Slog.w(TAG, "Package " + pkg.packageName + " desires unavailable shared library " + pkg.usesOptionalLibraries.get(i) + "; ignoring!");
                    continue;
                }
                this.addSharedLibraryLPw(usesLibraryFiles, file, changingLib);
            }
            N = usesLibraryFiles.size();
            pkg.usesLibraryFiles = N > 0 ? usesLibraryFiles.toArray(new String[N]) : null;
        }
    }

    private static boolean hasString(List<String> list, List<String> which) {
        if (list == null) {
            return false;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            for (int j = which.size() - 1; j >= 0; --j) {
                if (!which.get(j).equals(list.get(i))) continue;
                return true;
            }
        }
        return false;
    }

    private void updateAllSharedLibrariesLPw() {
        for (PackageParser.Package pkg : this.mPackages.values()) {
            try {
                this.updateSharedLibrariesLPw(pkg, null);
            }
            catch (PackageManagerException e) {
                Slog.e(TAG, "updateAllSharedLibrariesLPw failed: " + e.getMessage());
            }
        }
    }

    private ArrayList<PackageParser.Package> updateAllSharedLibrariesLPw(PackageParser.Package changingPkg) {
        ArrayList<PackageParser.Package> res = null;
        for (PackageParser.Package pkg : this.mPackages.values()) {
            if (!PackageManagerService.hasString(pkg.usesLibraries, changingPkg.libraryNames) && !PackageManagerService.hasString(pkg.usesOptionalLibraries, changingPkg.libraryNames)) continue;
            if (res == null) {
                res = new ArrayList<PackageParser.Package>();
            }
            res.add(pkg);
            try {
                this.updateSharedLibrariesLPw(pkg, changingPkg);
            }
            catch (PackageManagerException e) {
                Slog.e(TAG, "updateAllSharedLibrariesLPw failed: " + e.getMessage());
            }
        }
        return res;
    }

    private static String deriveAbiOverride(String abiOverride, PackageSetting settings) {
        String cpuAbiOverride = null;
        if (INSTALL_PACKAGE_SUFFIX.equals(abiOverride)) {
            cpuAbiOverride = null;
        } else if (abiOverride != null) {
            cpuAbiOverride = abiOverride;
        } else if (settings != null) {
            cpuAbiOverride = settings.cpuAbiOverrideString;
        }
        return cpuAbiOverride;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackageParser.Package scanPackageLI(PackageParser.Package pkg, int parseFlags, int scanFlags, long currentTime, UserHandle user) throws PackageManagerException {
        boolean success = false;
        try {
            PackageParser.Package res = this.scanPackageDirtyLI(pkg, parseFlags, scanFlags, currentTime, user);
            success = true;
            PackageParser.Package package_ = res;
            return package_;
        }
        finally {
            if (!success && (scanFlags & 0x400) != 0) {
                this.removeDataDirsLI(pkg.volumeUuid, pkg.packageName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackageParser.Package scanPackageDirtyLI(PackageParser.Package pkg, int parseFlags, int scanFlags, long currentTime, UserHandle user) throws PackageManagerException {
        int result;
        Object nativeLibPath;
        File dataPath;
        File scanFile = new File(pkg.codePath);
        if (pkg.applicationInfo.getCodePath() == null || pkg.applicationInfo.getResourcePath() == null) {
            throw new PackageManagerException(-2, "Code and resource paths haven't been set correctly");
        }
        if ((parseFlags & 1) != 0) {
            pkg.applicationInfo.flags |= 1;
        } else {
            pkg.coreApp = false;
        }
        if ((parseFlags & 0x80) != 0) {
            pkg.applicationInfo.privateFlags |= 8;
        }
        if (this.mCustomResolverComponentName != null && this.mCustomResolverComponentName.getPackageName().equals(pkg.packageName)) {
            this.setUpCustomResolverActivity(pkg);
        }
        if (pkg.packageName.equals("android")) {
            ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
            synchronized (arrayMap) {
                if (this.mAndroidApplication != null) {
                    Slog.w(TAG, "*************************************************");
                    Slog.w(TAG, "Core android package being redefined.  Skipping.");
                    Slog.w(TAG, " file=" + scanFile);
                    Slog.w(TAG, "*************************************************");
                    throw new PackageManagerException(-5, "Core android package being redefined.  Skipping.");
                }
                this.mPlatformPackage = pkg;
                pkg.mVersionCode = this.mSdkVersion;
                this.mAndroidApplication = pkg.applicationInfo;
                if (!this.mResolverReplaced) {
                    this.mResolveActivity.applicationInfo = this.mAndroidApplication;
                    this.mResolveActivity.name = ResolverActivity.class.getName();
                    this.mResolveActivity.packageName = this.mAndroidApplication.packageName;
                    this.mResolveActivity.processName = "system:ui";
                    this.mResolveActivity.launchMode = 0;
                    this.mResolveActivity.documentLaunchMode = 3;
                    this.mResolveActivity.flags = 32;
                    this.mResolveActivity.theme = 16974971;
                    this.mResolveActivity.exported = true;
                    this.mResolveActivity.enabled = true;
                    this.mResolveInfo.activityInfo = this.mResolveActivity;
                    this.mResolveInfo.priority = 0;
                    this.mResolveInfo.preferredOrder = 0;
                    this.mResolveInfo.match = 0;
                    this.mResolveComponentName = new ComponentName(this.mAndroidApplication.packageName, this.mResolveActivity.name);
                }
            }
        }
        if (this.mPackages.containsKey(pkg.packageName) || this.mSharedLibraries.containsKey(pkg.packageName)) {
            throw new PackageManagerException(-5, "Application package " + pkg.packageName + " already installed.  Skipping duplicate.");
        }
        if ((scanFlags & 0x1000) != 0) {
            if (this.mExpectingBetter.containsKey(pkg.packageName)) {
                PackageManagerService.logCriticalInfo(5, "Relax SCAN_REQUIRE_KNOWN requirement for package " + pkg.packageName);
            } else {
                PackageSetting known = this.mSettings.peekPackageLPr(pkg.packageName);
                if (!(known == null || pkg.applicationInfo.getCodePath().equals(known.codePathString) && pkg.applicationInfo.getResourcePath().equals(known.resourcePathString))) {
                    throw new PackageManagerException(-23, "Application package " + pkg.packageName + " found at " + pkg.applicationInfo.getCodePath() + " but expected at " + known.codePathString + "; ignoring.");
                }
            }
        }
        File destCodeFile = new File(pkg.applicationInfo.getCodePath());
        File destResourceFile = new File(pkg.applicationInfo.getResourcePath());
        SharedUserSetting suid = null;
        PackageSetting pkgSetting = null;
        if (!PackageManagerService.isSystemApp(pkg)) {
            pkg.mOriginalPackages = null;
            pkg.mRealPackage = null;
            pkg.mAdoptPermissions = null;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            String msg;
            int i;
            if (pkg.mSharedUserId != null && (suid = this.mSettings.getSharedUserLPw(pkg.mSharedUserId, 0, 0, true)) == null) {
                throw new PackageManagerException(-4, "Creating application package " + pkg.packageName + " for shared user failed");
            }
            PackageSetting origPackage = null;
            String realName = null;
            if (pkg.mOriginalPackages != null) {
                String renamed = this.mSettings.mRenamedPackages.get(pkg.mRealPackage);
                if (pkg.mOriginalPackages.contains(renamed)) {
                    realName = pkg.mRealPackage;
                    if (!pkg.packageName.equals(renamed)) {
                        pkg.setPackageName(renamed);
                    }
                } else {
                    for (i = pkg.mOriginalPackages.size() - 1; i >= 0; --i) {
                        origPackage = this.mSettings.peekPackageLPr(pkg.mOriginalPackages.get(i));
                        if (origPackage == null) continue;
                        if (!this.verifyPackageUpdateLPr(origPackage, pkg)) {
                            origPackage = null;
                            continue;
                        }
                        if (origPackage.sharedUser == null || origPackage.sharedUser.name.equals(pkg.mSharedUserId)) break;
                        Slog.w(TAG, "Unable to migrate data from " + origPackage.name + " to " + pkg.packageName + ": old uid " + origPackage.sharedUser.name + " differs from " + pkg.mSharedUserId);
                        origPackage = null;
                    }
                }
            }
            if (this.mTransferedPackages.contains(pkg.packageName)) {
                Slog.w(TAG, "Package " + pkg.packageName + " was transferred to another, but its .apk remains");
            }
            if ((pkgSetting = this.mSettings.getPackageLPw(pkg, origPackage, realName, suid, destCodeFile, destResourceFile, pkg.applicationInfo.nativeLibraryRootDir, pkg.applicationInfo.primaryCpuAbi, pkg.applicationInfo.secondaryCpuAbi, pkg.applicationInfo.flags, pkg.applicationInfo.privateFlags, user, false)) == null) {
                throw new PackageManagerException(-4, "Creating application package " + pkg.packageName + " failed");
            }
            if (pkgSetting.origPackage != null) {
                pkg.setPackageName(origPackage.name);
                msg = "New package " + pkgSetting.realName + " renamed to replace old package " + pkgSetting.name;
                PackageManagerService.reportSettingsProblem(5, msg);
                this.mTransferedPackages.add(origPackage.name);
                pkgSetting.origPackage = null;
            }
            if (realName != null) {
                this.mTransferedPackages.add(pkg.packageName);
            }
            if (this.mSettings.isDisabledSystemPackageLPr(pkg.packageName)) {
                pkg.applicationInfo.flags |= 0x80;
            }
            if ((parseFlags & 0x40) == 0) {
                this.updateSharedLibrariesLPw(pkg, null);
            }
            if (this.mFoundPolicyFile) {
                SELinuxMMAC.assignSeinfoValue(pkg);
            }
            pkg.applicationInfo.uid = pkgSetting.appId;
            pkg.mExtras = pkgSetting;
            if (this.shouldCheckUpgradeKeySetLP(pkgSetting, scanFlags)) {
                if (this.checkUpgradeKeySetLP(pkgSetting, pkg)) {
                    pkgSetting.signatures.mSignatures = pkg.mSignatures;
                } else {
                    if ((parseFlags & 0x40) == 0) {
                        throw new PackageManagerException(-7, "Package " + pkg.packageName + " upgrade keys do not match the " + "previously installed version");
                    }
                    pkgSetting.signatures.mSignatures = pkg.mSignatures;
                    msg = "System package " + pkg.packageName + " signature changed; retaining data.";
                    PackageManagerService.reportSettingsProblem(5, msg);
                }
            } else {
                try {
                    this.verifySignaturesLP(pkgSetting, pkg);
                    pkgSetting.signatures.mSignatures = pkg.mSignatures;
                }
                catch (PackageManagerException e) {
                    if ((parseFlags & 0x40) == 0) {
                        throw e;
                    }
                    pkgSetting.signatures.mSignatures = pkg.mSignatures;
                    if (pkgSetting.sharedUser != null && PackageManagerService.compareSignatures(pkgSetting.sharedUser.signatures.mSignatures, pkg.mSignatures) != 0) {
                        throw new PackageManagerException(-104, "Signature mismatch for shared user : " + pkgSetting.sharedUser);
                    }
                    String msg2 = "System package " + pkg.packageName + " signature changed; retaining data.";
                    PackageManagerService.reportSettingsProblem(5, msg2);
                }
            }
            if ((scanFlags & 0x10) != 0) {
                int N = pkg.providers.size();
                for (i = 0; i < N; ++i) {
                    PackageParser.Provider p = pkg.providers.get(i);
                    if (p.info.authority == null) continue;
                    String[] names = p.info.authority.split(";");
                    for (int j = 0; j < names.length; ++j) {
                        if (!this.mProvidersByAuthority.containsKey(names[j])) continue;
                        PackageParser.Provider other = this.mProvidersByAuthority.get(names[j]);
                        String otherPackageName = other != null && other.getComponentName() != null ? other.getComponentName().getPackageName() : "?";
                        throw new PackageManagerException(-13, "Can't install because provider name " + names[j] + " (in package " + pkg.applicationInfo.packageName + ") is already used by " + otherPackageName);
                    }
                }
            }
            if (pkg.mAdoptPermissions != null) {
                for (int i2 = pkg.mAdoptPermissions.size() - 1; i2 >= 0; --i2) {
                    String origName = pkg.mAdoptPermissions.get(i2);
                    PackageSetting orig = this.mSettings.peekPackageLPr(origName);
                    if (orig == null || !this.verifyPackageUpdateLPr(orig, pkg)) continue;
                    Slog.i(TAG, "Adopting permissions from " + origName + " to " + pkg.packageName);
                    this.mSettings.transferPermissionsLPw(origName, pkg.packageName);
                }
            }
        }
        String pkgName = pkg.packageName;
        long scanFileTime = scanFile.lastModified();
        boolean forceDex = (scanFlags & 4) != 0;
        pkg.applicationInfo.processName = PackageManagerService.fixProcessName(pkg.applicationInfo.packageName, pkg.applicationInfo.processName, pkg.applicationInfo.uid);
        if (this.mPlatformPackage == pkg) {
            dataPath = new File(Environment.getDataDirectory(), "system");
            pkg.applicationInfo.dataDir = dataPath.getPath();
        } else {
            dataPath = Environment.getDataUserPackageDirectory(pkg.volumeUuid, 0, pkg.packageName);
            boolean uidError = false;
            if (dataPath.exists()) {
                int currentUid = 0;
                try {
                    StructStat stat = Os.stat(dataPath.getPath());
                    currentUid = stat.st_uid;
                }
                catch (ErrnoException e) {
                    Slog.e(TAG, "Couldn't stat path " + dataPath.getPath(), e);
                }
                if (currentUid != pkg.applicationInfo.uid) {
                    Object prefix;
                    int ret;
                    boolean recovered = false;
                    if (currentUid == 0 && (ret = this.mInstaller.fixUid(pkg.volumeUuid, pkgName, pkg.applicationInfo.uid, pkg.applicationInfo.uid)) >= 0) {
                        recovered = true;
                        String msg = "Package " + pkg.packageName + " unexpectedly changed to uid 0; recovered to " + pkg.applicationInfo.uid;
                        PackageManagerService.reportSettingsProblem(5, msg);
                    }
                    if (!(recovered || (parseFlags & 1) == 0 && (scanFlags & 0x100) == 0)) {
                        ret = this.removeDataDirsLI(pkg.volumeUuid, pkgName);
                        if (ret >= 0) {
                            prefix = (parseFlags & 1) != 0 ? "System package " : "Third party package ";
                            String msg = (String)prefix + pkg.packageName + " has changed from uid: " + currentUid + " to " + pkg.applicationInfo.uid + "; old data erased";
                            PackageManagerService.reportSettingsProblem(5, msg);
                            recovered = true;
                            ret = this.createDataDirsLI(pkg.volumeUuid, pkgName, pkg.applicationInfo.uid, pkg.applicationInfo.seinfo);
                            if (ret == -1) {
                                msg = (String)prefix + pkg.packageName + " could not have data directory re-created after delete.";
                                PackageManagerService.reportSettingsProblem(5, msg);
                                throw new PackageManagerException(-4, msg);
                            }
                        }
                        if (!recovered) {
                            this.mHasSystemUidErrors = true;
                        }
                    } else if (!recovered) {
                        throw new PackageManagerException(-24, "scanPackageLI");
                    }
                    if (!recovered) {
                        pkg.applicationInfo.nativeLibraryDir = pkg.applicationInfo.dataDir = "/mismatched_uid/settings_" + pkg.applicationInfo.uid + "/fs_" + currentUid;
                        pkg.applicationInfo.nativeLibraryRootDir = pkg.applicationInfo.dataDir;
                        String msg = "Package " + pkg.packageName + " has mismatched uid: " + currentUid + " on disk, " + pkg.applicationInfo.uid + " in settings";
                        prefix = this.mPackages;
                        synchronized (prefix) {
                            this.mSettings.mReadMessages.append(msg);
                            this.mSettings.mReadMessages.append('\n');
                            uidError = true;
                            if (!pkgSetting.uidError) {
                                PackageManagerService.reportSettingsProblem(6, msg);
                            }
                        }
                    }
                }
                pkg.applicationInfo.dataDir = dataPath.getPath();
                if (this.mShouldRestoreconData) {
                    Slog.i(TAG, "SELinux relabeling of " + pkg.packageName + " issued.");
                    this.mInstaller.restoreconData(pkg.volumeUuid, pkg.packageName, pkg.applicationInfo.seinfo, pkg.applicationInfo.uid);
                }
            } else {
                int ret = this.createDataDirsLI(pkg.volumeUuid, pkgName, pkg.applicationInfo.uid, pkg.applicationInfo.seinfo);
                if (ret < 0) {
                    throw new PackageManagerException(-4, "Unable to create data dirs [errorCode=" + ret + "]");
                }
                if (dataPath.exists()) {
                    pkg.applicationInfo.dataDir = dataPath.getPath();
                } else {
                    Slog.w(TAG, "Unable to create data directory: " + dataPath);
                    pkg.applicationInfo.dataDir = null;
                }
            }
            pkgSetting.uidError = uidError;
        }
        String path = scanFile.getPath();
        String cpuAbiOverride = PackageManagerService.deriveAbiOverride(pkg.cpuAbiOverride, pkgSetting);
        if ((scanFlags & 0x10) == 0) {
            this.derivePackageAbi(pkg, scanFile, cpuAbiOverride, true);
            if (PackageManagerService.isSystemApp(pkg) && !pkg.isUpdatedSystemApp() && pkg.applicationInfo.primaryCpuAbi == null) {
                this.setBundledAppAbisAndRoots(pkg, pkgSetting);
                this.setNativeLibraryPaths(pkg);
            }
        } else {
            if ((scanFlags & 0x2000) != 0) {
                pkg.applicationInfo.primaryCpuAbi = pkgSetting.primaryCpuAbiString;
                pkg.applicationInfo.secondaryCpuAbi = pkgSetting.secondaryCpuAbiString;
            }
            this.setNativeLibraryPaths(pkg);
        }
        int[] userIds = sUserManager.getUserIds();
        Object msg = this.mInstallLock;
        synchronized (msg) {
            if (!TextUtils.isEmpty(pkg.volumeUuid)) {
                for (int userId : userIds) {
                    if (userId == 0) continue;
                    this.mInstaller.createUserData(pkg.volumeUuid, pkg.packageName, UserHandle.getUid(userId, pkg.applicationInfo.uid), userId, pkg.applicationInfo.seinfo);
                }
            }
            if (pkg.applicationInfo.primaryCpuAbi != null && !VMRuntime.is64BitAbi(pkg.applicationInfo.primaryCpuAbi)) {
                nativeLibPath = pkg.applicationInfo.nativeLibraryDir;
                for (int userId : userIds) {
                    if (this.mInstaller.linkNativeLibraryDirectory(pkg.volumeUuid, pkg.packageName, (String)nativeLibPath, userId) >= 0) continue;
                    throw new PackageManagerException(-110, "Failed linking native library dir (user=" + userId + ")");
                }
            }
        }
        if (this.mPlatformPackage == pkg) {
            String string2 = pkg.applicationInfo.primaryCpuAbi = VMRuntime.getRuntime().is64Bit() ? Build.SUPPORTED_64_BIT_ABIS[0] : Build.SUPPORTED_32_BIT_ABIS[0];
        }
        if ((scanFlags & 2) == 0 && (scanFlags & 0x10) != 0 && cpuAbiOverride == null && pkgSetting.cpuAbiOverrideString != null) {
            Slog.w(TAG, "Ignoring persisted ABI override " + cpuAbiOverride + " for package: " + pkg.packageName);
        }
        pkgSetting.primaryCpuAbiString = pkg.applicationInfo.primaryCpuAbi;
        pkgSetting.secondaryCpuAbiString = pkg.applicationInfo.secondaryCpuAbi;
        pkgSetting.cpuAbiOverrideString = cpuAbiOverride;
        pkg.cpuAbiOverride = cpuAbiOverride;
        pkgSetting.legacyNativeLibraryPathString = pkg.applicationInfo.nativeLibraryRootDir;
        if ((scanFlags & 0x100) == 0 && pkgSetting.sharedUser != null) {
            this.adjustCpuAbisForSharedUserLPw(pkgSetting.sharedUser.packages, pkg, forceDex, (scanFlags & 0x80) != 0);
        }
        if ((scanFlags & 2) == 0 && (result = this.mPackageDexOptimizer.performDexOpt(pkg, null, forceDex, (scanFlags & 0x80) != 0, false)) == -1) {
            throw new PackageManagerException(-11, "scanPackageLI");
        }
        if (this.mFactoryTest && pkg.requestedPermissions.contains("android.permission.FACTORY_TEST")) {
            pkg.applicationInfo.flags |= 0x10;
        }
        ArrayList<PackageParser.Package> clientLibPkgs = null;
        nativeLibPath = this.mPackages;
        synchronized (nativeLibPath) {
            if ((pkg.applicationInfo.flags & 1) != 0 && pkg.libraryNames != null) {
                for (int i = 0; i < pkg.libraryNames.size(); ++i) {
                    String name = pkg.libraryNames.get(i);
                    boolean allowed = false;
                    if (pkg.isUpdatedSystemApp()) {
                        PackageSetting sysPs = this.mSettings.getDisabledSystemPkgLPr(pkg.packageName);
                        if (sysPs.pkg != null && sysPs.pkg.libraryNames != null) {
                            for (int j = 0; j < sysPs.pkg.libraryNames.size(); ++j) {
                                if (!name.equals(sysPs.pkg.libraryNames.get(j))) continue;
                                allowed = true;
                                allowed = true;
                                break;
                            }
                        }
                    } else {
                        allowed = true;
                    }
                    if (allowed) {
                        if (!this.mSharedLibraries.containsKey(name)) {
                            this.mSharedLibraries.put(name, new SharedLibraryEntry(null, pkg.packageName));
                            continue;
                        }
                        if (name.equals(pkg.packageName)) continue;
                        Slog.w(TAG, "Package " + pkg.packageName + " library " + name + " already exists; skipping");
                        continue;
                    }
                    Slog.w(TAG, "Package " + pkg.packageName + " declares lib " + name + " that is not declared on system image; skipping");
                }
                if ((scanFlags & 0x100) == 0) {
                    clientLibPkgs = this.updateAllSharedLibrariesLPw(pkg);
                }
            }
        }
        if (clientLibPkgs != null && (scanFlags & 2) == 0) {
            for (int i = 0; i < clientLibPkgs.size(); ++i) {
                PackageParser.Package clientPkg = clientLibPkgs.get(i);
                int result2 = this.mPackageDexOptimizer.performDexOpt(clientPkg, null, forceDex, (scanFlags & 0x80) != 0, false);
                if (result2 != -1) continue;
                throw new PackageManagerException(-11, "scanPackageLI failed to dexopt clientLibPkgs");
            }
        }
        if ((scanFlags & 0x800) != 0) {
            this.killApplication(pkg.applicationInfo.packageName, pkg.applicationInfo.uid, "replace pkg");
        }
        if (clientLibPkgs != null) {
            for (int i = 0; i < clientLibPkgs.size(); ++i) {
                PackageParser.Package clientPkg = clientLibPkgs.get(i);
                this.killApplication(clientPkg.applicationInfo.packageName, clientPkg.applicationInfo.uid, "update lib");
            }
        }
        KeySetManagerService ksms = this.mSettings.mKeySetManagerService;
        ksms.assertScannedPackageValid(pkg);
        ArrayMap<String, PackageParser.Package> arrayMap2 = this.mPackages;
        synchronized (arrayMap2) {
            PackageParser.Component a;
            PackageParser.Component p;
            int i;
            this.mSettings.insertPackageSettingLPw(pkgSetting, pkg);
            this.mPackages.put(pkg.applicationInfo.packageName, pkg);
            Iterator<PackageCleanItem> iter = this.mSettings.mPackagesToBeCleaned.iterator();
            while (iter.hasNext()) {
                PackageCleanItem item = iter.next();
                if (!pkgName.equals(item.packageName)) continue;
                iter.remove();
            }
            if (currentTime != 0L) {
                if (pkgSetting.firstInstallTime == 0L) {
                    pkgSetting.firstInstallTime = pkgSetting.lastUpdateTime = currentTime;
                } else if ((scanFlags & 0x40) != 0) {
                    pkgSetting.lastUpdateTime = currentTime;
                }
            } else if (pkgSetting.firstInstallTime == 0L) {
                pkgSetting.firstInstallTime = pkgSetting.lastUpdateTime = scanFileTime;
            } else if ((parseFlags & 0x40) != 0 && scanFileTime != pkgSetting.timeStamp) {
                pkgSetting.lastUpdateTime = scanFileTime;
            }
            ksms.addScannedPackageLPw(pkg);
            int N = pkg.providers.size();
            StringBuilder r = null;
            for (i = 0; i < N; ++i) {
                p = pkg.providers.get(i);
                p.info.processName = PackageManagerService.fixProcessName(pkg.applicationInfo.processName, p.info.processName, pkg.applicationInfo.uid);
                this.mProviders.addProvider((PackageParser.Provider)p);
                p.syncable = p.info.isSyncable;
                if (p.info.authority != null) {
                    String[] names = p.info.authority.split(";");
                    p.info.authority = null;
                    for (int j = 0; j < names.length; ++j) {
                        if (j == 1 && p.syncable) {
                            p = new PackageParser.Provider((PackageParser.Provider)p);
                            p.syncable = false;
                        }
                        if (!this.mProvidersByAuthority.containsKey(names[j])) {
                            this.mProvidersByAuthority.put(names[j], (PackageParser.Provider)p);
                            if (p.info.authority == null) {
                                p.info.authority = names[j];
                                continue;
                            }
                            p.info.authority = p.info.authority + ";" + names[j];
                            continue;
                        }
                        PackageParser.Provider other = this.mProvidersByAuthority.get(names[j]);
                        Slog.w(TAG, "Skipping provider name " + names[j] + " (in package " + pkg.applicationInfo.packageName + "): name already used by " + (other != null && other.getComponentName() != null ? other.getComponentName().getPackageName() : "?"));
                    }
                }
                if ((parseFlags & 2) == 0) continue;
                if (r == null) {
                    r = new StringBuilder(256);
                } else {
                    r.append(' ');
                }
                r.append(p.info.name);
            }
            if (r != null) {
                // empty if block
            }
            N = pkg.services.size();
            r = null;
            for (i = 0; i < N; ++i) {
                PackageParser.Service s = pkg.services.get(i);
                s.info.processName = PackageManagerService.fixProcessName(pkg.applicationInfo.processName, s.info.processName, pkg.applicationInfo.uid);
                this.mServices.addService(s);
                if ((parseFlags & 2) == 0) continue;
                if (r == null) {
                    r = new StringBuilder(256);
                } else {
                    r.append(' ');
                }
                r.append(s.info.name);
            }
            if (r != null) {
                // empty if block
            }
            N = pkg.receivers.size();
            r = null;
            for (i = 0; i < N; ++i) {
                a = pkg.receivers.get(i);
                ((PackageParser.Activity)a).info.processName = PackageManagerService.fixProcessName(pkg.applicationInfo.processName, ((PackageParser.Activity)a).info.processName, pkg.applicationInfo.uid);
                this.mReceivers.addActivity((PackageParser.Activity)a, "receiver");
                if ((parseFlags & 2) == 0) continue;
                if (r == null) {
                    r = new StringBuilder(256);
                } else {
                    r.append(' ');
                }
                r.append(((PackageParser.Activity)a).info.name);
            }
            if (r != null) {
                // empty if block
            }
            N = pkg.activities.size();
            r = null;
            for (i = 0; i < N; ++i) {
                a = pkg.activities.get(i);
                ((PackageParser.Activity)a).info.processName = PackageManagerService.fixProcessName(pkg.applicationInfo.processName, ((PackageParser.Activity)a).info.processName, pkg.applicationInfo.uid);
                this.mActivities.addActivity((PackageParser.Activity)a, "activity");
                if ((parseFlags & 2) == 0) continue;
                if (r == null) {
                    r = new StringBuilder(256);
                } else {
                    r.append(' ');
                }
                r.append(((PackageParser.Activity)a).info.name);
            }
            if (r != null) {
                // empty if block
            }
            N = pkg.permissionGroups.size();
            r = null;
            for (i = 0; i < N; ++i) {
                PackageParser.PermissionGroup pg = pkg.permissionGroups.get(i);
                PackageParser.PermissionGroup cur = this.mPermissionGroups.get(pg.info.name);
                if (cur == null) {
                    this.mPermissionGroups.put(pg.info.name, pg);
                    if ((parseFlags & 2) == 0) continue;
                    if (r == null) {
                        r = new StringBuilder(256);
                    } else {
                        r.append(' ');
                    }
                    r.append(pg.info.name);
                    continue;
                }
                Slog.w(TAG, "Permission group " + pg.info.name + " from package " + pg.info.packageName + " ignored: original from " + cur.info.packageName);
                if ((parseFlags & 2) == 0) continue;
                if (r == null) {
                    r = new StringBuilder(256);
                } else {
                    r.append(' ');
                }
                r.append("DUP:");
                r.append(pg.info.name);
            }
            if (r != null) {
                // empty if block
            }
            N = pkg.permissions.size();
            r = null;
            for (i = 0; i < N; ++i) {
                ArrayMap<String, BasePermission> permissionMap;
                BasePermission bp;
                p = pkg.permissions.get(i);
                ((PackageParser.Permission)p).info.flags &= 0xBFFFFFFF;
                if (pkg.applicationInfo.targetSdkVersion > 22) {
                    ((PackageParser.Permission)p).group = this.mPermissionGroups.get(((PackageParser.Permission)p).info.group);
                    if (((PackageParser.Permission)p).info.group != null && ((PackageParser.Permission)p).group == null) {
                        Slog.w(TAG, "Permission " + ((PackageParser.Permission)p).info.name + " from package " + ((PackageParser.Permission)p).info.packageName + " in an unknown group " + ((PackageParser.Permission)p).info.group);
                    }
                }
                if ((bp = (permissionMap = ((PackageParser.Permission)p).tree ? this.mSettings.mPermissionTrees : this.mSettings.mPermissions).get(((PackageParser.Permission)p).info.name)) != null && !Objects.equals(bp.sourcePackage, ((PackageParser.Permission)p).info.packageName)) {
                    boolean currentOwnerIsSystem;
                    boolean bl = currentOwnerIsSystem = bp.perm != null && PackageManagerService.isSystemApp(bp.perm.owner);
                    if (PackageManagerService.isSystemApp(((PackageParser.Permission)p).owner)) {
                        if (bp.type == 1 && bp.perm == null) {
                            bp.packageSetting = pkgSetting;
                            bp.perm = p;
                            bp.uid = pkg.applicationInfo.uid;
                            bp.sourcePackage = ((PackageParser.Permission)p).info.packageName;
                            ((PackageParser.Permission)p).info.flags |= 0x40000000;
                        } else if (!currentOwnerIsSystem) {
                            String msg3 = "New decl " + ((PackageParser.Permission)p).owner + " of permission  " + ((PackageParser.Permission)p).info.name + " is system; overriding " + bp.sourcePackage;
                            PackageManagerService.reportSettingsProblem(5, msg3);
                            bp = null;
                        }
                    }
                }
                if (bp == null) {
                    bp = new BasePermission(((PackageParser.Permission)p).info.name, ((PackageParser.Permission)p).info.packageName, 0);
                    permissionMap.put(((PackageParser.Permission)p).info.name, bp);
                }
                if (bp.perm == null) {
                    if (bp.sourcePackage == null || bp.sourcePackage.equals(((PackageParser.Permission)p).info.packageName)) {
                        BasePermission tree = this.findPermissionTreeLP(((PackageParser.Permission)p).info.name);
                        if (tree == null || tree.sourcePackage.equals(((PackageParser.Permission)p).info.packageName)) {
                            bp.packageSetting = pkgSetting;
                            bp.perm = p;
                            bp.uid = pkg.applicationInfo.uid;
                            bp.sourcePackage = ((PackageParser.Permission)p).info.packageName;
                            ((PackageParser.Permission)p).info.flags |= 0x40000000;
                            if ((parseFlags & 2) != 0) {
                                if (r == null) {
                                    r = new StringBuilder(256);
                                } else {
                                    r.append(' ');
                                }
                                r.append(((PackageParser.Permission)p).info.name);
                            }
                        } else {
                            Slog.w(TAG, "Permission " + ((PackageParser.Permission)p).info.name + " from package " + ((PackageParser.Permission)p).info.packageName + " ignored: base tree " + tree.name + " is from package " + tree.sourcePackage);
                        }
                    } else {
                        Slog.w(TAG, "Permission " + ((PackageParser.Permission)p).info.name + " from package " + ((PackageParser.Permission)p).info.packageName + " ignored: original from " + bp.sourcePackage);
                    }
                } else if ((parseFlags & 2) != 0) {
                    if (r == null) {
                        r = new StringBuilder(256);
                    } else {
                        r.append(' ');
                    }
                    r.append("DUP:");
                    r.append(((PackageParser.Permission)p).info.name);
                }
                if (bp.perm != p) continue;
                bp.protectionLevel = ((PackageParser.Permission)p).info.protectionLevel;
            }
            if (r != null) {
                // empty if block
            }
            N = pkg.instrumentation.size();
            r = null;
            for (i = 0; i < N; ++i) {
                a = pkg.instrumentation.get(i);
                ((PackageParser.Instrumentation)a).info.packageName = pkg.applicationInfo.packageName;
                ((PackageParser.Instrumentation)a).info.sourceDir = pkg.applicationInfo.sourceDir;
                ((PackageParser.Instrumentation)a).info.publicSourceDir = pkg.applicationInfo.publicSourceDir;
                ((PackageParser.Instrumentation)a).info.splitSourceDirs = pkg.applicationInfo.splitSourceDirs;
                ((PackageParser.Instrumentation)a).info.splitPublicSourceDirs = pkg.applicationInfo.splitPublicSourceDirs;
                ((PackageParser.Instrumentation)a).info.dataDir = pkg.applicationInfo.dataDir;
                ((PackageParser.Instrumentation)a).info.nativeLibraryDir = pkg.applicationInfo.nativeLibraryDir;
                this.mInstrumentation.put(a.getComponentName(), (PackageParser.Instrumentation)a);
                if ((parseFlags & 2) == 0) continue;
                if (r == null) {
                    r = new StringBuilder(256);
                } else {
                    r.append(' ');
                }
                r.append(((PackageParser.Instrumentation)a).info.name);
            }
            if (r != null) {
                // empty if block
            }
            if (pkg.protectedBroadcasts != null) {
                N = pkg.protectedBroadcasts.size();
                for (i = 0; i < N; ++i) {
                    this.mProtectedBroadcasts.add(pkg.protectedBroadcasts.get(i));
                }
            }
            pkgSetting.setTimeStamp(scanFileTime);
            if (pkg.mOverlayTarget != null) {
                if (pkg.mOverlayTarget != null && !pkg.mOverlayTarget.equals("android")) {
                    if (!this.mOverlays.containsKey(pkg.mOverlayTarget)) {
                        this.mOverlays.put(pkg.mOverlayTarget, new ArrayMap());
                    }
                    ArrayMap<String, PackageParser.Package> map = this.mOverlays.get(pkg.mOverlayTarget);
                    map.put(pkg.packageName, pkg);
                    PackageParser.Package orig = this.mPackages.get(pkg.mOverlayTarget);
                    if (orig != null && !this.createIdmapForPackagePairLI(orig, pkg)) {
                        throw new PackageManagerException(-7, "scanPackageLI failed to createIdmap");
                    }
                }
            } else if (this.mOverlays.containsKey(pkg.packageName) && !pkg.packageName.equals("android")) {
                this.createIdmapsForPackageLI(pkg);
            }
        }
        return pkg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void derivePackageAbi(PackageParser.Package pkg, File scanFile, String cpuAbiOverride, boolean extractLibs) throws PackageManagerException {
        this.setNativeLibraryPaths(pkg);
        if (pkg.isForwardLocked() || PackageManagerService.isExternal(pkg) || PackageManagerService.isSystemApp(pkg) && !pkg.isUpdatedSystemApp()) {
            extractLibs = false;
        }
        String nativeLibraryRootStr = pkg.applicationInfo.nativeLibraryRootDir;
        boolean useIsaSpecificSubdirs = pkg.applicationInfo.nativeLibraryRootRequiresIsa;
        NativeLibraryHelper.Handle handle = null;
        try {
            handle = NativeLibraryHelper.Handle.create(scanFile);
            File nativeLibraryRoot = new File(nativeLibraryRootStr);
            pkg.applicationInfo.primaryCpuAbi = null;
            pkg.applicationInfo.secondaryCpuAbi = null;
            if (PackageManagerService.isMultiArch(pkg.applicationInfo)) {
                if (pkg.cpuAbiOverride != null && !INSTALL_PACKAGE_SUFFIX.equals(pkg.cpuAbiOverride)) {
                    Slog.w(TAG, "Ignoring abiOverride for multi arch application.");
                }
                int abi32 = -114;
                int abi64 = -114;
                if (Build.SUPPORTED_32_BIT_ABIS.length > 0) {
                    abi32 = extractLibs ? NativeLibraryHelper.copyNativeBinariesForSupportedAbi(handle, nativeLibraryRoot, Build.SUPPORTED_32_BIT_ABIS, useIsaSpecificSubdirs) : NativeLibraryHelper.findSupportedAbi(handle, Build.SUPPORTED_32_BIT_ABIS);
                }
                PackageManagerService.maybeThrowExceptionForMultiArchCopy("Error unpackaging 32 bit native libs for multiarch app.", abi32);
                if (Build.SUPPORTED_64_BIT_ABIS.length > 0) {
                    abi64 = extractLibs ? NativeLibraryHelper.copyNativeBinariesForSupportedAbi(handle, nativeLibraryRoot, Build.SUPPORTED_64_BIT_ABIS, useIsaSpecificSubdirs) : NativeLibraryHelper.findSupportedAbi(handle, Build.SUPPORTED_64_BIT_ABIS);
                }
                PackageManagerService.maybeThrowExceptionForMultiArchCopy("Error unpackaging 64 bit native libs for multiarch app.", abi64);
                if (abi64 >= 0) {
                    pkg.applicationInfo.primaryCpuAbi = Build.SUPPORTED_64_BIT_ABIS[abi64];
                }
                if (abi32 >= 0) {
                    String abi = Build.SUPPORTED_32_BIT_ABIS[abi32];
                    if (abi64 >= 0) {
                        pkg.applicationInfo.secondaryCpuAbi = abi;
                    } else {
                        pkg.applicationInfo.primaryCpuAbi = abi;
                    }
                }
            } else {
                int copyRet;
                String[] stringArray;
                if (cpuAbiOverride != null) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = cpuAbiOverride;
                } else {
                    stringArray = Build.SUPPORTED_ABIS;
                }
                String[] abiList = stringArray;
                boolean needsRenderScriptOverride = false;
                if (Build.SUPPORTED_64_BIT_ABIS.length > 0 && cpuAbiOverride == null && NativeLibraryHelper.hasRenderscriptBitcode(handle)) {
                    abiList = Build.SUPPORTED_32_BIT_ABIS;
                    needsRenderScriptOverride = true;
                }
                if ((copyRet = extractLibs ? NativeLibraryHelper.copyNativeBinariesForSupportedAbi(handle, nativeLibraryRoot, abiList, useIsaSpecificSubdirs) : NativeLibraryHelper.findSupportedAbi(handle, abiList)) < 0 && copyRet != -114) {
                    throw new PackageManagerException(-110, "Error unpackaging native libs for app, errorCode=" + copyRet);
                }
                if (copyRet >= 0) {
                    pkg.applicationInfo.primaryCpuAbi = abiList[copyRet];
                } else if (copyRet == -114 && cpuAbiOverride != null) {
                    pkg.applicationInfo.primaryCpuAbi = cpuAbiOverride;
                } else if (needsRenderScriptOverride) {
                    pkg.applicationInfo.primaryCpuAbi = abiList[0];
                }
            }
        }
        catch (IOException ioe) {
            Slog.e(TAG, "Unable to get canonical file " + ioe.toString());
        }
        finally {
            IoUtils.closeQuietly(handle);
        }
        this.setNativeLibraryPaths(pkg);
    }

    private void adjustCpuAbisForSharedUserLPw(Set<PackageSetting> packagesForUser, PackageParser.Package scannedPackage, boolean forceDexOpt, boolean deferDexOpt) {
        String requiredInstructionSet = null;
        if (scannedPackage != null && scannedPackage.applicationInfo.primaryCpuAbi != null) {
            requiredInstructionSet = VMRuntime.getInstructionSet(scannedPackage.applicationInfo.primaryCpuAbi);
        }
        PackageSetting requirer = null;
        for (PackageSetting ps : packagesForUser) {
            if (scannedPackage != null && scannedPackage.packageName.equals(ps.name) || ps.primaryCpuAbiString == null) continue;
            String instructionSet = VMRuntime.getInstructionSet(ps.primaryCpuAbiString);
            if (requiredInstructionSet != null && !instructionSet.equals(requiredInstructionSet)) {
                String errorMessage = "Instruction set mismatch, " + (requirer == null ? "[caller]" : requirer) + " requires " + requiredInstructionSet + " whereas " + ps + " requires " + instructionSet;
                Slog.w(TAG, errorMessage);
            }
            if (requiredInstructionSet != null) continue;
            requiredInstructionSet = instructionSet;
            requirer = ps;
        }
        if (requiredInstructionSet != null) {
            String adjustedAbi;
            if (requirer != null) {
                adjustedAbi = requirer.primaryCpuAbiString;
                if (scannedPackage != null) {
                    scannedPackage.applicationInfo.primaryCpuAbi = adjustedAbi;
                }
            } else {
                adjustedAbi = scannedPackage.applicationInfo.primaryCpuAbi;
            }
            for (PackageSetting ps : packagesForUser) {
                if (scannedPackage != null && scannedPackage.packageName.equals(ps.name) || ps.primaryCpuAbiString != null) continue;
                ps.primaryCpuAbiString = adjustedAbi;
                if (ps.pkg == null || ps.pkg.applicationInfo == null) continue;
                ps.pkg.applicationInfo.primaryCpuAbi = adjustedAbi;
                Slog.i(TAG, "Adjusting ABI for : " + ps.name + " to " + adjustedAbi);
                int result = this.mPackageDexOptimizer.performDexOpt(ps.pkg, null, forceDexOpt, deferDexOpt, true);
                if (result == -1) {
                    ps.primaryCpuAbiString = null;
                    ps.pkg.applicationInfo.primaryCpuAbi = null;
                    return;
                }
                this.mInstaller.rmdex(ps.codePathString, InstructionSets.getDexCodeInstructionSet(InstructionSets.getPreferredInstructionSet()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUpCustomResolverActivity(PackageParser.Package pkg) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            this.mResolverReplaced = true;
            this.mResolveActivity.applicationInfo = pkg.applicationInfo;
            this.mResolveActivity.name = this.mCustomResolverComponentName.getClassName();
            this.mResolveActivity.packageName = pkg.applicationInfo.packageName;
            this.mResolveActivity.processName = pkg.applicationInfo.packageName;
            this.mResolveActivity.launchMode = 0;
            this.mResolveActivity.flags = 288;
            this.mResolveActivity.theme = 0;
            this.mResolveActivity.exported = true;
            this.mResolveActivity.enabled = true;
            this.mResolveInfo.activityInfo = this.mResolveActivity;
            this.mResolveInfo.priority = 0;
            this.mResolveInfo.preferredOrder = 0;
            this.mResolveInfo.match = 0;
            this.mResolveComponentName = this.mCustomResolverComponentName;
            Slog.i(TAG, "Replacing default ResolverActivity with custom activity: " + this.mResolveComponentName);
        }
    }

    private static String calculateBundledApkRoot(String codePathString) {
        File codeRoot;
        File codePath = new File(codePathString);
        if (FileUtils.contains(Environment.getRootDirectory(), codePath)) {
            codeRoot = Environment.getRootDirectory();
        } else if (FileUtils.contains(Environment.getOemDirectory(), codePath)) {
            codeRoot = Environment.getOemDirectory();
        } else if (FileUtils.contains(Environment.getVendorDirectory(), codePath)) {
            codeRoot = Environment.getVendorDirectory();
        } else {
            try {
                File tmp;
                File f = codePath.getCanonicalFile();
                File parent = f.getParentFile();
                while ((tmp = parent.getParentFile()) != null) {
                    f = parent;
                    parent = tmp;
                }
                codeRoot = f;
                Slog.w(TAG, "Unrecognized code path " + codePath + " - using " + codeRoot);
            }
            catch (IOException e) {
                Slog.w(TAG, "Can't canonicalize code path " + codePath);
                return Environment.getRootDirectory().getPath();
            }
        }
        return codeRoot.getPath();
    }

    private void setNativeLibraryPaths(PackageParser.Package pkg) {
        ApplicationInfo info = pkg.applicationInfo;
        String codePath = pkg.codePath;
        File codeFile = new File(codePath);
        boolean bundledApp = info.isSystemApp() && !info.isUpdatedSystemApp();
        boolean asecApp = info.isForwardLocked() || PackageManagerService.isExternal(info);
        info.nativeLibraryRootDir = null;
        info.nativeLibraryRootRequiresIsa = false;
        info.nativeLibraryDir = null;
        info.secondaryNativeLibraryDir = null;
        if (PackageParser.isApkFile(codeFile)) {
            if (bundledApp) {
                String apkRoot = PackageManagerService.calculateBundledApkRoot(info.sourceDir);
                boolean is64Bit = VMRuntime.is64BitInstructionSet(InstructionSets.getPrimaryInstructionSet(info));
                String apkName = PackageManagerService.deriveCodePathName(codePath);
                String libDir = is64Bit ? "lib64" : "lib";
                info.nativeLibraryRootDir = Environment.buildPath(new File(apkRoot), libDir, apkName).getAbsolutePath();
                if (info.secondaryCpuAbi != null) {
                    String secondaryLibDir = is64Bit ? "lib" : "lib64";
                    info.secondaryNativeLibraryDir = Environment.buildPath(new File(apkRoot), secondaryLibDir, apkName).getAbsolutePath();
                }
            } else if (asecApp) {
                info.nativeLibraryRootDir = new File(codeFile.getParentFile(), "lib").getAbsolutePath();
            } else {
                String apkName = PackageManagerService.deriveCodePathName(codePath);
                info.nativeLibraryRootDir = new File(this.mAppLib32InstallDir, apkName).getAbsolutePath();
            }
            info.nativeLibraryRootRequiresIsa = false;
            info.nativeLibraryDir = info.nativeLibraryRootDir;
        } else {
            info.nativeLibraryRootDir = new File(codeFile, "lib").getAbsolutePath();
            info.nativeLibraryRootRequiresIsa = true;
            info.nativeLibraryDir = new File(info.nativeLibraryRootDir, InstructionSets.getPrimaryInstructionSet(info)).getAbsolutePath();
            if (info.secondaryCpuAbi != null) {
                info.secondaryNativeLibraryDir = new File(info.nativeLibraryRootDir, VMRuntime.getInstructionSet(info.secondaryCpuAbi)).getAbsolutePath();
            }
        }
    }

    private void setBundledAppAbisAndRoots(PackageParser.Package pkg, PackageSetting pkgSetting) {
        String apkName = PackageManagerService.deriveCodePathName(pkg.applicationInfo.getCodePath());
        String apkRoot = PackageManagerService.calculateBundledApkRoot(pkg.applicationInfo.sourceDir);
        PackageManagerService.setBundledAppAbi(pkg, apkRoot, apkName);
        if (pkgSetting != null) {
            pkgSetting.primaryCpuAbiString = pkg.applicationInfo.primaryCpuAbi;
            pkgSetting.secondaryCpuAbiString = pkg.applicationInfo.secondaryCpuAbi;
        }
    }

    private static void setBundledAppAbi(PackageParser.Package pkg, String apkRoot, String apkName) {
        boolean has32BitLibs;
        boolean has64BitLibs;
        File codeFile = new File(pkg.codePath);
        if (PackageParser.isApkFile(codeFile)) {
            has64BitLibs = new File(apkRoot, new File("lib64", apkName).getPath()).exists();
            has32BitLibs = new File(apkRoot, new File("lib", apkName).getPath()).exists();
        } else {
            String isa;
            File rootDir = new File(codeFile, "lib");
            if (!ArrayUtils.isEmpty(Build.SUPPORTED_64_BIT_ABIS) && !TextUtils.isEmpty(Build.SUPPORTED_64_BIT_ABIS[0])) {
                isa = VMRuntime.getInstructionSet(Build.SUPPORTED_64_BIT_ABIS[0]);
                has64BitLibs = new File(rootDir, isa).exists();
            } else {
                has64BitLibs = false;
            }
            if (!ArrayUtils.isEmpty(Build.SUPPORTED_32_BIT_ABIS) && !TextUtils.isEmpty(Build.SUPPORTED_32_BIT_ABIS[0])) {
                isa = VMRuntime.getInstructionSet(Build.SUPPORTED_32_BIT_ABIS[0]);
                has32BitLibs = new File(rootDir, isa).exists();
            } else {
                has32BitLibs = false;
            }
        }
        if (has64BitLibs && !has32BitLibs) {
            pkg.applicationInfo.primaryCpuAbi = Build.SUPPORTED_64_BIT_ABIS[0];
            pkg.applicationInfo.secondaryCpuAbi = null;
        } else if (has32BitLibs && !has64BitLibs) {
            pkg.applicationInfo.primaryCpuAbi = Build.SUPPORTED_32_BIT_ABIS[0];
            pkg.applicationInfo.secondaryCpuAbi = null;
        } else if (has32BitLibs && has64BitLibs) {
            if ((pkg.applicationInfo.flags & Integer.MIN_VALUE) == 0) {
                Slog.e(TAG, "Package: " + pkg + " has multiple bundled libs, but is not multiarch.");
            }
            if (VMRuntime.is64BitInstructionSet(InstructionSets.getPreferredInstructionSet())) {
                pkg.applicationInfo.primaryCpuAbi = Build.SUPPORTED_64_BIT_ABIS[0];
                pkg.applicationInfo.secondaryCpuAbi = Build.SUPPORTED_32_BIT_ABIS[0];
            } else {
                pkg.applicationInfo.primaryCpuAbi = Build.SUPPORTED_32_BIT_ABIS[0];
                pkg.applicationInfo.secondaryCpuAbi = Build.SUPPORTED_64_BIT_ABIS[0];
            }
        } else {
            pkg.applicationInfo.primaryCpuAbi = null;
            pkg.applicationInfo.secondaryCpuAbi = null;
        }
    }

    private void killApplication(String pkgName, int appId, String reason) {
        IActivityManager am = ActivityManagerNative.getDefault();
        if (am != null) {
            try {
                am.killApplicationWithAppId(pkgName, appId, reason);
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removePackageLI(PackageSetting ps, boolean chatty) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            this.mPackages.remove(ps.name);
            PackageParser.Package pkg = ps.pkg;
            if (pkg != null) {
                this.cleanPackageDataStructuresLILPw(pkg, chatty);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeInstalledPackageLI(PackageParser.Package pkg, boolean chatty) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            this.mPackages.remove(pkg.applicationInfo.packageName);
            this.cleanPackageDataStructuresLILPw(pkg, chatty);
        }
    }

    void cleanPackageDataStructuresLILPw(PackageParser.Package pkg, boolean chatty) {
        BasePermission bp;
        PackageParser.Component a;
        PackageParser.Component p;
        int i;
        int N = pkg.providers.size();
        StringBuilder r = null;
        for (i = 0; i < N; ++i) {
            p = pkg.providers.get(i);
            this.mProviders.removeProvider((PackageParser.Provider)p);
            if (p.info.authority == null) continue;
            String[] names = p.info.authority.split(";");
            for (int j = 0; j < names.length; ++j) {
                if (this.mProvidersByAuthority.get(names[j]) != p) continue;
                this.mProvidersByAuthority.remove(names[j]);
            }
        }
        if (r != null) {
            // empty if block
        }
        N = pkg.services.size();
        r = null;
        for (i = 0; i < N; ++i) {
            PackageParser.Service s = pkg.services.get(i);
            this.mServices.removeService(s);
            if (!chatty) continue;
            if (r == null) {
                r = new StringBuilder(256);
            } else {
                r.append(' ');
            }
            r.append(s.info.name);
        }
        if (r != null) {
            // empty if block
        }
        N = pkg.receivers.size();
        r = null;
        for (i = 0; i < N; ++i) {
            a = pkg.receivers.get(i);
            this.mReceivers.removeActivity((PackageParser.Activity)a, "receiver");
        }
        if (r != null) {
            // empty if block
        }
        N = pkg.activities.size();
        r = null;
        for (i = 0; i < N; ++i) {
            a = pkg.activities.get(i);
            this.mActivities.removeActivity((PackageParser.Activity)a, "activity");
        }
        if (r != null) {
            // empty if block
        }
        N = pkg.permissions.size();
        r = null;
        for (i = 0; i < N; ++i) {
            ArraySet<String> appOpPerms;
            p = pkg.permissions.get(i);
            bp = this.mSettings.mPermissions.get(((PackageParser.Permission)p).info.name);
            if (bp == null) {
                bp = this.mSettings.mPermissionTrees.get(((PackageParser.Permission)p).info.name);
            }
            if (bp != null && bp.perm == p) {
                bp.perm = null;
            }
            if ((((PackageParser.Permission)p).info.protectionLevel & 0x40) == 0 || (appOpPerms = this.mAppOpPermissionPackages.get(((PackageParser.Permission)p).info.name)) == null) continue;
            appOpPerms.remove(pkg.packageName);
        }
        if (r != null) {
            // empty if block
        }
        N = pkg.requestedPermissions.size();
        r = null;
        for (i = 0; i < N; ++i) {
            ArraySet<String> appOpPerms;
            String perm = pkg.requestedPermissions.get(i);
            bp = this.mSettings.mPermissions.get(perm);
            if (bp == null || (bp.protectionLevel & 0x40) == 0 || (appOpPerms = this.mAppOpPermissionPackages.get(perm)) == null) continue;
            appOpPerms.remove(pkg.packageName);
            if (!appOpPerms.isEmpty()) continue;
            this.mAppOpPermissionPackages.remove(perm);
        }
        if (r != null) {
            // empty if block
        }
        N = pkg.instrumentation.size();
        r = null;
        for (i = 0; i < N; ++i) {
            a = pkg.instrumentation.get(i);
            this.mInstrumentation.remove(a.getComponentName());
        }
        if (r != null) {
            // empty if block
        }
        r = null;
        if ((pkg.applicationInfo.flags & 1) != 0 && pkg.libraryNames != null) {
            for (i = 0; i < pkg.libraryNames.size(); ++i) {
                String name = pkg.libraryNames.get(i);
                SharedLibraryEntry cur = this.mSharedLibraries.get(name);
                if (cur == null || cur.apk == null || !cur.apk.equals(pkg.packageName)) continue;
                this.mSharedLibraries.remove(name);
            }
        }
        if (r != null) {
            // empty if block
        }
    }

    private static boolean hasPermission(PackageParser.Package pkgInfo, String perm) {
        for (int i = pkgInfo.permissions.size() - 1; i >= 0; --i) {
            if (!pkgInfo.permissions.get((int)i).info.name.equals(perm)) continue;
            return true;
        }
        return false;
    }

    private void updatePermissionsLPw(String changingPkg, PackageParser.Package pkgInfo, int flags) {
        BasePermission bp;
        Iterator<BasePermission> it = this.mSettings.mPermissionTrees.values().iterator();
        while (it.hasNext()) {
            bp = it.next();
            if (bp.packageSetting == null) {
                bp.packageSetting = this.mSettings.mPackages.get(bp.sourcePackage);
            }
            if (bp.packageSetting == null) {
                Slog.w(TAG, "Removing dangling permission tree: " + bp.name + " from package " + bp.sourcePackage);
                it.remove();
                continue;
            }
            if (changingPkg == null || !changingPkg.equals(bp.sourcePackage) || pkgInfo != null && PackageManagerService.hasPermission(pkgInfo, bp.name)) continue;
            Slog.i(TAG, "Removing old permission tree: " + bp.name + " from package " + bp.sourcePackage);
            flags |= 1;
            it.remove();
        }
        it = this.mSettings.mPermissions.values().iterator();
        while (it.hasNext()) {
            BasePermission tree;
            bp = it.next();
            if (bp.type == 2 && bp.packageSetting == null && bp.pendingInfo != null && (tree = this.findPermissionTreeLP(bp.name)) != null && tree.perm != null) {
                bp.packageSetting = tree.packageSetting;
                bp.perm = new PackageParser.Permission(tree.perm.owner, new PermissionInfo(bp.pendingInfo));
                bp.perm.info.packageName = tree.perm.info.packageName;
                bp.perm.info.name = bp.name;
                bp.uid = tree.uid;
            }
            if (bp.packageSetting == null) {
                bp.packageSetting = this.mSettings.mPackages.get(bp.sourcePackage);
            }
            if (bp.packageSetting == null) {
                Slog.w(TAG, "Removing dangling permission: " + bp.name + " from package " + bp.sourcePackage);
                it.remove();
                continue;
            }
            if (changingPkg == null || !changingPkg.equals(bp.sourcePackage) || pkgInfo != null && PackageManagerService.hasPermission(pkgInfo, bp.name)) continue;
            Slog.i(TAG, "Removing old permission: " + bp.name + " from package " + bp.sourcePackage);
            flags |= 1;
            it.remove();
        }
        if ((flags & 1) != 0) {
            for (PackageParser.Package pkg : this.mPackages.values()) {
                if (pkg == pkgInfo) continue;
                this.grantPermissionsLPw(pkg, (flags & 4) != 0, changingPkg);
            }
        }
        if (pkgInfo != null) {
            this.grantPermissionsLPw(pkgInfo, (flags & 2) != 0, changingPkg);
        }
    }

    private void grantPermissionsLPw(PackageParser.Package pkg, boolean replace, String packageOfInterest) {
        PermissionsState permissionsState;
        PackageSetting ps = (PackageSetting)pkg.mExtras;
        if (ps == null) {
            return;
        }
        PermissionsState origPermissions = permissionsState = ps.getPermissionsState();
        int[] currentUserIds = UserManagerService.getInstance().getUserIds();
        int[] changedRuntimePermissionUserIds = EMPTY_INT_ARRAY;
        boolean changedInstallPermission = false;
        if (replace) {
            ps.installPermissionsFixed = false;
            if (!ps.isSharedUser()) {
                origPermissions = new PermissionsState(permissionsState);
                permissionsState.reset();
            }
        }
        permissionsState.setGlobalGids(this.mGlobalGids);
        int N = pkg.requestedPermissions.size();
        block11: for (int i = 0; i < N; ++i) {
            String name = pkg.requestedPermissions.get(i);
            BasePermission bp = this.mSettings.mPermissions.get(name);
            if (bp == null || bp.packageSetting == null) {
                if (packageOfInterest != null && !packageOfInterest.equals(pkg.packageName)) continue;
                Slog.w(TAG, "Unknown permission " + name + " in package " + pkg.packageName);
                continue;
            }
            String perm = bp.name;
            boolean allowedSig = false;
            int grant = 1;
            if ((bp.protectionLevel & 0x40) != 0) {
                ArraySet<String> pkgs = this.mAppOpPermissionPackages.get(bp.name);
                if (pkgs == null) {
                    pkgs = new ArraySet();
                    this.mAppOpPermissionPackages.put(bp.name, pkgs);
                }
                pkgs.add(pkg.packageName);
            }
            int level = bp.protectionLevel & 0xF;
            switch (level) {
                case 0: {
                    grant = 2;
                    break;
                }
                case 1: {
                    if (pkg.applicationInfo.targetSdkVersion <= 22) {
                        grant = 3;
                        break;
                    }
                    if (origPermissions.hasInstallPermission(bp.name)) {
                        grant = 5;
                        break;
                    }
                    if (this.mPromoteSystemApps && PackageManagerService.isSystemApp(ps) && this.mExistingSystemPackages.contains(ps.name)) {
                        grant = 5;
                        break;
                    }
                    grant = 4;
                    break;
                }
                case 2: {
                    allowedSig = this.grantSignaturePermission(perm, pkg, bp, origPermissions);
                    if (!allowedSig) break;
                    grant = 2;
                }
            }
            if (grant != 1) {
                if (!(PackageManagerService.isSystemApp(ps) || !ps.installPermissionsFixed || allowedSig || origPermissions.hasInstallPermission(perm) || this.isNewPlatformPermissionForPackage(perm, pkg))) {
                    grant = 1;
                }
                switch (grant) {
                    case 2: {
                        for (int userId : UserManagerService.getInstance().getUserIds()) {
                            if (origPermissions.getRuntimePermissionState(bp.name, userId) == null) continue;
                            origPermissions.revokeRuntimePermission(bp, userId);
                            origPermissions.updatePermissionFlags(bp, userId, 255, 0);
                            changedRuntimePermissionUserIds = ArrayUtils.appendInt(changedRuntimePermissionUserIds, userId);
                        }
                        if (permissionsState.grantInstallPermission(bp) == -1) continue block11;
                        changedInstallPermission = true;
                        break;
                    }
                    case 3: {
                        if (permissionsState.grantInstallPermission(bp) == -1) continue block11;
                        changedInstallPermission = true;
                        break;
                    }
                    case 4: {
                        for (int userId : UserManagerService.getInstance().getUserIds()) {
                            int flags;
                            PermissionsState.PermissionState permissionState = origPermissions.getRuntimePermissionState(bp.name, userId);
                            int n = flags = permissionState != null ? permissionState.getFlags() : 0;
                            if (origPermissions.hasRuntimePermission(bp.name, userId) && permissionsState.grantRuntimePermission(bp, userId) == -1) {
                                changedRuntimePermissionUserIds = ArrayUtils.appendInt(changedRuntimePermissionUserIds, userId);
                            }
                            permissionsState.updatePermissionFlags(bp, userId, flags, flags);
                        }
                        continue block11;
                    }
                    case 5: {
                        int flags;
                        PermissionsState.PermissionState permissionState = origPermissions.getInstallPermissionState(bp.name);
                        int n = flags = permissionState != null ? permissionState.getFlags() : 0;
                        if (origPermissions.revokeInstallPermission(bp) != -1) {
                            origPermissions.updatePermissionFlags(bp, -1, 255, 0);
                            changedInstallPermission = true;
                        }
                        if ((flags & 8) != 0) continue block11;
                        for (int userId : currentUserIds) {
                            if (permissionsState.grantRuntimePermission(bp, userId) == -1) continue;
                            permissionsState.updatePermissionFlags(bp, userId, flags, flags);
                            changedRuntimePermissionUserIds = ArrayUtils.appendInt(changedRuntimePermissionUserIds, userId);
                        }
                        continue block11;
                    }
                    default: {
                        if (packageOfInterest != null && !packageOfInterest.equals(pkg.packageName)) continue block11;
                        Slog.w(TAG, "Not granting permission " + perm + " to package " + pkg.packageName + " because it was previously installed without");
                        break;
                    }
                }
                continue;
            }
            if (permissionsState.revokeInstallPermission(bp) != -1) {
                permissionsState.updatePermissionFlags(bp, -1, 255, 0);
                changedInstallPermission = true;
                Slog.i(TAG, "Un-granting permission " + perm + " from package " + pkg.packageName + " (protectionLevel=" + bp.protectionLevel + " flags=0x" + Integer.toHexString(pkg.applicationInfo.flags) + ")");
                continue;
            }
            if ((bp.protectionLevel & 0x40) != 0 || packageOfInterest != null && !packageOfInterest.equals(pkg.packageName)) continue;
            Slog.w(TAG, "Not granting permission " + perm + " to package " + pkg.packageName + " (protectionLevel=" + bp.protectionLevel + " flags=0x" + Integer.toHexString(pkg.applicationInfo.flags) + ")");
        }
        if ((changedInstallPermission || replace) && !ps.installPermissionsFixed && !PackageManagerService.isSystemApp(ps) || PackageManagerService.isUpdatedSystemApp(ps)) {
            ps.installPermissionsFixed = true;
        }
        for (int userId : changedRuntimePermissionUserIds) {
            this.mSettings.writeRuntimePermissionsForUserLPr(userId, false);
        }
    }

    private boolean isNewPlatformPermissionForPackage(String perm, PackageParser.Package pkg) {
        boolean allowed = false;
        for (PackageParser.NewPermissionInfo npi : PackageParser.NEW_PERMISSIONS) {
            if (!npi.name.equals(perm) || pkg.applicationInfo.targetSdkVersion >= npi.sdkVersion) continue;
            allowed = true;
            Log.i(TAG, "Auto-granting " + perm + " to old pkg " + pkg.packageName);
            break;
        }
        return allowed;
    }

    private boolean grantSignaturePermission(String perm, PackageParser.Package pkg, BasePermission bp, PermissionsState origPermissions) {
        boolean allowed;
        boolean bl = allowed = PackageManagerService.compareSignatures(bp.packageSetting.signatures.mSignatures, pkg.mSignatures) == 0 || PackageManagerService.compareSignatures(this.mPlatformPackage.mSignatures, pkg.mSignatures) == 0;
        if (!allowed && (bp.protectionLevel & 0x10) != 0 && PackageManagerService.isSystemApp(pkg)) {
            if (pkg.isUpdatedSystemApp()) {
                PackageSetting sysPs = this.mSettings.getDisabledSystemPkgLPr(pkg.packageName);
                if (sysPs.getPermissionsState().hasInstallPermission(perm)) {
                    if (sysPs.isPrivileged()) {
                        allowed = true;
                    }
                } else if (sysPs.pkg != null && sysPs.isPrivileged()) {
                    for (int j = 0; j < sysPs.pkg.requestedPermissions.size(); ++j) {
                        if (!perm.equals(sysPs.pkg.requestedPermissions.get(j))) continue;
                        allowed = true;
                        break;
                    }
                }
            } else {
                allowed = PackageManagerService.isPrivilegedApp(pkg);
            }
        }
        if (!allowed) {
            if (!allowed && (bp.protectionLevel & 0x80) != 0 && pkg.applicationInfo.targetSdkVersion < 23) {
                allowed = true;
            }
            if (!allowed && (bp.protectionLevel & 0x100) != 0 && pkg.packageName.equals(this.mRequiredInstallerPackage)) {
                allowed = true;
            }
            if (!allowed && (bp.protectionLevel & 0x200) != 0 && pkg.packageName.equals(this.mRequiredVerifierPackage)) {
                allowed = true;
            }
            if (!allowed && (bp.protectionLevel & 0x400) != 0 && PackageManagerService.isSystemApp(pkg)) {
                allowed = true;
            }
            if (!allowed && (bp.protectionLevel & 0x20) != 0) {
                allowed = origPermissions.hasInstallPermission(perm);
            }
        }
        return allowed;
    }

    final void sendPackageBroadcast(final String action, final String pkg, final Bundle extras, final String targetPkg, final IIntentReceiver finishedReceiver, final int[] userIds) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    IActivityManager am = ActivityManagerNative.getDefault();
                    if (am == null) {
                        return;
                    }
                    int[] resolvedUserIds = userIds == null ? am.getRunningUserIds() : userIds;
                    for (int id2 : resolvedUserIds) {
                        int uid;
                        Intent intent = new Intent(action, pkg != null ? Uri.fromParts("package", pkg, null) : null);
                        if (extras != null) {
                            intent.putExtras(extras);
                        }
                        if (targetPkg != null) {
                            intent.setPackage(targetPkg);
                        }
                        if ((uid = intent.getIntExtra("android.intent.extra.UID", -1)) > 0 && UserHandle.getUserId(uid) != id2) {
                            uid = UserHandle.getUid(id2, UserHandle.getAppId(uid));
                            intent.putExtra("android.intent.extra.UID", uid);
                        }
                        intent.putExtra("android.intent.extra.user_handle", id2);
                        intent.addFlags(0x4000000);
                        am.broadcastIntent(null, intent, null, finishedReceiver, 0, null, null, null, -1, null, finishedReceiver != null, false, id2);
                    }
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        });
    }

    private boolean isExternalMediaAvailable() {
        return this.mMediaMounted || Environment.isExternalStorageEmulated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PackageCleanItem nextPackageToClean(PackageCleanItem lastPackage) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            if (!this.isExternalMediaAvailable()) {
                return null;
            }
            ArrayList<PackageCleanItem> pkgs = this.mSettings.mPackagesToBeCleaned;
            if (lastPackage != null) {
                pkgs.remove(lastPackage);
            }
            if (pkgs.size() > 0) {
                return pkgs.get(0);
            }
        }
        return null;
    }

    void schedulePackageCleaning(String packageName, int userId, boolean andCode) {
        Message msg = this.mHandler.obtainMessage(7, userId, andCode ? 1 : 0, packageName);
        if (this.mSystemReady) {
            msg.sendToTarget();
        } else {
            if (this.mPostSystemReadyMessages == null) {
                this.mPostSystemReadyMessages = new ArrayList();
            }
            this.mPostSystemReadyMessages.add(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startCleaningPackages() {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            if (!this.isExternalMediaAvailable()) {
                return;
            }
            if (this.mSettings.mPackagesToBeCleaned.isEmpty()) {
                return;
            }
        }
        Intent intent = new Intent("android.content.pm.CLEAN_EXTERNAL_STORAGE");
        intent.setComponent(DEFAULT_CONTAINER_COMPONENT);
        IActivityManager am = ActivityManagerNative.getDefault();
        if (am != null) {
            try {
                am.startService(null, intent, null, this.mContext.getOpPackageName(), 0);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    @Override
    public void installPackage(String originPath, IPackageInstallObserver2 observer, int installFlags, String installerPackageName, VerificationParams verificationParams, String packageAbiOverride) {
        this.installPackageAsUser(originPath, observer, installFlags, installerPackageName, verificationParams, packageAbiOverride, UserHandle.getCallingUserId());
    }

    @Override
    public void installPackageAsUser(String originPath, IPackageInstallObserver2 observer, int installFlags, String installerPackageName, VerificationParams verificationParams, String packageAbiOverride, int userId) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.INSTALL_PACKAGES", null);
        int callingUid = Binder.getCallingUid();
        this.enforceCrossUserPermission(callingUid, userId, true, true, "installPackageAsUser");
        if (this.isUserRestricted(userId, "no_install_apps")) {
            try {
                if (observer != null) {
                    observer.onPackageInstalled("", -111, null, null);
                }
            }
            catch (RemoteException re) {
                // empty catch block
            }
            return;
        }
        if (callingUid == 2000 || callingUid == 0) {
            installFlags |= 0x20;
        } else {
            installFlags &= 0xFFFFFFDF;
            installFlags &= 0xFFFFFFBF;
        }
        UserHandle user = (installFlags & 0x40) != 0 ? UserHandle.ALL : new UserHandle(userId);
        if ((installFlags & 0x100) != 0 && this.mContext.checkCallingOrSelfPermission("android.permission.INSTALL_GRANT_RUNTIME_PERMISSIONS") == -1) {
            throw new SecurityException("You need the android.permission.INSTALL_GRANT_RUNTIME_PERMISSIONS permission to use the PackageManager.INSTALL_GRANT_RUNTIME_PERMISSIONS flag");
        }
        verificationParams.setInstallerUid(callingUid);
        File originFile = new File(originPath);
        OriginInfo origin = OriginInfo.fromUntrustedFile(originFile);
        Message msg = this.mHandler.obtainMessage(5);
        msg.obj = new InstallParams(origin, null, observer, installFlags, installerPackageName, null, verificationParams, user, packageAbiOverride, null);
        this.mHandler.sendMessage(msg);
    }

    void installStage(String packageName, File stagedDir, String stagedCid, IPackageInstallObserver2 observer, PackageInstaller.SessionParams params, String installerPackageName, int installerUid, UserHandle user) {
        VerificationParams verifParams = new VerificationParams(null, params.originatingUri, params.referrerUri, installerUid, null);
        verifParams.setInstallerUid(installerUid);
        OriginInfo origin = stagedDir != null ? OriginInfo.fromStagedFile(stagedDir) : OriginInfo.fromStagedContainer(stagedCid);
        Message msg = this.mHandler.obtainMessage(5);
        msg.obj = new InstallParams(origin, null, observer, params.installFlags, installerPackageName, params.volumeUuid, verifParams, user, params.abiOverride, params.grantedRuntimePermissions);
        this.mHandler.sendMessage(msg);
    }

    private void sendPackageAddedForUser(String packageName, PackageSetting pkgSetting, int userId) {
        Bundle extras = new Bundle(1);
        extras.putInt("android.intent.extra.UID", UserHandle.getUid(userId, pkgSetting.appId));
        this.sendPackageBroadcast("android.intent.action.PACKAGE_ADDED", packageName, extras, null, null, new int[]{userId});
        try {
            boolean isSystem;
            IActivityManager am = ActivityManagerNative.getDefault();
            boolean bl = isSystem = PackageManagerService.isSystemApp(pkgSetting) || PackageManagerService.isUpdatedSystemApp(pkgSetting);
            if (isSystem && am.isUserRunning(userId, false)) {
                Intent bcIntent = new Intent("android.intent.action.BOOT_COMPLETED").addFlags(32).setPackage(packageName);
                am.broadcastIntent(null, bcIntent, null, null, 0, null, null, null, -1, null, false, false, userId);
            }
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Unable to bootstrap installed package", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setApplicationHiddenSettingAsUser(String packageName, boolean hidden, int userId) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_USERS", null);
        int uid = Binder.getCallingUid();
        this.enforceCrossUserPermission(uid, userId, true, true, "setApplicationHiddenSetting for user " + userId);
        if (hidden && this.isPackageDeviceAdmin(packageName, userId)) {
            Slog.w(TAG, "Not hiding package " + packageName + ": has active device admin");
            return false;
        }
        long callingId = Binder.clearCallingIdentity();
        try {
            PackageSetting pkgSetting;
            boolean sendAdded = false;
            boolean sendRemoved = false;
            ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
            synchronized (arrayMap) {
                block15: {
                    pkgSetting = this.mSettings.mPackages.get(packageName);
                    if (pkgSetting != null) break block15;
                    boolean bl = false;
                    return bl;
                }
                if (pkgSetting.getHidden(userId) != hidden) {
                    pkgSetting.setHidden(hidden, userId);
                    this.mSettings.writePackageRestrictionsLPr(userId);
                    if (hidden) {
                        sendRemoved = true;
                    } else {
                        sendAdded = true;
                    }
                }
            }
            if (sendAdded) {
                this.sendPackageAddedForUser(packageName, pkgSetting, userId);
                boolean bl = true;
                return bl;
            }
            if (sendRemoved) {
                this.killApplication(packageName, UserHandle.getUid(userId, pkgSetting.appId), "hiding pkg");
                this.sendApplicationHiddenForUser(packageName, pkgSetting, userId);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            Binder.restoreCallingIdentity(callingId);
        }
        return false;
    }

    private void sendApplicationHiddenForUser(String packageName, PackageSetting pkgSetting, int userId) {
        PackageRemovedInfo info = new PackageRemovedInfo();
        info.removedPackage = packageName;
        info.removedUsers = new int[]{userId};
        info.uid = UserHandle.getUid(userId, pkgSetting.appId);
        info.sendBroadcast(false, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean getApplicationHiddenSettingAsUser(String packageName, int userId) {
        PackageSetting pkgSetting;
        long callingId;
        block6: {
            boolean bl;
            this.mContext.enforceCallingOrSelfPermission("android.permission.MANAGE_USERS", null);
            this.enforceCrossUserPermission(Binder.getCallingUid(), userId, true, false, "getApplicationHidden for user " + userId);
            callingId = Binder.clearCallingIdentity();
            try {
                ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
                // MONITORENTER : arrayMap
                pkgSetting = this.mSettings.mPackages.get(packageName);
                if (pkgSetting != null) break block6;
                bl = true;
                // MONITOREXIT : arrayMap
            }
            catch (Throwable throwable) {
                Binder.restoreCallingIdentity(callingId);
                throw throwable;
            }
            Binder.restoreCallingIdentity(callingId);
            return bl;
        }
        boolean bl = pkgSetting.getHidden(userId);
        // MONITOREXIT : arrayMap
        Binder.restoreCallingIdentity(callingId);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int installExistingPackageAsUser(String packageName, int userId) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.INSTALL_PACKAGES", null);
        int uid = Binder.getCallingUid();
        this.enforceCrossUserPermission(uid, userId, true, true, "installExistingPackage for user " + userId);
        if (this.isUserRestricted(userId, "no_install_apps")) {
            return -111;
        }
        long callingId = Binder.clearCallingIdentity();
        try {
            PackageSetting pkgSetting;
            boolean sendAdded = false;
            ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
            synchronized (arrayMap) {
                block11: {
                    pkgSetting = this.mSettings.mPackages.get(packageName);
                    if (pkgSetting != null) break block11;
                    int n = -3;
                    return n;
                }
                if (!pkgSetting.getInstalled(userId)) {
                    pkgSetting.setInstalled(true, userId);
                    pkgSetting.setHidden(false, userId);
                    this.mSettings.writePackageRestrictionsLPr(userId);
                    sendAdded = true;
                }
            }
            if (sendAdded) {
                this.sendPackageAddedForUser(packageName, pkgSetting, userId);
            }
        }
        finally {
            Binder.restoreCallingIdentity(callingId);
        }
        return 1;
    }

    boolean isUserRestricted(int userId, String restrictionKey) {
        Bundle restrictions = sUserManager.getUserRestrictions(userId);
        if (restrictions.getBoolean(restrictionKey, false)) {
            Log.w(TAG, "User is restricted: " + restrictionKey);
            return true;
        }
        return false;
    }

    @Override
    public void verifyPendingInstall(int id2, int verificationCode) throws RemoteException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.PACKAGE_VERIFICATION_AGENT", "Only package verification agents can verify applications");
        Message msg = this.mHandler.obtainMessage(15);
        PackageVerificationResponse response = new PackageVerificationResponse(verificationCode, Binder.getCallingUid());
        msg.arg1 = id2;
        msg.obj = response;
        this.mHandler.sendMessage(msg);
    }

    @Override
    public void extendVerificationTimeout(int id2, int verificationCodeAtTimeout, long millisecondsToDelay) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.PACKAGE_VERIFICATION_AGENT", "Only package verification agents can extend verification timeouts");
        PackageVerificationState state = this.mPendingVerification.get(id2);
        PackageVerificationResponse response = new PackageVerificationResponse(verificationCodeAtTimeout, Binder.getCallingUid());
        if (millisecondsToDelay > 3600000L) {
            millisecondsToDelay = 3600000L;
        }
        if (millisecondsToDelay < 0L) {
            millisecondsToDelay = 0L;
        }
        if (verificationCodeAtTimeout != 1 && verificationCodeAtTimeout != -1) {
            verificationCodeAtTimeout = -1;
        }
        if (state != null && !state.timeoutExtended()) {
            state.extendTimeout();
            Message msg = this.mHandler.obtainMessage(15);
            msg.arg1 = id2;
            msg.obj = response;
            this.mHandler.sendMessageDelayed(msg, millisecondsToDelay);
        }
    }

    private void broadcastPackageVerified(int verificationId, Uri packageUri, int verificationCode, UserHandle user) {
        Intent intent = new Intent("android.intent.action.PACKAGE_VERIFIED");
        intent.setDataAndType(packageUri, PACKAGE_MIME_TYPE);
        intent.addFlags(1);
        intent.putExtra("android.content.pm.extra.VERIFICATION_ID", verificationId);
        intent.putExtra("android.content.pm.extra.VERIFICATION_RESULT", verificationCode);
        this.mContext.sendBroadcastAsUser(intent, user, "android.permission.PACKAGE_VERIFICATION_AGENT");
    }

    private ComponentName matchComponentForVerifier(String packageName, List<ResolveInfo> receivers) {
        ActivityInfo targetReceiver = null;
        int NR = receivers.size();
        for (int i = 0; i < NR; ++i) {
            ResolveInfo info = receivers.get(i);
            if (info.activityInfo == null || !packageName.equals(info.activityInfo.packageName)) continue;
            targetReceiver = info.activityInfo;
            break;
        }
        if (targetReceiver == null) {
            return null;
        }
        return new ComponentName(targetReceiver.packageName, targetReceiver.name);
    }

    private List<ComponentName> matchVerifiers(PackageInfoLite pkgInfo, List<ResolveInfo> receivers, PackageVerificationState verificationState) {
        if (pkgInfo.verifiers.length == 0) {
            return null;
        }
        int N = pkgInfo.verifiers.length;
        ArrayList<ComponentName> sufficientVerifiers = new ArrayList<ComponentName>(N + 1);
        for (int i = 0; i < N; ++i) {
            int verifierUid;
            VerifierInfo verifierInfo = pkgInfo.verifiers[i];
            ComponentName comp = this.matchComponentForVerifier(verifierInfo.packageName, receivers);
            if (comp == null || (verifierUid = this.getUidForVerifier(verifierInfo)) == -1) continue;
            sufficientVerifiers.add(comp);
            verificationState.addSufficientVerifier(verifierUid);
        }
        return sufficientVerifiers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getUidForVerifier(VerifierInfo verifierInfo) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            byte[] expectedPublicKey;
            PackageParser.Package pkg = this.mPackages.get(verifierInfo.packageName);
            if (pkg == null) {
                return -1;
            }
            if (pkg.mSignatures.length != 1) {
                Slog.i(TAG, "Verifier package " + verifierInfo.packageName + " has more than one signature; ignoring");
                return -1;
            }
            try {
                Signature verifierSig = pkg.mSignatures[0];
                PublicKey publicKey = verifierSig.getPublicKey();
                expectedPublicKey = publicKey.getEncoded();
            }
            catch (CertificateException e) {
                return -1;
            }
            byte[] actualPublicKey = verifierInfo.publicKey.getEncoded();
            if (!Arrays.equals(actualPublicKey, expectedPublicKey)) {
                Slog.i(TAG, "Verifier package " + verifierInfo.packageName + " does not have the expected public key; ignoring");
                return -1;
            }
            return pkg.applicationInfo.uid;
        }
    }

    @Override
    public void finishPackageInstall(int token) {
        PackageManagerService.enforceSystemOrRoot("Only the system is allowed to finish installs");
        Message msg = this.mHandler.obtainMessage(9, token, 0);
        this.mHandler.sendMessage(msg);
    }

    private long getVerificationTimeout() {
        return Settings.Global.getLong(this.mContext.getContentResolver(), "verifier_timeout", 10000L);
    }

    private int getDefaultVerificationResponse() {
        return Settings.Global.getInt(this.mContext.getContentResolver(), "verifier_default_response", 1);
    }

    private boolean isVerificationEnabled(int userId, int installFlags) {
        boolean ensureVerifyAppsEnabled = this.isUserRestricted(userId, "ensure_verify_apps");
        if ((installFlags & 0x20) != 0) {
            if (ActivityManager.isRunningInTestHarness()) {
                return false;
            }
            if (ensureVerifyAppsEnabled) {
                return true;
            }
            if (Settings.Global.getInt(this.mContext.getContentResolver(), "verifier_verify_adb_installs", 1) == 0) {
                return false;
            }
        }
        if (ensureVerifyAppsEnabled) {
            return true;
        }
        return Settings.Global.getInt(this.mContext.getContentResolver(), "package_verifier_enable", 1) == 1;
    }

    @Override
    public void verifyIntentFilter(int id2, int verificationCode, List<String> failedDomains) throws RemoteException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.INTENT_FILTER_VERIFICATION_AGENT", "Only intentfilter verification agents can verify applications");
        Message msg = this.mHandler.obtainMessage(18);
        IntentFilterVerificationResponse response = new IntentFilterVerificationResponse(Binder.getCallingUid(), verificationCode, failedDomains);
        msg.arg1 = id2;
        msg.obj = response;
        this.mHandler.sendMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getIntentVerificationStatus(String packageName, int userId) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            return this.mSettings.getIntentFilterVerificationStatusLPr(packageName, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateIntentVerificationStatus(String packageName, int status, int userId) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.SET_PREFERRED_APPLICATIONS", null);
        boolean result = false;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            result = this.mSettings.updateIntentFilterVerificationStatusLPw(packageName, status, userId);
        }
        if (result) {
            this.scheduleWritePackageRestrictionsLocked(userId);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IntentFilterVerificationInfo> getIntentFilterVerifications(String packageName) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            return this.mSettings.getIntentFilterVerificationsLPr(packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IntentFilter> getAllIntentFilters(String packageName) {
        if (TextUtils.isEmpty(packageName)) {
            return Collections.emptyList();
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageParser.Package pkg = this.mPackages.get(packageName);
            if (pkg == null || pkg.activities == null) {
                return Collections.emptyList();
            }
            int count = pkg.activities.size();
            ArrayList<IntentFilter> result = new ArrayList<IntentFilter>();
            for (int n = 0; n < count; ++n) {
                PackageParser.Activity activity = pkg.activities.get(n);
                if (activity.intents == null && activity.intents.size() <= 0) continue;
                result.addAll(activity.intents);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setDefaultBrowserPackageName(String packageName, int userId) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.SET_PREFERRED_APPLICATIONS", null);
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            boolean result = this.mSettings.setDefaultBrowserPackageNameLPw(packageName, userId);
            if (packageName != null) {
                result |= this.updateIntentVerificationStatus(packageName, 2, userId);
                this.mDefaultPermissionPolicy.grantDefaultPermissionsToDefaultBrowserLPr(packageName, userId);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDefaultBrowserPackageName(int userId) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            return this.mSettings.getDefaultBrowserPackageNameLPw(userId);
        }
    }

    private int getUnknownSourcesSettings() {
        return Settings.Global.getInt(this.mContext.getContentResolver(), "install_non_market_apps", -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setInstallerPackageName(String targetPackage, String installerPackageName) {
        int uid = Binder.getCallingUid();
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageSetting setting;
            Signature[] callerSignature;
            Object obj;
            PackageSetting installerPackageSetting;
            PackageSetting targetPackageSetting = this.mSettings.mPackages.get(targetPackage);
            if (targetPackageSetting == null) {
                throw new IllegalArgumentException("Unknown target package: " + targetPackage);
            }
            if (installerPackageName != null) {
                installerPackageSetting = this.mSettings.mPackages.get(installerPackageName);
                if (installerPackageSetting == null) {
                    throw new IllegalArgumentException("Unknown installer package: " + installerPackageName);
                }
            } else {
                installerPackageSetting = null;
            }
            if ((obj = this.mSettings.getUserIdLPr(uid)) == null) throw new SecurityException("Unknown calling uid " + uid);
            if (obj instanceof SharedUserSetting) {
                callerSignature = ((SharedUserSetting)obj).signatures.mSignatures;
            } else {
                if (!(obj instanceof PackageSetting)) throw new SecurityException("Bad object " + obj + " for uid " + uid);
                callerSignature = ((PackageSetting)obj).signatures.mSignatures;
            }
            if (installerPackageSetting != null && PackageManagerService.compareSignatures(callerSignature, installerPackageSetting.signatures.mSignatures) != 0) {
                throw new SecurityException("Caller does not have same cert as new installer package " + installerPackageName);
            }
            if (targetPackageSetting.installerPackageName != null && (setting = this.mSettings.mPackages.get(targetPackageSetting.installerPackageName)) != null && PackageManagerService.compareSignatures(callerSignature, setting.signatures.mSignatures) != 0) {
                throw new SecurityException("Caller does not have same cert as old installer package " + targetPackageSetting.installerPackageName);
            }
            targetPackageSetting.installerPackageName = installerPackageName;
            this.scheduleWriteSettingsLocked();
            return;
        }
    }

    private void processPendingInstall(final InstallArgs args, final int currentStatus) {
        this.mHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int token;
                boolean doRestore;
                block13: {
                    PackageManagerService.this.mHandler.removeCallbacks(this);
                    PackageInstalledInfo res = new PackageInstalledInfo();
                    res.returnCode = currentStatus;
                    res.uid = -1;
                    res.pkg = null;
                    res.removedInfo = new PackageRemovedInfo();
                    if (res.returnCode == 1) {
                        args.doPreInstall(res.returnCode);
                        Object object = PackageManagerService.this.mInstallLock;
                        synchronized (object) {
                            PackageManagerService.this.installPackageLI(args, res);
                        }
                        args.doPostInstall(res.returnCode, res.uid);
                    }
                    boolean update = res.removedInfo.removedPackage != null;
                    int flags = res.pkg == null ? 0 : res.pkg.applicationInfo.flags;
                    boolean bl = doRestore = !update && (flags & 0x8000) != 0;
                    if (PackageManagerService.this.mNextInstallToken < 0) {
                        PackageManagerService.this.mNextInstallToken = 1;
                    }
                    token = PackageManagerService.this.mNextInstallToken++;
                    PostInstallData data = new PostInstallData(args, res);
                    PackageManagerService.this.mRunningInstalls.put(token, data);
                    if (res.returnCode == 1 && doRestore) {
                        IBackupManager bm = IBackupManager.Stub.asInterface(ServiceManager.getService("backup"));
                        if (bm != null) {
                            try {
                                if (bm.isBackupServiceActive(0)) {
                                    bm.restoreAtInstall(res.pkg.applicationInfo.packageName, token);
                                    break block13;
                                }
                                doRestore = false;
                            }
                            catch (RemoteException e) {
                            }
                            catch (Exception e) {
                                Slog.e(PackageManagerService.TAG, "Exception trying to enqueue restore", e);
                                doRestore = false;
                            }
                        } else {
                            Slog.e(PackageManagerService.TAG, "Backup Manager not found!");
                            doRestore = false;
                        }
                    }
                }
                if (!doRestore) {
                    Message msg = PackageManagerService.this.mHandler.obtainMessage(9, token, 0);
                    PackageManagerService.this.mHandler.sendMessage(msg);
                }
            }
        });
    }

    private static long calculateDirectorySize(IMediaContainerService mcs, File[] paths) throws RemoteException {
        long result = 0L;
        for (File path : paths) {
            result += mcs.calculateDirectorySize(path.getAbsolutePath());
        }
        return result;
    }

    private static void clearDirectory(IMediaContainerService mcs, File[] paths) {
        for (File path : paths) {
            try {
                mcs.clearDirectory(path.getAbsolutePath());
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
    }

    private static boolean installOnExternalAsec(int installFlags) {
        if ((installFlags & 0x10) != 0) {
            return false;
        }
        return (installFlags & 8) != 0;
    }

    private static boolean installForwardLocked(int installFlags) {
        return (installFlags & 1) != 0;
    }

    private InstallArgs createInstallArgs(InstallParams params) {
        if (params.move != null) {
            return new MoveInstallArgs(params);
        }
        if (PackageManagerService.installOnExternalAsec(params.installFlags) || params.isForwardLocked()) {
            return new AsecInstallArgs(params);
        }
        return new FileInstallArgs(params);
    }

    private InstallArgs createInstallArgsForExisting(int installFlags, String codePath, String resourcePath, String[] instructionSets) {
        boolean isInAsec = PackageManagerService.installOnExternalAsec(installFlags) ? true : PackageManagerService.installForwardLocked(installFlags) && !codePath.startsWith(this.mDrmAppPrivateInstallDir.getAbsolutePath());
        if (isInAsec) {
            return new AsecInstallArgs(codePath, instructionSets, PackageManagerService.installOnExternalAsec(installFlags), PackageManagerService.installForwardLocked(installFlags));
        }
        return new FileInstallArgs(codePath, resourcePath, instructionSets);
    }

    private void removeDexFiles(List<String> allCodePaths, String[] instructionSets) {
        if (!allCodePaths.isEmpty()) {
            if (instructionSets == null) {
                throw new IllegalStateException("instructionSet == null");
            }
            String[] dexCodeInstructionSets = InstructionSets.getDexCodeInstructionSets(instructionSets);
            for (String codePath : allCodePaths) {
                for (String dexCodeInstructionSet : dexCodeInstructionSets) {
                    int retCode = this.mInstaller.rmdex(codePath, dexCodeInstructionSet);
                    if (retCode >= 0) continue;
                    Slog.w(TAG, "Couldn't remove dex file for package:  at location " + codePath + ", retcode=" + retCode);
                }
            }
        }
    }

    private boolean isAsecExternal(String cid) {
        String asecPath = PackageHelper.getSdFilesystem(cid);
        return !asecPath.startsWith(this.mAsecInternalPath);
    }

    private static void maybeThrowExceptionForMultiArchCopy(String message, int copyRet) throws PackageManagerException {
        if (copyRet < 0 && copyRet != -114 && copyRet != -113) {
            throw new PackageManagerException(copyRet, message);
        }
    }

    static String cidFromCodePath(String fullCodePath) {
        int eidx = fullCodePath.lastIndexOf("/");
        String subStr1 = fullCodePath.substring(0, eidx);
        int sidx = subStr1.lastIndexOf("/");
        return subStr1.substring(sidx + 1, eidx);
    }

    static String getAsecPackageName(String packageCid) {
        int idx = packageCid.lastIndexOf(INSTALL_PACKAGE_SUFFIX);
        if (idx == -1) {
            return packageCid;
        }
        return packageCid.substring(0, idx);
    }

    private static String getNextCodePath(String oldCodePath, String prefix, String suffix) {
        String idxStr = "";
        int idx = 1;
        if (oldCodePath != null) {
            int sidx;
            String subStr = oldCodePath;
            if (suffix != null && subStr.endsWith(suffix)) {
                subStr = subStr.substring(0, subStr.length() - suffix.length());
            }
            if ((sidx = subStr.lastIndexOf(prefix)) != -1 && (subStr = subStr.substring(sidx + prefix.length())) != null) {
                if (subStr.startsWith(INSTALL_PACKAGE_SUFFIX)) {
                    subStr = subStr.substring(INSTALL_PACKAGE_SUFFIX.length());
                }
                try {
                    idx = Integer.parseInt(subStr);
                    idx = idx <= 1 ? ++idx : --idx;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        idxStr = INSTALL_PACKAGE_SUFFIX + Integer.toString(idx);
        return prefix + idxStr;
    }

    private File getNextCodePath(File targetDir, String packageName) {
        File result;
        int suffix = 1;
        do {
            result = new File(targetDir, packageName + INSTALL_PACKAGE_SUFFIX + suffix);
            ++suffix;
        } while (result.exists());
        return result;
    }

    static String deriveCodePathName(String codePath) {
        if (codePath == null) {
            return null;
        }
        File codeFile = new File(codePath);
        String name = codeFile.getName();
        if (codeFile.isDirectory()) {
            return name;
        }
        if (name.endsWith(".apk") || name.endsWith(".tmp")) {
            int lastDot = name.lastIndexOf(46);
            return name.substring(0, lastDot);
        }
        Slog.w(TAG, "Odd, " + codePath + " doesn't look like an APK");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installNewPackageLI(PackageParser.Package pkg, int parseFlags, int scanFlags, UserHandle user, String installerPackageName, String volumeUuid, PackageInstalledInfo res) {
        String pkgName = pkg.packageName;
        boolean dataDirExists = Environment.getDataUserPackageDirectory(volumeUuid, 0, pkgName).exists();
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            if (this.mSettings.mRenamedPackages.containsKey(pkgName)) {
                res.setError(-1, "Attempt to re-install " + pkgName + " without first uninstalling package running as " + this.mSettings.mRenamedPackages.get(pkgName));
                return;
            }
            if (this.mPackages.containsKey(pkgName)) {
                res.setError(-1, "Attempt to re-install " + pkgName + " without first uninstalling.");
                return;
            }
        }
        try {
            PackageParser.Package newPackage = this.scanPackageLI(pkg, parseFlags, scanFlags, System.currentTimeMillis(), user);
            this.updateSettingsLI(newPackage, installerPackageName, volumeUuid, null, null, res, user);
            if (res.returnCode != 1) {
                this.deletePackageLI(pkgName, UserHandle.ALL, false, null, null, dataDirExists ? 1 : 0, res.removedInfo, true);
            }
        }
        catch (PackageManagerException e) {
            res.setError("Package couldn't be installed in " + pkg.codePath, e);
        }
    }

    private boolean shouldCheckUpgradeKeySetLP(PackageSetting oldPs, int scanFlags) {
        if (oldPs == null || (scanFlags & 0x4000) != 0 || oldPs.sharedUser != null || !oldPs.keySetData.isUsingUpgradeKeySets()) {
            return false;
        }
        KeySetManagerService ksms = this.mSettings.mKeySetManagerService;
        long[] upgradeKeySets = oldPs.keySetData.getUpgradeKeySets();
        for (int i = 0; i < upgradeKeySets.length; ++i) {
            if (ksms.isIdValidKeySetId(upgradeKeySets[i])) continue;
            Slog.wtf(TAG, "Package " + (oldPs.name != null ? oldPs.name : "<null>") + " contains upgrade-key-set reference to unknown key-set: " + upgradeKeySets[i] + " reverting to signatures check.");
            return false;
        }
        return true;
    }

    private boolean checkUpgradeKeySetLP(PackageSetting oldPS, PackageParser.Package newPkg) {
        long[] upgradeKeySets = oldPS.keySetData.getUpgradeKeySets();
        KeySetManagerService ksms = this.mSettings.mKeySetManagerService;
        for (int i = 0; i < upgradeKeySets.length; ++i) {
            ArraySet<PublicKey> upgradeSet = ksms.getPublicKeysFromKeySetLPr(upgradeKeySets[i]);
            if (upgradeSet == null || !newPkg.mSigningKeys.containsAll(upgradeSet)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replacePackageLI(PackageParser.Package pkg, int parseFlags, int scanFlags, UserHandle user, String installerPackageName, String volumeUuid, PackageInstalledInfo res) {
        boolean[] perUserInstalled;
        int[] allUsers;
        PackageParser.Package oldPackage;
        String pkgName = pkg.packageName;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            oldPackage = this.mPackages.get(pkgName);
            PackageSetting ps = this.mSettings.mPackages.get(pkgName);
            if (this.shouldCheckUpgradeKeySetLP(ps, scanFlags)) {
                if (!this.checkUpgradeKeySetLP(ps, pkg)) {
                    res.setError(-7, "New package not signed by keys specified by upgrade-keysets: " + pkgName);
                    return;
                }
            } else if (PackageManagerService.compareSignatures(oldPackage.mSignatures, pkg.mSignatures) != 0) {
                res.setError(-7, "New package has a different signature: " + pkgName);
                return;
            }
            allUsers = sUserManager.getUserIds();
            perUserInstalled = new boolean[allUsers.length];
            for (int i = 0; i < allUsers.length; ++i) {
                perUserInstalled[i] = ps != null ? ps.getInstalled(allUsers[i]) : false;
            }
        }
        boolean sysPkg = PackageManagerService.isSystemApp(oldPackage);
        if (sysPkg) {
            this.replaceSystemPackageLI(oldPackage, pkg, parseFlags, scanFlags, user, allUsers, perUserInstalled, installerPackageName, volumeUuid, res);
        } else {
            this.replaceNonSystemPackageLI(oldPackage, pkg, parseFlags, scanFlags, user, allUsers, perUserInstalled, installerPackageName, volumeUuid, res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceNonSystemPackageLI(PackageParser.Package deletedPackage, PackageParser.Package pkg, int parseFlags, int scanFlags, UserHandle user, int[] allUsers, boolean[] perUserInstalled, String installerPackageName, String volumeUuid, PackageInstalledInfo res) {
        String pkgName = deletedPackage.packageName;
        boolean deletedPkg = true;
        boolean updatedSettings = false;
        long origUpdateTime = pkg.mExtras != null ? ((PackageSetting)pkg.mExtras).lastUpdateTime : 0L;
        if (!this.deletePackageLI(pkgName, null, true, null, null, 1, res.removedInfo, true)) {
            res.setError(-10, "replaceNonSystemPackageLI");
            deletedPkg = false;
        } else {
            if (deletedPackage.isForwardLocked() || PackageManagerService.isExternal(deletedPackage)) {
                int[] uidArray = new int[]{deletedPackage.applicationInfo.uid};
                ArrayList<String> pkgList = new ArrayList<String>(1);
                pkgList.add(deletedPackage.applicationInfo.packageName);
                this.sendResourcesChangedBroadcast(false, true, pkgList, uidArray, null);
            }
            this.deleteCodeCacheDirsLI(pkg.volumeUuid, pkgName);
            try {
                PackageParser.Package newPackage = this.scanPackageLI(pkg, parseFlags, scanFlags | 0x40, System.currentTimeMillis(), user);
                this.updateSettingsLI(newPackage, installerPackageName, volumeUuid, allUsers, perUserInstalled, res, user);
                updatedSettings = true;
            }
            catch (PackageManagerException e) {
                res.setError("Package couldn't be installed in " + pkg.codePath, e);
            }
        }
        if (res.returnCode != 1) {
            if (updatedSettings) {
                this.deletePackageLI(pkgName, null, true, allUsers, perUserInstalled, 1, res.removedInfo, true);
            }
            if (deletedPkg) {
                File restoreFile = new File(deletedPackage.codePath);
                boolean oldExternal = PackageManagerService.isExternal(deletedPackage);
                int oldParseFlags = this.mDefParseFlags | 2 | (deletedPackage.isForwardLocked() ? 16 : 0) | (oldExternal ? 32 : 0);
                int oldScanFlags = 72;
                try {
                    this.scanPackageLI(restoreFile, oldParseFlags, oldScanFlags, origUpdateTime, null);
                }
                catch (PackageManagerException e) {
                    Slog.e(TAG, "Failed to restore package : " + pkgName + " after failed upgrade: " + e.getMessage());
                    return;
                }
                ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
                synchronized (arrayMap) {
                    this.updatePermissionsLPw(deletedPackage.packageName, deletedPackage, 1);
                    this.mSettings.writeLPr();
                }
                Slog.i(TAG, "Successfully restored package : " + pkgName + " after failed upgrade");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceSystemPackageLI(PackageParser.Package deletedPackage, PackageParser.Package pkg, int parseFlags, int scanFlags, UserHandle user, int[] allUsers, boolean[] perUserInstalled, String installerPackageName, String volumeUuid, PackageInstalledInfo res) {
        PackageSetting oldPkgSetting;
        PackageParser.Package oldPkg;
        String packageName;
        boolean disabledSystem = false;
        boolean updatedSettings = false;
        parseFlags |= 1;
        if ((deletedPackage.applicationInfo.privateFlags & 8) != 0) {
            parseFlags |= 0x80;
        }
        if ((packageName = deletedPackage.packageName) == null) {
            res.setError(-10, "Attempt to delete null packageName.");
            return;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            oldPkg = this.mPackages.get(packageName);
            oldPkgSetting = this.mSettings.mPackages.get(packageName);
            if (oldPkg == null || oldPkg.applicationInfo == null || oldPkgSetting == null) {
                res.setError(-10, "Couldn't find package:" + packageName + " information");
                return;
            }
        }
        this.killApplication(packageName, oldPkg.applicationInfo.uid, "replace sys pkg");
        res.removedInfo.uid = oldPkg.applicationInfo.uid;
        res.removedInfo.removedPackage = packageName;
        this.removePackageLI(oldPkgSetting, true);
        arrayMap = this.mPackages;
        synchronized (arrayMap) {
            disabledSystem = this.mSettings.disableSystemPackageLPw(packageName);
            res.removedInfo.args = !disabledSystem && deletedPackage != null ? this.createInstallArgsForExisting(0, deletedPackage.applicationInfo.getCodePath(), deletedPackage.applicationInfo.getResourcePath(), InstructionSets.getAppDexInstructionSets(deletedPackage.applicationInfo)) : null;
        }
        this.deleteCodeCacheDirsLI(pkg.volumeUuid, packageName);
        res.returnCode = 1;
        pkg.applicationInfo.flags |= 0x80;
        PackageParser.Package newPackage = null;
        try {
            newPackage = this.scanPackageLI(pkg, parseFlags, scanFlags, 0L, user);
            if (newPackage.mExtras != null) {
                PackageSetting newPkgSetting = (PackageSetting)newPackage.mExtras;
                newPkgSetting.firstInstallTime = oldPkgSetting.firstInstallTime;
                newPkgSetting.lastUpdateTime = System.currentTimeMillis();
                if (oldPkgSetting.sharedUser != newPkgSetting.sharedUser) {
                    res.setError(-8, "Forbidding shared user change from " + oldPkgSetting.sharedUser + " to " + newPkgSetting.sharedUser);
                    updatedSettings = true;
                }
            }
            if (res.returnCode == 1) {
                this.updateSettingsLI(newPackage, installerPackageName, volumeUuid, allUsers, perUserInstalled, res, user);
                updatedSettings = true;
            }
        }
        catch (PackageManagerException e) {
            res.setError("Package couldn't be installed in " + pkg.codePath, e);
        }
        if (res.returnCode != 1) {
            if (newPackage != null) {
                this.removeInstalledPackageLI(newPackage, true);
            }
            try {
                this.scanPackageLI(oldPkg, parseFlags, 8, 0L, user);
            }
            catch (PackageManagerException e) {
                Slog.e(TAG, "Failed to restore original package: " + e.getMessage());
            }
            ArrayMap<String, PackageParser.Package> arrayMap2 = this.mPackages;
            synchronized (arrayMap2) {
                if (disabledSystem) {
                    this.mSettings.enableSystemPackageLPw(packageName);
                }
                if (updatedSettings) {
                    this.mSettings.setInstallerPackageName(packageName, oldPkgSetting.installerPackageName);
                }
                this.mSettings.writeLPr();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSettingsLI(PackageParser.Package newPackage, String installerPackageName, String volumeUuid, int[] allUsers, boolean[] perUserInstalled, PackageInstalledInfo res, UserHandle user) {
        String pkgName = newPackage.packageName;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            this.mSettings.setInstallStatus(pkgName, 0);
            this.mSettings.writeLPr();
        }
        arrayMap = this.mPackages;
        synchronized (arrayMap) {
            this.updatePermissionsLPw(newPackage.packageName, newPackage, 2 | (newPackage.permissions.size() > 0 ? 1 : 0));
            PackageSetting ps = this.mSettings.mPackages.get(pkgName);
            if (ps != null) {
                int userId;
                if (PackageManagerService.isSystemApp(newPackage)) {
                    if (res.origUsers != null) {
                        for (int userHandle : res.origUsers) {
                            ps.setEnabled(0, userHandle, installerPackageName);
                        }
                    }
                    if (allUsers != null && perUserInstalled != null) {
                        for (int i = 0; i < allUsers.length; ++i) {
                            ps.setInstalled(perUserInstalled[i], allUsers[i]);
                        }
                    }
                }
                if ((userId = user.getIdentifier()) != -1) {
                    ps.setInstalled(true, userId);
                    ps.setEnabled(0, userId, installerPackageName);
                }
            }
            res.name = pkgName;
            res.uid = newPackage.applicationInfo.uid;
            res.pkg = newPackage;
            this.mSettings.setInstallStatus(pkgName, 1);
            this.mSettings.setInstallerPackageName(pkgName, installerPackageName);
            res.returnCode = 1;
            this.mSettings.writeLPr();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installPackageLI(InstallArgs args, PackageInstalledInfo res) {
        PackageSetting ps;
        PackageParser.Package pkg;
        int installFlags = args.installFlags;
        String installerPackageName = args.installerPackageName;
        String volumeUuid = args.volumeUuid;
        File tmpPackageFile = new File(args.getCodePath());
        boolean forwardLocked = (installFlags & 1) != 0;
        boolean onExternal = (installFlags & 8) != 0 || args.volumeUuid != null;
        boolean replace = false;
        int scanFlags = 24;
        if (args.move != null) {
            scanFlags |= 0x4000;
        }
        res.returnCode = 1;
        int parseFlags = this.mDefParseFlags | 2 | (forwardLocked ? 16 : 0) | (onExternal ? 32 : 0);
        PackageParser pp = new PackageParser();
        pp.setSeparateProcesses(this.mSeparateProcesses);
        pp.setDisplayMetrics(this.mMetrics);
        try {
            pkg = pp.parsePackage(tmpPackageFile, parseFlags);
        }
        catch (PackageParser.PackageParserException e) {
            res.setError("Failed parse during installPackageLI", e);
            return;
        }
        pkg.cpuAbiOverride = args.abiOverride;
        String pkgName = res.name = pkg.packageName;
        if ((pkg.applicationInfo.flags & 0x100) != 0 && (installFlags & 4) == 0) {
            res.setError(-15, "installPackageLI");
            return;
        }
        try {
            pp.collectCertificates(pkg, parseFlags);
            pp.collectManifestDigest(pkg);
        }
        catch (PackageParser.PackageParserException e) {
            res.setError("Failed collect during installPackageLI", e);
            return;
        }
        if (args.manifestDigest != null && !args.manifestDigest.equals(pkg.manifestDigest)) {
            res.setError(-23, "Manifest digest changed");
            return;
        }
        pp = null;
        String oldCodePath = null;
        boolean systemApp = false;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            if ((installFlags & 2) != 0) {
                String oldName = this.mSettings.mRenamedPackages.get(pkgName);
                if (pkg.mOriginalPackages != null && pkg.mOriginalPackages.contains(oldName) && this.mPackages.containsKey(oldName)) {
                    pkg.setPackageName(oldName);
                    pkgName = pkg.packageName;
                    replace = true;
                } else if (this.mPackages.containsKey(pkgName)) {
                    replace = true;
                }
                if (replace) {
                    PackageParser.Package oldPackage = this.mPackages.get(pkgName);
                    int oldTargetSdk = oldPackage.applicationInfo.targetSdkVersion;
                    int newTargetSdk = pkg.applicationInfo.targetSdkVersion;
                    if (oldTargetSdk > 22 && newTargetSdk <= 22) {
                        res.setError(-26, "Package " + pkg.packageName + " new target SDK " + newTargetSdk + " doesn't support runtime permissions but the old" + " target SDK " + oldTargetSdk + " does.");
                        return;
                    }
                }
            }
            if ((ps = this.mSettings.mPackages.get(pkgName)) != null) {
                if (this.shouldCheckUpgradeKeySetLP(ps, scanFlags)) {
                    if (!this.checkUpgradeKeySetLP(ps, pkg)) {
                        res.setError(-7, "Package " + pkg.packageName + " upgrade keys do not match the " + "previously installed version");
                        return;
                    }
                } else {
                    try {
                        this.verifySignaturesLP(ps, pkg);
                    }
                    catch (PackageManagerException e) {
                        res.setError(e.error, e.getMessage());
                        return;
                    }
                }
                oldCodePath = this.mSettings.mPackages.get((Object)pkgName).codePathString;
                if (ps.pkg != null && ps.pkg.applicationInfo != null) {
                    systemApp = (ps.pkg.applicationInfo.flags & 1) != 0;
                }
                res.origUsers = ps.queryInstalledUsers(sUserManager.getUserIds(), true);
            }
            int N = pkg.permissions.size();
            for (int i = N - 1; i >= 0; --i) {
                boolean sigsOk;
                PackageParser.Permission perm = pkg.permissions.get(i);
                BasePermission bp = this.mSettings.mPermissions.get(perm.info.name);
                if (bp == null) continue;
                if (bp.sourcePackage.equals(pkg.packageName) && bp.packageSetting instanceof PackageSetting && this.shouldCheckUpgradeKeySetLP((PackageSetting)bp.packageSetting, scanFlags)) {
                    sigsOk = this.checkUpgradeKeySetLP((PackageSetting)bp.packageSetting, pkg);
                } else {
                    boolean bl = sigsOk = PackageManagerService.compareSignatures(bp.packageSetting.signatures.mSignatures, pkg.mSignatures) == 0;
                }
                if (sigsOk) continue;
                if (!bp.sourcePackage.equals("android")) {
                    res.setError(-112, "Package " + pkg.packageName + " attempting to redeclare permission " + perm.info.name + " already owned by " + bp.sourcePackage);
                    res.origPermission = perm.info.name;
                    res.origPackage = bp.sourcePackage;
                    return;
                }
                Slog.w(TAG, "Package " + pkg.packageName + " attempting to redeclare system permission " + perm.info.name + "; ignoring new declaration");
                pkg.permissions.remove(i);
            }
        }
        if (systemApp && onExternal) {
            res.setError(-19, "Cannot install updates to system apps on sdcard");
            return;
        }
        if (args.move != null) {
            scanFlags |= 2;
            scanFlags |= 0x2000;
            arrayMap = this.mPackages;
            synchronized (arrayMap) {
                ps = this.mSettings.mPackages.get(pkgName);
                if (ps == null) {
                    res.setError(-110, "Missing settings for moved package " + pkgName);
                }
                pkg.applicationInfo.primaryCpuAbi = ps.primaryCpuAbiString;
                pkg.applicationInfo.secondaryCpuAbi = ps.secondaryCpuAbiString;
            }
        }
        if (!forwardLocked && !pkg.applicationInfo.isExternalAsec()) {
            scanFlags |= 2;
            try {
                this.derivePackageAbi(pkg, new File(pkg.codePath), args.abiOverride, true);
            }
            catch (PackageManagerException pme) {
                Slog.e(TAG, "Error deriving application ABI", pme);
                res.setError(-110, "Error deriving application ABI");
                return;
            }
            int result = this.mPackageDexOptimizer.performDexOpt(pkg, null, false, false, false);
            if (result == -1) {
                res.setError(-11, "Dexopt failed for " + pkg.codePath);
                return;
            }
        }
        if (!args.doRename(res.returnCode, pkg, oldCodePath)) {
            res.setError(-4, "Failed rename");
            return;
        }
        this.startIntentFilterVerifications(args.user.getIdentifier(), replace, pkg);
        if (replace) {
            this.replacePackageLI(pkg, parseFlags, scanFlags | 0x800, args.user, installerPackageName, volumeUuid, res);
        } else {
            this.installNewPackageLI(pkg, parseFlags, scanFlags | 0x400, args.user, installerPackageName, volumeUuid, res);
        }
        ArrayMap<String, PackageParser.Package> arrayMap2 = this.mPackages;
        synchronized (arrayMap2) {
            ps = this.mSettings.mPackages.get(pkgName);
            if (ps != null) {
                res.newUsers = ps.queryInstalledUsers(sUserManager.getUserIds(), true);
            }
        }
    }

    private void startIntentFilterVerifications(int userId, boolean replacing, PackageParser.Package pkg) {
        if (this.mIntentFilterVerifierComponent == null) {
            Slog.w(TAG, "No IntentFilter verification will not be done as there is no IntentFilterVerifier available!");
            return;
        }
        int verifierUid = this.getPackageUid(this.mIntentFilterVerifierComponent.getPackageName(), userId == -1 ? 0 : userId);
        this.mHandler.removeMessages(17);
        Message msg = this.mHandler.obtainMessage(17);
        msg.obj = new IFVerificationParams(pkg, replacing, userId, verifierUid);
        this.mHandler.sendMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyIntentFiltersIfNeeded(int userId, int verifierUid, boolean replacing, PackageParser.Package pkg) {
        int size = pkg.activities.size();
        if (size == 0) {
            return;
        }
        boolean hasDomainURLs = PackageManagerService.hasDomainURLs(pkg);
        if (!hasDomainURLs) {
            return;
        }
        int count = 0;
        String packageName = pkg.packageName;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            IntentFilterVerificationInfo ivi;
            if (!replacing && (ivi = this.mSettings.getIntentFilterVerificationLPr(packageName)) != null) {
                return;
            }
            boolean needToVerify = false;
            block3: for (PackageParser.Activity a : pkg.activities) {
                for (PackageParser.ActivityIntentInfo filter : a.intents) {
                    if (!filter.needsVerification() || !this.needsNetworkVerificationLPr(filter)) continue;
                    needToVerify = true;
                    continue block3;
                }
            }
            if (needToVerify) {
                int verificationId = this.mIntentFilterVerificationToken++;
                for (PackageParser.Activity a : pkg.activities) {
                    for (PackageParser.ActivityIntentInfo filter : a.intents) {
                        if (!filter.handlesWebUris(true) || !this.needsNetworkVerificationLPr(filter)) continue;
                        this.mIntentFilterVerifier.addOneIntentFilterVerification(verifierUid, userId, verificationId, filter, packageName);
                        ++count;
                    }
                }
            }
        }
        if (count > 0) {
            this.mIntentFilterVerifier.startVerifications(userId);
        }
    }

    private boolean needsNetworkVerificationLPr(PackageParser.ActivityIntentInfo filter) {
        ComponentName cn = filter.activity.getComponentName();
        String packageName = cn.getPackageName();
        IntentFilterVerificationInfo ivi = this.mSettings.getIntentFilterVerificationLPr(packageName);
        if (ivi == null) {
            return true;
        }
        int status = ivi.getStatus();
        switch (status) {
            case 0: 
            case 1: {
                return true;
            }
        }
        return false;
    }

    private static boolean isMultiArch(PackageSetting ps) {
        return (ps.pkgFlags & Integer.MIN_VALUE) != 0;
    }

    private static boolean isMultiArch(ApplicationInfo info) {
        return (info.flags & Integer.MIN_VALUE) != 0;
    }

    private static boolean isExternal(PackageParser.Package pkg) {
        return (pkg.applicationInfo.flags & 0x40000) != 0;
    }

    private static boolean isExternal(PackageSetting ps) {
        return (ps.pkgFlags & 0x40000) != 0;
    }

    private static boolean isExternal(ApplicationInfo info) {
        return (info.flags & 0x40000) != 0;
    }

    private static boolean isSystemApp(PackageParser.Package pkg) {
        return (pkg.applicationInfo.flags & 1) != 0;
    }

    private static boolean isPrivilegedApp(PackageParser.Package pkg) {
        return (pkg.applicationInfo.privateFlags & 8) != 0;
    }

    private static boolean hasDomainURLs(PackageParser.Package pkg) {
        return (pkg.applicationInfo.privateFlags & 0x10) != 0;
    }

    private static boolean isSystemApp(PackageSetting ps) {
        return (ps.pkgFlags & 1) != 0;
    }

    private static boolean isUpdatedSystemApp(PackageSetting ps) {
        return (ps.pkgFlags & 0x80) != 0;
    }

    private int packageFlagsToInstallFlags(PackageSetting ps) {
        int installFlags = 0;
        if (PackageManagerService.isExternal(ps) && TextUtils.isEmpty(ps.volumeUuid)) {
            installFlags |= 8;
        }
        if (ps.isForwardLocked()) {
            installFlags |= 1;
        }
        return installFlags;
    }

    private Settings.VersionInfo getSettingsVersionForPackage(PackageParser.Package pkg) {
        if (PackageManagerService.isExternal(pkg)) {
            if (TextUtils.isEmpty(pkg.volumeUuid)) {
                return this.mSettings.getExternalVersion();
            }
            return this.mSettings.findOrCreateVersion(pkg.volumeUuid);
        }
        return this.mSettings.getInternalVersion();
    }

    private void deleteTempPackageFiles() {
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("vmdl") && name.endsWith(".tmp");
            }
        };
        for (File file : this.mDrmAppPrivateInstallDir.listFiles(filter)) {
            file.delete();
        }
    }

    @Override
    public void deletePackageAsUser(String packageName, IPackageDeleteObserver observer, int userId, int flags) {
        this.deletePackage(packageName, new PackageManager.LegacyPackageDeleteObserver(observer).getBinder(), userId, flags);
    }

    @Override
    public void deletePackage(final String packageName, final IPackageDeleteObserver2 observer, final int userId, final int flags) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DELETE_PACKAGES", null);
        Preconditions.checkNotNull(packageName);
        Preconditions.checkNotNull(observer);
        int uid = Binder.getCallingUid();
        if (UserHandle.getUserId(uid) != userId) {
            this.mContext.enforceCallingPermission("android.permission.INTERACT_ACROSS_USERS_FULL", "deletePackage for user " + userId);
        }
        if (this.isUserRestricted(userId, "no_uninstall_apps")) {
            try {
                observer.onPackageDeleted(packageName, -3, null);
            }
            catch (RemoteException re) {
                // empty catch block
            }
            return;
        }
        boolean uninstallBlocked = false;
        if ((flags & 2) != 0) {
            int[] users = sUserManager.getUserIds();
            for (int i = 0; i < users.length; ++i) {
                if (!this.getBlockUninstallForUser(packageName, users[i])) continue;
                uninstallBlocked = true;
                break;
            }
        } else {
            uninstallBlocked = this.getBlockUninstallForUser(packageName, userId);
        }
        if (uninstallBlocked) {
            try {
                observer.onPackageDeleted(packageName, -4, null);
            }
            catch (RemoteException re) {
                // empty catch block
            }
            return;
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                PackageManagerService.this.mHandler.removeCallbacks(this);
                int returnCode = PackageManagerService.this.deletePackageX(packageName, userId, flags);
                if (observer != null) {
                    try {
                        observer.onPackageDeleted(packageName, returnCode, null);
                    }
                    catch (RemoteException e) {
                        Log.i(PackageManagerService.TAG, "Observer no longer exists.");
                    }
                }
            }
        });
    }

    private boolean isPackageDeviceAdmin(String packageName, int userId) {
        IDevicePolicyManager dpm = IDevicePolicyManager.Stub.asInterface(ServiceManager.getService("device_policy"));
        try {
            if (dpm != null) {
                if (dpm.isDeviceOwner(packageName)) {
                    return true;
                }
                int[] users = userId == -1 ? sUserManager.getUserIds() : new int[]{userId};
                for (int i = 0; i < users.length; ++i) {
                    if (!dpm.packageHasActiveAdmins(packageName, users[i])) continue;
                    return true;
                }
            }
        }
        catch (RemoteException e) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int deletePackageX(String packageName, int userId, int flags) {
        boolean res;
        boolean[] perUserInstalled;
        int[] allUsers;
        UserHandle removeForUser;
        PackageRemovedInfo info = new PackageRemovedInfo();
        UserHandle userHandle = removeForUser = (flags & 2) != 0 ? UserHandle.ALL : new UserHandle(userId);
        if (this.isPackageDeviceAdmin(packageName, removeForUser.getIdentifier())) {
            Slog.w(TAG, "Not removing package " + packageName + ": has active device admin");
            return -2;
        }
        boolean removedForAllUsers = false;
        boolean systemUpdate = false;
        Object object = this.mPackages;
        synchronized (object) {
            PackageSetting ps = this.mSettings.mPackages.get(packageName);
            allUsers = sUserManager.getUserIds();
            perUserInstalled = new boolean[allUsers.length];
            for (int i = 0; i < allUsers.length; ++i) {
                perUserInstalled[i] = ps != null ? ps.getInstalled(allUsers[i]) : false;
            }
        }
        object = this.mInstallLock;
        synchronized (object) {
            res = this.deletePackageLI(packageName, removeForUser, true, allUsers, perUserInstalled, flags | 0x10000, info, true);
            systemUpdate = info.isRemovedPackageSystemUpdate;
            if (res && !systemUpdate && this.mPackages.get(packageName) == null) {
                removedForAllUsers = true;
            }
        }
        if (res) {
            info.sendBroadcast(true, systemUpdate, removedForAllUsers);
            if (systemUpdate) {
                Bundle extras = new Bundle(1);
                extras.putInt("android.intent.extra.UID", info.removedAppId >= 0 ? info.removedAppId : info.uid);
                extras.putBoolean("android.intent.extra.REPLACING", true);
                this.sendPackageBroadcast("android.intent.action.PACKAGE_ADDED", packageName, extras, null, null, null);
                this.sendPackageBroadcast("android.intent.action.PACKAGE_REPLACED", packageName, extras, null, null, null);
                this.sendPackageBroadcast("android.intent.action.MY_PACKAGE_REPLACED", null, null, packageName, null, null);
            }
        }
        Runtime.getRuntime().gc();
        if (info.args != null) {
            object = this.mInstallLock;
            synchronized (object) {
                info.args.doPostDeleteLI(true);
            }
        }
        return res ? 1 : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removePackageDataLI(PackageSetting ps, int[] allUserHandles, boolean[] perUserInstalled, PackageRemovedInfo outInfo, int flags, boolean writeSettings) {
        PackageSetting deletedPs;
        String packageName = ps.name;
        this.removePackageLI(ps, (flags & 0x10000) != 0);
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            deletedPs = this.mSettings.mPackages.get(packageName);
            if (outInfo != null) {
                outInfo.removedPackage = packageName;
                outInfo.removedUsers = deletedPs != null ? deletedPs.queryInstalledUsers(sUserManager.getUserIds(), true) : null;
            }
        }
        if ((flags & 1) == 0) {
            this.removeDataDirsLI(ps.volumeUuid, packageName);
            this.schedulePackageCleaning(packageName, -1, true);
        }
        arrayMap = this.mPackages;
        synchronized (arrayMap) {
            if (deletedPs != null) {
                if ((flags & 1) == 0) {
                    this.clearIntentFilterVerificationsLPw(deletedPs.name, -1);
                    this.clearDefaultBrowserIfNeeded(packageName);
                    if (outInfo != null) {
                        this.mSettings.mKeySetManagerService.removeAppKeySetDataLPw(packageName);
                        outInfo.removedAppId = this.mSettings.removePackageLPw(packageName);
                    }
                    this.updatePermissionsLPw(deletedPs.name, null, 0);
                    if (deletedPs.sharedUser != null) {
                        for (int userId : UserManagerService.getInstance().getUserIds()) {
                            int userIdToKill = this.mSettings.updateSharedUserPermsLPw(deletedPs, userId);
                            if (userIdToKill != -1 && userIdToKill < 0) continue;
                            this.mHandler.post(new Runnable(){

                                @Override
                                public void run() {
                                    PackageManagerService.this.killApplication(deletedPs.name, deletedPs.appId, PackageManagerService.KILL_APP_REASON_GIDS_CHANGED);
                                }
                            });
                            break;
                        }
                    }
                    this.clearPackagePreferredActivitiesLPw(deletedPs.name, -1);
                }
                if (allUserHandles != null && perUserInstalled != null) {
                    for (int i = 0; i < allUserHandles.length; ++i) {
                        ps.setInstalled(perUserInstalled[i], allUserHandles[i]);
                    }
                }
            }
            if (writeSettings) {
                this.mSettings.writeLPr();
            }
        }
        if (outInfo != null) {
            PackageManagerService.removeKeystoreDataIfNeeded(-1, outInfo.removedAppId);
        }
    }

    static boolean locationIsPrivileged(File path) {
        try {
            String privilegedAppDir = new File(Environment.getRootDirectory(), "priv-app").getCanonicalPath();
            return path.getCanonicalPath().startsWith(privilegedAppDir);
        }
        catch (IOException e) {
            Slog.e(TAG, "Unable to access code path " + path);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteSystemPackageLI(PackageSetting newPs, int[] allUserHandles, boolean[] perUserInstalled, int flags, PackageRemovedInfo outInfo, boolean writeSettings) {
        PackageParser.Package newPkg;
        boolean applyUserRestrictions = allUserHandles != null && perUserInstalled != null;
        PackageSetting disabledPs = null;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            disabledPs = this.mSettings.getDisabledSystemPkgLPr(newPs.name);
        }
        if (disabledPs == null) {
            Slog.w(TAG, "Attempt to delete unknown system package " + newPs.name);
            return false;
        }
        outInfo.isRemovedPackageSystemUpdate = true;
        flags = disabledPs.versionCode < newPs.versionCode ? (flags &= 0xFFFFFFFE) : (flags |= 1);
        boolean ret = this.deleteInstalledPackageLI(newPs, true, flags, allUserHandles, perUserInstalled, outInfo, writeSettings);
        if (!ret) {
            return false;
        }
        ArrayMap<String, PackageParser.Package> arrayMap2 = this.mPackages;
        synchronized (arrayMap2) {
            this.mSettings.enableSystemPackageLPw(newPs.name);
            NativeLibraryHelper.removeNativeBinariesLI(newPs.legacyNativeLibraryPathString);
        }
        int parseFlags = 5;
        if (PackageManagerService.locationIsPrivileged(disabledPs.codePath)) {
            parseFlags |= 0x80;
        }
        try {
            newPkg = this.scanPackageLI(disabledPs.codePath, parseFlags, 32, 0L, null);
        }
        catch (PackageManagerException e) {
            Slog.w(TAG, "Failed to restore system package:" + newPs.name + ": " + e.getMessage());
            return false;
        }
        ArrayMap<String, PackageParser.Package> arrayMap3 = this.mPackages;
        synchronized (arrayMap3) {
            PackageSetting ps = this.mSettings.mPackages.get(newPkg.packageName);
            ps.getPermissionsState().copyFrom(newPs.getPermissionsState());
            this.updatePermissionsLPw(newPkg.packageName, newPkg, 3);
            if (applyUserRestrictions) {
                for (int i = 0; i < allUserHandles.length; ++i) {
                    ps.setInstalled(perUserInstalled[i], allUserHandles[i]);
                    this.mSettings.writeRuntimePermissionsForUserLPr(allUserHandles[i], false);
                }
                this.mSettings.writeAllUsersPackageRestrictionsLPr();
            }
            if (writeSettings) {
                this.mSettings.writeLPr();
            }
        }
        return true;
    }

    private boolean deleteInstalledPackageLI(PackageSetting ps, boolean deleteCodeAndResources, int flags, int[] allUserHandles, boolean[] perUserInstalled, PackageRemovedInfo outInfo, boolean writeSettings) {
        if (outInfo != null) {
            outInfo.uid = ps.appId;
        }
        this.removePackageDataLI(ps, allUserHandles, perUserInstalled, outInfo, flags, writeSettings);
        if (deleteCodeAndResources && outInfo != null) {
            outInfo.args = this.createInstallArgsForExisting(this.packageFlagsToInstallFlags(ps), ps.codePathString, ps.resourcePathString, InstructionSets.getAppDexInstructionSets(ps));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setBlockUninstallForUser(String packageName, boolean blockUninstall, int userId) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DELETE_PACKAGES", null);
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageSetting ps = this.mSettings.mPackages.get(packageName);
            if (ps == null) {
                Log.i(TAG, "Package doesn't exist in set block uninstall " + packageName);
                return false;
            }
            if (!ps.getInstalled(userId)) {
                Log.i(TAG, "Package not installed in set block uninstall " + packageName);
                return false;
            }
            ps.setBlockUninstall(blockUninstall, userId);
            this.mSettings.writePackageRestrictionsLPr(userId);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getBlockUninstallForUser(String packageName, int userId) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageSetting ps = this.mSettings.mPackages.get(packageName);
            if (ps == null) {
                Log.i(TAG, "Package doesn't exist in get block uninstall " + packageName);
                return false;
            }
            return ps.getBlockUninstall(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deletePackageLI(String packageName, UserHandle user, boolean deleteCodeAndResources, int[] allUserHandles, boolean[] perUserInstalled, int flags, PackageRemovedInfo outInfo, boolean writeSettings) {
        PackageSetting ps;
        if (packageName == null) {
            Slog.w(TAG, "Attempt to delete null packageName.");
            return false;
        }
        boolean dataOnly = false;
        int removeUser = -1;
        int appId = -1;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            ps = this.mSettings.mPackages.get(packageName);
            if (ps == null) {
                Slog.w(TAG, "Package named '" + packageName + "' doesn't exist.");
                return false;
            }
            if (!(PackageManagerService.isSystemApp(ps) && (flags & 4) == 0 || user == null || user.getIdentifier() == -1)) {
                int userId = user.getIdentifier();
                ps.setUserState(userId, 0, false, true, true, false, null, null, null, false, ps.readUserState((int)userId).domainVerificationStatus, 0);
                if (!PackageManagerService.isSystemApp(ps)) {
                    if (ps.isAnyInstalled(sUserManager.getUserIds())) {
                        removeUser = user.getIdentifier();
                        appId = ps.appId;
                        this.scheduleWritePackageRestrictionsLocked(removeUser);
                    } else {
                        ps.setInstalled(true, user.getIdentifier());
                    }
                } else {
                    removeUser = user.getIdentifier();
                    appId = ps.appId;
                    this.scheduleWritePackageRestrictionsLocked(removeUser);
                }
            }
        }
        if (removeUser >= 0) {
            if (outInfo != null) {
                outInfo.removedPackage = packageName;
                outInfo.removedAppId = appId;
                outInfo.removedUsers = new int[]{removeUser};
            }
            this.mInstaller.clearUserData(ps.volumeUuid, packageName, removeUser);
            PackageManagerService.removeKeystoreDataIfNeeded(removeUser, appId);
            this.schedulePackageCleaning(packageName, removeUser, false);
            arrayMap = this.mPackages;
            synchronized (arrayMap) {
                if (this.clearPackagePreferredActivitiesLPw(packageName, removeUser)) {
                    this.scheduleWritePackageRestrictionsLocked(removeUser);
                }
                this.resetUserChangesToRuntimePermissionsAndFlagsLPw(ps, removeUser);
            }
            return true;
        }
        if (dataOnly) {
            this.removePackageDataLI(ps, null, null, outInfo, flags, writeSettings);
            return true;
        }
        boolean ret = false;
        if (PackageManagerService.isSystemApp(ps)) {
            ret = this.deleteSystemPackageLI(ps, allUserHandles, perUserInstalled, flags, outInfo, writeSettings);
        } else {
            this.killApplication(packageName, ps.appId, "uninstall pkg");
            ret = this.deleteInstalledPackageLI(ps, deleteCodeAndResources, flags, allUserHandles, perUserInstalled, outInfo, writeSettings);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearExternalStorageDataSync(String packageName, int userId, boolean allData) {
        boolean mounted;
        if (Environment.isExternalStorageEmulated()) {
            mounted = true;
        } else {
            String status = Environment.getExternalStorageState();
            boolean bl = mounted = status.equals("mounted") || status.equals("mounted_ro");
        }
        if (!mounted) {
            return;
        }
        Intent containerIntent = new Intent().setComponent(DEFAULT_CONTAINER_COMPONENT);
        int[] users = userId == -1 ? sUserManager.getUserIds() : new int[]{userId};
        ClearStorageConnection conn = new ClearStorageConnection();
        if (this.mContext.bindServiceAsUser(containerIntent, conn, 1, UserHandle.OWNER)) {
            try {
                for (int curUser : users) {
                    long timeout = SystemClock.uptimeMillis() + 5000L;
                    ClearStorageConnection clearStorageConnection = conn;
                    synchronized (clearStorageConnection) {
                        long now = SystemClock.uptimeMillis();
                        while (conn.mContainerService == null && now < timeout) {
                            try {
                                conn.wait(timeout - now);
                            }
                            catch (InterruptedException e) {}
                        }
                    }
                    if (conn.mContainerService == null) {
                        return;
                    }
                    Environment.UserEnvironment userEnv = new Environment.UserEnvironment(curUser);
                    PackageManagerService.clearDirectory(conn.mContainerService, userEnv.buildExternalStorageAppCacheDirs(packageName));
                    if (!allData) continue;
                    PackageManagerService.clearDirectory(conn.mContainerService, userEnv.buildExternalStorageAppDataDirs(packageName));
                    PackageManagerService.clearDirectory(conn.mContainerService, userEnv.buildExternalStorageAppMediaDirs(packageName));
                }
            }
            finally {
                this.mContext.unbindService(conn);
            }
        }
    }

    @Override
    public void clearApplicationUserData(final String packageName, final IPackageDataObserver observer, final int userId) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CLEAR_APP_USER_DATA", null);
        this.enforceCrossUserPermission(Binder.getCallingUid(), userId, true, false, "clear application data");
        this.mHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DeviceStorageMonitorInternal dsm;
                boolean succeeded;
                PackageManagerService.this.mHandler.removeCallbacks(this);
                Object object = PackageManagerService.this.mInstallLock;
                synchronized (object) {
                    succeeded = PackageManagerService.this.clearApplicationUserDataLI(packageName, userId);
                }
                PackageManagerService.this.clearExternalStorageDataSync(packageName, userId, true);
                if (succeeded && (dsm = LocalServices.getService(DeviceStorageMonitorInternal.class)) != null) {
                    dsm.checkMemory();
                }
                if (observer != null) {
                    try {
                        observer.onRemoveCompleted(packageName, succeeded);
                    }
                    catch (RemoteException e) {
                        Log.i(PackageManagerService.TAG, "Observer no longer exists.");
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean clearApplicationUserDataLI(String packageName, int userId) {
        String nativeLibPath;
        PackageParser.Package pkg;
        if (packageName == null) {
            Slog.w(TAG, "Attempt to delete null packageName.");
            return false;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageSetting ps;
            pkg = this.mPackages.get(packageName);
            if (pkg == null && (ps = this.mSettings.mPackages.get(packageName)) != null) {
                pkg = ps.pkg;
            }
            if (pkg == null) {
                Slog.w(TAG, "Package named '" + packageName + "' doesn't exist.");
                return false;
            }
            ps = (PackageSetting)pkg.mExtras;
            this.resetUserChangesToRuntimePermissionsAndFlagsLPw(ps, userId);
        }
        int retCode = this.mInstaller.clearUserData(pkg.volumeUuid, packageName, userId);
        if (retCode < 0) {
            Slog.w(TAG, "Couldn't remove cache files for package: " + packageName);
            return false;
        }
        int appId = pkg.applicationInfo.uid;
        PackageManagerService.removeKeystoreDataIfNeeded(userId, appId);
        if (pkg.applicationInfo.primaryCpuAbi != null && !VMRuntime.is64BitAbi(pkg.applicationInfo.primaryCpuAbi) && this.mInstaller.linkNativeLibraryDirectory(pkg.volumeUuid, pkg.packageName, nativeLibPath = pkg.applicationInfo.nativeLibraryDir, userId) < 0) {
            Slog.w(TAG, "Failed linking native library dir");
            return false;
        }
        return true;
    }

    private void resetUserChangesToRuntimePermissionsAndFlagsLPw(int userId) {
        int packageCount = this.mPackages.size();
        for (int i = 0; i < packageCount; ++i) {
            PackageParser.Package pkg = this.mPackages.valueAt(i);
            PackageSetting ps = (PackageSetting)pkg.mExtras;
            this.resetUserChangesToRuntimePermissionsAndFlagsLPw(ps, userId);
        }
    }

    private void resetUserChangesToRuntimePermissionsAndFlagsLPw(PackageSetting ps, final int userId) {
        if (ps.pkg == null) {
            return;
        }
        int userSettableFlags = 11;
        int policyOrSystemFlags = 20;
        boolean writeInstallPermissions = false;
        boolean writeRuntimePermissions = false;
        int permissionCount = ps.pkg.requestedPermissions.size();
        block4: for (int i = 0; i < permissionCount; ++i) {
            boolean hasInstallState;
            String permission2 = ps.pkg.requestedPermissions.get(i);
            BasePermission bp = this.mSettings.mPermissions.get(permission2);
            if (bp == null) continue;
            if (ps.sharedUser != null) {
                boolean used = false;
                int packageCount = ps.sharedUser.packages.size();
                for (int j = 0; j < packageCount; ++j) {
                    PackageSetting pkg = ps.sharedUser.packages.valueAt(j);
                    if (pkg.pkg == null || pkg.pkg.packageName.equals(ps.pkg.packageName) || !pkg.pkg.requestedPermissions.contains(permission2)) continue;
                    used = true;
                    break;
                }
                if (used) continue;
            }
            PermissionsState permissionsState = ps.getPermissionsState();
            int oldFlags = permissionsState.getPermissionFlags(bp.name, userId);
            boolean bl = hasInstallState = permissionsState.getInstallPermissionState(bp.name) != null;
            if (permissionsState.updatePermissionFlags(bp, userId, 11, 0)) {
                if (hasInstallState) {
                    writeInstallPermissions = true;
                } else {
                    writeRuntimePermissions = true;
                }
            }
            if (!bp.isRuntime() || (oldFlags & 0x14) != 0) continue;
            if ((oldFlags & 0x20) != 0) {
                if (permissionsState.grantRuntimePermission(bp, userId) == -1) continue;
                writeRuntimePermissions = true;
                continue;
            }
            int revokeResult = permissionsState.revokeRuntimePermission(bp, userId);
            switch (revokeResult) {
                case 0: {
                    writeRuntimePermissions = true;
                    continue block4;
                }
                case 1: {
                    writeRuntimePermissions = true;
                    final int appId = ps.appId;
                    this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            PackageManagerService.this.killUid(appId, userId, PackageManagerService.KILL_APP_REASON_GIDS_CHANGED);
                        }
                    });
                }
            }
        }
        if (writeRuntimePermissions) {
            this.mSettings.writeRuntimePermissionsForUserLPr(userId, true);
        }
        if (writeInstallPermissions) {
            this.mSettings.writeLPr();
        }
    }

    private static void removeKeystoreDataIfNeeded(int userId, int appId) {
        if (appId < 0) {
            return;
        }
        KeyStore keyStore = KeyStore.getInstance();
        if (keyStore != null) {
            if (userId == -1) {
                for (int individual : sUserManager.getUserIds()) {
                    keyStore.clearUid(UserHandle.getUid(individual, appId));
                }
            } else {
                keyStore.clearUid(UserHandle.getUid(userId, appId));
            }
        } else {
            Slog.w(TAG, "Could not contact keystore to clear entries for app id " + appId);
        }
    }

    @Override
    public void deleteApplicationCacheFiles(final String packageName, final IPackageDataObserver observer) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DELETE_CACHE_FILES", null);
        final int userId = UserHandle.getCallingUserId();
        this.mHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean succeded;
                PackageManagerService.this.mHandler.removeCallbacks(this);
                Object object = PackageManagerService.this.mInstallLock;
                synchronized (object) {
                    succeded = PackageManagerService.this.deleteApplicationCacheFilesLI(packageName, userId);
                }
                PackageManagerService.this.clearExternalStorageDataSync(packageName, userId, false);
                if (observer != null) {
                    try {
                        observer.onRemoveCompleted(packageName, succeded);
                    }
                    catch (RemoteException e) {
                        Log.i(PackageManagerService.TAG, "Observer no longer exists.");
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteApplicationCacheFilesLI(String packageName, int userId) {
        PackageParser.Package p;
        if (packageName == null) {
            Slog.w(TAG, "Attempt to delete null packageName.");
            return false;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            p = this.mPackages.get(packageName);
        }
        if (p == null) {
            Slog.w(TAG, "Package named '" + packageName + "' doesn't exist.");
            return false;
        }
        ApplicationInfo applicationInfo = p.applicationInfo;
        if (applicationInfo == null) {
            Slog.w(TAG, "Package " + packageName + " has no applicationInfo.");
            return false;
        }
        int retCode = this.mInstaller.deleteCacheFiles(p.volumeUuid, packageName, userId);
        if (retCode < 0) {
            Slog.w(TAG, "Couldn't remove cache files for package: " + packageName + " u" + userId);
            return false;
        }
        return true;
    }

    @Override
    public void getPackageSizeInfo(String packageName, int userHandle, IPackageStatsObserver observer) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.GET_PACKAGE_SIZE", null);
        if (packageName == null) {
            throw new IllegalArgumentException("Attempt to get size of null packageName");
        }
        PackageStats stats = new PackageStats(packageName, userHandle);
        Message msg = this.mHandler.obtainMessage(5);
        msg.obj = new MeasureParams(stats, observer);
        this.mHandler.sendMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getPackageSizeInfoLI(String packageName, int userHandle, PackageStats pStats) {
        String[] dexCodeInstructionSets;
        int res;
        PackageParser.Package p;
        if (packageName == null) {
            Slog.w(TAG, "Attempt to get size of null packageName.");
            return false;
        }
        boolean dataOnly = false;
        String libDirRoot = null;
        String asecPath = null;
        PackageSetting ps = null;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            p = this.mPackages.get(packageName);
            ps = this.mSettings.mPackages.get(packageName);
            if (p == null) {
                dataOnly = true;
                if (ps == null || ps.pkg == null) {
                    Slog.w(TAG, "Package named '" + packageName + "' doesn't exist.");
                    return false;
                }
                p = ps.pkg;
            }
            if (ps != null) {
                libDirRoot = ps.legacyNativeLibraryPathString;
            }
            if (p != null && (PackageManagerService.isExternal(p) || p.isForwardLocked())) {
                long token = Binder.clearCallingIdentity();
                try {
                    String secureContainerId = PackageManagerService.cidFromCodePath(p.applicationInfo.getBaseCodePath());
                    if (secureContainerId != null) {
                        asecPath = PackageHelper.getSdFilesystem(secureContainerId);
                    }
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                }
            }
        }
        String publicSrcDir = null;
        if (!dataOnly) {
            ApplicationInfo applicationInfo = p.applicationInfo;
            if (applicationInfo == null) {
                Slog.w(TAG, "Package " + packageName + " has no applicationInfo.");
                return false;
            }
            if (p.isForwardLocked()) {
                publicSrcDir = applicationInfo.getBaseResourcePath();
            }
        }
        if ((res = this.mInstaller.getSizeInfo(p.volumeUuid, packageName, userHandle, p.baseCodePath, libDirRoot, publicSrcDir, asecPath, dexCodeInstructionSets = InstructionSets.getDexCodeInstructionSets(InstructionSets.getAppDexInstructionSets(ps)), pStats)) < 0) {
            return false;
        }
        if (!PackageManagerService.isExternal(p)) {
            pStats.codeSize += pStats.externalCodeSize;
            pStats.externalCodeSize = 0L;
        }
        return true;
    }

    @Override
    public void addPackageToPreferred(String packageName) {
        Slog.w(TAG, "addPackageToPreferred: this is now a no-op");
    }

    @Override
    public void removePackageFromPreferred(String packageName) {
        Slog.w(TAG, "removePackageFromPreferred: this is now a no-op");
    }

    @Override
    public List<PackageInfo> getPreferredPackages(int flags) {
        return new ArrayList<PackageInfo>();
    }

    private int getUidTargetSdkVersionLockedLPr(int uid) {
        Object obj = this.mSettings.getUserIdLPr(uid);
        if (obj instanceof SharedUserSetting) {
            SharedUserSetting sus = (SharedUserSetting)obj;
            int vers = 10000;
            for (PackageSetting ps : sus.packages) {
                int v;
                if (ps.pkg == null || (v = ps.pkg.applicationInfo.targetSdkVersion) >= vers) continue;
                vers = v;
            }
            return vers;
        }
        if (obj instanceof PackageSetting) {
            PackageSetting ps = (PackageSetting)obj;
            if (ps.pkg != null) {
                return ps.pkg.applicationInfo.targetSdkVersion;
            }
        }
        return 10000;
    }

    @Override
    public void addPreferredActivity(IntentFilter filter, int match, ComponentName[] set, ComponentName activity, int userId) {
        this.addPreferredActivityInternal(filter, match, set, activity, true, userId, "Adding preferred");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPreferredActivityInternal(IntentFilter filter, int match, ComponentName[] set, ComponentName activity, boolean always, int userId, String opname) {
        int callingUid = Binder.getCallingUid();
        this.enforceCrossUserPermission(callingUid, userId, true, false, "add preferred activity");
        if (filter.countActions() == 0) {
            Slog.w(TAG, "Cannot set a preferred activity with no filter actions");
            return;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            if (this.mContext.checkCallingOrSelfPermission("android.permission.SET_PREFERRED_APPLICATIONS") != 0) {
                if (this.getUidTargetSdkVersionLockedLPr(callingUid) < 8) {
                    Slog.w(TAG, "Ignoring addPreferredActivity() from uid " + callingUid);
                    return;
                }
                this.mContext.enforceCallingOrSelfPermission("android.permission.SET_PREFERRED_APPLICATIONS", null);
            }
            PreferredIntentResolver pir = this.mSettings.editPreferredActivitiesLPw(userId);
            Slog.i(TAG, opname + " activity " + activity.flattenToShortString() + " for user " + userId + ":");
            filter.dump(new LogPrinter(4, TAG), "  ");
            pir.addFilter(new PreferredActivity(filter, match, set, activity, always));
            this.scheduleWritePackageRestrictionsLocked(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replacePreferredActivity(IntentFilter filter, int match, ComponentName[] set, ComponentName activity, int userId) {
        if (filter.countActions() != 1) {
            throw new IllegalArgumentException("replacePreferredActivity expects filter to have only 1 action.");
        }
        if (filter.countDataAuthorities() != 0 || filter.countDataPaths() != 0 || filter.countDataSchemes() > 1 || filter.countDataTypes() != 0) {
            throw new IllegalArgumentException("replacePreferredActivity expects filter to have no data authorities, paths, or types; and at most one scheme.");
        }
        int callingUid = Binder.getCallingUid();
        this.enforceCrossUserPermission(callingUid, userId, true, false, "replace preferred activity");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PreferredIntentResolver pir;
            if (this.mContext.checkCallingOrSelfPermission("android.permission.SET_PREFERRED_APPLICATIONS") != 0) {
                if (this.getUidTargetSdkVersionLockedLPr(callingUid) < 8) {
                    Slog.w(TAG, "Ignoring replacePreferredActivity() from uid " + Binder.getCallingUid());
                    return;
                }
                this.mContext.enforceCallingOrSelfPermission("android.permission.SET_PREFERRED_APPLICATIONS", null);
            }
            if ((pir = this.mSettings.mPreferredActivities.get(userId)) != null) {
                ArrayList existing = pir.findFilters(filter);
                if (existing != null && existing.size() == 1) {
                    PreferredActivity cur = (PreferredActivity)existing.get(0);
                    if (cur.mPref.mAlways && cur.mPref.mComponent.equals(activity) && cur.mPref.mMatch == (match & 0xFFF0000) && cur.mPref.sameSet(set)) {
                        return;
                    }
                }
                if (existing != null) {
                    for (int i = 0; i < existing.size(); ++i) {
                        PreferredActivity pa = (PreferredActivity)existing.get(i);
                        pir.removeFilter(pa);
                    }
                }
            }
            this.addPreferredActivityInternal(filter, match, set, activity, true, userId, "Replacing preferred");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearPackagePreferredActivities(String packageName) {
        int uid = Binder.getCallingUid();
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            int user;
            PackageParser.Package pkg = this.mPackages.get(packageName);
            if ((pkg == null || pkg.applicationInfo.uid != uid) && this.mContext.checkCallingOrSelfPermission("android.permission.SET_PREFERRED_APPLICATIONS") != 0) {
                if (this.getUidTargetSdkVersionLockedLPr(Binder.getCallingUid()) < 8) {
                    Slog.w(TAG, "Ignoring clearPackagePreferredActivities() from uid " + Binder.getCallingUid());
                    return;
                }
                this.mContext.enforceCallingOrSelfPermission("android.permission.SET_PREFERRED_APPLICATIONS", null);
            }
            if (this.clearPackagePreferredActivitiesLPw(packageName, user = UserHandle.getCallingUserId())) {
                this.scheduleWritePackageRestrictionsLocked(user);
            }
        }
    }

    boolean clearPackagePreferredActivitiesLPw(String packageName, int userId) {
        ArrayList<PreferredActivity> removed = null;
        boolean changed = false;
        for (int i = 0; i < this.mSettings.mPreferredActivities.size(); ++i) {
            int thisUserId = this.mSettings.mPreferredActivities.keyAt(i);
            PreferredIntentResolver pir = this.mSettings.mPreferredActivities.valueAt(i);
            if (userId != -1 && userId != thisUserId) continue;
            Iterator it = pir.filterIterator();
            while (it.hasNext()) {
                PreferredActivity pa = (PreferredActivity)it.next();
                if (packageName != null && (!pa.mPref.mComponent.getPackageName().equals(packageName) || !pa.mPref.mAlways)) continue;
                if (removed == null) {
                    removed = new ArrayList<PreferredActivity>();
                }
                removed.add(pa);
            }
            if (removed == null) continue;
            for (int j = 0; j < removed.size(); ++j) {
                PreferredActivity pa = (PreferredActivity)removed.get(j);
                pir.removeFilter(pa);
            }
            changed = true;
        }
        return changed;
    }

    private void clearIntentFilterVerificationsLPw(int userId) {
        int packageCount = this.mPackages.size();
        for (int i = 0; i < packageCount; ++i) {
            PackageParser.Package pkg = this.mPackages.valueAt(i);
            this.clearIntentFilterVerificationsLPw(pkg.packageName, userId);
        }
    }

    void clearIntentFilterVerificationsLPw(String packageName, int userId) {
        if (userId == -1) {
            if (this.mSettings.removeIntentFilterVerificationLPw(packageName, sUserManager.getUserIds())) {
                for (int oneUserId : sUserManager.getUserIds()) {
                    this.scheduleWritePackageRestrictionsLocked(oneUserId);
                }
            }
        } else if (this.mSettings.removeIntentFilterVerificationLPw(packageName, userId)) {
            this.scheduleWritePackageRestrictionsLocked(userId);
        }
    }

    void clearDefaultBrowserIfNeeded(String packageName) {
        for (int oneUserId : sUserManager.getUserIds()) {
            String defaultBrowserPackageName = this.getDefaultBrowserPackageName(oneUserId);
            if (TextUtils.isEmpty(defaultBrowserPackageName) || !packageName.equals(defaultBrowserPackageName)) continue;
            this.setDefaultBrowserPackageName(null, oneUserId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetApplicationPreferences(int userId) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.SET_PREFERRED_APPLICATIONS", null);
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            long identity = Binder.clearCallingIdentity();
            try {
                this.clearPackagePreferredActivitiesLPw(null, userId);
                this.mSettings.applyDefaultPreferredAppsLPw(this, userId);
                this.applyFactoryDefaultBrowserLPw(userId);
                this.clearIntentFilterVerificationsLPw(userId);
                this.primeDomainVerificationsLPw(userId);
                this.resetUserChangesToRuntimePermissionsAndFlagsLPw(userId);
                this.scheduleWritePackageRestrictionsLocked(userId);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPreferredActivities(List<IntentFilter> outFilters, List<ComponentName> outActivities, String packageName) {
        int num = 0;
        int userId = UserHandle.getCallingUserId();
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PreferredIntentResolver pir = this.mSettings.mPreferredActivities.get(userId);
            if (pir != null) {
                Iterator it = pir.filterIterator();
                while (it.hasNext()) {
                    PreferredActivity pa = (PreferredActivity)it.next();
                    if (packageName != null && (!pa.mPref.mComponent.getPackageName().equals(packageName) || !pa.mPref.mAlways)) continue;
                    if (outFilters != null) {
                        outFilters.add(new IntentFilter(pa));
                    }
                    if (outActivities == null) continue;
                    outActivities.add(pa.mPref.mComponent);
                }
            }
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPersistentPreferredActivity(IntentFilter filter, ComponentName activity, int userId) {
        int callingUid = Binder.getCallingUid();
        if (callingUid != 1000) {
            throw new SecurityException("addPersistentPreferredActivity can only be run by the system");
        }
        if (filter.countActions() == 0) {
            Slog.w(TAG, "Cannot set a preferred activity with no filter actions");
            return;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            Slog.i(TAG, "Adding persistent preferred activity " + activity + " for user " + userId + " :");
            filter.dump(new LogPrinter(4, TAG), "  ");
            this.mSettings.editPersistentPreferredActivitiesLPw(userId).addFilter(new PersistentPreferredActivity(filter, activity));
            this.scheduleWritePackageRestrictionsLocked(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearPackagePersistentPreferredActivities(String packageName, int userId) {
        int callingUid = Binder.getCallingUid();
        if (callingUid != 1000) {
            throw new SecurityException("clearPackagePersistentPreferredActivities can only be run by the system");
        }
        ArrayList<PersistentPreferredActivity> removed = null;
        boolean changed = false;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            for (int i = 0; i < this.mSettings.mPersistentPreferredActivities.size(); ++i) {
                int thisUserId = this.mSettings.mPersistentPreferredActivities.keyAt(i);
                PersistentPreferredIntentResolver ppir = this.mSettings.mPersistentPreferredActivities.valueAt(i);
                if (userId != thisUserId) continue;
                Iterator it = ppir.filterIterator();
                while (it.hasNext()) {
                    PersistentPreferredActivity ppa = (PersistentPreferredActivity)it.next();
                    if (!ppa.mComponent.getPackageName().equals(packageName)) continue;
                    if (removed == null) {
                        removed = new ArrayList<PersistentPreferredActivity>();
                    }
                    removed.add(ppa);
                }
                if (removed == null) continue;
                for (int j = 0; j < removed.size(); ++j) {
                    PersistentPreferredActivity ppa = (PersistentPreferredActivity)removed.get(j);
                    ppir.removeFilter(ppa);
                }
                changed = true;
            }
            if (changed) {
                this.scheduleWritePackageRestrictionsLocked(userId);
            }
        }
    }

    private void restoreFromXml(XmlPullParser parser, int userId, String expectedStartTag, BlobXmlRestorer functor) throws IOException, XmlPullParserException {
        int type;
        while ((type = parser.next()) != 2 && type != 1) {
        }
        if (type != 2) {
            return;
        }
        if (!expectedStartTag.equals(parser.getName())) {
            return;
        }
        while ((type = parser.next()) == 4) {
        }
        functor.apply(parser, userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getPreferredActivityBackup(int userId) {
        if (Binder.getCallingUid() != 1000) {
            throw new SecurityException("Only the system may call getPreferredActivityBackup()");
        }
        ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
        try {
            FastXmlSerializer serializer = new FastXmlSerializer();
            serializer.setOutput(dataStream, StandardCharsets.UTF_8.name());
            serializer.startDocument(null, true);
            serializer.startTag(null, TAG_PREFERRED_BACKUP);
            ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
            synchronized (arrayMap) {
                this.mSettings.writePreferredActivitiesLPr(serializer, userId, true);
            }
            serializer.endTag(null, TAG_PREFERRED_BACKUP);
            serializer.endDocument();
            serializer.flush();
        }
        catch (Exception e) {
            return null;
        }
        return dataStream.toByteArray();
    }

    @Override
    public void restorePreferredActivities(byte[] backup, int userId) {
        if (Binder.getCallingUid() != 1000) {
            throw new SecurityException("Only the system may call restorePreferredActivities()");
        }
        try {
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(new ByteArrayInputStream(backup), StandardCharsets.UTF_8.name());
            this.restoreFromXml(parser, userId, TAG_PREFERRED_BACKUP, new BlobXmlRestorer(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void apply(XmlPullParser parser, int userId) throws XmlPullParserException, IOException {
                    ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
                    synchronized (arrayMap) {
                        PackageManagerService.this.mSettings.readPreferredActivitiesLPw(parser, userId);
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getDefaultAppsBackup(int userId) {
        if (Binder.getCallingUid() != 1000) {
            throw new SecurityException("Only the system may call getDefaultAppsBackup()");
        }
        ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
        try {
            FastXmlSerializer serializer = new FastXmlSerializer();
            serializer.setOutput(dataStream, StandardCharsets.UTF_8.name());
            serializer.startDocument(null, true);
            serializer.startTag(null, TAG_DEFAULT_APPS);
            ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
            synchronized (arrayMap) {
                this.mSettings.writeDefaultAppsLPr(serializer, userId);
            }
            serializer.endTag(null, TAG_DEFAULT_APPS);
            serializer.endDocument();
            serializer.flush();
        }
        catch (Exception e) {
            return null;
        }
        return dataStream.toByteArray();
    }

    @Override
    public void restoreDefaultApps(byte[] backup, int userId) {
        if (Binder.getCallingUid() != 1000) {
            throw new SecurityException("Only the system may call restoreDefaultApps()");
        }
        try {
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(new ByteArrayInputStream(backup), StandardCharsets.UTF_8.name());
            this.restoreFromXml(parser, userId, TAG_DEFAULT_APPS, new BlobXmlRestorer(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void apply(XmlPullParser parser, int userId) throws XmlPullParserException, IOException {
                    ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
                    synchronized (arrayMap) {
                        PackageManagerService.this.mSettings.readDefaultAppsLPw(parser, userId);
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getIntentFilterVerificationBackup(int userId) {
        if (Binder.getCallingUid() != 1000) {
            throw new SecurityException("Only the system may call getIntentFilterVerificationBackup()");
        }
        ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
        try {
            FastXmlSerializer serializer = new FastXmlSerializer();
            serializer.setOutput(dataStream, StandardCharsets.UTF_8.name());
            serializer.startDocument(null, true);
            serializer.startTag(null, TAG_INTENT_FILTER_VERIFICATION);
            ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
            synchronized (arrayMap) {
                this.mSettings.writeAllDomainVerificationsLPr(serializer, userId);
            }
            serializer.endTag(null, TAG_INTENT_FILTER_VERIFICATION);
            serializer.endDocument();
            serializer.flush();
        }
        catch (Exception e) {
            return null;
        }
        return dataStream.toByteArray();
    }

    @Override
    public void restoreIntentFilterVerification(byte[] backup, int userId) {
        if (Binder.getCallingUid() != 1000) {
            throw new SecurityException("Only the system may call restorePreferredActivities()");
        }
        try {
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(new ByteArrayInputStream(backup), StandardCharsets.UTF_8.name());
            this.restoreFromXml(parser, userId, TAG_INTENT_FILTER_VERIFICATION, new BlobXmlRestorer(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void apply(XmlPullParser parser, int userId) throws XmlPullParserException, IOException {
                    ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
                    synchronized (arrayMap) {
                        PackageManagerService.this.mSettings.readAllDomainVerificationsLPr(parser, userId);
                        PackageManagerService.this.mSettings.writeLPr();
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCrossProfileIntentFilter(IntentFilter intentFilter, String ownerPackage, int sourceUserId, int targetUserId, int flags) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL", null);
        int callingUid = Binder.getCallingUid();
        this.enforceOwnerRights(ownerPackage, callingUid);
        this.enforceShellRestriction("no_debugging_features", callingUid, sourceUserId);
        if (intentFilter.countActions() == 0) {
            Slog.w(TAG, "Cannot set a crossProfile intent filter with no filter actions");
            return;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            CrossProfileIntentFilter newFilter = new CrossProfileIntentFilter(intentFilter, ownerPackage, targetUserId, flags);
            CrossProfileIntentResolver resolver = this.mSettings.editCrossProfileIntentResolverLPw(sourceUserId);
            ArrayList existing = resolver.findFilters(intentFilter);
            if (existing != null) {
                int size = existing.size();
                for (int i = 0; i < size; ++i) {
                    if (!newFilter.equalsIgnoreFilter((CrossProfileIntentFilter)existing.get(i))) continue;
                    return;
                }
            }
            resolver.addFilter(newFilter);
            this.scheduleWritePackageRestrictionsLocked(sourceUserId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCrossProfileIntentFilters(int sourceUserId, String ownerPackage) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL", null);
        int callingUid = Binder.getCallingUid();
        this.enforceOwnerRights(ownerPackage, callingUid);
        this.enforceShellRestriction("no_debugging_features", callingUid, sourceUserId);
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            CrossProfileIntentResolver resolver = this.mSettings.editCrossProfileIntentResolverLPw(sourceUserId);
            ArraySet set = new ArraySet(resolver.filterSet());
            for (CrossProfileIntentFilter filter : set) {
                if (!filter.getOwnerPackage().equals(ownerPackage)) continue;
                resolver.removeFilter(filter);
            }
            this.scheduleWritePackageRestrictionsLocked(sourceUserId);
        }
    }

    private void enforceOwnerRights(String pkg, int callingUid) {
        if (UserHandle.getAppId(callingUid) == 1000) {
            return;
        }
        int callingUserId = UserHandle.getUserId(callingUid);
        PackageInfo pi = this.getPackageInfo(pkg, 0, callingUserId);
        if (pi == null) {
            throw new IllegalArgumentException("Unknown package " + pkg + " on user " + callingUserId);
        }
        if (!UserHandle.isSameApp(pi.applicationInfo.uid, callingUid)) {
            throw new SecurityException("Calling uid " + callingUid + " does not own package " + pkg);
        }
    }

    @Override
    public ComponentName getHomeActivities(List<ResolveInfo> allHomeCandidates) {
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.HOME");
        int callingUserId = UserHandle.getCallingUserId();
        List<ResolveInfo> list = this.queryIntentActivities(intent, null, 128, callingUserId);
        ResolveInfo preferred = this.findPreferredActivity(intent, null, 0, list, 0, true, false, false, callingUserId);
        allHomeCandidates.clear();
        if (list != null) {
            for (ResolveInfo ri : list) {
                allHomeCandidates.add(ri);
            }
        }
        return preferred == null || preferred.activityInfo == null ? null : new ComponentName(preferred.activityInfo.packageName, preferred.activityInfo.name);
    }

    @Override
    public void setApplicationEnabledSetting(String appPackageName, int newState, int flags, int userId, String callingPackage) {
        if (!sUserManager.exists(userId)) {
            return;
        }
        if (callingPackage == null) {
            callingPackage = Integer.toString(Binder.getCallingUid());
        }
        this.setEnabledSetting(appPackageName, null, newState, flags, userId, callingPackage);
    }

    @Override
    public void setComponentEnabledSetting(ComponentName componentName, int newState, int flags, int userId) {
        if (!sUserManager.exists(userId)) {
            return;
        }
        this.setEnabledSetting(componentName.getPackageName(), componentName.getClassName(), newState, flags, userId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setEnabledSetting(String packageName, String className, int newState, int flags, int userId, String callingPackage) {
        ArrayList<String> components;
        PackageSetting pkgSetting;
        if (newState != 0 && newState != 1 && newState != 2 && newState != 3 && newState != 4) {
            throw new IllegalArgumentException("Invalid new component state: " + newState);
        }
        int uid = Binder.getCallingUid();
        int permission2 = this.mContext.checkCallingOrSelfPermission("android.permission.CHANGE_COMPONENT_ENABLED_STATE");
        this.enforceCrossUserPermission(uid, userId, false, true, "set enabled");
        boolean allowedByPermission = permission2 == 0;
        boolean sendNow = false;
        boolean isApp = className == null;
        String componentName = isApp ? packageName : className;
        int packageUid = -1;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            boolean newPackage;
            pkgSetting = this.mSettings.mPackages.get(packageName);
            if (pkgSetting == null) {
                if (className == null) {
                    throw new IllegalArgumentException("Unknown package: " + packageName);
                }
                throw new IllegalArgumentException("Unknown component: " + packageName + "/" + className);
            }
            if (!allowedByPermission && !UserHandle.isSameApp(uid, pkgSetting.appId)) {
                throw new SecurityException("Permission Denial: attempt to change component state from pid=" + Binder.getCallingPid() + ", uid=" + uid + ", package uid=" + pkgSetting.appId);
            }
            if (className == null) {
                if (pkgSetting.getEnabled(userId) == newState) {
                    return;
                }
                if (newState == 0 || newState == 1) {
                    callingPackage = null;
                }
                pkgSetting.setEnabled(newState, userId, callingPackage);
            } else {
                PackageParser.Package pkg = pkgSetting.pkg;
                if (pkg == null || !pkg.hasComponentClassName(className)) {
                    if (pkg.applicationInfo.targetSdkVersion >= 16) {
                        throw new IllegalArgumentException("Component class " + className + " does not exist in " + packageName);
                    }
                    Slog.w(TAG, "Failed setComponentEnabledSetting: component class " + className + " does not exist in " + packageName);
                }
                switch (newState) {
                    case 1: {
                        if (pkgSetting.enableComponentLPw(className, userId)) break;
                        return;
                    }
                    case 2: {
                        if (pkgSetting.disableComponentLPw(className, userId)) break;
                        return;
                    }
                    case 0: {
                        if (pkgSetting.restoreComponentLPw(className, userId)) break;
                        return;
                    }
                    default: {
                        Slog.e(TAG, "Invalid new component state: " + newState);
                        return;
                    }
                }
            }
            this.scheduleWritePackageRestrictionsLocked(userId);
            components = this.mPendingBroadcasts.get(userId, packageName);
            boolean bl = newPackage = components == null;
            if (newPackage) {
                components = new ArrayList();
            }
            if (!components.contains(componentName)) {
                components.add(componentName);
            }
            if ((flags & 1) == 0) {
                sendNow = true;
                this.mPendingBroadcasts.remove(userId, packageName);
            } else {
                if (newPackage) {
                    this.mPendingBroadcasts.put(userId, packageName, components);
                }
                if (!this.mHandler.hasMessages(1)) {
                    this.mHandler.sendEmptyMessageDelayed(1, 10000L);
                }
            }
        }
        long callingId = Binder.clearCallingIdentity();
        try {
            if (sendNow) {
                packageUid = UserHandle.getUid(userId, pkgSetting.appId);
                this.sendPackageChangedBroadcast(packageName, (flags & 1) != 0, components, packageUid);
            }
        }
        finally {
            Binder.restoreCallingIdentity(callingId);
        }
    }

    private void sendPackageChangedBroadcast(String packageName, boolean killFlag, ArrayList<String> componentNames, int packageUid) {
        Bundle extras = new Bundle(4);
        extras.putString("android.intent.extra.changed_component_name", componentNames.get(0));
        String[] nameList = new String[componentNames.size()];
        componentNames.toArray(nameList);
        extras.putStringArray("android.intent.extra.changed_component_name_list", nameList);
        extras.putBoolean("android.intent.extra.DONT_KILL_APP", killFlag);
        extras.putInt("android.intent.extra.UID", packageUid);
        this.sendPackageBroadcast("android.intent.action.PACKAGE_CHANGED", packageName, extras, null, null, new int[]{UserHandle.getUserId(packageUid)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPackageStoppedState(String packageName, boolean stopped, int userId) {
        if (!sUserManager.exists(userId)) {
            return;
        }
        int uid = Binder.getCallingUid();
        int permission2 = this.mContext.checkCallingOrSelfPermission("android.permission.CHANGE_COMPONENT_ENABLED_STATE");
        boolean allowedByPermission = permission2 == 0;
        this.enforceCrossUserPermission(uid, userId, true, true, "stop package");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            if (this.mSettings.setPackageStoppedStateLPw(this, packageName, stopped, allowedByPermission, uid, userId)) {
                this.scheduleWritePackageRestrictionsLocked(userId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getInstallerPackageName(String packageName) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            return this.mSettings.getInstallerPackageNameLPr(packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getApplicationEnabledSetting(String packageName, int userId) {
        if (!sUserManager.exists(userId)) {
            return 2;
        }
        int uid = Binder.getCallingUid();
        this.enforceCrossUserPermission(uid, userId, false, false, "get enabled");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            return this.mSettings.getApplicationEnabledSettingLPr(packageName, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getComponentEnabledSetting(ComponentName componentName, int userId) {
        if (!sUserManager.exists(userId)) {
            return 2;
        }
        int uid = Binder.getCallingUid();
        this.enforceCrossUserPermission(uid, userId, false, false, "get component enabled");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            return this.mSettings.getComponentEnabledSettingLPr(componentName, userId);
        }
    }

    @Override
    public void enterSafeMode() {
        PackageManagerService.enforceSystemOrRoot("Only the system can request entering safe mode");
        if (!this.mSystemReady) {
            this.mSafeMode = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void systemReady() {
        this.mSystemReady = true;
        boolean compatibilityModeEnabled = Settings.Global.getInt(this.mContext.getContentResolver(), "compatibility_mode", 1) == 1;
        PackageParser.setCompatibilityModeEnabled(compatibilityModeEnabled);
        int[] grantPermissionsUserIds = EMPTY_INT_ARRAY;
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            ArrayList<PreferredActivity> removed = new ArrayList<PreferredActivity>();
            for (int i = 0; i < this.mSettings.mPreferredActivities.size(); ++i) {
                PreferredIntentResolver pir = this.mSettings.mPreferredActivities.valueAt(i);
                removed.clear();
                for (PreferredActivity pa : pir.filterSet()) {
                    if (this.mActivities.mActivities.get(pa.mPref.mComponent) != null) continue;
                    removed.add(pa);
                }
                if (removed.size() <= 0) continue;
                for (int r = 0; r < removed.size(); ++r) {
                    PreferredActivity pa;
                    pa = (PreferredActivity)removed.get(r);
                    Slog.w(TAG, "Removing dangling preferred activity: " + pa.mPref.mComponent);
                    pir.removeFilter(pa);
                }
                this.mSettings.writePackageRestrictionsLPr(this.mSettings.mPreferredActivities.keyAt(i));
            }
            for (int userId : UserManagerService.getInstance().getUserIds()) {
                if (this.mSettings.areDefaultRuntimePermissionsGrantedLPr(userId)) continue;
                grantPermissionsUserIds = ArrayUtils.appendInt(grantPermissionsUserIds, userId);
            }
        }
        sUserManager.systemReady();
        for (int userId : grantPermissionsUserIds) {
            this.mDefaultPermissionPolicy.grantDefaultPermissions(userId);
        }
        if (this.mPostSystemReadyMessages != null) {
            for (Message msg : this.mPostSystemReadyMessages) {
                msg.sendToTarget();
            }
            this.mPostSystemReadyMessages = null;
        }
        StorageManager storage = this.mContext.getSystemService(StorageManager.class);
        storage.registerListener(this.mStorageListener);
        this.mInstallerService.systemReady();
        this.mPackageDexOptimizer.systemReady();
        MountServiceInternal mountServiceInternal = LocalServices.getService(MountServiceInternal.class);
        mountServiceInternal.addExternalStoragePolicy(new MountServiceInternal.ExternalStorageMountPolicy(){

            @Override
            public int getMountMode(int uid, String packageName) {
                if (Process.isIsolated(uid)) {
                    return 0;
                }
                if (PackageManagerService.this.checkUidPermission("android.permission.WRITE_MEDIA_STORAGE", uid) == 0) {
                    return 1;
                }
                if (PackageManagerService.this.checkUidPermission("android.permission.READ_EXTERNAL_STORAGE", uid) == -1) {
                    return 1;
                }
                if (PackageManagerService.this.checkUidPermission("android.permission.WRITE_EXTERNAL_STORAGE", uid) == -1) {
                    return 2;
                }
                return 3;
            }

            @Override
            public boolean hasExternalStorage(int uid, String packageName) {
                return true;
            }
        });
    }

    @Override
    public boolean isSafeMode() {
        return this.mSafeMode;
    }

    @Override
    public boolean hasSystemUidErrors() {
        return this.mHasSystemUidErrors;
    }

    static String arrayToString(int[] array2) {
        StringBuffer buf = new StringBuffer(128);
        buf.append('[');
        if (array2 != null) {
            for (int i = 0; i < array2.length; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(array2[i]);
            }
        }
        buf.append(']');
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        String opt;
        int opti;
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump ActivityManager from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " without permission " + "android.permission.DUMP");
            return;
        }
        DumpState dumpState = new DumpState();
        boolean fullPreferred = false;
        boolean checkin = false;
        String packageName = null;
        ArraySet<String> permissionNames = null;
        for (opti = 0; opti < args.length && (opt = args[opti]) != null && opt.length() > 0 && opt.charAt(0) == '-'; ++opti) {
            if ("-a".equals(opt)) continue;
            if ("-h".equals(opt)) {
                pw.println("Package manager dump options:");
                pw.println("  [-h] [-f] [--checkin] [cmd] ...");
                pw.println("    --checkin: dump for a checkin");
                pw.println("    -f: print details of intent filters");
                pw.println("    -h: print this help");
                pw.println("  cmd may be one of:");
                pw.println("    l[ibraries]: list known shared libraries");
                pw.println("    f[ibraries]: list device features");
                pw.println("    k[eysets]: print known keysets");
                pw.println("    r[esolvers]: dump intent resolvers");
                pw.println("    perm[issions]: dump permissions");
                pw.println("    permission [name ...]: dump declaration and use of given permission");
                pw.println("    pref[erred]: print preferred package settings");
                pw.println("    preferred-xml [--full]: print preferred package settings as xml");
                pw.println("    prov[iders]: dump content providers");
                pw.println("    p[ackages]: dump installed packages");
                pw.println("    s[hared-users]: dump shared user IDs");
                pw.println("    m[essages]: print collected runtime messages");
                pw.println("    v[erifiers]: print package verifier info");
                pw.println("    d[omain-preferred-apps]: print domains preferred apps");
                pw.println("    i[ntent-filter-verifiers]|ifv: print intent filter verifier info");
                pw.println("    version: print database version info");
                pw.println("    write: write current settings now");
                pw.println("    installs: details about install sessions");
                pw.println("    check-permission <permission> <package> [<user>]: does pkg hold perm?");
                pw.println("    <package.name>: info about given package");
                return;
            }
            if ("--checkin".equals(opt)) {
                checkin = true;
                continue;
            }
            if ("-f".equals(opt)) {
                dumpState.setOptionEnabled(1);
                continue;
            }
            pw.println("Unknown argument: " + opt + "; use -h for help");
        }
        if (opti < args.length) {
            String cmd = args[opti];
            ++opti;
            if ("android".equals(cmd) || cmd.contains(".")) {
                packageName = cmd;
                dumpState.setOptionEnabled(1);
            } else {
                if ("check-permission".equals(cmd)) {
                    if (opti >= args.length) {
                        pw.println("Error: check-permission missing permission argument");
                        return;
                    }
                    String perm = args[opti];
                    if (++opti >= args.length) {
                        pw.println("Error: check-permission missing package argument");
                        return;
                    }
                    String pkg = args[opti];
                    int user = UserHandle.getUserId(Binder.getCallingUid());
                    if (++opti < args.length) {
                        try {
                            user = Integer.parseInt(args[opti]);
                        }
                        catch (NumberFormatException e) {
                            pw.println("Error: check-permission user argument is not a number: " + args[opti]);
                            return;
                        }
                    }
                    pw.println(this.checkPermission(perm, pkg, user));
                    return;
                }
                if ("l".equals(cmd) || "libraries".equals(cmd)) {
                    dumpState.setDump(1);
                } else if ("f".equals(cmd) || "features".equals(cmd)) {
                    dumpState.setDump(2);
                } else if ("r".equals(cmd) || "resolvers".equals(cmd)) {
                    dumpState.setDump(4);
                } else if ("perm".equals(cmd) || "permissions".equals(cmd)) {
                    dumpState.setDump(8);
                } else if ("permission".equals(cmd)) {
                    if (opti >= args.length) {
                        pw.println("Error: permission requires permission name");
                        return;
                    }
                    permissionNames = new ArraySet<String>();
                    while (opti < args.length) {
                        permissionNames.add(args[opti]);
                        ++opti;
                    }
                    dumpState.setDump(56);
                } else if ("pref".equals(cmd) || "preferred".equals(cmd)) {
                    dumpState.setDump(512);
                } else if ("preferred-xml".equals(cmd)) {
                    dumpState.setDump(1024);
                    if (opti < args.length && "--full".equals(args[opti])) {
                        fullPreferred = true;
                        ++opti;
                    }
                } else if ("d".equals(cmd) || "domain-preferred-apps".equals(cmd)) {
                    dumpState.setDump(32768);
                } else if ("p".equals(cmd) || "packages".equals(cmd)) {
                    dumpState.setDump(16);
                } else if ("s".equals(cmd) || "shared-users".equals(cmd)) {
                    dumpState.setDump(32);
                } else if ("prov".equals(cmd) || "providers".equals(cmd)) {
                    dumpState.setDump(128);
                } else if ("m".equals(cmd) || "messages".equals(cmd)) {
                    dumpState.setDump(64);
                } else if ("v".equals(cmd) || "verifiers".equals(cmd)) {
                    dumpState.setDump(256);
                } else if ("i".equals(cmd) || "ifv".equals(cmd) || "intent-filter-verifiers".equals(cmd)) {
                    dumpState.setDump(16384);
                } else if ("version".equals(cmd)) {
                    dumpState.setDump(4096);
                } else if ("k".equals(cmd) || "keysets".equals(cmd)) {
                    dumpState.setDump(2048);
                } else if ("installs".equals(cmd)) {
                    dumpState.setDump(8192);
                } else if ("write".equals(cmd)) {
                    ArrayMap<String, PackageParser.Package> perm = this.mPackages;
                    synchronized (perm) {
                        this.mSettings.writeLPr();
                        pw.println("Settings written.");
                        return;
                    }
                }
            }
        }
        if (checkin) {
            pw.println("vers,1");
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            String line;
            if (dumpState.isDumping(4096) && packageName == null && !checkin) {
                if (dumpState.onTitlePrinted()) {
                    pw.println();
                }
                pw.println("Database versions:");
                this.mSettings.dumpVersionLPr(new IndentingPrintWriter((Writer)pw, "  "));
            }
            if (dumpState.isDumping(256) && packageName == null) {
                if (!checkin) {
                    if (dumpState.onTitlePrinted()) {
                        pw.println();
                    }
                    pw.println("Verifiers:");
                    pw.print("  Required: ");
                    pw.print(this.mRequiredVerifierPackage);
                    pw.print(" (uid=");
                    pw.print(this.getPackageUid(this.mRequiredVerifierPackage, 0));
                    pw.println(")");
                } else if (this.mRequiredVerifierPackage != null) {
                    pw.print("vrfy,");
                    pw.print(this.mRequiredVerifierPackage);
                    pw.print(",");
                    pw.println(this.getPackageUid(this.mRequiredVerifierPackage, 0));
                }
            }
            if (dumpState.isDumping(16384) && packageName == null) {
                if (this.mIntentFilterVerifierComponent != null) {
                    String verifierPackageName = this.mIntentFilterVerifierComponent.getPackageName();
                    if (!checkin) {
                        if (dumpState.onTitlePrinted()) {
                            pw.println();
                        }
                        pw.println("Intent Filter Verifier:");
                        pw.print("  Using: ");
                        pw.print(verifierPackageName);
                        pw.print(" (uid=");
                        pw.print(this.getPackageUid(verifierPackageName, 0));
                        pw.println(")");
                    } else if (verifierPackageName != null) {
                        pw.print("ifv,");
                        pw.print(verifierPackageName);
                        pw.print(",");
                        pw.println(this.getPackageUid(verifierPackageName, 0));
                    }
                } else {
                    pw.println();
                    pw.println("No Intent Filter Verifier available!");
                }
            }
            if (dumpState.isDumping(1) && packageName == null) {
                boolean printedHeader = false;
                for (String name : this.mSharedLibraries.keySet()) {
                    SharedLibraryEntry ent = this.mSharedLibraries.get(name);
                    if (!checkin) {
                        if (!printedHeader) {
                            if (dumpState.onTitlePrinted()) {
                                pw.println();
                            }
                            pw.println("Libraries:");
                            printedHeader = true;
                        }
                        pw.print("  ");
                    } else {
                        pw.print("lib,");
                    }
                    pw.print(name);
                    if (!checkin) {
                        pw.print(" -> ");
                    }
                    if (ent.path != null) {
                        if (!checkin) {
                            pw.print("(jar) ");
                            pw.print(ent.path);
                        } else {
                            pw.print(",jar,");
                            pw.print(ent.path);
                        }
                    } else if (!checkin) {
                        pw.print("(apk) ");
                        pw.print(ent.apk);
                    } else {
                        pw.print(",apk,");
                        pw.print(ent.apk);
                    }
                    pw.println();
                }
            }
            if (dumpState.isDumping(2) && packageName == null) {
                if (dumpState.onTitlePrinted()) {
                    pw.println();
                }
                if (!checkin) {
                    pw.println("Features:");
                }
                for (String name : this.mAvailableFeatures.keySet()) {
                    if (!checkin) {
                        pw.print("  ");
                    } else {
                        pw.print("feat,");
                    }
                    pw.println(name);
                }
            }
            if (!checkin && dumpState.isDumping(4)) {
                if (this.mActivities.dump(pw, dumpState.getTitlePrinted() ? "\nActivity Resolver Table:" : "Activity Resolver Table:", "  ", packageName, dumpState.isOptionEnabled(1), true)) {
                    dumpState.setTitlePrinted(true);
                }
                if (this.mReceivers.dump(pw, dumpState.getTitlePrinted() ? "\nReceiver Resolver Table:" : "Receiver Resolver Table:", "  ", packageName, dumpState.isOptionEnabled(1), true)) {
                    dumpState.setTitlePrinted(true);
                }
                if (this.mServices.dump(pw, dumpState.getTitlePrinted() ? "\nService Resolver Table:" : "Service Resolver Table:", "  ", packageName, dumpState.isOptionEnabled(1), true)) {
                    dumpState.setTitlePrinted(true);
                }
                if (this.mProviders.dump(pw, dumpState.getTitlePrinted() ? "\nProvider Resolver Table:" : "Provider Resolver Table:", "  ", packageName, dumpState.isOptionEnabled(1), true)) {
                    dumpState.setTitlePrinted(true);
                }
            }
            if (!checkin && dumpState.isDumping(512)) {
                for (int i = 0; i < this.mSettings.mPreferredActivities.size(); ++i) {
                    PreferredIntentResolver pir = this.mSettings.mPreferredActivities.valueAt(i);
                    int user = this.mSettings.mPreferredActivities.keyAt(i);
                    if (!pir.dump(pw, dumpState.getTitlePrinted() ? "\nPreferred Activities User " + user + ":" : "Preferred Activities User " + user + ":", "  ", packageName, true, false)) continue;
                    dumpState.setTitlePrinted(true);
                }
            }
            if (!checkin && dumpState.isDumping(1024)) {
                pw.flush();
                FileOutputStream fout = new FileOutputStream(fd);
                BufferedOutputStream str = new BufferedOutputStream(fout);
                FastXmlSerializer serializer = new FastXmlSerializer();
                try {
                    serializer.setOutput(str, StandardCharsets.UTF_8.name());
                    serializer.startDocument(null, true);
                    serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
                    this.mSettings.writePreferredActivitiesLPr(serializer, 0, fullPreferred);
                    serializer.endDocument();
                    serializer.flush();
                }
                catch (IllegalArgumentException e) {
                    pw.println("Failed writing: " + e);
                }
                catch (IllegalStateException e) {
                    pw.println("Failed writing: " + e);
                }
                catch (IOException e) {
                    pw.println("Failed writing: " + e);
                }
            }
            if (!checkin && dumpState.isDumping(32768) && packageName == null) {
                pw.println();
                int count = this.mSettings.mPackages.size();
                if (count == 0) {
                    pw.println("No applications!");
                    pw.println();
                } else {
                    String prefix = "  ";
                    Collection<PackageSetting> allPackageSettings = this.mSettings.mPackages.values();
                    if (allPackageSettings.size() == 0) {
                        pw.println("No domain preferred apps!");
                        pw.println();
                    } else {
                        pw.println("App verification status:");
                        pw.println();
                        count = 0;
                        for (PackageSetting ps : allPackageSettings) {
                            IntentFilterVerificationInfo ivi = ps.getIntentFilterVerificationInfo();
                            if (ivi == null || ivi.getPackageName() == null) continue;
                            pw.println("  Package: " + ivi.getPackageName());
                            pw.println("  Domains: " + ivi.getDomainsString());
                            pw.println("  Status:  " + ivi.getStatusString());
                            pw.println();
                            ++count;
                        }
                        if (count == 0) {
                            pw.println("  No app verification established.");
                            pw.println();
                        }
                        for (int userId : sUserManager.getUserIds()) {
                            pw.println("App linkages for user " + userId + ":");
                            pw.println();
                            count = 0;
                            for (PackageSetting ps : allPackageSettings) {
                                long status = ps.getDomainVerificationStatusForUser(userId);
                                if (status >> 32 == 0L) continue;
                                pw.println("  Package: " + ps.name);
                                pw.println("  Domains: " + this.dumpDomainString(ps.name));
                                String statusStr = IntentFilterVerificationInfo.getStatusStringFromValue(status);
                                pw.println("  Status:  " + statusStr);
                                pw.println();
                                ++count;
                            }
                            if (count != 0) continue;
                            pw.println("  No configured app linkages.");
                            pw.println();
                        }
                    }
                }
            }
            if (!checkin && dumpState.isDumping(8)) {
                this.mSettings.dumpPermissionsLPr(pw, packageName, permissionNames, dumpState);
                if (packageName == null && permissionNames == null) {
                    for (int iperm = 0; iperm < this.mAppOpPermissionPackages.size(); ++iperm) {
                        if (iperm == 0) {
                            if (dumpState.onTitlePrinted()) {
                                pw.println();
                            }
                            pw.println("AppOp Permissions:");
                        }
                        pw.print("  AppOp Permission ");
                        pw.print(this.mAppOpPermissionPackages.keyAt(iperm));
                        pw.println(":");
                        ArraySet<String> pkgs = this.mAppOpPermissionPackages.valueAt(iperm);
                        for (int ipkg = 0; ipkg < pkgs.size(); ++ipkg) {
                            pw.print("    ");
                            pw.println(pkgs.valueAt(ipkg));
                        }
                    }
                }
            }
            if (!checkin && dumpState.isDumping(128)) {
                boolean printedSomething = false;
                for (PackageParser.Provider p : this.mProviders.mProviders.values()) {
                    if (packageName != null && !packageName.equals(p.info.packageName)) continue;
                    if (!printedSomething) {
                        if (dumpState.onTitlePrinted()) {
                            pw.println();
                        }
                        pw.println("Registered ContentProviders:");
                        printedSomething = true;
                    }
                    pw.print("  ");
                    p.printComponentShortName(pw);
                    pw.println(":");
                    pw.print("    ");
                    pw.println(p.toString());
                }
                printedSomething = false;
                for (Map.Entry entry : this.mProvidersByAuthority.entrySet()) {
                    PackageParser.Provider p = (PackageParser.Provider)entry.getValue();
                    if (packageName != null && !packageName.equals(p.info.packageName)) continue;
                    if (!printedSomething) {
                        if (dumpState.onTitlePrinted()) {
                            pw.println();
                        }
                        pw.println("ContentProvider Authorities:");
                        printedSomething = true;
                    }
                    pw.print("  [");
                    pw.print((String)entry.getKey());
                    pw.println("]:");
                    pw.print("    ");
                    pw.println(p.toString());
                    if (p.info == null || p.info.applicationInfo == null) continue;
                    String appInfo = p.info.applicationInfo.toString();
                    pw.print("      applicationInfo=");
                    pw.println(appInfo);
                }
            }
            if (!checkin && dumpState.isDumping(2048)) {
                this.mSettings.mKeySetManagerService.dumpLPr(pw, packageName, dumpState);
            }
            if (dumpState.isDumping(16)) {
                this.mSettings.dumpPackagesLPr(pw, packageName, permissionNames, dumpState, checkin);
            }
            if (dumpState.isDumping(32)) {
                this.mSettings.dumpSharedUsersLPr(pw, packageName, permissionNames, dumpState, checkin);
            }
            if (!checkin && dumpState.isDumping(8192) && packageName == null) {
                if (dumpState.onTitlePrinted()) {
                    pw.println();
                }
                this.mInstallerService.dump(new IndentingPrintWriter(pw, "  ", 120));
            }
            if (!checkin && dumpState.isDumping(64) && packageName == null) {
                if (dumpState.onTitlePrinted()) {
                    pw.println();
                }
                this.mSettings.dumpReadMessagesLPr(pw, dumpState);
                pw.println();
                pw.println("Package warning messages:");
                BufferedReader in = null;
                line = null;
                try {
                    in = new BufferedReader(new FileReader(PackageManagerService.getSettingsProblemFile()));
                    while ((line = in.readLine()) != null) {
                        if (line.contains("ignored: updated version")) continue;
                        pw.println(line);
                    }
                }
                catch (IOException ignored) {
                    IoUtils.closeQuietly(in);
                    catch (Throwable throwable) {
                        IoUtils.closeQuietly(in);
                        throw throwable;
                    }
                }
                IoUtils.closeQuietly(in);
            }
            if (checkin && dumpState.isDumping(64)) {
                BufferedReader in = null;
                line = null;
                try {
                    in = new BufferedReader(new FileReader(PackageManagerService.getSettingsProblemFile()));
                    while ((line = in.readLine()) != null) {
                        if (line.contains("ignored: updated version")) continue;
                        pw.print("msg,");
                        pw.println(line);
                    }
                }
                catch (IOException ignored) {
                    IoUtils.closeQuietly(in);
                    catch (Throwable throwable) {
                        IoUtils.closeQuietly(in);
                        throw throwable;
                    }
                }
                IoUtils.closeQuietly(in);
            }
        }
    }

    private String dumpDomainString(String packageName) {
        List<IntentFilterVerificationInfo> iviList = this.getIntentFilterVerifications(packageName);
        List<IntentFilter> filters = this.getAllIntentFilters(packageName);
        ArraySet<String> result = new ArraySet<String>();
        if (iviList.size() > 0) {
            for (IntentFilterVerificationInfo ivi : iviList) {
                for (String host : ivi.getDomains()) {
                    result.add(host);
                }
            }
        }
        if (filters != null && filters.size() > 0) {
            for (IntentFilter filter : filters) {
                if (!filter.hasCategory("android.intent.category.BROWSABLE") || !filter.hasDataScheme("http") && !filter.hasDataScheme("https")) continue;
                result.addAll(filter.getHostsList());
            }
        }
        StringBuilder sb = new StringBuilder(result.size() * 16);
        for (String domain : result) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(domain);
        }
        return sb.toString();
    }

    static String getEncryptKey() {
        try {
            String sdEncKey = SystemKeyStore.getInstance().retrieveKeyHexString(SD_ENCRYPTION_KEYSTORE_NAME);
            if (sdEncKey == null && (sdEncKey = SystemKeyStore.getInstance().generateNewKeyHexString(128, SD_ENCRYPTION_ALGORITHM, SD_ENCRYPTION_KEYSTORE_NAME)) == null) {
                Slog.e(TAG, "Failed to create encryption keys");
                return null;
            }
            return sdEncKey;
        }
        catch (NoSuchAlgorithmException nsae) {
            Slog.e(TAG, "Failed to create encryption keys with exception: " + nsae);
            return null;
        }
        catch (IOException ioe) {
            Slog.e(TAG, "Failed to retrieve encryption keys with exception: " + ioe);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateExternalMediaStatus(final boolean mediaStatus, final boolean reportStatus) {
        int callingUid = Binder.getCallingUid();
        if (callingUid != 0 && callingUid != 1000) {
            throw new SecurityException("Media status can only be updated by the system");
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            Log.i(TAG, "Updating external media status from " + (this.mMediaMounted ? "mounted" : "unmounted") + " to " + (mediaStatus ? "mounted" : "unmounted"));
            if (mediaStatus == this.mMediaMounted) {
                Message msg = this.mHandler.obtainMessage(12, reportStatus ? 1 : 0, -1);
                this.mHandler.sendMessage(msg);
                return;
            }
            this.mMediaMounted = mediaStatus;
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                PackageManagerService.this.updateExternalMediaStatusInner(mediaStatus, reportStatus, true);
            }
        });
    }

    public void scanAvailableAsecs() {
        this.updateExternalMediaStatusInner(true, false, false);
        if (this.mShouldRestoreconData) {
            SELinuxMMAC.setRestoreconDone();
            this.mShouldRestoreconData = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateExternalMediaStatusInner(boolean isMounted, boolean reportStatus, boolean externalStorage) {
        ArrayMap<AsecInstallArgs, String> processCids = new ArrayMap<AsecInstallArgs, String>();
        int[] uidArr = EmptyArray.INT;
        String[] list = PackageHelper.getSecureContainerList();
        if (ArrayUtils.isEmpty(list)) {
            Log.i(TAG, "No secure containers found");
        } else {
            ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
            synchronized (arrayMap) {
                for (String cid : list) {
                    if (PackageInstallerService.isStageName(cid)) continue;
                    String pkgName = PackageManagerService.getAsecPackageName(cid);
                    if (pkgName == null) {
                        Slog.i(TAG, "Found stale container " + cid + " with no package name");
                        continue;
                    }
                    PackageSetting ps = this.mSettings.mPackages.get(pkgName);
                    if (ps == null) {
                        Slog.i(TAG, "Found stale container " + cid + " with no matching settings");
                        continue;
                    }
                    if (externalStorage && !isMounted && !PackageManagerService.isExternal(ps)) continue;
                    AsecInstallArgs args = new AsecInstallArgs(cid, InstructionSets.getAppDexInstructionSets(ps), ps.isForwardLocked());
                    if (ps.codePathString != null && ps.codePathString.startsWith(args.getCodePath())) {
                        processCids.put(args, ps.codePathString);
                        int uid = ps.appId;
                        if (uid == -1) continue;
                        uidArr = ArrayUtils.appendInt(uidArr, uid);
                        continue;
                    }
                    Slog.i(TAG, "Found stale container " + cid + ": expected codePath=" + ps.codePathString);
                }
            }
            Arrays.sort(uidArr);
        }
        if (isMounted) {
            this.loadMediaPackages(processCids, uidArr);
            this.startCleaningPackages();
            this.mInstallerService.onSecureContainersAvailable();
        } else {
            this.unloadMediaPackages(processCids, uidArr, reportStatus);
        }
    }

    private void sendResourcesChangedBroadcast(boolean mediaStatus, boolean replacing, ArrayList<ApplicationInfo> infos, IIntentReceiver finishedReceiver) {
        int size = infos.size();
        String[] packageNames = new String[size];
        int[] packageUids = new int[size];
        for (int i = 0; i < size; ++i) {
            ApplicationInfo info = infos.get(i);
            packageNames[i] = info.packageName;
            packageUids[i] = info.uid;
        }
        this.sendResourcesChangedBroadcast(mediaStatus, replacing, packageNames, packageUids, finishedReceiver);
    }

    private void sendResourcesChangedBroadcast(boolean mediaStatus, boolean replacing, ArrayList<String> pkgList, int[] uidArr, IIntentReceiver finishedReceiver) {
        this.sendResourcesChangedBroadcast(mediaStatus, replacing, pkgList.toArray(new String[pkgList.size()]), uidArr, finishedReceiver);
    }

    private void sendResourcesChangedBroadcast(boolean mediaStatus, boolean replacing, String[] pkgList, int[] uidArr, IIntentReceiver finishedReceiver) {
        int size = pkgList.length;
        if (size > 0) {
            Bundle extras = new Bundle();
            extras.putStringArray("android.intent.extra.changed_package_list", pkgList);
            if (uidArr != null) {
                extras.putIntArray("android.intent.extra.changed_uid_list", uidArr);
            }
            if (replacing) {
                extras.putBoolean("android.intent.extra.REPLACING", replacing);
            }
            String action = mediaStatus ? "android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE" : "android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE";
            this.sendPackageBroadcast(action, null, extras, null, finishedReceiver, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMediaPackages(ArrayMap<AsecInstallArgs, String> processCids, int[] uidArr) {
        ArrayList<String> pkgList = new ArrayList<String>();
        Set<AsecInstallArgs> keys = processCids.keySet();
        for (AsecInstallArgs args : keys) {
            String codePath = processCids.get(args);
            int retCode = -18;
            try {
                if (args.doPreInstall(1) != 1) {
                    Slog.e(TAG, "Failed to mount cid : " + args.cid + " when installing from sdcard");
                    continue;
                }
                if (codePath == null || !codePath.startsWith(args.getCodePath())) {
                    Slog.e(TAG, "Container " + args.cid + " cachepath " + args.getCodePath() + " does not match one in settings " + codePath);
                    continue;
                }
                int parseFlags = this.mDefParseFlags;
                if (args.isExternalAsec()) {
                    parseFlags |= 0x20;
                }
                if (args.isFwdLocked()) {
                    parseFlags |= 0x10;
                }
                Object object = this.mInstallLock;
                synchronized (object) {
                    PackageParser.Package pkg = null;
                    try {
                        pkg = this.scanPackageLI(new File(codePath), parseFlags, 0, 0L, null);
                    }
                    catch (PackageManagerException e) {
                        Slog.w(TAG, "Failed to scan " + codePath + ": " + e.getMessage());
                    }
                    if (pkg != null) {
                        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
                        synchronized (arrayMap) {
                            retCode = 1;
                            pkgList.add(pkg.packageName);
                            args.doPostInstall(1, pkg.applicationInfo.uid);
                        }
                    } else {
                        Slog.i(TAG, "Failed to install pkg from  " + codePath + " from sdcard");
                    }
                }
            }
            finally {
                if (retCode == 1) continue;
                Log.w(TAG, "Container " + args.cid + " is stale, retCode=" + retCode);
            }
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            Settings.VersionInfo ver = this.mSettings.getExternalVersion();
            int updateFlags = 1;
            if (ver.sdkVersion != this.mSdkVersion) {
                PackageManagerService.logCriticalInfo(4, "Platform changed from " + ver.sdkVersion + " to " + this.mSdkVersion + "; regranting permissions for external");
                updateFlags |= 6;
            }
            this.updatePermissionsLPw(null, null, updateFlags);
            ver.forceCurrent();
            this.mSettings.writeLPr();
        }
        if (pkgList.size() > 0) {
            this.sendResourcesChangedBroadcast(true, false, pkgList, uidArr, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unloadAllContainers(Set<AsecInstallArgs> cidArgs) {
        for (AsecInstallArgs arg : cidArgs) {
            Object object = this.mInstallLock;
            synchronized (object) {
                arg.doPostDeleteLI(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unloadMediaPackages(ArrayMap<AsecInstallArgs, String> processCids, int[] uidArr, final boolean reportStatus) {
        ArrayList<String> pkgList = new ArrayList<String>();
        ArrayList<AsecInstallArgs> failedList = new ArrayList<AsecInstallArgs>();
        final Set<AsecInstallArgs> keys = processCids.keySet();
        for (AsecInstallArgs args : keys) {
            String pkgName = args.getPackageName();
            PackageRemovedInfo outInfo = new PackageRemovedInfo();
            Object object = this.mInstallLock;
            synchronized (object) {
                boolean res = this.deletePackageLI(pkgName, null, false, null, null, 1, outInfo, false);
                if (res) {
                    pkgList.add(pkgName);
                } else {
                    Slog.e(TAG, "Failed to delete pkg from sdcard : " + pkgName);
                    failedList.add(args);
                }
            }
        }
        ArrayMap<String, PackageParser.Package> i$ = this.mPackages;
        synchronized (i$) {
            this.mSettings.writeLPr();
        }
        if (pkgList.size() > 0) {
            this.sendResourcesChangedBroadcast(false, false, pkgList, uidArr, (IIntentReceiver)new IIntentReceiver.Stub(){

                @Override
                public void performReceive(Intent intent, int resultCode, String data, Bundle extras, boolean ordered, boolean sticky, int sendingUser) throws RemoteException {
                    Message msg = PackageManagerService.this.mHandler.obtainMessage(12, reportStatus ? 1 : 0, 1, keys);
                    PackageManagerService.this.mHandler.sendMessage(msg);
                }
            });
        } else {
            Message msg = this.mHandler.obtainMessage(12, reportStatus ? 1 : 0, -1, keys);
            this.mHandler.sendMessage(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPrivatePackages(VolumeInfo vol) {
        ArrayList<ApplicationInfo> loaded = new ArrayList<ApplicationInfo>();
        int parseFlags = this.mDefParseFlags | 0x20;
        Object object = this.mInstallLock;
        synchronized (object) {
            ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
            synchronized (arrayMap) {
                Settings.VersionInfo ver = this.mSettings.findOrCreateVersion(vol.fsUuid);
                List<PackageSetting> packages = this.mSettings.getVolumePackagesLPr(vol.fsUuid);
                for (PackageSetting ps : packages) {
                    try {
                        PackageParser.Package pkg = this.scanPackageLI(ps.codePath, parseFlags, 16384, 0L, null);
                        loaded.add(pkg.applicationInfo);
                    }
                    catch (PackageManagerException e) {
                        Slog.w(TAG, "Failed to scan " + ps.codePath + ": " + e.getMessage());
                    }
                    if (Build.FINGERPRINT.equals(ver.fingerprint)) continue;
                    this.deleteCodeCacheDirsLI(ps.volumeUuid, ps.name);
                }
                int updateFlags = 1;
                if (ver.sdkVersion != this.mSdkVersion) {
                    PackageManagerService.logCriticalInfo(4, "Platform changed from " + ver.sdkVersion + " to " + this.mSdkVersion + "; regranting permissions for " + vol.fsUuid);
                    updateFlags |= 6;
                }
                this.updatePermissionsLPw(null, null, updateFlags);
                ver.forceCurrent();
                this.mSettings.writeLPr();
            }
        }
        this.sendResourcesChangedBroadcast(true, false, loaded, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unloadPrivatePackages(VolumeInfo vol) {
        ArrayList<ApplicationInfo> unloaded = new ArrayList<ApplicationInfo>();
        Object object = this.mInstallLock;
        synchronized (object) {
            ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
            synchronized (arrayMap) {
                List<PackageSetting> packages = this.mSettings.getVolumePackagesLPr(vol.fsUuid);
                for (PackageSetting ps : packages) {
                    if (ps.pkg == null) continue;
                    ApplicationInfo info = ps.pkg.applicationInfo;
                    PackageRemovedInfo outInfo = new PackageRemovedInfo();
                    if (this.deletePackageLI(ps.name, null, false, null, null, 1, outInfo, false)) {
                        unloaded.add(info);
                        continue;
                    }
                    Slog.w(TAG, "Failed to unload " + ps.codePath);
                }
                this.mSettings.writeLPr();
            }
        }
        this.sendResourcesChangedBroadcast(false, false, unloaded, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconcileUsers(String volumeUuid) {
        File[] files;
        for (File file : files = FileUtils.listFilesOrEmpty(Environment.getDataUserDirectory(volumeUuid))) {
            UserInfo info;
            int userId;
            if (!file.isDirectory()) continue;
            try {
                userId = Integer.parseInt(file.getName());
                info = sUserManager.getUserInfo(userId);
            }
            catch (NumberFormatException e) {
                Slog.w(TAG, "Invalid user directory " + file);
                continue;
            }
            boolean destroyUser = false;
            if (info == null) {
                PackageManagerService.logCriticalInfo(5, "Destroying user directory " + file + " because no matching user was found");
                destroyUser = true;
            } else {
                try {
                    UserManagerService.enforceSerialNumber(file, info.serialNumber);
                }
                catch (IOException e) {
                    PackageManagerService.logCriticalInfo(5, "Destroying user directory " + file + " because we failed to enforce serial number: " + e);
                    destroyUser = true;
                }
            }
            if (!destroyUser) continue;
            Object object = this.mInstallLock;
            synchronized (object) {
                this.mInstaller.removeUserDataDirs(volumeUuid, userId);
            }
        }
        UserManager um = this.mContext.getSystemService(UserManager.class);
        for (UserInfo user : um.getUsers()) {
            File userDir = Environment.getDataUserDirectory(volumeUuid, user.id);
            if (userDir.exists()) continue;
            try {
                UserManagerService.prepareUserDirectory(userDir);
                UserManagerService.enforceSerialNumber(userDir, user.serialNumber);
            }
            catch (IOException e) {
                Log.wtf(TAG, "Failed to create user directory on " + volumeUuid, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconcileApps(String volumeUuid) {
        File[] files;
        for (File file : files = FileUtils.listFilesOrEmpty(Environment.getDataAppDirectory(volumeUuid))) {
            boolean isPackage;
            boolean bl = isPackage = (PackageParser.isApkFile(file) || file.isDirectory()) && !PackageInstallerService.isStageName(file.getName());
            if (!isPackage) continue;
            boolean destroyApp = false;
            String packageName = null;
            try {
                PackageParser.PackageLite pkg = PackageParser.parsePackageLite(file, 4);
                packageName = pkg.packageName;
                ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
                synchronized (arrayMap) {
                    PackageSetting ps = this.mSettings.mPackages.get(packageName);
                    if (ps == null) {
                        PackageManagerService.logCriticalInfo(5, "Destroying " + packageName + " on + " + volumeUuid + " because we found no install record");
                        destroyApp = true;
                    } else if (!TextUtils.equals(volumeUuid, ps.volumeUuid)) {
                        PackageManagerService.logCriticalInfo(5, "Destroying " + packageName + " on " + volumeUuid + " because we expected it on " + ps.volumeUuid);
                        destroyApp = true;
                    }
                }
            }
            catch (PackageParser.PackageParserException e) {
                PackageManagerService.logCriticalInfo(5, "Destroying " + file + " due to parse failure: " + e);
                destroyApp = true;
            }
            if (!destroyApp) continue;
            Object object = this.mInstallLock;
            synchronized (object) {
                if (packageName != null) {
                    this.removeDataDirsLI(volumeUuid, packageName);
                }
                if (file.isDirectory()) {
                    this.mInstaller.rmPackageDir(file.getAbsolutePath());
                } else {
                    file.delete();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unfreezePackage(String packageName) {
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageSetting ps = this.mSettings.mPackages.get(packageName);
            if (ps != null) {
                ps.frozen = false;
            }
        }
    }

    @Override
    public int movePackage(String packageName, String volumeUuid) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MOVE_PACKAGE", null);
        int moveId = this.mNextMoveId.getAndIncrement();
        try {
            this.movePackageInternal(packageName, volumeUuid, moveId);
        }
        catch (PackageManagerException e) {
            Slog.w(TAG, "Failed to move " + packageName, e);
            this.mMoveCallbacks.notifyStatusChanged(moveId, -6);
        }
        return moveId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void movePackageInternal(final String packageName, String volumeUuid, final int moveId) throws PackageManagerException {
        MoveInfo move;
        File measurePath;
        boolean moveCompleteApp;
        int installFlags;
        String label;
        String seinfo;
        int appId;
        String packageAbiOverride;
        String installerPackageName;
        File codeFile;
        String currentVolumeUuid;
        boolean currentAsec;
        UserHandle user = new UserHandle(UserHandle.getCallingUserId());
        StorageManager storage = this.mContext.getSystemService(StorageManager.class);
        PackageManager pm = this.mContext.getPackageManager();
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageParser.Package pkg = this.mPackages.get(packageName);
            PackageSetting ps = this.mSettings.mPackages.get(packageName);
            if (pkg == null || ps == null) {
                throw new PackageManagerException(-2, "Missing package");
            }
            if (pkg.applicationInfo.isSystemApp()) {
                throw new PackageManagerException(-3, "Cannot move system application");
            }
            if (pkg.applicationInfo.isExternalAsec()) {
                currentAsec = true;
                currentVolumeUuid = "primary_physical";
            } else if (pkg.applicationInfo.isForwardLocked()) {
                currentAsec = true;
                currentVolumeUuid = "forward_locked";
            } else {
                currentAsec = false;
                currentVolumeUuid = ps.volumeUuid;
                File probe = new File(pkg.codePath);
                File probeOat = new File(probe, "oat");
                if (!probe.isDirectory() || !probeOat.isDirectory()) {
                    throw new PackageManagerException(-6, "Move only supported for modern cluster style installs");
                }
            }
            if (Objects.equals(currentVolumeUuid, volumeUuid)) {
                throw new PackageManagerException(-6, "Package already moved to " + volumeUuid);
            }
            if (ps.frozen) {
                throw new PackageManagerException(-7, "Failed to move already frozen package");
            }
            ps.frozen = true;
            codeFile = new File(pkg.codePath);
            installerPackageName = ps.installerPackageName;
            packageAbiOverride = ps.cpuAbiOverrideString;
            appId = UserHandle.getAppId(pkg.applicationInfo.uid);
            seinfo = pkg.applicationInfo.seinfo;
            label = String.valueOf(pm.getApplicationLabel(pkg.applicationInfo));
        }
        long token = Binder.clearCallingIdentity();
        try {
            this.killApplication(packageName, appId, "move pkg");
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
        Bundle extras = new Bundle();
        extras.putString("android.intent.extra.PACKAGE_NAME", packageName);
        extras.putString("android.intent.extra.TITLE", label);
        this.mMoveCallbacks.notifyCreated(moveId, extras);
        if (Objects.equals(StorageManager.UUID_PRIVATE_INTERNAL, volumeUuid)) {
            installFlags = 16;
            moveCompleteApp = !currentAsec;
            measurePath = Environment.getDataAppDirectory(volumeUuid);
        } else if (Objects.equals("primary_physical", volumeUuid)) {
            installFlags = 8;
            moveCompleteApp = false;
            measurePath = storage.getPrimaryPhysicalVolume().getPath();
        } else {
            VolumeInfo volume = storage.findVolumeByUuid(volumeUuid);
            if (volume == null || volume.getType() != 1 || !volume.isMountedWritable()) {
                this.unfreezePackage(packageName);
                throw new PackageManagerException(-6, "Move location not mounted private volume");
            }
            Preconditions.checkState(!currentAsec);
            installFlags = 16;
            moveCompleteApp = true;
            measurePath = Environment.getDataAppDirectory(volumeUuid);
        }
        PackageStats stats = new PackageStats(null, -1);
        Installer installer = this.mInstaller;
        synchronized (installer) {
            if (!this.getPackageSizeInfoLI(packageName, -1, stats)) {
                this.unfreezePackage(packageName);
                throw new PackageManagerException(-6, "Failed to measure package size");
            }
        }
        final long startFreeBytes = measurePath.getFreeSpace();
        final long sizeBytes = moveCompleteApp ? stats.codeSize + stats.dataSize : stats.codeSize;
        if (sizeBytes > storage.getStorageBytesUntilLow(measurePath)) {
            this.unfreezePackage(packageName);
            throw new PackageManagerException(-6, "Not enough free space to move");
        }
        this.mMoveCallbacks.notifyStatusChanged(moveId, 10);
        final CountDownLatch installedLatch = new CountDownLatch(1);
        IPackageInstallObserver2.Stub installObserver = new IPackageInstallObserver2.Stub(){

            @Override
            public void onUserActionRequired(Intent intent) throws RemoteException {
                throw new IllegalStateException();
            }

            @Override
            public void onPackageInstalled(String basePackageName, int returnCode, String msg, Bundle extras) throws RemoteException {
                installedLatch.countDown();
                PackageManagerService.this.unfreezePackage(packageName);
                int status = PackageManager.installStatusToPublicStatus(returnCode);
                switch (status) {
                    case 0: {
                        PackageManagerService.this.mMoveCallbacks.notifyStatusChanged(moveId, -100);
                        break;
                    }
                    case 6: {
                        PackageManagerService.this.mMoveCallbacks.notifyStatusChanged(moveId, -1);
                        break;
                    }
                    default: {
                        PackageManagerService.this.mMoveCallbacks.notifyStatusChanged(moveId, -6);
                    }
                }
            }
        };
        if (moveCompleteApp) {
            new Thread(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            if (installedLatch.await(1L, TimeUnit.SECONDS)) {
                                break;
                            }
                        }
                        catch (InterruptedException ignored) {
                            // empty catch block
                        }
                        long deltaFreeBytes = startFreeBytes - measurePath.getFreeSpace();
                        int progress = 10 + (int)MathUtils.constrain(deltaFreeBytes * 80L / sizeBytes, 0L, 80L);
                        PackageManagerService.this.mMoveCallbacks.notifyStatusChanged(moveId, progress);
                    }
                }
            }.start();
            String dataAppName = codeFile.getName();
            move = new MoveInfo(moveId, currentVolumeUuid, volumeUuid, packageName, dataAppName, appId, seinfo);
        } else {
            move = null;
        }
        Message msg = this.mHandler.obtainMessage(5);
        OriginInfo origin = OriginInfo.fromExistingFile(codeFile);
        msg.obj = new InstallParams(origin, move, installObserver, installFlags |= 2, installerPackageName, volumeUuid, null, user, packageAbiOverride, null);
        this.mHandler.sendMessage(msg);
    }

    @Override
    public int movePrimaryStorage(String volumeUuid) throws RemoteException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MOVE_PACKAGE", null);
        final int realMoveId = this.mNextMoveId.getAndIncrement();
        Bundle extras = new Bundle();
        extras.putString("android.os.storage.extra.FS_UUID", volumeUuid);
        this.mMoveCallbacks.notifyCreated(realMoveId, extras);
        IPackageMoveObserver.Stub callback = new IPackageMoveObserver.Stub(){

            @Override
            public void onCreated(int moveId, Bundle extras) {
            }

            @Override
            public void onStatusChanged(int moveId, int status, long estMillis) {
                PackageManagerService.this.mMoveCallbacks.notifyStatusChanged(realMoveId, status, estMillis);
            }
        };
        StorageManager storage = this.mContext.getSystemService(StorageManager.class);
        storage.setPrimaryStorageUuid(volumeUuid, callback);
        return realMoveId;
    }

    @Override
    public int getMoveStatus(int moveId) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MOUNT_UNMOUNT_FILESYSTEMS", null);
        return this.mMoveCallbacks.mLastStatus.get(moveId);
    }

    @Override
    public void registerMoveCallback(IPackageMoveObserver callback) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MOUNT_UNMOUNT_FILESYSTEMS", null);
        this.mMoveCallbacks.register(callback);
    }

    @Override
    public void unregisterMoveCallback(IPackageMoveObserver callback) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MOUNT_UNMOUNT_FILESYSTEMS", null);
        this.mMoveCallbacks.unregister(callback);
    }

    @Override
    public boolean setInstallLocation(int loc) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.WRITE_SECURE_SETTINGS", null);
        if (this.getInstallLocation() == loc) {
            return true;
        }
        if (loc == 0 || loc == 1 || loc == 2) {
            Settings.Global.putInt(this.mContext.getContentResolver(), "default_install_location", loc);
            return true;
        }
        return false;
    }

    @Override
    public int getInstallLocation() {
        return Settings.Global.getInt(this.mContext.getContentResolver(), "default_install_location", 0);
    }

    void cleanUpUserLILPw(UserManagerService userManager, int userHandle) {
        this.mDirtyUsers.remove(userHandle);
        this.mSettings.removeUserLPw(userHandle);
        this.mPendingBroadcasts.remove(userHandle);
        if (this.mInstaller != null) {
            StorageManager storage = this.mContext.getSystemService(StorageManager.class);
            for (VolumeInfo vol : storage.getWritablePrivateVolumes()) {
                String volumeUuid = vol.getFsUuid();
                this.mInstaller.removeUserDataDirs(volumeUuid, userHandle);
            }
        }
        this.mUserNeedsBadging.delete(userHandle);
        this.removeUnusedPackagesLILPw(userManager, userHandle);
    }

    private void removeUnusedPackagesLILPw(UserManagerService userManager, final int userHandle) {
        boolean DEBUG_CLEAN_APKS = false;
        int[] users = userManager.getUserIdsLPr();
        for (PackageSetting ps : this.mSettings.mPackages.values()) {
            if (ps.pkg == null) continue;
            final String packageName = ps.pkg.packageName;
            if ((ps.pkgFlags & 1) != 0) continue;
            boolean keep = false;
            for (int i = 0; i < users.length; ++i) {
                if (users[i] == userHandle || !ps.getInstalled(users[i])) continue;
                keep = true;
                break;
            }
            if (keep) continue;
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    PackageManagerService.this.deletePackageX(packageName, userHandle, 0);
                }
            });
        }
    }

    void createNewUserLILPw(int userHandle) {
        if (this.mInstaller != null) {
            this.mInstaller.createUserConfig(userHandle);
            this.mSettings.createNewUserLILPw(this, this.mInstaller, userHandle);
            this.applyFactoryDefaultBrowserLPw(userHandle);
            this.primeDomainVerificationsLPw(userHandle);
        }
    }

    void newUserCreated(int userHandle) {
        this.mDefaultPermissionPolicy.grantDefaultPermissions(userHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VerifierDeviceIdentity getVerifierDeviceIdentity() throws RemoteException {
        this.mContext.enforceCallingOrSelfPermission("android.permission.PACKAGE_VERIFICATION_AGENT", "Only package verification agents can read the verifier device identity");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            return this.mSettings.getVerifierDeviceIdentityLPw();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPermissionEnforced(String permission2, boolean enforced) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.GRANT_RUNTIME_PERMISSIONS", "setPermissionEnforced");
        if ("android.permission.READ_EXTERNAL_STORAGE".equals(permission2)) {
            ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
            synchronized (arrayMap) {
                if (this.mSettings.mReadExternalStorageEnforced == null || this.mSettings.mReadExternalStorageEnforced != enforced) {
                    this.mSettings.mReadExternalStorageEnforced = enforced;
                    this.mSettings.writeLPr();
                }
            }
            IActivityManager am = ActivityManagerNative.getDefault();
            if (am != null) {
                long token = Binder.clearCallingIdentity();
                try {
                    am.killProcessesBelowForeground("setPermissionEnforcement");
                }
                catch (RemoteException e) {
                }
                finally {
                    Binder.restoreCallingIdentity(token);
                }
            }
        } else {
            throw new IllegalArgumentException("No selective enforcement for " + permission2);
        }
    }

    @Override
    @Deprecated
    public boolean isPermissionEnforced(String permission2) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isStorageLow() {
        long token = Binder.clearCallingIdentity();
        try {
            DeviceStorageMonitorInternal dsm = LocalServices.getService(DeviceStorageMonitorInternal.class);
            if (dsm != null) {
                boolean bl = dsm.isMemoryLow();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    @Override
    public IPackageInstaller getPackageInstaller() {
        return this.mInstallerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean userNeedsBadging(int userId) {
        int index = this.mUserNeedsBadging.indexOfKey(userId);
        if (index < 0) {
            UserInfo userInfo;
            long token = Binder.clearCallingIdentity();
            try {
                userInfo = sUserManager.getUserInfo(userId);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
            boolean b = userInfo != null && userInfo.isManagedProfile();
            this.mUserNeedsBadging.put(userId, b);
            return b;
        }
        return this.mUserNeedsBadging.valueAt(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeySet getKeySetByAlias(String packageName, String alias) {
        if (packageName == null || alias == null) {
            return null;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageParser.Package pkg = this.mPackages.get(packageName);
            if (pkg == null) {
                Slog.w(TAG, "KeySet requested for unknown package:" + packageName);
                throw new IllegalArgumentException("Unknown package: " + packageName);
            }
            KeySetManagerService ksms = this.mSettings.mKeySetManagerService;
            return new KeySet(ksms.getKeySetByAliasAndPackageNameLPr(packageName, alias));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeySet getSigningKeySet(String packageName) {
        if (packageName == null) {
            return null;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageParser.Package pkg = this.mPackages.get(packageName);
            if (pkg == null) {
                Slog.w(TAG, "KeySet requested for unknown package:" + packageName);
                throw new IllegalArgumentException("Unknown package: " + packageName);
            }
            if (pkg.applicationInfo.uid != Binder.getCallingUid() && 1000 != Binder.getCallingUid()) {
                throw new SecurityException("May not access signing KeySet of other apps.");
            }
            KeySetManagerService ksms = this.mSettings.mKeySetManagerService;
            return new KeySet(ksms.getSigningKeySetByPackageNameLPr(packageName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPackageSignedByKeySet(String packageName, KeySet ks) {
        if (packageName == null || ks == null) {
            return false;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageParser.Package pkg = this.mPackages.get(packageName);
            if (pkg == null) {
                Slog.w(TAG, "KeySet requested for unknown package:" + packageName);
                throw new IllegalArgumentException("Unknown package: " + packageName);
            }
            IBinder ksh = ks.getToken();
            if (ksh instanceof KeySetHandle) {
                KeySetManagerService ksms = this.mSettings.mKeySetManagerService;
                return ksms.packageIsSignedByLPr(packageName, (KeySetHandle)ksh);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPackageSignedByKeySetExactly(String packageName, KeySet ks) {
        if (packageName == null || ks == null) {
            return false;
        }
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            PackageParser.Package pkg = this.mPackages.get(packageName);
            if (pkg == null) {
                Slog.w(TAG, "KeySet requested for unknown package:" + packageName);
                throw new IllegalArgumentException("Unknown package: " + packageName);
            }
            IBinder ksh = ks.getToken();
            if (ksh instanceof KeySetHandle) {
                KeySetManagerService ksms = this.mSettings.mKeySetManagerService;
                return ksms.packageIsSignedByExactlyLPr(packageName, (KeySetHandle)ksh);
            }
            return false;
        }
    }

    public void getUsageStatsIfNoPackageUsageInfo() {
        if (!this.mPackageUsage.isHistoricalPackageUsageAvailable()) {
            UsageStatsManager usm = (UsageStatsManager)this.mContext.getSystemService("usagestats");
            if (usm == null) {
                throw new IllegalStateException("UsageStatsManager must be initialized");
            }
            long now = System.currentTimeMillis();
            Map<String, UsageStats> stats = usm.queryAndAggregateUsageStats(now - this.mDexOptLRUThresholdInMills, now);
            for (Map.Entry<String, UsageStats> entry : stats.entrySet()) {
                String packageName = entry.getKey();
                PackageParser.Package pkg = this.mPackages.get(packageName);
                if (pkg == null) continue;
                UsageStats usage = entry.getValue();
                pkg.mLastPackageUsageTimeInMills = usage.getLastTimeUsed();
                this.mPackageUsage.mIsHistoricalPackageUsageAvailable = true;
            }
        }
    }

    private static void checkDowngrade(PackageParser.Package before, PackageInfoLite after) throws PackageManagerException {
        if (after.versionCode < before.mVersionCode) {
            throw new PackageManagerException(-25, "Update version code " + after.versionCode + " is older than current " + before.mVersionCode);
        }
        if (after.versionCode == before.mVersionCode) {
            if (after.baseRevisionCode < before.baseRevisionCode) {
                throw new PackageManagerException(-25, "Update base revision code " + after.baseRevisionCode + " is older than current " + before.baseRevisionCode);
            }
            if (!ArrayUtils.isEmpty(after.splitNames)) {
                for (int i = 0; i < after.splitNames.length; ++i) {
                    String splitName = after.splitNames[i];
                    int j = ArrayUtils.indexOf(before.splitNames, splitName);
                    if (j == -1 || after.splitRevisionCodes[i] >= before.splitRevisionCodes[j]) continue;
                    throw new PackageManagerException(-25, "Update split " + splitName + " revision code " + after.splitRevisionCodes[i] + " is older than current " + before.splitRevisionCodes[j]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantDefaultPermissionsToEnabledCarrierApps(String[] packageNames, int userId) {
        PackageManagerService.enforceSystemOrPhoneCaller("grantPermissionsToEnabledCarrierApps");
        ArrayMap<String, PackageParser.Package> arrayMap = this.mPackages;
        synchronized (arrayMap) {
            long identity = Binder.clearCallingIdentity();
            try {
                this.mDefaultPermissionPolicy.grantDefaultPermissionsToEnabledCarrierAppsLPr(packageNames, userId);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }

    private static void enforceSystemOrPhoneCaller(String tag) {
        int callingUid = Binder.getCallingUid();
        if (callingUid != 1001 && callingUid != 1000) {
            throw new SecurityException("Cannot call " + tag + " from UID " + callingUid);
        }
    }

    static {
        sBrowserIntent.setAction("android.intent.action.VIEW");
        sBrowserIntent.addCategory("android.intent.category.BROWSABLE");
        sBrowserIntent.setData(Uri.parse("http:"));
        mResolvePrioritySorter = new Comparator<ResolveInfo>(){

            @Override
            public int compare(ResolveInfo r1, ResolveInfo r2) {
                int v1 = r1.priority;
                int v2 = r2.priority;
                if (v1 != v2) {
                    return v1 > v2 ? -1 : 1;
                }
                v1 = r1.preferredOrder;
                v2 = r2.preferredOrder;
                if (v1 != v2) {
                    return v1 > v2 ? -1 : 1;
                }
                if (r1.isDefault != r2.isDefault) {
                    return r1.isDefault ? -1 : 1;
                }
                v1 = r1.match;
                v2 = r2.match;
                if (v1 != v2) {
                    return v1 > v2 ? -1 : 1;
                }
                if (r1.system != r2.system) {
                    return r1.system ? -1 : 1;
                }
                return 0;
            }
        };
        mProviderInitOrderSorter = new Comparator<ProviderInfo>(){

            @Override
            public int compare(ProviderInfo p1, ProviderInfo p2) {
                int v1 = p1.initOrder;
                int v2 = p2.initOrder;
                return v1 > v2 ? -1 : (v1 < v2 ? 1 : 0);
            }
        };
    }

    private class PackageManagerInternalImpl
    extends PackageManagerInternal {
        private PackageManagerInternalImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setLocationPackagesProvider(PackageManagerInternal.PackagesProvider provider) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageManagerService.this.mDefaultPermissionPolicy.setLocationPackagesProviderLPw(provider);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setImePackagesProvider(PackageManagerInternal.PackagesProvider provider) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageManagerService.this.mDefaultPermissionPolicy.setImePackagesProviderLPr(provider);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setVoiceInteractionPackagesProvider(PackageManagerInternal.PackagesProvider provider) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageManagerService.this.mDefaultPermissionPolicy.setVoiceInteractionPackagesProviderLPw(provider);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setSmsAppPackagesProvider(PackageManagerInternal.PackagesProvider provider) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageManagerService.this.mDefaultPermissionPolicy.setSmsAppPackagesProviderLPw(provider);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setDialerAppPackagesProvider(PackageManagerInternal.PackagesProvider provider) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageManagerService.this.mDefaultPermissionPolicy.setDialerAppPackagesProviderLPw(provider);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setSimCallManagerPackagesProvider(PackageManagerInternal.PackagesProvider provider) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageManagerService.this.mDefaultPermissionPolicy.setSimCallManagerPackagesProviderLPw(provider);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setSyncAdapterPackagesprovider(PackageManagerInternal.SyncAdapterPackagesProvider provider) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageManagerService.this.mDefaultPermissionPolicy.setSyncAdapterPackagesProviderLPw(provider);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void grantDefaultPermissionsToDefaultSmsApp(String packageName, int userId) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageManagerService.this.mDefaultPermissionPolicy.grantDefaultPermissionsToDefaultSmsAppLPr(packageName, userId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void grantDefaultPermissionsToDefaultDialerApp(String packageName, int userId) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageManagerService.this.mDefaultPermissionPolicy.grantDefaultPermissionsToDefaultDialerAppLPr(packageName, userId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void grantDefaultPermissionsToDefaultSimCallManager(String packageName, int userId) {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageManagerService.this.mDefaultPermissionPolicy.grantDefaultPermissionsToDefaultSimCallManagerLPr(packageName, userId);
            }
        }
    }

    private final class OnPermissionChangeListeners
    extends Handler {
        private static final int MSG_ON_PERMISSIONS_CHANGED = 1;
        private final RemoteCallbackList<IOnPermissionsChangeListener> mPermissionListeners;

        public OnPermissionChangeListeners(Looper looper) {
            super(looper);
            this.mPermissionListeners = new RemoteCallbackList();
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    int uid = msg.arg1;
                    this.handleOnPermissionsChanged(uid);
                }
            }
        }

        public void addListenerLocked(IOnPermissionsChangeListener listener) {
            this.mPermissionListeners.register(listener);
        }

        public void removeListenerLocked(IOnPermissionsChangeListener listener) {
            this.mPermissionListeners.unregister(listener);
        }

        public void onPermissionsChanged(int uid) {
            if (this.mPermissionListeners.getRegisteredCallbackCount() > 0) {
                this.obtainMessage(1, uid, 0).sendToTarget();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleOnPermissionsChanged(int uid) {
            int count = this.mPermissionListeners.beginBroadcast();
            try {
                for (int i = 0; i < count; ++i) {
                    IOnPermissionsChangeListener callback = this.mPermissionListeners.getBroadcastItem(i);
                    try {
                        callback.onPermissionsChanged(uid);
                        continue;
                    }
                    catch (RemoteException e) {
                        Log.e(PackageManagerService.TAG, "Permission listener is dead", e);
                    }
                }
            }
            finally {
                this.mPermissionListeners.finishBroadcast();
            }
        }
    }

    private static class MoveCallbacks
    extends Handler {
        private static final int MSG_CREATED = 1;
        private static final int MSG_STATUS_CHANGED = 2;
        private final RemoteCallbackList<IPackageMoveObserver> mCallbacks = new RemoteCallbackList();
        private final SparseIntArray mLastStatus = new SparseIntArray();

        public MoveCallbacks(Looper looper) {
            super(looper);
        }

        public void register(IPackageMoveObserver callback) {
            this.mCallbacks.register(callback);
        }

        public void unregister(IPackageMoveObserver callback) {
            this.mCallbacks.unregister(callback);
        }

        @Override
        public void handleMessage(Message msg) {
            SomeArgs args = (SomeArgs)msg.obj;
            int n = this.mCallbacks.beginBroadcast();
            for (int i = 0; i < n; ++i) {
                IPackageMoveObserver callback = this.mCallbacks.getBroadcastItem(i);
                try {
                    this.invokeCallback(callback, msg.what, args);
                    continue;
                }
                catch (RemoteException ignored) {
                    // empty catch block
                }
            }
            this.mCallbacks.finishBroadcast();
            args.recycle();
        }

        private void invokeCallback(IPackageMoveObserver callback, int what, SomeArgs args) throws RemoteException {
            switch (what) {
                case 1: {
                    callback.onCreated(args.argi1, (Bundle)args.arg2);
                    break;
                }
                case 2: {
                    callback.onStatusChanged(args.argi1, args.argi2, (Long)args.arg3);
                }
            }
        }

        private void notifyCreated(int moveId, Bundle extras) {
            Slog.v(PackageManagerService.TAG, "Move " + moveId + " created " + extras.toString());
            SomeArgs args = SomeArgs.obtain();
            args.argi1 = moveId;
            args.arg2 = extras;
            this.obtainMessage(1, args).sendToTarget();
        }

        private void notifyStatusChanged(int moveId, int status) {
            this.notifyStatusChanged(moveId, status, -1L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyStatusChanged(int moveId, int status, long estMillis) {
            Slog.v(PackageManagerService.TAG, "Move " + moveId + " status " + status);
            SomeArgs args = SomeArgs.obtain();
            args.argi1 = moveId;
            args.argi2 = status;
            args.arg3 = estMillis;
            this.obtainMessage(2, args).sendToTarget();
            SparseIntArray sparseIntArray = this.mLastStatus;
            synchronized (sparseIntArray) {
                this.mLastStatus.put(moveId, status);
            }
        }
    }

    static class DumpState {
        public static final int DUMP_LIBS = 1;
        public static final int DUMP_FEATURES = 2;
        public static final int DUMP_RESOLVERS = 4;
        public static final int DUMP_PERMISSIONS = 8;
        public static final int DUMP_PACKAGES = 16;
        public static final int DUMP_SHARED_USERS = 32;
        public static final int DUMP_MESSAGES = 64;
        public static final int DUMP_PROVIDERS = 128;
        public static final int DUMP_VERIFIERS = 256;
        public static final int DUMP_PREFERRED = 512;
        public static final int DUMP_PREFERRED_XML = 1024;
        public static final int DUMP_KEYSETS = 2048;
        public static final int DUMP_VERSION = 4096;
        public static final int DUMP_INSTALLS = 8192;
        public static final int DUMP_INTENT_FILTER_VERIFIERS = 16384;
        public static final int DUMP_DOMAIN_PREFERRED = 32768;
        public static final int OPTION_SHOW_FILTERS = 1;
        private int mTypes;
        private int mOptions;
        private boolean mTitlePrinted;
        private SharedUserSetting mSharedUser;

        DumpState() {
        }

        public boolean isDumping(int type) {
            if (this.mTypes == 0 && type != 1024) {
                return true;
            }
            return (this.mTypes & type) != 0;
        }

        public void setDump(int type) {
            this.mTypes |= type;
        }

        public boolean isOptionEnabled(int option) {
            return (this.mOptions & option) != 0;
        }

        public void setOptionEnabled(int option) {
            this.mOptions |= option;
        }

        public boolean onTitlePrinted() {
            boolean printed = this.mTitlePrinted;
            this.mTitlePrinted = true;
            return printed;
        }

        public boolean getTitlePrinted() {
            return this.mTitlePrinted;
        }

        public void setTitlePrinted(boolean enabled) {
            this.mTitlePrinted = enabled;
        }

        public SharedUserSetting getSharedUser() {
            return this.mSharedUser;
        }

        public void setSharedUser(SharedUserSetting user) {
            this.mSharedUser = user;
        }
    }

    private static interface BlobXmlRestorer {
        public void apply(XmlPullParser var1, int var2) throws IOException, XmlPullParserException;
    }

    private final class ClearStorageConnection
    implements ServiceConnection {
        IMediaContainerService mContainerService;

        private ClearStorageConnection() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            ClearStorageConnection clearStorageConnection = this;
            synchronized (clearStorageConnection) {
                this.mContainerService = IMediaContainerService.Stub.asInterface(service);
                this.notifyAll();
            }
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
        }
    }

    class PackageRemovedInfo {
        String removedPackage;
        int uid = -1;
        int removedAppId = -1;
        int[] removedUsers = null;
        boolean isRemovedPackageSystemUpdate = false;
        InstallArgs args = null;

        PackageRemovedInfo() {
        }

        void sendBroadcast(boolean fullRemove, boolean replacing, boolean removedForAllUsers) {
            Bundle extras = new Bundle(1);
            extras.putInt("android.intent.extra.UID", this.removedAppId >= 0 ? this.removedAppId : this.uid);
            extras.putBoolean("android.intent.extra.DATA_REMOVED", fullRemove);
            if (replacing) {
                extras.putBoolean("android.intent.extra.REPLACING", true);
            }
            extras.putBoolean("android.intent.extra.REMOVED_FOR_ALL_USERS", removedForAllUsers);
            if (this.removedPackage != null) {
                PackageManagerService.this.sendPackageBroadcast("android.intent.action.PACKAGE_REMOVED", this.removedPackage, extras, null, null, this.removedUsers);
                if (fullRemove && !replacing) {
                    PackageManagerService.this.sendPackageBroadcast("android.intent.action.PACKAGE_FULLY_REMOVED", this.removedPackage, extras, null, null, this.removedUsers);
                }
            }
            if (this.removedAppId >= 0) {
                PackageManagerService.this.sendPackageBroadcast("android.intent.action.UID_REMOVED", null, extras, null, null, this.removedUsers);
            }
        }
    }

    class PackageInstalledInfo {
        String name;
        int uid;
        int[] origUsers;
        int[] newUsers;
        PackageParser.Package pkg;
        int returnCode;
        String returnMsg;
        PackageRemovedInfo removedInfo;
        String origPackage;
        String origPermission;

        PackageInstalledInfo() {
        }

        public void setError(int code, String msg) {
            this.returnCode = code;
            this.returnMsg = msg;
            Slog.w(PackageManagerService.TAG, msg);
        }

        public void setError(String msg, PackageParser.PackageParserException e) {
            this.returnCode = e.error;
            this.returnMsg = ExceptionUtils.getCompleteMessage(msg, e);
            Slog.w(PackageManagerService.TAG, msg, e);
        }

        public void setError(String msg, PackageManagerException e) {
            this.returnCode = e.error;
            this.returnMsg = ExceptionUtils.getCompleteMessage(msg, e);
            Slog.w(PackageManagerService.TAG, msg, e);
        }
    }

    class MoveInstallArgs
    extends InstallArgs {
        private File codeFile;
        private File resourceFile;

        MoveInstallArgs(InstallParams params) {
            super(params.origin, params.move, params.observer, params.installFlags, params.installerPackageName, params.volumeUuid, params.getManifestDigest(), params.getUser(), null, params.packageAbiOverride, params.grantedRuntimePermissions);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        int copyApk(IMediaContainerService imcs, boolean temp) {
            Installer installer = PackageManagerService.this.mInstaller;
            synchronized (installer) {
                if (PackageManagerService.this.mInstaller.copyCompleteApp(this.move.fromUuid, this.move.toUuid, this.move.packageName, this.move.dataAppName, this.move.appId, this.move.seinfo) != 0) {
                    return -110;
                }
            }
            this.resourceFile = this.codeFile = new File(Environment.getDataAppDirectory(this.move.toUuid), this.move.dataAppName);
            return 1;
        }

        @Override
        int doPreInstall(int status) {
            if (status != 1) {
                this.cleanUp(this.move.toUuid);
            }
            return status;
        }

        @Override
        boolean doRename(int status, PackageParser.Package pkg, String oldCodePath) {
            if (status != 1) {
                this.cleanUp(this.move.toUuid);
                return false;
            }
            pkg.applicationInfo.volumeUuid = pkg.volumeUuid;
            pkg.applicationInfo.setCodePath(pkg.codePath);
            pkg.applicationInfo.setBaseCodePath(pkg.baseCodePath);
            pkg.applicationInfo.setSplitCodePaths(pkg.splitCodePaths);
            pkg.applicationInfo.setResourcePath(pkg.codePath);
            pkg.applicationInfo.setBaseResourcePath(pkg.baseCodePath);
            pkg.applicationInfo.setSplitResourcePaths(pkg.splitCodePaths);
            return true;
        }

        @Override
        int doPostInstall(int status, int uid) {
            if (status == 1) {
                this.cleanUp(this.move.fromUuid);
            } else {
                this.cleanUp(this.move.toUuid);
            }
            return status;
        }

        @Override
        String getCodePath() {
            return this.codeFile != null ? this.codeFile.getAbsolutePath() : null;
        }

        @Override
        String getResourcePath() {
            return this.resourceFile != null ? this.resourceFile.getAbsolutePath() : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean cleanUp(String volumeUuid) {
            File codeFile = new File(Environment.getDataAppDirectory(volumeUuid), this.move.dataAppName);
            Slog.d(PackageManagerService.TAG, "Cleaning up " + this.move.packageName + " on " + volumeUuid);
            Object object = PackageManagerService.this.mInstallLock;
            synchronized (object) {
                PackageManagerService.this.removeDataDirsLI(volumeUuid, this.move.packageName);
                if (codeFile.isDirectory()) {
                    PackageManagerService.this.mInstaller.rmPackageDir(codeFile.getAbsolutePath());
                } else {
                    codeFile.delete();
                }
            }
            return true;
        }

        @Override
        void cleanUpResourcesLI() {
            throw new UnsupportedOperationException();
        }

        @Override
        boolean doPostDeleteLI(boolean delete) {
            throw new UnsupportedOperationException();
        }
    }

    class AsecInstallArgs
    extends InstallArgs {
        static final String RES_FILE_NAME = "pkg.apk";
        static final String PUBLIC_RES_FILE_NAME = "res.zip";
        String cid;
        String packagePath;
        String resourcePath;

        AsecInstallArgs(InstallParams params) {
            super(params.origin, params.move, params.observer, params.installFlags, params.installerPackageName, params.volumeUuid, params.getManifestDigest(), params.getUser(), null, params.packageAbiOverride, params.grantedRuntimePermissions);
        }

        AsecInstallArgs(String fullCodePath, String[] instructionSets, boolean isExternal, boolean isForwardLocked) {
            super(OriginInfo.fromNothing(), null, null, (isExternal ? 8 : 0) | (isForwardLocked ? 1 : 0), null, null, null, null, instructionSets, null, null);
            if (!fullCodePath.endsWith(RES_FILE_NAME)) {
                fullCodePath = new File(fullCodePath, RES_FILE_NAME).getAbsolutePath();
            }
            int eidx = fullCodePath.lastIndexOf("/");
            String subStr1 = fullCodePath.substring(0, eidx);
            int sidx = subStr1.lastIndexOf("/");
            this.cid = subStr1.substring(sidx + 1, eidx);
            this.setMountPath(subStr1);
        }

        AsecInstallArgs(String cid, String[] instructionSets, boolean isForwardLocked) {
            super(OriginInfo.fromNothing(), null, null, (PackageManagerService.this.isAsecExternal(cid) ? 8 : 0) | (isForwardLocked ? 1 : 0), null, null, null, null, instructionSets, null, null);
            this.cid = cid;
            this.setMountPath(PackageHelper.getSdDir(cid));
        }

        void createCopyFile() {
            this.cid = PackageManagerService.this.mInstallerService.allocateExternalStageCidLegacy();
        }

        @Override
        int copyApk(IMediaContainerService imcs, boolean temp) throws RemoteException {
            if (this.origin.staged) {
                this.cid = this.origin.cid;
                this.setMountPath(PackageHelper.getSdDir(this.cid));
                return 1;
            }
            if (temp) {
                this.createCopyFile();
            } else {
                PackageHelper.destroySdDir(this.cid);
            }
            String newMountPath = imcs.copyPackageToContainer(this.origin.file.getAbsolutePath(), this.cid, PackageManagerService.getEncryptKey(), this.isExternalAsec(), this.isFwdLocked(), PackageManagerService.deriveAbiOverride(this.abiOverride, null));
            if (newMountPath != null) {
                this.setMountPath(newMountPath);
                return 1;
            }
            return -18;
        }

        @Override
        String getCodePath() {
            return this.packagePath;
        }

        @Override
        String getResourcePath() {
            return this.resourcePath;
        }

        @Override
        int doPreInstall(int status) {
            if (status != 1) {
                PackageHelper.destroySdDir(this.cid);
            } else {
                boolean mounted = PackageHelper.isContainerMounted(this.cid);
                if (!mounted) {
                    String newMountPath = PackageHelper.mountSdDir(this.cid, PackageManagerService.getEncryptKey(), 1000);
                    if (newMountPath != null) {
                        this.setMountPath(newMountPath);
                    } else {
                        return -18;
                    }
                }
            }
            return status;
        }

        @Override
        boolean doRename(int status, PackageParser.Package pkg, String oldCodePath) {
            String newCacheId = PackageManagerService.getNextCodePath(oldCodePath, pkg.packageName, "/pkg.apk");
            String newMountPath = null;
            if (PackageHelper.isContainerMounted(this.cid) && !PackageHelper.unMountSdDir(this.cid)) {
                Slog.i(PackageManagerService.TAG, "Failed to unmount " + this.cid + " before renaming");
                return false;
            }
            if (!PackageHelper.renameSdDir(this.cid, newCacheId)) {
                Slog.e(PackageManagerService.TAG, "Failed to rename " + this.cid + " to " + newCacheId + " which might be stale. Will try to clean up.");
                if (!PackageHelper.destroySdDir(newCacheId)) {
                    Slog.e(PackageManagerService.TAG, "Very strange. Cannot clean up stale container " + newCacheId);
                    return false;
                }
                if (!PackageHelper.renameSdDir(this.cid, newCacheId)) {
                    Slog.e(PackageManagerService.TAG, "Failed to rename " + this.cid + " to " + newCacheId + " inspite of cleaning it up.");
                    return false;
                }
            }
            if (!PackageHelper.isContainerMounted(newCacheId)) {
                Slog.w(PackageManagerService.TAG, "Mounting container " + newCacheId);
                newMountPath = PackageHelper.mountSdDir(newCacheId, PackageManagerService.getEncryptKey(), 1000);
            } else {
                newMountPath = PackageHelper.getSdDir(newCacheId);
            }
            if (newMountPath == null) {
                Slog.w(PackageManagerService.TAG, "Failed to get cache path for  " + newCacheId);
                return false;
            }
            Log.i(PackageManagerService.TAG, "Succesfully renamed " + this.cid + " to " + newCacheId + " at new path: " + newMountPath);
            this.cid = newCacheId;
            File beforeCodeFile = new File(this.packagePath);
            this.setMountPath(newMountPath);
            File afterCodeFile = new File(this.packagePath);
            pkg.codePath = afterCodeFile.getAbsolutePath();
            pkg.baseCodePath = FileUtils.rewriteAfterRename(beforeCodeFile, afterCodeFile, pkg.baseCodePath);
            pkg.splitCodePaths = FileUtils.rewriteAfterRename(beforeCodeFile, afterCodeFile, pkg.splitCodePaths);
            pkg.applicationInfo.volumeUuid = pkg.volumeUuid;
            pkg.applicationInfo.setCodePath(pkg.codePath);
            pkg.applicationInfo.setBaseCodePath(pkg.baseCodePath);
            pkg.applicationInfo.setSplitCodePaths(pkg.splitCodePaths);
            pkg.applicationInfo.setResourcePath(pkg.codePath);
            pkg.applicationInfo.setBaseResourcePath(pkg.baseCodePath);
            pkg.applicationInfo.setSplitResourcePaths(pkg.splitCodePaths);
            return true;
        }

        private void setMountPath(String mountPath) {
            File mountFile = new File(mountPath);
            File monolithicFile = new File(mountFile, RES_FILE_NAME);
            if (monolithicFile.exists()) {
                this.packagePath = monolithicFile.getAbsolutePath();
                this.resourcePath = this.isFwdLocked() ? new File(mountFile, PUBLIC_RES_FILE_NAME).getAbsolutePath() : this.packagePath;
            } else {
                this.resourcePath = this.packagePath = mountFile.getAbsolutePath();
            }
        }

        @Override
        int doPostInstall(int status, int uid) {
            if (status != 1) {
                this.cleanUp();
            } else {
                String protectedFile;
                int groupOwner;
                if (this.isFwdLocked()) {
                    groupOwner = UserHandle.getSharedAppGid(uid);
                    protectedFile = RES_FILE_NAME;
                } else {
                    groupOwner = -1;
                    protectedFile = null;
                }
                if (uid < 10000 || !PackageHelper.fixSdPermissions(this.cid, groupOwner, protectedFile)) {
                    Slog.e(PackageManagerService.TAG, "Failed to finalize " + this.cid);
                    PackageHelper.destroySdDir(this.cid);
                    return -18;
                }
                boolean mounted = PackageHelper.isContainerMounted(this.cid);
                if (!mounted) {
                    PackageHelper.mountSdDir(this.cid, PackageManagerService.getEncryptKey(), Process.myUid());
                }
            }
            return status;
        }

        private void cleanUp() {
            PackageHelper.destroySdDir(this.cid);
        }

        private List<String> getAllCodePaths() {
            File codeFile = new File(this.getCodePath());
            if (codeFile != null && codeFile.exists()) {
                try {
                    PackageParser.PackageLite pkg = PackageParser.parsePackageLite(codeFile, 0);
                    return pkg.getAllCodePaths();
                }
                catch (PackageParser.PackageParserException packageParserException) {
                    // empty catch block
                }
            }
            return Collections.EMPTY_LIST;
        }

        @Override
        void cleanUpResourcesLI() {
            this.cleanUpResourcesLI(this.getAllCodePaths());
        }

        private void cleanUpResourcesLI(List<String> allCodePaths) {
            this.cleanUp();
            PackageManagerService.this.removeDexFiles(allCodePaths, this.instructionSets);
        }

        String getPackageName() {
            return PackageManagerService.getAsecPackageName(this.cid);
        }

        @Override
        boolean doPostDeleteLI(boolean delete) {
            List<String> allCodePaths = this.getAllCodePaths();
            boolean mounted = PackageHelper.isContainerMounted(this.cid);
            if (mounted && PackageHelper.unMountSdDir(this.cid)) {
                mounted = false;
            }
            if (!mounted && delete) {
                this.cleanUpResourcesLI(allCodePaths);
            }
            return !mounted;
        }

        @Override
        int doPreCopy() {
            if (this.isFwdLocked() && !PackageHelper.fixSdPermissions(this.cid, PackageManagerService.this.getPackageUid(PackageManagerService.DEFAULT_CONTAINER_PACKAGE, 0), RES_FILE_NAME)) {
                return -18;
            }
            return 1;
        }

        @Override
        int doPostCopy(int uid) {
            if (this.isFwdLocked() && (uid < 10000 || !PackageHelper.fixSdPermissions(this.cid, UserHandle.getSharedAppGid(uid), RES_FILE_NAME))) {
                Slog.e(PackageManagerService.TAG, "Failed to finalize " + this.cid);
                PackageHelper.destroySdDir(this.cid);
                return -18;
            }
            return 1;
        }
    }

    class FileInstallArgs
    extends InstallArgs {
        private File codeFile;
        private File resourceFile;

        FileInstallArgs(InstallParams params) {
            super(params.origin, params.move, params.observer, params.installFlags, params.installerPackageName, params.volumeUuid, params.getManifestDigest(), params.getUser(), null, params.packageAbiOverride, params.grantedRuntimePermissions);
            if (this.isFwdLocked()) {
                throw new IllegalArgumentException("Forward locking only supported in ASEC");
            }
        }

        FileInstallArgs(String codePath, String resourcePath, String[] instructionSets) {
            super(OriginInfo.fromNothing(), null, null, 0, null, null, null, null, instructionSets, null, null);
            this.codeFile = codePath != null ? new File(codePath) : null;
            this.resourceFile = resourcePath != null ? new File(resourcePath) : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        int copyApk(IMediaContainerService imcs, boolean temp) throws RemoteException {
            if (this.origin.staged) {
                this.codeFile = this.origin.file;
                this.resourceFile = this.origin.file;
                return 1;
            }
            try {
                File tempDir;
                this.codeFile = tempDir = PackageManagerService.this.mInstallerService.allocateStageDirLegacy(this.volumeUuid);
                this.resourceFile = tempDir;
            }
            catch (IOException e) {
                Slog.w(PackageManagerService.TAG, "Failed to create copy file: " + e);
                return -4;
            }
            IParcelFileDescriptorFactory.Stub target = new IParcelFileDescriptorFactory.Stub(){

                @Override
                public ParcelFileDescriptor open(String name, int mode) throws RemoteException {
                    if (!FileUtils.isValidExtFilename(name)) {
                        throw new IllegalArgumentException("Invalid filename: " + name);
                    }
                    try {
                        File file = new File(FileInstallArgs.this.codeFile, name);
                        FileDescriptor fd = Os.open(file.getAbsolutePath(), OsConstants.O_RDWR | OsConstants.O_CREAT, 420);
                        Os.chmod(file.getAbsolutePath(), 420);
                        return new ParcelFileDescriptor(fd);
                    }
                    catch (ErrnoException e) {
                        throw new RemoteException("Failed to open: " + e.getMessage());
                    }
                }
            };
            int ret = 1;
            ret = imcs.copyPackage(this.origin.file.getAbsolutePath(), target);
            if (ret != 1) {
                Slog.e(PackageManagerService.TAG, "Failed to copy package");
                return ret;
            }
            File libraryRoot = new File(this.codeFile, "lib");
            NativeLibraryHelper.Handle handle = null;
            try {
                handle = NativeLibraryHelper.Handle.create(this.codeFile);
                ret = NativeLibraryHelper.copyNativeBinariesWithOverride(handle, libraryRoot, this.abiOverride);
            }
            catch (IOException e) {
                Slog.e(PackageManagerService.TAG, "Copying native libraries failed", e);
                ret = -110;
            }
            finally {
                IoUtils.closeQuietly(handle);
            }
            return ret;
        }

        @Override
        int doPreInstall(int status) {
            if (status != 1) {
                this.cleanUp();
            }
            return status;
        }

        @Override
        boolean doRename(int status, PackageParser.Package pkg, String oldCodePath) {
            if (status != 1) {
                this.cleanUp();
                return false;
            }
            File targetDir = this.codeFile.getParentFile();
            File beforeCodeFile = this.codeFile;
            File afterCodeFile = PackageManagerService.this.getNextCodePath(targetDir, pkg.packageName);
            try {
                Os.rename(beforeCodeFile.getAbsolutePath(), afterCodeFile.getAbsolutePath());
            }
            catch (ErrnoException e) {
                Slog.w(PackageManagerService.TAG, "Failed to rename", e);
                return false;
            }
            if (!SELinux.restoreconRecursive(afterCodeFile)) {
                Slog.w(PackageManagerService.TAG, "Failed to restorecon");
                return false;
            }
            this.codeFile = afterCodeFile;
            this.resourceFile = afterCodeFile;
            pkg.codePath = afterCodeFile.getAbsolutePath();
            pkg.baseCodePath = FileUtils.rewriteAfterRename(beforeCodeFile, afterCodeFile, pkg.baseCodePath);
            pkg.splitCodePaths = FileUtils.rewriteAfterRename(beforeCodeFile, afterCodeFile, pkg.splitCodePaths);
            pkg.applicationInfo.volumeUuid = pkg.volumeUuid;
            pkg.applicationInfo.setCodePath(pkg.codePath);
            pkg.applicationInfo.setBaseCodePath(pkg.baseCodePath);
            pkg.applicationInfo.setSplitCodePaths(pkg.splitCodePaths);
            pkg.applicationInfo.setResourcePath(pkg.codePath);
            pkg.applicationInfo.setBaseResourcePath(pkg.baseCodePath);
            pkg.applicationInfo.setSplitResourcePaths(pkg.splitCodePaths);
            return true;
        }

        @Override
        int doPostInstall(int status, int uid) {
            if (status != 1) {
                this.cleanUp();
            }
            return status;
        }

        @Override
        String getCodePath() {
            return this.codeFile != null ? this.codeFile.getAbsolutePath() : null;
        }

        @Override
        String getResourcePath() {
            return this.resourceFile != null ? this.resourceFile.getAbsolutePath() : null;
        }

        private boolean cleanUp() {
            if (this.codeFile == null || !this.codeFile.exists()) {
                return false;
            }
            if (this.codeFile.isDirectory()) {
                PackageManagerService.this.mInstaller.rmPackageDir(this.codeFile.getAbsolutePath());
            } else {
                this.codeFile.delete();
            }
            if (this.resourceFile != null && !FileUtils.contains(this.codeFile, this.resourceFile)) {
                this.resourceFile.delete();
            }
            return true;
        }

        @Override
        void cleanUpResourcesLI() {
            List<String> allCodePaths = Collections.EMPTY_LIST;
            if (this.codeFile != null && this.codeFile.exists()) {
                try {
                    PackageParser.PackageLite pkg = PackageParser.parsePackageLite(this.codeFile, 0);
                    allCodePaths = pkg.getAllCodePaths();
                }
                catch (PackageParser.PackageParserException packageParserException) {
                    // empty catch block
                }
            }
            this.cleanUp();
            PackageManagerService.this.removeDexFiles(allCodePaths, this.instructionSets);
        }

        @Override
        boolean doPostDeleteLI(boolean delete) {
            this.cleanUpResourcesLI();
            return true;
        }
    }

    static abstract class InstallArgs {
        final OriginInfo origin;
        final MoveInfo move;
        final IPackageInstallObserver2 observer;
        final int installFlags;
        final String installerPackageName;
        final String volumeUuid;
        final ManifestDigest manifestDigest;
        final UserHandle user;
        final String abiOverride;
        final String[] installGrantPermissions;
        String[] instructionSets;

        InstallArgs(OriginInfo origin, MoveInfo move, IPackageInstallObserver2 observer, int installFlags, String installerPackageName, String volumeUuid, ManifestDigest manifestDigest, UserHandle user, String[] instructionSets, String abiOverride, String[] installGrantPermissions) {
            this.origin = origin;
            this.move = move;
            this.installFlags = installFlags;
            this.observer = observer;
            this.installerPackageName = installerPackageName;
            this.volumeUuid = volumeUuid;
            this.manifestDigest = manifestDigest;
            this.user = user;
            this.instructionSets = instructionSets;
            this.abiOverride = abiOverride;
            this.installGrantPermissions = installGrantPermissions;
        }

        abstract int copyApk(IMediaContainerService var1, boolean var2) throws RemoteException;

        abstract int doPreInstall(int var1);

        abstract boolean doRename(int var1, PackageParser.Package var2, String var3);

        abstract int doPostInstall(int var1, int var2);

        abstract String getCodePath();

        abstract String getResourcePath();

        abstract void cleanUpResourcesLI();

        abstract boolean doPostDeleteLI(boolean var1);

        int doPreCopy() {
            return 1;
        }

        int doPostCopy(int uid) {
            return 1;
        }

        protected boolean isFwdLocked() {
            return (this.installFlags & 1) != 0;
        }

        protected boolean isExternalAsec() {
            return (this.installFlags & 8) != 0;
        }

        UserHandle getUser() {
            return this.user;
        }
    }

    class InstallParams
    extends HandlerParams {
        final OriginInfo origin;
        final MoveInfo move;
        final IPackageInstallObserver2 observer;
        int installFlags;
        final String installerPackageName;
        final String volumeUuid;
        final VerificationParams verificationParams;
        private InstallArgs mArgs;
        private int mRet;
        final String packageAbiOverride;
        final String[] grantedRuntimePermissions;

        InstallParams(OriginInfo origin, MoveInfo move, IPackageInstallObserver2 observer, int installFlags, String installerPackageName, String volumeUuid, VerificationParams verificationParams, UserHandle user, String packageAbiOverride, String[] grantedPermissions) {
            super(user);
            this.origin = origin;
            this.move = move;
            this.observer = observer;
            this.installFlags = installFlags;
            this.installerPackageName = installerPackageName;
            this.volumeUuid = volumeUuid;
            this.verificationParams = verificationParams;
            this.packageAbiOverride = packageAbiOverride;
            this.grantedRuntimePermissions = grantedPermissions;
        }

        public String toString() {
            return "InstallParams{" + Integer.toHexString(System.identityHashCode(this)) + " file=" + this.origin.file + " cid=" + this.origin.cid + "}";
        }

        public ManifestDigest getManifestDigest() {
            if (this.verificationParams == null) {
                return null;
            }
            return this.verificationParams.getManifestDigest();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int installLocationPolicy(PackageInfoLite pkgLite) {
            String packageName = pkgLite.packageName;
            int installLocation = pkgLite.installLocation;
            boolean onSd = (this.installFlags & 8) != 0;
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageParser.Package pkg = PackageManagerService.this.mPackages.get(packageName);
                if (pkg != null) {
                    if ((this.installFlags & 2) != 0) {
                        if ((this.installFlags & 0x80) == 0) {
                            try {
                                PackageManagerService.checkDowngrade(pkg, pkgLite);
                            }
                            catch (PackageManagerException e) {
                                Slog.w(PackageManagerService.TAG, "Downgrade detected: " + e.getMessage());
                                return -7;
                            }
                        }
                        if ((pkg.applicationInfo.flags & 1) != 0) {
                            if (onSd) {
                                Slog.w(PackageManagerService.TAG, "Cannot install update to system app on sdcard");
                                return -3;
                            }
                            return 1;
                        }
                        if (onSd) {
                            return 2;
                        }
                        if (installLocation == 1) {
                            return 1;
                        }
                        if (installLocation != 2) {
                            if (PackageManagerService.isExternal(pkg)) {
                                return 2;
                            }
                            return 1;
                        }
                    } else {
                        return -4;
                    }
                }
            }
            if (onSd) {
                return 2;
            }
            return pkgLite.recommendedInstallLocation;
        }

        @Override
        public void handleStartCopy() throws RemoteException {
            InstallArgs args;
            int ret = 1;
            if (this.origin.staged) {
                if (this.origin.file != null) {
                    this.installFlags |= 0x10;
                    this.installFlags &= 0xFFFFFFF7;
                } else if (this.origin.cid != null) {
                    this.installFlags |= 8;
                    this.installFlags &= 0xFFFFFFEF;
                } else {
                    throw new IllegalStateException("Invalid stage location");
                }
            }
            boolean onSd = (this.installFlags & 8) != 0;
            boolean onInt = (this.installFlags & 0x10) != 0;
            PackageInfoLite pkgLite = null;
            if (onInt && onSd) {
                Slog.w(PackageManagerService.TAG, "Conflicting flags specified for installing on both internal and external");
                ret = -19;
            } else {
                pkgLite = PackageManagerService.this.mContainerService.getMinimalPackageInfo(this.origin.resolvedPath, this.installFlags, this.packageAbiOverride);
                if (!this.origin.staged && pkgLite.recommendedInstallLocation == -1) {
                    StorageManager storage = StorageManager.from(PackageManagerService.this.mContext);
                    long lowThreshold = storage.getStorageLowBytes(Environment.getDataDirectory());
                    long sizeBytes = PackageManagerService.this.mContainerService.calculateInstalledSize(this.origin.resolvedPath, this.isForwardLocked(), this.packageAbiOverride);
                    if (PackageManagerService.this.mInstaller.freeCache(null, sizeBytes + lowThreshold) >= 0) {
                        pkgLite = PackageManagerService.this.mContainerService.getMinimalPackageInfo(this.origin.resolvedPath, this.installFlags, this.packageAbiOverride);
                    }
                    if (pkgLite.recommendedInstallLocation == -6) {
                        pkgLite.recommendedInstallLocation = -1;
                    }
                }
            }
            if (ret == 1) {
                int loc = pkgLite.recommendedInstallLocation;
                if (loc == -3) {
                    ret = -19;
                } else if (loc == -4) {
                    ret = -1;
                } else if (loc == -1) {
                    ret = -4;
                } else if (loc == -2) {
                    ret = -2;
                } else if (loc == -6) {
                    ret = -3;
                } else if (loc == -5) {
                    ret = -20;
                } else {
                    loc = this.installLocationPolicy(pkgLite);
                    if (loc == -7) {
                        ret = -25;
                    } else if (!onSd && !onInt) {
                        if (loc == 2) {
                            this.installFlags |= 8;
                            this.installFlags &= 0xFFFFFFEF;
                        } else {
                            this.installFlags |= 0x10;
                            this.installFlags &= 0xFFFFFFF7;
                        }
                    }
                }
            }
            this.mArgs = args = PackageManagerService.this.createInstallArgs(this);
            if (ret == 1) {
                int requiredUid;
                int userIdentifier = this.getUser().getIdentifier();
                if (userIdentifier == -1 && (this.installFlags & 0x20) != 0) {
                    userIdentifier = 0;
                }
                int n = requiredUid = PackageManagerService.this.mRequiredVerifierPackage == null ? -1 : PackageManagerService.this.getPackageUid(PackageManagerService.this.mRequiredVerifierPackage, userIdentifier);
                if (!this.origin.existing && requiredUid != -1 && PackageManagerService.this.isVerificationEnabled(userIdentifier, this.installFlags)) {
                    Intent verification = new Intent("android.intent.action.PACKAGE_NEEDS_VERIFICATION");
                    verification.addFlags(0x10000000);
                    verification.setDataAndType(Uri.fromFile(new File(this.origin.resolvedPath)), PackageManagerService.PACKAGE_MIME_TYPE);
                    verification.addFlags(1);
                    List<ResolveInfo> receivers = PackageManagerService.this.queryIntentReceivers(verification, PackageManagerService.PACKAGE_MIME_TYPE, 512, 0);
                    final int verificationId = PackageManagerService.this.mPendingVerificationToken++;
                    verification.putExtra("android.content.pm.extra.VERIFICATION_ID", verificationId);
                    verification.putExtra("android.content.pm.extra.VERIFICATION_INSTALLER_PACKAGE", this.installerPackageName);
                    verification.putExtra("android.content.pm.extra.VERIFICATION_INSTALL_FLAGS", this.installFlags);
                    verification.putExtra("android.content.pm.extra.VERIFICATION_PACKAGE_NAME", pkgLite.packageName);
                    verification.putExtra("android.content.pm.extra.VERIFICATION_VERSION_CODE", pkgLite.versionCode);
                    if (this.verificationParams != null) {
                        if (this.verificationParams.getVerificationURI() != null) {
                            verification.putExtra("android.content.pm.extra.VERIFICATION_URI", this.verificationParams.getVerificationURI());
                        }
                        if (this.verificationParams.getOriginatingURI() != null) {
                            verification.putExtra("android.intent.extra.ORIGINATING_URI", this.verificationParams.getOriginatingURI());
                        }
                        if (this.verificationParams.getReferrer() != null) {
                            verification.putExtra("android.intent.extra.REFERRER", this.verificationParams.getReferrer());
                        }
                        if (this.verificationParams.getOriginatingUid() >= 0) {
                            verification.putExtra("android.intent.extra.ORIGINATING_UID", this.verificationParams.getOriginatingUid());
                        }
                        if (this.verificationParams.getInstallerUid() >= 0) {
                            verification.putExtra("android.content.pm.extra.VERIFICATION_INSTALLER_UID", this.verificationParams.getInstallerUid());
                        }
                    }
                    PackageVerificationState verificationState = new PackageVerificationState(requiredUid, args);
                    PackageManagerService.this.mPendingVerification.append(verificationId, verificationState);
                    List sufficientVerifiers = PackageManagerService.this.matchVerifiers(pkgLite, receivers, verificationState);
                    UserHandle verifierUser = this.getUser();
                    if (verifierUser == UserHandle.ALL) {
                        verifierUser = UserHandle.OWNER;
                    }
                    if (sufficientVerifiers != null) {
                        int N = sufficientVerifiers.size();
                        if (N == 0) {
                            Slog.i(PackageManagerService.TAG, "Additional verifiers required, but none installed.");
                            ret = -22;
                        } else {
                            for (int i = 0; i < N; ++i) {
                                ComponentName verifierComponent = (ComponentName)sufficientVerifiers.get(i);
                                Intent sufficientIntent = new Intent(verification);
                                sufficientIntent.setComponent(verifierComponent);
                                PackageManagerService.this.mContext.sendBroadcastAsUser(sufficientIntent, verifierUser);
                            }
                        }
                    }
                    ComponentName requiredVerifierComponent = PackageManagerService.this.matchComponentForVerifier(PackageManagerService.this.mRequiredVerifierPackage, receivers);
                    if (ret == 1 && PackageManagerService.this.mRequiredVerifierPackage != null) {
                        verification.setComponent(requiredVerifierComponent);
                        PackageManagerService.this.mContext.sendOrderedBroadcastAsUser(verification, verifierUser, "android.permission.PACKAGE_VERIFICATION_AGENT", new BroadcastReceiver(){

                            @Override
                            public void onReceive(Context context, Intent intent) {
                                Message msg = PackageManagerService.this.mHandler.obtainMessage(16);
                                msg.arg1 = verificationId;
                                PackageManagerService.this.mHandler.sendMessageDelayed(msg, PackageManagerService.this.getVerificationTimeout());
                            }
                        }, null, 0, null, null);
                        this.mArgs = null;
                    }
                } else {
                    ret = args.copyApk(PackageManagerService.this.mContainerService, true);
                }
            }
            this.mRet = ret;
        }

        @Override
        void handleReturnCode() {
            if (this.mArgs != null) {
                PackageManagerService.this.processPendingInstall(this.mArgs, this.mRet);
            }
        }

        @Override
        void handleServiceError() {
            this.mArgs = PackageManagerService.this.createInstallArgs(this);
            this.mRet = -110;
        }

        public boolean isForwardLocked() {
            return (this.installFlags & 1) != 0;
        }
    }

    class MoveInfo {
        final int moveId;
        final String fromUuid;
        final String toUuid;
        final String packageName;
        final String dataAppName;
        final int appId;
        final String seinfo;

        public MoveInfo(int moveId, String fromUuid, String toUuid, String packageName, String dataAppName, int appId, String seinfo) {
            this.moveId = moveId;
            this.fromUuid = fromUuid;
            this.toUuid = toUuid;
            this.packageName = packageName;
            this.dataAppName = dataAppName;
            this.appId = appId;
            this.seinfo = seinfo;
        }
    }

    static class OriginInfo {
        final File file;
        final String cid;
        final boolean staged;
        final boolean existing;
        final String resolvedPath;
        final File resolvedFile;

        static OriginInfo fromNothing() {
            return new OriginInfo(null, null, false, false);
        }

        static OriginInfo fromUntrustedFile(File file) {
            return new OriginInfo(file, null, false, false);
        }

        static OriginInfo fromExistingFile(File file) {
            return new OriginInfo(file, null, false, true);
        }

        static OriginInfo fromStagedFile(File file) {
            return new OriginInfo(file, null, true, false);
        }

        static OriginInfo fromStagedContainer(String cid) {
            return new OriginInfo(null, cid, true, false);
        }

        private OriginInfo(File file, String cid, boolean staged, boolean existing) {
            this.file = file;
            this.cid = cid;
            this.staged = staged;
            this.existing = existing;
            if (cid != null) {
                this.resolvedPath = PackageHelper.getSdDir(cid);
                this.resolvedFile = new File(this.resolvedPath);
            } else if (file != null) {
                this.resolvedPath = file.getAbsolutePath();
                this.resolvedFile = file;
            } else {
                this.resolvedPath = null;
                this.resolvedFile = null;
            }
        }
    }

    class MeasureParams
    extends HandlerParams {
        private final PackageStats mStats;
        private boolean mSuccess;
        private final IPackageStatsObserver mObserver;

        public MeasureParams(PackageStats stats, IPackageStatsObserver observer) {
            super(new UserHandle(stats.userHandle));
            this.mObserver = observer;
            this.mStats = stats;
        }

        public String toString() {
            return "MeasureParams{" + Integer.toHexString(System.identityHashCode(this)) + " " + this.mStats.packageName + "}";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void handleStartCopy() throws RemoteException {
            Object object = PackageManagerService.this.mInstallLock;
            synchronized (object) {
                this.mSuccess = PackageManagerService.this.getPackageSizeInfoLI(this.mStats.packageName, this.mStats.userHandle, this.mStats);
            }
            if (this.mSuccess) {
                boolean mounted;
                if (Environment.isExternalStorageEmulated()) {
                    mounted = true;
                } else {
                    String status = Environment.getExternalStorageState();
                    boolean bl = mounted = "mounted".equals(status) || "mounted_ro".equals(status);
                }
                if (mounted) {
                    Environment.UserEnvironment userEnv = new Environment.UserEnvironment(this.mStats.userHandle);
                    this.mStats.externalCacheSize = PackageManagerService.calculateDirectorySize(PackageManagerService.this.mContainerService, userEnv.buildExternalStorageAppCacheDirs(this.mStats.packageName));
                    this.mStats.externalDataSize = PackageManagerService.calculateDirectorySize(PackageManagerService.this.mContainerService, userEnv.buildExternalStorageAppDataDirs(this.mStats.packageName));
                    this.mStats.externalDataSize -= this.mStats.externalCacheSize;
                    this.mStats.externalMediaSize = PackageManagerService.calculateDirectorySize(PackageManagerService.this.mContainerService, userEnv.buildExternalStorageAppMediaDirs(this.mStats.packageName));
                    this.mStats.externalObbSize = PackageManagerService.calculateDirectorySize(PackageManagerService.this.mContainerService, userEnv.buildExternalStorageAppObbDirs(this.mStats.packageName));
                }
            }
        }

        @Override
        void handleReturnCode() {
            if (this.mObserver != null) {
                try {
                    this.mObserver.onGetStatsCompleted(this.mStats, this.mSuccess);
                }
                catch (RemoteException e) {
                    Slog.i(PackageManagerService.TAG, "Observer no longer exists.");
                }
            }
        }

        @Override
        void handleServiceError() {
            Slog.e(PackageManagerService.TAG, "Could not measure application " + this.mStats.packageName + " external storage");
        }
    }

    private abstract class HandlerParams {
        private static final int MAX_RETRIES = 4;
        private int mRetries = 0;
        private final UserHandle mUser;

        HandlerParams(UserHandle user) {
            this.mUser = user;
        }

        UserHandle getUser() {
            return this.mUser;
        }

        final boolean startCopy() {
            boolean res;
            try {
                if (++this.mRetries > 4) {
                    Slog.w(PackageManagerService.TAG, "Failed to invoke remote methods on default container service. Giving up");
                    PackageManagerService.this.mHandler.sendEmptyMessage(11);
                    this.handleServiceError();
                    return false;
                }
                this.handleStartCopy();
                res = true;
            }
            catch (RemoteException e) {
                PackageManagerService.this.mHandler.sendEmptyMessage(10);
                res = false;
            }
            this.handleReturnCode();
            return res;
        }

        final void serviceError() {
            this.handleServiceError();
            this.handleReturnCode();
        }

        abstract void handleStartCopy() throws RemoteException;

        abstract void handleServiceError();

        abstract void handleReturnCode();
    }

    private final class ProviderIntentResolver
    extends IntentResolver<PackageParser.ProviderIntentInfo, ResolveInfo> {
        private final ArrayMap<ComponentName, PackageParser.Provider> mProviders = new ArrayMap();
        private int mFlags;

        private ProviderIntentResolver() {
        }

        @Override
        public List<ResolveInfo> queryIntent(Intent intent, String resolvedType, boolean defaultOnly, int userId) {
            this.mFlags = defaultOnly ? 65536 : 0;
            return super.queryIntent(intent, resolvedType, defaultOnly, userId);
        }

        public List<ResolveInfo> queryIntent(Intent intent, String resolvedType, int flags, int userId) {
            if (!sUserManager.exists(userId)) {
                return null;
            }
            this.mFlags = flags;
            return super.queryIntent(intent, resolvedType, (flags & 0x10000) != 0, userId);
        }

        public List<ResolveInfo> queryIntentForPackage(Intent intent, String resolvedType, int flags, ArrayList<PackageParser.Provider> packageProviders, int userId) {
            if (!sUserManager.exists(userId)) {
                return null;
            }
            if (packageProviders == null) {
                return null;
            }
            this.mFlags = flags;
            boolean defaultOnly = (flags & 0x10000) != 0;
            int N = packageProviders.size();
            ArrayList<F[]> listCut = new ArrayList<F[]>(N);
            for (int i = 0; i < N; ++i) {
                ArrayList intentFilters = packageProviders.get((int)i).intents;
                if (intentFilters == null || intentFilters.size() <= 0) continue;
                PackageParser.ProviderIntentInfo[] array2 = new PackageParser.ProviderIntentInfo[intentFilters.size()];
                intentFilters.toArray(array2);
                listCut.add(array2);
            }
            return super.queryIntentFromList(intent, resolvedType, defaultOnly, listCut, userId);
        }

        public final void addProvider(PackageParser.Provider p) {
            if (this.mProviders.containsKey(p.getComponentName())) {
                Slog.w(PackageManagerService.TAG, "Provider " + p.getComponentName() + " already defined; ignoring");
                return;
            }
            this.mProviders.put(p.getComponentName(), p);
            int NI = p.intents.size();
            for (int j = 0; j < NI; ++j) {
                PackageParser.ProviderIntentInfo intent = (PackageParser.ProviderIntentInfo)p.intents.get(j);
                if (!intent.debugCheck()) {
                    Log.w(PackageManagerService.TAG, "==> For Provider " + p.info.name);
                }
                this.addFilter(intent);
            }
        }

        public final void removeProvider(PackageParser.Provider p) {
            this.mProviders.remove(p.getComponentName());
            int NI = p.intents.size();
            for (int j = 0; j < NI; ++j) {
                PackageParser.ProviderIntentInfo intent = (PackageParser.ProviderIntentInfo)p.intents.get(j);
                this.removeFilter(intent);
            }
        }

        @Override
        protected boolean allowFilterResult(PackageParser.ProviderIntentInfo filter, List<ResolveInfo> dest) {
            ProviderInfo filterPi = filter.provider.info;
            for (int i = dest.size() - 1; i >= 0; --i) {
                ProviderInfo destPi = dest.get((int)i).providerInfo;
                if (destPi.name != filterPi.name || destPi.packageName != filterPi.packageName) continue;
                return false;
            }
            return true;
        }

        protected PackageParser.ProviderIntentInfo[] newArray(int size) {
            return new PackageParser.ProviderIntentInfo[size];
        }

        @Override
        protected boolean isFilterStopped(PackageParser.ProviderIntentInfo filter, int userId) {
            PackageSetting ps;
            if (!sUserManager.exists(userId)) {
                return true;
            }
            PackageParser.Package p = filter.provider.owner;
            if (p != null && (ps = (PackageSetting)p.mExtras) != null) {
                return (ps.pkgFlags & 1) == 0 && ps.getStopped(userId);
            }
            return false;
        }

        @Override
        protected boolean isPackageForFilter(String packageName, PackageParser.ProviderIntentInfo info) {
            return packageName.equals(info.provider.owner.packageName);
        }

        @Override
        protected ResolveInfo newResult(PackageParser.ProviderIntentInfo filter, int match, int userId) {
            if (!sUserManager.exists(userId)) {
                return null;
            }
            PackageParser.ProviderIntentInfo info = filter;
            if (!PackageManagerService.this.mSettings.isEnabledLPr(info.provider.info, this.mFlags, userId)) {
                return null;
            }
            PackageParser.Provider provider = info.provider;
            if (PackageManagerService.this.mSafeMode && (provider.info.applicationInfo.flags & 1) == 0) {
                return null;
            }
            PackageSetting ps = (PackageSetting)provider.owner.mExtras;
            if (ps == null) {
                return null;
            }
            ProviderInfo pi = PackageParser.generateProviderInfo(provider, this.mFlags, ps.readUserState(userId), userId);
            if (pi == null) {
                return null;
            }
            ResolveInfo res = new ResolveInfo();
            res.providerInfo = pi;
            if ((this.mFlags & 0x40) != 0) {
                res.filter = filter;
            }
            res.priority = info.getPriority();
            res.preferredOrder = provider.owner.mPreferredOrder;
            res.match = match;
            res.isDefault = info.hasDefault;
            res.labelRes = info.labelRes;
            res.nonLocalizedLabel = info.nonLocalizedLabel;
            res.icon = info.icon;
            res.system = res.providerInfo.applicationInfo.isSystemApp();
            return res;
        }

        @Override
        protected void sortResults(List<ResolveInfo> results) {
            Collections.sort(results, mResolvePrioritySorter);
        }

        @Override
        protected void dumpFilter(PrintWriter out, String prefix, PackageParser.ProviderIntentInfo filter) {
            out.print(prefix);
            out.print(Integer.toHexString(System.identityHashCode(filter.provider)));
            out.print(' ');
            filter.provider.printComponentShortName(out);
            out.print(" filter ");
            out.println(Integer.toHexString(System.identityHashCode(filter)));
        }

        @Override
        protected Object filterToLabel(PackageParser.ProviderIntentInfo filter) {
            return filter.provider;
        }

        @Override
        protected void dumpFilterLabel(PrintWriter out, String prefix, Object label, int count) {
            PackageParser.Provider provider = (PackageParser.Provider)label;
            out.print(prefix);
            out.print(Integer.toHexString(System.identityHashCode(provider)));
            out.print(' ');
            provider.printComponentShortName(out);
            if (count > 1) {
                out.print(" (");
                out.print(count);
                out.print(" filters)");
            }
            out.println();
        }
    }

    private final class ServiceIntentResolver
    extends IntentResolver<PackageParser.ServiceIntentInfo, ResolveInfo> {
        private final ArrayMap<ComponentName, PackageParser.Service> mServices = new ArrayMap();
        private int mFlags;

        private ServiceIntentResolver() {
        }

        @Override
        public List<ResolveInfo> queryIntent(Intent intent, String resolvedType, boolean defaultOnly, int userId) {
            this.mFlags = defaultOnly ? 65536 : 0;
            return super.queryIntent(intent, resolvedType, defaultOnly, userId);
        }

        public List<ResolveInfo> queryIntent(Intent intent, String resolvedType, int flags, int userId) {
            if (!sUserManager.exists(userId)) {
                return null;
            }
            this.mFlags = flags;
            return super.queryIntent(intent, resolvedType, (flags & 0x10000) != 0, userId);
        }

        public List<ResolveInfo> queryIntentForPackage(Intent intent, String resolvedType, int flags, ArrayList<PackageParser.Service> packageServices, int userId) {
            if (!sUserManager.exists(userId)) {
                return null;
            }
            if (packageServices == null) {
                return null;
            }
            this.mFlags = flags;
            boolean defaultOnly = (flags & 0x10000) != 0;
            int N = packageServices.size();
            ArrayList<F[]> listCut = new ArrayList<F[]>(N);
            for (int i = 0; i < N; ++i) {
                ArrayList intentFilters = packageServices.get((int)i).intents;
                if (intentFilters == null || intentFilters.size() <= 0) continue;
                PackageParser.ServiceIntentInfo[] array2 = new PackageParser.ServiceIntentInfo[intentFilters.size()];
                intentFilters.toArray(array2);
                listCut.add(array2);
            }
            return super.queryIntentFromList(intent, resolvedType, defaultOnly, listCut, userId);
        }

        public final void addService(PackageParser.Service s) {
            this.mServices.put(s.getComponentName(), s);
            int NI = s.intents.size();
            for (int j = 0; j < NI; ++j) {
                PackageParser.ServiceIntentInfo intent = (PackageParser.ServiceIntentInfo)s.intents.get(j);
                if (!intent.debugCheck()) {
                    Log.w(PackageManagerService.TAG, "==> For Service " + s.info.name);
                }
                this.addFilter(intent);
            }
        }

        public final void removeService(PackageParser.Service s) {
            this.mServices.remove(s.getComponentName());
            int NI = s.intents.size();
            for (int j = 0; j < NI; ++j) {
                PackageParser.ServiceIntentInfo intent = (PackageParser.ServiceIntentInfo)s.intents.get(j);
                this.removeFilter(intent);
            }
        }

        @Override
        protected boolean allowFilterResult(PackageParser.ServiceIntentInfo filter, List<ResolveInfo> dest) {
            ServiceInfo filterSi = filter.service.info;
            for (int i = dest.size() - 1; i >= 0; --i) {
                ServiceInfo destAi = dest.get((int)i).serviceInfo;
                if (destAi.name != filterSi.name || destAi.packageName != filterSi.packageName) continue;
                return false;
            }
            return true;
        }

        protected PackageParser.ServiceIntentInfo[] newArray(int size) {
            return new PackageParser.ServiceIntentInfo[size];
        }

        @Override
        protected boolean isFilterStopped(PackageParser.ServiceIntentInfo filter, int userId) {
            PackageSetting ps;
            if (!sUserManager.exists(userId)) {
                return true;
            }
            PackageParser.Package p = filter.service.owner;
            if (p != null && (ps = (PackageSetting)p.mExtras) != null) {
                return (ps.pkgFlags & 1) == 0 && ps.getStopped(userId);
            }
            return false;
        }

        @Override
        protected boolean isPackageForFilter(String packageName, PackageParser.ServiceIntentInfo info) {
            return packageName.equals(info.service.owner.packageName);
        }

        @Override
        protected ResolveInfo newResult(PackageParser.ServiceIntentInfo filter, int match, int userId) {
            if (!sUserManager.exists(userId)) {
                return null;
            }
            PackageParser.ServiceIntentInfo info = filter;
            if (!PackageManagerService.this.mSettings.isEnabledLPr(info.service.info, this.mFlags, userId)) {
                return null;
            }
            PackageParser.Service service = info.service;
            if (PackageManagerService.this.mSafeMode && (service.info.applicationInfo.flags & 1) == 0) {
                return null;
            }
            PackageSetting ps = (PackageSetting)service.owner.mExtras;
            if (ps == null) {
                return null;
            }
            ServiceInfo si = PackageParser.generateServiceInfo(service, this.mFlags, ps.readUserState(userId), userId);
            if (si == null) {
                return null;
            }
            ResolveInfo res = new ResolveInfo();
            res.serviceInfo = si;
            if ((this.mFlags & 0x40) != 0) {
                res.filter = filter;
            }
            res.priority = info.getPriority();
            res.preferredOrder = service.owner.mPreferredOrder;
            res.match = match;
            res.isDefault = info.hasDefault;
            res.labelRes = info.labelRes;
            res.nonLocalizedLabel = info.nonLocalizedLabel;
            res.icon = info.icon;
            res.system = res.serviceInfo.applicationInfo.isSystemApp();
            return res;
        }

        @Override
        protected void sortResults(List<ResolveInfo> results) {
            Collections.sort(results, mResolvePrioritySorter);
        }

        @Override
        protected void dumpFilter(PrintWriter out, String prefix, PackageParser.ServiceIntentInfo filter) {
            out.print(prefix);
            out.print(Integer.toHexString(System.identityHashCode(filter.service)));
            out.print(' ');
            filter.service.printComponentShortName(out);
            out.print(" filter ");
            out.println(Integer.toHexString(System.identityHashCode(filter)));
        }

        @Override
        protected Object filterToLabel(PackageParser.ServiceIntentInfo filter) {
            return filter.service;
        }

        @Override
        protected void dumpFilterLabel(PrintWriter out, String prefix, Object label, int count) {
            PackageParser.Service service = (PackageParser.Service)label;
            out.print(prefix);
            out.print(Integer.toHexString(System.identityHashCode(service)));
            out.print(' ');
            service.printComponentShortName(out);
            if (count > 1) {
                out.print(" (");
                out.print(count);
                out.print(" filters)");
            }
            out.println();
        }
    }

    final class ActivityIntentResolver
    extends IntentResolver<PackageParser.ActivityIntentInfo, ResolveInfo> {
        private final ArrayMap<ComponentName, PackageParser.Activity> mActivities = new ArrayMap();
        private int mFlags;

        ActivityIntentResolver() {
        }

        @Override
        public List<ResolveInfo> queryIntent(Intent intent, String resolvedType, boolean defaultOnly, int userId) {
            if (!sUserManager.exists(userId)) {
                return null;
            }
            this.mFlags = defaultOnly ? 65536 : 0;
            return super.queryIntent(intent, resolvedType, defaultOnly, userId);
        }

        public List<ResolveInfo> queryIntent(Intent intent, String resolvedType, int flags, int userId) {
            if (!sUserManager.exists(userId)) {
                return null;
            }
            this.mFlags = flags;
            return super.queryIntent(intent, resolvedType, (flags & 0x10000) != 0, userId);
        }

        public List<ResolveInfo> queryIntentForPackage(Intent intent, String resolvedType, int flags, ArrayList<PackageParser.Activity> packageActivities, int userId) {
            if (!sUserManager.exists(userId)) {
                return null;
            }
            if (packageActivities == null) {
                return null;
            }
            this.mFlags = flags;
            boolean defaultOnly = (flags & 0x10000) != 0;
            int N = packageActivities.size();
            ArrayList<F[]> listCut = new ArrayList<F[]>(N);
            for (int i = 0; i < N; ++i) {
                ArrayList intentFilters = packageActivities.get((int)i).intents;
                if (intentFilters == null || intentFilters.size() <= 0) continue;
                PackageParser.ActivityIntentInfo[] array2 = new PackageParser.ActivityIntentInfo[intentFilters.size()];
                intentFilters.toArray(array2);
                listCut.add(array2);
            }
            return super.queryIntentFromList(intent, resolvedType, defaultOnly, listCut, userId);
        }

        public final void addActivity(PackageParser.Activity a, String type) {
            boolean systemApp = a.info.applicationInfo.isSystemApp();
            this.mActivities.put(a.getComponentName(), a);
            int NI = a.intents.size();
            for (int j = 0; j < NI; ++j) {
                PackageParser.ActivityIntentInfo intent = (PackageParser.ActivityIntentInfo)a.intents.get(j);
                if (!systemApp && intent.getPriority() > 0 && "activity".equals(type)) {
                    intent.setPriority(0);
                    Log.w(PackageManagerService.TAG, "Package " + a.info.applicationInfo.packageName + " has activity " + a.className + " with priority > 0, forcing to 0");
                }
                if (!intent.debugCheck()) {
                    Log.w(PackageManagerService.TAG, "==> For Activity " + a.info.name);
                }
                this.addFilter(intent);
            }
        }

        public final void removeActivity(PackageParser.Activity a, String type) {
            this.mActivities.remove(a.getComponentName());
            int NI = a.intents.size();
            for (int j = 0; j < NI; ++j) {
                PackageParser.ActivityIntentInfo intent = (PackageParser.ActivityIntentInfo)a.intents.get(j);
                this.removeFilter(intent);
            }
        }

        @Override
        protected boolean allowFilterResult(PackageParser.ActivityIntentInfo filter, List<ResolveInfo> dest) {
            ActivityInfo filterAi = filter.activity.info;
            for (int i = dest.size() - 1; i >= 0; --i) {
                ActivityInfo destAi = dest.get((int)i).activityInfo;
                if (destAi.name != filterAi.name || destAi.packageName != filterAi.packageName) continue;
                return false;
            }
            return true;
        }

        protected PackageParser.ActivityIntentInfo[] newArray(int size) {
            return new PackageParser.ActivityIntentInfo[size];
        }

        @Override
        protected boolean isFilterStopped(PackageParser.ActivityIntentInfo filter, int userId) {
            PackageSetting ps;
            if (!sUserManager.exists(userId)) {
                return true;
            }
            PackageParser.Package p = filter.activity.owner;
            if (p != null && (ps = (PackageSetting)p.mExtras) != null) {
                return (ps.pkgFlags & 1) == 0 && ps.getStopped(userId);
            }
            return false;
        }

        @Override
        protected boolean isPackageForFilter(String packageName, PackageParser.ActivityIntentInfo info) {
            return packageName.equals(info.activity.owner.packageName);
        }

        @Override
        protected ResolveInfo newResult(PackageParser.ActivityIntentInfo info, int match, int userId) {
            if (!sUserManager.exists(userId)) {
                return null;
            }
            if (!PackageManagerService.this.mSettings.isEnabledLPr(info.activity.info, this.mFlags, userId)) {
                return null;
            }
            PackageParser.Activity activity = info.activity;
            if (PackageManagerService.this.mSafeMode && (activity.info.applicationInfo.flags & 1) == 0) {
                return null;
            }
            PackageSetting ps = (PackageSetting)activity.owner.mExtras;
            if (ps == null) {
                return null;
            }
            ActivityInfo ai = PackageParser.generateActivityInfo(activity, this.mFlags, ps.readUserState(userId), userId);
            if (ai == null) {
                return null;
            }
            ResolveInfo res = new ResolveInfo();
            res.activityInfo = ai;
            if ((this.mFlags & 0x40) != 0) {
                res.filter = info;
            }
            if (info != null) {
                res.handleAllWebDataURI = info.handleAllWebDataURI();
            }
            res.priority = info.getPriority();
            res.preferredOrder = activity.owner.mPreferredOrder;
            res.match = match;
            res.isDefault = info.hasDefault;
            res.labelRes = info.labelRes;
            res.nonLocalizedLabel = info.nonLocalizedLabel;
            if (PackageManagerService.this.userNeedsBadging(userId)) {
                res.noResourceId = true;
            } else {
                res.icon = info.icon;
            }
            res.iconResourceId = info.icon;
            res.system = res.activityInfo.applicationInfo.isSystemApp();
            return res;
        }

        @Override
        protected void sortResults(List<ResolveInfo> results) {
            Collections.sort(results, mResolvePrioritySorter);
        }

        @Override
        protected void dumpFilter(PrintWriter out, String prefix, PackageParser.ActivityIntentInfo filter) {
            out.print(prefix);
            out.print(Integer.toHexString(System.identityHashCode(filter.activity)));
            out.print(' ');
            filter.activity.printComponentShortName(out);
            out.print(" filter ");
            out.println(Integer.toHexString(System.identityHashCode(filter)));
        }

        @Override
        protected Object filterToLabel(PackageParser.ActivityIntentInfo filter) {
            return filter.activity;
        }

        @Override
        protected void dumpFilterLabel(PrintWriter out, String prefix, Object label, int count) {
            PackageParser.Activity activity = (PackageParser.Activity)label;
            out.print(prefix);
            out.print(Integer.toHexString(System.identityHashCode(activity)));
            out.print(' ');
            activity.printComponentShortName(out);
            if (count > 1) {
                out.print(" (");
                out.print(count);
                out.print(" filters)");
            }
            out.println();
        }
    }

    private static class CrossProfileDomainInfo {
        ResolveInfo resolveInfo;
        int bestDomainVerificationStatus;

        private CrossProfileDomainInfo() {
        }
    }

    class PackageHandler
    extends Handler {
        private boolean mBound;
        final ArrayList<HandlerParams> mPendingInstalls;

        private boolean connectToService() {
            Intent service = new Intent().setComponent(DEFAULT_CONTAINER_COMPONENT);
            Process.setThreadPriority(0);
            if (PackageManagerService.this.mContext.bindServiceAsUser(service, PackageManagerService.this.mDefContainerConn, 1, UserHandle.OWNER)) {
                Process.setThreadPriority(10);
                this.mBound = true;
                return true;
            }
            Process.setThreadPriority(10);
            return false;
        }

        private void disconnectService() {
            PackageManagerService.this.mContainerService = null;
            this.mBound = false;
            Process.setThreadPriority(0);
            PackageManagerService.this.mContext.unbindService(PackageManagerService.this.mDefContainerConn);
            Process.setThreadPriority(10);
        }

        PackageHandler(Looper looper) {
            super(looper);
            this.mBound = false;
            this.mPendingInstalls = new ArrayList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            try {
                this.doHandleMessage(msg);
            }
            finally {
                Process.setThreadPriority(10);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doHandleMessage(Message msg) {
            switch (msg.what) {
                case 5: {
                    HandlerParams params = (HandlerParams)msg.obj;
                    int idx = this.mPendingInstalls.size();
                    if (!this.mBound) {
                        if (!this.connectToService()) {
                            Slog.e(PackageManagerService.TAG, "Failed to bind to media container service");
                            params.serviceError();
                            return;
                        }
                        this.mPendingInstalls.add(idx, params);
                        break;
                    }
                    this.mPendingInstalls.add(idx, params);
                    if (idx != 0) break;
                    PackageManagerService.this.mHandler.sendEmptyMessage(3);
                    break;
                }
                case 3: {
                    if (msg.obj != null) {
                        PackageManagerService.this.mContainerService = (IMediaContainerService)msg.obj;
                    }
                    if (PackageManagerService.this.mContainerService == null) {
                        if (!this.mBound) {
                            Slog.e(PackageManagerService.TAG, "Cannot bind to media container service");
                            for (HandlerParams params : this.mPendingInstalls) {
                                params.serviceError();
                            }
                            this.mPendingInstalls.clear();
                            break;
                        }
                        Slog.w(PackageManagerService.TAG, "Waiting to connect to media container service");
                        break;
                    }
                    if (this.mPendingInstalls.size() > 0) {
                        HandlerParams params = this.mPendingInstalls.get(0);
                        if (params == null || !params.startCopy()) break;
                        if (this.mPendingInstalls.size() > 0) {
                            this.mPendingInstalls.remove(0);
                        }
                        if (this.mPendingInstalls.size() == 0) {
                            if (!this.mBound) break;
                            this.removeMessages(6);
                            Message ubmsg = this.obtainMessage(6);
                            this.sendMessageDelayed(ubmsg, 10000L);
                            break;
                        }
                        PackageManagerService.this.mHandler.sendEmptyMessage(3);
                        break;
                    }
                    Slog.w(PackageManagerService.TAG, "Empty queue");
                    break;
                }
                case 10: {
                    if (this.mPendingInstalls.size() <= 0) break;
                    if (this.mBound) {
                        this.disconnectService();
                    }
                    if (this.connectToService()) break;
                    Slog.e(PackageManagerService.TAG, "Failed to bind to media container service");
                    for (HandlerParams params : this.mPendingInstalls) {
                        params.serviceError();
                    }
                    this.mPendingInstalls.clear();
                    break;
                }
                case 6: {
                    if (this.mPendingInstalls.size() == 0 && PackageManagerService.this.mPendingVerification.size() == 0) {
                        if (!this.mBound) break;
                        this.disconnectService();
                        break;
                    }
                    if (this.mPendingInstalls.size() <= 0) break;
                    PackageManagerService.this.mHandler.sendEmptyMessage(3);
                    break;
                }
                case 11: {
                    this.mPendingInstalls.remove(0);
                    break;
                }
                case 1: {
                    int[] uids;
                    ArrayList[] components;
                    String[] packages;
                    int size = 0;
                    Process.setThreadPriority(0);
                    ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
                    synchronized (arrayMap) {
                        if (PackageManagerService.this.mPendingBroadcasts == null) {
                            return;
                        }
                        size = PackageManagerService.this.mPendingBroadcasts.size();
                        if (size <= 0) {
                            return;
                        }
                        packages = new String[size];
                        components = new ArrayList[size];
                        uids = new int[size];
                        int i = 0;
                        for (int n = 0; n < PackageManagerService.this.mPendingBroadcasts.userIdCount(); ++n) {
                            int packageUserId = PackageManagerService.this.mPendingBroadcasts.userIdAt(n);
                            Iterator<Map.Entry<String, ArrayList<String>>> it = PackageManagerService.this.mPendingBroadcasts.packagesForUserId(packageUserId).entrySet().iterator();
                            while (it.hasNext() && i < size) {
                                Map.Entry<String, ArrayList<String>> ent = it.next();
                                packages[i] = ent.getKey();
                                components[i] = ent.getValue();
                                PackageSetting ps = PackageManagerService.this.mSettings.mPackages.get(ent.getKey());
                                uids[i] = ps != null ? UserHandle.getUid(packageUserId, ps.appId) : -1;
                                ++i;
                            }
                        }
                        size = i;
                        PackageManagerService.this.mPendingBroadcasts.clear();
                    }
                    for (int i = 0; i < size; ++i) {
                        PackageManagerService.this.sendPackageChangedBroadcast(packages[i], true, components[i], uids[i]);
                    }
                    Process.setThreadPriority(10);
                    break;
                }
                case 7: {
                    Process.setThreadPriority(0);
                    String packageName = (String)msg.obj;
                    int userId = msg.arg1;
                    boolean andCode = msg.arg2 != 0;
                    ArrayMap<String, PackageParser.Package> uids = PackageManagerService.this.mPackages;
                    synchronized (uids) {
                        if (userId == -1) {
                            int[] users;
                            for (int user : users = sUserManager.getUserIds()) {
                                PackageManagerService.this.mSettings.addPackageToCleanLPw(new PackageCleanItem(user, packageName, andCode));
                            }
                        } else {
                            PackageManagerService.this.mSettings.addPackageToCleanLPw(new PackageCleanItem(userId, packageName, andCode));
                        }
                    }
                    Process.setThreadPriority(10);
                    PackageManagerService.this.startCleaningPackages();
                    break;
                }
                case 9: {
                    PostInstallData data = PackageManagerService.this.mRunningInstalls.get(msg.arg1);
                    PackageManagerService.this.mRunningInstalls.delete(msg.arg1);
                    boolean deleteOld = false;
                    if (data != null) {
                        Object packageName;
                        InstallArgs args = data.args;
                        PackageInstalledInfo res = data.res;
                        if (res.returnCode == 1) {
                            boolean update;
                            int[] firstUsers;
                            packageName = res.pkg.applicationInfo.packageName;
                            res.removedInfo.sendBroadcast(false, true, false);
                            Bundle extras = new Bundle(1);
                            extras.putInt("android.intent.extra.UID", res.uid);
                            if ((args.installFlags & 0x100) != 0) {
                                PackageManagerService.this.grantRequestedRuntimePermissions(res.pkg, args.user.getIdentifier(), args.installGrantPermissions);
                            }
                            int[] updateUsers = new int[]{};
                            if (res.origUsers == null || res.origUsers.length == 0) {
                                firstUsers = res.newUsers;
                            } else {
                                firstUsers = new int[]{};
                                for (int i = 0; i < res.newUsers.length; ++i) {
                                    int user = res.newUsers[i];
                                    boolean isNew = true;
                                    for (int j = 0; j < res.origUsers.length; ++j) {
                                        if (res.origUsers[j] != user) continue;
                                        isNew = false;
                                        break;
                                    }
                                    if (isNew) {
                                        int[] newFirst = new int[firstUsers.length + 1];
                                        System.arraycopy((int[])firstUsers, (int)0, (int[])newFirst, (int)0, (int)firstUsers.length);
                                        newFirst[firstUsers.length] = user;
                                        firstUsers = newFirst;
                                        continue;
                                    }
                                    int[] newUpdate = new int[updateUsers.length + 1];
                                    System.arraycopy((int[])updateUsers, (int)0, (int[])newUpdate, (int)0, (int)updateUsers.length);
                                    newUpdate[updateUsers.length] = user;
                                    updateUsers = newUpdate;
                                }
                            }
                            PackageManagerService.this.sendPackageBroadcast("android.intent.action.PACKAGE_ADDED", (String)packageName, extras, null, null, firstUsers);
                            boolean bl = update = res.removedInfo.removedPackage != null;
                            if (update) {
                                extras.putBoolean("android.intent.extra.REPLACING", true);
                            }
                            PackageManagerService.this.sendPackageBroadcast("android.intent.action.PACKAGE_ADDED", (String)packageName, extras, null, null, updateUsers);
                            if (update) {
                                PackageManagerService.this.sendPackageBroadcast("android.intent.action.PACKAGE_REPLACED", (String)packageName, extras, null, null, updateUsers);
                                PackageManagerService.this.sendPackageBroadcast("android.intent.action.MY_PACKAGE_REPLACED", null, null, (String)packageName, null, updateUsers);
                                if (res.pkg.isForwardLocked() || PackageManagerService.isExternal(res.pkg)) {
                                    int[] uidArray = new int[]{res.pkg.applicationInfo.uid};
                                    ArrayList<Object> pkgList = new ArrayList<Object>(1);
                                    pkgList.add(packageName);
                                    PackageManagerService.this.sendResourcesChangedBroadcast(true, true, pkgList, uidArray, null);
                                }
                            }
                            if (res.removedInfo.args != null) {
                                deleteOld = true;
                            }
                            if (firstUsers.length > 0 && PackageManagerService.this.packageIsBrowser((String)packageName, firstUsers[0])) {
                                ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
                                synchronized (arrayMap) {
                                    for (int userId : firstUsers) {
                                        PackageManagerService.this.mSettings.setDefaultBrowserPackageNameLPw(null, userId);
                                    }
                                }
                            }
                            EventLog.writeEvent(3110, PackageManagerService.this.getUnknownSourcesSettings());
                        }
                        Runtime.getRuntime().gc();
                        if (deleteOld) {
                            packageName = PackageManagerService.this.mInstallLock;
                            synchronized (packageName) {
                                res.removedInfo.args.doPostDeleteLI(true);
                            }
                        }
                        if (args.observer == null) break;
                        try {
                            Bundle extras = PackageManagerService.this.extrasForInstallResult(res);
                            args.observer.onPackageInstalled(res.name, res.returnCode, res.returnMsg, extras);
                        }
                        catch (RemoteException e) {
                            Slog.i(PackageManagerService.TAG, "Observer no longer exists.");
                        }
                        break;
                    }
                    Slog.e(PackageManagerService.TAG, "Bogus post-install token " + msg.arg1);
                    break;
                }
                case 12: {
                    boolean doGc;
                    boolean reportStatus = msg.arg1 == 1;
                    boolean bl = doGc = msg.arg2 == 1;
                    if (doGc) {
                        Runtime.getRuntime().gc();
                    }
                    if (msg.obj != null) {
                        Set args = (Set)msg.obj;
                        PackageManagerService.this.unloadAllContainers(args);
                    }
                    if (!reportStatus) break;
                    try {
                        PackageHelper.getMountService().finishMediaUpdate();
                    }
                    catch (RemoteException e) {
                        Log.e(PackageManagerService.TAG, "MountService not running?");
                    }
                    break;
                }
                case 13: {
                    Process.setThreadPriority(0);
                    ArrayMap<String, PackageParser.Package> reportStatus = PackageManagerService.this.mPackages;
                    synchronized (reportStatus) {
                        this.removeMessages(13);
                        this.removeMessages(14);
                        PackageManagerService.this.mSettings.writeLPr();
                        PackageManagerService.this.mDirtyUsers.clear();
                    }
                    Process.setThreadPriority(10);
                    break;
                }
                case 14: {
                    Process.setThreadPriority(0);
                    ArrayMap<String, PackageParser.Package> reportStatus = PackageManagerService.this.mPackages;
                    synchronized (reportStatus) {
                        this.removeMessages(14);
                        Iterator i$ = PackageManagerService.this.mDirtyUsers.iterator();
                        while (i$.hasNext()) {
                            int userId = (Integer)i$.next();
                            PackageManagerService.this.mSettings.writePackageRestrictionsLPr(userId);
                        }
                        PackageManagerService.this.mDirtyUsers.clear();
                    }
                    Process.setThreadPriority(10);
                    break;
                }
                case 16: {
                    int verificationId = msg.arg1;
                    PackageVerificationState state = PackageManagerService.this.mPendingVerification.get(verificationId);
                    if (state == null || state.timeoutExtended()) break;
                    InstallArgs args = state.getInstallArgs();
                    Uri originUri = Uri.fromFile(args.origin.resolvedFile);
                    Slog.i(PackageManagerService.TAG, "Verification timed out for " + originUri);
                    PackageManagerService.this.mPendingVerification.remove(verificationId);
                    int ret = -22;
                    if (PackageManagerService.this.getDefaultVerificationResponse() == 1) {
                        Slog.i(PackageManagerService.TAG, "Continuing with installation of " + originUri);
                        state.setVerifierResponse(Binder.getCallingUid(), 2);
                        PackageManagerService.this.broadcastPackageVerified(verificationId, originUri, 1, state.getInstallArgs().getUser());
                        try {
                            ret = args.copyApk(PackageManagerService.this.mContainerService, true);
                        }
                        catch (RemoteException e) {
                            Slog.e(PackageManagerService.TAG, "Could not contact the ContainerService");
                        }
                    } else {
                        PackageManagerService.this.broadcastPackageVerified(verificationId, originUri, -1, state.getInstallArgs().getUser());
                    }
                    PackageManagerService.this.processPendingInstall(args, ret);
                    PackageManagerService.this.mHandler.sendEmptyMessage(6);
                    break;
                }
                case 15: {
                    int ret;
                    int verificationId = msg.arg1;
                    PackageVerificationState state = PackageManagerService.this.mPendingVerification.get(verificationId);
                    if (state == null) {
                        Slog.w(PackageManagerService.TAG, "Invalid verification token " + verificationId + " received");
                        break;
                    }
                    PackageVerificationResponse response = (PackageVerificationResponse)msg.obj;
                    state.setVerifierResponse(response.callerUid, response.code);
                    if (!state.isVerificationComplete()) break;
                    PackageManagerService.this.mPendingVerification.remove(verificationId);
                    InstallArgs args = state.getInstallArgs();
                    Uri originUri = Uri.fromFile(args.origin.resolvedFile);
                    if (state.isInstallAllowed()) {
                        ret = -110;
                        PackageManagerService.this.broadcastPackageVerified(verificationId, originUri, response.code, state.getInstallArgs().getUser());
                        try {
                            ret = args.copyApk(PackageManagerService.this.mContainerService, true);
                        }
                        catch (RemoteException e) {
                            Slog.e(PackageManagerService.TAG, "Could not contact the ContainerService");
                        }
                    } else {
                        ret = -22;
                    }
                    PackageManagerService.this.processPendingInstall(args, ret);
                    PackageManagerService.this.mHandler.sendEmptyMessage(6);
                    break;
                }
                case 17: {
                    IFVerificationParams params = (IFVerificationParams)msg.obj;
                    PackageManagerService.this.verifyIntentFiltersIfNeeded(params.userId, params.verifierUid, params.replacing, params.pkg);
                    break;
                }
                case 18: {
                    int verificationId = msg.arg1;
                    IntentFilterVerificationState state = PackageManagerService.this.mIntentFilterVerificationStates.get(verificationId);
                    if (state == null) {
                        Slog.w(PackageManagerService.TAG, "Invalid IntentFilter verification token " + verificationId + " received");
                        break;
                    }
                    int userId = state.getUserId();
                    IntentFilterVerificationResponse response = (IntentFilterVerificationResponse)msg.obj;
                    state.setVerifierResponse(response.callerUid, response.code);
                    if (response.code == -1) {
                        // empty if block
                    }
                    if (!state.isVerificationComplete()) break;
                    PackageManagerService.this.mIntentFilterVerifier.receiveVerificationResponse(verificationId);
                    break;
                }
            }
        }
    }

    private class PackageUsage {
        private static final int WRITE_INTERVAL = 1800000;
        private final Object mFileLock = new Object();
        private final AtomicLong mLastWritten = new AtomicLong(0L);
        private final AtomicBoolean mBackgroundWriteRunning = new AtomicBoolean(false);
        private boolean mIsHistoricalPackageUsageAvailable = true;

        private PackageUsage() {
        }

        boolean isHistoricalPackageUsageAvailable() {
            return this.mIsHistoricalPackageUsageAvailable;
        }

        void write(boolean force) {
            if (force) {
                this.writeInternal();
                return;
            }
            if (SystemClock.elapsedRealtime() - this.mLastWritten.get() < 1800000L) {
                return;
            }
            if (this.mBackgroundWriteRunning.compareAndSet(false, true)) {
                new Thread("PackageUsage_DiskWriter"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            PackageUsage.this.writeInternal();
                        }
                        finally {
                            PackageUsage.this.mBackgroundWriteRunning.set(false);
                        }
                    }
                }.start();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeInternal() {
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                Object object = this.mFileLock;
                synchronized (object) {
                    AtomicFile file = this.getFile();
                    FileOutputStream f = null;
                    try {
                        f = file.startWrite();
                        BufferedOutputStream out = new BufferedOutputStream(f);
                        FileUtils.setPermissions(file.getBaseFile().getPath(), 416, 1000, 1032);
                        StringBuilder sb = new StringBuilder();
                        for (PackageParser.Package pkg : PackageManagerService.this.mPackages.values()) {
                            if (pkg.mLastPackageUsageTimeInMills == 0L) continue;
                            sb.setLength(0);
                            sb.append(pkg.packageName);
                            sb.append(' ');
                            sb.append(pkg.mLastPackageUsageTimeInMills);
                            sb.append('\n');
                            out.write(sb.toString().getBytes(StandardCharsets.US_ASCII));
                        }
                        out.flush();
                        file.finishWrite(f);
                    }
                    catch (IOException e) {
                        if (f != null) {
                            file.failWrite(f);
                        }
                        Log.e(PackageManagerService.TAG, "Failed to write package usage times", e);
                    }
                }
            }
            this.mLastWritten.set(SystemClock.elapsedRealtime());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        void readLP() {
            Object object = this.mFileLock;
            synchronized (object) {
                AtomicFile file = this.getFile();
                BufferedInputStream in = null;
                try {
                    String packageName;
                    in = new BufferedInputStream(file.openRead());
                    StringBuffer sb = new StringBuffer();
                    while ((packageName = this.readToken(in, sb, ' ')) != null) {
                        long timeInMillis;
                        String timeInMillisString = this.readToken(in, sb, '\n');
                        if (timeInMillisString == null) {
                            throw new IOException("Failed to find last usage time for package " + packageName);
                        }
                        PackageParser.Package pkg = PackageManagerService.this.mPackages.get(packageName);
                        if (pkg == null) continue;
                        try {
                            timeInMillis = Long.parseLong(timeInMillisString.toString());
                        }
                        catch (NumberFormatException e) {
                            throw new IOException("Failed to parse " + timeInMillisString + " as a long.", e);
                        }
                        pkg.mLastPackageUsageTimeInMills = timeInMillis;
                    }
                }
                catch (FileNotFoundException expected) {
                    this.mIsHistoricalPackageUsageAvailable = false;
                    IoUtils.closeQuietly(in);
                }
                catch (IOException e) {
                    Log.w(PackageManagerService.TAG, "Failed to read package usage times", e);
                    {
                        catch (Throwable throwable) {
                            IoUtils.closeQuietly(in);
                            throw throwable;
                        }
                    }
                    IoUtils.closeQuietly(in);
                }
                IoUtils.closeQuietly(in);
            }
            this.mLastWritten.set(SystemClock.elapsedRealtime());
        }

        private String readToken(InputStream in, StringBuffer sb, char endOfToken) throws IOException {
            sb.setLength(0);
            while (true) {
                int ch;
                if ((ch = in.read()) == -1) {
                    if (sb.length() == 0) {
                        return null;
                    }
                    throw new IOException("Unexpected EOF");
                }
                if (ch == endOfToken) {
                    return sb.toString();
                }
                sb.append((char)ch);
            }
        }

        private AtomicFile getFile() {
            File dataDir = Environment.getDataDirectory();
            File systemDir = new File(dataDir, "system");
            File fname = new File(systemDir, "package-usage.list");
            return new AtomicFile(fname);
        }
    }

    class PostInstallData {
        public InstallArgs args;
        public PackageInstalledInfo res;

        PostInstallData(InstallArgs _a, PackageInstalledInfo _r) {
            this.args = _a;
            this.res = _r;
        }
    }

    class DefaultContainerConnection
    implements ServiceConnection {
        DefaultContainerConnection() {
        }

        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            IMediaContainerService imcs = IMediaContainerService.Stub.asInterface(service);
            PackageManagerService.this.mHandler.sendMessage(PackageManagerService.this.mHandler.obtainMessage(3, imcs));
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
        }
    }

    static class PendingPackageBroadcasts {
        final SparseArray<ArrayMap<String, ArrayList<String>>> mUidMap = new SparseArray(2);

        public ArrayList<String> get(int userId, String packageName) {
            ArrayMap<String, ArrayList<String>> packages = this.getOrAllocate(userId);
            return packages.get(packageName);
        }

        public void put(int userId, String packageName, ArrayList<String> components) {
            ArrayMap<String, ArrayList<String>> packages = this.getOrAllocate(userId);
            packages.put(packageName, components);
        }

        public void remove(int userId, String packageName) {
            ArrayMap<String, ArrayList<String>> packages = this.mUidMap.get(userId);
            if (packages != null) {
                packages.remove(packageName);
            }
        }

        public void remove(int userId) {
            this.mUidMap.remove(userId);
        }

        public int userIdCount() {
            return this.mUidMap.size();
        }

        public int userIdAt(int n) {
            return this.mUidMap.keyAt(n);
        }

        public ArrayMap<String, ArrayList<String>> packagesForUserId(int userId) {
            return this.mUidMap.get(userId);
        }

        public int size() {
            int num = 0;
            for (int i = 0; i < this.mUidMap.size(); ++i) {
                num += this.mUidMap.valueAt(i).size();
            }
            return num;
        }

        public void clear() {
            this.mUidMap.clear();
        }

        private ArrayMap<String, ArrayList<String>> getOrAllocate(int userId) {
            ArrayMap<String, ArrayList<String>> map = this.mUidMap.get(userId);
            if (map == null) {
                map = new ArrayMap();
                this.mUidMap.put(userId, map);
            }
            return map;
        }
    }

    private class IntentVerifierProxy
    implements IntentFilterVerifier<PackageParser.ActivityIntentInfo> {
        private Context mContext;
        private ComponentName mIntentFilterVerifierComponent;
        private ArrayList<Integer> mCurrentIntentFilterVerifications = new ArrayList();

        public IntentVerifierProxy(Context context, ComponentName verifierComponent) {
            this.mContext = context;
            this.mIntentFilterVerifierComponent = verifierComponent;
        }

        private String getDefaultScheme() {
            return "https";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void startVerifications(int userId) {
            int count = this.mCurrentIntentFilterVerifications.size();
            for (int n = 0; n < count; ++n) {
                int verificationId = this.mCurrentIntentFilterVerifications.get(n);
                IntentFilterVerificationState ivs = PackageManagerService.this.mIntentFilterVerificationStates.get(verificationId);
                String packageName = ivs.getPackageName();
                ArrayList<PackageParser.ActivityIntentInfo> filters = ivs.getFilters();
                int filterCount = filters.size();
                ArraySet<String> domainsSet = new ArraySet<String>();
                for (int m = 0; m < filterCount; ++m) {
                    PackageParser.ActivityIntentInfo filter = filters.get(m);
                    domainsSet.addAll(filter.getHostsList());
                }
                ArrayList<String> domainsList = new ArrayList<String>(domainsSet);
                ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
                synchronized (arrayMap) {
                    if (PackageManagerService.this.mSettings.createIntentFilterVerificationIfNeededLPw(packageName, domainsList) != null) {
                        PackageManagerService.this.scheduleWriteSettingsLocked();
                    }
                }
                this.sendVerificationRequest(userId, verificationId, ivs);
            }
            this.mCurrentIntentFilterVerifications.clear();
        }

        private void sendVerificationRequest(int userId, int verificationId, IntentFilterVerificationState ivs) {
            Intent verificationIntent = new Intent("android.intent.action.INTENT_FILTER_NEEDS_VERIFICATION");
            verificationIntent.putExtra("android.content.pm.extra.INTENT_FILTER_VERIFICATION_ID", verificationId);
            verificationIntent.putExtra("android.content.pm.extra.INTENT_FILTER_VERIFICATION_URI_SCHEME", this.getDefaultScheme());
            verificationIntent.putExtra("android.content.pm.extra.INTENT_FILTER_VERIFICATION_HOSTS", ivs.getHostsString());
            verificationIntent.putExtra("android.content.pm.extra.INTENT_FILTER_VERIFICATION_PACKAGE_NAME", ivs.getPackageName());
            verificationIntent.setComponent(this.mIntentFilterVerifierComponent);
            verificationIntent.addFlags(0x10000000);
            UserHandle user = new UserHandle(userId);
            this.mContext.sendBroadcastAsUser(verificationIntent, user);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void receiveVerificationResponse(int verificationId) {
            IntentFilterVerificationState ivs = PackageManagerService.this.mIntentFilterVerificationStates.get(verificationId);
            boolean verified = ivs.isVerified();
            ArrayList<PackageParser.ActivityIntentInfo> filters = ivs.getFilters();
            int count = filters.size();
            for (int n = 0; n < count; ++n) {
                PackageParser.ActivityIntentInfo filter = filters.get(n);
                filter.setVerified(verified);
            }
            PackageManagerService.this.mIntentFilterVerificationStates.remove(verificationId);
            String packageName = ivs.getPackageName();
            IntentFilterVerificationInfo ivi = null;
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                ivi = PackageManagerService.this.mSettings.getIntentFilterVerificationLPr(packageName);
            }
            if (ivi == null) {
                Slog.w(PackageManagerService.TAG, "IntentFilterVerificationInfo not found for verificationId:" + verificationId + " packageName:" + packageName);
                return;
            }
            arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                if (verified) {
                    ivi.setStatus(2);
                } else {
                    ivi.setStatus(1);
                }
                PackageManagerService.this.scheduleWriteSettingsLocked();
                int userId = ivs.getUserId();
                if (userId != -1) {
                    int userStatus = PackageManagerService.this.mSettings.getIntentFilterVerificationStatusLPr(packageName, userId);
                    int updatedStatus = 0;
                    boolean needUpdate = false;
                    switch (userStatus) {
                        case 0: {
                            updatedStatus = verified ? 2 : 1;
                            needUpdate = true;
                            break;
                        }
                        case 1: {
                            if (!verified) break;
                            updatedStatus = 2;
                            needUpdate = true;
                            break;
                        }
                    }
                    if (needUpdate) {
                        PackageManagerService.this.mSettings.updateIntentFilterVerificationStatusLPw(packageName, updatedStatus, userId);
                        PackageManagerService.this.scheduleWritePackageRestrictionsLocked(userId);
                    }
                }
            }
        }

        @Override
        public boolean addOneIntentFilterVerification(int verifierUid, int userId, int verificationId, PackageParser.ActivityIntentInfo filter, String packageName) {
            if (!PackageManagerService.hasValidDomains(filter)) {
                return false;
            }
            IntentFilterVerificationState ivs = PackageManagerService.this.mIntentFilterVerificationStates.get(verificationId);
            if (ivs == null) {
                ivs = this.createDomainVerificationState(verifierUid, userId, verificationId, packageName);
            }
            ivs.addFilter(filter);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private IntentFilterVerificationState createDomainVerificationState(int verifierUid, int userId, int verificationId, String packageName) {
            IntentFilterVerificationState ivs = new IntentFilterVerificationState(verifierUid, userId, packageName);
            ivs.setPendingState();
            ArrayMap<String, PackageParser.Package> arrayMap = PackageManagerService.this.mPackages;
            synchronized (arrayMap) {
                PackageManagerService.this.mIntentFilterVerificationStates.append(verificationId, ivs);
                this.mCurrentIntentFilterVerifications.add(verificationId);
            }
            return ivs;
        }
    }

    private static interface IntentFilterVerifier<T extends IntentFilter> {
        public boolean addOneIntentFilterVerification(int var1, int var2, int var3, T var4, String var5);

        public void startVerifications(int var1);

        public void receiveVerificationResponse(int var1);
    }

    private static class IFVerificationParams {
        PackageParser.Package pkg;
        boolean replacing;
        int userId;
        int verifierUid;

        public IFVerificationParams(PackageParser.Package _pkg, boolean _replacing, int _userId, int _verifierUid) {
            this.pkg = _pkg;
            this.replacing = _replacing;
            this.userId = _userId;
            this.replacing = _replacing;
            this.verifierUid = _verifierUid;
        }
    }

    public static final class SharedLibraryEntry {
        public final String path;
        public final String apk;

        SharedLibraryEntry(String _path, String _apk) {
            this.path = _path;
            this.apk = _apk;
        }
    }
}

