/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.content.pm.PackageParser;
import android.content.pm.Signature;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

final class Policy {
    private final String mSeinfo;
    private final boolean mDefaultStanza;
    private final Set<Signature> mCerts;
    private final Map<String, String> mPkgMap;

    private Policy(PolicyBuilder builder) {
        this.mSeinfo = builder.mSeinfo;
        this.mDefaultStanza = builder.mDefaultStanza;
        this.mCerts = Collections.unmodifiableSet(builder.mCerts);
        this.mPkgMap = Collections.unmodifiableMap(builder.mPkgMap);
    }

    public Set<Signature> getSignatures() {
        return this.mCerts;
    }

    public boolean isDefaultStanza() {
        return this.mDefaultStanza;
    }

    public boolean hasInnerPackages() {
        return !this.mPkgMap.isEmpty();
    }

    public Map<String, String> getInnerPackages() {
        return this.mPkgMap;
    }

    public boolean hasGlobalSeinfo() {
        return this.mSeinfo != null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.mDefaultStanza) {
            sb.append("defaultStanza=true ");
        }
        for (Signature cert : this.mCerts) {
            sb.append("cert=" + cert.toCharsString().substring(0, 11) + "... ");
        }
        if (this.mSeinfo != null) {
            sb.append("seinfo=" + this.mSeinfo);
        }
        for (String name : this.mPkgMap.keySet()) {
            sb.append(" " + name + "=" + this.mPkgMap.get(name));
        }
        return sb.toString();
    }

    public String getMatchedSeinfo(PackageParser.Package pkg) {
        if (!this.mDefaultStanza) {
            Signature[] certs = this.mCerts.toArray(new Signature[0]);
            if (!Signature.areExactMatch(certs, pkg.mSignatures)) {
                return null;
            }
            String seinfoValue = this.mPkgMap.get(pkg.packageName);
            if (seinfoValue != null) {
                return seinfoValue;
            }
        }
        return this.mSeinfo;
    }

    public static final class PolicyBuilder {
        private String mSeinfo;
        private boolean mDefaultStanza;
        private final Set<Signature> mCerts = new HashSet<Signature>(2);
        private final Map<String, String> mPkgMap = new HashMap<String, String>(2);

        public PolicyBuilder setAsDefaultPolicy() {
            this.mDefaultStanza = true;
            return this;
        }

        public PolicyBuilder addSignature(String cert) {
            if (cert == null) {
                String err = "Invalid signature value " + cert;
                throw new IllegalArgumentException(err);
            }
            this.mCerts.add(new Signature(cert));
            return this;
        }

        public PolicyBuilder setGlobalSeinfoOrThrow(String seinfo) {
            if (!this.validateValue(seinfo)) {
                String err = "Invalid seinfo value " + seinfo;
                throw new IllegalArgumentException(err);
            }
            if (this.mSeinfo != null && !this.mSeinfo.equals(seinfo)) {
                String err = "Duplicate seinfo tag found";
                throw new IllegalStateException(err);
            }
            this.mSeinfo = seinfo;
            return this;
        }

        public PolicyBuilder addInnerPackageMapOrThrow(String pkgName, String seinfo) {
            if (!this.validateValue(pkgName)) {
                String err = "Invalid package name " + pkgName;
                throw new IllegalArgumentException(err);
            }
            if (!this.validateValue(seinfo)) {
                String err = "Invalid seinfo value " + seinfo;
                throw new IllegalArgumentException(err);
            }
            String pkgValue = this.mPkgMap.get(pkgName);
            if (pkgValue != null && !pkgValue.equals(seinfo)) {
                String err = "Conflicting seinfo value found";
                throw new IllegalStateException(err);
            }
            this.mPkgMap.put(pkgName, seinfo);
            return this;
        }

        private boolean validateValue(String name) {
            if (name == null) {
                return false;
            }
            return name.matches("\\A[\\.\\w]+\\z");
        }

        public Policy build() {
            Policy p = new Policy(this);
            if (p.mDefaultStanza) {
                if (p.mSeinfo == null) {
                    String err = "Missing global seinfo tag with default stanza.";
                    throw new IllegalStateException(err);
                }
                if (p.mCerts.size() != 0) {
                    String err = "Certs not allowed with default stanza.";
                    throw new IllegalStateException(err);
                }
                if (!p.mPkgMap.isEmpty()) {
                    String err = "Inner package mappings not allowed with default stanza.";
                    throw new IllegalStateException(err);
                }
            } else {
                if (p.mCerts.size() == 0) {
                    String err = "Missing certs with signer tag. Expecting at least one.";
                    throw new IllegalStateException(err);
                }
                if (!(p.mSeinfo == null ^ p.mPkgMap.isEmpty())) {
                    String err = "Only seinfo tag XOR package tags are allowed within a signer stanza.";
                    throw new IllegalStateException(err);
                }
            }
            return p;
        }
    }
}

