/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.content.pm.PackageParser;
import android.os.Environment;
import android.util.Slog;
import android.util.Xml;
import com.android.server.pm.Policy;
import com.android.server.pm.PolicyComparator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import libcore.io.IoUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class SELinuxMMAC {
    static final String TAG = "SELinuxMMAC";
    private static final boolean DEBUG_POLICY = false;
    private static final boolean DEBUG_POLICY_INSTALL = false;
    private static final boolean DEBUG_POLICY_ORDER = false;
    private static List<Policy> sPolicies = new ArrayList<Policy>();
    private static final String DATA_VERSION_FILE = Environment.getDataDirectory() + "/security/current/selinux_version";
    private static final String BASE_VERSION_FILE = "/selinux_version";
    private static final boolean USE_OVERRIDE_POLICY = SELinuxMMAC.useOverridePolicy();
    private static final String DATA_MAC_PERMISSIONS = Environment.getDataDirectory() + "/security/current/mac_permissions.xml";
    private static final String BASE_MAC_PERMISSIONS = Environment.getRootDirectory() + "/etc/security/mac_permissions.xml";
    private static final String MAC_PERMISSIONS = USE_OVERRIDE_POLICY ? DATA_MAC_PERMISSIONS : BASE_MAC_PERMISSIONS;
    private static final String DATA_SEAPP_CONTEXTS = Environment.getDataDirectory() + "/security/current/seapp_contexts";
    private static final String BASE_SEAPP_CONTEXTS = "/seapp_contexts";
    private static final String SEAPP_CONTEXTS = USE_OVERRIDE_POLICY ? DATA_SEAPP_CONTEXTS : "/seapp_contexts";
    private static final String SEAPP_HASH_FILE = Environment.getDataDirectory().toString() + "/system/seapp_hash";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean readInstallPolicy() {
        ArrayList<Policy> policies = new ArrayList<Policy>();
        FileReader policyFile = null;
        XmlPullParser parser = Xml.newPullParser();
        try {
            policyFile = new FileReader(MAC_PERMISSIONS);
            Slog.d(TAG, "Using policy file " + MAC_PERMISSIONS);
            parser.setInput(policyFile);
            parser.nextTag();
            parser.require(2, null, "policy");
            block17: while (parser.next() != 3) {
                if (parser.getEventType() != 2) continue;
                switch (parser.getName()) {
                    case "signer": {
                        policies.add(SELinuxMMAC.readSignerOrThrow(parser));
                        continue block17;
                    }
                    case "default": {
                        policies.add(SELinuxMMAC.readDefaultOrThrow(parser));
                        continue block17;
                    }
                }
                SELinuxMMAC.skip(parser);
            }
        }
        catch (IllegalArgumentException | IllegalStateException | XmlPullParserException ex) {
            StringBuilder sb = new StringBuilder("Exception @");
            sb.append(parser.getPositionDescription());
            sb.append(" while parsing ");
            sb.append(MAC_PERMISSIONS);
            sb.append(":");
            sb.append(ex);
            Slog.w(TAG, sb.toString());
            boolean bl = false;
            IoUtils.closeQuietly(policyFile);
            return bl;
        }
        catch (IOException ioe) {
            Slog.w(TAG, "Exception parsing " + MAC_PERMISSIONS, ioe);
            boolean bl = false;
            {
                catch (Throwable throwable) {
                    IoUtils.closeQuietly(policyFile);
                    throw throwable;
                }
            }
            IoUtils.closeQuietly(policyFile);
            return bl;
        }
        IoUtils.closeQuietly(policyFile);
        PolicyComparator policySort = new PolicyComparator();
        Collections.sort(policies, policySort);
        if (policySort.foundDuplicate()) {
            Slog.w(TAG, "ERROR! Duplicate entries found parsing " + MAC_PERMISSIONS);
            return false;
        }
        List<Policy> list = sPolicies;
        synchronized (list) {
            sPolicies = policies;
        }
        return true;
    }

    private static Policy readSignerOrThrow(XmlPullParser parser) throws IOException, XmlPullParserException {
        parser.require(2, null, "signer");
        Policy.PolicyBuilder pb = new Policy.PolicyBuilder();
        String cert = parser.getAttributeValue(null, "signature");
        if (cert != null) {
            pb.addSignature(cert);
        }
        while (parser.next() != 3) {
            if (parser.getEventType() != 2) continue;
            String tagName = parser.getName();
            if ("seinfo".equals(tagName)) {
                String seinfo = parser.getAttributeValue(null, "value");
                pb.setGlobalSeinfoOrThrow(seinfo);
                SELinuxMMAC.readSeinfo(parser);
                continue;
            }
            if ("package".equals(tagName)) {
                SELinuxMMAC.readPackageOrThrow(parser, pb);
                continue;
            }
            if ("cert".equals(tagName)) {
                String sig = parser.getAttributeValue(null, "signature");
                pb.addSignature(sig);
                SELinuxMMAC.readCert(parser);
                continue;
            }
            SELinuxMMAC.skip(parser);
        }
        return pb.build();
    }

    private static Policy readDefaultOrThrow(XmlPullParser parser) throws IOException, XmlPullParserException {
        parser.require(2, null, "default");
        Policy.PolicyBuilder pb = new Policy.PolicyBuilder();
        pb.setAsDefaultPolicy();
        while (parser.next() != 3) {
            if (parser.getEventType() != 2) continue;
            String tagName = parser.getName();
            if ("seinfo".equals(tagName)) {
                String seinfo = parser.getAttributeValue(null, "value");
                pb.setGlobalSeinfoOrThrow(seinfo);
                SELinuxMMAC.readSeinfo(parser);
                continue;
            }
            SELinuxMMAC.skip(parser);
        }
        return pb.build();
    }

    private static void readPackageOrThrow(XmlPullParser parser, Policy.PolicyBuilder pb) throws IOException, XmlPullParserException {
        parser.require(2, null, "package");
        String pkgName = parser.getAttributeValue(null, "name");
        while (parser.next() != 3) {
            if (parser.getEventType() != 2) continue;
            String tagName = parser.getName();
            if ("seinfo".equals(tagName)) {
                String seinfo = parser.getAttributeValue(null, "value");
                pb.addInnerPackageMapOrThrow(pkgName, seinfo);
                SELinuxMMAC.readSeinfo(parser);
                continue;
            }
            SELinuxMMAC.skip(parser);
        }
    }

    private static void readCert(XmlPullParser parser) throws IOException, XmlPullParserException {
        parser.require(2, null, "cert");
        parser.nextTag();
    }

    private static void readSeinfo(XmlPullParser parser) throws IOException, XmlPullParserException {
        parser.require(2, null, "seinfo");
        parser.nextTag();
    }

    private static void skip(XmlPullParser p) throws IOException, XmlPullParserException {
        if (p.getEventType() != 2) {
            throw new IllegalStateException();
        }
        int depth = 1;
        while (depth != 0) {
            switch (p.next()) {
                case 3: {
                    --depth;
                    break;
                }
                case 2: {
                    ++depth;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean assignSeinfoValue(PackageParser.Package pkg) {
        List<Policy> list = sPolicies;
        synchronized (list) {
            for (Policy policy : sPolicies) {
                String seinfo = policy.getMatchedSeinfo(pkg);
                if (seinfo == null) continue;
                pkg.applicationInfo.seinfo = seinfo;
                return true;
            }
        }
        return false;
    }

    public static boolean shouldRestorecon() {
        byte[] currentHash = null;
        try {
            currentHash = SELinuxMMAC.returnHash(SEAPP_CONTEXTS);
        }
        catch (IOException ioe) {
            Slog.e(TAG, "Error with hashing seapp_contexts.", ioe);
            return false;
        }
        byte[] storedHash = null;
        try {
            storedHash = IoUtils.readFileAsByteArray(SEAPP_HASH_FILE);
        }
        catch (IOException ioe) {
            Slog.w(TAG, "Error opening " + SEAPP_HASH_FILE + ". Assuming first boot.");
        }
        return storedHash == null || !MessageDigest.isEqual(storedHash, currentHash);
    }

    public static void setRestoreconDone() {
        try {
            byte[] currentHash = SELinuxMMAC.returnHash(SEAPP_CONTEXTS);
            SELinuxMMAC.dumpHash(new File(SEAPP_HASH_FILE), currentHash);
        }
        catch (IOException ioe) {
            Slog.e(TAG, "Error with saving hash to " + SEAPP_HASH_FILE, ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpHash(File file, byte[] content) throws IOException {
        FileOutputStream fos;
        block4: {
            fos = null;
            File tmp = null;
            try {
                tmp = File.createTempFile("seapp_hash", ".journal", file.getParentFile());
                tmp.setReadable(true);
                fos = new FileOutputStream(tmp);
                fos.write(content);
                fos.getFD().sync();
                if (!tmp.renameTo(file)) {
                    throw new IOException("Failure renaming " + file.getCanonicalPath());
                }
                if (tmp == null) break block4;
                tmp.delete();
            }
            catch (Throwable throwable) {
                if (tmp != null) {
                    tmp.delete();
                }
                IoUtils.closeQuietly(fos);
                throw throwable;
            }
        }
        IoUtils.closeQuietly(fos);
    }

    private static byte[] returnHash(String file) throws IOException {
        try {
            byte[] contents = IoUtils.readFileAsByteArray(file);
            return MessageDigest.getInstance("SHA-1").digest(contents);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException(nsae);
        }
    }

    private static boolean useOverridePolicy() {
        try {
            String overrideVersion = IoUtils.readFileAsString(DATA_VERSION_FILE);
            String baseVersion = IoUtils.readFileAsString(BASE_VERSION_FILE);
            if (overrideVersion.equals(baseVersion)) {
                return true;
            }
            Slog.e(TAG, "Override policy version '" + overrideVersion + "' doesn't match " + "base version '" + baseVersion + "'. Skipping override policy files.");
        }
        catch (FileNotFoundException fnfe) {
        }
        catch (IOException ioe) {
            Slog.w(TAG, "Skipping override policy files.", ioe);
        }
        return false;
    }
}

