/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.app.ActivityManager;
import android.app.ActivityManagerNative;
import android.app.IStopUserCallback;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.UserInfo;
import android.graphics.Bitmap;
import android.os.Binder;
import android.os.Bundle;
import android.os.Environment;
import android.os.FileUtils;
import android.os.Handler;
import android.os.IUserManager;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.storage.StorageManager;
import android.os.storage.VolumeInfo;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.util.AtomicFile;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.TimeUtils;
import android.util.Xml;
import com.android.internal.app.IAppOpsService;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.XmlUtils;
import com.android.server.pm.PackageManagerService;
import com.google.android.collect.Sets;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import libcore.io.IoUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class UserManagerService
extends IUserManager.Stub {
    private static final String LOG_TAG = "UserManagerService";
    private static final boolean DBG = false;
    private static final String TAG_NAME = "name";
    private static final String ATTR_FLAGS = "flags";
    private static final String ATTR_ICON_PATH = "icon";
    private static final String ATTR_ID = "id";
    private static final String ATTR_CREATION_TIME = "created";
    private static final String ATTR_LAST_LOGGED_IN_TIME = "lastLoggedIn";
    private static final String ATTR_SERIAL_NO = "serialNumber";
    private static final String ATTR_NEXT_SERIAL_NO = "nextSerialNumber";
    private static final String ATTR_PARTIAL = "partial";
    private static final String ATTR_GUEST_TO_REMOVE = "guestToRemove";
    private static final String ATTR_USER_VERSION = "version";
    private static final String ATTR_PROFILE_GROUP_ID = "profileGroupId";
    private static final String TAG_GUEST_RESTRICTIONS = "guestRestrictions";
    private static final String TAG_USERS = "users";
    private static final String TAG_USER = "user";
    private static final String TAG_RESTRICTIONS = "restrictions";
    private static final String TAG_ENTRY = "entry";
    private static final String TAG_VALUE = "value";
    private static final String ATTR_KEY = "key";
    private static final String ATTR_VALUE_TYPE = "type";
    private static final String ATTR_MULTIPLE = "m";
    private static final String ATTR_TYPE_STRING_ARRAY = "sa";
    private static final String ATTR_TYPE_STRING = "s";
    private static final String ATTR_TYPE_BOOLEAN = "b";
    private static final String ATTR_TYPE_INTEGER = "i";
    private static final String ATTR_TYPE_BUNDLE = "B";
    private static final String ATTR_TYPE_BUNDLE_ARRAY = "BA";
    private static final String USER_INFO_DIR = "system" + File.separator + "users";
    private static final String USER_LIST_FILENAME = "userlist.xml";
    private static final String USER_PHOTO_FILENAME = "photo.png";
    private static final String USER_PHOTO_FILENAME_TMP = "photo.png.tmp";
    private static final String RESTRICTIONS_FILE_PREFIX = "res_";
    private static final String XML_SUFFIX = ".xml";
    private static final int MIN_USER_ID = 10;
    private static final int USER_VERSION = 5;
    private static final long EPOCH_PLUS_30_YEARS = 946080000000L;
    private static final int MAX_MANAGED_PROFILES = 1;
    private static final boolean CONFIG_PROFILES_SHARE_CREDENTIAL = true;
    private static final Set<String> SYSTEM_CONTROLLED_RESTRICTIONS = Sets.newArraySet("no_record_audio");
    static final int WRITE_USER_MSG = 1;
    static final int WRITE_USER_DELAY = 2000;
    private static final String XATTR_SERIAL = "user.serial";
    private final Context mContext;
    private final PackageManagerService mPm;
    private final Object mInstallLock;
    private final Object mPackagesLock;
    private final Handler mHandler;
    private final File mUsersDir;
    private final File mUserListFile;
    private final SparseArray<UserInfo> mUsers = new SparseArray();
    private final SparseArray<Bundle> mUserRestrictions = new SparseArray();
    private final Bundle mGuestRestrictions = new Bundle();
    private final SparseBooleanArray mRemovingUserIds = new SparseBooleanArray();
    private int[] mUserIds;
    private int mNextSerialNumber;
    private int mUserVersion = 0;
    private IAppOpsService mAppOpsService;
    private static UserManagerService sInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UserManagerService getInstance() {
        Class<UserManagerService> clazz = UserManagerService.class;
        synchronized (UserManagerService.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    UserManagerService(File dataDir, File baseUserPath) {
        this(null, null, new Object(), new Object(), dataDir, baseUserPath);
    }

    UserManagerService(Context context, PackageManagerService pm, Object installLock, Object packagesLock) {
        this(context, pm, installLock, packagesLock, Environment.getDataDirectory(), new File(Environment.getDataDirectory(), TAG_USER));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserManagerService(Context context, PackageManagerService pm, Object installLock, Object packagesLock, File dataDir, File baseUserPath) {
        this.mContext = context;
        this.mPm = pm;
        this.mInstallLock = installLock;
        this.mPackagesLock = packagesLock;
        this.mHandler = new MainHandler();
        Object object = this.mInstallLock;
        synchronized (object) {
            Object object2 = this.mPackagesLock;
            synchronized (object2) {
                this.mUsersDir = new File(dataDir, USER_INFO_DIR);
                this.mUsersDir.mkdirs();
                File userZeroDir = new File(this.mUsersDir, "0");
                userZeroDir.mkdirs();
                FileUtils.setPermissions(this.mUsersDir.toString(), 509, -1, -1);
                this.mUserListFile = new File(this.mUsersDir, USER_LIST_FILENAME);
                this.initDefaultGuestRestrictions();
                this.readUserListLocked();
                sInstance = this;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void systemReady() {
        Object object = this.mInstallLock;
        synchronized (object) {
            Object object2 = this.mPackagesLock;
            synchronized (object2) {
                UserInfo ui;
                int i;
                ArrayList<UserInfo> partials = new ArrayList<UserInfo>();
                for (i = 0; i < this.mUsers.size(); ++i) {
                    ui = this.mUsers.valueAt(i);
                    if (!ui.partial && !ui.guestToRemove || i == 0) continue;
                    partials.add(ui);
                }
                for (i = 0; i < partials.size(); ++i) {
                    ui = (UserInfo)partials.get(i);
                    Slog.w(LOG_TAG, "Removing partially created user " + ui.id + " (name=" + ui.name + ")");
                    this.removeUserStateLocked(ui.id);
                }
            }
        }
        this.onUserForeground(0);
        this.mAppOpsService = IAppOpsService.Stub.asInterface(ServiceManager.getService("appops"));
        for (int i = 0; i < this.mUserIds.length; ++i) {
            try {
                this.mAppOpsService.setUserRestrictions(this.mUserRestrictions.get(this.mUserIds[i]), this.mUserIds[i]);
                continue;
            }
            catch (RemoteException e) {
                Log.w(LOG_TAG, "Unable to notify AppOpsService of UserRestrictions");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<UserInfo> getUsers(boolean excludeDying) {
        UserManagerService.checkManageUsersPermission("query users");
        Object object = this.mPackagesLock;
        synchronized (object) {
            ArrayList<UserInfo> users = new ArrayList<UserInfo>(this.mUsers.size());
            for (int i = 0; i < this.mUsers.size(); ++i) {
                UserInfo ui = this.mUsers.valueAt(i);
                if (ui.partial || excludeDying && this.mRemovingUserIds.get(ui.id)) continue;
                users.add(ui);
            }
            return users;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<UserInfo> getProfiles(int userId, boolean enabledOnly) {
        if (userId != UserHandle.getCallingUserId()) {
            UserManagerService.checkManageUsersPermission("getting profiles related to user " + userId);
        }
        long ident = Binder.clearCallingIdentity();
        try {
            Object object = this.mPackagesLock;
            synchronized (object) {
                List<UserInfo> list = this.getProfilesLocked(userId, enabledOnly);
                return list;
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private List<UserInfo> getProfilesLocked(int userId, boolean enabledOnly) {
        UserInfo user = this.getUserInfoLocked(userId);
        ArrayList<UserInfo> users = new ArrayList<UserInfo>(this.mUsers.size());
        if (user == null) {
            return users;
        }
        for (int i = 0; i < this.mUsers.size(); ++i) {
            UserInfo profile = this.mUsers.valueAt(i);
            if (!this.isProfileOf(user, profile) || enabledOnly && !profile.isEnabled() || this.mRemovingUserIds.get(profile.id)) continue;
            users.add(profile);
        }
        return users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCredentialOwnerProfile(int userHandle) {
        UserManagerService.checkManageUsersPermission("get the credential owner");
        Object object = this.mPackagesLock;
        synchronized (object) {
            UserInfo profileParent = this.getProfileParentLocked(userHandle);
            if (profileParent != null) {
                return profileParent.id;
            }
        }
        return userHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserInfo getProfileParent(int userHandle) {
        UserManagerService.checkManageUsersPermission("get the profile parent");
        Object object = this.mPackagesLock;
        synchronized (object) {
            return this.getProfileParentLocked(userHandle);
        }
    }

    private UserInfo getProfileParentLocked(int userHandle) {
        UserInfo profile = this.getUserInfoLocked(userHandle);
        if (profile == null) {
            return null;
        }
        int parentUserId = profile.profileGroupId;
        if (parentUserId == -1) {
            return null;
        }
        return this.getUserInfoLocked(parentUserId);
    }

    private boolean isProfileOf(UserInfo user, UserInfo profile) {
        return user.id == profile.id || user.profileGroupId != -1 && user.profileGroupId == profile.profileGroupId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserEnabled(int userId) {
        UserManagerService.checkManageUsersPermission("enable user");
        Object object = this.mPackagesLock;
        synchronized (object) {
            UserInfo info = this.getUserInfoLocked(userId);
            if (info != null && !info.isEnabled()) {
                info.flags ^= 0x40;
                this.writeUserLocked(info);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserInfo getUserInfo(int userId) {
        UserManagerService.checkManageUsersPermission("query user");
        Object object = this.mPackagesLock;
        synchronized (object) {
            return this.getUserInfoLocked(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRestricted() {
        Object object = this.mPackagesLock;
        synchronized (object) {
            return this.getUserInfoLocked(UserHandle.getCallingUserId()).isRestricted();
        }
    }

    private UserInfo getUserInfoLocked(int userId) {
        UserInfo ui = this.mUsers.get(userId);
        if (ui != null && ui.partial && !this.mRemovingUserIds.get(userId)) {
            Slog.w(LOG_TAG, "getUserInfo: unknown user #" + userId);
            return null;
        }
        return ui;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(int userId) {
        Object object = this.mPackagesLock;
        synchronized (object) {
            return this.mUsers.get(userId) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserName(int userId, String name) {
        UserManagerService.checkManageUsersPermission("rename users");
        boolean changed = false;
        Object object = this.mPackagesLock;
        synchronized (object) {
            UserInfo info = this.mUsers.get(userId);
            if (info == null || info.partial) {
                Slog.w(LOG_TAG, "setUserName: unknown user #" + userId);
                return;
            }
            if (name != null && !name.equals(info.name)) {
                info.name = name;
                this.writeUserLocked(info);
                changed = true;
            }
        }
        if (changed) {
            this.sendUserInfoChangedBroadcast(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserIcon(int userId, Bitmap bitmap) {
        UserManagerService.checkManageUsersPermission("update users");
        long ident = Binder.clearCallingIdentity();
        try {
            Object object = this.mPackagesLock;
            synchronized (object) {
                UserInfo info;
                block8: {
                    info = this.mUsers.get(userId);
                    if (info != null && !info.partial) break block8;
                    Slog.w(LOG_TAG, "setUserIcon: unknown user #" + userId);
                    return;
                }
                this.writeBitmapLocked(info, bitmap);
                this.writeUserLocked(info);
            }
            this.sendUserInfoChangedBroadcast(userId);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private void sendUserInfoChangedBroadcast(int userId) {
        Intent changedIntent = new Intent("android.intent.action.USER_INFO_CHANGED");
        changedIntent.putExtra("android.intent.extra.user_handle", userId);
        changedIntent.addFlags(0x40000000);
        this.mContext.sendBroadcastAsUser(changedIntent, UserHandle.ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParcelFileDescriptor getUserIcon(int userId) {
        String iconPath;
        Object object = this.mPackagesLock;
        synchronized (object) {
            UserInfo info = this.mUsers.get(userId);
            if (info == null || info.partial) {
                Slog.w(LOG_TAG, "getUserIcon: unknown user #" + userId);
                return null;
            }
            int callingGroupId = this.mUsers.get((int)UserHandle.getCallingUserId()).profileGroupId;
            if (callingGroupId == -1 || callingGroupId != info.profileGroupId) {
                UserManagerService.checkManageUsersPermission("get the icon of a user who is not related");
            }
            if (info.iconPath == null) {
                return null;
            }
            iconPath = info.iconPath;
        }
        try {
            return ParcelFileDescriptor.open(new File(iconPath), 0x10000000);
        }
        catch (FileNotFoundException e) {
            Log.e(LOG_TAG, "Couldn't find icon file", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeInitialized(int userId) {
        UserManagerService.checkManageUsersPermission("makeInitialized");
        Object object = this.mPackagesLock;
        synchronized (object) {
            UserInfo info = this.mUsers.get(userId);
            if (info == null || info.partial) {
                Slog.w(LOG_TAG, "makeInitialized: unknown user #" + userId);
            }
            if ((info.flags & 0x10) == 0) {
                info.flags |= 0x10;
                this.scheduleWriteUserLocked(info);
            }
        }
    }

    private void initDefaultGuestRestrictions() {
        if (this.mGuestRestrictions.isEmpty()) {
            this.mGuestRestrictions.putBoolean("no_outgoing_calls", true);
            this.mGuestRestrictions.putBoolean("no_sms", true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bundle getDefaultGuestRestrictions() {
        UserManagerService.checkManageUsersPermission("getDefaultGuestRestrictions");
        Object object = this.mPackagesLock;
        synchronized (object) {
            return new Bundle(this.mGuestRestrictions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDefaultGuestRestrictions(Bundle restrictions) {
        UserManagerService.checkManageUsersPermission("setDefaultGuestRestrictions");
        Object object = this.mPackagesLock;
        synchronized (object) {
            this.mGuestRestrictions.clear();
            this.mGuestRestrictions.putAll(restrictions);
            this.writeUserListLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasUserRestriction(String restrictionKey, int userId) {
        Object object = this.mPackagesLock;
        synchronized (object) {
            Bundle restrictions = this.mUserRestrictions.get(userId);
            return restrictions != null && restrictions.getBoolean(restrictionKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bundle getUserRestrictions(int userId) {
        Object object = this.mPackagesLock;
        synchronized (object) {
            Bundle restrictions = this.mUserRestrictions.get(userId);
            return restrictions != null ? new Bundle(restrictions) : new Bundle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserRestriction(String key, boolean value, int userId) {
        UserManagerService.checkManageUsersPermission("setUserRestriction");
        Object object = this.mPackagesLock;
        synchronized (object) {
            if (!SYSTEM_CONTROLLED_RESTRICTIONS.contains(key)) {
                Bundle restrictions = this.getUserRestrictions(userId);
                restrictions.putBoolean(key, value);
                this.setUserRestrictionsInternalLocked(restrictions, userId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSystemControlledUserRestriction(String key, boolean value, int userId) {
        UserManagerService.checkSystemOrRoot("setSystemControlledUserRestriction");
        Object object = this.mPackagesLock;
        synchronized (object) {
            Bundle restrictions = this.getUserRestrictions(userId);
            restrictions.putBoolean(key, value);
            this.setUserRestrictionsInternalLocked(restrictions, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserRestrictions(Bundle restrictions, int userId) {
        UserManagerService.checkManageUsersPermission("setUserRestrictions");
        if (restrictions == null) {
            return;
        }
        Object object = this.mPackagesLock;
        synchronized (object) {
            Bundle oldUserRestrictions = this.mUserRestrictions.get(userId);
            for (String key : SYSTEM_CONTROLLED_RESTRICTIONS) {
                restrictions.remove(key);
                if (!oldUserRestrictions.containsKey(key)) continue;
                restrictions.putBoolean(key, oldUserRestrictions.getBoolean(key));
            }
            this.setUserRestrictionsInternalLocked(restrictions, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUserRestrictionsInternalLocked(Bundle restrictions, int userId) {
        Bundle userRestrictions = this.mUserRestrictions.get(userId);
        userRestrictions.clear();
        userRestrictions.putAll(restrictions);
        long token = Binder.clearCallingIdentity();
        try {
            this.mAppOpsService.setUserRestrictions(userRestrictions, userId);
        }
        catch (RemoteException e) {
            Log.w(LOG_TAG, "Unable to notify AppOpsService of UserRestrictions");
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
        this.scheduleWriteUserLocked(this.mUsers.get(userId));
    }

    private boolean isUserLimitReachedLocked() {
        return this.getAliveUsersExcludingGuestsCountLocked() >= UserManager.getMaxSupportedUsers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canAddMoreManagedProfiles() {
        UserManagerService.checkManageUsersPermission("check if more managed profiles can be added.");
        if (ActivityManager.isLowRamDeviceStatic()) {
            return false;
        }
        if (!this.mContext.getPackageManager().hasSystemFeature("android.software.managed_users")) {
            return false;
        }
        Object object = this.mPackagesLock;
        synchronized (object) {
            if (this.numberOfUsersOfTypeLocked(32, true) >= 1) {
                return false;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl12 : MonitorExitStatement: MONITOREXIT : var1_1
            int usersCount = this.getAliveUsersExcludingGuestsCountLocked();
            return usersCount == 1 || usersCount < UserManager.getMaxSupportedUsers();
        }
    }

    private int getAliveUsersExcludingGuestsCountLocked() {
        int aliveUserCount = 0;
        int totalUserCount = this.mUsers.size();
        for (int i = 0; i < totalUserCount; ++i) {
            UserInfo user = this.mUsers.valueAt(i);
            if (this.mRemovingUserIds.get(user.id) || user.isGuest() || user.partial) continue;
            ++aliveUserCount;
        }
        return aliveUserCount;
    }

    private static final void checkManageUsersPermission(String message) {
        int uid = Binder.getCallingUid();
        if (uid != 1000 && uid != 0 && ActivityManager.checkComponentPermission("android.permission.MANAGE_USERS", uid, -1, true) != 0) {
            throw new SecurityException("You need MANAGE_USERS permission to: " + message);
        }
    }

    private static void checkSystemOrRoot(String message) {
        int uid = Binder.getCallingUid();
        if (uid != 1000 && uid != 0) {
            throw new SecurityException("Only system may call: " + message);
        }
    }

    private void writeBitmapLocked(UserInfo info, Bitmap bitmap) {
        try {
            FileOutputStream os;
            File dir = new File(this.mUsersDir, Integer.toString(info.id));
            File file = new File(dir, USER_PHOTO_FILENAME);
            File tmp = new File(dir, USER_PHOTO_FILENAME_TMP);
            if (!dir.exists()) {
                dir.mkdir();
                FileUtils.setPermissions(dir.getPath(), 505, -1, -1);
            }
            if (bitmap.compress(Bitmap.CompressFormat.PNG, 100, os = new FileOutputStream(tmp)) && tmp.renameTo(file)) {
                info.iconPath = file.getAbsolutePath();
            }
            try {
                os.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            tmp.delete();
        }
        catch (FileNotFoundException e) {
            Slog.w(LOG_TAG, "Error setting photo for user ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getUserIds() {
        Object object = this.mPackagesLock;
        synchronized (object) {
            return this.mUserIds;
        }
    }

    int[] getUserIdsLPr() {
        return this.mUserIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readUserListLocked() {
        if (!this.mUserListFile.exists()) {
            this.fallbackToSingleUserLocked();
            return;
        }
        FileInputStream fis = null;
        AtomicFile userListFile = new AtomicFile(this.mUserListFile);
        try {
            int type;
            fis = userListFile.openRead();
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(fis, StandardCharsets.UTF_8.name());
            while ((type = parser.next()) != 2 && type != 1) {
            }
            if (type != 2) {
                Slog.e(LOG_TAG, "Unable to read user list");
                this.fallbackToSingleUserLocked();
                return;
            }
            this.mNextSerialNumber = -1;
            if (parser.getName().equals(TAG_USERS)) {
                String versionNumber;
                String lastSerialNumber = parser.getAttributeValue(null, ATTR_NEXT_SERIAL_NO);
                if (lastSerialNumber != null) {
                    this.mNextSerialNumber = Integer.parseInt(lastSerialNumber);
                }
                if ((versionNumber = parser.getAttributeValue(null, ATTR_USER_VERSION)) != null) {
                    this.mUserVersion = Integer.parseInt(versionNumber);
                }
            }
            block19: while ((type = parser.next()) != 1) {
                if (type != 2) continue;
                String name = parser.getName();
                if (name.equals(TAG_USER)) {
                    String id2 = parser.getAttributeValue(null, ATTR_ID);
                    UserInfo user = this.readUserLocked(Integer.parseInt(id2));
                    if (user == null) continue;
                    this.mUsers.put(user.id, user);
                    if (this.mNextSerialNumber >= 0 && this.mNextSerialNumber > user.id) continue;
                    this.mNextSerialNumber = user.id + 1;
                    continue;
                }
                if (!name.equals(TAG_GUEST_RESTRICTIONS)) continue;
                while ((type = parser.next()) != 1 && type != 3) {
                    if (type != 2) continue;
                    if (!parser.getName().equals(TAG_RESTRICTIONS)) continue block19;
                    this.readRestrictionsLocked(parser, this.mGuestRestrictions);
                    continue block19;
                }
            }
            this.updateUserIdsLocked();
            this.upgradeIfNecessaryLocked();
        }
        catch (IOException ioe) {
            this.fallbackToSingleUserLocked();
        }
        catch (XmlPullParserException pe) {
            this.fallbackToSingleUserLocked();
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void upgradeIfNecessaryLocked() {
        UserInfo user;
        int userVersion = this.mUserVersion;
        if (userVersion < 1) {
            user = this.mUsers.get(0);
            if ("Primary".equals(user.name)) {
                user.name = this.mContext.getResources().getString(17040619);
                this.scheduleWriteUserLocked(user);
            }
            userVersion = 1;
        }
        if (userVersion < 2) {
            user = this.mUsers.get(0);
            if ((user.flags & 0x10) == 0) {
                user.flags |= 0x10;
                this.scheduleWriteUserLocked(user);
            }
            userVersion = 2;
        }
        if (userVersion < 4) {
            userVersion = 4;
        }
        if (userVersion < 5) {
            this.initDefaultGuestRestrictions();
            userVersion = 5;
        }
        if (userVersion < 5) {
            Slog.w(LOG_TAG, "User version " + this.mUserVersion + " didn't upgrade as expected to " + 5);
        } else {
            this.mUserVersion = userVersion;
            this.writeUserListLocked();
        }
    }

    private void fallbackToSingleUserLocked() {
        UserInfo primary = new UserInfo(0, this.mContext.getResources().getString(17040619), null, 19);
        this.mUsers.put(0, primary);
        this.mNextSerialNumber = 10;
        this.mUserVersion = 5;
        Bundle restrictions = new Bundle();
        this.mUserRestrictions.append(0, restrictions);
        this.updateUserIdsLocked();
        this.initDefaultGuestRestrictions();
        this.writeUserListLocked();
        this.writeUserLocked(primary);
    }

    private void scheduleWriteUserLocked(UserInfo userInfo) {
        if (!this.mHandler.hasMessages(1, userInfo)) {
            Message msg = this.mHandler.obtainMessage(1, userInfo);
            this.mHandler.sendMessageDelayed(msg, 2000L);
        }
    }

    private void writeUserLocked(UserInfo userInfo) {
        FileOutputStream fos = null;
        AtomicFile userFile = new AtomicFile(new File(this.mUsersDir, userInfo.id + XML_SUFFIX));
        try {
            fos = userFile.startWrite();
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            FastXmlSerializer serializer = new FastXmlSerializer();
            serializer.setOutput(bos, StandardCharsets.UTF_8.name());
            serializer.startDocument(null, true);
            serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
            serializer.startTag(null, TAG_USER);
            serializer.attribute(null, ATTR_ID, Integer.toString(userInfo.id));
            serializer.attribute(null, ATTR_SERIAL_NO, Integer.toString(userInfo.serialNumber));
            serializer.attribute(null, ATTR_FLAGS, Integer.toString(userInfo.flags));
            serializer.attribute(null, ATTR_CREATION_TIME, Long.toString(userInfo.creationTime));
            serializer.attribute(null, ATTR_LAST_LOGGED_IN_TIME, Long.toString(userInfo.lastLoggedInTime));
            if (userInfo.iconPath != null) {
                serializer.attribute(null, ATTR_ICON_PATH, userInfo.iconPath);
            }
            if (userInfo.partial) {
                serializer.attribute(null, ATTR_PARTIAL, "true");
            }
            if (userInfo.guestToRemove) {
                serializer.attribute(null, ATTR_GUEST_TO_REMOVE, "true");
            }
            if (userInfo.profileGroupId != -1) {
                serializer.attribute(null, ATTR_PROFILE_GROUP_ID, Integer.toString(userInfo.profileGroupId));
            }
            serializer.startTag(null, TAG_NAME);
            serializer.text(userInfo.name);
            serializer.endTag(null, TAG_NAME);
            Bundle restrictions = this.mUserRestrictions.get(userInfo.id);
            if (restrictions != null) {
                this.writeRestrictionsLocked(serializer, restrictions);
            }
            serializer.endTag(null, TAG_USER);
            serializer.endDocument();
            userFile.finishWrite(fos);
        }
        catch (Exception ioe) {
            Slog.e(LOG_TAG, "Error writing user info " + userInfo.id + "\n" + ioe);
            userFile.failWrite(fos);
        }
    }

    private void writeUserListLocked() {
        FileOutputStream fos = null;
        AtomicFile userListFile = new AtomicFile(this.mUserListFile);
        try {
            fos = userListFile.startWrite();
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            FastXmlSerializer serializer = new FastXmlSerializer();
            serializer.setOutput(bos, StandardCharsets.UTF_8.name());
            serializer.startDocument(null, true);
            serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
            serializer.startTag(null, TAG_USERS);
            serializer.attribute(null, ATTR_NEXT_SERIAL_NO, Integer.toString(this.mNextSerialNumber));
            serializer.attribute(null, ATTR_USER_VERSION, Integer.toString(this.mUserVersion));
            serializer.startTag(null, TAG_GUEST_RESTRICTIONS);
            this.writeRestrictionsLocked(serializer, this.mGuestRestrictions);
            serializer.endTag(null, TAG_GUEST_RESTRICTIONS);
            for (int i = 0; i < this.mUsers.size(); ++i) {
                UserInfo user = this.mUsers.valueAt(i);
                serializer.startTag(null, TAG_USER);
                serializer.attribute(null, ATTR_ID, Integer.toString(user.id));
                serializer.endTag(null, TAG_USER);
            }
            serializer.endTag(null, TAG_USERS);
            serializer.endDocument();
            userListFile.finishWrite(fos);
        }
        catch (Exception e) {
            userListFile.failWrite(fos);
            Slog.e(LOG_TAG, "Error writing user list");
        }
    }

    private void writeRestrictionsLocked(XmlSerializer serializer, Bundle restrictions) throws IOException {
        serializer.startTag(null, TAG_RESTRICTIONS);
        this.writeBoolean(serializer, restrictions, "no_config_wifi");
        this.writeBoolean(serializer, restrictions, "no_modify_accounts");
        this.writeBoolean(serializer, restrictions, "no_install_apps");
        this.writeBoolean(serializer, restrictions, "no_uninstall_apps");
        this.writeBoolean(serializer, restrictions, "no_share_location");
        this.writeBoolean(serializer, restrictions, "no_install_unknown_sources");
        this.writeBoolean(serializer, restrictions, "no_config_bluetooth");
        this.writeBoolean(serializer, restrictions, "no_usb_file_transfer");
        this.writeBoolean(serializer, restrictions, "no_config_credentials");
        this.writeBoolean(serializer, restrictions, "no_remove_user");
        this.writeBoolean(serializer, restrictions, "no_debugging_features");
        this.writeBoolean(serializer, restrictions, "no_config_vpn");
        this.writeBoolean(serializer, restrictions, "no_config_tethering");
        this.writeBoolean(serializer, restrictions, "no_network_reset");
        this.writeBoolean(serializer, restrictions, "no_factory_reset");
        this.writeBoolean(serializer, restrictions, "no_add_user");
        this.writeBoolean(serializer, restrictions, "ensure_verify_apps");
        this.writeBoolean(serializer, restrictions, "no_config_cell_broadcasts");
        this.writeBoolean(serializer, restrictions, "no_config_mobile_networks");
        this.writeBoolean(serializer, restrictions, "no_control_apps");
        this.writeBoolean(serializer, restrictions, "no_physical_media");
        this.writeBoolean(serializer, restrictions, "no_unmute_microphone");
        this.writeBoolean(serializer, restrictions, "no_adjust_volume");
        this.writeBoolean(serializer, restrictions, "no_outgoing_calls");
        this.writeBoolean(serializer, restrictions, "no_sms");
        this.writeBoolean(serializer, restrictions, "no_fun");
        this.writeBoolean(serializer, restrictions, "no_create_windows");
        this.writeBoolean(serializer, restrictions, "no_cross_profile_copy_paste");
        this.writeBoolean(serializer, restrictions, "no_outgoing_beam");
        this.writeBoolean(serializer, restrictions, "no_wallpaper");
        this.writeBoolean(serializer, restrictions, "no_safe_boot");
        this.writeBoolean(serializer, restrictions, "allow_parent_profile_app_linking");
        serializer.endTag(null, TAG_RESTRICTIONS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private UserInfo readUserLocked(int id2) {
        int flags = 0;
        int serialNumber = id2;
        String name = null;
        String iconPath = null;
        long creationTime = 0L;
        long lastLoggedInTime = 0L;
        int profileGroupId = -1;
        boolean partial = false;
        boolean guestToRemove = false;
        Bundle restrictions = new Bundle();
        FileInputStream fis = null;
        try {
            int type;
            AtomicFile userFile = new AtomicFile(new File(this.mUsersDir, Integer.toString(id2) + XML_SUFFIX));
            fis = userFile.openRead();
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(fis, StandardCharsets.UTF_8.name());
            while ((type = parser.next()) != 2 && type != 1) {
            }
            if (type != 2) {
                Slog.e(LOG_TAG, "Unable to read user " + id2);
                UserInfo userInfo = null;
                return userInfo;
            }
            if (type == 2 && parser.getName().equals(TAG_USER)) {
                int storedId = this.readIntAttribute(parser, ATTR_ID, -1);
                if (storedId != id2) {
                    Slog.e(LOG_TAG, "User id does not match the file name");
                    UserInfo e = null;
                    return e;
                }
                serialNumber = this.readIntAttribute(parser, ATTR_SERIAL_NO, id2);
                flags = this.readIntAttribute(parser, ATTR_FLAGS, 0);
                iconPath = parser.getAttributeValue(null, ATTR_ICON_PATH);
                creationTime = this.readLongAttribute(parser, ATTR_CREATION_TIME, 0L);
                lastLoggedInTime = this.readLongAttribute(parser, ATTR_LAST_LOGGED_IN_TIME, 0L);
                profileGroupId = this.readIntAttribute(parser, ATTR_PROFILE_GROUP_ID, -1);
                String valueString = parser.getAttributeValue(null, ATTR_PARTIAL);
                if ("true".equals(valueString)) {
                    partial = true;
                }
                if ("true".equals(valueString = parser.getAttributeValue(null, ATTR_GUEST_TO_REMOVE))) {
                    guestToRemove = true;
                }
                int outerDepth = parser.getDepth();
                while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                    if (type == 3 || type == 4) continue;
                    String tag = parser.getName();
                    if (TAG_NAME.equals(tag)) {
                        type = parser.next();
                        if (type != 4) continue;
                        name = parser.getText();
                        continue;
                    }
                    if (!TAG_RESTRICTIONS.equals(tag)) continue;
                    this.readRestrictionsLocked(parser, restrictions);
                }
            }
            UserInfo userInfo = new UserInfo(id2, name, iconPath, flags);
            userInfo.serialNumber = serialNumber;
            userInfo.creationTime = creationTime;
            userInfo.lastLoggedInTime = lastLoggedInTime;
            userInfo.partial = partial;
            userInfo.guestToRemove = guestToRemove;
            userInfo.profileGroupId = profileGroupId;
            this.mUserRestrictions.append(id2, restrictions);
            UserInfo userInfo2 = userInfo;
            return userInfo2;
        }
        catch (IOException ioe) {
            return null;
        }
        catch (XmlPullParserException pe) {
            return null;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void readRestrictionsLocked(XmlPullParser parser, Bundle restrictions) throws IOException {
        this.readBoolean(parser, restrictions, "no_config_wifi");
        this.readBoolean(parser, restrictions, "no_modify_accounts");
        this.readBoolean(parser, restrictions, "no_install_apps");
        this.readBoolean(parser, restrictions, "no_uninstall_apps");
        this.readBoolean(parser, restrictions, "no_share_location");
        this.readBoolean(parser, restrictions, "no_install_unknown_sources");
        this.readBoolean(parser, restrictions, "no_config_bluetooth");
        this.readBoolean(parser, restrictions, "no_usb_file_transfer");
        this.readBoolean(parser, restrictions, "no_config_credentials");
        this.readBoolean(parser, restrictions, "no_remove_user");
        this.readBoolean(parser, restrictions, "no_debugging_features");
        this.readBoolean(parser, restrictions, "no_config_vpn");
        this.readBoolean(parser, restrictions, "no_config_tethering");
        this.readBoolean(parser, restrictions, "no_network_reset");
        this.readBoolean(parser, restrictions, "no_factory_reset");
        this.readBoolean(parser, restrictions, "no_add_user");
        this.readBoolean(parser, restrictions, "ensure_verify_apps");
        this.readBoolean(parser, restrictions, "no_config_cell_broadcasts");
        this.readBoolean(parser, restrictions, "no_config_mobile_networks");
        this.readBoolean(parser, restrictions, "no_control_apps");
        this.readBoolean(parser, restrictions, "no_physical_media");
        this.readBoolean(parser, restrictions, "no_unmute_microphone");
        this.readBoolean(parser, restrictions, "no_adjust_volume");
        this.readBoolean(parser, restrictions, "no_outgoing_calls");
        this.readBoolean(parser, restrictions, "no_sms");
        this.readBoolean(parser, restrictions, "no_fun");
        this.readBoolean(parser, restrictions, "no_create_windows");
        this.readBoolean(parser, restrictions, "no_cross_profile_copy_paste");
        this.readBoolean(parser, restrictions, "no_outgoing_beam");
        this.readBoolean(parser, restrictions, "no_wallpaper");
        this.readBoolean(parser, restrictions, "no_safe_boot");
        this.readBoolean(parser, restrictions, "allow_parent_profile_app_linking");
    }

    private void readBoolean(XmlPullParser parser, Bundle restrictions, String restrictionKey) {
        String value = parser.getAttributeValue(null, restrictionKey);
        if (value != null) {
            restrictions.putBoolean(restrictionKey, Boolean.parseBoolean(value));
        }
    }

    private void writeBoolean(XmlSerializer xml2, Bundle restrictions, String restrictionKey) throws IOException {
        if (restrictions.containsKey(restrictionKey)) {
            xml2.attribute(null, restrictionKey, Boolean.toString(restrictions.getBoolean(restrictionKey)));
        }
    }

    private int readIntAttribute(XmlPullParser parser, String attr2, int defaultValue) {
        String valueString = parser.getAttributeValue(null, attr2);
        if (valueString == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(valueString);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    private long readLongAttribute(XmlPullParser parser, String attr2, long defaultValue) {
        String valueString = parser.getAttributeValue(null, attr2);
        if (valueString == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(valueString);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    private boolean isPackageInstalled(String pkg, int userId) {
        ApplicationInfo info = this.mPm.getApplicationInfo(pkg, 8192, userId);
        return info != null && (info.flags & 0x800000) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanAppRestrictions(int userId) {
        Object object = this.mPackagesLock;
        synchronized (object) {
            File dir = Environment.getUserSystemDirectory(userId);
            String[] files = dir.list();
            if (files == null) {
                return;
            }
            for (String fileName : files) {
                File resFile;
                if (!fileName.startsWith(RESTRICTIONS_FILE_PREFIX) || !(resFile = new File(dir, fileName)).exists()) continue;
                resFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanAppRestrictionsForPackage(String pkg, int userId) {
        Object object = this.mPackagesLock;
        synchronized (object) {
            File dir = Environment.getUserSystemDirectory(userId);
            File resFile = new File(dir, this.packageToRestrictionsFileName(pkg));
            if (resFile.exists()) {
                resFile.delete();
            }
        }
    }

    @Override
    public UserInfo createProfileForUser(String name, int flags, int userId) {
        UserManagerService.checkManageUsersPermission("Only the system can create users");
        if (userId != 0) {
            Slog.w(LOG_TAG, "Only user owner can have profiles");
            return null;
        }
        return this.createUserInternal(name, flags, userId);
    }

    @Override
    public UserInfo createUser(String name, int flags) {
        UserManagerService.checkManageUsersPermission("Only the system can create users");
        return this.createUserInternal(name, flags, -10000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private UserInfo createUserInternal(String name, int flags, int parentId) {
        UserInfo parent;
        UserInfo userInfo;
        long ident;
        boolean isManagedProfile;
        boolean isGuest;
        block23: {
            if (this.getUserRestrictions(UserHandle.getCallingUserId()).getBoolean("no_add_user", false)) {
                Log.w(LOG_TAG, "Cannot add user. DISALLOW_ADD_USER is enabled.");
                return null;
            }
            if (ActivityManager.isLowRamDeviceStatic()) {
                return null;
            }
            isGuest = (flags & 4) != 0;
            isManagedProfile = (flags & 0x20) != 0;
            ident = Binder.clearCallingIdentity();
            userInfo = null;
            Object object = this.mInstallLock;
            // MONITORENTER : object
            Object object2 = this.mPackagesLock;
            // MONITORENTER : object2
            parent = null;
            if (parentId == -10000 || (parent = this.getUserInfoLocked(parentId)) != null) break block23;
            UserInfo userInfo2 = null;
            // MONITOREXIT : object2
            // MONITOREXIT : object
            Binder.restoreCallingIdentity(ident);
            return userInfo2;
        }
        if (isManagedProfile && !this.canAddMoreManagedProfiles()) {
            UserInfo userInfo3 = null;
            // MONITOREXIT : object2
            // MONITOREXIT : object
            Binder.restoreCallingIdentity(ident);
            return userInfo3;
        }
        if (!isGuest && !isManagedProfile && this.isUserLimitReachedLocked()) {
            UserInfo userInfo4 = null;
            // MONITOREXIT : object2
            // MONITOREXIT : object
            Binder.restoreCallingIdentity(ident);
            return userInfo4;
        }
        if (isGuest && this.findCurrentGuestUserLocked() != null) {
            UserInfo userInfo5 = null;
            // MONITOREXIT : object2
            // MONITOREXIT : object
            Binder.restoreCallingIdentity(ident);
            return userInfo5;
        }
        try {
            int userId = this.getNextAvailableIdLocked();
            userInfo = new UserInfo(userId, name, null, flags);
            userInfo.serialNumber = this.mNextSerialNumber++;
            long now = System.currentTimeMillis();
            userInfo.creationTime = now > 946080000000L ? now : 0L;
            userInfo.partial = true;
            Environment.getUserSystemDirectory(userInfo.id).mkdirs();
            this.mUsers.put(userId, userInfo);
            this.writeUserListLocked();
            if (parent != null) {
                if (parent.profileGroupId == -1) {
                    parent.profileGroupId = parent.id;
                    this.scheduleWriteUserLocked(parent);
                }
                userInfo.profileGroupId = parent.profileGroupId;
            }
            StorageManager storage = this.mContext.getSystemService(StorageManager.class);
            for (VolumeInfo vol : storage.getWritablePrivateVolumes()) {
                String volumeUuid = vol.getFsUuid();
                try {
                    File userDir = Environment.getDataUserDirectory(volumeUuid, userId);
                    UserManagerService.prepareUserDirectory(userDir);
                    UserManagerService.enforceSerialNumber(userDir, userInfo.serialNumber);
                }
                catch (IOException e) {
                    Log.wtf(LOG_TAG, "Failed to create user directory on " + volumeUuid, e);
                }
            }
            this.mPm.createNewUserLILPw(userId);
            userInfo.partial = false;
            this.scheduleWriteUserLocked(userInfo);
            this.updateUserIdsLocked();
            Bundle restrictions = new Bundle();
            this.mUserRestrictions.append(userId, restrictions);
            // MONITOREXIT : object2
            // MONITOREXIT : object
            this.mPm.newUserCreated(userId);
            if (userInfo == null) return userInfo;
            Intent addedIntent = new Intent("android.intent.action.USER_ADDED");
            addedIntent.putExtra("android.intent.extra.user_handle", userInfo.id);
            this.mContext.sendBroadcastAsUser(addedIntent, UserHandle.ALL, "android.permission.MANAGE_USERS");
            return userInfo;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private int numberOfUsersOfTypeLocked(int flags, boolean excludeDying) {
        int count = 0;
        for (int i = this.mUsers.size() - 1; i >= 0; --i) {
            UserInfo user = this.mUsers.valueAt(i);
            if (excludeDying && this.mRemovingUserIds.get(user.id) || (user.flags & flags) == 0) continue;
            ++count;
        }
        return count;
    }

    private UserInfo findCurrentGuestUserLocked() {
        int size = this.mUsers.size();
        for (int i = 0; i < size; ++i) {
            UserInfo user = this.mUsers.valueAt(i);
            if (!user.isGuest() || user.guestToRemove || this.mRemovingUserIds.get(user.id)) continue;
            return user;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean markGuestForDeletion(int userHandle) {
        UserInfo user;
        long ident;
        block10: {
            UserManagerService.checkManageUsersPermission("Only the system can remove users");
            if (this.getUserRestrictions(UserHandle.getCallingUserId()).getBoolean("no_remove_user", false)) {
                Log.w(LOG_TAG, "Cannot remove user. DISALLOW_REMOVE_USER is enabled.");
                return false;
            }
            ident = Binder.clearCallingIdentity();
            Object object = this.mPackagesLock;
            // MONITORENTER : object
            user = this.mUsers.get(userHandle);
            if (userHandle != 0 && user != null && !this.mRemovingUserIds.get(userHandle)) break block10;
            boolean bl = false;
            // MONITOREXIT : object
            Binder.restoreCallingIdentity(ident);
            return bl;
        }
        if (!user.isGuest()) {
            boolean bl = false;
            // MONITOREXIT : object
            Binder.restoreCallingIdentity(ident);
            return bl;
        }
        try {
            user.guestToRemove = true;
            user.flags |= 0x40;
            this.writeUserLocked(user);
            // MONITOREXIT : object
            return true;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeUser(int userHandle) {
        UserManagerService.checkManageUsersPermission("Only the system can remove users");
        if (this.getUserRestrictions(UserHandle.getCallingUserId()).getBoolean("no_remove_user", false)) {
            Log.w(LOG_TAG, "Cannot remove user. DISALLOW_REMOVE_USER is enabled.");
            return false;
        }
        long ident = Binder.clearCallingIdentity();
        try {
            int res;
            UserInfo user;
            Object object = this.mPackagesLock;
            synchronized (object) {
                block15: {
                    user = this.mUsers.get(userHandle);
                    if (userHandle != 0 && user != null && !this.mRemovingUserIds.get(userHandle)) break block15;
                    boolean bl = false;
                    return bl;
                }
                this.mRemovingUserIds.put(userHandle, true);
                try {
                    this.mAppOpsService.removeUser(userHandle);
                }
                catch (RemoteException e) {
                    Log.w(LOG_TAG, "Unable to notify AppOpsService of removing user", e);
                }
                user.partial = true;
                user.flags |= 0x40;
                this.writeUserLocked(user);
            }
            if (user.profileGroupId != -1 && user.isManagedProfile()) {
                this.sendProfileRemovedBroadcast(user.profileGroupId, user.id);
            }
            try {
                res = ActivityManagerNative.getDefault().stopUser(userHandle, new IStopUserCallback.Stub(){

                    @Override
                    public void userStopped(int userId) {
                        UserManagerService.this.finishRemoveUser(userId);
                    }

                    @Override
                    public void userStopAborted(int userId) {
                    }
                });
            }
            catch (RemoteException e) {
                boolean bl = false;
                Binder.restoreCallingIdentity(ident);
                return bl;
            }
            boolean bl = res == 0;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishRemoveUser(final int userHandle) {
        long ident = Binder.clearCallingIdentity();
        try {
            Intent addedIntent = new Intent("android.intent.action.USER_REMOVED");
            addedIntent.putExtra("android.intent.extra.user_handle", userHandle);
            this.mContext.sendOrderedBroadcastAsUser(addedIntent, UserHandle.ALL, "android.permission.MANAGE_USERS", new BroadcastReceiver(){

                @Override
                public void onReceive(Context context, Intent intent) {
                    new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Object object = UserManagerService.this.mInstallLock;
                            synchronized (object) {
                                Object object2 = UserManagerService.this.mPackagesLock;
                                synchronized (object2) {
                                    UserManagerService.this.removeUserStateLocked(userHandle);
                                }
                            }
                        }
                    }.start();
                }
            }, null, -1, null, null);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private void removeUserStateLocked(int userHandle) {
        this.mPm.cleanUpUserLILPw(this, userHandle);
        this.mUsers.remove(userHandle);
        AtomicFile userFile = new AtomicFile(new File(this.mUsersDir, userHandle + XML_SUFFIX));
        userFile.delete();
        this.writeUserListLocked();
        this.updateUserIdsLocked();
        this.removeDirectoryRecursive(Environment.getUserSystemDirectory(userHandle));
    }

    private void removeDirectoryRecursive(File parent) {
        if (parent.isDirectory()) {
            String[] files;
            for (String filename : files = parent.list()) {
                File child = new File(parent, filename);
                this.removeDirectoryRecursive(child);
            }
        }
        parent.delete();
    }

    private void sendProfileRemovedBroadcast(int parentUserId, int removedUserId) {
        Intent managedProfileIntent = new Intent("android.intent.action.MANAGED_PROFILE_REMOVED");
        managedProfileIntent.addFlags(0x50000000);
        managedProfileIntent.putExtra("android.intent.extra.USER", new UserHandle(removedUserId));
        this.mContext.sendBroadcastAsUser(managedProfileIntent, new UserHandle(parentUserId), null);
    }

    @Override
    public Bundle getApplicationRestrictions(String packageName) {
        return this.getApplicationRestrictionsForUser(packageName, UserHandle.getCallingUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bundle getApplicationRestrictionsForUser(String packageName, int userId) {
        if (UserHandle.getCallingUserId() != userId || !UserHandle.isSameApp(Binder.getCallingUid(), this.getUidForPackage(packageName))) {
            UserManagerService.checkManageUsersPermission("Only system can get restrictions for other users/apps");
        }
        Object object = this.mPackagesLock;
        synchronized (object) {
            return this.readApplicationRestrictionsLocked(packageName, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setApplicationRestrictions(String packageName, Bundle restrictions, int userId) {
        if (UserHandle.getCallingUserId() != userId || !UserHandle.isSameApp(Binder.getCallingUid(), this.getUidForPackage(packageName))) {
            UserManagerService.checkManageUsersPermission("Only system can set restrictions for other users/apps");
        }
        Object object = this.mPackagesLock;
        synchronized (object) {
            if (restrictions == null || restrictions.isEmpty()) {
                this.cleanAppRestrictionsForPackage(packageName, userId);
            } else {
                this.writeApplicationRestrictionsLocked(packageName, restrictions, userId);
            }
        }
        if (this.isPackageInstalled(packageName, userId)) {
            Intent changeIntent = new Intent("android.intent.action.APPLICATION_RESTRICTIONS_CHANGED");
            changeIntent.setPackage(packageName);
            changeIntent.addFlags(0x40000000);
            this.mContext.sendBroadcastAsUser(changeIntent, new UserHandle(userId));
        }
    }

    @Override
    public void removeRestrictions() {
        UserManagerService.checkManageUsersPermission("Only system can remove restrictions");
        int userHandle = UserHandle.getCallingUserId();
        this.removeRestrictionsForUser(userHandle, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRestrictionsForUser(int userHandle, boolean unhideApps) {
        Object object = this.mPackagesLock;
        synchronized (object) {
            this.setUserRestrictions(new Bundle(), userHandle);
            this.cleanAppRestrictions(userHandle);
        }
        if (unhideApps) {
            this.unhideAllInstalledAppsForUser(userHandle);
        }
    }

    private void unhideAllInstalledAppsForUser(final int userHandle) {
        this.mHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List<ApplicationInfo> apps = UserManagerService.this.mPm.getInstalledApplications(8192, userHandle).getList();
                long ident = Binder.clearCallingIdentity();
                try {
                    for (ApplicationInfo appInfo : apps) {
                        if ((appInfo.flags & 0x800000) == 0 || (appInfo.privateFlags & 1) == 0) continue;
                        UserManagerService.this.mPm.setApplicationHiddenSettingAsUser(appInfo.packageName, false, userHandle);
                    }
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getUidForPackage(String packageName) {
        long ident = Binder.clearCallingIdentity();
        try {
            int n = this.mContext.getPackageManager().getApplicationInfo((String)packageName, (int)8192).uid;
            return n;
        }
        catch (PackageManager.NameNotFoundException nnfe) {
            int n = -1;
            return n;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private Bundle readApplicationRestrictionsLocked(String packageName, int userId) {
        AtomicFile restrictionsFile = new AtomicFile(new File(Environment.getUserSystemDirectory(userId), this.packageToRestrictionsFileName(packageName)));
        return UserManagerService.readApplicationRestrictionsLocked(restrictionsFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Bundle readApplicationRestrictionsLocked(AtomicFile restrictionsFile) {
        Bundle restrictions = new Bundle();
        ArrayList<String> values = new ArrayList<String>();
        if (!restrictionsFile.getBaseFile().exists()) {
            return restrictions;
        }
        FileInputStream fis = null;
        try {
            fis = restrictionsFile.openRead();
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(fis, StandardCharsets.UTF_8.name());
            XmlUtils.nextElement(parser);
            if (parser.getEventType() != 2) {
                Slog.e(LOG_TAG, "Unable to read restrictions file " + restrictionsFile.getBaseFile());
                Bundle bundle = restrictions;
                return bundle;
            }
            while (parser.next() != 1) {
                UserManagerService.readEntry(restrictions, values, parser);
            }
        }
        catch (IOException | XmlPullParserException e) {
            Log.w(LOG_TAG, "Error parsing " + restrictionsFile.getBaseFile(), e);
        }
        finally {
            IoUtils.closeQuietly(fis);
        }
        return restrictions;
    }

    private static void readEntry(Bundle restrictions, ArrayList<String> values, XmlPullParser parser) throws XmlPullParserException, IOException {
        int type = parser.getEventType();
        if (type == 2 && parser.getName().equals(TAG_ENTRY)) {
            String key = parser.getAttributeValue(null, ATTR_KEY);
            String valType = parser.getAttributeValue(null, ATTR_VALUE_TYPE);
            String multiple = parser.getAttributeValue(null, ATTR_MULTIPLE);
            if (multiple != null) {
                values.clear();
                int count = Integer.parseInt(multiple);
                while (count > 0 && (type = parser.next()) != 1) {
                    if (type != 2 || !parser.getName().equals(TAG_VALUE)) continue;
                    values.add(parser.nextText().trim());
                    --count;
                }
                String[] valueStrings = new String[values.size()];
                values.toArray(valueStrings);
                restrictions.putStringArray(key, valueStrings);
            } else if (ATTR_TYPE_BUNDLE.equals(valType)) {
                restrictions.putBundle(key, UserManagerService.readBundleEntry(parser, values));
            } else if (ATTR_TYPE_BUNDLE_ARRAY.equals(valType)) {
                int outerDepth = parser.getDepth();
                ArrayList<Bundle> bundleList = new ArrayList<Bundle>();
                while (XmlUtils.nextElementWithin(parser, outerDepth)) {
                    Bundle childBundle = UserManagerService.readBundleEntry(parser, values);
                    bundleList.add(childBundle);
                }
                restrictions.putParcelableArray(key, bundleList.toArray(new Bundle[bundleList.size()]));
            } else {
                String value = parser.nextText().trim();
                if (ATTR_TYPE_BOOLEAN.equals(valType)) {
                    restrictions.putBoolean(key, Boolean.parseBoolean(value));
                } else if (ATTR_TYPE_INTEGER.equals(valType)) {
                    restrictions.putInt(key, Integer.parseInt(value));
                } else {
                    restrictions.putString(key, value);
                }
            }
        }
    }

    private static Bundle readBundleEntry(XmlPullParser parser, ArrayList<String> values) throws IOException, XmlPullParserException {
        Bundle childBundle = new Bundle();
        int outerDepth = parser.getDepth();
        while (XmlUtils.nextElementWithin(parser, outerDepth)) {
            UserManagerService.readEntry(childBundle, values, parser);
        }
        return childBundle;
    }

    private void writeApplicationRestrictionsLocked(String packageName, Bundle restrictions, int userId) {
        AtomicFile restrictionsFile = new AtomicFile(new File(Environment.getUserSystemDirectory(userId), this.packageToRestrictionsFileName(packageName)));
        UserManagerService.writeApplicationRestrictionsLocked(restrictions, restrictionsFile);
    }

    static void writeApplicationRestrictionsLocked(Bundle restrictions, AtomicFile restrictionsFile) {
        FileOutputStream fos = null;
        try {
            fos = restrictionsFile.startWrite();
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            FastXmlSerializer serializer = new FastXmlSerializer();
            serializer.setOutput(bos, StandardCharsets.UTF_8.name());
            serializer.startDocument(null, true);
            serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
            serializer.startTag(null, TAG_RESTRICTIONS);
            UserManagerService.writeBundle(restrictions, serializer);
            serializer.endTag(null, TAG_RESTRICTIONS);
            serializer.endDocument();
            restrictionsFile.finishWrite(fos);
        }
        catch (Exception e) {
            restrictionsFile.failWrite(fos);
            Slog.e(LOG_TAG, "Error writing application restrictions list", e);
        }
    }

    private static void writeBundle(Bundle restrictions, XmlSerializer serializer) throws IOException {
        for (String key : restrictions.keySet()) {
            Object value = restrictions.get(key);
            serializer.startTag(null, TAG_ENTRY);
            serializer.attribute(null, ATTR_KEY, key);
            if (value instanceof Boolean) {
                serializer.attribute(null, ATTR_VALUE_TYPE, ATTR_TYPE_BOOLEAN);
                serializer.text(value.toString());
            } else if (value instanceof Integer) {
                serializer.attribute(null, ATTR_VALUE_TYPE, ATTR_TYPE_INTEGER);
                serializer.text(value.toString());
            } else if (value == null || value instanceof String) {
                serializer.attribute(null, ATTR_VALUE_TYPE, ATTR_TYPE_STRING);
                serializer.text(value != null ? (String)value : "");
            } else if (value instanceof Bundle) {
                serializer.attribute(null, ATTR_VALUE_TYPE, ATTR_TYPE_BUNDLE);
                UserManagerService.writeBundle((Bundle)value, serializer);
            } else if (value instanceof Parcelable[]) {
                serializer.attribute(null, ATTR_VALUE_TYPE, ATTR_TYPE_BUNDLE_ARRAY);
                Parcelable[] array2 = (Parcelable[])value;
                for (Parcelable parcelable : array2) {
                    if (!(parcelable instanceof Bundle)) {
                        throw new IllegalArgumentException("bundle-array can only hold Bundles");
                    }
                    serializer.startTag(null, TAG_ENTRY);
                    serializer.attribute(null, ATTR_VALUE_TYPE, ATTR_TYPE_BUNDLE);
                    UserManagerService.writeBundle((Bundle)parcelable, serializer);
                    serializer.endTag(null, TAG_ENTRY);
                }
            } else {
                serializer.attribute(null, ATTR_VALUE_TYPE, ATTR_TYPE_STRING_ARRAY);
                String[] values = (String[])value;
                serializer.attribute(null, ATTR_MULTIPLE, Integer.toString(values.length));
                for (String choice : values) {
                    serializer.startTag(null, TAG_VALUE);
                    serializer.text((String)(choice != null ? choice : ""));
                    serializer.endTag(null, TAG_VALUE);
                }
            }
            serializer.endTag(null, TAG_ENTRY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUserSerialNumber(int userHandle) {
        Object object = this.mPackagesLock;
        synchronized (object) {
            if (!this.exists(userHandle)) {
                return -1;
            }
            return this.getUserInfoLocked((int)userHandle).serialNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getUserHandle(int userSerialNumber) {
        Object object = this.mPackagesLock;
        synchronized (object) {
            for (int userId : this.mUserIds) {
                UserInfo info = this.getUserInfoLocked(userId);
                if (info == null || info.serialNumber != userSerialNumber) continue;
                return userId;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getUserCreationTime(int userHandle) {
        int callingUserId = UserHandle.getCallingUserId();
        UserInfo userInfo = null;
        Object object = this.mPackagesLock;
        synchronized (object) {
            if (callingUserId == userHandle) {
                userInfo = this.getUserInfoLocked(userHandle);
            } else {
                UserInfo parent = this.getProfileParentLocked(userHandle);
                if (parent != null && parent.id == callingUserId) {
                    userInfo = this.getUserInfoLocked(userHandle);
                }
            }
        }
        if (userInfo == null) {
            throw new SecurityException("userHandle can only be the calling user or a managed profile associated with this user");
        }
        return userInfo.creationTime;
    }

    private void updateUserIdsLocked() {
        int num = 0;
        for (int i = 0; i < this.mUsers.size(); ++i) {
            if (this.mUsers.valueAt((int)i).partial) continue;
            ++num;
        }
        int[] newUsers = new int[num];
        int n = 0;
        for (int i = 0; i < this.mUsers.size(); ++i) {
            if (this.mUsers.valueAt((int)i).partial) continue;
            newUsers[n++] = this.mUsers.keyAt(i);
        }
        this.mUserIds = newUsers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUserForeground(int userId) {
        Object object = this.mPackagesLock;
        synchronized (object) {
            UserInfo user = this.mUsers.get(userId);
            long now = System.currentTimeMillis();
            if (user == null || user.partial) {
                Slog.w(LOG_TAG, "userForeground: unknown user #" + userId);
                return;
            }
            if (now > 946080000000L) {
                user.lastLoggedInTime = now;
                this.scheduleWriteUserLocked(user);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextAvailableIdLocked() {
        Object object = this.mPackagesLock;
        synchronized (object) {
            int i;
            for (i = 10; i < Integer.MAX_VALUE && (this.mUsers.indexOfKey(i) >= 0 || this.mRemovingUserIds.get(i)); ++i) {
            }
            return i;
        }
    }

    private String packageToRestrictionsFileName(String packageName) {
        return RESTRICTIONS_FILE_PREFIX + packageName + XML_SUFFIX;
    }

    public static void prepareUserDirectory(File file) throws IOException {
        if (!file.exists() && !file.mkdir()) {
            throw new IOException("Failed to create " + file);
        }
        if (FileUtils.setPermissions(file.getAbsolutePath(), 505, 1000, 1000) != 0) {
            throw new IOException("Failed to prepare " + file);
        }
    }

    public static void enforceSerialNumber(File file, int serialNumber) throws IOException {
        int foundSerial = UserManagerService.getSerialNumber(file);
        Slog.v(LOG_TAG, "Found " + file + " with serial number " + foundSerial);
        if (foundSerial == -1) {
            Slog.d(LOG_TAG, "Serial number missing on " + file + "; assuming current is valid");
            try {
                UserManagerService.setSerialNumber(file, serialNumber);
            }
            catch (IOException e) {
                Slog.w(LOG_TAG, "Failed to set serial number on " + file, e);
            }
        } else if (foundSerial != serialNumber) {
            throw new IOException("Found serial number " + foundSerial + " doesn't match expected " + serialNumber);
        }
    }

    private static void setSerialNumber(File file, int serialNumber) throws IOException {
        try {
            byte[] buf = Integer.toString(serialNumber).getBytes(StandardCharsets.UTF_8);
            Os.setxattr(file.getAbsolutePath(), XATTR_SERIAL, buf, OsConstants.XATTR_CREATE);
        }
        catch (ErrnoException e) {
            throw e.rethrowAsIOException();
        }
    }

    private static int getSerialNumber(File file) throws IOException {
        try {
            byte[] buf = new byte[256];
            int len = Os.getxattr(file.getAbsolutePath(), XATTR_SERIAL, buf);
            String serial = new String(buf, 0, len);
            try {
                return Integer.parseInt(serial);
            }
            catch (NumberFormatException e) {
                throw new IOException("Bad serial number: " + serial);
            }
        }
        catch (ErrnoException e) {
            if (e.errno == OsConstants.ENODATA) {
                return -1;
            }
            throw e.rethrowAsIOException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump UserManager from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " without permission " + "android.permission.DUMP");
            return;
        }
        long now = System.currentTimeMillis();
        StringBuilder sb = new StringBuilder();
        Object object = this.mPackagesLock;
        synchronized (object) {
            pw.println("Users:");
            for (int i = 0; i < this.mUsers.size(); ++i) {
                UserInfo user = this.mUsers.valueAt(i);
                if (user == null) continue;
                pw.print("  ");
                pw.print(user);
                pw.print(" serialNo=");
                pw.print(user.serialNumber);
                if (this.mRemovingUserIds.get(this.mUsers.keyAt(i))) {
                    pw.print(" <removing> ");
                }
                if (user.partial) {
                    pw.print(" <partial>");
                }
                pw.println();
                pw.print("    Created: ");
                if (user.creationTime == 0L) {
                    pw.println("<unknown>");
                } else {
                    sb.setLength(0);
                    TimeUtils.formatDuration(now - user.creationTime, sb);
                    sb.append(" ago");
                    pw.println(sb);
                }
                pw.print("    Last logged in: ");
                if (user.lastLoggedInTime == 0L) {
                    pw.println("<unknown>");
                    continue;
                }
                sb.setLength(0);
                TimeUtils.formatDuration(now - user.lastLoggedInTime, sb);
                sb.append(" ago");
                pw.println(sb);
            }
        }
    }

    boolean isInitialized(int userId) {
        return (this.getUserInfo((int)userId).flags & 0x10) != 0;
    }

    final class MainHandler
    extends Handler {
        MainHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    this.removeMessages(1, msg.obj);
                    Object object = UserManagerService.this.mPackagesLock;
                    synchronized (object) {
                        int userId = ((UserInfo)msg.obj).id;
                        UserInfo userInfo = (UserInfo)UserManagerService.this.mUsers.get(userId);
                        if (userInfo != null) {
                            UserManagerService.this.writeUserLocked(userInfo);
                        }
                        break;
                    }
                }
            }
        }
    }
}

