/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.policy;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.res.XmlResourceParser;
import android.text.TextUtils;
import android.util.Log;
import android.util.SparseArray;
import android.view.KeyCharacterMap;
import com.android.internal.util.XmlUtils;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParserException;

class ShortcutManager {
    private static final String TAG = "ShortcutManager";
    private static final String TAG_BOOKMARKS = "bookmarks";
    private static final String TAG_BOOKMARK = "bookmark";
    private static final String ATTRIBUTE_PACKAGE = "package";
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String ATTRIBUTE_SHORTCUT = "shortcut";
    private static final String ATTRIBUTE_CATEGORY = "category";
    private final SparseArray<ShortcutInfo> mShortcuts = new SparseArray();
    private final Context mContext;

    public ShortcutManager(Context context) {
        this.mContext = context;
        this.loadShortcuts();
    }

    public Intent getIntent(KeyCharacterMap kcm, int keyCode, int metaState) {
        ShortcutInfo shortcut = null;
        int shortcutChar = kcm.get(keyCode, metaState);
        if (shortcutChar != 0) {
            shortcut = this.mShortcuts.get(shortcutChar);
        }
        if (shortcut == null && (shortcutChar = (int)Character.toLowerCase(kcm.getDisplayLabel(keyCode))) != 0) {
            shortcut = this.mShortcuts.get(shortcutChar);
        }
        return shortcut != null ? shortcut.intent : null;
    }

    private void loadShortcuts() {
        PackageManager packageManager = this.mContext.getPackageManager();
        try {
            XmlResourceParser parser = this.mContext.getResources().getXml(0x1110003);
            XmlUtils.beginDocument(parser, TAG_BOOKMARKS);
            while (true) {
                String title;
                Intent intent;
                XmlUtils.nextElement(parser);
                if (parser.getEventType() == 1 || !TAG_BOOKMARK.equals(parser.getName())) break;
                String packageName = parser.getAttributeValue(null, ATTRIBUTE_PACKAGE);
                String className = parser.getAttributeValue(null, ATTRIBUTE_CLASS);
                String shortcutName = parser.getAttributeValue(null, ATTRIBUTE_SHORTCUT);
                String categoryName = parser.getAttributeValue(null, ATTRIBUTE_CATEGORY);
                if (TextUtils.isEmpty(shortcutName)) {
                    Log.w(TAG, "Unable to get shortcut for: " + packageName + "/" + className);
                    continue;
                }
                char shortcutChar = shortcutName.charAt(0);
                if (packageName != null && className != null) {
                    ActivityInfo info = null;
                    ComponentName componentName = new ComponentName(packageName, className);
                    try {
                        info = packageManager.getActivityInfo(componentName, 0);
                    }
                    catch (PackageManager.NameNotFoundException e) {
                        String[] packages = packageManager.canonicalToCurrentPackageNames(new String[]{packageName});
                        componentName = new ComponentName(packages[0], className);
                        try {
                            info = packageManager.getActivityInfo(componentName, 0);
                        }
                        catch (PackageManager.NameNotFoundException e1) {
                            Log.w(TAG, "Unable to add bookmark: " + packageName + "/" + className, e);
                            continue;
                        }
                    }
                    intent = new Intent("android.intent.action.MAIN");
                    intent.addCategory("android.intent.category.LAUNCHER");
                    intent.setComponent(componentName);
                    title = info.loadLabel(packageManager).toString();
                } else if (categoryName != null) {
                    intent = Intent.makeMainSelectorActivity("android.intent.action.MAIN", categoryName);
                    title = "";
                } else {
                    Log.w(TAG, "Unable to add bookmark for shortcut " + shortcutName + ": missing package/class or category attributes");
                    continue;
                }
                ShortcutInfo shortcut = new ShortcutInfo(title, intent);
                this.mShortcuts.put(shortcutChar, shortcut);
            }
        }
        catch (XmlPullParserException e) {
            Log.w(TAG, "Got exception parsing bookmarks.", e);
        }
        catch (IOException e) {
            Log.w(TAG, "Got exception parsing bookmarks.", e);
        }
    }

    private static final class ShortcutInfo {
        public final String title;
        public final Intent intent;

        public ShortcutInfo(String title, Intent intent) {
            this.title = title;
            this.intent = intent;
        }
    }
}

