/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.policy;

import android.os.IBinder;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.Slog;
import android.view.WindowManagerInternal;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.Interpolator;
import android.view.animation.TranslateAnimation;
import com.android.internal.statusbar.IStatusBarService;
import com.android.server.policy.BarController;

public class StatusBarController
extends BarController {
    private static final long TRANSITION_DURATION = 120L;
    private final WindowManagerInternal.AppTransitionListener mAppTransitionListener = new WindowManagerInternal.AppTransitionListener(){

        @Override
        public void onAppTransitionPendingLocked() {
            StatusBarController.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        IStatusBarService statusbar = StatusBarController.this.getStatusBarService();
                        if (statusbar != null) {
                            statusbar.appTransitionPending();
                        }
                    }
                    catch (RemoteException e) {
                        Slog.e(StatusBarController.this.mTag, "RemoteException when app transition is pending", e);
                        StatusBarController.this.mStatusBarService = null;
                    }
                }
            });
        }

        @Override
        public void onAppTransitionStartingLocked(IBinder openToken, IBinder closeToken, final Animation openAnimation, final Animation closeAnimation) {
            StatusBarController.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        IStatusBarService statusbar = StatusBarController.this.getStatusBarService();
                        if (statusbar != null) {
                            long startTime = StatusBarController.this.calculateStatusBarTransitionStartTime(openAnimation, closeAnimation);
                            statusbar.appTransitionStarting(startTime, 120L);
                        }
                    }
                    catch (RemoteException e) {
                        Slog.e(StatusBarController.this.mTag, "RemoteException when app transition is starting", e);
                        StatusBarController.this.mStatusBarService = null;
                    }
                }
            });
        }

        @Override
        public void onAppTransitionCancelledLocked() {
            StatusBarController.this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        IStatusBarService statusbar = StatusBarController.this.getStatusBarService();
                        if (statusbar != null) {
                            statusbar.appTransitionCancelled();
                        }
                    }
                    catch (RemoteException e) {
                        Slog.e(StatusBarController.this.mTag, "RemoteException when app transition is cancelled", e);
                        StatusBarController.this.mStatusBarService = null;
                    }
                }
            });
        }
    };

    public StatusBarController() {
        super("StatusBar", 0x4000000, 0x10000000, 0x40000000, 1, 0x4000000);
    }

    public WindowManagerInternal.AppTransitionListener getAppTransitionListener() {
        return this.mAppTransitionListener;
    }

    private long calculateStatusBarTransitionStartTime(Animation openAnimation, Animation closeAnimation) {
        if (openAnimation != null && closeAnimation != null) {
            TranslateAnimation openTranslateAnimation = this.findTranslateAnimation(openAnimation);
            TranslateAnimation closeTranslateAnimation = this.findTranslateAnimation(closeAnimation);
            if (openTranslateAnimation != null) {
                float t = this.findAlmostThereFraction(openTranslateAnimation.getInterpolator());
                return SystemClock.uptimeMillis() + openTranslateAnimation.getStartOffset() + (long)((float)openTranslateAnimation.getDuration() * t) - 120L;
            }
            if (closeTranslateAnimation != null) {
                return SystemClock.uptimeMillis();
            }
            return SystemClock.uptimeMillis();
        }
        return SystemClock.uptimeMillis();
    }

    private TranslateAnimation findTranslateAnimation(Animation animation) {
        if (animation instanceof TranslateAnimation) {
            return (TranslateAnimation)animation;
        }
        if (animation instanceof AnimationSet) {
            AnimationSet set = (AnimationSet)animation;
            for (int i = 0; i < set.getAnimations().size(); ++i) {
                Animation a = set.getAnimations().get(i);
                if (!(a instanceof TranslateAnimation)) continue;
                return (TranslateAnimation)a;
            }
        }
        return null;
    }

    private float findAlmostThereFraction(Interpolator interpolator2) {
        float val = 0.5f;
        for (float adj = 0.25f; adj >= 0.01f; adj /= 2.0f) {
            if (interpolator2.getInterpolation(val) < 0.99f) {
                val += adj;
                continue;
            }
            val -= adj;
        }
        return val;
    }
}

