/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.policy.keyguard;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.res.Resources;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.Log;
import android.util.Slog;
import android.view.View;
import android.view.WindowManager;
import android.view.WindowManagerPolicy;
import com.android.internal.policy.IKeyguardDrawnCallback;
import com.android.internal.policy.IKeyguardExitCallback;
import com.android.internal.policy.IKeyguardService;
import com.android.server.policy.keyguard.KeyguardServiceWrapper;

public class KeyguardServiceDelegate {
    private static final String TAG = "KeyguardServiceDelegate";
    private static final boolean DEBUG = true;
    protected KeyguardServiceWrapper mKeyguardService;
    private final Context mContext;
    private final View mScrim;
    private final Handler mScrimHandler;
    private final KeyguardState mKeyguardState = new KeyguardState();
    private DrawnListener mDrawnListenerWhenConnect;
    private final ServiceConnection mKeyguardConnection = new ServiceConnection(){

        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            Log.v(KeyguardServiceDelegate.TAG, "*** Keyguard connected (yay!)");
            KeyguardServiceDelegate.this.mKeyguardService = new KeyguardServiceWrapper(KeyguardServiceDelegate.this.mContext, IKeyguardService.Stub.asInterface(service));
            if (((KeyguardServiceDelegate)KeyguardServiceDelegate.this).mKeyguardState.systemIsReady) {
                KeyguardServiceDelegate.this.mKeyguardService.onSystemReady();
                KeyguardServiceDelegate.this.mKeyguardService.onStartedWakingUp();
                KeyguardServiceDelegate.this.mKeyguardService.onScreenTurningOn(new KeyguardShowDelegate(KeyguardServiceDelegate.this.mDrawnListenerWhenConnect));
                KeyguardServiceDelegate.this.mKeyguardService.onScreenTurnedOn();
                KeyguardServiceDelegate.this.mDrawnListenerWhenConnect = null;
            }
            if (((KeyguardServiceDelegate)KeyguardServiceDelegate.this).mKeyguardState.bootCompleted) {
                KeyguardServiceDelegate.this.mKeyguardService.onBootCompleted();
            }
            if (((KeyguardServiceDelegate)KeyguardServiceDelegate.this).mKeyguardState.occluded) {
                KeyguardServiceDelegate.this.mKeyguardService.setOccluded(((KeyguardServiceDelegate)KeyguardServiceDelegate.this).mKeyguardState.occluded);
            }
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
            Log.v(KeyguardServiceDelegate.TAG, "*** Keyguard disconnected (boo!)");
            KeyguardServiceDelegate.this.mKeyguardService = null;
        }
    };

    public KeyguardServiceDelegate(Context context) {
        this.mContext = context;
        this.mScrim = KeyguardServiceDelegate.createScrim(context);
        this.mScrimHandler = new Handler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindService(Context context) {
        Intent intent = new Intent();
        Resources resources = context.getApplicationContext().getResources();
        ComponentName keyguardComponent = ComponentName.unflattenFromString(resources.getString(17039437));
        intent.setComponent(keyguardComponent);
        if (!context.bindServiceAsUser(intent, this.mKeyguardConnection, 1, UserHandle.OWNER)) {
            Log.v(TAG, "*** Keyguard: can't bind to " + keyguardComponent);
            this.mKeyguardState.showing = false;
            this.mKeyguardState.showingAndNotOccluded = false;
            this.mKeyguardState.secure = false;
            KeyguardState keyguardState = this.mKeyguardState;
            synchronized (keyguardState) {
                this.mKeyguardState.deviceHasKeyguard = false;
                this.hideScrim();
            }
        } else {
            Log.v(TAG, "*** Keyguard started");
        }
    }

    public boolean isShowing() {
        if (this.mKeyguardService != null) {
            this.mKeyguardState.showing = this.mKeyguardService.isShowing();
        }
        return this.mKeyguardState.showing;
    }

    public boolean isInputRestricted() {
        if (this.mKeyguardService != null) {
            this.mKeyguardState.inputRestricted = this.mKeyguardService.isInputRestricted();
        }
        return this.mKeyguardState.inputRestricted;
    }

    public void verifyUnlock(WindowManagerPolicy.OnKeyguardExitResult onKeyguardExitResult) {
        if (this.mKeyguardService != null) {
            this.mKeyguardService.verifyUnlock(new KeyguardExitDelegate(onKeyguardExitResult));
        }
    }

    public void keyguardDone(boolean authenticated, boolean wakeup) {
        if (this.mKeyguardService != null) {
            this.mKeyguardService.keyguardDone(authenticated, wakeup);
        }
    }

    public void setOccluded(boolean isOccluded) {
        if (this.mKeyguardService != null) {
            this.mKeyguardService.setOccluded(isOccluded);
        }
        this.mKeyguardState.occluded = isOccluded;
    }

    public void dismiss() {
        if (this.mKeyguardService != null) {
            this.mKeyguardService.dismiss();
        }
    }

    public boolean isSecure() {
        if (this.mKeyguardService != null) {
            this.mKeyguardState.secure = this.mKeyguardService.isSecure();
        }
        return this.mKeyguardState.secure;
    }

    public void onDreamingStarted() {
        if (this.mKeyguardService != null) {
            this.mKeyguardService.onDreamingStarted();
        }
        this.mKeyguardState.dreaming = true;
    }

    public void onDreamingStopped() {
        if (this.mKeyguardService != null) {
            this.mKeyguardService.onDreamingStopped();
        }
        this.mKeyguardState.dreaming = false;
    }

    public void onStartedWakingUp() {
        if (this.mKeyguardService != null) {
            Log.v(TAG, "onStartedWakingUp()");
            this.mKeyguardService.onStartedWakingUp();
        }
    }

    public void onScreenTurnedOff() {
        if (this.mKeyguardService != null) {
            Log.v(TAG, "onScreenTurnedOff()");
            this.mKeyguardService.onScreenTurnedOff();
        }
    }

    public void onScreenTurningOn(DrawnListener drawnListener) {
        if (this.mKeyguardService != null) {
            Log.v(TAG, "onScreenTurnedOn(showListener = " + drawnListener + ")");
            this.mKeyguardService.onScreenTurningOn(new KeyguardShowDelegate(drawnListener));
        } else {
            Slog.w(TAG, "onScreenTurningOn(): no keyguard service!");
            this.mDrawnListenerWhenConnect = drawnListener;
            this.showScrim();
        }
    }

    public void onScreenTurnedOn() {
        if (this.mKeyguardService != null) {
            Log.v(TAG, "onScreenTurnedOn()");
            this.mKeyguardService.onScreenTurnedOn();
        }
    }

    public void onStartedGoingToSleep(int why) {
        if (this.mKeyguardService != null) {
            this.mKeyguardService.onStartedGoingToSleep(why);
        }
        this.mKeyguardState.offReason = why;
    }

    public void onFinishedGoingToSleep(int why) {
        if (this.mKeyguardService != null) {
            this.mKeyguardService.onFinishedGoingToSleep(why);
        }
    }

    public void setKeyguardEnabled(boolean enabled) {
        if (this.mKeyguardService != null) {
            this.mKeyguardService.setKeyguardEnabled(enabled);
        }
        this.mKeyguardState.enabled = enabled;
    }

    public void onSystemReady() {
        if (this.mKeyguardService != null) {
            this.mKeyguardService.onSystemReady();
        } else {
            this.mKeyguardState.systemIsReady = true;
        }
    }

    public void doKeyguardTimeout(Bundle options) {
        if (this.mKeyguardService != null) {
            this.mKeyguardService.doKeyguardTimeout(options);
        }
    }

    public void setCurrentUser(int newUserId) {
        if (this.mKeyguardService != null) {
            this.mKeyguardService.setCurrentUser(newUserId);
        }
        this.mKeyguardState.currentUser = newUserId;
    }

    public void startKeyguardExitAnimation(long startTime, long fadeoutDuration) {
        if (this.mKeyguardService != null) {
            this.mKeyguardService.startKeyguardExitAnimation(startTime, fadeoutDuration);
        }
    }

    private static final View createScrim(Context context) {
        View view = new View(context);
        int flags = 0x110900;
        int stretch = -1;
        int type = 2029;
        WindowManager.LayoutParams lp = new WindowManager.LayoutParams(-1, -1, 2029, flags, -3);
        lp.softInputMode = 16;
        lp.screenOrientation = 5;
        lp.privateFlags |= 1;
        lp.setTitle("KeyguardScrim");
        WindowManager wm = (WindowManager)context.getSystemService("window");
        wm.addView(view, lp);
        view.setSystemUiVisibility(56688640);
        return view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showScrim() {
        KeyguardState keyguardState = this.mKeyguardState;
        synchronized (keyguardState) {
            if (!this.mKeyguardState.deviceHasKeyguard) {
                return;
            }
            this.mScrimHandler.post(new Runnable(){

                @Override
                public void run() {
                    KeyguardServiceDelegate.this.mScrim.setVisibility(0);
                }
            });
        }
    }

    public void hideScrim() {
        this.mScrimHandler.post(new Runnable(){

            @Override
            public void run() {
                KeyguardServiceDelegate.this.mScrim.setVisibility(8);
            }
        });
    }

    public void onBootCompleted() {
        if (this.mKeyguardService != null) {
            this.mKeyguardService.onBootCompleted();
        }
        this.mKeyguardState.bootCompleted = true;
    }

    public void onActivityDrawn() {
        if (this.mKeyguardService != null) {
            this.mKeyguardService.onActivityDrawn();
        }
    }

    private final class KeyguardExitDelegate
    extends IKeyguardExitCallback.Stub {
        private WindowManagerPolicy.OnKeyguardExitResult mOnKeyguardExitResult;

        KeyguardExitDelegate(WindowManagerPolicy.OnKeyguardExitResult onKeyguardExitResult) {
            this.mOnKeyguardExitResult = onKeyguardExitResult;
        }

        @Override
        public void onKeyguardExitResult(boolean success) throws RemoteException {
            Log.v(KeyguardServiceDelegate.TAG, "**** onKeyguardExitResult(" + success + ") CALLED ****");
            if (this.mOnKeyguardExitResult != null) {
                this.mOnKeyguardExitResult.onKeyguardExitResult(success);
            }
        }
    }

    private final class KeyguardShowDelegate
    extends IKeyguardDrawnCallback.Stub {
        private DrawnListener mDrawnListener;

        KeyguardShowDelegate(DrawnListener drawnListener) {
            this.mDrawnListener = drawnListener;
        }

        @Override
        public void onDrawn() throws RemoteException {
            Log.v(KeyguardServiceDelegate.TAG, "**** SHOWN CALLED ****");
            if (this.mDrawnListener != null) {
                this.mDrawnListener.onDrawn();
            }
            KeyguardServiceDelegate.this.hideScrim();
        }
    }

    public static interface DrawnListener {
        public void onDrawn();
    }

    private static final class KeyguardState {
        boolean showing = true;
        boolean showingAndNotOccluded = true;
        boolean inputRestricted;
        boolean occluded;
        boolean secure = true;
        boolean dreaming;
        boolean systemIsReady;
        boolean deviceHasKeyguard = true;
        public boolean enabled;
        public int offReason;
        public int currentUser;
        public boolean bootCompleted;

        KeyguardState() {
        }
    }
}

