/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.trust;

import android.app.ActivityManager;
import android.app.admin.DevicePolicyManager;
import android.app.trust.ITrustListener;
import android.app.trust.ITrustManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.UserInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Drawable;
import android.os.Binder;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.Settings;
import android.util.ArraySet;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Slog;
import android.util.SparseBooleanArray;
import android.util.Xml;
import android.view.IWindowManager;
import android.view.WindowManagerGlobal;
import com.android.internal.R;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.content.PackageMonitor;
import com.android.internal.widget.LockPatternUtils;
import com.android.server.SystemService;
import com.android.server.trust.TrustAgentWrapper;
import com.android.server.trust.TrustArchive;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class TrustManagerService
extends SystemService {
    private static final boolean DEBUG = false;
    private static final String TAG = "TrustManagerService";
    private static final Intent TRUST_AGENT_INTENT = new Intent("android.service.trust.TrustAgentService");
    private static final String PERMISSION_PROVIDE_AGENT = "android.permission.PROVIDE_TRUST_AGENT";
    private static final int MSG_REGISTER_LISTENER = 1;
    private static final int MSG_UNREGISTER_LISTENER = 2;
    private static final int MSG_DISPATCH_UNLOCK_ATTEMPT = 3;
    private static final int MSG_ENABLED_AGENTS_CHANGED = 4;
    private static final int MSG_REQUIRE_CREDENTIAL_ENTRY = 5;
    private static final int MSG_KEYGUARD_SHOWING_CHANGED = 6;
    private static final int MSG_START_USER = 7;
    private static final int MSG_CLEANUP_USER = 8;
    private static final int MSG_SWITCH_USER = 9;
    private final ArraySet<AgentInfo> mActiveAgents = new ArraySet();
    private final ArrayList<ITrustListener> mTrustListeners = new ArrayList();
    private final Receiver mReceiver = new Receiver();
    private final SparseBooleanArray mUserHasAuthenticated = new SparseBooleanArray();
    final TrustArchive mArchive = new TrustArchive();
    private final Context mContext;
    private final LockPatternUtils mLockPatternUtils;
    private final UserManager mUserManager;
    private final ActivityManager mActivityManager;
    @GuardedBy(value="mUserIsTrusted")
    private final SparseBooleanArray mUserIsTrusted = new SparseBooleanArray();
    @GuardedBy(value="mDeviceLockedForUser")
    private final SparseBooleanArray mDeviceLockedForUser = new SparseBooleanArray();
    @GuardedBy(value="mUserHasAuthenticatedSinceBoot")
    private final SparseBooleanArray mUserHasAuthenticatedSinceBoot = new SparseBooleanArray();
    private boolean mTrustAgentsCanRun = false;
    private int mCurrentUser = 0;
    private final IBinder mService = new ITrustManager.Stub(){

        @Override
        public void reportUnlockAttempt(boolean authenticated, int userId) throws RemoteException {
            this.enforceReportPermission();
            TrustManagerService.this.mHandler.obtainMessage(3, authenticated ? 1 : 0, userId).sendToTarget();
        }

        @Override
        public void reportEnabledTrustAgentsChanged(int userId) throws RemoteException {
            this.enforceReportPermission();
            TrustManagerService.this.mHandler.removeMessages(4);
            TrustManagerService.this.mHandler.sendEmptyMessage(4);
        }

        @Override
        public void reportRequireCredentialEntry(int userId) throws RemoteException {
            this.enforceReportPermission();
            if (userId != -1 && userId < 0) {
                throw new IllegalArgumentException("userId must be an explicit user id or USER_ALL");
            }
            TrustManagerService.this.mHandler.obtainMessage(5, userId, 0).sendToTarget();
        }

        @Override
        public void reportKeyguardShowingChanged() throws RemoteException {
            this.enforceReportPermission();
            TrustManagerService.this.mHandler.removeMessages(6);
            TrustManagerService.this.mHandler.sendEmptyMessage(6);
        }

        @Override
        public void registerTrustListener(ITrustListener trustListener) throws RemoteException {
            this.enforceListenerPermission();
            TrustManagerService.this.mHandler.obtainMessage(1, trustListener).sendToTarget();
        }

        @Override
        public void unregisterTrustListener(ITrustListener trustListener) throws RemoteException {
            this.enforceListenerPermission();
            TrustManagerService.this.mHandler.obtainMessage(2, trustListener).sendToTarget();
        }

        @Override
        public boolean isDeviceLocked(int userId) throws RemoteException {
            userId = ActivityManager.handleIncomingUser(1.getCallingPid(), 1.getCallingUid(), userId, false, true, "isDeviceLocked", null);
            userId = TrustManagerService.this.resolveProfileParent(userId);
            return TrustManagerService.this.isDeviceLockedInner(userId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isDeviceSecure(int userId) throws RemoteException {
            userId = ActivityManager.handleIncomingUser(1.getCallingPid(), 1.getCallingUid(), userId, false, true, "isDeviceSecure", null);
            userId = TrustManagerService.this.resolveProfileParent(userId);
            long token = Binder.clearCallingIdentity();
            try {
                boolean bl = new LockPatternUtils(TrustManagerService.this.mContext).isSecure(userId);
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasUserAuthenticatedSinceBoot(int userId) throws RemoteException {
            TrustManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_KEYGUARD_SECURE_STORAGE", null);
            long token = Binder.clearCallingIdentity();
            try {
                boolean bl = TrustManagerService.this.getUserHasAuthenticatedSinceBoot(userId);
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        private void enforceReportPermission() {
            TrustManagerService.this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_KEYGUARD_SECURE_STORAGE", "reporting trust events");
        }

        private void enforceListenerPermission() {
            TrustManagerService.this.mContext.enforceCallingPermission("android.permission.TRUST_LISTENER", "register trust listener");
        }

        @Override
        protected void dump(FileDescriptor fd, final PrintWriter fout, String[] args) {
            TrustManagerService.this.mContext.enforceCallingPermission("android.permission.DUMP", "dumping TrustManagerService");
            if (TrustManagerService.this.isSafeMode()) {
                fout.println("disabled because the system is in safe mode.");
                return;
            }
            if (!TrustManagerService.this.mTrustAgentsCanRun) {
                fout.println("disabled because the third-party apps can't run yet.");
                return;
            }
            final List<UserInfo> userInfos = TrustManagerService.this.mUserManager.getUsers(true);
            TrustManagerService.this.mHandler.runWithScissors(new Runnable(){

                @Override
                public void run() {
                    fout.println("Trust manager state:");
                    for (UserInfo user : userInfos) {
                        this.dumpUser(fout, user, user.id == TrustManagerService.this.mCurrentUser);
                    }
                }
            }, 1500L);
        }

        private void dumpUser(PrintWriter fout, UserInfo user, boolean isCurrent) {
            fout.printf(" User \"%s\" (id=%d, flags=%#x)", user.name, user.id, user.flags);
            if (!user.supportsSwitchTo()) {
                fout.println("(managed profile)");
                fout.println("   disabled because switching to this user is not possible.");
                return;
            }
            if (isCurrent) {
                fout.print(" (current)");
            }
            fout.print(": trusted=" + this.dumpBool(TrustManagerService.this.aggregateIsTrusted(user.id)));
            fout.print(", trustManaged=" + this.dumpBool(TrustManagerService.this.aggregateIsTrustManaged(user.id)));
            fout.print(", deviceLocked=" + this.dumpBool(TrustManagerService.this.isDeviceLockedInner(user.id)));
            fout.print(", hasAuthenticated=" + this.dumpBool(TrustManagerService.this.getUserHasAuthenticated(user.id)));
            fout.print(", hasAuthenticatedSinceBoot=" + this.dumpBool(TrustManagerService.this.getUserHasAuthenticatedSinceBoot(user.id)));
            fout.println();
            fout.println("   Enabled agents:");
            boolean duplicateSimpleNames = false;
            ArraySet<String> simpleNames = new ArraySet<String>();
            for (AgentInfo info : TrustManagerService.this.mActiveAgents) {
                if (info.userId != user.id) continue;
                boolean trusted = info.agent.isTrusted();
                fout.print("    ");
                fout.println(info.component.flattenToShortString());
                fout.print("     bound=" + this.dumpBool(info.agent.isBound()));
                fout.print(", connected=" + this.dumpBool(info.agent.isConnected()));
                fout.print(", managingTrust=" + this.dumpBool(info.agent.isManagingTrust()));
                fout.print(", trusted=" + this.dumpBool(trusted));
                fout.println();
                if (trusted) {
                    fout.println("      message=\"" + info.agent.getMessage() + "\"");
                }
                if (!info.agent.isConnected()) {
                    String restartTime = TrustArchive.formatDuration(info.agent.getScheduledRestartUptimeMillis() - SystemClock.uptimeMillis());
                    fout.println("      restartScheduledAt=" + restartTime);
                }
                if (simpleNames.add(TrustArchive.getSimpleName(info.component))) continue;
                duplicateSimpleNames = true;
            }
            fout.println("   Events:");
            TrustManagerService.this.mArchive.dump(fout, 50, user.id, "    ", duplicateSimpleNames);
            fout.println();
        }

        private String dumpBool(boolean b) {
            return b ? "1" : "0";
        }
    };
    private final Handler mHandler = new Handler(){

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    TrustManagerService.this.addListener((ITrustListener)msg.obj);
                    break;
                }
                case 2: {
                    TrustManagerService.this.removeListener((ITrustListener)msg.obj);
                    break;
                }
                case 3: {
                    TrustManagerService.this.dispatchUnlockAttempt(msg.arg1 != 0, msg.arg2);
                    break;
                }
                case 4: {
                    TrustManagerService.this.refreshAgentList(-1);
                    TrustManagerService.this.refreshDeviceLockedForUser(-1);
                    break;
                }
                case 5: {
                    TrustManagerService.this.requireCredentialEntry(msg.arg1);
                    break;
                }
                case 6: {
                    TrustManagerService.this.refreshDeviceLockedForUser(TrustManagerService.this.mCurrentUser);
                    break;
                }
                case 7: 
                case 8: {
                    TrustManagerService.this.refreshAgentList(msg.arg1);
                    break;
                }
                case 9: {
                    TrustManagerService.this.mCurrentUser = msg.arg1;
                    TrustManagerService.this.refreshDeviceLockedForUser(-1);
                }
            }
        }
    };
    private final PackageMonitor mPackageMonitor = new PackageMonitor(){

        @Override
        public void onSomePackagesChanged() {
            TrustManagerService.this.refreshAgentList(-1);
        }

        @Override
        public boolean onPackageChanged(String packageName, int uid, String[] components) {
            return true;
        }

        @Override
        public void onPackageDisappeared(String packageName, int reason) {
            TrustManagerService.this.removeAgentsOfPackage(packageName);
        }
    };

    public TrustManagerService(Context context) {
        super(context);
        this.mContext = context;
        this.mUserManager = (UserManager)this.mContext.getSystemService("user");
        this.mActivityManager = (ActivityManager)this.mContext.getSystemService("activity");
        this.mLockPatternUtils = new LockPatternUtils(context);
    }

    @Override
    public void onStart() {
        this.publishBinderService("trust", this.mService);
    }

    @Override
    public void onBootPhase(int phase) {
        if (this.isSafeMode()) {
            return;
        }
        if (phase == 500) {
            this.mPackageMonitor.register(this.mContext, this.mHandler.getLooper(), UserHandle.ALL, true);
            this.mReceiver.register(this.mContext);
        } else if (phase == 600) {
            this.mTrustAgentsCanRun = true;
            this.refreshAgentList(-1);
        } else if (phase == 1000) {
            this.maybeEnableFactoryTrustAgents(this.mLockPatternUtils, 0);
        }
    }

    private void updateTrustAll() {
        List<UserInfo> userInfos = this.mUserManager.getUsers(true);
        for (UserInfo userInfo : userInfos) {
            this.updateTrust(userInfo.id, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTrust(int userId, int flags) {
        boolean changed;
        this.dispatchOnTrustManagedChanged(this.aggregateIsTrustManaged(userId), userId);
        boolean trusted = this.aggregateIsTrusted(userId);
        SparseBooleanArray sparseBooleanArray = this.mUserIsTrusted;
        synchronized (sparseBooleanArray) {
            changed = this.mUserIsTrusted.get(userId) != trusted;
            this.mUserIsTrusted.put(userId, trusted);
        }
        this.dispatchOnTrustChanged(trusted, userId, flags);
        if (changed) {
            this.refreshDeviceLockedForUser(userId);
        }
    }

    /*
     * WARNING - void declaration
     */
    void refreshAgentList(int userId) {
        void var7_10;
        List<Object> userInfos;
        if (!this.mTrustAgentsCanRun) {
            return;
        }
        if (userId != -1 && userId < 0) {
            Log.e(TAG, "refreshAgentList(userId=" + userId + "): Invalid user handle," + " must be USER_ALL or a specific user.", new Throwable("here"));
            userId = -1;
        }
        PackageManager pm = this.mContext.getPackageManager();
        if (userId == -1) {
            userInfos = this.mUserManager.getUsers(true);
        } else {
            userInfos = new ArrayList();
            userInfos.add(this.mUserManager.getUserInfo(userId));
        }
        LockPatternUtils lockPatternUtils = this.mLockPatternUtils;
        ArraySet<AgentInfo> obsoleteAgents = new ArraySet<AgentInfo>();
        obsoleteAgents.addAll(this.mActiveAgents);
        for (UserInfo userInfo : userInfos) {
            if (userInfo == null || userInfo.partial || !userInfo.isEnabled() || userInfo.guestToRemove || !userInfo.supportsSwitchTo() || !this.mActivityManager.isUserRunning(userInfo.id) || !lockPatternUtils.isSecure(userInfo.id) || !this.getUserHasAuthenticated(userInfo.id)) continue;
            DevicePolicyManager dpm = lockPatternUtils.getDevicePolicyManager();
            int disabledFeatures = dpm.getKeyguardDisabledFeatures(null, userInfo.id);
            boolean disableTrustAgents = (disabledFeatures & 0x10) != 0;
            List<ComponentName> enabledAgents = lockPatternUtils.getEnabledTrustAgents(userInfo.id);
            if (enabledAgents == null) continue;
            List<ResolveInfo> resolveInfos = this.resolveAllowedTrustAgents(pm, userInfo.id);
            for (ResolveInfo resolveInfo : resolveInfos) {
                List<PersistableBundle> config;
                ComponentName name = this.getComponentName(resolveInfo);
                if (!enabledAgents.contains(name) || disableTrustAgents && ((config = dpm.getTrustAgentConfiguration(null, name, userInfo.id)) == null || config.isEmpty())) continue;
                AgentInfo agentInfo = new AgentInfo();
                agentInfo.component = name;
                agentInfo.userId = userInfo.id;
                if (!this.mActiveAgents.contains(agentInfo)) {
                    agentInfo.label = resolveInfo.loadLabel(pm);
                    agentInfo.icon = resolveInfo.loadIcon(pm);
                    agentInfo.settings = this.getSettingsComponentName(pm, resolveInfo);
                    agentInfo.agent = new TrustAgentWrapper(this.mContext, this, new Intent().setComponent(name), userInfo.getUserHandle());
                    this.mActiveAgents.add(agentInfo);
                    continue;
                }
                obsoleteAgents.remove(agentInfo);
            }
        }
        boolean trustMayHaveChanged = false;
        boolean bl = false;
        while (var7_10 < obsoleteAgents.size()) {
            AgentInfo info = (AgentInfo)obsoleteAgents.valueAt((int)var7_10);
            if (userId == -1 || userId == info.userId) {
                if (info.agent.isManagingTrust()) {
                    trustMayHaveChanged = true;
                }
                info.agent.destroy();
                this.mActiveAgents.remove(info);
            }
            ++var7_10;
        }
        if (trustMayHaveChanged) {
            if (userId == -1) {
                this.updateTrustAll();
            } else {
                this.updateTrust(userId, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isDeviceLockedInner(int userId) {
        SparseBooleanArray sparseBooleanArray = this.mDeviceLockedForUser;
        synchronized (sparseBooleanArray) {
            return this.mDeviceLockedForUser.get(userId, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshDeviceLockedForUser(int userId) {
        List<Object> userInfos;
        if (userId != -1 && userId < 0) {
            Log.e(TAG, "refreshDeviceLockedForUser(userId=" + userId + "): Invalid user handle," + " must be USER_ALL or a specific user.", new Throwable("here"));
            userId = -1;
        }
        if (userId == -1) {
            userInfos = this.mUserManager.getUsers(true);
        } else {
            userInfos = new ArrayList();
            userInfos.add(this.mUserManager.getUserInfo(userId));
        }
        IWindowManager wm = WindowManagerGlobal.getWindowManagerService();
        for (int i = 0; i < userInfos.size(); ++i) {
            boolean changed;
            UserInfo info = (UserInfo)userInfos.get(i);
            if (info == null || info.partial || !info.isEnabled() || info.guestToRemove || !info.supportsSwitchTo()) continue;
            int id2 = info.id;
            boolean secure = this.mLockPatternUtils.isSecure(id2);
            boolean trusted = this.aggregateIsTrusted(id2);
            boolean showingKeyguard = true;
            if (this.mCurrentUser == id2) {
                try {
                    showingKeyguard = wm.isKeyguardLocked();
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
            boolean deviceLocked = secure && showingKeyguard && !trusted;
            SparseBooleanArray sparseBooleanArray = this.mDeviceLockedForUser;
            synchronized (sparseBooleanArray) {
                changed = this.isDeviceLockedInner(id2) != deviceLocked;
                this.mDeviceLockedForUser.put(id2, deviceLocked);
            }
            if (!changed) continue;
            this.dispatchDeviceLocked(id2, deviceLocked);
        }
    }

    private void dispatchDeviceLocked(int userId, boolean isLocked) {
        for (int i = 0; i < this.mActiveAgents.size(); ++i) {
            AgentInfo agent = this.mActiveAgents.valueAt(i);
            if (agent.userId != userId) continue;
            if (isLocked) {
                agent.agent.onDeviceLocked();
                continue;
            }
            agent.agent.onDeviceUnlocked();
        }
    }

    void updateDevicePolicyFeatures() {
        for (int i = 0; i < this.mActiveAgents.size(); ++i) {
            AgentInfo info = this.mActiveAgents.valueAt(i);
            if (!info.agent.isConnected()) continue;
            info.agent.updateDevicePolicyFeatures();
        }
    }

    private void removeAgentsOfPackage(String packageName) {
        boolean trustMayHaveChanged = false;
        for (int i = this.mActiveAgents.size() - 1; i >= 0; --i) {
            AgentInfo info = this.mActiveAgents.valueAt(i);
            if (!packageName.equals(info.component.getPackageName())) continue;
            Log.i(TAG, "Resetting agent " + info.component.flattenToShortString());
            if (info.agent.isManagingTrust()) {
                trustMayHaveChanged = true;
            }
            info.agent.destroy();
            this.mActiveAgents.removeAt(i);
        }
        if (trustMayHaveChanged) {
            this.updateTrustAll();
        }
    }

    public void resetAgent(ComponentName name, int userId) {
        boolean trustMayHaveChanged = false;
        for (int i = this.mActiveAgents.size() - 1; i >= 0; --i) {
            AgentInfo info = this.mActiveAgents.valueAt(i);
            if (!name.equals(info.component) || userId != info.userId) continue;
            Log.i(TAG, "Resetting agent " + info.component.flattenToShortString());
            if (info.agent.isManagingTrust()) {
                trustMayHaveChanged = true;
            }
            info.agent.destroy();
            this.mActiveAgents.removeAt(i);
        }
        if (trustMayHaveChanged) {
            this.updateTrust(userId, 0);
        }
        this.refreshAgentList(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ComponentName getSettingsComponentName(PackageManager pm, ResolveInfo resolveInfo) {
        if (resolveInfo == null || resolveInfo.serviceInfo == null || resolveInfo.serviceInfo.metaData == null) {
            return null;
        }
        String cn = null;
        Exception caughtException = null;
        try (XmlResourceParser parser = null;){
            int type;
            parser = resolveInfo.serviceInfo.loadXmlMetaData(pm, "android.service.trust.trustagent");
            if (parser == null) {
                Slog.w(TAG, "Can't find android.service.trust.trustagent meta-data");
                ComponentName componentName = null;
                return componentName;
            }
            Resources res = pm.getResourcesForApplication(resolveInfo.serviceInfo.applicationInfo);
            AttributeSet attrs = Xml.asAttributeSet(parser);
            while ((type = parser.next()) != 1 && type != 2) {
            }
            String nodeName = parser.getName();
            if (!"trust-agent".equals(nodeName)) {
                Slog.w(TAG, "Meta-data does not start with trust-agent tag");
                ComponentName componentName = null;
                return componentName;
            }
            TypedArray sa = res.obtainAttributes(attrs, R.styleable.TrustAgent);
            cn = sa.getString(2);
            sa.recycle();
        }
        if (caughtException != null) {
            Slog.w(TAG, "Error parsing : " + resolveInfo.serviceInfo.packageName, caughtException);
            return null;
        }
        if (cn == null) {
            return null;
        }
        if (cn.indexOf(47) < 0) {
            cn = resolveInfo.serviceInfo.packageName + "/" + cn;
        }
        return ComponentName.unflattenFromString(cn);
    }

    private ComponentName getComponentName(ResolveInfo resolveInfo) {
        if (resolveInfo == null || resolveInfo.serviceInfo == null) {
            return null;
        }
        return new ComponentName(resolveInfo.serviceInfo.packageName, resolveInfo.serviceInfo.name);
    }

    private void maybeEnableFactoryTrustAgents(LockPatternUtils utils, int userId) {
        if (0 != Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "trust_agents_initialized", 0, userId)) {
            return;
        }
        PackageManager pm = this.mContext.getPackageManager();
        List<ResolveInfo> resolveInfos = this.resolveAllowedTrustAgents(pm, userId);
        ArraySet<ComponentName> discoveredAgents = new ArraySet<ComponentName>();
        for (ResolveInfo resolveInfo : resolveInfos) {
            ComponentName componentName = this.getComponentName(resolveInfo);
            int applicationInfoFlags = resolveInfo.serviceInfo.applicationInfo.flags;
            if ((applicationInfoFlags & 1) == 0) {
                Log.i(TAG, "Leaving agent " + componentName + " disabled because package " + "is not a system package.");
                continue;
            }
            discoveredAgents.add(componentName);
        }
        List<ComponentName> previouslyEnabledAgents = utils.getEnabledTrustAgents(userId);
        if (previouslyEnabledAgents != null) {
            discoveredAgents.addAll(previouslyEnabledAgents);
        }
        utils.setEnabledTrustAgents(discoveredAgents, userId);
        Settings.Secure.putIntForUser(this.mContext.getContentResolver(), "trust_agents_initialized", 1, userId);
    }

    private List<ResolveInfo> resolveAllowedTrustAgents(PackageManager pm, int userId) {
        List<ResolveInfo> resolveInfos = pm.queryIntentServicesAsUser(TRUST_AGENT_INTENT, 0, userId);
        ArrayList<ResolveInfo> allowedAgents = new ArrayList<ResolveInfo>(resolveInfos.size());
        for (ResolveInfo resolveInfo : resolveInfos) {
            if (resolveInfo.serviceInfo == null || resolveInfo.serviceInfo.applicationInfo == null) continue;
            String packageName = resolveInfo.serviceInfo.packageName;
            if (pm.checkPermission(PERMISSION_PROVIDE_AGENT, packageName) != 0) {
                ComponentName name = this.getComponentName(resolveInfo);
                Log.w(TAG, "Skipping agent " + name + " because package does not have" + " permission " + PERMISSION_PROVIDE_AGENT + ".");
                continue;
            }
            allowedAgents.add(resolveInfo);
        }
        return allowedAgents;
    }

    private boolean aggregateIsTrusted(int userId) {
        if (!this.getUserHasAuthenticated(userId)) {
            return false;
        }
        for (int i = 0; i < this.mActiveAgents.size(); ++i) {
            AgentInfo info = this.mActiveAgents.valueAt(i);
            if (info.userId != userId || !info.agent.isTrusted()) continue;
            return true;
        }
        return false;
    }

    private boolean aggregateIsTrustManaged(int userId) {
        if (!this.getUserHasAuthenticated(userId)) {
            return false;
        }
        for (int i = 0; i < this.mActiveAgents.size(); ++i) {
            AgentInfo info = this.mActiveAgents.valueAt(i);
            if (info.userId != userId || !info.agent.isManagingTrust()) continue;
            return true;
        }
        return false;
    }

    private void dispatchUnlockAttempt(boolean successful, int userId) {
        for (int i = 0; i < this.mActiveAgents.size(); ++i) {
            AgentInfo info = this.mActiveAgents.valueAt(i);
            if (info.userId != userId) continue;
            info.agent.onUnlockAttempt(successful);
        }
        if (successful) {
            this.updateUserHasAuthenticated(userId);
        }
    }

    private void updateUserHasAuthenticated(int userId) {
        boolean changed = this.setUserHasAuthenticated(userId);
        if (changed) {
            this.refreshAgentList(userId);
        }
    }

    private boolean getUserHasAuthenticated(int userId) {
        return this.mUserHasAuthenticated.get(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setUserHasAuthenticated(int userId) {
        if (!this.mUserHasAuthenticated.get(userId)) {
            this.mUserHasAuthenticated.put(userId, true);
            SparseBooleanArray sparseBooleanArray = this.mUserHasAuthenticatedSinceBoot;
            synchronized (sparseBooleanArray) {
                this.mUserHasAuthenticatedSinceBoot.put(userId, true);
            }
            return true;
        }
        return false;
    }

    private void clearUserHasAuthenticated(int userId) {
        if (userId == -1) {
            this.mUserHasAuthenticated.clear();
        } else {
            this.mUserHasAuthenticated.put(userId, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getUserHasAuthenticatedSinceBoot(int userId) {
        SparseBooleanArray sparseBooleanArray = this.mUserHasAuthenticatedSinceBoot;
        synchronized (sparseBooleanArray) {
            return this.mUserHasAuthenticatedSinceBoot.get(userId);
        }
    }

    private void requireCredentialEntry(int userId) {
        this.clearUserHasAuthenticated(userId);
        this.refreshAgentList(userId);
    }

    private void addListener(ITrustListener listener) {
        for (int i = 0; i < this.mTrustListeners.size(); ++i) {
            if (this.mTrustListeners.get(i).asBinder() != listener.asBinder()) continue;
            return;
        }
        this.mTrustListeners.add(listener);
        this.updateTrustAll();
    }

    private void removeListener(ITrustListener listener) {
        for (int i = 0; i < this.mTrustListeners.size(); ++i) {
            if (this.mTrustListeners.get(i).asBinder() != listener.asBinder()) continue;
            this.mTrustListeners.remove(i);
            return;
        }
    }

    private void dispatchOnTrustChanged(boolean enabled, int userId, int flags) {
        if (!enabled) {
            flags = 0;
        }
        for (int i = 0; i < this.mTrustListeners.size(); ++i) {
            try {
                this.mTrustListeners.get(i).onTrustChanged(enabled, userId, flags);
                continue;
            }
            catch (DeadObjectException e) {
                Slog.d(TAG, "Removing dead TrustListener.");
                this.mTrustListeners.remove(i);
                --i;
                continue;
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Exception while notifying TrustListener.", e);
            }
        }
    }

    private void dispatchOnTrustManagedChanged(boolean managed, int userId) {
        for (int i = 0; i < this.mTrustListeners.size(); ++i) {
            try {
                this.mTrustListeners.get(i).onTrustManagedChanged(managed, userId);
                continue;
            }
            catch (DeadObjectException e) {
                Slog.d(TAG, "Removing dead TrustListener.");
                this.mTrustListeners.remove(i);
                --i;
                continue;
            }
            catch (RemoteException e) {
                Slog.e(TAG, "Exception while notifying TrustListener.", e);
            }
        }
    }

    @Override
    public void onStartUser(int userId) {
        this.mHandler.obtainMessage(7, userId, 0, null).sendToTarget();
    }

    @Override
    public void onCleanupUser(int userId) {
        this.mHandler.obtainMessage(8, userId, 0, null).sendToTarget();
    }

    @Override
    public void onSwitchUser(int userId) {
        this.mHandler.obtainMessage(9, userId, 0, null).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int resolveProfileParent(int userId) {
        long identity = Binder.clearCallingIdentity();
        try {
            UserInfo parent = this.mUserManager.getProfileParent(userId);
            if (parent != null) {
                int n = parent.getUserHandle().getIdentifier();
                return n;
            }
            int n = userId;
            return n;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    private class Receiver
    extends BroadcastReceiver {
        private Receiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            int userId;
            String action = intent.getAction();
            if ("android.app.action.DEVICE_POLICY_MANAGER_STATE_CHANGED".equals(action)) {
                TrustManagerService.this.refreshAgentList(this.getSendingUserId());
                TrustManagerService.this.updateDevicePolicyFeatures();
            } else if ("android.intent.action.USER_PRESENT".equals(action)) {
                TrustManagerService.this.updateUserHasAuthenticated(this.getSendingUserId());
            } else if ("android.intent.action.USER_ADDED".equals(action)) {
                int userId2 = this.getUserId(intent);
                if (userId2 > 0) {
                    TrustManagerService.this.maybeEnableFactoryTrustAgents(TrustManagerService.this.mLockPatternUtils, userId2);
                }
            } else if ("android.intent.action.USER_REMOVED".equals(action) && (userId = this.getUserId(intent)) > 0) {
                TrustManagerService.this.mUserHasAuthenticated.delete(userId);
                SparseBooleanArray sparseBooleanArray = TrustManagerService.this.mUserIsTrusted;
                synchronized (sparseBooleanArray) {
                    TrustManagerService.this.mUserIsTrusted.delete(userId);
                }
                sparseBooleanArray = TrustManagerService.this.mDeviceLockedForUser;
                synchronized (sparseBooleanArray) {
                    TrustManagerService.this.mDeviceLockedForUser.delete(userId);
                }
                TrustManagerService.this.refreshAgentList(userId);
                TrustManagerService.this.refreshDeviceLockedForUser(userId);
            }
        }

        private int getUserId(Intent intent) {
            int userId = intent.getIntExtra("android.intent.extra.user_handle", -100);
            if (userId > 0) {
                return userId;
            }
            Slog.wtf(TrustManagerService.TAG, "EXTRA_USER_HANDLE missing or invalid, value=" + userId);
            return -100;
        }

        public void register(Context context) {
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.app.action.DEVICE_POLICY_MANAGER_STATE_CHANGED");
            filter.addAction("android.intent.action.USER_PRESENT");
            filter.addAction("android.intent.action.USER_ADDED");
            filter.addAction("android.intent.action.USER_REMOVED");
            context.registerReceiverAsUser(this, UserHandle.ALL, filter, null, null);
        }
    }

    private static final class AgentInfo {
        CharSequence label;
        Drawable icon;
        ComponentName component;
        ComponentName settings;
        TrustAgentWrapper agent;
        int userId;

        private AgentInfo() {
        }

        public boolean equals(Object other) {
            if (!(other instanceof AgentInfo)) {
                return false;
            }
            AgentInfo o = (AgentInfo)other;
            return this.component.equals(o.component) && this.userId == o.userId;
        }

        public int hashCode() {
            return this.component.hashCode() * 31 + this.userId;
        }
    }
}

