/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.tv;

import android.media.tv.TvInputHardwareInfo;
import android.media.tv.TvStreamConfig;
import android.os.Handler;
import android.os.Message;
import android.os.MessageQueue;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.Surface;
import java.util.LinkedList;
import java.util.Queue;

final class TvInputHal
implements Handler.Callback {
    private static final boolean DEBUG = false;
    private static final String TAG = TvInputHal.class.getSimpleName();
    public static final int SUCCESS = 0;
    public static final int ERROR_NO_INIT = -1;
    public static final int ERROR_STALE_CONFIG = -2;
    public static final int ERROR_UNKNOWN = -3;
    public static final int EVENT_DEVICE_AVAILABLE = 1;
    public static final int EVENT_DEVICE_UNAVAILABLE = 2;
    public static final int EVENT_STREAM_CONFIGURATION_CHANGED = 3;
    public static final int EVENT_FIRST_FRAME_CAPTURED = 4;
    private final Object mLock = new Object();
    private long mPtr = 0L;
    private final Callback mCallback;
    private final Handler mHandler;
    private final SparseIntArray mStreamConfigGenerations = new SparseIntArray();
    private final SparseArray<TvStreamConfig[]> mStreamConfigs = new SparseArray();
    private final Queue<Message> mPendingMessageQueue = new LinkedList<Message>();

    private native long nativeOpen(MessageQueue var1);

    private static native int nativeAddOrUpdateStream(long var0, int var2, int var3, Surface var4);

    private static native int nativeRemoveStream(long var0, int var2, int var3);

    private static native TvStreamConfig[] nativeGetStreamConfigs(long var0, int var2, int var3);

    private static native void nativeClose(long var0);

    public TvInputHal(Callback callback) {
        this.mCallback = callback;
        this.mHandler = new Handler(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        Object object = this.mLock;
        synchronized (object) {
            this.mPtr = this.nativeOpen(this.mHandler.getLooper().getQueue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addOrUpdateStream(int deviceId, Surface surface, TvStreamConfig streamConfig) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mPtr == 0L) {
                return -1;
            }
            int generation = this.mStreamConfigGenerations.get(deviceId, 0);
            if (generation != streamConfig.getGeneration()) {
                return -2;
            }
            if (TvInputHal.nativeAddOrUpdateStream(this.mPtr, deviceId, streamConfig.getStreamId(), surface) == 0) {
                return 0;
            }
            return -3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeStream(int deviceId, TvStreamConfig streamConfig) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mPtr == 0L) {
                return -1;
            }
            int generation = this.mStreamConfigGenerations.get(deviceId, 0);
            if (generation != streamConfig.getGeneration()) {
                return -2;
            }
            if (TvInputHal.nativeRemoveStream(this.mPtr, deviceId, streamConfig.getStreamId()) == 0) {
                return 0;
            }
            return -3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mPtr != 0L) {
                TvInputHal.nativeClose(this.mPtr);
            }
        }
    }

    private void retrieveStreamConfigsLocked(int deviceId) {
        int generation = this.mStreamConfigGenerations.get(deviceId, 0) + 1;
        this.mStreamConfigs.put(deviceId, TvInputHal.nativeGetStreamConfigs(this.mPtr, deviceId, generation));
        this.mStreamConfigGenerations.put(deviceId, generation);
    }

    private void deviceAvailableFromNative(TvInputHardwareInfo info) {
        this.mHandler.obtainMessage(1, info).sendToTarget();
    }

    private void deviceUnavailableFromNative(int deviceId) {
        this.mHandler.obtainMessage(2, deviceId, 0).sendToTarget();
    }

    private void streamConfigsChangedFromNative(int deviceId) {
        this.mHandler.obtainMessage(3, deviceId, 0).sendToTarget();
    }

    private void firstFrameCapturedFromNative(int deviceId, int streamId) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(3, deviceId, streamId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                TvStreamConfig[] configs;
                TvInputHardwareInfo info = (TvInputHardwareInfo)msg.obj;
                Object object = this.mLock;
                synchronized (object) {
                    this.retrieveStreamConfigsLocked(info.getDeviceId());
                    configs = this.mStreamConfigs.get(info.getDeviceId());
                }
                this.mCallback.onDeviceAvailable(info, configs);
                break;
            }
            case 2: {
                int deviceId = msg.arg1;
                this.mCallback.onDeviceUnavailable(deviceId);
                break;
            }
            case 3: {
                TvStreamConfig[] configs;
                int deviceId = msg.arg1;
                Object object = this.mLock;
                synchronized (object) {
                    this.retrieveStreamConfigsLocked(deviceId);
                    configs = this.mStreamConfigs.get(deviceId);
                }
                this.mCallback.onStreamConfigurationChanged(deviceId, configs);
                break;
            }
            case 4: {
                int deviceId = msg.arg1;
                int streamId = msg.arg2;
                this.mCallback.onFirstFrameCaptured(deviceId, streamId);
                break;
            }
            default: {
                Slog.e(TAG, "Unknown event: " + msg);
                return false;
            }
        }
        return true;
    }

    public static interface Callback {
        public void onDeviceAvailable(TvInputHardwareInfo var1, TvStreamConfig[] var2);

        public void onDeviceUnavailable(int var1);

        public void onStreamConfigurationChanged(int var1, TvStreamConfig[] var2);

        public void onFirstFrameCaptured(int var1, int var2);
    }
}

