/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usage;

import android.util.ArrayMap;
import android.util.SparseArray;
import com.android.internal.util.IndentingPrintWriter;

public class AppIdleHistory {
    private SparseArray<ArrayMap<String, byte[]>> mIdleHistory = new SparseArray();
    private long lastPeriod = 0L;
    private static final long ONE_MINUTE = 60000L;
    private static final int HISTORY_SIZE = 100;
    private static final int FLAG_LAST_STATE = 2;
    private static final int FLAG_PARTIAL_ACTIVE = 1;
    private static final long PERIOD_DURATION = 3600000L;

    public void addEntry(String packageName, int userId, boolean idle, long timeNow) {
        ArrayMap<String, byte[]> userHistory = this.getUserHistory(userId);
        byte[] packageHistory = this.getPackageHistory(userHistory, packageName);
        long thisPeriod = timeNow / 3600000L;
        if (this.lastPeriod != 0L && this.lastPeriod < thisPeriod && thisPeriod - this.lastPeriod < 99L) {
            int diff = (int)(thisPeriod - this.lastPeriod);
            int NUSERS = this.mIdleHistory.size();
            for (int u = 0; u < NUSERS; ++u) {
                userHistory = this.mIdleHistory.valueAt(u);
                for (byte[] history : userHistory.values()) {
                    System.arraycopy((byte[])history, (int)diff, (byte[])history, (int)0, (int)(100 - diff));
                    for (int i = 0; i < diff; ++i) {
                        history[100 - i - 1] = (byte)(history[100 - diff - 1] & 2);
                    }
                }
            }
        }
        this.lastPeriod = thisPeriod;
        packageHistory[99] = !idle ? 3 : (byte)(packageHistory[99] & 0xFFFFFFFD);
    }

    private ArrayMap<String, byte[]> getUserHistory(int userId) {
        ArrayMap<String, Object> userHistory = this.mIdleHistory.get(userId);
        if (userHistory == null) {
            userHistory = new ArrayMap();
            this.mIdleHistory.put(userId, userHistory);
        }
        return userHistory;
    }

    private byte[] getPackageHistory(ArrayMap<String, byte[]> userHistory, String packageName) {
        byte[] packageHistory = userHistory.get(packageName);
        if (packageHistory == null) {
            packageHistory = new byte[100];
            userHistory.put(packageName, packageHistory);
        }
        return packageHistory;
    }

    public void removeUser(int userId) {
        this.mIdleHistory.remove(userId);
    }

    public boolean isIdle(int userId, String packageName) {
        ArrayMap<String, byte[]> userHistory = this.getUserHistory(userId);
        byte[] packageHistory = this.getPackageHistory(userHistory, packageName);
        return (packageHistory[99] & 2) == 0;
    }

    public void dump(IndentingPrintWriter idpw, int userId) {
        ArrayMap<String, byte[]> userHistory = this.mIdleHistory.get(userId);
        if (userHistory == null) {
            return;
        }
        int P = userHistory.size();
        for (int p = 0; p < P; ++p) {
            String packageName = userHistory.keyAt(p);
            byte[] history = userHistory.valueAt(p);
            for (int i = 0; i < 100; ++i) {
                idpw.print(history[i] == 0 ? (char)'.' : 'A');
            }
            idpw.print("  " + packageName);
            idpw.println();
        }
    }
}

