/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usage;

import android.app.usage.ConfigurationStats;
import android.app.usage.TimeSparseArray;
import android.app.usage.UsageEvents;
import android.app.usage.UsageStats;
import android.content.res.Configuration;
import android.util.ArrayMap;
import android.util.ArraySet;

class IntervalStats {
    public long beginTime;
    public long endTime;
    public long lastTimeSaved;
    public final ArrayMap<String, UsageStats> packageStats = new ArrayMap();
    public final ArrayMap<Configuration, ConfigurationStats> configurations = new ArrayMap();
    public Configuration activeConfiguration;
    public TimeSparseArray<UsageEvents.Event> events;
    private final ArraySet<String> mStringCache = new ArraySet();

    IntervalStats() {
    }

    UsageStats getOrCreateUsageStats(String packageName) {
        UsageStats usageStats = this.packageStats.get(packageName);
        if (usageStats == null) {
            usageStats = new UsageStats();
            usageStats.mPackageName = this.getCachedStringRef(packageName);
            usageStats.mBeginTimeStamp = this.beginTime;
            usageStats.mEndTimeStamp = this.endTime;
            usageStats.mBeginIdleTime = 0L;
            this.packageStats.put(usageStats.mPackageName, usageStats);
        }
        return usageStats;
    }

    ConfigurationStats getOrCreateConfigurationStats(Configuration config) {
        ConfigurationStats configStats = this.configurations.get(config);
        if (configStats == null) {
            configStats = new ConfigurationStats();
            configStats.mBeginTimeStamp = this.beginTime;
            configStats.mEndTimeStamp = this.endTime;
            configStats.mConfiguration = config;
            this.configurations.put(config, configStats);
        }
        return configStats;
    }

    UsageEvents.Event buildEvent(String packageName, String className) {
        UsageEvents.Event event = new UsageEvents.Event();
        event.mPackage = this.getCachedStringRef(packageName);
        if (className != null) {
            event.mClass = this.getCachedStringRef(className);
        }
        return event;
    }

    private boolean isStatefulEvent(int eventType) {
        switch (eventType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    void update(String packageName, long timeStamp, int eventType) {
        UsageStats usageStats = this.getOrCreateUsageStats(packageName);
        if (!(eventType != 2 && eventType != 3 || usageStats.mLastEvent != 1 && usageStats.mLastEvent != 4)) {
            usageStats.mTotalTimeInForeground += timeStamp - usageStats.mLastTimeUsed;
        }
        if (this.isStatefulEvent(eventType)) {
            usageStats.mLastEvent = eventType;
        }
        if (eventType != 6) {
            usageStats.mLastTimeUsed = timeStamp;
        }
        usageStats.mLastTimeSystemUsed = timeStamp;
        usageStats.mEndTimeStamp = timeStamp;
        if (eventType == 1) {
            ++usageStats.mLaunchCount;
        }
        this.endTime = timeStamp;
    }

    void updateBeginIdleTime(String packageName, long timeStamp) {
        UsageStats usageStats = this.getOrCreateUsageStats(packageName);
        usageStats.mBeginIdleTime = timeStamp;
    }

    void updateSystemLastUsedTime(String packageName, long lastUsedTime) {
        UsageStats usageStats = this.getOrCreateUsageStats(packageName);
        usageStats.mLastTimeSystemUsed = lastUsedTime;
    }

    void updateConfigurationStats(Configuration config, long timeStamp) {
        if (this.activeConfiguration != null) {
            ConfigurationStats activeStats = this.configurations.get(this.activeConfiguration);
            activeStats.mTotalTimeActive += timeStamp - activeStats.mLastTimeActive;
            activeStats.mLastTimeActive = timeStamp - 1L;
        }
        if (config != null) {
            ConfigurationStats configStats = this.getOrCreateConfigurationStats(config);
            configStats.mLastTimeActive = timeStamp;
            ++configStats.mActivationCount;
            this.activeConfiguration = configStats.mConfiguration;
        }
        this.endTime = timeStamp;
    }

    private String getCachedStringRef(String str) {
        int index = this.mStringCache.indexOf(str);
        if (index < 0) {
            this.mStringCache.add(str);
            return str;
        }
        return this.mStringCache.valueAt(index);
    }
}

