/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usage;

import android.app.ActivityManagerNative;
import android.app.AppGlobals;
import android.app.AppOpsManager;
import android.app.admin.DevicePolicyManager;
import android.app.usage.ConfigurationStats;
import android.app.usage.IUsageStatsManager;
import android.app.usage.UsageEvents;
import android.app.usage.UsageStats;
import android.app.usage.UsageStatsManagerInternal;
import android.appwidget.AppWidgetManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.ParceledListSlice;
import android.content.pm.UserInfo;
import android.content.res.Configuration;
import android.database.ContentObserver;
import android.hardware.display.DisplayManager;
import android.net.NetworkScoreManager;
import android.os.BatteryManager;
import android.os.Binder;
import android.os.Environment;
import android.os.Handler;
import android.os.IDeviceIdleController;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.util.ArraySet;
import android.util.AtomicFile;
import android.util.KeyValueListParser;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.util.TimeUtils;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.app.IBatteryStats;
import com.android.internal.os.BackgroundThread;
import com.android.internal.os.SomeArgs;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.SystemService;
import com.android.server.usage.AppIdleHistory;
import com.android.server.usage.UserUsageStatsService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class UsageStatsService
extends SystemService
implements UserUsageStatsService.StatsUpdatedListener {
    static final String TAG = "UsageStatsService";
    static final boolean DEBUG = false;
    static final boolean COMPRESS_TIME = false;
    private static final long TEN_SECONDS = 10000L;
    private static final long ONE_MINUTE = 60000L;
    private static final long TWENTY_MINUTES = 1200000L;
    private static final long FLUSH_INTERVAL = 1200000L;
    private static final long TIME_CHANGE_THRESHOLD_MILLIS = 2000L;
    long mAppIdleDurationMillis;
    long mCheckIdleIntervalMillis;
    long mAppIdleWallclockThresholdMillis;
    long mAppIdleParoleIntervalMillis;
    long mAppIdleParoleDurationMillis;
    static final int MSG_REPORT_EVENT = 0;
    static final int MSG_FLUSH_TO_DISK = 1;
    static final int MSG_REMOVE_USER = 2;
    static final int MSG_INFORM_LISTENERS = 3;
    static final int MSG_FORCE_IDLE_STATE = 4;
    static final int MSG_CHECK_IDLE_STATES = 5;
    static final int MSG_CHECK_PAROLE_TIMEOUT = 6;
    static final int MSG_PAROLE_END_TIMEOUT = 7;
    static final int MSG_REPORT_CONTENT_PROVIDER_USAGE = 8;
    static final int MSG_PAROLE_STATE_CHANGED = 9;
    private final Object mLock = new Object();
    Handler mHandler;
    AppOpsManager mAppOps;
    UserManager mUserManager;
    AppWidgetManager mAppWidgetManager;
    IDeviceIdleController mDeviceIdleController;
    private DisplayManager mDisplayManager;
    private PowerManager mPowerManager;
    private IBatteryStats mBatteryStats;
    private final SparseArray<UserUsageStatsService> mUserState = new SparseArray();
    private File mUsageStatsDir;
    long mRealTimeSnapshot;
    long mSystemTimeSnapshot;
    boolean mAppIdleEnabled;
    boolean mAppIdleParoled;
    private boolean mScreenOn;
    private long mLastAppIdleParoledTime;
    long mScreenOnTime;
    long mScreenOnSystemTimeSnapshot;
    @GuardedBy(value="mLock")
    private AppIdleHistory mAppIdleHistory = new AppIdleHistory();
    private ArrayList<UsageStatsManagerInternal.AppIdleStateChangeListener> mPackageAccessListeners = new ArrayList();
    private final DisplayManager.DisplayListener mDisplayListener = new DisplayManager.DisplayListener(){

        @Override
        public void onDisplayAdded(int displayId) {
        }

        @Override
        public void onDisplayRemoved(int displayId) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDisplayChanged(int displayId) {
            if (displayId == 0) {
                Object object = UsageStatsService.this.mLock;
                synchronized (object) {
                    UsageStatsService.this.updateDisplayLocked();
                }
            }
        }
    };

    public UsageStatsService(Context context) {
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStart() {
        this.mAppOps = (AppOpsManager)this.getContext().getSystemService("appops");
        this.mUserManager = (UserManager)this.getContext().getSystemService("user");
        this.mHandler = new H(BackgroundThread.get().getLooper());
        File systemDataDir = new File(Environment.getDataDirectory(), "system");
        this.mUsageStatsDir = new File(systemDataDir, "usagestats");
        this.mUsageStatsDir.mkdirs();
        if (!this.mUsageStatsDir.exists()) {
            throw new IllegalStateException("Usage stats directory does not exist: " + this.mUsageStatsDir.getAbsolutePath());
        }
        IntentFilter userActions = new IntentFilter("android.intent.action.USER_REMOVED");
        userActions.addAction("android.intent.action.USER_STARTED");
        this.getContext().registerReceiverAsUser(new UserActionsReceiver(), UserHandle.ALL, userActions, null, null);
        this.mAppIdleEnabled = this.getContext().getResources().getBoolean(17956885);
        if (this.mAppIdleEnabled) {
            IntentFilter deviceStates = new IntentFilter("android.os.action.CHARGING");
            deviceStates.addAction("android.os.action.DISCHARGING");
            deviceStates.addAction("android.os.action.DEVICE_IDLE_MODE_CHANGED");
            this.getContext().registerReceiver(new DeviceStateReceiver(), deviceStates);
        }
        Object object = this.mLock;
        synchronized (object) {
            this.cleanUpRemovedUsersLocked();
        }
        this.mRealTimeSnapshot = SystemClock.elapsedRealtime();
        this.mSystemTimeSnapshot = System.currentTimeMillis();
        this.publishLocalService(UsageStatsManagerInternal.class, new LocalService());
        this.publishBinderService("usagestats", new BinderService());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBootPhase(int phase) {
        if (phase == 500) {
            SettingsObserver settingsObserver = new SettingsObserver(this.mHandler);
            settingsObserver.registerObserver();
            settingsObserver.updateSettings();
            this.mAppWidgetManager = this.getContext().getSystemService(AppWidgetManager.class);
            this.mDeviceIdleController = IDeviceIdleController.Stub.asInterface(ServiceManager.getService("deviceidle"));
            this.mBatteryStats = IBatteryStats.Stub.asInterface(ServiceManager.getService("batterystats"));
            this.mDisplayManager = (DisplayManager)this.getContext().getSystemService("display");
            this.mPowerManager = this.getContext().getSystemService(PowerManager.class);
            this.mScreenOnSystemTimeSnapshot = System.currentTimeMillis();
            UsageStatsService usageStatsService = this;
            synchronized (usageStatsService) {
                this.mScreenOnTime = this.readScreenOnTimeLocked();
            }
            this.mDisplayManager.registerDisplayListener(this.mDisplayListener, null);
            usageStatsService = this;
            synchronized (usageStatsService) {
                this.updateDisplayLocked();
            }
        }
        if (phase == 1000) {
            this.setAppIdleParoled(this.getContext().getSystemService(BatteryManager.class).isCharging());
        }
    }

    @Override
    public void onStatsUpdated() {
        this.mHandler.sendEmptyMessageDelayed(1, 1200000L);
    }

    private void cleanUpRemovedUsersLocked() {
        List<UserInfo> users = this.mUserManager.getUsers(true);
        if (users == null || users.size() == 0) {
            throw new IllegalStateException("There can't be no users");
        }
        ArraySet<String> toDelete = new ArraySet<String>();
        String[] fileNames = this.mUsageStatsDir.list();
        if (fileNames == null) {
            return;
        }
        toDelete.addAll(Arrays.asList(fileNames));
        int userCount = users.size();
        for (int i = 0; i < userCount; ++i) {
            UserInfo userInfo = users.get(i);
            toDelete.remove(Integer.toString(userInfo.id));
        }
        int deleteCount = toDelete.size();
        for (int i = 0; i < deleteCount; ++i) {
            UsageStatsService.deleteRecursively(new File(this.mUsageStatsDir, (String)toDelete.valueAt(i)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAppIdleParoled(boolean paroled) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mAppIdleParoled != paroled) {
                this.mAppIdleParoled = paroled;
                if (paroled) {
                    this.mLastAppIdleParoledTime = this.checkAndGetTimeLocked();
                    this.postNextParoleTimeout();
                }
                this.postParoleStateChanged();
            }
        }
    }

    private void postNextParoleTimeout() {
        this.mHandler.removeMessages(6);
        long timeLeft = this.mLastAppIdleParoledTime + this.mAppIdleParoleIntervalMillis - this.checkAndGetTimeLocked();
        if (timeLeft < 0L) {
            timeLeft = 0L;
        }
        this.mHandler.sendEmptyMessageDelayed(6, timeLeft / 10L);
    }

    private void postParoleEndTimeout() {
        this.mHandler.removeMessages(7);
        this.mHandler.sendEmptyMessageDelayed(7, this.mAppIdleParoleDurationMillis);
    }

    private void postParoleStateChanged() {
        this.mHandler.removeMessages(9);
        this.mHandler.sendEmptyMessage(9);
    }

    void postCheckIdleStates(int userId) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(5, userId, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkIdleStates(int checkUserId) {
        int[] userIds;
        if (!this.mAppIdleEnabled) {
            return;
        }
        try {
            userIds = checkUserId == -1 ? ActivityManagerNative.getDefault().getRunningUserIds() : new int[]{checkUserId};
        }
        catch (RemoteException re) {
            return;
        }
        for (int i = 0; i < userIds.length; ++i) {
            int userId = userIds[i];
            List<PackageInfo> packages = this.getContext().getPackageManager().getInstalledPackages(8704, userId);
            Object object = this.mLock;
            synchronized (object) {
                long timeNow = this.checkAndGetTimeLocked();
                long screenOnTime = this.getScreenOnTimeLocked(timeNow);
                UserUsageStatsService service = this.getUserDataAndInitializeIfNeededLocked(userId, timeNow);
                int packageCount = packages.size();
                for (int p = 0; p < packageCount; ++p) {
                    String packageName = packages.get((int)p).packageName;
                    boolean isIdle = this.isAppIdleFiltered(packageName, userId, service, timeNow, screenOnTime);
                    this.mHandler.sendMessage(this.mHandler.obtainMessage(3, userId, isIdle ? 1 : 0, packageName));
                    this.mAppIdleHistory.addEntry(packageName, userId, isIdle, timeNow);
                }
                continue;
            }
        }
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(5, checkUserId, 0), this.mCheckIdleIntervalMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkParoleTimeout() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mAppIdleParoled) {
                long timeSinceLastParole = this.checkAndGetTimeLocked() - this.mLastAppIdleParoledTime;
                if (timeSinceLastParole > this.mAppIdleParoleIntervalMillis) {
                    this.setAppIdleParoled(true);
                    this.postParoleEndTimeout();
                } else {
                    this.postNextParoleTimeout();
                }
            }
        }
    }

    private void notifyBatteryStats(String packageName, int userId, boolean idle) {
        try {
            int uid = AppGlobals.getPackageManager().getPackageUid(packageName, userId);
            if (idle) {
                this.mBatteryStats.noteEvent(15, packageName, uid);
            } else {
                this.mBatteryStats.noteEvent(16, packageName, uid);
            }
        }
        catch (RemoteException re) {
            // empty catch block
        }
    }

    void updateDisplayLocked() {
        boolean screenOn;
        boolean bl = screenOn = this.mDisplayManager.getDisplay(0).getState() == 2;
        if (screenOn == this.mScreenOn) {
            return;
        }
        this.mScreenOn = screenOn;
        long now = System.currentTimeMillis();
        if (this.mScreenOn) {
            this.mScreenOnSystemTimeSnapshot = now;
        } else {
            this.mScreenOnTime += now - this.mScreenOnSystemTimeSnapshot;
            this.writeScreenOnTimeLocked(this.mScreenOnTime);
        }
    }

    private long getScreenOnTimeLocked(long now) {
        if (this.mScreenOn) {
            return now - this.mScreenOnSystemTimeSnapshot + this.mScreenOnTime;
        }
        return this.mScreenOnTime;
    }

    private File getScreenOnTimeFile() {
        return new File(this.mUsageStatsDir, "0/screen_on_time");
    }

    private long readScreenOnTimeLocked() {
        long screenOnTime = 0L;
        File screenOnTimeFile = this.getScreenOnTimeFile();
        if (screenOnTimeFile.exists()) {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(screenOnTimeFile));
                screenOnTime = Long.parseLong(reader.readLine());
                reader.close();
            }
            catch (IOException | NumberFormatException e) {}
        } else {
            this.writeScreenOnTimeLocked(screenOnTime);
        }
        return screenOnTime;
    }

    private void writeScreenOnTimeLocked(long screenOnTime) {
        AtomicFile screenOnTimeFile = new AtomicFile(this.getScreenOnTimeFile());
        FileOutputStream fos = null;
        try {
            fos = screenOnTimeFile.startWrite();
            fos.write(Long.toString(screenOnTime).getBytes());
            screenOnTimeFile.finishWrite(fos);
        }
        catch (IOException ioe) {
            screenOnTimeFile.failWrite(fos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onDeviceIdleModeChanged() {
        boolean deviceIdle = this.mPowerManager.isDeviceIdleMode();
        Object object = this.mLock;
        synchronized (object) {
            long timeSinceLastParole = this.checkAndGetTimeLocked() - this.mLastAppIdleParoledTime;
            if (!deviceIdle && timeSinceLastParole >= this.mAppIdleParoleIntervalMillis) {
                this.postNextParoleTimeout();
                this.setAppIdleParoled(true);
            } else if (deviceIdle) {
                this.setAppIdleParoled(false);
            }
        }
    }

    private static void deleteRecursively(File f) {
        File[] files = f.listFiles();
        if (files != null) {
            for (File subFile : files) {
                UsageStatsService.deleteRecursively(subFile);
            }
        }
        if (!f.delete()) {
            Slog.e(TAG, "Failed to delete " + f);
        }
    }

    private UserUsageStatsService getUserDataAndInitializeIfNeededLocked(int userId, long currentTimeMillis) {
        UserUsageStatsService service = this.mUserState.get(userId);
        if (service == null) {
            service = new UserUsageStatsService(this.getContext(), userId, new File(this.mUsageStatsDir, Integer.toString(userId)), this);
            service.init(currentTimeMillis, this.getScreenOnTimeLocked(currentTimeMillis));
            this.mUserState.put(userId, service);
        }
        return service;
    }

    private long checkAndGetTimeLocked() {
        long actualSystemTime = System.currentTimeMillis();
        long actualRealtime = SystemClock.elapsedRealtime();
        long expectedSystemTime = actualRealtime - this.mRealTimeSnapshot + this.mSystemTimeSnapshot;
        boolean resetBeginIdleTime = false;
        if (Math.abs(actualSystemTime - expectedSystemTime) > 2000L) {
            if (Math.abs(actualSystemTime - expectedSystemTime) > this.mAppIdleDurationMillis) {
                this.mScreenOnSystemTimeSnapshot = actualSystemTime;
                this.mScreenOnTime = 0L;
                resetBeginIdleTime = true;
            }
            int userCount = this.mUserState.size();
            for (int i = 0; i < userCount; ++i) {
                UserUsageStatsService service = this.mUserState.valueAt(i);
                service.onTimeChanged(expectedSystemTime, actualSystemTime, resetBeginIdleTime);
            }
            this.mRealTimeSnapshot = actualRealtime;
            this.mSystemTimeSnapshot = actualSystemTime;
        }
        return actualSystemTime;
    }

    private void convertToSystemTimeLocked(UsageEvents.Event event) {
        event.mTimeStamp = Math.max(0L, event.mTimeStamp - this.mRealTimeSnapshot) + this.mSystemTimeSnapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        Object object = this.mLock;
        synchronized (object) {
            this.mHandler.removeMessages(0);
            this.flushToDiskLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reportEvent(UsageEvents.Event event, int userId) {
        Object object = this.mLock;
        synchronized (object) {
            long timeNow = this.checkAndGetTimeLocked();
            long screenOnTime = this.getScreenOnTimeLocked(timeNow);
            this.convertToSystemTimeLocked(event);
            UserUsageStatsService service = this.getUserDataAndInitializeIfNeededLocked(userId, timeNow);
            long beginIdleTime = service.getBeginIdleTime(event.mPackage);
            long lastUsedTime = service.getSystemLastUsedTime(event.mPackage);
            boolean previouslyIdle = this.hasPassedIdleTimeoutLocked(beginIdleTime, lastUsedTime, screenOnTime, timeNow);
            service.reportEvent(event, screenOnTime);
            if ((event.mEventType == 1 || event.mEventType == 2 || event.mEventType == 6 || event.mEventType == 7) && previouslyIdle) {
                this.mHandler.sendMessage(this.mHandler.obtainMessage(3, userId, 0, event.mPackage));
                this.notifyBatteryStats(event.mPackage, userId, false);
                this.mAppIdleHistory.addEntry(event.mPackage, userId, false, timeNow);
            }
        }
    }

    void reportContentProviderUsage(String authority, String providerPkgName, int userId) {
        String[] packages;
        for (String packageName : packages = ContentResolver.getSyncAdapterPackagesForAuthorityAsUser(authority, userId)) {
            try {
                PackageInfo pi = AppGlobals.getPackageManager().getPackageInfo(packageName, 0, userId);
                if (pi == null || pi.applicationInfo == null || !pi.applicationInfo.isSystemApp() || packageName.equals(providerPkgName)) continue;
                this.forceIdleState(packageName, userId, false);
            }
            catch (RemoteException re) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forceIdleState(String packageName, int userId, boolean idle) {
        Object object = this.mLock;
        synchronized (object) {
            long timeNow = this.checkAndGetTimeLocked();
            long screenOnTime = this.getScreenOnTimeLocked(timeNow);
            long deviceUsageTime = screenOnTime - (idle ? this.mAppIdleDurationMillis : 0L) - 5000L;
            UserUsageStatsService service = this.getUserDataAndInitializeIfNeededLocked(userId, timeNow);
            long beginIdleTime = service.getBeginIdleTime(packageName);
            long lastUsedTime = service.getSystemLastUsedTime(packageName);
            boolean previouslyIdle = this.hasPassedIdleTimeoutLocked(beginIdleTime, lastUsedTime, screenOnTime, timeNow);
            service.setBeginIdleTime(packageName, deviceUsageTime);
            service.setSystemLastUsedTime(packageName, timeNow - (idle ? this.mAppIdleWallclockThresholdMillis : 0L) - 5000L);
            if (previouslyIdle != idle) {
                this.mHandler.sendMessage(this.mHandler.obtainMessage(3, userId, idle ? 1 : 0, packageName));
                if (!idle) {
                    this.notifyBatteryStats(packageName, userId, idle);
                }
                this.mAppIdleHistory.addEntry(packageName, userId, idle, timeNow);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushToDisk() {
        Object object = this.mLock;
        synchronized (object) {
            this.flushToDiskLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeUser(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            Slog.i(TAG, "Removing user " + userId + " and all data.");
            this.mUserState.remove(userId);
            this.cleanUpRemovedUsersLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<UsageStats> queryUsageStats(int userId, int bucketType, long beginTime, long endTime) {
        Object object = this.mLock;
        synchronized (object) {
            long timeNow = this.checkAndGetTimeLocked();
            if (!UsageStatsService.validRange(timeNow, beginTime, endTime)) {
                return null;
            }
            UserUsageStatsService service = this.getUserDataAndInitializeIfNeededLocked(userId, timeNow);
            return service.queryUsageStats(bucketType, beginTime, endTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ConfigurationStats> queryConfigurationStats(int userId, int bucketType, long beginTime, long endTime) {
        Object object = this.mLock;
        synchronized (object) {
            long timeNow = this.checkAndGetTimeLocked();
            if (!UsageStatsService.validRange(timeNow, beginTime, endTime)) {
                return null;
            }
            UserUsageStatsService service = this.getUserDataAndInitializeIfNeededLocked(userId, timeNow);
            return service.queryConfigurationStats(bucketType, beginTime, endTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UsageEvents queryEvents(int userId, long beginTime, long endTime) {
        Object object = this.mLock;
        synchronized (object) {
            long timeNow = this.checkAndGetTimeLocked();
            if (!UsageStatsService.validRange(timeNow, beginTime, endTime)) {
                return null;
            }
            UserUsageStatsService service = this.getUserDataAndInitializeIfNeededLocked(userId, timeNow);
            return service.queryEvents(beginTime, endTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAppIdleUnfiltered(String packageName, UserUsageStatsService userService, long timeNow, long screenOnTime) {
        Object object = this.mLock;
        synchronized (object) {
            long beginIdleTime = userService.getBeginIdleTime(packageName);
            long lastUsedTime = userService.getSystemLastUsedTime(packageName);
            return this.hasPassedIdleTimeoutLocked(beginIdleTime, lastUsedTime, screenOnTime, timeNow);
        }
    }

    boolean hasPassedIdleTimeoutLocked(long beginIdleTime, long lastUsedTime, long screenOnTime, long currentTime) {
        return beginIdleTime <= screenOnTime - this.mAppIdleDurationMillis && lastUsedTime <= currentTime - this.mAppIdleWallclockThresholdMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addListener(UsageStatsManagerInternal.AppIdleStateChangeListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mPackageAccessListeners.contains(listener)) {
                this.mPackageAccessListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeListener(UsageStatsManagerInternal.AppIdleStateChangeListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mPackageAccessListeners.remove(listener);
        }
    }

    boolean isAppIdleFilteredOrParoled(String packageName, int userId, long timeNow) {
        if (this.mAppIdleParoled) {
            return false;
        }
        return this.isAppIdleFiltered(packageName, userId, timeNow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isAppIdleFiltered(String packageName, int userId, long timeNow) {
        long screenOnTime;
        UserUsageStatsService userService;
        Object object = this.mLock;
        synchronized (object) {
            if (timeNow == -1L) {
                timeNow = this.checkAndGetTimeLocked();
            }
            userService = this.getUserDataAndInitializeIfNeededLocked(userId, timeNow);
            screenOnTime = this.getScreenOnTimeLocked(timeNow);
        }
        return this.isAppIdleFiltered(packageName, userId, userService, timeNow, screenOnTime);
    }

    private boolean isAppIdleFiltered(String packageName, int userId, UserUsageStatsService userService, long timeNow, long screenOnTime) {
        if (packageName == null) {
            return false;
        }
        if (!this.mAppIdleEnabled) {
            return false;
        }
        if (packageName.equals("android")) {
            return false;
        }
        try {
            if (this.mDeviceIdleController.isPowerSaveWhitelistExceptIdleApp(packageName)) {
                return false;
            }
        }
        catch (RemoteException re) {
            // empty catch block
        }
        if (this.isActiveDeviceAdmin(packageName, userId)) {
            return false;
        }
        if (this.isCarrierApp(packageName)) {
            return false;
        }
        if (this.isActiveNetworkScorer(packageName)) {
            return false;
        }
        if (this.mAppWidgetManager != null && this.mAppWidgetManager.isBoundWidgetPackage(packageName, userId)) {
            return false;
        }
        return this.isAppIdleUnfiltered(packageName, userService, timeNow, screenOnTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int[] getIdleUidsForUser(int userId) {
        List apps;
        long screenOnTime;
        UserUsageStatsService userService;
        long timeNow;
        if (!this.mAppIdleEnabled) {
            return new int[0];
        }
        Object object = this.mLock;
        synchronized (object) {
            timeNow = this.checkAndGetTimeLocked();
            userService = this.getUserDataAndInitializeIfNeededLocked(userId, timeNow);
            screenOnTime = this.getScreenOnTimeLocked(timeNow);
        }
        try {
            ParceledListSlice slice = AppGlobals.getPackageManager().getInstalledApplications(0, userId);
            if (slice == null) {
                return new int[0];
            }
            apps = slice.getList();
        }
        catch (RemoteException e) {
            return new int[0];
        }
        SparseIntArray uidStates = new SparseIntArray();
        for (int i = apps.size() - 1; i >= 0; --i) {
            ApplicationInfo ai = (ApplicationInfo)apps.get(i);
            boolean idle = this.isAppIdleFiltered(ai.packageName, userId, userService, timeNow, screenOnTime);
            int index = uidStates.indexOfKey(ai.uid);
            if (index < 0) {
                uidStates.put(ai.uid, 1 + (idle ? 65536 : 0));
                continue;
            }
            int value = uidStates.valueAt(index);
            uidStates.setValueAt(index, value + 1 + (idle ? 65536 : 0));
        }
        int numIdle = 0;
        for (int i = uidStates.size() - 1; i >= 0; --i) {
            int value = uidStates.valueAt(i);
            if ((value & Short.MAX_VALUE) != value >> 16) continue;
            ++numIdle;
        }
        int[] res = new int[numIdle];
        numIdle = 0;
        for (int i = uidStates.size() - 1; i >= 0; --i) {
            int value = uidStates.valueAt(i);
            if ((value & Short.MAX_VALUE) != value >> 16) continue;
            res[numIdle] = uidStates.keyAt(i);
            ++numIdle;
        }
        return res;
    }

    void setAppIdle(String packageName, boolean idle, int userId) {
        if (packageName == null) {
            return;
        }
        this.mHandler.obtainMessage(4, userId, idle ? 1 : 0, packageName).sendToTarget();
    }

    private boolean isActiveDeviceAdmin(String packageName, int userId) {
        DevicePolicyManager dpm = this.getContext().getSystemService(DevicePolicyManager.class);
        if (dpm == null) {
            return false;
        }
        List<ComponentName> components = dpm.getActiveAdminsAsUser(userId);
        if (components == null) {
            return false;
        }
        int size = components.size();
        for (int i = 0; i < size; ++i) {
            if (!components.get(i).getPackageName().equals(packageName)) continue;
            return true;
        }
        return false;
    }

    private boolean isCarrierApp(String packageName) {
        TelephonyManager telephonyManager = this.getContext().getSystemService(TelephonyManager.class);
        return telephonyManager.checkCarrierPrivilegesForPackageAnyPhone(packageName) == 1;
    }

    private boolean isActiveNetworkScorer(String packageName) {
        NetworkScoreManager nsm = (NetworkScoreManager)this.getContext().getSystemService("network_score");
        return packageName != null && packageName.equals(nsm.getActiveScorerPackage());
    }

    void informListeners(String packageName, int userId, boolean isIdle) {
        for (UsageStatsManagerInternal.AppIdleStateChangeListener listener : this.mPackageAccessListeners) {
            listener.onAppIdleStateChanged(packageName, userId, isIdle);
        }
    }

    void informParoleStateChanged() {
        for (UsageStatsManagerInternal.AppIdleStateChangeListener listener : this.mPackageAccessListeners) {
            listener.onParoleStateChanged(this.mAppIdleParoled);
        }
    }

    private static boolean validRange(long currentTime, long beginTime, long endTime) {
        return beginTime <= currentTime && beginTime < endTime;
    }

    private void flushToDiskLocked() {
        int userCount = this.mUserState.size();
        for (int i = 0; i < userCount; ++i) {
            UserUsageStatsService service = this.mUserState.valueAt(i);
            service.persistActiveStats();
        }
        this.mHandler.removeMessages(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dump(String[] args, PrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            long screenOnTime = this.getScreenOnTimeLocked(this.checkAndGetTimeLocked());
            IndentingPrintWriter idpw = new IndentingPrintWriter((Writer)pw, "  ");
            ArraySet<String> argSet = new ArraySet<String>();
            argSet.addAll(Arrays.asList(args));
            int userCount = this.mUserState.size();
            for (int i = 0; i < userCount; ++i) {
                idpw.printPair("user", this.mUserState.keyAt(i));
                idpw.println();
                idpw.increaseIndent();
                if (argSet.contains("--checkin")) {
                    this.mUserState.valueAt(i).checkin(idpw, screenOnTime);
                } else {
                    this.mUserState.valueAt(i).dump(idpw, screenOnTime);
                    idpw.println();
                    if (args.length > 0 && "history".equals(args[0])) {
                        this.mAppIdleHistory.dump(idpw, this.mUserState.keyAt(i));
                    }
                }
                idpw.decreaseIndent();
            }
            pw.println("Screen On Timebase:" + this.mScreenOnTime);
            pw.println();
            pw.println("Settings:");
            pw.print("  mAppIdleDurationMillis=");
            TimeUtils.formatDuration(this.mAppIdleDurationMillis, pw);
            pw.println();
            pw.print("  mAppIdleWallclockThresholdMillis=");
            TimeUtils.formatDuration(this.mAppIdleWallclockThresholdMillis, pw);
            pw.println();
            pw.print("  mCheckIdleIntervalMillis=");
            TimeUtils.formatDuration(this.mCheckIdleIntervalMillis, pw);
            pw.println();
            pw.print("  mAppIdleParoleIntervalMillis=");
            TimeUtils.formatDuration(this.mAppIdleParoleIntervalMillis, pw);
            pw.println();
            pw.print("  mAppIdleParoleDurationMillis=");
            TimeUtils.formatDuration(this.mAppIdleParoleDurationMillis, pw);
            pw.println();
            pw.println();
            pw.print("mAppIdleEnabled=");
            pw.print(this.mAppIdleEnabled);
            pw.print(" mAppIdleParoled=");
            pw.print(this.mAppIdleParoled);
            pw.print(" mScreenOn=");
            pw.println(this.mScreenOn);
            pw.print("mLastAppIdleParoledTime=");
            TimeUtils.formatDuration(this.mLastAppIdleParoledTime, pw);
            pw.println();
            pw.print("mScreenOnTime=");
            TimeUtils.formatDuration(this.mScreenOnTime, pw);
            pw.println();
            pw.print("mScreenOnSystemTimeSnapshot=");
            TimeUtils.formatDuration(this.mScreenOnSystemTimeSnapshot, pw);
            pw.println();
        }
    }

    private final class LocalService
    extends UsageStatsManagerInternal {
        private LocalService() {
        }

        @Override
        public void reportEvent(ComponentName component, int userId, int eventType) {
            if (component == null) {
                Slog.w(UsageStatsService.TAG, "Event reported without a component name");
                return;
            }
            UsageEvents.Event event = new UsageEvents.Event();
            event.mPackage = component.getPackageName();
            event.mClass = component.getClassName();
            event.mTimeStamp = SystemClock.elapsedRealtime();
            event.mEventType = eventType;
            UsageStatsService.this.mHandler.obtainMessage(0, userId, 0, event).sendToTarget();
        }

        @Override
        public void reportEvent(String packageName, int userId, int eventType) {
            if (packageName == null) {
                Slog.w(UsageStatsService.TAG, "Event reported without a package name");
                return;
            }
            UsageEvents.Event event = new UsageEvents.Event();
            event.mPackage = packageName;
            event.mTimeStamp = SystemClock.elapsedRealtime();
            event.mEventType = eventType;
            UsageStatsService.this.mHandler.obtainMessage(0, userId, 0, event).sendToTarget();
        }

        @Override
        public void reportConfigurationChange(Configuration config, int userId) {
            if (config == null) {
                Slog.w(UsageStatsService.TAG, "Configuration event reported with a null config");
                return;
            }
            UsageEvents.Event event = new UsageEvents.Event();
            event.mPackage = "android";
            event.mTimeStamp = SystemClock.elapsedRealtime();
            event.mEventType = 5;
            event.mConfiguration = new Configuration(config);
            UsageStatsService.this.mHandler.obtainMessage(0, userId, 0, event).sendToTarget();
        }

        @Override
        public void reportContentProviderUsage(String name, String packageName, int userId) {
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = name;
            args.arg2 = packageName;
            args.arg3 = userId;
            UsageStatsService.this.mHandler.obtainMessage(8, args).sendToTarget();
        }

        @Override
        public boolean isAppIdle(String packageName, int userId) {
            return UsageStatsService.this.isAppIdleFiltered(packageName, userId, -1L);
        }

        @Override
        public int[] getIdleUidsForUser(int userId) {
            return UsageStatsService.this.getIdleUidsForUser(userId);
        }

        @Override
        public boolean isAppIdleParoleOn() {
            return UsageStatsService.this.mAppIdleParoled;
        }

        @Override
        public void prepareShutdown() {
            UsageStatsService.this.shutdown();
        }

        @Override
        public void addAppIdleStateChangeListener(UsageStatsManagerInternal.AppIdleStateChangeListener listener) {
            UsageStatsService.this.addListener(listener);
            listener.onParoleStateChanged(this.isAppIdleParoleOn());
        }

        @Override
        public void removeAppIdleStateChangeListener(UsageStatsManagerInternal.AppIdleStateChangeListener listener) {
            UsageStatsService.this.removeListener(listener);
        }
    }

    private final class BinderService
    extends IUsageStatsManager.Stub {
        private BinderService() {
        }

        private boolean hasPermission(String callingPackage) {
            int callingUid = Binder.getCallingUid();
            if (callingUid == 1000) {
                return true;
            }
            int mode = UsageStatsService.this.mAppOps.checkOp(43, callingUid, callingPackage);
            if (mode == 3) {
                return UsageStatsService.this.getContext().checkCallingPermission("android.permission.PACKAGE_USAGE_STATS") == 0;
            }
            return mode == 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ParceledListSlice<UsageStats> queryUsageStats(int bucketType, long beginTime, long endTime, String callingPackage) {
            if (!this.hasPermission(callingPackage)) {
                return null;
            }
            int userId = UserHandle.getCallingUserId();
            long token = Binder.clearCallingIdentity();
            try {
                List<UsageStats> results = UsageStatsService.this.queryUsageStats(userId, bucketType, beginTime, endTime);
                if (results != null) {
                    ParceledListSlice<UsageStats> parceledListSlice = new ParceledListSlice<UsageStats>(results);
                    return parceledListSlice;
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ParceledListSlice<ConfigurationStats> queryConfigurationStats(int bucketType, long beginTime, long endTime, String callingPackage) throws RemoteException {
            if (!this.hasPermission(callingPackage)) {
                return null;
            }
            int userId = UserHandle.getCallingUserId();
            long token = Binder.clearCallingIdentity();
            try {
                List<ConfigurationStats> results = UsageStatsService.this.queryConfigurationStats(userId, bucketType, beginTime, endTime);
                if (results != null) {
                    ParceledListSlice<ConfigurationStats> parceledListSlice = new ParceledListSlice<ConfigurationStats>(results);
                    return parceledListSlice;
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public UsageEvents queryEvents(long beginTime, long endTime, String callingPackage) {
            if (!this.hasPermission(callingPackage)) {
                return null;
            }
            int userId = UserHandle.getCallingUserId();
            long token = Binder.clearCallingIdentity();
            try {
                UsageEvents usageEvents = UsageStatsService.this.queryEvents(userId, beginTime, endTime);
                return usageEvents;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isAppInactive(String packageName, int userId) {
            try {
                userId = ActivityManagerNative.getDefault().handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, false, true, "isAppInactive", null);
            }
            catch (RemoteException re) {
                return false;
            }
            long token = Binder.clearCallingIdentity();
            try {
                boolean bl = UsageStatsService.this.isAppIdleFilteredOrParoled(packageName, userId, -1L);
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setAppInactive(String packageName, boolean idle, int userId) {
            int callingUid = Binder.getCallingUid();
            try {
                userId = ActivityManagerNative.getDefault().handleIncomingUser(Binder.getCallingPid(), callingUid, userId, false, true, "setAppIdle", null);
            }
            catch (RemoteException re) {
                return;
            }
            UsageStatsService.this.getContext().enforceCallingPermission("android.permission.CHANGE_APP_IDLE_STATE", "No permission to change app idle state");
            long token = Binder.clearCallingIdentity();
            try {
                PackageInfo pi = AppGlobals.getPackageManager().getPackageInfo(packageName, 0, userId);
                if (pi == null) {
                    return;
                }
                UsageStatsService.this.setAppIdle(packageName, idle, userId);
            }
            catch (RemoteException re) {
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        @Override
        public void whitelistAppTemporarily(String packageName, long duration, int userId) throws RemoteException {
            StringBuilder reason = new StringBuilder(32);
            reason.append("from:");
            UserHandle.formatUid(reason, Binder.getCallingUid());
            UsageStatsService.this.mDeviceIdleController.addPowerSaveTempWhitelistApp(packageName, duration, userId, reason.toString());
        }

        @Override
        protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (UsageStatsService.this.getContext().checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
                pw.println("Permission Denial: can't dump UsageStats from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " without permission " + "android.permission.DUMP");
                return;
            }
            UsageStatsService.this.dump(args, pw);
        }
    }

    private class SettingsObserver
    extends ContentObserver {
        private static final String KEY_IDLE_DURATION = "idle_duration";
        private static final String KEY_WALLCLOCK_THRESHOLD = "wallclock_threshold";
        private static final String KEY_PAROLE_INTERVAL = "parole_interval";
        private static final String KEY_PAROLE_DURATION = "parole_duration";
        private final KeyValueListParser mParser;

        SettingsObserver(Handler handler) {
            super(handler);
            this.mParser = new KeyValueListParser(',');
        }

        void registerObserver() {
            UsageStatsService.this.getContext().getContentResolver().registerContentObserver(Settings.Global.getUriFor("app_idle_constants"), false, this);
        }

        @Override
        public void onChange(boolean selfChange) {
            this.updateSettings();
            UsageStatsService.this.postCheckIdleStates(-1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateSettings() {
            Object object = UsageStatsService.this.mLock;
            synchronized (object) {
                try {
                    this.mParser.setString(Settings.Global.getString(UsageStatsService.this.getContext().getContentResolver(), "app_idle_constants"));
                }
                catch (IllegalArgumentException e) {
                    Slog.e(UsageStatsService.TAG, "Bad value for app idle settings: " + e.getMessage());
                }
                UsageStatsService.this.mAppIdleDurationMillis = this.mParser.getLong(KEY_IDLE_DURATION, 43200000L);
                UsageStatsService.this.mAppIdleWallclockThresholdMillis = this.mParser.getLong(KEY_WALLCLOCK_THRESHOLD, 172800000L);
                UsageStatsService.this.mCheckIdleIntervalMillis = Math.min(UsageStatsService.this.mAppIdleDurationMillis / 4L, 28800000L);
                UsageStatsService.this.mAppIdleParoleIntervalMillis = this.mParser.getLong(KEY_PAROLE_INTERVAL, 86400000L);
                UsageStatsService.this.mAppIdleParoleDurationMillis = this.mParser.getLong(KEY_PAROLE_DURATION, 600000L);
            }
        }
    }

    class H
    extends Handler {
        public H(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    UsageStatsService.this.reportEvent((UsageEvents.Event)msg.obj, msg.arg1);
                    break;
                }
                case 1: {
                    UsageStatsService.this.flushToDisk();
                    break;
                }
                case 2: {
                    UsageStatsService.this.removeUser(msg.arg1);
                    break;
                }
                case 3: {
                    UsageStatsService.this.informListeners((String)msg.obj, msg.arg1, msg.arg2 == 1);
                    break;
                }
                case 4: {
                    UsageStatsService.this.forceIdleState((String)msg.obj, msg.arg1, msg.arg2 == 1);
                    break;
                }
                case 5: {
                    UsageStatsService.this.checkIdleStates(msg.arg1);
                    break;
                }
                case 6: {
                    UsageStatsService.this.checkParoleTimeout();
                    break;
                }
                case 7: {
                    UsageStatsService.this.setAppIdleParoled(false);
                    break;
                }
                case 8: {
                    SomeArgs args = (SomeArgs)msg.obj;
                    UsageStatsService.this.reportContentProviderUsage((String)args.arg1, (String)args.arg2, (Integer)args.arg3);
                    args.recycle();
                    break;
                }
                case 9: {
                    UsageStatsService.this.informParoleStateChanged();
                    break;
                }
                default: {
                    super.handleMessage(msg);
                }
            }
        }
    }

    private class DeviceStateReceiver
    extends BroadcastReceiver {
        private DeviceStateReceiver() {
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.os.action.CHARGING".equals(action) || "android.os.action.DISCHARGING".equals(action)) {
                UsageStatsService.this.setAppIdleParoled("android.os.action.CHARGING".equals(action));
            } else if ("android.os.action.DEVICE_IDLE_MODE_CHANGED".equals(action)) {
                UsageStatsService.this.onDeviceIdleModeChanged();
            }
        }
    }

    private class UserActionsReceiver
    extends BroadcastReceiver {
        private UserActionsReceiver() {
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            int userId = intent.getIntExtra("android.intent.extra.user_handle", -1);
            if ("android.intent.action.USER_REMOVED".equals(intent.getAction())) {
                if (userId >= 0) {
                    UsageStatsService.this.mHandler.obtainMessage(2, userId, 0).sendToTarget();
                }
            } else if ("android.intent.action.USER_STARTED".equals(intent.getAction()) && userId >= 0) {
                UsageStatsService.this.postCheckIdleStates(userId);
            }
        }
    }
}

