/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.voiceinteraction;

import android.app.ActivityManagerNative;
import android.app.AppOpsManager;
import android.app.IActivityManager;
import android.app.assist.AssistContent;
import android.app.assist.AssistStructure;
import android.content.ClipData;
import android.content.ComponentName;
import android.content.ContentProvider;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.provider.Settings;
import android.service.voice.IVoiceInteractionSession;
import android.service.voice.IVoiceInteractionSessionService;
import android.util.Slog;
import android.view.IWindowManager;
import com.android.internal.app.IAssistScreenshotReceiver;
import com.android.internal.app.IVoiceInteractionSessionShowCallback;
import com.android.internal.app.IVoiceInteractor;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.os.IResultReceiver;
import com.android.server.LocalServices;
import com.android.server.statusbar.StatusBarManagerInternal;
import java.io.PrintWriter;
import java.util.ArrayList;

final class VoiceInteractionSessionConnection
implements ServiceConnection {
    static final String TAG = "VoiceInteractionServiceManager";
    final IBinder mToken = new Binder();
    final Object mLock;
    final ComponentName mSessionComponentName;
    final Intent mBindIntent;
    final int mUser;
    final Context mContext;
    final Callback mCallback;
    final int mCallingUid;
    final Handler mHandler;
    final IActivityManager mAm;
    final IWindowManager mIWindowManager;
    final AppOpsManager mAppOps;
    final IBinder mPermissionOwner;
    boolean mShown;
    Bundle mShowArgs;
    int mShowFlags;
    boolean mBound;
    boolean mFullyBound;
    boolean mCanceled;
    IVoiceInteractionSessionService mService;
    IVoiceInteractionSession mSession;
    IVoiceInteractor mInteractor;
    boolean mHaveAssistData;
    Bundle mAssistData;
    boolean mHaveScreenshot;
    Bitmap mScreenshot;
    ArrayList<IVoiceInteractionSessionShowCallback> mPendingShowCallbacks = new ArrayList();
    IVoiceInteractionSessionShowCallback mShowCallback = new IVoiceInteractionSessionShowCallback.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFailed() throws RemoteException {
            Object object = VoiceInteractionSessionConnection.this.mLock;
            synchronized (object) {
                VoiceInteractionSessionConnection.this.notifyPendingShowCallbacksFailedLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onShown() throws RemoteException {
            Object object = VoiceInteractionSessionConnection.this.mLock;
            synchronized (object) {
                VoiceInteractionSessionConnection.this.notifyPendingShowCallbacksShownLocked();
            }
        }
    };
    final ServiceConnection mFullConnection = new ServiceConnection(){

        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
        }
    };
    final IResultReceiver mAssistReceiver = new IResultReceiver.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void send(int resultCode, Bundle resultData) throws RemoteException {
            Object object = VoiceInteractionSessionConnection.this.mLock;
            synchronized (object) {
                if (VoiceInteractionSessionConnection.this.mShown) {
                    VoiceInteractionSessionConnection.this.mHaveAssistData = true;
                    VoiceInteractionSessionConnection.this.mAssistData = resultData;
                    VoiceInteractionSessionConnection.this.deliverSessionDataLocked();
                }
            }
        }
    };
    final IAssistScreenshotReceiver mScreenshotReceiver = new IAssistScreenshotReceiver.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void send(Bitmap screenshot) throws RemoteException {
            Object object = VoiceInteractionSessionConnection.this.mLock;
            synchronized (object) {
                if (VoiceInteractionSessionConnection.this.mShown) {
                    VoiceInteractionSessionConnection.this.mHaveScreenshot = true;
                    VoiceInteractionSessionConnection.this.mScreenshot = screenshot;
                    VoiceInteractionSessionConnection.this.deliverSessionDataLocked();
                }
            }
        }
    };
    private Runnable mShowAssistDisclosureRunnable = new Runnable(){

        @Override
        public void run() {
            StatusBarManagerInternal statusBarInternal = LocalServices.getService(StatusBarManagerInternal.class);
            if (statusBarInternal != null) {
                statusBarInternal.showAssistDisclosure();
            }
        }
    };

    public VoiceInteractionSessionConnection(Object lock, ComponentName component, int user, Context context, Callback callback, int callingUid, Handler handler) {
        this.mLock = lock;
        this.mSessionComponentName = component;
        this.mUser = user;
        this.mContext = context;
        this.mCallback = callback;
        this.mCallingUid = callingUid;
        this.mHandler = handler;
        this.mAm = ActivityManagerNative.getDefault();
        this.mIWindowManager = IWindowManager.Stub.asInterface(ServiceManager.getService("window"));
        this.mAppOps = context.getSystemService(AppOpsManager.class);
        IBinder permOwner = null;
        try {
            permOwner = this.mAm.newUriPermissionOwner("voicesession:" + component.flattenToShortString());
        }
        catch (RemoteException e) {
            Slog.w("voicesession", "AM dead", e);
        }
        this.mPermissionOwner = permOwner;
        this.mBindIntent = new Intent("android.service.voice.VoiceInteractionService");
        this.mBindIntent.setComponent(this.mSessionComponentName);
        this.mBound = this.mContext.bindServiceAsUser(this.mBindIntent, this, 49, new UserHandle(this.mUser));
        if (this.mBound) {
            try {
                this.mIWindowManager.addWindowToken(this.mToken, 2031);
            }
            catch (RemoteException e) {
                Slog.w(TAG, "Failed adding window token", e);
            }
        } else {
            Slog.w(TAG, "Failed binding to voice interaction session service " + this.mSessionComponentName);
        }
    }

    public int getUserDisabledShowContextLocked() {
        int flags = 0;
        if (Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "assist_structure_enabled", 1, this.mUser) == 0) {
            flags |= 1;
        }
        if (Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "assist_screenshot_enabled", 1, this.mUser) == 0) {
            flags |= 2;
        }
        return flags;
    }

    public boolean showLocked(Bundle args, int flags, int disabledContext, IVoiceInteractionSessionShowCallback showCallback, IBinder activityToken) {
        if (this.mBound) {
            boolean needDisclosure;
            boolean screenshotEnabled;
            block26: {
                if (!this.mFullyBound) {
                    this.mFullyBound = this.mContext.bindServiceAsUser(this.mBindIntent, this.mFullConnection, 0xC000001, new UserHandle(this.mUser));
                }
                this.mShown = true;
                boolean isAssistDataAllowed = true;
                try {
                    isAssistDataAllowed = this.mAm.isAssistDataAllowedOnCurrentActivity();
                }
                catch (RemoteException e) {
                    // empty catch block
                }
                boolean structureEnabled = isAssistDataAllowed && ((disabledContext |= this.getUserDisabledShowContextLocked()) & 1) == 0;
                screenshotEnabled = isAssistDataAllowed && structureEnabled && (disabledContext & 2) == 0;
                this.mShowArgs = args;
                this.mShowFlags = flags;
                this.mHaveAssistData = false;
                needDisclosure = false;
                if ((flags & 1) != 0) {
                    if (this.mAppOps.noteOpNoThrow(49, this.mCallingUid, this.mSessionComponentName.getPackageName()) == 0 && structureEnabled) {
                        try {
                            MetricsLogger.count(this.mContext, "assist_with_context", 1);
                            if (this.mAm.requestAssistContextExtras(1, this.mAssistReceiver, activityToken)) {
                                needDisclosure = true;
                                break block26;
                            }
                            this.mHaveAssistData = true;
                            this.mAssistData = null;
                            screenshotEnabled = false;
                        }
                        catch (RemoteException e) {}
                    } else {
                        this.mHaveAssistData = true;
                        this.mAssistData = null;
                    }
                } else {
                    this.mAssistData = null;
                }
            }
            this.mHaveScreenshot = false;
            if ((flags & 2) != 0) {
                if (this.mAppOps.noteOpNoThrow(50, this.mCallingUid, this.mSessionComponentName.getPackageName()) == 0 && screenshotEnabled) {
                    try {
                        MetricsLogger.count(this.mContext, "assist_with_screen", 1);
                        needDisclosure = true;
                        this.mIWindowManager.requestAssistScreenshot(this.mScreenshotReceiver);
                    }
                    catch (RemoteException e) {}
                } else {
                    this.mHaveScreenshot = true;
                    this.mScreenshot = null;
                }
            } else {
                this.mScreenshot = null;
            }
            if (needDisclosure) {
                this.mHandler.post(this.mShowAssistDisclosureRunnable);
            }
            if (this.mSession != null) {
                try {
                    this.mSession.show(this.mShowArgs, this.mShowFlags, showCallback);
                    this.mShowArgs = null;
                    this.mShowFlags = 0;
                }
                catch (RemoteException e) {
                    // empty catch block
                }
                this.deliverSessionDataLocked();
            } else if (showCallback != null) {
                this.mPendingShowCallbacks.add(showCallback);
            }
            return true;
        }
        if (showCallback != null) {
            try {
                showCallback.onFailed();
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void grantUriPermission(Uri uri, int mode, int srcUid, int destUid, String destPkg) {
        if (!"content".equals(uri.getScheme())) {
            return;
        }
        long ident = Binder.clearCallingIdentity();
        try {
            this.mAm.checkGrantUriPermission(srcUid, null, ContentProvider.getUriWithoutUserId(uri), mode, ContentProvider.getUserIdFromUri(uri, UserHandle.getUserId(srcUid)));
            int sourceUserId = ContentProvider.getUserIdFromUri(uri, this.mUser);
            uri = ContentProvider.getUriWithoutUserId(uri);
            this.mAm.grantUriPermissionFromOwner(this.mPermissionOwner, srcUid, destPkg, uri, 1, sourceUserId, this.mUser);
        }
        catch (RemoteException e) {
        }
        catch (SecurityException e) {
            Slog.w(TAG, "Can't propagate permission", e);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    void grantClipDataItemPermission(ClipData.Item item, int mode, int srcUid, int destUid, String destPkg) {
        Intent intent;
        if (item.getUri() != null) {
            this.grantUriPermission(item.getUri(), mode, srcUid, destUid, destPkg);
        }
        if ((intent = item.getIntent()) != null && intent.getData() != null) {
            this.grantUriPermission(intent.getData(), mode, srcUid, destUid, destPkg);
        }
    }

    void grantClipDataPermissions(ClipData data, int mode, int srcUid, int destUid, String destPkg) {
        int N = data.getItemCount();
        for (int i = 0; i < N; ++i) {
            this.grantClipDataItemPermission(data.getItemAt(i), mode, srcUid, destUid, destPkg);
        }
    }

    void deliverSessionDataLocked() {
        if (this.mSession == null) {
            return;
        }
        if (this.mHaveAssistData) {
            AssistContent content;
            AssistStructure structure;
            Bundle assistData;
            if (this.mAssistData != null) {
                assistData = this.mAssistData.getBundle("data");
                structure = (AssistStructure)this.mAssistData.getParcelable("structure");
                content = (AssistContent)this.mAssistData.getParcelable("content");
                int uid = this.mAssistData.getInt("android.intent.extra.ASSIST_UID", -1);
                if (uid >= 0 && content != null) {
                    ClipData data;
                    Intent intent = content.getIntent();
                    if (intent != null && (data = intent.getClipData()) != null && Intent.isAccessUriMode(intent.getFlags())) {
                        this.grantClipDataPermissions(data, intent.getFlags(), uid, this.mCallingUid, this.mSessionComponentName.getPackageName());
                    }
                    if ((data = content.getClipData()) != null) {
                        this.grantClipDataPermissions(data, 1, uid, this.mCallingUid, this.mSessionComponentName.getPackageName());
                    }
                }
            } else {
                assistData = null;
                structure = null;
                content = null;
            }
            try {
                this.mSession.handleAssist(assistData, structure, content);
            }
            catch (RemoteException e) {
                // empty catch block
            }
            this.mAssistData = null;
            this.mHaveAssistData = false;
        }
        if (this.mHaveScreenshot) {
            try {
                this.mSession.handleScreenshot(this.mScreenshot);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this.mScreenshot = null;
            this.mHaveScreenshot = false;
        }
    }

    public boolean hideLocked() {
        if (this.mBound) {
            if (this.mShown) {
                this.mShown = false;
                this.mShowArgs = null;
                this.mShowFlags = 0;
                this.mHaveAssistData = false;
                this.mAssistData = null;
                if (this.mSession != null) {
                    try {
                        this.mSession.hide();
                    }
                    catch (RemoteException e) {
                        // empty catch block
                    }
                }
                try {
                    this.mAm.revokeUriPermissionFromOwner(this.mPermissionOwner, null, 3, this.mUser);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
                if (this.mSession != null) {
                    try {
                        this.mAm.finishVoiceTask(this.mSession);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            }
            if (this.mFullyBound) {
                this.mContext.unbindService(this.mFullConnection);
                this.mFullyBound = false;
            }
            return true;
        }
        return false;
    }

    public void cancelLocked() {
        this.hideLocked();
        this.mCanceled = true;
        if (this.mBound) {
            if (this.mSession != null) {
                try {
                    this.mSession.destroy();
                }
                catch (RemoteException e) {
                    Slog.w(TAG, "Voice interation session already dead");
                }
            }
            if (this.mSession != null) {
                try {
                    this.mAm.finishVoiceTask(this.mSession);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
            this.mContext.unbindService(this);
            try {
                this.mIWindowManager.removeWindowToken(this.mToken);
            }
            catch (RemoteException e) {
                Slog.w(TAG, "Failed removing window token", e);
            }
            this.mBound = false;
            this.mService = null;
            this.mSession = null;
            this.mInteractor = null;
        }
        if (this.mFullyBound) {
            this.mContext.unbindService(this.mFullConnection);
            this.mFullyBound = false;
        }
    }

    public boolean deliverNewSessionLocked(IVoiceInteractionSession session, IVoiceInteractor interactor) {
        this.mSession = session;
        this.mInteractor = interactor;
        if (this.mShown) {
            try {
                session.show(this.mShowArgs, this.mShowFlags, this.mShowCallback);
                this.mShowArgs = null;
                this.mShowFlags = 0;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this.deliverSessionDataLocked();
        }
        return true;
    }

    private void notifyPendingShowCallbacksShownLocked() {
        for (int i = 0; i < this.mPendingShowCallbacks.size(); ++i) {
            try {
                this.mPendingShowCallbacks.get(i).onShown();
                continue;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        this.mPendingShowCallbacks.clear();
    }

    private void notifyPendingShowCallbacksFailedLocked() {
        for (int i = 0; i < this.mPendingShowCallbacks.size(); ++i) {
            try {
                this.mPendingShowCallbacks.get(i).onFailed();
                continue;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        this.mPendingShowCallbacks.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onServiceConnected(ComponentName name, IBinder service) {
        Object object = this.mLock;
        synchronized (object) {
            this.mService = IVoiceInteractionSessionService.Stub.asInterface(service);
            if (!this.mCanceled) {
                try {
                    this.mService.newSession(this.mToken, this.mShowArgs, this.mShowFlags);
                }
                catch (RemoteException e) {
                    Slog.w(TAG, "Failed adding window token", e);
                }
            }
        }
    }

    @Override
    public void onServiceDisconnected(ComponentName name) {
        this.mCallback.sessionConnectionGone(this);
        this.mService = null;
    }

    public void dump(String prefix, PrintWriter pw) {
        pw.print(prefix);
        pw.print("mToken=");
        pw.println(this.mToken);
        pw.print(prefix);
        pw.print("mShown=");
        pw.println(this.mShown);
        pw.print(prefix);
        pw.print("mShowArgs=");
        pw.println(this.mShowArgs);
        pw.print(prefix);
        pw.print("mShowFlags=0x");
        pw.println(Integer.toHexString(this.mShowFlags));
        pw.print(prefix);
        pw.print("mBound=");
        pw.println(this.mBound);
        if (this.mBound) {
            pw.print(prefix);
            pw.print("mService=");
            pw.println(this.mService);
            pw.print(prefix);
            pw.print("mSession=");
            pw.println(this.mSession);
            pw.print(prefix);
            pw.print("mInteractor=");
            pw.println(this.mInteractor);
        }
        pw.print(prefix);
        pw.print("mHaveAssistData=");
        pw.println(this.mHaveAssistData);
        if (this.mHaveAssistData) {
            pw.print(prefix);
            pw.print("mAssistData=");
            pw.println(this.mAssistData);
        }
    }

    public static interface Callback {
        public void sessionConnectionGone(VoiceInteractionSessionConnection var1);
    }
}

