/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.util.ArraySet;
import android.util.SparseArray;
import android.util.TypedValue;
import android.view.MagnificationSpec;
import android.view.Surface;
import android.view.SurfaceControl;
import android.view.ViewConfiguration;
import android.view.WindowInfo;
import android.view.WindowManager;
import android.view.WindowManagerInternal;
import android.view.WindowManagerPolicy;
import android.view.animation.DecelerateInterpolator;
import com.android.internal.os.SomeArgs;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.WindowList;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

final class AccessibilityController {
    private final WindowManagerService mWindowManagerService;
    private static final float[] sTempFloats = new float[9];
    private DisplayMagnifier mDisplayMagnifier;
    private WindowsForAccessibilityObserver mWindowsForAccessibilityObserver;

    public AccessibilityController(WindowManagerService service) {
        this.mWindowManagerService = service;
    }

    public void setMagnificationCallbacksLocked(WindowManagerInternal.MagnificationCallbacks callbacks) {
        if (callbacks != null) {
            if (this.mDisplayMagnifier != null) {
                throw new IllegalStateException("Magnification callbacks already set!");
            }
            this.mDisplayMagnifier = new DisplayMagnifier(this.mWindowManagerService, callbacks);
        } else {
            if (this.mDisplayMagnifier == null) {
                throw new IllegalStateException("Magnification callbacks already cleared!");
            }
            this.mDisplayMagnifier.destroyLocked();
            this.mDisplayMagnifier = null;
        }
    }

    public void setWindowsForAccessibilityCallback(WindowManagerInternal.WindowsForAccessibilityCallback callback) {
        if (callback != null) {
            if (this.mWindowsForAccessibilityObserver != null) {
                throw new IllegalStateException("Windows for accessibility callback already set!");
            }
            this.mWindowsForAccessibilityObserver = new WindowsForAccessibilityObserver(this.mWindowManagerService, callback);
        } else {
            if (this.mWindowsForAccessibilityObserver == null) {
                throw new IllegalStateException("Windows for accessibility callback already cleared!");
            }
            this.mWindowsForAccessibilityObserver = null;
        }
    }

    public void setMagnificationSpecLocked(MagnificationSpec spec) {
        if (this.mDisplayMagnifier != null) {
            this.mDisplayMagnifier.setMagnificationSpecLocked(spec);
        }
        if (this.mWindowsForAccessibilityObserver != null) {
            this.mWindowsForAccessibilityObserver.scheduleComputeChangedWindowsLocked();
        }
    }

    public void onRectangleOnScreenRequestedLocked(Rect rectangle) {
        if (this.mDisplayMagnifier != null) {
            this.mDisplayMagnifier.onRectangleOnScreenRequestedLocked(rectangle);
        }
    }

    public void onWindowLayersChangedLocked() {
        if (this.mDisplayMagnifier != null) {
            this.mDisplayMagnifier.onWindowLayersChangedLocked();
        }
        if (this.mWindowsForAccessibilityObserver != null) {
            this.mWindowsForAccessibilityObserver.scheduleComputeChangedWindowsLocked();
        }
    }

    public void onRotationChangedLocked(DisplayContent displayContent, int rotation) {
        if (this.mDisplayMagnifier != null) {
            this.mDisplayMagnifier.onRotationChangedLocked(displayContent, rotation);
        }
        if (this.mWindowsForAccessibilityObserver != null) {
            this.mWindowsForAccessibilityObserver.scheduleComputeChangedWindowsLocked();
        }
    }

    public void onAppWindowTransitionLocked(WindowState windowState, int transition2) {
        if (this.mDisplayMagnifier != null) {
            this.mDisplayMagnifier.onAppWindowTransitionLocked(windowState, transition2);
        }
    }

    public void onWindowTransitionLocked(WindowState windowState, int transition2) {
        if (this.mDisplayMagnifier != null) {
            this.mDisplayMagnifier.onWindowTransitionLocked(windowState, transition2);
        }
        if (this.mWindowsForAccessibilityObserver != null) {
            this.mWindowsForAccessibilityObserver.scheduleComputeChangedWindowsLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWindowFocusChangedNotLocked() {
        WindowsForAccessibilityObserver observer = null;
        WindowManagerService windowManagerService = this.mWindowManagerService;
        synchronized (windowManagerService) {
            observer = this.mWindowsForAccessibilityObserver;
        }
        if (observer != null) {
            observer.performComputeChangedWindowsNotLocked();
        }
    }

    public void onSomeWindowResizedOrMovedLocked() {
        if (this.mWindowsForAccessibilityObserver != null) {
            this.mWindowsForAccessibilityObserver.scheduleComputeChangedWindowsLocked();
        }
    }

    public void drawMagnifiedRegionBorderIfNeededLocked() {
        if (this.mDisplayMagnifier != null) {
            this.mDisplayMagnifier.drawMagnifiedRegionBorderIfNeededLocked();
        }
    }

    public MagnificationSpec getMagnificationSpecForWindowLocked(WindowState windowState) {
        if (this.mDisplayMagnifier != null) {
            return this.mDisplayMagnifier.getMagnificationSpecForWindowLocked(windowState);
        }
        return null;
    }

    public boolean hasCallbacksLocked() {
        return this.mDisplayMagnifier != null || this.mWindowsForAccessibilityObserver != null;
    }

    private static void populateTransformationMatrixLocked(WindowState windowState, Matrix outMatrix) {
        AccessibilityController.sTempFloats[0] = windowState.mWinAnimator.mDsDx;
        AccessibilityController.sTempFloats[3] = windowState.mWinAnimator.mDtDx;
        AccessibilityController.sTempFloats[1] = windowState.mWinAnimator.mDsDy;
        AccessibilityController.sTempFloats[4] = windowState.mWinAnimator.mDtDy;
        AccessibilityController.sTempFloats[2] = windowState.mShownFrame.left;
        AccessibilityController.sTempFloats[5] = windowState.mShownFrame.top;
        AccessibilityController.sTempFloats[6] = 0.0f;
        AccessibilityController.sTempFloats[7] = 0.0f;
        AccessibilityController.sTempFloats[8] = 1.0f;
        outMatrix.setValues(sTempFloats);
    }

    private static final class WindowsForAccessibilityObserver {
        private static final String LOG_TAG = "WindowsForAccessibilityObserver";
        private static final boolean DEBUG = false;
        private final SparseArray<WindowState> mTempWindowStates = new SparseArray();
        private final List<WindowInfo> mOldWindows = new ArrayList<WindowInfo>();
        private final Set<IBinder> mTempBinderSet = new ArraySet<IBinder>();
        private final RectF mTempRectF = new RectF();
        private final Matrix mTempMatrix = new Matrix();
        private final Point mTempPoint = new Point();
        private final Rect mTempRect = new Rect();
        private final Region mTempRegion = new Region();
        private final Region mTempRegion1 = new Region();
        private final Context mContext;
        private final WindowManagerService mWindowManagerService;
        private final Handler mHandler;
        private final WindowManagerInternal.WindowsForAccessibilityCallback mCallback;
        private final long mRecurringAccessibilityEventsIntervalMillis;

        public WindowsForAccessibilityObserver(WindowManagerService windowManagerService, WindowManagerInternal.WindowsForAccessibilityCallback callback) {
            this.mContext = windowManagerService.mContext;
            this.mWindowManagerService = windowManagerService;
            this.mCallback = callback;
            this.mHandler = new MyHandler(this.mWindowManagerService.mH.getLooper());
            this.mRecurringAccessibilityEventsIntervalMillis = ViewConfiguration.getSendRecurringAccessibilityEventsInterval();
            this.computeChangedWindows();
        }

        public void performComputeChangedWindowsNotLocked() {
            this.mHandler.removeMessages(1);
            this.computeChangedWindows();
        }

        public void scheduleComputeChangedWindowsLocked() {
            if (!this.mHandler.hasMessages(1)) {
                this.mHandler.sendEmptyMessageDelayed(1, this.mRecurringAccessibilityEventsIntervalMillis);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void computeChangedWindows() {
            boolean windowsChanged = false;
            ArrayList<WindowInfo> windows = new ArrayList<WindowInfo>();
            HashMap<IBinder, WindowState> hashMap = this.mWindowManagerService.mWindowMap;
            synchronized (hashMap) {
                int i;
                WindowState windowState;
                int i2;
                if (this.mWindowManagerService.mCurrentFocus == null) {
                    return;
                }
                WindowManager windowManager = (WindowManager)this.mContext.getSystemService("window");
                windowManager.getDefaultDisplay().getRealSize(this.mTempPoint);
                int screenWidth = this.mTempPoint.x;
                int screenHeight = this.mTempPoint.y;
                Region unaccountedSpace = this.mTempRegion;
                unaccountedSpace.set(0, 0, screenWidth, screenHeight);
                SparseArray<WindowState> visibleWindows = this.mTempWindowStates;
                this.populateVisibleWindowsOnScreenLocked(visibleWindows);
                Set<IBinder> addedWindows = this.mTempBinderSet;
                addedWindows.clear();
                boolean focusedWindowAdded = false;
                int visibleWindowCount = visibleWindows.size();
                for (i2 = visibleWindowCount - 1; i2 >= 0; --i2) {
                    windowState = visibleWindows.valueAt(i2);
                    int flags = windowState.mAttrs.flags;
                    if ((flags & 0x10) != 0) continue;
                    Rect boundsInScreen = this.mTempRect;
                    this.computeWindowBoundsInScreen(windowState, boundsInScreen);
                    if (unaccountedSpace.quickReject(boundsInScreen)) continue;
                    if (WindowsForAccessibilityObserver.isReportedWindowType(windowState.mAttrs.type)) {
                        WindowInfo window = WindowsForAccessibilityObserver.obtainPopulatedWindowInfo(windowState, boundsInScreen);
                        addedWindows.add(window.token);
                        windows.add(window);
                        if (windowState.isFocused()) {
                            focusedWindowAdded = true;
                        }
                    }
                    if (windowState.mAttrs.type != 2032) {
                        unaccountedSpace.op(boundsInScreen, unaccountedSpace, Region.Op.REVERSE_DIFFERENCE);
                    }
                    if (unaccountedSpace.isEmpty() || (flags & 0x28) == 0) break;
                }
                if (!focusedWindowAdded) {
                    for (i2 = visibleWindowCount - 1; i2 >= 0; --i2) {
                        windowState = visibleWindows.valueAt(i2);
                        if (!windowState.isFocused()) continue;
                        Rect boundsInScreen = this.mTempRect;
                        this.computeWindowBoundsInScreen(windowState, boundsInScreen);
                        WindowInfo window = WindowsForAccessibilityObserver.obtainPopulatedWindowInfo(windowState, boundsInScreen);
                        addedWindows.add(window.token);
                        windows.add(window);
                        break;
                    }
                }
                int windowCount = windows.size();
                for (i = 0; i < windowCount; ++i) {
                    WindowInfo window = (WindowInfo)windows.get(i);
                    if (!addedWindows.contains(window.parentToken)) {
                        window.parentToken = null;
                    }
                    if (window.childTokens == null) continue;
                    int childTokenCount = window.childTokens.size();
                    for (int j = childTokenCount - 1; j >= 0; --j) {
                        if (addedWindows.contains(window.childTokens.get(j))) continue;
                        window.childTokens.remove(j);
                    }
                }
                visibleWindows.clear();
                addedWindows.clear();
                if (this.mOldWindows.size() != windows.size()) {
                    windowsChanged = true;
                } else if (!this.mOldWindows.isEmpty() || !windows.isEmpty()) {
                    for (i = 0; i < windowCount; ++i) {
                        WindowInfo newWindow;
                        WindowInfo oldWindow = this.mOldWindows.get(i);
                        if (!this.windowChangedNoLayer(oldWindow, newWindow = (WindowInfo)windows.get(i))) continue;
                        windowsChanged = true;
                        break;
                    }
                }
                if (windowsChanged) {
                    this.cacheWindows(windows);
                }
            }
            if (windowsChanged) {
                this.mCallback.onWindowsForAccessibilityChanged(windows);
            }
            WindowsForAccessibilityObserver.clearAndRecycleWindows(windows);
        }

        private void computeWindowBoundsInScreen(WindowState windowState, Rect outBounds) {
            Region touchableRegion = this.mTempRegion1;
            windowState.getTouchableRegion(touchableRegion);
            Rect touchableFrame = this.mTempRect;
            touchableRegion.getBounds(touchableFrame);
            RectF windowFrame = this.mTempRectF;
            windowFrame.set(touchableFrame);
            windowFrame.offset(-windowState.mFrame.left, -windowState.mFrame.top);
            Matrix matrix = this.mTempMatrix;
            AccessibilityController.populateTransformationMatrixLocked(windowState, matrix);
            matrix.mapRect(windowFrame);
            outBounds.set((int)windowFrame.left, (int)windowFrame.top, (int)windowFrame.right, (int)windowFrame.bottom);
        }

        private static WindowInfo obtainPopulatedWindowInfo(WindowState windowState, Rect boundsInScreen) {
            WindowInfo window = WindowInfo.obtain();
            window.type = windowState.mAttrs.type;
            window.layer = windowState.mLayer;
            window.token = windowState.mClient.asBinder();
            WindowState attachedWindow = windowState.mAttachedWindow;
            if (attachedWindow != null) {
                window.parentToken = attachedWindow.mClient.asBinder();
            }
            window.focused = windowState.isFocused();
            window.boundsInScreen.set(boundsInScreen);
            int childCount = windowState.mChildWindows.size();
            if (childCount > 0) {
                if (window.childTokens == null) {
                    window.childTokens = new ArrayList<IBinder>();
                }
                for (int j = 0; j < childCount; ++j) {
                    WindowState child = (WindowState)windowState.mChildWindows.get(j);
                    window.childTokens.add(child.mClient.asBinder());
                }
            }
            return window;
        }

        private void cacheWindows(List<WindowInfo> windows) {
            int oldWindowCount = this.mOldWindows.size();
            for (int i = oldWindowCount - 1; i >= 0; --i) {
                this.mOldWindows.remove(i).recycle();
            }
            int newWindowCount = windows.size();
            for (int i = 0; i < newWindowCount; ++i) {
                WindowInfo newWindow = windows.get(i);
                this.mOldWindows.add(WindowInfo.obtain(newWindow));
            }
        }

        private boolean windowChangedNoLayer(WindowInfo oldWindow, WindowInfo newWindow) {
            if (oldWindow == newWindow) {
                return false;
            }
            if (oldWindow == null) {
                return true;
            }
            if (newWindow == null) {
                return true;
            }
            if (oldWindow.type != newWindow.type) {
                return true;
            }
            if (oldWindow.focused != newWindow.focused) {
                return true;
            }
            if (oldWindow.token == null ? newWindow.token != null : !oldWindow.token.equals(newWindow.token)) {
                return true;
            }
            if (oldWindow.parentToken == null ? newWindow.parentToken != null : !oldWindow.parentToken.equals(newWindow.parentToken)) {
                return true;
            }
            if (!oldWindow.boundsInScreen.equals(newWindow.boundsInScreen)) {
                return true;
            }
            return oldWindow.childTokens != null && newWindow.childTokens != null && !oldWindow.childTokens.equals(newWindow.childTokens);
        }

        private static void clearAndRecycleWindows(List<WindowInfo> windows) {
            int windowCount = windows.size();
            for (int i = windowCount - 1; i >= 0; --i) {
                windows.remove(i).recycle();
            }
        }

        private static boolean isReportedWindowType(int windowType) {
            return windowType != 2029 && windowType != 2013 && windowType != 2021 && windowType != 2026 && windowType != 2016 && windowType != 2022 && windowType != 2018 && windowType != 2027 && windowType != 1004 && windowType != 2015 && windowType != 2030;
        }

        private void populateVisibleWindowsOnScreenLocked(SparseArray<WindowState> outWindows) {
            DisplayContent displayContent = this.mWindowManagerService.getDefaultDisplayContentLocked();
            WindowList windowList = displayContent.getWindowList();
            int windowCount = windowList.size();
            for (int i = 0; i < windowCount; ++i) {
                WindowState windowState = (WindowState)windowList.get(i);
                if (!windowState.isVisibleLw()) continue;
                outWindows.put(windowState.mLayer, windowState);
            }
        }

        private class MyHandler
        extends Handler {
            public static final int MESSAGE_COMPUTE_CHANGED_WINDOWS = 1;

            public MyHandler(Looper looper) {
                super(looper, null, false);
            }

            @Override
            public void handleMessage(Message message) {
                switch (message.what) {
                    case 1: {
                        WindowsForAccessibilityObserver.this.computeChangedWindows();
                    }
                }
            }
        }
    }

    private static final class DisplayMagnifier {
        private static final String LOG_TAG = "DisplayMagnifier";
        private static final boolean DEBUG_WINDOW_TRANSITIONS = false;
        private static final boolean DEBUG_ROTATION = false;
        private static final boolean DEBUG_LAYERS = false;
        private static final boolean DEBUG_RECTANGLE_REQUESTED = false;
        private static final boolean DEBUG_VIEWPORT_WINDOW = false;
        private final Rect mTempRect1 = new Rect();
        private final Rect mTempRect2 = new Rect();
        private final Region mTempRegion1 = new Region();
        private final Region mTempRegion2 = new Region();
        private final Region mTempRegion3 = new Region();
        private final Region mTempRegion4 = new Region();
        private final Context mContext;
        private final WindowManagerService mWindowManagerService;
        private final MagnifiedViewport mMagnifedViewport;
        private final Handler mHandler;
        private final WindowManagerInternal.MagnificationCallbacks mCallbacks;
        private final long mLongAnimationDuration;

        public DisplayMagnifier(WindowManagerService windowManagerService, WindowManagerInternal.MagnificationCallbacks callbacks) {
            this.mContext = windowManagerService.mContext;
            this.mWindowManagerService = windowManagerService;
            this.mCallbacks = callbacks;
            this.mHandler = new MyHandler(this.mWindowManagerService.mH.getLooper());
            this.mMagnifedViewport = new MagnifiedViewport();
            this.mLongAnimationDuration = this.mContext.getResources().getInteger(17694722);
        }

        public void setMagnificationSpecLocked(MagnificationSpec spec) {
            this.mMagnifedViewport.updateMagnificationSpecLocked(spec);
            this.mMagnifedViewport.recomputeBoundsLocked();
            this.mWindowManagerService.scheduleAnimationLocked();
        }

        public void onRectangleOnScreenRequestedLocked(Rect rectangle) {
            if (!this.mMagnifedViewport.isMagnifyingLocked()) {
                return;
            }
            Rect magnifiedRegionBounds = this.mTempRect2;
            this.mMagnifedViewport.getMagnifiedFrameInContentCoordsLocked(magnifiedRegionBounds);
            if (magnifiedRegionBounds.contains(rectangle)) {
                return;
            }
            SomeArgs args = SomeArgs.obtain();
            args.argi1 = rectangle.left;
            args.argi2 = rectangle.top;
            args.argi3 = rectangle.right;
            args.argi4 = rectangle.bottom;
            this.mHandler.obtainMessage(2, args).sendToTarget();
        }

        public void onWindowLayersChangedLocked() {
            this.mMagnifedViewport.recomputeBoundsLocked();
            this.mWindowManagerService.scheduleAnimationLocked();
        }

        public void onRotationChangedLocked(DisplayContent displayContent, int rotation) {
            this.mMagnifedViewport.onRotationChangedLocked();
            this.mHandler.sendEmptyMessage(4);
        }

        public void onAppWindowTransitionLocked(WindowState windowState, int transition2) {
            boolean magnifying = this.mMagnifedViewport.isMagnifyingLocked();
            if (magnifying) {
                switch (transition2) {
                    case 6: 
                    case 8: 
                    case 10: 
                    case 12: 
                    case 13: 
                    case 14: {
                        this.mHandler.sendEmptyMessage(3);
                    }
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public void onWindowTransitionLocked(WindowState windowState, int transition2) {
            boolean magnifying = this.mMagnifedViewport.isMagnifyingLocked();
            int type = windowState.mAttrs.type;
            switch (transition2) {
                case 1: 
                case 3: {
                    if (!magnifying) {
                        return;
                    }
                    switch (type) {
                        case 2: 
                        case 1000: 
                        case 1001: 
                        case 1002: 
                        case 1003: 
                        case 1005: 
                        case 2001: 
                        case 2002: 
                        case 2003: 
                        case 2005: 
                        case 2006: 
                        case 2007: 
                        case 2008: 
                        case 2009: 
                        case 2010: 
                        case 2020: 
                        case 2024: {
                            Rect magnifiedRegionBounds = this.mTempRect2;
                            this.mMagnifedViewport.getMagnifiedFrameInContentCoordsLocked(magnifiedRegionBounds);
                            Rect touchableRegionBounds = this.mTempRect1;
                            windowState.getTouchableRegion(this.mTempRegion1);
                            this.mTempRegion1.getBounds(touchableRegionBounds);
                            if (magnifiedRegionBounds.intersect(touchableRegionBounds)) return;
                            this.mCallbacks.onRectangleOnScreenRequested(touchableRegionBounds.left, touchableRegionBounds.top, touchableRegionBounds.right, touchableRegionBounds.bottom);
                        }
                    }
                    return;
                }
            }
        }

        public MagnificationSpec getMagnificationSpecForWindowLocked(WindowState windowState) {
            MagnificationSpec spec = this.mMagnifedViewport.getMagnificationSpecLocked();
            if (spec != null && !spec.isNop()) {
                WindowManagerPolicy policy = this.mWindowManagerService.mPolicy;
                int windowType = windowState.mAttrs.type;
                if (!policy.isTopLevelWindow(windowType) && windowState.mAttachedWindow != null && !policy.canMagnifyWindow(windowType)) {
                    return null;
                }
                if (!policy.canMagnifyWindow(windowState.mAttrs.type)) {
                    return null;
                }
            }
            return spec;
        }

        public void destroyLocked() {
            this.mMagnifedViewport.destroyWindow();
        }

        public void drawMagnifiedRegionBorderIfNeededLocked() {
            this.mMagnifedViewport.drawWindowIfNeededLocked();
        }

        private class MyHandler
        extends Handler {
            public static final int MESSAGE_NOTIFY_MAGNIFIED_BOUNDS_CHANGED = 1;
            public static final int MESSAGE_NOTIFY_RECTANGLE_ON_SCREEN_REQUESTED = 2;
            public static final int MESSAGE_NOTIFY_USER_CONTEXT_CHANGED = 3;
            public static final int MESSAGE_NOTIFY_ROTATION_CHANGED = 4;
            public static final int MESSAGE_SHOW_MAGNIFIED_REGION_BOUNDS_IF_NEEDED = 5;

            public MyHandler(Looper looper) {
                super(looper);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleMessage(Message message) {
                switch (message.what) {
                    case 1: {
                        Region bounds = (Region)message.obj;
                        DisplayMagnifier.this.mCallbacks.onMagnifedBoundsChanged(bounds);
                        bounds.recycle();
                        break;
                    }
                    case 2: {
                        SomeArgs args = (SomeArgs)message.obj;
                        int left = args.argi1;
                        int top = args.argi2;
                        int right = args.argi3;
                        int bottom = args.argi4;
                        DisplayMagnifier.this.mCallbacks.onRectangleOnScreenRequested(left, top, right, bottom);
                        args.recycle();
                        break;
                    }
                    case 3: {
                        DisplayMagnifier.this.mCallbacks.onUserContextChanged();
                        break;
                    }
                    case 4: {
                        int rotation = message.arg1;
                        DisplayMagnifier.this.mCallbacks.onRotationChanged(rotation);
                        break;
                    }
                    case 5: {
                        HashMap<IBinder, WindowState> hashMap = ((DisplayMagnifier)DisplayMagnifier.this).mWindowManagerService.mWindowMap;
                        synchronized (hashMap) {
                            if (DisplayMagnifier.this.mMagnifedViewport.isMagnifyingLocked()) {
                                DisplayMagnifier.this.mMagnifedViewport.setMagnifiedRegionBorderShownLocked(true, true);
                                DisplayMagnifier.this.mWindowManagerService.scheduleAnimationLocked();
                            }
                            break;
                        }
                    }
                }
            }
        }

        private final class MagnifiedViewport {
            private final SparseArray<WindowState> mTempWindowStates = new SparseArray();
            private final RectF mTempRectF = new RectF();
            private final Point mTempPoint = new Point();
            private final Matrix mTempMatrix = new Matrix();
            private final Region mMagnifiedBounds = new Region();
            private final Region mOldMagnifiedBounds = new Region();
            private final Path mCircularPath;
            private final MagnificationSpec mMagnificationSpec = MagnificationSpec.obtain();
            private final WindowManager mWindowManager;
            private final float mBorderWidth;
            private final int mHalfBorderWidth;
            private final int mDrawBorderInset;
            private final ViewportWindow mWindow;
            private boolean mFullRedrawNeeded;

            public MagnifiedViewport() {
                this.mWindowManager = (WindowManager)DisplayMagnifier.this.mContext.getSystemService("window");
                this.mBorderWidth = DisplayMagnifier.this.mContext.getResources().getDimension(17105015);
                this.mHalfBorderWidth = (int)Math.ceil(this.mBorderWidth / 2.0f);
                this.mDrawBorderInset = (int)this.mBorderWidth / 2;
                this.mWindow = new ViewportWindow(DisplayMagnifier.this.mContext);
                if (DisplayMagnifier.this.mContext.getResources().getConfiguration().isScreenRound()) {
                    this.mCircularPath = new Path();
                    this.mWindowManager.getDefaultDisplay().getRealSize(this.mTempPoint);
                    int centerXY = this.mTempPoint.x / 2;
                    this.mCircularPath.addCircle(centerXY, centerXY, centerXY, Path.Direction.CW);
                } else {
                    this.mCircularPath = null;
                }
                this.recomputeBoundsLocked();
            }

            public void updateMagnificationSpecLocked(MagnificationSpec spec) {
                if (spec != null) {
                    this.mMagnificationSpec.initialize(spec.scale, spec.offsetX, spec.offsetY);
                } else {
                    this.mMagnificationSpec.clear();
                }
                if (!DisplayMagnifier.this.mHandler.hasMessages(5)) {
                    this.setMagnifiedRegionBorderShownLocked(this.isMagnifyingLocked(), true);
                }
            }

            public void recomputeBoundsLocked() {
                this.mWindowManager.getDefaultDisplay().getRealSize(this.mTempPoint);
                int screenWidth = this.mTempPoint.x;
                int screenHeight = this.mTempPoint.y;
                Region magnifiedBounds = this.mMagnifiedBounds;
                magnifiedBounds.set(0, 0, 0, 0);
                Region availableBounds = DisplayMagnifier.this.mTempRegion1;
                availableBounds.set(0, 0, screenWidth, screenHeight);
                if (this.mCircularPath != null) {
                    availableBounds.setPath(this.mCircularPath, availableBounds);
                }
                Region nonMagnifiedBounds = DisplayMagnifier.this.mTempRegion4;
                nonMagnifiedBounds.set(0, 0, 0, 0);
                SparseArray<WindowState> visibleWindows = this.mTempWindowStates;
                visibleWindows.clear();
                this.populateWindowsOnScreenLocked(visibleWindows);
                int visibleWindowCount = visibleWindows.size();
                for (int i = visibleWindowCount - 1; i >= 0; --i) {
                    WindowState windowState = visibleWindows.valueAt(i);
                    if (windowState.mAttrs.type == 2027) continue;
                    Region windowBounds = DisplayMagnifier.this.mTempRegion2;
                    Matrix matrix = this.mTempMatrix;
                    AccessibilityController.populateTransformationMatrixLocked(windowState, matrix);
                    RectF windowFrame = this.mTempRectF;
                    if (((DisplayMagnifier)DisplayMagnifier.this).mWindowManagerService.mPolicy.canMagnifyWindow(windowState.mAttrs.type)) {
                        windowFrame.set(windowState.mFrame);
                        windowFrame.offset(-windowFrame.left, -windowFrame.top);
                        matrix.mapRect(windowFrame);
                        windowBounds.set((int)windowFrame.left, (int)windowFrame.top, (int)windowFrame.right, (int)windowFrame.bottom);
                        magnifiedBounds.op(windowBounds, Region.Op.UNION);
                        magnifiedBounds.op(availableBounds, Region.Op.INTERSECT);
                    } else {
                        Region touchableRegion = DisplayMagnifier.this.mTempRegion3;
                        windowState.getTouchableRegion(touchableRegion);
                        Rect touchableFrame = DisplayMagnifier.this.mTempRect1;
                        touchableRegion.getBounds(touchableFrame);
                        windowFrame.set(touchableFrame);
                        windowFrame.offset(-windowState.mFrame.left, -windowState.mFrame.top);
                        matrix.mapRect(windowFrame);
                        windowBounds.set((int)windowFrame.left, (int)windowFrame.top, (int)windowFrame.right, (int)windowFrame.bottom);
                        nonMagnifiedBounds.op(windowBounds, Region.Op.UNION);
                        windowBounds.op(magnifiedBounds, Region.Op.DIFFERENCE);
                        availableBounds.op(windowBounds, Region.Op.DIFFERENCE);
                    }
                    Region accountedBounds = DisplayMagnifier.this.mTempRegion2;
                    accountedBounds.set(magnifiedBounds);
                    accountedBounds.op(nonMagnifiedBounds, Region.Op.UNION);
                    accountedBounds.op(0, 0, screenWidth, screenHeight, Region.Op.INTERSECT);
                    if (!accountedBounds.isRect()) continue;
                    Rect accountedFrame = DisplayMagnifier.this.mTempRect1;
                    accountedBounds.getBounds(accountedFrame);
                    if (accountedFrame.width() == screenWidth && accountedFrame.height() == screenHeight) break;
                }
                visibleWindows.clear();
                magnifiedBounds.op(this.mDrawBorderInset, this.mDrawBorderInset, screenWidth - this.mDrawBorderInset, screenHeight - this.mDrawBorderInset, Region.Op.INTERSECT);
                if (!this.mOldMagnifiedBounds.equals(magnifiedBounds)) {
                    Region bounds = Region.obtain();
                    bounds.set(magnifiedBounds);
                    DisplayMagnifier.this.mHandler.obtainMessage(1, bounds).sendToTarget();
                    this.mWindow.setBounds(magnifiedBounds);
                    Rect dirtyRect = DisplayMagnifier.this.mTempRect1;
                    if (this.mFullRedrawNeeded) {
                        this.mFullRedrawNeeded = false;
                        dirtyRect.set(this.mDrawBorderInset, this.mDrawBorderInset, screenWidth - this.mDrawBorderInset, screenHeight - this.mDrawBorderInset);
                        this.mWindow.invalidate(dirtyRect);
                    } else {
                        Region dirtyRegion = DisplayMagnifier.this.mTempRegion3;
                        dirtyRegion.set(magnifiedBounds);
                        dirtyRegion.op(this.mOldMagnifiedBounds, Region.Op.UNION);
                        dirtyRegion.op(nonMagnifiedBounds, Region.Op.INTERSECT);
                        dirtyRegion.getBounds(dirtyRect);
                        this.mWindow.invalidate(dirtyRect);
                    }
                    this.mOldMagnifiedBounds.set(magnifiedBounds);
                }
            }

            public void onRotationChangedLocked() {
                if (this.isMagnifyingLocked()) {
                    this.setMagnifiedRegionBorderShownLocked(false, false);
                    long delay = (long)((float)DisplayMagnifier.this.mLongAnimationDuration * DisplayMagnifier.this.mWindowManagerService.getWindowAnimationScaleLocked());
                    Message message = DisplayMagnifier.this.mHandler.obtainMessage(5);
                    DisplayMagnifier.this.mHandler.sendMessageDelayed(message, delay);
                }
                this.recomputeBoundsLocked();
                this.mWindow.updateSize();
            }

            public void setMagnifiedRegionBorderShownLocked(boolean shown, boolean animate) {
                if (shown) {
                    this.mFullRedrawNeeded = true;
                    this.mOldMagnifiedBounds.set(0, 0, 0, 0);
                }
                this.mWindow.setShown(shown, animate);
            }

            public void getMagnifiedFrameInContentCoordsLocked(Rect rect) {
                MagnificationSpec spec = this.mMagnificationSpec;
                this.mMagnifiedBounds.getBounds(rect);
                rect.offset((int)(-spec.offsetX), (int)(-spec.offsetY));
                rect.scale(1.0f / spec.scale);
            }

            public boolean isMagnifyingLocked() {
                return this.mMagnificationSpec.scale > 1.0f;
            }

            public MagnificationSpec getMagnificationSpecLocked() {
                return this.mMagnificationSpec;
            }

            public void drawWindowIfNeededLocked() {
                this.recomputeBoundsLocked();
                this.mWindow.drawIfNeeded();
            }

            public void destroyWindow() {
                this.mWindow.releaseSurface();
            }

            private void populateWindowsOnScreenLocked(SparseArray<WindowState> outWindows) {
                DisplayContent displayContent = DisplayMagnifier.this.mWindowManagerService.getDefaultDisplayContentLocked();
                WindowList windowList = displayContent.getWindowList();
                int windowCount = windowList.size();
                for (int i = 0; i < windowCount; ++i) {
                    WindowState windowState = (WindowState)windowList.get(i);
                    if (!windowState.isOnScreen() || windowState.mWinAnimator.mEnterAnimationPending) continue;
                    outWindows.put(windowState.mLayer, windowState);
                }
            }

            private final class ViewportWindow {
                private static final String SURFACE_TITLE = "Magnification Overlay";
                private final Region mBounds = new Region();
                private final Rect mDirtyRect = new Rect();
                private final Paint mPaint = new Paint();
                private final SurfaceControl mSurfaceControl;
                private final Surface mSurface = new Surface();
                private final AnimationController mAnimationController;
                private boolean mShown;
                private int mAlpha;
                private boolean mInvalidated;

                public ViewportWindow(Context context) {
                    SurfaceControl surfaceControl = null;
                    try {
                        MagnifiedViewport.this.mWindowManager.getDefaultDisplay().getRealSize(MagnifiedViewport.this.mTempPoint);
                        surfaceControl = new SurfaceControl(((DisplayMagnifier)DisplayMagnifier.this).mWindowManagerService.mFxSession, SURFACE_TITLE, ((MagnifiedViewport)MagnifiedViewport.this).mTempPoint.x, ((MagnifiedViewport)MagnifiedViewport.this).mTempPoint.y, -3, 4);
                    }
                    catch (Surface.OutOfResourcesException oore) {
                        // empty catch block
                    }
                    this.mSurfaceControl = surfaceControl;
                    this.mSurfaceControl.setLayerStack(MagnifiedViewport.this.mWindowManager.getDefaultDisplay().getLayerStack());
                    this.mSurfaceControl.setLayer(((DisplayMagnifier)DisplayMagnifier.this).mWindowManagerService.mPolicy.windowTypeToLayerLw(2027) * 10000);
                    this.mSurfaceControl.setPosition(0.0f, 0.0f);
                    this.mSurface.copyFrom(this.mSurfaceControl);
                    this.mAnimationController = new AnimationController(context, ((DisplayMagnifier)DisplayMagnifier.this).mWindowManagerService.mH.getLooper());
                    TypedValue typedValue = new TypedValue();
                    context.getTheme().resolveAttribute(16843664, typedValue, true);
                    int borderColor = context.getColor(typedValue.resourceId);
                    this.mPaint.setStyle(Paint.Style.STROKE);
                    this.mPaint.setStrokeWidth(MagnifiedViewport.this.mBorderWidth);
                    this.mPaint.setColor(borderColor);
                    this.mInvalidated = true;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void setShown(boolean shown, boolean animate) {
                    HashMap<IBinder, WindowState> hashMap = ((DisplayMagnifier)DisplayMagnifier.this).mWindowManagerService.mWindowMap;
                    synchronized (hashMap) {
                        if (this.mShown == shown) {
                            return;
                        }
                        this.mShown = shown;
                        this.mAnimationController.onFrameShownStateChanged(shown, animate);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public int getAlpha() {
                    HashMap<IBinder, WindowState> hashMap = ((DisplayMagnifier)DisplayMagnifier.this).mWindowManagerService.mWindowMap;
                    synchronized (hashMap) {
                        return this.mAlpha;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void setAlpha(int alpha) {
                    HashMap<IBinder, WindowState> hashMap = ((DisplayMagnifier)DisplayMagnifier.this).mWindowManagerService.mWindowMap;
                    synchronized (hashMap) {
                        if (this.mAlpha == alpha) {
                            return;
                        }
                        this.mAlpha = alpha;
                        this.invalidate(null);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void setBounds(Region bounds) {
                    HashMap<IBinder, WindowState> hashMap = ((DisplayMagnifier)DisplayMagnifier.this).mWindowManagerService.mWindowMap;
                    synchronized (hashMap) {
                        if (this.mBounds.equals(bounds)) {
                            return;
                        }
                        this.mBounds.set(bounds);
                        this.invalidate(this.mDirtyRect);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void updateSize() {
                    HashMap<IBinder, WindowState> hashMap = ((DisplayMagnifier)DisplayMagnifier.this).mWindowManagerService.mWindowMap;
                    synchronized (hashMap) {
                        MagnifiedViewport.this.mWindowManager.getDefaultDisplay().getRealSize(MagnifiedViewport.this.mTempPoint);
                        this.mSurfaceControl.setSize(((MagnifiedViewport)MagnifiedViewport.this).mTempPoint.x, ((MagnifiedViewport)MagnifiedViewport.this).mTempPoint.y);
                        this.invalidate(this.mDirtyRect);
                    }
                }

                public void invalidate(Rect dirtyRect) {
                    if (dirtyRect != null) {
                        this.mDirtyRect.set(dirtyRect);
                    } else {
                        this.mDirtyRect.setEmpty();
                    }
                    this.mInvalidated = true;
                    DisplayMagnifier.this.mWindowManagerService.scheduleAnimationLocked();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void drawIfNeeded() {
                    HashMap<IBinder, WindowState> hashMap = ((DisplayMagnifier)DisplayMagnifier.this).mWindowManagerService.mWindowMap;
                    synchronized (hashMap) {
                        if (!this.mInvalidated) {
                            return;
                        }
                        this.mInvalidated = false;
                        Canvas canvas = null;
                        try {
                            if (this.mDirtyRect.isEmpty()) {
                                this.mBounds.getBounds(this.mDirtyRect);
                            }
                            this.mDirtyRect.inset(-MagnifiedViewport.this.mHalfBorderWidth, -MagnifiedViewport.this.mHalfBorderWidth);
                            canvas = this.mSurface.lockCanvas(this.mDirtyRect);
                        }
                        catch (IllegalArgumentException iae) {
                        }
                        catch (Surface.OutOfResourcesException oore) {
                            // empty catch block
                        }
                        if (canvas == null) {
                            return;
                        }
                        canvas.drawColor(0, PorterDuff.Mode.CLEAR);
                        this.mPaint.setAlpha(this.mAlpha);
                        Path path = this.mBounds.getBoundaryPath();
                        canvas.drawPath(path, this.mPaint);
                        this.mSurface.unlockCanvasAndPost(canvas);
                        if (this.mAlpha > 0) {
                            this.mSurfaceControl.show();
                        } else {
                            this.mSurfaceControl.hide();
                        }
                    }
                }

                public void releaseSurface() {
                    this.mSurfaceControl.release();
                    this.mSurface.release();
                }

                private final class AnimationController
                extends Handler {
                    private static final String PROPERTY_NAME_ALPHA = "alpha";
                    private static final int MIN_ALPHA = 0;
                    private static final int MAX_ALPHA = 255;
                    private static final int MSG_FRAME_SHOWN_STATE_CHANGED = 1;
                    private final ValueAnimator mShowHideFrameAnimator;

                    public AnimationController(Context context, Looper looper) {
                        super(looper);
                        this.mShowHideFrameAnimator = ObjectAnimator.ofInt((Object)ViewportWindow.this, PROPERTY_NAME_ALPHA, 0, 255);
                        DecelerateInterpolator interpolator2 = new DecelerateInterpolator(2.5f);
                        long longAnimationDuration = context.getResources().getInteger(17694722);
                        this.mShowHideFrameAnimator.setInterpolator(interpolator2);
                        this.mShowHideFrameAnimator.setDuration(longAnimationDuration);
                    }

                    public void onFrameShownStateChanged(boolean shown, boolean animate) {
                        this.obtainMessage(1, shown ? 1 : 0, animate ? 1 : 0).sendToTarget();
                    }

                    @Override
                    public void handleMessage(Message message) {
                        switch (message.what) {
                            case 1: {
                                boolean animate;
                                boolean shown = message.arg1 == 1;
                                boolean bl = animate = message.arg2 == 1;
                                if (animate) {
                                    if (this.mShowHideFrameAnimator.isRunning()) {
                                        this.mShowHideFrameAnimator.reverse();
                                        break;
                                    }
                                    if (shown) {
                                        this.mShowHideFrameAnimator.start();
                                        break;
                                    }
                                    this.mShowHideFrameAnimator.reverse();
                                    break;
                                }
                                this.mShowHideFrameAnimator.cancel();
                                if (shown) {
                                    ViewportWindow.this.setAlpha(255);
                                    break;
                                }
                                ViewportWindow.this.setAlpha(0);
                            }
                        }
                    }
                }
            }
        }
    }
}

