/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.os.Handler;
import android.os.IBinder;
import android.os.IRemoteCallback;
import android.view.WindowManager;
import android.view.WindowManagerInternal;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.AnimationUtils;
import android.view.animation.ClipRectAnimation;
import android.view.animation.ClipRectLRAnimation;
import android.view.animation.ClipRectTBAnimation;
import android.view.animation.Interpolator;
import android.view.animation.PathInterpolator;
import android.view.animation.ScaleAnimation;
import android.view.animation.TranslateAnimation;
import android.view.animation.TranslateYAnimation;
import com.android.internal.R;
import com.android.internal.util.DumpUtils;
import com.android.server.AttributeCache;
import com.android.server.wm.AppWindowAnimator;
import java.io.PrintWriter;
import java.util.ArrayList;

public class AppTransition
implements DumpUtils.Dump {
    private static final String TAG = "AppTransition";
    private static final boolean DEBUG_APP_TRANSITIONS = false;
    private static final boolean DEBUG_ANIM = false;
    private static final int CLIP_REVEAL_TRANSLATION_Y_DP = 8;
    public static final int TRANSIT_UNSET = -1;
    public static final int TRANSIT_NONE = 0;
    public static final int TRANSIT_ACTIVITY_OPEN = 6;
    public static final int TRANSIT_ACTIVITY_CLOSE = 7;
    public static final int TRANSIT_TASK_OPEN = 8;
    public static final int TRANSIT_TASK_CLOSE = 9;
    public static final int TRANSIT_TASK_TO_FRONT = 10;
    public static final int TRANSIT_TASK_TO_BACK = 11;
    public static final int TRANSIT_WALLPAPER_CLOSE = 12;
    public static final int TRANSIT_WALLPAPER_OPEN = 13;
    public static final int TRANSIT_WALLPAPER_INTRA_OPEN = 14;
    public static final int TRANSIT_WALLPAPER_INTRA_CLOSE = 15;
    public static final int TRANSIT_TASK_OPEN_BEHIND = 16;
    public static final int TRANSIT_TASK_IN_PLACE = 17;
    private static final float RECENTS_THUMBNAIL_FADEIN_FRACTION = 0.5f;
    private static final float RECENTS_THUMBNAIL_FADEOUT_FRACTION = 0.5f;
    private static final int DEFAULT_APP_TRANSITION_DURATION = 336;
    private static final int THUMBNAIL_APP_TRANSITION_DURATION = 336;
    private static final int THUMBNAIL_APP_TRANSITION_ALPHA_DURATION = 336;
    private final Context mContext;
    private final Handler mH;
    private int mNextAppTransition = -1;
    private static final int NEXT_TRANSIT_TYPE_NONE = 0;
    private static final int NEXT_TRANSIT_TYPE_CUSTOM = 1;
    private static final int NEXT_TRANSIT_TYPE_SCALE_UP = 2;
    private static final int NEXT_TRANSIT_TYPE_THUMBNAIL_SCALE_UP = 3;
    private static final int NEXT_TRANSIT_TYPE_THUMBNAIL_SCALE_DOWN = 4;
    private static final int NEXT_TRANSIT_TYPE_THUMBNAIL_ASPECT_SCALE_UP = 5;
    private static final int NEXT_TRANSIT_TYPE_THUMBNAIL_ASPECT_SCALE_DOWN = 6;
    private static final int NEXT_TRANSIT_TYPE_CUSTOM_IN_PLACE = 7;
    private static final int NEXT_TRANSIT_TYPE_CLIP_REVEAL = 8;
    private int mNextAppTransitionType = 0;
    private static final int THUMBNAIL_TRANSITION_ENTER_SCALE_UP = 0;
    private static final int THUMBNAIL_TRANSITION_EXIT_SCALE_UP = 1;
    private static final int THUMBNAIL_TRANSITION_ENTER_SCALE_DOWN = 2;
    private static final int THUMBNAIL_TRANSITION_EXIT_SCALE_DOWN = 3;
    private String mNextAppTransitionPackage;
    private Bitmap mNextAppTransitionThumbnail;
    private boolean mNextAppTransitionScaleUp;
    private IRemoteCallback mNextAppTransitionCallback;
    private int mNextAppTransitionEnter;
    private int mNextAppTransitionExit;
    private int mNextAppTransitionInPlace;
    private int mNextAppTransitionStartX;
    private int mNextAppTransitionStartY;
    private int mNextAppTransitionStartWidth;
    private int mNextAppTransitionStartHeight;
    private Rect mNextAppTransitionInsets = new Rect();
    private Rect mTmpFromClipRect = new Rect();
    private Rect mTmpToClipRect = new Rect();
    private static final int APP_STATE_IDLE = 0;
    private static final int APP_STATE_READY = 1;
    private static final int APP_STATE_RUNNING = 2;
    private static final int APP_STATE_TIMEOUT = 3;
    private int mAppTransitionState = 0;
    private final int mConfigShortAnimTime;
    private final Interpolator mDecelerateInterpolator;
    private final Interpolator mThumbnailFadeInInterpolator;
    private final Interpolator mThumbnailFadeOutInterpolator;
    private final Interpolator mLinearOutSlowInInterpolator;
    private final Interpolator mFastOutLinearInInterpolator;
    private final Interpolator mClipHorizontalInterpolator = new PathInterpolator(0.0f, 0.0f, 0.4f, 1.0f);
    private final Interpolator mTouchResponseInterpolator = new PathInterpolator(0.3f, 0.0f, 0.1f, 1.0f);
    private final int mClipRevealTranslationY;
    private int mCurrentUserId = 0;
    private final ArrayList<WindowManagerInternal.AppTransitionListener> mListeners = new ArrayList();

    AppTransition(Context context, Handler h) {
        this.mContext = context;
        this.mH = h;
        this.mLinearOutSlowInInterpolator = AnimationUtils.loadInterpolator(context, 17563662);
        this.mFastOutLinearInInterpolator = AnimationUtils.loadInterpolator(context, 17563663);
        this.mConfigShortAnimTime = context.getResources().getInteger(0x10E0000);
        this.mDecelerateInterpolator = AnimationUtils.loadInterpolator(context, 17563651);
        this.mThumbnailFadeInInterpolator = new Interpolator(){

            @Override
            public float getInterpolation(float input) {
                if (input < 0.5f) {
                    return 0.0f;
                }
                float t = (input - 0.5f) / 0.5f;
                return AppTransition.this.mFastOutLinearInInterpolator.getInterpolation(t);
            }
        };
        this.mThumbnailFadeOutInterpolator = new Interpolator(){

            @Override
            public float getInterpolation(float input) {
                if (input < 0.5f) {
                    float t = input / 0.5f;
                    return AppTransition.this.mLinearOutSlowInInterpolator.getInterpolation(t);
                }
                return 1.0f;
            }
        };
        this.mClipRevealTranslationY = (int)(8.0f * this.mContext.getResources().getDisplayMetrics().density);
    }

    boolean isTransitionSet() {
        return this.mNextAppTransition != -1;
    }

    boolean isTransitionNone() {
        return this.mNextAppTransition == 0;
    }

    boolean isTransitionEqual(int transit) {
        return this.mNextAppTransition == transit;
    }

    int getAppTransition() {
        return this.mNextAppTransition;
    }

    void setAppTransition(int transit) {
        this.mNextAppTransition = transit;
    }

    boolean isReady() {
        return this.mAppTransitionState == 1 || this.mAppTransitionState == 3;
    }

    void setReady() {
        this.mAppTransitionState = 1;
    }

    boolean isRunning() {
        return this.mAppTransitionState == 2;
    }

    void setIdle() {
        this.mAppTransitionState = 0;
    }

    boolean isTimeout() {
        return this.mAppTransitionState == 3;
    }

    void setTimeout() {
        this.mAppTransitionState = 3;
    }

    Bitmap getNextAppTransitionThumbnail() {
        return this.mNextAppTransitionThumbnail;
    }

    boolean isNextThumbnailTransitionAspectScaled() {
        return this.mNextAppTransitionType == 5 || this.mNextAppTransitionType == 6;
    }

    boolean isNextThumbnailTransitionScaleUp() {
        return this.mNextAppTransitionScaleUp;
    }

    int getStartingX() {
        return this.mNextAppTransitionStartX;
    }

    int getStartingY() {
        return this.mNextAppTransitionStartY;
    }

    boolean prepare() {
        if (!this.isRunning()) {
            this.mAppTransitionState = 0;
            this.notifyAppTransitionPendingLocked();
            return true;
        }
        return false;
    }

    void goodToGo(AppWindowAnimator openingAppAnimator, AppWindowAnimator closingAppAnimator) {
        this.mNextAppTransition = -1;
        this.mAppTransitionState = 2;
        this.notifyAppTransitionStartingLocked(openingAppAnimator != null ? openingAppAnimator.mAppToken.token : null, closingAppAnimator != null ? closingAppAnimator.mAppToken.token : null, openingAppAnimator != null ? openingAppAnimator.animation : null, closingAppAnimator != null ? closingAppAnimator.animation : null);
    }

    void clear() {
        this.mNextAppTransitionType = 0;
        this.mNextAppTransitionPackage = null;
        this.mNextAppTransitionThumbnail = null;
    }

    void freeze() {
        this.setAppTransition(-1);
        this.clear();
        this.setReady();
        this.notifyAppTransitionCancelledLocked();
    }

    void registerListenerLocked(WindowManagerInternal.AppTransitionListener listener) {
        this.mListeners.add(listener);
    }

    public void notifyAppTransitionFinishedLocked(IBinder token) {
        for (int i = 0; i < this.mListeners.size(); ++i) {
            this.mListeners.get(i).onAppTransitionFinishedLocked(token);
        }
    }

    private void notifyAppTransitionPendingLocked() {
        for (int i = 0; i < this.mListeners.size(); ++i) {
            this.mListeners.get(i).onAppTransitionPendingLocked();
        }
    }

    private void notifyAppTransitionCancelledLocked() {
        for (int i = 0; i < this.mListeners.size(); ++i) {
            this.mListeners.get(i).onAppTransitionCancelledLocked();
        }
    }

    private void notifyAppTransitionStartingLocked(IBinder openToken, IBinder closeToken, Animation openAnimation, Animation closeAnimation) {
        for (int i = 0; i < this.mListeners.size(); ++i) {
            this.mListeners.get(i).onAppTransitionStartingLocked(openToken, closeToken, openAnimation, closeAnimation);
        }
    }

    private AttributeCache.Entry getCachedAnimations(WindowManager.LayoutParams lp) {
        if (lp != null && lp.windowAnimations != 0) {
            String packageName = lp.packageName != null ? lp.packageName : "android";
            int resId = lp.windowAnimations;
            if ((resId & 0xFF000000) == 0x1000000) {
                packageName = "android";
            }
            return AttributeCache.instance().get(packageName, resId, R.styleable.WindowAnimation, this.mCurrentUserId);
        }
        return null;
    }

    private AttributeCache.Entry getCachedAnimations(String packageName, int resId) {
        if (packageName != null) {
            if ((resId & 0xFF000000) == 0x1000000) {
                packageName = "android";
            }
            return AttributeCache.instance().get(packageName, resId, R.styleable.WindowAnimation, this.mCurrentUserId);
        }
        return null;
    }

    Animation loadAnimationAttr(WindowManager.LayoutParams lp, int animAttr) {
        AttributeCache.Entry ent;
        int anim2 = 0;
        Context context = this.mContext;
        if (animAttr >= 0 && (ent = this.getCachedAnimations(lp)) != null) {
            context = ent.context;
            anim2 = ent.array.getResourceId(animAttr, 0);
        }
        if (anim2 != 0) {
            return AnimationUtils.loadAnimation(context, anim2);
        }
        return null;
    }

    Animation loadAnimationRes(WindowManager.LayoutParams lp, int resId) {
        Context context = this.mContext;
        if (resId >= 0) {
            AttributeCache.Entry ent = this.getCachedAnimations(lp);
            if (ent != null) {
                context = ent.context;
            }
            return AnimationUtils.loadAnimation(context, resId);
        }
        return null;
    }

    private Animation loadAnimationRes(String packageName, int resId) {
        AttributeCache.Entry ent;
        int anim2 = 0;
        Context context = this.mContext;
        if (resId >= 0 && (ent = this.getCachedAnimations(packageName, resId)) != null) {
            context = ent.context;
            anim2 = resId;
        }
        if (anim2 != 0) {
            return AnimationUtils.loadAnimation(context, anim2);
        }
        return null;
    }

    private static float computePivot(int startPos, float finalScale) {
        float denom = finalScale - 1.0f;
        if (Math.abs(denom) < 1.0E-4f) {
            return startPos;
        }
        return (float)(-startPos) / denom;
    }

    private Animation createScaleUpAnimationLocked(int transit, boolean enter, int appWidth, int appHeight) {
        long duration;
        Animation a = null;
        if (enter) {
            float scaleW = (float)this.mNextAppTransitionStartWidth / (float)appWidth;
            float scaleH = (float)this.mNextAppTransitionStartHeight / (float)appHeight;
            ScaleAnimation scale = new ScaleAnimation(scaleW, 1.0f, scaleH, 1.0f, AppTransition.computePivot(this.mNextAppTransitionStartX, scaleW), AppTransition.computePivot(this.mNextAppTransitionStartY, scaleH));
            scale.setInterpolator(this.mDecelerateInterpolator);
            AlphaAnimation alpha = new AlphaAnimation(0.0f, 1.0f);
            alpha.setInterpolator(this.mThumbnailFadeOutInterpolator);
            AnimationSet set = new AnimationSet(false);
            set.addAnimation(scale);
            set.addAnimation(alpha);
            set.setDetachWallpaper(true);
            a = set;
        } else if (transit == 14 || transit == 15) {
            a = new AlphaAnimation(1.0f, 0.0f);
            a.setDetachWallpaper(true);
        } else {
            a = new AlphaAnimation(1.0f, 1.0f);
        }
        switch (transit) {
            case 6: 
            case 7: {
                duration = this.mConfigShortAnimTime;
                break;
            }
            default: {
                duration = 336L;
            }
        }
        a.setDuration(duration);
        a.setFillAfter(true);
        a.setInterpolator(this.mDecelerateInterpolator);
        a.initialize(appWidth, appHeight, appWidth, appHeight);
        return a;
    }

    private Animation createClipRevealAnimationLocked(int transit, boolean enter, Rect appFrame) {
        Animation anim2;
        if (enter) {
            int appWidth = appFrame.width();
            int appHeight = appFrame.height();
            float t = 0.0f;
            if (appHeight > 0) {
                t = (float)this.mNextAppTransitionStartY / (float)appHeight;
            }
            int translationY = this.mClipRevealTranslationY + (int)((float)appHeight / 7.0f * t);
            int centerX = this.mNextAppTransitionStartX + this.mNextAppTransitionStartWidth / 2;
            int centerY = this.mNextAppTransitionStartY + this.mNextAppTransitionStartHeight / 2;
            ClipRectLRAnimation clipAnimLR = new ClipRectLRAnimation(centerX - this.mNextAppTransitionStartWidth / 2, centerX + this.mNextAppTransitionStartWidth / 2, 0, appWidth);
            clipAnimLR.setInterpolator(this.mClipHorizontalInterpolator);
            clipAnimLR.setDuration(134L);
            ClipRectTBAnimation clipAnimTB = new ClipRectTBAnimation(centerY - this.mNextAppTransitionStartHeight / 2 - translationY, centerY + this.mNextAppTransitionStartHeight / 2 - translationY, 0, appHeight);
            clipAnimTB.setInterpolator(this.mTouchResponseInterpolator);
            clipAnimTB.setDuration(336L);
            TranslateYAnimation translateY = new TranslateYAnimation(0, (float)translationY, 0, 0.0f);
            translateY.setInterpolator(this.mLinearOutSlowInInterpolator);
            translateY.setDuration(336L);
            int alphaDuration = 84;
            AlphaAnimation alpha = new AlphaAnimation(0.5f, 1.0f);
            alpha.setDuration(84L);
            alpha.setInterpolator(this.mLinearOutSlowInInterpolator);
            AnimationSet set = new AnimationSet(false);
            set.addAnimation(clipAnimLR);
            set.addAnimation(clipAnimTB);
            set.addAnimation(translateY);
            set.addAnimation(alpha);
            set.setZAdjustment(1);
            set.initialize(appWidth, appHeight, appWidth, appHeight);
            anim2 = set;
        } else {
            long duration;
            switch (transit) {
                case 6: 
                case 7: {
                    duration = this.mConfigShortAnimTime;
                    break;
                }
                default: {
                    duration = 336L;
                }
            }
            if (transit == 14 || transit == 15) {
                anim2 = new AlphaAnimation(1.0f, 0.0f);
                anim2.setDetachWallpaper(true);
            } else {
                anim2 = new AlphaAnimation(1.0f, 1.0f);
            }
            anim2.setInterpolator(this.mDecelerateInterpolator);
            anim2.setDuration(duration);
            anim2.setFillAfter(true);
        }
        return anim2;
    }

    Animation prepareThumbnailAnimationWithDuration(Animation a, int appWidth, int appHeight, int duration, Interpolator interpolator2) {
        if (duration > 0) {
            a.setDuration(duration);
        }
        a.setFillAfter(true);
        a.setInterpolator(interpolator2);
        a.initialize(appWidth, appHeight, appWidth, appHeight);
        return a;
    }

    Animation prepareThumbnailAnimation(Animation a, int appWidth, int appHeight, int transit) {
        int duration;
        switch (transit) {
            case 6: 
            case 7: {
                duration = this.mConfigShortAnimTime;
                break;
            }
            default: {
                duration = 336;
            }
        }
        return this.prepareThumbnailAnimationWithDuration(a, appWidth, appHeight, duration, this.mDecelerateInterpolator);
    }

    int getThumbnailTransitionState(boolean enter) {
        if (enter) {
            if (this.mNextAppTransitionScaleUp) {
                return 0;
            }
            return 2;
        }
        if (this.mNextAppTransitionScaleUp) {
            return 1;
        }
        return 3;
    }

    Animation createThumbnailAspectScaleAnimationLocked(int appWidth, int appHeight, int deviceWidth, int transit) {
        AnimationSet a;
        int thumbWidthI = this.mNextAppTransitionThumbnail.getWidth();
        float thumbWidth = thumbWidthI > 0 ? (float)thumbWidthI : 1.0f;
        int thumbHeightI = this.mNextAppTransitionThumbnail.getHeight();
        float thumbHeight = thumbHeightI > 0 ? (float)thumbHeightI : 1.0f;
        float scaleW = (float)deviceWidth / thumbWidth;
        float unscaledWidth = deviceWidth;
        float unscaledHeight = thumbHeight * scaleW;
        float unscaledStartY = (float)this.mNextAppTransitionStartY - (unscaledHeight - thumbHeight) / 2.0f;
        if (this.mNextAppTransitionScaleUp) {
            ScaleAnimation scale = new ScaleAnimation(1.0f, scaleW, 1.0f, scaleW, (float)this.mNextAppTransitionStartX + thumbWidth / 2.0f, (float)this.mNextAppTransitionStartY + thumbHeight / 2.0f);
            scale.setInterpolator(this.mTouchResponseInterpolator);
            scale.setDuration(336L);
            AlphaAnimation alpha = new AlphaAnimation(1.0f, 0.0f);
            alpha.setInterpolator(this.mThumbnailFadeOutInterpolator);
            alpha.setDuration(336L);
            TranslateAnimation translate = new TranslateAnimation(0.0f, 0.0f, 0.0f, -unscaledStartY + (float)this.mNextAppTransitionInsets.top);
            translate.setInterpolator(this.mTouchResponseInterpolator);
            translate.setDuration(336L);
            AnimationSet set = new AnimationSet(false);
            set.addAnimation(scale);
            set.addAnimation(alpha);
            set.addAnimation(translate);
            a = set;
        } else {
            ScaleAnimation scale = new ScaleAnimation(scaleW, 1.0f, scaleW, 1.0f, (float)this.mNextAppTransitionStartX + thumbWidth / 2.0f, (float)this.mNextAppTransitionStartY + thumbHeight / 2.0f);
            scale.setInterpolator(this.mTouchResponseInterpolator);
            scale.setDuration(336L);
            AlphaAnimation alpha = new AlphaAnimation(0.0f, 1.0f);
            alpha.setInterpolator(this.mThumbnailFadeInInterpolator);
            alpha.setDuration(336L);
            TranslateAnimation translate = new TranslateAnimation(0.0f, 0.0f, -unscaledStartY + (float)this.mNextAppTransitionInsets.top, 0.0f);
            translate.setInterpolator(this.mTouchResponseInterpolator);
            translate.setDuration(336L);
            AnimationSet set = new AnimationSet(false);
            set.addAnimation(scale);
            set.addAnimation(alpha);
            set.addAnimation(translate);
            a = set;
        }
        return this.prepareThumbnailAnimationWithDuration(a, appWidth, appHeight, 0, this.mTouchResponseInterpolator);
    }

    Animation createAspectScaledThumbnailEnterExitAnimationLocked(int thumbTransitState, int appWidth, int appHeight, int orientation, int transit, Rect containingFrame, Rect contentInsets) {
        Animation a;
        int thumbWidthI = this.mNextAppTransitionStartWidth;
        float thumbWidth = thumbWidthI > 0 ? (float)thumbWidthI : 1.0f;
        int thumbHeightI = this.mNextAppTransitionStartHeight;
        float thumbHeight = thumbHeightI > 0 ? (float)thumbHeightI : 1.0f;
        float scale = 1.0f;
        int scaledTopDecor = 0;
        switch (thumbTransitState) {
            case 0: {
                if (orientation == 1) {
                    scale = thumbWidth / (float)appWidth;
                    scaledTopDecor = (int)(scale * (float)contentInsets.top);
                    int unscaledThumbHeight = (int)(thumbHeight / scale);
                    this.mTmpFromClipRect.set(containingFrame);
                    this.mTmpFromClipRect.bottom = this.mTmpFromClipRect.top + unscaledThumbHeight;
                    this.mTmpToClipRect.set(containingFrame);
                } else {
                    scale = thumbHeight / (float)(appHeight - contentInsets.top);
                    scaledTopDecor = (int)(scale * (float)contentInsets.top);
                    int unscaledThumbWidth = (int)(thumbWidth / scale);
                    this.mTmpFromClipRect.set(containingFrame);
                    this.mTmpFromClipRect.right = this.mTmpFromClipRect.left + unscaledThumbWidth;
                    this.mTmpToClipRect.set(containingFrame);
                }
                this.mTmpFromClipRect.top = contentInsets.top;
                this.mNextAppTransitionInsets.set(contentInsets);
                ScaleAnimation scaleAnim = new ScaleAnimation(scale, 1.0f, scale, 1.0f, AppTransition.computePivot(this.mNextAppTransitionStartX, scale), AppTransition.computePivot(this.mNextAppTransitionStartY, scale));
                ClipRectAnimation clipAnim = new ClipRectAnimation(this.mTmpFromClipRect, this.mTmpToClipRect);
                TranslateAnimation translateAnim = new TranslateAnimation(0.0f, 0.0f, -scaledTopDecor, 0.0f);
                AnimationSet set = new AnimationSet(true);
                set.addAnimation(clipAnim);
                set.addAnimation(scaleAnim);
                set.addAnimation(translateAnim);
                a = set;
                break;
            }
            case 1: {
                if (transit == 14) {
                    a = new AlphaAnimation(1.0f, 0.0f);
                    break;
                }
                a = new AlphaAnimation(1.0f, 1.0f);
                break;
            }
            case 2: {
                if (transit == 14) {
                    a = new AlphaAnimation(0.0f, 1.0f);
                    break;
                }
                a = new AlphaAnimation(1.0f, 1.0f);
                break;
            }
            case 3: {
                if (orientation == 1) {
                    scale = thumbWidth / (float)appWidth;
                    scaledTopDecor = (int)(scale * (float)contentInsets.top);
                    int unscaledThumbHeight = (int)(thumbHeight / scale);
                    this.mTmpFromClipRect.set(containingFrame);
                    this.mTmpToClipRect.set(containingFrame);
                    this.mTmpToClipRect.bottom = this.mTmpToClipRect.top + unscaledThumbHeight;
                } else {
                    scale = thumbHeight / (float)(appHeight - contentInsets.top);
                    scaledTopDecor = (int)(scale * (float)contentInsets.top);
                    int unscaledThumbWidth = (int)(thumbWidth / scale);
                    this.mTmpFromClipRect.set(containingFrame);
                    this.mTmpToClipRect.set(containingFrame);
                    this.mTmpToClipRect.right = this.mTmpToClipRect.left + unscaledThumbWidth;
                }
                this.mTmpToClipRect.top = contentInsets.top;
                this.mNextAppTransitionInsets.set(contentInsets);
                ScaleAnimation scaleAnim = new ScaleAnimation(1.0f, scale, 1.0f, scale, AppTransition.computePivot(this.mNextAppTransitionStartX, scale), AppTransition.computePivot(this.mNextAppTransitionStartY, scale));
                ClipRectAnimation clipAnim = new ClipRectAnimation(this.mTmpFromClipRect, this.mTmpToClipRect);
                TranslateAnimation translateAnim = new TranslateAnimation(0.0f, 0.0f, 0.0f, -scaledTopDecor);
                AnimationSet set = new AnimationSet(true);
                set.addAnimation(clipAnim);
                set.addAnimation(scaleAnim);
                set.addAnimation(translateAnim);
                a = set;
                a.setZAdjustment(1);
                break;
            }
            default: {
                throw new RuntimeException("Invalid thumbnail transition state");
            }
        }
        int duration = Math.max(336, 336);
        return this.prepareThumbnailAnimationWithDuration(a, appWidth, appHeight, duration, this.mTouchResponseInterpolator);
    }

    Animation createThumbnailScaleAnimationLocked(int appWidth, int appHeight, int transit) {
        Animation a;
        float thumbHeight;
        int thumbWidthI = this.mNextAppTransitionThumbnail.getWidth();
        float thumbWidth = thumbWidthI > 0 ? (float)thumbWidthI : 1.0f;
        int thumbHeightI = this.mNextAppTransitionThumbnail.getHeight();
        float f = thumbHeight = thumbHeightI > 0 ? (float)thumbHeightI : 1.0f;
        if (this.mNextAppTransitionScaleUp) {
            float scaleW = (float)appWidth / thumbWidth;
            float scaleH = (float)appHeight / thumbHeight;
            ScaleAnimation scale = new ScaleAnimation(1.0f, scaleW, 1.0f, scaleH, AppTransition.computePivot(this.mNextAppTransitionStartX, 1.0f / scaleW), AppTransition.computePivot(this.mNextAppTransitionStartY, 1.0f / scaleH));
            scale.setInterpolator(this.mDecelerateInterpolator);
            AlphaAnimation alpha = new AlphaAnimation(1.0f, 0.0f);
            alpha.setInterpolator(this.mThumbnailFadeOutInterpolator);
            AnimationSet set = new AnimationSet(false);
            set.addAnimation(scale);
            set.addAnimation(alpha);
            a = set;
        } else {
            float scaleW = (float)appWidth / thumbWidth;
            float scaleH = (float)appHeight / thumbHeight;
            a = new ScaleAnimation(scaleW, 1.0f, scaleH, 1.0f, AppTransition.computePivot(this.mNextAppTransitionStartX, 1.0f / scaleW), AppTransition.computePivot(this.mNextAppTransitionStartY, 1.0f / scaleH));
        }
        return this.prepareThumbnailAnimation(a, appWidth, appHeight, transit);
    }

    Animation createThumbnailEnterExitAnimationLocked(int thumbTransitState, int appWidth, int appHeight, int transit) {
        Animation a;
        int thumbWidthI = this.mNextAppTransitionThumbnail.getWidth();
        float thumbWidth = thumbWidthI > 0 ? (float)thumbWidthI : 1.0f;
        int thumbHeightI = this.mNextAppTransitionThumbnail.getHeight();
        float thumbHeight = thumbHeightI > 0 ? (float)thumbHeightI : 1.0f;
        switch (thumbTransitState) {
            case 0: {
                float scaleW = thumbWidth / (float)appWidth;
                float scaleH = thumbHeight / (float)appHeight;
                a = new ScaleAnimation(scaleW, 1.0f, scaleH, 1.0f, AppTransition.computePivot(this.mNextAppTransitionStartX, scaleW), AppTransition.computePivot(this.mNextAppTransitionStartY, scaleH));
                break;
            }
            case 1: {
                if (transit == 14) {
                    a = new AlphaAnimation(1.0f, 0.0f);
                    break;
                }
                a = new AlphaAnimation(1.0f, 1.0f);
                break;
            }
            case 2: {
                a = new AlphaAnimation(1.0f, 1.0f);
                break;
            }
            case 3: {
                float scaleW = thumbWidth / (float)appWidth;
                float scaleH = thumbHeight / (float)appHeight;
                ScaleAnimation scale = new ScaleAnimation(1.0f, scaleW, 1.0f, scaleH, AppTransition.computePivot(this.mNextAppTransitionStartX, scaleW), AppTransition.computePivot(this.mNextAppTransitionStartY, scaleH));
                AlphaAnimation alpha = new AlphaAnimation(1.0f, 0.0f);
                AnimationSet set = new AnimationSet(true);
                set.addAnimation(scale);
                set.addAnimation(alpha);
                set.setZAdjustment(1);
                a = set;
                break;
            }
            default: {
                throw new RuntimeException("Invalid thumbnail transition state");
            }
        }
        return this.prepareThumbnailAnimation(a, appWidth, appHeight, transit);
    }

    boolean canSkipFirstFrame() {
        return this.mNextAppTransitionType != 1 && this.mNextAppTransitionType != 7 && this.mNextAppTransitionType != 8;
    }

    Animation loadAnimation(WindowManager.LayoutParams lp, int transit, boolean enter, int appWidth, int appHeight, int orientation, Rect containingFrame, Rect contentInsets, Rect appFrame, boolean isVoiceInteraction) {
        Animation a;
        if (isVoiceInteraction && (transit == 6 || transit == 8 || transit == 10)) {
            a = this.loadAnimationRes(lp, enter ? 17432702 : 17432703);
        } else if (isVoiceInteraction && (transit == 7 || transit == 9 || transit == 11)) {
            a = this.loadAnimationRes(lp, enter ? 17432700 : 17432701);
        } else if (this.mNextAppTransitionType == 1) {
            a = this.loadAnimationRes(this.mNextAppTransitionPackage, enter ? this.mNextAppTransitionEnter : this.mNextAppTransitionExit);
        } else if (this.mNextAppTransitionType == 7) {
            a = this.loadAnimationRes(this.mNextAppTransitionPackage, this.mNextAppTransitionInPlace);
        } else if (this.mNextAppTransitionType == 8) {
            a = this.createClipRevealAnimationLocked(transit, enter, appFrame);
        } else if (this.mNextAppTransitionType == 2) {
            a = this.createScaleUpAnimationLocked(transit, enter, appWidth, appHeight);
        } else if (this.mNextAppTransitionType == 3 || this.mNextAppTransitionType == 4) {
            this.mNextAppTransitionScaleUp = this.mNextAppTransitionType == 3;
            a = this.createThumbnailEnterExitAnimationLocked(this.getThumbnailTransitionState(enter), appWidth, appHeight, transit);
        } else if (this.mNextAppTransitionType == 5 || this.mNextAppTransitionType == 6) {
            this.mNextAppTransitionScaleUp = this.mNextAppTransitionType == 5;
            a = this.createAspectScaledThumbnailEnterExitAnimationLocked(this.getThumbnailTransitionState(enter), appWidth, appHeight, orientation, transit, containingFrame, contentInsets);
        } else {
            int animAttr = 0;
            switch (transit) {
                case 6: {
                    animAttr = enter ? 4 : 5;
                    break;
                }
                case 7: {
                    animAttr = enter ? 6 : 7;
                    break;
                }
                case 8: {
                    animAttr = enter ? 8 : 9;
                    break;
                }
                case 9: {
                    animAttr = enter ? 10 : 11;
                    break;
                }
                case 10: {
                    animAttr = enter ? 12 : 13;
                    break;
                }
                case 11: {
                    animAttr = enter ? 14 : 15;
                    break;
                }
                case 13: {
                    animAttr = enter ? 16 : 17;
                    break;
                }
                case 12: {
                    animAttr = enter ? 18 : 19;
                    break;
                }
                case 14: {
                    animAttr = enter ? 20 : 21;
                    break;
                }
                case 15: {
                    animAttr = enter ? 22 : 23;
                    break;
                }
                case 16: {
                    animAttr = enter ? 25 : 24;
                }
            }
            a = animAttr != 0 ? this.loadAnimationAttr(lp, animAttr) : null;
        }
        return a;
    }

    void postAnimationCallback() {
        if (this.mNextAppTransitionCallback != null) {
            this.mH.sendMessage(this.mH.obtainMessage(26, this.mNextAppTransitionCallback));
            this.mNextAppTransitionCallback = null;
        }
    }

    void overridePendingAppTransition(String packageName, int enterAnim, int exitAnim, IRemoteCallback startedCallback) {
        if (this.isTransitionSet()) {
            this.mNextAppTransitionType = 1;
            this.mNextAppTransitionPackage = packageName;
            this.mNextAppTransitionThumbnail = null;
            this.mNextAppTransitionEnter = enterAnim;
            this.mNextAppTransitionExit = exitAnim;
            this.postAnimationCallback();
            this.mNextAppTransitionCallback = startedCallback;
        } else {
            this.postAnimationCallback();
        }
    }

    void overridePendingAppTransitionScaleUp(int startX, int startY, int startWidth, int startHeight) {
        if (this.isTransitionSet()) {
            this.mNextAppTransitionType = 2;
            this.mNextAppTransitionPackage = null;
            this.mNextAppTransitionThumbnail = null;
            this.mNextAppTransitionStartX = startX;
            this.mNextAppTransitionStartY = startY;
            this.mNextAppTransitionStartWidth = startWidth;
            this.mNextAppTransitionStartHeight = startHeight;
            this.postAnimationCallback();
            this.mNextAppTransitionCallback = null;
        }
    }

    void overridePendingAppTransitionClipReveal(int startX, int startY, int startWidth, int startHeight) {
        if (this.isTransitionSet()) {
            this.mNextAppTransitionType = 8;
            this.mNextAppTransitionStartX = startX;
            this.mNextAppTransitionStartY = startY;
            this.mNextAppTransitionStartWidth = startWidth;
            this.mNextAppTransitionStartHeight = startHeight;
            this.postAnimationCallback();
            this.mNextAppTransitionCallback = null;
        }
    }

    void overridePendingAppTransitionThumb(Bitmap srcThumb, int startX, int startY, IRemoteCallback startedCallback, boolean scaleUp) {
        if (this.isTransitionSet()) {
            this.mNextAppTransitionType = scaleUp ? 3 : 4;
            this.mNextAppTransitionPackage = null;
            this.mNextAppTransitionThumbnail = srcThumb;
            this.mNextAppTransitionScaleUp = scaleUp;
            this.mNextAppTransitionStartX = startX;
            this.mNextAppTransitionStartY = startY;
            this.postAnimationCallback();
            this.mNextAppTransitionCallback = startedCallback;
        } else {
            this.postAnimationCallback();
        }
    }

    void overridePendingAppTransitionAspectScaledThumb(Bitmap srcThumb, int startX, int startY, int targetWidth, int targetHeight, IRemoteCallback startedCallback, boolean scaleUp) {
        if (this.isTransitionSet()) {
            this.mNextAppTransitionType = scaleUp ? 5 : 6;
            this.mNextAppTransitionPackage = null;
            this.mNextAppTransitionThumbnail = srcThumb;
            this.mNextAppTransitionScaleUp = scaleUp;
            this.mNextAppTransitionStartX = startX;
            this.mNextAppTransitionStartY = startY;
            this.mNextAppTransitionStartWidth = targetWidth;
            this.mNextAppTransitionStartHeight = targetHeight;
            this.postAnimationCallback();
            this.mNextAppTransitionCallback = startedCallback;
        } else {
            this.postAnimationCallback();
        }
    }

    void overrideInPlaceAppTransition(String packageName, int anim2) {
        if (this.isTransitionSet()) {
            this.mNextAppTransitionType = 7;
            this.mNextAppTransitionPackage = packageName;
            this.mNextAppTransitionInPlace = anim2;
        } else {
            this.postAnimationCallback();
        }
    }

    public String toString() {
        return "mNextAppTransition=" + AppTransition.appTransitionToString(this.mNextAppTransition);
    }

    public static String appTransitionToString(int transition2) {
        switch (transition2) {
            case -1: {
                return "TRANSIT_UNSET";
            }
            case 0: {
                return "TRANSIT_NONE";
            }
            case 6: {
                return "TRANSIT_ACTIVITY_OPEN";
            }
            case 7: {
                return "TRANSIT_ACTIVITY_CLOSE";
            }
            case 8: {
                return "TRANSIT_TASK_OPEN";
            }
            case 9: {
                return "TRANSIT_TASK_CLOSE";
            }
            case 10: {
                return "TRANSIT_TASK_TO_FRONT";
            }
            case 11: {
                return "TRANSIT_TASK_TO_BACK";
            }
            case 12: {
                return "TRANSIT_WALLPAPER_CLOSE";
            }
            case 13: {
                return "TRANSIT_WALLPAPER_OPEN";
            }
            case 14: {
                return "TRANSIT_WALLPAPER_INTRA_OPEN";
            }
            case 15: {
                return "TRANSIT_WALLPAPER_INTRA_CLOSE";
            }
            case 16: {
                return "TRANSIT_TASK_OPEN_BEHIND";
            }
        }
        return "<UNKNOWN>";
    }

    private String appStateToString() {
        switch (this.mAppTransitionState) {
            case 0: {
                return "APP_STATE_IDLE";
            }
            case 1: {
                return "APP_STATE_READY";
            }
            case 2: {
                return "APP_STATE_RUNNING";
            }
            case 3: {
                return "APP_STATE_TIMEOUT";
            }
        }
        return "unknown state=" + this.mAppTransitionState;
    }

    private String transitTypeToString() {
        switch (this.mNextAppTransitionType) {
            case 0: {
                return "NEXT_TRANSIT_TYPE_NONE";
            }
            case 1: {
                return "NEXT_TRANSIT_TYPE_CUSTOM";
            }
            case 7: {
                return "NEXT_TRANSIT_TYPE_CUSTOM_IN_PLACE";
            }
            case 2: {
                return "NEXT_TRANSIT_TYPE_SCALE_UP";
            }
            case 3: {
                return "NEXT_TRANSIT_TYPE_THUMBNAIL_SCALE_UP";
            }
            case 4: {
                return "NEXT_TRANSIT_TYPE_THUMBNAIL_SCALE_DOWN";
            }
            case 5: {
                return "NEXT_TRANSIT_TYPE_THUMBNAIL_ASPECT_SCALE_UP";
            }
            case 6: {
                return "NEXT_TRANSIT_TYPE_THUMBNAIL_ASPECT_SCALE_DOWN";
            }
        }
        return "unknown type=" + this.mNextAppTransitionType;
    }

    @Override
    public void dump(PrintWriter pw, String prefix) {
        pw.print(prefix);
        pw.println(this);
        pw.print(prefix);
        pw.print("mAppTransitionState=");
        pw.println(this.appStateToString());
        if (this.mNextAppTransitionType != 0) {
            pw.print(prefix);
            pw.print("mNextAppTransitionType=");
            pw.println(this.transitTypeToString());
        }
        switch (this.mNextAppTransitionType) {
            case 1: {
                pw.print(prefix);
                pw.print("mNextAppTransitionPackage=");
                pw.println(this.mNextAppTransitionPackage);
                pw.print(prefix);
                pw.print("mNextAppTransitionEnter=0x");
                pw.print(Integer.toHexString(this.mNextAppTransitionEnter));
                pw.print(" mNextAppTransitionExit=0x");
                pw.println(Integer.toHexString(this.mNextAppTransitionExit));
                break;
            }
            case 7: {
                pw.print(prefix);
                pw.print("mNextAppTransitionPackage=");
                pw.println(this.mNextAppTransitionPackage);
                pw.print(prefix);
                pw.print("mNextAppTransitionInPlace=0x");
                pw.print(Integer.toHexString(this.mNextAppTransitionInPlace));
                break;
            }
            case 2: {
                pw.print(prefix);
                pw.print("mNextAppTransitionStartX=");
                pw.print(this.mNextAppTransitionStartX);
                pw.print(" mNextAppTransitionStartY=");
                pw.println(this.mNextAppTransitionStartY);
                pw.print(prefix);
                pw.print("mNextAppTransitionStartWidth=");
                pw.print(this.mNextAppTransitionStartWidth);
                pw.print(" mNextAppTransitionStartHeight=");
                pw.println(this.mNextAppTransitionStartHeight);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                pw.print(prefix);
                pw.print("mNextAppTransitionThumbnail=");
                pw.print(this.mNextAppTransitionThumbnail);
                pw.print(" mNextAppTransitionStartX=");
                pw.print(this.mNextAppTransitionStartX);
                pw.print(" mNextAppTransitionStartY=");
                pw.println(this.mNextAppTransitionStartY);
                pw.print(prefix);
                pw.print("mNextAppTransitionStartWidth=");
                pw.print(this.mNextAppTransitionStartWidth);
                pw.print(" mNextAppTransitionStartHeight=");
                pw.println(this.mNextAppTransitionStartHeight);
                pw.print(prefix);
                pw.print("mNextAppTransitionScaleUp=");
                pw.println(this.mNextAppTransitionScaleUp);
            }
        }
        if (this.mNextAppTransitionCallback != null) {
            pw.print(prefix);
            pw.print("mNextAppTransitionCallback=");
            pw.println(this.mNextAppTransitionCallback);
        }
    }

    public void setCurrentUser(int newUserId) {
        this.mCurrentUserId = newUserId;
    }
}

