/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.graphics.Rect;
import android.os.Environment;
import android.util.AtomicFile;
import android.util.Slog;
import android.util.Xml;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.XmlUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class DisplaySettings {
    private static final String TAG = "WindowManager";
    private final AtomicFile mFile;
    private final HashMap<String, Entry> mEntries = new HashMap();

    public DisplaySettings() {
        File dataDir = Environment.getDataDirectory();
        File systemDir = new File(dataDir, "system");
        this.mFile = new AtomicFile(new File(systemDir, "display_settings.xml"));
    }

    public void getOverscanLocked(String name, String uniqueId, Rect outRect) {
        Entry entry;
        if (uniqueId == null || (entry = this.mEntries.get(uniqueId)) == null) {
            entry = this.mEntries.get(name);
        }
        if (entry != null) {
            outRect.left = entry.overscanLeft;
            outRect.top = entry.overscanTop;
            outRect.right = entry.overscanRight;
            outRect.bottom = entry.overscanBottom;
        } else {
            outRect.set(0, 0, 0, 0);
        }
    }

    public void setOverscanLocked(String name, int left, int top, int right, int bottom) {
        if (left == 0 && top == 0 && right == 0 && bottom == 0) {
            this.mEntries.remove(name);
            return;
        }
        Entry entry = this.mEntries.get(name);
        if (entry == null) {
            entry = new Entry(name);
            this.mEntries.put(name, entry);
        }
        entry.overscanLeft = left;
        entry.overscanTop = top;
        entry.overscanRight = right;
        entry.overscanBottom = bottom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readSettingsLocked() {
        FileInputStream stream;
        try {
            stream = this.mFile.openRead();
        }
        catch (FileNotFoundException e) {
            Slog.i(TAG, "No existing display settings " + this.mFile.getBaseFile() + "; starting empty");
            return;
        }
        boolean success = false;
        try {
            int type;
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(stream, StandardCharsets.UTF_8.name());
            while ((type = parser.next()) != 2 && type != 1) {
            }
            if (type != 2) {
                throw new IllegalStateException("no start tag found");
            }
            int outerDepth = parser.getDepth();
            while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                if (type == 3 || type == 4) continue;
                String tagName = parser.getName();
                if (tagName.equals("display")) {
                    this.readDisplay(parser);
                    continue;
                }
                Slog.w(TAG, "Unknown element under <display-settings>: " + parser.getName());
                XmlUtils.skipCurrentTag(parser);
            }
            success = true;
        }
        catch (IllegalStateException e) {
            Slog.w(TAG, "Failed parsing " + e);
        }
        catch (NullPointerException e) {
            Slog.w(TAG, "Failed parsing " + e);
        }
        catch (NumberFormatException e) {
            Slog.w(TAG, "Failed parsing " + e);
        }
        catch (XmlPullParserException e) {
            Slog.w(TAG, "Failed parsing " + e);
        }
        catch (IOException e) {
            Slog.w(TAG, "Failed parsing " + e);
        }
        catch (IndexOutOfBoundsException e) {
            Slog.w(TAG, "Failed parsing " + e);
        }
        finally {
            if (!success) {
                this.mEntries.clear();
            }
            try {
                stream.close();
            }
            catch (IOException e) {}
        }
    }

    private int getIntAttribute(XmlPullParser parser, String name) {
        try {
            String str = parser.getAttributeValue(null, name);
            return str != null ? Integer.parseInt(str) : 0;
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private void readDisplay(XmlPullParser parser) throws NumberFormatException, XmlPullParserException, IOException {
        String name = parser.getAttributeValue(null, "name");
        if (name != null) {
            Entry entry = new Entry(name);
            entry.overscanLeft = this.getIntAttribute(parser, "overscanLeft");
            entry.overscanTop = this.getIntAttribute(parser, "overscanTop");
            entry.overscanRight = this.getIntAttribute(parser, "overscanRight");
            entry.overscanBottom = this.getIntAttribute(parser, "overscanBottom");
            this.mEntries.put(name, entry);
        }
        XmlUtils.skipCurrentTag(parser);
    }

    public void writeSettingsLocked() {
        FileOutputStream stream;
        try {
            stream = this.mFile.startWrite();
        }
        catch (IOException e) {
            Slog.w(TAG, "Failed to write display settings: " + e);
            return;
        }
        try {
            FastXmlSerializer out = new FastXmlSerializer();
            out.setOutput(stream, StandardCharsets.UTF_8.name());
            out.startDocument(null, true);
            out.startTag(null, "display-settings");
            for (Entry entry : this.mEntries.values()) {
                out.startTag(null, "display");
                out.attribute(null, "name", entry.name);
                if (entry.overscanLeft != 0) {
                    out.attribute(null, "overscanLeft", Integer.toString(entry.overscanLeft));
                }
                if (entry.overscanTop != 0) {
                    out.attribute(null, "overscanTop", Integer.toString(entry.overscanTop));
                }
                if (entry.overscanRight != 0) {
                    out.attribute(null, "overscanRight", Integer.toString(entry.overscanRight));
                }
                if (entry.overscanBottom != 0) {
                    out.attribute(null, "overscanBottom", Integer.toString(entry.overscanBottom));
                }
                out.endTag(null, "display");
            }
            out.endTag(null, "display-settings");
            out.endDocument();
            this.mFile.finishWrite(stream);
        }
        catch (IOException e) {
            Slog.w(TAG, "Failed to write display settings, restoring backup.", e);
            this.mFile.failWrite(stream);
        }
    }

    public static class Entry {
        public final String name;
        public int overscanLeft;
        public int overscanTop;
        public int overscanRight;
        public int overscanBottom;

        public Entry(String _name) {
            this.name = _name;
        }
    }
}

