/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.Slog;
import android.view.Display;
import android.view.Surface;
import android.view.SurfaceControl;
import android.view.SurfaceSession;
import com.android.server.wm.TaskStack;

class FocusedStackFrame {
    private static final String TAG = "FocusedStackFrame";
    private static final boolean DEBUG = false;
    private static final int THICKNESS = 2;
    private static final float ALPHA = 0.3f;
    private final SurfaceControl mSurfaceControl;
    private final Surface mSurface = new Surface();
    private final Paint mInnerPaint = new Paint();
    private final Paint mOuterPaint = new Paint();
    private final Rect mBounds = new Rect();
    private final Rect mLastBounds = new Rect();
    private int mLayer = -1;

    public FocusedStackFrame(Display display, SurfaceSession session) {
        SurfaceControl ctrl = null;
        try {
            ctrl = new SurfaceControl(session, TAG, 1, 1, -3, 4);
            ctrl.setLayerStack(display.getLayerStack());
            ctrl.setAlpha(0.3f);
            this.mSurface.copyFrom(ctrl);
        }
        catch (Surface.OutOfResourcesException e) {
            // empty catch block
        }
        this.mSurfaceControl = ctrl;
        this.mInnerPaint.setStyle(Paint.Style.STROKE);
        this.mInnerPaint.setStrokeWidth(2.0f);
        this.mInnerPaint.setColor(-1);
        this.mOuterPaint.setStyle(Paint.Style.STROKE);
        this.mOuterPaint.setStrokeWidth(2.0f);
        this.mOuterPaint.setColor(-16777216);
    }

    private void draw() {
        if (this.mLastBounds.isEmpty()) {
            this.mLastBounds.set(this.mBounds);
        }
        Canvas c = null;
        try {
            c = this.mSurface.lockCanvas(this.mLastBounds);
        }
        catch (IllegalArgumentException e) {
            Slog.e(TAG, "Unable to lock canvas", e);
        }
        catch (Surface.OutOfResourcesException e) {
            Slog.e(TAG, "Unable to lock canvas", e);
        }
        if (c == null) {
            return;
        }
        c.drawRect(0.0f, 0.0f, this.mBounds.width(), this.mBounds.height(), this.mOuterPaint);
        c.drawRect(2.0f, 2.0f, this.mBounds.width() - 2, this.mBounds.height() - 2, this.mInnerPaint);
        this.mSurface.unlockCanvasAndPost(c);
        this.mLastBounds.set(this.mBounds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupSurface(boolean visible) {
        if (this.mSurfaceControl == null) {
            return;
        }
        SurfaceControl.openTransaction();
        try {
            if (visible) {
                this.mSurfaceControl.setPosition(this.mBounds.left, this.mBounds.top);
                this.mSurfaceControl.setSize(this.mBounds.width(), this.mBounds.height());
                this.mSurfaceControl.show();
            } else {
                this.mSurfaceControl.hide();
            }
        }
        finally {
            SurfaceControl.closeTransaction();
        }
    }

    void setVisibility(TaskStack stack) {
        if (stack == null || stack.isFullscreen()) {
            this.setupSurface(false);
        } else {
            stack.getBounds(this.mBounds);
            this.setupSurface(true);
            if (!this.mBounds.equals(this.mLastBounds)) {
                this.draw();
            }
        }
    }

    void setLayer(int layer) {
        if (this.mLayer == layer) {
            return;
        }
        this.mLayer = layer;
        this.mSurfaceControl.setLayer(this.mLayer);
    }
}

