/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.util.EventLog;
import com.android.server.wm.AppTokenList;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.TaskStack;
import com.android.server.wm.WindowManagerService;

class Task {
    TaskStack mStack;
    final AppTokenList mAppTokens = new AppTokenList();
    final int mTaskId;
    final int mUserId;
    boolean mDeferRemoval = false;
    final WindowManagerService mService;

    Task(int taskId, TaskStack stack, int userId, WindowManagerService service) {
        this.mTaskId = taskId;
        this.mStack = stack;
        this.mUserId = userId;
        this.mService = service;
    }

    DisplayContent getDisplayContent() {
        return this.mStack.getDisplayContent();
    }

    void addAppToken(int addPos, AppWindowToken wtoken) {
        int lastPos = this.mAppTokens.size();
        if (addPos >= lastPos) {
            addPos = lastPos;
        } else {
            for (int pos = 0; pos < lastPos && pos < addPos; ++pos) {
                if (!((AppWindowToken)this.mAppTokens.get((int)pos)).removed) continue;
                ++addPos;
            }
        }
        this.mAppTokens.add(addPos, wtoken);
        wtoken.mTask = this;
        this.mDeferRemoval = false;
    }

    void removeLocked() {
        if (!this.mAppTokens.isEmpty() && this.mStack.isAnimating()) {
            this.mDeferRemoval = true;
            return;
        }
        EventLog.writeEvent(31003, this.mTaskId, "removeTask");
        this.mDeferRemoval = false;
        this.mStack.removeTask(this);
        this.mService.mTaskIdToTask.delete(this.mTaskId);
    }

    void moveTaskToStack(TaskStack stack, boolean toTop) {
        if (stack == this.mStack) {
            return;
        }
        EventLog.writeEvent(31003, this.mTaskId, "moveTask");
        if (this.mStack != null) {
            this.mStack.removeTask(this);
        }
        stack.addTask(this, toTop);
    }

    boolean removeAppToken(AppWindowToken wtoken) {
        boolean removed = this.mAppTokens.remove(wtoken);
        if (this.mAppTokens.size() == 0) {
            EventLog.writeEvent(31003, this.mTaskId, "removeAppToken: last token");
            if (this.mDeferRemoval) {
                this.removeLocked();
            }
        }
        wtoken.mTask = null;
        return removed;
    }

    void setSendingToBottom(boolean toBottom) {
        for (int appTokenNdx = 0; appTokenNdx < this.mAppTokens.size(); ++appTokenNdx) {
            ((AppWindowToken)this.mAppTokens.get((int)appTokenNdx)).sendingToBottom = toBottom;
        }
    }

    boolean showForAllUsers() {
        int tokensCount = this.mAppTokens.size();
        return tokensCount != 0 && ((AppWindowToken)this.mAppTokens.get((int)(tokensCount - 1))).showForAllUsers;
    }

    public String toString() {
        return "{taskId=" + this.mTaskId + " appTokens=" + this.mAppTokens + " mdr=" + this.mDeferRemoval + "}";
    }
}

