/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.content.res.Configuration;
import android.graphics.Rect;
import android.util.EventLog;
import android.util.TypedValue;
import com.android.server.wm.AppTokenList;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.DimLayer;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.Task;
import com.android.server.wm.WindowList;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowState;
import com.android.server.wm.WindowStateAnimator;
import com.android.server.wm.WindowToken;
import java.io.PrintWriter;
import java.util.ArrayList;

public class TaskStack {
    private static final int DEFAULT_DIM_DURATION = 200;
    final int mStackId;
    private final WindowManagerService mService;
    private DisplayContent mDisplayContent;
    private final ArrayList<Task> mTasks = new ArrayList();
    private Rect mTmpRect = new Rect();
    private Rect mTmpRect2 = new Rect();
    private Rect mBounds = new Rect();
    private boolean mFullscreen = true;
    private DimLayer mDimLayer;
    WindowStateAnimator mDimWinAnimator;
    DimLayer mAnimationBackgroundSurface;
    WindowStateAnimator mAnimationBackgroundAnimator;
    boolean mDimmingTag;
    final AppTokenList mExitingAppTokens = new AppTokenList();
    boolean mDeferDetach;
    Configuration mOverrideConfig;
    private boolean mForceFullscreen;
    private final Rect mPreForceFullscreenBounds;
    int mRotation;

    TaskStack(WindowManagerService service, int stackId) {
        this.mService = service;
        this.mStackId = stackId;
        this.mOverrideConfig = Configuration.EMPTY;
        this.mForceFullscreen = false;
        this.mPreForceFullscreenBounds = new Rect();
        EventLog.writeEvent(31004, stackId, this.mBounds.left, this.mBounds.top, this.mBounds.right, this.mBounds.bottom);
    }

    DisplayContent getDisplayContent() {
        return this.mDisplayContent;
    }

    ArrayList<Task> getTasks() {
        return this.mTasks;
    }

    void resizeWindows() {
        ArrayList<WindowState> resizingWindows = this.mService.mResizingWindows;
        for (int taskNdx = this.mTasks.size() - 1; taskNdx >= 0; --taskNdx) {
            AppTokenList activities = this.mTasks.get((int)taskNdx).mAppTokens;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                WindowList windows = ((AppWindowToken)activities.get((int)activityNdx)).allAppWindows;
                for (int winNdx = windows.size() - 1; winNdx >= 0; --winNdx) {
                    WindowState win = (WindowState)windows.get(winNdx);
                    if (resizingWindows.contains(win)) continue;
                    resizingWindows.add(win);
                }
            }
        }
    }

    boolean setBounds(Rect bounds) {
        boolean oldFullscreen = this.mFullscreen;
        int rotation = 0;
        if (this.mDisplayContent != null) {
            this.mDisplayContent.getLogicalDisplayRect(this.mTmpRect);
            rotation = this.mDisplayContent.getDisplayInfo().rotation;
            if (bounds == null) {
                bounds = this.mTmpRect;
                this.mFullscreen = true;
            } else {
                if (!bounds.intersect(this.mTmpRect)) {
                    return false;
                }
                this.mFullscreen = this.mTmpRect.equals(bounds);
            }
        }
        if (bounds == null) {
            return false;
        }
        if (this.mBounds.equals(bounds) && oldFullscreen == this.mFullscreen && this.mRotation == rotation) {
            return false;
        }
        this.mDimLayer.setBounds(bounds);
        this.mAnimationBackgroundSurface.setBounds(bounds);
        this.mBounds.set(bounds);
        this.mRotation = rotation;
        this.updateOverrideConfiguration();
        return true;
    }

    void getBounds(Rect out) {
        out.set(this.mBounds);
    }

    private void updateOverrideConfiguration() {
        Configuration serviceConfig = this.mService.mCurConfiguration;
        if (this.mFullscreen) {
            this.mOverrideConfig = Configuration.EMPTY;
            return;
        }
        if (this.mOverrideConfig == Configuration.EMPTY) {
            this.mOverrideConfig = new Configuration();
        }
        float density = (float)serviceConfig.densityDpi * 0.00625f;
        this.mOverrideConfig.screenWidthDp = Math.min((int)((float)this.mBounds.width() / density), serviceConfig.screenWidthDp);
        this.mOverrideConfig.screenHeightDp = Math.min((int)((float)this.mBounds.height() / density), serviceConfig.screenHeightDp);
        this.mOverrideConfig.smallestScreenWidthDp = Math.min(this.mOverrideConfig.screenWidthDp, this.mOverrideConfig.screenHeightDp);
        this.mOverrideConfig.orientation = this.mOverrideConfig.screenWidthDp <= this.mOverrideConfig.screenHeightDp ? 1 : 2;
    }

    void updateDisplayInfo() {
        if (this.mFullscreen) {
            this.setBounds(null);
        } else if (this.mDisplayContent != null) {
            int newRotation = this.mDisplayContent.getDisplayInfo().rotation;
            if (this.mRotation == newRotation) {
                return;
            }
            int rotationDelta = DisplayContent.deltaRotation(this.mRotation, newRotation);
            this.mDisplayContent.getLogicalDisplayRect(this.mTmpRect);
            switch (rotationDelta) {
                case 0: {
                    this.mTmpRect2.set(this.mBounds);
                    break;
                }
                case 1: {
                    this.mTmpRect2.top = this.mTmpRect.bottom - this.mBounds.right;
                    this.mTmpRect2.left = this.mBounds.top;
                    this.mTmpRect2.right = this.mTmpRect2.left + this.mBounds.height();
                    this.mTmpRect2.bottom = this.mTmpRect2.top + this.mBounds.width();
                    break;
                }
                case 2: {
                    this.mTmpRect2.top = this.mTmpRect.bottom - this.mBounds.bottom;
                    this.mTmpRect2.left = this.mTmpRect.right - this.mBounds.right;
                    this.mTmpRect2.right = this.mTmpRect2.left + this.mBounds.width();
                    this.mTmpRect2.bottom = this.mTmpRect2.top + this.mBounds.height();
                    break;
                }
                case 3: {
                    this.mTmpRect2.top = this.mBounds.left;
                    this.mTmpRect2.left = this.mTmpRect.right - this.mBounds.bottom;
                    this.mTmpRect2.right = this.mTmpRect2.left + this.mBounds.height();
                    this.mTmpRect2.bottom = this.mTmpRect2.top + this.mBounds.width();
                }
            }
            this.setBounds(this.mTmpRect2);
        }
    }

    boolean isFullscreen() {
        return this.mFullscreen;
    }

    boolean forceFullscreen(boolean forceFullscreen) {
        if (this.mForceFullscreen == forceFullscreen) {
            return false;
        }
        this.mForceFullscreen = forceFullscreen;
        if (forceFullscreen) {
            if (this.mFullscreen) {
                return false;
            }
            this.mPreForceFullscreenBounds.set(this.mBounds);
            return this.setBounds(null);
        }
        if (!this.mFullscreen || this.mPreForceFullscreenBounds.isEmpty()) {
            return false;
        }
        return this.setBounds(this.mPreForceFullscreenBounds);
    }

    boolean isAnimating() {
        for (int taskNdx = this.mTasks.size() - 1; taskNdx >= 0; --taskNdx) {
            AppTokenList activities = this.mTasks.get((int)taskNdx).mAppTokens;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                WindowList windows = ((AppWindowToken)activities.get((int)activityNdx)).allAppWindows;
                for (int winNdx = windows.size() - 1; winNdx >= 0; --winNdx) {
                    WindowStateAnimator winAnimator = ((WindowState)windows.get((int)winNdx)).mWinAnimator;
                    if (!winAnimator.isAnimating() && !winAnimator.mWin.mExiting) continue;
                    return true;
                }
            }
        }
        return false;
    }

    void addTask(Task task, boolean toTop) {
        this.addTask(task, toTop, task.showForAllUsers());
    }

    void addTask(Task task, boolean toTop, boolean showForAllUsers) {
        int stackNdx;
        if (!toTop) {
            stackNdx = 0;
        } else {
            stackNdx = this.mTasks.size();
            if (!showForAllUsers && !this.mService.isCurrentProfileLocked(task.mUserId)) {
                Task tmpTask;
                while (--stackNdx >= 0 && (tmpTask = this.mTasks.get(stackNdx)).showForAllUsers() && this.mService.isCurrentProfileLocked(tmpTask.mUserId)) {
                }
                ++stackNdx;
            }
        }
        this.mTasks.add(stackNdx, task);
        task.mStack = this;
        if (toTop) {
            this.mDisplayContent.moveStack(this, true);
        }
        EventLog.writeEvent(31002, task.mTaskId, toTop ? 1 : 0, stackNdx);
    }

    void moveTaskToTop(Task task) {
        this.mTasks.remove(task);
        this.addTask(task, true);
    }

    void moveTaskToBottom(Task task) {
        this.mTasks.remove(task);
        this.addTask(task, false);
    }

    void removeTask(Task task) {
        this.mTasks.remove(task);
        if (this.mDisplayContent != null) {
            if (this.mTasks.isEmpty()) {
                this.mDisplayContent.moveStack(this, false);
            }
            this.mDisplayContent.layoutNeeded = true;
        }
        for (int appNdx = this.mExitingAppTokens.size() - 1; appNdx >= 0; --appNdx) {
            AppWindowToken wtoken = (AppWindowToken)this.mExitingAppTokens.get(appNdx);
            if (wtoken.mTask != task) continue;
            wtoken.mIsExiting = false;
            this.mExitingAppTokens.remove(appNdx);
        }
    }

    void attachDisplayContent(DisplayContent displayContent) {
        if (this.mDisplayContent != null) {
            throw new IllegalStateException("attachDisplayContent: Already attached");
        }
        this.mDisplayContent = displayContent;
        this.mDimLayer = new DimLayer(this.mService, this, displayContent);
        this.mAnimationBackgroundSurface = new DimLayer(this.mService, this, displayContent);
        this.updateDisplayInfo();
    }

    void detachDisplay() {
        EventLog.writeEvent(31006, this.mStackId);
        boolean doAnotherLayoutPass = false;
        for (int taskNdx = this.mTasks.size() - 1; taskNdx >= 0; --taskNdx) {
            AppTokenList appWindowTokens = this.mTasks.get((int)taskNdx).mAppTokens;
            for (int appNdx = appWindowTokens.size() - 1; appNdx >= 0; --appNdx) {
                WindowList appWindows = ((AppWindowToken)appWindowTokens.get((int)appNdx)).allAppWindows;
                for (int winNdx = appWindows.size() - 1; winNdx >= 0; --winNdx) {
                    this.mService.removeWindowInnerLocked((WindowState)appWindows.get(winNdx), false);
                    doAnotherLayoutPass = true;
                }
            }
        }
        if (doAnotherLayoutPass) {
            this.mService.requestTraversalLocked();
        }
        this.close();
    }

    void resetAnimationBackgroundAnimator() {
        this.mAnimationBackgroundAnimator = null;
        this.mAnimationBackgroundSurface.hide();
    }

    private long getDimBehindFadeDuration(long duration) {
        TypedValue tv = new TypedValue();
        this.mService.mContext.getResources().getValue(0x1130000, tv, true);
        if (tv.type == 6) {
            duration = (long)tv.getFraction(duration, duration);
        } else if (tv.type >= 16 && tv.type <= 31) {
            duration = tv.data;
        }
        return duration;
    }

    boolean animateDimLayers() {
        float dimAmount;
        int dimLayer;
        if (this.mDimWinAnimator == null) {
            dimLayer = this.mDimLayer.getLayer();
            dimAmount = 0.0f;
        } else {
            dimLayer = this.mDimWinAnimator.mAnimLayer - 1;
            dimAmount = this.mDimWinAnimator.mWin.mAttrs.dimAmount;
        }
        float targetAlpha = this.mDimLayer.getTargetAlpha();
        if (targetAlpha != dimAmount) {
            if (this.mDimWinAnimator == null) {
                this.mDimLayer.hide(200L);
            } else {
                long duration;
                long l = duration = this.mDimWinAnimator.mAnimating && this.mDimWinAnimator.mAnimation != null ? this.mDimWinAnimator.mAnimation.computeDurationHint() : 200L;
                if (targetAlpha > dimAmount) {
                    duration = this.getDimBehindFadeDuration(duration);
                }
                this.mDimLayer.show(dimLayer, dimAmount, duration);
            }
        } else if (this.mDimLayer.getLayer() != dimLayer) {
            this.mDimLayer.setLayer(dimLayer);
        }
        if (this.mDimLayer.isAnimating()) {
            if (!this.mService.okToDisplay()) {
                this.mDimLayer.show();
            } else {
                return this.mDimLayer.stepAnimation();
            }
        }
        return false;
    }

    void resetDimmingTag() {
        this.mDimmingTag = false;
    }

    void setDimmingTag() {
        this.mDimmingTag = true;
    }

    boolean testDimmingTag() {
        return this.mDimmingTag;
    }

    boolean isDimming() {
        return this.mDimLayer.isDimming();
    }

    boolean isDimming(WindowStateAnimator winAnimator) {
        return this.mDimWinAnimator == winAnimator && this.mDimLayer.isDimming();
    }

    void startDimmingIfNeeded(WindowStateAnimator newWinAnimator) {
        if (newWinAnimator.mSurfaceShown && (this.mDimWinAnimator == null || !this.mDimWinAnimator.mSurfaceShown || this.mDimWinAnimator.mAnimLayer < newWinAnimator.mAnimLayer)) {
            this.mDimWinAnimator = newWinAnimator;
            if (this.mDimWinAnimator.mWin.mAppToken == null && !this.mFullscreen && this.mDisplayContent != null) {
                this.mDisplayContent.getLogicalDisplayRect(this.mTmpRect);
                this.mDimLayer.setBounds(this.mTmpRect);
            }
        }
    }

    void stopDimmingIfNeeded() {
        if (!this.mDimmingTag && this.isDimming()) {
            this.mDimWinAnimator = null;
            this.mDimLayer.setBounds(this.mBounds);
        }
    }

    void setAnimationBackground(WindowStateAnimator winAnimator, int color2) {
        int animLayer = winAnimator.mAnimLayer;
        if (this.mAnimationBackgroundAnimator == null || animLayer < this.mAnimationBackgroundAnimator.mAnimLayer) {
            this.mAnimationBackgroundAnimator = winAnimator;
            animLayer = this.mService.adjustAnimationBackground(winAnimator);
            this.mAnimationBackgroundSurface.show(animLayer - 1, (float)(color2 >> 24 & 0xFF) / 255.0f, 0L);
        }
    }

    void switchUser() {
        int top = this.mTasks.size();
        for (int taskNdx = 0; taskNdx < top; ++taskNdx) {
            Task task = this.mTasks.get(taskNdx);
            if (!this.mService.isCurrentProfileLocked(task.mUserId) && !task.showForAllUsers()) continue;
            this.mTasks.remove(taskNdx);
            this.mTasks.add(task);
            --top;
        }
    }

    void close() {
        if (this.mAnimationBackgroundSurface != null) {
            this.mAnimationBackgroundSurface.destroySurface();
            this.mAnimationBackgroundSurface = null;
        }
        if (this.mDimLayer != null) {
            this.mDimLayer.destroySurface();
            this.mDimLayer = null;
        }
        this.mDisplayContent = null;
    }

    public void dump(String prefix, PrintWriter pw) {
        pw.print(prefix);
        pw.print("mStackId=");
        pw.println(this.mStackId);
        pw.print(prefix);
        pw.print("mDeferDetach=");
        pw.println(this.mDeferDetach);
        for (int taskNdx = 0; taskNdx < this.mTasks.size(); ++taskNdx) {
            pw.print(prefix);
            pw.println(this.mTasks.get(taskNdx));
        }
        if (this.mAnimationBackgroundSurface.isDimming()) {
            pw.print(prefix);
            pw.println("mWindowAnimationBackgroundSurface:");
            this.mAnimationBackgroundSurface.printTo(prefix + "  ", pw);
        }
        if (this.mDimLayer.isDimming()) {
            pw.print(prefix);
            pw.println("mDimLayer:");
            this.mDimLayer.printTo(prefix + " ", pw);
            pw.print(prefix);
            pw.print("mDimWinAnimator=");
            pw.println(this.mDimWinAnimator);
        }
        if (!this.mExitingAppTokens.isEmpty()) {
            pw.println();
            pw.println("  Exiting application tokens:");
            for (int i = this.mExitingAppTokens.size() - 1; i >= 0; --i) {
                WindowToken token = (WindowToken)this.mExitingAppTokens.get(i);
                pw.print("  Exiting App #");
                pw.print(i);
                pw.print(' ');
                pw.print(token);
                pw.println(':');
                token.dump(pw, "    ");
            }
        }
    }

    public String toString() {
        return "{stackId=" + this.mStackId + " tasks=" + this.mTasks + "}";
    }
}

