/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.animation.ValueAnimator;
import android.app.ActivityManagerNative;
import android.app.AppOpsManager;
import android.app.IActivityManager;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.database.ContentObserver;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Region;
import android.hardware.display.DisplayManager;
import android.hardware.display.DisplayManagerInternal;
import android.net.Uri;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.Debug;
import android.os.Handler;
import android.os.IBinder;
import android.os.IRemoteCallback;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.PowerManager;
import android.os.PowerManagerInternal;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.SystemService;
import android.os.Trace;
import android.os.UserHandle;
import android.os.WorkSource;
import android.provider.Settings;
import android.util.ArraySet;
import android.util.DisplayMetrics;
import android.util.EventLog;
import android.util.Log;
import android.util.Pair;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.util.TimeUtils;
import android.util.TypedValue;
import android.view.Choreographer;
import android.view.Display;
import android.view.DisplayInfo;
import android.view.IApplicationToken;
import android.view.IInputFilter;
import android.view.IOnKeyguardExitResult;
import android.view.IRotationWatcher;
import android.view.IWindow;
import android.view.IWindowId;
import android.view.IWindowManager;
import android.view.IWindowSession;
import android.view.IWindowSessionCallback;
import android.view.InputChannel;
import android.view.InputDevice;
import android.view.InputEvent;
import android.view.InputEventReceiver;
import android.view.MagnificationSpec;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.SurfaceControl;
import android.view.SurfaceSession;
import android.view.View;
import android.view.WindowContentFrameStats;
import android.view.WindowManager;
import android.view.WindowManagerInternal;
import android.view.WindowManagerPolicy;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import com.android.internal.R;
import com.android.internal.app.IAssistScreenshotReceiver;
import com.android.internal.app.IBatteryStats;
import com.android.internal.util.FastPrintWriter;
import com.android.internal.view.IInputContext;
import com.android.internal.view.IInputMethodClient;
import com.android.internal.view.IInputMethodManager;
import com.android.internal.view.WindowManagerPolicyThread;
import com.android.server.AttributeCache;
import com.android.server.DisplayThread;
import com.android.server.FgThread;
import com.android.server.LocalServices;
import com.android.server.UiThread;
import com.android.server.Watchdog;
import com.android.server.am.BatteryStatsService;
import com.android.server.input.InputManagerService;
import com.android.server.policy.PhoneWindowManager;
import com.android.server.power.ShutdownThread;
import com.android.server.wm.AccessibilityController;
import com.android.server.wm.AppTokenList;
import com.android.server.wm.AppTransition;
import com.android.server.wm.AppWindowAnimator;
import com.android.server.wm.AppWindowToken;
import com.android.server.wm.CircularDisplayMask;
import com.android.server.wm.DisplayContent;
import com.android.server.wm.DisplayContentList;
import com.android.server.wm.DisplaySettings;
import com.android.server.wm.DragState;
import com.android.server.wm.EmulatorDisplayOverlay;
import com.android.server.wm.FocusedStackFrame;
import com.android.server.wm.InputConsumerImpl;
import com.android.server.wm.InputMonitor;
import com.android.server.wm.KeyguardDisableHandler;
import com.android.server.wm.PointerEventDispatcher;
import com.android.server.wm.ScreenRotationAnimation;
import com.android.server.wm.Session;
import com.android.server.wm.StackTapPointerEventListener;
import com.android.server.wm.StartingData;
import com.android.server.wm.StrictModeFlash;
import com.android.server.wm.Task;
import com.android.server.wm.TaskGroup;
import com.android.server.wm.TaskStack;
import com.android.server.wm.ViewServer;
import com.android.server.wm.Watermark;
import com.android.server.wm.WindowAnimator;
import com.android.server.wm.WindowList;
import com.android.server.wm.WindowState;
import com.android.server.wm.WindowStateAnimator;
import com.android.server.wm.WindowToken;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Socket;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class WindowManagerService
extends IWindowManager.Stub
implements Watchdog.Monitor,
WindowManagerPolicy.WindowManagerFuncs {
    static final String TAG = "WindowManager";
    static final boolean DEBUG = false;
    static final boolean DEBUG_ADD_REMOVE = false;
    static final boolean DEBUG_FOCUS = false;
    static final boolean DEBUG_FOCUS_LIGHT = false;
    static final boolean DEBUG_ANIM = false;
    static final boolean DEBUG_KEYGUARD = false;
    static final boolean DEBUG_LAYOUT = false;
    static final boolean DEBUG_RESIZE = false;
    static final boolean DEBUG_LAYERS = false;
    static final boolean DEBUG_INPUT = false;
    static final boolean DEBUG_INPUT_METHOD = false;
    static final boolean DEBUG_VISIBILITY = false;
    static final boolean DEBUG_WINDOW_MOVEMENT = false;
    static final boolean DEBUG_TOKEN_MOVEMENT = false;
    static final boolean DEBUG_ORIENTATION = false;
    static final boolean DEBUG_APP_ORIENTATION = false;
    static final boolean DEBUG_CONFIGURATION = false;
    static final boolean DEBUG_APP_TRANSITIONS = false;
    static final boolean DEBUG_STARTING_WINDOW = false;
    static final boolean DEBUG_WALLPAPER = false;
    static final boolean DEBUG_WALLPAPER_LIGHT = false;
    static final boolean DEBUG_DRAG = false;
    static final boolean DEBUG_SCREEN_ON = false;
    static final boolean DEBUG_SCREENSHOT = false;
    static final boolean DEBUG_BOOT = false;
    static final boolean DEBUG_LAYOUT_REPEATS = true;
    static final boolean DEBUG_SURFACE_TRACE = false;
    static final boolean DEBUG_WINDOW_TRACE = false;
    static final boolean DEBUG_TASK_MOVEMENT = false;
    static final boolean DEBUG_STACK = false;
    static final boolean DEBUG_DISPLAY = false;
    static final boolean DEBUG_POWER = false;
    static final boolean SHOW_SURFACE_ALLOC = false;
    static final boolean SHOW_TRANSACTIONS = false;
    static final boolean SHOW_LIGHT_TRANSACTIONS = false;
    static final boolean HIDE_STACK_CRAWLS = true;
    static final int LAYOUT_REPEAT_THRESHOLD = 4;
    static final boolean PROFILE_ORIENTATION = false;
    static final boolean localLOGV = false;
    static final int TYPE_LAYER_MULTIPLIER = 10000;
    static final int TYPE_LAYER_OFFSET = 1000;
    static final int WINDOW_LAYER_MULTIPLIER = 5;
    static final int LAYER_OFFSET_DIM = 1;
    static final int LAYER_OFFSET_FOCUSED_STACK = 1;
    static final int LAYER_OFFSET_THUMBNAIL = 4;
    static final int MAX_ANIMATION_DURATION = 10000;
    static final int WINDOW_FREEZE_TIMEOUT_DURATION = 2000;
    static final int LAST_ANR_LIFETIME_DURATION_MSECS = 0x6DDD00;
    static final boolean CUSTOM_SCREEN_ROTATION = true;
    private static final int INPUT_DEVICES_READY_FOR_SAFE_MODE_DETECTION_TIMEOUT_MILLIS = 1000;
    static final long DEFAULT_INPUT_DISPATCHING_TIMEOUT_NANOS = 5000000000L;
    private static final int BOOT_ANIMATION_POLL_INTERVAL = 200;
    private static final String BOOT_ANIMATION_SERVICE = "bootanim";
    static final int UPDATE_FOCUS_NORMAL = 0;
    static final int UPDATE_FOCUS_WILL_ASSIGN_LAYERS = 1;
    static final int UPDATE_FOCUS_PLACING_SURFACES = 2;
    static final int UPDATE_FOCUS_WILL_PLACE_SURFACES = 3;
    private static final String SYSTEM_SECURE = "ro.secure";
    private static final String SYSTEM_DEBUGGABLE = "ro.debuggable";
    private static final String DENSITY_OVERRIDE = "ro.config.density_override";
    private static final String SIZE_OVERRIDE = "ro.config.size_override";
    private static final int MAX_SCREENSHOT_RETRIES = 3;
    private static final String PROPERTY_EMULATOR_CIRCULAR = "ro.emulator.circular";
    private final KeyguardDisableHandler mKeyguardDisableHandler;
    final BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.app.action.DEVICE_POLICY_MANAGER_STATE_CHANGED".equals(action)) {
                WindowManagerService.this.mKeyguardDisableHandler.sendEmptyMessage(3);
            }
        }
    };
    int mCurrentUserId;
    int[] mCurrentProfileIds = new int[]{0};
    final Context mContext;
    final boolean mHaveInputMethods;
    final boolean mHasPermanentDpad;
    final long mDrawLockTimeoutMillis;
    final boolean mAllowAnimationsInLowPowerMode;
    final boolean mAllowBootMessages;
    final boolean mLimitedAlphaCompositing;
    final WindowManagerPolicy mPolicy = new PhoneWindowManager();
    final IActivityManager mActivityManager;
    final IBatteryStats mBatteryStats;
    final AppOpsManager mAppOps;
    final DisplaySettings mDisplaySettings;
    final ArraySet<Session> mSessions = new ArraySet();
    final HashMap<IBinder, WindowState> mWindowMap = new HashMap();
    final HashMap<IBinder, WindowToken> mTokenMap = new HashMap();
    final ArrayList<AppWindowToken> mFinishedStarting = new ArrayList();
    InputConsumerImpl mInputConsumer;
    final ArrayList<WindowState> mResizingWindows = new ArrayList();
    final ArrayList<WindowState> mPendingRemove = new ArrayList();
    WindowState[] mPendingRemoveTmp = new WindowState[20];
    final ArrayList<WindowState> mDestroySurface = new ArrayList();
    ArrayList<WindowState> mLosingFocus = new ArrayList();
    final ArrayList<WindowState> mForceRemoves = new ArrayList();
    ArrayList<WindowState> mWaitingForDrawn = new ArrayList();
    Runnable mWaitingForDrawnCallback;
    WindowState[] mRebuildTmp = new WindowState[20];
    SparseArray<Boolean> mScreenCaptureDisabled = new SparseArray();
    IInputMethodManager mInputMethodManager;
    AccessibilityController mAccessibilityController;
    final SurfaceSession mFxSession;
    Watermark mWatermark;
    StrictModeFlash mStrictModeFlash;
    CircularDisplayMask mCircularDisplayMask;
    EmulatorDisplayOverlay mEmulatorDisplayOverlay;
    FocusedStackFrame mFocusedStackFrame;
    int mFocusedStackLayer;
    final float[] mTmpFloats = new float[9];
    final Rect mTmpContentRect = new Rect();
    boolean mDisplayReady;
    boolean mSafeMode;
    boolean mDisplayEnabled = false;
    boolean mSystemBooted = false;
    boolean mForceDisplayEnabled = false;
    boolean mShowingBootMessages = false;
    boolean mBootAnimationStopped = false;
    String mLastANRState;
    SparseArray<DisplayContent> mDisplayContents = new SparseArray(2);
    int mRotation = 0;
    int mForcedAppOrientation = -1;
    boolean mAltOrientation = false;
    private boolean mKeyguardWaitingForActivityDrawn;
    ArrayList<RotationWatcher> mRotationWatchers = new ArrayList();
    int mDeferredRotationPauseCount;
    int mSystemDecorLayer = 0;
    final Rect mScreenRect = new Rect();
    boolean mTraversalScheduled = false;
    boolean mDisplayFrozen = false;
    long mDisplayFreezeTime = 0L;
    int mLastDisplayFreezeDuration = 0;
    Object mLastFinishedFreezeSource = null;
    boolean mWaitingForConfig = false;
    static final int WINDOWS_FREEZING_SCREENS_NONE = 0;
    static final int WINDOWS_FREEZING_SCREENS_ACTIVE = 1;
    static final int WINDOWS_FREEZING_SCREENS_TIMEOUT = 2;
    private int mWindowsFreezingScreen = 0;
    boolean mClientFreezingScreen = false;
    int mAppsFreezingScreen = 0;
    int mLastWindowForcedOrientation = -1;
    int mLastKeyguardForcedOrientation = 5;
    int mLayoutSeq = 0;
    int mLastStatusBarVisibility = 0;
    int mLastDispatchedSystemUiVisibility = 0;
    boolean mFocusMayChange;
    Configuration mCurConfiguration = new Configuration();
    private final PowerManager.WakeLock mScreenFrozenLock;
    final AppTransition mAppTransition;
    boolean mSkipAppTransitionAnimation = false;
    final ArraySet<AppWindowToken> mOpeningApps = new ArraySet();
    final ArraySet<AppWindowToken> mClosingApps = new ArraySet();
    boolean mIsTouchDevice;
    final DisplayMetrics mDisplayMetrics = new DisplayMetrics();
    final DisplayMetrics mRealDisplayMetrics = new DisplayMetrics();
    final DisplayMetrics mTmpDisplayMetrics = new DisplayMetrics();
    final DisplayMetrics mCompatDisplayMetrics = new DisplayMetrics();
    final H mH = new H();
    final Choreographer mChoreographer = Choreographer.getInstance();
    WindowState mCurrentFocus = null;
    WindowState mLastFocus = null;
    WindowState mInputMethodTarget = null;
    boolean mInputMethodTargetWaitingAnim;
    int mInputMethodAnimLayerAdjustment;
    WindowState mInputMethodWindow = null;
    final ArrayList<WindowState> mInputMethodDialogs = new ArrayList();
    final ArrayList<WindowState> mTmpWindows = new ArrayList();
    boolean mHardKeyboardAvailable;
    boolean mShowImeWithHardKeyboard;
    OnHardKeyboardStatusChangeListener mHardKeyboardStatusChangeListener;
    SettingsObserver mSettingsObserver;
    private final ArrayList<WindowToken> mWallpaperTokens = new ArrayList();
    WindowState mWallpaperTarget = null;
    WindowState mLowerWallpaperTarget = null;
    WindowState mUpperWallpaperTarget = null;
    int mWallpaperAnimLayerAdjustment;
    float mLastWallpaperX = -1.0f;
    float mLastWallpaperY = -1.0f;
    float mLastWallpaperXStep = -1.0f;
    float mLastWallpaperYStep = -1.0f;
    int mLastWallpaperDisplayOffsetX = Integer.MIN_VALUE;
    int mLastWallpaperDisplayOffsetY = Integer.MIN_VALUE;
    WindowState mWaitingOnWallpaper;
    long mLastWallpaperTimeoutTime;
    static final long WALLPAPER_TIMEOUT = 150L;
    static final long WALLPAPER_TIMEOUT_RECOVERY = 10000L;
    boolean mAnimateWallpaperWithTarget;
    static final long WALLPAPER_DRAW_PENDING_TIMEOUT_DURATION = 500L;
    static final int WALLPAPER_DRAW_NORMAL = 0;
    static final int WALLPAPER_DRAW_PENDING = 1;
    static final int WALLPAPER_DRAW_TIMEOUT = 2;
    int mWallpaperDrawState = 0;
    WindowState mDeferredHideWallpaper = null;
    AppWindowToken mFocusedApp = null;
    PowerManager mPowerManager;
    PowerManagerInternal mPowerManagerInternal;
    float mWindowAnimationScaleSetting = 1.0f;
    float mTransitionAnimationScaleSetting = 1.0f;
    float mAnimatorDurationScaleSetting = 1.0f;
    boolean mAnimationsDisabled = false;
    final InputManagerService mInputManager;
    final DisplayManagerInternal mDisplayManagerInternal;
    final DisplayManager mDisplayManager;
    Session mHoldingScreenOn;
    PowerManager.WakeLock mHoldingScreenWakeLock;
    boolean mTurnOnScreen;
    boolean mAllowTheaterModeWakeFromLayout;
    DragState mDragState = null;
    int mExitAnimId;
    int mEnterAnimId;
    final LayoutFields mInnerFields = new LayoutFields();
    boolean mAnimationScheduled;
    private int mTransactionSequence;
    private int mLayoutRepeatCount;
    final WindowAnimator mAnimator;
    SparseArray<Task> mTaskIdToTask = new SparseArray();
    SparseArray<TaskStack> mStackIdToStack = new SparseArray();
    private final PointerEventDispatcher mPointerEventDispatcher;
    private WindowContentFrameStats mTempWindowRenderStats;
    boolean mInTouchMode;
    private ViewServer mViewServer;
    private final ArrayList<WindowChangeListener> mWindowChangeListeners = new ArrayList();
    private boolean mWindowsChanged = false;
    final Configuration mTempConfiguration = new Configuration();
    float mCompatibleScreenScale;
    final boolean mOnlyCore;
    private final List<IBinder> mNoAnimationNotifyOnTransitionFinished = new ArrayList<IBinder>();
    private final WindowManagerInternal.AppTransitionListener mActivityManagerAppTransitionNotifier = new WindowManagerInternal.AppTransitionListener(){

        @Override
        public void onAppTransitionFinishedLocked(IBinder token) {
            AppWindowToken atoken = WindowManagerService.this.findAppWindowToken(token);
            if (atoken == null) {
                return;
            }
            if (atoken.mLaunchTaskBehind) {
                try {
                    WindowManagerService.this.mActivityManager.notifyLaunchTaskBehindComplete(atoken.token);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
                atoken.mLaunchTaskBehind = false;
            } else {
                atoken.updateReportedVisibilityLocked();
                if (atoken.mEnteringAnimation) {
                    atoken.mEnteringAnimation = false;
                    try {
                        WindowManagerService.this.mActivityManager.notifyEnterAnimationComplete(atoken.token);
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
            }
        }
    };
    final InputMonitor mInputMonitor = new InputMonitor(this);
    private boolean mEventDispatchingEnabled;
    private boolean mInLayout = false;

    public static WindowManagerService main(final Context context, final InputManagerService im, final boolean haveInputMethods, final boolean showBootMsgs, final boolean onlyCore) {
        final WindowManagerService[] holder = new WindowManagerService[1];
        DisplayThread.getHandler().runWithScissors(new Runnable(){

            @Override
            public void run() {
                holder[0] = new WindowManagerService(context, im, haveInputMethods, showBootMsgs, onlyCore);
            }
        }, 0L);
        return holder[0];
    }

    private void initPolicy() {
        UiThread.getHandler().runWithScissors(new Runnable(){

            @Override
            public void run() {
                WindowManagerPolicyThread.set(Thread.currentThread(), Looper.myLooper());
                WindowManagerService.this.mPolicy.init(WindowManagerService.this.mContext, WindowManagerService.this, WindowManagerService.this);
            }
        }, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WindowManagerService(Context context, InputManagerService inputManager, boolean haveInputMethods, boolean showBootMsgs, boolean onlyCore) {
        Display[] displays;
        this.mContext = context;
        this.mHaveInputMethods = haveInputMethods;
        this.mAllowBootMessages = showBootMsgs;
        this.mOnlyCore = onlyCore;
        this.mLimitedAlphaCompositing = context.getResources().getBoolean(17956877);
        this.mHasPermanentDpad = context.getResources().getBoolean(17956988);
        this.mInTouchMode = context.getResources().getBoolean(17957015);
        this.mDrawLockTimeoutMillis = context.getResources().getInteger(17694861);
        this.mAllowAnimationsInLowPowerMode = context.getResources().getBoolean(17957017);
        this.mInputManager = inputManager;
        this.mDisplayManagerInternal = LocalServices.getService(DisplayManagerInternal.class);
        this.mDisplaySettings = new DisplaySettings();
        this.mDisplaySettings.readSettingsLocked();
        LocalServices.addService(WindowManagerPolicy.class, this.mPolicy);
        this.mPointerEventDispatcher = new PointerEventDispatcher(this.mInputManager.monitorInput(TAG));
        this.mFxSession = new SurfaceSession();
        this.mDisplayManager = (DisplayManager)context.getSystemService("display");
        for (Display display : displays = this.mDisplayManager.getDisplays()) {
            this.createDisplayContentLocked(display);
        }
        this.mKeyguardDisableHandler = new KeyguardDisableHandler(this.mContext, this.mPolicy);
        this.mPowerManager = (PowerManager)context.getSystemService("power");
        this.mPowerManagerInternal = LocalServices.getService(PowerManagerInternal.class);
        this.mPowerManagerInternal.registerLowPowerModeObserver(new PowerManagerInternal.LowPowerModeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onLowPowerModeChanged(boolean enabled) {
                HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
                synchronized (hashMap) {
                    if (WindowManagerService.this.mAnimationsDisabled != enabled && !WindowManagerService.this.mAllowAnimationsInLowPowerMode) {
                        WindowManagerService.this.mAnimationsDisabled = enabled;
                        WindowManagerService.this.dispatchNewAnimatorScaleLocked(null);
                    }
                }
            }
        });
        this.mAnimationsDisabled = this.mPowerManagerInternal.getLowPowerModeEnabled();
        this.mScreenFrozenLock = this.mPowerManager.newWakeLock(1, "SCREEN_FROZEN");
        this.mScreenFrozenLock.setReferenceCounted(false);
        this.mAppTransition = new AppTransition(context, this.mH);
        this.mAppTransition.registerListenerLocked(this.mActivityManagerAppTransitionNotifier);
        this.mActivityManager = ActivityManagerNative.getDefault();
        this.mBatteryStats = BatteryStatsService.getService();
        this.mAppOps = (AppOpsManager)context.getSystemService("appops");
        AppOpsManager.OnOpChangedInternalListener opListener = new AppOpsManager.OnOpChangedInternalListener(){

            @Override
            public void onOpChanged(int op, String packageName) {
                WindowManagerService.this.updateAppOpsState();
            }
        };
        this.mAppOps.startWatchingMode(24, null, (AppOpsManager.OnOpChangedListener)opListener);
        this.mAppOps.startWatchingMode(45, null, (AppOpsManager.OnOpChangedListener)opListener);
        this.mWindowAnimationScaleSetting = Settings.Global.getFloat(context.getContentResolver(), "window_animation_scale", this.mWindowAnimationScaleSetting);
        this.mTransitionAnimationScaleSetting = Settings.Global.getFloat(context.getContentResolver(), "transition_animation_scale", this.mTransitionAnimationScaleSetting);
        this.setAnimatorDurationScale(Settings.Global.getFloat(context.getContentResolver(), "animator_duration_scale", this.mAnimatorDurationScaleSetting));
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.app.action.DEVICE_POLICY_MANAGER_STATE_CHANGED");
        this.mContext.registerReceiver(this.mBroadcastReceiver, filter);
        this.mSettingsObserver = new SettingsObserver();
        this.updateShowImeWithHardKeyboard();
        this.mHoldingScreenWakeLock = this.mPowerManager.newWakeLock(0x2000000A, TAG);
        this.mHoldingScreenWakeLock.setReferenceCounted(false);
        this.mAnimator = new WindowAnimator(this);
        this.mAllowTheaterModeWakeFromLayout = context.getResources().getBoolean(17956912);
        LocalServices.addService(WindowManagerInternal.class, new LocalService());
        this.initPolicy();
        Watchdog.getInstance().addMonitor(this);
        SurfaceControl.openTransaction();
        try {
            this.createWatermarkInTransaction();
            this.mFocusedStackFrame = new FocusedStackFrame(this.getDefaultDisplayContentLocked().getDisplay(), this.mFxSession);
        }
        finally {
            SurfaceControl.closeTransaction();
        }
        this.updateCircularDisplayMaskIfNeeded();
        this.showEmulatorDisplayOverlayIfNeeded();
    }

    public InputMonitor getInputMonitor() {
        return this.mInputMonitor;
    }

    @Override
    public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        try {
            return super.onTransact(code, data, reply, flags);
        }
        catch (RuntimeException e) {
            if (!(e instanceof SecurityException)) {
                Slog.wtf(TAG, "Window Manager Crash", e);
            }
            throw e;
        }
    }

    private void placeWindowAfter(WindowState pos, WindowState window) {
        WindowList windows = pos.getWindowList();
        int i = windows.indexOf(pos);
        windows.add(i + 1, window);
        this.mWindowsChanged = true;
    }

    private void placeWindowBefore(WindowState pos, WindowState window) {
        WindowList windows = pos.getWindowList();
        int i = windows.indexOf(pos);
        if (i < 0) {
            Slog.w(TAG, "placeWindowBefore: Unable to find " + pos + " in " + windows);
            i = 0;
        }
        windows.add(i, window);
        this.mWindowsChanged = true;
    }

    private int findIdxBasedOnAppTokens(WindowState win) {
        WindowList windows = win.getWindowList();
        for (int j = windows.size() - 1; j >= 0; --j) {
            WindowState wentry = (WindowState)windows.get(j);
            if (wentry.mAppToken != win.mAppToken) continue;
            return j;
        }
        return -1;
    }

    WindowList getTokenWindowsOnDisplay(WindowToken token, DisplayContent displayContent) {
        WindowList windowList = new WindowList();
        int count = token.windows.size();
        for (int i = 0; i < count; ++i) {
            WindowState win = (WindowState)token.windows.get(i);
            if (win.getDisplayContent() != displayContent) continue;
            windowList.add(win);
        }
        return windowList;
    }

    private int indexOfWinInWindowList(WindowState targetWin, WindowList windows) {
        for (int i = windows.size() - 1; i >= 0; --i) {
            WindowState w = (WindowState)windows.get(i);
            if (w == targetWin) {
                return i;
            }
            if (w.mChildWindows.isEmpty() || this.indexOfWinInWindowList(targetWin, w.mChildWindows) < 0) continue;
            return i;
        }
        return -1;
    }

    private int addAppWindowToListLocked(WindowState win) {
        int i;
        WindowToken atoken;
        AppWindowToken t;
        AppTokenList tokens;
        int taskNdx;
        IWindow client = win.mClient;
        WindowToken token = win.mToken;
        DisplayContent displayContent = win.getDisplayContent();
        if (displayContent == null) {
            return 0;
        }
        WindowList windows = win.getWindowList();
        int N = windows.size();
        WindowList tokenWindowList = this.getTokenWindowsOnDisplay(token, displayContent);
        int tokenWindowsPos = 0;
        int windowListPos = tokenWindowList.size();
        if (!tokenWindowList.isEmpty()) {
            if (win.mAttrs.type == 1) {
                WindowState lowestWindow = (WindowState)tokenWindowList.get(0);
                this.placeWindowBefore(lowestWindow, win);
                tokenWindowsPos = this.indexOfWinInWindowList(lowestWindow, token.windows);
            } else {
                AppWindowToken atoken2 = win.mAppToken;
                WindowState lastWindow = (WindowState)tokenWindowList.get(windowListPos - 1);
                if (atoken2 != null && lastWindow == atoken2.startingWindow) {
                    this.placeWindowBefore(lastWindow, win);
                    tokenWindowsPos = this.indexOfWinInWindowList(lastWindow, token.windows);
                } else {
                    int newIdx = this.findIdxBasedOnAppTokens(win);
                    windows.add(newIdx + 1, win);
                    tokenWindowsPos = newIdx < 0 ? 0 : this.indexOfWinInWindowList((WindowState)windows.get(newIdx), token.windows) + 1;
                    this.mWindowsChanged = true;
                }
            }
            return tokenWindowsPos;
        }
        WindowState pos = null;
        ArrayList<Task> tasks = displayContent.getTasks();
        int tokenNdx = -1;
        for (taskNdx = tasks.size() - 1; taskNdx >= 0; --taskNdx) {
            tokens = tasks.get((int)taskNdx).mAppTokens;
            for (tokenNdx = tokens.size() - 1; tokenNdx >= 0; --tokenNdx) {
                t = (AppWindowToken)tokens.get(tokenNdx);
                if (t == token) {
                    if (--tokenNdx >= 0 || --taskNdx < 0) break;
                    tokenNdx = tasks.get((int)taskNdx).mAppTokens.size() - 1;
                    break;
                }
                tokenWindowList = this.getTokenWindowsOnDisplay(t, displayContent);
                if (t.sendingToBottom || tokenWindowList.size() <= 0) continue;
                pos = (WindowState)tokenWindowList.get(0);
            }
            if (tokenNdx >= 0) break;
        }
        if (pos != null) {
            int NC;
            atoken = this.mTokenMap.get(pos.mClient.asBinder());
            if (atoken != null && (NC = (tokenWindowList = this.getTokenWindowsOnDisplay(atoken, displayContent)).size()) > 0) {
                WindowState bottom = (WindowState)tokenWindowList.get(0);
                if (bottom.mSubLayer < 0) {
                    pos = bottom;
                }
            }
            this.placeWindowBefore(pos, win);
            return tokenWindowsPos;
        }
        while (taskNdx >= 0) {
            tokens = tasks.get((int)taskNdx).mAppTokens;
            while (tokenNdx >= 0) {
                t = (AppWindowToken)tokens.get(tokenNdx);
                tokenWindowList = this.getTokenWindowsOnDisplay(t, displayContent);
                int NW = tokenWindowList.size();
                if (NW > 0) {
                    pos = (WindowState)tokenWindowList.get(NW - 1);
                    break;
                }
                --tokenNdx;
            }
            if (tokenNdx >= 0) break;
            --taskNdx;
        }
        if (pos != null) {
            int NC;
            atoken = this.mTokenMap.get(pos.mClient.asBinder());
            if (atoken != null && (NC = atoken.windows.size()) > 0) {
                WindowState top = (WindowState)atoken.windows.get(NC - 1);
                if (top.mSubLayer >= 0) {
                    pos = top;
                }
            }
            this.placeWindowAfter(pos, win);
            return tokenWindowsPos;
        }
        int myLayer = win.mBaseLayer;
        for (i = N - 1; i >= 0; --i) {
            WindowState w = (WindowState)windows.get(i);
            if (w.mBaseLayer <= myLayer) break;
        }
        windows.add(i + 1, win);
        this.mWindowsChanged = true;
        return tokenWindowsPos;
    }

    private void addFreeWindowToListLocked(WindowState win) {
        int i;
        WindowList windows = win.getWindowList();
        int myLayer = win.mBaseLayer;
        for (i = windows.size() - 1; i >= 0 && ((WindowState)windows.get((int)i)).mBaseLayer > myLayer; --i) {
        }
        windows.add(++i, win);
        this.mWindowsChanged = true;
    }

    private void addAttachedWindowToListLocked(WindowState win, boolean addToToken) {
        int i;
        WindowToken token = win.mToken;
        DisplayContent displayContent = win.getDisplayContent();
        if (displayContent == null) {
            return;
        }
        WindowState attached = win.mAttachedWindow;
        WindowList tokenWindowList = this.getTokenWindowsOnDisplay(token, displayContent);
        int NA = tokenWindowList.size();
        int sublayer = win.mSubLayer;
        int largestSublayer = Integer.MIN_VALUE;
        WindowState windowWithLargestSublayer = null;
        for (i = 0; i < NA; ++i) {
            WindowState w = (WindowState)tokenWindowList.get(i);
            int wSublayer = w.mSubLayer;
            if (wSublayer >= largestSublayer) {
                largestSublayer = wSublayer;
                windowWithLargestSublayer = w;
            }
            if (sublayer < 0) {
                if (wSublayer < sublayer) continue;
                if (addToToken) {
                    token.windows.add(i, win);
                }
                this.placeWindowBefore(wSublayer >= 0 ? attached : w, win);
                break;
            }
            if (wSublayer <= sublayer) continue;
            if (addToToken) {
                token.windows.add(i, win);
            }
            this.placeWindowBefore(w, win);
            break;
        }
        if (i >= NA) {
            if (addToToken) {
                token.windows.add(win);
            }
            if (sublayer < 0) {
                this.placeWindowBefore(attached, win);
            } else {
                this.placeWindowAfter(largestSublayer >= 0 ? windowWithLargestSublayer : attached, win);
            }
        }
    }

    private void addWindowToListInOrderLocked(WindowState win, boolean addToToken) {
        if (win.mAttachedWindow == null) {
            WindowToken token = win.mToken;
            int tokenWindowsPos = 0;
            if (token.appWindowToken != null) {
                tokenWindowsPos = this.addAppWindowToListLocked(win);
            } else {
                this.addFreeWindowToListLocked(win);
            }
            if (addToToken) {
                token.windows.add(tokenWindowsPos, win);
            }
        } else {
            this.addAttachedWindowToListLocked(win, addToToken);
        }
        if (win.mAppToken != null && addToToken) {
            win.mAppToken.allAppWindows.add(win);
        }
    }

    static boolean canBeImeTarget(WindowState w) {
        int fl = w.mAttrs.flags & 0x20008;
        if (fl == 0 || fl == 131080 || w.mAttrs.type == 3) {
            return w.isVisibleOrAdding();
        }
        return false;
    }

    int findDesiredInputMethodWindowIndexLocked(boolean willMove) {
        WindowState curTarget;
        int i;
        WindowList windows = this.getDefaultWindowListLocked();
        WindowState w = null;
        for (i = windows.size() - 1; i >= 0; --i) {
            WindowState win = (WindowState)windows.get(i);
            if (!WindowManagerService.canBeImeTarget(win)) continue;
            w = win;
            if (willMove || w.mAttrs.type != 3 || i <= 0) break;
            WindowState wb = (WindowState)windows.get(i - 1);
            if (wb.mAppToken != w.mAppToken || !WindowManagerService.canBeImeTarget(wb)) break;
            --i;
            w = wb;
            break;
        }
        if ((curTarget = this.mInputMethodTarget) != null && curTarget.isDisplayedLw() && curTarget.isClosing() && (w == null || curTarget.mWinAnimator.mAnimLayer > w.mWinAnimator.mAnimLayer)) {
            return windows.indexOf(curTarget) + 1;
        }
        if (willMove && w != null) {
            AppWindowToken token;
            AppWindowToken appWindowToken = token = curTarget == null ? null : curTarget.mAppToken;
            if (token != null) {
                WindowState highestTarget = null;
                int highestPos = 0;
                if (token.mAppAnimator.animating || token.mAppAnimator.animation != null) {
                    WindowList curWindows = curTarget.getWindowList();
                    for (int pos = curWindows.indexOf(curTarget); pos >= 0; --pos) {
                        WindowState win = (WindowState)curWindows.get(pos);
                        if (win.mAppToken != token) break;
                        if (win.mRemoved || highestTarget != null && win.mWinAnimator.mAnimLayer <= highestTarget.mWinAnimator.mAnimLayer) continue;
                        highestTarget = win;
                        highestPos = pos;
                    }
                }
                if (highestTarget != null) {
                    if (this.mAppTransition.isTransitionSet()) {
                        this.mInputMethodTargetWaitingAnim = true;
                        this.mInputMethodTarget = highestTarget;
                        return highestPos + 1;
                    }
                    if (highestTarget.mWinAnimator.isAnimating() && highestTarget.mWinAnimator.mAnimLayer > w.mWinAnimator.mAnimLayer) {
                        this.mInputMethodTargetWaitingAnim = true;
                        this.mInputMethodTarget = highestTarget;
                        return highestPos + 1;
                    }
                }
            }
        }
        if (w != null) {
            if (willMove) {
                this.mInputMethodTarget = w;
                this.mInputMethodTargetWaitingAnim = false;
                if (w.mAppToken != null) {
                    this.setInputMethodAnimLayerAdjustment(w.mAppToken.mAppAnimator.animLayerAdjustment);
                } else {
                    this.setInputMethodAnimLayerAdjustment(0);
                }
            }
            return i + 1;
        }
        if (willMove) {
            this.mInputMethodTarget = null;
            this.setInputMethodAnimLayerAdjustment(0);
        }
        return -1;
    }

    void addInputMethodWindowToListLocked(WindowState win) {
        int pos = this.findDesiredInputMethodWindowIndexLocked(true);
        if (pos >= 0) {
            win.mTargetAppToken = this.mInputMethodTarget.mAppToken;
            this.getDefaultWindowListLocked().add(pos, win);
            this.mWindowsChanged = true;
            this.moveInputMethodDialogsLocked(pos + 1);
            return;
        }
        win.mTargetAppToken = null;
        this.addWindowToListInOrderLocked(win, true);
        this.moveInputMethodDialogsLocked(pos);
    }

    void setInputMethodAnimLayerAdjustment(int adj) {
        this.mInputMethodAnimLayerAdjustment = adj;
        WindowState imw = this.mInputMethodWindow;
        if (imw != null) {
            imw.mWinAnimator.mAnimLayer = imw.mLayer + adj;
            int wi = imw.mChildWindows.size();
            while (wi > 0) {
                WindowState cw = (WindowState)imw.mChildWindows.get(--wi);
                cw.mWinAnimator.mAnimLayer = cw.mLayer + adj;
            }
        }
        int di = this.mInputMethodDialogs.size();
        while (di > 0) {
            imw = this.mInputMethodDialogs.get(--di);
            imw.mWinAnimator.mAnimLayer = imw.mLayer + adj;
        }
    }

    private int tmpRemoveWindowLocked(int interestingPos, WindowState win) {
        WindowList windows = win.getWindowList();
        int wpos = windows.indexOf(win);
        if (wpos >= 0) {
            if (wpos < interestingPos) {
                --interestingPos;
            }
            windows.remove(wpos);
            this.mWindowsChanged = true;
            int NC = win.mChildWindows.size();
            while (NC > 0) {
                WindowState cw;
                int cpos;
                if ((cpos = windows.indexOf(cw = (WindowState)win.mChildWindows.get(--NC))) < 0) continue;
                if (cpos < interestingPos) {
                    --interestingPos;
                }
                windows.remove(cpos);
            }
        }
        return interestingPos;
    }

    private void reAddWindowToListInOrderLocked(WindowState win) {
        this.addWindowToListInOrderLocked(win, false);
        WindowList windows = win.getWindowList();
        int wpos = windows.indexOf(win);
        if (wpos >= 0) {
            windows.remove(wpos);
            this.mWindowsChanged = true;
            this.reAddWindowLocked(wpos, win);
        }
    }

    void logWindowList(WindowList windows, String prefix) {
        int N = windows.size();
        while (N > 0) {
            Slog.v(TAG, prefix + "#" + --N + ": " + windows.get(N));
        }
    }

    void moveInputMethodDialogsLocked(int pos) {
        int i;
        ArrayList<WindowState> dialogs = this.mInputMethodDialogs;
        WindowList windows = this.getDefaultWindowListLocked();
        int N = dialogs.size();
        for (i = 0; i < N; ++i) {
            pos = this.tmpRemoveWindowLocked(pos, dialogs.get(i));
        }
        if (pos >= 0) {
            AppWindowToken targetAppToken = this.mInputMethodTarget.mAppToken;
            if (this.mInputMethodWindow != null) {
                WindowState wp;
                while (pos < windows.size() && ((wp = (WindowState)windows.get(pos)) == this.mInputMethodWindow || wp.mAttachedWindow == this.mInputMethodWindow)) {
                    ++pos;
                }
            }
            for (int i2 = 0; i2 < N; ++i2) {
                WindowState win = dialogs.get(i2);
                win.mTargetAppToken = targetAppToken;
                pos = this.reAddWindowLocked(pos, win);
            }
            return;
        }
        for (i = 0; i < N; ++i) {
            WindowState win = dialogs.get(i);
            win.mTargetAppToken = null;
            this.reAddWindowToListInOrderLocked(win);
        }
    }

    boolean moveInputMethodWindowsIfNeededLocked(boolean needAssignLayers) {
        WindowState imWin = this.mInputMethodWindow;
        int DN = this.mInputMethodDialogs.size();
        if (imWin == null && DN == 0) {
            return false;
        }
        WindowList windows = this.getDefaultWindowListLocked();
        int imPos = this.findDesiredInputMethodWindowIndexLocked(true);
        if (imPos >= 0) {
            WindowState baseImWin;
            int N = windows.size();
            WindowState firstImWin = imPos < N ? (WindowState)windows.get(imPos) : null;
            WindowState windowState = baseImWin = imWin != null ? imWin : this.mInputMethodDialogs.get(0);
            if (baseImWin.mChildWindows.size() > 0) {
                WindowState cw = (WindowState)baseImWin.mChildWindows.get(0);
                if (cw.mSubLayer < 0) {
                    baseImWin = cw;
                }
            }
            if (firstImWin == baseImWin) {
                int pos;
                for (pos = imPos + 1; pos < N && ((WindowState)windows.get((int)pos)).mIsImWindow; ++pos) {
                }
                ++pos;
                while (pos < N && !((WindowState)windows.get((int)pos)).mIsImWindow) {
                    ++pos;
                }
                if (pos >= N) {
                    if (imWin != null) {
                        imWin.mTargetAppToken = this.mInputMethodTarget.mAppToken;
                    }
                    return false;
                }
            }
            if (imWin != null) {
                imPos = this.tmpRemoveWindowLocked(imPos, imWin);
                imWin.mTargetAppToken = this.mInputMethodTarget.mAppToken;
                this.reAddWindowLocked(imPos, imWin);
                if (DN > 0) {
                    this.moveInputMethodDialogsLocked(imPos + 1);
                }
            } else {
                this.moveInputMethodDialogsLocked(imPos);
            }
        } else if (imWin != null) {
            this.tmpRemoveWindowLocked(0, imWin);
            imWin.mTargetAppToken = null;
            this.reAddWindowToListInOrderLocked(imWin);
            if (DN > 0) {
                this.moveInputMethodDialogsLocked(-1);
            }
        } else {
            this.moveInputMethodDialogsLocked(-1);
        }
        if (needAssignLayers) {
            this.assignLayersLocked(windows);
        }
        return true;
    }

    private boolean isWallpaperVisible(WindowState wallpaperTarget) {
        return wallpaperTarget != null && (!wallpaperTarget.mObscured || wallpaperTarget.mAppToken != null && wallpaperTarget.mAppToken.mAppAnimator.animation != null) || this.mUpperWallpaperTarget != null || this.mLowerWallpaperTarget != null;
    }

    void hideWallpapersLocked(WindowState winGoingAway) {
        if (this.mWallpaperTarget != null && (this.mWallpaperTarget != winGoingAway || this.mLowerWallpaperTarget != null)) {
            return;
        }
        if (this.mAppTransition.isRunning()) {
            this.mDeferredHideWallpaper = winGoingAway;
            return;
        }
        boolean wasDeferred = this.mDeferredHideWallpaper == winGoingAway;
        for (int i = this.mWallpaperTokens.size() - 1; i >= 0; --i) {
            WindowToken token = this.mWallpaperTokens.get(i);
            for (int j = token.windows.size() - 1; j >= 0; --j) {
                WindowState wallpaper = (WindowState)token.windows.get(j);
                WindowStateAnimator winAnimator = wallpaper.mWinAnimator;
                if (winAnimator.mLastHidden && !wasDeferred) continue;
                winAnimator.hide();
                this.dispatchWallpaperVisibility(wallpaper, false);
                DisplayContent displayContent = wallpaper.getDisplayContent();
                if (displayContent == null) continue;
                displayContent.pendingLayoutChanges |= 4;
            }
            token.hidden = true;
        }
    }

    boolean adjustWallpaperWindowsLocked() {
        boolean visible;
        this.mInnerFields.mWallpaperMayChange = false;
        boolean targetChanged = false;
        DisplayInfo displayInfo = this.getDefaultDisplayContentLocked().getDisplayInfo();
        int dw = displayInfo.logicalWidth;
        int dh = displayInfo.logicalHeight;
        WindowList windows = this.getDefaultWindowListLocked();
        int N = windows.size();
        WindowState w = null;
        WindowState foundW = null;
        int foundI = 0;
        WindowState topCurW = null;
        int topCurI = 0;
        int windowDetachedI = -1;
        int i = N;
        while (i > 0) {
            boolean hasWallpaper;
            w = (WindowState)windows.get(--i);
            if (w.mAttrs.type == 2013) {
                if (topCurW != null) continue;
                topCurW = w;
                topCurI = i;
                continue;
            }
            topCurW = null;
            if (w != this.mAnimator.mWindowDetachedWallpaper && w.mAppToken != null && w.mAppToken.hidden && w.mAppToken.mAppAnimator.animation == null) continue;
            boolean bl = hasWallpaper = (w.mAttrs.flags & 0x100000) != 0 || w.mAppToken != null && w.mWinAnimator.mKeyguardGoingAwayAnimation;
            if (hasWallpaper && w.isOnScreen() && (this.mWallpaperTarget == w || w.isDrawFinishedLw())) {
                foundW = w;
                foundI = i;
                if (w != this.mWallpaperTarget || !w.mWinAnimator.isAnimating()) break;
                continue;
            }
            if (w != this.mAnimator.mWindowDetachedWallpaper) continue;
            windowDetachedI = i;
        }
        if (foundW == null && windowDetachedI >= 0) {
            foundW = w;
            foundI = windowDetachedI;
        }
        if (this.mWallpaperTarget != foundW && (this.mLowerWallpaperTarget == null || this.mLowerWallpaperTarget != foundW)) {
            this.mLowerWallpaperTarget = null;
            this.mUpperWallpaperTarget = null;
            WindowState oldW = this.mWallpaperTarget;
            this.mWallpaperTarget = foundW;
            targetChanged = true;
            if (foundW != null && oldW != null) {
                int oldI;
                boolean oldAnim = oldW.isAnimatingLw();
                boolean foundAnim = foundW.isAnimatingLw();
                if (foundAnim && oldAnim && (oldI = windows.indexOf(oldW)) >= 0) {
                    if (foundW.mAppToken != null && foundW.mAppToken.hiddenRequested) {
                        this.mWallpaperTarget = oldW;
                        foundW = oldW;
                        foundI = oldI;
                    } else if (foundI > oldI) {
                        this.mUpperWallpaperTarget = foundW;
                        this.mLowerWallpaperTarget = oldW;
                        foundW = oldW;
                        foundI = oldI;
                    } else {
                        this.mUpperWallpaperTarget = oldW;
                        this.mLowerWallpaperTarget = foundW;
                    }
                }
            }
        } else if (!(this.mLowerWallpaperTarget == null || this.mLowerWallpaperTarget.isAnimatingLw() && this.mUpperWallpaperTarget.isAnimatingLw())) {
            this.mLowerWallpaperTarget = null;
            this.mUpperWallpaperTarget = null;
            this.mWallpaperTarget = foundW;
            targetChanged = true;
        }
        boolean bl = visible = foundW != null;
        if (visible) {
            visible = this.isWallpaperVisible(foundW);
            this.mWallpaperAnimLayerAdjustment = this.mLowerWallpaperTarget == null && foundW.mAppToken != null ? foundW.mAppToken.mAppAnimator.animLayerAdjustment : 0;
            int maxLayer = this.mPolicy.getMaxWallpaperLayer() * 10000 + 1000;
            while (foundI > 0) {
                WindowState wb = (WindowState)windows.get(foundI - 1);
                if (!(wb.mBaseLayer >= maxLayer || wb.mAttachedWindow == foundW || foundW.mAttachedWindow != null && wb.mAttachedWindow == foundW.mAttachedWindow || wb.mAttrs.type == 3 && foundW.mToken != null && wb.mToken == foundW.mToken)) break;
                foundW = wb;
                --foundI;
            }
        }
        if (foundW == null && topCurW != null) {
            foundW = topCurW;
            foundI = topCurI + 1;
        } else {
            WindowState windowState = foundW = foundI > 0 ? (WindowState)windows.get(foundI - 1) : null;
        }
        if (visible) {
            if (this.mWallpaperTarget.mWallpaperX >= 0.0f) {
                this.mLastWallpaperX = this.mWallpaperTarget.mWallpaperX;
                this.mLastWallpaperXStep = this.mWallpaperTarget.mWallpaperXStep;
            }
            if (this.mWallpaperTarget.mWallpaperY >= 0.0f) {
                this.mLastWallpaperY = this.mWallpaperTarget.mWallpaperY;
                this.mLastWallpaperYStep = this.mWallpaperTarget.mWallpaperYStep;
            }
            if (this.mWallpaperTarget.mWallpaperDisplayOffsetX != Integer.MIN_VALUE) {
                this.mLastWallpaperDisplayOffsetX = this.mWallpaperTarget.mWallpaperDisplayOffsetX;
            }
            if (this.mWallpaperTarget.mWallpaperDisplayOffsetY != Integer.MIN_VALUE) {
                this.mLastWallpaperDisplayOffsetY = this.mWallpaperTarget.mWallpaperDisplayOffsetY;
            }
        }
        boolean changed = false;
        for (int curTokenNdx = this.mWallpaperTokens.size() - 1; curTokenNdx >= 0; --curTokenNdx) {
            WindowToken token = this.mWallpaperTokens.get(curTokenNdx);
            if (token.hidden == visible) {
                token.hidden = !visible;
                this.getDefaultDisplayContentLocked().layoutNeeded = true;
            }
            WindowList tokenWindows = token.windows;
            for (int wallpaperNdx = tokenWindows.size() - 1; wallpaperNdx >= 0; --wallpaperNdx) {
                WindowState wallpaper = (WindowState)tokenWindows.get(wallpaperNdx);
                if (visible) {
                    this.updateWallpaperOffsetLocked(wallpaper, dw, dh, false);
                }
                this.dispatchWallpaperVisibility(wallpaper, visible);
                wallpaper.mWinAnimator.mAnimLayer = wallpaper.mLayer + this.mWallpaperAnimLayerAdjustment;
                if (wallpaper == foundW) {
                    foundW = --foundI > 0 ? (WindowState)windows.get(foundI - 1) : null;
                    continue;
                }
                int oldIndex = windows.indexOf(wallpaper);
                if (oldIndex >= 0) {
                    windows.remove(oldIndex);
                    this.mWindowsChanged = true;
                    if (oldIndex < foundI) {
                        --foundI;
                    }
                }
                int insertionIndex = 0;
                if (visible && foundW != null) {
                    int type = foundW.mAttrs.type;
                    int privateFlags = foundW.mAttrs.privateFlags;
                    if ((privateFlags & 0x400) != 0 || type == 2029) {
                        insertionIndex = windows.indexOf(foundW);
                    }
                }
                windows.add(insertionIndex, wallpaper);
                this.mWindowsChanged = true;
                changed = true;
            }
        }
        if (targetChanged) {
            // empty if block
        }
        return changed;
    }

    void setWallpaperAnimLayerAdjustmentLocked(int adj) {
        this.mWallpaperAnimLayerAdjustment = adj;
        for (int curTokenNdx = this.mWallpaperTokens.size() - 1; curTokenNdx >= 0; --curTokenNdx) {
            WindowList windows = this.mWallpaperTokens.get((int)curTokenNdx).windows;
            for (int wallpaperNdx = windows.size() - 1; wallpaperNdx >= 0; --wallpaperNdx) {
                WindowState wallpaper = (WindowState)windows.get(wallpaperNdx);
                wallpaper.mWinAnimator.mAnimLayer = wallpaper.mLayer + adj;
            }
        }
    }

    boolean updateWallpaperOffsetLocked(WindowState wallpaperWin, int dw, int dh, boolean sync) {
        boolean changed;
        block14: {
            int offset;
            changed = false;
            boolean rawChanged = false;
            float wpx = this.mLastWallpaperX >= 0.0f ? this.mLastWallpaperX : 0.5f;
            float wpxs = this.mLastWallpaperXStep >= 0.0f ? this.mLastWallpaperXStep : -1.0f;
            int availw = wallpaperWin.mFrame.right - wallpaperWin.mFrame.left - dw;
            int n = offset = availw > 0 ? -((int)((float)availw * wpx + 0.5f)) : 0;
            if (this.mLastWallpaperDisplayOffsetX != Integer.MIN_VALUE) {
                offset += this.mLastWallpaperDisplayOffsetX;
            }
            boolean bl = changed = wallpaperWin.mXOffset != offset;
            if (changed) {
                wallpaperWin.mXOffset = offset;
            }
            if (wallpaperWin.mWallpaperX != wpx || wallpaperWin.mWallpaperXStep != wpxs) {
                wallpaperWin.mWallpaperX = wpx;
                wallpaperWin.mWallpaperXStep = wpxs;
                rawChanged = true;
            }
            float wpy = this.mLastWallpaperY >= 0.0f ? this.mLastWallpaperY : 0.5f;
            float wpys = this.mLastWallpaperYStep >= 0.0f ? this.mLastWallpaperYStep : -1.0f;
            int availh = wallpaperWin.mFrame.bottom - wallpaperWin.mFrame.top - dh;
            int n2 = offset = availh > 0 ? -((int)((float)availh * wpy + 0.5f)) : 0;
            if (this.mLastWallpaperDisplayOffsetY != Integer.MIN_VALUE) {
                offset += this.mLastWallpaperDisplayOffsetY;
            }
            if (wallpaperWin.mYOffset != offset) {
                changed = true;
                wallpaperWin.mYOffset = offset;
            }
            if (wallpaperWin.mWallpaperY != wpy || wallpaperWin.mWallpaperYStep != wpys) {
                wallpaperWin.mWallpaperY = wpy;
                wallpaperWin.mWallpaperYStep = wpys;
                rawChanged = true;
            }
            if (rawChanged && (wallpaperWin.mAttrs.privateFlags & 4) != 0) {
                try {
                    if (sync) {
                        this.mWaitingOnWallpaper = wallpaperWin;
                    }
                    wallpaperWin.mClient.dispatchWallpaperOffsets(wallpaperWin.mWallpaperX, wallpaperWin.mWallpaperY, wallpaperWin.mWallpaperXStep, wallpaperWin.mWallpaperYStep, sync);
                    if (!sync || this.mWaitingOnWallpaper == null) break block14;
                    long start = SystemClock.uptimeMillis();
                    if (this.mLastWallpaperTimeoutTime + 10000L < start) {
                        try {
                            this.mWindowMap.wait(150L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        if (start + 150L < SystemClock.uptimeMillis()) {
                            Slog.i(TAG, "Timeout waiting for wallpaper to offset: " + wallpaperWin);
                            this.mLastWallpaperTimeoutTime = start;
                        }
                    }
                    this.mWaitingOnWallpaper = null;
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void wallpaperOffsetsComplete(IBinder window) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mWaitingOnWallpaper != null && this.mWaitingOnWallpaper.mClient.asBinder() == window) {
                this.mWaitingOnWallpaper = null;
                this.mWindowMap.notifyAll();
            }
        }
    }

    void updateWallpaperOffsetLocked(WindowState changingTarget, boolean sync) {
        DisplayContent displayContent = changingTarget.getDisplayContent();
        if (displayContent == null) {
            return;
        }
        DisplayInfo displayInfo = displayContent.getDisplayInfo();
        int dw = displayInfo.logicalWidth;
        int dh = displayInfo.logicalHeight;
        WindowState target = this.mWallpaperTarget;
        if (target != null) {
            if (target.mWallpaperX >= 0.0f) {
                this.mLastWallpaperX = target.mWallpaperX;
            } else if (changingTarget.mWallpaperX >= 0.0f) {
                this.mLastWallpaperX = changingTarget.mWallpaperX;
            }
            if (target.mWallpaperY >= 0.0f) {
                this.mLastWallpaperY = target.mWallpaperY;
            } else if (changingTarget.mWallpaperY >= 0.0f) {
                this.mLastWallpaperY = changingTarget.mWallpaperY;
            }
            if (target.mWallpaperDisplayOffsetX != Integer.MIN_VALUE) {
                this.mLastWallpaperDisplayOffsetX = target.mWallpaperDisplayOffsetX;
            } else if (changingTarget.mWallpaperDisplayOffsetX != Integer.MIN_VALUE) {
                this.mLastWallpaperDisplayOffsetX = changingTarget.mWallpaperDisplayOffsetX;
            }
            if (target.mWallpaperDisplayOffsetY != Integer.MIN_VALUE) {
                this.mLastWallpaperDisplayOffsetY = target.mWallpaperDisplayOffsetY;
            } else if (changingTarget.mWallpaperDisplayOffsetY != Integer.MIN_VALUE) {
                this.mLastWallpaperDisplayOffsetY = changingTarget.mWallpaperDisplayOffsetY;
            }
            if (target.mWallpaperXStep >= 0.0f) {
                this.mLastWallpaperXStep = target.mWallpaperXStep;
            } else if (changingTarget.mWallpaperXStep >= 0.0f) {
                this.mLastWallpaperXStep = changingTarget.mWallpaperXStep;
            }
            if (target.mWallpaperYStep >= 0.0f) {
                this.mLastWallpaperYStep = target.mWallpaperYStep;
            } else if (changingTarget.mWallpaperYStep >= 0.0f) {
                this.mLastWallpaperYStep = changingTarget.mWallpaperYStep;
            }
        }
        for (int curTokenNdx = this.mWallpaperTokens.size() - 1; curTokenNdx >= 0; --curTokenNdx) {
            WindowList windows = this.mWallpaperTokens.get((int)curTokenNdx).windows;
            for (int wallpaperNdx = windows.size() - 1; wallpaperNdx >= 0; --wallpaperNdx) {
                WindowState wallpaper = (WindowState)windows.get(wallpaperNdx);
                if (!this.updateWallpaperOffsetLocked(wallpaper, dw, dh, sync)) continue;
                WindowStateAnimator winAnimator = wallpaper.mWinAnimator;
                winAnimator.computeShownFrameLocked();
                winAnimator.setWallpaperOffset(wallpaper.mShownFrame);
                sync = false;
            }
        }
    }

    void dispatchWallpaperVisibility(WindowState wallpaper, boolean visible) {
        if (wallpaper.mWallpaperVisible != visible && (this.mDeferredHideWallpaper == null || visible)) {
            wallpaper.mWallpaperVisible = visible;
            try {
                wallpaper.mClient.dispatchAppVisibility(visible);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    private void updateWallpaperVisibilityLocked() {
        boolean visible = this.isWallpaperVisible(this.mWallpaperTarget);
        DisplayContent displayContent = this.mWallpaperTarget.getDisplayContent();
        if (displayContent == null) {
            return;
        }
        DisplayInfo displayInfo = displayContent.getDisplayInfo();
        int dw = displayInfo.logicalWidth;
        int dh = displayInfo.logicalHeight;
        for (int curTokenNdx = this.mWallpaperTokens.size() - 1; curTokenNdx >= 0; --curTokenNdx) {
            WindowToken token = this.mWallpaperTokens.get(curTokenNdx);
            if (token.hidden == visible) {
                token.hidden = !visible;
                displayContent.layoutNeeded = true;
            }
            WindowList windows = token.windows;
            for (int wallpaperNdx = windows.size() - 1; wallpaperNdx >= 0; --wallpaperNdx) {
                WindowState wallpaper = (WindowState)windows.get(wallpaperNdx);
                if (visible) {
                    this.updateWallpaperOffsetLocked(wallpaper, dw, dh, false);
                }
                this.dispatchWallpaperVisibility(wallpaper, visible);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addWindow(Session session, IWindow client, int seq, WindowManager.LayoutParams attrs, int viewVisibility, int displayId, Rect outContentInsets, Rect outStableInsets, Rect outOutsets, InputChannel outInputChannel) {
        long origId;
        int[] appOp = new int[1];
        int res = this.mPolicy.checkAddPermission(attrs, appOp);
        if (res != 0) {
            return res;
        }
        boolean reportNewConfig = false;
        WindowState attachedWindow = null;
        int type = attrs.type;
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            int startOpResult;
            if (!this.mDisplayReady) {
                throw new IllegalStateException("Display has not been initialialized");
            }
            DisplayContent displayContent = this.getDisplayContentLocked(displayId);
            if (displayContent == null) {
                Slog.w(TAG, "Attempted to add window to a display that does not exist: " + displayId + ".  Aborting.");
                return -9;
            }
            if (!displayContent.hasAccess(session.mUid)) {
                Slog.w(TAG, "Attempted to add window to a display for which the application does not have access: " + displayId + ".  Aborting.");
                return -9;
            }
            if (this.mWindowMap.containsKey(client.asBinder())) {
                Slog.w(TAG, "Window " + client + " is already added");
                return -5;
            }
            if (type >= 1000 && type <= 1999) {
                attachedWindow = this.windowForClientLocked(null, attrs.token, false);
                if (attachedWindow == null) {
                    Slog.w(TAG, "Attempted to add window with token that is not a window: " + attrs.token + ".  Aborting.");
                    return -2;
                }
                if (attachedWindow.mAttrs.type >= 1000 && attachedWindow.mAttrs.type <= 1999) {
                    Slog.w(TAG, "Attempted to add window with token that is a sub-window: " + attrs.token + ".  Aborting.");
                    return -2;
                }
            }
            if (type == 2030 && !displayContent.isPrivate()) {
                Slog.w(TAG, "Attempted to add private presentation window to a non-private display.  Aborting.");
                return -8;
            }
            boolean addToken = false;
            WindowToken token = this.mTokenMap.get(attrs.token);
            if (token == null) {
                if (type >= 1 && type <= 99) {
                    Slog.w(TAG, "Attempted to add application window with unknown token " + attrs.token + ".  Aborting.");
                    return -1;
                }
                if (type == 2011) {
                    Slog.w(TAG, "Attempted to add input method window with unknown token " + attrs.token + ".  Aborting.");
                    return -1;
                }
                if (type == 2031) {
                    Slog.w(TAG, "Attempted to add voice interaction window with unknown token " + attrs.token + ".  Aborting.");
                    return -1;
                }
                if (type == 2013) {
                    Slog.w(TAG, "Attempted to add wallpaper window with unknown token " + attrs.token + ".  Aborting.");
                    return -1;
                }
                if (type == 2023) {
                    Slog.w(TAG, "Attempted to add Dream window with unknown token " + attrs.token + ".  Aborting.");
                    return -1;
                }
                if (type == 2032) {
                    Slog.w(TAG, "Attempted to add Accessibility overlay window with unknown token " + attrs.token + ".  Aborting.");
                    return -1;
                }
                token = new WindowToken(this, attrs.token, -1, false);
                addToken = true;
            } else if (type >= 1 && type <= 99) {
                AppWindowToken atoken = token.appWindowToken;
                if (atoken == null) {
                    Slog.w(TAG, "Attempted to add window with non-application token " + token + ".  Aborting.");
                    return -3;
                }
                if (atoken.removed) {
                    Slog.w(TAG, "Attempted to add window with exiting application token " + token + ".  Aborting.");
                    return -4;
                }
                if (type == 3 && atoken.firstWindowDrawn) {
                    return -6;
                }
            } else if (type == 2011) {
                if (token.windowType != 2011) {
                    Slog.w(TAG, "Attempted to add input method window with bad token " + attrs.token + ".  Aborting.");
                    return -1;
                }
            } else if (type == 2031) {
                if (token.windowType != 2031) {
                    Slog.w(TAG, "Attempted to add voice interaction window with bad token " + attrs.token + ".  Aborting.");
                    return -1;
                }
            } else if (type == 2013) {
                if (token.windowType != 2013) {
                    Slog.w(TAG, "Attempted to add wallpaper window with bad token " + attrs.token + ".  Aborting.");
                    return -1;
                }
            } else if (type == 2023) {
                if (token.windowType != 2023) {
                    Slog.w(TAG, "Attempted to add Dream window with bad token " + attrs.token + ".  Aborting.");
                    return -1;
                }
            } else if (type == 2032) {
                if (token.windowType != 2032) {
                    Slog.w(TAG, "Attempted to add Accessibility overlay window with bad token " + attrs.token + ".  Aborting.");
                    return -1;
                }
            } else if (token.appWindowToken != null) {
                Slog.w(TAG, "Non-null appWindowToken for system window of type=" + type);
                attrs.token = null;
                token = new WindowToken(this, null, -1, false);
                addToken = true;
            }
            WindowState win = new WindowState(this, session, client, token, attachedWindow, appOp[0], seq, attrs, viewVisibility, displayContent);
            if (win.mDeathRecipient == null) {
                Slog.w(TAG, "Adding window client " + client.asBinder() + " that is dead, aborting.");
                return -4;
            }
            if (win.getDisplayContent() == null) {
                Slog.w(TAG, "Adding window to Display that has been removed.");
                return -9;
            }
            this.mPolicy.adjustWindowParamsLw(win.mAttrs);
            win.setShowToOwnerOnlyLocked(this.mPolicy.checkShowToOwnerOnly(attrs));
            res = this.mPolicy.prepareAddWindowLw(win, attrs);
            if (res != 0) {
                return res;
            }
            if (outInputChannel != null && (attrs.inputFeatures & 2) == 0) {
                String name = win.makeInputChannelName();
                InputChannel[] inputChannels = InputChannel.openInputChannelPair(name);
                win.setInputChannel(inputChannels[0]);
                inputChannels[1].transferTo(outInputChannel);
                this.mInputManager.registerInputChannel(win.mInputChannel, win.mInputWindowHandle);
            }
            res = 0;
            origId = Binder.clearCallingIdentity();
            if (addToken) {
                this.mTokenMap.put(attrs.token, token);
            }
            win.attach();
            this.mWindowMap.put(client.asBinder(), win);
            if (win.mAppOp != -1 && (startOpResult = this.mAppOps.startOpNoThrow(win.mAppOp, win.getOwningUid(), win.getOwningPackage())) != 0 && startOpResult != 3) {
                win.setAppOpVisibilityLw(false);
            }
            if (type == 3 && token.appWindowToken != null) {
                token.appWindowToken.startingWindow = win;
            }
            boolean imMayMove = true;
            if (type == 2011) {
                win.mGivenInsetsPending = true;
                this.mInputMethodWindow = win;
                this.addInputMethodWindowToListLocked(win);
                imMayMove = false;
            } else if (type == 2012) {
                this.mInputMethodDialogs.add(win);
                this.addWindowToListInOrderLocked(win, true);
                this.moveInputMethodDialogsLocked(this.findDesiredInputMethodWindowIndexLocked(true));
                imMayMove = false;
            } else {
                this.addWindowToListInOrderLocked(win, true);
                if (type == 2013) {
                    this.mLastWallpaperTimeoutTime = 0L;
                    displayContent.pendingLayoutChanges |= 4;
                } else if ((attrs.flags & 0x100000) != 0) {
                    displayContent.pendingLayoutChanges |= 4;
                } else if (this.mWallpaperTarget != null && this.mWallpaperTarget.mLayer >= win.mBaseLayer) {
                    displayContent.pendingLayoutChanges |= 4;
                }
            }
            WindowStateAnimator winAnimator = win.mWinAnimator;
            winAnimator.mEnterAnimationPending = true;
            winAnimator.mEnteringAnimation = true;
            if (displayContent.isDefaultDisplay) {
                this.mPolicy.getInsetHintLw(win.mAttrs, this.mRotation, outContentInsets, outStableInsets, outOutsets);
            } else {
                outContentInsets.setEmpty();
                outStableInsets.setEmpty();
            }
            if (this.mInTouchMode) {
                res |= 1;
            }
            if (win.mAppToken == null || !win.mAppToken.clientHidden) {
                res |= 2;
            }
            this.mInputMonitor.setUpdateInputWindowsNeededLw();
            boolean focusChanged = false;
            if (win.canReceiveKeys() && (focusChanged = this.updateFocusedWindowLocked(1, false))) {
                imMayMove = false;
            }
            if (imMayMove) {
                this.moveInputMethodWindowsIfNeededLocked(false);
            }
            this.assignLayersLocked(displayContent.getWindowList());
            if (focusChanged) {
                this.mInputMonitor.setInputFocusLw(this.mCurrentFocus, false);
            }
            this.mInputMonitor.updateInputWindowsLw(false);
            if (win.isVisibleOrAdding() && this.updateOrientationFromAppTokensLocked(false)) {
                reportNewConfig = true;
            }
        }
        if (reportNewConfig) {
            this.sendNewConfiguration();
        }
        Binder.restoreCallingIdentity(origId);
        return res;
    }

    boolean isScreenCaptureDisabledLocked(int userId) {
        Boolean disabled = this.mScreenCaptureDisabled.get(userId);
        if (disabled == null) {
            return false;
        }
        return disabled;
    }

    boolean isSecureLocked(WindowState w) {
        if ((w.mAttrs.flags & 0x2000) != 0) {
            return true;
        }
        return this.isScreenCaptureDisabledLocked(UserHandle.getUserId(w.mOwnerUid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setScreenCaptureDisabled(int userId, boolean disabled) {
        int callingUid = Binder.getCallingUid();
        if (callingUid != 1000) {
            throw new SecurityException("Only system can call setScreenCaptureDisabled.");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mScreenCaptureDisabled.put(userId, disabled);
            for (int displayNdx = this.mDisplayContents.size() - 1; displayNdx >= 0; --displayNdx) {
                WindowList windows = this.mDisplayContents.valueAt(displayNdx).getWindowList();
                for (int winNdx = windows.size() - 1; winNdx >= 0; --winNdx) {
                    WindowState win = (WindowState)windows.get(winNdx);
                    if (!win.mHasSurface || userId != UserHandle.getUserId(win.mOwnerUid)) continue;
                    win.mWinAnimator.setSecureLocked(disabled);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWindow(Session session, IWindow client) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            WindowState win = this.windowForClientLocked(session, client, false);
            if (win == null) {
                return;
            }
            this.removeWindowLocked(win);
        }
    }

    void removeWindowLocked(WindowState win) {
        boolean startingWindow;
        boolean bl = startingWindow = win.mAttrs.type == 3;
        if (startingWindow) {
            // empty if block
        }
        long origId = Binder.clearCallingIdentity();
        win.disposeInputChannel();
        boolean wasVisible = false;
        if (win.mHasSurface && this.okToDisplay()) {
            boolean lastWinStartingNotAnimating;
            wasVisible = win.isWinVisibleLw();
            if (wasVisible) {
                int transit;
                int n = transit = !startingWindow ? 2 : 5;
                if (win.mWinAnimator.applyAnimationLocked(transit, false)) {
                    win.mExiting = true;
                }
                if (this.mAccessibilityController != null && win.getDisplayId() == 0) {
                    this.mAccessibilityController.onWindowTransitionLocked(win, transit);
                }
            }
            AppWindowToken appToken = win.mAppToken;
            boolean isAnimating = win.mWinAnimator.isAnimating();
            boolean bl2 = lastWinStartingNotAnimating = startingWindow && appToken != null && appToken.allAppWindows.size() == 1 && !isAnimating;
            if (!lastWinStartingNotAnimating && (win.mExiting || isAnimating)) {
                win.mExiting = true;
                win.mRemoveOnExit = true;
                DisplayContent displayContent = win.getDisplayContent();
                if (displayContent != null) {
                    displayContent.layoutNeeded = true;
                }
                boolean focusChanged = this.updateFocusedWindowLocked(3, false);
                this.performLayoutAndPlaceSurfacesLocked();
                if (appToken != null) {
                    appToken.updateReportedVisibilityLocked();
                }
                if (focusChanged) {
                    this.mInputMonitor.updateInputWindowsLw(false);
                }
                Binder.restoreCallingIdentity(origId);
                return;
            }
        }
        this.removeWindowInnerLocked(win);
        if (wasVisible && this.updateOrientationFromAppTokensLocked(false)) {
            this.mH.sendEmptyMessage(18);
        }
        this.updateFocusedWindowLocked(0, true);
        Binder.restoreCallingIdentity(origId);
    }

    void removeWindowInnerLocked(WindowState win) {
        this.removeWindowInnerLocked(win, true);
    }

    void removeWindowInnerLocked(WindowState win, boolean performLayout) {
        if (win.mRemoved) {
            return;
        }
        for (int i = win.mChildWindows.size() - 1; i >= 0; --i) {
            WindowState cwin = (WindowState)win.mChildWindows.get(i);
            Slog.w(TAG, "Force-removing child win " + cwin + " from container " + win);
            this.removeWindowInnerLocked(cwin);
        }
        win.mRemoved = true;
        if (this.mInputMethodTarget == win) {
            this.moveInputMethodWindowsIfNeededLocked(false);
        }
        this.mPolicy.removeWindowLw(win);
        win.removeLocked();
        this.mWindowMap.remove(win.mClient.asBinder());
        if (win.mAppOp != -1) {
            this.mAppOps.finishOp(win.mAppOp, win.getOwningUid(), win.getOwningPackage());
        }
        this.mPendingRemove.remove(win);
        this.mResizingWindows.remove(win);
        this.mWindowsChanged = true;
        if (this.mInputMethodWindow == win) {
            this.mInputMethodWindow = null;
        } else if (win.mAttrs.type == 2012) {
            this.mInputMethodDialogs.remove(win);
        }
        WindowToken token = win.mToken;
        AppWindowToken atoken = win.mAppToken;
        token.windows.remove(win);
        if (atoken != null) {
            atoken.allAppWindows.remove(win);
        }
        if (token.windows.size() == 0) {
            if (!token.explicit) {
                this.mTokenMap.remove(token.token);
            } else if (atoken != null) {
                atoken.firstWindowDrawn = false;
            }
        }
        if (atoken != null) {
            if (atoken.startingWindow == win) {
                this.scheduleRemoveStartingWindowLocked(atoken);
            } else if (atoken.allAppWindows.size() == 0 && atoken.startingData != null) {
                atoken.startingData = null;
            } else if (atoken.allAppWindows.size() == 1 && atoken.startingView != null) {
                this.scheduleRemoveStartingWindowLocked(atoken);
            }
        }
        if (win.mAttrs.type == 2013) {
            this.mLastWallpaperTimeoutTime = 0L;
            this.getDefaultDisplayContentLocked().pendingLayoutChanges |= 4;
        } else if ((win.mAttrs.flags & 0x100000) != 0) {
            this.getDefaultDisplayContentLocked().pendingLayoutChanges |= 4;
        }
        WindowList windows = win.getWindowList();
        if (windows != null) {
            windows.remove(win);
            if (!this.mInLayout) {
                this.assignLayersLocked(windows);
                DisplayContent displayContent = win.getDisplayContent();
                if (displayContent != null) {
                    displayContent.layoutNeeded = true;
                }
                if (performLayout) {
                    this.performLayoutAndPlaceSurfacesLocked();
                }
                if (win.mAppToken != null) {
                    win.mAppToken.updateReportedVisibilityLocked();
                }
            }
        }
        this.mInputMonitor.updateInputWindowsLw(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAppOpsState() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            int numDisplays = this.mDisplayContents.size();
            for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
                WindowList windows = this.mDisplayContents.valueAt(displayNdx).getWindowList();
                int numWindows = windows.size();
                for (int winNdx = 0; winNdx < numWindows; ++winNdx) {
                    WindowState win = (WindowState)windows.get(winNdx);
                    if (win.mAppOp == -1) continue;
                    int mode = this.mAppOps.checkOpNoThrow(win.mAppOp, win.getOwningUid(), win.getOwningPackage());
                    win.setAppOpVisibilityLw(mode == 0 || mode == 3);
                }
            }
        }
    }

    static void logSurface(WindowState w, String msg, RuntimeException where) {
        String str = "  SURFACE " + msg + ": " + w;
        if (where != null) {
            Slog.i(TAG, str, where);
        } else {
            Slog.i(TAG, str);
        }
    }

    static void logSurface(SurfaceControl s, String title, String msg, RuntimeException where) {
        String str = "  SURFACE " + s + ": " + msg + " / " + title;
        if (where != null) {
            Slog.i(TAG, str, where);
        } else {
            Slog.i(TAG, str);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTransparentRegionWindow(Session session, IWindow client, Region region) {
        long origId = Binder.clearCallingIdentity();
        try {
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                WindowState w = this.windowForClientLocked(session, client, false);
                if (w != null && w.mHasSurface) {
                    w.mWinAnimator.setTransparentRegionHintLocked(region);
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInsetsWindow(Session session, IWindow client, int touchableInsets, Rect contentInsets, Rect visibleInsets, Region touchableRegion) {
        long origId = Binder.clearCallingIdentity();
        try {
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                WindowState w = this.windowForClientLocked(session, client, false);
                if (w != null) {
                    DisplayContent displayContent;
                    w.mGivenInsetsPending = false;
                    w.mGivenContentInsets.set(contentInsets);
                    w.mGivenVisibleInsets.set(visibleInsets);
                    w.mGivenTouchableRegion.set(touchableRegion);
                    w.mTouchableInsets = touchableInsets;
                    if (w.mGlobalScale != 1.0f) {
                        w.mGivenContentInsets.scale(w.mGlobalScale);
                        w.mGivenVisibleInsets.scale(w.mGlobalScale);
                        w.mGivenTouchableRegion.scale(w.mGlobalScale);
                    }
                    if ((displayContent = w.getDisplayContent()) != null) {
                        displayContent.layoutNeeded = true;
                    }
                    this.performLayoutAndPlaceSurfacesLocked();
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getWindowDisplayFrame(Session session, IWindow client, Rect outDisplayFrame) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            WindowState win = this.windowForClientLocked(session, client, false);
            if (win == null) {
                outDisplayFrame.setEmpty();
                return;
            }
            outDisplayFrame.set(win.mDisplayFrame);
        }
    }

    public void setWindowWallpaperPositionLocked(WindowState window, float x, float y, float xStep, float yStep) {
        if (window.mWallpaperX != x || window.mWallpaperY != y) {
            window.mWallpaperX = x;
            window.mWallpaperY = y;
            window.mWallpaperXStep = xStep;
            window.mWallpaperYStep = yStep;
            this.updateWallpaperOffsetLocked(window, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void wallpaperCommandComplete(IBinder window, Bundle result) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mWaitingOnWallpaper != null && this.mWaitingOnWallpaper.mClient.asBinder() == window) {
                this.mWaitingOnWallpaper = null;
                this.mWindowMap.notifyAll();
            }
        }
    }

    public void setWindowWallpaperDisplayOffsetLocked(WindowState window, int x, int y) {
        if (window.mWallpaperDisplayOffsetX != x || window.mWallpaperDisplayOffsetY != y) {
            window.mWallpaperDisplayOffsetX = x;
            window.mWallpaperDisplayOffsetY = y;
            this.updateWallpaperOffsetLocked(window, true);
        }
    }

    public Bundle sendWindowWallpaperCommandLocked(WindowState window, String action, int x, int y, int z, Bundle extras, boolean sync) {
        if (window == this.mWallpaperTarget || window == this.mLowerWallpaperTarget || window == this.mUpperWallpaperTarget) {
            boolean doWait = sync;
            for (int curTokenNdx = this.mWallpaperTokens.size() - 1; curTokenNdx >= 0; --curTokenNdx) {
                WindowList windows = this.mWallpaperTokens.get((int)curTokenNdx).windows;
                for (int wallpaperNdx = windows.size() - 1; wallpaperNdx >= 0; --wallpaperNdx) {
                    WindowState wallpaper = (WindowState)windows.get(wallpaperNdx);
                    try {
                        wallpaper.mClient.dispatchWallpaperCommand(action, x, y, z, extras, sync);
                        sync = false;
                        continue;
                    }
                    catch (RemoteException e) {
                        // empty catch block
                    }
                }
            }
            if (doWait) {
                // empty if block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRectangleOnScreenRequested(IBinder token, Rect rectangle) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            WindowState window;
            if (this.mAccessibilityController != null && (window = this.mWindowMap.get(token)) != null && window.getDisplayId() == 0) {
                this.mAccessibilityController.onRectangleOnScreenRequestedLocked(rectangle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IWindowId getWindowId(IBinder token) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            WindowState window = this.mWindowMap.get(token);
            return window != null ? window.mWindowId : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pokeDrawLock(Session session, IBinder token) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            WindowState window = this.windowForClientLocked(session, token, false);
            if (window != null) {
                window.pokeDrawLockLw(this.mDrawLockTimeoutMillis);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int relayoutWindow(Session session, IWindow client, int seq, WindowManager.LayoutParams attrs, int requestedWidth, int requestedHeight, int viewVisibility, int flags, Rect outFrame, Rect outOverscanInsets, Rect outContentInsets, Rect outVisibleInsets, Rect outStableInsets, Rect outOutsets, Configuration outConfig, Surface outSurface) {
        boolean inTouchMode;
        boolean configChanged;
        boolean toBeDisplayed = false;
        boolean surfaceChanged = false;
        boolean hasStatusBarPermission = this.mContext.checkCallingOrSelfPermission("android.permission.STATUS_BAR") == 0;
        long origId = Binder.clearCallingIdentity();
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            DisplayContent displayContent;
            boolean scaledWindow;
            WindowState win = this.windowForClientLocked(session, client, false);
            if (win == null) {
                return 0;
            }
            WindowStateAnimator winAnimator = win.mWinAnimator;
            if (viewVisibility != 8 && (win.mRequestedWidth != requestedWidth || win.mRequestedHeight != requestedHeight)) {
                win.mLayoutNeeded = true;
                win.mRequestedWidth = requestedWidth;
                win.mRequestedHeight = requestedHeight;
            }
            if (attrs != null) {
                this.mPolicy.adjustWindowParamsLw(attrs);
            }
            int systemUiVisibility = 0;
            if (attrs != null && ((systemUiVisibility = attrs.systemUiVisibility | attrs.subtreeSystemUiVisibility) & 0x3FF0000) != 0 && !hasStatusBarPermission) {
                systemUiVisibility &= 0xFC00FFFF;
            }
            if (attrs != null && seq == win.mSeq) {
                win.mSystemUiVisibility = systemUiVisibility;
            }
            winAnimator.mSurfaceDestroyDeferred = (flags & 2) != 0;
            int attrChanges = 0;
            int flagChanges = 0;
            if (attrs != null) {
                if (win.mAttrs.type != attrs.type) {
                    throw new IllegalArgumentException("Window type can not be changed after the window is added.");
                }
                flagChanges = win.mAttrs.flags ^= attrs.flags;
                attrChanges = win.mAttrs.copyFrom(attrs);
                if ((attrChanges & 0x4001) != 0) {
                    win.mLayoutNeeded = true;
                }
            }
            boolean bl = win.mEnforceSizeCompat = (win.mAttrs.privateFlags & 0x80) != 0;
            if ((attrChanges & 0x80) != 0) {
                winAnimator.mAlpha = attrs.alpha;
            }
            boolean bl2 = scaledWindow = (win.mAttrs.flags & 0x4000) != 0;
            if (scaledWindow) {
                win.mHScale = attrs.width != requestedWidth ? (float)attrs.width / (float)requestedWidth : 1.0f;
                win.mVScale = attrs.height != requestedHeight ? (float)attrs.height / (float)requestedHeight : 1.0f;
            } else {
                win.mVScale = 1.0f;
                win.mHScale = 1.0f;
            }
            boolean imMayMove = (flagChanges & 0x20008) != 0;
            boolean isDefaultDisplay = win.isDefaultDisplay();
            boolean focusMayChange = isDefaultDisplay && (win.mViewVisibility != viewVisibility || (flagChanges & 8) != 0 || !win.mRelayoutCalled);
            boolean wallpaperMayMove = win.mViewVisibility != viewVisibility && (win.mAttrs.flags & 0x100000) != 0;
            wallpaperMayMove |= (flagChanges & 0x100000) != 0;
            if ((flagChanges & 0x2000) != 0 && winAnimator.mSurfaceControl != null) {
                winAnimator.mSurfaceControl.setSecure(this.isSecureLocked(win));
            }
            win.mRelayoutCalled = true;
            int oldVisibility = win.mViewVisibility;
            win.mViewVisibility = viewVisibility;
            if (!(viewVisibility != 0 || win.mAppToken != null && win.mAppToken.clientHidden)) {
                boolean bl3 = toBeDisplayed = !win.isVisibleLw();
                if (win.mExiting) {
                    winAnimator.cancelExitAnimationForNextAnimationLocked();
                    win.mExiting = false;
                }
                if (win.mDestroying) {
                    win.mDestroying = false;
                    this.mDestroySurface.remove(win);
                }
                if (oldVisibility == 8) {
                    winAnimator.mEnterAnimationPending = true;
                }
                winAnimator.mEnteringAnimation = true;
                if (toBeDisplayed) {
                    if ((win.mAttrs.softInputMode & 0xF0) == 16) {
                        win.mLayoutNeeded = true;
                    }
                    if (win.isDrawnLw() && this.okToDisplay()) {
                        winAnimator.applyEnterAnimationLocked();
                    }
                    if ((win.mAttrs.flags & 0x200000) != 0) {
                        win.mTurnOnScreen = true;
                    }
                    if (win.isConfigChanged()) {
                        outConfig.setTo(this.mCurConfiguration);
                    }
                }
                if ((attrChanges & 8) != 0 && !winAnimator.tryChangeFormatInPlaceLocked()) {
                    winAnimator.destroySurfaceLocked();
                    toBeDisplayed = true;
                    surfaceChanged = true;
                }
                try {
                    SurfaceControl surfaceControl;
                    if (!win.mHasSurface) {
                        surfaceChanged = true;
                    }
                    if ((surfaceControl = winAnimator.createSurfaceLocked()) != null) {
                        outSurface.copyFrom(surfaceControl);
                    } else {
                        outSurface.release();
                    }
                }
                catch (Exception e) {
                    this.mInputMonitor.updateInputWindowsLw(true);
                    Slog.w(TAG, "Exception thrown when creating surface for client " + client + " (" + win.mAttrs.getTitle() + ")", e);
                    Binder.restoreCallingIdentity(origId);
                    return 0;
                }
                if (toBeDisplayed) {
                    focusMayChange = isDefaultDisplay;
                }
                if (win.mAttrs.type == 2011 && this.mInputMethodWindow == null) {
                    this.mInputMethodWindow = win;
                    imMayMove = true;
                }
                if (win.mAttrs.type == 1 && win.mAppToken != null && win.mAppToken.startingWindow != null) {
                    int mask = 4718593;
                    WindowManager.LayoutParams sa = win.mAppToken.startingWindow.mAttrs;
                    sa.flags = sa.flags & 0xFFB7FFFE | win.mAttrs.flags & 0x480001;
                }
            } else {
                winAnimator.mEnterAnimationPending = false;
                winAnimator.mEnteringAnimation = false;
                if (winAnimator.mSurfaceControl != null && !win.mExiting) {
                    surfaceChanged = true;
                    int transit = 2;
                    if (win.mAttrs.type == 3) {
                        transit = 5;
                    }
                    if (win.isWinVisibleLw() && winAnimator.applyAnimationLocked(transit, false)) {
                        focusMayChange = isDefaultDisplay;
                        win.mExiting = true;
                    } else if (win.mWinAnimator.isAnimating()) {
                        win.mExiting = true;
                    } else if (win == this.mWallpaperTarget) {
                        win.mExiting = true;
                        win.mWinAnimator.mAnimating = true;
                    } else {
                        if (this.mInputMethodWindow == win) {
                            this.mInputMethodWindow = null;
                        }
                        winAnimator.destroySurfaceLocked();
                    }
                    if (this.mAccessibilityController != null && win.getDisplayId() == 0) {
                        this.mAccessibilityController.onWindowTransitionLocked(win, transit);
                    }
                }
                outSurface.release();
            }
            if (focusMayChange && this.updateFocusedWindowLocked(3, false)) {
                imMayMove = false;
            }
            if (imMayMove && (this.moveInputMethodWindowsIfNeededLocked(false) || toBeDisplayed)) {
                this.assignLayersLocked(win.getWindowList());
            }
            if (wallpaperMayMove) {
                this.getDefaultDisplayContentLocked().pendingLayoutChanges |= 4;
            }
            if ((displayContent = win.getDisplayContent()) != null) {
                displayContent.layoutNeeded = true;
            }
            win.mGivenInsetsPending = (flags & 1) != 0;
            configChanged = this.updateOrientationFromAppTokensLocked(false);
            this.performLayoutAndPlaceSurfacesLocked();
            if (toBeDisplayed && win.mIsWallpaper) {
                DisplayInfo displayInfo = this.getDefaultDisplayInfoLocked();
                this.updateWallpaperOffsetLocked(win, displayInfo.logicalWidth, displayInfo.logicalHeight, false);
            }
            if (win.mAppToken != null) {
                win.mAppToken.updateReportedVisibilityLocked();
            }
            outFrame.set(win.mCompatFrame);
            outOverscanInsets.set(win.mOverscanInsets);
            outContentInsets.set(win.mContentInsets);
            outVisibleInsets.set(win.mVisibleInsets);
            outStableInsets.set(win.mStableInsets);
            outOutsets.set(win.mOutsets);
            inTouchMode = this.mInTouchMode;
            this.mInputMonitor.updateInputWindowsLw(true);
        }
        if (configChanged) {
            this.sendNewConfiguration();
        }
        Binder.restoreCallingIdentity(origId);
        return (inTouchMode ? 1 : 0) | (toBeDisplayed ? 2 : 0) | (surfaceChanged ? 4 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performDeferredDestroyWindow(Session session, IWindow client) {
        long origId = Binder.clearCallingIdentity();
        try {
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                WindowState win;
                block8: {
                    win = this.windowForClientLocked(session, client, false);
                    if (win != null) break block8;
                    return;
                }
                win.mWinAnimator.destroyDeferredSurfaceLocked();
            }
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean outOfMemoryWindow(Session session, IWindow client) {
        WindowState win;
        long origId;
        block6: {
            boolean bl;
            origId = Binder.clearCallingIdentity();
            try {
                HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
                // MONITORENTER : hashMap
                win = this.windowForClientLocked(session, client, false);
                if (win != null) break block6;
                bl = false;
                // MONITOREXIT : hashMap
            }
            catch (Throwable throwable) {
                Binder.restoreCallingIdentity(origId);
                throw throwable;
            }
            Binder.restoreCallingIdentity(origId);
            return bl;
        }
        boolean bl = this.reclaimSomeSurfaceMemoryLocked(win.mWinAnimator, "from-client", false);
        // MONITOREXIT : hashMap
        Binder.restoreCallingIdentity(origId);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishDrawingWindow(Session session, IWindow client) {
        long origId = Binder.clearCallingIdentity();
        try {
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                WindowState win = this.windowForClientLocked(session, client, false);
                if (win != null && win.mWinAnimator.finishDrawingLocked()) {
                    DisplayContent displayContent;
                    if ((win.mAttrs.flags & 0x100000) != 0) {
                        this.getDefaultDisplayContentLocked().pendingLayoutChanges |= 4;
                    }
                    if ((displayContent = win.getDisplayContent()) != null) {
                        displayContent.layoutNeeded = true;
                    }
                    this.requestTraversalLocked();
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    private boolean applyAnimationLocked(AppWindowToken atoken, WindowManager.LayoutParams lp, int transit, boolean enter, boolean isVoiceInteraction) {
        if (this.okToDisplay()) {
            Animation a;
            DisplayInfo displayInfo = this.getDefaultDisplayInfoLocked();
            int width = displayInfo.appWidth;
            int height = displayInfo.appHeight;
            WindowState win = atoken.findMainWindow();
            Rect containingFrame = new Rect(0, 0, width, height);
            Rect contentInsets = new Rect();
            Rect appFrame = new Rect(0, 0, width, height);
            if (win != null && win.isFullscreen(width, height)) {
                containingFrame.set(win.mContainingFrame);
                contentInsets.set(win.mContentInsets);
                appFrame.set(win.mFrame);
            }
            if (atoken.mLaunchTaskBehind) {
                enter = false;
            }
            if ((a = this.mAppTransition.loadAnimation(lp, transit, enter, width, height, this.mCurConfiguration.orientation, containingFrame, contentInsets, appFrame, isVoiceInteraction)) != null) {
                atoken.mAppAnimator.setAnimation(a, width, height, this.mAppTransition.canSkipFirstFrame());
            }
        } else {
            atoken.mAppAnimator.clearAnimation();
        }
        return atoken.mAppAnimator.animation != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateAppTokens(int stackId, List<TaskGroup> tasks) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            int taskNdx;
            int t = tasks.size() - 1;
            if (t < 0) {
                Slog.w(TAG, "validateAppTokens: empty task list");
                return;
            }
            TaskGroup task = tasks.get(0);
            int taskId = task.taskId;
            Task targetTask = this.mTaskIdToTask.get(taskId);
            DisplayContent displayContent = targetTask.getDisplayContent();
            if (displayContent == null) {
                Slog.w(TAG, "validateAppTokens: no Display for taskId=" + taskId);
                return;
            }
            ArrayList<Task> localTasks = this.mStackIdToStack.get(stackId).getTasks();
            for (taskNdx = localTasks.size() - 1; taskNdx >= 0 && t >= 0; --taskNdx, --t) {
                AppTokenList localTokens = localTasks.get((int)taskNdx).mAppTokens;
                task = tasks.get(t);
                ArrayList<IApplicationToken> tokens = task.tokens;
                DisplayContent lastDisplayContent = displayContent;
                displayContent = this.mTaskIdToTask.get(taskId).getDisplayContent();
                if (displayContent != lastDisplayContent) {
                    Slog.w(TAG, "validateAppTokens: displayContent changed in TaskGroup list!");
                    return;
                }
                int tokenNdx = localTokens.size() - 1;
                int v = task.tokens.size() - 1;
                while (tokenNdx >= 0 && v >= 0) {
                    AppWindowToken atoken = (AppWindowToken)localTokens.get(tokenNdx);
                    if (atoken.removed) {
                        --tokenNdx;
                        continue;
                    }
                    if (tokens.get(v) != atoken.token) break;
                    --tokenNdx;
                    --v;
                }
                if (tokenNdx >= 0 || v >= 0) break;
            }
            if (taskNdx >= 0 || t >= 0) {
                Slog.w(TAG, "validateAppTokens: Mismatch! ActivityManager=" + tasks);
                Slog.w(TAG, "validateAppTokens: Mismatch! WindowManager=" + localTasks);
                Slog.w(TAG, "validateAppTokens: Mismatch! Callers=" + Debug.getCallers(4));
            }
        }
    }

    public void validateStackOrder(Integer[] remoteStackIds) {
    }

    boolean checkCallingPermission(String permission2, String func) {
        if (Binder.getCallingPid() == Process.myPid()) {
            return true;
        }
        if (this.mContext.checkCallingPermission(permission2) == 0) {
            return true;
        }
        String msg = "Permission Denial: " + func + " from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + permission2;
        Slog.w(TAG, msg);
        return false;
    }

    boolean okToDisplay() {
        return !this.mDisplayFrozen && this.mDisplayEnabled && this.mPolicy.isScreenOn();
    }

    AppWindowToken findAppWindowToken(IBinder token) {
        WindowToken wtoken = this.mTokenMap.get(token);
        if (wtoken == null) {
            return null;
        }
        return wtoken.appWindowToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addWindowToken(IBinder token, int type) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "addWindowToken()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            WindowToken wtoken = this.mTokenMap.get(token);
            if (wtoken != null) {
                Slog.w(TAG, "Attempted to add existing input method token: " + token);
                return;
            }
            wtoken = new WindowToken(this, token, type, true);
            this.mTokenMap.put(token, wtoken);
            if (type == 2013) {
                this.mWallpaperTokens.add(wtoken);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeWindowToken(IBinder token) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "removeWindowToken()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        long origId = Binder.clearCallingIdentity();
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            DisplayContent displayContent = null;
            WindowToken wtoken = this.mTokenMap.remove(token);
            if (wtoken != null) {
                boolean delayed = false;
                if (!wtoken.hidden) {
                    int N = wtoken.windows.size();
                    boolean changed = false;
                    for (int i = 0; i < N; ++i) {
                        WindowState win = (WindowState)wtoken.windows.get(i);
                        displayContent = win.getDisplayContent();
                        if (win.mWinAnimator.isAnimating()) {
                            delayed = true;
                        }
                        if (!win.isVisibleNow()) continue;
                        win.mWinAnimator.applyAnimationLocked(2, false);
                        if (this.mAccessibilityController != null && win.isDefaultDisplay()) {
                            this.mAccessibilityController.onWindowTransitionLocked(win, 2);
                        }
                        changed = true;
                        if (displayContent == null) continue;
                        displayContent.layoutNeeded = true;
                    }
                    wtoken.hidden = true;
                    if (changed) {
                        this.performLayoutAndPlaceSurfacesLocked();
                        this.updateFocusedWindowLocked(0, false);
                    }
                    if (delayed && displayContent != null) {
                        displayContent.mExitingTokens.add(wtoken);
                    } else if (wtoken.windowType == 2013) {
                        this.mWallpaperTokens.remove(wtoken);
                    }
                } else if (wtoken.windowType == 2013) {
                    this.mWallpaperTokens.remove(wtoken);
                }
                this.mInputMonitor.updateInputWindowsLw(true);
            } else {
                Slog.w(TAG, "Attempted to remove non-existing token: " + token);
            }
        }
        Binder.restoreCallingIdentity(origId);
    }

    private Task createTaskLocked(int taskId, int stackId, int userId, AppWindowToken atoken) {
        TaskStack stack = this.mStackIdToStack.get(stackId);
        if (stack == null) {
            throw new IllegalArgumentException("addAppToken: invalid stackId=" + stackId);
        }
        EventLog.writeEvent(31001, taskId, stackId);
        Task task = new Task(taskId, stack, userId, this);
        this.mTaskIdToTask.put(taskId, task);
        stack.addTask(task, !atoken.mLaunchTaskBehind, atoken.showForAllUsers);
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAppToken(int addPos, IApplicationToken token, int taskId, int stackId, int requestedOrientation, boolean fullscreen, boolean showForAllUsers, int userId, int configChanges, boolean voiceInteraction, boolean launchTaskBehind) {
        long inputDispatchingTimeoutNanos;
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "addAppToken()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        try {
            inputDispatchingTimeoutNanos = token.getKeyDispatchingTimeout() * 1000000L;
        }
        catch (RemoteException ex) {
            Slog.w(TAG, "Could not get dispatching timeout.", ex);
            inputDispatchingTimeoutNanos = 5000000000L;
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            AppWindowToken atoken = this.findAppWindowToken(token.asBinder());
            if (atoken != null) {
                Slog.w(TAG, "Attempted to add existing app token: " + token);
                return;
            }
            atoken = new AppWindowToken(this, token, voiceInteraction);
            atoken.inputDispatchingTimeoutNanos = inputDispatchingTimeoutNanos;
            atoken.appFullscreen = fullscreen;
            atoken.showForAllUsers = showForAllUsers;
            atoken.requestedOrientation = requestedOrientation;
            atoken.layoutConfigChanges = (configChanges & 0x480) != 0;
            atoken.mLaunchTaskBehind = launchTaskBehind;
            Task task = this.mTaskIdToTask.get(taskId);
            if (task == null) {
                task = this.createTaskLocked(taskId, stackId, userId, atoken);
            }
            task.addAppToken(addPos, atoken);
            this.mTokenMap.put(token.asBinder(), atoken);
            atoken.hidden = true;
            atoken.hiddenRequested = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAppTask(IBinder token, int taskId) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "setAppTask()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            AppWindowToken atoken = this.findAppWindowToken(token);
            if (atoken == null) {
                Slog.w(TAG, "Attempted to set task id of non-existing app token: " + token);
                return;
            }
            Task oldTask = atoken.mTask;
            oldTask.removeAppToken(atoken);
            Task newTask = this.mTaskIdToTask.get(taskId);
            if (newTask == null) {
                newTask = this.createTaskLocked(taskId, oldTask.mStack.mStackId, oldTask.mUserId, atoken);
            }
            newTask.addAppToken(Integer.MAX_VALUE, atoken);
        }
    }

    public int getOrientationLocked() {
        if (this.mDisplayFrozen) {
            if (this.mLastWindowForcedOrientation != -1) {
                return this.mLastWindowForcedOrientation;
            }
        } else {
            int req;
            WindowList windows = this.getDefaultWindowListLocked();
            for (int pos = windows.size() - 1; pos >= 0; --pos) {
                WindowState win = (WindowState)windows.get(pos);
                if (win.mAppToken != null) break;
                if (!win.isVisibleLw() || !win.mPolicyVisibilityAfterAnim || (req = win.mAttrs.screenOrientation) == -1 || req == 3) continue;
                if (this.mPolicy.isKeyguardHostWindow(win.mAttrs)) {
                    this.mLastKeyguardForcedOrientation = req;
                }
                this.mLastWindowForcedOrientation = req;
                return this.mLastWindowForcedOrientation;
            }
            this.mLastWindowForcedOrientation = -1;
            if (this.mPolicy.isKeyguardLocked()) {
                AppWindowToken appShowWhenLocked;
                WindowState winShowWhenLocked = (WindowState)this.mPolicy.getWinShowWhenLockedLw();
                AppWindowToken appWindowToken = appShowWhenLocked = winShowWhenLocked == null ? null : winShowWhenLocked.mAppToken;
                if (appShowWhenLocked != null) {
                    req = appShowWhenLocked.requestedOrientation;
                    if (req == 3) {
                        req = this.mLastKeyguardForcedOrientation;
                    }
                    return req;
                }
                return this.mLastKeyguardForcedOrientation;
            }
        }
        int lastOrientation = -1;
        boolean findingBehind = false;
        boolean lastFullscreen = false;
        DisplayContent displayContent = this.getDefaultDisplayContentLocked();
        ArrayList<Task> tasks = displayContent.getTasks();
        for (int taskNdx = tasks.size() - 1; taskNdx >= 0; --taskNdx) {
            int firstToken;
            AppTokenList tokens = tasks.get((int)taskNdx).mAppTokens;
            for (int tokenNdx = firstToken = tokens.size() - 1; tokenNdx >= 0; --tokenNdx) {
                AppWindowToken atoken = (AppWindowToken)tokens.get(tokenNdx);
                if (!findingBehind && !atoken.hidden && atoken.hiddenRequested) continue;
                if (tokenNdx == firstToken && lastOrientation != 3 && lastFullscreen) {
                    return lastOrientation;
                }
                if (atoken.hiddenRequested || atoken.willBeHidden) continue;
                if (tokenNdx == 0) {
                    lastOrientation = atoken.requestedOrientation;
                }
                int or = atoken.requestedOrientation;
                lastFullscreen = atoken.appFullscreen;
                if (lastFullscreen && or != 3) {
                    return or;
                }
                if (or != -1 && or != 3) {
                    return or;
                }
                findingBehind |= or == 3;
            }
        }
        return this.mForcedAppOrientation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Configuration updateOrientationFromAppTokens(Configuration currentConfig, IBinder freezeThisOneIfNeeded) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "updateOrientationFromAppTokens()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        Configuration config = null;
        long ident = Binder.clearCallingIdentity();
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            config = this.updateOrientationFromAppTokensLocked(currentConfig, freezeThisOneIfNeeded);
        }
        Binder.restoreCallingIdentity(ident);
        return config;
    }

    private Configuration updateOrientationFromAppTokensLocked(Configuration currentConfig, IBinder freezeThisOneIfNeeded) {
        if (!this.mDisplayReady) {
            return null;
        }
        Configuration config = null;
        if (this.updateOrientationFromAppTokensLocked(false)) {
            AppWindowToken atoken;
            if (freezeThisOneIfNeeded != null && (atoken = this.findAppWindowToken(freezeThisOneIfNeeded)) != null) {
                this.startAppFreezingScreenLocked(atoken);
            }
            config = this.computeNewConfigurationLocked();
        } else if (currentConfig != null) {
            this.mTempConfiguration.setToDefaults();
            this.mTempConfiguration.fontScale = currentConfig.fontScale;
            this.computeScreenConfigurationLocked(this.mTempConfiguration);
            if (currentConfig.diff(this.mTempConfiguration) != 0) {
                this.mWaitingForConfig = true;
                DisplayContent displayContent = this.getDefaultDisplayContentLocked();
                displayContent.layoutNeeded = true;
                int[] anim2 = new int[2];
                if (displayContent.isDimming()) {
                    anim2[1] = 0;
                    anim2[0] = 0;
                } else {
                    this.mPolicy.selectRotationAnimationLw(anim2);
                }
                this.startFreezingDisplayLocked(false, anim2[0], anim2[1]);
                config = new Configuration(this.mTempConfiguration);
            }
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateOrientationFromAppTokensLocked(boolean inTransaction) {
        long ident = Binder.clearCallingIdentity();
        try {
            int req = this.getOrientationLocked();
            if (req != this.mForcedAppOrientation) {
                this.mForcedAppOrientation = req;
                this.mPolicy.setCurrentOrientationLw(req);
                if (this.updateRotationUncheckedLocked(inTransaction)) {
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNewConfiguration(Configuration config) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "setNewConfiguration()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mCurConfiguration = new Configuration(config);
            if (this.mWaitingForConfig) {
                this.mWaitingForConfig = false;
                this.mLastFinishedFreezeSource = "new-config";
            }
            this.performLayoutAndPlaceSurfacesLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAppOrientation(IApplicationToken token, int requestedOrientation) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "setAppOrientation()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            AppWindowToken atoken = this.findAppWindowToken(token.asBinder());
            if (atoken == null) {
                Slog.w(TAG, "Attempted to set orientation of non-existing app token: " + token);
                return;
            }
            atoken.requestedOrientation = requestedOrientation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getAppOrientation(IApplicationToken token) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            AppWindowToken wtoken = this.findAppWindowToken(token.asBinder());
            if (wtoken == null) {
                return -1;
            }
            return wtoken.requestedOrientation;
        }
    }

    void setFocusedStackLayer() {
        this.mFocusedStackLayer = 0;
        if (this.mFocusedApp != null) {
            WindowList windows = this.mFocusedApp.allAppWindows;
            for (int i = windows.size() - 1; i >= 0; --i) {
                WindowState win = (WindowState)windows.get(i);
                int animLayer = win.mWinAnimator.mAnimLayer;
                if (win.mAttachedWindow != null || !win.isVisibleLw() || animLayer <= this.mFocusedStackLayer) continue;
                this.mFocusedStackLayer = animLayer + 1;
            }
        }
        this.mFocusedStackFrame.setLayer(this.mFocusedStackLayer);
    }

    void setFocusedStackFrame() {
        TaskStack stack;
        if (this.mFocusedApp != null) {
            Task task = this.mFocusedApp.mTask;
            stack = task.mStack;
            DisplayContent displayContent = task.getDisplayContent();
            if (displayContent != null) {
                displayContent.setTouchExcludeRegion(stack);
            }
        } else {
            stack = null;
        }
        this.mFocusedStackFrame.setVisibility(stack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFocusedApp(IBinder token, boolean moveFocusNow) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "setFocusedApp()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            boolean changed;
            AppWindowToken newFocus;
            if (token == null) {
                newFocus = null;
            } else {
                newFocus = this.findAppWindowToken(token);
                if (newFocus == null) {
                    Slog.w(TAG, "Attempted to set focus to non-existing app token: " + token);
                }
            }
            boolean bl = changed = this.mFocusedApp != newFocus;
            if (changed) {
                this.mFocusedApp = newFocus;
                this.mInputMonitor.setFocusedAppLw(newFocus);
                this.setFocusedStackFrame();
                SurfaceControl.openTransaction();
                try {
                    this.setFocusedStackLayer();
                }
                finally {
                    SurfaceControl.closeTransaction();
                }
            }
            if (moveFocusNow && changed) {
                long origId = Binder.clearCallingIdentity();
                this.updateFocusedWindowLocked(0, true);
                Binder.restoreCallingIdentity(origId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepareAppTransition(int transit, boolean alwaysKeepCurrent) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "prepareAppTransition()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (!this.mAppTransition.isTransitionSet() || this.mAppTransition.isTransitionNone()) {
                this.mAppTransition.setAppTransition(transit);
            } else if (!alwaysKeepCurrent) {
                if (transit == 8 && this.mAppTransition.isTransitionEqual(9)) {
                    this.mAppTransition.setAppTransition(transit);
                } else if (transit == 6 && this.mAppTransition.isTransitionEqual(7)) {
                    this.mAppTransition.setAppTransition(transit);
                }
            }
            if (this.okToDisplay() && this.mAppTransition.prepare()) {
                this.mSkipAppTransitionAnimation = false;
            }
            if (this.mAppTransition.isTransitionSet()) {
                this.mH.removeMessages(13);
                this.mH.sendEmptyMessageDelayed(13, 5000L);
            }
        }
    }

    @Override
    public int getPendingAppTransition() {
        return this.mAppTransition.getAppTransition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void overridePendingAppTransition(String packageName, int enterAnim, int exitAnim, IRemoteCallback startedCallback) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mAppTransition.overridePendingAppTransition(packageName, enterAnim, exitAnim, startedCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void overridePendingAppTransitionScaleUp(int startX, int startY, int startWidth, int startHeight) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mAppTransition.overridePendingAppTransitionScaleUp(startX, startY, startWidth, startHeight);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void overridePendingAppTransitionClipReveal(int startX, int startY, int startWidth, int startHeight) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mAppTransition.overridePendingAppTransitionClipReveal(startX, startY, startWidth, startHeight);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void overridePendingAppTransitionThumb(Bitmap srcThumb, int startX, int startY, IRemoteCallback startedCallback, boolean scaleUp) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mAppTransition.overridePendingAppTransitionThumb(srcThumb, startX, startY, startedCallback, scaleUp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void overridePendingAppTransitionAspectScaledThumb(Bitmap srcThumb, int startX, int startY, int targetWidth, int targetHeight, IRemoteCallback startedCallback, boolean scaleUp) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mAppTransition.overridePendingAppTransitionAspectScaledThumb(srcThumb, startX, startY, targetWidth, targetHeight, startedCallback, scaleUp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void overridePendingAppTransitionInPlace(String packageName, int anim2) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mAppTransition.overrideInPlaceAppTransition(packageName, anim2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeAppTransition() {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "executeAppTransition()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mAppTransition.isTransitionSet()) {
                this.mAppTransition.setReady();
                long origId = Binder.clearCallingIdentity();
                try {
                    this.performLayoutAndPlaceSurfacesLocked();
                }
                finally {
                    Binder.restoreCallingIdentity(origId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAppStartingWindow(IBinder token, String pkg, int theme, CompatibilityInfo compatInfo, CharSequence nonLocalizedLabel, int labelRes, int icon, int logo, int windowFlags, IBinder transferFrom, boolean createIfNeeded) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "setAppStartingWindow()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            AppWindowToken ttoken;
            AppWindowToken wtoken = this.findAppWindowToken(token);
            if (wtoken == null) {
                Slog.w(TAG, "Attempted to set icon of non-existing app token: " + token);
                return;
            }
            if (!this.okToDisplay()) {
                return;
            }
            if (wtoken.startingData != null) {
                return;
            }
            if (transferFrom != null && (ttoken = this.findAppWindowToken(transferFrom)) != null) {
                WindowState startingWindow = ttoken.startingWindow;
                if (startingWindow != null) {
                    this.mSkipAppTransitionAnimation = true;
                    long origId = Binder.clearCallingIdentity();
                    wtoken.startingData = ttoken.startingData;
                    wtoken.startingView = ttoken.startingView;
                    wtoken.startingDisplayed = ttoken.startingDisplayed;
                    ttoken.startingDisplayed = false;
                    wtoken.startingWindow = startingWindow;
                    wtoken.reportedVisible = ttoken.reportedVisible;
                    ttoken.startingData = null;
                    ttoken.startingView = null;
                    ttoken.startingWindow = null;
                    ttoken.startingMoved = true;
                    startingWindow.mToken = wtoken;
                    startingWindow.mRootToken = wtoken;
                    startingWindow.mAppToken = wtoken;
                    startingWindow.getWindowList().remove(startingWindow);
                    this.mWindowsChanged = true;
                    ttoken.windows.remove(startingWindow);
                    ttoken.allAppWindows.remove(startingWindow);
                    this.addWindowToListInOrderLocked(startingWindow, true);
                    if (ttoken.allDrawn) {
                        wtoken.allDrawn = true;
                        wtoken.deferClearAllDrawn = ttoken.deferClearAllDrawn;
                    }
                    if (ttoken.firstWindowDrawn) {
                        wtoken.firstWindowDrawn = true;
                    }
                    if (!ttoken.hidden) {
                        wtoken.hidden = false;
                        wtoken.hiddenRequested = false;
                        wtoken.willBeHidden = false;
                    }
                    if (wtoken.clientHidden != ttoken.clientHidden) {
                        wtoken.clientHidden = ttoken.clientHidden;
                        wtoken.sendAppVisibilityToClients();
                    }
                    ttoken.mAppAnimator.transferCurrentAnimation(wtoken.mAppAnimator, startingWindow.mWinAnimator);
                    this.updateFocusedWindowLocked(3, true);
                    this.getDefaultDisplayContentLocked().layoutNeeded = true;
                    this.performLayoutAndPlaceSurfacesLocked();
                    Binder.restoreCallingIdentity(origId);
                    return;
                }
                if (ttoken.startingData != null) {
                    wtoken.startingData = ttoken.startingData;
                    ttoken.startingData = null;
                    ttoken.startingMoved = true;
                    Message m = this.mH.obtainMessage(5, wtoken);
                    this.mH.sendMessageAtFrontOfQueue(m);
                    return;
                }
                AppWindowAnimator tAppAnimator = ttoken.mAppAnimator;
                AppWindowAnimator wAppAnimator = wtoken.mAppAnimator;
                if (tAppAnimator.thumbnail != null) {
                    if (wAppAnimator.thumbnail != null) {
                        wAppAnimator.thumbnail.destroy();
                    }
                    wAppAnimator.thumbnail = tAppAnimator.thumbnail;
                    wAppAnimator.thumbnailX = tAppAnimator.thumbnailX;
                    wAppAnimator.thumbnailY = tAppAnimator.thumbnailY;
                    wAppAnimator.thumbnailLayer = tAppAnimator.thumbnailLayer;
                    wAppAnimator.thumbnailAnimation = tAppAnimator.thumbnailAnimation;
                    tAppAnimator.thumbnail = null;
                }
            }
            if (!createIfNeeded) {
                return;
            }
            if (theme != 0) {
                AttributeCache.Entry ent = AttributeCache.instance().get(pkg, theme, R.styleable.Window, this.mCurrentUserId);
                if (ent == null) {
                    return;
                }
                boolean windowIsTranslucentDefined = ent.array.hasValue(5);
                boolean windowIsTranslucent = ent.array.getBoolean(5, false);
                boolean windowSwipeToDismiss = ent.array.getBoolean(25, false);
                if (windowIsTranslucent || !windowIsTranslucentDefined && windowSwipeToDismiss) {
                    return;
                }
                if (ent.array.getBoolean(4, false)) {
                    return;
                }
                if (ent.array.getBoolean(14, false)) {
                    if (this.mWallpaperTarget == null) {
                        windowFlags |= 0x100000;
                    } else {
                        return;
                    }
                }
            }
            wtoken.startingData = new StartingData(pkg, theme, compatInfo, nonLocalizedLabel, labelRes, icon, logo, windowFlags);
            Message m = this.mH.obtainMessage(5, wtoken);
            this.mH.sendMessageAtFrontOfQueue(m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAppStartingWindow(IBinder token) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            AppWindowToken wtoken = this.mTokenMap.get((Object)token).appWindowToken;
            if (wtoken.startingWindow != null) {
                this.scheduleRemoveStartingWindowLocked(wtoken);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAppWillBeHidden(IBinder token) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "setAppWillBeHidden()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            AppWindowToken wtoken = this.findAppWindowToken(token);
            if (wtoken == null) {
                Slog.w(TAG, "Attempted to set will be hidden of non-existing app token: " + token);
                return;
            }
            wtoken.willBeHidden = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAppFullscreen(IBinder token, boolean toOpaque) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            AppWindowToken atoken = this.findAppWindowToken(token);
            if (atoken != null) {
                atoken.appFullscreen = toOpaque;
                this.setWindowOpaqueLocked(token, toOpaque);
                this.requestTraversalLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWindowOpaque(IBinder token, boolean isOpaque) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.setWindowOpaqueLocked(token, isOpaque);
        }
    }

    public void setWindowOpaqueLocked(IBinder token, boolean isOpaque) {
        WindowState win;
        AppWindowToken wtoken = this.findAppWindowToken(token);
        if (wtoken != null && (win = wtoken.findMainWindow()) != null) {
            win.mWinAnimator.setOpaqueLocked(isOpaque);
        }
    }

    boolean setTokenVisibilityLocked(AppWindowToken wtoken, WindowManager.LayoutParams lp, boolean visible, int transit, boolean performLayout, boolean isVoiceInteraction) {
        boolean delayed = false;
        if (wtoken.clientHidden == visible) {
            wtoken.clientHidden = !visible;
            wtoken.sendAppVisibilityToClients();
        }
        wtoken.willBeHidden = false;
        if (wtoken.hidden == visible || wtoken.hidden && wtoken.mIsExiting) {
            boolean changed = false;
            boolean runningAppAnimation = false;
            if (transit != -1) {
                WindowState window;
                if (wtoken.mAppAnimator.animation == AppWindowAnimator.sDummyAnimation) {
                    wtoken.mAppAnimator.animation = null;
                }
                if (this.applyAnimationLocked(wtoken, lp, transit, visible, isVoiceInteraction)) {
                    runningAppAnimation = true;
                    delayed = true;
                }
                if ((window = wtoken.findMainWindow()) != null && this.mAccessibilityController != null && window.getDisplayId() == 0) {
                    this.mAccessibilityController.onAppWindowTransitionLocked(window, transit);
                }
                changed = true;
            }
            int windowsCount = wtoken.allAppWindows.size();
            for (int i = 0; i < windowsCount; ++i) {
                DisplayContent displayContent;
                WindowState win = (WindowState)wtoken.allAppWindows.get(i);
                if (win == wtoken.startingWindow) continue;
                if (visible) {
                    if (win.isVisibleNow()) continue;
                    if (!runningAppAnimation) {
                        win.mWinAnimator.applyAnimationLocked(1, true);
                        if (this.mAccessibilityController != null && win.getDisplayId() == 0) {
                            this.mAccessibilityController.onWindowTransitionLocked(win, 1);
                        }
                    }
                    changed = true;
                    displayContent = win.getDisplayContent();
                    if (displayContent == null) continue;
                    displayContent.layoutNeeded = true;
                    continue;
                }
                if (!win.isVisibleNow()) continue;
                if (!runningAppAnimation) {
                    win.mWinAnimator.applyAnimationLocked(2, false);
                    if (this.mAccessibilityController != null && win.getDisplayId() == 0) {
                        this.mAccessibilityController.onWindowTransitionLocked(win, 2);
                    }
                }
                changed = true;
                displayContent = win.getDisplayContent();
                if (displayContent == null) continue;
                displayContent.layoutNeeded = true;
            }
            wtoken.hiddenRequested = !visible;
            wtoken.hidden = wtoken.hiddenRequested;
            if (!visible) {
                this.unsetAppFreezingScreenLocked(wtoken, true, true);
            } else {
                WindowState swin = wtoken.startingWindow;
                if (swin != null && !swin.isDrawnLw()) {
                    swin.mPolicyVisibility = false;
                    swin.mPolicyVisibilityAfterAnim = false;
                }
            }
            if (changed) {
                this.mInputMonitor.setUpdateInputWindowsNeededLw();
                if (performLayout) {
                    this.updateFocusedWindowLocked(3, false);
                    this.performLayoutAndPlaceSurfacesLocked();
                }
                this.mInputMonitor.updateInputWindowsLw(false);
            }
        }
        if (wtoken.mAppAnimator.animation != null) {
            delayed = true;
        }
        for (int i = wtoken.allAppWindows.size() - 1; i >= 0 && !delayed; --i) {
            if (!((WindowState)wtoken.allAppWindows.get((int)i)).mWinAnimator.isWindowAnimating()) continue;
            delayed = true;
        }
        return delayed;
    }

    void updateTokenInPlaceLocked(AppWindowToken wtoken, int transit) {
        if (transit != -1) {
            if (wtoken.mAppAnimator.animation == AppWindowAnimator.sDummyAnimation) {
                wtoken.mAppAnimator.animation = null;
            }
            this.applyAnimationLocked(wtoken, null, transit, false, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAppVisibility(IBinder token, boolean visible) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "setAppVisibility()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            AppWindowToken wtoken = this.findAppWindowToken(token);
            if (wtoken == null) {
                Slog.w(TAG, "Attempted to set visibility of non-existing app token: " + token);
                return;
            }
            this.mOpeningApps.remove(wtoken);
            this.mClosingApps.remove(wtoken);
            wtoken.waitingToShow = false;
            boolean bl = wtoken.hiddenRequested = !visible;
            if (this.okToDisplay() && this.mAppTransition.isTransitionSet()) {
                AppWindowToken focusedToken;
                WindowState win;
                if (!(wtoken.mAppAnimator.usingTransferredAnimation || wtoken.startingDisplayed && !this.mSkipAppTransitionAnimation)) {
                    wtoken.mAppAnimator.setDummyAnimation();
                }
                wtoken.inPendingTransaction = true;
                if (visible) {
                    this.mOpeningApps.add(wtoken);
                    wtoken.startingMoved = false;
                    wtoken.mEnteringAnimation = true;
                    if (wtoken.hidden) {
                        wtoken.allDrawn = false;
                        wtoken.deferClearAllDrawn = false;
                        wtoken.waitingToShow = true;
                        if (wtoken.clientHidden) {
                            wtoken.clientHidden = false;
                            wtoken.sendAppVisibilityToClients();
                        }
                    }
                } else {
                    this.mClosingApps.add(wtoken);
                    wtoken.mEnteringAnimation = false;
                }
                if (this.mAppTransition.getAppTransition() == 16 && (win = this.findFocusedWindowLocked(this.getDefaultDisplayContentLocked())) != null && (focusedToken = win.mAppToken) != null) {
                    focusedToken.hidden = true;
                    this.mOpeningApps.add(focusedToken);
                }
                return;
            }
            long origId = Binder.clearCallingIdentity();
            wtoken.inPendingTransaction = false;
            this.setTokenVisibilityLocked(wtoken, null, visible, -1, true, wtoken.voiceInteraction);
            wtoken.updateReportedVisibilityLocked();
            Binder.restoreCallingIdentity(origId);
        }
    }

    void unsetAppFreezingScreenLocked(AppWindowToken wtoken, boolean unfreezeSurfaceNow, boolean force) {
        if (wtoken.mAppAnimator.freezingScreen) {
            int N = wtoken.allAppWindows.size();
            boolean unfrozeWindows = false;
            for (int i = 0; i < N; ++i) {
                WindowState w = (WindowState)wtoken.allAppWindows.get(i);
                if (!w.mAppFreezing) continue;
                w.mAppFreezing = false;
                if (w.mHasSurface && !w.mOrientationChanging && this.mWindowsFreezingScreen != 2) {
                    w.mOrientationChanging = true;
                    this.mInnerFields.mOrientationChangeComplete = false;
                }
                w.mLastFreezeDuration = 0;
                unfrozeWindows = true;
                DisplayContent displayContent = w.getDisplayContent();
                if (displayContent == null) continue;
                displayContent.layoutNeeded = true;
            }
            if (force || unfrozeWindows) {
                wtoken.mAppAnimator.freezingScreen = false;
                wtoken.mAppAnimator.lastFreezeDuration = (int)(SystemClock.elapsedRealtime() - this.mDisplayFreezeTime);
                --this.mAppsFreezingScreen;
                this.mLastFinishedFreezeSource = wtoken;
            }
            if (unfreezeSurfaceNow) {
                if (unfrozeWindows) {
                    this.performLayoutAndPlaceSurfacesLocked();
                }
                this.stopFreezingDisplayLocked();
            }
        }
    }

    private void startAppFreezingScreenLocked(AppWindowToken wtoken) {
        if (!wtoken.hiddenRequested) {
            if (!wtoken.mAppAnimator.freezingScreen) {
                wtoken.mAppAnimator.freezingScreen = true;
                wtoken.mAppAnimator.lastFreezeDuration = 0;
                ++this.mAppsFreezingScreen;
                if (this.mAppsFreezingScreen == 1) {
                    this.startFreezingDisplayLocked(false, 0, 0);
                    this.mH.removeMessages(17);
                    this.mH.sendEmptyMessageDelayed(17, 2000L);
                }
            }
            int N = wtoken.allAppWindows.size();
            for (int i = 0; i < N; ++i) {
                WindowState w = (WindowState)wtoken.allAppWindows.get(i);
                w.mAppFreezing = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startAppFreezingScreen(IBinder token, int configChanges) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "setAppFreezingScreen()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (configChanges == 0 && this.okToDisplay()) {
                return;
            }
            AppWindowToken wtoken = this.findAppWindowToken(token);
            if (wtoken == null || wtoken.appToken == null) {
                Slog.w(TAG, "Attempted to freeze screen with non-existing app token: " + wtoken);
                return;
            }
            long origId = Binder.clearCallingIdentity();
            this.startAppFreezingScreenLocked(wtoken);
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopAppFreezingScreen(IBinder token, boolean force) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "setAppFreezingScreen()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            AppWindowToken wtoken = this.findAppWindowToken(token);
            if (wtoken == null || wtoken.appToken == null) {
                return;
            }
            long origId = Binder.clearCallingIdentity();
            this.unsetAppFreezingScreenLocked(wtoken, true, force);
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAppToken(IBinder token) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "removeAppToken()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        AppWindowToken wtoken = null;
        AppWindowToken startingToken = null;
        boolean delayed = false;
        long origId = Binder.clearCallingIdentity();
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            WindowToken basewtoken = this.mTokenMap.remove(token);
            if (basewtoken != null && (wtoken = basewtoken.appWindowToken) != null) {
                delayed = this.setTokenVisibilityLocked(wtoken, null, false, -1, true, wtoken.voiceInteraction);
                wtoken.inPendingTransaction = false;
                this.mOpeningApps.remove(wtoken);
                wtoken.waitingToShow = false;
                if (this.mClosingApps.contains(wtoken)) {
                    delayed = true;
                } else if (this.mAppTransition.isTransitionSet()) {
                    this.mClosingApps.add(wtoken);
                    delayed = true;
                }
                TaskStack stack = wtoken.mTask.mStack;
                if (delayed && !wtoken.allAppWindows.isEmpty()) {
                    stack.mExitingAppTokens.add(wtoken);
                    wtoken.mIsExiting = true;
                } else {
                    wtoken.mAppAnimator.clearAnimation();
                    wtoken.mAppAnimator.animating = false;
                    wtoken.removeAppFromTaskLocked();
                }
                wtoken.removed = true;
                if (wtoken.startingData != null) {
                    startingToken = wtoken;
                }
                this.unsetAppFreezingScreenLocked(wtoken, true, true);
                if (this.mFocusedApp == wtoken) {
                    this.mFocusedApp = null;
                    this.updateFocusedWindowLocked(0, true);
                    this.mInputMonitor.setFocusedAppLw(null);
                }
            } else {
                Slog.w(TAG, "Attempted to remove non-existing app token: " + token);
            }
            if (!delayed && wtoken != null) {
                wtoken.updateReportedVisibilityLocked();
            }
            this.scheduleRemoveStartingWindowLocked(startingToken);
        }
        Binder.restoreCallingIdentity(origId);
    }

    void scheduleRemoveStartingWindowLocked(AppWindowToken wtoken) {
        if (this.mH.hasMessages(6, wtoken)) {
            return;
        }
        if (wtoken != null && wtoken.startingWindow != null) {
            Message m = this.mH.obtainMessage(6, wtoken);
            this.mH.sendMessage(m);
        }
    }

    void dumpAppTokensLocked() {
        int numStacks = this.mStackIdToStack.size();
        for (int stackNdx = 0; stackNdx < numStacks; ++stackNdx) {
            TaskStack stack = this.mStackIdToStack.valueAt(stackNdx);
            Slog.v(TAG, "  Stack #" + stack.mStackId + " tasks from bottom to top:");
            ArrayList<Task> tasks = stack.getTasks();
            int numTasks = tasks.size();
            for (int taskNdx = 0; taskNdx < numTasks; ++taskNdx) {
                Task task = tasks.get(taskNdx);
                Slog.v(TAG, "    Task #" + task.mTaskId + " activities from bottom to top:");
                AppTokenList tokens = task.mAppTokens;
                int numTokens = tokens.size();
                for (int tokenNdx = 0; tokenNdx < numTokens; ++tokenNdx) {
                    Slog.v(TAG, "      activity #" + tokenNdx + ": " + ((AppWindowToken)tokens.get((int)tokenNdx)).token);
                }
            }
        }
    }

    void dumpWindowsLocked() {
        int numDisplays = this.mDisplayContents.size();
        for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
            DisplayContent displayContent = this.mDisplayContents.valueAt(displayNdx);
            Slog.v(TAG, " Display #" + displayContent.getDisplayId());
            WindowList windows = displayContent.getWindowList();
            for (int winNdx = windows.size() - 1; winNdx >= 0; --winNdx) {
                Slog.v(TAG, "  #" + winNdx + ": " + windows.get(winNdx));
            }
        }
    }

    private final int reAddWindowLocked(int index, WindowState win) {
        WindowList windows = win.getWindowList();
        int NCW = win.mChildWindows.size();
        boolean winAdded = false;
        for (int j = 0; j < NCW; ++j) {
            WindowState cwin = (WindowState)win.mChildWindows.get(j);
            if (!winAdded && cwin.mSubLayer >= 0) {
                win.mRebuilding = false;
                windows.add(index, win);
                ++index;
                winAdded = true;
            }
            cwin.mRebuilding = false;
            windows.add(index, cwin);
            ++index;
        }
        if (!winAdded) {
            win.mRebuilding = false;
            windows.add(index, win);
            ++index;
        }
        this.mWindowsChanged = true;
        return index;
    }

    private final int reAddAppWindowsLocked(DisplayContent displayContent, int index, WindowToken token) {
        int NW = token.windows.size();
        for (int i = 0; i < NW; ++i) {
            WindowState win = (WindowState)token.windows.get(i);
            DisplayContent winDisplayContent = win.getDisplayContent();
            if (winDisplayContent != displayContent && winDisplayContent != null) continue;
            win.mDisplayContent = displayContent;
            index = this.reAddWindowLocked(index, win);
        }
        return index;
    }

    void moveStackWindowsLocked(DisplayContent displayContent) {
        WindowList windows = displayContent.getWindowList();
        this.mTmpWindows.addAll(windows);
        this.rebuildAppWindowListLocked(displayContent);
        int tmpSize = this.mTmpWindows.size();
        int winSize = windows.size();
        int tmpNdx = 0;
        int winNdx = 0;
        while (tmpNdx < tmpSize && winNdx < winSize) {
            WindowState win;
            WindowState tmp;
            do {
                tmp = this.mTmpWindows.get(tmpNdx++);
            } while (tmpNdx < tmpSize && tmp.mAppToken != null && tmp.mAppToken.mIsExiting);
            do {
                win = (WindowState)windows.get(winNdx++);
            } while (winNdx < winSize && win.mAppToken != null && win.mAppToken.mIsExiting);
            if (tmp == win) continue;
            displayContent.layoutNeeded = true;
            break;
        }
        if (tmpNdx != winNdx) {
            displayContent.layoutNeeded = true;
        }
        this.mTmpWindows.clear();
        if (!this.updateFocusedWindowLocked(3, false)) {
            this.assignLayersLocked(displayContent.getWindowList());
        }
        this.mInputMonitor.setUpdateInputWindowsNeededLw();
        this.performLayoutAndPlaceSurfacesLocked();
        this.mInputMonitor.updateInputWindowsLw(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveTaskToTop(int taskId) {
        long origId = Binder.clearCallingIdentity();
        try {
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                TaskStack homeStack;
                Task task;
                block10: {
                    task = this.mTaskIdToTask.get(taskId);
                    if (task != null) break block10;
                    return;
                }
                TaskStack stack = task.mStack;
                DisplayContent displayContent = task.getDisplayContent();
                displayContent.moveStack(stack, true);
                if (displayContent.isDefaultDisplay && (homeStack = displayContent.getHomeStack()) != stack) {
                    displayContent.moveStack(homeStack, false);
                }
                stack.moveTaskToTop(task);
                if (this.mAppTransition.isTransitionSet()) {
                    task.setSendingToBottom(false);
                }
                this.moveStackWindowsLocked(displayContent);
            }
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveTaskToBottom(int taskId) {
        long origId = Binder.clearCallingIdentity();
        try {
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                Task task;
                block9: {
                    task = this.mTaskIdToTask.get(taskId);
                    if (task != null) break block9;
                    Slog.e(TAG, "moveTaskToBottom: taskId=" + taskId + " not found in mTaskIdToTask");
                    return;
                }
                TaskStack stack = task.mStack;
                stack.moveTaskToBottom(task);
                if (this.mAppTransition.isTransitionSet()) {
                    task.setSendingToBottom(true);
                }
                this.moveStackWindowsLocked(stack.getDisplayContent());
            }
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachStack(int stackId, int displayId) {
        long origId = Binder.clearCallingIdentity();
        try {
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                DisplayContent displayContent = this.mDisplayContents.get(displayId);
                if (displayContent != null) {
                    TaskStack stack = this.mStackIdToStack.get(stackId);
                    if (stack == null) {
                        stack = new TaskStack(this, stackId);
                        this.mStackIdToStack.put(stackId, stack);
                    }
                    stack.attachDisplayContent(displayContent);
                    displayContent.attachStack(stack);
                    this.moveStackWindowsLocked(displayContent);
                    WindowList windows = displayContent.getWindowList();
                    for (int winNdx = windows.size() - 1; winNdx >= 0; --winNdx) {
                        ((WindowState)windows.get(winNdx)).reportResized();
                    }
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    void detachStackLocked(DisplayContent displayContent, TaskStack stack) {
        displayContent.detachStack(stack);
        stack.detachDisplay();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachStack(int stackId) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            DisplayContent displayContent;
            TaskStack stack = this.mStackIdToStack.get(stackId);
            if (stack != null && (displayContent = stack.getDisplayContent()) != null) {
                if (stack.isAnimating()) {
                    stack.mDeferDetach = true;
                    return;
                }
                this.detachStackLocked(displayContent, stack);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStack(int stackId) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mStackIdToStack.remove(stackId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTask(int taskId) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            Task task = this.mTaskIdToTask.get(taskId);
            if (task == null) {
                return;
            }
            task.removeLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(int taskId, int stackId, boolean toTop) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            Task task = this.mTaskIdToTask.get(taskId);
            if (task == null) {
                return;
            }
            TaskStack stack = this.mStackIdToStack.get(stackId);
            stack.addTask(task, toTop);
            DisplayContent displayContent = stack.getDisplayContent();
            displayContent.layoutNeeded = true;
            this.performLayoutAndPlaceSurfacesLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveTaskToStack(int taskId, int stackId, boolean toTop) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            Task task = this.mTaskIdToTask.get(taskId);
            if (task == null) {
                return;
            }
            TaskStack stack = this.mStackIdToStack.get(stackId);
            if (stack == null) {
                return;
            }
            task.moveTaskToStack(stack, toTop);
            DisplayContent displayContent = stack.getDisplayContent();
            displayContent.layoutNeeded = true;
            this.performLayoutAndPlaceSurfacesLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration resizeStack(int stackId, Rect bounds) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            TaskStack stack = this.mStackIdToStack.get(stackId);
            if (stack == null) {
                throw new IllegalArgumentException("resizeStack: stackId " + stackId + " not found.");
            }
            if (stack.setBounds(bounds)) {
                stack.resizeWindows();
                stack.getDisplayContent().layoutNeeded = true;
                this.performLayoutAndPlaceSurfacesLocked();
            }
            return new Configuration(stack.mOverrideConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getStackBounds(int stackId, Rect bounds) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            TaskStack stack = this.mStackIdToStack.get(stackId);
            if (stack != null) {
                stack.getBounds(bounds);
                return;
            }
        }
        bounds.setEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStackIdWithBounds(Rect bounds) {
        Rect stackBounds = new Rect();
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            for (int i = this.mStackIdToStack.size() - 1; i >= 0; --i) {
                TaskStack stack = this.mStackIdToStack.valueAt(i);
                if (stack.mStackId == 0) continue;
                stack.getBounds(stackBounds);
                if (!stackBounds.equals(bounds)) continue;
                return stack.mStackId;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration forceStackToFullscreen(int stackId, boolean forceFullscreen) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            TaskStack stack = this.mStackIdToStack.get(stackId);
            if (stack == null) {
                throw new IllegalArgumentException("resizeStack: stackId " + stackId + " not found.");
            }
            if (stack.forceFullscreen(forceFullscreen)) {
                stack.resizeWindows();
                stack.getDisplayContent().layoutNeeded = true;
                this.performLayoutAndPlaceSurfacesLocked();
            }
            return new Configuration(stack.mOverrideConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startFreezingScreen(int exitAnim, int enterAnim) {
        if (!this.checkCallingPermission("android.permission.FREEZE_SCREEN", "startFreezingScreen()")) {
            throw new SecurityException("Requires FREEZE_SCREEN permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (!this.mClientFreezingScreen) {
                this.mClientFreezingScreen = true;
                long origId = Binder.clearCallingIdentity();
                try {
                    this.startFreezingDisplayLocked(false, exitAnim, enterAnim);
                    this.mH.removeMessages(30);
                    this.mH.sendEmptyMessageDelayed(30, 5000L);
                }
                finally {
                    Binder.restoreCallingIdentity(origId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopFreezingScreen() {
        if (!this.checkCallingPermission("android.permission.FREEZE_SCREEN", "stopFreezingScreen()")) {
            throw new SecurityException("Requires FREEZE_SCREEN permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mClientFreezingScreen) {
                this.mClientFreezingScreen = false;
                this.mLastFinishedFreezeSource = "client";
                long origId = Binder.clearCallingIdentity();
                try {
                    this.stopFreezingDisplayLocked();
                }
                finally {
                    Binder.restoreCallingIdentity(origId);
                }
            }
        }
    }

    @Override
    public void disableKeyguard(IBinder token, String tag) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DISABLE_KEYGUARD") != 0) {
            throw new SecurityException("Requires DISABLE_KEYGUARD permission");
        }
        if (Binder.getCallingUid() != 1000 && this.isKeyguardSecure()) {
            Log.d(TAG, "current mode is SecurityMode, ignore hide keyguard");
            return;
        }
        if (token == null) {
            throw new IllegalArgumentException("token == null");
        }
        this.mKeyguardDisableHandler.sendMessage(this.mKeyguardDisableHandler.obtainMessage(1, new Pair<IBinder, String>(token, tag)));
    }

    @Override
    public void reenableKeyguard(IBinder token) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DISABLE_KEYGUARD") != 0) {
            throw new SecurityException("Requires DISABLE_KEYGUARD permission");
        }
        if (token == null) {
            throw new IllegalArgumentException("token == null");
        }
        this.mKeyguardDisableHandler.sendMessage(this.mKeyguardDisableHandler.obtainMessage(2, token));
    }

    @Override
    public void exitKeyguardSecurely(final IOnKeyguardExitResult callback) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DISABLE_KEYGUARD") != 0) {
            throw new SecurityException("Requires DISABLE_KEYGUARD permission");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback == null");
        }
        this.mPolicy.exitKeyguardSecurely(new WindowManagerPolicy.OnKeyguardExitResult(){

            @Override
            public void onKeyguardExitResult(boolean success) {
                try {
                    callback.onKeyguardExitResult(success);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public boolean inKeyguardRestrictedInputMode() {
        return this.mPolicy.inKeyguardRestrictedKeyInputMode();
    }

    @Override
    public boolean isKeyguardLocked() {
        return this.mPolicy.isKeyguardLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isKeyguardSecure() {
        long origId = Binder.clearCallingIdentity();
        try {
            boolean bl = this.mPolicy.isKeyguardSecure();
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dismissKeyguard() {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DISABLE_KEYGUARD") != 0) {
            throw new SecurityException("Requires DISABLE_KEYGUARD permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mPolicy.dismissKeyguardLw();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyguardGoingAway(boolean disableWindowAnimations, boolean keyguardGoingToNotificationShade) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DISABLE_KEYGUARD") != 0) {
            throw new SecurityException("Requires DISABLE_KEYGUARD permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mAnimator.mKeyguardGoingAway = true;
            this.mAnimator.mKeyguardGoingAwayToNotificationShade = keyguardGoingToNotificationShade;
            this.mAnimator.mKeyguardGoingAwayDisableWindowAnimations = disableWindowAnimations;
            this.requestTraversalLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyguardWaitingForActivityDrawn() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mKeyguardWaitingForActivityDrawn = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyActivityDrawnForKeyguard() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mKeyguardWaitingForActivityDrawn) {
                this.mPolicy.notifyActivityDrawnForKeyguardLw();
                this.mKeyguardWaitingForActivityDrawn = false;
            }
        }
    }

    void showGlobalActions() {
        this.mPolicy.showGlobalActions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeSystemDialogs(String reason) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            int numDisplays = this.mDisplayContents.size();
            for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
                WindowList windows = this.mDisplayContents.valueAt(displayNdx).getWindowList();
                int numWindows = windows.size();
                for (int winNdx = 0; winNdx < numWindows; ++winNdx) {
                    WindowState w = (WindowState)windows.get(winNdx);
                    if (!w.mHasSurface) continue;
                    try {
                        w.mClient.closeSystemDialogs(reason);
                        continue;
                    }
                    catch (RemoteException e) {
                        // empty catch block
                    }
                }
            }
        }
    }

    static float fixScale(float scale) {
        if (scale < 0.0f) {
            scale = 0.0f;
        } else if (scale > 20.0f) {
            scale = 20.0f;
        }
        return Math.abs(scale);
    }

    @Override
    public void setAnimationScale(int which, float scale) {
        if (!this.checkCallingPermission("android.permission.SET_ANIMATION_SCALE", "setAnimationScale()")) {
            throw new SecurityException("Requires SET_ANIMATION_SCALE permission");
        }
        scale = WindowManagerService.fixScale(scale);
        switch (which) {
            case 0: {
                this.mWindowAnimationScaleSetting = scale;
                break;
            }
            case 1: {
                this.mTransitionAnimationScaleSetting = scale;
                break;
            }
            case 2: {
                this.mAnimatorDurationScaleSetting = scale;
            }
        }
        this.mH.sendEmptyMessage(14);
    }

    @Override
    public void setAnimationScales(float[] scales) {
        if (!this.checkCallingPermission("android.permission.SET_ANIMATION_SCALE", "setAnimationScale()")) {
            throw new SecurityException("Requires SET_ANIMATION_SCALE permission");
        }
        if (scales != null) {
            if (scales.length >= 1) {
                this.mWindowAnimationScaleSetting = WindowManagerService.fixScale(scales[0]);
            }
            if (scales.length >= 2) {
                this.mTransitionAnimationScaleSetting = WindowManagerService.fixScale(scales[1]);
            }
            if (scales.length >= 3) {
                this.mAnimatorDurationScaleSetting = WindowManagerService.fixScale(scales[2]);
                this.dispatchNewAnimatorScaleLocked(null);
            }
        }
        this.mH.sendEmptyMessage(14);
    }

    private void setAnimatorDurationScale(float scale) {
        this.mAnimatorDurationScaleSetting = scale;
        ValueAnimator.setDurationScale(scale);
    }

    public float getWindowAnimationScaleLocked() {
        return this.mAnimationsDisabled ? 0.0f : this.mWindowAnimationScaleSetting;
    }

    public float getTransitionAnimationScaleLocked() {
        return this.mAnimationsDisabled ? 0.0f : this.mTransitionAnimationScaleSetting;
    }

    @Override
    public float getAnimationScale(int which) {
        switch (which) {
            case 0: {
                return this.mWindowAnimationScaleSetting;
            }
            case 1: {
                return this.mTransitionAnimationScaleSetting;
            }
            case 2: {
                return this.mAnimatorDurationScaleSetting;
            }
        }
        return 0.0f;
    }

    @Override
    public float[] getAnimationScales() {
        return new float[]{this.mWindowAnimationScaleSetting, this.mTransitionAnimationScaleSetting, this.mAnimatorDurationScaleSetting};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getCurrentAnimatorScale() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            return this.mAnimationsDisabled ? 0.0f : this.mAnimatorDurationScaleSetting;
        }
    }

    void dispatchNewAnimatorScaleLocked(Session session) {
        this.mH.obtainMessage(34, session).sendToTarget();
    }

    @Override
    public void registerPointerEventListener(WindowManagerPolicy.PointerEventListener listener) {
        this.mPointerEventDispatcher.registerInputEventListener(listener);
    }

    @Override
    public void unregisterPointerEventListener(WindowManagerPolicy.PointerEventListener listener) {
        this.mPointerEventDispatcher.unregisterInputEventListener(listener);
    }

    @Override
    public int getLidState() {
        int sw = this.mInputManager.getSwitchState(-1, -256, 0);
        if (sw > 0) {
            return 0;
        }
        if (sw == 0) {
            return 1;
        }
        return -1;
    }

    @Override
    public int getCameraLensCoverState() {
        int sw = this.mInputManager.getSwitchState(-1, -256, 9);
        if (sw > 0) {
            return 1;
        }
        if (sw == 0) {
            return 0;
        }
        return -1;
    }

    @Override
    public void switchKeyboardLayout(int deviceId, int direction) {
        this.mInputManager.switchKeyboardLayout(deviceId, direction);
    }

    @Override
    public void shutdown(boolean confirm) {
        ShutdownThread.shutdown(this.mContext, confirm);
    }

    @Override
    public void rebootSafeMode(boolean confirm) {
        ShutdownThread.rebootSafeMode(this.mContext, confirm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentProfileIds(int[] currentProfileIds) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mCurrentProfileIds = currentProfileIds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentUser(int newUserId, int[] currentProfileIds) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mCurrentUserId = newUserId;
            this.mCurrentProfileIds = currentProfileIds;
            this.mAppTransition.setCurrentUser(newUserId);
            this.mPolicy.setCurrentUserLw(newUserId);
            int numDisplays = this.mDisplayContents.size();
            for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
                DisplayContent displayContent = this.mDisplayContents.valueAt(displayNdx);
                displayContent.switchUserStacks();
                this.rebuildAppWindowListLocked(displayContent);
            }
            this.performLayoutAndPlaceSurfacesLocked();
        }
    }

    boolean isCurrentProfileLocked(int userId) {
        if (userId == this.mCurrentUserId) {
            return true;
        }
        for (int i = 0; i < this.mCurrentProfileIds.length; ++i) {
            if (this.mCurrentProfileIds[i] != userId) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableScreenAfterBoot() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mSystemBooted) {
                return;
            }
            this.mSystemBooted = true;
            this.hideBootMessagesLocked();
            this.mH.sendEmptyMessageDelayed(23, 30000L);
        }
        this.mPolicy.systemBooted();
        this.performEnableScreen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enableScreenIfNeeded() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.enableScreenIfNeededLocked();
        }
    }

    void enableScreenIfNeededLocked() {
        if (this.mDisplayEnabled) {
            return;
        }
        if (!this.mSystemBooted && !this.mShowingBootMessages) {
            return;
        }
        this.mH.sendEmptyMessage(16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performBootTimeout() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mDisplayEnabled) {
                return;
            }
            Slog.w(TAG, "***** BOOT TIMEOUT: forcing display enabled");
            this.mForceDisplayEnabled = true;
        }
        this.performEnableScreen();
    }

    private boolean checkWaitingForWindowsLocked() {
        boolean haveBootMsg = false;
        boolean haveApp = false;
        boolean haveWallpaper = false;
        boolean wallpaperEnabled = this.mContext.getResources().getBoolean(17956936) && !this.mOnlyCore;
        boolean haveKeyguard = true;
        WindowList windows = this.getDefaultWindowListLocked();
        int N = windows.size();
        for (int i = 0; i < N; ++i) {
            WindowState w = (WindowState)windows.get(i);
            if (w.isVisibleLw() && !w.mObscured && !w.isDrawnLw()) {
                return true;
            }
            if (!w.isDrawnLw()) continue;
            if (w.mAttrs.type == 2021) {
                haveBootMsg = true;
                continue;
            }
            if (w.mAttrs.type == 2) {
                haveApp = true;
                continue;
            }
            if (w.mAttrs.type == 2013) {
                haveWallpaper = true;
                continue;
            }
            if (w.mAttrs.type != 2000) continue;
            haveKeyguard = this.mPolicy.isKeyguardDrawnLw();
        }
        if (!this.mSystemBooted && !haveBootMsg) {
            return true;
        }
        return this.mSystemBooted && (!haveApp && !haveKeyguard || wallpaperEnabled && !haveWallpaper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performEnableScreen() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mDisplayEnabled) {
                return;
            }
            if (!this.mSystemBooted && !this.mShowingBootMessages) {
                return;
            }
            if (!this.mForceDisplayEnabled && this.checkWaitingForWindowsLocked()) {
                return;
            }
            if (!this.mBootAnimationStopped) {
                try {
                    IBinder surfaceFlinger = ServiceManager.getService("SurfaceFlinger");
                    if (surfaceFlinger != null) {
                        Parcel data = Parcel.obtain();
                        data.writeInterfaceToken("android.ui.ISurfaceComposer");
                        surfaceFlinger.transact(1, data, null, 0);
                        data.recycle();
                    }
                }
                catch (RemoteException ex) {
                    Slog.e(TAG, "Boot completed: SurfaceFlinger is dead!");
                }
                this.mBootAnimationStopped = true;
            }
            if (!this.mForceDisplayEnabled && !this.checkBootAnimationCompleteLocked()) {
                return;
            }
            this.mDisplayEnabled = true;
            this.mInputMonitor.setEventDispatchingLw(this.mEventDispatchingEnabled);
        }
        try {
            this.mActivityManager.bootAnimationComplete();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.mPolicy.enableScreenAfterBoot();
        this.updateRotationUnchecked(false, false);
    }

    private boolean checkBootAnimationCompleteLocked() {
        if (SystemService.isRunning(BOOT_ANIMATION_SERVICE)) {
            this.mH.removeMessages(37);
            this.mH.sendEmptyMessageDelayed(37, 200L);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showBootMessage(CharSequence msg, boolean always) {
        boolean first = false;
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (!this.mAllowBootMessages) {
                return;
            }
            if (!this.mShowingBootMessages) {
                if (!always) {
                    return;
                }
                first = true;
            }
            if (this.mSystemBooted) {
                return;
            }
            this.mShowingBootMessages = true;
            this.mPolicy.showBootMessage(msg, always);
        }
        if (first) {
            this.performEnableScreen();
        }
    }

    public void hideBootMessagesLocked() {
        if (this.mShowingBootMessages) {
            this.mShowingBootMessages = false;
            this.mPolicy.hideBootMessages();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInTouchMode(boolean mode) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mInTouchMode = mode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCircularDisplayMaskIfNeeded() {
        if (this.mContext.getResources().getConfiguration().isScreenRound() && this.mContext.getResources().getBoolean(17956991)) {
            int currentUserId;
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                currentUserId = this.mCurrentUserId;
            }
            int inversionState = Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "accessibility_display_inversion_enabled", 0, currentUserId);
            int showMask = inversionState == 1 ? 0 : 1;
            Message m = this.mH.obtainMessage(35);
            m.arg1 = showMask;
            this.mH.sendMessage(m);
        }
    }

    public void showEmulatorDisplayOverlayIfNeeded() {
        if (this.mContext.getResources().getBoolean(17956992) && SystemProperties.getBoolean(PROPERTY_EMULATOR_CIRCULAR, false) && Build.HARDWARE.contains("goldfish")) {
            this.mH.sendMessage(this.mH.obtainMessage(36));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showCircularMask(boolean visible) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            SurfaceControl.openTransaction();
            try {
                if (visible) {
                    if (this.mCircularDisplayMask == null) {
                        int screenOffset = this.mContext.getResources().getDimensionPixelSize(17105034);
                        int maskThickness = this.mContext.getResources().getDimensionPixelSize(17105035);
                        this.mCircularDisplayMask = new CircularDisplayMask(this.getDefaultDisplayContentLocked().getDisplay(), this.mFxSession, this.mPolicy.windowTypeToLayerLw(2018) * 10000 + 10, screenOffset, maskThickness);
                    }
                    this.mCircularDisplayMask.setVisibility(true);
                } else if (this.mCircularDisplayMask != null) {
                    this.mCircularDisplayMask.setVisibility(false);
                    this.mCircularDisplayMask = null;
                }
            }
            finally {
                SurfaceControl.closeTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showEmulatorDisplayOverlay() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            SurfaceControl.openTransaction();
            try {
                if (this.mEmulatorDisplayOverlay == null) {
                    this.mEmulatorDisplayOverlay = new EmulatorDisplayOverlay(this.mContext, this.getDefaultDisplayContentLocked().getDisplay(), this.mFxSession, this.mPolicy.windowTypeToLayerLw(2018) * 10000 + 10);
                }
                this.mEmulatorDisplayOverlay.setVisibility(true);
            }
            finally {
                SurfaceControl.closeTransaction();
            }
        }
    }

    @Override
    public void showStrictModeViolation(boolean on) {
        int pid = Binder.getCallingPid();
        this.mH.sendMessage(this.mH.obtainMessage(25, on ? 1 : 0, pid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showStrictModeViolation(int arg, int pid) {
        boolean on = arg != 0;
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (on) {
                boolean isVisible = false;
                int numDisplays = this.mDisplayContents.size();
                block6: for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
                    WindowList windows = this.mDisplayContents.valueAt(displayNdx).getWindowList();
                    int numWindows = windows.size();
                    for (int winNdx = 0; winNdx < numWindows; ++winNdx) {
                        WindowState ws = (WindowState)windows.get(winNdx);
                        if (ws.mSession.mPid != pid || !ws.isVisibleLw()) continue;
                        isVisible = true;
                        continue block6;
                    }
                }
                if (!isVisible) {
                    return;
                }
            }
            SurfaceControl.openTransaction();
            try {
                if (this.mStrictModeFlash == null) {
                    this.mStrictModeFlash = new StrictModeFlash(this.getDefaultDisplayContentLocked().getDisplay(), this.mFxSession);
                }
                this.mStrictModeFlash.setVisibility(on);
            }
            finally {
                SurfaceControl.closeTransaction();
            }
        }
    }

    @Override
    public void setStrictModeVisualIndicatorPreference(String value) {
        SystemProperties.set("persist.sys.strictmode.visual", value);
    }

    private static void convertCropForSurfaceFlinger(Rect crop, int rot, int dw, int dh) {
        if (rot == 1) {
            int tmp = crop.top;
            crop.top = dw - crop.right;
            crop.right = crop.bottom;
            crop.bottom = dw - crop.left;
            crop.left = tmp;
        } else if (rot == 2) {
            int tmp = crop.top;
            crop.top = dh - crop.bottom;
            crop.bottom = dh - tmp;
            tmp = crop.right;
            crop.right = dw - crop.left;
            crop.left = dw - tmp;
        } else if (rot == 3) {
            int tmp = crop.top;
            crop.top = crop.left;
            crop.left = dh - crop.bottom;
            crop.bottom = crop.right;
            crop.right = dh - tmp;
        }
    }

    @Override
    public boolean requestAssistScreenshot(final IAssistScreenshotReceiver receiver) {
        if (!this.checkCallingPermission("android.permission.READ_FRAME_BUFFER", "requestAssistScreenshot()")) {
            throw new SecurityException("Requires READ_FRAME_BUFFER permission");
        }
        FgThread.getHandler().post(new Runnable(){

            @Override
            public void run() {
                Bitmap bm = WindowManagerService.this.screenshotApplicationsInner(null, 0, -1, -1, true);
                try {
                    receiver.send(bm);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        });
        return true;
    }

    @Override
    public Bitmap screenshotApplications(IBinder appToken, int displayId, int width, int height) {
        if (!this.checkCallingPermission("android.permission.READ_FRAME_BUFFER", "screenshotApplications()")) {
            throw new SecurityException("Requires READ_FRAME_BUFFER permission");
        }
        return this.screenshotApplicationsInner(appToken, displayId, width, height, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Bitmap screenshotApplicationsInner(IBinder appToken, int displayId, int width, int height, boolean includeFullDisplay) {
        int minLayer;
        boolean screenshotReady;
        DisplayContent displayContent;
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            displayContent = this.getDisplayContentLocked(displayId);
            if (displayContent == null) {
                return null;
            }
        }
        DisplayInfo displayInfo = displayContent.getDisplayInfo();
        int dw = displayInfo.logicalWidth;
        int dh = displayInfo.logicalHeight;
        if (dw == 0 || dh == 0) {
            return null;
        }
        Bitmap bm = null;
        int maxLayer = 0;
        Rect frame = new Rect();
        Rect stackBounds = new Rect();
        if (appToken == null) {
            screenshotReady = true;
            minLayer = 0;
        } else {
            screenshotReady = false;
            minLayer = Integer.MAX_VALUE;
        }
        int retryCount = 0;
        WindowState appWin = null;
        boolean appIsImTarget = this.mInputMethodTarget != null && this.mInputMethodTarget.mAppToken != null && this.mInputMethodTarget.mAppToken.appToken != null && this.mInputMethodTarget.mAppToken.appToken.asBinder() == appToken;
        int aboveAppLayer = (this.mPolicy.windowTypeToLayerLw(2) + 1) * 10000 + 1000;
        while (true) {
            if (retryCount++ > 0) {
                maxLayer = 0;
                minLayer = Integer.MAX_VALUE;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            HashMap<IBinder, WindowState> e = this.mWindowMap;
            synchronized (e) {
                appWin = null;
                WindowList windows = displayContent.getWindowList();
                for (int i = windows.size() - 1; i >= 0; --i) {
                    WindowState ws = (WindowState)windows.get(i);
                    if (!ws.mHasSurface || ws.mLayer >= aboveAppLayer) continue;
                    if (ws.mIsImWindow) {
                        if (!appIsImTarget) {
                            continue;
                        }
                    } else if (ws.mIsWallpaper) {
                        if (appWin == null) {
                            continue;
                        }
                    } else if (appToken != null) {
                        if (ws.mAppToken == null || ws.mAppToken.token != appToken) continue;
                        appWin = ws;
                    }
                    WindowStateAnimator winAnim = ws.mWinAnimator;
                    if (maxLayer < winAnim.mSurfaceLayer) {
                        maxLayer = winAnim.mSurfaceLayer;
                    }
                    if (minLayer > winAnim.mSurfaceLayer) {
                        minLayer = winAnim.mSurfaceLayer;
                    }
                    if (!includeFullDisplay && !ws.mIsWallpaper) {
                        Rect wf = ws.mFrame;
                        Rect cr = ws.mContentInsets;
                        int left = wf.left + cr.left;
                        int top = wf.top + cr.top;
                        int right = wf.right - cr.right;
                        int bottom = wf.bottom - cr.bottom;
                        frame.union(left, top, right, bottom);
                        ws.getStackBounds(stackBounds);
                        if (!frame.intersect(stackBounds)) {
                            frame.setEmpty();
                        }
                    }
                    if (ws.mAppToken != null && ws.mAppToken.token == appToken && ws.isDisplayedLw() && winAnim.mSurfaceShown) {
                        screenshotReady = true;
                    }
                    if (ws.isFullscreen(dw, dh) && ws.isOpaqueDrawn()) break;
                }
                if (appToken != null && appWin == null) {
                    return null;
                }
                if (screenshotReady) break;
                if (retryCount > 3) {
                    Slog.i(TAG, "Screenshot max retries " + retryCount + " of " + appToken + " appWin=" + (appWin == null ? "null" : appWin + " drawState=" + appWin.mWinAnimator.mDrawState));
                    return null;
                }
            }
        }
        {
            if (maxLayer == 0) {
                return null;
            }
            if (!includeFullDisplay) {
                if (!frame.intersect(0, 0, dw, dh)) {
                    frame.setEmpty();
                }
            } else {
                frame.set(0, 0, dw, dh);
            }
            if (frame.isEmpty()) {
                return null;
            }
            if (width < 0) {
                width = frame.width();
            }
            if (height < 0) {
                height = frame.height();
            }
            Rect crop = new Rect(frame);
            if ((float)width / (float)frame.width() < (float)height / (float)frame.height()) {
                int cropWidth = (int)((float)width / (float)height * (float)frame.height());
                crop.right = crop.left + cropWidth;
            } else {
                int cropHeight = (int)((float)height / (float)width * (float)frame.width());
                crop.bottom = crop.top + cropHeight;
            }
            int rot = this.getDefaultDisplayContentLocked().getDisplay().getRotation();
            if (rot == 1 || rot == 3) {
                rot = rot == 1 ? 3 : 1;
            }
            WindowManagerService.convertCropForSurfaceFlinger(crop, rot, dw, dh);
            ScreenRotationAnimation screenRotationAnimation = this.mAnimator.getScreenRotationAnimationLocked(0);
            boolean inRotation = screenRotationAnimation != null && screenRotationAnimation.isAnimating();
            bm = SurfaceControl.screenshot(crop, width, height, minLayer, maxLayer, inRotation, rot);
            if (bm == null) {
                Slog.w(TAG, "Screenshot failure taking screenshot for (" + dw + "x" + dh + ") to layer " + maxLayer);
                return null;
            }
        }
        Bitmap ret = bm.createAshmemBitmap();
        bm.recycle();
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freezeRotation(int rotation) {
        if (!this.checkCallingPermission("android.permission.SET_ORIENTATION", "freezeRotation()")) {
            throw new SecurityException("Requires SET_ORIENTATION permission");
        }
        if (rotation < -1 || rotation > 3) {
            throw new IllegalArgumentException("Rotation argument must be -1 or a valid rotation constant.");
        }
        long origId = Binder.clearCallingIdentity();
        try {
            this.mPolicy.setUserRotationMode(1, rotation == -1 ? this.mRotation : rotation);
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
        this.updateRotationUnchecked(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void thawRotation() {
        if (!this.checkCallingPermission("android.permission.SET_ORIENTATION", "thawRotation()")) {
            throw new SecurityException("Requires SET_ORIENTATION permission");
        }
        long origId = Binder.clearCallingIdentity();
        try {
            this.mPolicy.setUserRotationMode(0, 777);
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
        this.updateRotationUnchecked(false, false);
    }

    @Override
    public void updateRotation(boolean alwaysSendConfiguration, boolean forceRelayout) {
        this.updateRotationUnchecked(alwaysSendConfiguration, forceRelayout);
    }

    void pauseRotationLocked() {
        ++this.mDeferredRotationPauseCount;
    }

    void resumeRotationLocked() {
        if (this.mDeferredRotationPauseCount > 0) {
            boolean changed;
            --this.mDeferredRotationPauseCount;
            if (this.mDeferredRotationPauseCount == 0 && (changed = this.updateRotationUncheckedLocked(false))) {
                this.mH.sendEmptyMessage(18);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRotationUnchecked(boolean alwaysSendConfiguration, boolean forceRelayout) {
        boolean changed;
        long origId = Binder.clearCallingIdentity();
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            changed = this.updateRotationUncheckedLocked(false);
            if (!changed || forceRelayout) {
                this.getDefaultDisplayContentLocked().layoutNeeded = true;
                this.performLayoutAndPlaceSurfacesLocked();
            }
        }
        if (changed || alwaysSendConfiguration) {
            this.sendNewConfiguration();
        }
        Binder.restoreCallingIdentity(origId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateRotationUncheckedLocked(boolean inTransaction) {
        int i;
        boolean altOrientation;
        if (this.mDeferredRotationPauseCount > 0) {
            return false;
        }
        ScreenRotationAnimation screenRotationAnimation = this.mAnimator.getScreenRotationAnimationLocked(0);
        if (screenRotationAnimation != null && screenRotationAnimation.isAnimating()) {
            return false;
        }
        if (!this.mDisplayEnabled) {
            return false;
        }
        int rotation = this.mPolicy.rotationForOrientationLw(this.mForcedAppOrientation, this.mRotation);
        boolean bl = altOrientation = !this.mPolicy.rotationHasCompatibleMetricsLw(this.mForcedAppOrientation, rotation);
        if (this.mRotation == rotation && this.mAltOrientation == altOrientation) {
            return false;
        }
        this.mRotation = rotation;
        this.mAltOrientation = altOrientation;
        this.mPolicy.setRotationLw(this.mRotation);
        this.mWindowsFreezingScreen = 1;
        this.mH.removeMessages(11);
        this.mH.sendEmptyMessageDelayed(11, 2000L);
        this.mWaitingForConfig = true;
        DisplayContent displayContent = this.getDefaultDisplayContentLocked();
        displayContent.layoutNeeded = true;
        int[] anim2 = new int[2];
        if (displayContent.isDimming()) {
            anim2[1] = 0;
            anim2[0] = 0;
        } else {
            this.mPolicy.selectRotationAnimationLw(anim2);
        }
        this.startFreezingDisplayLocked(inTransaction, anim2[0], anim2[1]);
        screenRotationAnimation = this.mAnimator.getScreenRotationAnimationLocked(0);
        this.updateDisplayAndOrientationLocked();
        DisplayInfo displayInfo = displayContent.getDisplayInfo();
        if (!inTransaction) {
            SurfaceControl.openTransaction();
        }
        try {
            if (screenRotationAnimation != null && screenRotationAnimation.hasScreenshot() && screenRotationAnimation.setRotationInTransaction(rotation, this.mFxSession, 10000L, this.getTransitionAnimationScaleLocked(), displayInfo.logicalWidth, displayInfo.logicalHeight)) {
                this.scheduleAnimationLocked();
            }
            this.mDisplayManagerInternal.performTraversalInTransactionFromWindowManager();
        }
        finally {
            if (!inTransaction) {
                SurfaceControl.closeTransaction();
            }
        }
        WindowList windows = displayContent.getWindowList();
        for (i = windows.size() - 1; i >= 0; --i) {
            WindowState w = (WindowState)windows.get(i);
            if (w.mHasSurface) {
                w.mOrientationChanging = true;
                this.mInnerFields.mOrientationChangeComplete = false;
            }
            w.mLastFreezeDuration = 0;
        }
        for (i = this.mRotationWatchers.size() - 1; i >= 0; --i) {
            try {
                this.mRotationWatchers.get((int)i).watcher.onRotationChanged(rotation);
                continue;
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
        if (screenRotationAnimation == null && this.mAccessibilityController != null && displayContent.getDisplayId() == 0) {
            this.mAccessibilityController.onRotationChangedLocked(this.getDefaultDisplayContentLocked(), rotation);
        }
        return true;
    }

    @Override
    public int getRotation() {
        return this.mRotation;
    }

    @Override
    public boolean isRotationFrozen() {
        return this.mPolicy.getUserRotationMode() == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int watchRotation(IRotationWatcher watcher) {
        final IBinder watcherBinder = watcher.asBinder();
        IBinder.DeathRecipient dr = new IBinder.DeathRecipient(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void binderDied() {
                HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
                synchronized (hashMap) {
                    for (int i = 0; i < WindowManagerService.this.mRotationWatchers.size(); ++i) {
                        if (watcherBinder != WindowManagerService.this.mRotationWatchers.get((int)i).watcher.asBinder()) continue;
                        RotationWatcher removed = WindowManagerService.this.mRotationWatchers.remove(i);
                        IBinder binder = removed.watcher.asBinder();
                        if (binder != null) {
                            binder.unlinkToDeath(this, 0);
                        }
                        --i;
                    }
                }
            }
        };
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            try {
                watcher.asBinder().linkToDeath(dr, 0);
                this.mRotationWatchers.add(new RotationWatcher(watcher, dr));
            }
            catch (RemoteException e) {
                // empty catch block
            }
            return this.mRotation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRotationWatcher(IRotationWatcher watcher) {
        IBinder watcherBinder = watcher.asBinder();
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            for (int i = 0; i < this.mRotationWatchers.size(); ++i) {
                RotationWatcher rotationWatcher = this.mRotationWatchers.get(i);
                if (watcherBinder != rotationWatcher.watcher.asBinder()) continue;
                RotationWatcher removed = this.mRotationWatchers.remove(i);
                IBinder binder = removed.watcher.asBinder();
                if (binder != null) {
                    binder.unlinkToDeath(removed.deathRecipient, 0);
                }
                --i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPreferredOptionsPanelGravity() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            int rotation = this.getRotation();
            DisplayContent displayContent = this.getDefaultDisplayContentLocked();
            if (displayContent.mInitialDisplayWidth < displayContent.mInitialDisplayHeight) {
                switch (rotation) {
                    default: {
                        return 81;
                    }
                    case 1: {
                        return 85;
                    }
                    case 2: {
                        return 81;
                    }
                    case 3: 
                }
                return 8388691;
            }
            switch (rotation) {
                default: {
                    return 85;
                }
                case 1: {
                    return 81;
                }
                case 2: {
                    return 8388691;
                }
                case 3: 
            }
            return 81;
        }
    }

    @Override
    public boolean startViewServer(int port) {
        if (this.isSystemSecure()) {
            return false;
        }
        if (!this.checkCallingPermission("android.permission.DUMP", "startViewServer")) {
            return false;
        }
        if (port < 1024) {
            return false;
        }
        if (this.mViewServer != null) {
            if (!this.mViewServer.isRunning()) {
                try {
                    return this.mViewServer.start();
                }
                catch (IOException e) {
                    Slog.w(TAG, "View server did not start");
                }
            }
            return false;
        }
        try {
            this.mViewServer = new ViewServer(this, port);
            return this.mViewServer.start();
        }
        catch (IOException e) {
            Slog.w(TAG, "View server did not start");
            return false;
        }
    }

    private boolean isSystemSecure() {
        return "1".equals(SystemProperties.get(SYSTEM_SECURE, "1")) && "0".equals(SystemProperties.get(SYSTEM_DEBUGGABLE, "0"));
    }

    @Override
    public boolean stopViewServer() {
        if (this.isSystemSecure()) {
            return false;
        }
        if (!this.checkCallingPermission("android.permission.DUMP", "stopViewServer")) {
            return false;
        }
        if (this.mViewServer != null) {
            return this.mViewServer.stop();
        }
        return false;
    }

    @Override
    public boolean isViewServerRunning() {
        if (this.isSystemSecure()) {
            return false;
        }
        if (!this.checkCallingPermission("android.permission.DUMP", "isViewServerRunning")) {
            return false;
        }
        return this.mViewServer != null && this.mViewServer.isRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean viewServerListWindows(Socket client) {
        if (this.isSystemSecure()) {
            return false;
        }
        boolean result = true;
        WindowList windows = new WindowList();
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            int numDisplays = this.mDisplayContents.size();
            for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
                DisplayContent displayContent = this.mDisplayContents.valueAt(displayNdx);
                windows.addAll(displayContent.getWindowList());
            }
        }
        BufferedWriter out = null;
        try {
            OutputStream clientStream = client.getOutputStream();
            out = new BufferedWriter(new OutputStreamWriter(clientStream), 8192);
            int count = windows.size();
            for (int i = 0; i < count; ++i) {
                WindowState w = (WindowState)windows.get(i);
                out.write(Integer.toHexString(System.identityHashCode(w)));
                out.write(32);
                out.append(w.mAttrs.getTitle());
                out.write(10);
            }
            out.write("DONE.\n");
            out.flush();
        }
        catch (Exception e) {
            result = false;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    result = false;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean viewServerGetFocusedWindow(Socket client) {
        if (this.isSystemSecure()) {
            return false;
        }
        boolean result = true;
        WindowState focusedWindow = this.getFocusedWindow();
        BufferedWriter out = null;
        try {
            OutputStream clientStream = client.getOutputStream();
            out = new BufferedWriter(new OutputStreamWriter(clientStream), 8192);
            if (focusedWindow != null) {
                out.write(Integer.toHexString(System.identityHashCode(focusedWindow)));
                out.write(32);
                out.append(focusedWindow.mAttrs.getTitle());
            }
            out.write(10);
            out.flush();
        }
        catch (Exception e) {
            result = false;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    result = false;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean viewServerWindowCommand(Socket client, String command, String parameters) {
        if (this.isSystemSecure()) {
            return false;
        }
        boolean success = true;
        Parcel data = null;
        Parcel reply = null;
        BufferedWriter out = null;
        try {
            int index = parameters.indexOf(32);
            if (index == -1) {
                index = parameters.length();
            }
            String code = parameters.substring(0, index);
            int hashCode = (int)Long.parseLong(code, 16);
            parameters = index < parameters.length() ? parameters.substring(index + 1) : "";
            WindowState window = this.findWindow(hashCode);
            if (window == null) {
                boolean bl = false;
                return bl;
            }
            data = Parcel.obtain();
            data.writeInterfaceToken("android.view.IWindow");
            data.writeString(command);
            data.writeString(parameters);
            data.writeInt(1);
            ParcelFileDescriptor.fromSocket(client).writeToParcel(data, 0);
            reply = Parcel.obtain();
            IBinder binder = window.mClient.asBinder();
            binder.transact(1, data, reply, 0);
            reply.readException();
            if (!client.isOutputShutdown()) {
                out = new BufferedWriter(new OutputStreamWriter(client.getOutputStream()));
                out.write("DONE\n");
                out.flush();
            }
        }
        catch (Exception e) {
            Slog.w(TAG, "Could not send command " + command + " with parameters " + parameters, e);
            success = false;
        }
        finally {
            if (data != null) {
                data.recycle();
            }
            if (reply != null) {
                reply.recycle();
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWindowChangeListener(WindowChangeListener listener) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mWindowChangeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWindowChangeListener(WindowChangeListener listener) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mWindowChangeListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWindowsChanged() {
        WindowChangeListener[] windowChangeListeners;
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mWindowChangeListeners.isEmpty()) {
                return;
            }
            windowChangeListeners = new WindowChangeListener[this.mWindowChangeListeners.size()];
            windowChangeListeners = this.mWindowChangeListeners.toArray(windowChangeListeners);
        }
        int N = windowChangeListeners.length;
        for (int i = 0; i < N; ++i) {
            windowChangeListeners[i].windowsChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyFocusChanged() {
        WindowChangeListener[] windowChangeListeners;
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mWindowChangeListeners.isEmpty()) {
                return;
            }
            windowChangeListeners = new WindowChangeListener[this.mWindowChangeListeners.size()];
            windowChangeListeners = this.mWindowChangeListeners.toArray(windowChangeListeners);
        }
        int N = windowChangeListeners.length;
        for (int i = 0; i < N; ++i) {
            windowChangeListeners[i].focusChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WindowState findWindow(int hashCode) {
        if (hashCode == -1) {
            return this.getFocusedWindow();
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            int numDisplays = this.mDisplayContents.size();
            for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
                WindowList windows = this.mDisplayContents.valueAt(displayNdx).getWindowList();
                int numWindows = windows.size();
                for (int winNdx = 0; winNdx < numWindows; ++winNdx) {
                    WindowState w = (WindowState)windows.get(winNdx);
                    if (System.identityHashCode(w) != hashCode) continue;
                    return w;
                }
            }
        }
        return null;
    }

    void sendNewConfiguration() {
        try {
            this.mActivityManager.updateConfiguration(null);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration computeNewConfiguration() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            return this.computeNewConfigurationLocked();
        }
    }

    private Configuration computeNewConfigurationLocked() {
        if (!this.mDisplayReady) {
            return null;
        }
        Configuration config = new Configuration();
        config.fontScale = 0.0f;
        this.computeScreenConfigurationLocked(config);
        return config;
    }

    private void adjustDisplaySizeRanges(DisplayInfo displayInfo, int rotation, int dw, int dh) {
        int height;
        int width = this.mPolicy.getConfigDisplayWidth(dw, dh, rotation);
        if (width < displayInfo.smallestNominalAppWidth) {
            displayInfo.smallestNominalAppWidth = width;
        }
        if (width > displayInfo.largestNominalAppWidth) {
            displayInfo.largestNominalAppWidth = width;
        }
        if ((height = this.mPolicy.getConfigDisplayHeight(dw, dh, rotation)) < displayInfo.smallestNominalAppHeight) {
            displayInfo.smallestNominalAppHeight = height;
        }
        if (height > displayInfo.largestNominalAppHeight) {
            displayInfo.largestNominalAppHeight = height;
        }
    }

    private int reduceConfigLayout(int curLayout, int rotation, float density, int dw, int dh) {
        int h;
        int shortSize;
        int w = this.mPolicy.getNonDecorDisplayWidth(dw, dh, rotation);
        int longSize = w;
        if (longSize < (shortSize = (h = this.mPolicy.getNonDecorDisplayHeight(dw, dh, rotation)))) {
            int tmp = longSize;
            longSize = shortSize;
            shortSize = tmp;
        }
        longSize = (int)((float)longSize / density);
        shortSize = (int)((float)shortSize / density);
        return Configuration.reduceScreenLayout(curLayout, longSize, shortSize);
    }

    private void computeSizeRangesAndScreenLayout(DisplayInfo displayInfo, boolean rotated, int dw, int dh, float density, Configuration outConfig) {
        int unrotDh;
        int unrotDw;
        if (rotated) {
            unrotDw = dh;
            unrotDh = dw;
        } else {
            unrotDw = dw;
            unrotDh = dh;
        }
        displayInfo.smallestNominalAppWidth = 0x40000000;
        displayInfo.smallestNominalAppHeight = 0x40000000;
        displayInfo.largestNominalAppWidth = 0;
        displayInfo.largestNominalAppHeight = 0;
        this.adjustDisplaySizeRanges(displayInfo, 0, unrotDw, unrotDh);
        this.adjustDisplaySizeRanges(displayInfo, 1, unrotDh, unrotDw);
        this.adjustDisplaySizeRanges(displayInfo, 2, unrotDw, unrotDh);
        this.adjustDisplaySizeRanges(displayInfo, 3, unrotDh, unrotDw);
        int sl = Configuration.resetScreenLayout(outConfig.screenLayout);
        sl = this.reduceConfigLayout(sl, 0, density, unrotDw, unrotDh);
        sl = this.reduceConfigLayout(sl, 1, density, unrotDh, unrotDw);
        sl = this.reduceConfigLayout(sl, 2, density, unrotDw, unrotDh);
        sl = this.reduceConfigLayout(sl, 3, density, unrotDh, unrotDw);
        outConfig.smallestScreenWidthDp = (int)((float)displayInfo.smallestNominalAppWidth / density);
        outConfig.screenLayout = sl;
    }

    private int reduceCompatConfigWidthSize(int curSize, int rotation, DisplayMetrics dm, int dw, int dh) {
        dm.noncompatWidthPixels = this.mPolicy.getNonDecorDisplayWidth(dw, dh, rotation);
        dm.noncompatHeightPixels = this.mPolicy.getNonDecorDisplayHeight(dw, dh, rotation);
        float scale = CompatibilityInfo.computeCompatibleScaling(dm, null);
        int size = (int)((float)dm.noncompatWidthPixels / scale / dm.density + 0.5f);
        if (curSize == 0 || size < curSize) {
            curSize = size;
        }
        return curSize;
    }

    private int computeCompatSmallestWidth(boolean rotated, DisplayMetrics dm, int dw, int dh) {
        int unrotDh;
        int unrotDw;
        this.mTmpDisplayMetrics.setTo(dm);
        DisplayMetrics tmpDm = this.mTmpDisplayMetrics;
        if (rotated) {
            unrotDw = dh;
            unrotDh = dw;
        } else {
            unrotDw = dw;
            unrotDh = dh;
        }
        int sw = this.reduceCompatConfigWidthSize(0, 0, tmpDm, unrotDw, unrotDh);
        sw = this.reduceCompatConfigWidthSize(sw, 1, tmpDm, unrotDh, unrotDw);
        sw = this.reduceCompatConfigWidthSize(sw, 2, tmpDm, unrotDw, unrotDh);
        sw = this.reduceCompatConfigWidthSize(sw, 3, tmpDm, unrotDh, unrotDw);
        return sw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DisplayInfo updateDisplayAndOrientationLocked() {
        DisplayContent displayContent = this.getDefaultDisplayContentLocked();
        boolean rotated = this.mRotation == 1 || this.mRotation == 3;
        int realdw = rotated ? displayContent.mBaseDisplayHeight : displayContent.mBaseDisplayWidth;
        int realdh = rotated ? displayContent.mBaseDisplayWidth : displayContent.mBaseDisplayHeight;
        int dw = realdw;
        int dh = realdh;
        if (this.mAltOrientation) {
            if (realdw > realdh) {
                int maxw = (int)((float)realdh / 1.3f);
                if (maxw < realdw) {
                    dw = maxw;
                }
            } else {
                int maxh = (int)((float)realdw / 1.3f);
                if (maxh < realdh) {
                    dh = maxh;
                }
            }
        }
        int appWidth = this.mPolicy.getNonDecorDisplayWidth(dw, dh, this.mRotation);
        int appHeight = this.mPolicy.getNonDecorDisplayHeight(dw, dh, this.mRotation);
        DisplayInfo displayInfo = displayContent.getDisplayInfo();
        Object object = displayContent.mDisplaySizeLock;
        synchronized (object) {
            displayInfo.rotation = this.mRotation;
            displayInfo.logicalWidth = dw;
            displayInfo.logicalHeight = dh;
            displayInfo.logicalDensityDpi = displayContent.mBaseDisplayDensity;
            displayInfo.appWidth = appWidth;
            displayInfo.appHeight = appHeight;
            displayInfo.getLogicalMetrics(this.mRealDisplayMetrics, CompatibilityInfo.DEFAULT_COMPATIBILITY_INFO, null);
            displayInfo.getAppMetrics(this.mDisplayMetrics);
            displayInfo.flags = displayContent.mDisplayScalingDisabled ? (displayInfo.flags |= 0x40000000) : (displayInfo.flags &= 0xBFFFFFFF);
            this.mDisplayManagerInternal.setDisplayInfoOverrideFromWindowManager(displayContent.getDisplayId(), displayInfo);
            displayContent.mBaseDisplayRect.set(0, 0, dw, dh);
        }
        this.mCompatibleScreenScale = CompatibilityInfo.computeCompatibleScaling(this.mDisplayMetrics, this.mCompatDisplayMetrics);
        return displayInfo;
    }

    void computeScreenConfigurationLocked(Configuration config) {
        boolean hardKeyboardAvailable;
        DisplayInfo displayInfo = this.updateDisplayAndOrientationLocked();
        int dw = displayInfo.logicalWidth;
        int dh = displayInfo.logicalHeight;
        config.orientation = dw <= dh ? 1 : 2;
        config.screenWidthDp = (int)((float)this.mPolicy.getConfigDisplayWidth(dw, dh, this.mRotation) / this.mDisplayMetrics.density);
        config.screenHeightDp = (int)((float)this.mPolicy.getConfigDisplayHeight(dw, dh, this.mRotation) / this.mDisplayMetrics.density);
        boolean rotated = this.mRotation == 1 || this.mRotation == 3;
        this.computeSizeRangesAndScreenLayout(displayInfo, rotated, dw, dh, this.mDisplayMetrics.density, config);
        config.screenLayout = config.screenLayout & 0xFFFFFCFF | ((displayInfo.flags & 0x10) != 0 ? 512 : 256);
        config.compatScreenWidthDp = (int)((float)config.screenWidthDp / this.mCompatibleScreenScale);
        config.compatScreenHeightDp = (int)((float)config.screenHeightDp / this.mCompatibleScreenScale);
        config.compatSmallestScreenWidthDp = this.computeCompatSmallestWidth(rotated, this.mDisplayMetrics, dw, dh);
        config.densityDpi = displayInfo.logicalDensityDpi;
        config.touchscreen = 1;
        config.keyboard = 1;
        config.navigation = 1;
        int keyboardPresence = 0;
        int navigationPresence = 0;
        for (InputDevice device : this.mInputManager.getInputDevices()) {
            int presenceFlag;
            if (device.isVirtual()) continue;
            int sources = device.getSources();
            int n = presenceFlag = device.isExternal() ? 2 : 1;
            if (this.mIsTouchDevice) {
                if ((sources & 0x1002) == 4098) {
                    config.touchscreen = 3;
                }
            } else {
                config.touchscreen = 1;
            }
            if ((sources & 0x10004) == 65540) {
                config.navigation = 3;
                navigationPresence |= presenceFlag;
            } else if ((sources & 0x201) == 513 && config.navigation == 1) {
                config.navigation = 2;
                navigationPresence |= presenceFlag;
            }
            if (device.getKeyboardType() != 2) continue;
            config.keyboard = 2;
            keyboardPresence |= presenceFlag;
        }
        if (config.navigation == 1 && this.mHasPermanentDpad) {
            config.navigation = 2;
            navigationPresence |= 1;
        }
        boolean bl = hardKeyboardAvailable = config.keyboard != 1;
        if (hardKeyboardAvailable != this.mHardKeyboardAvailable) {
            this.mHardKeyboardAvailable = hardKeyboardAvailable;
            this.mH.removeMessages(22);
            this.mH.sendEmptyMessage(22);
        }
        if (this.mShowImeWithHardKeyboard) {
            config.keyboard = 1;
        }
        config.keyboardHidden = 1;
        config.hardKeyboardHidden = 1;
        config.navigationHidden = 1;
        this.mPolicy.adjustConfigurationLw(config, keyboardPresence, navigationPresence);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHardKeyboardAvailable() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            return this.mHardKeyboardAvailable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateShowImeWithHardKeyboard() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            boolean showImeWithHardKeyboard;
            boolean bl = showImeWithHardKeyboard = Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "show_ime_with_hard_keyboard", 0, this.mCurrentUserId) == 1;
            if (this.mShowImeWithHardKeyboard != showImeWithHardKeyboard) {
                this.mShowImeWithHardKeyboard = showImeWithHardKeyboard;
                this.mH.sendEmptyMessage(18);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnHardKeyboardStatusChangeListener(OnHardKeyboardStatusChangeListener listener) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mHardKeyboardStatusChangeListener = listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyHardKeyboardStatusChange() {
        boolean available;
        OnHardKeyboardStatusChangeListener listener;
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            listener = this.mHardKeyboardStatusChangeListener;
            available = this.mHardKeyboardAvailable;
        }
        if (listener != null) {
            listener.onHardKeyboardStatusChange(available);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IBinder prepareDragSurface(IWindow window, SurfaceSession session, int flags, int width, int height, Surface outSurface) {
        int callerPid = Binder.getCallingPid();
        long origId = Binder.clearCallingIdentity();
        Binder token = null;
        try {
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                block10: {
                    try {
                        if (this.mDragState == null) {
                            DisplayContent displayContent = this.getDefaultDisplayContentLocked();
                            Display display = displayContent.getDisplay();
                            SurfaceControl surface = new SurfaceControl(session, "drag surface", width, height, -3, 4);
                            surface.setLayerStack(display.getLayerStack());
                            outSurface.copyFrom(surface);
                            IBinder winBinder = window.asBinder();
                            token = new Binder();
                            this.mDragState = new DragState(this, token, surface, flags, winBinder);
                            this.mDragState.mToken = new Binder();
                            token = this.mDragState.mToken;
                            this.mH.removeMessages(20, winBinder);
                            Message msg = this.mH.obtainMessage(20, winBinder);
                            this.mH.sendMessageDelayed(msg, 5000L);
                        } else {
                            Slog.w(TAG, "Drag already in progress");
                        }
                    }
                    catch (Surface.OutOfResourcesException e) {
                        Slog.e(TAG, "Can't allocate drag surface w=" + width + " h=" + height, e);
                        if (this.mDragState == null) break block10;
                        this.mDragState.reset();
                        this.mDragState = null;
                    }
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pauseKeyDispatching(IBinder _token) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "pauseKeyDispatching()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            WindowToken token = this.mTokenMap.get(_token);
            if (token != null) {
                this.mInputMonitor.pauseDispatchingLw(token);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeKeyDispatching(IBinder _token) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "resumeKeyDispatching()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            WindowToken token = this.mTokenMap.get(_token);
            if (token != null) {
                this.mInputMonitor.resumeDispatchingLw(token);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEventDispatching(boolean enabled) {
        if (!this.checkCallingPermission("android.permission.MANAGE_APP_TOKENS", "setEventDispatching()")) {
            throw new SecurityException("Requires MANAGE_APP_TOKENS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mEventDispatchingEnabled = enabled;
            if (this.mDisplayEnabled) {
                this.mInputMonitor.setEventDispatchingLw(enabled);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WindowState getFocusedWindow() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            return this.getFocusedWindowLocked();
        }
    }

    private WindowState getFocusedWindowLocked() {
        return this.mCurrentFocus;
    }

    public boolean detectSafeMode() {
        if (!this.mInputMonitor.waitForInputDevicesReady(1000L)) {
            Slog.w(TAG, "Devices still not ready after waiting 1000 milliseconds before attempting to detect safe mode.");
        }
        int menuState = this.mInputManager.getKeyCodeState(-1, -256, 82);
        int sState = this.mInputManager.getKeyCodeState(-1, -256, 47);
        int dpadState = this.mInputManager.getKeyCodeState(-1, 513, 23);
        int trackballState = this.mInputManager.getScanCodeState(-1, 65540, 272);
        int volumeDownState = this.mInputManager.getKeyCodeState(-1, -256, 25);
        this.mSafeMode = menuState > 0 || sState > 0 || dpadState > 0 || trackballState > 0 || volumeDownState > 0;
        try {
            if (SystemProperties.getInt("persist.sys.safemode", 0) != 0) {
                this.mSafeMode = true;
                SystemProperties.set("persist.sys.safemode", "");
            }
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        if (this.mSafeMode) {
            Log.i(TAG, "SAFE MODE ENABLED (menu=" + menuState + " s=" + sState + " dpad=" + dpadState + " trackball=" + trackballState + ")");
        } else {
            Log.i(TAG, "SAFE MODE not enabled");
        }
        this.mPolicy.setSafeMode(this.mSafeMode);
        return this.mSafeMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayReady() {
        this.displayReady(0);
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            DisplayContent displayContent = this.getDefaultDisplayContentLocked();
            this.readForcedDisplayPropertiesLocked(displayContent);
            this.mDisplayReady = true;
        }
        try {
            this.mActivityManager.updateConfiguration(null);
        }
        catch (RemoteException e) {
            // empty catch block
        }
        HashMap<IBinder, WindowState> e = this.mWindowMap;
        synchronized (e) {
            this.mIsTouchDevice = this.mContext.getPackageManager().hasSystemFeature("android.hardware.touchscreen");
            this.configureDisplayPolicyLocked(this.getDefaultDisplayContentLocked());
        }
        try {
            this.mActivityManager.updateConfiguration(null);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayReady(int displayId) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            DisplayContent displayContent = this.getDisplayContentLocked(displayId);
            if (displayContent != null) {
                this.mAnimator.addDisplayLocked(displayId);
                Object object = displayContent.mDisplaySizeLock;
                synchronized (object) {
                    DisplayInfo displayInfo = displayContent.getDisplayInfo();
                    DisplayInfo newDisplayInfo = this.mDisplayManagerInternal.getDisplayInfo(displayId);
                    if (newDisplayInfo != null) {
                        displayInfo.copyFrom(newDisplayInfo);
                    }
                    displayContent.mInitialDisplayWidth = displayInfo.logicalWidth;
                    displayContent.mInitialDisplayHeight = displayInfo.logicalHeight;
                    displayContent.mInitialDisplayDensity = displayInfo.logicalDensityDpi;
                    displayContent.mBaseDisplayWidth = displayContent.mInitialDisplayWidth;
                    displayContent.mBaseDisplayHeight = displayContent.mInitialDisplayHeight;
                    displayContent.mBaseDisplayDensity = displayContent.mInitialDisplayDensity;
                    displayContent.mBaseDisplayRect.set(0, 0, displayContent.mBaseDisplayWidth, displayContent.mBaseDisplayHeight);
                }
            }
        }
    }

    public void systemReady() {
        this.mPolicy.systemReady();
    }

    @Override
    public IWindowSession openSession(IWindowSessionCallback callback, IInputMethodClient client, IInputContext inputContext) {
        if (client == null) {
            throw new IllegalArgumentException("null client");
        }
        if (inputContext == null) {
            throw new IllegalArgumentException("null inputContext");
        }
        Session session = new Session(this, callback, client, inputContext);
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean inputMethodClientHasFocus(IInputMethodClient client) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            WindowState imFocus;
            int idx = this.findDesiredInputMethodWindowIndexLocked(false);
            if (idx > 0 && (imFocus = (WindowState)this.getDefaultWindowListLocked().get(idx - 1)) != null) {
                if (imFocus.mAttrs.type == 3 && imFocus.mAppToken != null) {
                    for (int i = 0; i < imFocus.mAppToken.windows.size(); ++i) {
                        WindowState w = (WindowState)imFocus.mAppToken.windows.get(i);
                        if (w == imFocus) continue;
                        Log.i(TAG, "Switching to real app window: " + w);
                        imFocus = w;
                        break;
                    }
                }
                if (imFocus.mSession.mClient != null && imFocus.mSession.mClient.asBinder() == client.asBinder()) {
                    return true;
                }
            }
            if (this.mCurrentFocus != null && this.mCurrentFocus.mSession.mClient != null && this.mCurrentFocus.mSession.mClient.asBinder() == client.asBinder()) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getInitialDisplaySize(int displayId, Point size) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            DisplayContent displayContent = this.getDisplayContentLocked(displayId);
            if (displayContent != null && displayContent.hasAccess(Binder.getCallingUid())) {
                Object object = displayContent.mDisplaySizeLock;
                synchronized (object) {
                    size.x = displayContent.mInitialDisplayWidth;
                    size.y = displayContent.mInitialDisplayHeight;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getBaseDisplaySize(int displayId, Point size) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            DisplayContent displayContent = this.getDisplayContentLocked(displayId);
            if (displayContent != null && displayContent.hasAccess(Binder.getCallingUid())) {
                Object object = displayContent.mDisplaySizeLock;
                synchronized (object) {
                    size.x = displayContent.mBaseDisplayWidth;
                    size.y = displayContent.mBaseDisplayHeight;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setForcedDisplaySize(int displayId, int width, int height) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.WRITE_SECURE_SETTINGS") != 0) {
            throw new SecurityException("Must hold permission android.permission.WRITE_SECURE_SETTINGS");
        }
        if (displayId != 0) {
            throw new IllegalArgumentException("Can only set the default display");
        }
        long ident = Binder.clearCallingIdentity();
        try {
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                int MIN_WIDTH = 200;
                int MIN_HEIGHT = 200;
                int MAX_SCALE = 2;
                DisplayContent displayContent = this.getDisplayContentLocked(displayId);
                if (displayContent != null) {
                    width = Math.min(Math.max(width, 200), displayContent.mInitialDisplayWidth * 2);
                    height = Math.min(Math.max(height, 200), displayContent.mInitialDisplayHeight * 2);
                    this.setForcedDisplaySizeLocked(displayContent, width, height);
                    Settings.Global.putString(this.mContext.getContentResolver(), "display_size_forced", width + "," + height);
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setForcedDisplayScalingMode(int displayId, int mode) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.WRITE_SECURE_SETTINGS") != 0) {
            throw new SecurityException("Must hold permission android.permission.WRITE_SECURE_SETTINGS");
        }
        if (displayId != 0) {
            throw new IllegalArgumentException("Can only set the default display");
        }
        long ident = Binder.clearCallingIdentity();
        try {
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                DisplayContent displayContent = this.getDisplayContentLocked(displayId);
                if (displayContent != null) {
                    if (mode < 0 || mode > 1) {
                        mode = 0;
                    }
                    this.setForcedDisplayScalingModeLocked(displayContent, mode);
                    Settings.Global.putInt(this.mContext.getContentResolver(), "display_scaling_force", mode);
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setForcedDisplayScalingModeLocked(DisplayContent displayContent, int mode) {
        Slog.i(TAG, "Using display scaling mode: " + (mode == 0 ? "auto" : "off"));
        Object object = displayContent.mDisplaySizeLock;
        synchronized (object) {
            displayContent.mDisplayScalingDisabled = mode != 0;
        }
        this.reconfigureDisplayLocked(displayContent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readForcedDisplayPropertiesLocked(DisplayContent displayContent) {
        int mode;
        String densityStr;
        int pos;
        String sizeStr = Settings.Global.getString(this.mContext.getContentResolver(), "display_size_forced");
        if (sizeStr == null || sizeStr.length() == 0) {
            sizeStr = SystemProperties.get(SIZE_OVERRIDE, null);
        }
        if (sizeStr != null && sizeStr.length() > 0 && (pos = sizeStr.indexOf(44)) > 0 && sizeStr.lastIndexOf(44) == pos) {
            try {
                int width = Integer.parseInt(sizeStr.substring(0, pos));
                int height = Integer.parseInt(sizeStr.substring(pos + 1));
                Object object = displayContent.mDisplaySizeLock;
                synchronized (object) {
                    if (displayContent.mBaseDisplayWidth != width || displayContent.mBaseDisplayHeight != height) {
                        Slog.i(TAG, "FORCED DISPLAY SIZE: " + width + "x" + height);
                        displayContent.mBaseDisplayWidth = width;
                        displayContent.mBaseDisplayHeight = height;
                    }
                }
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        if ((densityStr = Settings.Global.getString(this.mContext.getContentResolver(), "display_density_forced")) == null || densityStr.length() == 0) {
            densityStr = SystemProperties.get(DENSITY_OVERRIDE, null);
        }
        if (densityStr != null && densityStr.length() > 0) {
            try {
                int density = Integer.parseInt(densityStr);
                Object height = displayContent.mDisplaySizeLock;
                synchronized (height) {
                    if (displayContent.mBaseDisplayDensity != density) {
                        Slog.i(TAG, "FORCED DISPLAY DENSITY: " + density);
                        displayContent.mBaseDisplayDensity = density;
                    }
                }
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        if ((mode = Settings.Global.getInt(this.mContext.getContentResolver(), "display_scaling_force", 0)) != 0) {
            Object object = displayContent.mDisplaySizeLock;
            synchronized (object) {
                Slog.i(TAG, "FORCED DISPLAY SCALING DISABLED");
                displayContent.mDisplayScalingDisabled = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setForcedDisplaySizeLocked(DisplayContent displayContent, int width, int height) {
        Slog.i(TAG, "Using new display size: " + width + "x" + height);
        Object object = displayContent.mDisplaySizeLock;
        synchronized (object) {
            displayContent.mBaseDisplayWidth = width;
            displayContent.mBaseDisplayHeight = height;
        }
        this.reconfigureDisplayLocked(displayContent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearForcedDisplaySize(int displayId) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.WRITE_SECURE_SETTINGS") != 0) {
            throw new SecurityException("Must hold permission android.permission.WRITE_SECURE_SETTINGS");
        }
        if (displayId != 0) {
            throw new IllegalArgumentException("Can only set the default display");
        }
        long ident = Binder.clearCallingIdentity();
        try {
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                DisplayContent displayContent = this.getDisplayContentLocked(displayId);
                if (displayContent != null) {
                    this.setForcedDisplaySizeLocked(displayContent, displayContent.mInitialDisplayWidth, displayContent.mInitialDisplayHeight);
                    Settings.Global.putString(this.mContext.getContentResolver(), "display_size_forced", "");
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInitialDisplayDensity(int displayId) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            DisplayContent displayContent = this.getDisplayContentLocked(displayId);
            if (displayContent != null && displayContent.hasAccess(Binder.getCallingUid())) {
                Object object = displayContent.mDisplaySizeLock;
                synchronized (object) {
                    return displayContent.mInitialDisplayDensity;
                }
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getBaseDisplayDensity(int displayId) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            DisplayContent displayContent = this.getDisplayContentLocked(displayId);
            if (displayContent != null && displayContent.hasAccess(Binder.getCallingUid())) {
                Object object = displayContent.mDisplaySizeLock;
                synchronized (object) {
                    return displayContent.mBaseDisplayDensity;
                }
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setForcedDisplayDensity(int displayId, int density) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.WRITE_SECURE_SETTINGS") != 0) {
            throw new SecurityException("Must hold permission android.permission.WRITE_SECURE_SETTINGS");
        }
        if (displayId != 0) {
            throw new IllegalArgumentException("Can only set the default display");
        }
        long ident = Binder.clearCallingIdentity();
        try {
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                DisplayContent displayContent = this.getDisplayContentLocked(displayId);
                if (displayContent != null) {
                    this.setForcedDisplayDensityLocked(displayContent, density);
                    Settings.Global.putString(this.mContext.getContentResolver(), "display_density_forced", Integer.toString(density));
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setForcedDisplayDensityLocked(DisplayContent displayContent, int density) {
        Slog.i(TAG, "Using new display density: " + density);
        Object object = displayContent.mDisplaySizeLock;
        synchronized (object) {
            displayContent.mBaseDisplayDensity = density;
        }
        this.reconfigureDisplayLocked(displayContent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearForcedDisplayDensity(int displayId) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.WRITE_SECURE_SETTINGS") != 0) {
            throw new SecurityException("Must hold permission android.permission.WRITE_SECURE_SETTINGS");
        }
        if (displayId != 0) {
            throw new IllegalArgumentException("Can only set the default display");
        }
        long ident = Binder.clearCallingIdentity();
        try {
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                DisplayContent displayContent = this.getDisplayContentLocked(displayId);
                if (displayContent != null) {
                    this.setForcedDisplayDensityLocked(displayContent, displayContent.mInitialDisplayDensity);
                    Settings.Global.putString(this.mContext.getContentResolver(), "display_density_forced", "");
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private void reconfigureDisplayLocked(DisplayContent displayContent) {
        if (!this.mDisplayReady) {
            return;
        }
        this.configureDisplayPolicyLocked(displayContent);
        displayContent.layoutNeeded = true;
        boolean configChanged = this.updateOrientationFromAppTokensLocked(false);
        this.mTempConfiguration.setToDefaults();
        this.mTempConfiguration.fontScale = this.mCurConfiguration.fontScale;
        this.computeScreenConfigurationLocked(this.mTempConfiguration);
        if (configChanged |= this.mCurConfiguration.diff(this.mTempConfiguration) != 0) {
            this.mWaitingForConfig = true;
            this.startFreezingDisplayLocked(false, 0, 0);
            this.mH.sendEmptyMessage(18);
        }
        this.performLayoutAndPlaceSurfacesLocked();
    }

    private void configureDisplayPolicyLocked(DisplayContent displayContent) {
        this.mPolicy.setInitialDisplaySize(displayContent.getDisplay(), displayContent.mBaseDisplayWidth, displayContent.mBaseDisplayHeight, displayContent.mBaseDisplayDensity);
        DisplayInfo displayInfo = displayContent.getDisplayInfo();
        this.mPolicy.setDisplayOverscan(displayContent.getDisplay(), displayInfo.overscanLeft, displayInfo.overscanTop, displayInfo.overscanRight, displayInfo.overscanBottom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOverscan(int displayId, int left, int top, int right, int bottom) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.WRITE_SECURE_SETTINGS") != 0) {
            throw new SecurityException("Must hold permission android.permission.WRITE_SECURE_SETTINGS");
        }
        long ident = Binder.clearCallingIdentity();
        try {
            HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
            synchronized (hashMap) {
                DisplayContent displayContent = this.getDisplayContentLocked(displayId);
                if (displayContent != null) {
                    this.setOverscanLocked(displayContent, left, top, right, bottom);
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOverscanLocked(DisplayContent displayContent, int left, int top, int right, int bottom) {
        DisplayInfo displayInfo = displayContent.getDisplayInfo();
        Object object = displayContent.mDisplaySizeLock;
        synchronized (object) {
            displayInfo.overscanLeft = left;
            displayInfo.overscanTop = top;
            displayInfo.overscanRight = right;
            displayInfo.overscanBottom = bottom;
        }
        this.mDisplaySettings.setOverscanLocked(displayInfo.uniqueId, left, top, right, bottom);
        this.mDisplaySettings.writeSettingsLocked();
        this.reconfigureDisplayLocked(displayContent);
    }

    final WindowState windowForClientLocked(Session session, IWindow client, boolean throwOnError) {
        return this.windowForClientLocked(session, client.asBinder(), throwOnError);
    }

    final WindowState windowForClientLocked(Session session, IBinder client, boolean throwOnError) {
        WindowState win = this.mWindowMap.get(client);
        if (win == null) {
            IllegalArgumentException ex = new IllegalArgumentException("Requested window " + client + " does not exist");
            if (throwOnError) {
                throw ex;
            }
            Slog.w(TAG, "Failed looking up window", ex);
            return null;
        }
        if (session != null && win.mSession != session) {
            IllegalArgumentException ex = new IllegalArgumentException("Requested window " + client + " is in session " + win.mSession + ", not " + session);
            if (throwOnError) {
                throw ex;
            }
            Slog.w(TAG, "Failed looking up window", ex);
            return null;
        }
        return win;
    }

    final void rebuildAppWindowListLocked() {
        this.rebuildAppWindowListLocked(this.getDefaultDisplayContentLocked());
    }

    private void rebuildAppWindowListLocked(DisplayContent displayContent) {
        int stackNdx;
        WindowList windows = displayContent.getWindowList();
        int NW = windows.size();
        int lastBelow = -1;
        int numRemoved = 0;
        if (this.mRebuildTmp.length < NW) {
            this.mRebuildTmp = new WindowState[NW + 10];
        }
        int i = 0;
        while (i < NW) {
            WindowState w = (WindowState)windows.get(i);
            if (w.mAppToken != null) {
                WindowState win = (WindowState)windows.remove(i);
                win.mRebuilding = true;
                this.mRebuildTmp[numRemoved] = win;
                this.mWindowsChanged = true;
                --NW;
                ++numRemoved;
                continue;
            }
            if (lastBelow == i - 1 && w.mAttrs.type == 2013) {
                lastBelow = i;
            }
            ++i;
        }
        i = ++lastBelow;
        ArrayList<TaskStack> stacks = displayContent.getStacks();
        int numStacks = stacks.size();
        for (stackNdx = 0; stackNdx < numStacks; ++stackNdx) {
            AppTokenList exitingAppTokens = stacks.get((int)stackNdx).mExitingAppTokens;
            int NT = exitingAppTokens.size();
            for (int j = 0; j < NT; ++j) {
                i = this.reAddAppWindowsLocked(displayContent, i, (WindowToken)exitingAppTokens.get(j));
            }
        }
        for (stackNdx = 0; stackNdx < numStacks; ++stackNdx) {
            ArrayList<Task> tasks = stacks.get(stackNdx).getTasks();
            int numTasks = tasks.size();
            for (int taskNdx = 0; taskNdx < numTasks; ++taskNdx) {
                AppTokenList tokens = tasks.get((int)taskNdx).mAppTokens;
                int numTokens = tokens.size();
                for (int tokenNdx = 0; tokenNdx < numTokens; ++tokenNdx) {
                    AppWindowToken wtoken = (AppWindowToken)tokens.get(tokenNdx);
                    if (wtoken.mIsExiting) continue;
                    i = this.reAddAppWindowsLocked(displayContent, i, wtoken);
                }
            }
        }
        if ((i -= lastBelow) != numRemoved) {
            displayContent.layoutNeeded = true;
            Slog.w(TAG, "On display=" + displayContent.getDisplayId() + " Rebuild removed " + numRemoved + " windows but added " + i, new RuntimeException("here").fillInStackTrace());
            for (i = 0; i < numRemoved; ++i) {
                WindowState ws = this.mRebuildTmp[i];
                if (!ws.mRebuilding) continue;
                StringWriter sw = new StringWriter();
                FastPrintWriter pw = new FastPrintWriter(sw, false, 1024);
                ws.dump(pw, "", true);
                ((PrintWriter)pw).flush();
                Slog.w(TAG, "This window was lost: " + ws);
                Slog.w(TAG, sw.toString());
                ws.mWinAnimator.destroySurfaceLocked();
            }
            Slog.w(TAG, "Current app token list:");
            this.dumpAppTokensLocked();
            Slog.w(TAG, "Final window list:");
            this.dumpWindowsLocked();
        }
        Arrays.fill(this.mRebuildTmp, null);
    }

    private final void assignLayersLocked(WindowList windows) {
        int N = windows.size();
        int curBaseLayer = 0;
        int curLayer = 0;
        boolean anyLayerChanged = false;
        for (int i = 0; i < N; ++i) {
            WindowState w = (WindowState)windows.get(i);
            WindowStateAnimator winAnimator = w.mWinAnimator;
            boolean layerChanged = false;
            int oldLayer = w.mLayer;
            if (w.mBaseLayer == curBaseLayer || w.mIsImWindow || i > 0 && w.mIsWallpaper) {
                w.mLayer = curLayer += 5;
            } else {
                curBaseLayer = curLayer = w.mBaseLayer;
                w.mLayer = curLayer;
            }
            if (w.mLayer != oldLayer) {
                layerChanged = true;
                anyLayerChanged = true;
            }
            AppWindowToken wtoken = w.mAppToken;
            oldLayer = winAnimator.mAnimLayer;
            winAnimator.mAnimLayer = w.mTargetAppToken != null ? w.mLayer + w.mTargetAppToken.mAppAnimator.animLayerAdjustment : (wtoken != null ? w.mLayer + wtoken.mAppAnimator.animLayerAdjustment : w.mLayer);
            if (w.mIsImWindow) {
                winAnimator.mAnimLayer += this.mInputMethodAnimLayerAdjustment;
            } else if (w.mIsWallpaper) {
                winAnimator.mAnimLayer += this.mWallpaperAnimLayerAdjustment;
            }
            if (winAnimator.mAnimLayer != oldLayer) {
                layerChanged = true;
                anyLayerChanged = true;
            }
            TaskStack stack = w.getStack();
            if (!layerChanged || stack == null || !stack.isDimming(winAnimator)) continue;
            this.scheduleAnimationLocked();
        }
        if (this.mAccessibilityController != null && anyLayerChanged && ((WindowState)windows.get(windows.size() - 1)).getDisplayId() == 0) {
            this.mAccessibilityController.onWindowLayersChangedLocked();
        }
    }

    private final void performLayoutAndPlaceSurfacesLocked() {
        int loopCount = 6;
        do {
            this.mTraversalScheduled = false;
            this.performLayoutAndPlaceSurfacesLockedLoop();
            this.mH.removeMessages(4);
        } while (this.mTraversalScheduled && --loopCount > 0);
        this.mInnerFields.mWallpaperActionPending = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void performLayoutAndPlaceSurfacesLockedLoop() {
        if (this.mInLayout) {
            Slog.w(TAG, "performLayoutAndPlaceSurfacesLocked called while in layout. Callers=" + Debug.getCallers(3));
            return;
        }
        if (this.mWaitingForConfig) {
            return;
        }
        if (!this.mDisplayReady) {
            return;
        }
        Trace.traceBegin(32L, "wmLayout");
        this.mInLayout = true;
        boolean recoveringMemory = false;
        if (!this.mForceRemoves.isEmpty()) {
            Object tmp;
            recoveringMemory = true;
            while (!this.mForceRemoves.isEmpty()) {
                WindowState ws = this.mForceRemoves.remove(0);
                Slog.i(TAG, "Force removing: " + ws);
                this.removeWindowInnerLocked(ws);
            }
            Slog.w(TAG, "Due to memory failure, waiting a bit for next layout");
            Object object = tmp = new Object();
            synchronized (object) {
                try {
                    tmp.wait(250L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        try {
            this.performLayoutAndPlaceSurfacesLockedInner(recoveringMemory);
            this.mInLayout = false;
            if (this.needsLayout()) {
                if (++this.mLayoutRepeatCount < 6) {
                    this.requestTraversalLocked();
                } else {
                    Slog.e(TAG, "Performed 6 layouts in a row. Skipping");
                    this.mLayoutRepeatCount = 0;
                }
            } else {
                this.mLayoutRepeatCount = 0;
            }
            if (this.mWindowsChanged && !this.mWindowChangeListeners.isEmpty()) {
                this.mH.removeMessages(19);
                this.mH.sendEmptyMessage(19);
            }
        }
        catch (RuntimeException e) {
            this.mInLayout = false;
            Slog.wtf(TAG, "Unhandled exception while laying out windows", e);
        }
        Trace.traceEnd(32L);
    }

    private final void performLayoutLockedInner(DisplayContent displayContent, boolean initial, boolean updateInputWindows) {
        int i;
        if (!displayContent.layoutNeeded) {
            return;
        }
        displayContent.layoutNeeded = false;
        WindowList windows = displayContent.getWindowList();
        boolean isDefaultDisplay = displayContent.isDefaultDisplay;
        DisplayInfo displayInfo = displayContent.getDisplayInfo();
        int dw = displayInfo.logicalWidth;
        int dh = displayInfo.logicalHeight;
        if (this.mInputConsumer != null) {
            this.mInputConsumer.layout(dw, dh);
        }
        int N = windows.size();
        this.mPolicy.beginLayoutLw(isDefaultDisplay, dw, dh, this.mRotation);
        if (isDefaultDisplay) {
            this.mSystemDecorLayer = this.mPolicy.getSystemDecorLayerLw();
            this.mScreenRect.set(0, 0, dw, dh);
        }
        this.mPolicy.getContentRectLw(this.mTmpContentRect);
        displayContent.resize(this.mTmpContentRect);
        int seq = this.mLayoutSeq + 1;
        if (seq < 0) {
            seq = 0;
        }
        this.mLayoutSeq = seq;
        boolean behindDream = false;
        int topAttached = -1;
        for (i = N - 1; i >= 0; --i) {
            boolean gone;
            WindowState win = (WindowState)windows.get(i);
            boolean bl = gone = behindDream && this.mPolicy.canBeForceHidden(win, win.mAttrs) || win.isGoneForLayoutLw();
            if (gone && win.mHaveFrame && !win.mLayoutNeeded && (!win.isConfigChanged() && !win.setInsetsChanged() || (win.mAttrs.privateFlags & 0x400) == 0 && (!win.mHasSurface || win.mAppToken == null || !win.mAppToken.layoutConfigChanges))) continue;
            if (!win.mLayoutAttached) {
                if (initial) {
                    win.mContentChanged = false;
                }
                if (win.mAttrs.type == 2023) {
                    behindDream = true;
                }
                win.mLayoutNeeded = false;
                win.prelayout();
                this.mPolicy.layoutWindowLw(win, null);
                win.mLayoutSeq = seq;
                continue;
            }
            if (topAttached >= 0) continue;
            topAttached = i;
        }
        boolean attachedBehindDream = false;
        for (i = topAttached; i >= 0; --i) {
            WindowState win = (WindowState)windows.get(i);
            if (win.mLayoutAttached) {
                if (attachedBehindDream && this.mPolicy.canBeForceHidden(win, win.mAttrs) || (win.mViewVisibility == 8 || !win.mRelayoutCalled) && win.mHaveFrame && !win.mLayoutNeeded) continue;
                if (initial) {
                    win.mContentChanged = false;
                }
                win.mLayoutNeeded = false;
                win.prelayout();
                this.mPolicy.layoutWindowLw(win, win.mAttachedWindow);
                win.mLayoutSeq = seq;
                continue;
            }
            if (win.mAttrs.type != 2023) continue;
            attachedBehindDream = behindDream;
        }
        this.mInputMonitor.setUpdateInputWindowsNeededLw();
        if (updateInputWindows) {
            this.mInputMonitor.updateInputWindowsLw(false);
        }
        this.mPolicy.finishLayoutLw();
    }

    void makeWindowFreezingScreenIfNeededLocked(WindowState w) {
        if (!this.okToDisplay() && this.mWindowsFreezingScreen != 2) {
            w.mOrientationChanging = true;
            w.mLastFreezeDuration = 0;
            this.mInnerFields.mOrientationChangeComplete = false;
            if (this.mWindowsFreezingScreen == 0) {
                this.mWindowsFreezingScreen = 1;
                this.mH.removeMessages(11);
                this.mH.sendEmptyMessageDelayed(11, 2000L);
            }
        }
    }

    public int handleAppTransitionReadyLocked(WindowList windows) {
        int i;
        int changes = 0;
        int appsCount = this.mOpeningApps.size();
        boolean goodToGo = true;
        if (!this.mAppTransition.isTimeout()) {
            for (i = 0; i < appsCount && goodToGo; ++i) {
                AppWindowToken wtoken = this.mOpeningApps.valueAt(i);
                if (wtoken.allDrawn || wtoken.startingDisplayed || wtoken.startingMoved) continue;
                goodToGo = false;
            }
            if (goodToGo && this.isWallpaperVisible(this.mWallpaperTarget)) {
                boolean wallpaperGoodToGo = true;
                block7: for (int curTokenIndex = this.mWallpaperTokens.size() - 1; curTokenIndex >= 0 && wallpaperGoodToGo; --curTokenIndex) {
                    WindowToken token = this.mWallpaperTokens.get(curTokenIndex);
                    for (int curWallpaperIndex = token.windows.size() - 1; curWallpaperIndex >= 0; --curWallpaperIndex) {
                        WindowState wallpaper = (WindowState)token.windows.get(curWallpaperIndex);
                        if (!wallpaper.mWallpaperVisible || wallpaper.isDrawnLw()) continue;
                        wallpaperGoodToGo = false;
                        if (this.mWallpaperDrawState != 2) {
                            goodToGo = false;
                        }
                        if (this.mWallpaperDrawState != 0) continue block7;
                        this.mWallpaperDrawState = 1;
                        this.mH.removeMessages(39);
                        this.mH.sendEmptyMessageDelayed(39, 500L);
                        continue block7;
                    }
                }
                if (wallpaperGoodToGo) {
                    this.mWallpaperDrawState = 0;
                    this.mH.removeMessages(39);
                }
            }
        }
        if (goodToGo) {
            int j;
            AppWindowAnimator appAnimator;
            AppWindowToken wtoken;
            int j2;
            WindowState win;
            AppWindowToken lowerWallpaperAppToken;
            AppWindowToken upperWallpaperAppToken;
            int transit = this.mAppTransition.getAppTransition();
            if (this.mSkipAppTransitionAnimation) {
                transit = -1;
            }
            this.mSkipAppTransitionAnimation = false;
            this.mNoAnimationNotifyOnTransitionFinished.clear();
            this.mH.removeMessages(13);
            this.rebuildAppWindowListLocked();
            WindowState oldWallpaper = this.mWallpaperTarget != null && this.mWallpaperTarget.mWinAnimator.isAnimating() && !this.mWallpaperTarget.mWinAnimator.isDummyAnimation() ? null : this.mWallpaperTarget;
            this.mInnerFields.mWallpaperMayChange = false;
            WindowManager.LayoutParams animLp = null;
            int bestAnimLayer = -1;
            boolean fullscreenAnim = false;
            boolean voiceInteraction = false;
            boolean openingAppHasWallpaper = false;
            boolean closingAppHasWallpaper = false;
            if (this.mLowerWallpaperTarget == null) {
                upperWallpaperAppToken = null;
                lowerWallpaperAppToken = null;
            } else {
                lowerWallpaperAppToken = this.mLowerWallpaperTarget.mAppToken;
                upperWallpaperAppToken = this.mUpperWallpaperTarget.mAppToken;
            }
            int closingAppsCount = this.mClosingApps.size();
            appsCount = closingAppsCount + this.mOpeningApps.size();
            for (i = 0; i < appsCount; ++i) {
                WindowState ws;
                AppWindowToken wtoken2;
                if (i < closingAppsCount) {
                    wtoken2 = this.mClosingApps.valueAt(i);
                    if (wtoken2 == lowerWallpaperAppToken || wtoken2 == upperWallpaperAppToken) {
                        closingAppHasWallpaper = true;
                    }
                } else {
                    wtoken2 = this.mOpeningApps.valueAt(i - closingAppsCount);
                    if (wtoken2 == lowerWallpaperAppToken || wtoken2 == upperWallpaperAppToken) {
                        openingAppHasWallpaper = true;
                    }
                }
                voiceInteraction |= wtoken2.voiceInteraction;
                if (wtoken2.appFullscreen) {
                    ws = wtoken2.findMainWindow();
                    if (ws == null) continue;
                    animLp = ws.mAttrs;
                    bestAnimLayer = ws.mLayer;
                    fullscreenAnim = true;
                    continue;
                }
                if (fullscreenAnim || (ws = wtoken2.findMainWindow()) == null || ws.mLayer <= bestAnimLayer) continue;
                animLp = ws.mAttrs;
                bestAnimLayer = ws.mLayer;
            }
            this.mAnimateWallpaperWithTarget = false;
            if (closingAppHasWallpaper && openingAppHasWallpaper) {
                switch (transit) {
                    case 6: 
                    case 8: 
                    case 10: {
                        transit = 14;
                        break;
                    }
                    case 7: 
                    case 9: 
                    case 11: {
                        transit = 15;
                    }
                }
            } else if (oldWallpaper != null && !this.mOpeningApps.isEmpty() && !this.mOpeningApps.contains(oldWallpaper.mAppToken)) {
                transit = 12;
            } else if (this.mWallpaperTarget != null && this.mWallpaperTarget.isVisibleLw()) {
                transit = 13;
            } else {
                this.mAnimateWallpaperWithTarget = true;
            }
            if (!this.mPolicy.allowAppAnimationsLw()) {
                animLp = null;
            }
            AppWindowToken topOpeningApp = null;
            AppWindowToken topClosingApp = null;
            int topOpeningLayer = 0;
            int topClosingLayer = 0;
            if (transit == 17 && (win = this.findFocusedWindowLocked(this.getDefaultDisplayContentLocked())) != null) {
                AppWindowToken wtoken3 = win.mAppToken;
                AppWindowAnimator appAnimator2 = wtoken3.mAppAnimator;
                appAnimator2.clearThumbnail();
                appAnimator2.animation = null;
                this.updateTokenInPlaceLocked(wtoken3, transit);
                wtoken3.updateReportedVisibilityLocked();
                appAnimator2.mAllAppWinAnimators.clear();
                int N = wtoken3.allAppWindows.size();
                for (j2 = 0; j2 < N; ++j2) {
                    appAnimator2.mAllAppWinAnimators.add(((WindowState)wtoken3.allAppWindows.get((int)j2)).mWinAnimator);
                }
                this.mAnimator.mAppWindowAnimating |= appAnimator2.isAnimating();
                this.mAnimator.mAnimating |= appAnimator2.showAllWindowsLocked();
            }
            appsCount = this.mOpeningApps.size();
            for (i = 0; i < appsCount; ++i) {
                wtoken = this.mOpeningApps.valueAt(i);
                appAnimator = wtoken.mAppAnimator;
                if (!appAnimator.usingTransferredAnimation) {
                    appAnimator.clearThumbnail();
                    appAnimator.animation = null;
                }
                wtoken.inPendingTransaction = false;
                if (!this.setTokenVisibilityLocked(wtoken, animLp, true, transit, false, voiceInteraction)) {
                    this.mNoAnimationNotifyOnTransitionFinished.add(wtoken.token);
                }
                wtoken.updateReportedVisibilityLocked();
                wtoken.waitingToShow = false;
                appAnimator.mAllAppWinAnimators.clear();
                int windowsCount = wtoken.allAppWindows.size();
                for (j = 0; j < windowsCount; ++j) {
                    appAnimator.mAllAppWinAnimators.add(((WindowState)wtoken.allAppWindows.get((int)j)).mWinAnimator);
                }
                this.mAnimator.mAnimating |= appAnimator.showAllWindowsLocked();
                this.mAnimator.mAppWindowAnimating |= appAnimator.isAnimating();
                if (animLp == null) continue;
                int layer = -1;
                for (j2 = 0; j2 < wtoken.windows.size(); ++j2) {
                    WindowState win2 = (WindowState)wtoken.windows.get(j2);
                    if (win2.mWinAnimator.mAnimLayer <= layer) continue;
                    layer = win2.mWinAnimator.mAnimLayer;
                }
                if (topOpeningApp != null && layer <= topOpeningLayer) continue;
                topOpeningApp = wtoken;
                topOpeningLayer = layer;
            }
            appsCount = this.mClosingApps.size();
            for (i = 0; i < appsCount; ++i) {
                wtoken = this.mClosingApps.valueAt(i);
                appAnimator = wtoken.mAppAnimator;
                appAnimator.clearThumbnail();
                appAnimator.animation = null;
                wtoken.inPendingTransaction = false;
                this.setTokenVisibilityLocked(wtoken, animLp, false, transit, false, voiceInteraction);
                wtoken.updateReportedVisibilityLocked();
                wtoken.allDrawn = true;
                wtoken.deferClearAllDrawn = false;
                if (wtoken.startingWindow != null && !wtoken.startingWindow.mExiting) {
                    this.scheduleRemoveStartingWindowLocked(wtoken);
                }
                this.mAnimator.mAppWindowAnimating |= appAnimator.isAnimating();
                if (animLp == null) continue;
                int layer = -1;
                for (j = 0; j < wtoken.windows.size(); ++j) {
                    WindowState win3 = (WindowState)wtoken.windows.get(j);
                    if (win3.mWinAnimator.mAnimLayer <= layer) continue;
                    layer = win3.mWinAnimator.mAnimLayer;
                }
                if (topClosingApp != null && layer <= topClosingLayer) continue;
                topClosingApp = wtoken;
                topClosingLayer = layer;
            }
            AppWindowAnimator openingAppAnimator = topOpeningApp == null ? null : topOpeningApp.mAppAnimator;
            AppWindowAnimator closingAppAnimator = topClosingApp == null ? null : topClosingApp.mAppAnimator;
            Bitmap nextAppTransitionThumbnail = this.mAppTransition.getNextAppTransitionThumbnail();
            if (nextAppTransitionThumbnail != null && openingAppAnimator != null && openingAppAnimator.animation != null && nextAppTransitionThumbnail.getConfig() != Bitmap.Config.ALPHA_8) {
                Rect dirty = new Rect(0, 0, nextAppTransitionThumbnail.getWidth(), nextAppTransitionThumbnail.getHeight());
                try {
                    Animation anim2;
                    DisplayContent displayContent = this.getDefaultDisplayContentLocked();
                    Display display = displayContent.getDisplay();
                    DisplayInfo displayInfo = displayContent.getDisplayInfo();
                    SurfaceControl surfaceControl = new SurfaceControl(this.mFxSession, "thumbnail anim", dirty.width(), dirty.height(), -3, 4);
                    surfaceControl.setLayerStack(display.getLayerStack());
                    Surface drawSurface = new Surface();
                    drawSurface.copyFrom(surfaceControl);
                    Canvas c = drawSurface.lockCanvas(dirty);
                    c.drawBitmap(nextAppTransitionThumbnail, 0.0f, 0.0f, null);
                    drawSurface.unlockCanvasAndPost(c);
                    drawSurface.release();
                    if (this.mAppTransition.isNextThumbnailTransitionAspectScaled()) {
                        anim2 = this.mAppTransition.createThumbnailAspectScaleAnimationLocked(displayInfo.appWidth, displayInfo.appHeight, displayInfo.logicalWidth, transit);
                        openingAppAnimator.thumbnailForceAboveLayer = Math.max(topOpeningLayer, topClosingLayer);
                        openingAppAnimator.deferThumbnailDestruction = !this.mAppTransition.isNextThumbnailTransitionScaleUp();
                    } else {
                        anim2 = this.mAppTransition.createThumbnailScaleAnimationLocked(displayInfo.appWidth, displayInfo.appHeight, transit);
                    }
                    anim2.restrictDuration(10000L);
                    anim2.scaleCurrentDuration(this.getTransitionAnimationScaleLocked());
                    openingAppAnimator.thumbnail = surfaceControl;
                    openingAppAnimator.thumbnailLayer = topOpeningLayer;
                    openingAppAnimator.thumbnailAnimation = anim2;
                    openingAppAnimator.thumbnailX = this.mAppTransition.getStartingX();
                    openingAppAnimator.thumbnailY = this.mAppTransition.getStartingY();
                }
                catch (Surface.OutOfResourcesException e) {
                    Slog.e(TAG, "Can't allocate thumbnail/Canvas surface w=" + dirty.width() + " h=" + dirty.height(), e);
                    openingAppAnimator.clearThumbnail();
                }
            }
            this.mAppTransition.goodToGo(openingAppAnimator, closingAppAnimator);
            this.mAppTransition.postAnimationCallback();
            this.mAppTransition.clear();
            this.mOpeningApps.clear();
            this.mClosingApps.clear();
            changes |= 3;
            this.getDefaultDisplayContentLocked().layoutNeeded = true;
            if (windows == this.getDefaultWindowListLocked() && !this.moveInputMethodWindowsIfNeededLocked(true)) {
                this.assignLayersLocked(windows);
            }
            this.updateFocusedWindowLocked(2, true);
            this.mFocusMayChange = false;
            this.notifyActivityDrawnForKeyguard();
        }
        return changes;
    }

    private int handleAnimatingStoppedAndTransitionLocked() {
        int changes = 0;
        this.mAppTransition.setIdle();
        for (int i = this.mNoAnimationNotifyOnTransitionFinished.size() - 1; i >= 0; --i) {
            IBinder token = this.mNoAnimationNotifyOnTransitionFinished.get(i);
            this.mAppTransition.notifyAppTransitionFinishedLocked(token);
        }
        this.mNoAnimationNotifyOnTransitionFinished.clear();
        if (this.mDeferredHideWallpaper != null) {
            this.hideWallpapersLocked(this.mDeferredHideWallpaper);
            this.mDeferredHideWallpaper = null;
        }
        ArrayList<TaskStack> stacks = this.getDefaultDisplayContentLocked().getStacks();
        for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
            ArrayList<Task> tasks = stacks.get(stackNdx).getTasks();
            for (int taskNdx = tasks.size() - 1; taskNdx >= 0; --taskNdx) {
                AppTokenList tokens = tasks.get((int)taskNdx).mAppTokens;
                for (int tokenNdx = tokens.size() - 1; tokenNdx >= 0; --tokenNdx) {
                    ((AppWindowToken)tokens.get((int)tokenNdx)).sendingToBottom = false;
                }
            }
        }
        this.rebuildAppWindowListLocked();
        this.moveInputMethodWindowsIfNeededLocked(true);
        this.mInnerFields.mWallpaperMayChange = true;
        this.mFocusMayChange = true;
        return changes |= 1;
    }

    private void updateResizingWindows(WindowState w) {
        WindowStateAnimator winAnimator = w.mWinAnimator;
        if (w.mHasSurface && w.mLayoutSeq == this.mLayoutSeq) {
            w.setInsetsChanged();
            boolean configChanged = w.isConfigChanged();
            w.mLastFrame.set(w.mFrame);
            if (w.mContentInsetsChanged || w.mVisibleInsetsChanged || winAnimator.mSurfaceResized || w.mOutsetsChanged || configChanged) {
                w.mLastOverscanInsets.set(w.mOverscanInsets);
                w.mLastContentInsets.set(w.mContentInsets);
                w.mLastVisibleInsets.set(w.mVisibleInsets);
                w.mLastStableInsets.set(w.mStableInsets);
                w.mLastOutsets.set(w.mOutsets);
                this.makeWindowFreezingScreenIfNeededLocked(w);
                if (w.mOrientationChanging) {
                    winAnimator.mDrawState = 1;
                    if (w.mAppToken != null) {
                        w.mAppToken.allDrawn = false;
                        w.mAppToken.deferClearAllDrawn = false;
                    }
                }
                if (!this.mResizingWindows.contains(w)) {
                    this.mResizingWindows.add(w);
                }
            } else if (w.mOrientationChanging && w.isDrawnLw()) {
                w.mOrientationChanging = false;
                w.mLastFreezeDuration = (int)(SystemClock.elapsedRealtime() - this.mDisplayFreezeTime);
            }
        }
    }

    private void handleNotObscuredLocked(WindowState w, int innerDw, int innerDh) {
        boolean opaqueDrawn;
        WindowManager.LayoutParams attrs = w.mAttrs;
        int attrFlags = attrs.flags;
        boolean canBeSeen = w.isDisplayedLw();
        boolean bl = opaqueDrawn = canBeSeen && w.isOpaqueDrawn();
        if (opaqueDrawn && w.isFullscreen(innerDw, innerDh)) {
            this.mInnerFields.mObscured = true;
        }
        if (w.mHasSurface) {
            if ((attrFlags & 0x80) != 0) {
                this.mInnerFields.mHoldScreen = w.mSession;
            }
            if (!this.mInnerFields.mSyswin && w.mAttrs.screenBrightness >= 0.0f && this.mInnerFields.mScreenBrightness < 0.0f) {
                this.mInnerFields.mScreenBrightness = w.mAttrs.screenBrightness;
            }
            if (!this.mInnerFields.mSyswin && w.mAttrs.buttonBrightness >= 0.0f && this.mInnerFields.mButtonBrightness < 0.0f) {
                this.mInnerFields.mButtonBrightness = w.mAttrs.buttonBrightness;
            }
            if (!this.mInnerFields.mSyswin && w.mAttrs.userActivityTimeout >= 0L && this.mInnerFields.mUserActivityTimeout < 0L) {
                this.mInnerFields.mUserActivityTimeout = w.mAttrs.userActivityTimeout;
            }
            int type = attrs.type;
            if (canBeSeen && (type == 2008 || type == 2010 || (attrs.privateFlags & 0x400) != 0)) {
                this.mInnerFields.mSyswin = true;
            }
            if (canBeSeen) {
                DisplayContent displayContent = w.getDisplayContent();
                if (displayContent != null && displayContent.isDefaultDisplay) {
                    if (type == 2023 || (attrs.privateFlags & 0x400) != 0) {
                        this.mInnerFields.mObscureApplicationContentOnSecondaryDisplays = true;
                    }
                    this.mInnerFields.mDisplayHasContent = true;
                } else if (displayContent != null && (!this.mInnerFields.mObscureApplicationContentOnSecondaryDisplays || this.mInnerFields.mObscured && type == 2009)) {
                    this.mInnerFields.mDisplayHasContent = true;
                }
                if (this.mInnerFields.mPreferredRefreshRate == 0.0f && w.mAttrs.preferredRefreshRate != 0.0f) {
                    this.mInnerFields.mPreferredRefreshRate = w.mAttrs.preferredRefreshRate;
                }
                if (this.mInnerFields.mPreferredModeId == 0 && w.mAttrs.preferredDisplayModeId != 0) {
                    this.mInnerFields.mPreferredModeId = w.mAttrs.preferredDisplayModeId;
                }
            }
        }
    }

    private void handleFlagDimBehind(WindowState w) {
        WindowManager.LayoutParams attrs = w.mAttrs;
        if ((attrs.flags & 2) != 0 && w.isDisplayedLw() && !w.mExiting) {
            WindowStateAnimator winAnimator = w.mWinAnimator;
            TaskStack stack = w.getStack();
            if (stack == null) {
                return;
            }
            stack.setDimmingTag();
            if (!stack.isDimming(winAnimator)) {
                stack.startDimmingIfNeeded(winAnimator);
            }
        }
    }

    private void updateAllDrawnLocked(DisplayContent displayContent) {
        ArrayList<TaskStack> stacks = displayContent.getStacks();
        for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
            ArrayList<Task> tasks = stacks.get(stackNdx).getTasks();
            for (int taskNdx = tasks.size() - 1; taskNdx >= 0; --taskNdx) {
                AppTokenList tokens = tasks.get((int)taskNdx).mAppTokens;
                for (int tokenNdx = tokens.size() - 1; tokenNdx >= 0; --tokenNdx) {
                    int numInteresting;
                    AppWindowToken wtoken = (AppWindowToken)tokens.get(tokenNdx);
                    if (wtoken.allDrawn || (numInteresting = wtoken.numInterestingWindows) <= 0 || wtoken.numDrawnWindows < numInteresting) continue;
                    wtoken.allDrawn = true;
                    displayContent.layoutNeeded = true;
                    this.mH.obtainMessage(32, wtoken.token).sendToTarget();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void performLayoutAndPlaceSurfacesLockedInner(boolean recoveringMemory) {
        int N;
        int displayNdx;
        int i;
        boolean updateInputWindowsNeeded = false;
        if (this.mFocusMayChange) {
            this.mFocusMayChange = false;
            updateInputWindowsNeeded = this.updateFocusedWindowLocked(3, false);
        }
        int numDisplays = this.mDisplayContents.size();
        for (int displayNdx2 = 0; displayNdx2 < numDisplays; ++displayNdx2) {
            DisplayContent displayContent = this.mDisplayContents.valueAt(displayNdx2);
            for (i = displayContent.mExitingTokens.size() - 1; i >= 0; --i) {
                displayContent.mExitingTokens.get((int)i).hasVisible = false;
            }
        }
        for (int stackNdx = this.mStackIdToStack.size() - 1; stackNdx >= 0; --stackNdx) {
            AppTokenList exitingAppTokens = this.mStackIdToStack.valueAt((int)stackNdx).mExitingAppTokens;
            for (int tokenNdx = exitingAppTokens.size() - 1; tokenNdx >= 0; --tokenNdx) {
                ((AppWindowToken)exitingAppTokens.get((int)tokenNdx)).hasVisible = false;
            }
        }
        this.mInnerFields.mHoldScreen = null;
        this.mInnerFields.mScreenBrightness = -1.0f;
        this.mInnerFields.mButtonBrightness = -1.0f;
        this.mInnerFields.mUserActivityTimeout = -1L;
        this.mInnerFields.mObscureApplicationContentOnSecondaryDisplays = false;
        ++this.mTransactionSequence;
        DisplayContent defaultDisplay = this.getDefaultDisplayContentLocked();
        DisplayInfo defaultInfo = defaultDisplay.getDisplayInfo();
        int defaultDw = defaultInfo.logicalWidth;
        int defaultDh = defaultInfo.logicalHeight;
        SurfaceControl.openTransaction();
        try {
            if (this.mWatermark != null) {
                this.mWatermark.positionSurface(defaultDw, defaultDh);
            }
            if (this.mStrictModeFlash != null) {
                this.mStrictModeFlash.positionSurface(defaultDw, defaultDh);
            }
            if (this.mCircularDisplayMask != null) {
                this.mCircularDisplayMask.positionSurface(defaultDw, defaultDh, this.mRotation);
            }
            if (this.mEmulatorDisplayOverlay != null) {
                this.mEmulatorDisplayOverlay.positionSurface(defaultDw, defaultDh, this.mRotation);
            }
            boolean focusDisplayed = false;
            for (int displayNdx3 = 0; displayNdx3 < numDisplays; ++displayNdx3) {
                DisplayContent displayContent = this.mDisplayContents.valueAt(displayNdx3);
                boolean updateAllDrawn = false;
                WindowList windows = displayContent.getWindowList();
                DisplayInfo displayInfo = displayContent.getDisplayInfo();
                int displayId = displayContent.getDisplayId();
                int dw = displayInfo.logicalWidth;
                int dh = displayInfo.logicalHeight;
                int innerDw = displayInfo.appWidth;
                int innerDh = displayInfo.appHeight;
                boolean isDefaultDisplay = displayId == 0;
                this.mInnerFields.mDisplayHasContent = false;
                this.mInnerFields.mPreferredRefreshRate = 0.0f;
                this.mInnerFields.mPreferredModeId = 0;
                int repeats = 0;
                do {
                    if (++repeats > 6) {
                        Slog.w(TAG, "Animation repeat aborted after too many iterations");
                        displayContent.layoutNeeded = false;
                        break;
                    }
                    this.debugLayoutRepeats("On entry to LockedInner", displayContent.pendingLayoutChanges);
                    if ((displayContent.pendingLayoutChanges & 4) != 0 && this.adjustWallpaperWindowsLocked()) {
                        this.assignLayersLocked(windows);
                        displayContent.layoutNeeded = true;
                    }
                    if (isDefaultDisplay && (displayContent.pendingLayoutChanges & 2) != 0 && this.updateOrientationFromAppTokensLocked(true)) {
                        displayContent.layoutNeeded = true;
                        this.mH.sendEmptyMessage(18);
                    }
                    if ((displayContent.pendingLayoutChanges & 1) != 0) {
                        displayContent.layoutNeeded = true;
                    }
                    if (repeats < 4) {
                        this.performLayoutLockedInner(displayContent, repeats == 1, false);
                    } else {
                        Slog.w(TAG, "Layout repeat skipped after too many iterations");
                    }
                    displayContent.pendingLayoutChanges = 0;
                    if (!isDefaultDisplay) continue;
                    this.mPolicy.beginPostLayoutPolicyLw(dw, dh);
                    for (i = windows.size() - 1; i >= 0; --i) {
                        WindowState w = (WindowState)windows.get(i);
                        if (!w.mHasSurface) continue;
                        this.mPolicy.applyPostLayoutPolicyLw(w, w.mAttrs, w.mAttachedWindow);
                    }
                    displayContent.pendingLayoutChanges |= this.mPolicy.finishPostLayoutPolicyLw();
                    this.debugLayoutRepeats("after finishPostLayoutPolicyLw", displayContent.pendingLayoutChanges);
                } while (displayContent.pendingLayoutChanges != 0);
                this.mInnerFields.mObscured = false;
                this.mInnerFields.mSyswin = false;
                displayContent.resetDimming();
                boolean someoneLosingFocus = !this.mLosingFocus.isEmpty();
                int N2 = windows.size();
                for (i = N2 - 1; i >= 0; --i) {
                    AppWindowToken atoken;
                    WindowState w = (WindowState)windows.get(i);
                    TaskStack stack = w.getStack();
                    if (stack == null && w.getAttrs().type != 2030) continue;
                    boolean obscuredChanged = w.mObscured != this.mInnerFields.mObscured;
                    w.mObscured = this.mInnerFields.mObscured;
                    if (!this.mInnerFields.mObscured) {
                        this.handleNotObscuredLocked(w, innerDw, innerDh);
                    }
                    if (stack != null && !stack.testDimmingTag()) {
                        this.handleFlagDimBehind(w);
                    }
                    if (isDefaultDisplay && obscuredChanged && this.mWallpaperTarget == w && w.isVisibleLw()) {
                        this.updateWallpaperVisibilityLocked();
                    }
                    WindowStateAnimator winAnimator = w.mWinAnimator;
                    if (w.hasMoved()) {
                        int left = w.mFrame.left;
                        int top = w.mFrame.top;
                        if ((w.mAttrs.privateFlags & 0x40) == 0) {
                            Animation a = AnimationUtils.loadAnimation(this.mContext, 17432716);
                            winAnimator.setAnimation(a);
                            winAnimator.mAnimDw = w.mLastFrame.left - left;
                            winAnimator.mAnimDh = w.mLastFrame.top - top;
                            winAnimator.mAnimateMove = true;
                            winAnimator.mAnimatingMove = true;
                        }
                        if (this.mAccessibilityController != null && displayId == 0) {
                            this.mAccessibilityController.onSomeWindowResizedOrMovedLocked();
                        }
                        try {
                            w.mClient.moved(left, top);
                        }
                        catch (RemoteException e) {
                            // empty catch block
                        }
                    }
                    w.mContentChanged = false;
                    if (w.mHasSurface) {
                        boolean committed = winAnimator.commitFinishDrawingLocked();
                        if (isDefaultDisplay && committed) {
                            if (w.mAttrs.type == 2023) {
                                displayContent.pendingLayoutChanges |= 1;
                                this.debugLayoutRepeats("dream and commitFinishDrawingLocked true", displayContent.pendingLayoutChanges);
                            }
                            if ((w.mAttrs.flags & 0x100000) != 0) {
                                this.mInnerFields.mWallpaperMayChange = true;
                                displayContent.pendingLayoutChanges |= 4;
                                this.debugLayoutRepeats("wallpaper and commitFinishDrawingLocked true", displayContent.pendingLayoutChanges);
                            }
                        }
                        winAnimator.setSurfaceBoundariesLocked(recoveringMemory);
                    }
                    if ((atoken = w.mAppToken) != null && (!atoken.allDrawn || atoken.mAppAnimator.freezingScreen)) {
                        if (atoken.lastTransactionSequence != (long)this.mTransactionSequence) {
                            atoken.lastTransactionSequence = this.mTransactionSequence;
                            atoken.numDrawnWindows = 0;
                            atoken.numInterestingWindows = 0;
                            atoken.startingDisplayed = false;
                        }
                        if (!(!w.isOnScreenIgnoringKeyguard() && winAnimator.mAttrType != 1 || w.mExiting || w.mDestroying)) {
                            if (w != atoken.startingWindow) {
                                if (!atoken.mAppAnimator.freezingScreen || !w.mAppFreezing) {
                                    ++atoken.numInterestingWindows;
                                    if (w.isDrawnLw()) {
                                        ++atoken.numDrawnWindows;
                                        updateAllDrawn = true;
                                    }
                                }
                            } else if (w.isDrawnLw()) {
                                atoken.startingDisplayed = true;
                            }
                        }
                    }
                    if (isDefaultDisplay && someoneLosingFocus && w == this.mCurrentFocus && w.isDisplayedLw()) {
                        focusDisplayed = true;
                    }
                    this.updateResizingWindows(w);
                }
                this.mDisplayManagerInternal.setDisplayProperties(displayId, this.mInnerFields.mDisplayHasContent, this.mInnerFields.mPreferredRefreshRate, this.mInnerFields.mPreferredModeId, true);
                this.getDisplayContentLocked(displayId).stopDimmingIfNeeded();
                if (!updateAllDrawn) continue;
                this.updateAllDrawnLocked(displayContent);
            }
            if (focusDisplayed) {
                this.mH.sendEmptyMessage(3);
            }
            this.mDisplayManagerInternal.performTraversalInTransactionFromWindowManager();
        }
        catch (RuntimeException e) {
            Slog.wtf(TAG, "Unhandled exception in Window Manager", e);
        }
        finally {
            SurfaceControl.closeTransaction();
        }
        WindowList defaultWindows = defaultDisplay.getWindowList();
        if (this.mAppTransition.isReady()) {
            defaultDisplay.pendingLayoutChanges |= this.handleAppTransitionReadyLocked(defaultWindows);
            this.debugLayoutRepeats("after handleAppTransitionReadyLocked", defaultDisplay.pendingLayoutChanges);
        }
        if (!this.mAnimator.mAppWindowAnimating && this.mAppTransition.isRunning()) {
            defaultDisplay.pendingLayoutChanges |= this.handleAnimatingStoppedAndTransitionLocked();
            this.debugLayoutRepeats("after handleAnimStopAndXitionLock", defaultDisplay.pendingLayoutChanges);
        }
        if (this.mInnerFields.mWallpaperForceHidingChanged && defaultDisplay.pendingLayoutChanges == 0 && !this.mAppTransition.isReady()) {
            defaultDisplay.pendingLayoutChanges |= 1;
            this.debugLayoutRepeats("after animateAwayWallpaperLocked", defaultDisplay.pendingLayoutChanges);
        }
        this.mInnerFields.mWallpaperForceHidingChanged = false;
        if (this.mInnerFields.mWallpaperMayChange) {
            defaultDisplay.pendingLayoutChanges |= 4;
            this.debugLayoutRepeats("WallpaperMayChange", defaultDisplay.pendingLayoutChanges);
        }
        if (this.mFocusMayChange) {
            this.mFocusMayChange = false;
            if (this.updateFocusedWindowLocked(2, false)) {
                updateInputWindowsNeeded = true;
                defaultDisplay.pendingLayoutChanges |= 8;
            }
        }
        if (this.needsLayout()) {
            defaultDisplay.pendingLayoutChanges |= 1;
            this.debugLayoutRepeats("mLayoutNeeded", defaultDisplay.pendingLayoutChanges);
        }
        for (i = this.mResizingWindows.size() - 1; i >= 0; --i) {
            WindowState win = this.mResizingWindows.get(i);
            if (win.mAppFreezing) continue;
            win.reportResized();
            this.mResizingWindows.remove(i);
        }
        if (this.mInnerFields.mOrientationChangeComplete) {
            if (this.mWindowsFreezingScreen != 0) {
                this.mWindowsFreezingScreen = 0;
                this.mLastFinishedFreezeSource = this.mInnerFields.mLastWindowFreezeSource;
                this.mH.removeMessages(11);
            }
            this.stopFreezingDisplayLocked();
        }
        boolean wallpaperDestroyed = false;
        i = this.mDestroySurface.size();
        if (i > 0) {
            do {
                WindowState win = this.mDestroySurface.get(--i);
                win.mDestroying = false;
                if (this.mInputMethodWindow == win) {
                    this.mInputMethodWindow = null;
                }
                if (win == this.mWallpaperTarget) {
                    wallpaperDestroyed = true;
                }
                win.mWinAnimator.destroySurfaceLocked();
            } while (i > 0);
            this.mDestroySurface.clear();
        }
        for (displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
            DisplayContent displayContent = this.mDisplayContents.valueAt(displayNdx);
            ArrayList<WindowToken> exitingTokens = displayContent.mExitingTokens;
            for (i = exitingTokens.size() - 1; i >= 0; --i) {
                WindowToken token = exitingTokens.get(i);
                if (token.hasVisible) continue;
                exitingTokens.remove(i);
                if (token.windowType != 2013) continue;
                this.mWallpaperTokens.remove(token);
            }
        }
        for (int stackNdx = this.mStackIdToStack.size() - 1; stackNdx >= 0; --stackNdx) {
            AppTokenList exitingAppTokens = this.mStackIdToStack.valueAt((int)stackNdx).mExitingAppTokens;
            for (i = exitingAppTokens.size() - 1; i >= 0; --i) {
                AppWindowToken token = (AppWindowToken)exitingAppTokens.get(i);
                if (token.hasVisible || this.mClosingApps.contains(token) || token.mIsExiting && !token.allAppWindows.isEmpty()) continue;
                token.mAppAnimator.clearAnimation();
                token.mAppAnimator.animating = false;
                token.removeAppFromTaskLocked();
            }
        }
        if (wallpaperDestroyed) {
            defaultDisplay.pendingLayoutChanges |= 4;
            defaultDisplay.layoutNeeded = true;
        }
        for (displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
            DisplayContent displayContent = this.mDisplayContents.valueAt(displayNdx);
            if (displayContent.pendingLayoutChanges == 0) continue;
            displayContent.layoutNeeded = true;
        }
        this.mInputMonitor.updateInputWindowsLw(true);
        this.setHoldScreenLocked(this.mInnerFields.mHoldScreen);
        if (!this.mDisplayFrozen) {
            if (this.mInnerFields.mScreenBrightness < 0.0f || this.mInnerFields.mScreenBrightness > 1.0f) {
                this.mPowerManagerInternal.setScreenBrightnessOverrideFromWindowManager(-1);
            } else {
                this.mPowerManagerInternal.setScreenBrightnessOverrideFromWindowManager(this.toBrightnessOverride(this.mInnerFields.mScreenBrightness));
            }
            if (this.mInnerFields.mButtonBrightness < 0.0f || this.mInnerFields.mButtonBrightness > 1.0f) {
                this.mPowerManagerInternal.setButtonBrightnessOverrideFromWindowManager(-1);
            } else {
                this.mPowerManagerInternal.setButtonBrightnessOverrideFromWindowManager(this.toBrightnessOverride(this.mInnerFields.mButtonBrightness));
            }
            this.mPowerManagerInternal.setUserActivityTimeoutOverrideFromWindowManager(this.mInnerFields.mUserActivityTimeout);
        }
        if (this.mTurnOnScreen) {
            if (this.mAllowTheaterModeWakeFromLayout || Settings.Global.getInt(this.mContext.getContentResolver(), "theater_mode_on", 0) == 0) {
                this.mPowerManager.wakeUp(SystemClock.uptimeMillis(), "android.server.wm:TURN_ON");
            }
            this.mTurnOnScreen = false;
        }
        if (this.mInnerFields.mUpdateRotation) {
            if (this.updateRotationUncheckedLocked(false)) {
                this.mH.sendEmptyMessage(18);
            } else {
                this.mInnerFields.mUpdateRotation = false;
            }
        }
        if (this.mWaitingForDrawnCallback != null || this.mInnerFields.mOrientationChangeComplete && !defaultDisplay.layoutNeeded && !this.mInnerFields.mUpdateRotation) {
            this.checkDrawnWindowsLocked();
        }
        if ((N = this.mPendingRemove.size()) > 0) {
            if (this.mPendingRemoveTmp.length < N) {
                this.mPendingRemoveTmp = new WindowState[N + 10];
            }
            this.mPendingRemove.toArray(this.mPendingRemoveTmp);
            this.mPendingRemove.clear();
            DisplayContentList displayList = new DisplayContentList();
            for (i = 0; i < N; ++i) {
                WindowState w = this.mPendingRemoveTmp[i];
                this.removeWindowInnerLocked(w);
                DisplayContent displayContent = w.getDisplayContent();
                if (displayContent == null || displayList.contains(displayContent)) continue;
                displayList.add(displayContent);
            }
            for (DisplayContent displayContent : displayList) {
                this.assignLayersLocked(displayContent.getWindowList());
                displayContent.layoutNeeded = true;
            }
        }
        for (int displayNdx4 = this.mDisplayContents.size() - 1; displayNdx4 >= 0; --displayNdx4) {
            this.mDisplayContents.valueAt(displayNdx4).checkForDeferredActions();
        }
        if (updateInputWindowsNeeded) {
            this.mInputMonitor.updateInputWindowsLw(false);
        }
        this.setFocusedStackFrame();
        this.enableScreenIfNeededLocked();
        this.scheduleAnimationLocked();
    }

    private int toBrightnessOverride(float value) {
        return (int)(value * 255.0f);
    }

    void checkDrawnWindowsLocked() {
        if (this.mWaitingForDrawn.isEmpty() || this.mWaitingForDrawnCallback == null) {
            return;
        }
        for (int j = this.mWaitingForDrawn.size() - 1; j >= 0; --j) {
            WindowState win = this.mWaitingForDrawn.get(j);
            if (win.mRemoved || !win.mHasSurface) {
                this.mWaitingForDrawn.remove(win);
                continue;
            }
            if (!win.hasDrawnLw()) continue;
            this.mWaitingForDrawn.remove(win);
        }
        if (this.mWaitingForDrawn.isEmpty()) {
            this.mH.removeMessages(24);
            this.mH.sendEmptyMessage(33);
        }
    }

    void setHoldScreenLocked(Session newHoldScreen) {
        boolean hold;
        boolean bl = hold = newHoldScreen != null;
        if (hold && this.mHoldingScreenOn != newHoldScreen) {
            this.mHoldingScreenWakeLock.setWorkSource(new WorkSource(newHoldScreen.mUid));
        }
        this.mHoldingScreenOn = newHoldScreen;
        boolean state = this.mHoldingScreenWakeLock.isHeld();
        if (hold != state) {
            if (hold) {
                this.mHoldingScreenWakeLock.acquire();
                this.mPolicy.keepScreenOnStartedLw();
            } else {
                this.mPolicy.keepScreenOnStoppedLw();
                this.mHoldingScreenWakeLock.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void requestTraversal() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.requestTraversalLocked();
        }
    }

    void requestTraversalLocked() {
        if (!this.mTraversalScheduled) {
            this.mTraversalScheduled = true;
            this.mH.sendEmptyMessage(4);
        }
    }

    void scheduleAnimationLocked() {
        if (!this.mAnimationScheduled) {
            this.mAnimationScheduled = true;
            this.mChoreographer.postFrameCallback(this.mAnimator.mAnimationFrameCallback);
        }
    }

    private boolean needsLayout() {
        int numDisplays = this.mDisplayContents.size();
        for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
            DisplayContent displayContent = this.mDisplayContents.valueAt(displayNdx);
            if (!displayContent.layoutNeeded) continue;
            return true;
        }
        return false;
    }

    boolean copyAnimToLayoutParamsLocked() {
        boolean doRequest = false;
        int bulkUpdateParams = this.mAnimator.mBulkUpdateParams;
        if ((bulkUpdateParams & 1) != 0) {
            this.mInnerFields.mUpdateRotation = true;
            doRequest = true;
        }
        if ((bulkUpdateParams & 2) != 0) {
            this.mInnerFields.mWallpaperMayChange = true;
            doRequest = true;
        }
        if ((bulkUpdateParams & 4) != 0) {
            this.mInnerFields.mWallpaperForceHidingChanged = true;
            doRequest = true;
        }
        if ((bulkUpdateParams & 8) == 0) {
            this.mInnerFields.mOrientationChangeComplete = false;
        } else {
            this.mInnerFields.mOrientationChangeComplete = true;
            this.mInnerFields.mLastWindowFreezeSource = this.mAnimator.mLastWindowFreezeSource;
            if (this.mWindowsFreezingScreen != 0) {
                doRequest = true;
            }
        }
        if ((bulkUpdateParams & 0x10) != 0) {
            this.mTurnOnScreen = true;
        }
        if ((bulkUpdateParams & 0x20) != 0) {
            this.mInnerFields.mWallpaperActionPending = true;
        }
        return doRequest;
    }

    int adjustAnimationBackground(WindowStateAnimator winAnimator) {
        WindowList windows = winAnimator.mWin.getWindowList();
        for (int i = windows.size() - 1; i >= 0; --i) {
            WindowState testWin = (WindowState)windows.get(i);
            if (!testWin.mIsWallpaper || !testWin.isVisibleNow()) continue;
            return testWin.mWinAnimator.mAnimLayer;
        }
        return winAnimator.mAnimLayer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean reclaimSomeSurfaceMemoryLocked(WindowStateAnimator winAnimator, String operation, boolean secure) {
        SurfaceControl surface = winAnimator.mSurfaceControl;
        boolean leakedSurface = false;
        boolean killedApps = false;
        EventLog.writeEvent(31000, winAnimator.mWin.toString(), winAnimator.mSession.mPid, operation);
        long callingIdentity = Binder.clearCallingIdentity();
        try {
            Slog.i(TAG, "Out of memory for surface!  Looking for leaks...");
            int numDisplays = this.mDisplayContents.size();
            for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
                WindowList windows = this.mDisplayContents.valueAt(displayNdx).getWindowList();
                int numWindows = windows.size();
                for (int winNdx = 0; winNdx < numWindows; ++winNdx) {
                    WindowState ws = (WindowState)windows.get(winNdx);
                    WindowStateAnimator wsa = ws.mWinAnimator;
                    if (wsa.mSurfaceControl == null) continue;
                    if (!this.mSessions.contains(wsa.mSession)) {
                        Slog.w(TAG, "LEAKED SURFACE (session doesn't exist): " + ws + " surface=" + wsa.mSurfaceControl + " token=" + ws.mToken + " pid=" + ws.mSession.mPid + " uid=" + ws.mSession.mUid);
                        wsa.mSurfaceControl.destroy();
                        wsa.mSurfaceShown = false;
                        wsa.mSurfaceControl = null;
                        ws.mHasSurface = false;
                        this.mForceRemoves.add(ws);
                        leakedSurface = true;
                        continue;
                    }
                    if (ws.mAppToken == null || !ws.mAppToken.clientHidden) continue;
                    Slog.w(TAG, "LEAKED SURFACE (app token hidden): " + ws + " surface=" + wsa.mSurfaceControl + " token=" + ws.mAppToken);
                    wsa.mSurfaceControl.destroy();
                    wsa.mSurfaceShown = false;
                    wsa.mSurfaceControl = null;
                    ws.mHasSurface = false;
                    leakedSurface = true;
                }
            }
            if (!leakedSurface) {
                Slog.w(TAG, "No leaked surfaces; killing applicatons!");
                SparseIntArray pidCandidates = new SparseIntArray();
                for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
                    WindowList windows = this.mDisplayContents.valueAt(displayNdx).getWindowList();
                    int numWindows = windows.size();
                    for (int winNdx = 0; winNdx < numWindows; ++winNdx) {
                        WindowState ws = (WindowState)windows.get(winNdx);
                        if (this.mForceRemoves.contains(ws)) continue;
                        WindowStateAnimator wsa = ws.mWinAnimator;
                        if (wsa.mSurfaceControl == null) continue;
                        pidCandidates.append(wsa.mSession.mPid, wsa.mSession.mPid);
                    }
                    if (pidCandidates.size() <= 0) continue;
                    int[] pids = new int[pidCandidates.size()];
                    for (int i = 0; i < pids.length; ++i) {
                        pids[i] = pidCandidates.keyAt(i);
                    }
                    try {
                        if (!this.mActivityManager.killPids(pids, "Free memory", secure)) continue;
                        killedApps = true;
                        continue;
                    }
                    catch (RemoteException e) {
                        // empty catch block
                    }
                }
            }
            if (leakedSurface || killedApps) {
                Slog.w(TAG, "Looks like we have reclaimed some memory, clearing surface for retry.");
                if (surface != null) {
                    surface.destroy();
                    winAnimator.mSurfaceShown = false;
                    winAnimator.mSurfaceControl = null;
                    winAnimator.mWin.mHasSurface = false;
                    this.scheduleRemoveStartingWindowLocked(winAnimator.mWin.mAppToken);
                }
                try {
                    winAnimator.mWin.mClient.dispatchGetNewSurface();
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(callingIdentity);
        }
        return leakedSurface || killedApps;
    }

    private boolean updateFocusedWindowLocked(int mode, boolean updateInputWindows) {
        WindowState newFocus = this.computeFocusedWindowLocked();
        if (this.mCurrentFocus != newFocus) {
            Trace.traceBegin(32L, "wmUpdateFocus");
            this.mH.removeMessages(2);
            this.mH.sendEmptyMessage(2);
            DisplayContent displayContent = this.getDefaultDisplayContentLocked();
            boolean imWindowChanged = this.moveInputMethodWindowsIfNeededLocked(mode != 1 && mode != 3);
            if (imWindowChanged) {
                displayContent.layoutNeeded = true;
                newFocus = this.computeFocusedWindowLocked();
            }
            WindowState oldFocus = this.mCurrentFocus;
            this.mCurrentFocus = newFocus;
            this.mLosingFocus.remove(newFocus);
            int focusChanged = this.mPolicy.focusChangedLw(oldFocus, newFocus);
            if (imWindowChanged && oldFocus != this.mInputMethodWindow) {
                if (mode == 2) {
                    this.performLayoutLockedInner(displayContent, true, updateInputWindows);
                    focusChanged &= 0xFFFFFFFE;
                } else if (mode == 3) {
                    this.assignLayersLocked(displayContent.getWindowList());
                }
            }
            if ((focusChanged & 1) != 0) {
                displayContent.layoutNeeded = true;
                if (mode == 2) {
                    this.performLayoutLockedInner(displayContent, true, updateInputWindows);
                }
            }
            if (mode != 1) {
                this.mInputMonitor.setInputFocusLw(this.mCurrentFocus, updateInputWindows);
            }
            Trace.traceEnd(32L);
            return true;
        }
        return false;
    }

    private WindowState computeFocusedWindowLocked() {
        int displayCount = this.mDisplayContents.size();
        for (int i = 0; i < displayCount; ++i) {
            DisplayContent displayContent = this.mDisplayContents.valueAt(i);
            WindowState win = this.findFocusedWindowLocked(displayContent);
            if (win == null) continue;
            return win;
        }
        return null;
    }

    private WindowState findFocusedWindowLocked(DisplayContent displayContent) {
        WindowList windows = displayContent.getWindowList();
        for (int i = windows.size() - 1; i >= 0; --i) {
            AppWindowToken wtoken;
            WindowState win = (WindowState)windows.get(i);
            if (!win.canReceiveKeys() || (wtoken = win.mAppToken) != null && (wtoken.removed || wtoken.sendingToBottom)) continue;
            if (wtoken != null && win.mAttrs.type != 3 && this.mFocusedApp != null) {
                ArrayList<Task> tasks = displayContent.getTasks();
                for (int taskNdx = tasks.size() - 1; taskNdx >= 0; --taskNdx) {
                    AppWindowToken token;
                    int tokenNdx;
                    AppTokenList tokens = tasks.get((int)taskNdx).mAppTokens;
                    for (tokenNdx = tokens.size() - 1; tokenNdx >= 0 && wtoken != (token = (AppWindowToken)tokens.get(tokenNdx)); --tokenNdx) {
                        if (this.mFocusedApp != token) continue;
                        return null;
                    }
                    if (tokenNdx >= 0) break;
                }
            }
            return win;
        }
        return null;
    }

    private void startFreezingDisplayLocked(boolean inTransaction, int exitAnim, int enterAnim) {
        if (this.mDisplayFrozen) {
            return;
        }
        if (!this.mDisplayReady || !this.mPolicy.isScreenOn()) {
            return;
        }
        this.mScreenFrozenLock.acquire();
        this.mDisplayFrozen = true;
        this.mDisplayFreezeTime = SystemClock.elapsedRealtime();
        this.mLastFinishedFreezeSource = null;
        this.mInputMonitor.freezeInputDispatchingLw();
        this.mPolicy.setLastInputMethodWindowLw(null, null);
        if (this.mAppTransition.isTransitionSet()) {
            this.mAppTransition.freeze();
        }
        this.mExitAnimId = exitAnim;
        this.mEnterAnimId = enterAnim;
        DisplayContent displayContent = this.getDefaultDisplayContentLocked();
        int displayId = displayContent.getDisplayId();
        ScreenRotationAnimation screenRotationAnimation = this.mAnimator.getScreenRotationAnimationLocked(displayId);
        if (screenRotationAnimation != null) {
            screenRotationAnimation.kill();
        }
        boolean isSecure = false;
        WindowList windows = this.getDefaultWindowListLocked();
        int N = windows.size();
        for (int i = 0; i < N; ++i) {
            WindowState ws = (WindowState)windows.get(i);
            if (!ws.isOnScreen() || (ws.mAttrs.flags & 0x2000) == 0) continue;
            isSecure = true;
            break;
        }
        displayContent.updateDisplayInfo();
        screenRotationAnimation = new ScreenRotationAnimation(this.mContext, displayContent, this.mFxSession, inTransaction, this.mPolicy.isDefaultOrientationForced(), isSecure);
        this.mAnimator.setScreenRotationAnimationLocked(displayId, screenRotationAnimation);
    }

    private void stopFreezingDisplayLocked() {
        if (!this.mDisplayFrozen) {
            return;
        }
        if (this.mWaitingForConfig || this.mAppsFreezingScreen > 0 || this.mWindowsFreezingScreen == 1 || this.mClientFreezingScreen || !this.mOpeningApps.isEmpty()) {
            return;
        }
        this.mDisplayFrozen = false;
        this.mLastDisplayFreezeDuration = (int)(SystemClock.elapsedRealtime() - this.mDisplayFreezeTime);
        StringBuilder sb = new StringBuilder(128);
        sb.append("Screen frozen for ");
        TimeUtils.formatDuration((long)this.mLastDisplayFreezeDuration, sb);
        if (this.mLastFinishedFreezeSource != null) {
            sb.append(" due to ");
            sb.append(this.mLastFinishedFreezeSource);
        }
        Slog.i(TAG, sb.toString());
        this.mH.removeMessages(17);
        this.mH.removeMessages(30);
        boolean updateRotation = false;
        DisplayContent displayContent = this.getDefaultDisplayContentLocked();
        int displayId = displayContent.getDisplayId();
        ScreenRotationAnimation screenRotationAnimation = this.mAnimator.getScreenRotationAnimationLocked(displayId);
        if (screenRotationAnimation != null && screenRotationAnimation.hasScreenshot()) {
            DisplayInfo displayInfo = displayContent.getDisplayInfo();
            boolean isDimming = displayContent.isDimming();
            if (!this.mPolicy.validateRotationAnimationLw(this.mExitAnimId, this.mEnterAnimId, isDimming)) {
                this.mEnterAnimId = 0;
                this.mExitAnimId = 0;
            }
            if (screenRotationAnimation.dismiss(this.mFxSession, 10000L, this.getTransitionAnimationScaleLocked(), displayInfo.logicalWidth, displayInfo.logicalHeight, this.mExitAnimId, this.mEnterAnimId)) {
                this.scheduleAnimationLocked();
            } else {
                screenRotationAnimation.kill();
                this.mAnimator.setScreenRotationAnimationLocked(displayId, null);
                updateRotation = true;
            }
        } else {
            if (screenRotationAnimation != null) {
                screenRotationAnimation.kill();
                this.mAnimator.setScreenRotationAnimationLocked(displayId, null);
            }
            updateRotation = true;
        }
        this.mInputMonitor.thawInputDispatchingLw();
        boolean configChanged = this.updateOrientationFromAppTokensLocked(false);
        this.mH.removeMessages(15);
        this.mH.sendEmptyMessageDelayed(15, 2000L);
        this.mScreenFrozenLock.release();
        if (updateRotation) {
            configChanged |= this.updateRotationUncheckedLocked(false);
        }
        if (configChanged) {
            this.mH.sendEmptyMessage(18);
        }
    }

    static int getPropertyInt(String[] tokens, int index, int defUnits, int defDps, DisplayMetrics dm) {
        String str;
        if (index < tokens.length && (str = tokens[index]) != null && str.length() > 0) {
            try {
                int val = Integer.parseInt(str);
                return val;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (defUnits == 0) {
            return defDps;
        }
        int val = (int)TypedValue.applyDimension(defUnits, defDps, dm);
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createWatermarkInTransaction() {
        if (this.mWatermark != null) {
            return;
        }
        File file = new File("/system/etc/setup.conf");
        FileInputStream in = null;
        FilterInputStream ind = null;
        try {
            String[] toks;
            in = new FileInputStream(file);
            ind = new DataInputStream(in);
            String line = ((DataInputStream)ind).readLine();
            if (line != null && (toks = line.split("%")) != null && toks.length > 0) {
                this.mWatermark = new Watermark(this.getDefaultDisplayContentLocked().getDisplay(), this.mRealDisplayMetrics, this.mFxSession, toks);
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
        }
        finally {
            if (ind != null) {
                try {
                    ind.close();
                }
                catch (IOException e) {}
            } else if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void statusBarVisibilityChanged(int visibility) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.STATUS_BAR") != 0) {
            throw new SecurityException("Caller does not hold permission android.permission.STATUS_BAR");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mLastStatusBarVisibility = visibility;
            visibility = this.mPolicy.adjustSystemUiVisibilityLw(visibility);
            this.updateStatusBarVisibilityLocked(visibility);
        }
    }

    void updateStatusBarVisibilityLocked(int visibility) {
        if (this.mLastDispatchedSystemUiVisibility == visibility) {
            return;
        }
        int globalDiff = (visibility ^ this.mLastDispatchedSystemUiVisibility) & 7 & ~visibility;
        this.mLastDispatchedSystemUiVisibility = visibility;
        this.mInputManager.setSystemUiVisibility(visibility);
        WindowList windows = this.getDefaultWindowListLocked();
        int N = windows.size();
        for (int i = 0; i < N; ++i) {
            WindowState ws = (WindowState)windows.get(i);
            try {
                int curValue = ws.mSystemUiVisibility;
                int diff = (curValue ^ visibility) & globalDiff;
                int newValue = curValue & ~diff | visibility & diff;
                if (newValue != curValue) {
                    ++ws.mSeq;
                    ws.mSystemUiVisibility = newValue;
                }
                if (newValue == curValue && !ws.mAttrs.hasSystemUiListeners) continue;
                ws.mClient.dispatchSystemUiVisibilityChanged(ws.mSeq, visibility, newValue, diff);
                continue;
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reevaluateStatusBarVisibility() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            int visibility = this.mPolicy.adjustSystemUiVisibilityLw(this.mLastStatusBarVisibility);
            this.updateStatusBarVisibilityLocked(visibility);
            this.performLayoutAndPlaceSurfacesLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputConsumerImpl addInputConsumer(Looper looper, InputEventReceiver.Factory inputEventReceiverFactory) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.mInputConsumer = new InputConsumerImpl(this, looper, inputEventReceiverFactory);
            this.mInputMonitor.updateInputWindowsLw(true);
            return this.mInputConsumer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeInputConsumer() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            if (this.mInputConsumer != null) {
                this.mInputConsumer = null;
                this.mInputMonitor.updateInputWindowsLw(true);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveLastInputMethodWindowForTransition() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            DisplayContent displayContent = this.getDefaultDisplayContentLocked();
            if (this.mInputMethodWindow != null) {
                this.mPolicy.setLastInputMethodWindowLw(this.mInputMethodWindow, this.mInputMethodTarget);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInputMethodWindowVisibleHeight() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            return this.mPolicy.getInputMethodWindowVisibleHeightLw();
        }
    }

    @Override
    public boolean hasNavigationBar() {
        return this.mPolicy.hasNavigationBar();
    }

    @Override
    public void lockNow(Bundle options) {
        this.mPolicy.lockNow(options);
    }

    public void showRecentApps() {
        this.mPolicy.showRecentApps();
    }

    @Override
    public boolean isSafeModeEnabled() {
        return this.mSafeMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean clearWindowContentFrameStats(IBinder token) {
        if (!this.checkCallingPermission("android.permission.FRAME_STATS", "clearWindowContentFrameStats()")) {
            throw new SecurityException("Requires FRAME_STATS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            WindowState windowState = this.mWindowMap.get(token);
            if (windowState == null) {
                return false;
            }
            SurfaceControl surfaceControl = windowState.mWinAnimator.mSurfaceControl;
            if (surfaceControl == null) {
                return false;
            }
            return surfaceControl.clearContentFrameStats();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WindowContentFrameStats getWindowContentFrameStats(IBinder token) {
        if (!this.checkCallingPermission("android.permission.FRAME_STATS", "getWindowContentFrameStats()")) {
            throw new SecurityException("Requires FRAME_STATS permission");
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            WindowContentFrameStats stats;
            WindowState windowState = this.mWindowMap.get(token);
            if (windowState == null) {
                return null;
            }
            SurfaceControl surfaceControl = windowState.mWinAnimator.mSurfaceControl;
            if (surfaceControl == null) {
                return null;
            }
            if (this.mTempWindowRenderStats == null) {
                this.mTempWindowRenderStats = new WindowContentFrameStats();
            }
            if (!surfaceControl.getContentFrameStats(stats = this.mTempWindowRenderStats)) {
                return null;
            }
            return stats;
        }
    }

    void dumpPolicyLocked(PrintWriter pw, String[] args, boolean dumpAll) {
        pw.println("WINDOW MANAGER POLICY STATE (dumpsys window policy)");
        this.mPolicy.dump("    ", pw, args);
    }

    void dumpAnimatorLocked(PrintWriter pw, String[] args, boolean dumpAll) {
        pw.println("WINDOW MANAGER ANIMATOR STATE (dumpsys window animator)");
        this.mAnimator.dumpLocked(pw, "    ", dumpAll);
    }

    void dumpTokensLocked(PrintWriter pw, boolean dumpAll) {
        WindowToken token2;
        pw.println("WINDOW MANAGER TOKENS (dumpsys window tokens)");
        if (!this.mTokenMap.isEmpty()) {
            pw.println("  All tokens:");
            for (WindowToken token2 : this.mTokenMap.values()) {
                pw.print("  ");
                pw.print(token2);
                if (dumpAll) {
                    pw.println(':');
                    token2.dump(pw, "    ");
                    continue;
                }
                pw.println();
            }
        }
        if (!this.mWallpaperTokens.isEmpty()) {
            pw.println();
            pw.println("  Wallpaper tokens:");
            for (int i = this.mWallpaperTokens.size() - 1; i >= 0; --i) {
                token2 = this.mWallpaperTokens.get(i);
                pw.print("  Wallpaper #");
                pw.print(i);
                pw.print(' ');
                pw.print(token2);
                if (dumpAll) {
                    pw.println(':');
                    token2.dump(pw, "    ");
                    continue;
                }
                pw.println();
            }
        }
        if (!this.mFinishedStarting.isEmpty()) {
            pw.println();
            pw.println("  Finishing start of application tokens:");
            for (int i = this.mFinishedStarting.size() - 1; i >= 0; --i) {
                token2 = this.mFinishedStarting.get(i);
                pw.print("  Finished Starting #");
                pw.print(i);
                pw.print(' ');
                pw.print(token2);
                if (dumpAll) {
                    pw.println(':');
                    token2.dump(pw, "    ");
                    continue;
                }
                pw.println();
            }
        }
        if (!this.mOpeningApps.isEmpty() || !this.mClosingApps.isEmpty()) {
            pw.println();
            if (this.mOpeningApps.size() > 0) {
                pw.print("  mOpeningApps=");
                pw.println(this.mOpeningApps);
            }
            if (this.mClosingApps.size() > 0) {
                pw.print("  mClosingApps=");
                pw.println(this.mClosingApps);
            }
        }
    }

    void dumpSessionsLocked(PrintWriter pw, boolean dumpAll) {
        pw.println("WINDOW MANAGER SESSIONS (dumpsys window sessions)");
        for (int i = 0; i < this.mSessions.size(); ++i) {
            Session s = this.mSessions.valueAt(i);
            pw.print("  Session ");
            pw.print(s);
            pw.println(':');
            s.dump(pw, "    ");
        }
    }

    void dumpDisplayContentsLocked(PrintWriter pw, boolean dumpAll) {
        pw.println("WINDOW MANAGER DISPLAY CONTENTS (dumpsys window displays)");
        if (this.mDisplayReady) {
            int numDisplays = this.mDisplayContents.size();
            for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
                DisplayContent displayContent = this.mDisplayContents.valueAt(displayNdx);
                displayContent.dump("  ", pw);
            }
        } else {
            pw.println("  NO DISPLAY");
        }
    }

    void dumpWindowsLocked(PrintWriter pw, boolean dumpAll, ArrayList<WindowState> windows) {
        pw.println("WINDOW MANAGER WINDOWS (dumpsys window windows)");
        this.dumpWindowsNoHeaderLocked(pw, dumpAll, windows);
    }

    void dumpWindowsNoHeaderLocked(PrintWriter pw, boolean dumpAll, ArrayList<WindowState> windows) {
        WindowState w;
        int i;
        int displayNdx;
        int numDisplays = this.mDisplayContents.size();
        for (displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
            WindowList windowList = this.mDisplayContents.valueAt(displayNdx).getWindowList();
            for (int winNdx = windowList.size() - 1; winNdx >= 0; --winNdx) {
                WindowState w2 = (WindowState)windowList.get(winNdx);
                if (windows != null && !windows.contains(w2)) continue;
                pw.print("  Window #");
                pw.print(winNdx);
                pw.print(' ');
                pw.print(w2);
                pw.println(":");
                w2.dump(pw, "    ", dumpAll || windows != null);
            }
        }
        if (this.mInputMethodDialogs.size() > 0) {
            pw.println();
            pw.println("  Input method dialogs:");
            for (i = this.mInputMethodDialogs.size() - 1; i >= 0; --i) {
                w = this.mInputMethodDialogs.get(i);
                if (windows != null && !windows.contains(w)) continue;
                pw.print("  IM Dialog #");
                pw.print(i);
                pw.print(": ");
                pw.println(w);
            }
        }
        if (this.mPendingRemove.size() > 0) {
            pw.println();
            pw.println("  Remove pending for:");
            for (i = this.mPendingRemove.size() - 1; i >= 0; --i) {
                w = this.mPendingRemove.get(i);
                if (windows != null && !windows.contains(w)) continue;
                pw.print("  Remove #");
                pw.print(i);
                pw.print(' ');
                pw.print(w);
                if (dumpAll) {
                    pw.println(":");
                    w.dump(pw, "    ", true);
                    continue;
                }
                pw.println();
            }
        }
        if (this.mForceRemoves != null && this.mForceRemoves.size() > 0) {
            pw.println();
            pw.println("  Windows force removing:");
            for (i = this.mForceRemoves.size() - 1; i >= 0; --i) {
                w = this.mForceRemoves.get(i);
                pw.print("  Removing #");
                pw.print(i);
                pw.print(' ');
                pw.print(w);
                if (dumpAll) {
                    pw.println(":");
                    w.dump(pw, "    ", true);
                    continue;
                }
                pw.println();
            }
        }
        if (this.mDestroySurface.size() > 0) {
            pw.println();
            pw.println("  Windows waiting to destroy their surface:");
            for (i = this.mDestroySurface.size() - 1; i >= 0; --i) {
                w = this.mDestroySurface.get(i);
                if (windows != null && !windows.contains(w)) continue;
                pw.print("  Destroy #");
                pw.print(i);
                pw.print(' ');
                pw.print(w);
                if (dumpAll) {
                    pw.println(":");
                    w.dump(pw, "    ", true);
                    continue;
                }
                pw.println();
            }
        }
        if (this.mLosingFocus.size() > 0) {
            pw.println();
            pw.println("  Windows losing focus:");
            for (i = this.mLosingFocus.size() - 1; i >= 0; --i) {
                w = this.mLosingFocus.get(i);
                if (windows != null && !windows.contains(w)) continue;
                pw.print("  Losing #");
                pw.print(i);
                pw.print(' ');
                pw.print(w);
                if (dumpAll) {
                    pw.println(":");
                    w.dump(pw, "    ", true);
                    continue;
                }
                pw.println();
            }
        }
        if (this.mResizingWindows.size() > 0) {
            pw.println();
            pw.println("  Windows waiting to resize:");
            for (i = this.mResizingWindows.size() - 1; i >= 0; --i) {
                w = this.mResizingWindows.get(i);
                if (windows != null && !windows.contains(w)) continue;
                pw.print("  Resizing #");
                pw.print(i);
                pw.print(' ');
                pw.print(w);
                if (dumpAll) {
                    pw.println(":");
                    w.dump(pw, "    ", true);
                    continue;
                }
                pw.println();
            }
        }
        if (this.mWaitingForDrawn.size() > 0) {
            pw.println();
            pw.println("  Clients waiting for these windows to be drawn:");
            for (i = this.mWaitingForDrawn.size() - 1; i >= 0; --i) {
                WindowState win = this.mWaitingForDrawn.get(i);
                pw.print("  Waiting #");
                pw.print(i);
                pw.print(' ');
                pw.print(win);
            }
        }
        pw.println();
        pw.print("  mCurConfiguration=");
        pw.println(this.mCurConfiguration);
        pw.print("  mHasPermanentDpad=");
        pw.println(this.mHasPermanentDpad);
        pw.print("  mCurrentFocus=");
        pw.println(this.mCurrentFocus);
        if (this.mLastFocus != this.mCurrentFocus) {
            pw.print("  mLastFocus=");
            pw.println(this.mLastFocus);
        }
        pw.print("  mFocusedApp=");
        pw.println(this.mFocusedApp);
        if (this.mInputMethodTarget != null) {
            pw.print("  mInputMethodTarget=");
            pw.println(this.mInputMethodTarget);
        }
        pw.print("  mInTouchMode=");
        pw.print(this.mInTouchMode);
        pw.print(" mLayoutSeq=");
        pw.println(this.mLayoutSeq);
        pw.print("  mLastDisplayFreezeDuration=");
        TimeUtils.formatDuration((long)this.mLastDisplayFreezeDuration, pw);
        if (this.mLastFinishedFreezeSource != null) {
            pw.print(" due to ");
            pw.print(this.mLastFinishedFreezeSource);
        }
        pw.println();
        if (dumpAll) {
            pw.print("  mSystemDecorLayer=");
            pw.print(this.mSystemDecorLayer);
            pw.print(" mScreenRect=");
            pw.println(this.mScreenRect.toShortString());
            if (this.mLastStatusBarVisibility != 0) {
                pw.print("  mLastStatusBarVisibility=0x");
                pw.println(Integer.toHexString(this.mLastStatusBarVisibility));
            }
            if (this.mInputMethodWindow != null) {
                pw.print("  mInputMethodWindow=");
                pw.println(this.mInputMethodWindow);
            }
            pw.print("  mWallpaperTarget=");
            pw.println(this.mWallpaperTarget);
            if (this.mLowerWallpaperTarget != null || this.mUpperWallpaperTarget != null) {
                pw.print("  mLowerWallpaperTarget=");
                pw.println(this.mLowerWallpaperTarget);
                pw.print("  mUpperWallpaperTarget=");
                pw.println(this.mUpperWallpaperTarget);
            }
            pw.print("  mLastWallpaperX=");
            pw.print(this.mLastWallpaperX);
            pw.print(" mLastWallpaperY=");
            pw.println(this.mLastWallpaperY);
            if (this.mLastWallpaperDisplayOffsetX != Integer.MIN_VALUE || this.mLastWallpaperDisplayOffsetY != Integer.MIN_VALUE) {
                pw.print("  mLastWallpaperDisplayOffsetX=");
                pw.print(this.mLastWallpaperDisplayOffsetX);
                pw.print(" mLastWallpaperDisplayOffsetY=");
                pw.println(this.mLastWallpaperDisplayOffsetY);
            }
            if (this.mInputMethodAnimLayerAdjustment != 0 || this.mWallpaperAnimLayerAdjustment != 0) {
                pw.print("  mInputMethodAnimLayerAdjustment=");
                pw.print(this.mInputMethodAnimLayerAdjustment);
                pw.print("  mWallpaperAnimLayerAdjustment=");
                pw.println(this.mWallpaperAnimLayerAdjustment);
            }
            pw.print("  mSystemBooted=");
            pw.print(this.mSystemBooted);
            pw.print(" mDisplayEnabled=");
            pw.println(this.mDisplayEnabled);
            if (this.needsLayout()) {
                pw.print("  layoutNeeded on displays=");
                for (displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
                    DisplayContent displayContent = this.mDisplayContents.valueAt(displayNdx);
                    if (!displayContent.layoutNeeded) continue;
                    pw.print(displayContent.getDisplayId());
                }
                pw.println();
            }
            pw.print("  mTransactionSequence=");
            pw.println(this.mTransactionSequence);
            pw.print("  mDisplayFrozen=");
            pw.print(this.mDisplayFrozen);
            pw.print(" windows=");
            pw.print(this.mWindowsFreezingScreen);
            pw.print(" client=");
            pw.print(this.mClientFreezingScreen);
            pw.print(" apps=");
            pw.print(this.mAppsFreezingScreen);
            pw.print(" waitingForConfig=");
            pw.println(this.mWaitingForConfig);
            pw.print("  mRotation=");
            pw.print(this.mRotation);
            pw.print(" mAltOrientation=");
            pw.println(this.mAltOrientation);
            pw.print("  mLastWindowForcedOrientation=");
            pw.print(this.mLastWindowForcedOrientation);
            pw.print(" mForcedAppOrientation=");
            pw.println(this.mForcedAppOrientation);
            pw.print("  mDeferredRotationPauseCount=");
            pw.println(this.mDeferredRotationPauseCount);
            pw.print("  Animation settings: disabled=");
            pw.print(this.mAnimationsDisabled);
            pw.print(" window=");
            pw.print(this.mWindowAnimationScaleSetting);
            pw.print(" transition=");
            pw.print(this.mTransitionAnimationScaleSetting);
            pw.print(" animator=");
            pw.println(this.mAnimatorDurationScaleSetting);
            pw.print("  mTraversalScheduled=");
            pw.println(this.mTraversalScheduled);
            pw.print(" mSkipAppTransitionAnimation=");
            pw.println(this.mSkipAppTransitionAnimation);
            pw.println("  mLayoutToAnim:");
            this.mAppTransition.dump(pw, "    ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean dumpWindows(PrintWriter pw, String name, String[] args, int opti, boolean dumpAll) {
        HashMap<IBinder, WindowState> hashMap;
        WindowList windows = new WindowList();
        if ("visible".equals(name)) {
            hashMap = this.mWindowMap;
            synchronized (hashMap) {
                int numDisplays = this.mDisplayContents.size();
                for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
                    WindowList windowList = this.mDisplayContents.valueAt(displayNdx).getWindowList();
                    for (int winNdx = windowList.size() - 1; winNdx >= 0; --winNdx) {
                        WindowState w = (WindowState)windowList.get(winNdx);
                        if (!w.mWinAnimator.mSurfaceShown) continue;
                        windows.add(w);
                    }
                }
            }
        }
        int objectId = 0;
        try {
            objectId = Integer.parseInt(name, 16);
            name = null;
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        HashMap<IBinder, WindowState> hashMap2 = this.mWindowMap;
        synchronized (hashMap2) {
            int numDisplays = this.mDisplayContents.size();
            for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
                WindowList windowList = this.mDisplayContents.valueAt(displayNdx).getWindowList();
                for (int winNdx = windowList.size() - 1; winNdx >= 0; --winNdx) {
                    WindowState w = (WindowState)windowList.get(winNdx);
                    if (name != null) {
                        if (!w.mAttrs.getTitle().toString().contains(name)) continue;
                        windows.add(w);
                        continue;
                    }
                    if (System.identityHashCode(w) != objectId) continue;
                    windows.add(w);
                }
            }
        }
        if (windows.size() <= 0) {
            return false;
        }
        hashMap = this.mWindowMap;
        synchronized (hashMap) {
            this.dumpWindowsLocked(pw, dumpAll, windows);
        }
        return true;
    }

    void dumpLastANRLocked(PrintWriter pw) {
        pw.println("WINDOW MANAGER LAST ANR (dumpsys window lastanr)");
        if (this.mLastANRState == null) {
            pw.println("  <no ANR has occurred since boot>");
        } else {
            pw.println(this.mLastANRState);
        }
    }

    public void saveANRStateLocked(AppWindowToken appWindowToken, WindowState windowState, String reason) {
        StringWriter sw = new StringWriter();
        FastPrintWriter pw = new FastPrintWriter(sw, false, 1024);
        pw.println("  ANR time: " + DateFormat.getInstance().format(new Date()));
        if (appWindowToken != null) {
            pw.println("  Application at fault: " + appWindowToken.stringName);
        }
        if (windowState != null) {
            pw.println("  Window at fault: " + windowState.mAttrs.getTitle());
        }
        if (reason != null) {
            pw.println("  Reason: " + reason);
        }
        ((PrintWriter)pw).println();
        this.dumpWindowsNoHeaderLocked(pw, true, null);
        ((PrintWriter)pw).println();
        pw.println("Last ANR continued");
        this.dumpDisplayContentsLocked(pw, true);
        ((PrintWriter)pw).close();
        this.mLastANRState = sw.toString();
        this.mH.removeMessages(38);
        this.mH.sendEmptyMessageDelayed(38, 0x6DDD00L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        String opt;
        int opti;
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump WindowManager from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        boolean dumpAll = false;
        for (opti = 0; opti < args.length && (opt = args[opti]) != null && opt.length() > 0 && opt.charAt(0) == '-'; ++opti) {
            if ("-a".equals(opt)) {
                dumpAll = true;
                continue;
            }
            if ("-h".equals(opt)) {
                pw.println("Window manager dump options:");
                pw.println("  [-a] [-h] [cmd] ...");
                pw.println("  cmd may be one of:");
                pw.println("    l[astanr]: last ANR information");
                pw.println("    p[policy]: policy state");
                pw.println("    a[animator]: animator state");
                pw.println("    s[essions]: active sessions");
                pw.println("    surfaces: active surfaces (debugging enabled only)");
                pw.println("    d[isplays]: active display contents");
                pw.println("    t[okens]: token list");
                pw.println("    w[indows]: window list");
                pw.println("  cmd may also be a NAME to dump windows.  NAME may");
                pw.println("    be a partial substring in a window name, a");
                pw.println("    Window hex object identifier, or");
                pw.println("    \"all\" for all windows, or");
                pw.println("    \"visible\" for the visible windows.");
                pw.println("  -a: include all available server state.");
                return;
            }
            pw.println("Unknown argument: " + opt + "; use -h for help");
        }
        if (opti < args.length) {
            String cmd = args[opti];
            ++opti;
            if ("lastanr".equals(cmd) || "l".equals(cmd)) {
                HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
                synchronized (hashMap) {
                    this.dumpLastANRLocked(pw);
                }
                return;
            }
            if ("policy".equals(cmd) || "p".equals(cmd)) {
                HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
                synchronized (hashMap) {
                    this.dumpPolicyLocked(pw, args, true);
                }
                return;
            }
            if ("animator".equals(cmd) || "a".equals(cmd)) {
                HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
                synchronized (hashMap) {
                    this.dumpAnimatorLocked(pw, args, true);
                }
                return;
            }
            if ("sessions".equals(cmd) || "s".equals(cmd)) {
                HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
                synchronized (hashMap) {
                    this.dumpSessionsLocked(pw, true);
                }
                return;
            }
            if ("surfaces".equals(cmd)) {
                HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
                synchronized (hashMap) {
                    WindowStateAnimator.SurfaceTrace.dumpAllSurfaces(pw, null);
                }
                return;
            }
            if ("displays".equals(cmd) || "d".equals(cmd)) {
                HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
                synchronized (hashMap) {
                    this.dumpDisplayContentsLocked(pw, true);
                }
                return;
            }
            if ("tokens".equals(cmd) || "t".equals(cmd)) {
                HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
                synchronized (hashMap) {
                    this.dumpTokensLocked(pw, true);
                }
                return;
            }
            if ("windows".equals(cmd) || "w".equals(cmd)) {
                HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
                synchronized (hashMap) {
                    this.dumpWindowsLocked(pw, true, null);
                }
                return;
            }
            if ("all".equals(cmd) || "a".equals(cmd)) {
                HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
                synchronized (hashMap) {
                    this.dumpWindowsLocked(pw, true, null);
                }
                return;
            }
            if (!this.dumpWindows(pw, cmd, args, opti, dumpAll)) {
                pw.println("Bad window command, or no windows match: " + cmd);
                pw.println("Use -h for help.");
            }
            return;
        }
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpLastANRLocked(pw);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpPolicyLocked(pw, args, dumpAll);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpAnimatorLocked(pw, args, dumpAll);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpSessionsLocked(pw, dumpAll);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            WindowStateAnimator.SurfaceTrace.dumpAllSurfaces(pw, dumpAll ? "-------------------------------------------------------------------------------" : null);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpDisplayContentsLocked(pw, dumpAll);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpTokensLocked(pw, dumpAll);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpWindowsLocked(pw, dumpAll, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void monitor() {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
        }
    }

    void debugLayoutRepeats(String msg, int pendingLayoutChanges) {
        if (this.mLayoutRepeatCount >= 4) {
            Slog.v(TAG, "Layouts looping: " + msg + ", mPendingLayoutChanges = 0x" + Integer.toHexString(pendingLayoutChanges));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DisplayContent newDisplayContentLocked(Display display) {
        DisplayContent displayContent = new DisplayContent(display, this);
        int displayId = display.getDisplayId();
        this.mDisplayContents.put(displayId, displayContent);
        DisplayInfo displayInfo = displayContent.getDisplayInfo();
        Rect rect = new Rect();
        this.mDisplaySettings.getOverscanLocked(displayInfo.name, displayInfo.uniqueId, rect);
        Object object = displayContent.mDisplaySizeLock;
        synchronized (object) {
            displayInfo.overscanLeft = rect.left;
            displayInfo.overscanTop = rect.top;
            displayInfo.overscanRight = rect.right;
            displayInfo.overscanBottom = rect.bottom;
            this.mDisplayManagerInternal.setDisplayInfoOverrideFromWindowManager(displayId, displayInfo);
        }
        this.configureDisplayPolicyLocked(displayContent);
        if (displayId == 0) {
            displayContent.mTapDetector = new StackTapPointerEventListener(this, displayContent);
            this.registerPointerEventListener(displayContent.mTapDetector);
        }
        return displayContent;
    }

    public void createDisplayContentLocked(Display display) {
        if (display == null) {
            throw new IllegalArgumentException("getDisplayContent: display must not be null");
        }
        this.getDisplayContentLocked(display.getDisplayId());
    }

    public DisplayContent getDisplayContentLocked(int displayId) {
        Display display;
        DisplayContent displayContent = this.mDisplayContents.get(displayId);
        if (displayContent == null && (display = this.mDisplayManager.getDisplay(displayId)) != null) {
            displayContent = this.newDisplayContentLocked(display);
        }
        return displayContent;
    }

    public DisplayContent getDefaultDisplayContentLocked() {
        return this.getDisplayContentLocked(0);
    }

    public WindowList getDefaultWindowListLocked() {
        return this.getDefaultDisplayContentLocked().getWindowList();
    }

    public DisplayInfo getDefaultDisplayInfoLocked() {
        return this.getDefaultDisplayContentLocked().getDisplayInfo();
    }

    public WindowList getWindowListLocked(Display display) {
        return this.getWindowListLocked(display.getDisplayId());
    }

    public WindowList getWindowListLocked(int displayId) {
        DisplayContent displayContent = this.getDisplayContentLocked(displayId);
        return displayContent != null ? displayContent.getWindowList() : null;
    }

    public void onDisplayAdded(int displayId) {
        this.mH.sendMessage(this.mH.obtainMessage(27, displayId, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDisplayAdded(int displayId) {
        HashMap<IBinder, WindowState> hashMap = this.mWindowMap;
        synchronized (hashMap) {
            Display display = this.mDisplayManager.getDisplay(displayId);
            if (display != null) {
                this.createDisplayContentLocked(display);
                this.displayReady(displayId);
            }
            this.requestTraversalLocked();
        }
    }

    public void onDisplayRemoved(int displayId) {
        this.mH.sendMessage(this.mH.obtainMessage(28, displayId, 0));
    }

    private void handleDisplayRemovedLocked(int displayId) {
        DisplayContent displayContent = this.getDisplayContentLocked(displayId);
        if (displayContent != null) {
            if (displayContent.isAnimating()) {
                displayContent.mDeferredRemoval = true;
                return;
            }
            this.mDisplayContents.delete(displayId);
            displayContent.close();
            if (displayId == 0) {
                this.unregisterPointerEventListener(displayContent.mTapDetector);
            }
        }
        this.mAnimator.removeDisplayLocked(displayId);
        this.requestTraversalLocked();
    }

    public void onDisplayChanged(int displayId) {
        this.mH.sendMessage(this.mH.obtainMessage(29, displayId, 0));
    }

    private void handleDisplayChangedLocked(int displayId) {
        DisplayContent displayContent = this.getDisplayContentLocked(displayId);
        if (displayContent != null) {
            displayContent.updateDisplayInfo();
        }
        this.requestTraversalLocked();
    }

    @Override
    public Object getWindowManagerLock() {
        return this.mWindowMap;
    }

    private final class LocalService
    extends WindowManagerInternal {
        private LocalService() {
        }

        @Override
        public void requestTraversalFromDisplayManager() {
            WindowManagerService.this.requestTraversal();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setMagnificationSpec(MagnificationSpec spec) {
            HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
            synchronized (hashMap) {
                if (WindowManagerService.this.mAccessibilityController == null) {
                    throw new IllegalStateException("Magnification callbacks not set!");
                }
                WindowManagerService.this.mAccessibilityController.setMagnificationSpecLocked(spec);
            }
            if (Binder.getCallingPid() != Process.myPid()) {
                spec.recycle();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public MagnificationSpec getCompatibleMagnificationSpecForWindow(IBinder windowToken) {
            HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
            synchronized (hashMap) {
                WindowState windowState = WindowManagerService.this.mWindowMap.get(windowToken);
                if (windowState == null) {
                    return null;
                }
                MagnificationSpec spec = null;
                if (WindowManagerService.this.mAccessibilityController != null) {
                    spec = WindowManagerService.this.mAccessibilityController.getMagnificationSpecForWindowLocked(windowState);
                }
                if ((spec == null || spec.isNop()) && windowState.mGlobalScale == 1.0f) {
                    return null;
                }
                spec = spec == null ? MagnificationSpec.obtain() : MagnificationSpec.obtain(spec);
                spec.scale *= windowState.mGlobalScale;
                return spec;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setMagnificationCallbacks(WindowManagerInternal.MagnificationCallbacks callbacks) {
            HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
            synchronized (hashMap) {
                if (WindowManagerService.this.mAccessibilityController == null) {
                    WindowManagerService.this.mAccessibilityController = new AccessibilityController(WindowManagerService.this);
                }
                WindowManagerService.this.mAccessibilityController.setMagnificationCallbacksLocked(callbacks);
                if (!WindowManagerService.this.mAccessibilityController.hasCallbacksLocked()) {
                    WindowManagerService.this.mAccessibilityController = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setWindowsForAccessibilityCallback(WindowManagerInternal.WindowsForAccessibilityCallback callback) {
            HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
            synchronized (hashMap) {
                if (WindowManagerService.this.mAccessibilityController == null) {
                    WindowManagerService.this.mAccessibilityController = new AccessibilityController(WindowManagerService.this);
                }
                WindowManagerService.this.mAccessibilityController.setWindowsForAccessibilityCallback(callback);
                if (!WindowManagerService.this.mAccessibilityController.hasCallbacksLocked()) {
                    WindowManagerService.this.mAccessibilityController = null;
                }
            }
        }

        @Override
        public void setInputFilter(IInputFilter filter) {
            WindowManagerService.this.mInputManager.setInputFilter(filter);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IBinder getFocusedWindowToken() {
            HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
            synchronized (hashMap) {
                WindowState windowState = WindowManagerService.this.getFocusedWindowLocked();
                if (windowState != null) {
                    return windowState.mClient.asBinder();
                }
                return null;
            }
        }

        @Override
        public boolean isKeyguardLocked() {
            return WindowManagerService.this.isKeyguardLocked();
        }

        @Override
        public void showGlobalActions() {
            WindowManagerService.this.showGlobalActions();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getWindowFrame(IBinder token, Rect outBounds) {
            HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
            synchronized (hashMap) {
                WindowState windowState = WindowManagerService.this.mWindowMap.get(token);
                if (windowState != null) {
                    outBounds.set(windowState.mFrame);
                } else {
                    outBounds.setEmpty();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void waitForAllWindowsDrawn(Runnable callback, long timeout) {
            HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
            synchronized (hashMap) {
                WindowManagerService.this.mWaitingForDrawnCallback = callback;
                WindowList windows = WindowManagerService.this.getDefaultWindowListLocked();
                for (int winNdx = windows.size() - 1; winNdx >= 0; --winNdx) {
                    WindowState win = (WindowState)windows.get(winNdx);
                    if (!win.isVisibleLw() || win.mAppToken == null && !WindowManagerService.this.mPolicy.isForceHiding(win.mAttrs)) continue;
                    win.mWinAnimator.mDrawState = 1;
                    win.mLastContentInsets.set(-1, -1, -1, -1);
                    WindowManagerService.this.mWaitingForDrawn.add(win);
                }
                WindowManagerService.this.requestTraversalLocked();
            }
            WindowManagerService.this.mH.removeMessages(24);
            if (WindowManagerService.this.mWaitingForDrawn.isEmpty()) {
                callback.run();
            } else {
                WindowManagerService.this.mH.sendEmptyMessageDelayed(24, timeout);
                WindowManagerService.this.checkDrawnWindowsLocked();
            }
        }

        @Override
        public void addWindowToken(IBinder token, int type) {
            WindowManagerService.this.addWindowToken(token, type);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeWindowToken(IBinder token, boolean removeWindows) {
            HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
            synchronized (hashMap) {
                WindowToken wtoken;
                if (removeWindows && (wtoken = WindowManagerService.this.mTokenMap.remove(token)) != null) {
                    wtoken.removeAllWindows();
                }
                WindowManagerService.this.removeWindowToken(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void registerAppTransitionListener(WindowManagerInternal.AppTransitionListener listener) {
            HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
            synchronized (hashMap) {
                WindowManagerService.this.mAppTransition.registerListenerLocked(listener);
            }
        }
    }

    public static interface OnHardKeyboardStatusChangeListener {
        public void onHardKeyboardStatusChange(boolean var1);
    }

    final class H
    extends Handler {
        public static final int REPORT_FOCUS_CHANGE = 2;
        public static final int REPORT_LOSING_FOCUS = 3;
        public static final int DO_TRAVERSAL = 4;
        public static final int ADD_STARTING = 5;
        public static final int REMOVE_STARTING = 6;
        public static final int FINISHED_STARTING = 7;
        public static final int REPORT_APPLICATION_TOKEN_WINDOWS = 8;
        public static final int REPORT_APPLICATION_TOKEN_DRAWN = 9;
        public static final int WINDOW_FREEZE_TIMEOUT = 11;
        public static final int APP_TRANSITION_TIMEOUT = 13;
        public static final int PERSIST_ANIMATION_SCALE = 14;
        public static final int FORCE_GC = 15;
        public static final int ENABLE_SCREEN = 16;
        public static final int APP_FREEZE_TIMEOUT = 17;
        public static final int SEND_NEW_CONFIGURATION = 18;
        public static final int REPORT_WINDOWS_CHANGE = 19;
        public static final int DRAG_START_TIMEOUT = 20;
        public static final int DRAG_END_TIMEOUT = 21;
        public static final int REPORT_HARD_KEYBOARD_STATUS_CHANGE = 22;
        public static final int BOOT_TIMEOUT = 23;
        public static final int WAITING_FOR_DRAWN_TIMEOUT = 24;
        public static final int SHOW_STRICT_MODE_VIOLATION = 25;
        public static final int DO_ANIMATION_CALLBACK = 26;
        public static final int DO_DISPLAY_ADDED = 27;
        public static final int DO_DISPLAY_REMOVED = 28;
        public static final int DO_DISPLAY_CHANGED = 29;
        public static final int CLIENT_FREEZE_TIMEOUT = 30;
        public static final int TAP_OUTSIDE_STACK = 31;
        public static final int NOTIFY_ACTIVITY_DRAWN = 32;
        public static final int ALL_WINDOWS_DRAWN = 33;
        public static final int NEW_ANIMATOR_SCALE = 34;
        public static final int SHOW_CIRCULAR_DISPLAY_MASK = 35;
        public static final int SHOW_EMULATOR_DISPLAY_OVERLAY = 36;
        public static final int CHECK_IF_BOOT_ANIMATION_FINISHED = 37;
        public static final int RESET_ANR_MESSAGE = 38;
        public static final int WALLPAPER_DRAW_PENDING_TIMEOUT = 39;

        H() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            block57 : switch (msg.what) {
                case 2: {
                    WindowState newFocus;
                    WindowState lastFocus;
                    AccessibilityController accessibilityController = null;
                    HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
                    synchronized (hashMap) {
                        if (WindowManagerService.this.mAccessibilityController != null && WindowManagerService.this.getDefaultDisplayContentLocked().getDisplayId() == 0) {
                            accessibilityController = WindowManagerService.this.mAccessibilityController;
                        }
                        if ((lastFocus = WindowManagerService.this.mLastFocus) == (newFocus = WindowManagerService.this.mCurrentFocus)) {
                            return;
                        }
                        WindowManagerService.this.mLastFocus = newFocus;
                        if (newFocus != null && lastFocus != null && !newFocus.isDisplayedLw()) {
                            WindowManagerService.this.mLosingFocus.add(lastFocus);
                            lastFocus = null;
                        }
                    }
                    if (accessibilityController != null) {
                        accessibilityController.onWindowFocusChangedNotLocked();
                    }
                    if (newFocus != null) {
                        newFocus.reportFocusChangedSerialized(true, WindowManagerService.this.mInTouchMode);
                        WindowManagerService.this.notifyFocusChanged();
                    }
                    if (lastFocus == null) break;
                    lastFocus.reportFocusChangedSerialized(false, WindowManagerService.this.mInTouchMode);
                    break;
                }
                case 3: {
                    ArrayList<WindowState> losers;
                    HashMap<IBinder, WindowState> newFocus = WindowManagerService.this.mWindowMap;
                    synchronized (newFocus) {
                        losers = WindowManagerService.this.mLosingFocus;
                        WindowManagerService.this.mLosingFocus = new ArrayList();
                    }
                    int N = losers.size();
                    for (int i = 0; i < N; ++i) {
                        losers.get(i).reportFocusChangedSerialized(false, WindowManagerService.this.mInTouchMode);
                    }
                    break;
                }
                case 4: {
                    HashMap<IBinder, WindowState> losers = WindowManagerService.this.mWindowMap;
                    synchronized (losers) {
                        WindowManagerService.this.mTraversalScheduled = false;
                        WindowManagerService.this.performLayoutAndPlaceSurfacesLocked();
                        break;
                    }
                }
                case 5: {
                    AppWindowToken wtoken = (AppWindowToken)msg.obj;
                    StartingData sd = wtoken.startingData;
                    if (sd == null) {
                        return;
                    }
                    View view = null;
                    try {
                        view = WindowManagerService.this.mPolicy.addStartingWindow(wtoken.token, sd.pkg, sd.theme, sd.compatInfo, sd.nonLocalizedLabel, sd.labelRes, sd.icon, sd.logo, sd.windowFlags);
                    }
                    catch (Exception e) {
                        Slog.w(WindowManagerService.TAG, "Exception when adding starting window", e);
                    }
                    if (view == null) break;
                    boolean abort = false;
                    HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
                    synchronized (hashMap) {
                        if (wtoken.removed || wtoken.startingData == null) {
                            if (wtoken.startingWindow != null) {
                                wtoken.startingWindow = null;
                                wtoken.startingData = null;
                                abort = true;
                            }
                        } else {
                            wtoken.startingView = view;
                        }
                    }
                    if (!abort) break;
                    try {
                        WindowManagerService.this.mPolicy.removeStartingWindow(wtoken.token, view);
                    }
                    catch (Exception e) {
                        Slog.w(WindowManagerService.TAG, "Exception when removing starting window", e);
                    }
                    break;
                }
                case 6: {
                    AppWindowToken wtoken = (AppWindowToken)msg.obj;
                    IBinder token = null;
                    View view2 = null;
                    HashMap<IBinder, WindowState> abort = WindowManagerService.this.mWindowMap;
                    synchronized (abort) {
                        if (wtoken.startingWindow != null) {
                            view2 = wtoken.startingView;
                            token = wtoken.token;
                            wtoken.startingData = null;
                            wtoken.startingView = null;
                            wtoken.startingWindow = null;
                            wtoken.startingDisplayed = false;
                        }
                    }
                    if (view2 == null) break;
                    try {
                        WindowManagerService.this.mPolicy.removeStartingWindow(token, view2);
                    }
                    catch (Exception e) {
                        Slog.w(WindowManagerService.TAG, "Exception when removing starting window", e);
                    }
                    break;
                }
                case 7: {
                    IBinder token = null;
                    View view = null;
                    while (true) {
                        HashMap<IBinder, WindowState> view2 = WindowManagerService.this.mWindowMap;
                        synchronized (view2) {
                            int N = WindowManagerService.this.mFinishedStarting.size();
                            if (N <= 0) {
                                break block57;
                            }
                            AppWindowToken wtoken = WindowManagerService.this.mFinishedStarting.remove(N - 1);
                            if (wtoken.startingWindow == null) {
                                continue;
                            }
                            view = wtoken.startingView;
                            token = wtoken.token;
                            wtoken.startingData = null;
                            wtoken.startingView = null;
                            wtoken.startingWindow = null;
                            wtoken.startingDisplayed = false;
                        }
                        try {
                            WindowManagerService.this.mPolicy.removeStartingWindow(token, view);
                        }
                        catch (Exception e) {
                            Slog.w(WindowManagerService.TAG, "Exception when removing starting window", e);
                        }
                    }
                }
                case 9: {
                    AppWindowToken wtoken = (AppWindowToken)msg.obj;
                    try {
                        wtoken.appToken.windowsDrawn();
                    }
                    catch (RemoteException ex) {}
                    break;
                }
                case 8: {
                    AppWindowToken wtoken = (AppWindowToken)msg.obj;
                    boolean nowVisible = msg.arg1 != 0;
                    boolean nowGone = msg.arg2 != 0;
                    try {
                        if (nowVisible) {
                            wtoken.appToken.windowsVisible();
                            break;
                        }
                        wtoken.appToken.windowsGone();
                    }
                    catch (RemoteException ex) {}
                    break;
                }
                case 11: {
                    HashMap<IBinder, WindowState> wtoken = WindowManagerService.this.mWindowMap;
                    synchronized (wtoken) {
                        Slog.w(WindowManagerService.TAG, "Window freeze timeout expired.");
                        WindowManagerService.this.mWindowsFreezingScreen = 2;
                        WindowList windows = WindowManagerService.this.getDefaultWindowListLocked();
                        int i = windows.size();
                        while (i > 0) {
                            WindowState w = (WindowState)windows.get(--i);
                            if (!w.mOrientationChanging) continue;
                            w.mOrientationChanging = false;
                            w.mLastFreezeDuration = (int)(SystemClock.elapsedRealtime() - WindowManagerService.this.mDisplayFreezeTime);
                            Slog.w(WindowManagerService.TAG, "Force clearing orientation change: " + w);
                        }
                        WindowManagerService.this.performLayoutAndPlaceSurfacesLocked();
                        break;
                    }
                }
                case 13: {
                    HashMap<IBinder, WindowState> wtoken = WindowManagerService.this.mWindowMap;
                    synchronized (wtoken) {
                        if (WindowManagerService.this.mAppTransition.isTransitionSet() || !WindowManagerService.this.mOpeningApps.isEmpty() || !WindowManagerService.this.mClosingApps.isEmpty()) {
                            WindowManagerService.this.mAppTransition.setTimeout();
                            WindowManagerService.this.performLayoutAndPlaceSurfacesLocked();
                        }
                        break;
                    }
                }
                case 14: {
                    Settings.Global.putFloat(WindowManagerService.this.mContext.getContentResolver(), "window_animation_scale", WindowManagerService.this.mWindowAnimationScaleSetting);
                    Settings.Global.putFloat(WindowManagerService.this.mContext.getContentResolver(), "transition_animation_scale", WindowManagerService.this.mTransitionAnimationScaleSetting);
                    Settings.Global.putFloat(WindowManagerService.this.mContext.getContentResolver(), "animator_duration_scale", WindowManagerService.this.mAnimatorDurationScaleSetting);
                    break;
                }
                case 15: {
                    HashMap<IBinder, WindowState> wtoken = WindowManagerService.this.mWindowMap;
                    synchronized (wtoken) {
                        if (WindowManagerService.this.mAnimator.mAnimating || WindowManagerService.this.mAnimationScheduled) {
                            this.sendEmptyMessageDelayed(15, 2000L);
                            return;
                        }
                        if (WindowManagerService.this.mDisplayFrozen) {
                            return;
                        }
                    }
                    Runtime.getRuntime().gc();
                    break;
                }
                case 16: {
                    WindowManagerService.this.performEnableScreen();
                    break;
                }
                case 17: {
                    HashMap<IBinder, WindowState> wtoken = WindowManagerService.this.mWindowMap;
                    synchronized (wtoken) {
                        Slog.w(WindowManagerService.TAG, "App freeze timeout expired.");
                        WindowManagerService.this.mWindowsFreezingScreen = 2;
                        int numStacks = WindowManagerService.this.mStackIdToStack.size();
                        for (int stackNdx = 0; stackNdx < numStacks; ++stackNdx) {
                            TaskStack stack = WindowManagerService.this.mStackIdToStack.valueAt(stackNdx);
                            ArrayList<Task> tasks = stack.getTasks();
                            for (int taskNdx = tasks.size() - 1; taskNdx >= 0; --taskNdx) {
                                AppTokenList tokens = tasks.get((int)taskNdx).mAppTokens;
                                for (int tokenNdx = tokens.size() - 1; tokenNdx >= 0; --tokenNdx) {
                                    AppWindowToken tok = (AppWindowToken)tokens.get(tokenNdx);
                                    if (!tok.mAppAnimator.freezingScreen) continue;
                                    Slog.w(WindowManagerService.TAG, "Force clearing freeze: " + tok);
                                    WindowManagerService.this.unsetAppFreezingScreenLocked(tok, true, true);
                                }
                            }
                        }
                        break;
                    }
                }
                case 30: {
                    HashMap<IBinder, WindowState> wtoken = WindowManagerService.this.mWindowMap;
                    synchronized (wtoken) {
                        if (WindowManagerService.this.mClientFreezingScreen) {
                            WindowManagerService.this.mClientFreezingScreen = false;
                            WindowManagerService.this.mLastFinishedFreezeSource = "client-timeout";
                            WindowManagerService.this.stopFreezingDisplayLocked();
                        }
                        break;
                    }
                }
                case 18: {
                    this.removeMessages(18);
                    WindowManagerService.this.sendNewConfiguration();
                    break;
                }
                case 19: {
                    if (!WindowManagerService.this.mWindowsChanged) break;
                    HashMap<IBinder, WindowState> wtoken = WindowManagerService.this.mWindowMap;
                    synchronized (wtoken) {
                        WindowManagerService.this.mWindowsChanged = false;
                    }
                    WindowManagerService.this.notifyWindowsChanged();
                    break;
                }
                case 20: {
                    IBinder win = (IBinder)msg.obj;
                    HashMap<IBinder, WindowState> numStacks = WindowManagerService.this.mWindowMap;
                    synchronized (numStacks) {
                        if (WindowManagerService.this.mDragState != null) {
                            WindowManagerService.this.mDragState.unregister();
                            WindowManagerService.this.mInputMonitor.updateInputWindowsLw(true);
                            WindowManagerService.this.mDragState.reset();
                            WindowManagerService.this.mDragState = null;
                        }
                        break;
                    }
                }
                case 21: {
                    IBinder win = (IBinder)msg.obj;
                    HashMap<IBinder, WindowState> numStacks = WindowManagerService.this.mWindowMap;
                    synchronized (numStacks) {
                        if (WindowManagerService.this.mDragState != null) {
                            WindowManagerService.this.mDragState.mDragResult = false;
                            WindowManagerService.this.mDragState.endDragLw();
                        }
                        break;
                    }
                }
                case 22: {
                    WindowManagerService.this.notifyHardKeyboardStatusChange();
                    break;
                }
                case 23: {
                    WindowManagerService.this.performBootTimeout();
                    break;
                }
                case 24: {
                    Runnable callback = null;
                    HashMap<IBinder, WindowState> numStacks = WindowManagerService.this.mWindowMap;
                    synchronized (numStacks) {
                        Slog.w(WindowManagerService.TAG, "Timeout waiting for drawn: undrawn=" + WindowManagerService.this.mWaitingForDrawn);
                        WindowManagerService.this.mWaitingForDrawn.clear();
                        callback = WindowManagerService.this.mWaitingForDrawnCallback;
                        WindowManagerService.this.mWaitingForDrawnCallback = null;
                    }
                    if (callback == null) break;
                    callback.run();
                    break;
                }
                case 25: {
                    WindowManagerService.this.showStrictModeViolation(msg.arg1, msg.arg2);
                    break;
                }
                case 35: {
                    WindowManagerService.this.showCircularMask(msg.arg1 == 1);
                    break;
                }
                case 36: {
                    WindowManagerService.this.showEmulatorDisplayOverlay();
                    break;
                }
                case 26: {
                    try {
                        ((IRemoteCallback)msg.obj).sendResult(null);
                    }
                    catch (RemoteException e) {}
                    break;
                }
                case 27: {
                    WindowManagerService.this.handleDisplayAdded(msg.arg1);
                    break;
                }
                case 28: {
                    HashMap<IBinder, WindowState> e = WindowManagerService.this.mWindowMap;
                    synchronized (e) {
                        WindowManagerService.this.handleDisplayRemovedLocked(msg.arg1);
                        break;
                    }
                }
                case 29: {
                    HashMap<IBinder, WindowState> e = WindowManagerService.this.mWindowMap;
                    synchronized (e) {
                        WindowManagerService.this.handleDisplayChangedLocked(msg.arg1);
                        break;
                    }
                }
                case 31: {
                    int stackId;
                    HashMap<IBinder, WindowState> numStacks = WindowManagerService.this.mWindowMap;
                    synchronized (numStacks) {
                        stackId = ((DisplayContent)msg.obj).stackIdFromPoint(msg.arg1, msg.arg2);
                    }
                    if (stackId < 0) break;
                    try {
                        WindowManagerService.this.mActivityManager.setFocusedStack(stackId);
                    }
                    catch (RemoteException e) {}
                    break;
                }
                case 32: {
                    try {
                        WindowManagerService.this.mActivityManager.notifyActivityDrawn((IBinder)msg.obj);
                    }
                    catch (RemoteException e) {}
                    break;
                }
                case 33: {
                    Runnable callback;
                    HashMap<IBinder, WindowState> e = WindowManagerService.this.mWindowMap;
                    synchronized (e) {
                        callback = WindowManagerService.this.mWaitingForDrawnCallback;
                        WindowManagerService.this.mWaitingForDrawnCallback = null;
                    }
                    if (callback != null) {
                        callback.run();
                    }
                }
                case 34: {
                    float scale = WindowManagerService.this.getCurrentAnimatorScale();
                    ValueAnimator.setDurationScale(scale);
                    Session session = (Session)msg.obj;
                    if (session != null) {
                        try {
                            session.mCallback.onAnimatorScaleChanged(scale);
                        }
                        catch (RemoteException e) {}
                        break;
                    }
                    ArrayList<IWindowSessionCallback> callbacks = new ArrayList<IWindowSessionCallback>();
                    HashMap<IBinder, WindowState> stack = WindowManagerService.this.mWindowMap;
                    synchronized (stack) {
                        for (int i = 0; i < WindowManagerService.this.mSessions.size(); ++i) {
                            callbacks.add(WindowManagerService.this.mSessions.valueAt((int)i).mCallback);
                        }
                    }
                    for (int i = 0; i < callbacks.size(); ++i) {
                        try {
                            ((IWindowSessionCallback)callbacks.get(i)).onAnimatorScaleChanged(scale);
                            continue;
                        }
                        catch (RemoteException e) {
                            // empty catch block
                        }
                    }
                    break;
                }
                case 37: {
                    boolean bootAnimationComplete;
                    HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
                    synchronized (hashMap) {
                        bootAnimationComplete = WindowManagerService.this.checkBootAnimationCompleteLocked();
                    }
                    if (!bootAnimationComplete) break;
                    WindowManagerService.this.performEnableScreen();
                    break;
                }
                case 38: {
                    HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
                    synchronized (hashMap) {
                        WindowManagerService.this.mLastANRState = null;
                        break;
                    }
                }
                case 39: {
                    HashMap<IBinder, WindowState> hashMap = WindowManagerService.this.mWindowMap;
                    synchronized (hashMap) {
                        if (WindowManagerService.this.mWallpaperDrawState == 1) {
                            WindowManagerService.this.mWallpaperDrawState = 2;
                            WindowManagerService.this.performLayoutAndPlaceSurfacesLocked();
                        }
                        break;
                    }
                }
            }
        }
    }

    public static interface WindowChangeListener {
        public void windowsChanged();

        public void focusChanged();
    }

    final class DragInputEventReceiver
    extends InputEventReceiver {
        private boolean mStylusButtonDownAtStart;
        private boolean mIsStartEvent;

        public DragInputEventReceiver(InputChannel inputChannel, Looper looper) {
            super(inputChannel, looper);
            this.mIsStartEvent = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onInputEvent(InputEvent event) {
            block27: {
                boolean handled = false;
                try {
                    HashMap<IBinder, WindowState> hashMap;
                    boolean isStylusButtonDown;
                    if (!(event instanceof MotionEvent) || (event.getSource() & 2) == 0 || WindowManagerService.this.mDragState == null) break block27;
                    MotionEvent motionEvent = (MotionEvent)event;
                    boolean endDrag = false;
                    float newX = motionEvent.getRawX();
                    float newY = motionEvent.getRawY();
                    boolean bl = isStylusButtonDown = (motionEvent.getButtonState() & 0x20) != 0;
                    if (this.mIsStartEvent) {
                        if (isStylusButtonDown) {
                            this.mStylusButtonDownAtStart = true;
                        }
                        this.mIsStartEvent = false;
                    }
                    switch (motionEvent.getAction()) {
                        case 0: {
                            break;
                        }
                        case 2: {
                            if (this.mStylusButtonDownAtStart && !isStylusButtonDown) {
                                hashMap = WindowManagerService.this.mWindowMap;
                                synchronized (hashMap) {
                                    endDrag = WindowManagerService.this.mDragState.notifyDropLw(newX, newY);
                                    break;
                                }
                            }
                            hashMap = WindowManagerService.this.mWindowMap;
                            synchronized (hashMap) {
                                WindowManagerService.this.mDragState.notifyMoveLw(newX, newY);
                                break;
                            }
                        }
                        case 1: {
                            hashMap = WindowManagerService.this.mWindowMap;
                            synchronized (hashMap) {
                                endDrag = WindowManagerService.this.mDragState.notifyDropLw(newX, newY);
                                break;
                            }
                        }
                        case 3: {
                            endDrag = true;
                        }
                    }
                    if (endDrag) {
                        hashMap = WindowManagerService.this.mWindowMap;
                        synchronized (hashMap) {
                            WindowManagerService.this.mDragState.endDragLw();
                        }
                        this.mStylusButtonDownAtStart = false;
                        this.mIsStartEvent = true;
                    }
                    handled = true;
                }
                catch (Exception e) {
                    Slog.e(WindowManagerService.TAG, "Exception caught by drag handleMotion", e);
                }
                finally {
                    this.finishInputEvent(event, handled);
                }
            }
        }
    }

    class LayoutFields {
        static final int SET_UPDATE_ROTATION = 1;
        static final int SET_WALLPAPER_MAY_CHANGE = 2;
        static final int SET_FORCE_HIDING_CHANGED = 4;
        static final int SET_ORIENTATION_CHANGE_COMPLETE = 8;
        static final int SET_TURN_ON_SCREEN = 16;
        static final int SET_WALLPAPER_ACTION_PENDING = 32;
        boolean mWallpaperForceHidingChanged = false;
        boolean mWallpaperMayChange = false;
        boolean mOrientationChangeComplete = true;
        Object mLastWindowFreezeSource = null;
        private Session mHoldScreen = null;
        private boolean mObscured = false;
        private boolean mSyswin = false;
        private float mScreenBrightness = -1.0f;
        private float mButtonBrightness = -1.0f;
        private long mUserActivityTimeout = -1L;
        private boolean mUpdateRotation = false;
        boolean mWallpaperActionPending = false;
        boolean mDisplayHasContent = false;
        boolean mObscureApplicationContentOnSecondaryDisplays = false;
        float mPreferredRefreshRate = 0.0f;
        int mPreferredModeId = 0;

        LayoutFields() {
        }
    }

    private final class SettingsObserver
    extends ContentObserver {
        private final Uri mShowImeWithHardKeyboardUri;
        private final Uri mDisplayInversionEnabledUri;

        public SettingsObserver() {
            super(new Handler());
            this.mShowImeWithHardKeyboardUri = Settings.Secure.getUriFor("show_ime_with_hard_keyboard");
            this.mDisplayInversionEnabledUri = Settings.Secure.getUriFor("accessibility_display_inversion_enabled");
            ContentResolver resolver = WindowManagerService.this.mContext.getContentResolver();
            resolver.registerContentObserver(this.mShowImeWithHardKeyboardUri, false, this, -1);
            resolver.registerContentObserver(this.mDisplayInversionEnabledUri, false, this, -1);
        }

        @Override
        public void onChange(boolean selfChange, Uri uri) {
            if (this.mShowImeWithHardKeyboardUri.equals(uri)) {
                WindowManagerService.this.updateShowImeWithHardKeyboard();
            } else if (this.mDisplayInversionEnabledUri.equals(uri)) {
                WindowManagerService.this.updateCircularDisplayMaskIfNeeded();
            }
        }
    }

    class RotationWatcher {
        IRotationWatcher watcher;
        IBinder.DeathRecipient deathRecipient;

        RotationWatcher(IRotationWatcher w, IBinder.DeathRecipient d) {
            this.watcher = w;
            this.deathRecipient = d;
        }
    }
}

