/*
 * Decompiled with CFR 0.152.
 */
package dalvik.system;

import java.io.FileDescriptor;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public final class VMDebug {
    public static final int TRACE_COUNT_ALLOCS = 1;
    private static final int KIND_ALLOCATED_OBJECTS = 1;
    private static final int KIND_ALLOCATED_BYTES = 2;
    private static final int KIND_FREED_OBJECTS = 4;
    private static final int KIND_FREED_BYTES = 8;
    private static final int KIND_GC_INVOCATIONS = 16;
    private static final int KIND_CLASS_INIT_COUNT = 32;
    private static final int KIND_CLASS_INIT_TIME = 64;
    private static final int KIND_EXT_ALLOCATED_OBJECTS = 4096;
    private static final int KIND_EXT_ALLOCATED_BYTES = 8192;
    private static final int KIND_EXT_FREED_OBJECTS = 16384;
    private static final int KIND_EXT_FREED_BYTES = 32768;
    public static final int KIND_GLOBAL_ALLOCATED_OBJECTS = 1;
    public static final int KIND_GLOBAL_ALLOCATED_BYTES = 2;
    public static final int KIND_GLOBAL_FREED_OBJECTS = 4;
    public static final int KIND_GLOBAL_FREED_BYTES = 8;
    public static final int KIND_GLOBAL_GC_INVOCATIONS = 16;
    public static final int KIND_GLOBAL_CLASS_INIT_COUNT = 32;
    public static final int KIND_GLOBAL_CLASS_INIT_TIME = 64;
    public static final int KIND_GLOBAL_EXT_ALLOCATED_OBJECTS = 4096;
    public static final int KIND_GLOBAL_EXT_ALLOCATED_BYTES = 8192;
    public static final int KIND_GLOBAL_EXT_FREED_OBJECTS = 16384;
    public static final int KIND_GLOBAL_EXT_FREED_BYTES = 32768;
    public static final int KIND_THREAD_ALLOCATED_OBJECTS = 65536;
    public static final int KIND_THREAD_ALLOCATED_BYTES = 131072;
    public static final int KIND_THREAD_FREED_OBJECTS = 262144;
    public static final int KIND_THREAD_FREED_BYTES = 524288;
    public static final int KIND_THREAD_GC_INVOCATIONS = 0x100000;
    public static final int KIND_THREAD_CLASS_INIT_COUNT = 0x200000;
    public static final int KIND_THREAD_CLASS_INIT_TIME = 0x400000;
    public static final int KIND_THREAD_EXT_ALLOCATED_OBJECTS = 0x10000000;
    public static final int KIND_THREAD_EXT_ALLOCATED_BYTES = 0x20000000;
    public static final int KIND_THREAD_EXT_FREED_OBJECTS = 0x40000000;
    public static final int KIND_THREAD_EXT_FREED_BYTES = Integer.MIN_VALUE;
    public static final int KIND_ALL_COUNTS = -1;
    private static final HashMap<String, Integer> runtimeStatsMap = new HashMap();

    private VMDebug() {
    }

    public static native long lastDebuggerActivity();

    public static native boolean isDebuggingEnabled();

    public static native boolean isDebuggerConnected();

    public static native String[] getVmFeatureList();

    @Deprecated
    public static void startMethodTracing() {
        throw new UnsupportedOperationException();
    }

    public static void startMethodTracing(String traceFileName, int bufferSize, int flags, boolean samplingEnabled, int intervalUs) {
        VMDebug.startMethodTracingFilename(traceFileName, VMDebug.checkBufferSize(bufferSize), flags, samplingEnabled, intervalUs);
    }

    public static void startMethodTracing(String traceFileName, FileDescriptor fd, int bufferSize, int flags, boolean samplingEnabled, int intervalUs) {
        if (fd == null) {
            throw new NullPointerException("fd == null");
        }
        VMDebug.startMethodTracingFd(traceFileName, fd, VMDebug.checkBufferSize(bufferSize), flags, samplingEnabled, intervalUs);
    }

    public static void startMethodTracingDdms(int bufferSize, int flags, boolean samplingEnabled, int intervalUs) {
        VMDebug.startMethodTracingDdmsImpl(VMDebug.checkBufferSize(bufferSize), flags, samplingEnabled, intervalUs);
    }

    private static int checkBufferSize(int bufferSize) {
        if (bufferSize == 0) {
            bufferSize = 0x800000;
        }
        if (bufferSize < 1024) {
            throw new IllegalArgumentException("buffer size < 1024: " + bufferSize);
        }
        return bufferSize;
    }

    private static native void startMethodTracingDdmsImpl(int var0, int var1, boolean var2, int var3);

    private static native void startMethodTracingFd(String var0, FileDescriptor var1, int var2, int var3, boolean var4, int var5);

    private static native void startMethodTracingFilename(String var0, int var1, int var2, boolean var3, int var4);

    public static native int getMethodTracingMode();

    public static native void stopMethodTracing();

    public static native void startEmulatorTracing();

    public static native void stopEmulatorTracing();

    public static native long threadCpuTimeNanos();

    public static native void startAllocCounting();

    public static native void stopAllocCounting();

    public static native int getAllocCount(int var0);

    public static native void resetAllocCount(int var0);

    @Deprecated
    public static int setAllocationLimit(int limit) {
        return -1;
    }

    @Deprecated
    public static int setGlobalAllocationLimit(int limit) {
        return -1;
    }

    public static native void startInstructionCounting();

    public static native void stopInstructionCounting();

    public static native void getInstructionCount(int[] var0);

    public static native void resetInstructionCount();

    public static native void printLoadedClasses(int var0);

    public static native int getLoadedClassCount();

    public static void dumpHprofData(String filename) throws IOException {
        if (filename == null) {
            throw new NullPointerException("filename == null");
        }
        VMDebug.dumpHprofData(filename, null);
    }

    public static native void dumpHprofDataDdms();

    public static native void dumpHprofData(String var0, FileDescriptor var1) throws IOException;

    public static native boolean cacheRegisterMap(String var0);

    public static native void dumpReferenceTables();

    public static native void crash();

    public static native void infopoint(int var0);

    private static void startGC() {
    }

    private static void startClassPrep() {
    }

    public static native long countInstancesOfClass(Class var0, boolean var1);

    public static native void getHeapSpaceStats(long[] var0);

    public static String getRuntimeStat(String statName) {
        if (statName == null) {
            throw new NullPointerException("statName == null");
        }
        Integer statId = runtimeStatsMap.get(statName);
        if (statId != null) {
            return VMDebug.getRuntimeStatInternal(statId);
        }
        return null;
    }

    public static Map<String, String> getRuntimeStats() {
        HashMap<String, String> map = new HashMap<String, String>();
        String[] values = VMDebug.getRuntimeStatsInternal();
        for (String name : runtimeStatsMap.keySet()) {
            int id2 = runtimeStatsMap.get(name);
            String value = values[id2];
            map.put(name, value);
        }
        return map;
    }

    private static native String getRuntimeStatInternal(int var0);

    private static native String[] getRuntimeStatsInternal();

    static {
        runtimeStatsMap.put("art.gc.gc-count", 0);
        runtimeStatsMap.put("art.gc.gc-time", 1);
        runtimeStatsMap.put("art.gc.bytes-allocated", 2);
        runtimeStatsMap.put("art.gc.bytes-freed", 3);
        runtimeStatsMap.put("art.gc.blocking-gc-count", 4);
        runtimeStatsMap.put("art.gc.blocking-gc-time", 5);
        runtimeStatsMap.put("art.gc.gc-count-rate-histogram", 6);
        runtimeStatsMap.put("art.gc.blocking-gc-count-rate-histogram", 7);
    }
}

