/*
 * Decompiled with CFR 0.152.
 */
package dalvik.system;

import java.lang.ref.FinalizerReference;
import java.util.HashMap;
import java.util.Map;

public final class VMRuntime {
    private static final VMRuntime THE_ONE = new VMRuntime();
    private static final Map<String, String> ABI_TO_INSTRUCTION_SET_MAP = new HashMap<String, String>();
    private int targetSdkVersion;

    private VMRuntime() {
    }

    public static VMRuntime getRuntime() {
        return THE_ONE;
    }

    public native String[] properties();

    public native String bootClassPath();

    public native String classPath();

    public native String vmVersion();

    public native String vmLibrary();

    public native String vmInstructionSet();

    public native boolean is64Bit();

    public native boolean isCheckJniEnabled();

    public native float getTargetHeapUtilization();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float setTargetHeapUtilization(float newTarget) {
        if (newTarget <= 0.0f || newTarget >= 1.0f) {
            throw new IllegalArgumentException(newTarget + " out of range (0,1)");
        }
        VMRuntime vMRuntime = this;
        synchronized (vMRuntime) {
            float oldTarget = this.getTargetHeapUtilization();
            this.nativeSetTargetHeapUtilization(newTarget);
            return oldTarget;
        }
    }

    public synchronized void setTargetSdkVersion(int targetSdkVersion) {
        this.targetSdkVersion = targetSdkVersion;
        this.setTargetSdkVersionNative(this.targetSdkVersion);
    }

    public synchronized int getTargetSdkVersion() {
        return this.targetSdkVersion;
    }

    private native void setTargetSdkVersionNative(int var1);

    @Deprecated
    public long getMinimumHeapSize() {
        return 0L;
    }

    @Deprecated
    public long setMinimumHeapSize(long size) {
        return 0L;
    }

    @Deprecated
    public void gcSoftReferences() {
    }

    @Deprecated
    public void runFinalizationSync() {
        System.runFinalization();
    }

    private native void nativeSetTargetHeapUtilization(float var1);

    @Deprecated
    public boolean trackExternalAllocation(long size) {
        return true;
    }

    @Deprecated
    public void trackExternalFree(long size) {
    }

    @Deprecated
    public long getExternalBytesAllocated() {
        return 0L;
    }

    public native void startJitCompilation();

    public native void disableJitCompilation();

    public native Object newNonMovableArray(Class<?> var1, int var2);

    public native Object newUnpaddedArray(Class<?> var1, int var2);

    public native long addressOf(Object var1);

    public native void clearGrowthLimit();

    public native void clampGrowthLimit();

    public native boolean isDebuggerActive();

    public native void registerNativeAllocation(int var1);

    public native void registerNativeFree(int var1);

    public static void runFinalization(long timeout) {
        try {
            FinalizerReference.finalizeAllEnqueued((long)timeout);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public native void requestConcurrentGC();

    public native void concurrentGC();

    public native void requestHeapTrim();

    public native void trimHeap();

    public native void startHeapTaskProcessor();

    public native void stopHeapTaskProcessor();

    public native void runHeapTasks();

    public native void updateProcessState(int var1);

    public native void preloadDexCaches();

    public static native void registerAppInfo(String var0, String var1, String var2);

    public static String getInstructionSet(String abi) {
        String instructionSet = ABI_TO_INSTRUCTION_SET_MAP.get(abi);
        if (instructionSet == null) {
            throw new IllegalArgumentException("Unsupported ABI: " + abi);
        }
        return instructionSet;
    }

    public static boolean is64BitInstructionSet(String instructionSet) {
        return "arm64".equals(instructionSet) || "x86_64".equals(instructionSet) || "mips64".equals(instructionSet);
    }

    public static boolean is64BitAbi(String abi) {
        return VMRuntime.is64BitInstructionSet(VMRuntime.getInstructionSet(abi));
    }

    public static native boolean isBootClassPathOnDisk(String var0);

    public static native String getCurrentInstructionSet();

    static {
        ABI_TO_INSTRUCTION_SET_MAP.put("armeabi", "arm");
        ABI_TO_INSTRUCTION_SET_MAP.put("armeabi-v7a", "arm");
        ABI_TO_INSTRUCTION_SET_MAP.put("mips", "mips");
        ABI_TO_INSTRUCTION_SET_MAP.put("mips64", "mips64");
        ABI_TO_INSTRUCTION_SET_MAP.put("x86", "x86");
        ABI_TO_INSTRUCTION_SET_MAP.put("x86_64", "x86_64");
        ABI_TO_INSTRUCTION_SET_MAP.put("arm64-v8a", "arm64");
    }
}

