/*
 * Decompiled with CFR 0.152.
 */
package dalvik.system.profiler;

import dalvik.system.profiler.HprofData;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;

public final class AsciiHprofWriter {
    private final HprofData data;
    private final PrintWriter out;
    private static final Comparator<HprofData.Sample> SAMPLE_COMPARATOR = new Comparator<HprofData.Sample>(){

        @Override
        public int compare(HprofData.Sample s1, HprofData.Sample s2) {
            return s2.count - s1.count;
        }
    };

    public static void write(HprofData data, OutputStream outputStream) throws IOException {
        new AsciiHprofWriter(data, outputStream).write();
    }

    private AsciiHprofWriter(HprofData data, OutputStream outputStream) {
        this.data = data;
        this.out = new PrintWriter(outputStream);
    }

    private void write() throws IOException {
        for (HprofData.ThreadEvent e : this.data.getThreadHistory()) {
            this.out.println(e);
        }
        ArrayList<HprofData.Sample> samples = new ArrayList<HprofData.Sample>(this.data.getSamples());
        Collections.sort(samples, SAMPLE_COMPARATOR);
        int total = 0;
        for (HprofData.Sample sample : samples) {
            HprofData.StackTrace stackTrace = sample.stackTrace;
            int count = sample.count;
            total += count;
            this.out.printf("TRACE %d: (thread=%d)\n", stackTrace.stackTraceId, stackTrace.threadId);
            for (StackTraceElement e : stackTrace.stackFrames) {
                this.out.printf("\t%s\n", e);
            }
        }
        Date now = new Date(this.data.getStartMillis());
        this.out.printf("CPU SAMPLES BEGIN (total = %d) %ta %tb %td %tT %tY\n", total, now, now, now, now, now);
        this.out.printf("rank   self  accum   count trace method\n", new Object[0]);
        int rank = 0;
        double accum = 0.0;
        for (HprofData.Sample sample : samples) {
            HprofData.StackTrace stackTrace = sample.stackTrace;
            int count = sample.count;
            double self = (double)count / (double)total;
            this.out.printf("% 4d% 6.2f%%% 6.2f%% % 7d % 5d %s.%s\n", ++rank, self * 100.0, (accum += self) * 100.0, count, stackTrace.stackTraceId, stackTrace.stackFrames[0].getClassName(), stackTrace.stackFrames[0].getMethodName());
        }
        this.out.printf("CPU SAMPLES END\n", new Object[0]);
        this.out.flush();
    }
}

