/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;

public class CharArrayReader
extends Reader {
    protected char[] buf;
    protected int pos;
    protected int markedPos = -1;
    protected int count;

    public CharArrayReader(char[] buf) {
        this.buf = buf;
        this.count = buf.length;
    }

    public CharArrayReader(char[] buf, int offset, int length) {
        if (offset < 0 || offset > buf.length || length < 0 || offset + length < 0) {
            throw new IllegalArgumentException();
        }
        this.buf = buf;
        this.pos = offset;
        this.markedPos = offset;
        int bufferLength = buf.length;
        this.count = offset + length < bufferLength ? length : bufferLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isOpen()) {
                this.buf = null;
            }
        }
    }

    private boolean isOpen() {
        return this.buf != null;
    }

    private boolean isClosed() {
        return this.buf == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mark(int readLimit) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotClosed();
            this.markedPos = this.pos;
        }
    }

    private void checkNotClosed() throws IOException {
        if (this.isClosed()) {
            throw new IOException("CharArrayReader is closed");
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotClosed();
            if (this.pos == this.count) {
                return -1;
            }
            return this.buf[this.pos++];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] buffer, int offset, int count) throws IOException {
        Arrays.checkOffsetAndCount(buffer.length, offset, count);
        Object object = this.lock;
        synchronized (object) {
            this.checkNotClosed();
            if (this.pos < this.count) {
                int bytesRead = this.pos + count > this.count ? this.count - this.pos : count;
                System.arraycopy((char[])this.buf, (int)this.pos, (char[])buffer, (int)offset, (int)bytesRead);
                this.pos += bytesRead;
                return bytesRead;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotClosed();
            return this.pos != this.count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotClosed();
            this.pos = this.markedPos != -1 ? this.markedPos : 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long charCount) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkNotClosed();
            if (charCount <= 0L) {
                return 0L;
            }
            long skipped = 0L;
            if (charCount < (long)(this.count - this.pos)) {
                this.pos += (int)charCount;
                skipped = charCount;
            } else {
                skipped = this.count - this.pos;
                this.pos = this.count;
            }
            return skipped;
        }
    }
}

