/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import android.system.ErrnoException;
import android.system.OsConstants;
import dalvik.system.CloseGuard;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.NioUtils;
import java.nio.channels.FileChannel;
import libcore.io.IoBridge;
import libcore.io.Libcore;
import libcore.io.Streams;

public class FileInputStream
extends InputStream {
    private FileDescriptor fd;
    private final boolean shouldClose;
    private FileChannel channel;
    private final CloseGuard guard = CloseGuard.get();

    public FileInputStream(File file) throws FileNotFoundException {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        this.fd = IoBridge.open(file.getPath(), OsConstants.O_RDONLY);
        this.shouldClose = true;
        this.guard.open("close");
    }

    public FileInputStream(FileDescriptor fd) {
        if (fd == null) {
            throw new NullPointerException("fd == null");
        }
        this.fd = fd;
        this.shouldClose = false;
    }

    public FileInputStream(String path) throws FileNotFoundException {
        this(new File(path));
    }

    @Override
    public int available() throws IOException {
        return IoBridge.available(this.fd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.guard.close();
        FileInputStream fileInputStream = this;
        synchronized (fileInputStream) {
            if (this.channel != null) {
                this.channel.close();
            }
            if (this.shouldClose) {
                IoBridge.closeAndSignalBlockedThreads(this.fd);
            } else {
                this.fd = new FileDescriptor();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws IOException {
        try {
            if (this.guard != null) {
                this.guard.warnIfOpen();
            }
            this.close();
        }
        finally {
            try {
                super.finalize();
            }
            catch (Throwable t) {
                throw new AssertionError((Object)t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileChannel getChannel() {
        FileInputStream fileInputStream = this;
        synchronized (fileInputStream) {
            if (this.channel == null) {
                this.channel = NioUtils.newFileChannel(this, this.fd, OsConstants.O_RDONLY);
            }
            return this.channel;
        }
    }

    public final FileDescriptor getFD() throws IOException {
        return this.fd;
    }

    @Override
    public int read() throws IOException {
        return Streams.readSingleByte(this);
    }

    @Override
    public int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
        return IoBridge.read(this.fd, buffer, byteOffset, byteCount);
    }

    @Override
    public long skip(long byteCount) throws IOException {
        if (byteCount < 0L) {
            throw new IOException("byteCount < 0: " + byteCount);
        }
        try {
            Libcore.os.lseek(this.fd, byteCount, OsConstants.SEEK_CUR);
            return byteCount;
        }
        catch (ErrnoException errnoException) {
            if (errnoException.errno == OsConstants.ESPIPE) {
                return super.skip(byteCount);
            }
            throw errnoException.rethrowAsIOException();
        }
    }
}

