/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.InetAddress;
import libcore.util.BasicLruCache;

class AddressCache {
    private static final int MAX_ENTRIES = 16;
    private static final long TTL_NANOS = 2000000000L;
    private final BasicLruCache<AddressCacheKey, AddressCacheEntry> cache = new BasicLruCache(16);

    AddressCache() {
    }

    public void clear() {
        this.cache.evictAll();
    }

    public Object get(String hostname, int netId) {
        AddressCacheEntry entry = this.cache.get(new AddressCacheKey(hostname, netId));
        if (entry != null && entry.expiryNanos >= System.nanoTime()) {
            return entry.value;
        }
        return null;
    }

    public void put(String hostname, int netId, InetAddress[] addresses) {
        this.cache.put(new AddressCacheKey(hostname, netId), new AddressCacheEntry(addresses));
    }

    public void putUnknownHost(String hostname, int netId, String detailMessage) {
        this.cache.put(new AddressCacheKey(hostname, netId), new AddressCacheEntry(detailMessage));
    }

    static class AddressCacheEntry {
        final Object value;
        final long expiryNanos;

        AddressCacheEntry(Object value) {
            this.value = value;
            this.expiryNanos = System.nanoTime() + 2000000000L;
        }
    }

    static class AddressCacheKey {
        private final String mHostname;
        private final int mNetId;

        AddressCacheKey(String hostname, int netId) {
            this.mHostname = hostname;
            this.mNetId = netId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AddressCacheKey)) {
                return false;
            }
            AddressCacheKey lhs = (AddressCacheKey)o;
            return this.mHostname.equals(lhs.mHostname) && this.mNetId == lhs.mNetId;
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + this.mNetId;
            result = 31 * result + this.mHostname.hashCode();
            return result;
        }
    }
}

