/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import android.system.ErrnoException;
import android.system.OsConstants;
import dalvik.system.CloseGuard;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketTimeoutException;
import java.net.Socks4Message;
import java.net.UnknownHostException;
import java.nio.ByteOrder;
import java.util.Arrays;
import libcore.io.IoBridge;
import libcore.io.Libcore;
import libcore.io.Memory;
import libcore.io.Streams;

public class PlainSocketImpl
extends SocketImpl {
    private static InetAddress lastConnectedAddress;
    private static int lastConnectedPort;
    private boolean streaming = true;
    private boolean shutdownInput;
    private Proxy proxy;
    private final CloseGuard guard = CloseGuard.get();

    public PlainSocketImpl(FileDescriptor fd) {
        this.fd = fd;
        if (fd.valid()) {
            this.guard.open("close");
        }
    }

    public PlainSocketImpl(Proxy proxy) {
        this(new FileDescriptor());
        this.proxy = proxy;
    }

    public PlainSocketImpl() {
        this(new FileDescriptor());
    }

    public PlainSocketImpl(FileDescriptor fd, int localport, InetAddress addr, int port) {
        this.fd = fd;
        this.localport = localport;
        this.address = addr;
        this.port = port;
        if (fd.valid()) {
            this.guard.open("close");
        }
    }

    @Override
    protected void accept(SocketImpl newImpl) throws IOException {
        if (this.usingSocks()) {
            ((PlainSocketImpl)newImpl).socksBind();
            ((PlainSocketImpl)newImpl).socksAccept();
            return;
        }
        try {
            InetSocketAddress peerAddress = new InetSocketAddress();
            FileDescriptor clientFd = Libcore.os.accept(this.fd, peerAddress);
            newImpl.fd.setInt$(clientFd.getInt$());
            newImpl.address = peerAddress.getAddress();
            newImpl.port = peerAddress.getPort();
        }
        catch (ErrnoException errnoException) {
            if (errnoException.errno == OsConstants.EAGAIN) {
                throw new SocketTimeoutException(errnoException);
            }
            throw errnoException.rethrowAsSocketException();
        }
        newImpl.setOption(4102, 0);
        newImpl.localport = IoBridge.getSocketLocalPort(newImpl.fd);
    }

    private boolean usingSocks() {
        return this.proxy != null && this.proxy.type() == Proxy.Type.SOCKS;
    }

    private void checkNotClosed() throws IOException {
        if (!this.fd.valid()) {
            throw new SocketException("Socket is closed");
        }
    }

    @Override
    protected synchronized int available() throws IOException {
        this.checkNotClosed();
        if (this.shutdownInput) {
            return 0;
        }
        return IoBridge.available(this.fd);
    }

    @Override
    protected void bind(InetAddress address, int port) throws IOException {
        IoBridge.bind(this.fd, address, port);
        this.localport = port != 0 ? port : IoBridge.getSocketLocalPort(this.fd);
    }

    @Override
    public void onBind(InetAddress localAddress, int localPort) {
        this.localport = localPort;
    }

    @Override
    protected synchronized void close() throws IOException {
        this.guard.close();
        IoBridge.closeAndSignalBlockedThreads(this.fd);
    }

    @Override
    public void onClose() {
        this.guard.close();
    }

    @Override
    protected void connect(String aHost, int aPort) throws IOException {
        this.connect(InetAddress.getByName(aHost), aPort);
    }

    @Override
    protected void connect(InetAddress anAddr, int aPort) throws IOException {
        this.connect(anAddr, aPort, 0);
    }

    private void connect(InetAddress anAddr, int aPort, int timeout) throws IOException {
        InetAddress normalAddr;
        InetAddress inetAddress = normalAddr = anAddr.isAnyLocalAddress() ? InetAddress.getLocalHost() : anAddr;
        if (this.streaming && this.usingSocks()) {
            this.socksConnect(anAddr, aPort, 0);
        } else {
            IoBridge.connect(this.fd, normalAddr, aPort, timeout);
        }
        this.address = normalAddr;
        this.port = aPort;
    }

    @Override
    public void onConnect(InetAddress remoteAddress, int remotePort) {
        this.address = remoteAddress;
        this.port = remotePort;
    }

    @Override
    protected void create(boolean streaming) throws IOException {
        this.streaming = streaming;
        this.fd = IoBridge.socket(streaming);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.guard != null) {
                this.guard.warnIfOpen();
            }
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    protected synchronized InputStream getInputStream() throws IOException {
        this.checkNotClosed();
        return new PlainSocketInputStream(this);
    }

    @Override
    public Object getOption(int option) throws SocketException {
        return IoBridge.getSocketOption(this.fd, option);
    }

    @Override
    protected synchronized OutputStream getOutputStream() throws IOException {
        this.checkNotClosed();
        return new PlainSocketOutputStream(this);
    }

    @Override
    protected void listen(int backlog) throws IOException {
        if (this.usingSocks()) {
            return;
        }
        try {
            Libcore.os.listen(this.fd, backlog);
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsSocketException();
        }
    }

    @Override
    public void setOption(int option, Object value) throws SocketException {
        IoBridge.setSocketOption(this.fd, option, value);
    }

    private int socksGetServerPort() {
        InetSocketAddress addr = (InetSocketAddress)this.proxy.address();
        return addr.getPort();
    }

    private InetAddress socksGetServerAddress() throws UnknownHostException {
        InetSocketAddress socketAddress = (InetSocketAddress)this.proxy.address();
        InetAddress address = socketAddress.getAddress();
        return address != null ? address : InetAddress.getByName(socketAddress.getHostName());
    }

    private void socksConnect(InetAddress applicationServerAddress, int applicationServerPort, int timeout) throws IOException {
        try {
            IoBridge.connect(this.fd, this.socksGetServerAddress(), this.socksGetServerPort(), timeout);
        }
        catch (Exception e) {
            throw new SocketException("SOCKS connection failed", e);
        }
        this.socksRequestConnection(applicationServerAddress, applicationServerPort);
        lastConnectedAddress = applicationServerAddress;
        lastConnectedPort = applicationServerPort;
    }

    private void socksRequestConnection(InetAddress applicationServerAddress, int applicationServerPort) throws IOException {
        this.socksSendRequest(1, applicationServerAddress, applicationServerPort);
        Socks4Message reply = this.socksReadReply();
        if (reply.getCommandOrResult() != 90) {
            throw new IOException(reply.getErrorString(reply.getCommandOrResult()));
        }
    }

    public void socksAccept() throws IOException {
        Socks4Message reply = this.socksReadReply();
        if (reply.getCommandOrResult() != 90) {
            throw new IOException(reply.getErrorString(reply.getCommandOrResult()));
        }
    }

    @Override
    protected void shutdownInput() throws IOException {
        this.shutdownInput = true;
        try {
            Libcore.os.shutdown(this.fd, OsConstants.SHUT_RD);
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsSocketException();
        }
    }

    @Override
    protected void shutdownOutput() throws IOException {
        try {
            Libcore.os.shutdown(this.fd, OsConstants.SHUT_WR);
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsSocketException();
        }
    }

    private void socksBind() throws IOException {
        try {
            IoBridge.connect(this.fd, this.socksGetServerAddress(), this.socksGetServerPort());
        }
        catch (Exception e) {
            throw new IOException("Unable to connect to SOCKS server", e);
        }
        if (lastConnectedAddress == null) {
            throw new SocketException("Invalid SOCKS client");
        }
        this.socksSendRequest(2, lastConnectedAddress, lastConnectedPort);
        Socks4Message reply = this.socksReadReply();
        if (reply.getCommandOrResult() != 90) {
            throw new IOException(reply.getErrorString(reply.getCommandOrResult()));
        }
        if (reply.getIP() == 0) {
            this.address = this.socksGetServerAddress();
        } else {
            byte[] replyBytes = new byte[4];
            Memory.pokeInt(replyBytes, 0, reply.getIP(), ByteOrder.BIG_ENDIAN);
            this.address = InetAddress.getByAddress(replyBytes);
        }
        this.localport = reply.getPort();
    }

    private void socksSendRequest(int command, InetAddress address, int port) throws IOException {
        Socks4Message request = new Socks4Message();
        request.setCommandOrResult(command);
        request.setPort(port);
        request.setIP(address.getAddress());
        request.setUserId("default");
        this.getOutputStream().write(request.getBytes(), 0, request.getLength());
    }

    private Socks4Message socksReadReply() throws IOException {
        int bytesRead;
        int count;
        Socks4Message reply = new Socks4Message();
        for (bytesRead = 0; bytesRead < 8 && (count = this.getInputStream().read(reply.getBytes(), bytesRead, 8 - bytesRead)) != -1; bytesRead += count) {
        }
        if (8 != bytesRead) {
            throw new SocketException("Malformed reply from SOCKS server");
        }
        return reply;
    }

    @Override
    protected void connect(SocketAddress remoteAddr, int timeout) throws IOException {
        InetSocketAddress inetAddr = (InetSocketAddress)remoteAddr;
        this.connect(inetAddr.getAddress(), inetAddr.getPort(), timeout);
    }

    @Override
    protected boolean supportsUrgentData() {
        return true;
    }

    @Override
    protected void sendUrgentData(int value) throws IOException {
        try {
            byte[] buffer = new byte[]{(byte)value};
            Libcore.os.sendto(this.fd, buffer, 0, 1, OsConstants.MSG_OOB, null, 0);
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsSocketException();
        }
    }

    private int read(byte[] buffer, int offset, int byteCount) throws IOException {
        if (byteCount == 0) {
            return 0;
        }
        Arrays.checkOffsetAndCount(buffer.length, offset, byteCount);
        if (this.shutdownInput) {
            return -1;
        }
        int readCount = IoBridge.recvfrom(true, this.fd, buffer, offset, byteCount, 0, null, false);
        if (readCount == 0) {
            throw new SocketTimeoutException();
        }
        if (readCount == -1) {
            this.shutdownInput = true;
        }
        return readCount;
    }

    private void write(byte[] buffer, int offset, int byteCount) throws IOException {
        Arrays.checkOffsetAndCount(buffer.length, offset, byteCount);
        if (this.streaming) {
            while (byteCount > 0) {
                int bytesWritten = IoBridge.sendto(this.fd, buffer, offset, byteCount, 0, null, 0);
                byteCount -= bytesWritten;
                offset += bytesWritten;
            }
        } else {
            IoBridge.sendto(this.fd, buffer, offset, byteCount, 0, this.address, this.port);
        }
    }

    private static class PlainSocketOutputStream
    extends OutputStream {
        private final PlainSocketImpl socketImpl;

        public PlainSocketOutputStream(PlainSocketImpl socketImpl) {
            this.socketImpl = socketImpl;
        }

        @Override
        public void close() throws IOException {
            this.socketImpl.close();
        }

        @Override
        public void write(int oneByte) throws IOException {
            Streams.writeSingleByte(this, oneByte);
        }

        @Override
        public void write(byte[] buffer, int offset, int byteCount) throws IOException {
            this.socketImpl.write(buffer, offset, byteCount);
        }
    }

    private static class PlainSocketInputStream
    extends InputStream {
        private final PlainSocketImpl socketImpl;

        public PlainSocketInputStream(PlainSocketImpl socketImpl) {
            this.socketImpl = socketImpl;
        }

        @Override
        public int available() throws IOException {
            return this.socketImpl.available();
        }

        @Override
        public void close() throws IOException {
            this.socketImpl.close();
        }

        @Override
        public int read() throws IOException {
            return Streams.readSingleByte(this);
        }

        @Override
        public int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
            return this.socketImpl.read(buffer, byteOffset, byteCount);
        }
    }
}

