/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.BindException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PlainSocketImpl;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketImplFactory;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import libcore.io.IoBridge;

public class Socket
implements Closeable {
    private static SocketImplFactory factory;
    final SocketImpl impl;
    private final Proxy proxy;
    volatile boolean isCreated = false;
    private boolean isBound = false;
    private boolean isConnected = false;
    private boolean isClosed = false;
    private boolean isInputShutdown = false;
    private boolean isOutputShutdown = false;
    private InetAddress localAddress = Inet6Address.ANY;
    private final Object connectLock = new Object();

    public Socket() {
        this.impl = factory != null ? factory.createSocketImpl() : new PlainSocketImpl();
        this.proxy = null;
    }

    public Socket(Proxy proxy) {
        if (proxy == null || proxy.type() == Proxy.Type.HTTP) {
            throw new IllegalArgumentException("Invalid proxy: " + proxy);
        }
        this.proxy = proxy;
        this.impl = factory != null ? factory.createSocketImpl() : new PlainSocketImpl(proxy);
    }

    private void tryAllAddresses(String dstName, int dstPort, InetAddress localAddress, int localPort, boolean streaming) throws IOException {
        InetAddress dstAddress;
        InetAddress[] dstAddresses = InetAddress.getAllByName(dstName);
        for (int i = 0; i < dstAddresses.length - 1; ++i) {
            dstAddress = dstAddresses[i];
            try {
                this.checkDestination(dstAddress, dstPort);
                this.startupSocket(dstAddress, dstPort, localAddress, localPort, streaming);
                return;
            }
            catch (IOException ex) {
                continue;
            }
        }
        dstAddress = dstAddresses[dstAddresses.length - 1];
        this.checkDestination(dstAddress, dstPort);
        this.startupSocket(dstAddress, dstPort, localAddress, localPort, streaming);
    }

    public Socket(String dstName, int dstPort) throws UnknownHostException, IOException {
        this(dstName, dstPort, null, 0);
    }

    public Socket(String dstName, int dstPort, InetAddress localAddress, int localPort) throws IOException {
        this();
        this.tryAllAddresses(dstName, dstPort, localAddress, localPort, true);
    }

    @Deprecated
    public Socket(String hostName, int port, boolean streaming) throws IOException {
        this();
        this.tryAllAddresses(hostName, port, null, 0, streaming);
    }

    public Socket(InetAddress dstAddress, int dstPort) throws IOException {
        this();
        this.checkDestination(dstAddress, dstPort);
        this.startupSocket(dstAddress, dstPort, null, 0, true);
    }

    public Socket(InetAddress dstAddress, int dstPort, InetAddress localAddress, int localPort) throws IOException {
        this();
        this.checkDestination(dstAddress, dstPort);
        this.startupSocket(dstAddress, dstPort, localAddress, localPort, true);
    }

    @Deprecated
    public Socket(InetAddress addr, int port, boolean streaming) throws IOException {
        this();
        this.checkDestination(addr, port);
        this.startupSocket(addr, port, null, 0, streaming);
    }

    protected Socket(SocketImpl impl) throws SocketException {
        this.impl = impl;
        this.proxy = null;
    }

    private void checkDestination(InetAddress destAddr, int dstPort) {
        if (dstPort < 0 || dstPort > 65535) {
            throw new IllegalArgumentException("Port out of range: " + dstPort);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.isClosed = true;
        this.isConnected = false;
        this.localAddress = Inet6Address.ANY;
        this.impl.close();
    }

    public void onClose() {
        this.isClosed = true;
        this.isConnected = false;
        this.localAddress = Inet6Address.ANY;
        this.impl.onClose();
    }

    public InetAddress getInetAddress() {
        if (!this.isConnected()) {
            return null;
        }
        return this.impl.getInetAddress();
    }

    public InputStream getInputStream() throws IOException {
        this.checkOpenAndCreate(false);
        if (this.isInputShutdown()) {
            throw new SocketException("Socket input is shutdown");
        }
        return this.impl.getInputStream();
    }

    public boolean getKeepAlive() throws SocketException {
        this.checkOpenAndCreate(true);
        return (Boolean)this.impl.getOption(8);
    }

    public InetAddress getLocalAddress() {
        return this.localAddress;
    }

    public int getLocalPort() {
        if (!this.isBound()) {
            return -1;
        }
        return this.impl.getLocalPort();
    }

    public OutputStream getOutputStream() throws IOException {
        this.checkOpenAndCreate(false);
        if (this.isOutputShutdown()) {
            throw new SocketException("Socket output is shutdown");
        }
        return this.impl.getOutputStream();
    }

    public int getPort() {
        if (!this.isConnected()) {
            return 0;
        }
        return this.impl.getPort();
    }

    public int getSoLinger() throws SocketException {
        this.checkOpenAndCreate(true);
        Object value = this.impl.getOption(128);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return -1;
    }

    public synchronized int getReceiveBufferSize() throws SocketException {
        this.checkOpenAndCreate(true);
        return (Integer)this.impl.getOption(4098);
    }

    public synchronized int getSendBufferSize() throws SocketException {
        this.checkOpenAndCreate(true);
        return (Integer)this.impl.getOption(4097);
    }

    public synchronized int getSoTimeout() throws SocketException {
        this.checkOpenAndCreate(true);
        return (Integer)this.impl.getOption(4102);
    }

    public boolean getTcpNoDelay() throws SocketException {
        this.checkOpenAndCreate(true);
        return (Boolean)this.impl.getOption(1);
    }

    public void setKeepAlive(boolean keepAlive) throws SocketException {
        if (this.impl != null) {
            this.checkOpenAndCreate(true);
            this.impl.setOption(8, keepAlive);
        }
    }

    public static synchronized void setSocketImplFactory(SocketImplFactory fac) throws IOException {
        if (factory != null) {
            throw new SocketException("Factory already set");
        }
        factory = fac;
    }

    public synchronized void setSendBufferSize(int size) throws SocketException {
        this.checkOpenAndCreate(true);
        if (size < 1) {
            throw new IllegalArgumentException("size < 1");
        }
        this.impl.setOption(4097, size);
    }

    public synchronized void setReceiveBufferSize(int size) throws SocketException {
        this.checkOpenAndCreate(true);
        if (size < 1) {
            throw new IllegalArgumentException("size < 1");
        }
        this.impl.setOption(4098, size);
    }

    public void setSoLinger(boolean on, int timeout) throws SocketException {
        this.checkOpenAndCreate(true);
        if (on && timeout < 0) {
            throw new IllegalArgumentException("timeout < 0");
        }
        if (on) {
            this.impl.setOption(128, timeout);
        } else {
            this.impl.setOption(128, Boolean.FALSE);
        }
    }

    public synchronized void setSoTimeout(int timeout) throws SocketException {
        this.checkOpenAndCreate(true);
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout < 0");
        }
        this.impl.setOption(4102, timeout);
    }

    public void setTcpNoDelay(boolean on) throws SocketException {
        this.checkOpenAndCreate(true);
        this.impl.setOption(1, on);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startupSocket(InetAddress dstAddress, int dstPort, InetAddress localAddress, int localPort, boolean streaming) throws IOException {
        if (localPort < 0 || localPort > 65535) {
            throw new IllegalArgumentException("Local port out of range: " + localPort);
        }
        InetAddress addr = localAddress == null ? Inet6Address.ANY : localAddress;
        Socket socket = this;
        synchronized (socket) {
            this.impl.create(streaming);
            this.isCreated = true;
            try {
                if (!streaming || !this.usingSocks()) {
                    this.impl.bind(addr, localPort);
                }
                this.isBound = true;
                this.cacheLocalAddress();
                this.impl.connect(dstAddress, dstPort);
                this.isConnected = true;
                this.cacheLocalAddress();
            }
            catch (IOException e) {
                this.impl.close();
                throw e;
            }
        }
    }

    private boolean usingSocks() {
        return this.proxy != null && this.proxy.type() == Proxy.Type.SOCKS;
    }

    public String toString() {
        if (!this.isConnected()) {
            return "Socket[unconnected]";
        }
        return this.impl.toString();
    }

    public void shutdownInput() throws IOException {
        if (this.isInputShutdown()) {
            throw new SocketException("Socket input is shutdown");
        }
        this.checkOpenAndCreate(false);
        this.impl.shutdownInput();
        this.isInputShutdown = true;
    }

    public void shutdownOutput() throws IOException {
        if (this.isOutputShutdown()) {
            throw new SocketException("Socket output is shutdown");
        }
        this.checkOpenAndCreate(false);
        this.impl.shutdownOutput();
        this.isOutputShutdown = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkOpenAndCreate(boolean create) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!create) {
            if (!this.isConnected()) {
                throw new SocketException("Socket is not connected");
            }
            return;
        }
        if (this.isCreated) {
            return;
        }
        Socket socket = this;
        synchronized (socket) {
            if (this.isCreated) {
                return;
            }
            try {
                this.impl.create(true);
            }
            catch (SocketException e) {
                throw e;
            }
            catch (IOException e) {
                throw new SocketException(e.toString());
            }
            this.isCreated = true;
        }
    }

    public SocketAddress getLocalSocketAddress() {
        if (!this.isBound()) {
            return null;
        }
        return new InetSocketAddress(this.getLocalAddress(), this.getLocalPort());
    }

    public SocketAddress getRemoteSocketAddress() {
        if (!this.isConnected()) {
            return null;
        }
        return new InetSocketAddress(this.getInetAddress(), this.getPort());
    }

    public boolean isBound() {
        return this.isBound;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(SocketAddress localAddr) throws IOException {
        InetAddress addr;
        int port;
        this.checkOpenAndCreate(true);
        if (this.isBound()) {
            throw new BindException("Socket is already bound");
        }
        if (localAddr == null) {
            port = 0;
            addr = Inet6Address.ANY;
        } else {
            if (!(localAddr instanceof InetSocketAddress)) {
                throw new IllegalArgumentException("Local address not an InetSocketAddress: " + localAddr.getClass());
            }
            InetSocketAddress inetAddr = (InetSocketAddress)localAddr;
            addr = inetAddr.getAddress();
            if (addr == null) {
                throw new UnknownHostException("Host is unresolved: " + inetAddr.getHostName());
            }
            port = inetAddr.getPort();
        }
        Socket socket = this;
        synchronized (socket) {
            try {
                this.impl.bind(addr, port);
                this.isBound = true;
                this.cacheLocalAddress();
            }
            catch (IOException e) {
                this.impl.close();
                throw e;
            }
        }
    }

    public void onBind(InetAddress localAddress, int localPort) {
        this.isBound = true;
        this.localAddress = localAddress;
        this.impl.onBind(localAddress, localPort);
    }

    public void connect(SocketAddress remoteAddr) throws IOException {
        this.connect(remoteAddr, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(SocketAddress remoteAddr, int timeout) throws IOException {
        this.checkOpenAndCreate(true);
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout < 0");
        }
        if (this.isConnected()) {
            throw new SocketException("Already connected");
        }
        if (remoteAddr == null) {
            throw new IllegalArgumentException("remoteAddr == null");
        }
        if (!(remoteAddr instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("Remote address not an InetSocketAddress: " + remoteAddr.getClass());
        }
        InetSocketAddress inetAddr = (InetSocketAddress)remoteAddr;
        InetAddress addr = inetAddr.getAddress();
        if (addr == null) {
            throw new UnknownHostException("Host is unresolved: " + inetAddr.getHostName());
        }
        int port = inetAddr.getPort();
        this.checkDestination(addr, port);
        Object object = this.connectLock;
        synchronized (object) {
            try {
                if (!this.isBound()) {
                    if (!this.usingSocks()) {
                        this.impl.bind(Inet6Address.ANY, 0);
                    }
                    this.isBound = true;
                }
                this.impl.connect(remoteAddr, timeout);
                this.isConnected = true;
                this.cacheLocalAddress();
            }
            catch (IOException e) {
                this.impl.close();
                throw e;
            }
        }
    }

    public void onConnect(InetAddress remoteAddress, int remotePort) {
        this.isConnected = true;
        this.impl.onConnect(remoteAddress, remotePort);
    }

    public boolean isInputShutdown() {
        return this.isInputShutdown;
    }

    public boolean isOutputShutdown() {
        return this.isOutputShutdown;
    }

    public void setReuseAddress(boolean reuse) throws SocketException {
        this.checkOpenAndCreate(true);
        this.impl.setOption(4, reuse);
    }

    public boolean getReuseAddress() throws SocketException {
        this.checkOpenAndCreate(true);
        return (Boolean)this.impl.getOption(4);
    }

    public void setOOBInline(boolean oobinline) throws SocketException {
        this.checkOpenAndCreate(true);
        this.impl.setOption(4099, oobinline);
    }

    public boolean getOOBInline() throws SocketException {
        this.checkOpenAndCreate(true);
        return (Boolean)this.impl.getOption(4099);
    }

    public void setTrafficClass(int value) throws SocketException {
        this.checkOpenAndCreate(true);
        if (value < 0 || value > 255) {
            throw new IllegalArgumentException("Value doesn't fit in an unsigned byte: " + value);
        }
        this.impl.setOption(3, value);
    }

    public int getTrafficClass() throws SocketException {
        this.checkOpenAndCreate(true);
        return (Integer)this.impl.getOption(3);
    }

    public void sendUrgentData(int value) throws IOException {
        this.impl.sendUrgentData(value);
    }

    void accepted() throws SocketException {
        this.isConnected = true;
        this.isBound = true;
        this.isCreated = true;
        this.cacheLocalAddress();
    }

    private void cacheLocalAddress() throws SocketException {
        this.localAddress = IoBridge.getSocketLocalAddress(this.impl.fd);
    }

    public SocketChannel getChannel() {
        return null;
    }

    public FileDescriptor getFileDescriptor$() {
        return this.impl.fd;
    }

    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
    }
}

